# -*- coding: utf8 -*-
# Copyright (c) 2017-2025 Tencent. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class AIAnalysisTemplateItem(AbstractModel):
    r"""AI 智能分析模板详情

    """

    def __init__(self):
        r"""
        :param _Definition: 智能分析模板唯一标识。
        :type Definition: int
        :param _Name: 智能分析模板名称。
        :type Name: str
        :param _Comment: 智能分析模板描述信息。
        :type Comment: str
        :param _ClassificationConfigure: 智能分类任务控制参数。
        :type ClassificationConfigure: :class:`tencentcloud.vod.v20180717.models.ClassificationConfigureInfo`
        :param _TagConfigure: 智能标签任务控制参数。
        :type TagConfigure: :class:`tencentcloud.vod.v20180717.models.TagConfigureInfo`
        :param _CoverConfigure: 智能封面任务控制参数。
        :type CoverConfigure: :class:`tencentcloud.vod.v20180717.models.CoverConfigureInfo`
        :param _FrameTagConfigure: 智能按帧标签任务控制参数。
        :type FrameTagConfigure: :class:`tencentcloud.vod.v20180717.models.FrameTagConfigureInfo`
        :param _HighlightConfigure: 智能精彩集锦任务控制参数。
        :type HighlightConfigure: :class:`tencentcloud.vod.v20180717.models.HighlightsConfigureInfo`
        :param _CreateTime: 模板创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type CreateTime: str
        :param _UpdateTime: 模板最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type UpdateTime: str
        """
        self._Definition = None
        self._Name = None
        self._Comment = None
        self._ClassificationConfigure = None
        self._TagConfigure = None
        self._CoverConfigure = None
        self._FrameTagConfigure = None
        self._HighlightConfigure = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def Definition(self):
        r"""智能分析模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Name(self):
        r"""智能分析模板名称。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        r"""智能分析模板描述信息。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def ClassificationConfigure(self):
        r"""智能分类任务控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ClassificationConfigureInfo`
        """
        return self._ClassificationConfigure

    @ClassificationConfigure.setter
    def ClassificationConfigure(self, ClassificationConfigure):
        self._ClassificationConfigure = ClassificationConfigure

    @property
    def TagConfigure(self):
        r"""智能标签任务控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.TagConfigureInfo`
        """
        return self._TagConfigure

    @TagConfigure.setter
    def TagConfigure(self, TagConfigure):
        self._TagConfigure = TagConfigure

    @property
    def CoverConfigure(self):
        r"""智能封面任务控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.CoverConfigureInfo`
        """
        return self._CoverConfigure

    @CoverConfigure.setter
    def CoverConfigure(self, CoverConfigure):
        self._CoverConfigure = CoverConfigure

    @property
    def FrameTagConfigure(self):
        r"""智能按帧标签任务控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.FrameTagConfigureInfo`
        """
        return self._FrameTagConfigure

    @FrameTagConfigure.setter
    def FrameTagConfigure(self, FrameTagConfigure):
        self._FrameTagConfigure = FrameTagConfigure

    @property
    def HighlightConfigure(self):
        r"""智能精彩集锦任务控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.HighlightsConfigureInfo`
        """
        return self._HighlightConfigure

    @HighlightConfigure.setter
    def HighlightConfigure(self, HighlightConfigure):
        self._HighlightConfigure = HighlightConfigure

    @property
    def CreateTime(self):
        r"""模板创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""模板最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("ClassificationConfigure") is not None:
            self._ClassificationConfigure = ClassificationConfigureInfo()
            self._ClassificationConfigure._deserialize(params.get("ClassificationConfigure"))
        if params.get("TagConfigure") is not None:
            self._TagConfigure = TagConfigureInfo()
            self._TagConfigure._deserialize(params.get("TagConfigure"))
        if params.get("CoverConfigure") is not None:
            self._CoverConfigure = CoverConfigureInfo()
            self._CoverConfigure._deserialize(params.get("CoverConfigure"))
        if params.get("FrameTagConfigure") is not None:
            self._FrameTagConfigure = FrameTagConfigureInfo()
            self._FrameTagConfigure._deserialize(params.get("FrameTagConfigure"))
        if params.get("HighlightConfigure") is not None:
            self._HighlightConfigure = HighlightsConfigureInfo()
            self._HighlightConfigure._deserialize(params.get("HighlightConfigure"))
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AIRecognitionTemplateItem(AbstractModel):
    r"""视频内容识别模板详情

    """

    def __init__(self):
        r"""
        :param _Definition: 视频内容识别模板唯一标识。
        :type Definition: int
        :param _Name: 视频内容识别模板名称。
        :type Name: str
        :param _Comment: 视频内容识别模板描述信息。
        :type Comment: str
        :param _Type: 模板类型，取值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :type Type: str
        :param _HeadTailConfigure: 头尾识别控制参数。
        :type HeadTailConfigure: :class:`tencentcloud.vod.v20180717.models.HeadTailConfigureInfo`
        :param _SegmentConfigure: 拆条识别控制参数。
        :type SegmentConfigure: :class:`tencentcloud.vod.v20180717.models.SegmentConfigureInfo`
        :param _FaceConfigure: 人脸识别控制参数。
        :type FaceConfigure: :class:`tencentcloud.vod.v20180717.models.FaceConfigureInfo`
        :param _OcrFullTextConfigure: 文本全文识别控制参数。
        :type OcrFullTextConfigure: :class:`tencentcloud.vod.v20180717.models.OcrFullTextConfigureInfo`
        :param _OcrWordsConfigure: 文本关键词识别控制参数。
        :type OcrWordsConfigure: :class:`tencentcloud.vod.v20180717.models.OcrWordsConfigureInfo`
        :param _AsrFullTextConfigure: 语音全文识别控制参数。
<font color=red>注意：本参数已不再维护，推荐使用 AsrTranslateConfigure 参数发起语音翻译识别（当 DstLanguage 不填或填空字符串时，则不进行翻译，计费项和语音全文识别一致）。</font> 
        :type AsrFullTextConfigure: :class:`tencentcloud.vod.v20180717.models.AsrFullTextConfigureInfo`
        :param _AsrWordsConfigure: 语音关键词识别控制参数。
        :type AsrWordsConfigure: :class:`tencentcloud.vod.v20180717.models.AsrWordsConfigureInfo`
        :param _AsrTranslateConfigure: 语音翻译识别控制参数。
        :type AsrTranslateConfigure: :class:`tencentcloud.vod.v20180717.models.AsrTranslateConfigureInfo`
        :param _ObjectConfigure: 物体识别控制参数。
        :type ObjectConfigure: :class:`tencentcloud.vod.v20180717.models.ObjectConfigureInfo`
        :param _ScreenshotInterval: 截图时间间隔，单位：秒。
        :type ScreenshotInterval: float
        :param _CreateTime: 模板创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type CreateTime: str
        :param _UpdateTime: 模板最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type UpdateTime: str
        """
        self._Definition = None
        self._Name = None
        self._Comment = None
        self._Type = None
        self._HeadTailConfigure = None
        self._SegmentConfigure = None
        self._FaceConfigure = None
        self._OcrFullTextConfigure = None
        self._OcrWordsConfigure = None
        self._AsrFullTextConfigure = None
        self._AsrWordsConfigure = None
        self._AsrTranslateConfigure = None
        self._ObjectConfigure = None
        self._ScreenshotInterval = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def Definition(self):
        r"""视频内容识别模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Name(self):
        r"""视频内容识别模板名称。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        r"""视频内容识别模板描述信息。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def Type(self):
        r"""模板类型，取值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def HeadTailConfigure(self):
        r"""头尾识别控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.HeadTailConfigureInfo`
        """
        return self._HeadTailConfigure

    @HeadTailConfigure.setter
    def HeadTailConfigure(self, HeadTailConfigure):
        self._HeadTailConfigure = HeadTailConfigure

    @property
    def SegmentConfigure(self):
        r"""拆条识别控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.SegmentConfigureInfo`
        """
        return self._SegmentConfigure

    @SegmentConfigure.setter
    def SegmentConfigure(self, SegmentConfigure):
        self._SegmentConfigure = SegmentConfigure

    @property
    def FaceConfigure(self):
        r"""人脸识别控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.FaceConfigureInfo`
        """
        return self._FaceConfigure

    @FaceConfigure.setter
    def FaceConfigure(self, FaceConfigure):
        self._FaceConfigure = FaceConfigure

    @property
    def OcrFullTextConfigure(self):
        r"""文本全文识别控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.OcrFullTextConfigureInfo`
        """
        return self._OcrFullTextConfigure

    @OcrFullTextConfigure.setter
    def OcrFullTextConfigure(self, OcrFullTextConfigure):
        self._OcrFullTextConfigure = OcrFullTextConfigure

    @property
    def OcrWordsConfigure(self):
        r"""文本关键词识别控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.OcrWordsConfigureInfo`
        """
        return self._OcrWordsConfigure

    @OcrWordsConfigure.setter
    def OcrWordsConfigure(self, OcrWordsConfigure):
        self._OcrWordsConfigure = OcrWordsConfigure

    @property
    def AsrFullTextConfigure(self):
        r"""语音全文识别控制参数。
<font color=red>注意：本参数已不再维护，推荐使用 AsrTranslateConfigure 参数发起语音翻译识别（当 DstLanguage 不填或填空字符串时，则不进行翻译，计费项和语音全文识别一致）。</font> 
        :rtype: :class:`tencentcloud.vod.v20180717.models.AsrFullTextConfigureInfo`
        """
        return self._AsrFullTextConfigure

    @AsrFullTextConfigure.setter
    def AsrFullTextConfigure(self, AsrFullTextConfigure):
        self._AsrFullTextConfigure = AsrFullTextConfigure

    @property
    def AsrWordsConfigure(self):
        r"""语音关键词识别控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AsrWordsConfigureInfo`
        """
        return self._AsrWordsConfigure

    @AsrWordsConfigure.setter
    def AsrWordsConfigure(self, AsrWordsConfigure):
        self._AsrWordsConfigure = AsrWordsConfigure

    @property
    def AsrTranslateConfigure(self):
        r"""语音翻译识别控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AsrTranslateConfigureInfo`
        """
        return self._AsrTranslateConfigure

    @AsrTranslateConfigure.setter
    def AsrTranslateConfigure(self, AsrTranslateConfigure):
        self._AsrTranslateConfigure = AsrTranslateConfigure

    @property
    def ObjectConfigure(self):
        r"""物体识别控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ObjectConfigureInfo`
        """
        return self._ObjectConfigure

    @ObjectConfigure.setter
    def ObjectConfigure(self, ObjectConfigure):
        self._ObjectConfigure = ObjectConfigure

    @property
    def ScreenshotInterval(self):
        r"""截图时间间隔，单位：秒。
        :rtype: float
        """
        return self._ScreenshotInterval

    @ScreenshotInterval.setter
    def ScreenshotInterval(self, ScreenshotInterval):
        self._ScreenshotInterval = ScreenshotInterval

    @property
    def CreateTime(self):
        r"""模板创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""模板最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        self._Type = params.get("Type")
        if params.get("HeadTailConfigure") is not None:
            self._HeadTailConfigure = HeadTailConfigureInfo()
            self._HeadTailConfigure._deserialize(params.get("HeadTailConfigure"))
        if params.get("SegmentConfigure") is not None:
            self._SegmentConfigure = SegmentConfigureInfo()
            self._SegmentConfigure._deserialize(params.get("SegmentConfigure"))
        if params.get("FaceConfigure") is not None:
            self._FaceConfigure = FaceConfigureInfo()
            self._FaceConfigure._deserialize(params.get("FaceConfigure"))
        if params.get("OcrFullTextConfigure") is not None:
            self._OcrFullTextConfigure = OcrFullTextConfigureInfo()
            self._OcrFullTextConfigure._deserialize(params.get("OcrFullTextConfigure"))
        if params.get("OcrWordsConfigure") is not None:
            self._OcrWordsConfigure = OcrWordsConfigureInfo()
            self._OcrWordsConfigure._deserialize(params.get("OcrWordsConfigure"))
        if params.get("AsrFullTextConfigure") is not None:
            self._AsrFullTextConfigure = AsrFullTextConfigureInfo()
            self._AsrFullTextConfigure._deserialize(params.get("AsrFullTextConfigure"))
        if params.get("AsrWordsConfigure") is not None:
            self._AsrWordsConfigure = AsrWordsConfigureInfo()
            self._AsrWordsConfigure._deserialize(params.get("AsrWordsConfigure"))
        if params.get("AsrTranslateConfigure") is not None:
            self._AsrTranslateConfigure = AsrTranslateConfigureInfo()
            self._AsrTranslateConfigure._deserialize(params.get("AsrTranslateConfigure"))
        if params.get("ObjectConfigure") is not None:
            self._ObjectConfigure = ObjectConfigureInfo()
            self._ObjectConfigure._deserialize(params.get("ObjectConfigure"))
        self._ScreenshotInterval = params.get("ScreenshotInterval")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AbnormalLightingConfigureInfo(AbstractModel):
    r"""视频画面低光、过曝检测的控制参数。

    """

    def __init__(self):
        r"""
        :param _Switch: 视频画面低光、过曝检测开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        r"""视频画面低光、过曝检测开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AbnormalLightingConfigureInfoForUpdate(AbstractModel):
    r"""视频画面低光、过曝检测的控制参数。

    """

    def __init__(self):
        r"""
        :param _Switch: 视频画面低光、过曝检测开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        r"""视频画面低光、过曝检测开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AccelerateAreaInfo(AbstractModel):
    r"""域名的地区加速信息

    """

    def __init__(self):
        r"""
        :param _Area: 加速地区，可选值：
<li>Chinese Mainland：中国境内（不包含港澳台）。</li>
<li>Outside Chinese Mainland：中国境外。</li>
        :type Area: str
        :param _TencentDisableReason: 腾讯禁用原因，可选值：
<li>ForLegalReasons：因法律原因导致关闭加速；</li>
<li>ForOverdueBills：因欠费停服导致关闭加速。</li>
        :type TencentDisableReason: str
        :param _TencentEdgeDomain: 加速域名对应的 CNAME 域名。
        :type TencentEdgeDomain: str
        """
        self._Area = None
        self._TencentDisableReason = None
        self._TencentEdgeDomain = None

    @property
    def Area(self):
        r"""加速地区，可选值：
<li>Chinese Mainland：中国境内（不包含港澳台）。</li>
<li>Outside Chinese Mainland：中国境外。</li>
        :rtype: str
        """
        return self._Area

    @Area.setter
    def Area(self, Area):
        self._Area = Area

    @property
    def TencentDisableReason(self):
        r"""腾讯禁用原因，可选值：
<li>ForLegalReasons：因法律原因导致关闭加速；</li>
<li>ForOverdueBills：因欠费停服导致关闭加速。</li>
        :rtype: str
        """
        return self._TencentDisableReason

    @TencentDisableReason.setter
    def TencentDisableReason(self, TencentDisableReason):
        self._TencentDisableReason = TencentDisableReason

    @property
    def TencentEdgeDomain(self):
        r"""加速域名对应的 CNAME 域名。
        :rtype: str
        """
        return self._TencentEdgeDomain

    @TencentEdgeDomain.setter
    def TencentEdgeDomain(self, TencentEdgeDomain):
        self._TencentEdgeDomain = TencentEdgeDomain


    def _deserialize(self, params):
        self._Area = params.get("Area")
        self._TencentDisableReason = params.get("TencentDisableReason")
        self._TencentEdgeDomain = params.get("TencentEdgeDomain")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AdaptiveDynamicStreamingInfoItem(AbstractModel):
    r"""转自适应码流信息

    """

    def __init__(self):
        r"""
        :param _Definition: 转自适应码流规格。
        :type Definition: int
        :param _Package: 打包格式，取值范围：
<li>HLS；</li>
<li>DASH。</li>
        :type Package: str
        :param _DrmType: 加密类型。
        :type DrmType: str
        :param _Url: 播放地址。
        :type Url: str
        :param _Size: 媒体文件大小，单位：字节。
<li>当媒体文件为 HLS 时，大小是 m3u8 和 ts 文件大小的总和；</li>
<li>当媒体文件为 DASH 时，大小是 mpd 和分片文件大小的总和；</li>
<li><font color=red>注意</font>：在 2022-01-10T16:00:00Z 前处理生成的自适应码流文件此字段为0。</li>
        :type Size: int
        :param _DigitalWatermarkType: 数字水印类型。可选值：
<li>Trace 表示经过溯源水印处理；</li>
<li>CopyRight 表示经过版权水印处理；</li>
<li>None 表示没有经过数字水印处理。</li>
        :type DigitalWatermarkType: str
        :param _SubStreamSet: 子流信息列表。
        :type SubStreamSet: list of MediaSubStreamInfoItem
        :param _CopyRightWatermarkText: 版权信息。
        :type CopyRightWatermarkText: str
        :param _SubtitleSet: 字幕信息列表。
        :type SubtitleSet: list of MediaSubtitleItem
        :param _DefaultSubtitleId: 默认字幕的唯一标识。
        :type DefaultSubtitleId: str
        """
        self._Definition = None
        self._Package = None
        self._DrmType = None
        self._Url = None
        self._Size = None
        self._DigitalWatermarkType = None
        self._SubStreamSet = None
        self._CopyRightWatermarkText = None
        self._SubtitleSet = None
        self._DefaultSubtitleId = None

    @property
    def Definition(self):
        r"""转自适应码流规格。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Package(self):
        r"""打包格式，取值范围：
<li>HLS；</li>
<li>DASH。</li>
        :rtype: str
        """
        return self._Package

    @Package.setter
    def Package(self, Package):
        self._Package = Package

    @property
    def DrmType(self):
        r"""加密类型。
        :rtype: str
        """
        return self._DrmType

    @DrmType.setter
    def DrmType(self, DrmType):
        self._DrmType = DrmType

    @property
    def Url(self):
        r"""播放地址。
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def Size(self):
        r"""媒体文件大小，单位：字节。
<li>当媒体文件为 HLS 时，大小是 m3u8 和 ts 文件大小的总和；</li>
<li>当媒体文件为 DASH 时，大小是 mpd 和分片文件大小的总和；</li>
<li><font color=red>注意</font>：在 2022-01-10T16:00:00Z 前处理生成的自适应码流文件此字段为0。</li>
        :rtype: int
        """
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size

    @property
    def DigitalWatermarkType(self):
        r"""数字水印类型。可选值：
<li>Trace 表示经过溯源水印处理；</li>
<li>CopyRight 表示经过版权水印处理；</li>
<li>None 表示没有经过数字水印处理。</li>
        :rtype: str
        """
        return self._DigitalWatermarkType

    @DigitalWatermarkType.setter
    def DigitalWatermarkType(self, DigitalWatermarkType):
        self._DigitalWatermarkType = DigitalWatermarkType

    @property
    def SubStreamSet(self):
        r"""子流信息列表。
        :rtype: list of MediaSubStreamInfoItem
        """
        return self._SubStreamSet

    @SubStreamSet.setter
    def SubStreamSet(self, SubStreamSet):
        self._SubStreamSet = SubStreamSet

    @property
    def CopyRightWatermarkText(self):
        r"""版权信息。
        :rtype: str
        """
        return self._CopyRightWatermarkText

    @CopyRightWatermarkText.setter
    def CopyRightWatermarkText(self, CopyRightWatermarkText):
        self._CopyRightWatermarkText = CopyRightWatermarkText

    @property
    def SubtitleSet(self):
        r"""字幕信息列表。
        :rtype: list of MediaSubtitleItem
        """
        return self._SubtitleSet

    @SubtitleSet.setter
    def SubtitleSet(self, SubtitleSet):
        self._SubtitleSet = SubtitleSet

    @property
    def DefaultSubtitleId(self):
        r"""默认字幕的唯一标识。
        :rtype: str
        """
        return self._DefaultSubtitleId

    @DefaultSubtitleId.setter
    def DefaultSubtitleId(self, DefaultSubtitleId):
        self._DefaultSubtitleId = DefaultSubtitleId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Package = params.get("Package")
        self._DrmType = params.get("DrmType")
        self._Url = params.get("Url")
        self._Size = params.get("Size")
        self._DigitalWatermarkType = params.get("DigitalWatermarkType")
        if params.get("SubStreamSet") is not None:
            self._SubStreamSet = []
            for item in params.get("SubStreamSet"):
                obj = MediaSubStreamInfoItem()
                obj._deserialize(item)
                self._SubStreamSet.append(obj)
        self._CopyRightWatermarkText = params.get("CopyRightWatermarkText")
        if params.get("SubtitleSet") is not None:
            self._SubtitleSet = []
            for item in params.get("SubtitleSet"):
                obj = MediaSubtitleItem()
                obj._deserialize(item)
                self._SubtitleSet.append(obj)
        self._DefaultSubtitleId = params.get("DefaultSubtitleId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AdaptiveDynamicStreamingTaskInput(AbstractModel):
    r"""对视频转自适应码流的输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 转自适应码流模板 ID。
        :type Definition: int
        :param _WatermarkSet: 水印列表，支持多张图片或文字水印，最大可支持 10 张。
        :type WatermarkSet: list of WatermarkInput
        :param _TraceWatermark: 溯源水印。
        :type TraceWatermark: :class:`tencentcloud.vod.v20180717.models.TraceWatermarkInput`
        :param _CopyRightWatermark: 版权水印。
        :type CopyRightWatermark: :class:`tencentcloud.vod.v20180717.models.CopyRightWatermarkInput`
        :param _SubtitleSet: 字幕列表，元素为字幕 ID，支持多个字幕，最大可支持16个。
        :type SubtitleSet: list of str
        """
        self._Definition = None
        self._WatermarkSet = None
        self._TraceWatermark = None
        self._CopyRightWatermark = None
        self._SubtitleSet = None

    @property
    def Definition(self):
        r"""转自适应码流模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def WatermarkSet(self):
        r"""水印列表，支持多张图片或文字水印，最大可支持 10 张。
        :rtype: list of WatermarkInput
        """
        return self._WatermarkSet

    @WatermarkSet.setter
    def WatermarkSet(self, WatermarkSet):
        self._WatermarkSet = WatermarkSet

    @property
    def TraceWatermark(self):
        r"""溯源水印。
        :rtype: :class:`tencentcloud.vod.v20180717.models.TraceWatermarkInput`
        """
        return self._TraceWatermark

    @TraceWatermark.setter
    def TraceWatermark(self, TraceWatermark):
        self._TraceWatermark = TraceWatermark

    @property
    def CopyRightWatermark(self):
        r"""版权水印。
        :rtype: :class:`tencentcloud.vod.v20180717.models.CopyRightWatermarkInput`
        """
        return self._CopyRightWatermark

    @CopyRightWatermark.setter
    def CopyRightWatermark(self, CopyRightWatermark):
        self._CopyRightWatermark = CopyRightWatermark

    @property
    def SubtitleSet(self):
        r"""字幕列表，元素为字幕 ID，支持多个字幕，最大可支持16个。
        :rtype: list of str
        """
        return self._SubtitleSet

    @SubtitleSet.setter
    def SubtitleSet(self, SubtitleSet):
        self._SubtitleSet = SubtitleSet


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        if params.get("WatermarkSet") is not None:
            self._WatermarkSet = []
            for item in params.get("WatermarkSet"):
                obj = WatermarkInput()
                obj._deserialize(item)
                self._WatermarkSet.append(obj)
        if params.get("TraceWatermark") is not None:
            self._TraceWatermark = TraceWatermarkInput()
            self._TraceWatermark._deserialize(params.get("TraceWatermark"))
        if params.get("CopyRightWatermark") is not None:
            self._CopyRightWatermark = CopyRightWatermarkInput()
            self._CopyRightWatermark._deserialize(params.get("CopyRightWatermark"))
        self._SubtitleSet = params.get("SubtitleSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AdaptiveDynamicStreamingTemplate(AbstractModel):
    r"""转自适应码流模板详情

    """

    def __init__(self):
        r"""
        :param _Definition: 转自适应码流模板唯一标识。
        :type Definition: int
        :param _Type: 模板类型，取值范围：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :type Type: str
        :param _Name: 转自适应码流模板名称。
        :type Name: str
        :param _Comment: 转自适应码流模板描述信息。
        :type Comment: str
        :param _Format: 自适应转码格式，取值范围：
<li>HLS。</li>
        :type Format: str
        :param _DrmType: DRM 类型，取值范围：
<li>SimpleAES</li>
<li>Widevine</li>
<li>FairPlay</li>
如果取值为空字符串，代表不对视频做 DRM 保护。
        :type DrmType: str
        :param _DrmKeyProvider: DRM 的密钥提供商，取值范围：
<li>SDMC：华曦达；</li>
<li>VOD：云点播。</li>
默认值为 VOD 。
        :type DrmKeyProvider: str
        :param _StreamInfos: 自适应转码输入流参数信息，最多输入10路流。
        :type StreamInfos: list of AdaptiveStreamTemplate
        :param _DisableHigherVideoBitrate: 是否禁止视频低码率转高码率，取值范围：
<li>0：否，</li>
<li>1：是。</li>
        :type DisableHigherVideoBitrate: int
        :param _DisableHigherVideoResolution: 是否禁止视频分辨率转高分辨率，取值范围：
<li>0：否，</li>
<li>1：是。</li>
        :type DisableHigherVideoResolution: int
        :param _CreateTime: 模板创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type CreateTime: str
        :param _UpdateTime: 模板最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type UpdateTime: str
        :param _SegmentType: 切片类型，仅当 Format 为 HLS 时有效。
        :type SegmentType: str
        """
        self._Definition = None
        self._Type = None
        self._Name = None
        self._Comment = None
        self._Format = None
        self._DrmType = None
        self._DrmKeyProvider = None
        self._StreamInfos = None
        self._DisableHigherVideoBitrate = None
        self._DisableHigherVideoResolution = None
        self._CreateTime = None
        self._UpdateTime = None
        self._SegmentType = None

    @property
    def Definition(self):
        r"""转自适应码流模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Type(self):
        r"""模板类型，取值范围：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        r"""转自适应码流模板名称。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        r"""转自适应码流模板描述信息。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def Format(self):
        r"""自适应转码格式，取值范围：
<li>HLS。</li>
        :rtype: str
        """
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def DrmType(self):
        r"""DRM 类型，取值范围：
<li>SimpleAES</li>
<li>Widevine</li>
<li>FairPlay</li>
如果取值为空字符串，代表不对视频做 DRM 保护。
        :rtype: str
        """
        return self._DrmType

    @DrmType.setter
    def DrmType(self, DrmType):
        self._DrmType = DrmType

    @property
    def DrmKeyProvider(self):
        r"""DRM 的密钥提供商，取值范围：
<li>SDMC：华曦达；</li>
<li>VOD：云点播。</li>
默认值为 VOD 。
        :rtype: str
        """
        return self._DrmKeyProvider

    @DrmKeyProvider.setter
    def DrmKeyProvider(self, DrmKeyProvider):
        self._DrmKeyProvider = DrmKeyProvider

    @property
    def StreamInfos(self):
        r"""自适应转码输入流参数信息，最多输入10路流。
        :rtype: list of AdaptiveStreamTemplate
        """
        return self._StreamInfos

    @StreamInfos.setter
    def StreamInfos(self, StreamInfos):
        self._StreamInfos = StreamInfos

    @property
    def DisableHigherVideoBitrate(self):
        r"""是否禁止视频低码率转高码率，取值范围：
<li>0：否，</li>
<li>1：是。</li>
        :rtype: int
        """
        return self._DisableHigherVideoBitrate

    @DisableHigherVideoBitrate.setter
    def DisableHigherVideoBitrate(self, DisableHigherVideoBitrate):
        self._DisableHigherVideoBitrate = DisableHigherVideoBitrate

    @property
    def DisableHigherVideoResolution(self):
        r"""是否禁止视频分辨率转高分辨率，取值范围：
<li>0：否，</li>
<li>1：是。</li>
        :rtype: int
        """
        return self._DisableHigherVideoResolution

    @DisableHigherVideoResolution.setter
    def DisableHigherVideoResolution(self, DisableHigherVideoResolution):
        self._DisableHigherVideoResolution = DisableHigherVideoResolution

    @property
    def CreateTime(self):
        r"""模板创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""模板最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def SegmentType(self):
        r"""切片类型，仅当 Format 为 HLS 时有效。
        :rtype: str
        """
        return self._SegmentType

    @SegmentType.setter
    def SegmentType(self, SegmentType):
        self._SegmentType = SegmentType


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        self._Format = params.get("Format")
        self._DrmType = params.get("DrmType")
        self._DrmKeyProvider = params.get("DrmKeyProvider")
        if params.get("StreamInfos") is not None:
            self._StreamInfos = []
            for item in params.get("StreamInfos"):
                obj = AdaptiveStreamTemplate()
                obj._deserialize(item)
                self._StreamInfos.append(obj)
        self._DisableHigherVideoBitrate = params.get("DisableHigherVideoBitrate")
        self._DisableHigherVideoResolution = params.get("DisableHigherVideoResolution")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._SegmentType = params.get("SegmentType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AdaptiveStreamTemplate(AbstractModel):
    r"""自适应转码流参数模板

    """

    def __init__(self):
        r"""
        :param _Video: 视频参数信息。
        :type Video: :class:`tencentcloud.vod.v20180717.models.VideoTemplateInfo`
        :param _Audio: 音频参数信息。
        :type Audio: :class:`tencentcloud.vod.v20180717.models.AudioTemplateInfo`
        :param _RemoveAudio: 是否移除音频流，取值范围：
<li>0：否，</li>
<li>1：是。</li>
        :type RemoveAudio: int
        :param _RemoveVideo: 是否移除视频流，取值范围：
<li>0：否，</li>
<li>1：是。</li>
        :type RemoveVideo: int
        :param _TEHDConfig: 极速高清转码参数。
注意：此字段可能返回 null，表示取不到有效值。
        :type TEHDConfig: :class:`tencentcloud.vod.v20180717.models.TEHDConfig`
        :param _EnhanceConfig: 音视频增强配置。
注意：此字段可能返回 null，表示取不到有效值。
        :type EnhanceConfig: :class:`tencentcloud.vod.v20180717.models.EnhanceConfig`
        """
        self._Video = None
        self._Audio = None
        self._RemoveAudio = None
        self._RemoveVideo = None
        self._TEHDConfig = None
        self._EnhanceConfig = None

    @property
    def Video(self):
        r"""视频参数信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.VideoTemplateInfo`
        """
        return self._Video

    @Video.setter
    def Video(self, Video):
        self._Video = Video

    @property
    def Audio(self):
        r"""音频参数信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AudioTemplateInfo`
        """
        return self._Audio

    @Audio.setter
    def Audio(self, Audio):
        self._Audio = Audio

    @property
    def RemoveAudio(self):
        r"""是否移除音频流，取值范围：
<li>0：否，</li>
<li>1：是。</li>
        :rtype: int
        """
        return self._RemoveAudio

    @RemoveAudio.setter
    def RemoveAudio(self, RemoveAudio):
        self._RemoveAudio = RemoveAudio

    @property
    def RemoveVideo(self):
        r"""是否移除视频流，取值范围：
<li>0：否，</li>
<li>1：是。</li>
        :rtype: int
        """
        return self._RemoveVideo

    @RemoveVideo.setter
    def RemoveVideo(self, RemoveVideo):
        self._RemoveVideo = RemoveVideo

    @property
    def TEHDConfig(self):
        r"""极速高清转码参数。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.TEHDConfig`
        """
        return self._TEHDConfig

    @TEHDConfig.setter
    def TEHDConfig(self, TEHDConfig):
        self._TEHDConfig = TEHDConfig

    @property
    def EnhanceConfig(self):
        r"""音视频增强配置。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.EnhanceConfig`
        """
        return self._EnhanceConfig

    @EnhanceConfig.setter
    def EnhanceConfig(self, EnhanceConfig):
        self._EnhanceConfig = EnhanceConfig


    def _deserialize(self, params):
        if params.get("Video") is not None:
            self._Video = VideoTemplateInfo()
            self._Video._deserialize(params.get("Video"))
        if params.get("Audio") is not None:
            self._Audio = AudioTemplateInfo()
            self._Audio._deserialize(params.get("Audio"))
        self._RemoveAudio = params.get("RemoveAudio")
        self._RemoveVideo = params.get("RemoveVideo")
        if params.get("TEHDConfig") is not None:
            self._TEHDConfig = TEHDConfig()
            self._TEHDConfig._deserialize(params.get("TEHDConfig"))
        if params.get("EnhanceConfig") is not None:
            self._EnhanceConfig = EnhanceConfig()
            self._EnhanceConfig._deserialize(params.get("EnhanceConfig"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisResult(AbstractModel):
    r"""智能分析结果

    """

    def __init__(self):
        r"""
        :param _Type: 任务的类型，可以取的值有：
<li>Classification：智能分类</li>
<li>Cover：智能封面</li>
<li>Tag：智能标签</li>
<li>FrameTag：智能按帧标签</li>
<li>Highlight：智能精彩集锦</li>
        :type Type: str
        :param _ClassificationTask: 视频内容分析智能分类任务的查询结果，当任务类型为 Classification 时有效。
        :type ClassificationTask: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskClassificationResult`
        :param _CoverTask: 视频内容分析智能封面任务的查询结果，当任务类型为 Cover 时有效。
        :type CoverTask: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskCoverResult`
        :param _TagTask: 视频内容分析智能标签任务的查询结果，当任务类型为 Tag 时有效。
        :type TagTask: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskTagResult`
        :param _FrameTagTask: 视频内容分析智能按帧标签任务的查询结果，当任务类型为 FrameTag 时有效。
        :type FrameTagTask: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskFrameTagResult`
        :param _HighlightTask: 视频内容分析智能精彩集锦任务的查询结果，当任务类型为 Highlight 时有效。
        :type HighlightTask: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskHighlightResult`
        """
        self._Type = None
        self._ClassificationTask = None
        self._CoverTask = None
        self._TagTask = None
        self._FrameTagTask = None
        self._HighlightTask = None

    @property
    def Type(self):
        r"""任务的类型，可以取的值有：
<li>Classification：智能分类</li>
<li>Cover：智能封面</li>
<li>Tag：智能标签</li>
<li>FrameTag：智能按帧标签</li>
<li>Highlight：智能精彩集锦</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def ClassificationTask(self):
        r"""视频内容分析智能分类任务的查询结果，当任务类型为 Classification 时有效。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskClassificationResult`
        """
        return self._ClassificationTask

    @ClassificationTask.setter
    def ClassificationTask(self, ClassificationTask):
        self._ClassificationTask = ClassificationTask

    @property
    def CoverTask(self):
        r"""视频内容分析智能封面任务的查询结果，当任务类型为 Cover 时有效。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskCoverResult`
        """
        return self._CoverTask

    @CoverTask.setter
    def CoverTask(self, CoverTask):
        self._CoverTask = CoverTask

    @property
    def TagTask(self):
        r"""视频内容分析智能标签任务的查询结果，当任务类型为 Tag 时有效。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskTagResult`
        """
        return self._TagTask

    @TagTask.setter
    def TagTask(self, TagTask):
        self._TagTask = TagTask

    @property
    def FrameTagTask(self):
        r"""视频内容分析智能按帧标签任务的查询结果，当任务类型为 FrameTag 时有效。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskFrameTagResult`
        """
        return self._FrameTagTask

    @FrameTagTask.setter
    def FrameTagTask(self, FrameTagTask):
        self._FrameTagTask = FrameTagTask

    @property
    def HighlightTask(self):
        r"""视频内容分析智能精彩集锦任务的查询结果，当任务类型为 Highlight 时有效。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskHighlightResult`
        """
        return self._HighlightTask

    @HighlightTask.setter
    def HighlightTask(self, HighlightTask):
        self._HighlightTask = HighlightTask


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("ClassificationTask") is not None:
            self._ClassificationTask = AiAnalysisTaskClassificationResult()
            self._ClassificationTask._deserialize(params.get("ClassificationTask"))
        if params.get("CoverTask") is not None:
            self._CoverTask = AiAnalysisTaskCoverResult()
            self._CoverTask._deserialize(params.get("CoverTask"))
        if params.get("TagTask") is not None:
            self._TagTask = AiAnalysisTaskTagResult()
            self._TagTask._deserialize(params.get("TagTask"))
        if params.get("FrameTagTask") is not None:
            self._FrameTagTask = AiAnalysisTaskFrameTagResult()
            self._FrameTagTask._deserialize(params.get("FrameTagTask"))
        if params.get("HighlightTask") is not None:
            self._HighlightTask = AiAnalysisTaskHighlightResult()
            self._HighlightTask._deserialize(params.get("HighlightTask"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskClassificationInput(AbstractModel):
    r"""智能分类任务输入类型

    """

    def __init__(self):
        r"""
        :param _Definition: 视频智能分类模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""视频智能分类模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskClassificationOutput(AbstractModel):
    r"""智能分类结果信息

    """

    def __init__(self):
        r"""
        :param _ClassificationSet: 视频智能分类列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 ClassificationSetFileUrl 对应的文件中获取。
        :type ClassificationSet: list of MediaAiAnalysisClassificationItem
        :param _ClassificationSetFileUrl: 视频智能分类列表文件 URL。文件的内容为 JSON，数据结构与 ClassificationSet 字段一致。 （文件不会永久存储，到达 ClassificationSetFileUrlExpireTime 时间点后文件将被删除）。
        :type ClassificationSetFileUrl: str
        :param _ClassificationSetFileUrlExpireTime: 视频智能分类列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type ClassificationSetFileUrlExpireTime: str
        """
        self._ClassificationSet = None
        self._ClassificationSetFileUrl = None
        self._ClassificationSetFileUrlExpireTime = None

    @property
    def ClassificationSet(self):
        r"""视频智能分类列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 ClassificationSetFileUrl 对应的文件中获取。
        :rtype: list of MediaAiAnalysisClassificationItem
        """
        return self._ClassificationSet

    @ClassificationSet.setter
    def ClassificationSet(self, ClassificationSet):
        self._ClassificationSet = ClassificationSet

    @property
    def ClassificationSetFileUrl(self):
        r"""视频智能分类列表文件 URL。文件的内容为 JSON，数据结构与 ClassificationSet 字段一致。 （文件不会永久存储，到达 ClassificationSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._ClassificationSetFileUrl

    @ClassificationSetFileUrl.setter
    def ClassificationSetFileUrl(self, ClassificationSetFileUrl):
        self._ClassificationSetFileUrl = ClassificationSetFileUrl

    @property
    def ClassificationSetFileUrlExpireTime(self):
        r"""视频智能分类列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._ClassificationSetFileUrlExpireTime

    @ClassificationSetFileUrlExpireTime.setter
    def ClassificationSetFileUrlExpireTime(self, ClassificationSetFileUrlExpireTime):
        self._ClassificationSetFileUrlExpireTime = ClassificationSetFileUrlExpireTime


    def _deserialize(self, params):
        if params.get("ClassificationSet") is not None:
            self._ClassificationSet = []
            for item in params.get("ClassificationSet"):
                obj = MediaAiAnalysisClassificationItem()
                obj._deserialize(item)
                self._ClassificationSet.append(obj)
        self._ClassificationSetFileUrl = params.get("ClassificationSetFileUrl")
        self._ClassificationSetFileUrlExpireTime = params.get("ClassificationSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskClassificationResult(AbstractModel):
    r"""智能分类任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 智能分类任务输入。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskClassificationInput`
        :param _Output: 智能分类任务输出。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskClassificationOutput`
        :param _Progress: 智能分类任务进度，取值范围 [0-100] 。
        :type Progress: int
        :param _BeginProcessTime: 智能分类任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type BeginProcessTime: str
        :param _FinishTime: 智能分类任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""智能分类任务输入。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskClassificationInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""智能分类任务输出。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskClassificationOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        r"""智能分类任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def BeginProcessTime(self):
        r"""智能分类任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        r"""智能分类任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskClassificationInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskClassificationOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskCoverInput(AbstractModel):
    r"""智能分类任务输入类型

    """

    def __init__(self):
        r"""
        :param _Definition: 视频智能封面模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""视频智能封面模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskCoverOutput(AbstractModel):
    r"""智能封面结果信息

    """

    def __init__(self):
        r"""
        :param _CoverSet: 智能封面列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 CoverSetFileUrl 对应的文件中获取。
        :type CoverSet: list of MediaAiAnalysisCoverItem
        :param _CoverSetFileUrl: 智能封面列表文件 URL。文件的内容为 JSON，数据结构与 CoverSet 字段一致。 （文件不会永久存储，到达 CoverSetFileUrlExpireTime 时间点后文件将被删除）。
        :type CoverSetFileUrl: str
        :param _CoverSetFileUrlExpireTime: 智能封面列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type CoverSetFileUrlExpireTime: str
        """
        self._CoverSet = None
        self._CoverSetFileUrl = None
        self._CoverSetFileUrlExpireTime = None

    @property
    def CoverSet(self):
        r"""智能封面列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 CoverSetFileUrl 对应的文件中获取。
        :rtype: list of MediaAiAnalysisCoverItem
        """
        return self._CoverSet

    @CoverSet.setter
    def CoverSet(self, CoverSet):
        self._CoverSet = CoverSet

    @property
    def CoverSetFileUrl(self):
        r"""智能封面列表文件 URL。文件的内容为 JSON，数据结构与 CoverSet 字段一致。 （文件不会永久存储，到达 CoverSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._CoverSetFileUrl

    @CoverSetFileUrl.setter
    def CoverSetFileUrl(self, CoverSetFileUrl):
        self._CoverSetFileUrl = CoverSetFileUrl

    @property
    def CoverSetFileUrlExpireTime(self):
        r"""智能封面列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._CoverSetFileUrlExpireTime

    @CoverSetFileUrlExpireTime.setter
    def CoverSetFileUrlExpireTime(self, CoverSetFileUrlExpireTime):
        self._CoverSetFileUrlExpireTime = CoverSetFileUrlExpireTime


    def _deserialize(self, params):
        if params.get("CoverSet") is not None:
            self._CoverSet = []
            for item in params.get("CoverSet"):
                obj = MediaAiAnalysisCoverItem()
                obj._deserialize(item)
                self._CoverSet.append(obj)
        self._CoverSetFileUrl = params.get("CoverSetFileUrl")
        self._CoverSetFileUrlExpireTime = params.get("CoverSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskCoverResult(AbstractModel):
    r"""智能封面结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 智能封面任务输入。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskCoverInput`
        :param _Output: 智能封面任务输出。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskCoverOutput`
        :param _Progress: 智能封面任务进度，取值范围 [0-100] 。
        :type Progress: int
        :param _BeginProcessTime: 智能封面任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type BeginProcessTime: str
        :param _FinishTime: 智能封面任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""智能封面任务输入。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskCoverInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""智能封面任务输出。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskCoverOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        r"""智能封面任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def BeginProcessTime(self):
        r"""智能封面任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        r"""智能封面任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskCoverInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskCoverOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskFrameTagInput(AbstractModel):
    r"""智能按帧标签任务输入类型

    """

    def __init__(self):
        r"""
        :param _Definition: 视频智能按帧标签模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""视频智能按帧标签模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskFrameTagOutput(AbstractModel):
    r"""智能按帧标签结果信息

    """

    def __init__(self):
        r"""
        :param _SegmentSet: 视频按帧标签列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :type SegmentSet: list of MediaAiAnalysisFrameTagSegmentItem
        :param _SegmentSetFileUrl: 视频按帧标签列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :type SegmentSetFileUrl: str
        :param _SegmentSetFileUrlExpireTime: 视频按帧标签列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type SegmentSetFileUrlExpireTime: str
        """
        self._SegmentSet = None
        self._SegmentSetFileUrl = None
        self._SegmentSetFileUrlExpireTime = None

    @property
    def SegmentSet(self):
        r"""视频按帧标签列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :rtype: list of MediaAiAnalysisFrameTagSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SegmentSetFileUrl(self):
        r"""视频按帧标签列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._SegmentSetFileUrl

    @SegmentSetFileUrl.setter
    def SegmentSetFileUrl(self, SegmentSetFileUrl):
        self._SegmentSetFileUrl = SegmentSetFileUrl

    @property
    def SegmentSetFileUrlExpireTime(self):
        r"""视频按帧标签列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._SegmentSetFileUrlExpireTime

    @SegmentSetFileUrlExpireTime.setter
    def SegmentSetFileUrlExpireTime(self, SegmentSetFileUrlExpireTime):
        self._SegmentSetFileUrlExpireTime = SegmentSetFileUrlExpireTime


    def _deserialize(self, params):
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaAiAnalysisFrameTagSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SegmentSetFileUrl = params.get("SegmentSetFileUrl")
        self._SegmentSetFileUrlExpireTime = params.get("SegmentSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskFrameTagResult(AbstractModel):
    r"""智能按帧标签结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 智能按帧标签任务输入。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskFrameTagInput`
        :param _Output: 智能按帧标签任务输出。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskFrameTagOutput`
        :param _Progress: 智能按帧标签任务进度，取值范围 [0-100] 。
        :type Progress: int
        :param _BeginProcessTime: 智能按帧标签任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type BeginProcessTime: str
        :param _FinishTime: 智能按帧标签任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""智能按帧标签任务输入。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskFrameTagInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""智能按帧标签任务输出。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskFrameTagOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        r"""智能按帧标签任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def BeginProcessTime(self):
        r"""智能按帧标签任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        r"""智能按帧标签任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskFrameTagInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskFrameTagOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskHighlightInput(AbstractModel):
    r"""智能精彩片段任务输入类型

    """

    def __init__(self):
        r"""
        :param _Definition: 视频智能精彩片段模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""视频智能精彩片段模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskHighlightOutput(AbstractModel):
    r"""智能精彩片段结果信息

    """

    def __init__(self):
        r"""
        :param _HighlightSet: 视频智能精彩片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 HighlightSetFileUrl 对应的文件中获取。
        :type HighlightSet: list of MediaAiAnalysisHighlightItem
        :param _HighlightSetFileUrl: 视频智能精彩片段列表文件 URL。文件的内容为 JSON，数据结构与 HighlightSet 字段一致。 （文件不会永久存储，到达 HighlightSetFileUrlExpireTime 时间点后文件将被删除）。
        :type HighlightSetFileUrl: str
        :param _HighlightSetFileUrlExpireTime: 视频智能精彩片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type HighlightSetFileUrlExpireTime: str
        """
        self._HighlightSet = None
        self._HighlightSetFileUrl = None
        self._HighlightSetFileUrlExpireTime = None

    @property
    def HighlightSet(self):
        r"""视频智能精彩片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 HighlightSetFileUrl 对应的文件中获取。
        :rtype: list of MediaAiAnalysisHighlightItem
        """
        return self._HighlightSet

    @HighlightSet.setter
    def HighlightSet(self, HighlightSet):
        self._HighlightSet = HighlightSet

    @property
    def HighlightSetFileUrl(self):
        r"""视频智能精彩片段列表文件 URL。文件的内容为 JSON，数据结构与 HighlightSet 字段一致。 （文件不会永久存储，到达 HighlightSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._HighlightSetFileUrl

    @HighlightSetFileUrl.setter
    def HighlightSetFileUrl(self, HighlightSetFileUrl):
        self._HighlightSetFileUrl = HighlightSetFileUrl

    @property
    def HighlightSetFileUrlExpireTime(self):
        r"""视频智能精彩片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._HighlightSetFileUrlExpireTime

    @HighlightSetFileUrlExpireTime.setter
    def HighlightSetFileUrlExpireTime(self, HighlightSetFileUrlExpireTime):
        self._HighlightSetFileUrlExpireTime = HighlightSetFileUrlExpireTime


    def _deserialize(self, params):
        if params.get("HighlightSet") is not None:
            self._HighlightSet = []
            for item in params.get("HighlightSet"):
                obj = MediaAiAnalysisHighlightItem()
                obj._deserialize(item)
                self._HighlightSet.append(obj)
        self._HighlightSetFileUrl = params.get("HighlightSetFileUrl")
        self._HighlightSetFileUrlExpireTime = params.get("HighlightSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskHighlightResult(AbstractModel):
    r"""智能精彩片段结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 智能精彩片段任务输入。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskHighlightInput`
        :param _Output: 智能精彩片段任务输出。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskHighlightOutput`
        :param _Progress: 智能精彩片段任务进度，取值范围 [0-100] 。
        :type Progress: int
        :param _BeginProcessTime: 智能精彩片段任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type BeginProcessTime: str
        :param _FinishTime: 智能精彩片段任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""智能精彩片段任务输入。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskHighlightInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""智能精彩片段任务输出。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskHighlightOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        r"""智能精彩片段任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def BeginProcessTime(self):
        r"""智能精彩片段任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        r"""智能精彩片段任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskHighlightInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskHighlightOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskInput(AbstractModel):
    r"""AI 视频智能分析输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 视频内容分析模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""视频内容分析模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskTagInput(AbstractModel):
    r"""智能标签任务输入类型

    """

    def __init__(self):
        r"""
        :param _Definition: 视频智能标签模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""视频智能标签模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskTagOutput(AbstractModel):
    r"""智能标签结果信息

    """

    def __init__(self):
        r"""
        :param _TagSet: 视频智能标签列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 TagSetFileUrl 对应的文件中获取。
        :type TagSet: list of MediaAiAnalysisTagItem
        :param _TagSetFileUrl: 视频智能标签列表文件 URL。文件的内容为 JSON，数据结构与 TagSet 字段一致。 （文件不会永久存储，到达 TagSetFileUrlExpireTime 时间点后文件将被删除）。
        :type TagSetFileUrl: str
        :param _TagSetFileUrlExpireTime: 视频智能标签列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type TagSetFileUrlExpireTime: str
        """
        self._TagSet = None
        self._TagSetFileUrl = None
        self._TagSetFileUrlExpireTime = None

    @property
    def TagSet(self):
        r"""视频智能标签列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 TagSetFileUrl 对应的文件中获取。
        :rtype: list of MediaAiAnalysisTagItem
        """
        return self._TagSet

    @TagSet.setter
    def TagSet(self, TagSet):
        self._TagSet = TagSet

    @property
    def TagSetFileUrl(self):
        r"""视频智能标签列表文件 URL。文件的内容为 JSON，数据结构与 TagSet 字段一致。 （文件不会永久存储，到达 TagSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._TagSetFileUrl

    @TagSetFileUrl.setter
    def TagSetFileUrl(self, TagSetFileUrl):
        self._TagSetFileUrl = TagSetFileUrl

    @property
    def TagSetFileUrlExpireTime(self):
        r"""视频智能标签列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._TagSetFileUrlExpireTime

    @TagSetFileUrlExpireTime.setter
    def TagSetFileUrlExpireTime(self, TagSetFileUrlExpireTime):
        self._TagSetFileUrlExpireTime = TagSetFileUrlExpireTime


    def _deserialize(self, params):
        if params.get("TagSet") is not None:
            self._TagSet = []
            for item in params.get("TagSet"):
                obj = MediaAiAnalysisTagItem()
                obj._deserialize(item)
                self._TagSet.append(obj)
        self._TagSetFileUrl = params.get("TagSetFileUrl")
        self._TagSetFileUrlExpireTime = params.get("TagSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskTagResult(AbstractModel):
    r"""智能标签结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 智能标签任务输入。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskTagInput`
        :param _Output: 智能标签任务输出。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskTagOutput`
        :param _Progress: 智能标签任务进度，取值范围 [0-100] 。
        :type Progress: int
        :param _BeginProcessTime: 智能标签任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type BeginProcessTime: str
        :param _FinishTime: 智能标签任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""智能标签任务输入。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskTagInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""智能标签任务输出。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskTagOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        r"""智能标签任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def BeginProcessTime(self):
        r"""智能标签任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        r"""智能标签任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskTagInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskTagOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiContentReviewResult(AbstractModel):
    r"""音视频审核结果

    """

    def __init__(self):
        r"""
        :param _Type: 任务的类型，可以取的值有：
<li>Porn：图片鉴别是否涉及令人反感的信息</li>
<li>Terrorism：图片鉴别是否涉及令人不安全的信息</li>
<li>Political：图片鉴别是否涉及令人不适宜的信息</li>
<li>Porn.Asr：Asr 文字（ 音频中的文字）鉴别是否涉及令人反感的信息</li>
<li>Porn.Ocr：Ocr 文字鉴别是否涉及令人反感的信息</li>
<li>Political.Asr：Asr 文字（ 音频中的文字）鉴别是否涉及令人不适宜的信息</li>
<li>Political.Ocr：Ocr 文字鉴别是否涉及令人不适宜的信息</li>
<li>Terrorism.Ocr：Ocr 文字鉴别是否涉及令人不安全的信息</li>
<li>Prohibited.Asr：Asr 文字（ 音频中的文字）鉴违禁</li>
<li>Prohibited.Ocr：Ocr 文字鉴违禁</li>
        :type Type: str
        :param _PornTask: 视频音视频审核任务（画面涉及令人反感的信息）的查询结果，当任务类型为 Porn 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type PornTask: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskPornResult`
        :param _TerrorismTask: 视频音视频审核任务（画面涉及令人不安全的信息）的查询结果，当任务类型为 Terrorism 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type TerrorismTask: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskTerrorismResult`
        :param _PoliticalTask: 视频音视频审核任务（画面涉及令人不适宜的信息）的查询结果，当任务类型为 Political 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type PoliticalTask: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskPoliticalResult`
        :param _PornAsrTask: 视频音视频审核任务（Asr 文字涉及令人反感的信息）的查询结果，当任务类型为 Porn.Asr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type PornAsrTask: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskPornAsrResult`
        :param _PornOcrTask: 视频音视频审核任务（Ocr 文字涉及令人反感的信息）的查询结果，当任务类型为 Porn.Ocr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type PornOcrTask: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskPornOcrResult`
        :param _PoliticalAsrTask: 视频音视频审核任务（Asr 文字涉及令人不适宜的信息）的查询结果，当任务类型为 Political.Asr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type PoliticalAsrTask: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskPoliticalAsrResult`
        :param _PoliticalOcrTask: 视频音视频审核任务（Ocr 文字涉及令人不适宜的信息）的查询结果，当任务类型为 Political.Ocr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type PoliticalOcrTask: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskPoliticalOcrResult`
        :param _TerrorismOcrTask: 视频音视频审核任务（ Ocr 文字涉及令人不安全的信息）的查询结果，当任务类型为 Terrorism.Ocr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type TerrorismOcrTask: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskTerrorismOcrResult`
        :param _ProhibitedOcrTask: 视频音视频审核 Ocr 文字鉴违禁任务的查询结果，当任务类型为 Prohibited.Ocr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type ProhibitedOcrTask: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskProhibitedOcrResult`
        :param _ProhibitedAsrTask: 视频音视频审核 Asr 文字鉴违禁任务的查询结果，当任务类型为 Prohibited.Asr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type ProhibitedAsrTask: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskProhibitedAsrResult`
        """
        self._Type = None
        self._PornTask = None
        self._TerrorismTask = None
        self._PoliticalTask = None
        self._PornAsrTask = None
        self._PornOcrTask = None
        self._PoliticalAsrTask = None
        self._PoliticalOcrTask = None
        self._TerrorismOcrTask = None
        self._ProhibitedOcrTask = None
        self._ProhibitedAsrTask = None

    @property
    def Type(self):
        r"""任务的类型，可以取的值有：
<li>Porn：图片鉴别是否涉及令人反感的信息</li>
<li>Terrorism：图片鉴别是否涉及令人不安全的信息</li>
<li>Political：图片鉴别是否涉及令人不适宜的信息</li>
<li>Porn.Asr：Asr 文字（ 音频中的文字）鉴别是否涉及令人反感的信息</li>
<li>Porn.Ocr：Ocr 文字鉴别是否涉及令人反感的信息</li>
<li>Political.Asr：Asr 文字（ 音频中的文字）鉴别是否涉及令人不适宜的信息</li>
<li>Political.Ocr：Ocr 文字鉴别是否涉及令人不适宜的信息</li>
<li>Terrorism.Ocr：Ocr 文字鉴别是否涉及令人不安全的信息</li>
<li>Prohibited.Asr：Asr 文字（ 音频中的文字）鉴违禁</li>
<li>Prohibited.Ocr：Ocr 文字鉴违禁</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def PornTask(self):
        r"""视频音视频审核任务（画面涉及令人反感的信息）的查询结果，当任务类型为 Porn 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskPornResult`
        """
        return self._PornTask

    @PornTask.setter
    def PornTask(self, PornTask):
        self._PornTask = PornTask

    @property
    def TerrorismTask(self):
        r"""视频音视频审核任务（画面涉及令人不安全的信息）的查询结果，当任务类型为 Terrorism 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskTerrorismResult`
        """
        return self._TerrorismTask

    @TerrorismTask.setter
    def TerrorismTask(self, TerrorismTask):
        self._TerrorismTask = TerrorismTask

    @property
    def PoliticalTask(self):
        r"""视频音视频审核任务（画面涉及令人不适宜的信息）的查询结果，当任务类型为 Political 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskPoliticalResult`
        """
        return self._PoliticalTask

    @PoliticalTask.setter
    def PoliticalTask(self, PoliticalTask):
        self._PoliticalTask = PoliticalTask

    @property
    def PornAsrTask(self):
        r"""视频音视频审核任务（Asr 文字涉及令人反感的信息）的查询结果，当任务类型为 Porn.Asr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskPornAsrResult`
        """
        return self._PornAsrTask

    @PornAsrTask.setter
    def PornAsrTask(self, PornAsrTask):
        self._PornAsrTask = PornAsrTask

    @property
    def PornOcrTask(self):
        r"""视频音视频审核任务（Ocr 文字涉及令人反感的信息）的查询结果，当任务类型为 Porn.Ocr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskPornOcrResult`
        """
        return self._PornOcrTask

    @PornOcrTask.setter
    def PornOcrTask(self, PornOcrTask):
        self._PornOcrTask = PornOcrTask

    @property
    def PoliticalAsrTask(self):
        r"""视频音视频审核任务（Asr 文字涉及令人不适宜的信息）的查询结果，当任务类型为 Political.Asr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskPoliticalAsrResult`
        """
        return self._PoliticalAsrTask

    @PoliticalAsrTask.setter
    def PoliticalAsrTask(self, PoliticalAsrTask):
        self._PoliticalAsrTask = PoliticalAsrTask

    @property
    def PoliticalOcrTask(self):
        r"""视频音视频审核任务（Ocr 文字涉及令人不适宜的信息）的查询结果，当任务类型为 Political.Ocr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskPoliticalOcrResult`
        """
        return self._PoliticalOcrTask

    @PoliticalOcrTask.setter
    def PoliticalOcrTask(self, PoliticalOcrTask):
        self._PoliticalOcrTask = PoliticalOcrTask

    @property
    def TerrorismOcrTask(self):
        r"""视频音视频审核任务（ Ocr 文字涉及令人不安全的信息）的查询结果，当任务类型为 Terrorism.Ocr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskTerrorismOcrResult`
        """
        return self._TerrorismOcrTask

    @TerrorismOcrTask.setter
    def TerrorismOcrTask(self, TerrorismOcrTask):
        self._TerrorismOcrTask = TerrorismOcrTask

    @property
    def ProhibitedOcrTask(self):
        r"""视频音视频审核 Ocr 文字鉴违禁任务的查询结果，当任务类型为 Prohibited.Ocr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskProhibitedOcrResult`
        """
        return self._ProhibitedOcrTask

    @ProhibitedOcrTask.setter
    def ProhibitedOcrTask(self, ProhibitedOcrTask):
        self._ProhibitedOcrTask = ProhibitedOcrTask

    @property
    def ProhibitedAsrTask(self):
        r"""视频音视频审核 Asr 文字鉴违禁任务的查询结果，当任务类型为 Prohibited.Asr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskProhibitedAsrResult`
        """
        return self._ProhibitedAsrTask

    @ProhibitedAsrTask.setter
    def ProhibitedAsrTask(self, ProhibitedAsrTask):
        self._ProhibitedAsrTask = ProhibitedAsrTask


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("PornTask") is not None:
            self._PornTask = AiReviewTaskPornResult()
            self._PornTask._deserialize(params.get("PornTask"))
        if params.get("TerrorismTask") is not None:
            self._TerrorismTask = AiReviewTaskTerrorismResult()
            self._TerrorismTask._deserialize(params.get("TerrorismTask"))
        if params.get("PoliticalTask") is not None:
            self._PoliticalTask = AiReviewTaskPoliticalResult()
            self._PoliticalTask._deserialize(params.get("PoliticalTask"))
        if params.get("PornAsrTask") is not None:
            self._PornAsrTask = AiReviewTaskPornAsrResult()
            self._PornAsrTask._deserialize(params.get("PornAsrTask"))
        if params.get("PornOcrTask") is not None:
            self._PornOcrTask = AiReviewTaskPornOcrResult()
            self._PornOcrTask._deserialize(params.get("PornOcrTask"))
        if params.get("PoliticalAsrTask") is not None:
            self._PoliticalAsrTask = AiReviewTaskPoliticalAsrResult()
            self._PoliticalAsrTask._deserialize(params.get("PoliticalAsrTask"))
        if params.get("PoliticalOcrTask") is not None:
            self._PoliticalOcrTask = AiReviewTaskPoliticalOcrResult()
            self._PoliticalOcrTask._deserialize(params.get("PoliticalOcrTask"))
        if params.get("TerrorismOcrTask") is not None:
            self._TerrorismOcrTask = AiReviewTaskTerrorismOcrResult()
            self._TerrorismOcrTask._deserialize(params.get("TerrorismOcrTask"))
        if params.get("ProhibitedOcrTask") is not None:
            self._ProhibitedOcrTask = AiReviewTaskProhibitedOcrResult()
            self._ProhibitedOcrTask._deserialize(params.get("ProhibitedOcrTask"))
        if params.get("ProhibitedAsrTask") is not None:
            self._ProhibitedAsrTask = AiReviewTaskProhibitedAsrResult()
            self._ProhibitedAsrTask._deserialize(params.get("ProhibitedAsrTask"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiContentReviewTaskInput(AbstractModel):
    r"""音视频审核任务类型

    """

    def __init__(self):
        r"""
        :param _Definition: 音视频审核模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""音视频审核模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionResult(AbstractModel):
    r"""智能识别结果。

    """

    def __init__(self):
        r"""
        :param _Type: 任务的类型，取值范围：
<li>FaceRecognition：人脸识别，</li>
<li>AsrWordsRecognition：语音关键词识别，</li>
<li>OcrWordsRecognition：文本关键词识别，</li>
<li>AsrFullTextRecognition：语音全文识别，</li>
<li>AsrTranslateRecognition：语音翻译识别，</li>
<li>OcrFullTextRecognition：文本全文识别，</li>
<li>HeadTailRecognition：视频片头片尾识别，</li>
<li>ObjectRecognition：物体识别。</li>
        :type Type: str
        :param _HeadTailTask: 视频片头片尾识别结果，当 Type 为
 HeadTailRecognition 时有效。
        :type HeadTailTask: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskHeadTailResult`
        :param _SegmentTask: 视频拆条识别结果，当 Type 为
 SegmentRecognition 时有效。
        :type SegmentTask: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskSegmentResult`
        :param _FaceTask: 人脸识别结果，当 Type 为 
 FaceRecognition 时有效。
        :type FaceTask: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskFaceResult`
        :param _AsrWordsTask: 语音关键词识别结果，当 Type 为
 AsrWordsRecognition 时有效。
        :type AsrWordsTask: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskAsrWordsResult`
        :param _AsrFullTextTask: 语音全文识别结果，当 Type 为
 AsrFullTextRecognition 时有效。
        :type AsrFullTextTask: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskAsrFullTextResult`
        :param _AsrTranslateTask: 语音翻译结果，当 Type 为 AsrTranslateRecognition 时有效。
        :type AsrTranslateTask: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskAsrTranslateResult`
        :param _OcrWordsTask: 文本关键词识别结果，当 Type 为
 OcrWordsRecognition 时有效。
        :type OcrWordsTask: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskOcrWordsResult`
        :param _OcrFullTextTask: 文本全文识别结果，当 Type 为
 OcrFullTextRecognition 时有效。
        :type OcrFullTextTask: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskOcrFullTextResult`
        :param _ObjectTask: 物体识别结果，当 Type 为
 ObjectRecognition 时有效。
        :type ObjectTask: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskObjectResult`
        """
        self._Type = None
        self._HeadTailTask = None
        self._SegmentTask = None
        self._FaceTask = None
        self._AsrWordsTask = None
        self._AsrFullTextTask = None
        self._AsrTranslateTask = None
        self._OcrWordsTask = None
        self._OcrFullTextTask = None
        self._ObjectTask = None

    @property
    def Type(self):
        r"""任务的类型，取值范围：
<li>FaceRecognition：人脸识别，</li>
<li>AsrWordsRecognition：语音关键词识别，</li>
<li>OcrWordsRecognition：文本关键词识别，</li>
<li>AsrFullTextRecognition：语音全文识别，</li>
<li>AsrTranslateRecognition：语音翻译识别，</li>
<li>OcrFullTextRecognition：文本全文识别，</li>
<li>HeadTailRecognition：视频片头片尾识别，</li>
<li>ObjectRecognition：物体识别。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def HeadTailTask(self):
        r"""视频片头片尾识别结果，当 Type 为
 HeadTailRecognition 时有效。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskHeadTailResult`
        """
        return self._HeadTailTask

    @HeadTailTask.setter
    def HeadTailTask(self, HeadTailTask):
        self._HeadTailTask = HeadTailTask

    @property
    def SegmentTask(self):
        r"""视频拆条识别结果，当 Type 为
 SegmentRecognition 时有效。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskSegmentResult`
        """
        return self._SegmentTask

    @SegmentTask.setter
    def SegmentTask(self, SegmentTask):
        self._SegmentTask = SegmentTask

    @property
    def FaceTask(self):
        r"""人脸识别结果，当 Type 为 
 FaceRecognition 时有效。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskFaceResult`
        """
        return self._FaceTask

    @FaceTask.setter
    def FaceTask(self, FaceTask):
        self._FaceTask = FaceTask

    @property
    def AsrWordsTask(self):
        r"""语音关键词识别结果，当 Type 为
 AsrWordsRecognition 时有效。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskAsrWordsResult`
        """
        return self._AsrWordsTask

    @AsrWordsTask.setter
    def AsrWordsTask(self, AsrWordsTask):
        self._AsrWordsTask = AsrWordsTask

    @property
    def AsrFullTextTask(self):
        r"""语音全文识别结果，当 Type 为
 AsrFullTextRecognition 时有效。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskAsrFullTextResult`
        """
        return self._AsrFullTextTask

    @AsrFullTextTask.setter
    def AsrFullTextTask(self, AsrFullTextTask):
        self._AsrFullTextTask = AsrFullTextTask

    @property
    def AsrTranslateTask(self):
        r"""语音翻译结果，当 Type 为 AsrTranslateRecognition 时有效。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskAsrTranslateResult`
        """
        return self._AsrTranslateTask

    @AsrTranslateTask.setter
    def AsrTranslateTask(self, AsrTranslateTask):
        self._AsrTranslateTask = AsrTranslateTask

    @property
    def OcrWordsTask(self):
        r"""文本关键词识别结果，当 Type 为
 OcrWordsRecognition 时有效。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskOcrWordsResult`
        """
        return self._OcrWordsTask

    @OcrWordsTask.setter
    def OcrWordsTask(self, OcrWordsTask):
        self._OcrWordsTask = OcrWordsTask

    @property
    def OcrFullTextTask(self):
        r"""文本全文识别结果，当 Type 为
 OcrFullTextRecognition 时有效。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskOcrFullTextResult`
        """
        return self._OcrFullTextTask

    @OcrFullTextTask.setter
    def OcrFullTextTask(self, OcrFullTextTask):
        self._OcrFullTextTask = OcrFullTextTask

    @property
    def ObjectTask(self):
        r"""物体识别结果，当 Type 为
 ObjectRecognition 时有效。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskObjectResult`
        """
        return self._ObjectTask

    @ObjectTask.setter
    def ObjectTask(self, ObjectTask):
        self._ObjectTask = ObjectTask


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("HeadTailTask") is not None:
            self._HeadTailTask = AiRecognitionTaskHeadTailResult()
            self._HeadTailTask._deserialize(params.get("HeadTailTask"))
        if params.get("SegmentTask") is not None:
            self._SegmentTask = AiRecognitionTaskSegmentResult()
            self._SegmentTask._deserialize(params.get("SegmentTask"))
        if params.get("FaceTask") is not None:
            self._FaceTask = AiRecognitionTaskFaceResult()
            self._FaceTask._deserialize(params.get("FaceTask"))
        if params.get("AsrWordsTask") is not None:
            self._AsrWordsTask = AiRecognitionTaskAsrWordsResult()
            self._AsrWordsTask._deserialize(params.get("AsrWordsTask"))
        if params.get("AsrFullTextTask") is not None:
            self._AsrFullTextTask = AiRecognitionTaskAsrFullTextResult()
            self._AsrFullTextTask._deserialize(params.get("AsrFullTextTask"))
        if params.get("AsrTranslateTask") is not None:
            self._AsrTranslateTask = AiRecognitionTaskAsrTranslateResult()
            self._AsrTranslateTask._deserialize(params.get("AsrTranslateTask"))
        if params.get("OcrWordsTask") is not None:
            self._OcrWordsTask = AiRecognitionTaskOcrWordsResult()
            self._OcrWordsTask._deserialize(params.get("OcrWordsTask"))
        if params.get("OcrFullTextTask") is not None:
            self._OcrFullTextTask = AiRecognitionTaskOcrFullTextResult()
            self._OcrFullTextTask._deserialize(params.get("OcrFullTextTask"))
        if params.get("ObjectTask") is not None:
            self._ObjectTask = AiRecognitionTaskObjectResult()
            self._ObjectTask._deserialize(params.get("ObjectTask"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrFullTextResult(AbstractModel):
    r"""语音全文识别结果。

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 语音全文识别任务输入信息。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskAsrFullTextResultInput`
        :param _Output: 语音全文识别任务输出信息。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskAsrFullTextResultOutput`
        :param _Progress: 语音全文识别任务进度，取值范围 [0-100] 。
        :type Progress: int
        :param _BeginProcessTime: 语音全文识别任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type BeginProcessTime: str
        :param _FinishTime: 语音全文识别任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""语音全文识别任务输入信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskAsrFullTextResultInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""语音全文识别任务输出信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskAsrFullTextResultOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        r"""语音全文识别任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def BeginProcessTime(self):
        r"""语音全文识别任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        r"""语音全文识别任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskAsrFullTextResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskAsrFullTextResultOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrFullTextResultInput(AbstractModel):
    r"""语音全文识别的输入。

    """

    def __init__(self):
        r"""
        :param _Definition: 语音全文识别模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""语音全文识别模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrFullTextResultOutput(AbstractModel):
    r"""语音全文识别结果。

    """

    def __init__(self):
        r"""
        :param _SegmentSet: 语音全文识别片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :type SegmentSet: list of AiRecognitionTaskAsrFullTextSegmentItem
        :param _SegmentSetFileUrl: 语音全文识别片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :type SegmentSetFileUrl: str
        :param _SegmentSetFileUrlExpireTime: 语音全文识别片段列表文件 URL 失效时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type SegmentSetFileUrlExpireTime: str
        :param _SubtitleSet: 生成的字幕列表，对应 [语音全文识别任务控制参数](https://cloud.tencent.com/document/api/266/31773#AsrFullTextConfigureInfo) SubtitleFormats。
        :type SubtitleSet: list of AiRecognitionTaskAsrFullTextResultOutputSubtitleItem
        :param _SubtitleUrl: 生成的字幕文件 Url，对应 [语音全文识别任务控制参数](https://cloud.tencent.com/document/api/266/31773#AsrFullTextConfigureInfo) SubtitleFormat。
        :type SubtitleUrl: str
        """
        self._SegmentSet = None
        self._SegmentSetFileUrl = None
        self._SegmentSetFileUrlExpireTime = None
        self._SubtitleSet = None
        self._SubtitleUrl = None

    @property
    def SegmentSet(self):
        r"""语音全文识别片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :rtype: list of AiRecognitionTaskAsrFullTextSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SegmentSetFileUrl(self):
        r"""语音全文识别片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._SegmentSetFileUrl

    @SegmentSetFileUrl.setter
    def SegmentSetFileUrl(self, SegmentSetFileUrl):
        self._SegmentSetFileUrl = SegmentSetFileUrl

    @property
    def SegmentSetFileUrlExpireTime(self):
        r"""语音全文识别片段列表文件 URL 失效时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._SegmentSetFileUrlExpireTime

    @SegmentSetFileUrlExpireTime.setter
    def SegmentSetFileUrlExpireTime(self, SegmentSetFileUrlExpireTime):
        self._SegmentSetFileUrlExpireTime = SegmentSetFileUrlExpireTime

    @property
    def SubtitleSet(self):
        r"""生成的字幕列表，对应 [语音全文识别任务控制参数](https://cloud.tencent.com/document/api/266/31773#AsrFullTextConfigureInfo) SubtitleFormats。
        :rtype: list of AiRecognitionTaskAsrFullTextResultOutputSubtitleItem
        """
        return self._SubtitleSet

    @SubtitleSet.setter
    def SubtitleSet(self, SubtitleSet):
        self._SubtitleSet = SubtitleSet

    @property
    def SubtitleUrl(self):
        r"""生成的字幕文件 Url，对应 [语音全文识别任务控制参数](https://cloud.tencent.com/document/api/266/31773#AsrFullTextConfigureInfo) SubtitleFormat。
        :rtype: str
        """
        return self._SubtitleUrl

    @SubtitleUrl.setter
    def SubtitleUrl(self, SubtitleUrl):
        self._SubtitleUrl = SubtitleUrl


    def _deserialize(self, params):
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskAsrFullTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SegmentSetFileUrl = params.get("SegmentSetFileUrl")
        self._SegmentSetFileUrlExpireTime = params.get("SegmentSetFileUrlExpireTime")
        if params.get("SubtitleSet") is not None:
            self._SubtitleSet = []
            for item in params.get("SubtitleSet"):
                obj = AiRecognitionTaskAsrFullTextResultOutputSubtitleItem()
                obj._deserialize(item)
                self._SubtitleSet.append(obj)
        self._SubtitleUrl = params.get("SubtitleUrl")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrFullTextResultOutputSubtitleItem(AbstractModel):
    r"""字幕信息。

    """

    def __init__(self):
        r"""
        :param _Id: 媒资字幕 ID，用于媒资字幕管理，仅当 Format 为 vtt 时有效。
<font color=red>注意：</font>2024-11-01T10:00:00Z 之前的任务返回此字段无效。
        :type Id: str
        :param _Name: 媒资字幕名字，用于播放器展示，仅当 Format 为 vtt 时有效。
<font color=red>注意：</font>2024-11-01T10:00:00Z 之前的任务返回此字段无效。
        :type Name: str
        :param _Language: 字幕语言。
        :type Language: str
        :param _Format: 字幕文件格式，取值范围：
<li>vtt：WebVTT 字幕文件；</li>
<li>srt：SRT 字幕文件。</li>
        :type Format: str
        :param _Url: 字幕文件 Url。
        :type Url: str
        """
        self._Id = None
        self._Name = None
        self._Language = None
        self._Format = None
        self._Url = None

    @property
    def Id(self):
        r"""媒资字幕 ID，用于媒资字幕管理，仅当 Format 为 vtt 时有效。
<font color=red>注意：</font>2024-11-01T10:00:00Z 之前的任务返回此字段无效。
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Name(self):
        r"""媒资字幕名字，用于播放器展示，仅当 Format 为 vtt 时有效。
<font color=red>注意：</font>2024-11-01T10:00:00Z 之前的任务返回此字段无效。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Language(self):
        r"""字幕语言。
        :rtype: str
        """
        return self._Language

    @Language.setter
    def Language(self, Language):
        self._Language = Language

    @property
    def Format(self):
        r"""字幕文件格式，取值范围：
<li>vtt：WebVTT 字幕文件；</li>
<li>srt：SRT 字幕文件。</li>
        :rtype: str
        """
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def Url(self):
        r"""字幕文件 Url。
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Name = params.get("Name")
        self._Language = params.get("Language")
        self._Format = params.get("Format")
        self._Url = params.get("Url")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrFullTextSegmentItem(AbstractModel):
    r"""语音全文识别片段。

    """

    def __init__(self):
        r"""
        :param _Confidence: 识别片段置信度。取值：0~100。
        :type Confidence: float
        :param _StartTimeOffset: 识别片段起始的偏移时间，单位：秒。
        :type StartTimeOffset: float
        :param _EndTimeOffset: 识别片段终止的偏移时间，单位：秒。
        :type EndTimeOffset: float
        :param _Text: 识别文本。
        :type Text: str
        """
        self._Confidence = None
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Text = None

    @property
    def Confidence(self):
        r"""识别片段置信度。取值：0~100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def StartTimeOffset(self):
        r"""识别片段起始的偏移时间，单位：秒。
        :rtype: float
        """
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        r"""识别片段终止的偏移时间，单位：秒。
        :rtype: float
        """
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Text(self):
        r"""识别文本。
        :rtype: str
        """
        return self._Text

    @Text.setter
    def Text(self, Text):
        self._Text = Text


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Text = params.get("Text")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrTranslateResult(AbstractModel):
    r"""语音翻译结果。

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 语音翻译任务输入信息。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskAsrTranslateResultInput`
        :param _Output: 语音翻译任务输出信息。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskAsrTranslateResultOutput`
        :param _Progress: 语音翻译任务进度，取值范围 [0-100] 。
        :type Progress: int
        :param _BeginProcessTime: 语音翻译任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type BeginProcessTime: str
        :param _FinishTime: 语音翻译任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""语音翻译任务输入信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskAsrTranslateResultInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""语音翻译任务输出信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskAsrTranslateResultOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        r"""语音翻译任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def BeginProcessTime(self):
        r"""语音翻译任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        r"""语音翻译任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskAsrTranslateResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskAsrTranslateResultOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrTranslateResultInput(AbstractModel):
    r"""语音翻译的输入。

    """

    def __init__(self):
        r"""
        :param _Definition: 语音翻译模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""语音翻译模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrTranslateResultOutput(AbstractModel):
    r"""语音翻译结果。

    """

    def __init__(self):
        r"""
        :param _SegmentSet: 语音翻译片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :type SegmentSet: list of AiRecognitionTaskAsrTranslateSegmentItem
        :param _SegmentSetFileUrl: 语音翻译片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :type SegmentSetFileUrl: str
        :param _SegmentSetFileUrlExpireTime: 语音翻译片段列表文件 URL 失效时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type SegmentSetFileUrlExpireTime: str
        :param _SubtitleSet: 生成的字幕列表。
        :type SubtitleSet: list of AiRecognitionTaskAsrFullTextResultOutputSubtitleItem
        """
        self._SegmentSet = None
        self._SegmentSetFileUrl = None
        self._SegmentSetFileUrlExpireTime = None
        self._SubtitleSet = None

    @property
    def SegmentSet(self):
        r"""语音翻译片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :rtype: list of AiRecognitionTaskAsrTranslateSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SegmentSetFileUrl(self):
        r"""语音翻译片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._SegmentSetFileUrl

    @SegmentSetFileUrl.setter
    def SegmentSetFileUrl(self, SegmentSetFileUrl):
        self._SegmentSetFileUrl = SegmentSetFileUrl

    @property
    def SegmentSetFileUrlExpireTime(self):
        r"""语音翻译片段列表文件 URL 失效时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._SegmentSetFileUrlExpireTime

    @SegmentSetFileUrlExpireTime.setter
    def SegmentSetFileUrlExpireTime(self, SegmentSetFileUrlExpireTime):
        self._SegmentSetFileUrlExpireTime = SegmentSetFileUrlExpireTime

    @property
    def SubtitleSet(self):
        r"""生成的字幕列表。
        :rtype: list of AiRecognitionTaskAsrFullTextResultOutputSubtitleItem
        """
        return self._SubtitleSet

    @SubtitleSet.setter
    def SubtitleSet(self, SubtitleSet):
        self._SubtitleSet = SubtitleSet


    def _deserialize(self, params):
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskAsrTranslateSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SegmentSetFileUrl = params.get("SegmentSetFileUrl")
        self._SegmentSetFileUrlExpireTime = params.get("SegmentSetFileUrlExpireTime")
        if params.get("SubtitleSet") is not None:
            self._SubtitleSet = []
            for item in params.get("SubtitleSet"):
                obj = AiRecognitionTaskAsrFullTextResultOutputSubtitleItem()
                obj._deserialize(item)
                self._SubtitleSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrTranslateSegmentItem(AbstractModel):
    r"""语音翻译识别片段。

    """

    def __init__(self):
        r"""
        :param _Confidence: 语音翻译识别片段置信度。取值：0~100。
        :type Confidence: float
        :param _StartTimeOffset: 语音翻译识别片段起始的偏移时间，单位：秒。
        :type StartTimeOffset: float
        :param _EndTimeOffset: 语音翻译识别片段终止的偏移时间，单位：秒。
        :type EndTimeOffset: float
        :param _Text: 识别文本。
        :type Text: str
        :param _Translation: 翻译文本。
        :type Translation: str
        """
        self._Confidence = None
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Text = None
        self._Translation = None

    @property
    def Confidence(self):
        r"""语音翻译识别片段置信度。取值：0~100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def StartTimeOffset(self):
        r"""语音翻译识别片段起始的偏移时间，单位：秒。
        :rtype: float
        """
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        r"""语音翻译识别片段终止的偏移时间，单位：秒。
        :rtype: float
        """
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Text(self):
        r"""识别文本。
        :rtype: str
        """
        return self._Text

    @Text.setter
    def Text(self, Text):
        self._Text = Text

    @property
    def Translation(self):
        r"""翻译文本。
        :rtype: str
        """
        return self._Translation

    @Translation.setter
    def Translation(self, Translation):
        self._Translation = Translation


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Text = params.get("Text")
        self._Translation = params.get("Translation")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrWordsResult(AbstractModel):
    r"""语音关键词识别结果。

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 语音关键词识别任务输入信息。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskAsrWordsResultInput`
        :param _Output: 语音关键词识别任务输出信息。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskAsrWordsResultOutput`
        :param _Progress: 语音关键词识别任务进度，取值范围 [0-100] 。
        :type Progress: int
        :param _BeginProcessTime: 语音关键词识别任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type BeginProcessTime: str
        :param _FinishTime: 语音关键词识别任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""语音关键词识别任务输入信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskAsrWordsResultInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""语音关键词识别任务输出信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskAsrWordsResultOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        r"""语音关键词识别任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def BeginProcessTime(self):
        r"""语音关键词识别任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        r"""语音关键词识别任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskAsrWordsResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskAsrWordsResultOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrWordsResultInput(AbstractModel):
    r"""语音关键词识别输入。

    """

    def __init__(self):
        r"""
        :param _Definition: 语音关键词识别模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""语音关键词识别模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrWordsResultItem(AbstractModel):
    r"""语音关键词识别结果。

    """

    def __init__(self):
        r"""
        :param _Word: 语音关键词。
        :type Word: str
        :param _SegmentSet: 语音关键词出现的时间片段列表。
        :type SegmentSet: list of AiRecognitionTaskAsrWordsSegmentItem
        """
        self._Word = None
        self._SegmentSet = None

    @property
    def Word(self):
        r"""语音关键词。
        :rtype: str
        """
        return self._Word

    @Word.setter
    def Word(self, Word):
        self._Word = Word

    @property
    def SegmentSet(self):
        r"""语音关键词出现的时间片段列表。
        :rtype: list of AiRecognitionTaskAsrWordsSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Word = params.get("Word")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskAsrWordsSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrWordsResultOutput(AbstractModel):
    r"""语音关键词识别输出。

    """

    def __init__(self):
        r"""
        :param _ResultSet: 语音关键词识别结果集。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 ResultSetFileUrl 对应的文件中获取。
        :type ResultSet: list of AiRecognitionTaskAsrWordsResultItem
        :param _ResultSetFileUrl: 语音关键词识别结果集文件 URL。文件的内容为 JSON，数据结构与 ResultSet 字段一致。 （文件不会永久存储，到达ResultSetFileUrlExpireTime 时间点后文件将被删除）。
        :type ResultSetFileUrl: str
        :param _ResultSetFileUrlExpireTime: 语音关键词识别结果集文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type ResultSetFileUrlExpireTime: str
        """
        self._ResultSet = None
        self._ResultSetFileUrl = None
        self._ResultSetFileUrlExpireTime = None

    @property
    def ResultSet(self):
        r"""语音关键词识别结果集。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 ResultSetFileUrl 对应的文件中获取。
        :rtype: list of AiRecognitionTaskAsrWordsResultItem
        """
        return self._ResultSet

    @ResultSet.setter
    def ResultSet(self, ResultSet):
        self._ResultSet = ResultSet

    @property
    def ResultSetFileUrl(self):
        r"""语音关键词识别结果集文件 URL。文件的内容为 JSON，数据结构与 ResultSet 字段一致。 （文件不会永久存储，到达ResultSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._ResultSetFileUrl

    @ResultSetFileUrl.setter
    def ResultSetFileUrl(self, ResultSetFileUrl):
        self._ResultSetFileUrl = ResultSetFileUrl

    @property
    def ResultSetFileUrlExpireTime(self):
        r"""语音关键词识别结果集文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._ResultSetFileUrlExpireTime

    @ResultSetFileUrlExpireTime.setter
    def ResultSetFileUrlExpireTime(self, ResultSetFileUrlExpireTime):
        self._ResultSetFileUrlExpireTime = ResultSetFileUrlExpireTime


    def _deserialize(self, params):
        if params.get("ResultSet") is not None:
            self._ResultSet = []
            for item in params.get("ResultSet"):
                obj = AiRecognitionTaskAsrWordsResultItem()
                obj._deserialize(item)
                self._ResultSet.append(obj)
        self._ResultSetFileUrl = params.get("ResultSetFileUrl")
        self._ResultSetFileUrlExpireTime = params.get("ResultSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrWordsSegmentItem(AbstractModel):
    r"""语音识别片段。

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: 识别片段起始的偏移时间，单位：秒。
        :type StartTimeOffset: float
        :param _EndTimeOffset: 识别片段终止的偏移时间，单位：秒。
        :type EndTimeOffset: float
        :param _Confidence: 识别片段置信度。取值：0~100。
        :type Confidence: float
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Confidence = None

    @property
    def StartTimeOffset(self):
        r"""识别片段起始的偏移时间，单位：秒。
        :rtype: float
        """
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        r"""识别片段终止的偏移时间，单位：秒。
        :rtype: float
        """
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Confidence(self):
        r"""识别片段置信度。取值：0~100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Confidence = params.get("Confidence")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskFaceResult(AbstractModel):
    r"""人脸识别结果。

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 人脸识别任务输入信息。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskFaceResultInput`
        :param _Output: 人脸识别任务输出信息。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskFaceResultOutput`
        :param _Progress: 人脸识别任务进度，取值范围 [0-100] 。
        :type Progress: int
        :param _BeginProcessTime: 人脸识别任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type BeginProcessTime: str
        :param _FinishTime: 人脸识别任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""人脸识别任务输入信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskFaceResultInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""人脸识别任务输出信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskFaceResultOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        r"""人脸识别任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def BeginProcessTime(self):
        r"""人脸识别任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        r"""人脸识别任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskFaceResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskFaceResultOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskFaceResultInput(AbstractModel):
    r"""人脸识别输入。

    """

    def __init__(self):
        r"""
        :param _Definition: 人脸识别模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""人脸识别模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskFaceResultItem(AbstractModel):
    r"""人脸识别结果

    """

    def __init__(self):
        r"""
        :param _Id: 人物唯一标识 ID。
        :type Id: str
        :param _Type: 人物库类型，表示识别出的人物来自哪个人物库：
<li>Default：默认人物库；</li>
<li>UserDefine：用户自定义人物库。</li>
        :type Type: str
        :param _Name: 人物名称。
        :type Name: str
        :param _SegmentSet: 人物出现的片段结果集。
        :type SegmentSet: list of AiRecognitionTaskFaceSegmentItem
        """
        self._Id = None
        self._Type = None
        self._Name = None
        self._SegmentSet = None

    @property
    def Id(self):
        r"""人物唯一标识 ID。
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Type(self):
        r"""人物库类型，表示识别出的人物来自哪个人物库：
<li>Default：默认人物库；</li>
<li>UserDefine：用户自定义人物库。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        r"""人物名称。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SegmentSet(self):
        r"""人物出现的片段结果集。
        :rtype: list of AiRecognitionTaskFaceSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskFaceSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskFaceResultOutput(AbstractModel):
    r"""智能人脸识别输出。

    """

    def __init__(self):
        r"""
        :param _ResultSet: 智能人脸识别结果集。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 ResultSetFileUrl 对应的文件中获取。
        :type ResultSet: list of AiRecognitionTaskFaceResultItem
        :param _ResultSetFileUrl: 智能人脸识别结果集文件 URL。文件的内容为 JSON，数据结构与 ResultSet 字段一致。 （文件不会永久存储，到达ResultSetFileUrlExpireTime 时间点后文件将被删除）。
        :type ResultSetFileUrl: str
        :param _ResultSetFileUrlExpireTime: 智能人脸识别结果集文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type ResultSetFileUrlExpireTime: str
        """
        self._ResultSet = None
        self._ResultSetFileUrl = None
        self._ResultSetFileUrlExpireTime = None

    @property
    def ResultSet(self):
        r"""智能人脸识别结果集。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 ResultSetFileUrl 对应的文件中获取。
        :rtype: list of AiRecognitionTaskFaceResultItem
        """
        return self._ResultSet

    @ResultSet.setter
    def ResultSet(self, ResultSet):
        self._ResultSet = ResultSet

    @property
    def ResultSetFileUrl(self):
        r"""智能人脸识别结果集文件 URL。文件的内容为 JSON，数据结构与 ResultSet 字段一致。 （文件不会永久存储，到达ResultSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._ResultSetFileUrl

    @ResultSetFileUrl.setter
    def ResultSetFileUrl(self, ResultSetFileUrl):
        self._ResultSetFileUrl = ResultSetFileUrl

    @property
    def ResultSetFileUrlExpireTime(self):
        r"""智能人脸识别结果集文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._ResultSetFileUrlExpireTime

    @ResultSetFileUrlExpireTime.setter
    def ResultSetFileUrlExpireTime(self, ResultSetFileUrlExpireTime):
        self._ResultSetFileUrlExpireTime = ResultSetFileUrlExpireTime


    def _deserialize(self, params):
        if params.get("ResultSet") is not None:
            self._ResultSet = []
            for item in params.get("ResultSet"):
                obj = AiRecognitionTaskFaceResultItem()
                obj._deserialize(item)
                self._ResultSet.append(obj)
        self._ResultSetFileUrl = params.get("ResultSetFileUrl")
        self._ResultSetFileUrlExpireTime = params.get("ResultSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskFaceSegmentItem(AbstractModel):
    r"""人脸识别结果片段

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: 识别片段起始的偏移时间，单位：秒。
        :type StartTimeOffset: float
        :param _EndTimeOffset: 识别片段终止的偏移时间，单位：秒。
        :type EndTimeOffset: float
        :param _Confidence: 识别片段置信度。取值：0~100。
        :type Confidence: float
        :param _AreaCoordSet: 识别结果的区域坐标。数组包含 4 个元素 [x1,y1,x2,y2]，依次表示区域左上点、右下点的横纵坐标。
        :type AreaCoordSet: list of int
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Confidence = None
        self._AreaCoordSet = None

    @property
    def StartTimeOffset(self):
        r"""识别片段起始的偏移时间，单位：秒。
        :rtype: float
        """
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        r"""识别片段终止的偏移时间，单位：秒。
        :rtype: float
        """
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Confidence(self):
        r"""识别片段置信度。取值：0~100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def AreaCoordSet(self):
        r"""识别结果的区域坐标。数组包含 4 个元素 [x1,y1,x2,y2]，依次表示区域左上点、右下点的横纵坐标。
        :rtype: list of int
        """
        return self._AreaCoordSet

    @AreaCoordSet.setter
    def AreaCoordSet(self, AreaCoordSet):
        self._AreaCoordSet = AreaCoordSet


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Confidence = params.get("Confidence")
        self._AreaCoordSet = params.get("AreaCoordSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskHeadTailResult(AbstractModel):
    r"""视频片头片尾识别结果。

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 视频片头片尾识别任务输入信息。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskHeadTailResultInput`
        :param _Output: 视频片头片尾识别任务输出信息。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskHeadTailResultOutput`
        :param _Progress: 视频片头片尾识别任务进度，取值范围 [0-100] 。
        :type Progress: int
        :param _BeginProcessTime: 视频片头片尾识别任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type BeginProcessTime: str
        :param _FinishTime: 视频片头片尾识别任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""视频片头片尾识别任务输入信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskHeadTailResultInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""视频片头片尾识别任务输出信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskHeadTailResultOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        r"""视频片头片尾识别任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def BeginProcessTime(self):
        r"""视频片头片尾识别任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        r"""视频片头片尾识别任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskHeadTailResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskHeadTailResultOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskHeadTailResultInput(AbstractModel):
    r"""视频片头片尾识别的输入。

    """

    def __init__(self):
        r"""
        :param _Definition: 视频片头片尾识别模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""视频片头片尾识别模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskHeadTailResultOutput(AbstractModel):
    r"""视频片头片尾识别输出。

    """

    def __init__(self):
        r"""
        :param _HeadConfidence: 片头识别置信度。取值：0~100。
        :type HeadConfidence: float
        :param _HeadTimeOffset: 视频片头的结束时间点，单位：秒。
        :type HeadTimeOffset: float
        :param _TailConfidence: 片尾识别置信度。取值：0~100。
        :type TailConfidence: float
        :param _TailTimeOffset: 视频片尾的开始时间点，单位：秒。
        :type TailTimeOffset: float
        """
        self._HeadConfidence = None
        self._HeadTimeOffset = None
        self._TailConfidence = None
        self._TailTimeOffset = None

    @property
    def HeadConfidence(self):
        r"""片头识别置信度。取值：0~100。
        :rtype: float
        """
        return self._HeadConfidence

    @HeadConfidence.setter
    def HeadConfidence(self, HeadConfidence):
        self._HeadConfidence = HeadConfidence

    @property
    def HeadTimeOffset(self):
        r"""视频片头的结束时间点，单位：秒。
        :rtype: float
        """
        return self._HeadTimeOffset

    @HeadTimeOffset.setter
    def HeadTimeOffset(self, HeadTimeOffset):
        self._HeadTimeOffset = HeadTimeOffset

    @property
    def TailConfidence(self):
        r"""片尾识别置信度。取值：0~100。
        :rtype: float
        """
        return self._TailConfidence

    @TailConfidence.setter
    def TailConfidence(self, TailConfidence):
        self._TailConfidence = TailConfidence

    @property
    def TailTimeOffset(self):
        r"""视频片尾的开始时间点，单位：秒。
        :rtype: float
        """
        return self._TailTimeOffset

    @TailTimeOffset.setter
    def TailTimeOffset(self, TailTimeOffset):
        self._TailTimeOffset = TailTimeOffset


    def _deserialize(self, params):
        self._HeadConfidence = params.get("HeadConfidence")
        self._HeadTimeOffset = params.get("HeadTimeOffset")
        self._TailConfidence = params.get("TailConfidence")
        self._TailTimeOffset = params.get("TailTimeOffset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskInput(AbstractModel):
    r"""视频内容识别输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 视频智能识别模板 ID 。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""视频智能识别模板 ID 。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskObjectResult(AbstractModel):
    r"""物体识别结果。

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 物体识别任务输入信息。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskObjectResultInput`
        :param _Output: 物体识别任务输出信息。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskObjectResultOutput`
        :param _Progress: 物体识别任务进度，取值范围 [0-100] 。
        :type Progress: int
        :param _BeginProcessTime: 物体识别任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type BeginProcessTime: str
        :param _FinishTime: 物体识别任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""物体识别任务输入信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskObjectResultInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""物体识别任务输出信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskObjectResultOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        r"""物体识别任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def BeginProcessTime(self):
        r"""物体识别任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        r"""物体识别任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskObjectResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskObjectResultOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskObjectResultInput(AbstractModel):
    r"""物体识别任务输入类型。

    """

    def __init__(self):
        r"""
        :param _Definition: 物体识别模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""物体识别模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskObjectResultItem(AbstractModel):
    r"""单个物体识别结果。

    """

    def __init__(self):
        r"""
        :param _Name: 识别的物体名称。
        :type Name: str
        :param _SegmentSet: 物体出现的片段列表。
        :type SegmentSet: list of AiRecognitionTaskObjectSeqmentItem
        :param _RecognitionSegmentSet: 物体出现的片段列表。
        :type RecognitionSegmentSet: list of AiRecognitionTaskObjectSegmentItem
        """
        self._Name = None
        self._SegmentSet = None
        self._RecognitionSegmentSet = None

    @property
    def Name(self):
        r"""识别的物体名称。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SegmentSet(self):
        warnings.warn("parameter `SegmentSet` is deprecated", DeprecationWarning) 

        r"""物体出现的片段列表。
        :rtype: list of AiRecognitionTaskObjectSeqmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        warnings.warn("parameter `SegmentSet` is deprecated", DeprecationWarning) 

        self._SegmentSet = SegmentSet

    @property
    def RecognitionSegmentSet(self):
        r"""物体出现的片段列表。
        :rtype: list of AiRecognitionTaskObjectSegmentItem
        """
        return self._RecognitionSegmentSet

    @RecognitionSegmentSet.setter
    def RecognitionSegmentSet(self, RecognitionSegmentSet):
        self._RecognitionSegmentSet = RecognitionSegmentSet


    def _deserialize(self, params):
        self._Name = params.get("Name")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskObjectSeqmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        if params.get("RecognitionSegmentSet") is not None:
            self._RecognitionSegmentSet = []
            for item in params.get("RecognitionSegmentSet"):
                obj = AiRecognitionTaskObjectSegmentItem()
                obj._deserialize(item)
                self._RecognitionSegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskObjectResultOutput(AbstractModel):
    r"""智能物体识别输出。

    """

    def __init__(self):
        r"""
        :param _ResultSet: 智能物体识别结果集。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 ResultSetFileUrl 对应的文件中获取。
        :type ResultSet: list of AiRecognitionTaskObjectResultItem
        :param _ResultSetFileUrl: 智能物体识别结果集文件 URL。文件的内容为 JSON，数据结构与 ResultSet 字段一致。 （文件不会永久存储，到达ResultSetFileUrlExpireTime 时间点后文件将被删除）。
        :type ResultSetFileUrl: str
        :param _ResultSetFileUrlExpireTime: 智能物体识别结果集文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type ResultSetFileUrlExpireTime: str
        """
        self._ResultSet = None
        self._ResultSetFileUrl = None
        self._ResultSetFileUrlExpireTime = None

    @property
    def ResultSet(self):
        r"""智能物体识别结果集。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 ResultSetFileUrl 对应的文件中获取。
        :rtype: list of AiRecognitionTaskObjectResultItem
        """
        return self._ResultSet

    @ResultSet.setter
    def ResultSet(self, ResultSet):
        self._ResultSet = ResultSet

    @property
    def ResultSetFileUrl(self):
        r"""智能物体识别结果集文件 URL。文件的内容为 JSON，数据结构与 ResultSet 字段一致。 （文件不会永久存储，到达ResultSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._ResultSetFileUrl

    @ResultSetFileUrl.setter
    def ResultSetFileUrl(self, ResultSetFileUrl):
        self._ResultSetFileUrl = ResultSetFileUrl

    @property
    def ResultSetFileUrlExpireTime(self):
        r"""智能物体识别结果集文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._ResultSetFileUrlExpireTime

    @ResultSetFileUrlExpireTime.setter
    def ResultSetFileUrlExpireTime(self, ResultSetFileUrlExpireTime):
        self._ResultSetFileUrlExpireTime = ResultSetFileUrlExpireTime


    def _deserialize(self, params):
        if params.get("ResultSet") is not None:
            self._ResultSet = []
            for item in params.get("ResultSet"):
                obj = AiRecognitionTaskObjectResultItem()
                obj._deserialize(item)
                self._ResultSet.append(obj)
        self._ResultSetFileUrl = params.get("ResultSetFileUrl")
        self._ResultSetFileUrlExpireTime = params.get("ResultSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskObjectSegmentItem(AbstractModel):
    r"""物体识别结果片段。

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: 识别片段起始的偏移时间，单位：秒。
        :type StartTimeOffset: float
        :param _EndTimeOffset: 识别片段终止的偏移时间，单位：秒。
        :type EndTimeOffset: float
        :param _Confidence: 识别片段置信度。取值：0~100。
        :type Confidence: float
        :param _AreaCoordSet: 识别结果的区域坐标。数组包含 4 个元素 [x1,y1,x2,y2]，依次表示区域左上点、右下点的横纵坐标。
        :type AreaCoordSet: list of int
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Confidence = None
        self._AreaCoordSet = None

    @property
    def StartTimeOffset(self):
        r"""识别片段起始的偏移时间，单位：秒。
        :rtype: float
        """
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        r"""识别片段终止的偏移时间，单位：秒。
        :rtype: float
        """
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Confidence(self):
        r"""识别片段置信度。取值：0~100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def AreaCoordSet(self):
        r"""识别结果的区域坐标。数组包含 4 个元素 [x1,y1,x2,y2]，依次表示区域左上点、右下点的横纵坐标。
        :rtype: list of int
        """
        return self._AreaCoordSet

    @AreaCoordSet.setter
    def AreaCoordSet(self, AreaCoordSet):
        self._AreaCoordSet = AreaCoordSet


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Confidence = params.get("Confidence")
        self._AreaCoordSet = params.get("AreaCoordSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskObjectSeqmentItem(AbstractModel):
    r"""物体识别结果片段。

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: 识别片段起始的偏移时间，单位：秒。
        :type StartTimeOffset: float
        :param _EndTimeOffset: 识别片段终止的偏移时间，单位：秒。
        :type EndTimeOffset: float
        :param _Confidence: 识别片段置信度。取值：0~100。
        :type Confidence: float
        :param _AreaCoordSet: 识别结果的区域坐标。数组包含 4 个元素 [x1,y1,x2,y2]，依次表示区域左上点、右下点的横纵坐标。
        :type AreaCoordSet: list of int
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Confidence = None
        self._AreaCoordSet = None

    @property
    def StartTimeOffset(self):
        r"""识别片段起始的偏移时间，单位：秒。
        :rtype: float
        """
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        r"""识别片段终止的偏移时间，单位：秒。
        :rtype: float
        """
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Confidence(self):
        r"""识别片段置信度。取值：0~100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def AreaCoordSet(self):
        r"""识别结果的区域坐标。数组包含 4 个元素 [x1,y1,x2,y2]，依次表示区域左上点、右下点的横纵坐标。
        :rtype: list of int
        """
        return self._AreaCoordSet

    @AreaCoordSet.setter
    def AreaCoordSet(self, AreaCoordSet):
        self._AreaCoordSet = AreaCoordSet


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Confidence = params.get("Confidence")
        self._AreaCoordSet = params.get("AreaCoordSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrFullTextResult(AbstractModel):
    r"""文本全文识别结果。

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 文本全文识别任务输入信息。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskOcrFullTextResultInput`
        :param _Output: 文本全文识别任务输出信息。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskOcrFullTextResultOutput`
        :param _Progress: 文本全文识别任务进度，取值范围 [0-100] 。
        :type Progress: int
        :param _BeginProcessTime: 文本全文识别任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type BeginProcessTime: str
        :param _FinishTime: 文本全文识别任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""文本全文识别任务输入信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskOcrFullTextResultInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""文本全文识别任务输出信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskOcrFullTextResultOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        r"""文本全文识别任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def BeginProcessTime(self):
        r"""文本全文识别任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        r"""文本全文识别任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskOcrFullTextResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskOcrFullTextResultOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrFullTextResultInput(AbstractModel):
    r"""文本全文识别输入。

    """

    def __init__(self):
        r"""
        :param _Definition: 文本全文识别模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""文本全文识别模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrFullTextResultOutput(AbstractModel):
    r"""文本全文识别输出。

    """

    def __init__(self):
        r"""
        :param _SegmentSet: 文本全文识别结果集。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :type SegmentSet: list of AiRecognitionTaskOcrFullTextSegmentItem
        :param _SegmentSetFileUrl: 文本全文识别结果集文件 URL。文件的内容为 JSON，数据结构与 ResultSet 字段一致。 （文件不会永久存储，到达SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :type SegmentSetFileUrl: str
        :param _SegmentSetFileUrlExpireTime: 文本全文识别结果集文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type SegmentSetFileUrlExpireTime: str
        """
        self._SegmentSet = None
        self._SegmentSetFileUrl = None
        self._SegmentSetFileUrlExpireTime = None

    @property
    def SegmentSet(self):
        r"""文本全文识别结果集。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :rtype: list of AiRecognitionTaskOcrFullTextSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SegmentSetFileUrl(self):
        r"""文本全文识别结果集文件 URL。文件的内容为 JSON，数据结构与 ResultSet 字段一致。 （文件不会永久存储，到达SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._SegmentSetFileUrl

    @SegmentSetFileUrl.setter
    def SegmentSetFileUrl(self, SegmentSetFileUrl):
        self._SegmentSetFileUrl = SegmentSetFileUrl

    @property
    def SegmentSetFileUrlExpireTime(self):
        r"""文本全文识别结果集文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._SegmentSetFileUrlExpireTime

    @SegmentSetFileUrlExpireTime.setter
    def SegmentSetFileUrlExpireTime(self, SegmentSetFileUrlExpireTime):
        self._SegmentSetFileUrlExpireTime = SegmentSetFileUrlExpireTime


    def _deserialize(self, params):
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskOcrFullTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SegmentSetFileUrl = params.get("SegmentSetFileUrl")
        self._SegmentSetFileUrlExpireTime = params.get("SegmentSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrFullTextSegmentItem(AbstractModel):
    r"""文本全文识别片段。

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: 识别片段起始的偏移时间，单位：秒。
        :type StartTimeOffset: float
        :param _EndTimeOffset: 识别片段终止的偏移时间，单位：秒。
        :type EndTimeOffset: float
        :param _TextSet: 识别片段结果集。
        :type TextSet: list of AiRecognitionTaskOcrFullTextSegmentTextItem
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._TextSet = None

    @property
    def StartTimeOffset(self):
        r"""识别片段起始的偏移时间，单位：秒。
        :rtype: float
        """
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        r"""识别片段终止的偏移时间，单位：秒。
        :rtype: float
        """
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def TextSet(self):
        r"""识别片段结果集。
        :rtype: list of AiRecognitionTaskOcrFullTextSegmentTextItem
        """
        return self._TextSet

    @TextSet.setter
    def TextSet(self, TextSet):
        self._TextSet = TextSet


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        if params.get("TextSet") is not None:
            self._TextSet = []
            for item in params.get("TextSet"):
                obj = AiRecognitionTaskOcrFullTextSegmentTextItem()
                obj._deserialize(item)
                self._TextSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrFullTextSegmentTextItem(AbstractModel):
    r"""文本全文识别片段。

    """

    def __init__(self):
        r"""
        :param _Confidence: 识别片段置信度。取值：0~100。
        :type Confidence: float
        :param _AreaCoordSet: 识别结果的区域坐标。数组包含 4 个元素 [x1,y1,x2,y2]，依次表示区域左上点、右下点的横纵坐标。
        :type AreaCoordSet: list of int
        :param _Text: 识别文本。
        :type Text: str
        """
        self._Confidence = None
        self._AreaCoordSet = None
        self._Text = None

    @property
    def Confidence(self):
        r"""识别片段置信度。取值：0~100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def AreaCoordSet(self):
        r"""识别结果的区域坐标。数组包含 4 个元素 [x1,y1,x2,y2]，依次表示区域左上点、右下点的横纵坐标。
        :rtype: list of int
        """
        return self._AreaCoordSet

    @AreaCoordSet.setter
    def AreaCoordSet(self, AreaCoordSet):
        self._AreaCoordSet = AreaCoordSet

    @property
    def Text(self):
        r"""识别文本。
        :rtype: str
        """
        return self._Text

    @Text.setter
    def Text(self, Text):
        self._Text = Text


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._AreaCoordSet = params.get("AreaCoordSet")
        self._Text = params.get("Text")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrWordsResult(AbstractModel):
    r"""文本关键识别结果。

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 文本关键词识别任务输入信息。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskOcrWordsResultInput`
        :param _Output: 文本关键词识别任务输出信息。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskOcrWordsResultOutput`
        :param _Progress: 文本关键词识别任务进度，取值范围 [0-100] 。
        :type Progress: int
        :param _BeginProcessTime: 文本关键词识别任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type BeginProcessTime: str
        :param _FinishTime: 文本关键词识别任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""文本关键词识别任务输入信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskOcrWordsResultInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""文本关键词识别任务输出信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskOcrWordsResultOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        r"""文本关键词识别任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def BeginProcessTime(self):
        r"""文本关键词识别任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        r"""文本关键词识别任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskOcrWordsResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskOcrWordsResultOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrWordsResultInput(AbstractModel):
    r"""文本关键词识别输入。

    """

    def __init__(self):
        r"""
        :param _Definition: 文本关键词识别模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""文本关键词识别模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrWordsResultItem(AbstractModel):
    r"""文本关键词识别结果。

    """

    def __init__(self):
        r"""
        :param _Word: 文本关键词。
        :type Word: str
        :param _SegmentSet: 文本关键出现的片段列表。
        :type SegmentSet: list of AiRecognitionTaskOcrWordsSegmentItem
        """
        self._Word = None
        self._SegmentSet = None

    @property
    def Word(self):
        r"""文本关键词。
        :rtype: str
        """
        return self._Word

    @Word.setter
    def Word(self, Word):
        self._Word = Word

    @property
    def SegmentSet(self):
        r"""文本关键出现的片段列表。
        :rtype: list of AiRecognitionTaskOcrWordsSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Word = params.get("Word")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskOcrWordsSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrWordsResultOutput(AbstractModel):
    r"""文本关键词识别输出。

    """

    def __init__(self):
        r"""
        :param _ResultSet: 文本关键词识别结果集。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 ResultSetFileUrl 对应的文件中获取。
        :type ResultSet: list of AiRecognitionTaskOcrWordsResultItem
        :param _ResultSetFileUrl: 文本关键词识别结果集文件 URL。文件的内容为 JSON，数据结构与 ResultSet 字段一致。 （文件不会永久存储，到达ResultSetFileUrlExpireTime 时间点后文件将被删除）。
        :type ResultSetFileUrl: str
        :param _ResultSetFileUrlExpireTime: 文本关键词识别结果集文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type ResultSetFileUrlExpireTime: str
        """
        self._ResultSet = None
        self._ResultSetFileUrl = None
        self._ResultSetFileUrlExpireTime = None

    @property
    def ResultSet(self):
        r"""文本关键词识别结果集。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 ResultSetFileUrl 对应的文件中获取。
        :rtype: list of AiRecognitionTaskOcrWordsResultItem
        """
        return self._ResultSet

    @ResultSet.setter
    def ResultSet(self, ResultSet):
        self._ResultSet = ResultSet

    @property
    def ResultSetFileUrl(self):
        r"""文本关键词识别结果集文件 URL。文件的内容为 JSON，数据结构与 ResultSet 字段一致。 （文件不会永久存储，到达ResultSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._ResultSetFileUrl

    @ResultSetFileUrl.setter
    def ResultSetFileUrl(self, ResultSetFileUrl):
        self._ResultSetFileUrl = ResultSetFileUrl

    @property
    def ResultSetFileUrlExpireTime(self):
        r"""文本关键词识别结果集文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._ResultSetFileUrlExpireTime

    @ResultSetFileUrlExpireTime.setter
    def ResultSetFileUrlExpireTime(self, ResultSetFileUrlExpireTime):
        self._ResultSetFileUrlExpireTime = ResultSetFileUrlExpireTime


    def _deserialize(self, params):
        if params.get("ResultSet") is not None:
            self._ResultSet = []
            for item in params.get("ResultSet"):
                obj = AiRecognitionTaskOcrWordsResultItem()
                obj._deserialize(item)
                self._ResultSet.append(obj)
        self._ResultSetFileUrl = params.get("ResultSetFileUrl")
        self._ResultSetFileUrlExpireTime = params.get("ResultSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrWordsSegmentItem(AbstractModel):
    r"""文本识别片段。

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: 识别片段起始的偏移时间，单位：秒。
        :type StartTimeOffset: float
        :param _EndTimeOffset: 识别片段终止的偏移时间，单位：秒。
        :type EndTimeOffset: float
        :param _Confidence: 识别片段置信度。取值：0~100。
        :type Confidence: float
        :param _AreaCoordSet: 识别结果的区域坐标。数组包含 4 个元素 [x1,y1,x2,y2]，依次表示区域左上点、右下点的横纵坐标。
        :type AreaCoordSet: list of int
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Confidence = None
        self._AreaCoordSet = None

    @property
    def StartTimeOffset(self):
        r"""识别片段起始的偏移时间，单位：秒。
        :rtype: float
        """
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        r"""识别片段终止的偏移时间，单位：秒。
        :rtype: float
        """
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Confidence(self):
        r"""识别片段置信度。取值：0~100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def AreaCoordSet(self):
        r"""识别结果的区域坐标。数组包含 4 个元素 [x1,y1,x2,y2]，依次表示区域左上点、右下点的横纵坐标。
        :rtype: list of int
        """
        return self._AreaCoordSet

    @AreaCoordSet.setter
    def AreaCoordSet(self, AreaCoordSet):
        self._AreaCoordSet = AreaCoordSet


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Confidence = params.get("Confidence")
        self._AreaCoordSet = params.get("AreaCoordSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskSegmentResult(AbstractModel):
    r"""视频拆条结果。

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 视频拆条任务输入信息。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskSegmentResultInput`
        :param _Output: 视频拆条任务输出信息。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskSegmentResultOutput`
        :param _Progress: 视频拆条任务进度，取值范围 [0-100] 。
        :type Progress: int
        :param _BeginProcessTime: 视频拆条任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type BeginProcessTime: str
        :param _FinishTime: 视频拆条任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""视频拆条任务输入信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskSegmentResultInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""视频拆条任务输出信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskSegmentResultOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        r"""视频拆条任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def BeginProcessTime(self):
        r"""视频拆条任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        r"""视频拆条任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskSegmentResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskSegmentResultOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskSegmentResultInput(AbstractModel):
    r"""视频拆条输入。

    """

    def __init__(self):
        r"""
        :param _Definition: 视频拆条模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""视频拆条模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskSegmentResultOutput(AbstractModel):
    r"""视频拆条输出。

    """

    def __init__(self):
        r"""
        :param _SegmentSet: 视频拆条片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :type SegmentSet: list of AiRecognitionTaskSegmentSegmentItem
        :param _SegmentSetFileUrl: 视频拆条片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :type SegmentSetFileUrl: str
        :param _SegmentSetFileUrlExpireTime: 视频拆条片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type SegmentSetFileUrlExpireTime: str
        """
        self._SegmentSet = None
        self._SegmentSetFileUrl = None
        self._SegmentSetFileUrlExpireTime = None

    @property
    def SegmentSet(self):
        r"""视频拆条片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :rtype: list of AiRecognitionTaskSegmentSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SegmentSetFileUrl(self):
        r"""视频拆条片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._SegmentSetFileUrl

    @SegmentSetFileUrl.setter
    def SegmentSetFileUrl(self, SegmentSetFileUrl):
        self._SegmentSetFileUrl = SegmentSetFileUrl

    @property
    def SegmentSetFileUrlExpireTime(self):
        r"""视频拆条片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._SegmentSetFileUrlExpireTime

    @SegmentSetFileUrlExpireTime.setter
    def SegmentSetFileUrlExpireTime(self, SegmentSetFileUrlExpireTime):
        self._SegmentSetFileUrlExpireTime = SegmentSetFileUrlExpireTime


    def _deserialize(self, params):
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskSegmentSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SegmentSetFileUrl = params.get("SegmentSetFileUrl")
        self._SegmentSetFileUrlExpireTime = params.get("SegmentSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskSegmentSegmentItem(AbstractModel):
    r"""视频拆条片段。

    """

    def __init__(self):
        r"""
        :param _FileId: 文件 ID。仅当处理的是点播文件并且拆条生成的子片段为点播文件时有效。
        :type FileId: str
        :param _SegmentUrl: 视频拆条片段 Url。
        :type SegmentUrl: str
        :param _Confidence: 拆条片段置信度。取值：0~100。
        :type Confidence: float
        :param _StartTimeOffset: 拆条片段起始的偏移时间，单位：秒。
        :type StartTimeOffset: float
        :param _EndTimeOffset: 拆条片段终止的偏移时间，单位：秒。
        :type EndTimeOffset: float
        :param _CovImgUrl: 拆条封面图片 Url。
        :type CovImgUrl: str
        :param _SpecialInfo: 特殊字段，请忽略。
        :type SpecialInfo: str
        """
        self._FileId = None
        self._SegmentUrl = None
        self._Confidence = None
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._CovImgUrl = None
        self._SpecialInfo = None

    @property
    def FileId(self):
        r"""文件 ID。仅当处理的是点播文件并且拆条生成的子片段为点播文件时有效。
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def SegmentUrl(self):
        r"""视频拆条片段 Url。
        :rtype: str
        """
        return self._SegmentUrl

    @SegmentUrl.setter
    def SegmentUrl(self, SegmentUrl):
        self._SegmentUrl = SegmentUrl

    @property
    def Confidence(self):
        r"""拆条片段置信度。取值：0~100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def StartTimeOffset(self):
        r"""拆条片段起始的偏移时间，单位：秒。
        :rtype: float
        """
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        r"""拆条片段终止的偏移时间，单位：秒。
        :rtype: float
        """
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def CovImgUrl(self):
        r"""拆条封面图片 Url。
        :rtype: str
        """
        return self._CovImgUrl

    @CovImgUrl.setter
    def CovImgUrl(self, CovImgUrl):
        self._CovImgUrl = CovImgUrl

    @property
    def SpecialInfo(self):
        r"""特殊字段，请忽略。
        :rtype: str
        """
        return self._SpecialInfo

    @SpecialInfo.setter
    def SpecialInfo(self, SpecialInfo):
        self._SpecialInfo = SpecialInfo


    def _deserialize(self, params):
        self._FileId = params.get("FileId")
        self._SegmentUrl = params.get("SegmentUrl")
        self._Confidence = params.get("Confidence")
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._CovImgUrl = params.get("CovImgUrl")
        self._SpecialInfo = params.get("SpecialInfo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPoliticalAsrTaskInput(AbstractModel):
    r"""音视频审核 Asr 文字涉及令人不适宜的信息、违规任务输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 鉴别涉及令人不适宜信息的模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""鉴别涉及令人不适宜信息的模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPoliticalAsrTaskOutput(AbstractModel):
    r"""Asr 文字涉及令人不适宜的信息

    """

    def __init__(self):
        r"""
        :param _Confidence: Asr 文字涉及令人不适宜的信息、违规评分，分值为0到100。
        :type Confidence: float
        :param _Suggestion: Asr 文字涉及令人不适宜的信息、违规结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :type Suggestion: str
        :param _SegmentSet: Asr 文字有涉及令人不适宜的信息、违规嫌疑的视频片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :type SegmentSet: list of MediaContentReviewAsrTextSegmentItem
        :param _SegmentSetFileUrl: Asr 文字有涉及令人不适宜的信息、违规嫌疑的视频片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达 SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :type SegmentSetFileUrl: str
        :param _SegmentSetFileUrlExpireTime: Asr 文字有涉及令人不适宜的信息、违规嫌疑的视频片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type SegmentSetFileUrlExpireTime: str
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None
        self._SegmentSetFileUrl = None
        self._SegmentSetFileUrlExpireTime = None

    @property
    def Confidence(self):
        r"""Asr 文字涉及令人不适宜的信息、违规评分，分值为0到100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        r"""Asr 文字涉及令人不适宜的信息、违规结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :rtype: str
        """
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        r"""Asr 文字有涉及令人不适宜的信息、违规嫌疑的视频片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :rtype: list of MediaContentReviewAsrTextSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SegmentSetFileUrl(self):
        r"""Asr 文字有涉及令人不适宜的信息、违规嫌疑的视频片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达 SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._SegmentSetFileUrl

    @SegmentSetFileUrl.setter
    def SegmentSetFileUrl(self, SegmentSetFileUrl):
        self._SegmentSetFileUrl = SegmentSetFileUrl

    @property
    def SegmentSetFileUrlExpireTime(self):
        r"""Asr 文字有涉及令人不适宜的信息、违规嫌疑的视频片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._SegmentSetFileUrlExpireTime

    @SegmentSetFileUrlExpireTime.setter
    def SegmentSetFileUrlExpireTime(self, SegmentSetFileUrlExpireTime):
        self._SegmentSetFileUrlExpireTime = SegmentSetFileUrlExpireTime


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewAsrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SegmentSetFileUrl = params.get("SegmentSetFileUrl")
        self._SegmentSetFileUrlExpireTime = params.get("SegmentSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPoliticalOcrTaskInput(AbstractModel):
    r"""音视频审核 Ocr 文字涉及令人不适宜信息的任务输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 鉴别涉及令人不适宜信息的模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""鉴别涉及令人不适宜信息的模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPoliticalOcrTaskOutput(AbstractModel):
    r"""Ocr 文字涉及令人不适宜的信息

    """

    def __init__(self):
        r"""
        :param _Confidence: Ocr 文字涉及令人不适宜的信息、违规评分，分值为0到100。
        :type Confidence: float
        :param _Suggestion: Ocr 文字涉及令人不适宜的信息、违规结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :type Suggestion: str
        :param _SegmentSet: Ocr 文字有涉及令人不适宜的信息、违规嫌疑的视频片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :type SegmentSet: list of MediaContentReviewOcrTextSegmentItem
        :param _SegmentSetFileUrl: Ocr 文字有涉及令人不适宜的信息、违规嫌疑的视频片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达 SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :type SegmentSetFileUrl: str
        :param _SegmentSetFileUrlExpireTime: Ocr 文字有涉及令人不适宜的信息、违规嫌疑的视频片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type SegmentSetFileUrlExpireTime: str
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None
        self._SegmentSetFileUrl = None
        self._SegmentSetFileUrlExpireTime = None

    @property
    def Confidence(self):
        r"""Ocr 文字涉及令人不适宜的信息、违规评分，分值为0到100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        r"""Ocr 文字涉及令人不适宜的信息、违规结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :rtype: str
        """
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        r"""Ocr 文字有涉及令人不适宜的信息、违规嫌疑的视频片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :rtype: list of MediaContentReviewOcrTextSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SegmentSetFileUrl(self):
        r"""Ocr 文字有涉及令人不适宜的信息、违规嫌疑的视频片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达 SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._SegmentSetFileUrl

    @SegmentSetFileUrl.setter
    def SegmentSetFileUrl(self, SegmentSetFileUrl):
        self._SegmentSetFileUrl = SegmentSetFileUrl

    @property
    def SegmentSetFileUrlExpireTime(self):
        r"""Ocr 文字有涉及令人不适宜的信息、违规嫌疑的视频片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._SegmentSetFileUrlExpireTime

    @SegmentSetFileUrlExpireTime.setter
    def SegmentSetFileUrlExpireTime(self, SegmentSetFileUrlExpireTime):
        self._SegmentSetFileUrlExpireTime = SegmentSetFileUrlExpireTime


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewOcrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SegmentSetFileUrl = params.get("SegmentSetFileUrl")
        self._SegmentSetFileUrlExpireTime = params.get("SegmentSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPoliticalTaskInput(AbstractModel):
    r"""音视频审核涉及令人不适宜信息的任务输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 鉴别涉及令人不适宜信息的模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""鉴别涉及令人不适宜信息的模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPoliticalTaskOutput(AbstractModel):
    r"""涉及令人不适宜的信息

    """

    def __init__(self):
        r"""
        :param _Confidence: 视频涉及令人不适宜信息的评分，分值为0到100。
        :type Confidence: float
        :param _Suggestion: 涉及令人不适宜信息的结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :type Suggestion: str
        :param _Label: 视频涉及令人不适宜信息的结果标签。音视频审核模板[画面鉴政任务控制参数](https://cloud.tencent.com/document/api/266/31773#PoliticalImgReviewTemplateInfo)里 LabelSet 参数与此参数取值范围的对应关系：
violation_photo：
<li>violation_photo：违规图标。</li>
其他（即 politician/entertainment/sport/entrepreneur/scholar/celebrity/military）：
<li>politician：相关人物。</li>
        :type Label: str
        :param _SegmentSet: 有涉及令人不适宜信息嫌疑的视频片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :type SegmentSet: list of MediaContentReviewPoliticalSegmentItem
        :param _SegmentSetFileUrl: 有涉及令人不适宜的信息嫌疑的视频片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达 SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :type SegmentSetFileUrl: str
        :param _SegmentSetFileUrlExpireTime: 有涉及令人不适宜的信息嫌疑的视频片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type SegmentSetFileUrlExpireTime: str
        """
        self._Confidence = None
        self._Suggestion = None
        self._Label = None
        self._SegmentSet = None
        self._SegmentSetFileUrl = None
        self._SegmentSetFileUrlExpireTime = None

    @property
    def Confidence(self):
        r"""视频涉及令人不适宜信息的评分，分值为0到100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        r"""涉及令人不适宜信息的结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :rtype: str
        """
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def Label(self):
        r"""视频涉及令人不适宜信息的结果标签。音视频审核模板[画面鉴政任务控制参数](https://cloud.tencent.com/document/api/266/31773#PoliticalImgReviewTemplateInfo)里 LabelSet 参数与此参数取值范围的对应关系：
violation_photo：
<li>violation_photo：违规图标。</li>
其他（即 politician/entertainment/sport/entrepreneur/scholar/celebrity/military）：
<li>politician：相关人物。</li>
        :rtype: str
        """
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label

    @property
    def SegmentSet(self):
        r"""有涉及令人不适宜信息嫌疑的视频片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :rtype: list of MediaContentReviewPoliticalSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SegmentSetFileUrl(self):
        r"""有涉及令人不适宜的信息嫌疑的视频片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达 SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._SegmentSetFileUrl

    @SegmentSetFileUrl.setter
    def SegmentSetFileUrl(self, SegmentSetFileUrl):
        self._SegmentSetFileUrl = SegmentSetFileUrl

    @property
    def SegmentSetFileUrlExpireTime(self):
        r"""有涉及令人不适宜的信息嫌疑的视频片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._SegmentSetFileUrlExpireTime

    @SegmentSetFileUrlExpireTime.setter
    def SegmentSetFileUrlExpireTime(self, SegmentSetFileUrlExpireTime):
        self._SegmentSetFileUrlExpireTime = SegmentSetFileUrlExpireTime


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        self._Label = params.get("Label")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewPoliticalSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SegmentSetFileUrl = params.get("SegmentSetFileUrl")
        self._SegmentSetFileUrlExpireTime = params.get("SegmentSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPornAsrTaskInput(AbstractModel):
    r"""音视频审核 Asr 文字涉及令人反感的信息的任务输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 鉴别涉及令人反感的信息的模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""鉴别涉及令人反感的信息的模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPornAsrTaskOutput(AbstractModel):
    r"""Asr 文字涉及令人反感的信息

    """

    def __init__(self):
        r"""
        :param _Confidence: Asr 文字涉及令人反感的信息的评分，分值为0到100。
        :type Confidence: float
        :param _Suggestion: Asr 文字涉及令人反感的信息的结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :type Suggestion: str
        :param _SegmentSet: Asr 文字有涉及令人反感的信息的嫌疑的视频片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :type SegmentSet: list of MediaContentReviewAsrTextSegmentItem
        :param _SegmentSetFileUrl: Asr 文字有涉及令人反感的信息的嫌疑的视频片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达 SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :type SegmentSetFileUrl: str
        :param _SegmentSetFileUrlExpireTime: Asr 文字有涉及令人反感的信息的嫌疑的视频片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type SegmentSetFileUrlExpireTime: str
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None
        self._SegmentSetFileUrl = None
        self._SegmentSetFileUrlExpireTime = None

    @property
    def Confidence(self):
        r"""Asr 文字涉及令人反感的信息的评分，分值为0到100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        r"""Asr 文字涉及令人反感的信息的结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :rtype: str
        """
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        r"""Asr 文字有涉及令人反感的信息的嫌疑的视频片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :rtype: list of MediaContentReviewAsrTextSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SegmentSetFileUrl(self):
        r"""Asr 文字有涉及令人反感的信息的嫌疑的视频片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达 SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._SegmentSetFileUrl

    @SegmentSetFileUrl.setter
    def SegmentSetFileUrl(self, SegmentSetFileUrl):
        self._SegmentSetFileUrl = SegmentSetFileUrl

    @property
    def SegmentSetFileUrlExpireTime(self):
        r"""Asr 文字有涉及令人反感的信息的嫌疑的视频片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._SegmentSetFileUrlExpireTime

    @SegmentSetFileUrlExpireTime.setter
    def SegmentSetFileUrlExpireTime(self, SegmentSetFileUrlExpireTime):
        self._SegmentSetFileUrlExpireTime = SegmentSetFileUrlExpireTime


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewAsrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SegmentSetFileUrl = params.get("SegmentSetFileUrl")
        self._SegmentSetFileUrlExpireTime = params.get("SegmentSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPornOcrTaskInput(AbstractModel):
    r"""音视频审核 Ocr 文字涉及令人反感的信息的任务输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 鉴别涉及令人反感的信息的模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""鉴别涉及令人反感的信息的模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPornOcrTaskOutput(AbstractModel):
    r"""Ocr 文字涉及令人反感的信息

    """

    def __init__(self):
        r"""
        :param _Confidence: Ocr 文字涉及令人反感的信息的评分，分值为0到100。
        :type Confidence: float
        :param _Suggestion: Ocr 文字涉及令人反感的信息的结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :type Suggestion: str
        :param _SegmentSet: Ocr 文字有涉及令人反感的信息的嫌疑的视频片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :type SegmentSet: list of MediaContentReviewOcrTextSegmentItem
        :param _SegmentSetFileUrl: Ocr 文字有涉及令人反感的信息的嫌疑的视频片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达 SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :type SegmentSetFileUrl: str
        :param _SegmentSetFileUrlExpireTime: Ocr 文字有涉及令人反感的信息的嫌疑的视频片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type SegmentSetFileUrlExpireTime: str
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None
        self._SegmentSetFileUrl = None
        self._SegmentSetFileUrlExpireTime = None

    @property
    def Confidence(self):
        r"""Ocr 文字涉及令人反感的信息的评分，分值为0到100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        r"""Ocr 文字涉及令人反感的信息的结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :rtype: str
        """
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        r"""Ocr 文字有涉及令人反感的信息的嫌疑的视频片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :rtype: list of MediaContentReviewOcrTextSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SegmentSetFileUrl(self):
        r"""Ocr 文字有涉及令人反感的信息的嫌疑的视频片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达 SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._SegmentSetFileUrl

    @SegmentSetFileUrl.setter
    def SegmentSetFileUrl(self, SegmentSetFileUrl):
        self._SegmentSetFileUrl = SegmentSetFileUrl

    @property
    def SegmentSetFileUrlExpireTime(self):
        r"""Ocr 文字有涉及令人反感的信息的嫌疑的视频片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._SegmentSetFileUrlExpireTime

    @SegmentSetFileUrlExpireTime.setter
    def SegmentSetFileUrlExpireTime(self, SegmentSetFileUrlExpireTime):
        self._SegmentSetFileUrlExpireTime = SegmentSetFileUrlExpireTime


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewOcrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SegmentSetFileUrl = params.get("SegmentSetFileUrl")
        self._SegmentSetFileUrlExpireTime = params.get("SegmentSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPornTaskInput(AbstractModel):
    r"""音视频审核涉及令人反感的信息的任务输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 鉴别涉及令人反感的信息的模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""鉴别涉及令人反感的信息的模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPornTaskOutput(AbstractModel):
    r"""鉴别涉及令人反感的信息的结果信息

    """

    def __init__(self):
        r"""
        :param _Confidence: 视频鉴别涉及令人反感的信息的评分，分值为0到100。
        :type Confidence: float
        :param _Suggestion: 鉴别涉及令人反感的信息的结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :type Suggestion: str
        :param _Label: 视频鉴别涉及令人反感的信息的结果标签，取值范围：
<li>porn：色情。</li>
<li>sexy：性感。</li>
<li>vulgar：低俗。</li>
<li>intimacy：亲密行为。</li>
        :type Label: str
        :param _SegmentSet: 有涉及令人反感的信息的嫌疑的视频片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :type SegmentSet: list of MediaContentReviewSegmentItem
        :param _SegmentSetFileUrl: 涉及令人反感的信息的嫌疑的视频片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :type SegmentSetFileUrl: str
        :param _SegmentSetFileUrlExpireTime: 涉及令人反感的信息的嫌疑的视频片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type SegmentSetFileUrlExpireTime: str
        """
        self._Confidence = None
        self._Suggestion = None
        self._Label = None
        self._SegmentSet = None
        self._SegmentSetFileUrl = None
        self._SegmentSetFileUrlExpireTime = None

    @property
    def Confidence(self):
        r"""视频鉴别涉及令人反感的信息的评分，分值为0到100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        r"""鉴别涉及令人反感的信息的结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :rtype: str
        """
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def Label(self):
        r"""视频鉴别涉及令人反感的信息的结果标签，取值范围：
<li>porn：色情。</li>
<li>sexy：性感。</li>
<li>vulgar：低俗。</li>
<li>intimacy：亲密行为。</li>
        :rtype: str
        """
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label

    @property
    def SegmentSet(self):
        r"""有涉及令人反感的信息的嫌疑的视频片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :rtype: list of MediaContentReviewSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SegmentSetFileUrl(self):
        r"""涉及令人反感的信息的嫌疑的视频片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._SegmentSetFileUrl

    @SegmentSetFileUrl.setter
    def SegmentSetFileUrl(self, SegmentSetFileUrl):
        self._SegmentSetFileUrl = SegmentSetFileUrl

    @property
    def SegmentSetFileUrlExpireTime(self):
        r"""涉及令人反感的信息的嫌疑的视频片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._SegmentSetFileUrlExpireTime

    @SegmentSetFileUrlExpireTime.setter
    def SegmentSetFileUrlExpireTime(self, SegmentSetFileUrlExpireTime):
        self._SegmentSetFileUrlExpireTime = SegmentSetFileUrlExpireTime


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        self._Label = params.get("Label")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SegmentSetFileUrl = params.get("SegmentSetFileUrl")
        self._SegmentSetFileUrlExpireTime = params.get("SegmentSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewProhibitedAsrTaskInput(AbstractModel):
    r"""音视频审核 Asr 文字鉴违禁任务输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 鉴违禁模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""鉴违禁模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewProhibitedAsrTaskOutput(AbstractModel):
    r"""Asr 文字涉违禁信息

    """

    def __init__(self):
        r"""
        :param _Confidence: Asr 文字涉违禁评分，分值为0到100。
        :type Confidence: float
        :param _Suggestion: Asr 文字涉违禁结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :type Suggestion: str
        :param _SegmentSet: Asr 文字有涉违禁嫌疑的视频片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :type SegmentSet: list of MediaContentReviewAsrTextSegmentItem
        :param _SegmentSetFileUrl: Asr 文字有涉违禁嫌疑的视频片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达 SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :type SegmentSetFileUrl: str
        :param _SegmentSetFileUrlExpireTime: Asr 文字有涉违禁嫌疑的视频片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type SegmentSetFileUrlExpireTime: str
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None
        self._SegmentSetFileUrl = None
        self._SegmentSetFileUrlExpireTime = None

    @property
    def Confidence(self):
        r"""Asr 文字涉违禁评分，分值为0到100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        r"""Asr 文字涉违禁结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :rtype: str
        """
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        r"""Asr 文字有涉违禁嫌疑的视频片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :rtype: list of MediaContentReviewAsrTextSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SegmentSetFileUrl(self):
        r"""Asr 文字有涉违禁嫌疑的视频片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达 SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._SegmentSetFileUrl

    @SegmentSetFileUrl.setter
    def SegmentSetFileUrl(self, SegmentSetFileUrl):
        self._SegmentSetFileUrl = SegmentSetFileUrl

    @property
    def SegmentSetFileUrlExpireTime(self):
        r"""Asr 文字有涉违禁嫌疑的视频片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._SegmentSetFileUrlExpireTime

    @SegmentSetFileUrlExpireTime.setter
    def SegmentSetFileUrlExpireTime(self, SegmentSetFileUrlExpireTime):
        self._SegmentSetFileUrlExpireTime = SegmentSetFileUrlExpireTime


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewAsrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SegmentSetFileUrl = params.get("SegmentSetFileUrl")
        self._SegmentSetFileUrlExpireTime = params.get("SegmentSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewProhibitedOcrTaskInput(AbstractModel):
    r"""音视频审核 Ocr 文字鉴违禁任务输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 鉴违禁模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""鉴违禁模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewProhibitedOcrTaskOutput(AbstractModel):
    r"""Ocr 文字涉违禁信息

    """

    def __init__(self):
        r"""
        :param _Confidence: Ocr 文字涉违禁评分，分值为0到100。
        :type Confidence: float
        :param _Suggestion: Ocr 文字涉违禁结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :type Suggestion: str
        :param _SegmentSet: Ocr 文字有涉违禁嫌疑的视频片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :type SegmentSet: list of MediaContentReviewOcrTextSegmentItem
        :param _SegmentSetFileUrl: Ocr 文字有涉违禁嫌疑的视频片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达 SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :type SegmentSetFileUrl: str
        :param _SegmentSetFileUrlExpireTime: Ocr 文字有涉违禁嫌疑的视频片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type SegmentSetFileUrlExpireTime: str
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None
        self._SegmentSetFileUrl = None
        self._SegmentSetFileUrlExpireTime = None

    @property
    def Confidence(self):
        r"""Ocr 文字涉违禁评分，分值为0到100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        r"""Ocr 文字涉违禁结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :rtype: str
        """
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        r"""Ocr 文字有涉违禁嫌疑的视频片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :rtype: list of MediaContentReviewOcrTextSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SegmentSetFileUrl(self):
        r"""Ocr 文字有涉违禁嫌疑的视频片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达 SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._SegmentSetFileUrl

    @SegmentSetFileUrl.setter
    def SegmentSetFileUrl(self, SegmentSetFileUrl):
        self._SegmentSetFileUrl = SegmentSetFileUrl

    @property
    def SegmentSetFileUrlExpireTime(self):
        r"""Ocr 文字有涉违禁嫌疑的视频片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._SegmentSetFileUrlExpireTime

    @SegmentSetFileUrlExpireTime.setter
    def SegmentSetFileUrlExpireTime(self, SegmentSetFileUrlExpireTime):
        self._SegmentSetFileUrlExpireTime = SegmentSetFileUrlExpireTime


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewOcrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SegmentSetFileUrl = params.get("SegmentSetFileUrl")
        self._SegmentSetFileUrlExpireTime = params.get("SegmentSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskPoliticalAsrResult(AbstractModel):
    r"""音视频审核 Asr 文字涉及令人不适宜信息、违规任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 音视频审核 Asr 文字涉及令人不适宜信息的任务输入。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiReviewPoliticalAsrTaskInput`
        :param _Output: 音视频审核 Asr 文字涉及令人不适宜信息的任务输出。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiReviewPoliticalAsrTaskOutput`
        :param _Progress: 音视频审核 Asr 文字涉及令人不适宜信息的任务进度，取值范围 [0-100] 。
        :type Progress: int
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""音视频审核 Asr 文字涉及令人不适宜信息的任务输入。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewPoliticalAsrTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""音视频审核 Asr 文字涉及令人不适宜信息的任务输出。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewPoliticalAsrTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        r"""音视频审核 Asr 文字涉及令人不适宜信息的任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewPoliticalAsrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewPoliticalAsrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskPoliticalOcrResult(AbstractModel):
    r"""音视频审核 Ocr 文字涉及令人不适宜信息、违规任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 音视频审核 Ocr 文字涉及令人不适宜信息的任务输入。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiReviewPoliticalOcrTaskInput`
        :param _Output: 音视频审核 Ocr 文字涉及令人不适宜信息的任务输出。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiReviewPoliticalOcrTaskOutput`
        :param _Progress: 音视频审核 Ocr 文字涉及令人不适宜信息的任务进度，取值范围 [0-100] 。
        :type Progress: int
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""音视频审核 Ocr 文字涉及令人不适宜信息的任务输入。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewPoliticalOcrTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""音视频审核 Ocr 文字涉及令人不适宜信息的任务输出。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewPoliticalOcrTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        r"""音视频审核 Ocr 文字涉及令人不适宜信息的任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewPoliticalOcrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewPoliticalOcrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskPoliticalResult(AbstractModel):
    r"""音视频审核涉及令人不适宜信息的任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 音视频审核涉及令人不适宜信息的任务输入。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiReviewPoliticalTaskInput`
        :param _Output: 音视频审核涉及令人不适宜信息的任务输出。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiReviewPoliticalTaskOutput`
        :param _Progress: 音视频审核涉及令人不适宜信息的任务进度，取值范围 [0-100] 。
        :type Progress: int
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""音视频审核涉及令人不适宜信息的任务输入。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewPoliticalTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""音视频审核涉及令人不适宜信息的任务输出。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewPoliticalTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        r"""音视频审核涉及令人不适宜信息的任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewPoliticalTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewPoliticalTaskOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskPornAsrResult(AbstractModel):
    r"""音视频审核 Asr 文字涉及令人反感的信息的任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 音视频审核 Asr 文字涉及令人反感的信息的任务输入。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiReviewPornAsrTaskInput`
        :param _Output: 音视频审核 Asr 文字涉及令人反感的信息的任务输出。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiReviewPornAsrTaskOutput`
        :param _Progress: 音视频审核 Asr 文字涉及令人反感的信息的任务进度，取值范围 [0-100] 。
        :type Progress: int
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""音视频审核 Asr 文字涉及令人反感的信息的任务输入。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewPornAsrTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""音视频审核 Asr 文字涉及令人反感的信息的任务输出。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewPornAsrTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        r"""音视频审核 Asr 文字涉及令人反感的信息的任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewPornAsrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewPornAsrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskPornOcrResult(AbstractModel):
    r"""音视频审核 Ocr 文字涉及令人反感的信息的任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 音视频审核 Ocr 文字涉及令人反感的信息的任务输入。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiReviewPornOcrTaskInput`
        :param _Output: Ocr 文字音视频审核涉及令人反感的信息的任务输出。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiReviewPornOcrTaskOutput`
        :param _Progress: Ocr 文字音视频审核涉及令人反感的信息的任务进度，取值范围 [0-100] 。
        :type Progress: int
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""音视频审核 Ocr 文字涉及令人反感的信息的任务输入。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewPornOcrTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""Ocr 文字音视频审核涉及令人反感的信息的任务输出。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewPornOcrTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        r"""Ocr 文字音视频审核涉及令人反感的信息的任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewPornOcrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewPornOcrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskPornResult(AbstractModel):
    r"""音视频审核涉及令人反感的信息的任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 音视频审核涉及令人反感的信息的任务输入。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiReviewPornTaskInput`
        :param _Output: 音视频审核涉及令人反感的信息的任务输出。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiReviewPornTaskOutput`
        :param _Progress: 音视频审核涉及令人反感的信息的任务进度，取值范围 [0-100] 。
        :type Progress: int
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""音视频审核涉及令人反感的信息的任务输入。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewPornTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""音视频审核涉及令人反感的信息的任务输出。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewPornTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        r"""音视频审核涉及令人反感的信息的任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewPornTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewPornTaskOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskProhibitedAsrResult(AbstractModel):
    r"""音视频审核 Asr 文字鉴违禁任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 音视频审核 Asr 文字鉴违禁任务输入。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiReviewProhibitedAsrTaskInput`
        :param _Output: 音视频审核 Asr 文字鉴违禁任务输出。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiReviewProhibitedAsrTaskOutput`
        :param _Progress: 音视频审核 Asr 文字鉴违禁任务进度，取值范围 [0-100] 。
        :type Progress: int
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""音视频审核 Asr 文字鉴违禁任务输入。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewProhibitedAsrTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""音视频审核 Asr 文字鉴违禁任务输出。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewProhibitedAsrTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        r"""音视频审核 Asr 文字鉴违禁任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewProhibitedAsrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewProhibitedAsrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskProhibitedOcrResult(AbstractModel):
    r"""音视频审核 Ocr 文字鉴违禁任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 音视频审核 Ocr 文字鉴违禁任务输入。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiReviewProhibitedOcrTaskInput`
        :param _Output: 音视频审核 Ocr 文字鉴违禁任务输出。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiReviewProhibitedOcrTaskOutput`
        :param _Progress: 音视频审核 Ocr 文字鉴违禁任务进度，取值范围 [0-100] 。
        :type Progress: int
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""音视频审核 Ocr 文字鉴违禁任务输入。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewProhibitedOcrTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""音视频审核 Ocr 文字鉴违禁任务输出。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewProhibitedOcrTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        r"""音视频审核 Ocr 文字鉴违禁任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewProhibitedOcrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewProhibitedOcrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskTerrorismOcrResult(AbstractModel):
    r"""音视频审核 Ocr 文字鉴别涉及令人不安全的信息的任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 音视频审核 Ocr 文字涉及令人不安全的信息的任务输入。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiReviewTerrorismOcrTaskInput`
        :param _Output: 音视频审核 Ocr 文字涉及令人不安全的信息的任务输出。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiReviewTerrorismOcrTaskOutput`
        :param _Progress: 音视频审核 Ocr 文字涉及令人不安全的信息的任务进度，取值范围 [0-100] 。
        :type Progress: int
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""音视频审核 Ocr 文字涉及令人不安全的信息的任务输入。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewTerrorismOcrTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""音视频审核 Ocr 文字涉及令人不安全的信息的任务输出。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewTerrorismOcrTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        r"""音视频审核 Ocr 文字涉及令人不安全的信息的任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewTerrorismOcrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewTerrorismOcrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskTerrorismResult(AbstractModel):
    r"""音视频审核涉及令人不安全的信息的任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 音视频审核涉及令人不安全的信息的任务输入。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiReviewTerrorismTaskInput`
        :param _Output: 音视频审核涉及令人不安全的信息的任务输出。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiReviewTerrorismTaskOutput`
        :param _Progress: 音视频审核涉及令人不安全的信息的任务进度，取值范围 [0-100] 。
        :type Progress: int
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""音视频审核涉及令人不安全的信息的任务输入。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewTerrorismTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""音视频审核涉及令人不安全的信息的任务输出。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiReviewTerrorismTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        r"""音视频审核涉及令人不安全的信息的任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewTerrorismTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewTerrorismTaskOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTerrorismOcrTaskInput(AbstractModel):
    r"""音视频审核 Ocr 文字涉及令人不安全的信息的任务输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 鉴别涉及令人不安全的信息的模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""鉴别涉及令人不安全的信息的模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTerrorismOcrTaskOutput(AbstractModel):
    r"""Ocr 文字涉及令人不安全的信息

    """

    def __init__(self):
        r"""
        :param _Confidence: Ocr 文字有涉及令人不安全信息的评分，分值为0到100。
        :type Confidence: float
        :param _Suggestion: Ocr 文字有涉及令人不安全信息的结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :type Suggestion: str
        :param _SegmentSet: Ocr 文字有涉及令人不安全信息嫌疑的视频片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :type SegmentSet: list of MediaContentReviewOcrTextSegmentItem
        :param _SegmentSetFileUrl: Ocr 文字有涉及令人不安全信息嫌疑的视频片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达 SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :type SegmentSetFileUrl: str
        :param _SegmentSetFileUrlExpireTime: Ocr 文字有涉及令人不安全信息嫌疑的视频片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type SegmentSetFileUrlExpireTime: str
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None
        self._SegmentSetFileUrl = None
        self._SegmentSetFileUrlExpireTime = None

    @property
    def Confidence(self):
        r"""Ocr 文字有涉及令人不安全信息的评分，分值为0到100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        r"""Ocr 文字有涉及令人不安全信息的结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :rtype: str
        """
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        r"""Ocr 文字有涉及令人不安全信息嫌疑的视频片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :rtype: list of MediaContentReviewOcrTextSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SegmentSetFileUrl(self):
        r"""Ocr 文字有涉及令人不安全信息嫌疑的视频片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达 SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._SegmentSetFileUrl

    @SegmentSetFileUrl.setter
    def SegmentSetFileUrl(self, SegmentSetFileUrl):
        self._SegmentSetFileUrl = SegmentSetFileUrl

    @property
    def SegmentSetFileUrlExpireTime(self):
        r"""Ocr 文字有涉及令人不安全信息嫌疑的视频片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._SegmentSetFileUrlExpireTime

    @SegmentSetFileUrlExpireTime.setter
    def SegmentSetFileUrlExpireTime(self, SegmentSetFileUrlExpireTime):
        self._SegmentSetFileUrlExpireTime = SegmentSetFileUrlExpireTime


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewOcrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SegmentSetFileUrl = params.get("SegmentSetFileUrl")
        self._SegmentSetFileUrlExpireTime = params.get("SegmentSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTerrorismTaskInput(AbstractModel):
    r"""音视频审核涉及令人不安全的信息的任务输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 鉴别涉及令人不安全的信息的模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""鉴别涉及令人不安全的信息的模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTerrorismTaskOutput(AbstractModel):
    r"""暴恐信息

    """

    def __init__(self):
        r"""
        :param _Confidence: 视频暴恐评分，分值为0到100。
        :type Confidence: float
        :param _Suggestion: 暴恐结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :type Suggestion: str
        :param _Label: 视频暴恐结果标签，取值范围：
<li>guns：武器枪支。</li>
<li>crowd：人群聚集。</li>
<li>police：警察部队。</li>
<li>bloody：血腥画面。</li>
<li>banners：暴恐旗帜。</li>
<li>militant：武装分子。</li>
<li>explosion：爆炸火灾。</li>
<li>terrorists：暴恐人物。</li>
<li>scenario：暴恐画面。</li>
        :type Label: str
        :param _SegmentSet: 有暴恐嫌疑的视频片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :type SegmentSet: list of MediaContentReviewSegmentItem
        :param _SegmentSetFileUrl: 暴恐嫌疑的视频片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :type SegmentSetFileUrl: str
        :param _SegmentSetFileUrlExpireTime: 暴恐嫌疑的视频片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type SegmentSetFileUrlExpireTime: str
        """
        self._Confidence = None
        self._Suggestion = None
        self._Label = None
        self._SegmentSet = None
        self._SegmentSetFileUrl = None
        self._SegmentSetFileUrlExpireTime = None

    @property
    def Confidence(self):
        r"""视频暴恐评分，分值为0到100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        r"""暴恐结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :rtype: str
        """
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def Label(self):
        r"""视频暴恐结果标签，取值范围：
<li>guns：武器枪支。</li>
<li>crowd：人群聚集。</li>
<li>police：警察部队。</li>
<li>bloody：血腥画面。</li>
<li>banners：暴恐旗帜。</li>
<li>militant：武装分子。</li>
<li>explosion：爆炸火灾。</li>
<li>terrorists：暴恐人物。</li>
<li>scenario：暴恐画面。</li>
        :rtype: str
        """
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label

    @property
    def SegmentSet(self):
        r"""有暴恐嫌疑的视频片段列表。
<font color=red>注意</font> ：该列表最多仅展示前 100 个元素。如希望获得完整结果，请从 SegmentSetFileUrl 对应的文件中获取。
        :rtype: list of MediaContentReviewSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SegmentSetFileUrl(self):
        r"""暴恐嫌疑的视频片段列表文件 URL。文件的内容为 JSON，数据结构与 SegmentSet 字段一致。 （文件不会永久存储，到达SegmentSetFileUrlExpireTime 时间点后文件将被删除）。
        :rtype: str
        """
        return self._SegmentSetFileUrl

    @SegmentSetFileUrl.setter
    def SegmentSetFileUrl(self, SegmentSetFileUrl):
        self._SegmentSetFileUrl = SegmentSetFileUrl

    @property
    def SegmentSetFileUrlExpireTime(self):
        r"""暴恐嫌疑的视频片段列表文件 URL 失效时间，使用  [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._SegmentSetFileUrlExpireTime

    @SegmentSetFileUrlExpireTime.setter
    def SegmentSetFileUrlExpireTime(self, SegmentSetFileUrlExpireTime):
        self._SegmentSetFileUrlExpireTime = SegmentSetFileUrlExpireTime


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        self._Label = params.get("Label")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SegmentSetFileUrl = params.get("SegmentSetFileUrl")
        self._SegmentSetFileUrlExpireTime = params.get("SegmentSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSampleFaceInfo(AbstractModel):
    r"""AI 样本管理，人脸信息。

    """

    def __init__(self):
        r"""
        :param _FaceId: 人脸图片 ID。
        :type FaceId: str
        :param _Url: 人脸图片地址。
        :type Url: str
        """
        self._FaceId = None
        self._Url = None

    @property
    def FaceId(self):
        r"""人脸图片 ID。
        :rtype: str
        """
        return self._FaceId

    @FaceId.setter
    def FaceId(self, FaceId):
        self._FaceId = FaceId

    @property
    def Url(self):
        r"""人脸图片地址。
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url


    def _deserialize(self, params):
        self._FaceId = params.get("FaceId")
        self._Url = params.get("Url")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSampleFaceOperation(AbstractModel):
    r"""AI 样本管理，人脸数据操作。

    """

    def __init__(self):
        r"""
        :param _Type: 操作类型，可选值：add（添加）、delete（删除）、reset（重置）。重置操作将清空该人物已有人脸数据，并添加 FaceContents 指定人脸数据。
        :type Type: str
        :param _FaceIds: 人脸 ID 集合，当 Type为delete 时，该字段必填。
        :type FaceIds: list of str
        :param _FaceContents: 人脸图片 [Base64](https://tools.ietf.org/html/rfc4648) 编码后的字符串集合，仅支持 jpeg、png 图片格式。
<li>当 Type为add 或 reset 时，该字段必填；</li>
<li>数组长度限制：5 张图片。</li>
注意：图片必须是单人像正面人脸较清晰的照片，像素不低于 200*200。
        :type FaceContents: list of str
        """
        self._Type = None
        self._FaceIds = None
        self._FaceContents = None

    @property
    def Type(self):
        r"""操作类型，可选值：add（添加）、delete（删除）、reset（重置）。重置操作将清空该人物已有人脸数据，并添加 FaceContents 指定人脸数据。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def FaceIds(self):
        r"""人脸 ID 集合，当 Type为delete 时，该字段必填。
        :rtype: list of str
        """
        return self._FaceIds

    @FaceIds.setter
    def FaceIds(self, FaceIds):
        self._FaceIds = FaceIds

    @property
    def FaceContents(self):
        r"""人脸图片 [Base64](https://tools.ietf.org/html/rfc4648) 编码后的字符串集合，仅支持 jpeg、png 图片格式。
<li>当 Type为add 或 reset 时，该字段必填；</li>
<li>数组长度限制：5 张图片。</li>
注意：图片必须是单人像正面人脸较清晰的照片，像素不低于 200*200。
        :rtype: list of str
        """
        return self._FaceContents

    @FaceContents.setter
    def FaceContents(self, FaceContents):
        self._FaceContents = FaceContents


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._FaceIds = params.get("FaceIds")
        self._FaceContents = params.get("FaceContents")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSampleFailFaceInfo(AbstractModel):
    r"""AI 样本管理，处理失败的人脸信息

    """

    def __init__(self):
        r"""
        :param _Index: 对应入参 FaceContents 中错误图片下标，从 0 开始。
        :type Index: int
        :param _ErrCode: 错误码，取值：
<li>0：成功；</li>
<li>其他：失败。</li>
        :type ErrCode: int
        :param _Message: 错误描述。
        :type Message: str
        """
        self._Index = None
        self._ErrCode = None
        self._Message = None

    @property
    def Index(self):
        r"""对应入参 FaceContents 中错误图片下标，从 0 开始。
        :rtype: int
        """
        return self._Index

    @Index.setter
    def Index(self, Index):
        self._Index = Index

    @property
    def ErrCode(self):
        r"""错误码，取值：
<li>0：成功；</li>
<li>其他：失败。</li>
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误描述。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message


    def _deserialize(self, params):
        self._Index = params.get("Index")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSamplePerson(AbstractModel):
    r"""AI 样本管理，人物信息。

    """

    def __init__(self):
        r"""
        :param _PersonId: 人物 ID。
        :type PersonId: str
        :param _Name: 人物名称。
        :type Name: str
        :param _Description: 人物描述。
        :type Description: str
        :param _FaceInfoSet: 人脸信息。
        :type FaceInfoSet: list of AiSampleFaceInfo
        :param _TagSet: 人物标签。
        :type TagSet: list of str
        :param _UsageSet: 应用场景。
        :type UsageSet: list of str
        :param _CreateTime: 创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type CreateTime: str
        :param _UpdateTime: 最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type UpdateTime: str
        """
        self._PersonId = None
        self._Name = None
        self._Description = None
        self._FaceInfoSet = None
        self._TagSet = None
        self._UsageSet = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def PersonId(self):
        r"""人物 ID。
        :rtype: str
        """
        return self._PersonId

    @PersonId.setter
    def PersonId(self, PersonId):
        self._PersonId = PersonId

    @property
    def Name(self):
        r"""人物名称。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Description(self):
        r"""人物描述。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def FaceInfoSet(self):
        r"""人脸信息。
        :rtype: list of AiSampleFaceInfo
        """
        return self._FaceInfoSet

    @FaceInfoSet.setter
    def FaceInfoSet(self, FaceInfoSet):
        self._FaceInfoSet = FaceInfoSet

    @property
    def TagSet(self):
        r"""人物标签。
        :rtype: list of str
        """
        return self._TagSet

    @TagSet.setter
    def TagSet(self, TagSet):
        self._TagSet = TagSet

    @property
    def UsageSet(self):
        r"""应用场景。
        :rtype: list of str
        """
        return self._UsageSet

    @UsageSet.setter
    def UsageSet(self, UsageSet):
        self._UsageSet = UsageSet

    @property
    def CreateTime(self):
        r"""创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._PersonId = params.get("PersonId")
        self._Name = params.get("Name")
        self._Description = params.get("Description")
        if params.get("FaceInfoSet") is not None:
            self._FaceInfoSet = []
            for item in params.get("FaceInfoSet"):
                obj = AiSampleFaceInfo()
                obj._deserialize(item)
                self._FaceInfoSet.append(obj)
        self._TagSet = params.get("TagSet")
        self._UsageSet = params.get("UsageSet")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSampleTagOperation(AbstractModel):
    r"""AI 样本管理，标签操作。

    """

    def __init__(self):
        r"""
        :param _Type: 操作类型，可选值：add（添加）、delete（删除）、reset（重置）。
        :type Type: str
        :param _Tags: 标签，长度限制：128 个字符。
        :type Tags: list of str
        """
        self._Type = None
        self._Tags = None

    @property
    def Type(self):
        r"""操作类型，可选值：add（添加）、delete（删除）、reset（重置）。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Tags(self):
        r"""标签，长度限制：128 个字符。
        :rtype: list of str
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Tags = params.get("Tags")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSampleWord(AbstractModel):
    r"""AI 样本管理，关键词输出信息。

    """

    def __init__(self):
        r"""
        :param _Keyword: 关键词。
        :type Keyword: str
        :param _TagSet: 关键词标签。
        :type TagSet: list of str
        :param _UsageSet: 关键词应用场景。
        :type UsageSet: list of str
        :param _CreateTime: 创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type CreateTime: str
        :param _UpdateTime: 最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type UpdateTime: str
        """
        self._Keyword = None
        self._TagSet = None
        self._UsageSet = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def Keyword(self):
        r"""关键词。
        :rtype: str
        """
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword

    @property
    def TagSet(self):
        r"""关键词标签。
        :rtype: list of str
        """
        return self._TagSet

    @TagSet.setter
    def TagSet(self, TagSet):
        self._TagSet = TagSet

    @property
    def UsageSet(self):
        r"""关键词应用场景。
        :rtype: list of str
        """
        return self._UsageSet

    @UsageSet.setter
    def UsageSet(self, UsageSet):
        self._UsageSet = UsageSet

    @property
    def CreateTime(self):
        r"""创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._Keyword = params.get("Keyword")
        self._TagSet = params.get("TagSet")
        self._UsageSet = params.get("UsageSet")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSampleWordInfo(AbstractModel):
    r"""AI 样本管理，关键词输入信息。

    """

    def __init__(self):
        r"""
        :param _Keyword: 关键词，长度限制：20 个字符。
        :type Keyword: str
        :param _Tags: 关键词标签
<li>数组长度限制：20 个标签；</li>
<li>单个标签长度限制：128 个字符。</li>
        :type Tags: list of str
        """
        self._Keyword = None
        self._Tags = None

    @property
    def Keyword(self):
        r"""关键词，长度限制：20 个字符。
        :rtype: str
        """
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword

    @property
    def Tags(self):
        r"""关键词标签
<li>数组长度限制：20 个标签；</li>
<li>单个标签长度限制：128 个字符。</li>
        :rtype: list of str
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._Keyword = params.get("Keyword")
        self._Tags = params.get("Tags")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AigcImageOutputConfig(AbstractModel):
    r"""AIGC 生图任务的输出媒体文件配置。

    """

    def __init__(self):
        r"""
        :param _StorageMode: 存储模式。取值有： <li>Permanent：永久存储，生成的图片文件将存储到云点播，可在事件通知中获取到 FileId；</li> <li>Temporary：临时存储，生成的图片文件不会存储到云点播，可在事件通知中获取到临时访问的 URL；</li>
默认值：Temporary
        :type StorageMode: str
        :param _MediaName: 输出文件名，最长 64 个字符。缺省由系统指定生成文件名。
        :type MediaName: str
        :param _ClassId: 分类ID，用于对媒体进行分类管理，可通过 [创建分类](/document/product/266/7812) 接口，创建分类，获得分类 ID。
<li>默认值：0，表示其他分类。</li>
        :type ClassId: int
        :param _ExpireTime: 输出文件的过期时间，超过该时间文件将被删除，默认为永久不过期，格式按照 ISO 8601标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :type ExpireTime: str
        :param _Resolution: 生成图片的分辨率。可选值为 720P、1080P、2K、4K、1024x1024、2048x2048、2304x1728、2496x1664、2560x1440、3024x1296、4096x4096、4694x3520、4992x3328、5404x3040、6198x2656。
        :type Resolution: str
        :param _AspectRatio: 指定所生成图片的宽高比。<li>当 ModelName 是 GEM，可选值是 1:1、3:2、2:3、3:4、4:3、4:5、5:4、9:16、16:9 和 21:9；</li><li>当 ModelName 是 Qwen，则暂不支持。</li>
        :type AspectRatio: str
        :param _PersonGeneration: 是否允许人物或人脸生成。取值有： <li>AllowAdult：允许生成成人；</li> <li>Disallowed：禁止在图片中包含人物或人脸；</li> 
        :type PersonGeneration: str
        :param _InputComplianceCheck: 是否开启输入内容的合规性检查。取值有： <li>Enabled：开启；</li> <li>Disabled：关闭；</li> 
        :type InputComplianceCheck: str
        :param _OutputComplianceCheck: 是否开启输出内容的合规性检查。取值有： <li>Enabled：开启；</li> <li>Disabled：关闭；</li> 
        :type OutputComplianceCheck: str
        """
        self._StorageMode = None
        self._MediaName = None
        self._ClassId = None
        self._ExpireTime = None
        self._Resolution = None
        self._AspectRatio = None
        self._PersonGeneration = None
        self._InputComplianceCheck = None
        self._OutputComplianceCheck = None

    @property
    def StorageMode(self):
        r"""存储模式。取值有： <li>Permanent：永久存储，生成的图片文件将存储到云点播，可在事件通知中获取到 FileId；</li> <li>Temporary：临时存储，生成的图片文件不会存储到云点播，可在事件通知中获取到临时访问的 URL；</li>
默认值：Temporary
        :rtype: str
        """
        return self._StorageMode

    @StorageMode.setter
    def StorageMode(self, StorageMode):
        self._StorageMode = StorageMode

    @property
    def MediaName(self):
        r"""输出文件名，最长 64 个字符。缺省由系统指定生成文件名。
        :rtype: str
        """
        return self._MediaName

    @MediaName.setter
    def MediaName(self, MediaName):
        self._MediaName = MediaName

    @property
    def ClassId(self):
        r"""分类ID，用于对媒体进行分类管理，可通过 [创建分类](/document/product/266/7812) 接口，创建分类，获得分类 ID。
<li>默认值：0，表示其他分类。</li>
        :rtype: int
        """
        return self._ClassId

    @ClassId.setter
    def ClassId(self, ClassId):
        self._ClassId = ClassId

    @property
    def ExpireTime(self):
        r"""输出文件的过期时间，超过该时间文件将被删除，默认为永久不过期，格式按照 ISO 8601标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def Resolution(self):
        r"""生成图片的分辨率。可选值为 720P、1080P、2K、4K、1024x1024、2048x2048、2304x1728、2496x1664、2560x1440、3024x1296、4096x4096、4694x3520、4992x3328、5404x3040、6198x2656。
        :rtype: str
        """
        return self._Resolution

    @Resolution.setter
    def Resolution(self, Resolution):
        self._Resolution = Resolution

    @property
    def AspectRatio(self):
        r"""指定所生成图片的宽高比。<li>当 ModelName 是 GEM，可选值是 1:1、3:2、2:3、3:4、4:3、4:5、5:4、9:16、16:9 和 21:9；</li><li>当 ModelName 是 Qwen，则暂不支持。</li>
        :rtype: str
        """
        return self._AspectRatio

    @AspectRatio.setter
    def AspectRatio(self, AspectRatio):
        self._AspectRatio = AspectRatio

    @property
    def PersonGeneration(self):
        r"""是否允许人物或人脸生成。取值有： <li>AllowAdult：允许生成成人；</li> <li>Disallowed：禁止在图片中包含人物或人脸；</li> 
        :rtype: str
        """
        return self._PersonGeneration

    @PersonGeneration.setter
    def PersonGeneration(self, PersonGeneration):
        self._PersonGeneration = PersonGeneration

    @property
    def InputComplianceCheck(self):
        r"""是否开启输入内容的合规性检查。取值有： <li>Enabled：开启；</li> <li>Disabled：关闭；</li> 
        :rtype: str
        """
        return self._InputComplianceCheck

    @InputComplianceCheck.setter
    def InputComplianceCheck(self, InputComplianceCheck):
        self._InputComplianceCheck = InputComplianceCheck

    @property
    def OutputComplianceCheck(self):
        r"""是否开启输出内容的合规性检查。取值有： <li>Enabled：开启；</li> <li>Disabled：关闭；</li> 
        :rtype: str
        """
        return self._OutputComplianceCheck

    @OutputComplianceCheck.setter
    def OutputComplianceCheck(self, OutputComplianceCheck):
        self._OutputComplianceCheck = OutputComplianceCheck


    def _deserialize(self, params):
        self._StorageMode = params.get("StorageMode")
        self._MediaName = params.get("MediaName")
        self._ClassId = params.get("ClassId")
        self._ExpireTime = params.get("ExpireTime")
        self._Resolution = params.get("Resolution")
        self._AspectRatio = params.get("AspectRatio")
        self._PersonGeneration = params.get("PersonGeneration")
        self._InputComplianceCheck = params.get("InputComplianceCheck")
        self._OutputComplianceCheck = params.get("OutputComplianceCheck")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AigcImageSceneInfo(AbstractModel):
    r"""场景化 AIGC 生图配置。

    """

    def __init__(self):
        r"""
        :param _Type: AI生图场景类型，可选值：
- change_clothes：AI换衣。
- product_image：AI生商品图。
        :type Type: str
        :param _ChangeClothesConfig: 当 Type 为 change_clothes 时有效，则该项为必填，表示AI 换衣生图配置参数。
        :type ChangeClothesConfig: :class:`tencentcloud.vod.v20180717.models.ChangeClothesConfig`
        :param _ProductImageConfig: 当 Type 为 product_image 时有效，表示AI 生商品图配置参数。
        :type ProductImageConfig: :class:`tencentcloud.vod.v20180717.models.ProductImageConfig`
        """
        self._Type = None
        self._ChangeClothesConfig = None
        self._ProductImageConfig = None

    @property
    def Type(self):
        r"""AI生图场景类型，可选值：
- change_clothes：AI换衣。
- product_image：AI生商品图。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def ChangeClothesConfig(self):
        r"""当 Type 为 change_clothes 时有效，则该项为必填，表示AI 换衣生图配置参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ChangeClothesConfig`
        """
        return self._ChangeClothesConfig

    @ChangeClothesConfig.setter
    def ChangeClothesConfig(self, ChangeClothesConfig):
        self._ChangeClothesConfig = ChangeClothesConfig

    @property
    def ProductImageConfig(self):
        r"""当 Type 为 product_image 时有效，表示AI 生商品图配置参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ProductImageConfig`
        """
        return self._ProductImageConfig

    @ProductImageConfig.setter
    def ProductImageConfig(self, ProductImageConfig):
        self._ProductImageConfig = ProductImageConfig


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("ChangeClothesConfig") is not None:
            self._ChangeClothesConfig = ChangeClothesConfig()
            self._ChangeClothesConfig._deserialize(params.get("ChangeClothesConfig"))
        if params.get("ProductImageConfig") is not None:
            self._ProductImageConfig = ProductImageConfig()
            self._ProductImageConfig._deserialize(params.get("ProductImageConfig"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AigcImageTask(AbstractModel):
    r"""AIGC 生图任务信息

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务 ID。
        :type TaskId: str
        :param _Status: 任务状态，取值：<li>PROCESSING：处理中；</li><li>FINISH：已完成。</li>
        :type Status: str
        :param _ErrCode: 错误码。源异常时返回非0错误码，返回0时请使用各个具体任务的 ErrCode。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Progress: 任务进度，取值范围 [0-100] 。
        :type Progress: int
        :param _Input: AIGC 生图任务的输入信息。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AigcImageTaskInput`
        :param _Output: AIGC 生图任务的输出信息。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AigcImageTaskOutput`
        :param _SessionId: 用于去重的识别码，如果七天内曾有过相同的识别码的请求，则本次的请求会返回错误。最长 50 个字符，不带或者带空字符串表示不做去重。
        :type SessionId: str
        :param _SessionContext: 来源上下文，用于透传用户请求信息，任务流状态变更回调将返回该字段值，最长 1000 个字符。
        :type SessionContext: str
        """
        self._TaskId = None
        self._Status = None
        self._ErrCode = None
        self._Message = None
        self._Progress = None
        self._Input = None
        self._Output = None
        self._SessionId = None
        self._SessionContext = None

    @property
    def TaskId(self):
        r"""任务 ID。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Status(self):
        r"""任务状态，取值：<li>PROCESSING：处理中；</li><li>FINISH：已完成。</li>
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        r"""错误码。源异常时返回非0错误码，返回0时请使用各个具体任务的 ErrCode。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Progress(self):
        r"""任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def Input(self):
        r"""AIGC 生图任务的输入信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AigcImageTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""AIGC 生图任务的输出信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AigcImageTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def SessionId(self):
        r"""用于去重的识别码，如果七天内曾有过相同的识别码的请求，则本次的请求会返回错误。最长 50 个字符，不带或者带空字符串表示不做去重。
        :rtype: str
        """
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def SessionContext(self):
        r"""来源上下文，用于透传用户请求信息，任务流状态变更回调将返回该字段值，最长 1000 个字符。
        :rtype: str
        """
        return self._SessionContext

    @SessionContext.setter
    def SessionContext(self, SessionContext):
        self._SessionContext = SessionContext


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        self._Progress = params.get("Progress")
        if params.get("Input") is not None:
            self._Input = AigcImageTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AigcImageTaskOutput()
            self._Output._deserialize(params.get("Output"))
        self._SessionId = params.get("SessionId")
        self._SessionContext = params.get("SessionContext")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AigcImageTaskInput(AbstractModel):
    r"""AIGC 生图任务的输入。

    """

    def __init__(self):
        r"""
        :param _ModelName: 模型名称。
        :type ModelName: str
        :param _ModelVersion: 模型版本。
        :type ModelVersion: str
        :param _FileInfos: AIGC生图任务输入文件信息。
        :type FileInfos: list of AigcImageTaskInputFileInfo
        :param _Prompt: 生成图片的提示词。最大支持1000字符，当 FileInfos 为空时，此参数必填。
        :type Prompt: str
        :param _NegativePrompt: 要阻止模型生成图片的提示词。最大支持1000字符。
        :type NegativePrompt: str
        :param _EnhancePrompt: 是否自动优化提示词。开启时将自动优化传入的Prompt，以提升生成质量。取值有： <li>Enabled：开启；</li> <li>Disabled：关闭；</li> 
        :type EnhancePrompt: str
        :param _GenerationMode: 生成模式。取值有： <li>Standard：标准模式；</li> <li>Professional：高品质模式；</li> 
        :type GenerationMode: str
        :param _OutputConfig: AIGC 生图输出结果文件输出。
        :type OutputConfig: :class:`tencentcloud.vod.v20180717.models.AigcImageOutputConfig`
        """
        self._ModelName = None
        self._ModelVersion = None
        self._FileInfos = None
        self._Prompt = None
        self._NegativePrompt = None
        self._EnhancePrompt = None
        self._GenerationMode = None
        self._OutputConfig = None

    @property
    def ModelName(self):
        r"""模型名称。
        :rtype: str
        """
        return self._ModelName

    @ModelName.setter
    def ModelName(self, ModelName):
        self._ModelName = ModelName

    @property
    def ModelVersion(self):
        r"""模型版本。
        :rtype: str
        """
        return self._ModelVersion

    @ModelVersion.setter
    def ModelVersion(self, ModelVersion):
        self._ModelVersion = ModelVersion

    @property
    def FileInfos(self):
        r"""AIGC生图任务输入文件信息。
        :rtype: list of AigcImageTaskInputFileInfo
        """
        return self._FileInfos

    @FileInfos.setter
    def FileInfos(self, FileInfos):
        self._FileInfos = FileInfos

    @property
    def Prompt(self):
        r"""生成图片的提示词。最大支持1000字符，当 FileInfos 为空时，此参数必填。
        :rtype: str
        """
        return self._Prompt

    @Prompt.setter
    def Prompt(self, Prompt):
        self._Prompt = Prompt

    @property
    def NegativePrompt(self):
        r"""要阻止模型生成图片的提示词。最大支持1000字符。
        :rtype: str
        """
        return self._NegativePrompt

    @NegativePrompt.setter
    def NegativePrompt(self, NegativePrompt):
        self._NegativePrompt = NegativePrompt

    @property
    def EnhancePrompt(self):
        r"""是否自动优化提示词。开启时将自动优化传入的Prompt，以提升生成质量。取值有： <li>Enabled：开启；</li> <li>Disabled：关闭；</li> 
        :rtype: str
        """
        return self._EnhancePrompt

    @EnhancePrompt.setter
    def EnhancePrompt(self, EnhancePrompt):
        self._EnhancePrompt = EnhancePrompt

    @property
    def GenerationMode(self):
        r"""生成模式。取值有： <li>Standard：标准模式；</li> <li>Professional：高品质模式；</li> 
        :rtype: str
        """
        return self._GenerationMode

    @GenerationMode.setter
    def GenerationMode(self, GenerationMode):
        self._GenerationMode = GenerationMode

    @property
    def OutputConfig(self):
        r"""AIGC 生图输出结果文件输出。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AigcImageOutputConfig`
        """
        return self._OutputConfig

    @OutputConfig.setter
    def OutputConfig(self, OutputConfig):
        self._OutputConfig = OutputConfig


    def _deserialize(self, params):
        self._ModelName = params.get("ModelName")
        self._ModelVersion = params.get("ModelVersion")
        if params.get("FileInfos") is not None:
            self._FileInfos = []
            for item in params.get("FileInfos"):
                obj = AigcImageTaskInputFileInfo()
                obj._deserialize(item)
                self._FileInfos.append(obj)
        self._Prompt = params.get("Prompt")
        self._NegativePrompt = params.get("NegativePrompt")
        self._EnhancePrompt = params.get("EnhancePrompt")
        self._GenerationMode = params.get("GenerationMode")
        if params.get("OutputConfig") is not None:
            self._OutputConfig = AigcImageOutputConfig()
            self._OutputConfig._deserialize(params.get("OutputConfig"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AigcImageTaskInputFileInfo(AbstractModel):
    r"""AIGC生图任务输入文件信息

    """

    def __init__(self):
        r"""
        :param _Type: 输入的视频文件类型。取值有： <li>File：点播媒体文件；</li> <li>Url：可访问的 URL；</li> 
        :type Type: str
        :param _FileId: 图片文件的媒体文件 ID，即该文件在云点播上的全局唯一标识符，在上传成功后由云点播后台分配。可以在 [视频上传完成事件通知](/document/product/266/7830) 或 [云点播控制台](https://console.cloud.tencent.com/vod/media) 获取该字段。当 Type 取值为 File 时，本参数有效。
说明：
1. 推荐使用小于7M的图片；
2. 图片格式的取值为：jpeg，jpg, png, webp。
        :type FileId: str
        :param _Url: 可访问的文件 URL。当 Type 取值为 Url 时，本参数有效。
说明：
1. 推荐使用小于7M的图片；
2. 图片格式的取值为：jpeg，jpg, png, webp。
        :type Url: str
        :param _Text: 输入图片的描述信息，用于帮助模型理解图片。仅GEM 2.5、GEM 3.0 有效。
        :type Text: str
        """
        self._Type = None
        self._FileId = None
        self._Url = None
        self._Text = None

    @property
    def Type(self):
        r"""输入的视频文件类型。取值有： <li>File：点播媒体文件；</li> <li>Url：可访问的 URL；</li> 
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def FileId(self):
        r"""图片文件的媒体文件 ID，即该文件在云点播上的全局唯一标识符，在上传成功后由云点播后台分配。可以在 [视频上传完成事件通知](/document/product/266/7830) 或 [云点播控制台](https://console.cloud.tencent.com/vod/media) 获取该字段。当 Type 取值为 File 时，本参数有效。
说明：
1. 推荐使用小于7M的图片；
2. 图片格式的取值为：jpeg，jpg, png, webp。
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def Url(self):
        r"""可访问的文件 URL。当 Type 取值为 Url 时，本参数有效。
说明：
1. 推荐使用小于7M的图片；
2. 图片格式的取值为：jpeg，jpg, png, webp。
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def Text(self):
        r"""输入图片的描述信息，用于帮助模型理解图片。仅GEM 2.5、GEM 3.0 有效。
        :rtype: str
        """
        return self._Text

    @Text.setter
    def Text(self, Text):
        self._Text = Text


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._FileId = params.get("FileId")
        self._Url = params.get("Url")
        self._Text = params.get("Text")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AigcImageTaskOutput(AbstractModel):
    r"""AIGC 生图任务的输出。

    """

    def __init__(self):
        r"""
        :param _FileInfos: AIGC 生图任务的输出文件信息。
        :type FileInfos: list of AigcImageTaskOutputFileInfo
        """
        self._FileInfos = None

    @property
    def FileInfos(self):
        r"""AIGC 生图任务的输出文件信息。
        :rtype: list of AigcImageTaskOutputFileInfo
        """
        return self._FileInfos

    @FileInfos.setter
    def FileInfos(self, FileInfos):
        self._FileInfos = FileInfos


    def _deserialize(self, params):
        if params.get("FileInfos") is not None:
            self._FileInfos = []
            for item in params.get("FileInfos"):
                obj = AigcImageTaskOutputFileInfo()
                obj._deserialize(item)
                self._FileInfos.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AigcImageTaskOutputFileInfo(AbstractModel):
    r"""AIGC 生图任务的输出文件信息。

    """

    def __init__(self):
        r"""
        :param _StorageMode: 存储模式。取值有： <li>Permanent：永久存储；</li> <li>Temporary：临时存储；</li>

        :type StorageMode: str
        :param _MediaName: 输出文件名，最长 64 个字符。缺省由系统指定生成文件名。当 StorageMode 为 Permanent 时有效。
        :type MediaName: str
        :param _ClassId: 分类ID，用于对媒体进行分类管理，可通过 [创建分类](/document/product/266/7812) 接口，创建分类，获得分类 ID。当 StorageMode 为 Permanent 时有效。

        :type ClassId: int
        :param _ExpireTime: 输出文件的过期时间，超过该时间文件将被删除，默认为永久不过期，格式按照 ISO 8601标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :type ExpireTime: str
        :param _FileType: 文件类型，例如 mp4、flv 等。
        :type FileType: str
        :param _FileUrl: 媒体文件播放地址。
        :type FileUrl: str
        :param _FileId: 媒体文件 ID。当 StorageMode 为 Permanent 时有效。
        :type FileId: str
        :param _MetaData: 输出视频的元信息。当 StorageMode 为 Permanent 时有效。
        :type MetaData: :class:`tencentcloud.vod.v20180717.models.MediaMetaData`
        """
        self._StorageMode = None
        self._MediaName = None
        self._ClassId = None
        self._ExpireTime = None
        self._FileType = None
        self._FileUrl = None
        self._FileId = None
        self._MetaData = None

    @property
    def StorageMode(self):
        r"""存储模式。取值有： <li>Permanent：永久存储；</li> <li>Temporary：临时存储；</li>

        :rtype: str
        """
        return self._StorageMode

    @StorageMode.setter
    def StorageMode(self, StorageMode):
        self._StorageMode = StorageMode

    @property
    def MediaName(self):
        r"""输出文件名，最长 64 个字符。缺省由系统指定生成文件名。当 StorageMode 为 Permanent 时有效。
        :rtype: str
        """
        return self._MediaName

    @MediaName.setter
    def MediaName(self, MediaName):
        self._MediaName = MediaName

    @property
    def ClassId(self):
        r"""分类ID，用于对媒体进行分类管理，可通过 [创建分类](/document/product/266/7812) 接口，创建分类，获得分类 ID。当 StorageMode 为 Permanent 时有效。

        :rtype: int
        """
        return self._ClassId

    @ClassId.setter
    def ClassId(self, ClassId):
        self._ClassId = ClassId

    @property
    def ExpireTime(self):
        r"""输出文件的过期时间，超过该时间文件将被删除，默认为永久不过期，格式按照 ISO 8601标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def FileType(self):
        r"""文件类型，例如 mp4、flv 等。
        :rtype: str
        """
        return self._FileType

    @FileType.setter
    def FileType(self, FileType):
        self._FileType = FileType

    @property
    def FileUrl(self):
        r"""媒体文件播放地址。
        :rtype: str
        """
        return self._FileUrl

    @FileUrl.setter
    def FileUrl(self, FileUrl):
        self._FileUrl = FileUrl

    @property
    def FileId(self):
        r"""媒体文件 ID。当 StorageMode 为 Permanent 时有效。
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def MetaData(self):
        r"""输出视频的元信息。当 StorageMode 为 Permanent 时有效。
        :rtype: :class:`tencentcloud.vod.v20180717.models.MediaMetaData`
        """
        return self._MetaData

    @MetaData.setter
    def MetaData(self, MetaData):
        self._MetaData = MetaData


    def _deserialize(self, params):
        self._StorageMode = params.get("StorageMode")
        self._MediaName = params.get("MediaName")
        self._ClassId = params.get("ClassId")
        self._ExpireTime = params.get("ExpireTime")
        self._FileType = params.get("FileType")
        self._FileUrl = params.get("FileUrl")
        self._FileId = params.get("FileId")
        if params.get("MetaData") is not None:
            self._MetaData = MediaMetaData()
            self._MetaData._deserialize(params.get("MetaData"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AigcUsageDataItem(AbstractModel):
    r"""AIGC 统计数据

    """

    def __init__(self):
        r"""
        :param _Specification: AIGC规格。
取值有：
<li>Qwen2.0</li>
<li>Gem2.5</li>
<li>Gem3.0_1K</li>
<li>Gem3.0_2K</li>
<li>Gem3.0_4K</li>
<li>Sora2</li>
<li>Veo3.1Fast</li>
<li>Veo3.1Standard</li>
<li>Kling2.5pro_720P</li>
<li>Kling2.5pro_1080P</li>
<li>KlingO1_1080P</li>
<li>Kling2.0&2.1std_720P</li>
<li>Kling2.0&2.1pro_1080P</li>
<li>KlingO1_720P</li>
<li>Hailuo02&2.3_1080P</li>
<li>Hailuo02&2.3_768P</li>
<li>Hailuo2.3fast_768P</li>
<li>Hailuo2.3fast_1080P</li>
<li>ViduQ2_720P</li>
<li>ViduQ2_1080P</li>
<li>ViduQ2pro_720P</li>
<li>ViduQ2pro_1080P</li>
<li>ViduQ2turbo_720P</li>
<li>ViduQ2turbo_1080P</li>
<li>ViduQ2_720P_OffPeak</li>
<li>ViduQ2_1080P_OffPeak</li>
<li>ViduQ2turbo_720P_OffPeak</li>
<li>ViduQ2turbo_1080P_OffPeak</li>
<li>ViduQ2pro_720P_OffPeak</li>
<li>ViduQ2pro_1080P_OffPeak</li>
<li>Hunyuan1.5_720P</li>
<li>Hunyuan1.5_1080P</li>
<li>Hunyuan3.0_1K</li>
<li>Hunyuan3.0_2K</li>
<li>Hunyuan3.0_4K</li>
<li>Mingmou1.0_1080P</li>
<li>Mingmou1.0_1K</li>
<li>Mingmou1.0_2K</li>
<li>Mingmou1.0_4K</li>
<li>Mingmou1.0_720P</li>
<li> unknown</li>
        :type Specification: str
        :param _DataSet: 用量数据。
        :type DataSet: list of TaskStatDataItem
        """
        self._Specification = None
        self._DataSet = None

    @property
    def Specification(self):
        r"""AIGC规格。
取值有：
<li>Qwen2.0</li>
<li>Gem2.5</li>
<li>Gem3.0_1K</li>
<li>Gem3.0_2K</li>
<li>Gem3.0_4K</li>
<li>Sora2</li>
<li>Veo3.1Fast</li>
<li>Veo3.1Standard</li>
<li>Kling2.5pro_720P</li>
<li>Kling2.5pro_1080P</li>
<li>KlingO1_1080P</li>
<li>Kling2.0&2.1std_720P</li>
<li>Kling2.0&2.1pro_1080P</li>
<li>KlingO1_720P</li>
<li>Hailuo02&2.3_1080P</li>
<li>Hailuo02&2.3_768P</li>
<li>Hailuo2.3fast_768P</li>
<li>Hailuo2.3fast_1080P</li>
<li>ViduQ2_720P</li>
<li>ViduQ2_1080P</li>
<li>ViduQ2pro_720P</li>
<li>ViduQ2pro_1080P</li>
<li>ViduQ2turbo_720P</li>
<li>ViduQ2turbo_1080P</li>
<li>ViduQ2_720P_OffPeak</li>
<li>ViduQ2_1080P_OffPeak</li>
<li>ViduQ2turbo_720P_OffPeak</li>
<li>ViduQ2turbo_1080P_OffPeak</li>
<li>ViduQ2pro_720P_OffPeak</li>
<li>ViduQ2pro_1080P_OffPeak</li>
<li>Hunyuan1.5_720P</li>
<li>Hunyuan1.5_1080P</li>
<li>Hunyuan3.0_1K</li>
<li>Hunyuan3.0_2K</li>
<li>Hunyuan3.0_4K</li>
<li>Mingmou1.0_1080P</li>
<li>Mingmou1.0_1K</li>
<li>Mingmou1.0_2K</li>
<li>Mingmou1.0_4K</li>
<li>Mingmou1.0_720P</li>
<li> unknown</li>
        :rtype: str
        """
        return self._Specification

    @Specification.setter
    def Specification(self, Specification):
        self._Specification = Specification

    @property
    def DataSet(self):
        r"""用量数据。
        :rtype: list of TaskStatDataItem
        """
        return self._DataSet

    @DataSet.setter
    def DataSet(self, DataSet):
        self._DataSet = DataSet


    def _deserialize(self, params):
        self._Specification = params.get("Specification")
        if params.get("DataSet") is not None:
            self._DataSet = []
            for item in params.get("DataSet"):
                obj = TaskStatDataItem()
                obj._deserialize(item)
                self._DataSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AigcVideoOutputConfig(AbstractModel):
    r"""AIGC 生视频任务的输出媒体文件配置。

    """

    def __init__(self):
        r"""
        :param _StorageMode: 存储模式。取值有： <li>Permanent：永久存储，生成的视频文件将存储到云点播，可在事件通知中获取到 FileId；</li> <li>Temporary：临时存储，生成的视频文件不会存储到云点播，可在事件通知中获取到临时访问的 URL；</li>
默认值：Temporary
        :type StorageMode: str
        :param _MediaName: 输出媒体文件名，最长 64 个字符。缺省由系统指定生成文件名。
        :type MediaName: str
        :param _ClassId: 分类ID，用于对媒体进行分类管理，可通过 [创建分类](/document/product/266/7812) 接口，创建分类，获得分类 ID。
<li>默认值：0，表示其他分类。</li>
        :type ClassId: int
        :param _ExpireTime: 输出文件的过期时间，超过该时间文件将被删除，默认为永久不过期，格式按照 ISO 8601标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :type ExpireTime: str
        :param _Duration: 生成视频的时长，单位：秒。<li>当 ModelName 是 Kling，可选值为 5、10，默认为 5；</li><li>当 ModelName 是 Hailuo，可选值为 6、10，默认为 6；</li><li>当 ModelName 是 Vidu，可指定1-10；</li><li>当 ModelName 是 GV，可选值为 8，默认为 8；</li><li>当 ModelName 是 OS，可选值为 4、8、12，默认为 8；</li>
        :type Duration: float
        :param _Resolution: 生成视频的分辨率。
<li>当 ModelName 是 Kling，可选值为 720P、1080P，默认为 720P；</li>
<li>当 ModelName 是 Hailuo，可选值为 768P、1080P，默认为 768P；</li>
<li>当 ModelName 是 Vidu，可选值为 720P、1080P，默认为 720P；</li>
<li>当 ModelName 是 GV，可选值为 720P、1080P，默认为 720P；</li>
<li>当 ModelName 是 OS，可选值为 720P；</li>
        :type Resolution: str
        :param _AspectRatio: 指定所生成视频的宽高比。
<li>当 ModelName 是 Kling，当文生视频时，则可选值为 16:9、9:16、 1:1，默认为16:9；</li>
<li>当 ModelName 是 Vidu，当文生视频时和使用参考图片生成时，则可选值为 16:9、9:16、4:3、3:4、1:1，其中仅版本q2支持4:3、3:4</li>
<li>当 ModelName 是 GV，则可选值为 16:9、9:16，默认为 16:9；</li>
<li>当 ModelName 是 OS，当文生视频时，则可选值为 16:9、9:16，默认为 16:9；</li>
<li>当 ModelName 是 Hailuo，则暂不支持。</li>
        :type AspectRatio: str
        :param _AudioGeneration: 是否生成音频。支持的模型包括 GV、OS、Vidu。取值有： <li>Enabled：开启；</li> <li>Disabled：关闭；</li>
默认值：Disabled
        :type AudioGeneration: str
        :param _PersonGeneration: 是否允许人物或人脸生成。取值有： <li>AllowAdult：允许生成成人；</li> <li>Disallowed：禁止在图片中包含人物或人脸；</li> 
        :type PersonGeneration: str
        :param _InputComplianceCheck: 是否开启输入内容的合规性检查。取值有： <li>Enabled：开启；</li> <li>Disabled：关闭；</li> 
        :type InputComplianceCheck: str
        :param _OutputComplianceCheck: 是否开启输出内容的合规性检查。取值有： <li>Enabled：开启；</li> <li>Disabled：关闭；</li> 
        :type OutputComplianceCheck: str
        :param _EnhanceSwitch: 是否启用视频增强。取值有： <li>Enabled：开启；</li> <li>Disabled：关闭；</li> 
说明：
1. 对于选择的分辨率超过模型可生成分辨率时，默认会启用增强。
2. 对于模型可以直出的分辨率，也可以主动选择模型直出低分辨率，使用增强获得指定分辨率。
        :type EnhanceSwitch: str
        :param _FrameInterpolate: 是否开启vidu智能插帧。取值有： <li>Enabled：开启；</li> <li>Disabled：关闭；</li> 
        :type FrameInterpolate: str
        """
        self._StorageMode = None
        self._MediaName = None
        self._ClassId = None
        self._ExpireTime = None
        self._Duration = None
        self._Resolution = None
        self._AspectRatio = None
        self._AudioGeneration = None
        self._PersonGeneration = None
        self._InputComplianceCheck = None
        self._OutputComplianceCheck = None
        self._EnhanceSwitch = None
        self._FrameInterpolate = None

    @property
    def StorageMode(self):
        r"""存储模式。取值有： <li>Permanent：永久存储，生成的视频文件将存储到云点播，可在事件通知中获取到 FileId；</li> <li>Temporary：临时存储，生成的视频文件不会存储到云点播，可在事件通知中获取到临时访问的 URL；</li>
默认值：Temporary
        :rtype: str
        """
        return self._StorageMode

    @StorageMode.setter
    def StorageMode(self, StorageMode):
        self._StorageMode = StorageMode

    @property
    def MediaName(self):
        r"""输出媒体文件名，最长 64 个字符。缺省由系统指定生成文件名。
        :rtype: str
        """
        return self._MediaName

    @MediaName.setter
    def MediaName(self, MediaName):
        self._MediaName = MediaName

    @property
    def ClassId(self):
        r"""分类ID，用于对媒体进行分类管理，可通过 [创建分类](/document/product/266/7812) 接口，创建分类，获得分类 ID。
<li>默认值：0，表示其他分类。</li>
        :rtype: int
        """
        return self._ClassId

    @ClassId.setter
    def ClassId(self, ClassId):
        self._ClassId = ClassId

    @property
    def ExpireTime(self):
        r"""输出文件的过期时间，超过该时间文件将被删除，默认为永久不过期，格式按照 ISO 8601标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def Duration(self):
        r"""生成视频的时长，单位：秒。<li>当 ModelName 是 Kling，可选值为 5、10，默认为 5；</li><li>当 ModelName 是 Hailuo，可选值为 6、10，默认为 6；</li><li>当 ModelName 是 Vidu，可指定1-10；</li><li>当 ModelName 是 GV，可选值为 8，默认为 8；</li><li>当 ModelName 是 OS，可选值为 4、8、12，默认为 8；</li>
        :rtype: float
        """
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration

    @property
    def Resolution(self):
        r"""生成视频的分辨率。
<li>当 ModelName 是 Kling，可选值为 720P、1080P，默认为 720P；</li>
<li>当 ModelName 是 Hailuo，可选值为 768P、1080P，默认为 768P；</li>
<li>当 ModelName 是 Vidu，可选值为 720P、1080P，默认为 720P；</li>
<li>当 ModelName 是 GV，可选值为 720P、1080P，默认为 720P；</li>
<li>当 ModelName 是 OS，可选值为 720P；</li>
        :rtype: str
        """
        return self._Resolution

    @Resolution.setter
    def Resolution(self, Resolution):
        self._Resolution = Resolution

    @property
    def AspectRatio(self):
        r"""指定所生成视频的宽高比。
<li>当 ModelName 是 Kling，当文生视频时，则可选值为 16:9、9:16、 1:1，默认为16:9；</li>
<li>当 ModelName 是 Vidu，当文生视频时和使用参考图片生成时，则可选值为 16:9、9:16、4:3、3:4、1:1，其中仅版本q2支持4:3、3:4</li>
<li>当 ModelName 是 GV，则可选值为 16:9、9:16，默认为 16:9；</li>
<li>当 ModelName 是 OS，当文生视频时，则可选值为 16:9、9:16，默认为 16:9；</li>
<li>当 ModelName 是 Hailuo，则暂不支持。</li>
        :rtype: str
        """
        return self._AspectRatio

    @AspectRatio.setter
    def AspectRatio(self, AspectRatio):
        self._AspectRatio = AspectRatio

    @property
    def AudioGeneration(self):
        r"""是否生成音频。支持的模型包括 GV、OS、Vidu。取值有： <li>Enabled：开启；</li> <li>Disabled：关闭；</li>
默认值：Disabled
        :rtype: str
        """
        return self._AudioGeneration

    @AudioGeneration.setter
    def AudioGeneration(self, AudioGeneration):
        self._AudioGeneration = AudioGeneration

    @property
    def PersonGeneration(self):
        r"""是否允许人物或人脸生成。取值有： <li>AllowAdult：允许生成成人；</li> <li>Disallowed：禁止在图片中包含人物或人脸；</li> 
        :rtype: str
        """
        return self._PersonGeneration

    @PersonGeneration.setter
    def PersonGeneration(self, PersonGeneration):
        self._PersonGeneration = PersonGeneration

    @property
    def InputComplianceCheck(self):
        r"""是否开启输入内容的合规性检查。取值有： <li>Enabled：开启；</li> <li>Disabled：关闭；</li> 
        :rtype: str
        """
        return self._InputComplianceCheck

    @InputComplianceCheck.setter
    def InputComplianceCheck(self, InputComplianceCheck):
        self._InputComplianceCheck = InputComplianceCheck

    @property
    def OutputComplianceCheck(self):
        r"""是否开启输出内容的合规性检查。取值有： <li>Enabled：开启；</li> <li>Disabled：关闭；</li> 
        :rtype: str
        """
        return self._OutputComplianceCheck

    @OutputComplianceCheck.setter
    def OutputComplianceCheck(self, OutputComplianceCheck):
        self._OutputComplianceCheck = OutputComplianceCheck

    @property
    def EnhanceSwitch(self):
        r"""是否启用视频增强。取值有： <li>Enabled：开启；</li> <li>Disabled：关闭；</li> 
说明：
1. 对于选择的分辨率超过模型可生成分辨率时，默认会启用增强。
2. 对于模型可以直出的分辨率，也可以主动选择模型直出低分辨率，使用增强获得指定分辨率。
        :rtype: str
        """
        return self._EnhanceSwitch

    @EnhanceSwitch.setter
    def EnhanceSwitch(self, EnhanceSwitch):
        self._EnhanceSwitch = EnhanceSwitch

    @property
    def FrameInterpolate(self):
        r"""是否开启vidu智能插帧。取值有： <li>Enabled：开启；</li> <li>Disabled：关闭；</li> 
        :rtype: str
        """
        return self._FrameInterpolate

    @FrameInterpolate.setter
    def FrameInterpolate(self, FrameInterpolate):
        self._FrameInterpolate = FrameInterpolate


    def _deserialize(self, params):
        self._StorageMode = params.get("StorageMode")
        self._MediaName = params.get("MediaName")
        self._ClassId = params.get("ClassId")
        self._ExpireTime = params.get("ExpireTime")
        self._Duration = params.get("Duration")
        self._Resolution = params.get("Resolution")
        self._AspectRatio = params.get("AspectRatio")
        self._AudioGeneration = params.get("AudioGeneration")
        self._PersonGeneration = params.get("PersonGeneration")
        self._InputComplianceCheck = params.get("InputComplianceCheck")
        self._OutputComplianceCheck = params.get("OutputComplianceCheck")
        self._EnhanceSwitch = params.get("EnhanceSwitch")
        self._FrameInterpolate = params.get("FrameInterpolate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AigcVideoTask(AbstractModel):
    r"""AIGC 生视频任务信息

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务 ID。
        :type TaskId: str
        :param _Status: 任务状态，取值：<li>PROCESSING：处理中；</li><li>FINISH：已完成。</li>
        :type Status: str
        :param _ErrCode: 错误码。源异常时返回非0错误码，返回0时请使用各个具体任务的 ErrCode。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Progress: 任务进度，取值范围 [0-100] 。
        :type Progress: int
        :param _Input: AIGC 生视频任务的输入信息。
        :type Input: :class:`tencentcloud.vod.v20180717.models.AigcVideoTaskInput`
        :param _Output: AIGC 生视频任务的输出信息。
        :type Output: :class:`tencentcloud.vod.v20180717.models.AigcVideoTaskOutput`
        :param _SessionId: 用于去重的识别码，如果七天内曾有过相同的识别码的请求，则本次的请求会返回错误。最长 50 个字符，不带或者带空字符串表示不做去重。
        :type SessionId: str
        :param _SessionContext: 来源上下文，用于透传用户请求信息，任务流状态变更回调将返回该字段值，最长 1000 个字符。
        :type SessionContext: str
        """
        self._TaskId = None
        self._Status = None
        self._ErrCode = None
        self._Message = None
        self._Progress = None
        self._Input = None
        self._Output = None
        self._SessionId = None
        self._SessionContext = None

    @property
    def TaskId(self):
        r"""任务 ID。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Status(self):
        r"""任务状态，取值：<li>PROCESSING：处理中；</li><li>FINISH：已完成。</li>
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        r"""错误码。源异常时返回非0错误码，返回0时请使用各个具体任务的 ErrCode。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Progress(self):
        r"""任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def Input(self):
        r"""AIGC 生视频任务的输入信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AigcVideoTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""AIGC 生视频任务的输出信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AigcVideoTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def SessionId(self):
        r"""用于去重的识别码，如果七天内曾有过相同的识别码的请求，则本次的请求会返回错误。最长 50 个字符，不带或者带空字符串表示不做去重。
        :rtype: str
        """
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def SessionContext(self):
        r"""来源上下文，用于透传用户请求信息，任务流状态变更回调将返回该字段值，最长 1000 个字符。
        :rtype: str
        """
        return self._SessionContext

    @SessionContext.setter
    def SessionContext(self, SessionContext):
        self._SessionContext = SessionContext


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        self._Progress = params.get("Progress")
        if params.get("Input") is not None:
            self._Input = AigcVideoTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AigcVideoTaskOutput()
            self._Output._deserialize(params.get("Output"))
        self._SessionId = params.get("SessionId")
        self._SessionContext = params.get("SessionContext")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AigcVideoTaskInput(AbstractModel):
    r"""AIGC 生视频任务的输入。

    """

    def __init__(self):
        r"""
        :param _ModelName: 模型名称。
        :type ModelName: str
        :param _ModelVersion: 模型版本。
        :type ModelVersion: str
        :param _FileInfos: AIGC生图任务输入文件信息。
        :type FileInfos: list of AigcVideoTaskInputFileInfo
        :param _LastFrameFileId: 用于作为尾帧画面来生成视频的媒体文件 ID。该文件在云点播上的全局唯一标识符，在上传成功后由云点播后台分配。可以在 [视频上传完成事件通知](/document/product/266/7830) 或 [云点播控制台](https://console.cloud.tencent.com/vod/media) 获取该字段。
        :type LastFrameFileId: str
        :param _Prompt: 生成视频的提示词。最大支持1000字符，当 FileInfos 为空时，此参数必填。
        :type Prompt: str
        :param _NegativePrompt: 要阻止模型生成视频的提示词。最大支持1000字符。
        :type NegativePrompt: str
        :param _EnhancePrompt: 是否自动优化提示词。开启时将自动优化传入的Prompt，以提升生成质量。取值有： <li>Enabled：开启；</li> <li>Disabled：关闭；</li> 
        :type EnhancePrompt: str
        :param _GenerationMode: 生成模式。取值有： <li>Standard：标准模式；</li> <li>Professional：高品质模式；</li> 
        :type GenerationMode: str
        :param _OutputConfig: AIGC 生图输出结果文件输出。
        :type OutputConfig: :class:`tencentcloud.vod.v20180717.models.AigcVideoOutputConfig`
        """
        self._ModelName = None
        self._ModelVersion = None
        self._FileInfos = None
        self._LastFrameFileId = None
        self._Prompt = None
        self._NegativePrompt = None
        self._EnhancePrompt = None
        self._GenerationMode = None
        self._OutputConfig = None

    @property
    def ModelName(self):
        r"""模型名称。
        :rtype: str
        """
        return self._ModelName

    @ModelName.setter
    def ModelName(self, ModelName):
        self._ModelName = ModelName

    @property
    def ModelVersion(self):
        r"""模型版本。
        :rtype: str
        """
        return self._ModelVersion

    @ModelVersion.setter
    def ModelVersion(self, ModelVersion):
        self._ModelVersion = ModelVersion

    @property
    def FileInfos(self):
        r"""AIGC生图任务输入文件信息。
        :rtype: list of AigcVideoTaskInputFileInfo
        """
        return self._FileInfos

    @FileInfos.setter
    def FileInfos(self, FileInfos):
        self._FileInfos = FileInfos

    @property
    def LastFrameFileId(self):
        r"""用于作为尾帧画面来生成视频的媒体文件 ID。该文件在云点播上的全局唯一标识符，在上传成功后由云点播后台分配。可以在 [视频上传完成事件通知](/document/product/266/7830) 或 [云点播控制台](https://console.cloud.tencent.com/vod/media) 获取该字段。
        :rtype: str
        """
        return self._LastFrameFileId

    @LastFrameFileId.setter
    def LastFrameFileId(self, LastFrameFileId):
        self._LastFrameFileId = LastFrameFileId

    @property
    def Prompt(self):
        r"""生成视频的提示词。最大支持1000字符，当 FileInfos 为空时，此参数必填。
        :rtype: str
        """
        return self._Prompt

    @Prompt.setter
    def Prompt(self, Prompt):
        self._Prompt = Prompt

    @property
    def NegativePrompt(self):
        r"""要阻止模型生成视频的提示词。最大支持1000字符。
        :rtype: str
        """
        return self._NegativePrompt

    @NegativePrompt.setter
    def NegativePrompt(self, NegativePrompt):
        self._NegativePrompt = NegativePrompt

    @property
    def EnhancePrompt(self):
        r"""是否自动优化提示词。开启时将自动优化传入的Prompt，以提升生成质量。取值有： <li>Enabled：开启；</li> <li>Disabled：关闭；</li> 
        :rtype: str
        """
        return self._EnhancePrompt

    @EnhancePrompt.setter
    def EnhancePrompt(self, EnhancePrompt):
        self._EnhancePrompt = EnhancePrompt

    @property
    def GenerationMode(self):
        r"""生成模式。取值有： <li>Standard：标准模式；</li> <li>Professional：高品质模式；</li> 
        :rtype: str
        """
        return self._GenerationMode

    @GenerationMode.setter
    def GenerationMode(self, GenerationMode):
        self._GenerationMode = GenerationMode

    @property
    def OutputConfig(self):
        r"""AIGC 生图输出结果文件输出。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AigcVideoOutputConfig`
        """
        return self._OutputConfig

    @OutputConfig.setter
    def OutputConfig(self, OutputConfig):
        self._OutputConfig = OutputConfig


    def _deserialize(self, params):
        self._ModelName = params.get("ModelName")
        self._ModelVersion = params.get("ModelVersion")
        if params.get("FileInfos") is not None:
            self._FileInfos = []
            for item in params.get("FileInfos"):
                obj = AigcVideoTaskInputFileInfo()
                obj._deserialize(item)
                self._FileInfos.append(obj)
        self._LastFrameFileId = params.get("LastFrameFileId")
        self._Prompt = params.get("Prompt")
        self._NegativePrompt = params.get("NegativePrompt")
        self._EnhancePrompt = params.get("EnhancePrompt")
        self._GenerationMode = params.get("GenerationMode")
        if params.get("OutputConfig") is not None:
            self._OutputConfig = AigcVideoOutputConfig()
            self._OutputConfig._deserialize(params.get("OutputConfig"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AigcVideoTaskInputFileInfo(AbstractModel):
    r"""AIGC 生视频任务输入的图片文件信息。

    """

    def __init__(self):
        r"""
        :param _Type: 输入的视频文件类型。取值有： <li>File：点播媒体文件；</li> <li>Url：可访问的 URL；</li> 
        :type Type: str
        :param _FileId: 媒体文件 ID，即该文件在云点播上的全局唯一标识符，在上传成功后由云点播后台分配。可以在 [视频上传完成事件通知](/document/product/266/7830) 或 [云点播控制台](https://console.cloud.tencent.com/vod/media) 获取该字段。当 Type 取值为 File 时，本参数有效。说明：
1. 推荐使用小于10M的图片；
2. 图片格式的取值为：jpeg，jpg, png。
        :type FileId: str
        :param _Url: 可访问的文件 URL。当 Type 取值为 Url 时，本参数有效。
说明：
1. 推荐使用小于10M的图片；
2. 图片格式的取值为：jpeg，jpg, png。
        :type Url: str
        :param _ReferenceType: 参考类型，GV模型适用。
注意：

当使用GV模型时，可作为参考方式,可选asset(素材)、style(风格)。
        :type ReferenceType: str
        :param _ObjectId: 主体id.
适用模型：Vidu-q2.
当需要对图片标识主体时，需要每个图片都带主体id，后续生成时可以通过@主体id的方式使用。
        :type ObjectId: str
        :param _VoiceId: 适用于Vidu-q2模型。
当全部图片携带主体id时，可针对主体设置音色id。 音色列表：https://shengshu.feishu.cn/sheets/EgFvs6DShhiEBStmjzccr5gonOg
        :type VoiceId: str
        """
        self._Type = None
        self._FileId = None
        self._Url = None
        self._ReferenceType = None
        self._ObjectId = None
        self._VoiceId = None

    @property
    def Type(self):
        r"""输入的视频文件类型。取值有： <li>File：点播媒体文件；</li> <li>Url：可访问的 URL；</li> 
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def FileId(self):
        r"""媒体文件 ID，即该文件在云点播上的全局唯一标识符，在上传成功后由云点播后台分配。可以在 [视频上传完成事件通知](/document/product/266/7830) 或 [云点播控制台](https://console.cloud.tencent.com/vod/media) 获取该字段。当 Type 取值为 File 时，本参数有效。说明：
1. 推荐使用小于10M的图片；
2. 图片格式的取值为：jpeg，jpg, png。
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def Url(self):
        r"""可访问的文件 URL。当 Type 取值为 Url 时，本参数有效。
说明：
1. 推荐使用小于10M的图片；
2. 图片格式的取值为：jpeg，jpg, png。
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def ReferenceType(self):
        r"""参考类型，GV模型适用。
注意：

当使用GV模型时，可作为参考方式,可选asset(素材)、style(风格)。
        :rtype: str
        """
        return self._ReferenceType

    @ReferenceType.setter
    def ReferenceType(self, ReferenceType):
        self._ReferenceType = ReferenceType

    @property
    def ObjectId(self):
        r"""主体id.
适用模型：Vidu-q2.
当需要对图片标识主体时，需要每个图片都带主体id，后续生成时可以通过@主体id的方式使用。
        :rtype: str
        """
        return self._ObjectId

    @ObjectId.setter
    def ObjectId(self, ObjectId):
        self._ObjectId = ObjectId

    @property
    def VoiceId(self):
        r"""适用于Vidu-q2模型。
当全部图片携带主体id时，可针对主体设置音色id。 音色列表：https://shengshu.feishu.cn/sheets/EgFvs6DShhiEBStmjzccr5gonOg
        :rtype: str
        """
        return self._VoiceId

    @VoiceId.setter
    def VoiceId(self, VoiceId):
        self._VoiceId = VoiceId


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._FileId = params.get("FileId")
        self._Url = params.get("Url")
        self._ReferenceType = params.get("ReferenceType")
        self._ObjectId = params.get("ObjectId")
        self._VoiceId = params.get("VoiceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AigcVideoTaskOutput(AbstractModel):
    r"""AIGC 生视频任务的输出信息。

    """

    def __init__(self):
        r"""
        :param _FileInfos: AIGC 生视频任务的输出文件信息。	
        :type FileInfos: list of AigcVideoTaskOutputFileInfo
        """
        self._FileInfos = None

    @property
    def FileInfos(self):
        r"""AIGC 生视频任务的输出文件信息。	
        :rtype: list of AigcVideoTaskOutputFileInfo
        """
        return self._FileInfos

    @FileInfos.setter
    def FileInfos(self, FileInfos):
        self._FileInfos = FileInfos


    def _deserialize(self, params):
        if params.get("FileInfos") is not None:
            self._FileInfos = []
            for item in params.get("FileInfos"):
                obj = AigcVideoTaskOutputFileInfo()
                obj._deserialize(item)
                self._FileInfos.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AigcVideoTaskOutputFileInfo(AbstractModel):
    r"""AIGC 生视频任务的输出文件信息。

    """

    def __init__(self):
        r"""
        :param _StorageMode: 存储模式。取值有： <li>Permanent：永久存储；</li> <li>Temporary：临时存储；</li>
默认值：Temporary
        :type StorageMode: str
        :param _MediaName: 输出文件名，最长 64 个字符。缺省由系统指定生成文件名。当 StorageMode 为 Permanent 时有效。
        :type MediaName: str
        :param _ClassId: 分类ID，用于对媒体进行分类管理，可通过 [创建分类](/document/product/266/7812) 接口，创建分类，获得分类 ID。当 StorageMode 为 Permanent 时有效。

        :type ClassId: int
        :param _ExpireTime: 输出文件的过期时间，超过该时间文件将被删除，默认为永久不过期，格式按照 ISO 8601标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :type ExpireTime: str
        :param _FileType: 文件类型，例如 mp4、flv 等。
        :type FileType: str
        :param _FileUrl: 媒体文件播放地址。
        :type FileUrl: str
        :param _FileId: 媒体文件 ID。当 StorageMode 为 Permanent 时有效。
        :type FileId: str
        :param _MetaData: 输出视频的元信息。当 StorageMode 为 Permanent 时有效。
        :type MetaData: :class:`tencentcloud.vod.v20180717.models.MediaMetaData`
        """
        self._StorageMode = None
        self._MediaName = None
        self._ClassId = None
        self._ExpireTime = None
        self._FileType = None
        self._FileUrl = None
        self._FileId = None
        self._MetaData = None

    @property
    def StorageMode(self):
        r"""存储模式。取值有： <li>Permanent：永久存储；</li> <li>Temporary：临时存储；</li>
默认值：Temporary
        :rtype: str
        """
        return self._StorageMode

    @StorageMode.setter
    def StorageMode(self, StorageMode):
        self._StorageMode = StorageMode

    @property
    def MediaName(self):
        r"""输出文件名，最长 64 个字符。缺省由系统指定生成文件名。当 StorageMode 为 Permanent 时有效。
        :rtype: str
        """
        return self._MediaName

    @MediaName.setter
    def MediaName(self, MediaName):
        self._MediaName = MediaName

    @property
    def ClassId(self):
        r"""分类ID，用于对媒体进行分类管理，可通过 [创建分类](/document/product/266/7812) 接口，创建分类，获得分类 ID。当 StorageMode 为 Permanent 时有效。

        :rtype: int
        """
        return self._ClassId

    @ClassId.setter
    def ClassId(self, ClassId):
        self._ClassId = ClassId

    @property
    def ExpireTime(self):
        r"""输出文件的过期时间，超过该时间文件将被删除，默认为永久不过期，格式按照 ISO 8601标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def FileType(self):
        r"""文件类型，例如 mp4、flv 等。
        :rtype: str
        """
        return self._FileType

    @FileType.setter
    def FileType(self, FileType):
        self._FileType = FileType

    @property
    def FileUrl(self):
        r"""媒体文件播放地址。
        :rtype: str
        """
        return self._FileUrl

    @FileUrl.setter
    def FileUrl(self, FileUrl):
        self._FileUrl = FileUrl

    @property
    def FileId(self):
        r"""媒体文件 ID。当 StorageMode 为 Permanent 时有效。
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def MetaData(self):
        r"""输出视频的元信息。当 StorageMode 为 Permanent 时有效。
        :rtype: :class:`tencentcloud.vod.v20180717.models.MediaMetaData`
        """
        return self._MetaData

    @MetaData.setter
    def MetaData(self, MetaData):
        self._MetaData = MetaData


    def _deserialize(self, params):
        self._StorageMode = params.get("StorageMode")
        self._MediaName = params.get("MediaName")
        self._ClassId = params.get("ClassId")
        self._ExpireTime = params.get("ExpireTime")
        self._FileType = params.get("FileType")
        self._FileUrl = params.get("FileUrl")
        self._FileId = params.get("FileId")
        if params.get("MetaData") is not None:
            self._MetaData = MediaMetaData()
            self._MetaData._deserialize(params.get("MetaData"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AnimatedGraphicTaskInput(AbstractModel):
    r"""转动图任务类型

    """

    def __init__(self):
        r"""
        :param _Definition: 视频转动图模板 ID
        :type Definition: int
        :param _StartTimeOffset: 动图在视频中的起始时间偏移，单位为秒。
<li>不填或填0，表示从视频的起始位置开始；</li>
<li>当数值大于0时（假设为 n），表示从视频的第 n 秒位置开始；</li>
<li>当数值小于0时（假设为 -n），表示从视频结束 n 秒前的位置开始。</li>
        :type StartTimeOffset: float
        :param _EndTimeOffset: 动图在视频中的终止时间偏移，单位为秒。
<li>不填或填0，表示持续到视频的末尾终止；</li>
<li>当数值大于0时（假设为 n），表示持续到视频第 n 秒时终止；</li>
<li>当数值小于0时（假设为 -n），表示持续到视频结束 n 秒前终止。</li>
        :type EndTimeOffset: float
        """
        self._Definition = None
        self._StartTimeOffset = None
        self._EndTimeOffset = None

    @property
    def Definition(self):
        r"""视频转动图模板 ID
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def StartTimeOffset(self):
        r"""动图在视频中的起始时间偏移，单位为秒。
<li>不填或填0，表示从视频的起始位置开始；</li>
<li>当数值大于0时（假设为 n），表示从视频的第 n 秒位置开始；</li>
<li>当数值小于0时（假设为 -n），表示从视频结束 n 秒前的位置开始。</li>
        :rtype: float
        """
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        r"""动图在视频中的终止时间偏移，单位为秒。
<li>不填或填0，表示持续到视频的末尾终止；</li>
<li>当数值大于0时（假设为 n），表示持续到视频第 n 秒时终止；</li>
<li>当数值小于0时（假设为 -n），表示持续到视频结束 n 秒前终止。</li>
        :rtype: float
        """
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AnimatedGraphicsTemplate(AbstractModel):
    r"""转动图模板详情。

    """

    def __init__(self):
        r"""
        :param _Definition: 转动图模板唯一标识。
        :type Definition: int
        :param _Type: 模板类型，取值范围：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :type Type: str
        :param _Name: 转动图模板名称。
        :type Name: str
        :param _Comment: 转动图模板描述信息。
        :type Comment: str
        :param _Width: 动图宽度（或长边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Width: int
        :param _Height: 动图高度（或短边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Height: int
        :param _ResolutionAdaptive: 分辨率自适应，可选值：
<li>open：开启，此时，Width 代表视频的长边，Height 表示视频的短边；</li>
<li>close：关闭，此时，Width 代表视频的宽度，Height 表示视频的高度。</li>
默认值：open。
        :type ResolutionAdaptive: str
        :param _Format: 动图格式。
        :type Format: str
        :param _Fps: 帧率。
        :type Fps: int
        :param _Quality: 图片质量。
        :type Quality: float
        :param _CreateTime: 模板创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type CreateTime: str
        :param _UpdateTime: 模板最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type UpdateTime: str
        """
        self._Definition = None
        self._Type = None
        self._Name = None
        self._Comment = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._Format = None
        self._Fps = None
        self._Quality = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def Definition(self):
        r"""转动图模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Type(self):
        r"""模板类型，取值范围：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        r"""转动图模板名称。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        r"""转动图模板描述信息。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def Width(self):
        r"""动图宽度（或长边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :rtype: int
        """
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        r"""动图高度（或短边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :rtype: int
        """
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        r"""分辨率自适应，可选值：
<li>open：开启，此时，Width 代表视频的长边，Height 表示视频的短边；</li>
<li>close：关闭，此时，Width 代表视频的宽度，Height 表示视频的高度。</li>
默认值：open。
        :rtype: str
        """
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def Format(self):
        r"""动图格式。
        :rtype: str
        """
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def Fps(self):
        r"""帧率。
        :rtype: int
        """
        return self._Fps

    @Fps.setter
    def Fps(self, Fps):
        self._Fps = Fps

    @property
    def Quality(self):
        r"""图片质量。
        :rtype: float
        """
        return self._Quality

    @Quality.setter
    def Quality(self, Quality):
        self._Quality = Quality

    @property
    def CreateTime(self):
        r"""模板创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""模板最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._Format = params.get("Format")
        self._Fps = params.get("Fps")
        self._Quality = params.get("Quality")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApplyUploadRequest(AbstractModel):
    r"""ApplyUpload请求参数结构体

    """

    def __init__(self):
        r"""
        :param _MediaType: 媒体类型，可选值请参考 [上传能力综述](/document/product/266/9760#.E6.96.87.E4.BB.B6.E7.B1.BB.E5.9E.8B)。
        :type MediaType: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _MediaName: 媒体名称。
        :type MediaName: str
        :param _CoverType: 封面类型，可选值请参考 [上传能力综述](/document/product/266/9760#.E6.96.87.E4.BB.B6.E7.B1.BB.E5.9E.8B)。
        :type CoverType: str
        :param _Procedure: 媒体后续任务处理操作，即完成媒体上传后，可自动发起任务流操作。参数值为任务流模板名，云点播支持 [创建任务流模板](/document/product/266/33819) 并为模板命名。
        :type Procedure: str
        :param _ExpireTime: 媒体文件过期时间，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](/document/product/266/11732#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F)。
        :type ExpireTime: str
        :param _StorageRegion: 指定上传园区，仅适用于对上传地域有特殊需求的用户。
        :type StorageRegion: str
        :param _ClassId: 分类ID，用于对媒体进行分类管理，可通过 [创建分类](/document/product/266/7812) 接口，创建分类，获得分类 ID。
<li>默认值：0，表示其他分类。</li>
        :type ClassId: int
        :param _SourceContext: 来源上下文，用于透传用户请求信息，[上传完成回调](/document/product/266/7830) 将返回该字段值，最长 250 个字符。
        :type SourceContext: str
        :param _SessionContext: 会话上下文，用于透传用户请求信息，当指定 Procedure 参数后，[任务流状态变更回调](/document/product/266/9636) 将返回该字段值，最长 1000 个字符。
        :type SessionContext: str
        :param _ExtInfo: 保留字段，特殊用途时使用。
        :type ExtInfo: str
        """
        self._MediaType = None
        self._SubAppId = None
        self._MediaName = None
        self._CoverType = None
        self._Procedure = None
        self._ExpireTime = None
        self._StorageRegion = None
        self._ClassId = None
        self._SourceContext = None
        self._SessionContext = None
        self._ExtInfo = None

    @property
    def MediaType(self):
        r"""媒体类型，可选值请参考 [上传能力综述](/document/product/266/9760#.E6.96.87.E4.BB.B6.E7.B1.BB.E5.9E.8B)。
        :rtype: str
        """
        return self._MediaType

    @MediaType.setter
    def MediaType(self, MediaType):
        self._MediaType = MediaType

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def MediaName(self):
        r"""媒体名称。
        :rtype: str
        """
        return self._MediaName

    @MediaName.setter
    def MediaName(self, MediaName):
        self._MediaName = MediaName

    @property
    def CoverType(self):
        r"""封面类型，可选值请参考 [上传能力综述](/document/product/266/9760#.E6.96.87.E4.BB.B6.E7.B1.BB.E5.9E.8B)。
        :rtype: str
        """
        return self._CoverType

    @CoverType.setter
    def CoverType(self, CoverType):
        self._CoverType = CoverType

    @property
    def Procedure(self):
        r"""媒体后续任务处理操作，即完成媒体上传后，可自动发起任务流操作。参数值为任务流模板名，云点播支持 [创建任务流模板](/document/product/266/33819) 并为模板命名。
        :rtype: str
        """
        return self._Procedure

    @Procedure.setter
    def Procedure(self, Procedure):
        self._Procedure = Procedure

    @property
    def ExpireTime(self):
        r"""媒体文件过期时间，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](/document/product/266/11732#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F)。
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def StorageRegion(self):
        r"""指定上传园区，仅适用于对上传地域有特殊需求的用户。
        :rtype: str
        """
        return self._StorageRegion

    @StorageRegion.setter
    def StorageRegion(self, StorageRegion):
        self._StorageRegion = StorageRegion

    @property
    def ClassId(self):
        r"""分类ID，用于对媒体进行分类管理，可通过 [创建分类](/document/product/266/7812) 接口，创建分类，获得分类 ID。
<li>默认值：0，表示其他分类。</li>
        :rtype: int
        """
        return self._ClassId

    @ClassId.setter
    def ClassId(self, ClassId):
        self._ClassId = ClassId

    @property
    def SourceContext(self):
        r"""来源上下文，用于透传用户请求信息，[上传完成回调](/document/product/266/7830) 将返回该字段值，最长 250 个字符。
        :rtype: str
        """
        return self._SourceContext

    @SourceContext.setter
    def SourceContext(self, SourceContext):
        self._SourceContext = SourceContext

    @property
    def SessionContext(self):
        r"""会话上下文，用于透传用户请求信息，当指定 Procedure 参数后，[任务流状态变更回调](/document/product/266/9636) 将返回该字段值，最长 1000 个字符。
        :rtype: str
        """
        return self._SessionContext

    @SessionContext.setter
    def SessionContext(self, SessionContext):
        self._SessionContext = SessionContext

    @property
    def ExtInfo(self):
        r"""保留字段，特殊用途时使用。
        :rtype: str
        """
        return self._ExtInfo

    @ExtInfo.setter
    def ExtInfo(self, ExtInfo):
        self._ExtInfo = ExtInfo


    def _deserialize(self, params):
        self._MediaType = params.get("MediaType")
        self._SubAppId = params.get("SubAppId")
        self._MediaName = params.get("MediaName")
        self._CoverType = params.get("CoverType")
        self._Procedure = params.get("Procedure")
        self._ExpireTime = params.get("ExpireTime")
        self._StorageRegion = params.get("StorageRegion")
        self._ClassId = params.get("ClassId")
        self._SourceContext = params.get("SourceContext")
        self._SessionContext = params.get("SessionContext")
        self._ExtInfo = params.get("ExtInfo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApplyUploadResponse(AbstractModel):
    r"""ApplyUpload返回参数结构体

    """

    def __init__(self):
        r"""
        :param _StorageBucket: 存储桶，用于上传接口 URL 的 bucket_name。
        :type StorageBucket: str
        :param _StorageRegion: 存储园区，用于上传接口 Host 的 Region。
        :type StorageRegion: str
        :param _VodSessionKey: 点播会话，用于确认上传接口的参数 VodSessionKey。
        :type VodSessionKey: str
        :param _MediaStoragePath: 媒体存储路径，用于上传接口存储媒体的对象键（Key）。
        :type MediaStoragePath: str
        :param _CoverStoragePath: 封面存储路径，用于上传接口存储封面的对象键（Key）。
        :type CoverStoragePath: str
        :param _TempCertificate: 临时凭证，用于上传接口的权限验证。
        :type TempCertificate: :class:`tencentcloud.vod.v20180717.models.TempCertificate`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._StorageBucket = None
        self._StorageRegion = None
        self._VodSessionKey = None
        self._MediaStoragePath = None
        self._CoverStoragePath = None
        self._TempCertificate = None
        self._RequestId = None

    @property
    def StorageBucket(self):
        r"""存储桶，用于上传接口 URL 的 bucket_name。
        :rtype: str
        """
        return self._StorageBucket

    @StorageBucket.setter
    def StorageBucket(self, StorageBucket):
        self._StorageBucket = StorageBucket

    @property
    def StorageRegion(self):
        r"""存储园区，用于上传接口 Host 的 Region。
        :rtype: str
        """
        return self._StorageRegion

    @StorageRegion.setter
    def StorageRegion(self, StorageRegion):
        self._StorageRegion = StorageRegion

    @property
    def VodSessionKey(self):
        r"""点播会话，用于确认上传接口的参数 VodSessionKey。
        :rtype: str
        """
        return self._VodSessionKey

    @VodSessionKey.setter
    def VodSessionKey(self, VodSessionKey):
        self._VodSessionKey = VodSessionKey

    @property
    def MediaStoragePath(self):
        r"""媒体存储路径，用于上传接口存储媒体的对象键（Key）。
        :rtype: str
        """
        return self._MediaStoragePath

    @MediaStoragePath.setter
    def MediaStoragePath(self, MediaStoragePath):
        self._MediaStoragePath = MediaStoragePath

    @property
    def CoverStoragePath(self):
        r"""封面存储路径，用于上传接口存储封面的对象键（Key）。
        :rtype: str
        """
        return self._CoverStoragePath

    @CoverStoragePath.setter
    def CoverStoragePath(self, CoverStoragePath):
        self._CoverStoragePath = CoverStoragePath

    @property
    def TempCertificate(self):
        r"""临时凭证，用于上传接口的权限验证。
        :rtype: :class:`tencentcloud.vod.v20180717.models.TempCertificate`
        """
        return self._TempCertificate

    @TempCertificate.setter
    def TempCertificate(self, TempCertificate):
        self._TempCertificate = TempCertificate

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._StorageBucket = params.get("StorageBucket")
        self._StorageRegion = params.get("StorageRegion")
        self._VodSessionKey = params.get("VodSessionKey")
        self._MediaStoragePath = params.get("MediaStoragePath")
        self._CoverStoragePath = params.get("CoverStoragePath")
        if params.get("TempCertificate") is not None:
            self._TempCertificate = TempCertificate()
            self._TempCertificate._deserialize(params.get("TempCertificate"))
        self._RequestId = params.get("RequestId")


class AreaCLSTargetInfo(AbstractModel):
    r"""日志推送目标。

    """

    def __init__(self):
        r"""
        :param _CLSRegion: 日志集所属地区：
<li>ap-guangzhou：广州；</li>
<li>ap-beijing：北京；</li>
<li>ap-chengdu：成都；</li>
<li>ap-chongqing：重庆；</li>
<li>ap-nanjing：南京；</li>
<li>ap-shanghai：上海；</li>
<li>ap-singapore：新加坡。</li>
        :type CLSRegion: str
        :param _TopicId: 投递的目标主题 ID。
        :type TopicId: str
        :param _LogsetId: 投递的目标集 ID。
        :type LogsetId: str
        :param _Switch: 日志投递状态。
 ON：启用；
 OFF：停用。
        :type Switch: str
        """
        self._CLSRegion = None
        self._TopicId = None
        self._LogsetId = None
        self._Switch = None

    @property
    def CLSRegion(self):
        r"""日志集所属地区：
<li>ap-guangzhou：广州；</li>
<li>ap-beijing：北京；</li>
<li>ap-chengdu：成都；</li>
<li>ap-chongqing：重庆；</li>
<li>ap-nanjing：南京；</li>
<li>ap-shanghai：上海；</li>
<li>ap-singapore：新加坡。</li>
        :rtype: str
        """
        return self._CLSRegion

    @CLSRegion.setter
    def CLSRegion(self, CLSRegion):
        self._CLSRegion = CLSRegion

    @property
    def TopicId(self):
        r"""投递的目标主题 ID。
        :rtype: str
        """
        return self._TopicId

    @TopicId.setter
    def TopicId(self, TopicId):
        self._TopicId = TopicId

    @property
    def LogsetId(self):
        r"""投递的目标集 ID。
        :rtype: str
        """
        return self._LogsetId

    @LogsetId.setter
    def LogsetId(self, LogsetId):
        self._LogsetId = LogsetId

    @property
    def Switch(self):
        r"""日志投递状态。
 ON：启用；
 OFF：停用。
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._CLSRegion = params.get("CLSRegion")
        self._TopicId = params.get("TopicId")
        self._LogsetId = params.get("LogsetId")
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ArtifactRepairInfo(AbstractModel):
    r"""去伪影（毛刺）控制信息

    """

    def __init__(self):
        r"""
        :param _Switch: 去伪影（毛刺）控制开关，可选值：
<li>ON：开启去伪影（毛刺）；</li>
<li>OFF：关闭去伪影（毛刺）。</li>
        :type Switch: str
        :param _Type: 去伪影（毛刺）类型，仅当去伪影（毛刺）控制开关为 ON 时有效，可选值：
<li>weak：轻去伪影（毛刺）；</li>
<li>strong：强去伪影（毛刺）。</li>
默认值：weak。
        :type Type: str
        """
        self._Switch = None
        self._Type = None

    @property
    def Switch(self):
        r"""去伪影（毛刺）控制开关，可选值：
<li>ON：开启去伪影（毛刺）；</li>
<li>OFF：关闭去伪影（毛刺）。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Type(self):
        r"""去伪影（毛刺）类型，仅当去伪影（毛刺）控制开关为 ON 时有效，可选值：
<li>weak：轻去伪影（毛刺）；</li>
<li>strong：强去伪影（毛刺）。</li>
默认值：weak。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AsrFullTextConfigureInfo(AbstractModel):
    r"""语音全文识别任务控制参数。
    <font color=red>注意：本参数已不再维护，推荐使用 AsrTranslateConfigure 参数发起语音翻译识别（当 DstLanguage 不填或填空字符串时，则不进行翻译，计费项和语音全文识别一致）。</font>

    """

    def __init__(self):
        r"""
        :param _Switch: 语音全文识别任务开关，可选值：
<li>ON：开启智能语音全文识别任务；</li>
<li>OFF：关闭智能语音全文识别任务。</li>
        :type Switch: str
        :param _SubtitleFormats: 生成的字幕文件格式列表，不填或者填空数组表示不生成字幕文件，可选值：
<li>vtt：生成 WebVTT 字幕文件；</li>
<li>srt：生成 SRT 字幕文件。</li><font color=red>注意：</font>云点播媒资信息仅支持添加 vtt 字幕，因此当且仅当 SubtitleFormats 包含 vtt 时，云点播将生成的字幕添加到媒资。
        :type SubtitleFormats: list of str
        :param _SubtitleFormat: 生成的字幕文件格式，不填或者填空字符串表示不生成字幕文件，可选值：
<li>vtt：生成 WebVTT 字幕文件；</li>
<li>srt：生成 SRT 字幕文件。</li>
<font color='red'>注意：此字段已废弃，建议使用 SubtitleFormats。</font>
        :type SubtitleFormat: str
        :param _SrcLanguage: 媒体源语言，取值范围：
<li>zh：中文普通话；</li>
<li>en：英语；</li>
<li>ja：日语；</li>
<li>zh-ca：粤语。</li>
<font color=red>注意：</font> 填空字符串，或者不填该参数，则自动识别（效果较难保证，推荐填写原始媒体对应的语言，以提高识别的准确率）。
        :type SrcLanguage: str
        :param _SubtitleName: 指定字幕名称，长度限制：64 个字符。该值将用于播放器展示，若不填则云点播自动生成。
<font color=red>注意：</font>仅当 SubtitleFormats 包含 vtt 时，该字段有效。
        :type SubtitleName: str
        """
        self._Switch = None
        self._SubtitleFormats = None
        self._SubtitleFormat = None
        self._SrcLanguage = None
        self._SubtitleName = None

    @property
    def Switch(self):
        r"""语音全文识别任务开关，可选值：
<li>ON：开启智能语音全文识别任务；</li>
<li>OFF：关闭智能语音全文识别任务。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def SubtitleFormats(self):
        r"""生成的字幕文件格式列表，不填或者填空数组表示不生成字幕文件，可选值：
<li>vtt：生成 WebVTT 字幕文件；</li>
<li>srt：生成 SRT 字幕文件。</li><font color=red>注意：</font>云点播媒资信息仅支持添加 vtt 字幕，因此当且仅当 SubtitleFormats 包含 vtt 时，云点播将生成的字幕添加到媒资。
        :rtype: list of str
        """
        return self._SubtitleFormats

    @SubtitleFormats.setter
    def SubtitleFormats(self, SubtitleFormats):
        self._SubtitleFormats = SubtitleFormats

    @property
    def SubtitleFormat(self):
        warnings.warn("parameter `SubtitleFormat` is deprecated", DeprecationWarning) 

        r"""生成的字幕文件格式，不填或者填空字符串表示不生成字幕文件，可选值：
<li>vtt：生成 WebVTT 字幕文件；</li>
<li>srt：生成 SRT 字幕文件。</li>
<font color='red'>注意：此字段已废弃，建议使用 SubtitleFormats。</font>
        :rtype: str
        """
        return self._SubtitleFormat

    @SubtitleFormat.setter
    def SubtitleFormat(self, SubtitleFormat):
        warnings.warn("parameter `SubtitleFormat` is deprecated", DeprecationWarning) 

        self._SubtitleFormat = SubtitleFormat

    @property
    def SrcLanguage(self):
        r"""媒体源语言，取值范围：
<li>zh：中文普通话；</li>
<li>en：英语；</li>
<li>ja：日语；</li>
<li>zh-ca：粤语。</li>
<font color=red>注意：</font> 填空字符串，或者不填该参数，则自动识别（效果较难保证，推荐填写原始媒体对应的语言，以提高识别的准确率）。
        :rtype: str
        """
        return self._SrcLanguage

    @SrcLanguage.setter
    def SrcLanguage(self, SrcLanguage):
        self._SrcLanguage = SrcLanguage

    @property
    def SubtitleName(self):
        r"""指定字幕名称，长度限制：64 个字符。该值将用于播放器展示，若不填则云点播自动生成。
<font color=red>注意：</font>仅当 SubtitleFormats 包含 vtt 时，该字段有效。
        :rtype: str
        """
        return self._SubtitleName

    @SubtitleName.setter
    def SubtitleName(self, SubtitleName):
        self._SubtitleName = SubtitleName


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._SubtitleFormats = params.get("SubtitleFormats")
        self._SubtitleFormat = params.get("SubtitleFormat")
        self._SrcLanguage = params.get("SrcLanguage")
        self._SubtitleName = params.get("SubtitleName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AsrFullTextConfigureInfoForUpdate(AbstractModel):
    r"""语音全文识别任务控制参数

    """

    def __init__(self):
        r"""
        :param _Switch: 语音全文识别任务开关，可选值：
<li>ON：开启智能语音全文识别任务；</li>
<li>OFF：关闭智能语音全文识别任务。</li>
        :type Switch: str
        :param _SubtitleFormatsOperation: 字幕格式列表操作信息。
        :type SubtitleFormatsOperation: :class:`tencentcloud.vod.v20180717.models.SubtitleFormatsOperation`
        :param _SubtitleFormat: 生成的字幕文件格式，<font color='red'>填空字符串</font>表示不生成字幕文件，可选值：
<li>vtt：生成 WebVTT 字幕文件；</li>
<li>srt：生成 SRT 字幕文件。</li>
<font color='red'>注意：此字段已废弃，建议使用 SubtitleFormatsOperation。</font>
        :type SubtitleFormat: str
        :param _SrcLanguage: 媒体源语言，取值范围：
<li>zh：中文普通话；</li>
<li>en：英语；</li>
<li>ja：日语；</li>
<li>zh-ca：粤语。</li>
        :type SrcLanguage: str
        :param _SubtitleName: 指定字幕名称，长度限制：64 个字符。该值将用于播放器展示。
        :type SubtitleName: str
        """
        self._Switch = None
        self._SubtitleFormatsOperation = None
        self._SubtitleFormat = None
        self._SrcLanguage = None
        self._SubtitleName = None

    @property
    def Switch(self):
        r"""语音全文识别任务开关，可选值：
<li>ON：开启智能语音全文识别任务；</li>
<li>OFF：关闭智能语音全文识别任务。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def SubtitleFormatsOperation(self):
        r"""字幕格式列表操作信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.SubtitleFormatsOperation`
        """
        return self._SubtitleFormatsOperation

    @SubtitleFormatsOperation.setter
    def SubtitleFormatsOperation(self, SubtitleFormatsOperation):
        self._SubtitleFormatsOperation = SubtitleFormatsOperation

    @property
    def SubtitleFormat(self):
        warnings.warn("parameter `SubtitleFormat` is deprecated", DeprecationWarning) 

        r"""生成的字幕文件格式，<font color='red'>填空字符串</font>表示不生成字幕文件，可选值：
<li>vtt：生成 WebVTT 字幕文件；</li>
<li>srt：生成 SRT 字幕文件。</li>
<font color='red'>注意：此字段已废弃，建议使用 SubtitleFormatsOperation。</font>
        :rtype: str
        """
        return self._SubtitleFormat

    @SubtitleFormat.setter
    def SubtitleFormat(self, SubtitleFormat):
        warnings.warn("parameter `SubtitleFormat` is deprecated", DeprecationWarning) 

        self._SubtitleFormat = SubtitleFormat

    @property
    def SrcLanguage(self):
        r"""媒体源语言，取值范围：
<li>zh：中文普通话；</li>
<li>en：英语；</li>
<li>ja：日语；</li>
<li>zh-ca：粤语。</li>
        :rtype: str
        """
        return self._SrcLanguage

    @SrcLanguage.setter
    def SrcLanguage(self, SrcLanguage):
        self._SrcLanguage = SrcLanguage

    @property
    def SubtitleName(self):
        r"""指定字幕名称，长度限制：64 个字符。该值将用于播放器展示。
        :rtype: str
        """
        return self._SubtitleName

    @SubtitleName.setter
    def SubtitleName(self, SubtitleName):
        self._SubtitleName = SubtitleName


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        if params.get("SubtitleFormatsOperation") is not None:
            self._SubtitleFormatsOperation = SubtitleFormatsOperation()
            self._SubtitleFormatsOperation._deserialize(params.get("SubtitleFormatsOperation"))
        self._SubtitleFormat = params.get("SubtitleFormat")
        self._SrcLanguage = params.get("SrcLanguage")
        self._SubtitleName = params.get("SubtitleName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AsrTranslateConfigureInfo(AbstractModel):
    r"""语音翻译识别任务控制参数

    """

    def __init__(self):
        r"""
        :param _Switch: 语音翻译识别任务开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li><font color=red>注意：</font>语音翻译识别任务本身会返回 ASR 全文识别结果，为避免重复收费，因此禁止同时开启语音翻译识别和 ASR 全文识别功能项。

        :type Switch: str
        :param _SrcLanguage: 媒体源语言，当 Switch 为 ON 时，此参数必填。取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>ja：日文；</li>
<li>ko：韩文；</li>
<li>vi：越南语；</li>
<li>ms：马来语；</li>
<li>th：泰语；</li>
<li>pt：葡萄牙语；</li>
<li>tr：土耳其语；</li>
<li>ar：阿拉伯语；</li>
<li>es：西班牙语；</li>
<li>hi：印地语；</li>
<li>fr：法语。</li>
        :type SrcLanguage: str
        :param _DstLanguage: 翻译目标语言，当 Switch 为 ON 时，此参数有效。
若此参数不填或者填写空字符串，则表示只进行语音全文识别，不进行翻译（计费项与 AsrFullTextConfigure 语音全文识别一致）；
否则，此参数的取值范围分为如下几种情况：
当 SrcLanguage 为 zh（中文）时，取值范围：
<li>en：英文；</li>
<li>ja：日文；</li>
<li>ko：韩文；</li>
<li>fr：法语；</li>
<li>es：西班牙语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>tr：土耳其语；</li>
<li>ru：俄语；</li>
<li>pt：葡萄牙语；</li>
<li>vi：越南语；</li>
<li>id：印尼语；</li>
<li>th：泰语；</li>
<li>ms：马来语。</li>
当 SrcLanguage 为 en（英文）时，取值范围：
<li>zh：中文；</li>
<li>ja：日文；</li>
<li>ko：韩文；</li>
<li>fr：法语；</li>
<li>es：西班牙语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>tr：土耳其语；</li>
<li>ru：俄语；</li>
<li>pt：葡萄牙语；</li>
<li>vi：越南语；</li>
<li>id：印尼语；</li>
<li>th：泰语；</li>
<li>ms：马来语；</li>
<li>ar：阿拉伯语；</li>
<li>hi：印地语。</li>
当 SrcLanguage 为 ja（日文）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>ko：韩文。</li>
当 SrcLanguage 为 ko（韩文）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>ja：日文。</li>
当 SrcLanguage 为 vi（越南语）或 ms（马来语）或 th（泰语）时，取值范围：
<li>zh：中文；</li>
<li>en：英文。</li>
当 SrcLanguage 为 pt（葡萄牙语）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>fr：法语；</li>
<li>es：西班牙语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>tr：土耳其语；</li>
<li>ru：俄语。</li>
当 SrcLanguage 为 tr（土耳其语）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>fr：法语；</li>
<li>es：西班牙语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>ru：俄语；</li>
<li>pt：葡萄牙语。</li>
当 SrcLanguage 为 es（西班牙语）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>fr：法语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>tr：土耳其语；</li>
<li>ru：俄语；</li>
<li>pt：葡萄牙语。</li>
当 SrcLanguage 为 ar（阿拉伯语）或 hi（印地语）时，取值范围：
<li>en：英文。</li>
当 SrcLanguage 为 fr（法语）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>es：西班牙语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>tr：土耳其语；</li>
<li>ru：俄语；</li>
<li>pt：葡萄牙语。</li>
        :type DstLanguage: str
        :param _SubtitleFormats: 生成的字幕文件格式列表，不填或者填空数组表示不生成字幕文件，可选值：
<li>vtt：生成 WebVTT 字幕文件；</li>
<li>srt：生成 SRT 字幕文件。</li><font color=red>注意：</font> 云点播媒资信息仅支持添加 vtt 字幕，因此当且仅当 SubtitleFormats 包含 vtt 时，云点播将生成的字幕添加到媒资。
        :type SubtitleFormats: list of str
        :param _SubtitleName: 指定字幕名称，长度限制：64 个字符。该值将用于播放器展示，若不填则云点播自动生成。
<font color=red>注意：</font>仅当 SubtitleFormats 包含 vtt 时，该字段有效。

        :type SubtitleName: str
        """
        self._Switch = None
        self._SrcLanguage = None
        self._DstLanguage = None
        self._SubtitleFormats = None
        self._SubtitleName = None

    @property
    def Switch(self):
        r"""语音翻译识别任务开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li><font color=red>注意：</font>语音翻译识别任务本身会返回 ASR 全文识别结果，为避免重复收费，因此禁止同时开启语音翻译识别和 ASR 全文识别功能项。

        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def SrcLanguage(self):
        r"""媒体源语言，当 Switch 为 ON 时，此参数必填。取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>ja：日文；</li>
<li>ko：韩文；</li>
<li>vi：越南语；</li>
<li>ms：马来语；</li>
<li>th：泰语；</li>
<li>pt：葡萄牙语；</li>
<li>tr：土耳其语；</li>
<li>ar：阿拉伯语；</li>
<li>es：西班牙语；</li>
<li>hi：印地语；</li>
<li>fr：法语。</li>
        :rtype: str
        """
        return self._SrcLanguage

    @SrcLanguage.setter
    def SrcLanguage(self, SrcLanguage):
        self._SrcLanguage = SrcLanguage

    @property
    def DstLanguage(self):
        r"""翻译目标语言，当 Switch 为 ON 时，此参数有效。
若此参数不填或者填写空字符串，则表示只进行语音全文识别，不进行翻译（计费项与 AsrFullTextConfigure 语音全文识别一致）；
否则，此参数的取值范围分为如下几种情况：
当 SrcLanguage 为 zh（中文）时，取值范围：
<li>en：英文；</li>
<li>ja：日文；</li>
<li>ko：韩文；</li>
<li>fr：法语；</li>
<li>es：西班牙语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>tr：土耳其语；</li>
<li>ru：俄语；</li>
<li>pt：葡萄牙语；</li>
<li>vi：越南语；</li>
<li>id：印尼语；</li>
<li>th：泰语；</li>
<li>ms：马来语。</li>
当 SrcLanguage 为 en（英文）时，取值范围：
<li>zh：中文；</li>
<li>ja：日文；</li>
<li>ko：韩文；</li>
<li>fr：法语；</li>
<li>es：西班牙语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>tr：土耳其语；</li>
<li>ru：俄语；</li>
<li>pt：葡萄牙语；</li>
<li>vi：越南语；</li>
<li>id：印尼语；</li>
<li>th：泰语；</li>
<li>ms：马来语；</li>
<li>ar：阿拉伯语；</li>
<li>hi：印地语。</li>
当 SrcLanguage 为 ja（日文）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>ko：韩文。</li>
当 SrcLanguage 为 ko（韩文）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>ja：日文。</li>
当 SrcLanguage 为 vi（越南语）或 ms（马来语）或 th（泰语）时，取值范围：
<li>zh：中文；</li>
<li>en：英文。</li>
当 SrcLanguage 为 pt（葡萄牙语）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>fr：法语；</li>
<li>es：西班牙语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>tr：土耳其语；</li>
<li>ru：俄语。</li>
当 SrcLanguage 为 tr（土耳其语）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>fr：法语；</li>
<li>es：西班牙语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>ru：俄语；</li>
<li>pt：葡萄牙语。</li>
当 SrcLanguage 为 es（西班牙语）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>fr：法语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>tr：土耳其语；</li>
<li>ru：俄语；</li>
<li>pt：葡萄牙语。</li>
当 SrcLanguage 为 ar（阿拉伯语）或 hi（印地语）时，取值范围：
<li>en：英文。</li>
当 SrcLanguage 为 fr（法语）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>es：西班牙语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>tr：土耳其语；</li>
<li>ru：俄语；</li>
<li>pt：葡萄牙语。</li>
        :rtype: str
        """
        return self._DstLanguage

    @DstLanguage.setter
    def DstLanguage(self, DstLanguage):
        self._DstLanguage = DstLanguage

    @property
    def SubtitleFormats(self):
        r"""生成的字幕文件格式列表，不填或者填空数组表示不生成字幕文件，可选值：
<li>vtt：生成 WebVTT 字幕文件；</li>
<li>srt：生成 SRT 字幕文件。</li><font color=red>注意：</font> 云点播媒资信息仅支持添加 vtt 字幕，因此当且仅当 SubtitleFormats 包含 vtt 时，云点播将生成的字幕添加到媒资。
        :rtype: list of str
        """
        return self._SubtitleFormats

    @SubtitleFormats.setter
    def SubtitleFormats(self, SubtitleFormats):
        self._SubtitleFormats = SubtitleFormats

    @property
    def SubtitleName(self):
        r"""指定字幕名称，长度限制：64 个字符。该值将用于播放器展示，若不填则云点播自动生成。
<font color=red>注意：</font>仅当 SubtitleFormats 包含 vtt 时，该字段有效。

        :rtype: str
        """
        return self._SubtitleName

    @SubtitleName.setter
    def SubtitleName(self, SubtitleName):
        self._SubtitleName = SubtitleName


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._SrcLanguage = params.get("SrcLanguage")
        self._DstLanguage = params.get("DstLanguage")
        self._SubtitleFormats = params.get("SubtitleFormats")
        self._SubtitleName = params.get("SubtitleName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AsrTranslateConfigureInfoForUpdate(AbstractModel):
    r"""语音翻译识别控制参数

    """

    def __init__(self):
        r"""
        :param _Switch: 语音翻译识别任务开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li><font color=red>注意：</font>语音翻译识别任务本身会返回 ASR 全文识别结果，为避免重复收费，因此禁止同时开启语音翻译识别和 ASR 全文识别功能项。
        :type Switch: str
        :param _SrcLanguage: 媒体源语言，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>ja：日文；</li>
<li>ko：韩文；</li>
<li>vi：越南语；</li>
<li>ms：马来语；</li>
<li>th：泰语；</li>
<li>pt：葡萄牙语；</li>
<li>tr：土耳其语；</li>
<li>ar：阿拉伯语；</li>
<li>es：西班牙语；</li>
<li>hi：印地语；</li>
<li>fr：法语。</li>
        :type SrcLanguage: str
        :param _DstLanguage: 翻译目标语言。
若此参数填写空字符串，则表示只进行语音全文识别，不进行翻译（计费项与 AsrFullTextConfigure 语音全文识别一致）；
否则，此参数的取值范围分为如下几种情况：
当 SrcLanguage 为 zh（中文）时，取值范围：
<li>en：英文；</li>
<li>ja：日文；</li>
<li>ko：韩文；</li>
<li>fr：法语；</li>
<li>es：西班牙语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>tr：土耳其语；</li>
<li>ru：俄语；</li>
<li>pt：葡萄牙语；</li>
<li>vi：越南语；</li>
<li>id：印尼语；</li>
<li>th：泰语；</li>
<li>ms：马来语。</li>
当 SrcLanguage 为 en（英文）时，取值范围：
<li>zh：中文；</li>
<li>ja：日文；</li>
<li>ko：韩文；</li>
<li>fr：法语；</li>
<li>es：西班牙语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>tr：土耳其语；</li>
<li>ru：俄语；</li>
<li>pt：葡萄牙语；</li>
<li>vi：越南语；</li>
<li>id：印尼语；</li>
<li>th：泰语；</li>
<li>ms：马来语；</li>
<li>ar：阿拉伯语；</li>
<li>hi：印地语。</li>
当 SrcLanguage 为 ja（日文）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>ko：韩文。</li>
当 SrcLanguage 为 ko（韩文）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>ja：日文。</li>
当 SrcLanguage 为 vi（越南语）或 ms（马来语）或 th（泰语）时，取值范围：
<li>zh：中文；</li>
<li>en：英文。</li>
当 SrcLanguage 为 pt（葡萄牙语）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>fr：法语；</li>
<li>es：西班牙语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>tr：土耳其语；</li>
<li>ru：俄语。</li>
当 SrcLanguage 为 tr（土耳其语）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>fr：法语；</li>
<li>es：西班牙语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>ru：俄语；</li>
<li>pt：葡萄牙语。</li>
当 SrcLanguage 为 es（西班牙语）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>fr：法语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>tr：土耳其语；</li>
<li>ru：俄语；</li>
<li>pt：葡萄牙语。</li>
当 SrcLanguage 为 ar（阿拉伯语）或 hi（印地语）时，取值范围：
<li>en：英文。</li>
当 SrcLanguage 为 fr（法语）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>es：西班牙语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>tr：土耳其语；</li>
<li>ru：俄语；</li>
<li>pt：葡萄牙语。</li>
        :type DstLanguage: str
        :param _SubtitleFormatsOperation: 字幕格式列表操作信息。
        :type SubtitleFormatsOperation: :class:`tencentcloud.vod.v20180717.models.SubtitleFormatsOperation`
        :param _SubtitleName: 指定字幕名称，长度限制：64 个字符。该值将用于播放器展示。
        :type SubtitleName: str
        """
        self._Switch = None
        self._SrcLanguage = None
        self._DstLanguage = None
        self._SubtitleFormatsOperation = None
        self._SubtitleName = None

    @property
    def Switch(self):
        r"""语音翻译识别任务开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li><font color=red>注意：</font>语音翻译识别任务本身会返回 ASR 全文识别结果，为避免重复收费，因此禁止同时开启语音翻译识别和 ASR 全文识别功能项。
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def SrcLanguage(self):
        r"""媒体源语言，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>ja：日文；</li>
<li>ko：韩文；</li>
<li>vi：越南语；</li>
<li>ms：马来语；</li>
<li>th：泰语；</li>
<li>pt：葡萄牙语；</li>
<li>tr：土耳其语；</li>
<li>ar：阿拉伯语；</li>
<li>es：西班牙语；</li>
<li>hi：印地语；</li>
<li>fr：法语。</li>
        :rtype: str
        """
        return self._SrcLanguage

    @SrcLanguage.setter
    def SrcLanguage(self, SrcLanguage):
        self._SrcLanguage = SrcLanguage

    @property
    def DstLanguage(self):
        r"""翻译目标语言。
若此参数填写空字符串，则表示只进行语音全文识别，不进行翻译（计费项与 AsrFullTextConfigure 语音全文识别一致）；
否则，此参数的取值范围分为如下几种情况：
当 SrcLanguage 为 zh（中文）时，取值范围：
<li>en：英文；</li>
<li>ja：日文；</li>
<li>ko：韩文；</li>
<li>fr：法语；</li>
<li>es：西班牙语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>tr：土耳其语；</li>
<li>ru：俄语；</li>
<li>pt：葡萄牙语；</li>
<li>vi：越南语；</li>
<li>id：印尼语；</li>
<li>th：泰语；</li>
<li>ms：马来语。</li>
当 SrcLanguage 为 en（英文）时，取值范围：
<li>zh：中文；</li>
<li>ja：日文；</li>
<li>ko：韩文；</li>
<li>fr：法语；</li>
<li>es：西班牙语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>tr：土耳其语；</li>
<li>ru：俄语；</li>
<li>pt：葡萄牙语；</li>
<li>vi：越南语；</li>
<li>id：印尼语；</li>
<li>th：泰语；</li>
<li>ms：马来语；</li>
<li>ar：阿拉伯语；</li>
<li>hi：印地语。</li>
当 SrcLanguage 为 ja（日文）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>ko：韩文。</li>
当 SrcLanguage 为 ko（韩文）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>ja：日文。</li>
当 SrcLanguage 为 vi（越南语）或 ms（马来语）或 th（泰语）时，取值范围：
<li>zh：中文；</li>
<li>en：英文。</li>
当 SrcLanguage 为 pt（葡萄牙语）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>fr：法语；</li>
<li>es：西班牙语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>tr：土耳其语；</li>
<li>ru：俄语。</li>
当 SrcLanguage 为 tr（土耳其语）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>fr：法语；</li>
<li>es：西班牙语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>ru：俄语；</li>
<li>pt：葡萄牙语。</li>
当 SrcLanguage 为 es（西班牙语）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>fr：法语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>tr：土耳其语；</li>
<li>ru：俄语；</li>
<li>pt：葡萄牙语。</li>
当 SrcLanguage 为 ar（阿拉伯语）或 hi（印地语）时，取值范围：
<li>en：英文。</li>
当 SrcLanguage 为 fr（法语）时，取值范围：
<li>zh：中文；</li>
<li>en：英文；</li>
<li>es：西班牙语；</li>
<li>it：意大利语；</li>
<li>de：德语；</li>
<li>tr：土耳其语；</li>
<li>ru：俄语；</li>
<li>pt：葡萄牙语。</li>
        :rtype: str
        """
        return self._DstLanguage

    @DstLanguage.setter
    def DstLanguage(self, DstLanguage):
        self._DstLanguage = DstLanguage

    @property
    def SubtitleFormatsOperation(self):
        r"""字幕格式列表操作信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.SubtitleFormatsOperation`
        """
        return self._SubtitleFormatsOperation

    @SubtitleFormatsOperation.setter
    def SubtitleFormatsOperation(self, SubtitleFormatsOperation):
        self._SubtitleFormatsOperation = SubtitleFormatsOperation

    @property
    def SubtitleName(self):
        r"""指定字幕名称，长度限制：64 个字符。该值将用于播放器展示。
        :rtype: str
        """
        return self._SubtitleName

    @SubtitleName.setter
    def SubtitleName(self, SubtitleName):
        self._SubtitleName = SubtitleName


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._SrcLanguage = params.get("SrcLanguage")
        self._DstLanguage = params.get("DstLanguage")
        if params.get("SubtitleFormatsOperation") is not None:
            self._SubtitleFormatsOperation = SubtitleFormatsOperation()
            self._SubtitleFormatsOperation._deserialize(params.get("SubtitleFormatsOperation"))
        self._SubtitleName = params.get("SubtitleName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AsrWordsConfigureInfo(AbstractModel):
    r"""语音关键词识别控制参数。

    """

    def __init__(self):
        r"""
        :param _Switch: 语音关键词识别任务开关，可选值：
<li>ON：开启语音关键词识别任务；</li>
<li>OFF：关闭语音关键词识别任务。</li>
        :type Switch: str
        :param _LabelSet: 关键词过滤标签，指定需要返回的关键词的标签。如果未填或者为空，则全部结果都返回。
标签个数最多 10 个，每个标签长度最多 16 个字符。
        :type LabelSet: list of str
        """
        self._Switch = None
        self._LabelSet = None

    @property
    def Switch(self):
        r"""语音关键词识别任务开关，可选值：
<li>ON：开启语音关键词识别任务；</li>
<li>OFF：关闭语音关键词识别任务。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def LabelSet(self):
        r"""关键词过滤标签，指定需要返回的关键词的标签。如果未填或者为空，则全部结果都返回。
标签个数最多 10 个，每个标签长度最多 16 个字符。
        :rtype: list of str
        """
        return self._LabelSet

    @LabelSet.setter
    def LabelSet(self, LabelSet):
        self._LabelSet = LabelSet


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._LabelSet = params.get("LabelSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AsrWordsConfigureInfoForUpdate(AbstractModel):
    r"""语音关键词识别控制参数。

    """

    def __init__(self):
        r"""
        :param _Switch: 语音关键词识别任务开关，可选值：
<li>ON：开启语音关键词识别任务；</li>
<li>OFF：关闭语音关键词识别任务。</li>
        :type Switch: str
        :param _LabelSet: 关键词过滤标签，指定需要返回的关键词的标签。如果未填或者为空，则全部结果都返回。
标签个数最多 10 个，每个标签长度最多 16 个字符。
        :type LabelSet: list of str
        """
        self._Switch = None
        self._LabelSet = None

    @property
    def Switch(self):
        r"""语音关键词识别任务开关，可选值：
<li>ON：开启语音关键词识别任务；</li>
<li>OFF：关闭语音关键词识别任务。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def LabelSet(self):
        r"""关键词过滤标签，指定需要返回的关键词的标签。如果未填或者为空，则全部结果都返回。
标签个数最多 10 个，每个标签长度最多 16 个字符。
        :rtype: list of str
        """
        return self._LabelSet

    @LabelSet.setter
    def LabelSet(self, LabelSet):
        self._LabelSet = LabelSet


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._LabelSet = params.get("LabelSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AttachMediaSubtitlesRequest(AbstractModel):
    r"""AttachMediaSubtitles请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FileId: 媒体文件唯一标识。
        :type FileId: str
        :param _Operation: 操作。取值如下：
<li>Attach：关联字幕。</li>
<li>Detach：解除关联字幕。</li>
        :type Operation: str
        :param _AdaptiveDynamicStreamingDefinition: [转自适应码流模板号](https://cloud.tencent.com/document/product/266/34071#zsy)。
        :type AdaptiveDynamicStreamingDefinition: int
        :param _SubtitleIds: 字幕的唯一标识。
        :type SubtitleIds: list of str
        :param _DefaultSubtitleId: 默认字幕的唯一标识。不填则不设置默认字幕。
        :type DefaultSubtitleId: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._FileId = None
        self._Operation = None
        self._AdaptiveDynamicStreamingDefinition = None
        self._SubtitleIds = None
        self._DefaultSubtitleId = None
        self._SubAppId = None

    @property
    def FileId(self):
        r"""媒体文件唯一标识。
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def Operation(self):
        r"""操作。取值如下：
<li>Attach：关联字幕。</li>
<li>Detach：解除关联字幕。</li>
        :rtype: str
        """
        return self._Operation

    @Operation.setter
    def Operation(self, Operation):
        self._Operation = Operation

    @property
    def AdaptiveDynamicStreamingDefinition(self):
        r"""[转自适应码流模板号](https://cloud.tencent.com/document/product/266/34071#zsy)。
        :rtype: int
        """
        return self._AdaptiveDynamicStreamingDefinition

    @AdaptiveDynamicStreamingDefinition.setter
    def AdaptiveDynamicStreamingDefinition(self, AdaptiveDynamicStreamingDefinition):
        self._AdaptiveDynamicStreamingDefinition = AdaptiveDynamicStreamingDefinition

    @property
    def SubtitleIds(self):
        r"""字幕的唯一标识。
        :rtype: list of str
        """
        return self._SubtitleIds

    @SubtitleIds.setter
    def SubtitleIds(self, SubtitleIds):
        self._SubtitleIds = SubtitleIds

    @property
    def DefaultSubtitleId(self):
        r"""默认字幕的唯一标识。不填则不设置默认字幕。
        :rtype: str
        """
        return self._DefaultSubtitleId

    @DefaultSubtitleId.setter
    def DefaultSubtitleId(self, DefaultSubtitleId):
        self._DefaultSubtitleId = DefaultSubtitleId

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._FileId = params.get("FileId")
        self._Operation = params.get("Operation")
        self._AdaptiveDynamicStreamingDefinition = params.get("AdaptiveDynamicStreamingDefinition")
        self._SubtitleIds = params.get("SubtitleIds")
        self._DefaultSubtitleId = params.get("DefaultSubtitleId")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AttachMediaSubtitlesResponse(AbstractModel):
    r"""AttachMediaSubtitles返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AudioBeautifyInfo(AbstractModel):
    r"""音频美化配置。

    """

    def __init__(self):
        r"""
        :param _Switch: 音频美化控制开关，可选值：
<li>ON：开启音频美化；</li>
<li>OFF：关闭音频美化。</li>
        :type Switch: str
        :param _Types: 类型，可多选，可选值：
<li>declick：杂音去除</li>
<li>deesser：齿音压制</li>
默认值：declick。
        :type Types: list of str
        """
        self._Switch = None
        self._Types = None

    @property
    def Switch(self):
        r"""音频美化控制开关，可选值：
<li>ON：开启音频美化；</li>
<li>OFF：关闭音频美化。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Types(self):
        r"""类型，可多选，可选值：
<li>declick：杂音去除</li>
<li>deesser：齿音压制</li>
默认值：declick。
        :rtype: list of str
        """
        return self._Types

    @Types.setter
    def Types(self, Types):
        self._Types = Types


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Types = params.get("Types")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioDenoiseInfo(AbstractModel):
    r"""音频降噪控制信息

    """

    def __init__(self):
        r"""
        :param _Switch: 音频降噪控制开关，可选值：
<li>ON：开启音频降噪；</li>
<li>OFF：关闭音频降噪。</li>
        :type Switch: str
        :param _Type: 音频降噪类型，仅当音频降噪控制开关为 ON 时有效，可选值：
<li>normal：正常音频降噪；</li>
默认值：normal。
        :type Type: str
        """
        self._Switch = None
        self._Type = None

    @property
    def Switch(self):
        r"""音频降噪控制开关，可选值：
<li>ON：开启音频降噪；</li>
<li>OFF：关闭音频降噪。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Type(self):
        r"""音频降噪类型，仅当音频降噪控制开关为 ON 时有效，可选值：
<li>normal：正常音频降噪；</li>
默认值：normal。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioEnhanceConfig(AbstractModel):
    r"""音频增强配置。

    """

    def __init__(self):
        r"""
        :param _Denoise: 音频降噪配置。
注意：此字段可能返回 null，表示取不到有效值。
        :type Denoise: :class:`tencentcloud.vod.v20180717.models.AudioDenoiseInfo`
        :param _Separate: 音频分离配置。
注意：此字段可能返回 null，表示取不到有效值。
        :type Separate: :class:`tencentcloud.vod.v20180717.models.AudioSeparateInfo`
        :param _VolumeBalance: 音量均衡配置。
注意：此字段可能返回 null，表示取不到有效值。
        :type VolumeBalance: :class:`tencentcloud.vod.v20180717.models.AudioVolumeBalanceInfo`
        :param _Beautify: 音量美化配置。
注意：此字段可能返回 null，表示取不到有效值。
        :type Beautify: :class:`tencentcloud.vod.v20180717.models.AudioBeautifyInfo`
        """
        self._Denoise = None
        self._Separate = None
        self._VolumeBalance = None
        self._Beautify = None

    @property
    def Denoise(self):
        r"""音频降噪配置。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AudioDenoiseInfo`
        """
        return self._Denoise

    @Denoise.setter
    def Denoise(self, Denoise):
        self._Denoise = Denoise

    @property
    def Separate(self):
        r"""音频分离配置。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AudioSeparateInfo`
        """
        return self._Separate

    @Separate.setter
    def Separate(self, Separate):
        self._Separate = Separate

    @property
    def VolumeBalance(self):
        r"""音量均衡配置。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AudioVolumeBalanceInfo`
        """
        return self._VolumeBalance

    @VolumeBalance.setter
    def VolumeBalance(self, VolumeBalance):
        self._VolumeBalance = VolumeBalance

    @property
    def Beautify(self):
        r"""音量美化配置。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AudioBeautifyInfo`
        """
        return self._Beautify

    @Beautify.setter
    def Beautify(self, Beautify):
        self._Beautify = Beautify


    def _deserialize(self, params):
        if params.get("Denoise") is not None:
            self._Denoise = AudioDenoiseInfo()
            self._Denoise._deserialize(params.get("Denoise"))
        if params.get("Separate") is not None:
            self._Separate = AudioSeparateInfo()
            self._Separate._deserialize(params.get("Separate"))
        if params.get("VolumeBalance") is not None:
            self._VolumeBalance = AudioVolumeBalanceInfo()
            self._VolumeBalance._deserialize(params.get("VolumeBalance"))
        if params.get("Beautify") is not None:
            self._Beautify = AudioBeautifyInfo()
            self._Beautify._deserialize(params.get("Beautify"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioSeparateInfo(AbstractModel):
    r"""音频分离配置。

    """

    def __init__(self):
        r"""
        :param _Switch: 音频分离控制开关，可选值：
<li>ON：开启音频分离；</li>
<li>OFF：关闭音频分离。</li>
        :type Switch: str
        :param _Type: 场景类型，可选值：
<li>normal：人声背景声场景</li>
<li>music：演唱伴奏场景</li>
默认值：normal。
        :type Type: str
        :param _Track: 输出音轨，可选值：
<li>vocal：输出人声</li>
<li>background：应用场景为normal时输出背景声，应用场景为music时输出伴奏</li>
默认值：vocal。
        :type Track: str
        """
        self._Switch = None
        self._Type = None
        self._Track = None

    @property
    def Switch(self):
        r"""音频分离控制开关，可选值：
<li>ON：开启音频分离；</li>
<li>OFF：关闭音频分离。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Type(self):
        r"""场景类型，可选值：
<li>normal：人声背景声场景</li>
<li>music：演唱伴奏场景</li>
默认值：normal。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Track(self):
        r"""输出音轨，可选值：
<li>vocal：输出人声</li>
<li>background：应用场景为normal时输出背景声，应用场景为music时输出伴奏</li>
默认值：vocal。
        :rtype: str
        """
        return self._Track

    @Track.setter
    def Track(self, Track):
        self._Track = Track


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Type = params.get("Type")
        self._Track = params.get("Track")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioTemplateInfo(AbstractModel):
    r"""音频流配置参数

    """

    def __init__(self):
        r"""
        :param _Codec: 音频流的编码格式。
当外层参数 Container 为 mp3 时，可选值为：
<li>libmp3lame。</li>
当外层参数 Container 为 ogg 或 flac 时，可选值为：
<li>flac。</li>
当外层参数 Container 为 m4a 时，可选值为：
<li>libfdk_aac；</li>
<li>libmp3lame；</li>
<li>ac3。</li>
当外层参数 Container 为 mp4 或 flv 时，可选值为：
<li>libfdk_aac：更适合 mp4；</li>
<li>libmp3lame：更适合 flv；</li>
<li>mp2。</li>
当外层参数 Container 为 hls 时，可选值为：
<li>libfdk_aac。</li>
当外层参数 Format 为 HLS 或 MPEG-DASH 时，可选值为：
<li>libfdk_aac。</li>
当外层参数 Container 为 wav 时，可选值为：
<li>pcm16。</li>
        :type Codec: str
        :param _Bitrate: 音频流的码率，取值范围：0 和 [26, 256]，单位：kbps。
当取值为 0，表示由云点播自动设置码率。
        :type Bitrate: int
        :param _SampleRate: 音频流的采样率，可选值：
<li>16000，仅当 Codec 为 pcm16 时可选。</li>
<li>32000</li>
<li>44100</li>
<li>48000</li>
单位：Hz。
        :type SampleRate: int
        :param _AudioChannel: 音频通道，可选值：
<li>1：单通道</li>
<li>2：双通道</li>
<li>6：立体声</li>
<li>0：音频声道数和原始音频保持一致</li>
当媒体的封装格式是音频格式时（flac，ogg，mp3，m4a）时，声道数不允许设为立体声。
默认值：2。
        :type AudioChannel: int
        """
        self._Codec = None
        self._Bitrate = None
        self._SampleRate = None
        self._AudioChannel = None

    @property
    def Codec(self):
        r"""音频流的编码格式。
当外层参数 Container 为 mp3 时，可选值为：
<li>libmp3lame。</li>
当外层参数 Container 为 ogg 或 flac 时，可选值为：
<li>flac。</li>
当外层参数 Container 为 m4a 时，可选值为：
<li>libfdk_aac；</li>
<li>libmp3lame；</li>
<li>ac3。</li>
当外层参数 Container 为 mp4 或 flv 时，可选值为：
<li>libfdk_aac：更适合 mp4；</li>
<li>libmp3lame：更适合 flv；</li>
<li>mp2。</li>
当外层参数 Container 为 hls 时，可选值为：
<li>libfdk_aac。</li>
当外层参数 Format 为 HLS 或 MPEG-DASH 时，可选值为：
<li>libfdk_aac。</li>
当外层参数 Container 为 wav 时，可选值为：
<li>pcm16。</li>
        :rtype: str
        """
        return self._Codec

    @Codec.setter
    def Codec(self, Codec):
        self._Codec = Codec

    @property
    def Bitrate(self):
        r"""音频流的码率，取值范围：0 和 [26, 256]，单位：kbps。
当取值为 0，表示由云点播自动设置码率。
        :rtype: int
        """
        return self._Bitrate

    @Bitrate.setter
    def Bitrate(self, Bitrate):
        self._Bitrate = Bitrate

    @property
    def SampleRate(self):
        r"""音频流的采样率，可选值：
<li>16000，仅当 Codec 为 pcm16 时可选。</li>
<li>32000</li>
<li>44100</li>
<li>48000</li>
单位：Hz。
        :rtype: int
        """
        return self._SampleRate

    @SampleRate.setter
    def SampleRate(self, SampleRate):
        self._SampleRate = SampleRate

    @property
    def AudioChannel(self):
        r"""音频通道，可选值：
<li>1：单通道</li>
<li>2：双通道</li>
<li>6：立体声</li>
<li>0：音频声道数和原始音频保持一致</li>
当媒体的封装格式是音频格式时（flac，ogg，mp3，m4a）时，声道数不允许设为立体声。
默认值：2。
        :rtype: int
        """
        return self._AudioChannel

    @AudioChannel.setter
    def AudioChannel(self, AudioChannel):
        self._AudioChannel = AudioChannel


    def _deserialize(self, params):
        self._Codec = params.get("Codec")
        self._Bitrate = params.get("Bitrate")
        self._SampleRate = params.get("SampleRate")
        self._AudioChannel = params.get("AudioChannel")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioTemplateInfoForUpdate(AbstractModel):
    r"""音频流配置参数

    """

    def __init__(self):
        r"""
        :param _Codec: 音频流的编码格式。
当外层参数 Container 为 mp3 时，可选值为：
<li>libmp3lame。</li>
当外层参数 Container 为 ogg 或 flac 时，可选值为：
<li>flac。</li>
当外层参数 Container 为 m4a 时，可选值为：
<li>libfdk_aac；</li>
<li>libmp3lame；</li>
<li>ac3。</li>
当外层参数 Container 为 mp4 或 flv 时，可选值为：
<li>libfdk_aac：更适合 mp4；</li>
<li>libmp3lame：更适合 flv；</li>
<li>mp2。</li>
当外层参数 Container 为 hls 时，可选值为：
<li>libfdk_aac。</li>
当外层参数 Format 为 HLS 或 MPEG-DASH 时，可选值为：
<li>libfdk_aac。</li>
当外层参数 Container 为 wav 时，可选值为：
<li>pcm16。</li>
        :type Codec: str
        :param _Bitrate: 音频流的码率，取值范围：0 和 [26, 256]，单位：kbps。 当取值为 0，表示由云点播自动设置码率。
        :type Bitrate: int
        :param _SampleRate: 音频流的采样率，可选值：
<li>16000，仅当 Codec 为 pcm16 时可选。</li>
<li>32000</li>
<li>44100</li>
<li>48000</li>
单位：Hz。
        :type SampleRate: int
        :param _AudioChannel: 音频通道，可选值：
<li>1：单通道</li>
<li>2：双通道</li>
<li>6：立体声</li>
<li>0：音频声道数和原始音频保持一致</li>
当媒体的封装格式是音频格式时（flac，ogg，mp3，m4a）时，声道数不允许设为立体声。
        :type AudioChannel: int
        """
        self._Codec = None
        self._Bitrate = None
        self._SampleRate = None
        self._AudioChannel = None

    @property
    def Codec(self):
        r"""音频流的编码格式。
当外层参数 Container 为 mp3 时，可选值为：
<li>libmp3lame。</li>
当外层参数 Container 为 ogg 或 flac 时，可选值为：
<li>flac。</li>
当外层参数 Container 为 m4a 时，可选值为：
<li>libfdk_aac；</li>
<li>libmp3lame；</li>
<li>ac3。</li>
当外层参数 Container 为 mp4 或 flv 时，可选值为：
<li>libfdk_aac：更适合 mp4；</li>
<li>libmp3lame：更适合 flv；</li>
<li>mp2。</li>
当外层参数 Container 为 hls 时，可选值为：
<li>libfdk_aac。</li>
当外层参数 Format 为 HLS 或 MPEG-DASH 时，可选值为：
<li>libfdk_aac。</li>
当外层参数 Container 为 wav 时，可选值为：
<li>pcm16。</li>
        :rtype: str
        """
        return self._Codec

    @Codec.setter
    def Codec(self, Codec):
        self._Codec = Codec

    @property
    def Bitrate(self):
        r"""音频流的码率，取值范围：0 和 [26, 256]，单位：kbps。 当取值为 0，表示由云点播自动设置码率。
        :rtype: int
        """
        return self._Bitrate

    @Bitrate.setter
    def Bitrate(self, Bitrate):
        self._Bitrate = Bitrate

    @property
    def SampleRate(self):
        r"""音频流的采样率，可选值：
<li>16000，仅当 Codec 为 pcm16 时可选。</li>
<li>32000</li>
<li>44100</li>
<li>48000</li>
单位：Hz。
        :rtype: int
        """
        return self._SampleRate

    @SampleRate.setter
    def SampleRate(self, SampleRate):
        self._SampleRate = SampleRate

    @property
    def AudioChannel(self):
        r"""音频通道，可选值：
<li>1：单通道</li>
<li>2：双通道</li>
<li>6：立体声</li>
<li>0：音频声道数和原始音频保持一致</li>
当媒体的封装格式是音频格式时（flac，ogg，mp3，m4a）时，声道数不允许设为立体声。
        :rtype: int
        """
        return self._AudioChannel

    @AudioChannel.setter
    def AudioChannel(self, AudioChannel):
        self._AudioChannel = AudioChannel


    def _deserialize(self, params):
        self._Codec = params.get("Codec")
        self._Bitrate = params.get("Bitrate")
        self._SampleRate = params.get("SampleRate")
        self._AudioChannel = params.get("AudioChannel")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioTrackItem(AbstractModel):
    r"""音频轨道上的音频片段信息。

    """

    def __init__(self):
        r"""
        :param _SourceMedia: 音频片段的媒体素材来源，可以是：
<li>点播的媒体文件 ID；</li>
<li>其他媒体文件的下载 URL。</li>
注意：当使用其他媒体文件的下载 URL 作为素材来源，且开启了访问控制（如防盗链）时，需要在 URL 携带访问控制参数（如防盗链签名）。
        :type SourceMedia: str
        :param _SourceMediaStartTime: 音频片段取自素材文件的起始时间，单位为秒。0 表示从素材开始位置截取。默认为0。
        :type SourceMediaStartTime: float
        :param _Duration: 音频片段的时长，单位为秒。默认和素材本身长度一致，表示截取全部素材。
        :type Duration: float
        :param _TargetDuration: 音频片段目标时长，单位为秒。
<li>当 TargetDuration 不填或填0时，表示目标时长和 Duration 一致；</li>
<li>当 TargetDuration 取大于0的值时，将对音频片段做快进或慢放等处理，使得输出片段的时长等于 TargetDuration。</li>
        :type TargetDuration: float
        :param _AudioOperations: 对音频片段进行的操作，如音量调节等。
        :type AudioOperations: list of AudioTransform
        """
        self._SourceMedia = None
        self._SourceMediaStartTime = None
        self._Duration = None
        self._TargetDuration = None
        self._AudioOperations = None

    @property
    def SourceMedia(self):
        r"""音频片段的媒体素材来源，可以是：
<li>点播的媒体文件 ID；</li>
<li>其他媒体文件的下载 URL。</li>
注意：当使用其他媒体文件的下载 URL 作为素材来源，且开启了访问控制（如防盗链）时，需要在 URL 携带访问控制参数（如防盗链签名）。
        :rtype: str
        """
        return self._SourceMedia

    @SourceMedia.setter
    def SourceMedia(self, SourceMedia):
        self._SourceMedia = SourceMedia

    @property
    def SourceMediaStartTime(self):
        r"""音频片段取自素材文件的起始时间，单位为秒。0 表示从素材开始位置截取。默认为0。
        :rtype: float
        """
        return self._SourceMediaStartTime

    @SourceMediaStartTime.setter
    def SourceMediaStartTime(self, SourceMediaStartTime):
        self._SourceMediaStartTime = SourceMediaStartTime

    @property
    def Duration(self):
        r"""音频片段的时长，单位为秒。默认和素材本身长度一致，表示截取全部素材。
        :rtype: float
        """
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration

    @property
    def TargetDuration(self):
        r"""音频片段目标时长，单位为秒。
<li>当 TargetDuration 不填或填0时，表示目标时长和 Duration 一致；</li>
<li>当 TargetDuration 取大于0的值时，将对音频片段做快进或慢放等处理，使得输出片段的时长等于 TargetDuration。</li>
        :rtype: float
        """
        return self._TargetDuration

    @TargetDuration.setter
    def TargetDuration(self, TargetDuration):
        self._TargetDuration = TargetDuration

    @property
    def AudioOperations(self):
        r"""对音频片段进行的操作，如音量调节等。
        :rtype: list of AudioTransform
        """
        return self._AudioOperations

    @AudioOperations.setter
    def AudioOperations(self, AudioOperations):
        self._AudioOperations = AudioOperations


    def _deserialize(self, params):
        self._SourceMedia = params.get("SourceMedia")
        self._SourceMediaStartTime = params.get("SourceMediaStartTime")
        self._Duration = params.get("Duration")
        self._TargetDuration = params.get("TargetDuration")
        if params.get("AudioOperations") is not None:
            self._AudioOperations = []
            for item in params.get("AudioOperations"):
                obj = AudioTransform()
                obj._deserialize(item)
                self._AudioOperations.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioTransform(AbstractModel):
    r"""音频操作

    """

    def __init__(self):
        r"""
        :param _Type: 音频操作类型，取值有：
<li>Volume：音量调节。</li>
        :type Type: str
        :param _VolumeParam: 音量调节参数， 当 Type = Volume 时有效。
        :type VolumeParam: :class:`tencentcloud.vod.v20180717.models.AudioVolumeParam`
        """
        self._Type = None
        self._VolumeParam = None

    @property
    def Type(self):
        r"""音频操作类型，取值有：
<li>Volume：音量调节。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def VolumeParam(self):
        r"""音量调节参数， 当 Type = Volume 时有效。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AudioVolumeParam`
        """
        return self._VolumeParam

    @VolumeParam.setter
    def VolumeParam(self, VolumeParam):
        self._VolumeParam = VolumeParam


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("VolumeParam") is not None:
            self._VolumeParam = AudioVolumeParam()
            self._VolumeParam._deserialize(params.get("VolumeParam"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioVolumeBalanceInfo(AbstractModel):
    r"""音量均衡配置。

    """

    def __init__(self):
        r"""
        :param _Switch: 音量均衡控制开关，可选值：
<li>ON：开启音量均衡；</li>
<li>OFF：关闭音量均衡。</li>
        :type Switch: str
        :param _Type: 类型，可选值：
<li>loudNorm：响度标准化</li>
<li>gainControl：减小突变</li>
默认值：loudNorm。
        :type Type: str
        """
        self._Switch = None
        self._Type = None

    @property
    def Switch(self):
        r"""音量均衡控制开关，可选值：
<li>ON：开启音量均衡；</li>
<li>OFF：关闭音量均衡。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Type(self):
        r"""类型，可选值：
<li>loudNorm：响度标准化</li>
<li>gainControl：减小突变</li>
默认值：loudNorm。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioVolumeParam(AbstractModel):
    r"""音频增益调节参数

    """

    def __init__(self):
        r"""
        :param _Mute: 是否静音，取值范围0或1。
<li>0表示不静音。</li>
<li>1表示静音。</li>
默认是0。
        :type Mute: int
        :param _Gain: 音频增益，取值范围0~10。
<li>大于1表示增加音量。</li>
<li>小于1表示降低音量。</li>
<li>0和1：表示不改变。</li>
默认是0。
        :type Gain: float
        """
        self._Mute = None
        self._Gain = None

    @property
    def Mute(self):
        r"""是否静音，取值范围0或1。
<li>0表示不静音。</li>
<li>1表示静音。</li>
默认是0。
        :rtype: int
        """
        return self._Mute

    @Mute.setter
    def Mute(self, Mute):
        self._Mute = Mute

    @property
    def Gain(self):
        r"""音频增益，取值范围0~10。
<li>大于1表示增加音量。</li>
<li>小于1表示降低音量。</li>
<li>0和1：表示不改变。</li>
默认是0。
        :rtype: float
        """
        return self._Gain

    @Gain.setter
    def Gain(self, Gain):
        self._Gain = Gain


    def _deserialize(self, params):
        self._Mute = params.get("Mute")
        self._Gain = params.get("Gain")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BlackWhiteEdgeConfigureInfo(AbstractModel):
    r"""视频画面黑边、白边、黑屏、白屏检测的控制参数。

    """

    def __init__(self):
        r"""
        :param _Switch: 视频画面黑边、白边、黑屏、白屏检测开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        r"""视频画面黑边、白边、黑屏、白屏检测开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BlackWhiteEdgeConfigureInfoForUpdate(AbstractModel):
    r"""视频画面黑边、白边、黑屏、白屏检测的控制参数。

    """

    def __init__(self):
        r"""
        :param _Switch: 视频画面黑边、白边、黑屏、白屏检测开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        r"""视频画面黑边、白边、黑屏、白屏检测开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BlurConfigureInfo(AbstractModel):
    r"""视频画面模糊检测的控制参数。

    """

    def __init__(self):
        r"""
        :param _Switch: 视频画面模糊检测开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        r"""视频画面模糊检测开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BlurConfigureInfoForUpdate(AbstractModel):
    r"""视频画面模糊检测的控制参数。

    """

    def __init__(self):
        r"""
        :param _Switch: 视频画面模糊检测开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        r"""视频画面模糊检测开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CLSLogsetInfo(AbstractModel):
    r"""CLS 日志集信息

    """

    def __init__(self):
        r"""
        :param _LogsetId: 日志集 ID。
        :type LogsetId: str
        :param _LogsetName: 日志集名。
        :type LogsetName: str
        """
        self._LogsetId = None
        self._LogsetName = None

    @property
    def LogsetId(self):
        r"""日志集 ID。
        :rtype: str
        """
        return self._LogsetId

    @LogsetId.setter
    def LogsetId(self, LogsetId):
        self._LogsetId = LogsetId

    @property
    def LogsetName(self):
        r"""日志集名。
        :rtype: str
        """
        return self._LogsetName

    @LogsetName.setter
    def LogsetName(self, LogsetName):
        self._LogsetName = LogsetName


    def _deserialize(self, params):
        self._LogsetId = params.get("LogsetId")
        self._LogsetName = params.get("LogsetName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CLSTopicInfo(AbstractModel):
    r"""CLS日志主题信息。

    """

    def __init__(self):
        r"""
        :param _TopicId: 日志主题 ID。
        :type TopicId: str
        :param _TopicName: 日志主题名。
        :type TopicName: str
        :param _LogsetId: 日志集 ID。
        :type LogsetId: str
        """
        self._TopicId = None
        self._TopicName = None
        self._LogsetId = None

    @property
    def TopicId(self):
        r"""日志主题 ID。
        :rtype: str
        """
        return self._TopicId

    @TopicId.setter
    def TopicId(self, TopicId):
        self._TopicId = TopicId

    @property
    def TopicName(self):
        r"""日志主题名。
        :rtype: str
        """
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName

    @property
    def LogsetId(self):
        r"""日志集 ID。
        :rtype: str
        """
        return self._LogsetId

    @LogsetId.setter
    def LogsetId(self, LogsetId):
        self._LogsetId = LogsetId


    def _deserialize(self, params):
        self._TopicId = params.get("TopicId")
        self._TopicName = params.get("TopicName")
        self._LogsetId = params.get("LogsetId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Canvas(AbstractModel):
    r"""画布信息。制作视频时，如果源素材（视频或者图片）不能填满输出的视频窗口，将用设置的画布进行背景绘制。

    """

    def __init__(self):
        r"""
        :param _Color: 背景颜色，取值有：
<li>Black：黑色背景</li>
<li>White：白色背景</li>
默认值：Black。
        :type Color: str
        :param _Width: 画布宽度，即输出视频的宽度，取值范围：0~ 3840，单位：px。
默认值：0，表示和第一个视频轨的第一个视频片段的视频宽度一致。
        :type Width: int
        :param _Height: 画布高度，即输出视频的高度（或长边），取值范围：0~ 3840，单位：px。
默认值：0，表示和第一个视频轨的第一个视频片段的视频高度一致。
        :type Height: int
        """
        self._Color = None
        self._Width = None
        self._Height = None

    @property
    def Color(self):
        r"""背景颜色，取值有：
<li>Black：黑色背景</li>
<li>White：白色背景</li>
默认值：Black。
        :rtype: str
        """
        return self._Color

    @Color.setter
    def Color(self, Color):
        self._Color = Color

    @property
    def Width(self):
        r"""画布宽度，即输出视频的宽度，取值范围：0~ 3840，单位：px。
默认值：0，表示和第一个视频轨的第一个视频片段的视频宽度一致。
        :rtype: int
        """
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        r"""画布高度，即输出视频的高度（或长边），取值范围：0~ 3840，单位：px。
默认值：0，表示和第一个视频轨的第一个视频片段的视频高度一致。
        :rtype: int
        """
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height


    def _deserialize(self, params):
        self._Color = params.get("Color")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CdnLogInfo(AbstractModel):
    r"""CDN 日志信息

    """

    def __init__(self):
        r"""
        :param _Date: 日志所属日期， 格式为：yyyy-MM-dd ，如2018-03-01。
        :type Date: str
        :param _Name: 日志名称，格式为：日期小时-域名
如 example.com。
        :type Name: str
        :param _Url: 日志下载链接，24小时内下载有效。
        :type Url: str
        :param _StartTime: 日志起始时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F)。
        :type StartTime: str
        :param _EndTime: 日志结束时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F)。
        :type EndTime: str
        """
        self._Date = None
        self._Name = None
        self._Url = None
        self._StartTime = None
        self._EndTime = None

    @property
    def Date(self):
        r"""日志所属日期， 格式为：yyyy-MM-dd ，如2018-03-01。
        :rtype: str
        """
        return self._Date

    @Date.setter
    def Date(self, Date):
        self._Date = Date

    @property
    def Name(self):
        r"""日志名称，格式为：日期小时-域名
如 example.com。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Url(self):
        r"""日志下载链接，24小时内下载有效。
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def StartTime(self):
        r"""日志起始时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F)。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""日志结束时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F)。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._Date = params.get("Date")
        self._Name = params.get("Name")
        self._Url = params.get("Url")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ChangeClothesConfig(AbstractModel):
    r"""AI 换衣参数配置

    """

    def __init__(self):
        r"""
        :param _ClothesFileInfos: 输入需要更换的**衣物**图片列表。目前最大支持4张图片。
        :type ClothesFileInfos: list of SceneAigcImageTaskInputFileInfo
        """
        self._ClothesFileInfos = None

    @property
    def ClothesFileInfos(self):
        r"""输入需要更换的**衣物**图片列表。目前最大支持4张图片。
        :rtype: list of SceneAigcImageTaskInputFileInfo
        """
        return self._ClothesFileInfos

    @ClothesFileInfos.setter
    def ClothesFileInfos(self, ClothesFileInfos):
        self._ClothesFileInfos = ClothesFileInfos


    def _deserialize(self, params):
        if params.get("ClothesFileInfos") is not None:
            self._ClothesFileInfos = []
            for item in params.get("ClothesFileInfos"):
                obj = SceneAigcImageTaskInputFileInfo()
                obj._deserialize(item)
                self._ClothesFileInfos.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClassificationConfigureInfo(AbstractModel):
    r"""智能分类任务控制参数

    """

    def __init__(self):
        r"""
        :param _Switch: 智能分类任务开关，可选值：
<li>ON：开启智能分类任务；</li>
<li>OFF：关闭智能分类任务。</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        r"""智能分类任务开关，可选值：
<li>ON：开启智能分类任务；</li>
<li>OFF：关闭智能分类任务。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClassificationConfigureInfoForUpdate(AbstractModel):
    r"""智能分类任务控制参数

    """

    def __init__(self):
        r"""
        :param _Switch: 智能分类任务开关，可选值：
<li>ON：开启智能分类任务；</li>
<li>OFF：关闭智能分类任务。</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        r"""智能分类任务开关，可选值：
<li>ON：开启智能分类任务；</li>
<li>OFF：关闭智能分类任务。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClipFileInfo2017(AbstractModel):
    r"""视频裁剪结果文件信息（2017 版）

    """

    def __init__(self):
        r"""
        :param _ErrCode: 错误码
<li>0：成功；</li>
<li>其他值：失败。</li>
        :type ErrCode: int
        :param _Message: 错误描述。
        :type Message: str
        :param _FileId: 输出目标文件的文件 ID。
        :type FileId: str
        :param _FileUrl: 输出目标文件的文件地址。
        :type FileUrl: str
        :param _FileType: 输出目标文件的文件类型。
        :type FileType: str
        """
        self._ErrCode = None
        self._Message = None
        self._FileId = None
        self._FileUrl = None
        self._FileType = None

    @property
    def ErrCode(self):
        r"""错误码
<li>0：成功；</li>
<li>其他值：失败。</li>
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误描述。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def FileId(self):
        r"""输出目标文件的文件 ID。
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def FileUrl(self):
        r"""输出目标文件的文件地址。
        :rtype: str
        """
        return self._FileUrl

    @FileUrl.setter
    def FileUrl(self, FileUrl):
        self._FileUrl = FileUrl

    @property
    def FileType(self):
        r"""输出目标文件的文件类型。
        :rtype: str
        """
        return self._FileType

    @FileType.setter
    def FileType(self, FileType):
        self._FileType = FileType


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        self._FileId = params.get("FileId")
        self._FileUrl = params.get("FileUrl")
        self._FileType = params.get("FileType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClipTask2017(AbstractModel):
    r"""视频剪辑任务信息，该结构仅用于对 2017 版[视频剪辑](https://cloud.tencent.com/document/product/266/10156)接口发起的任务。

    """

    def __init__(self):
        r"""
        :param _TaskId: 视频剪辑任务 ID。
        :type TaskId: str
        :param _SrcFileId: 视频剪辑任务源文件 ID。
        :type SrcFileId: str
        :param _FileInfo: 视频剪辑输出的文件信息。
        :type FileInfo: :class:`tencentcloud.vod.v20180717.models.ClipFileInfo2017`
        """
        self._TaskId = None
        self._SrcFileId = None
        self._FileInfo = None

    @property
    def TaskId(self):
        r"""视频剪辑任务 ID。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def SrcFileId(self):
        r"""视频剪辑任务源文件 ID。
        :rtype: str
        """
        return self._SrcFileId

    @SrcFileId.setter
    def SrcFileId(self, SrcFileId):
        self._SrcFileId = SrcFileId

    @property
    def FileInfo(self):
        r"""视频剪辑输出的文件信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ClipFileInfo2017`
        """
        return self._FileInfo

    @FileInfo.setter
    def FileInfo(self, FileInfo):
        self._FileInfo = FileInfo


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._SrcFileId = params.get("SrcFileId")
        if params.get("FileInfo") is not None:
            self._FileInfo = ClipFileInfo2017()
            self._FileInfo._deserialize(params.get("FileInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ColorEnhanceInfo(AbstractModel):
    r"""色彩增强控制参数

    """

    def __init__(self):
        r"""
        :param _Switch: 色彩增强控制开关，可选值：
<li>ON：开启综合增强；</li>
<li>OFF：关闭综合增强。</li>
        :type Switch: str
        :param _Type: 色彩增强类型，仅当色彩增强控制开关为 ON 时有效，可选值：
<li>weak：轻色彩增强；</li>
<li>normal：正常色彩增强；</li>
<li>strong：强色彩增强。</li>
默认值：weak。
        :type Type: str
        """
        self._Switch = None
        self._Type = None

    @property
    def Switch(self):
        r"""色彩增强控制开关，可选值：
<li>ON：开启综合增强；</li>
<li>OFF：关闭综合增强。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Type(self):
        r"""色彩增强类型，仅当色彩增强控制开关为 ON 时有效，可选值：
<li>weak：轻色彩增强；</li>
<li>normal：正常色彩增强；</li>
<li>strong：强色彩增强。</li>
默认值：weak。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CommitUploadRequest(AbstractModel):
    r"""CommitUpload请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VodSessionKey: 点播会话，取申请上传接口的返回值 VodSessionKey。
        :type VodSessionKey: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._VodSessionKey = None
        self._SubAppId = None

    @property
    def VodSessionKey(self):
        r"""点播会话，取申请上传接口的返回值 VodSessionKey。
        :rtype: str
        """
        return self._VodSessionKey

    @VodSessionKey.setter
    def VodSessionKey(self, VodSessionKey):
        self._VodSessionKey = VodSessionKey

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._VodSessionKey = params.get("VodSessionKey")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CommitUploadResponse(AbstractModel):
    r"""CommitUpload返回参数结构体

    """

    def __init__(self):
        r"""
        :param _FileId: 媒体文件的唯一标识。
        :type FileId: str
        :param _MediaUrl: 媒体播放地址。
        :type MediaUrl: str
        :param _CoverUrl: 媒体封面地址。
        :type CoverUrl: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._FileId = None
        self._MediaUrl = None
        self._CoverUrl = None
        self._RequestId = None

    @property
    def FileId(self):
        r"""媒体文件的唯一标识。
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def MediaUrl(self):
        r"""媒体播放地址。
        :rtype: str
        """
        return self._MediaUrl

    @MediaUrl.setter
    def MediaUrl(self, MediaUrl):
        self._MediaUrl = MediaUrl

    @property
    def CoverUrl(self):
        r"""媒体封面地址。
        :rtype: str
        """
        return self._CoverUrl

    @CoverUrl.setter
    def CoverUrl(self, CoverUrl):
        self._CoverUrl = CoverUrl

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FileId = params.get("FileId")
        self._MediaUrl = params.get("MediaUrl")
        self._CoverUrl = params.get("CoverUrl")
        self._RequestId = params.get("RequestId")


class ComplexAdaptiveDynamicStreamingTask(AbstractModel):
    r"""自适应码流任务信息。

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务 ID。
        :type TaskId: str
        :param _Status: 任务状态，取值：
<li>PROCESSING：处理中；</li>
<li>FINISH：已完成。</li>

        :type Status: str
        :param _ComplexAdaptiveDynamicStreamingTaskResultSet: 自适应码流任务的执行状态与结果，每个元素对应一个自适应码流模板。
        :type ComplexAdaptiveDynamicStreamingTaskResultSet: list of ComplexAdaptiveDynamicStreamingTaskResult
        """
        self._TaskId = None
        self._Status = None
        self._ComplexAdaptiveDynamicStreamingTaskResultSet = None

    @property
    def TaskId(self):
        r"""任务 ID。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Status(self):
        r"""任务状态，取值：
<li>PROCESSING：处理中；</li>
<li>FINISH：已完成。</li>

        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ComplexAdaptiveDynamicStreamingTaskResultSet(self):
        r"""自适应码流任务的执行状态与结果，每个元素对应一个自适应码流模板。
        :rtype: list of ComplexAdaptiveDynamicStreamingTaskResult
        """
        return self._ComplexAdaptiveDynamicStreamingTaskResultSet

    @ComplexAdaptiveDynamicStreamingTaskResultSet.setter
    def ComplexAdaptiveDynamicStreamingTaskResultSet(self, ComplexAdaptiveDynamicStreamingTaskResultSet):
        self._ComplexAdaptiveDynamicStreamingTaskResultSet = ComplexAdaptiveDynamicStreamingTaskResultSet


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Status = params.get("Status")
        if params.get("ComplexAdaptiveDynamicStreamingTaskResultSet") is not None:
            self._ComplexAdaptiveDynamicStreamingTaskResultSet = []
            for item in params.get("ComplexAdaptiveDynamicStreamingTaskResultSet"):
                obj = ComplexAdaptiveDynamicStreamingTaskResult()
                obj._deserialize(item)
                self._ComplexAdaptiveDynamicStreamingTaskResultSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplexAdaptiveDynamicStreamingTaskAudioInput(AbstractModel):
    r"""自适应码流任务多语言音频流输入参数。

    """

    def __init__(self):
        r"""
        :param _FileId: 音频源的媒体 ID。固定取该媒体中的首个音频流，视频流和其它音频流（如有）将被忽略。
        :type FileId: str
        :param _Name: 输出的自适应码流中的音频流名称，长度限制为16个字符。
        :type Name: str
        :param _Language: 输出的自适应码流中的音频流语言，长度限制为16个字符。要求符合 RFC5646 规范。
        :type Language: str
        :param _Default: 是否设置为自适应码流的默认音频。取值：
<li>YES：设置为默认音频；</li>
<li>NO：不设置为默认音频（默认值）。</li>

        :type Default: str
        :param _AudioTrackIdx: 音轨序号，表示选择音频源中的第几个音轨，从0开始计数。默认值为0，表示选择最靠前的音轨。
        :type AudioTrackIdx: int
        """
        self._FileId = None
        self._Name = None
        self._Language = None
        self._Default = None
        self._AudioTrackIdx = None

    @property
    def FileId(self):
        r"""音频源的媒体 ID。固定取该媒体中的首个音频流，视频流和其它音频流（如有）将被忽略。
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def Name(self):
        r"""输出的自适应码流中的音频流名称，长度限制为16个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Language(self):
        r"""输出的自适应码流中的音频流语言，长度限制为16个字符。要求符合 RFC5646 规范。
        :rtype: str
        """
        return self._Language

    @Language.setter
    def Language(self, Language):
        self._Language = Language

    @property
    def Default(self):
        r"""是否设置为自适应码流的默认音频。取值：
<li>YES：设置为默认音频；</li>
<li>NO：不设置为默认音频（默认值）。</li>

        :rtype: str
        """
        return self._Default

    @Default.setter
    def Default(self, Default):
        self._Default = Default

    @property
    def AudioTrackIdx(self):
        r"""音轨序号，表示选择音频源中的第几个音轨，从0开始计数。默认值为0，表示选择最靠前的音轨。
        :rtype: int
        """
        return self._AudioTrackIdx

    @AudioTrackIdx.setter
    def AudioTrackIdx(self, AudioTrackIdx):
        self._AudioTrackIdx = AudioTrackIdx


    def _deserialize(self, params):
        self._FileId = params.get("FileId")
        self._Name = params.get("Name")
        self._Language = params.get("Language")
        self._Default = params.get("Default")
        self._AudioTrackIdx = params.get("AudioTrackIdx")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplexAdaptiveDynamicStreamingTaskInput(AbstractModel):
    r"""自适应码流任务的输入参数。

    """

    def __init__(self):
        r"""
        :param _StreamPara: 自适应码流参数。
        :type StreamPara: :class:`tencentcloud.vod.v20180717.models.ComplexAdaptiveDynamicStreamingTaskStreamPara`
        """
        self._StreamPara = None

    @property
    def StreamPara(self):
        r"""自适应码流参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ComplexAdaptiveDynamicStreamingTaskStreamPara`
        """
        return self._StreamPara

    @StreamPara.setter
    def StreamPara(self, StreamPara):
        self._StreamPara = StreamPara


    def _deserialize(self, params):
        if params.get("StreamPara") is not None:
            self._StreamPara = ComplexAdaptiveDynamicStreamingTaskStreamPara()
            self._StreamPara._deserialize(params.get("StreamPara"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplexAdaptiveDynamicStreamingTaskOutput(AbstractModel):
    r"""自适应码流任务的输出结果。

    """

    def __init__(self):
        r"""
        :param _Definition: 自适应码流模板 ID。
        :type Definition: int
        :param _Format: 自适应码流打包格式。可选值：
<li>HLS；</li>
<li>MPEG-DASH。</li>
        :type Format: str
        :param _DrmType: DRM 方案类型。可选值：
<li>空字符串：无加密；</li>
<li>SimpleAES；</li>
<li>Widevine；</li>
<li>FairPlay。</li>
        :type DrmType: str
        :param _Url: 自适应码流的播放地址。
        :type Url: str
        """
        self._Definition = None
        self._Format = None
        self._DrmType = None
        self._Url = None

    @property
    def Definition(self):
        r"""自适应码流模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Format(self):
        r"""自适应码流打包格式。可选值：
<li>HLS；</li>
<li>MPEG-DASH。</li>
        :rtype: str
        """
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def DrmType(self):
        r"""DRM 方案类型。可选值：
<li>空字符串：无加密；</li>
<li>SimpleAES；</li>
<li>Widevine；</li>
<li>FairPlay。</li>
        :rtype: str
        """
        return self._DrmType

    @DrmType.setter
    def DrmType(self, DrmType):
        self._DrmType = DrmType

    @property
    def Url(self):
        r"""自适应码流的播放地址。
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Format = params.get("Format")
        self._DrmType = params.get("DrmType")
        self._Url = params.get("Url")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplexAdaptiveDynamicStreamingTaskResult(AbstractModel):
    r"""自适应码流任务信息。

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，取值：
<li>PROCESSING：处理中；</li>
<li>SUCCESS：已完成；</li>
<li>FAIL：失败。</li>
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _Message: 错误信息。
        :type Message: str
        :param _Progress: 转码进度，取值范围 [0-100] 。
        :type Progress: int
        :param _Input: 自适应码流任务的输入。
        :type Input: :class:`tencentcloud.vod.v20180717.models.ComplexAdaptiveDynamicStreamingTaskInput`
        :param _Output: 自适应码流任务的输出。
        :type Output: :class:`tencentcloud.vod.v20180717.models.ComplexAdaptiveDynamicStreamingTaskOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._Message = None
        self._Progress = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""任务状态，取值：
<li>PROCESSING：处理中；</li>
<li>SUCCESS：已完成；</li>
<li>FAIL：失败。</li>
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Progress(self):
        r"""转码进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def Input(self):
        r"""自适应码流任务的输入。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ComplexAdaptiveDynamicStreamingTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""自适应码流任务的输出。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ComplexAdaptiveDynamicStreamingTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._Message = params.get("Message")
        self._Progress = params.get("Progress")
        if params.get("Input") is not None:
            self._Input = ComplexAdaptiveDynamicStreamingTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = ComplexAdaptiveDynamicStreamingTaskOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplexAdaptiveDynamicStreamingTaskStreamPara(AbstractModel):
    r"""自适应码流任务的流参数。

    """

    def __init__(self):
        r"""
        :param _Definition: 自适应码流模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""自适应码流模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplexAdaptiveDynamicStreamingTaskSubtitleInput(AbstractModel):
    r"""自适应码流任务多语言字幕的输入参数。

    """

    def __init__(self):
        r"""
        :param _Id: 字幕 ID。该字幕必须归属于自适应码流任务的输入主媒体。
        :type Id: str
        :param _Default: 是否设置为自适应码流的默认字幕。取值：
<li>YES：设置为默认字幕；</li>
<li>NO：不设置为默认字幕（默认值）。</li>
        :type Default: str
        """
        self._Id = None
        self._Default = None

    @property
    def Id(self):
        r"""字幕 ID。该字幕必须归属于自适应码流任务的输入主媒体。
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Default(self):
        r"""是否设置为自适应码流的默认字幕。取值：
<li>YES：设置为默认字幕；</li>
<li>NO：不设置为默认字幕（默认值）。</li>
        :rtype: str
        """
        return self._Default

    @Default.setter
    def Default(self, Default):
        self._Default = Default


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Default = params.get("Default")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeMediaOutput(AbstractModel):
    r"""输出的媒体文件信息。

    """

    def __init__(self):
        r"""
        :param _FileName: 文件名称，最长 64 个字符。
        :type FileName: str
        :param _Description: 描述信息，最长 128 个字符。
        :type Description: str
        :param _ClassId: 分类ID，用于对媒体进行分类管理，可通过 [创建分类](/document/product/266/7812) 接口，创建分类，获得分类 ID。
<li>默认值：0，表示其他分类。</li>
        :type ClassId: int
        :param _ExpireTime: 输出文件的过期时间，超过该时间文件将被删除，默认为永久不过期，格式按照 ISO 8601标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :type ExpireTime: str
        :param _Container: 封装格式，可选值：mp4、mp3。其中，mp3 为纯音频文件。
        :type Container: str
        :param _VideoStream: 输出的视频信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type VideoStream: :class:`tencentcloud.vod.v20180717.models.OutputVideoStream`
        :param _AudioStream: 输出的音频信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type AudioStream: :class:`tencentcloud.vod.v20180717.models.OutputAudioStream`
        :param _RemoveVideo: 是否去除视频数据，可选值：
<li>0：保留</li>
<li>1：去除</li>
默认值：0。
        :type RemoveVideo: int
        :param _RemoveAudio: 是否去除音频数据，可选值：
<li>0：保留</li>
<li>1：去除</li>
默认值：0。
        :type RemoveAudio: int
        """
        self._FileName = None
        self._Description = None
        self._ClassId = None
        self._ExpireTime = None
        self._Container = None
        self._VideoStream = None
        self._AudioStream = None
        self._RemoveVideo = None
        self._RemoveAudio = None

    @property
    def FileName(self):
        r"""文件名称，最长 64 个字符。
        :rtype: str
        """
        return self._FileName

    @FileName.setter
    def FileName(self, FileName):
        self._FileName = FileName

    @property
    def Description(self):
        r"""描述信息，最长 128 个字符。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def ClassId(self):
        r"""分类ID，用于对媒体进行分类管理，可通过 [创建分类](/document/product/266/7812) 接口，创建分类，获得分类 ID。
<li>默认值：0，表示其他分类。</li>
        :rtype: int
        """
        return self._ClassId

    @ClassId.setter
    def ClassId(self, ClassId):
        self._ClassId = ClassId

    @property
    def ExpireTime(self):
        r"""输出文件的过期时间，超过该时间文件将被删除，默认为永久不过期，格式按照 ISO 8601标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def Container(self):
        r"""封装格式，可选值：mp4、mp3。其中，mp3 为纯音频文件。
        :rtype: str
        """
        return self._Container

    @Container.setter
    def Container(self, Container):
        self._Container = Container

    @property
    def VideoStream(self):
        r"""输出的视频信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.OutputVideoStream`
        """
        return self._VideoStream

    @VideoStream.setter
    def VideoStream(self, VideoStream):
        self._VideoStream = VideoStream

    @property
    def AudioStream(self):
        r"""输出的音频信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.OutputAudioStream`
        """
        return self._AudioStream

    @AudioStream.setter
    def AudioStream(self, AudioStream):
        self._AudioStream = AudioStream

    @property
    def RemoveVideo(self):
        r"""是否去除视频数据，可选值：
<li>0：保留</li>
<li>1：去除</li>
默认值：0。
        :rtype: int
        """
        return self._RemoveVideo

    @RemoveVideo.setter
    def RemoveVideo(self, RemoveVideo):
        self._RemoveVideo = RemoveVideo

    @property
    def RemoveAudio(self):
        r"""是否去除音频数据，可选值：
<li>0：保留</li>
<li>1：去除</li>
默认值：0。
        :rtype: int
        """
        return self._RemoveAudio

    @RemoveAudio.setter
    def RemoveAudio(self, RemoveAudio):
        self._RemoveAudio = RemoveAudio


    def _deserialize(self, params):
        self._FileName = params.get("FileName")
        self._Description = params.get("Description")
        self._ClassId = params.get("ClassId")
        self._ExpireTime = params.get("ExpireTime")
        self._Container = params.get("Container")
        if params.get("VideoStream") is not None:
            self._VideoStream = OutputVideoStream()
            self._VideoStream._deserialize(params.get("VideoStream"))
        if params.get("AudioStream") is not None:
            self._AudioStream = OutputAudioStream()
            self._AudioStream._deserialize(params.get("AudioStream"))
        self._RemoveVideo = params.get("RemoveVideo")
        self._RemoveAudio = params.get("RemoveAudio")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeMediaRequest(AbstractModel):
    r"""ComposeMedia请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Tracks: 输入的媒体轨道列表，包括视频、音频、图片等素材组成的多个轨道信息，其中：<li>输入的多个轨道在时间轴上和输出媒体文件的时间轴对齐；</li><li>时间轴上相同时间点的各个轨道的素材进行重叠，视频或者图片按轨道顺序进行图像的叠加，轨道顺序高的素材叠加在上面，音频素材进行混音；</li><li>视频、音频、图片，每一种类型的轨道最多支持 10 个。</li><li>所有类型的轨道上放置的媒体片段数量总和最多支持 500 个。</li>
        :type Tracks: list of MediaTrack
        :param _Output: 输出的媒体文件信息。
        :type Output: :class:`tencentcloud.vod.v20180717.models.ComposeMediaOutput`
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Canvas: 制作视频文件时使用的画布。
        :type Canvas: :class:`tencentcloud.vod.v20180717.models.Canvas`
        :param _SessionContext: 标识来源上下文，用于透传用户请求信息，在ComposeMediaComplete回调将返回该字段值，最长 1000个字符。
        :type SessionContext: str
        :param _SessionId: 用于任务去重的识别码，如果三天内曾有过相同的识别码的请求，则本次的请求会返回错误。最长 50 个字符，不带或者带空字符串表示不做去重。
        :type SessionId: str
        """
        self._Tracks = None
        self._Output = None
        self._SubAppId = None
        self._Canvas = None
        self._SessionContext = None
        self._SessionId = None

    @property
    def Tracks(self):
        r"""输入的媒体轨道列表，包括视频、音频、图片等素材组成的多个轨道信息，其中：<li>输入的多个轨道在时间轴上和输出媒体文件的时间轴对齐；</li><li>时间轴上相同时间点的各个轨道的素材进行重叠，视频或者图片按轨道顺序进行图像的叠加，轨道顺序高的素材叠加在上面，音频素材进行混音；</li><li>视频、音频、图片，每一种类型的轨道最多支持 10 个。</li><li>所有类型的轨道上放置的媒体片段数量总和最多支持 500 个。</li>
        :rtype: list of MediaTrack
        """
        return self._Tracks

    @Tracks.setter
    def Tracks(self, Tracks):
        self._Tracks = Tracks

    @property
    def Output(self):
        r"""输出的媒体文件信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ComposeMediaOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Canvas(self):
        r"""制作视频文件时使用的画布。
        :rtype: :class:`tencentcloud.vod.v20180717.models.Canvas`
        """
        return self._Canvas

    @Canvas.setter
    def Canvas(self, Canvas):
        self._Canvas = Canvas

    @property
    def SessionContext(self):
        r"""标识来源上下文，用于透传用户请求信息，在ComposeMediaComplete回调将返回该字段值，最长 1000个字符。
        :rtype: str
        """
        return self._SessionContext

    @SessionContext.setter
    def SessionContext(self, SessionContext):
        self._SessionContext = SessionContext

    @property
    def SessionId(self):
        r"""用于任务去重的识别码，如果三天内曾有过相同的识别码的请求，则本次的请求会返回错误。最长 50 个字符，不带或者带空字符串表示不做去重。
        :rtype: str
        """
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId


    def _deserialize(self, params):
        if params.get("Tracks") is not None:
            self._Tracks = []
            for item in params.get("Tracks"):
                obj = MediaTrack()
                obj._deserialize(item)
                self._Tracks.append(obj)
        if params.get("Output") is not None:
            self._Output = ComposeMediaOutput()
            self._Output._deserialize(params.get("Output"))
        self._SubAppId = params.get("SubAppId")
        if params.get("Canvas") is not None:
            self._Canvas = Canvas()
            self._Canvas._deserialize(params.get("Canvas"))
        self._SessionContext = params.get("SessionContext")
        self._SessionId = params.get("SessionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeMediaResponse(AbstractModel):
    r"""ComposeMedia返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 制作媒体文件的任务 ID，可以通过该 ID 查询制作任务（任务类型为 MakeMedia）的状态。
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        r"""制作媒体文件的任务 ID，可以通过该 ID 查询制作任务（任务类型为 MakeMedia）的状态。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class ComposeMediaTask(AbstractModel):
    r"""制作媒体文件任务信息

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务 ID。
        :type TaskId: str
        :param _Status: 任务流状态，取值：
<li>PROCESSING：处理中；</li>
<li>FINISH：已完成。</li>
        :type Status: str
        :param _ErrCode: 错误码
<li>0：成功；</li>
<li>其他值：失败。</li>
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Progress: 制作媒体文件任务进度，取值范围 [0-100] 。
        :type Progress: int
        :param _Input: 制作媒体文件任务的输入。
        :type Input: :class:`tencentcloud.vod.v20180717.models.ComposeMediaTaskInput`
        :param _Output: 制作媒体文件任务的输出。
        :type Output: :class:`tencentcloud.vod.v20180717.models.ComposeMediaTaskOutput`
        :param _MetaData: 输出视频的元信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type MetaData: :class:`tencentcloud.vod.v20180717.models.MediaMetaData`
        :param _SessionId: 用于去重的识别码，如果七天内曾有过相同的识别码的请求，则本次的请求会返回错误。最长 50 个字符，不带或者带空字符串表示不做去重。
        :type SessionId: str
        :param _SessionContext: 来源上下文，用于透传用户请求信息，任务流状态变更回调将返回该字段值，最长 1000 个字符。
        :type SessionContext: str
        """
        self._TaskId = None
        self._Status = None
        self._ErrCode = None
        self._Message = None
        self._Progress = None
        self._Input = None
        self._Output = None
        self._MetaData = None
        self._SessionId = None
        self._SessionContext = None

    @property
    def TaskId(self):
        r"""任务 ID。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Status(self):
        r"""任务流状态，取值：
<li>PROCESSING：处理中；</li>
<li>FINISH：已完成。</li>
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        r"""错误码
<li>0：成功；</li>
<li>其他值：失败。</li>
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Progress(self):
        r"""制作媒体文件任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def Input(self):
        r"""制作媒体文件任务的输入。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ComposeMediaTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""制作媒体文件任务的输出。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ComposeMediaTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def MetaData(self):
        r"""输出视频的元信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.MediaMetaData`
        """
        return self._MetaData

    @MetaData.setter
    def MetaData(self, MetaData):
        self._MetaData = MetaData

    @property
    def SessionId(self):
        r"""用于去重的识别码，如果七天内曾有过相同的识别码的请求，则本次的请求会返回错误。最长 50 个字符，不带或者带空字符串表示不做去重。
        :rtype: str
        """
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def SessionContext(self):
        r"""来源上下文，用于透传用户请求信息，任务流状态变更回调将返回该字段值，最长 1000 个字符。
        :rtype: str
        """
        return self._SessionContext

    @SessionContext.setter
    def SessionContext(self, SessionContext):
        self._SessionContext = SessionContext


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        self._Progress = params.get("Progress")
        if params.get("Input") is not None:
            self._Input = ComposeMediaTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = ComposeMediaTaskOutput()
            self._Output._deserialize(params.get("Output"))
        if params.get("MetaData") is not None:
            self._MetaData = MediaMetaData()
            self._MetaData._deserialize(params.get("MetaData"))
        self._SessionId = params.get("SessionId")
        self._SessionContext = params.get("SessionContext")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeMediaTaskInput(AbstractModel):
    r"""制作媒体文件任务的输入。

    """

    def __init__(self):
        r"""
        :param _Tracks: 输入的媒体轨道列表，包括视频、音频、图片等素材组成的多个轨道信息。
        :type Tracks: list of MediaTrack
        :param _Canvas: 制作视频文件时使用的画布。
注意：此字段可能返回 null，表示取不到有效值。
        :type Canvas: :class:`tencentcloud.vod.v20180717.models.Canvas`
        :param _Output: 输出的媒体文件信息。
        :type Output: :class:`tencentcloud.vod.v20180717.models.ComposeMediaOutput`
        """
        self._Tracks = None
        self._Canvas = None
        self._Output = None

    @property
    def Tracks(self):
        r"""输入的媒体轨道列表，包括视频、音频、图片等素材组成的多个轨道信息。
        :rtype: list of MediaTrack
        """
        return self._Tracks

    @Tracks.setter
    def Tracks(self, Tracks):
        self._Tracks = Tracks

    @property
    def Canvas(self):
        r"""制作视频文件时使用的画布。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.Canvas`
        """
        return self._Canvas

    @Canvas.setter
    def Canvas(self, Canvas):
        self._Canvas = Canvas

    @property
    def Output(self):
        r"""输出的媒体文件信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ComposeMediaOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        if params.get("Tracks") is not None:
            self._Tracks = []
            for item in params.get("Tracks"):
                obj = MediaTrack()
                obj._deserialize(item)
                self._Tracks.append(obj)
        if params.get("Canvas") is not None:
            self._Canvas = Canvas()
            self._Canvas._deserialize(params.get("Canvas"))
        if params.get("Output") is not None:
            self._Output = ComposeMediaOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeMediaTaskOutput(AbstractModel):
    r"""制作媒体文件任务的输出。

    """

    def __init__(self):
        r"""
        :param _FileType: 文件类型，例如 mp4、mp3 等。
        :type FileType: str
        :param _FileId: 媒体文件 ID。
        :type FileId: str
        :param _FileUrl: 媒体文件播放地址。
        :type FileUrl: str
        :param _MediaName: 文件名称，最长 64 个字符。
        :type MediaName: str
        :param _ClassId: 分类ID，用于对媒体进行分类管理，可通过 [创建分类](/document/product/266/7812) 接口，创建分类，获得分类 ID。
<li>默认值：0，表示其他分类。</li>
        :type ClassId: int
        :param _ExpireTime: 输出文件的过期时间，超过该时间文件将被删除，默认为永久不过期，格式按照 ISO 8601标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :type ExpireTime: str
        """
        self._FileType = None
        self._FileId = None
        self._FileUrl = None
        self._MediaName = None
        self._ClassId = None
        self._ExpireTime = None

    @property
    def FileType(self):
        r"""文件类型，例如 mp4、mp3 等。
        :rtype: str
        """
        return self._FileType

    @FileType.setter
    def FileType(self, FileType):
        self._FileType = FileType

    @property
    def FileId(self):
        r"""媒体文件 ID。
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def FileUrl(self):
        r"""媒体文件播放地址。
        :rtype: str
        """
        return self._FileUrl

    @FileUrl.setter
    def FileUrl(self, FileUrl):
        self._FileUrl = FileUrl

    @property
    def MediaName(self):
        r"""文件名称，最长 64 个字符。
        :rtype: str
        """
        return self._MediaName

    @MediaName.setter
    def MediaName(self, MediaName):
        self._MediaName = MediaName

    @property
    def ClassId(self):
        r"""分类ID，用于对媒体进行分类管理，可通过 [创建分类](/document/product/266/7812) 接口，创建分类，获得分类 ID。
<li>默认值：0，表示其他分类。</li>
        :rtype: int
        """
        return self._ClassId

    @ClassId.setter
    def ClassId(self, ClassId):
        self._ClassId = ClassId

    @property
    def ExpireTime(self):
        r"""输出文件的过期时间，超过该时间文件将被删除，默认为永久不过期，格式按照 ISO 8601标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime


    def _deserialize(self, params):
        self._FileType = params.get("FileType")
        self._FileId = params.get("FileId")
        self._FileUrl = params.get("FileUrl")
        self._MediaName = params.get("MediaName")
        self._ClassId = params.get("ClassId")
        self._ExpireTime = params.get("ExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ConcatFileInfo2017(AbstractModel):
    r"""视频拼接源文件信息（2017 版）

    """

    def __init__(self):
        r"""
        :param _ErrCode: 错误码
<li>0：成功；</li>
<li>其他值：失败。</li>
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _FileId: 视频拼接源文件的 ID。
        :type FileId: str
        :param _FileUrl: 视频拼接源文件的地址。
        :type FileUrl: str
        :param _FileType: 视频拼接源文件的格式。
        :type FileType: str
        """
        self._ErrCode = None
        self._Message = None
        self._FileId = None
        self._FileUrl = None
        self._FileType = None

    @property
    def ErrCode(self):
        r"""错误码
<li>0：成功；</li>
<li>其他值：失败。</li>
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def FileId(self):
        r"""视频拼接源文件的 ID。
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def FileUrl(self):
        r"""视频拼接源文件的地址。
        :rtype: str
        """
        return self._FileUrl

    @FileUrl.setter
    def FileUrl(self, FileUrl):
        self._FileUrl = FileUrl

    @property
    def FileType(self):
        r"""视频拼接源文件的格式。
        :rtype: str
        """
        return self._FileType

    @FileType.setter
    def FileType(self, FileType):
        self._FileType = FileType


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        self._FileId = params.get("FileId")
        self._FileUrl = params.get("FileUrl")
        self._FileType = params.get("FileType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ConcatTask2017(AbstractModel):
    r"""视频拼接任务信息，该结构仅用于对 2017 版[视频拼接](https://cloud.tencent.com/document/product/266/7821)接口发起的任务。

    """

    def __init__(self):
        r"""
        :param _TaskId: 视频拼接任务 ID。
        :type TaskId: str
        :param _FileInfoSet: 视频拼接源文件信息。
        :type FileInfoSet: list of ConcatFileInfo2017
        """
        self._TaskId = None
        self._FileInfoSet = None

    @property
    def TaskId(self):
        r"""视频拼接任务 ID。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def FileInfoSet(self):
        r"""视频拼接源文件信息。
        :rtype: list of ConcatFileInfo2017
        """
        return self._FileInfoSet

    @FileInfoSet.setter
    def FileInfoSet(self, FileInfoSet):
        self._FileInfoSet = FileInfoSet


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        if params.get("FileInfoSet") is not None:
            self._FileInfoSet = []
            for item in params.get("FileInfoSet"):
                obj = ConcatFileInfo2017()
                obj._deserialize(item)
                self._FileInfoSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ConfirmEventsRequest(AbstractModel):
    r"""ConfirmEvents请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EventHandles: 事件句柄，即 [拉取事件通知](/document/product/266/33433) 接口输出参数中的 EventSet. EventHandle 字段。
数组长度限制：16。
        :type EventHandles: list of str
        :param _ExtInfo: 保留字段，特殊用途时使用。
        :type ExtInfo: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._EventHandles = None
        self._ExtInfo = None
        self._SubAppId = None

    @property
    def EventHandles(self):
        r"""事件句柄，即 [拉取事件通知](/document/product/266/33433) 接口输出参数中的 EventSet. EventHandle 字段。
数组长度限制：16。
        :rtype: list of str
        """
        return self._EventHandles

    @EventHandles.setter
    def EventHandles(self, EventHandles):
        self._EventHandles = EventHandles

    @property
    def ExtInfo(self):
        r"""保留字段，特殊用途时使用。
        :rtype: str
        """
        return self._ExtInfo

    @ExtInfo.setter
    def ExtInfo(self, ExtInfo):
        self._ExtInfo = ExtInfo

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._EventHandles = params.get("EventHandles")
        self._ExtInfo = params.get("ExtInfo")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ConfirmEventsResponse(AbstractModel):
    r"""ConfirmEvents返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ContentReviewOcrResult(AbstractModel):
    r"""图片Ocr 文字鉴别信息的任务结果类型

    """

    def __init__(self):
        r"""
        :param _Confidence: Ocr 文字鉴别结果的评分，分值为0到100。
        :type Confidence: float
        :param _Suggestion: Ocr 文字鉴别的结果建议，取值范围：
<li>pass；</li>
<li>review；</li>
<li>block。</li>
        :type Suggestion: str
        :param _KeywordSet: Ocr 文字鉴别的嫌疑关键词列表。
        :type KeywordSet: list of str
        :param _AreaCoordSet: Ocr 文字鉴别的嫌疑文字出现的区域坐标 (像素级)，[x1, y1, x2, y2]，即左上角坐标、右下角坐标。
        :type AreaCoordSet: list of int
        """
        self._Confidence = None
        self._Suggestion = None
        self._KeywordSet = None
        self._AreaCoordSet = None

    @property
    def Confidence(self):
        r"""Ocr 文字鉴别结果的评分，分值为0到100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        r"""Ocr 文字鉴别的结果建议，取值范围：
<li>pass；</li>
<li>review；</li>
<li>block。</li>
        :rtype: str
        """
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def KeywordSet(self):
        r"""Ocr 文字鉴别的嫌疑关键词列表。
        :rtype: list of str
        """
        return self._KeywordSet

    @KeywordSet.setter
    def KeywordSet(self, KeywordSet):
        self._KeywordSet = KeywordSet

    @property
    def AreaCoordSet(self):
        r"""Ocr 文字鉴别的嫌疑文字出现的区域坐标 (像素级)，[x1, y1, x2, y2]，即左上角坐标、右下角坐标。
        :rtype: list of int
        """
        return self._AreaCoordSet

    @AreaCoordSet.setter
    def AreaCoordSet(self, AreaCoordSet):
        self._AreaCoordSet = AreaCoordSet


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        self._KeywordSet = params.get("KeywordSet")
        self._AreaCoordSet = params.get("AreaCoordSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ContentReviewResult(AbstractModel):
    r"""图片智能内容识别任务结果

    """

    def __init__(self):
        r"""
        :param _Type: 结果类型，取值范围：
<li>Porn.Image：图片画面中的鉴别令人反感的信息结果；</li>
<li>Terrorism.Image：图片画面中的鉴别令人不安全的信息结果；</li>
<li>Political.Image：图片画面中的鉴别令人不适宜信息结果；</li>
<li>Porn.Ocr：图片 OCR 文字中的鉴别令人反感的信息结果；</li>
<li>Terrorism.Ocr：图片 OCR 文字中的鉴别令人不安全的信息结果；</li>
<li>Political.Ocr：图片 OCR 文字中的鉴别令人不适宜信息结果。</li>
        :type Type: str
        :param _PornImageResult: 图片画面中的鉴别令人反感的信息结果，当 Type 为 Porn.Image 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type PornImageResult: :class:`tencentcloud.vod.v20180717.models.PornImageResult`
        :param _TerrorismImageResult: 图片画面中的鉴别令人不安全的信息结果，当 Type 为 Terrorism.Image 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type TerrorismImageResult: :class:`tencentcloud.vod.v20180717.models.TerrorismImageResult`
        :param _PoliticalImageResult: 图片画面中的鉴别令人不适宜信息结果，当 Type 为 Political.Image 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type PoliticalImageResult: :class:`tencentcloud.vod.v20180717.models.PoliticalImageResult`
        :param _PornOcrResult: 图片 OCR 文字中的鉴别令人反感的信息结果，当 Type 为 Porn.Ocr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type PornOcrResult: :class:`tencentcloud.vod.v20180717.models.ContentReviewOcrResult`
        :param _TerrorismOcrResult: 图片 OCR 中的鉴别令人不安全的信息结果，当 Type 为 Terrorism.Ocr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type TerrorismOcrResult: :class:`tencentcloud.vod.v20180717.models.ContentReviewOcrResult`
        :param _PoliticalOcrResult: 图片 OCR 文字中的鉴别令人不适宜信息结果，当 Type 为 Political.Ocr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type PoliticalOcrResult: :class:`tencentcloud.vod.v20180717.models.ContentReviewOcrResult`
        """
        self._Type = None
        self._PornImageResult = None
        self._TerrorismImageResult = None
        self._PoliticalImageResult = None
        self._PornOcrResult = None
        self._TerrorismOcrResult = None
        self._PoliticalOcrResult = None

    @property
    def Type(self):
        r"""结果类型，取值范围：
<li>Porn.Image：图片画面中的鉴别令人反感的信息结果；</li>
<li>Terrorism.Image：图片画面中的鉴别令人不安全的信息结果；</li>
<li>Political.Image：图片画面中的鉴别令人不适宜信息结果；</li>
<li>Porn.Ocr：图片 OCR 文字中的鉴别令人反感的信息结果；</li>
<li>Terrorism.Ocr：图片 OCR 文字中的鉴别令人不安全的信息结果；</li>
<li>Political.Ocr：图片 OCR 文字中的鉴别令人不适宜信息结果。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def PornImageResult(self):
        r"""图片画面中的鉴别令人反感的信息结果，当 Type 为 Porn.Image 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.PornImageResult`
        """
        return self._PornImageResult

    @PornImageResult.setter
    def PornImageResult(self, PornImageResult):
        self._PornImageResult = PornImageResult

    @property
    def TerrorismImageResult(self):
        r"""图片画面中的鉴别令人不安全的信息结果，当 Type 为 Terrorism.Image 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.TerrorismImageResult`
        """
        return self._TerrorismImageResult

    @TerrorismImageResult.setter
    def TerrorismImageResult(self, TerrorismImageResult):
        self._TerrorismImageResult = TerrorismImageResult

    @property
    def PoliticalImageResult(self):
        r"""图片画面中的鉴别令人不适宜信息结果，当 Type 为 Political.Image 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.PoliticalImageResult`
        """
        return self._PoliticalImageResult

    @PoliticalImageResult.setter
    def PoliticalImageResult(self, PoliticalImageResult):
        self._PoliticalImageResult = PoliticalImageResult

    @property
    def PornOcrResult(self):
        r"""图片 OCR 文字中的鉴别令人反感的信息结果，当 Type 为 Porn.Ocr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ContentReviewOcrResult`
        """
        return self._PornOcrResult

    @PornOcrResult.setter
    def PornOcrResult(self, PornOcrResult):
        self._PornOcrResult = PornOcrResult

    @property
    def TerrorismOcrResult(self):
        r"""图片 OCR 中的鉴别令人不安全的信息结果，当 Type 为 Terrorism.Ocr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ContentReviewOcrResult`
        """
        return self._TerrorismOcrResult

    @TerrorismOcrResult.setter
    def TerrorismOcrResult(self, TerrorismOcrResult):
        self._TerrorismOcrResult = TerrorismOcrResult

    @property
    def PoliticalOcrResult(self):
        r"""图片 OCR 文字中的鉴别令人不适宜信息结果，当 Type 为 Political.Ocr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ContentReviewOcrResult`
        """
        return self._PoliticalOcrResult

    @PoliticalOcrResult.setter
    def PoliticalOcrResult(self, PoliticalOcrResult):
        self._PoliticalOcrResult = PoliticalOcrResult


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("PornImageResult") is not None:
            self._PornImageResult = PornImageResult()
            self._PornImageResult._deserialize(params.get("PornImageResult"))
        if params.get("TerrorismImageResult") is not None:
            self._TerrorismImageResult = TerrorismImageResult()
            self._TerrorismImageResult._deserialize(params.get("TerrorismImageResult"))
        if params.get("PoliticalImageResult") is not None:
            self._PoliticalImageResult = PoliticalImageResult()
            self._PoliticalImageResult._deserialize(params.get("PoliticalImageResult"))
        if params.get("PornOcrResult") is not None:
            self._PornOcrResult = ContentReviewOcrResult()
            self._PornOcrResult._deserialize(params.get("PornOcrResult"))
        if params.get("TerrorismOcrResult") is not None:
            self._TerrorismOcrResult = ContentReviewOcrResult()
            self._TerrorismOcrResult._deserialize(params.get("TerrorismOcrResult"))
        if params.get("PoliticalOcrResult") is not None:
            self._PoliticalOcrResult = ContentReviewOcrResult()
            self._PoliticalOcrResult._deserialize(params.get("PoliticalOcrResult"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ContentReviewTemplateItem(AbstractModel):
    r"""音视频审核模板详情

    """

    def __init__(self):
        r"""
        :param _Definition: 音视频审核模板唯一标识。
        :type Definition: int
        :param _Name: 音视频审核模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Comment: 音视频审核模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _PornConfigure: 鉴别涉及令人反感的信息的控制参数。
        :type PornConfigure: :class:`tencentcloud.vod.v20180717.models.PornConfigureInfo`
        :param _TerrorismConfigure: 鉴别涉及令人不安全的信息的控制参数。
        :type TerrorismConfigure: :class:`tencentcloud.vod.v20180717.models.TerrorismConfigureInfo`
        :param _PoliticalConfigure: 鉴别涉及令人不适宜的信息的控制参数。
        :type PoliticalConfigure: :class:`tencentcloud.vod.v20180717.models.PoliticalConfigureInfo`
        :param _ProhibitedConfigure: 违禁控制参数。违禁内容包括：
<li>谩骂；</li>
<li>涉毒违法。</li>
        :type ProhibitedConfigure: :class:`tencentcloud.vod.v20180717.models.ProhibitedConfigureInfo`
        :param _UserDefineConfigure: 用户自定义音视频审核控制参数。
        :type UserDefineConfigure: :class:`tencentcloud.vod.v20180717.models.UserDefineConfigureInfo`
        :param _ReviewWallSwitch: 音视频审核结果是否进入音视频审核墙（对音视频审核结果进行人工复核）的开关。
<li>ON：是；</li>
<li>OFF：否。</li>
        :type ReviewWallSwitch: str
        :param _ScreenshotInterval: 截帧间隔，单位为秒。当不填时，默认截帧间隔为 1 秒，最小值为 0.5 秒。
        :type ScreenshotInterval: float
        :param _CreateTime: 模板创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type CreateTime: str
        :param _UpdateTime: 模板最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type UpdateTime: str
        """
        self._Definition = None
        self._Name = None
        self._Comment = None
        self._PornConfigure = None
        self._TerrorismConfigure = None
        self._PoliticalConfigure = None
        self._ProhibitedConfigure = None
        self._UserDefineConfigure = None
        self._ReviewWallSwitch = None
        self._ScreenshotInterval = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def Definition(self):
        r"""音视频审核模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Name(self):
        r"""音视频审核模板名称，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        r"""音视频审核模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def PornConfigure(self):
        r"""鉴别涉及令人反感的信息的控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.PornConfigureInfo`
        """
        return self._PornConfigure

    @PornConfigure.setter
    def PornConfigure(self, PornConfigure):
        self._PornConfigure = PornConfigure

    @property
    def TerrorismConfigure(self):
        r"""鉴别涉及令人不安全的信息的控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.TerrorismConfigureInfo`
        """
        return self._TerrorismConfigure

    @TerrorismConfigure.setter
    def TerrorismConfigure(self, TerrorismConfigure):
        self._TerrorismConfigure = TerrorismConfigure

    @property
    def PoliticalConfigure(self):
        r"""鉴别涉及令人不适宜的信息的控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.PoliticalConfigureInfo`
        """
        return self._PoliticalConfigure

    @PoliticalConfigure.setter
    def PoliticalConfigure(self, PoliticalConfigure):
        self._PoliticalConfigure = PoliticalConfigure

    @property
    def ProhibitedConfigure(self):
        r"""违禁控制参数。违禁内容包括：
<li>谩骂；</li>
<li>涉毒违法。</li>
        :rtype: :class:`tencentcloud.vod.v20180717.models.ProhibitedConfigureInfo`
        """
        return self._ProhibitedConfigure

    @ProhibitedConfigure.setter
    def ProhibitedConfigure(self, ProhibitedConfigure):
        self._ProhibitedConfigure = ProhibitedConfigure

    @property
    def UserDefineConfigure(self):
        r"""用户自定义音视频审核控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.UserDefineConfigureInfo`
        """
        return self._UserDefineConfigure

    @UserDefineConfigure.setter
    def UserDefineConfigure(self, UserDefineConfigure):
        self._UserDefineConfigure = UserDefineConfigure

    @property
    def ReviewWallSwitch(self):
        r"""音视频审核结果是否进入音视频审核墙（对音视频审核结果进行人工复核）的开关。
<li>ON：是；</li>
<li>OFF：否。</li>
        :rtype: str
        """
        return self._ReviewWallSwitch

    @ReviewWallSwitch.setter
    def ReviewWallSwitch(self, ReviewWallSwitch):
        self._ReviewWallSwitch = ReviewWallSwitch

    @property
    def ScreenshotInterval(self):
        r"""截帧间隔，单位为秒。当不填时，默认截帧间隔为 1 秒，最小值为 0.5 秒。
        :rtype: float
        """
        return self._ScreenshotInterval

    @ScreenshotInterval.setter
    def ScreenshotInterval(self, ScreenshotInterval):
        self._ScreenshotInterval = ScreenshotInterval

    @property
    def CreateTime(self):
        r"""模板创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""模板最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("PornConfigure") is not None:
            self._PornConfigure = PornConfigureInfo()
            self._PornConfigure._deserialize(params.get("PornConfigure"))
        if params.get("TerrorismConfigure") is not None:
            self._TerrorismConfigure = TerrorismConfigureInfo()
            self._TerrorismConfigure._deserialize(params.get("TerrorismConfigure"))
        if params.get("PoliticalConfigure") is not None:
            self._PoliticalConfigure = PoliticalConfigureInfo()
            self._PoliticalConfigure._deserialize(params.get("PoliticalConfigure"))
        if params.get("ProhibitedConfigure") is not None:
            self._ProhibitedConfigure = ProhibitedConfigureInfo()
            self._ProhibitedConfigure._deserialize(params.get("ProhibitedConfigure"))
        if params.get("UserDefineConfigure") is not None:
            self._UserDefineConfigure = UserDefineConfigureInfo()
            self._UserDefineConfigure._deserialize(params.get("UserDefineConfigure"))
        self._ReviewWallSwitch = params.get("ReviewWallSwitch")
        self._ScreenshotInterval = params.get("ScreenshotInterval")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CopyRightWatermarkInput(AbstractModel):
    r"""版权水印参数

    """

    def __init__(self):
        r"""
        :param _Text: 版权信息，最大长度为 200 个字符。
        :type Text: str
        """
        self._Text = None

    @property
    def Text(self):
        r"""版权信息，最大长度为 200 个字符。
        :rtype: str
        """
        return self._Text

    @Text.setter
    def Text(self, Text):
        self._Text = Text


    def _deserialize(self, params):
        self._Text = params.get("Text")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CoverBySnapshotTaskInput(AbstractModel):
    r"""对视频截图做封面任务输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 指定时间点截图模板 ID。
        :type Definition: int
        :param _PositionType: 截图方式。包含：
<li>Time：依照时间点截图</li>
<li>Percent：依照百分比截图</li>
        :type PositionType: str
        :param _PositionValue: 截图位置：
<li>对于依照时间点截图，该值表示指定视频第几秒的截图作为封面</li>
<li>对于依照百分比截图，该值表示使用视频百分之多少的截图作为封面</li>
        :type PositionValue: float
        :param _WatermarkSet: 水印列表，支持多张图片或文字水印，最大可支持 10 张。
        :type WatermarkSet: list of WatermarkInput
        """
        self._Definition = None
        self._PositionType = None
        self._PositionValue = None
        self._WatermarkSet = None

    @property
    def Definition(self):
        r"""指定时间点截图模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def PositionType(self):
        r"""截图方式。包含：
<li>Time：依照时间点截图</li>
<li>Percent：依照百分比截图</li>
        :rtype: str
        """
        return self._PositionType

    @PositionType.setter
    def PositionType(self, PositionType):
        self._PositionType = PositionType

    @property
    def PositionValue(self):
        r"""截图位置：
<li>对于依照时间点截图，该值表示指定视频第几秒的截图作为封面</li>
<li>对于依照百分比截图，该值表示使用视频百分之多少的截图作为封面</li>
        :rtype: float
        """
        return self._PositionValue

    @PositionValue.setter
    def PositionValue(self, PositionValue):
        self._PositionValue = PositionValue

    @property
    def WatermarkSet(self):
        r"""水印列表，支持多张图片或文字水印，最大可支持 10 张。
        :rtype: list of WatermarkInput
        """
        return self._WatermarkSet

    @WatermarkSet.setter
    def WatermarkSet(self, WatermarkSet):
        self._WatermarkSet = WatermarkSet


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._PositionType = params.get("PositionType")
        self._PositionValue = params.get("PositionValue")
        if params.get("WatermarkSet") is not None:
            self._WatermarkSet = []
            for item in params.get("WatermarkSet"):
                obj = WatermarkInput()
                obj._deserialize(item)
                self._WatermarkSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CoverBySnapshotTaskOutput(AbstractModel):
    r"""对视频截图做封面任务输出类型

    """

    def __init__(self):
        r"""
        :param _CoverUrl: 封面 URL。
        :type CoverUrl: str
        """
        self._CoverUrl = None

    @property
    def CoverUrl(self):
        r"""封面 URL。
        :rtype: str
        """
        return self._CoverUrl

    @CoverUrl.setter
    def CoverUrl(self, CoverUrl):
        self._CoverUrl = CoverUrl


    def _deserialize(self, params):
        self._CoverUrl = params.get("CoverUrl")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CoverConfigureInfo(AbstractModel):
    r"""智能封面任务控制参数

    """

    def __init__(self):
        r"""
        :param _Switch: 智能封面任务开关，可选值：
<li>ON：开启智能封面任务；</li>
<li>OFF：关闭智能封面任务。</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        r"""智能封面任务开关，可选值：
<li>ON：开启智能封面任务；</li>
<li>OFF：关闭智能封面任务。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CoverConfigureInfoForUpdate(AbstractModel):
    r"""智能封面任务控制参数

    """

    def __init__(self):
        r"""
        :param _Switch: 智能封面任务开关，可选值：
<li>ON：开启智能封面任务；</li>
<li>OFF：关闭智能封面任务。</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        r"""智能封面任务开关，可选值：
<li>ON：开启智能封面任务；</li>
<li>OFF：关闭智能封面任务。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CrashScreenConfigureInfo(AbstractModel):
    r"""视频画面花屏检测的控制参数。

    """

    def __init__(self):
        r"""
        :param _Switch: 视频画面花屏检测开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        r"""视频画面花屏检测开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CrashScreenConfigureInfoForUpdate(AbstractModel):
    r"""视频画面花屏检测的控制参数。

    """

    def __init__(self):
        r"""
        :param _Switch: 视频画面花屏检测开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        r"""视频画面花屏检测开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAIAnalysisTemplateRequest(AbstractModel):
    r"""CreateAIAnalysisTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Name: 音视频内容分析模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Comment: 音视频内容分析模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _ClassificationConfigure: 智能分类任务控制参数。
        :type ClassificationConfigure: :class:`tencentcloud.vod.v20180717.models.ClassificationConfigureInfo`
        :param _TagConfigure: 智能标签任务控制参数。
        :type TagConfigure: :class:`tencentcloud.vod.v20180717.models.TagConfigureInfo`
        :param _CoverConfigure: 智能封面任务控制参数。
        :type CoverConfigure: :class:`tencentcloud.vod.v20180717.models.CoverConfigureInfo`
        :param _FrameTagConfigure: 智能按帧标签任务控制参数。
        :type FrameTagConfigure: :class:`tencentcloud.vod.v20180717.models.FrameTagConfigureInfo`
        :param _HighlightConfigure: 智能精彩集锦任务控制参数。
        :type HighlightConfigure: :class:`tencentcloud.vod.v20180717.models.HighlightsConfigureInfo`
        """
        self._SubAppId = None
        self._Name = None
        self._Comment = None
        self._ClassificationConfigure = None
        self._TagConfigure = None
        self._CoverConfigure = None
        self._FrameTagConfigure = None
        self._HighlightConfigure = None

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Name(self):
        r"""音视频内容分析模板名称，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        r"""音视频内容分析模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def ClassificationConfigure(self):
        r"""智能分类任务控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ClassificationConfigureInfo`
        """
        return self._ClassificationConfigure

    @ClassificationConfigure.setter
    def ClassificationConfigure(self, ClassificationConfigure):
        self._ClassificationConfigure = ClassificationConfigure

    @property
    def TagConfigure(self):
        r"""智能标签任务控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.TagConfigureInfo`
        """
        return self._TagConfigure

    @TagConfigure.setter
    def TagConfigure(self, TagConfigure):
        self._TagConfigure = TagConfigure

    @property
    def CoverConfigure(self):
        r"""智能封面任务控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.CoverConfigureInfo`
        """
        return self._CoverConfigure

    @CoverConfigure.setter
    def CoverConfigure(self, CoverConfigure):
        self._CoverConfigure = CoverConfigure

    @property
    def FrameTagConfigure(self):
        r"""智能按帧标签任务控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.FrameTagConfigureInfo`
        """
        return self._FrameTagConfigure

    @FrameTagConfigure.setter
    def FrameTagConfigure(self, FrameTagConfigure):
        self._FrameTagConfigure = FrameTagConfigure

    @property
    def HighlightConfigure(self):
        r"""智能精彩集锦任务控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.HighlightsConfigureInfo`
        """
        return self._HighlightConfigure

    @HighlightConfigure.setter
    def HighlightConfigure(self, HighlightConfigure):
        self._HighlightConfigure = HighlightConfigure


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("ClassificationConfigure") is not None:
            self._ClassificationConfigure = ClassificationConfigureInfo()
            self._ClassificationConfigure._deserialize(params.get("ClassificationConfigure"))
        if params.get("TagConfigure") is not None:
            self._TagConfigure = TagConfigureInfo()
            self._TagConfigure._deserialize(params.get("TagConfigure"))
        if params.get("CoverConfigure") is not None:
            self._CoverConfigure = CoverConfigureInfo()
            self._CoverConfigure._deserialize(params.get("CoverConfigure"))
        if params.get("FrameTagConfigure") is not None:
            self._FrameTagConfigure = FrameTagConfigureInfo()
            self._FrameTagConfigure._deserialize(params.get("FrameTagConfigure"))
        if params.get("HighlightConfigure") is not None:
            self._HighlightConfigure = HighlightsConfigureInfo()
            self._HighlightConfigure._deserialize(params.get("HighlightConfigure"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAIAnalysisTemplateResponse(AbstractModel):
    r"""CreateAIAnalysisTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 音视频内容分析模板唯一标识。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""音视频内容分析模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateAIRecognitionTemplateRequest(AbstractModel):
    r"""CreateAIRecognitionTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Name: 音视频内容识别模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Comment: 音视频内容识别模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _HeadTailConfigure: 视频片头片尾识别控制参数。
        :type HeadTailConfigure: :class:`tencentcloud.vod.v20180717.models.HeadTailConfigureInfo`
        :param _SegmentConfigure: 视频拆条识别控制参数。
        :type SegmentConfigure: :class:`tencentcloud.vod.v20180717.models.SegmentConfigureInfo`
        :param _FaceConfigure: 人脸识别控制参数。
        :type FaceConfigure: :class:`tencentcloud.vod.v20180717.models.FaceConfigureInfo`
        :param _OcrFullTextConfigure: 文本全文识别控制参数。
        :type OcrFullTextConfigure: :class:`tencentcloud.vod.v20180717.models.OcrFullTextConfigureInfo`
        :param _OcrWordsConfigure: 文本关键词识别控制参数。
        :type OcrWordsConfigure: :class:`tencentcloud.vod.v20180717.models.OcrWordsConfigureInfo`
        :param _AsrFullTextConfigure: 语音全文识别控制参数。
<font color=red>注意：本参数已不再维护，推荐使用 AsrTranslateConfigure 参数发起语音翻译识别（当 DstLanguage 不填或填空字符串时，则不进行翻译，计费项和语音全文识别一致）。</font> 
        :type AsrFullTextConfigure: :class:`tencentcloud.vod.v20180717.models.AsrFullTextConfigureInfo`
        :param _AsrWordsConfigure: 语音关键词识别控制参数。
        :type AsrWordsConfigure: :class:`tencentcloud.vod.v20180717.models.AsrWordsConfigureInfo`
        :param _AsrTranslateConfigure: 语音翻译识别控制参数。
        :type AsrTranslateConfigure: :class:`tencentcloud.vod.v20180717.models.AsrTranslateConfigureInfo`
        :param _ObjectConfigure: 物体识别控制参数。
        :type ObjectConfigure: :class:`tencentcloud.vod.v20180717.models.ObjectConfigureInfo`
        :param _ScreenshotInterval: 截帧间隔，单位为秒。当不填时，默认截帧间隔为 1 秒，最小值为 0.5 秒。
        :type ScreenshotInterval: float
        """
        self._SubAppId = None
        self._Name = None
        self._Comment = None
        self._HeadTailConfigure = None
        self._SegmentConfigure = None
        self._FaceConfigure = None
        self._OcrFullTextConfigure = None
        self._OcrWordsConfigure = None
        self._AsrFullTextConfigure = None
        self._AsrWordsConfigure = None
        self._AsrTranslateConfigure = None
        self._ObjectConfigure = None
        self._ScreenshotInterval = None

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Name(self):
        r"""音视频内容识别模板名称，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        r"""音视频内容识别模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def HeadTailConfigure(self):
        r"""视频片头片尾识别控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.HeadTailConfigureInfo`
        """
        return self._HeadTailConfigure

    @HeadTailConfigure.setter
    def HeadTailConfigure(self, HeadTailConfigure):
        self._HeadTailConfigure = HeadTailConfigure

    @property
    def SegmentConfigure(self):
        r"""视频拆条识别控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.SegmentConfigureInfo`
        """
        return self._SegmentConfigure

    @SegmentConfigure.setter
    def SegmentConfigure(self, SegmentConfigure):
        self._SegmentConfigure = SegmentConfigure

    @property
    def FaceConfigure(self):
        r"""人脸识别控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.FaceConfigureInfo`
        """
        return self._FaceConfigure

    @FaceConfigure.setter
    def FaceConfigure(self, FaceConfigure):
        self._FaceConfigure = FaceConfigure

    @property
    def OcrFullTextConfigure(self):
        r"""文本全文识别控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.OcrFullTextConfigureInfo`
        """
        return self._OcrFullTextConfigure

    @OcrFullTextConfigure.setter
    def OcrFullTextConfigure(self, OcrFullTextConfigure):
        self._OcrFullTextConfigure = OcrFullTextConfigure

    @property
    def OcrWordsConfigure(self):
        r"""文本关键词识别控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.OcrWordsConfigureInfo`
        """
        return self._OcrWordsConfigure

    @OcrWordsConfigure.setter
    def OcrWordsConfigure(self, OcrWordsConfigure):
        self._OcrWordsConfigure = OcrWordsConfigure

    @property
    def AsrFullTextConfigure(self):
        r"""语音全文识别控制参数。
<font color=red>注意：本参数已不再维护，推荐使用 AsrTranslateConfigure 参数发起语音翻译识别（当 DstLanguage 不填或填空字符串时，则不进行翻译，计费项和语音全文识别一致）。</font> 
        :rtype: :class:`tencentcloud.vod.v20180717.models.AsrFullTextConfigureInfo`
        """
        return self._AsrFullTextConfigure

    @AsrFullTextConfigure.setter
    def AsrFullTextConfigure(self, AsrFullTextConfigure):
        self._AsrFullTextConfigure = AsrFullTextConfigure

    @property
    def AsrWordsConfigure(self):
        r"""语音关键词识别控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AsrWordsConfigureInfo`
        """
        return self._AsrWordsConfigure

    @AsrWordsConfigure.setter
    def AsrWordsConfigure(self, AsrWordsConfigure):
        self._AsrWordsConfigure = AsrWordsConfigure

    @property
    def AsrTranslateConfigure(self):
        r"""语音翻译识别控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AsrTranslateConfigureInfo`
        """
        return self._AsrTranslateConfigure

    @AsrTranslateConfigure.setter
    def AsrTranslateConfigure(self, AsrTranslateConfigure):
        self._AsrTranslateConfigure = AsrTranslateConfigure

    @property
    def ObjectConfigure(self):
        r"""物体识别控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ObjectConfigureInfo`
        """
        return self._ObjectConfigure

    @ObjectConfigure.setter
    def ObjectConfigure(self, ObjectConfigure):
        self._ObjectConfigure = ObjectConfigure

    @property
    def ScreenshotInterval(self):
        r"""截帧间隔，单位为秒。当不填时，默认截帧间隔为 1 秒，最小值为 0.5 秒。
        :rtype: float
        """
        return self._ScreenshotInterval

    @ScreenshotInterval.setter
    def ScreenshotInterval(self, ScreenshotInterval):
        self._ScreenshotInterval = ScreenshotInterval


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("HeadTailConfigure") is not None:
            self._HeadTailConfigure = HeadTailConfigureInfo()
            self._HeadTailConfigure._deserialize(params.get("HeadTailConfigure"))
        if params.get("SegmentConfigure") is not None:
            self._SegmentConfigure = SegmentConfigureInfo()
            self._SegmentConfigure._deserialize(params.get("SegmentConfigure"))
        if params.get("FaceConfigure") is not None:
            self._FaceConfigure = FaceConfigureInfo()
            self._FaceConfigure._deserialize(params.get("FaceConfigure"))
        if params.get("OcrFullTextConfigure") is not None:
            self._OcrFullTextConfigure = OcrFullTextConfigureInfo()
            self._OcrFullTextConfigure._deserialize(params.get("OcrFullTextConfigure"))
        if params.get("OcrWordsConfigure") is not None:
            self._OcrWordsConfigure = OcrWordsConfigureInfo()
            self._OcrWordsConfigure._deserialize(params.get("OcrWordsConfigure"))
        if params.get("AsrFullTextConfigure") is not None:
            self._AsrFullTextConfigure = AsrFullTextConfigureInfo()
            self._AsrFullTextConfigure._deserialize(params.get("AsrFullTextConfigure"))
        if params.get("AsrWordsConfigure") is not None:
            self._AsrWordsConfigure = AsrWordsConfigureInfo()
            self._AsrWordsConfigure._deserialize(params.get("AsrWordsConfigure"))
        if params.get("AsrTranslateConfigure") is not None:
            self._AsrTranslateConfigure = AsrTranslateConfigureInfo()
            self._AsrTranslateConfigure._deserialize(params.get("AsrTranslateConfigure"))
        if params.get("ObjectConfigure") is not None:
            self._ObjectConfigure = ObjectConfigureInfo()
            self._ObjectConfigure._deserialize(params.get("ObjectConfigure"))
        self._ScreenshotInterval = params.get("ScreenshotInterval")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAIRecognitionTemplateResponse(AbstractModel):
    r"""CreateAIRecognitionTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 音视频内容识别模板唯一标识。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""音视频内容识别模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateAdaptiveDynamicStreamingTemplateRequest(AbstractModel):
    r"""CreateAdaptiveDynamicStreamingTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Format: 自适应转码格式，取值范围：
<li>HLS；</li>
<li>MPEG-DASH。</li>
        :type Format: str
        :param _StreamInfos: 自适应转码输出子流参数信息，最多输出10路子流。
注意：各个子流的帧率必须保持一致；如果不一致，采用第一个子流的帧率作为输出帧率。
        :type StreamInfos: list of AdaptiveStreamTemplate
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Name: 模板名称，长度限制：64 个字符。
        :type Name: str
        :param _DrmType: DRM 方案类型，取值范围：
<li>SimpleAES</li>
<li>Widevine</li>
<li>FairPlay</li>
默认值为空字符串，如果取值为空字符串，代表不对视频做 DRM 保护。
        :type DrmType: str
        :param _DrmKeyProvider: DRM 的密钥提供商，取值范围：
<li>SDMC：华曦达；</li>
<li>VOD：云点播。</li>
默认为 VOD 。
        :type DrmKeyProvider: str
        :param _DisableHigherVideoBitrate: 是否禁止视频低码率转高码率，取值范围：
<li>0：否，</li>
<li>1：是。</li>
默认为否。
        :type DisableHigherVideoBitrate: int
        :param _DisableHigherVideoResolution: 是否禁止视频分辨率转高分辨率，取值范围：
<li>0：否，</li>
<li>1：是。</li>
默认为否。
        :type DisableHigherVideoResolution: int
        :param _Comment: 模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _SegmentType: 切片类型，当 Format 为 HLS 时有效，可选值：
<li>ts：ts 切片；</li>
<li>fmp4：fmp4 切片。</li>
默认值：ts。
        :type SegmentType: str
        """
        self._Format = None
        self._StreamInfos = None
        self._SubAppId = None
        self._Name = None
        self._DrmType = None
        self._DrmKeyProvider = None
        self._DisableHigherVideoBitrate = None
        self._DisableHigherVideoResolution = None
        self._Comment = None
        self._SegmentType = None

    @property
    def Format(self):
        r"""自适应转码格式，取值范围：
<li>HLS；</li>
<li>MPEG-DASH。</li>
        :rtype: str
        """
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def StreamInfos(self):
        r"""自适应转码输出子流参数信息，最多输出10路子流。
注意：各个子流的帧率必须保持一致；如果不一致，采用第一个子流的帧率作为输出帧率。
        :rtype: list of AdaptiveStreamTemplate
        """
        return self._StreamInfos

    @StreamInfos.setter
    def StreamInfos(self, StreamInfos):
        self._StreamInfos = StreamInfos

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Name(self):
        r"""模板名称，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def DrmType(self):
        r"""DRM 方案类型，取值范围：
<li>SimpleAES</li>
<li>Widevine</li>
<li>FairPlay</li>
默认值为空字符串，如果取值为空字符串，代表不对视频做 DRM 保护。
        :rtype: str
        """
        return self._DrmType

    @DrmType.setter
    def DrmType(self, DrmType):
        self._DrmType = DrmType

    @property
    def DrmKeyProvider(self):
        r"""DRM 的密钥提供商，取值范围：
<li>SDMC：华曦达；</li>
<li>VOD：云点播。</li>
默认为 VOD 。
        :rtype: str
        """
        return self._DrmKeyProvider

    @DrmKeyProvider.setter
    def DrmKeyProvider(self, DrmKeyProvider):
        self._DrmKeyProvider = DrmKeyProvider

    @property
    def DisableHigherVideoBitrate(self):
        r"""是否禁止视频低码率转高码率，取值范围：
<li>0：否，</li>
<li>1：是。</li>
默认为否。
        :rtype: int
        """
        return self._DisableHigherVideoBitrate

    @DisableHigherVideoBitrate.setter
    def DisableHigherVideoBitrate(self, DisableHigherVideoBitrate):
        self._DisableHigherVideoBitrate = DisableHigherVideoBitrate

    @property
    def DisableHigherVideoResolution(self):
        r"""是否禁止视频分辨率转高分辨率，取值范围：
<li>0：否，</li>
<li>1：是。</li>
默认为否。
        :rtype: int
        """
        return self._DisableHigherVideoResolution

    @DisableHigherVideoResolution.setter
    def DisableHigherVideoResolution(self, DisableHigherVideoResolution):
        self._DisableHigherVideoResolution = DisableHigherVideoResolution

    @property
    def Comment(self):
        r"""模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def SegmentType(self):
        r"""切片类型，当 Format 为 HLS 时有效，可选值：
<li>ts：ts 切片；</li>
<li>fmp4：fmp4 切片。</li>
默认值：ts。
        :rtype: str
        """
        return self._SegmentType

    @SegmentType.setter
    def SegmentType(self, SegmentType):
        self._SegmentType = SegmentType


    def _deserialize(self, params):
        self._Format = params.get("Format")
        if params.get("StreamInfos") is not None:
            self._StreamInfos = []
            for item in params.get("StreamInfos"):
                obj = AdaptiveStreamTemplate()
                obj._deserialize(item)
                self._StreamInfos.append(obj)
        self._SubAppId = params.get("SubAppId")
        self._Name = params.get("Name")
        self._DrmType = params.get("DrmType")
        self._DrmKeyProvider = params.get("DrmKeyProvider")
        self._DisableHigherVideoBitrate = params.get("DisableHigherVideoBitrate")
        self._DisableHigherVideoResolution = params.get("DisableHigherVideoResolution")
        self._Comment = params.get("Comment")
        self._SegmentType = params.get("SegmentType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAdaptiveDynamicStreamingTemplateResponse(AbstractModel):
    r"""CreateAdaptiveDynamicStreamingTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 自适应转码模板唯一标识。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""自适应转码模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateAigcImageTaskRequest(AbstractModel):
    r"""CreateAigcImageTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _ModelName: 模型名称。取值：
<li>GEM：Gemini；</li>
<li>Qwen：千问。</li>
<li>Hunyuan：混元。</li>
        :type ModelName: str
        :param _ModelVersion: 模型版本。取值：
<li>当 ModelName 是 GEM，可选值为 2.5、3.0；</li>
<li>当 ModelName 是 Qwen，可选值为 0925；</li>
<li>当 ModelName 是 Hunyuan，可选值为 3.0；</li>
        :type ModelVersion: str
        :param _FileInfos: AIGC 生图任务的输入图片的文件信息。默认只支持指定1个，使用模型 GEM 时，版本2.5最多指定3个，版本3.0最多指定14个。
        :type FileInfos: list of AigcImageTaskInputFileInfo
        :param _Prompt: 生成图片的提示词。当 FileInfos 为空时，此参数必填。
        :type Prompt: str
        :param _NegativePrompt: 要阻止模型生成图片的提示词。
        :type NegativePrompt: str
        :param _EnhancePrompt: 是否自动优化提示词。开启时将自动优化传入的 Prompt，以提升生成质量。取值有： <li>Enabled：开启；</li> <li>Disabled：关闭；</li> 
        :type EnhancePrompt: str
        :param _OutputConfig: 生图任务的输出媒体文件配置。
        :type OutputConfig: :class:`tencentcloud.vod.v20180717.models.AigcImageOutputConfig`
        :param _SessionId: 用于去重的识别码，如果三天内曾有过相同的识别码的请求，则本次的请求会返回错误。最长 50 个字符，不带或者带空字符串表示不做去重。
        :type SessionId: str
        :param _SessionContext: 来源上下文，用于透传用户请求信息，音画质重生完成回调将返回该字段值，最长 1000 个字符。
        :type SessionContext: str
        :param _TasksPriority: 任务的优先级，数值越大优先级越高，取值范围是 -10 到 10，不填代表 0。
        :type TasksPriority: int
        :param _ExtInfo: 保留字段，特殊用途时使用。
        :type ExtInfo: str
        """
        self._SubAppId = None
        self._ModelName = None
        self._ModelVersion = None
        self._FileInfos = None
        self._Prompt = None
        self._NegativePrompt = None
        self._EnhancePrompt = None
        self._OutputConfig = None
        self._SessionId = None
        self._SessionContext = None
        self._TasksPriority = None
        self._ExtInfo = None

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def ModelName(self):
        r"""模型名称。取值：
<li>GEM：Gemini；</li>
<li>Qwen：千问。</li>
<li>Hunyuan：混元。</li>
        :rtype: str
        """
        return self._ModelName

    @ModelName.setter
    def ModelName(self, ModelName):
        self._ModelName = ModelName

    @property
    def ModelVersion(self):
        r"""模型版本。取值：
<li>当 ModelName 是 GEM，可选值为 2.5、3.0；</li>
<li>当 ModelName 是 Qwen，可选值为 0925；</li>
<li>当 ModelName 是 Hunyuan，可选值为 3.0；</li>
        :rtype: str
        """
        return self._ModelVersion

    @ModelVersion.setter
    def ModelVersion(self, ModelVersion):
        self._ModelVersion = ModelVersion

    @property
    def FileInfos(self):
        r"""AIGC 生图任务的输入图片的文件信息。默认只支持指定1个，使用模型 GEM 时，版本2.5最多指定3个，版本3.0最多指定14个。
        :rtype: list of AigcImageTaskInputFileInfo
        """
        return self._FileInfos

    @FileInfos.setter
    def FileInfos(self, FileInfos):
        self._FileInfos = FileInfos

    @property
    def Prompt(self):
        r"""生成图片的提示词。当 FileInfos 为空时，此参数必填。
        :rtype: str
        """
        return self._Prompt

    @Prompt.setter
    def Prompt(self, Prompt):
        self._Prompt = Prompt

    @property
    def NegativePrompt(self):
        r"""要阻止模型生成图片的提示词。
        :rtype: str
        """
        return self._NegativePrompt

    @NegativePrompt.setter
    def NegativePrompt(self, NegativePrompt):
        self._NegativePrompt = NegativePrompt

    @property
    def EnhancePrompt(self):
        r"""是否自动优化提示词。开启时将自动优化传入的 Prompt，以提升生成质量。取值有： <li>Enabled：开启；</li> <li>Disabled：关闭；</li> 
        :rtype: str
        """
        return self._EnhancePrompt

    @EnhancePrompt.setter
    def EnhancePrompt(self, EnhancePrompt):
        self._EnhancePrompt = EnhancePrompt

    @property
    def OutputConfig(self):
        r"""生图任务的输出媒体文件配置。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AigcImageOutputConfig`
        """
        return self._OutputConfig

    @OutputConfig.setter
    def OutputConfig(self, OutputConfig):
        self._OutputConfig = OutputConfig

    @property
    def SessionId(self):
        r"""用于去重的识别码，如果三天内曾有过相同的识别码的请求，则本次的请求会返回错误。最长 50 个字符，不带或者带空字符串表示不做去重。
        :rtype: str
        """
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def SessionContext(self):
        r"""来源上下文，用于透传用户请求信息，音画质重生完成回调将返回该字段值，最长 1000 个字符。
        :rtype: str
        """
        return self._SessionContext

    @SessionContext.setter
    def SessionContext(self, SessionContext):
        self._SessionContext = SessionContext

    @property
    def TasksPriority(self):
        r"""任务的优先级，数值越大优先级越高，取值范围是 -10 到 10，不填代表 0。
        :rtype: int
        """
        return self._TasksPriority

    @TasksPriority.setter
    def TasksPriority(self, TasksPriority):
        self._TasksPriority = TasksPriority

    @property
    def ExtInfo(self):
        r"""保留字段，特殊用途时使用。
        :rtype: str
        """
        return self._ExtInfo

    @ExtInfo.setter
    def ExtInfo(self, ExtInfo):
        self._ExtInfo = ExtInfo


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._ModelName = params.get("ModelName")
        self._ModelVersion = params.get("ModelVersion")
        if params.get("FileInfos") is not None:
            self._FileInfos = []
            for item in params.get("FileInfos"):
                obj = AigcImageTaskInputFileInfo()
                obj._deserialize(item)
                self._FileInfos.append(obj)
        self._Prompt = params.get("Prompt")
        self._NegativePrompt = params.get("NegativePrompt")
        self._EnhancePrompt = params.get("EnhancePrompt")
        if params.get("OutputConfig") is not None:
            self._OutputConfig = AigcImageOutputConfig()
            self._OutputConfig._deserialize(params.get("OutputConfig"))
        self._SessionId = params.get("SessionId")
        self._SessionContext = params.get("SessionContext")
        self._TasksPriority = params.get("TasksPriority")
        self._ExtInfo = params.get("ExtInfo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAigcImageTaskResponse(AbstractModel):
    r"""CreateAigcImageTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务 ID。
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        r"""任务 ID。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class CreateAigcVideoTaskRequest(AbstractModel):
    r"""CreateAigcVideoTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _ModelName: 模型名称。取值：<li>Hailuo：海螺；</li><li>Kling：可灵；</li><li> Jimeng：即梦；</li><li>Vidu；</li><li>Hunyuan：混元；</li><li>Mingmou：明眸；</li>
        :type ModelName: str
        :param _ModelVersion: 模型版本。取值：<li>当 ModelName 是 Hailuo，可选值为 02、2.3、2.3-fast；</li><li>当 ModelName 是 Kling，可选值为 1.6、2.0、2.1、2.5、O1；</li><li>当 ModelName 是 Jimeng，可选值为 3.0pro；</li><li>当 ModelName 是 Vidu，可选值为 q2、q2-pro、q2-turbo；</li><li>当 ModelName 是 GV，可选值为 3.1、3.1-Fast；</li><li>当 ModelName 是 OS，可选值为 2.0；</li><li>当 ModelName 是 Hunyuan，可选值为 1.5；</li><li>当 ModelName 是 Mingmou，可选值为 1.0；</li>
        :type ModelVersion: str
        :param _FileInfos: 最多包含三张素材资源图片的列表，用于描述模型在生成视频时要使用的资源图片。

首尾帧视频生成：用FileInfos第一张表示首帧（此时FileInfos最多包含一张图片），LastFrameFileId或者LastFrameUrl表示尾帧。

支持多图输入的模型：
1. GV，使用多图输入时，不可使用LastFrameFileId和LastFrameUrl。
2. Vidu，支持多图参考生视频。q2模型1-7张图片，可通过FileInfos里面的ObjectId作为主体id来传入。

注意：
1. 图片大小不超过10M。
2. 支持的图片格式：jpeg、png。
        :type FileInfos: list of AigcVideoTaskInputFileInfo
        :param _LastFrameFileId: 用于作为尾帧画面来生成视频的媒体文件 ID。该文件在云点播上的全局唯一标识符，在上传成功后由云点播后台分配。可以在 [视频上传完成事件通知](/document/product/266/7830) 或 [云点播控制台](https://console.cloud.tencent.com/vod/media) 获取该字段。说明：
1. 只支持模型 GV 、Kling、Vidu，其他模型暂不支持。当 ModelName 为 GV 时，如果指定该参数，则需同时指定 FileInfos 作为待生成视频的首帧。当 ModelName 为 Kling 、ModelVersion 为 2.1 并且指定输出分辨率 Resolution 为 1080P 时，才能指定该参数。当 ModelName 为 Vidu、ModelVersion 为 q2-pro、q2-turbo 时，才能指定该参数。
2. 图片大小需小于5M。
3. 图片格式的取值为：jpeg，jpg, png, webp。
        :type LastFrameFileId: str
        :param _LastFrameUrl: 用于作为尾帧画面来生成视频的媒体文件 URL。说明：
1. 只支持模型 GV 、Kling、Vidu，其他模型暂不支持。当 ModelName 为 GV 时，如果指定该参数，则需同时指定 FileInfos 作为待生成视频的首帧。当 ModelName 为 Kling 、ModelVersion 为 2.1 并且指定输出分辨率 Resolution 为 1080P 时，才能指定该参数。当 ModelName 为 Vidu、ModelVersion 为 q2-pro、q2-turbo 时，才能指定该参数。
2. 图片大小需小于5M。
3. 3. 图片格式的取值为：jpeg，jpg, png, webp。
        :type LastFrameUrl: str
        :param _Prompt: 生成视频的提示词。当 FileInfos 为空时，此参数必填。
示例值：move the picture
        :type Prompt: str
        :param _NegativePrompt: 要阻止模型生成视频的提示词。
        :type NegativePrompt: str
        :param _EnhancePrompt: 是否自动优化提示词。开启时将自动优化传入的 Prompt，以提升生成质量。取值有： <li>Enabled：开启；</li> <li>Disabled：关闭；</li> 
        :type EnhancePrompt: str
        :param _OutputConfig: 生视频任务的输出媒体文件配置。
        :type OutputConfig: :class:`tencentcloud.vod.v20180717.models.AigcVideoOutputConfig`
        :param _SessionId: 用于去重的识别码，如果三天内曾有过相同的识别码的请求，则本次的请求会返回错误。最长 50 个字符，不带或者带空字符串表示不做去重。
        :type SessionId: str
        :param _SessionContext: 来源上下文，用于透传用户请求信息，音画质重生完成回调将返回该字段值，最长 1000 个字符。
        :type SessionContext: str
        :param _TasksPriority: 任务的优先级，数值越大优先级越高，取值范围是 -10 到 10，不填代表 0。
        :type TasksPriority: int
        :param _ExtInfo: 保留字段，特殊用途时使用。
        :type ExtInfo: str
        :param _InputRegion: 输入图片的区域信息。当图片url是国外地址时候，可选Oversea。默认Mainland。
        :type InputRegion: str
        """
        self._SubAppId = None
        self._ModelName = None
        self._ModelVersion = None
        self._FileInfos = None
        self._LastFrameFileId = None
        self._LastFrameUrl = None
        self._Prompt = None
        self._NegativePrompt = None
        self._EnhancePrompt = None
        self._OutputConfig = None
        self._SessionId = None
        self._SessionContext = None
        self._TasksPriority = None
        self._ExtInfo = None
        self._InputRegion = None

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def ModelName(self):
        r"""模型名称。取值：<li>Hailuo：海螺；</li><li>Kling：可灵；</li><li> Jimeng：即梦；</li><li>Vidu；</li><li>Hunyuan：混元；</li><li>Mingmou：明眸；</li>
        :rtype: str
        """
        return self._ModelName

    @ModelName.setter
    def ModelName(self, ModelName):
        self._ModelName = ModelName

    @property
    def ModelVersion(self):
        r"""模型版本。取值：<li>当 ModelName 是 Hailuo，可选值为 02、2.3、2.3-fast；</li><li>当 ModelName 是 Kling，可选值为 1.6、2.0、2.1、2.5、O1；</li><li>当 ModelName 是 Jimeng，可选值为 3.0pro；</li><li>当 ModelName 是 Vidu，可选值为 q2、q2-pro、q2-turbo；</li><li>当 ModelName 是 GV，可选值为 3.1、3.1-Fast；</li><li>当 ModelName 是 OS，可选值为 2.0；</li><li>当 ModelName 是 Hunyuan，可选值为 1.5；</li><li>当 ModelName 是 Mingmou，可选值为 1.0；</li>
        :rtype: str
        """
        return self._ModelVersion

    @ModelVersion.setter
    def ModelVersion(self, ModelVersion):
        self._ModelVersion = ModelVersion

    @property
    def FileInfos(self):
        r"""最多包含三张素材资源图片的列表，用于描述模型在生成视频时要使用的资源图片。

首尾帧视频生成：用FileInfos第一张表示首帧（此时FileInfos最多包含一张图片），LastFrameFileId或者LastFrameUrl表示尾帧。

支持多图输入的模型：
1. GV，使用多图输入时，不可使用LastFrameFileId和LastFrameUrl。
2. Vidu，支持多图参考生视频。q2模型1-7张图片，可通过FileInfos里面的ObjectId作为主体id来传入。

注意：
1. 图片大小不超过10M。
2. 支持的图片格式：jpeg、png。
        :rtype: list of AigcVideoTaskInputFileInfo
        """
        return self._FileInfos

    @FileInfos.setter
    def FileInfos(self, FileInfos):
        self._FileInfos = FileInfos

    @property
    def LastFrameFileId(self):
        r"""用于作为尾帧画面来生成视频的媒体文件 ID。该文件在云点播上的全局唯一标识符，在上传成功后由云点播后台分配。可以在 [视频上传完成事件通知](/document/product/266/7830) 或 [云点播控制台](https://console.cloud.tencent.com/vod/media) 获取该字段。说明：
1. 只支持模型 GV 、Kling、Vidu，其他模型暂不支持。当 ModelName 为 GV 时，如果指定该参数，则需同时指定 FileInfos 作为待生成视频的首帧。当 ModelName 为 Kling 、ModelVersion 为 2.1 并且指定输出分辨率 Resolution 为 1080P 时，才能指定该参数。当 ModelName 为 Vidu、ModelVersion 为 q2-pro、q2-turbo 时，才能指定该参数。
2. 图片大小需小于5M。
3. 图片格式的取值为：jpeg，jpg, png, webp。
        :rtype: str
        """
        return self._LastFrameFileId

    @LastFrameFileId.setter
    def LastFrameFileId(self, LastFrameFileId):
        self._LastFrameFileId = LastFrameFileId

    @property
    def LastFrameUrl(self):
        r"""用于作为尾帧画面来生成视频的媒体文件 URL。说明：
1. 只支持模型 GV 、Kling、Vidu，其他模型暂不支持。当 ModelName 为 GV 时，如果指定该参数，则需同时指定 FileInfos 作为待生成视频的首帧。当 ModelName 为 Kling 、ModelVersion 为 2.1 并且指定输出分辨率 Resolution 为 1080P 时，才能指定该参数。当 ModelName 为 Vidu、ModelVersion 为 q2-pro、q2-turbo 时，才能指定该参数。
2. 图片大小需小于5M。
3. 3. 图片格式的取值为：jpeg，jpg, png, webp。
        :rtype: str
        """
        return self._LastFrameUrl

    @LastFrameUrl.setter
    def LastFrameUrl(self, LastFrameUrl):
        self._LastFrameUrl = LastFrameUrl

    @property
    def Prompt(self):
        r"""生成视频的提示词。当 FileInfos 为空时，此参数必填。
示例值：move the picture
        :rtype: str
        """
        return self._Prompt

    @Prompt.setter
    def Prompt(self, Prompt):
        self._Prompt = Prompt

    @property
    def NegativePrompt(self):
        r"""要阻止模型生成视频的提示词。
        :rtype: str
        """
        return self._NegativePrompt

    @NegativePrompt.setter
    def NegativePrompt(self, NegativePrompt):
        self._NegativePrompt = NegativePrompt

    @property
    def EnhancePrompt(self):
        r"""是否自动优化提示词。开启时将自动优化传入的 Prompt，以提升生成质量。取值有： <li>Enabled：开启；</li> <li>Disabled：关闭；</li> 
        :rtype: str
        """
        return self._EnhancePrompt

    @EnhancePrompt.setter
    def EnhancePrompt(self, EnhancePrompt):
        self._EnhancePrompt = EnhancePrompt

    @property
    def OutputConfig(self):
        r"""生视频任务的输出媒体文件配置。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AigcVideoOutputConfig`
        """
        return self._OutputConfig

    @OutputConfig.setter
    def OutputConfig(self, OutputConfig):
        self._OutputConfig = OutputConfig

    @property
    def SessionId(self):
        r"""用于去重的识别码，如果三天内曾有过相同的识别码的请求，则本次的请求会返回错误。最长 50 个字符，不带或者带空字符串表示不做去重。
        :rtype: str
        """
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def SessionContext(self):
        r"""来源上下文，用于透传用户请求信息，音画质重生完成回调将返回该字段值，最长 1000 个字符。
        :rtype: str
        """
        return self._SessionContext

    @SessionContext.setter
    def SessionContext(self, SessionContext):
        self._SessionContext = SessionContext

    @property
    def TasksPriority(self):
        r"""任务的优先级，数值越大优先级越高，取值范围是 -10 到 10，不填代表 0。
        :rtype: int
        """
        return self._TasksPriority

    @TasksPriority.setter
    def TasksPriority(self, TasksPriority):
        self._TasksPriority = TasksPriority

    @property
    def ExtInfo(self):
        r"""保留字段，特殊用途时使用。
        :rtype: str
        """
        return self._ExtInfo

    @ExtInfo.setter
    def ExtInfo(self, ExtInfo):
        self._ExtInfo = ExtInfo

    @property
    def InputRegion(self):
        r"""输入图片的区域信息。当图片url是国外地址时候，可选Oversea。默认Mainland。
        :rtype: str
        """
        return self._InputRegion

    @InputRegion.setter
    def InputRegion(self, InputRegion):
        self._InputRegion = InputRegion


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._ModelName = params.get("ModelName")
        self._ModelVersion = params.get("ModelVersion")
        if params.get("FileInfos") is not None:
            self._FileInfos = []
            for item in params.get("FileInfos"):
                obj = AigcVideoTaskInputFileInfo()
                obj._deserialize(item)
                self._FileInfos.append(obj)
        self._LastFrameFileId = params.get("LastFrameFileId")
        self._LastFrameUrl = params.get("LastFrameUrl")
        self._Prompt = params.get("Prompt")
        self._NegativePrompt = params.get("NegativePrompt")
        self._EnhancePrompt = params.get("EnhancePrompt")
        if params.get("OutputConfig") is not None:
            self._OutputConfig = AigcVideoOutputConfig()
            self._OutputConfig._deserialize(params.get("OutputConfig"))
        self._SessionId = params.get("SessionId")
        self._SessionContext = params.get("SessionContext")
        self._TasksPriority = params.get("TasksPriority")
        self._ExtInfo = params.get("ExtInfo")
        self._InputRegion = params.get("InputRegion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAigcVideoTaskResponse(AbstractModel):
    r"""CreateAigcVideoTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务 ID。
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        r"""任务 ID。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class CreateAnimatedGraphicsTemplateRequest(AbstractModel):
    r"""CreateAnimatedGraphicsTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Fps: 帧率，取值范围：[1, 30]，单位：Hz。
        :type Fps: int
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Width: 动图宽度（或长边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Width: int
        :param _Height: 动图高度（或短边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Height: int
        :param _ResolutionAdaptive: 分辨率自适应，可选值：
<li>open：开启，此时，Width 代表视频的长边，Height 表示视频的短边；</li>
<li>close：关闭，此时，Width 代表视频的宽度，Height 表示视频的高度。</li>
默认值：open。
        :type ResolutionAdaptive: str
        :param _Format: 动图格式，取值为 gif 和 webp。默认为 gif。
        :type Format: str
        :param _Quality: 图片质量，取值范围：[1, 100]，默认值为 75。
        :type Quality: float
        :param _Name: 转动图模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Comment: 模板描述信息，长度限制：256 个字符。
        :type Comment: str
        """
        self._Fps = None
        self._SubAppId = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._Format = None
        self._Quality = None
        self._Name = None
        self._Comment = None

    @property
    def Fps(self):
        r"""帧率，取值范围：[1, 30]，单位：Hz。
        :rtype: int
        """
        return self._Fps

    @Fps.setter
    def Fps(self, Fps):
        self._Fps = Fps

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Width(self):
        r"""动图宽度（或长边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :rtype: int
        """
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        r"""动图高度（或短边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :rtype: int
        """
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        r"""分辨率自适应，可选值：
<li>open：开启，此时，Width 代表视频的长边，Height 表示视频的短边；</li>
<li>close：关闭，此时，Width 代表视频的宽度，Height 表示视频的高度。</li>
默认值：open。
        :rtype: str
        """
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def Format(self):
        r"""动图格式，取值为 gif 和 webp。默认为 gif。
        :rtype: str
        """
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def Quality(self):
        r"""图片质量，取值范围：[1, 100]，默认值为 75。
        :rtype: float
        """
        return self._Quality

    @Quality.setter
    def Quality(self, Quality):
        self._Quality = Quality

    @property
    def Name(self):
        r"""转动图模板名称，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        r"""模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment


    def _deserialize(self, params):
        self._Fps = params.get("Fps")
        self._SubAppId = params.get("SubAppId")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._Format = params.get("Format")
        self._Quality = params.get("Quality")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAnimatedGraphicsTemplateResponse(AbstractModel):
    r"""CreateAnimatedGraphicsTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 转动图模板唯一标识。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""转动图模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateCLSLogsetRequest(AbstractModel):
    r"""CreateCLSLogset请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CLSRegion: 日志集所属的地域，取值有： <li>ap-guangzhou：广州；</li> <li>ap-beijing：北京；</li> <li>ap-chengdu：成都；</li> <li>ap-chongqing：重庆；</li> <li>ap-nanjing：南京；</li> <li>ap-shanghai：上海；</li> <li>ap-singapore：新加坡。</li>
        :type CLSRegion: str
        """
        self._CLSRegion = None

    @property
    def CLSRegion(self):
        r"""日志集所属的地域，取值有： <li>ap-guangzhou：广州；</li> <li>ap-beijing：北京；</li> <li>ap-chengdu：成都；</li> <li>ap-chongqing：重庆；</li> <li>ap-nanjing：南京；</li> <li>ap-shanghai：上海；</li> <li>ap-singapore：新加坡。</li>
        :rtype: str
        """
        return self._CLSRegion

    @CLSRegion.setter
    def CLSRegion(self, CLSRegion):
        self._CLSRegion = CLSRegion


    def _deserialize(self, params):
        self._CLSRegion = params.get("CLSRegion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCLSLogsetResponse(AbstractModel):
    r"""CreateCLSLogset返回参数结构体

    """

    def __init__(self):
        r"""
        :param _LogsetId: 日志集 ID。
        :type LogsetId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._LogsetId = None
        self._RequestId = None

    @property
    def LogsetId(self):
        r"""日志集 ID。
        :rtype: str
        """
        return self._LogsetId

    @LogsetId.setter
    def LogsetId(self, LogsetId):
        self._LogsetId = LogsetId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._LogsetId = params.get("LogsetId")
        self._RequestId = params.get("RequestId")


class CreateCLSTopicRequest(AbstractModel):
    r"""CreateCLSTopic请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CLSRegion: 日志集所属的地域，取值有： <li>ap-guangzhou：广州；</li> <li>ap-beijing：北京；</li> <li>ap-chengdu：成都；</li> <li>ap-chongqing：重庆；</li> <li>ap-nanjing：南京；</li> <li>ap-shanghai：上海；</li> <li>ap-singapore：新加坡。</li>
        :type CLSRegion: str
        :param _TopicName: 日志主题名。
        :type TopicName: str
        :param _LogsetId: 日志集 ID。
        :type LogsetId: str
        """
        self._CLSRegion = None
        self._TopicName = None
        self._LogsetId = None

    @property
    def CLSRegion(self):
        r"""日志集所属的地域，取值有： <li>ap-guangzhou：广州；</li> <li>ap-beijing：北京；</li> <li>ap-chengdu：成都；</li> <li>ap-chongqing：重庆；</li> <li>ap-nanjing：南京；</li> <li>ap-shanghai：上海；</li> <li>ap-singapore：新加坡。</li>
        :rtype: str
        """
        return self._CLSRegion

    @CLSRegion.setter
    def CLSRegion(self, CLSRegion):
        self._CLSRegion = CLSRegion

    @property
    def TopicName(self):
        r"""日志主题名。
        :rtype: str
        """
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName

    @property
    def LogsetId(self):
        r"""日志集 ID。
        :rtype: str
        """
        return self._LogsetId

    @LogsetId.setter
    def LogsetId(self, LogsetId):
        self._LogsetId = LogsetId


    def _deserialize(self, params):
        self._CLSRegion = params.get("CLSRegion")
        self._TopicName = params.get("TopicName")
        self._LogsetId = params.get("LogsetId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCLSTopicResponse(AbstractModel):
    r"""CreateCLSTopic返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TopicId: 日志主题 ID。
        :type TopicId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TopicId = None
        self._RequestId = None

    @property
    def TopicId(self):
        r"""日志主题 ID。
        :rtype: str
        """
        return self._TopicId

    @TopicId.setter
    def TopicId(self, TopicId):
        self._TopicId = TopicId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TopicId = params.get("TopicId")
        self._RequestId = params.get("RequestId")


class CreateClassRequest(AbstractModel):
    r"""CreateClass请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ParentId: 父类 ID，一级分类填写 -1。
        :type ParentId: int
        :param _ClassName: 分类名称，长度限制：1-64 个字符。
        :type ClassName: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._ParentId = None
        self._ClassName = None
        self._SubAppId = None

    @property
    def ParentId(self):
        r"""父类 ID，一级分类填写 -1。
        :rtype: int
        """
        return self._ParentId

    @ParentId.setter
    def ParentId(self, ParentId):
        self._ParentId = ParentId

    @property
    def ClassName(self):
        r"""分类名称，长度限制：1-64 个字符。
        :rtype: str
        """
        return self._ClassName

    @ClassName.setter
    def ClassName(self, ClassName):
        self._ClassName = ClassName

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._ParentId = params.get("ParentId")
        self._ClassName = params.get("ClassName")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateClassResponse(AbstractModel):
    r"""CreateClass返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ClassId: 分类 ID
        :type ClassId: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ClassId = None
        self._RequestId = None

    @property
    def ClassId(self):
        r"""分类 ID
        :rtype: int
        """
        return self._ClassId

    @ClassId.setter
    def ClassId(self, ClassId):
        self._ClassId = ClassId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ClassId = params.get("ClassId")
        self._RequestId = params.get("RequestId")


class CreateComplexAdaptiveDynamicStreamingTaskRequest(AbstractModel):
    r"""CreateComplexAdaptiveDynamicStreamingTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。</b>
        :type SubAppId: int
        :param _FileId: 主媒体文件的媒体 ID。
        :type FileId: str
        :param _StreamParaSet: 自适应码流参数，最大支持8个。
        :type StreamParaSet: list of ComplexAdaptiveDynamicStreamingTaskStreamPara
        :param _HeadTailSet: 片头片尾列表，支持多片头片尾，最大可支持 4 个。如果填写了该字段，AudioSet 和 SubtitleSet 中指定的媒体的起始时间将会自动调整，和主媒体保持同步。
        :type HeadTailSet: list of HeadTailTaskInput
        :param _AudioSet: 多语言音频流参数，最大支持16个。每个数组元素对应自适应码流中的一条音频流。如果要将主媒体文件中的音频流添加到输出的自适应码流中，那么也需要在此处指定。数组中元素的顺序将决定自适应码流中的音频流顺序。如果输入的媒体文件同时带有视频流和音频流，那么视频流将被忽略。
        :type AudioSet: list of ComplexAdaptiveDynamicStreamingTaskAudioInput
        :param _SubtitleSet: 多语言字幕参数，最大可支持16个。每个数组元素对应自适应码流中的一条字幕流。数组中元素的顺序将决定自适应码流中的字幕流顺序。
        :type SubtitleSet: list of ComplexAdaptiveDynamicStreamingTaskSubtitleInput
        """
        self._SubAppId = None
        self._FileId = None
        self._StreamParaSet = None
        self._HeadTailSet = None
        self._AudioSet = None
        self._SubtitleSet = None

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def FileId(self):
        r"""主媒体文件的媒体 ID。
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def StreamParaSet(self):
        r"""自适应码流参数，最大支持8个。
        :rtype: list of ComplexAdaptiveDynamicStreamingTaskStreamPara
        """
        return self._StreamParaSet

    @StreamParaSet.setter
    def StreamParaSet(self, StreamParaSet):
        self._StreamParaSet = StreamParaSet

    @property
    def HeadTailSet(self):
        r"""片头片尾列表，支持多片头片尾，最大可支持 4 个。如果填写了该字段，AudioSet 和 SubtitleSet 中指定的媒体的起始时间将会自动调整，和主媒体保持同步。
        :rtype: list of HeadTailTaskInput
        """
        return self._HeadTailSet

    @HeadTailSet.setter
    def HeadTailSet(self, HeadTailSet):
        self._HeadTailSet = HeadTailSet

    @property
    def AudioSet(self):
        r"""多语言音频流参数，最大支持16个。每个数组元素对应自适应码流中的一条音频流。如果要将主媒体文件中的音频流添加到输出的自适应码流中，那么也需要在此处指定。数组中元素的顺序将决定自适应码流中的音频流顺序。如果输入的媒体文件同时带有视频流和音频流，那么视频流将被忽略。
        :rtype: list of ComplexAdaptiveDynamicStreamingTaskAudioInput
        """
        return self._AudioSet

    @AudioSet.setter
    def AudioSet(self, AudioSet):
        self._AudioSet = AudioSet

    @property
    def SubtitleSet(self):
        r"""多语言字幕参数，最大可支持16个。每个数组元素对应自适应码流中的一条字幕流。数组中元素的顺序将决定自适应码流中的字幕流顺序。
        :rtype: list of ComplexAdaptiveDynamicStreamingTaskSubtitleInput
        """
        return self._SubtitleSet

    @SubtitleSet.setter
    def SubtitleSet(self, SubtitleSet):
        self._SubtitleSet = SubtitleSet


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._FileId = params.get("FileId")
        if params.get("StreamParaSet") is not None:
            self._StreamParaSet = []
            for item in params.get("StreamParaSet"):
                obj = ComplexAdaptiveDynamicStreamingTaskStreamPara()
                obj._deserialize(item)
                self._StreamParaSet.append(obj)
        if params.get("HeadTailSet") is not None:
            self._HeadTailSet = []
            for item in params.get("HeadTailSet"):
                obj = HeadTailTaskInput()
                obj._deserialize(item)
                self._HeadTailSet.append(obj)
        if params.get("AudioSet") is not None:
            self._AudioSet = []
            for item in params.get("AudioSet"):
                obj = ComplexAdaptiveDynamicStreamingTaskAudioInput()
                obj._deserialize(item)
                self._AudioSet.append(obj)
        if params.get("SubtitleSet") is not None:
            self._SubtitleSet = []
            for item in params.get("SubtitleSet"):
                obj = ComplexAdaptiveDynamicStreamingTaskSubtitleInput()
                obj._deserialize(item)
                self._SubtitleSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateComplexAdaptiveDynamicStreamingTaskResponse(AbstractModel):
    r"""CreateComplexAdaptiveDynamicStreamingTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务 ID。
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        r"""任务 ID。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class CreateContentReviewTemplateRequest(AbstractModel):
    r"""CreateContentReviewTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ReviewWallSwitch: 音视频审核结果是否进入音视频审核墙（对识别结果进行人工复核）的开关。
<li>ON：是；</li>
<li>OFF：否。</li>
        :type ReviewWallSwitch: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Name: 内容审核模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Comment: 内容审核模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _PornConfigure: 令人反感的信息的控制参数。
        :type PornConfigure: :class:`tencentcloud.vod.v20180717.models.PornConfigureInfo`
        :param _TerrorismConfigure: 令人不安全的信息的控制参数。
        :type TerrorismConfigure: :class:`tencentcloud.vod.v20180717.models.TerrorismConfigureInfo`
        :param _PoliticalConfigure: 令人不适宜的控制参数。
        :type PoliticalConfigure: :class:`tencentcloud.vod.v20180717.models.PoliticalConfigureInfo`
        :param _ProhibitedConfigure: 违禁控制参数。违禁内容包括：
<li>谩骂；</li>
<li>涉毒违法。</li>
        :type ProhibitedConfigure: :class:`tencentcloud.vod.v20180717.models.ProhibitedConfigureInfo`
        :param _UserDefineConfigure: 用户自定义内容审核控制参数。
        :type UserDefineConfigure: :class:`tencentcloud.vod.v20180717.models.UserDefineConfigureInfo`
        :param _ScreenshotInterval: 截帧间隔，单位为秒。当不填时，默认截帧间隔为 1 秒，最小值为 0.5 秒。
        :type ScreenshotInterval: float
        """
        self._ReviewWallSwitch = None
        self._SubAppId = None
        self._Name = None
        self._Comment = None
        self._PornConfigure = None
        self._TerrorismConfigure = None
        self._PoliticalConfigure = None
        self._ProhibitedConfigure = None
        self._UserDefineConfigure = None
        self._ScreenshotInterval = None

    @property
    def ReviewWallSwitch(self):
        r"""音视频审核结果是否进入音视频审核墙（对识别结果进行人工复核）的开关。
<li>ON：是；</li>
<li>OFF：否。</li>
        :rtype: str
        """
        return self._ReviewWallSwitch

    @ReviewWallSwitch.setter
    def ReviewWallSwitch(self, ReviewWallSwitch):
        self._ReviewWallSwitch = ReviewWallSwitch

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Name(self):
        r"""内容审核模板名称，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        r"""内容审核模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def PornConfigure(self):
        r"""令人反感的信息的控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.PornConfigureInfo`
        """
        return self._PornConfigure

    @PornConfigure.setter
    def PornConfigure(self, PornConfigure):
        self._PornConfigure = PornConfigure

    @property
    def TerrorismConfigure(self):
        r"""令人不安全的信息的控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.TerrorismConfigureInfo`
        """
        return self._TerrorismConfigure

    @TerrorismConfigure.setter
    def TerrorismConfigure(self, TerrorismConfigure):
        self._TerrorismConfigure = TerrorismConfigure

    @property
    def PoliticalConfigure(self):
        r"""令人不适宜的控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.PoliticalConfigureInfo`
        """
        return self._PoliticalConfigure

    @PoliticalConfigure.setter
    def PoliticalConfigure(self, PoliticalConfigure):
        self._PoliticalConfigure = PoliticalConfigure

    @property
    def ProhibitedConfigure(self):
        r"""违禁控制参数。违禁内容包括：
<li>谩骂；</li>
<li>涉毒违法。</li>
        :rtype: :class:`tencentcloud.vod.v20180717.models.ProhibitedConfigureInfo`
        """
        return self._ProhibitedConfigure

    @ProhibitedConfigure.setter
    def ProhibitedConfigure(self, ProhibitedConfigure):
        self._ProhibitedConfigure = ProhibitedConfigure

    @property
    def UserDefineConfigure(self):
        r"""用户自定义内容审核控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.UserDefineConfigureInfo`
        """
        return self._UserDefineConfigure

    @UserDefineConfigure.setter
    def UserDefineConfigure(self, UserDefineConfigure):
        self._UserDefineConfigure = UserDefineConfigure

    @property
    def ScreenshotInterval(self):
        r"""截帧间隔，单位为秒。当不填时，默认截帧间隔为 1 秒，最小值为 0.5 秒。
        :rtype: float
        """
        return self._ScreenshotInterval

    @ScreenshotInterval.setter
    def ScreenshotInterval(self, ScreenshotInterval):
        self._ScreenshotInterval = ScreenshotInterval


    def _deserialize(self, params):
        self._ReviewWallSwitch = params.get("ReviewWallSwitch")
        self._SubAppId = params.get("SubAppId")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("PornConfigure") is not None:
            self._PornConfigure = PornConfigureInfo()
            self._PornConfigure._deserialize(params.get("PornConfigure"))
        if params.get("TerrorismConfigure") is not None:
            self._TerrorismConfigure = TerrorismConfigureInfo()
            self._TerrorismConfigure._deserialize(params.get("TerrorismConfigure"))
        if params.get("PoliticalConfigure") is not None:
            self._PoliticalConfigure = PoliticalConfigureInfo()
            self._PoliticalConfigure._deserialize(params.get("PoliticalConfigure"))
        if params.get("ProhibitedConfigure") is not None:
            self._ProhibitedConfigure = ProhibitedConfigureInfo()
            self._ProhibitedConfigure._deserialize(params.get("ProhibitedConfigure"))
        if params.get("UserDefineConfigure") is not None:
            self._UserDefineConfigure = UserDefineConfigureInfo()
            self._UserDefineConfigure._deserialize(params.get("UserDefineConfigure"))
        self._ScreenshotInterval = params.get("ScreenshotInterval")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateContentReviewTemplateResponse(AbstractModel):
    r"""CreateContentReviewTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 音视频内容审核模板唯一标识。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""音视频内容审核模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateDomainVerifyRecordRequest(AbstractModel):
    r"""CreateDomainVerifyRecord请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 需要接入点播的加速域名。
        :type Domain: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2024年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>	
        :type SubAppId: int
        """
        self._Domain = None
        self._SubAppId = None

    @property
    def Domain(self):
        r"""需要接入点播的加速域名。
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2024年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>	
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDomainVerifyRecordResponse(AbstractModel):
    r"""CreateDomainVerifyRecord返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DNSVerifyInfo: DNS解析信息
        :type DNSVerifyInfo: :class:`tencentcloud.vod.v20180717.models.DNSVerifyInfo`
        :param _FileVerifyInfo: 文件验证信息
        :type FileVerifyInfo: :class:`tencentcloud.vod.v20180717.models.FileVerifyInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DNSVerifyInfo = None
        self._FileVerifyInfo = None
        self._RequestId = None

    @property
    def DNSVerifyInfo(self):
        r"""DNS解析信息
        :rtype: :class:`tencentcloud.vod.v20180717.models.DNSVerifyInfo`
        """
        return self._DNSVerifyInfo

    @DNSVerifyInfo.setter
    def DNSVerifyInfo(self, DNSVerifyInfo):
        self._DNSVerifyInfo = DNSVerifyInfo

    @property
    def FileVerifyInfo(self):
        r"""文件验证信息
        :rtype: :class:`tencentcloud.vod.v20180717.models.FileVerifyInfo`
        """
        return self._FileVerifyInfo

    @FileVerifyInfo.setter
    def FileVerifyInfo(self, FileVerifyInfo):
        self._FileVerifyInfo = FileVerifyInfo

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DNSVerifyInfo") is not None:
            self._DNSVerifyInfo = DNSVerifyInfo()
            self._DNSVerifyInfo._deserialize(params.get("DNSVerifyInfo"))
        if params.get("FileVerifyInfo") is not None:
            self._FileVerifyInfo = FileVerifyInfo()
            self._FileVerifyInfo._deserialize(params.get("FileVerifyInfo"))
        self._RequestId = params.get("RequestId")


class CreateEnhanceMediaTemplateRequest(AbstractModel):
    r"""CreateEnhanceMediaTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Container: 输出文件封装格式，可选值：mp4、flv、hls。
        :type Container: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Name: 音画质重生模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Comment: 模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _RebuildVideoInfo: 音画质重生视频控制控制信息。
        :type RebuildVideoInfo: :class:`tencentcloud.vod.v20180717.models.RebuildVideoInfo`
        :param _RebuildAudioInfo: 音画质重生音频控制控制信息。
        :type RebuildAudioInfo: :class:`tencentcloud.vod.v20180717.models.RebuildAudioInfo`
        :param _TargetVideoInfo: 输出目标视频控制信息。
        :type TargetVideoInfo: :class:`tencentcloud.vod.v20180717.models.RebuildMediaTargetVideoStream`
        :param _TargetAudioInfo: 输出目标音频控制信息。
        :type TargetAudioInfo: :class:`tencentcloud.vod.v20180717.models.RebuildMediaTargetAudioStream`
        :param _RemoveVideo: 是否去除视频数据，可选值：
<li>0：保留</li>
<li>1：去除</li>
默认值 0。
        :type RemoveVideo: int
        :param _RemoveAudio: 是否去除音频数据，可选值：
<li>0：保留</li>
<li>1：去除</li>
默认值 0。
        :type RemoveAudio: int
        """
        self._Container = None
        self._SubAppId = None
        self._Name = None
        self._Comment = None
        self._RebuildVideoInfo = None
        self._RebuildAudioInfo = None
        self._TargetVideoInfo = None
        self._TargetAudioInfo = None
        self._RemoveVideo = None
        self._RemoveAudio = None

    @property
    def Container(self):
        r"""输出文件封装格式，可选值：mp4、flv、hls。
        :rtype: str
        """
        return self._Container

    @Container.setter
    def Container(self, Container):
        self._Container = Container

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Name(self):
        r"""音画质重生模板名称，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        r"""模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def RebuildVideoInfo(self):
        r"""音画质重生视频控制控制信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.RebuildVideoInfo`
        """
        return self._RebuildVideoInfo

    @RebuildVideoInfo.setter
    def RebuildVideoInfo(self, RebuildVideoInfo):
        self._RebuildVideoInfo = RebuildVideoInfo

    @property
    def RebuildAudioInfo(self):
        r"""音画质重生音频控制控制信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.RebuildAudioInfo`
        """
        return self._RebuildAudioInfo

    @RebuildAudioInfo.setter
    def RebuildAudioInfo(self, RebuildAudioInfo):
        self._RebuildAudioInfo = RebuildAudioInfo

    @property
    def TargetVideoInfo(self):
        r"""输出目标视频控制信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.RebuildMediaTargetVideoStream`
        """
        return self._TargetVideoInfo

    @TargetVideoInfo.setter
    def TargetVideoInfo(self, TargetVideoInfo):
        self._TargetVideoInfo = TargetVideoInfo

    @property
    def TargetAudioInfo(self):
        r"""输出目标音频控制信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.RebuildMediaTargetAudioStream`
        """
        return self._TargetAudioInfo

    @TargetAudioInfo.setter
    def TargetAudioInfo(self, TargetAudioInfo):
        self._TargetAudioInfo = TargetAudioInfo

    @property
    def RemoveVideo(self):
        r"""是否去除视频数据，可选值：
<li>0：保留</li>
<li>1：去除</li>
默认值 0。
        :rtype: int
        """
        return self._RemoveVideo

    @RemoveVideo.setter
    def RemoveVideo(self, RemoveVideo):
        self._RemoveVideo = RemoveVideo

    @property
    def RemoveAudio(self):
        r"""是否去除音频数据，可选值：
<li>0：保留</li>
<li>1：去除</li>
默认值 0。
        :rtype: int
        """
        return self._RemoveAudio

    @RemoveAudio.setter
    def RemoveAudio(self, RemoveAudio):
        self._RemoveAudio = RemoveAudio


    def _deserialize(self, params):
        self._Container = params.get("Container")
        self._SubAppId = params.get("SubAppId")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("RebuildVideoInfo") is not None:
            self._RebuildVideoInfo = RebuildVideoInfo()
            self._RebuildVideoInfo._deserialize(params.get("RebuildVideoInfo"))
        if params.get("RebuildAudioInfo") is not None:
            self._RebuildAudioInfo = RebuildAudioInfo()
            self._RebuildAudioInfo._deserialize(params.get("RebuildAudioInfo"))
        if params.get("TargetVideoInfo") is not None:
            self._TargetVideoInfo = RebuildMediaTargetVideoStream()
            self._TargetVideoInfo._deserialize(params.get("TargetVideoInfo"))
        if params.get("TargetAudioInfo") is not None:
            self._TargetAudioInfo = RebuildMediaTargetAudioStream()
            self._TargetAudioInfo._deserialize(params.get("TargetAudioInfo"))
        self._RemoveVideo = params.get("RemoveVideo")
        self._RemoveAudio = params.get("RemoveAudio")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateEnhanceMediaTemplateResponse(AbstractModel):
    r"""CreateEnhanceMediaTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 音画质重生模板 ID。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""音画质重生模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateHeadTailTemplateRequest(AbstractModel):
    r"""CreateHeadTailTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 模板名，长度限制 64 个字符。
        :type Name: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Comment: 模板描述信息，长度限制 256 个字符。
        :type Comment: str
        :param _HeadCandidateSet: 片头候选列表，填写视频的 FileId。转码时将自动选择与正片宽高比最接近的一个片头（相同宽高比时，靠前的候选项优先）。最多支持 5 个候选片头。
        :type HeadCandidateSet: list of str
        :param _TailCandidateSet: 片尾候选列表，填写视频的 FileId。转码时将自动选择与正片宽高比最接近的一个片尾（相同宽高比时，靠前的候选项优先）。最多支持 5 个候选片尾。
        :type TailCandidateSet: list of str
        :param _FillType: 填充方式，当视频流配置宽高参数与原始视频的宽高比不一致时，对转码的处理方式，即为“填充”。可选填充方式：
<li> stretch：拉伸，对每一帧进行拉伸，填满整个画面，可能导致转码后的视频被“压扁“或者“拉长“；</li>
<li> gauss：高斯模糊，保持视频宽高比不变，边缘剩余部分使用高斯模糊；</li>
<li> white：留白，保持视频宽高比不变，边缘剩余部分使用白色填充；</li>
<li> black：留黑，保持视频宽高比不变，边缘剩余部分使用黑色填充。</li>
默认值：stretch 。
        :type FillType: str
        """
        self._Name = None
        self._SubAppId = None
        self._Comment = None
        self._HeadCandidateSet = None
        self._TailCandidateSet = None
        self._FillType = None

    @property
    def Name(self):
        r"""模板名，长度限制 64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Comment(self):
        r"""模板描述信息，长度限制 256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def HeadCandidateSet(self):
        r"""片头候选列表，填写视频的 FileId。转码时将自动选择与正片宽高比最接近的一个片头（相同宽高比时，靠前的候选项优先）。最多支持 5 个候选片头。
        :rtype: list of str
        """
        return self._HeadCandidateSet

    @HeadCandidateSet.setter
    def HeadCandidateSet(self, HeadCandidateSet):
        self._HeadCandidateSet = HeadCandidateSet

    @property
    def TailCandidateSet(self):
        r"""片尾候选列表，填写视频的 FileId。转码时将自动选择与正片宽高比最接近的一个片尾（相同宽高比时，靠前的候选项优先）。最多支持 5 个候选片尾。
        :rtype: list of str
        """
        return self._TailCandidateSet

    @TailCandidateSet.setter
    def TailCandidateSet(self, TailCandidateSet):
        self._TailCandidateSet = TailCandidateSet

    @property
    def FillType(self):
        r"""填充方式，当视频流配置宽高参数与原始视频的宽高比不一致时，对转码的处理方式，即为“填充”。可选填充方式：
<li> stretch：拉伸，对每一帧进行拉伸，填满整个画面，可能导致转码后的视频被“压扁“或者“拉长“；</li>
<li> gauss：高斯模糊，保持视频宽高比不变，边缘剩余部分使用高斯模糊；</li>
<li> white：留白，保持视频宽高比不变，边缘剩余部分使用白色填充；</li>
<li> black：留黑，保持视频宽高比不变，边缘剩余部分使用黑色填充。</li>
默认值：stretch 。
        :rtype: str
        """
        return self._FillType

    @FillType.setter
    def FillType(self, FillType):
        self._FillType = FillType


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._SubAppId = params.get("SubAppId")
        self._Comment = params.get("Comment")
        self._HeadCandidateSet = params.get("HeadCandidateSet")
        self._TailCandidateSet = params.get("TailCandidateSet")
        self._FillType = params.get("FillType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateHeadTailTemplateResponse(AbstractModel):
    r"""CreateHeadTailTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 片头片尾模板号。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""片头片尾模板号。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateImageProcessingTemplateRequest(AbstractModel):
    r"""CreateImageProcessingTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Operations: 图片处理操作数组，操作将以其在数组中的顺序执行。
<li>长度限制：10。</li>
        :type Operations: list of ImageOperation
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Name: 图片处理模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Comment: 模板描述信息，长度限制：256 个字符。
        :type Comment: str
        """
        self._Operations = None
        self._SubAppId = None
        self._Name = None
        self._Comment = None

    @property
    def Operations(self):
        r"""图片处理操作数组，操作将以其在数组中的顺序执行。
<li>长度限制：10。</li>
        :rtype: list of ImageOperation
        """
        return self._Operations

    @Operations.setter
    def Operations(self, Operations):
        self._Operations = Operations

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Name(self):
        r"""图片处理模板名称，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        r"""模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment


    def _deserialize(self, params):
        if params.get("Operations") is not None:
            self._Operations = []
            for item in params.get("Operations"):
                obj = ImageOperation()
                obj._deserialize(item)
                self._Operations.append(obj)
        self._SubAppId = params.get("SubAppId")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateImageProcessingTemplateResponse(AbstractModel):
    r"""CreateImageProcessingTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 图片处理模板唯一标识。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""图片处理模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateImageSpriteTask2017(AbstractModel):
    r"""视频截取雪碧图任务，该结构仅用于对 2017 版[截取雪碧图](https://cloud.tencent.com/document/product/266/8101)接口发起的任务。

    """

    def __init__(self):
        r"""
        :param _TaskId: 截图雪碧图任务 ID。
        :type TaskId: str
        :param _ErrCode: 错误码
<li>0：成功；</li>
<li>其他值：失败。</li>
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _FileId: 截取雪碧图文件 ID。
        :type FileId: str
        :param _Definition: 雪碧图规格，参见[雪碧图截图模板](https://cloud.tencent.com/document/product/266/33480#.E9.9B.AA.E7.A2.A7.E5.9B.BE.E6.A8.A1.E6.9D.BF)。
        :type Definition: int
        :param _TotalCount: 雪碧图小图总数量。
        :type TotalCount: int
        :param _ImageSpriteUrlSet: 截取雪碧图输出的地址。
        :type ImageSpriteUrlSet: list of str
        :param _WebVttUrl: 雪碧图子图位置与时间关系 WebVtt 文件地址。
        :type WebVttUrl: str
        """
        self._TaskId = None
        self._ErrCode = None
        self._Message = None
        self._FileId = None
        self._Definition = None
        self._TotalCount = None
        self._ImageSpriteUrlSet = None
        self._WebVttUrl = None

    @property
    def TaskId(self):
        r"""截图雪碧图任务 ID。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ErrCode(self):
        r"""错误码
<li>0：成功；</li>
<li>其他值：失败。</li>
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def FileId(self):
        r"""截取雪碧图文件 ID。
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def Definition(self):
        r"""雪碧图规格，参见[雪碧图截图模板](https://cloud.tencent.com/document/product/266/33480#.E9.9B.AA.E7.A2.A7.E5.9B.BE.E6.A8.A1.E6.9D.BF)。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def TotalCount(self):
        r"""雪碧图小图总数量。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ImageSpriteUrlSet(self):
        r"""截取雪碧图输出的地址。
        :rtype: list of str
        """
        return self._ImageSpriteUrlSet

    @ImageSpriteUrlSet.setter
    def ImageSpriteUrlSet(self, ImageSpriteUrlSet):
        self._ImageSpriteUrlSet = ImageSpriteUrlSet

    @property
    def WebVttUrl(self):
        r"""雪碧图子图位置与时间关系 WebVtt 文件地址。
        :rtype: str
        """
        return self._WebVttUrl

    @WebVttUrl.setter
    def WebVttUrl(self, WebVttUrl):
        self._WebVttUrl = WebVttUrl


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        self._FileId = params.get("FileId")
        self._Definition = params.get("Definition")
        self._TotalCount = params.get("TotalCount")
        self._ImageSpriteUrlSet = params.get("ImageSpriteUrlSet")
        self._WebVttUrl = params.get("WebVttUrl")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateImageSpriteTemplateRequest(AbstractModel):
    r"""CreateImageSpriteTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SampleType: 采样类型，取值：
<li>Percent：按百分比。</li>
<li>Time：按时间间隔。</li>
        :type SampleType: str
        :param _SampleInterval: 采样间隔。
<li>当 SampleType 为 Percent 时，指定采样间隔的百分比。</li>
<li>当 SampleType 为 Time 时，指定采样间隔的时间，单位为秒。</li>
        :type SampleInterval: int
        :param _RowCount: 雪碧图中小图的行数。
注意：小图的行数会影响最终大图的高度，大图的高度最大为15000像素，其中大图的高度为小图行数与小图高度的乘积。
        :type RowCount: int
        :param _ColumnCount: 雪碧图中小图的列数。
注意：小图的列数会影响最终大图的宽度，大图的宽度最大为15000像素，其中大图的宽度为小图列数与小图宽度的乘积。
        :type ColumnCount: int
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Name: 雪碧图模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Comment: 模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _FillType: 填充方式，当视频流配置宽高参数与原始视频的宽高比不一致时，对转码的处理方式，即为“填充”。可选填充方式：<li> stretch：拉伸，对每一帧进行拉伸，填满整个画面，可能导致转码后的视频被“压扁”或者“拉长”；</li><li>black：留黑，保持视频宽高比不变，边缘剩余部分使用黑色填充。</li>默认值：black 。
        :type FillType: str
        :param _Width: 雪碧图中小图的宽度（或长边）的最大值，取值范围：0 和 [128, 4096]，单位：px。<li>当 Width、Height 均为 0，则分辨率同源；</li><li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li><li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li><li>当 Width、Height 均非 0，则分辨率按用户指定。</li>默认值：0。注意：小图的宽度会影响最终大图的宽度，大图的宽度最大为15000像素，其中大图的宽度为小图列数与小图宽度的乘积。
        :type Width: int
        :param _Height: 雪碧图中小图的高度（或短边）的最大值，取值范围：0 和 [128, 4096]，单位：px。<li>当 Width、Height 均为 0，则分辨率同源；</li><li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li><li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li><li>当 Width、Height 均非 0，则分辨率按用户指定。</li>默认值：0。注意：小图的高度会影响最终大图的高度，大图的高度最大为15000像素，其中大图的高度为小图行数与小图高度的乘积。
        :type Height: int
        :param _ResolutionAdaptive: 分辨率自适应，可选值：
<li>open：开启，此时，Width 代表视频的长边，Height 表示视频的短边；</li>
<li>close：关闭，此时，Width 代表视频的宽度，Height 表示视频的高度。</li>
默认值：open。
        :type ResolutionAdaptive: str
        :param _Format: 图片格式，取值：
<li> jpg：jpg 格式；</li>
<li> png：png 格式；</li>
<li> webp：webp 格式。</li>
默认值：jpg。
        :type Format: str
        """
        self._SampleType = None
        self._SampleInterval = None
        self._RowCount = None
        self._ColumnCount = None
        self._SubAppId = None
        self._Name = None
        self._Comment = None
        self._FillType = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._Format = None

    @property
    def SampleType(self):
        r"""采样类型，取值：
<li>Percent：按百分比。</li>
<li>Time：按时间间隔。</li>
        :rtype: str
        """
        return self._SampleType

    @SampleType.setter
    def SampleType(self, SampleType):
        self._SampleType = SampleType

    @property
    def SampleInterval(self):
        r"""采样间隔。
<li>当 SampleType 为 Percent 时，指定采样间隔的百分比。</li>
<li>当 SampleType 为 Time 时，指定采样间隔的时间，单位为秒。</li>
        :rtype: int
        """
        return self._SampleInterval

    @SampleInterval.setter
    def SampleInterval(self, SampleInterval):
        self._SampleInterval = SampleInterval

    @property
    def RowCount(self):
        r"""雪碧图中小图的行数。
注意：小图的行数会影响最终大图的高度，大图的高度最大为15000像素，其中大图的高度为小图行数与小图高度的乘积。
        :rtype: int
        """
        return self._RowCount

    @RowCount.setter
    def RowCount(self, RowCount):
        self._RowCount = RowCount

    @property
    def ColumnCount(self):
        r"""雪碧图中小图的列数。
注意：小图的列数会影响最终大图的宽度，大图的宽度最大为15000像素，其中大图的宽度为小图列数与小图宽度的乘积。
        :rtype: int
        """
        return self._ColumnCount

    @ColumnCount.setter
    def ColumnCount(self, ColumnCount):
        self._ColumnCount = ColumnCount

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Name(self):
        r"""雪碧图模板名称，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        r"""模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def FillType(self):
        r"""填充方式，当视频流配置宽高参数与原始视频的宽高比不一致时，对转码的处理方式，即为“填充”。可选填充方式：<li> stretch：拉伸，对每一帧进行拉伸，填满整个画面，可能导致转码后的视频被“压扁”或者“拉长”；</li><li>black：留黑，保持视频宽高比不变，边缘剩余部分使用黑色填充。</li>默认值：black 。
        :rtype: str
        """
        return self._FillType

    @FillType.setter
    def FillType(self, FillType):
        self._FillType = FillType

    @property
    def Width(self):
        r"""雪碧图中小图的宽度（或长边）的最大值，取值范围：0 和 [128, 4096]，单位：px。<li>当 Width、Height 均为 0，则分辨率同源；</li><li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li><li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li><li>当 Width、Height 均非 0，则分辨率按用户指定。</li>默认值：0。注意：小图的宽度会影响最终大图的宽度，大图的宽度最大为15000像素，其中大图的宽度为小图列数与小图宽度的乘积。
        :rtype: int
        """
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        r"""雪碧图中小图的高度（或短边）的最大值，取值范围：0 和 [128, 4096]，单位：px。<li>当 Width、Height 均为 0，则分辨率同源；</li><li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li><li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li><li>当 Width、Height 均非 0，则分辨率按用户指定。</li>默认值：0。注意：小图的高度会影响最终大图的高度，大图的高度最大为15000像素，其中大图的高度为小图行数与小图高度的乘积。
        :rtype: int
        """
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        r"""分辨率自适应，可选值：
<li>open：开启，此时，Width 代表视频的长边，Height 表示视频的短边；</li>
<li>close：关闭，此时，Width 代表视频的宽度，Height 表示视频的高度。</li>
默认值：open。
        :rtype: str
        """
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def Format(self):
        r"""图片格式，取值：
<li> jpg：jpg 格式；</li>
<li> png：png 格式；</li>
<li> webp：webp 格式。</li>
默认值：jpg。
        :rtype: str
        """
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format


    def _deserialize(self, params):
        self._SampleType = params.get("SampleType")
        self._SampleInterval = params.get("SampleInterval")
        self._RowCount = params.get("RowCount")
        self._ColumnCount = params.get("ColumnCount")
        self._SubAppId = params.get("SubAppId")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        self._FillType = params.get("FillType")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._Format = params.get("Format")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateImageSpriteTemplateResponse(AbstractModel):
    r"""CreateImageSpriteTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 雪碧图模板唯一标识。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""雪碧图模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateJustInTimeTranscodeTemplateRequest(AbstractModel):
    r"""CreateJustInTimeTranscodeTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 模板名字，长度限制64个字符。
        :type Name: str
        :param _VideoConfigure: 视频参数配置。
        :type VideoConfigure: :class:`tencentcloud.vod.v20180717.models.VideoConfigureInfo`
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _WatermarkConfigure: 水印参数配置。
        :type WatermarkConfigure: :class:`tencentcloud.vod.v20180717.models.WatermarkConfigureInfo`
        :param _Comment: 模板描述，长度限制256个字符。
        :type Comment: str
        """
        self._Name = None
        self._VideoConfigure = None
        self._SubAppId = None
        self._WatermarkConfigure = None
        self._Comment = None

    @property
    def Name(self):
        r"""模板名字，长度限制64个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def VideoConfigure(self):
        r"""视频参数配置。
        :rtype: :class:`tencentcloud.vod.v20180717.models.VideoConfigureInfo`
        """
        return self._VideoConfigure

    @VideoConfigure.setter
    def VideoConfigure(self, VideoConfigure):
        self._VideoConfigure = VideoConfigure

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def WatermarkConfigure(self):
        r"""水印参数配置。
        :rtype: :class:`tencentcloud.vod.v20180717.models.WatermarkConfigureInfo`
        """
        return self._WatermarkConfigure

    @WatermarkConfigure.setter
    def WatermarkConfigure(self, WatermarkConfigure):
        self._WatermarkConfigure = WatermarkConfigure

    @property
    def Comment(self):
        r"""模板描述，长度限制256个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment


    def _deserialize(self, params):
        self._Name = params.get("Name")
        if params.get("VideoConfigure") is not None:
            self._VideoConfigure = VideoConfigureInfo()
            self._VideoConfigure._deserialize(params.get("VideoConfigure"))
        self._SubAppId = params.get("SubAppId")
        if params.get("WatermarkConfigure") is not None:
            self._WatermarkConfigure = WatermarkConfigureInfo()
            self._WatermarkConfigure._deserialize(params.get("WatermarkConfigure"))
        self._Comment = params.get("Comment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateJustInTimeTranscodeTemplateResponse(AbstractModel):
    r"""CreateJustInTimeTranscodeTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateMPSTemplateRequest(AbstractModel):
    r"""CreateMPSTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。</b>
        :type SubAppId: int
        :param _TemplateType: 需要创建的 MPS 模板的类型。取值：
<li>Transcode: 创建转码模板，目前仅支持创建增强模板。</li>
        :type TemplateType: str
        :param _MPSCreateTemplateParams: MPS 创建模板参数。该参数用于透传至媒体处理服务（MPS），从云点播侧创建用户自定义的 MPS 任务模板。
目前仅支持通过此方式创建以下任务类型的模板：
1. 音视频增强：仅支持填写“[创建转码模板](https://cloud.tencent.com/document/product/862/37605)”接口中的 Container 、Name、Comment、RemoveVideo、RemoveAudio、VideoTemplate、AudioTemplate 和 EnhanceConfig 几个参数。其中 EnhanceConfig 此处必填，且 Container 目前暂不支持 hls。

目前模板中仅支持配置以上参数，其他参数无需填写。若包含其它参数，系统将自动忽略。以上透传参数以JSON形式表示。

        :type MPSCreateTemplateParams: str
        """
        self._SubAppId = None
        self._TemplateType = None
        self._MPSCreateTemplateParams = None

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def TemplateType(self):
        r"""需要创建的 MPS 模板的类型。取值：
<li>Transcode: 创建转码模板，目前仅支持创建增强模板。</li>
        :rtype: str
        """
        return self._TemplateType

    @TemplateType.setter
    def TemplateType(self, TemplateType):
        self._TemplateType = TemplateType

    @property
    def MPSCreateTemplateParams(self):
        r"""MPS 创建模板参数。该参数用于透传至媒体处理服务（MPS），从云点播侧创建用户自定义的 MPS 任务模板。
目前仅支持通过此方式创建以下任务类型的模板：
1. 音视频增强：仅支持填写“[创建转码模板](https://cloud.tencent.com/document/product/862/37605)”接口中的 Container 、Name、Comment、RemoveVideo、RemoveAudio、VideoTemplate、AudioTemplate 和 EnhanceConfig 几个参数。其中 EnhanceConfig 此处必填，且 Container 目前暂不支持 hls。

目前模板中仅支持配置以上参数，其他参数无需填写。若包含其它参数，系统将自动忽略。以上透传参数以JSON形式表示。

        :rtype: str
        """
        return self._MPSCreateTemplateParams

    @MPSCreateTemplateParams.setter
    def MPSCreateTemplateParams(self, MPSCreateTemplateParams):
        self._MPSCreateTemplateParams = MPSCreateTemplateParams


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._TemplateType = params.get("TemplateType")
        self._MPSCreateTemplateParams = params.get("MPSCreateTemplateParams")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateMPSTemplateResponse(AbstractModel):
    r"""CreateMPSTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: MPS 任务模板唯一标识。该模板独立于直接在 MPS 服务中创建的模板。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""MPS 任务模板唯一标识。该模板独立于直接在 MPS 服务中创建的模板。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreatePersonSampleRequest(AbstractModel):
    r"""CreatePersonSample请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 素材名称，长度限制：20 个字符。
        :type Name: str
        :param _Usages: 素材应用场景，可选值：
1. Recognition：用于内容识别，等价于 Recognition.Face。
2. Review：用于内容不适宜，等价于 Review.Face。
3. All：包含以上全部，等价于 1+2。
        :type Usages: list of str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Description: 素材描述，长度限制：1024 个字符。
        :type Description: str
        :param _FaceContents: 素材图片 [Base64](https://tools.ietf.org/html/rfc4648) 编码后的字符串，仅支持 jpeg、png 图片格式。数组长度限制：5 张图片。
注意：图片必须是单人像五官较清晰的照片，像素不低于 200*200。
        :type FaceContents: list of str
        :param _Tags: 素材标签
<li>数组长度限制：20 个标签；</li>
<li>单个标签长度限制：128 个字符。</li>
        :type Tags: list of str
        """
        self._Name = None
        self._Usages = None
        self._SubAppId = None
        self._Description = None
        self._FaceContents = None
        self._Tags = None

    @property
    def Name(self):
        r"""素材名称，长度限制：20 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Usages(self):
        r"""素材应用场景，可选值：
1. Recognition：用于内容识别，等价于 Recognition.Face。
2. Review：用于内容不适宜，等价于 Review.Face。
3. All：包含以上全部，等价于 1+2。
        :rtype: list of str
        """
        return self._Usages

    @Usages.setter
    def Usages(self, Usages):
        self._Usages = Usages

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Description(self):
        r"""素材描述，长度限制：1024 个字符。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def FaceContents(self):
        r"""素材图片 [Base64](https://tools.ietf.org/html/rfc4648) 编码后的字符串，仅支持 jpeg、png 图片格式。数组长度限制：5 张图片。
注意：图片必须是单人像五官较清晰的照片，像素不低于 200*200。
        :rtype: list of str
        """
        return self._FaceContents

    @FaceContents.setter
    def FaceContents(self, FaceContents):
        self._FaceContents = FaceContents

    @property
    def Tags(self):
        r"""素材标签
<li>数组长度限制：20 个标签；</li>
<li>单个标签长度限制：128 个字符。</li>
        :rtype: list of str
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Usages = params.get("Usages")
        self._SubAppId = params.get("SubAppId")
        self._Description = params.get("Description")
        self._FaceContents = params.get("FaceContents")
        self._Tags = params.get("Tags")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreatePersonSampleResponse(AbstractModel):
    r"""CreatePersonSample返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Person: 素材信息。
        :type Person: :class:`tencentcloud.vod.v20180717.models.AiSamplePerson`
        :param _FailFaceInfoSet: 处理失败的五官定位信息。
        :type FailFaceInfoSet: list of AiSampleFailFaceInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Person = None
        self._FailFaceInfoSet = None
        self._RequestId = None

    @property
    def Person(self):
        r"""素材信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiSamplePerson`
        """
        return self._Person

    @Person.setter
    def Person(self, Person):
        self._Person = Person

    @property
    def FailFaceInfoSet(self):
        r"""处理失败的五官定位信息。
        :rtype: list of AiSampleFailFaceInfo
        """
        return self._FailFaceInfoSet

    @FailFaceInfoSet.setter
    def FailFaceInfoSet(self, FailFaceInfoSet):
        self._FailFaceInfoSet = FailFaceInfoSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Person") is not None:
            self._Person = AiSamplePerson()
            self._Person._deserialize(params.get("Person"))
        if params.get("FailFaceInfoSet") is not None:
            self._FailFaceInfoSet = []
            for item in params.get("FailFaceInfoSet"):
                obj = AiSampleFailFaceInfo()
                obj._deserialize(item)
                self._FailFaceInfoSet.append(obj)
        self._RequestId = params.get("RequestId")


class CreateProcedureTemplateRequest(AbstractModel):
    r"""CreateProcedureTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 任务流名字（支持中文，不超过20个字）。
        :type Name: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Comment: 模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _MediaProcessTask: 视频处理类型任务参数。
        :type MediaProcessTask: :class:`tencentcloud.vod.v20180717.models.MediaProcessTaskInput`
        :param _AiContentReviewTask: AI 内容审核类型任务参数 \*。
<font color=red>\*：该参数用于发起旧版审核，不建议使用。推荐使用 ReviewAudioVideoTask 参数发起审核。</font> 
        :type AiContentReviewTask: :class:`tencentcloud.vod.v20180717.models.AiContentReviewTaskInput`
        :param _AiAnalysisTask: AI 内容分析类型任务参数。
        :type AiAnalysisTask: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskInput`
        :param _AiRecognitionTaskSet: AI 内容识别类型任务参数。
        :type AiRecognitionTaskSet: list of AiRecognitionTaskInput
        :param _AiRecognitionTask: 该参数已不推荐使用，建议使用 AiRecognitionTaskSet。
        :type AiRecognitionTask: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskInput`
        :param _ReviewAudioVideoTask: 音视频审核类型任务参数。
        :type ReviewAudioVideoTask: :class:`tencentcloud.vod.v20180717.models.ProcedureReviewAudioVideoTaskInput`
        """
        self._Name = None
        self._SubAppId = None
        self._Comment = None
        self._MediaProcessTask = None
        self._AiContentReviewTask = None
        self._AiAnalysisTask = None
        self._AiRecognitionTaskSet = None
        self._AiRecognitionTask = None
        self._ReviewAudioVideoTask = None

    @property
    def Name(self):
        r"""任务流名字（支持中文，不超过20个字）。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Comment(self):
        r"""模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def MediaProcessTask(self):
        r"""视频处理类型任务参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.MediaProcessTaskInput`
        """
        return self._MediaProcessTask

    @MediaProcessTask.setter
    def MediaProcessTask(self, MediaProcessTask):
        self._MediaProcessTask = MediaProcessTask

    @property
    def AiContentReviewTask(self):
        r"""AI 内容审核类型任务参数 \*。
<font color=red>\*：该参数用于发起旧版审核，不建议使用。推荐使用 ReviewAudioVideoTask 参数发起审核。</font> 
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiContentReviewTaskInput`
        """
        return self._AiContentReviewTask

    @AiContentReviewTask.setter
    def AiContentReviewTask(self, AiContentReviewTask):
        self._AiContentReviewTask = AiContentReviewTask

    @property
    def AiAnalysisTask(self):
        r"""AI 内容分析类型任务参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskInput`
        """
        return self._AiAnalysisTask

    @AiAnalysisTask.setter
    def AiAnalysisTask(self, AiAnalysisTask):
        self._AiAnalysisTask = AiAnalysisTask

    @property
    def AiRecognitionTaskSet(self):
        r"""AI 内容识别类型任务参数。
        :rtype: list of AiRecognitionTaskInput
        """
        return self._AiRecognitionTaskSet

    @AiRecognitionTaskSet.setter
    def AiRecognitionTaskSet(self, AiRecognitionTaskSet):
        self._AiRecognitionTaskSet = AiRecognitionTaskSet

    @property
    def AiRecognitionTask(self):
        warnings.warn("parameter `AiRecognitionTask` is deprecated", DeprecationWarning) 

        r"""该参数已不推荐使用，建议使用 AiRecognitionTaskSet。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskInput`
        """
        return self._AiRecognitionTask

    @AiRecognitionTask.setter
    def AiRecognitionTask(self, AiRecognitionTask):
        warnings.warn("parameter `AiRecognitionTask` is deprecated", DeprecationWarning) 

        self._AiRecognitionTask = AiRecognitionTask

    @property
    def ReviewAudioVideoTask(self):
        r"""音视频审核类型任务参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ProcedureReviewAudioVideoTaskInput`
        """
        return self._ReviewAudioVideoTask

    @ReviewAudioVideoTask.setter
    def ReviewAudioVideoTask(self, ReviewAudioVideoTask):
        self._ReviewAudioVideoTask = ReviewAudioVideoTask


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._SubAppId = params.get("SubAppId")
        self._Comment = params.get("Comment")
        if params.get("MediaProcessTask") is not None:
            self._MediaProcessTask = MediaProcessTaskInput()
            self._MediaProcessTask._deserialize(params.get("MediaProcessTask"))
        if params.get("AiContentReviewTask") is not None:
            self._AiContentReviewTask = AiContentReviewTaskInput()
            self._AiContentReviewTask._deserialize(params.get("AiContentReviewTask"))
        if params.get("AiAnalysisTask") is not None:
            self._AiAnalysisTask = AiAnalysisTaskInput()
            self._AiAnalysisTask._deserialize(params.get("AiAnalysisTask"))
        if params.get("AiRecognitionTaskSet") is not None:
            self._AiRecognitionTaskSet = []
            for item in params.get("AiRecognitionTaskSet"):
                obj = AiRecognitionTaskInput()
                obj._deserialize(item)
                self._AiRecognitionTaskSet.append(obj)
        if params.get("AiRecognitionTask") is not None:
            self._AiRecognitionTask = AiRecognitionTaskInput()
            self._AiRecognitionTask._deserialize(params.get("AiRecognitionTask"))
        if params.get("ReviewAudioVideoTask") is not None:
            self._ReviewAudioVideoTask = ProcedureReviewAudioVideoTaskInput()
            self._ReviewAudioVideoTask._deserialize(params.get("ReviewAudioVideoTask"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateProcedureTemplateResponse(AbstractModel):
    r"""CreateProcedureTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateQualityInspectTemplateRequest(AbstractModel):
    r"""CreateQualityInspectTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Name: 音画质检测模板名称。
        :type Name: str
        :param _Comment: 音画质检测模板描述。
        :type Comment: str
        :param _ScreenshotInterval: 截帧间隔，单位为秒，最小值为 1。当不填时，默认截帧间隔为 1 秒。
        :type ScreenshotInterval: float
        :param _JitterConfigure: 视频画面抖动重影检测的控制参数。
        :type JitterConfigure: :class:`tencentcloud.vod.v20180717.models.JitterConfigureInfo`
        :param _BlurConfigure: 视频画面模糊检测的控制参数。
        :type BlurConfigure: :class:`tencentcloud.vod.v20180717.models.BlurConfigureInfo`
        :param _AbnormalLightingConfigure: 视频画面低光、过曝检测的控制参数。
        :type AbnormalLightingConfigure: :class:`tencentcloud.vod.v20180717.models.AbnormalLightingConfigureInfo`
        :param _CrashScreenConfigure: 视频画面花屏检测的控制参数。
        :type CrashScreenConfigure: :class:`tencentcloud.vod.v20180717.models.CrashScreenConfigureInfo`
        :param _BlackWhiteEdgeConfigure: 视频画面黑边、白边、黑屏、白屏检测的控制参数。
        :type BlackWhiteEdgeConfigure: :class:`tencentcloud.vod.v20180717.models.BlackWhiteEdgeConfigureInfo`
        :param _NoiseConfigure: 视频画面噪点检测的控制参数。
        :type NoiseConfigure: :class:`tencentcloud.vod.v20180717.models.NoiseConfigureInfo`
        :param _MosaicConfigure: 视频画面马赛克检测的控制参数。
        :type MosaicConfigure: :class:`tencentcloud.vod.v20180717.models.MosaicConfigureInfo`
        :param _QRCodeConfigure: 视频画面二维码检测的控制参数。
        :type QRCodeConfigure: :class:`tencentcloud.vod.v20180717.models.QRCodeConfigureInfo`
        :param _VoiceConfigure: 音频（静音、低音、爆音）检测的控制参数。
        :type VoiceConfigure: :class:`tencentcloud.vod.v20180717.models.VoiceConfigureInfo`
        :param _QualityEvaluationConfigure: 视频画面质量评价的控制参数。
        :type QualityEvaluationConfigure: :class:`tencentcloud.vod.v20180717.models.QualityEvaluationConfigureInfo`
        """
        self._SubAppId = None
        self._Name = None
        self._Comment = None
        self._ScreenshotInterval = None
        self._JitterConfigure = None
        self._BlurConfigure = None
        self._AbnormalLightingConfigure = None
        self._CrashScreenConfigure = None
        self._BlackWhiteEdgeConfigure = None
        self._NoiseConfigure = None
        self._MosaicConfigure = None
        self._QRCodeConfigure = None
        self._VoiceConfigure = None
        self._QualityEvaluationConfigure = None

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Name(self):
        r"""音画质检测模板名称。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        r"""音画质检测模板描述。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def ScreenshotInterval(self):
        r"""截帧间隔，单位为秒，最小值为 1。当不填时，默认截帧间隔为 1 秒。
        :rtype: float
        """
        return self._ScreenshotInterval

    @ScreenshotInterval.setter
    def ScreenshotInterval(self, ScreenshotInterval):
        self._ScreenshotInterval = ScreenshotInterval

    @property
    def JitterConfigure(self):
        r"""视频画面抖动重影检测的控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.JitterConfigureInfo`
        """
        return self._JitterConfigure

    @JitterConfigure.setter
    def JitterConfigure(self, JitterConfigure):
        self._JitterConfigure = JitterConfigure

    @property
    def BlurConfigure(self):
        r"""视频画面模糊检测的控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.BlurConfigureInfo`
        """
        return self._BlurConfigure

    @BlurConfigure.setter
    def BlurConfigure(self, BlurConfigure):
        self._BlurConfigure = BlurConfigure

    @property
    def AbnormalLightingConfigure(self):
        r"""视频画面低光、过曝检测的控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AbnormalLightingConfigureInfo`
        """
        return self._AbnormalLightingConfigure

    @AbnormalLightingConfigure.setter
    def AbnormalLightingConfigure(self, AbnormalLightingConfigure):
        self._AbnormalLightingConfigure = AbnormalLightingConfigure

    @property
    def CrashScreenConfigure(self):
        r"""视频画面花屏检测的控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.CrashScreenConfigureInfo`
        """
        return self._CrashScreenConfigure

    @CrashScreenConfigure.setter
    def CrashScreenConfigure(self, CrashScreenConfigure):
        self._CrashScreenConfigure = CrashScreenConfigure

    @property
    def BlackWhiteEdgeConfigure(self):
        r"""视频画面黑边、白边、黑屏、白屏检测的控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.BlackWhiteEdgeConfigureInfo`
        """
        return self._BlackWhiteEdgeConfigure

    @BlackWhiteEdgeConfigure.setter
    def BlackWhiteEdgeConfigure(self, BlackWhiteEdgeConfigure):
        self._BlackWhiteEdgeConfigure = BlackWhiteEdgeConfigure

    @property
    def NoiseConfigure(self):
        r"""视频画面噪点检测的控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.NoiseConfigureInfo`
        """
        return self._NoiseConfigure

    @NoiseConfigure.setter
    def NoiseConfigure(self, NoiseConfigure):
        self._NoiseConfigure = NoiseConfigure

    @property
    def MosaicConfigure(self):
        r"""视频画面马赛克检测的控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.MosaicConfigureInfo`
        """
        return self._MosaicConfigure

    @MosaicConfigure.setter
    def MosaicConfigure(self, MosaicConfigure):
        self._MosaicConfigure = MosaicConfigure

    @property
    def QRCodeConfigure(self):
        r"""视频画面二维码检测的控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.QRCodeConfigureInfo`
        """
        return self._QRCodeConfigure

    @QRCodeConfigure.setter
    def QRCodeConfigure(self, QRCodeConfigure):
        self._QRCodeConfigure = QRCodeConfigure

    @property
    def VoiceConfigure(self):
        r"""音频（静音、低音、爆音）检测的控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.VoiceConfigureInfo`
        """
        return self._VoiceConfigure

    @VoiceConfigure.setter
    def VoiceConfigure(self, VoiceConfigure):
        self._VoiceConfigure = VoiceConfigure

    @property
    def QualityEvaluationConfigure(self):
        r"""视频画面质量评价的控制参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.QualityEvaluationConfigureInfo`
        """
        return self._QualityEvaluationConfigure

    @QualityEvaluationConfigure.setter
    def QualityEvaluationConfigure(self, QualityEvaluationConfigure):
        self._QualityEvaluationConfigure = QualityEvaluationConfigure


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        self._ScreenshotInterval = params.get("ScreenshotInterval")
        if params.get("JitterConfigure") is not None:
            self._JitterConfigure = JitterConfigureInfo()
            self._JitterConfigure._deserialize(params.get("JitterConfigure"))
        if params.get("BlurConfigure") is not None:
            self._BlurConfigure = BlurConfigureInfo()
            self._BlurConfigure._deserialize(params.get("BlurConfigure"))
        if params.get("AbnormalLightingConfigure") is not None:
            self._AbnormalLightingConfigure = AbnormalLightingConfigureInfo()
            self._AbnormalLightingConfigure._deserialize(params.get("AbnormalLightingConfigure"))
        if params.get("CrashScreenConfigure") is not None:
            self._CrashScreenConfigure = CrashScreenConfigureInfo()
            self._CrashScreenConfigure._deserialize(params.get("CrashScreenConfigure"))
        if params.get("BlackWhiteEdgeConfigure") is not None:
            self._BlackWhiteEdgeConfigure = BlackWhiteEdgeConfigureInfo()
            self._BlackWhiteEdgeConfigure._deserialize(params.get("BlackWhiteEdgeConfigure"))
        if params.get("NoiseConfigure") is not None:
            self._NoiseConfigure = NoiseConfigureInfo()
            self._NoiseConfigure._deserialize(params.get("NoiseConfigure"))
        if params.get("MosaicConfigure") is not None:
            self._MosaicConfigure = MosaicConfigureInfo()
            self._MosaicConfigure._deserialize(params.get("MosaicConfigure"))
        if params.get("QRCodeConfigure") is not None:
            self._QRCodeConfigure = QRCodeConfigureInfo()
            self._QRCodeConfigure._deserialize(params.get("QRCodeConfigure"))
        if params.get("VoiceConfigure") is not None:
            self._VoiceConfigure = VoiceConfigureInfo()
            self._VoiceConfigure._deserialize(params.get("VoiceConfigure"))
        if params.get("QualityEvaluationConfigure") is not None:
            self._QualityEvaluationConfigure = QualityEvaluationConfigureInfo()
            self._QualityEvaluationConfigure._deserialize(params.get("QualityEvaluationConfigure"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateQualityInspectTemplateResponse(AbstractModel):
    r"""CreateQualityInspectTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 音画质检测模板 ID。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""音画质检测模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateRebuildMediaTemplateRequest(AbstractModel):
    r"""CreateRebuildMediaTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Container: 输出文件封装格式，可选值：mp4、flv、hls。
        :type Container: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Name: 音画质重生模板名称。
        :type Name: str
        :param _Comment: 模板描述。
        :type Comment: str
        :param _RebuildVideoInfo: 音画质重生视频控制控制信息。
        :type RebuildVideoInfo: :class:`tencentcloud.vod.v20180717.models.RebuildVideoInfo`
        :param _RebuildAudioInfo: 音画质重生音频控制控制信息。
        :type RebuildAudioInfo: :class:`tencentcloud.vod.v20180717.models.RebuildAudioInfo`
        :param _TargetVideoInfo: 输出目标视频控制信息。
        :type TargetVideoInfo: :class:`tencentcloud.vod.v20180717.models.RebuildMediaTargetVideoStream`
        :param _TargetAudioInfo: 输出目标音频控制信息。
        :type TargetAudioInfo: :class:`tencentcloud.vod.v20180717.models.RebuildMediaTargetAudioStream`
        :param _RemoveVideo: 是否去除视频数据，可选值：
<li>0：保留</li>
<li>1：去除</li>
默认值 0。
        :type RemoveVideo: int
        :param _RemoveAudio: 是否去除音频数据，可选值：
<li>0：保留</li>
<li>1：去除</li>
默认值 0。
        :type RemoveAudio: str
        """
        self._Container = None
        self._SubAppId = None
        self._Name = None
        self._Comment = None
        self._RebuildVideoInfo = None
        self._RebuildAudioInfo = None
        self._TargetVideoInfo = None
        self._TargetAudioInfo = None
        self._RemoveVideo = None
        self._RemoveAudio = None

    @property
    def Container(self):
        r"""输出文件封装格式，可选值：mp4、flv、hls。
        :rtype: str
        """
        return self._Container

    @Container.setter
    def Container(self, Container):
        self._Container = Container

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Name(self):
        r"""音画质重生模板名称。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        r"""模板描述。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def RebuildVideoInfo(self):
        r"""音画质重生视频控制控制信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.RebuildVideoInfo`
        """
        return self._RebuildVideoInfo

    @RebuildVideoInfo.setter
    def RebuildVideoInfo(self, RebuildVideoInfo):
        self._RebuildVideoInfo = RebuildVideoInfo

    @property
    def RebuildAudioInfo(self):
        r"""音画质重生音频控制控制信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.RebuildAudioInfo`
        """
        return self._RebuildAudioInfo

    @RebuildAudioInfo.setter
    def RebuildAudioInfo(self, RebuildAudioInfo):
        self._RebuildAudioInfo = RebuildAudioInfo

    @property
    def TargetVideoInfo(self):
        r"""输出目标视频控制信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.RebuildMediaTargetVideoStream`
        """
        return self._TargetVideoInfo

    @TargetVideoInfo.setter
    def TargetVideoInfo(self, TargetVideoInfo):
        self._TargetVideoInfo = TargetVideoInfo

    @property
    def TargetAudioInfo(self):
        r"""输出目标音频控制信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.RebuildMediaTargetAudioStream`
        """
        return self._TargetAudioInfo

    @TargetAudioInfo.setter
    def TargetAudioInfo(self, TargetAudioInfo):
        self._TargetAudioInfo = TargetAudioInfo

    @property
    def RemoveVideo(self):
        r"""是否去除视频数据，可选值：
<li>0：保留</li>
<li>1：去除</li>
默认值 0。
        :rtype: int
        """
        return self._RemoveVideo

    @RemoveVideo.setter
    def RemoveVideo(self, RemoveVideo):
        self._RemoveVideo = RemoveVideo

    @property
    def RemoveAudio(self):
        r"""是否去除音频数据，可选值：
<li>0：保留</li>
<li>1：去除</li>
默认值 0。
        :rtype: str
        """
        return self._RemoveAudio

    @RemoveAudio.setter
    def RemoveAudio(self, RemoveAudio):
        self._RemoveAudio = RemoveAudio


    def _deserialize(self, params):
        self._Container = params.get("Container")
        self._SubAppId = params.get("SubAppId")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("RebuildVideoInfo") is not None:
            self._RebuildVideoInfo = RebuildVideoInfo()
            self._RebuildVideoInfo._deserialize(params.get("RebuildVideoInfo"))
        if params.get("RebuildAudioInfo") is not None:
            self._RebuildAudioInfo = RebuildAudioInfo()
            self._RebuildAudioInfo._deserialize(params.get("RebuildAudioInfo"))
        if params.get("TargetVideoInfo") is not None:
            self._TargetVideoInfo = RebuildMediaTargetVideoStream()
            self._TargetVideoInfo._deserialize(params.get("TargetVideoInfo"))
        if params.get("TargetAudioInfo") is not None:
            self._TargetAudioInfo = RebuildMediaTargetAudioStream()
            self._TargetAudioInfo._deserialize(params.get("TargetAudioInfo"))
        self._RemoveVideo = params.get("RemoveVideo")
        self._RemoveAudio = params.get("RemoveAudio")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRebuildMediaTemplateResponse(AbstractModel):
    r"""CreateRebuildMediaTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 视频重生模板 ID。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""视频重生模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateReviewTemplateRequest(AbstractModel):
    r"""CreateReviewTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Labels: 需要返回的违规标签列表，可选值为：
<li>Porn：色情；</li>
<li>Terror：暴力；</li>
<li>Polity：不适宜的信息；</li>
<li>Illegal：违法；</li>
<li>Abuse：谩骂；</li>
<li>Ad：广告；</li>
<li>Moan：娇喘。</li>
        :type Labels: list of str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: str
        :param _Name: 审核模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Comment: 审核模板描述信息，长度限制：256 个字符。
        :type Comment: str
        """
        self._Labels = None
        self._SubAppId = None
        self._Name = None
        self._Comment = None

    @property
    def Labels(self):
        r"""需要返回的违规标签列表，可选值为：
<li>Porn：色情；</li>
<li>Terror：暴力；</li>
<li>Polity：不适宜的信息；</li>
<li>Illegal：违法；</li>
<li>Abuse：谩骂；</li>
<li>Ad：广告；</li>
<li>Moan：娇喘。</li>
        :rtype: list of str
        """
        return self._Labels

    @Labels.setter
    def Labels(self, Labels):
        self._Labels = Labels

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: str
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Name(self):
        r"""审核模板名称，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        r"""审核模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment


    def _deserialize(self, params):
        self._Labels = params.get("Labels")
        self._SubAppId = params.get("SubAppId")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateReviewTemplateResponse(AbstractModel):
    r"""CreateReviewTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 审核模板唯一标识。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""审核模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateRoundPlayRequest(AbstractModel):
    r"""CreateRoundPlay请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 启播时间，格式按照 ISO 8601标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#52)。
        :type StartTime: str
        :param _RoundPlaylist: 轮播列表。
<li>数组长度限制：100。</li>
        :type RoundPlaylist: list of RoundPlayListItemInfo
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Name: 轮播播单名称，长度限制：64 个字符。
        :type Name: str
        :param _Desc: 轮播播单描述信息，长度限制：256 个字符。
        :type Desc: str
        :param _PlayBackMode: 播放模式，可选值：
<li>Loop：循环播放播单；</li>
<li>Linear：单次播放，播单播放完停止播放。</li>
默认值：Loop。
        :type PlayBackMode: str
        :param _RoundPlayId: 播单唯一标识 ID，长度限制为64个字符，只允许包含大小写英文字母（a-zA-Z）、数字（0-9）和连字符（-）。如果存在相同 RoundPlayId 的播单，返回 InvalidParameterValue.RoundPlayAlreadyExists 错误。默认取值为空，表示由系统分配。
        :type RoundPlayId: str
        :param _ExpiredTime: 过期时间，格式按照 ISO 8601标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#52)。过期后的播单将停止播放，“9999-12-31T23:59:59+08:00”表示不过期。默认值：9999-12-31T23:59:59+08:00。
        :type ExpiredTime: str
        """
        self._StartTime = None
        self._RoundPlaylist = None
        self._SubAppId = None
        self._Name = None
        self._Desc = None
        self._PlayBackMode = None
        self._RoundPlayId = None
        self._ExpiredTime = None

    @property
    def StartTime(self):
        r"""启播时间，格式按照 ISO 8601标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#52)。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def RoundPlaylist(self):
        r"""轮播列表。
<li>数组长度限制：100。</li>
        :rtype: list of RoundPlayListItemInfo
        """
        return self._RoundPlaylist

    @RoundPlaylist.setter
    def RoundPlaylist(self, RoundPlaylist):
        self._RoundPlaylist = RoundPlaylist

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Name(self):
        r"""轮播播单名称，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Desc(self):
        r"""轮播播单描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Desc

    @Desc.setter
    def Desc(self, Desc):
        self._Desc = Desc

    @property
    def PlayBackMode(self):
        r"""播放模式，可选值：
<li>Loop：循环播放播单；</li>
<li>Linear：单次播放，播单播放完停止播放。</li>
默认值：Loop。
        :rtype: str
        """
        return self._PlayBackMode

    @PlayBackMode.setter
    def PlayBackMode(self, PlayBackMode):
        self._PlayBackMode = PlayBackMode

    @property
    def RoundPlayId(self):
        r"""播单唯一标识 ID，长度限制为64个字符，只允许包含大小写英文字母（a-zA-Z）、数字（0-9）和连字符（-）。如果存在相同 RoundPlayId 的播单，返回 InvalidParameterValue.RoundPlayAlreadyExists 错误。默认取值为空，表示由系统分配。
        :rtype: str
        """
        return self._RoundPlayId

    @RoundPlayId.setter
    def RoundPlayId(self, RoundPlayId):
        self._RoundPlayId = RoundPlayId

    @property
    def ExpiredTime(self):
        r"""过期时间，格式按照 ISO 8601标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#52)。过期后的播单将停止播放，“9999-12-31T23:59:59+08:00”表示不过期。默认值：9999-12-31T23:59:59+08:00。
        :rtype: str
        """
        return self._ExpiredTime

    @ExpiredTime.setter
    def ExpiredTime(self, ExpiredTime):
        self._ExpiredTime = ExpiredTime


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        if params.get("RoundPlaylist") is not None:
            self._RoundPlaylist = []
            for item in params.get("RoundPlaylist"):
                obj = RoundPlayListItemInfo()
                obj._deserialize(item)
                self._RoundPlaylist.append(obj)
        self._SubAppId = params.get("SubAppId")
        self._Name = params.get("Name")
        self._Desc = params.get("Desc")
        self._PlayBackMode = params.get("PlayBackMode")
        self._RoundPlayId = params.get("RoundPlayId")
        self._ExpiredTime = params.get("ExpiredTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRoundPlayResponse(AbstractModel):
    r"""CreateRoundPlay返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RoundPlayId: 轮播播单唯一标识。
        :type RoundPlayId: str
        :param _Url: 轮播播放地址。
        :type Url: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RoundPlayId = None
        self._Url = None
        self._RequestId = None

    @property
    def RoundPlayId(self):
        r"""轮播播单唯一标识。
        :rtype: str
        """
        return self._RoundPlayId

    @RoundPlayId.setter
    def RoundPlayId(self, RoundPlayId):
        self._RoundPlayId = RoundPlayId

    @property
    def Url(self):
        r"""轮播播放地址。
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RoundPlayId = params.get("RoundPlayId")
        self._Url = params.get("Url")
        self._RequestId = params.get("RequestId")


class CreateSampleSnapshotTemplateRequest(AbstractModel):
    r"""CreateSampleSnapshotTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SampleType: 采样截图类型，取值：
<li>Percent：按百分比。</li>
<li>Time：按时间间隔。</li>
        :type SampleType: str
        :param _SampleInterval: 采样间隔。
<li>当 SampleType 为 Percent 时，指定采样间隔的百分比。</li>
<li>当 SampleType 为 Time 时，指定采样间隔的时间，单位为秒。</li>
        :type SampleInterval: int
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Name: 采样截图模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Width: 截图宽度（或长边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Width: int
        :param _Height: 截图高度（或短边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Height: int
        :param _ResolutionAdaptive: 分辨率自适应，可选值：
<li>open：开启，此时，Width 代表视频的长边，Height 表示视频的短边；</li>
<li>close：关闭，此时，Width 代表视频的宽度，Height 表示视频的高度。</li>
默认值：open。
        :type ResolutionAdaptive: str
        :param _Format: 图片格式，取值为 jpg 和 png。默认为 jpg。
        :type Format: str
        :param _Comment: 模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _FillType: 填充方式，当视频流配置宽高参数与原始视频的宽高比不一致时，对转码的处理方式，即为“填充”。可选填充方式：
<li> stretch：拉伸，对每一帧进行拉伸，填满整个画面，可能导致转码后的视频被“压扁“或者“拉长“；</li>
<li>black：留黑，保持视频宽高比不变，边缘剩余部分使用黑色填充。</li>
<li>white：留白，保持视频宽高比不变，边缘剩余部分使用白色填充。</li>
<li>gauss：高斯模糊，保持视频宽高比不变，边缘剩余部分使用高斯模糊。</li>
默认值：black 。
        :type FillType: str
        """
        self._SampleType = None
        self._SampleInterval = None
        self._SubAppId = None
        self._Name = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._Format = None
        self._Comment = None
        self._FillType = None

    @property
    def SampleType(self):
        r"""采样截图类型，取值：
<li>Percent：按百分比。</li>
<li>Time：按时间间隔。</li>
        :rtype: str
        """
        return self._SampleType

    @SampleType.setter
    def SampleType(self, SampleType):
        self._SampleType = SampleType

    @property
    def SampleInterval(self):
        r"""采样间隔。
<li>当 SampleType 为 Percent 时，指定采样间隔的百分比。</li>
<li>当 SampleType 为 Time 时，指定采样间隔的时间，单位为秒。</li>
        :rtype: int
        """
        return self._SampleInterval

    @SampleInterval.setter
    def SampleInterval(self, SampleInterval):
        self._SampleInterval = SampleInterval

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Name(self):
        r"""采样截图模板名称，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Width(self):
        r"""截图宽度（或长边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :rtype: int
        """
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        r"""截图高度（或短边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :rtype: int
        """
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        r"""分辨率自适应，可选值：
<li>open：开启，此时，Width 代表视频的长边，Height 表示视频的短边；</li>
<li>close：关闭，此时，Width 代表视频的宽度，Height 表示视频的高度。</li>
默认值：open。
        :rtype: str
        """
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def Format(self):
        r"""图片格式，取值为 jpg 和 png。默认为 jpg。
        :rtype: str
        """
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def Comment(self):
        r"""模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def FillType(self):
        r"""填充方式，当视频流配置宽高参数与原始视频的宽高比不一致时，对转码的处理方式，即为“填充”。可选填充方式：
<li> stretch：拉伸，对每一帧进行拉伸，填满整个画面，可能导致转码后的视频被“压扁“或者“拉长“；</li>
<li>black：留黑，保持视频宽高比不变，边缘剩余部分使用黑色填充。</li>
<li>white：留白，保持视频宽高比不变，边缘剩余部分使用白色填充。</li>
<li>gauss：高斯模糊，保持视频宽高比不变，边缘剩余部分使用高斯模糊。</li>
默认值：black 。
        :rtype: str
        """
        return self._FillType

    @FillType.setter
    def FillType(self, FillType):
        self._FillType = FillType


    def _deserialize(self, params):
        self._SampleType = params.get("SampleType")
        self._SampleInterval = params.get("SampleInterval")
        self._SubAppId = params.get("SubAppId")
        self._Name = params.get("Name")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._Format = params.get("Format")
        self._Comment = params.get("Comment")
        self._FillType = params.get("FillType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSampleSnapshotTemplateResponse(AbstractModel):
    r"""CreateSampleSnapshotTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 采样截图模板唯一标识。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""采样截图模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateSceneAigcImageTaskRequest(AbstractModel):
    r"""CreateSceneAigcImageTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: **点播应用 ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。**
        :type SubAppId: int
        :param _SceneInfo: 场景化生图参数配置。
        :type SceneInfo: :class:`tencentcloud.vod.v20180717.models.AigcImageSceneInfo`
        :param _FileInfos: 输入图片列表，支持的图片格式：jpg、jpeg、png、webp。不同的场景需要不同的输入数据：

- AI换衣场景：只能输入 1 张**模特**图片。
- AI生商品图场景：需输入 1～10 张**同一产品**的不同角度的图片
        :type FileInfos: list of SceneAigcImageTaskInputFileInfo
        :param _OutputConfig: 场景化生图任务的输出媒体文件配置。
        :type OutputConfig: :class:`tencentcloud.vod.v20180717.models.SceneAigcImageOutputConfig`
        :param _SessionId: 用于去重的识别码，如果三天内曾有过相同的识别码的请求，则本次的请求会返回错误。最长 50 个字符，不带或者带空字符串表示不做去重。
        :type SessionId: str
        :param _SessionContext: 来源上下文，用于透传用户请求信息，音画质重生完成回调将返回该字段值，最长 1000 个字符。
        :type SessionContext: str
        :param _TasksPriority: 任务的优先级，数值越大优先级越高，取值范围是 -10 到 10，不填代表 0。
        :type TasksPriority: int
        :param _ExtInfo: 保留字段，特殊用途时使用。
        :type ExtInfo: str
        """
        self._SubAppId = None
        self._SceneInfo = None
        self._FileInfos = None
        self._OutputConfig = None
        self._SessionId = None
        self._SessionContext = None
        self._TasksPriority = None
        self._ExtInfo = None

    @property
    def SubAppId(self):
        r"""**点播应用 ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。**
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def SceneInfo(self):
        r"""场景化生图参数配置。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AigcImageSceneInfo`
        """
        return self._SceneInfo

    @SceneInfo.setter
    def SceneInfo(self, SceneInfo):
        self._SceneInfo = SceneInfo

    @property
    def FileInfos(self):
        r"""输入图片列表，支持的图片格式：jpg、jpeg、png、webp。不同的场景需要不同的输入数据：

- AI换衣场景：只能输入 1 张**模特**图片。
- AI生商品图场景：需输入 1～10 张**同一产品**的不同角度的图片
        :rtype: list of SceneAigcImageTaskInputFileInfo
        """
        return self._FileInfos

    @FileInfos.setter
    def FileInfos(self, FileInfos):
        self._FileInfos = FileInfos

    @property
    def OutputConfig(self):
        r"""场景化生图任务的输出媒体文件配置。
        :rtype: :class:`tencentcloud.vod.v20180717.models.SceneAigcImageOutputConfig`
        """
        return self._OutputConfig

    @OutputConfig.setter
    def OutputConfig(self, OutputConfig):
        self._OutputConfig = OutputConfig

    @property
    def SessionId(self):
        r"""用于去重的识别码，如果三天内曾有过相同的识别码的请求，则本次的请求会返回错误。最长 50 个字符，不带或者带空字符串表示不做去重。
        :rtype: str
        """
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def SessionContext(self):
        r"""来源上下文，用于透传用户请求信息，音画质重生完成回调将返回该字段值，最长 1000 个字符。
        :rtype: str
        """
        return self._SessionContext

    @SessionContext.setter
    def SessionContext(self, SessionContext):
        self._SessionContext = SessionContext

    @property
    def TasksPriority(self):
        r"""任务的优先级，数值越大优先级越高，取值范围是 -10 到 10，不填代表 0。
        :rtype: int
        """
        return self._TasksPriority

    @TasksPriority.setter
    def TasksPriority(self, TasksPriority):
        self._TasksPriority = TasksPriority

    @property
    def ExtInfo(self):
        r"""保留字段，特殊用途时使用。
        :rtype: str
        """
        return self._ExtInfo

    @ExtInfo.setter
    def ExtInfo(self, ExtInfo):
        self._ExtInfo = ExtInfo


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        if params.get("SceneInfo") is not None:
            self._SceneInfo = AigcImageSceneInfo()
            self._SceneInfo._deserialize(params.get("SceneInfo"))
        if params.get("FileInfos") is not None:
            self._FileInfos = []
            for item in params.get("FileInfos"):
                obj = SceneAigcImageTaskInputFileInfo()
                obj._deserialize(item)
                self._FileInfos.append(obj)
        if params.get("OutputConfig") is not None:
            self._OutputConfig = SceneAigcImageOutputConfig()
            self._OutputConfig._deserialize(params.get("OutputConfig"))
        self._SessionId = params.get("SessionId")
        self._SessionContext = params.get("SessionContext")
        self._TasksPriority = params.get("TasksPriority")
        self._ExtInfo = params.get("ExtInfo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSceneAigcImageTaskResponse(AbstractModel):
    r"""CreateSceneAigcImageTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务 ID。
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        r"""任务 ID。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class CreateSnapshotByTimeOffsetTemplateRequest(AbstractModel):
    r"""CreateSnapshotByTimeOffsetTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Name: 指定时间点截图模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Width: 截图宽度（或长边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Width: int
        :param _Height: 截图高度（或短边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Height: int
        :param _ResolutionAdaptive: 分辨率自适应，可选值：
<li>open：开启，此时，Width 代表视频的长边，Height 表示视频的短边；</li>
<li>close：关闭，此时，Width 代表视频的宽度，Height 表示视频的高度。</li>
默认值：open。
        :type ResolutionAdaptive: str
        :param _Format: 图片格式，取值可以为 jpg 和 png。默认为 jpg。
        :type Format: str
        :param _Comment: 模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _FillType: 填充方式，当视频流配置宽高参数与原始视频的宽高比不一致时，对转码的处理方式，即为“填充”。可选填充方式：
<li> stretch：拉伸，对每一帧进行拉伸，填满整个画面，可能导致转码后的视频被“压扁“或者“拉长“；</li>
<li>black：留黑，保持视频宽高比不变，边缘剩余部分使用黑色填充。</li>
<li>white：留白，保持视频宽高比不变，边缘剩余部分使用白色填充。</li>
<li>gauss：高斯模糊，保持视频宽高比不变，边缘剩余部分使用高斯模糊。</li>
默认值：black 。
        :type FillType: str
        """
        self._SubAppId = None
        self._Name = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._Format = None
        self._Comment = None
        self._FillType = None

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Name(self):
        r"""指定时间点截图模板名称，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Width(self):
        r"""截图宽度（或长边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :rtype: int
        """
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        r"""截图高度（或短边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :rtype: int
        """
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        r"""分辨率自适应，可选值：
<li>open：开启，此时，Width 代表视频的长边，Height 表示视频的短边；</li>
<li>close：关闭，此时，Width 代表视频的宽度，Height 表示视频的高度。</li>
默认值：open。
        :rtype: str
        """
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def Format(self):
        r"""图片格式，取值可以为 jpg 和 png。默认为 jpg。
        :rtype: str
        """
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def Comment(self):
        r"""模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def FillType(self):
        r"""填充方式，当视频流配置宽高参数与原始视频的宽高比不一致时，对转码的处理方式，即为“填充”。可选填充方式：
<li> stretch：拉伸，对每一帧进行拉伸，填满整个画面，可能导致转码后的视频被“压扁“或者“拉长“；</li>
<li>black：留黑，保持视频宽高比不变，边缘剩余部分使用黑色填充。</li>
<li>white：留白，保持视频宽高比不变，边缘剩余部分使用白色填充。</li>
<li>gauss：高斯模糊，保持视频宽高比不变，边缘剩余部分使用高斯模糊。</li>
默认值：black 。
        :rtype: str
        """
        return self._FillType

    @FillType.setter
    def FillType(self, FillType):
        self._FillType = FillType


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Name = params.get("Name")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._Format = params.get("Format")
        self._Comment = params.get("Comment")
        self._FillType = params.get("FillType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSnapshotByTimeOffsetTemplateResponse(AbstractModel):
    r"""CreateSnapshotByTimeOffsetTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 时间点截图模板唯一标识。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""时间点截图模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateStorageRegionRequest(AbstractModel):
    r"""CreateStorageRegion请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StorageRegion: 待开通的存储地域，必须是系统支持的地域。
        :type StorageRegion: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._StorageRegion = None
        self._SubAppId = None

    @property
    def StorageRegion(self):
        r"""待开通的存储地域，必须是系统支持的地域。
        :rtype: str
        """
        return self._StorageRegion

    @StorageRegion.setter
    def StorageRegion(self, StorageRegion):
        self._StorageRegion = StorageRegion

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._StorageRegion = params.get("StorageRegion")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateStorageRegionResponse(AbstractModel):
    r"""CreateStorageRegion返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateSubAppIdRequest(AbstractModel):
    r"""CreateSubAppId请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 应用名称，长度限制：40个字符。
        :type Name: str
        :param _Description: 应用简介，长度限制： 300个字符。不填则应用简介默认为空。
        :type Description: str
        :param _Type: 应用类型， 取值有：<li>AllInOne：一体化；</li><li>Professional：专业版。</li>默认值为 AllInOne。
        :type Type: str
        """
        self._Name = None
        self._Description = None
        self._Type = None

    @property
    def Name(self):
        r"""应用名称，长度限制：40个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Description(self):
        r"""应用简介，长度限制： 300个字符。不填则应用简介默认为空。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Type(self):
        r"""应用类型， 取值有：<li>AllInOne：一体化；</li><li>Professional：专业版。</li>默认值为 AllInOne。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Description = params.get("Description")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSubAppIdResponse(AbstractModel):
    r"""CreateSubAppId返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: 新创建的应用 ID。
        :type SubAppId: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SubAppId = None
        self._RequestId = None

    @property
    def SubAppId(self):
        r"""新创建的应用 ID。
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._RequestId = params.get("RequestId")


class CreateSuperPlayerConfigRequest(AbstractModel):
    r"""CreateSuperPlayerConfig请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 播放器配置名称，长度限制：64 个字符。只允许出现 [0-9a-zA-Z] 及 _- 字符（如 test_ABC-123），同一个用户该名称唯一。
        :type Name: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _AudioVideoType: 播放的音视频类型，可选值：
<li>AdaptiveDynamicStream：自适应码流输出；</li>
<li>Transcode：转码输出；</li>
<li>Original：原始音视频。</li>
默认为 AdaptiveDynamicStream。
        :type AudioVideoType: str
        :param _DrmSwitch: 播放 DRM 保护的自适应码流开关：
<li>ON：开启，表示仅播放 DRM  保护的自适应码流输出；</li>
<li>OFF：关闭，表示播放未加密的自适应码流输出。</li>
默认为 OFF。
当 AudioVideoType 为 AdaptiveDynamicStream 时，此参数有效。
        :type DrmSwitch: str
        :param _AdaptiveDynamicStreamingDefinition: 允许输出的未加密的自适应码流模板 ID。

当 AudioVideoType 为 AdaptiveDynamicStream 并且 DrmSwitch 为 OFF 时，此参数为必填。
        :type AdaptiveDynamicStreamingDefinition: int
        :param _DrmStreamingsInfo: 允许输出的 DRM 自适应码流模板内容。

当 AudioVideoType 为 AdaptiveDynamicStream 并且 DrmSwitch 为 ON 时，此参数为必填。
        :type DrmStreamingsInfo: :class:`tencentcloud.vod.v20180717.models.DrmStreamingsInfo`
        :param _TranscodeDefinition: 允许输出的转码模板 ID。

当 AudioVideoType 为 Transcode 时必填。
        :type TranscodeDefinition: int
        :param _ImageSpriteDefinition: 允许输出的雪碧图模板 ID。
        :type ImageSpriteDefinition: int
        :param _ResolutionNames: 播放器对于不同分辨率的子流展示名字，不填或者填空数组则使用默认配置：
<li>MinEdgeLength：240，Name：流畅；</li>
<li>MinEdgeLength：480，Name：标清；</li>
<li>MinEdgeLength：720，Name：高清；</li>
<li>MinEdgeLength：1080，Name：全高清；</li>
<li>MinEdgeLength：1440，Name：2K；</li>
<li>MinEdgeLength：2160，Name：4K；</li>
<li>MinEdgeLength：4320，Name：8K。</li>
        :type ResolutionNames: list of ResolutionNameInfo
        :param _Domain: 播放时使用的域名。不填或者填 Default，表示使用[默认分发配置](https://cloud.tencent.com/document/product/266/33373)中的域名。
        :type Domain: str
        :param _Scheme: 播放时使用的 Scheme。不填或者填 Default，表示使用[默认分发配置](https://cloud.tencent.com/document/product/266/33373)中的 Scheme。其他可选值：
<li>HTTP；</li>
<li>HTTPS。</li>
        :type Scheme: str
        :param _Comment: 模板描述信息，长度限制：256 个字符。
        :type Comment: str
        """
        self._Name = None
        self._SubAppId = None
        self._AudioVideoType = None
        self._DrmSwitch = None
        self._AdaptiveDynamicStreamingDefinition = None
        self._DrmStreamingsInfo = None
        self._TranscodeDefinition = None
        self._ImageSpriteDefinition = None
        self._ResolutionNames = None
        self._Domain = None
        self._Scheme = None
        self._Comment = None

    @property
    def Name(self):
        r"""播放器配置名称，长度限制：64 个字符。只允许出现 [0-9a-zA-Z] 及 _- 字符（如 test_ABC-123），同一个用户该名称唯一。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def AudioVideoType(self):
        r"""播放的音视频类型，可选值：
<li>AdaptiveDynamicStream：自适应码流输出；</li>
<li>Transcode：转码输出；</li>
<li>Original：原始音视频。</li>
默认为 AdaptiveDynamicStream。
        :rtype: str
        """
        return self._AudioVideoType

    @AudioVideoType.setter
    def AudioVideoType(self, AudioVideoType):
        self._AudioVideoType = AudioVideoType

    @property
    def DrmSwitch(self):
        r"""播放 DRM 保护的自适应码流开关：
<li>ON：开启，表示仅播放 DRM  保护的自适应码流输出；</li>
<li>OFF：关闭，表示播放未加密的自适应码流输出。</li>
默认为 OFF。
当 AudioVideoType 为 AdaptiveDynamicStream 时，此参数有效。
        :rtype: str
        """
        return self._DrmSwitch

    @DrmSwitch.setter
    def DrmSwitch(self, DrmSwitch):
        self._DrmSwitch = DrmSwitch

    @property
    def AdaptiveDynamicStreamingDefinition(self):
        r"""允许输出的未加密的自适应码流模板 ID。

当 AudioVideoType 为 AdaptiveDynamicStream 并且 DrmSwitch 为 OFF 时，此参数为必填。
        :rtype: int
        """
        return self._AdaptiveDynamicStreamingDefinition

    @AdaptiveDynamicStreamingDefinition.setter
    def AdaptiveDynamicStreamingDefinition(self, AdaptiveDynamicStreamingDefinition):
        self._AdaptiveDynamicStreamingDefinition = AdaptiveDynamicStreamingDefinition

    @property
    def DrmStreamingsInfo(self):
        r"""允许输出的 DRM 自适应码流模板内容。

当 AudioVideoType 为 AdaptiveDynamicStream 并且 DrmSwitch 为 ON 时，此参数为必填。
        :rtype: :class:`tencentcloud.vod.v20180717.models.DrmStreamingsInfo`
        """
        return self._DrmStreamingsInfo

    @DrmStreamingsInfo.setter
    def DrmStreamingsInfo(self, DrmStreamingsInfo):
        self._DrmStreamingsInfo = DrmStreamingsInfo

    @property
    def TranscodeDefinition(self):
        r"""允许输出的转码模板 ID。

当 AudioVideoType 为 Transcode 时必填。
        :rtype: int
        """
        return self._TranscodeDefinition

    @TranscodeDefinition.setter
    def TranscodeDefinition(self, TranscodeDefinition):
        self._TranscodeDefinition = TranscodeDefinition

    @property
    def ImageSpriteDefinition(self):
        r"""允许输出的雪碧图模板 ID。
        :rtype: int
        """
        return self._ImageSpriteDefinition

    @ImageSpriteDefinition.setter
    def ImageSpriteDefinition(self, ImageSpriteDefinition):
        self._ImageSpriteDefinition = ImageSpriteDefinition

    @property
    def ResolutionNames(self):
        r"""播放器对于不同分辨率的子流展示名字，不填或者填空数组则使用默认配置：
<li>MinEdgeLength：240，Name：流畅；</li>
<li>MinEdgeLength：480，Name：标清；</li>
<li>MinEdgeLength：720，Name：高清；</li>
<li>MinEdgeLength：1080，Name：全高清；</li>
<li>MinEdgeLength：1440，Name：2K；</li>
<li>MinEdgeLength：2160，Name：4K；</li>
<li>MinEdgeLength：4320，Name：8K。</li>
        :rtype: list of ResolutionNameInfo
        """
        return self._ResolutionNames

    @ResolutionNames.setter
    def ResolutionNames(self, ResolutionNames):
        self._ResolutionNames = ResolutionNames

    @property
    def Domain(self):
        r"""播放时使用的域名。不填或者填 Default，表示使用[默认分发配置](https://cloud.tencent.com/document/product/266/33373)中的域名。
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Scheme(self):
        r"""播放时使用的 Scheme。不填或者填 Default，表示使用[默认分发配置](https://cloud.tencent.com/document/product/266/33373)中的 Scheme。其他可选值：
<li>HTTP；</li>
<li>HTTPS。</li>
        :rtype: str
        """
        return self._Scheme

    @Scheme.setter
    def Scheme(self, Scheme):
        self._Scheme = Scheme

    @property
    def Comment(self):
        r"""模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._SubAppId = params.get("SubAppId")
        self._AudioVideoType = params.get("AudioVideoType")
        self._DrmSwitch = params.get("DrmSwitch")
        self._AdaptiveDynamicStreamingDefinition = params.get("AdaptiveDynamicStreamingDefinition")
        if params.get("DrmStreamingsInfo") is not None:
            self._DrmStreamingsInfo = DrmStreamingsInfo()
            self._DrmStreamingsInfo._deserialize(params.get("DrmStreamingsInfo"))
        self._TranscodeDefinition = params.get("TranscodeDefinition")
        self._ImageSpriteDefinition = params.get("ImageSpriteDefinition")
        if params.get("ResolutionNames") is not None:
            self._ResolutionNames = []
            for item in params.get("ResolutionNames"):
                obj = ResolutionNameInfo()
                obj._deserialize(item)
                self._ResolutionNames.append(obj)
        self._Domain = params.get("Domain")
        self._Scheme = params.get("Scheme")
        self._Comment = params.get("Comment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSuperPlayerConfigResponse(AbstractModel):
    r"""CreateSuperPlayerConfig返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateTranscodeTemplateRequest(AbstractModel):
    r"""CreateTranscodeTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Container: 封装格式，可选值：mp4、flv、hls、mp3、flac、ogg、m4a、wav。其中，mp3、flac、ogg、m4a、wav 为纯音频文件。
        :type Container: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Name: 转码模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Comment: 模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _RemoveVideo: 是否去除视频数据，可选值：
<li>0：保留</li>
<li>1：去除</li>
默认值：0。
        :type RemoveVideo: int
        :param _RemoveAudio: 是否去除音频数据，可选值：
<li>0：保留</li>
<li>1：去除</li>
默认值：0。
        :type RemoveAudio: int
        :param _VideoTemplate: 视频流配置参数，当 RemoveVideo 为 0，该字段必填。
        :type VideoTemplate: :class:`tencentcloud.vod.v20180717.models.VideoTemplateInfo`
        :param _AudioTemplate: 音频流配置参数，当 RemoveAudio 为 0，该字段必填。
        :type AudioTemplate: :class:`tencentcloud.vod.v20180717.models.AudioTemplateInfo`
        :param _TEHDConfig: 极速高清转码参数。
        :type TEHDConfig: :class:`tencentcloud.vod.v20180717.models.TEHDConfig`
        :param _EnhanceConfig: 音视频增强配置。
        :type EnhanceConfig: :class:`tencentcloud.vod.v20180717.models.EnhanceConfig`
        :param _SegmentType: 切片类型，当 Container 为 hls 时有效，可选值：
<li>ts：ts 切片；</li>
<li>fmp4：fmp4 切片。</li>
默认值：ts。
        :type SegmentType: str
        """
        self._Container = None
        self._SubAppId = None
        self._Name = None
        self._Comment = None
        self._RemoveVideo = None
        self._RemoveAudio = None
        self._VideoTemplate = None
        self._AudioTemplate = None
        self._TEHDConfig = None
        self._EnhanceConfig = None
        self._SegmentType = None

    @property
    def Container(self):
        r"""封装格式，可选值：mp4、flv、hls、mp3、flac、ogg、m4a、wav。其中，mp3、flac、ogg、m4a、wav 为纯音频文件。
        :rtype: str
        """
        return self._Container

    @Container.setter
    def Container(self, Container):
        self._Container = Container

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Name(self):
        r"""转码模板名称，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        r"""模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def RemoveVideo(self):
        r"""是否去除视频数据，可选值：
<li>0：保留</li>
<li>1：去除</li>
默认值：0。
        :rtype: int
        """
        return self._RemoveVideo

    @RemoveVideo.setter
    def RemoveVideo(self, RemoveVideo):
        self._RemoveVideo = RemoveVideo

    @property
    def RemoveAudio(self):
        r"""是否去除音频数据，可选值：
<li>0：保留</li>
<li>1：去除</li>
默认值：0。
        :rtype: int
        """
        return self._RemoveAudio

    @RemoveAudio.setter
    def RemoveAudio(self, RemoveAudio):
        self._RemoveAudio = RemoveAudio

    @property
    def VideoTemplate(self):
        r"""视频流配置参数，当 RemoveVideo 为 0，该字段必填。
        :rtype: :class:`tencentcloud.vod.v20180717.models.VideoTemplateInfo`
        """
        return self._VideoTemplate

    @VideoTemplate.setter
    def VideoTemplate(self, VideoTemplate):
        self._VideoTemplate = VideoTemplate

    @property
    def AudioTemplate(self):
        r"""音频流配置参数，当 RemoveAudio 为 0，该字段必填。
        :rtype: :class:`tencentcloud.vod.v20180717.models.AudioTemplateInfo`
        """
        return self._AudioTemplate

    @AudioTemplate.setter
    def AudioTemplate(self, AudioTemplate):
        self._AudioTemplate = AudioTemplate

    @property
    def TEHDConfig(self):
        r"""极速高清转码参数。
        :rtype: :class:`tencentcloud.vod.v20180717.models.TEHDConfig`
        """
        return self._TEHDConfig

    @TEHDConfig.setter
    def TEHDConfig(self, TEHDConfig):
        self._TEHDConfig = TEHDConfig

    @property
    def EnhanceConfig(self):
        r"""音视频增强配置。
        :rtype: :class:`tencentcloud.vod.v20180717.models.EnhanceConfig`
        """
        return self._EnhanceConfig

    @EnhanceConfig.setter
    def EnhanceConfig(self, EnhanceConfig):
        self._EnhanceConfig = EnhanceConfig

    @property
    def SegmentType(self):
        r"""切片类型，当 Container 为 hls 时有效，可选值：
<li>ts：ts 切片；</li>
<li>fmp4：fmp4 切片。</li>
默认值：ts。
        :rtype: str
        """
        return self._SegmentType

    @SegmentType.setter
    def SegmentType(self, SegmentType):
        self._SegmentType = SegmentType


    def _deserialize(self, params):
        self._Container = params.get("Container")
        self._SubAppId = params.get("SubAppId")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        self._RemoveVideo = params.get("RemoveVideo")
        self._RemoveAudio = params.get("RemoveAudio")
        if params.get("VideoTemplate") is not None:
            self._VideoTemplate = VideoTemplateInfo()
            self._VideoTemplate._deserialize(params.get("VideoTemplate"))
        if params.get("AudioTemplate") is not None:
            self._AudioTemplate = AudioTemplateInfo()
            self._AudioTemplate._deserialize(params.get("AudioTemplate"))
        if params.get("TEHDConfig") is not None:
            self._TEHDConfig = TEHDConfig()
            self._TEHDConfig._deserialize(params.get("TEHDConfig"))
        if params.get("EnhanceConfig") is not None:
            self._EnhanceConfig = EnhanceConfig()
            self._EnhanceConfig._deserialize(params.get("EnhanceConfig"))
        self._SegmentType = params.get("SegmentType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTranscodeTemplateResponse(AbstractModel):
    r"""CreateTranscodeTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 转码模板唯一标识。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""转码模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateVodDomainRequest(AbstractModel):
    r"""CreateVodDomain请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 需要接入点播的加速域名。注意：不支持填写泛域名。
        :type Domain: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _AccelerateArea: 需要开启 CDN 加速的区域：
<li>Chinese Mainland：中国境内（不包含港澳台）。</li>
<li>Outside Chinese Mainland: 中国境外。</li>
<li>Global: 全球范围。</li>
如果没有设置 AccelerateArea， 点播会根据用户在腾讯云设置的地域信息自动开通中国境内或者中国境外的 CDN 加速。开启中国境内加速的域名，需要先[备案域名](/document/product/243/18905)。
        :type AccelerateArea: str
        :param _Type: 域名类型，取值有： <li>VOD：使用 VOD 产品分发的域名；</li> <li>EdgeOne：使用 EdgeOne 产品分发的域名。</li>不填默认取值为 VOD 。
        :type Type: str
        """
        self._Domain = None
        self._SubAppId = None
        self._AccelerateArea = None
        self._Type = None

    @property
    def Domain(self):
        r"""需要接入点播的加速域名。注意：不支持填写泛域名。
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def AccelerateArea(self):
        r"""需要开启 CDN 加速的区域：
<li>Chinese Mainland：中国境内（不包含港澳台）。</li>
<li>Outside Chinese Mainland: 中国境外。</li>
<li>Global: 全球范围。</li>
如果没有设置 AccelerateArea， 点播会根据用户在腾讯云设置的地域信息自动开通中国境内或者中国境外的 CDN 加速。开启中国境内加速的域名，需要先[备案域名](/document/product/243/18905)。
        :rtype: str
        """
        return self._AccelerateArea

    @AccelerateArea.setter
    def AccelerateArea(self, AccelerateArea):
        self._AccelerateArea = AccelerateArea

    @property
    def Type(self):
        r"""域名类型，取值有： <li>VOD：使用 VOD 产品分发的域名；</li> <li>EdgeOne：使用 EdgeOne 产品分发的域名。</li>不填默认取值为 VOD 。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._SubAppId = params.get("SubAppId")
        self._AccelerateArea = params.get("AccelerateArea")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVodDomainResponse(AbstractModel):
    r"""CreateVodDomain返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateWatermarkTemplateRequest(AbstractModel):
    r"""CreateWatermarkTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Type: 水印类型，可选值：
<li>image：图片水印；</li>
<li>text：文字水印；</li>
<li>svg：SVG 水印。</li>
        :type Type: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Name: 水印模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Comment: 模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _CoordinateOrigin: 原点位置，可选值：
<li>TopLeft：表示坐标原点位于视频图像左上角，水印原点为图片或文字的左上角；</li>
<li>TopRight：表示坐标原点位于视频图像的右上角，水印原点为图片或文字的右上角；</li>
<li>BottomLeft：表示坐标原点位于视频图像的左下角，水印原点为图片或文字的左下角；</li>
<li>BottomRight：表示坐标原点位于视频图像的右下角，水印原点为图片或文字的右下角。</li>
默认值：TopLeft。
        :type CoordinateOrigin: str
        :param _XPos: 水印原点距离视频图像坐标原点的水平位置。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示水印 XPos 为视频宽度指定百分比，如 10% 表示 XPos 为视频宽度的 10%；</li>
<li>当字符串以 px 结尾，表示水印 XPos 为指定像素，如 100px 表示 XPos 为 100 像素。</li>
默认值：0px。
        :type XPos: str
        :param _YPos: 水印原点距离视频图像坐标原点的垂直位置。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示水印 YPos 为视频高度指定百分比，如 10% 表示 YPos 为视频高度的 10%；</li>
<li>当字符串以 px 结尾，表示水印 YPos 为指定像素，如 100px 表示 YPos 为 100 像素。</li>
默认值：0px。
        :type YPos: str
        :param _ImageTemplate: 图片水印模板，当 Type 为 image，该字段必填。当 Type 为 text，该字段无效。
        :type ImageTemplate: :class:`tencentcloud.vod.v20180717.models.ImageWatermarkInput`
        :param _TextTemplate: 文字水印模板，当 Type 为 text，该字段必填。当 Type 为 image，该字段无效。
        :type TextTemplate: :class:`tencentcloud.vod.v20180717.models.TextWatermarkTemplateInput`
        :param _SvgTemplate: SVG水印模板，当 Type 为 svg，该字段必填。当 Type 为 image 或 text，该字段无效。
        :type SvgTemplate: :class:`tencentcloud.vod.v20180717.models.SvgWatermarkInput`
        """
        self._Type = None
        self._SubAppId = None
        self._Name = None
        self._Comment = None
        self._CoordinateOrigin = None
        self._XPos = None
        self._YPos = None
        self._ImageTemplate = None
        self._TextTemplate = None
        self._SvgTemplate = None

    @property
    def Type(self):
        r"""水印类型，可选值：
<li>image：图片水印；</li>
<li>text：文字水印；</li>
<li>svg：SVG 水印。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Name(self):
        r"""水印模板名称，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        r"""模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def CoordinateOrigin(self):
        r"""原点位置，可选值：
<li>TopLeft：表示坐标原点位于视频图像左上角，水印原点为图片或文字的左上角；</li>
<li>TopRight：表示坐标原点位于视频图像的右上角，水印原点为图片或文字的右上角；</li>
<li>BottomLeft：表示坐标原点位于视频图像的左下角，水印原点为图片或文字的左下角；</li>
<li>BottomRight：表示坐标原点位于视频图像的右下角，水印原点为图片或文字的右下角。</li>
默认值：TopLeft。
        :rtype: str
        """
        return self._CoordinateOrigin

    @CoordinateOrigin.setter
    def CoordinateOrigin(self, CoordinateOrigin):
        self._CoordinateOrigin = CoordinateOrigin

    @property
    def XPos(self):
        r"""水印原点距离视频图像坐标原点的水平位置。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示水印 XPos 为视频宽度指定百分比，如 10% 表示 XPos 为视频宽度的 10%；</li>
<li>当字符串以 px 结尾，表示水印 XPos 为指定像素，如 100px 表示 XPos 为 100 像素。</li>
默认值：0px。
        :rtype: str
        """
        return self._XPos

    @XPos.setter
    def XPos(self, XPos):
        self._XPos = XPos

    @property
    def YPos(self):
        r"""水印原点距离视频图像坐标原点的垂直位置。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示水印 YPos 为视频高度指定百分比，如 10% 表示 YPos 为视频高度的 10%；</li>
<li>当字符串以 px 结尾，表示水印 YPos 为指定像素，如 100px 表示 YPos 为 100 像素。</li>
默认值：0px。
        :rtype: str
        """
        return self._YPos

    @YPos.setter
    def YPos(self, YPos):
        self._YPos = YPos

    @property
    def ImageTemplate(self):
        r"""图片水印模板，当 Type 为 image，该字段必填。当 Type 为 text，该字段无效。
        :rtype: :class:`tencentcloud.vod.v20180717.models.ImageWatermarkInput`
        """
        return self._ImageTemplate

    @ImageTemplate.setter
    def ImageTemplate(self, ImageTemplate):
        self._ImageTemplate = ImageTemplate

    @property
    def TextTemplate(self):
        r"""文字水印模板，当 Type 为 text，该字段必填。当 Type 为 image，该字段无效。
        :rtype: :class:`tencentcloud.vod.v20180717.models.TextWatermarkTemplateInput`
        """
        return self._TextTemplate

    @TextTemplate.setter
    def TextTemplate(self, TextTemplate):
        self._TextTemplate = TextTemplate

    @property
    def SvgTemplate(self):
        r"""SVG水印模板，当 Type 为 svg，该字段必填。当 Type 为 image 或 text，该字段无效。
        :rtype: :class:`tencentcloud.vod.v20180717.models.SvgWatermarkInput`
        """
        return self._SvgTemplate

    @SvgTemplate.setter
    def SvgTemplate(self, SvgTemplate):
        self._SvgTemplate = SvgTemplate


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._SubAppId = params.get("SubAppId")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        self._CoordinateOrigin = params.get("CoordinateOrigin")
        self._XPos = params.get("XPos")
        self._YPos = params.get("YPos")
        if params.get("ImageTemplate") is not None:
            self._ImageTemplate = ImageWatermarkInput()
            self._ImageTemplate._deserialize(params.get("ImageTemplate"))
        if params.get("TextTemplate") is not None:
            self._TextTemplate = TextWatermarkTemplateInput()
            self._TextTemplate._deserialize(params.get("TextTemplate"))
        if params.get("SvgTemplate") is not None:
            self._SvgTemplate = SvgWatermarkInput()
            self._SvgTemplate._deserialize(params.get("SvgTemplate"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateWatermarkTemplateResponse(AbstractModel):
    r"""CreateWatermarkTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 水印模板唯一标识。
        :type Definition: int
        :param _ImageUrl: 水印图片地址，仅当 Type 为 image，该字段有效。
        :type ImageUrl: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._ImageUrl = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""水印模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def ImageUrl(self):
        r"""水印图片地址，仅当 Type 为 image，该字段有效。
        :rtype: str
        """
        return self._ImageUrl

    @ImageUrl.setter
    def ImageUrl(self, ImageUrl):
        self._ImageUrl = ImageUrl

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._ImageUrl = params.get("ImageUrl")
        self._RequestId = params.get("RequestId")


class CreateWordSamplesRequest(AbstractModel):
    r"""CreateWordSamples请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Usages: <b>关键词应用场景，可选值：</b>
1. Recognition.Ocr：通过光学字符识别技术，进行内容识别；
2. Recognition.Asr：通过音频识别技术，进行内容识别；
3. Review.Ocr：通过光学字符识别技术，进行不适宜内容识别；
4. Review.Asr：通过音频识别技术，进行不适宜内容识别；
<b>可合并简写为：</b>
5. Recognition：通过光学字符识别技术、音频识别技术，进行内容识别，等价于 1+2；
6. Review：通过光学字符识别技术、音频识别技术，进行不适宜内容识别，等价于 3+4；
7. All：通过光学字符识别技术、音频识别技术，进行内容识别、不适宜内容识别，等价于 1+2+3+4。
        :type Usages: list of str
        :param _Words: 关键词，数组长度限制：100。
        :type Words: list of AiSampleWordInfo
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Usages = None
        self._Words = None
        self._SubAppId = None

    @property
    def Usages(self):
        r"""<b>关键词应用场景，可选值：</b>
1. Recognition.Ocr：通过光学字符识别技术，进行内容识别；
2. Recognition.Asr：通过音频识别技术，进行内容识别；
3. Review.Ocr：通过光学字符识别技术，进行不适宜内容识别；
4. Review.Asr：通过音频识别技术，进行不适宜内容识别；
<b>可合并简写为：</b>
5. Recognition：通过光学字符识别技术、音频识别技术，进行内容识别，等价于 1+2；
6. Review：通过光学字符识别技术、音频识别技术，进行不适宜内容识别，等价于 3+4；
7. All：通过光学字符识别技术、音频识别技术，进行内容识别、不适宜内容识别，等价于 1+2+3+4。
        :rtype: list of str
        """
        return self._Usages

    @Usages.setter
    def Usages(self, Usages):
        self._Usages = Usages

    @property
    def Words(self):
        r"""关键词，数组长度限制：100。
        :rtype: list of AiSampleWordInfo
        """
        return self._Words

    @Words.setter
    def Words(self, Words):
        self._Words = Words

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Usages = params.get("Usages")
        if params.get("Words") is not None:
            self._Words = []
            for item in params.get("Words"):
                obj = AiSampleWordInfo()
                obj._deserialize(item)
                self._Words.append(obj)
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateWordSamplesResponse(AbstractModel):
    r"""CreateWordSamples返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DNSVerifyInfo(AbstractModel):
    r"""DNS解析验证信息

    """

    def __init__(self):
        r"""
        :param _SubDomain: 子解析。
        :type SubDomain: str
        :param _Record: 解析值。
        :type Record: str
        :param _RecordType: 解析类型。
        :type RecordType: str
        """
        self._SubDomain = None
        self._Record = None
        self._RecordType = None

    @property
    def SubDomain(self):
        r"""子解析。
        :rtype: str
        """
        return self._SubDomain

    @SubDomain.setter
    def SubDomain(self, SubDomain):
        self._SubDomain = SubDomain

    @property
    def Record(self):
        r"""解析值。
        :rtype: str
        """
        return self._Record

    @Record.setter
    def Record(self, Record):
        self._Record = Record

    @property
    def RecordType(self):
        r"""解析类型。
        :rtype: str
        """
        return self._RecordType

    @RecordType.setter
    def RecordType(self, RecordType):
        self._RecordType = RecordType


    def _deserialize(self, params):
        self._SubDomain = params.get("SubDomain")
        self._Record = params.get("Record")
        self._RecordType = params.get("RecordType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DailyPlayStatInfo(AbstractModel):
    r"""播放统计信息。

    """

    def __init__(self):
        r"""
        :param _Date: 播放媒体文件的日期，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type Date: str
        :param _FileId: 媒体文件ID。
        :type FileId: str
        :param _PlayTimes: 播放次数。
        :type PlayTimes: int
        :param _Traffic: 播放流量，单位：字节。
        :type Traffic: int
        """
        self._Date = None
        self._FileId = None
        self._PlayTimes = None
        self._Traffic = None

    @property
    def Date(self):
        r"""播放媒体文件的日期，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._Date

    @Date.setter
    def Date(self, Date):
        self._Date = Date

    @property
    def FileId(self):
        r"""媒体文件ID。
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def PlayTimes(self):
        r"""播放次数。
        :rtype: int
        """
        return self._PlayTimes

    @PlayTimes.setter
    def PlayTimes(self, PlayTimes):
        self._PlayTimes = PlayTimes

    @property
    def Traffic(self):
        r"""播放流量，单位：字节。
        :rtype: int
        """
        return self._Traffic

    @Traffic.setter
    def Traffic(self, Traffic):
        self._Traffic = Traffic


    def _deserialize(self, params):
        self._Date = params.get("Date")
        self._FileId = params.get("FileId")
        self._PlayTimes = params.get("PlayTimes")
        self._Traffic = params.get("Traffic")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAIAnalysisTemplateRequest(AbstractModel):
    r"""DeleteAIAnalysisTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 音视频内容分析模板唯一标识。
        :type Definition: int
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        r"""音视频内容分析模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAIAnalysisTemplateResponse(AbstractModel):
    r"""DeleteAIAnalysisTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteAIRecognitionTemplateRequest(AbstractModel):
    r"""DeleteAIRecognitionTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 音视频内容识别模板唯一标识。
        :type Definition: int
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        r"""音视频内容识别模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAIRecognitionTemplateResponse(AbstractModel):
    r"""DeleteAIRecognitionTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteAdaptiveDynamicStreamingTemplateRequest(AbstractModel):
    r"""DeleteAdaptiveDynamicStreamingTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 自适应转码模板唯一标识。
        :type Definition: int
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        r"""自适应转码模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAdaptiveDynamicStreamingTemplateResponse(AbstractModel):
    r"""DeleteAdaptiveDynamicStreamingTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteAnimatedGraphicsTemplateRequest(AbstractModel):
    r"""DeleteAnimatedGraphicsTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 转动图模板唯一标识。
        :type Definition: int
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        r"""转动图模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAnimatedGraphicsTemplateResponse(AbstractModel):
    r"""DeleteAnimatedGraphicsTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteCLSTopicRequest(AbstractModel):
    r"""DeleteCLSTopic请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CLSRegion: 日志集所属的地域，取值有： <li>ap-guangzhou：广州；</li> <li>ap-beijing：北京；</li> <li>ap-chengdu：成都；</li> <li>ap-chongqing：重庆；</li> <li>ap-nanjing：南京；</li> <li>ap-shanghai：上海；</li> <li>ap-singapore：新加坡。</li>
        :type CLSRegion: str
        :param _TopicId: 日志主题 ID。
        :type TopicId: str
        """
        self._CLSRegion = None
        self._TopicId = None

    @property
    def CLSRegion(self):
        r"""日志集所属的地域，取值有： <li>ap-guangzhou：广州；</li> <li>ap-beijing：北京；</li> <li>ap-chengdu：成都；</li> <li>ap-chongqing：重庆；</li> <li>ap-nanjing：南京；</li> <li>ap-shanghai：上海；</li> <li>ap-singapore：新加坡。</li>
        :rtype: str
        """
        return self._CLSRegion

    @CLSRegion.setter
    def CLSRegion(self, CLSRegion):
        self._CLSRegion = CLSRegion

    @property
    def TopicId(self):
        r"""日志主题 ID。
        :rtype: str
        """
        return self._TopicId

    @TopicId.setter
    def TopicId(self, TopicId):
        self._TopicId = TopicId


    def _deserialize(self, params):
        self._CLSRegion = params.get("CLSRegion")
        self._TopicId = params.get("TopicId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCLSTopicResponse(AbstractModel):
    r"""DeleteCLSTopic返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteClassRequest(AbstractModel):
    r"""DeleteClass请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClassId: 分类 ID
        :type ClassId: int
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._ClassId = None
        self._SubAppId = None

    @property
    def ClassId(self):
        r"""分类 ID
        :rtype: int
        """
        return self._ClassId

    @ClassId.setter
    def ClassId(self, ClassId):
        self._ClassId = ClassId

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._ClassId = params.get("ClassId")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteClassResponse(AbstractModel):
    r"""DeleteClass返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteContentReviewTemplateRequest(AbstractModel):
    r"""DeleteContentReviewTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 内容审核模板唯一标识。
        :type Definition: int
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        r"""内容审核模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteContentReviewTemplateResponse(AbstractModel):
    r"""DeleteContentReviewTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteEnhanceMediaTemplateRequest(AbstractModel):
    r"""DeleteEnhanceMediaTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 音画质重生模板号。
        :type Definition: int
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        r"""音画质重生模板号。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteEnhanceMediaTemplateResponse(AbstractModel):
    r"""DeleteEnhanceMediaTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteHeadTailTemplateRequest(AbstractModel):
    r"""DeleteHeadTailTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 片头片尾模板号。
        :type Definition: int
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        r"""片头片尾模板号。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteHeadTailTemplateResponse(AbstractModel):
    r"""DeleteHeadTailTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteImageProcessingTemplateRequest(AbstractModel):
    r"""DeleteImageProcessingTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 图片处理模板唯一标识。
        :type Definition: int
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        r"""图片处理模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteImageProcessingTemplateResponse(AbstractModel):
    r"""DeleteImageProcessingTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteImageSpriteTemplateRequest(AbstractModel):
    r"""DeleteImageSpriteTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 雪碧图模板唯一标识。
        :type Definition: int
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        r"""雪碧图模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteImageSpriteTemplateResponse(AbstractModel):
    r"""DeleteImageSpriteTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteJustInTimeTranscodeTemplateRequest(AbstractModel):
    r"""DeleteJustInTimeTranscodeTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 模板名字。
        :type Name: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Name = None
        self._SubAppId = None

    @property
    def Name(self):
        r"""模板名字。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteJustInTimeTranscodeTemplateResponse(AbstractModel):
    r"""DeleteJustInTimeTranscodeTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteMPSTemplateRequest(AbstractModel):
    r"""DeleteMPSTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。</b>
        :type SubAppId: int
        :param _TemplateType: 需要删除的 MPS 模板的类型。取值：
<li>Transcode: 删除转码模板。</li>
        :type TemplateType: str
        :param _Definition: MPS 任务模板唯一标识。
        :type Definition: int
        """
        self._SubAppId = None
        self._TemplateType = None
        self._Definition = None

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def TemplateType(self):
        r"""需要删除的 MPS 模板的类型。取值：
<li>Transcode: 删除转码模板。</li>
        :rtype: str
        """
        return self._TemplateType

    @TemplateType.setter
    def TemplateType(self, TemplateType):
        self._TemplateType = TemplateType

    @property
    def Definition(self):
        r"""MPS 任务模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._TemplateType = params.get("TemplateType")
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteMPSTemplateResponse(AbstractModel):
    r"""DeleteMPSTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteMediaRequest(AbstractModel):
    r"""DeleteMedia请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FileId: 媒体文件的唯一标识。
        :type FileId: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _DeleteParts: 指定本次需要删除的部分。默认值为 "[]", 表示删除媒体及其对应的全部视频处理文件。
        :type DeleteParts: list of MediaDeleteItem
        """
        self._FileId = None
        self._SubAppId = None
        self._DeleteParts = None

    @property
    def FileId(self):
        r"""媒体文件的唯一标识。
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def DeleteParts(self):
        r"""指定本次需要删除的部分。默认值为 "[]", 表示删除媒体及其对应的全部视频处理文件。
        :rtype: list of MediaDeleteItem
        """
        return self._DeleteParts

    @DeleteParts.setter
    def DeleteParts(self, DeleteParts):
        self._DeleteParts = DeleteParts


    def _deserialize(self, params):
        self._FileId = params.get("FileId")
        self._SubAppId = params.get("SubAppId")
        if params.get("DeleteParts") is not None:
            self._DeleteParts = []
            for item in params.get("DeleteParts"):
                obj = MediaDeleteItem()
                obj._deserialize(item)
                self._DeleteParts.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteMediaResponse(AbstractModel):
    r"""DeleteMedia返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeletePersonSampleRequest(AbstractModel):
    r"""DeletePersonSample请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PersonId: 素材 ID。
        :type PersonId: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._PersonId = None
        self._SubAppId = None

    @property
    def PersonId(self):
        r"""素材 ID。
        :rtype: str
        """
        return self._PersonId

    @PersonId.setter
    def PersonId(self, PersonId):
        self._PersonId = PersonId

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._PersonId = params.get("PersonId")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeletePersonSampleResponse(AbstractModel):
    r"""DeletePersonSample返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteProcedureTemplateRequest(AbstractModel):
    r"""DeleteProcedureTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 任务流名字。
        :type Name: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Name = None
        self._SubAppId = None

    @property
    def Name(self):
        r"""任务流名字。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteProcedureTemplateResponse(AbstractModel):
    r"""DeleteProcedureTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteQualityInspectTemplateRequest(AbstractModel):
    r"""DeleteQualityInspectTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 音画质检测模板 ID。
        :type Definition: int
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        r"""音画质检测模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteQualityInspectTemplateResponse(AbstractModel):
    r"""DeleteQualityInspectTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteRebuildMediaTemplateRequest(AbstractModel):
    r"""DeleteRebuildMediaTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 视频重生模板号。
        :type Definition: int
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        r"""视频重生模板号。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRebuildMediaTemplateResponse(AbstractModel):
    r"""DeleteRebuildMediaTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteReviewTemplateRequest(AbstractModel):
    r"""DeleteReviewTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 审核模板唯一标识。
        :type Definition: int
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        r"""审核模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteReviewTemplateResponse(AbstractModel):
    r"""DeleteReviewTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteRoundPlayRequest(AbstractModel):
    r"""DeleteRoundPlay请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RoundPlayId: 轮播播单唯一标识。
        :type RoundPlayId: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._RoundPlayId = None
        self._SubAppId = None

    @property
    def RoundPlayId(self):
        r"""轮播播单唯一标识。
        :rtype: str
        """
        return self._RoundPlayId

    @RoundPlayId.setter
    def RoundPlayId(self, RoundPlayId):
        self._RoundPlayId = RoundPlayId

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._RoundPlayId = params.get("RoundPlayId")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRoundPlayResponse(AbstractModel):
    r"""DeleteRoundPlay返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteSampleSnapshotTemplateRequest(AbstractModel):
    r"""DeleteSampleSnapshotTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 采样截图模板唯一标识。
        :type Definition: int
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        r"""采样截图模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSampleSnapshotTemplateResponse(AbstractModel):
    r"""DeleteSampleSnapshotTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteSnapshotByTimeOffsetTemplateRequest(AbstractModel):
    r"""DeleteSnapshotByTimeOffsetTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 指定时间点截图模板唯一标识。
        :type Definition: int
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        r"""指定时间点截图模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSnapshotByTimeOffsetTemplateResponse(AbstractModel):
    r"""DeleteSnapshotByTimeOffsetTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteSuperPlayerConfigRequest(AbstractModel):
    r"""DeleteSuperPlayerConfig请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 播放器配置名称。
        :type Name: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Name = None
        self._SubAppId = None

    @property
    def Name(self):
        r"""播放器配置名称。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSuperPlayerConfigResponse(AbstractModel):
    r"""DeleteSuperPlayerConfig返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteTranscodeTemplateRequest(AbstractModel):
    r"""DeleteTranscodeTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 转码模板唯一标识。
        :type Definition: int
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        r"""转码模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteTranscodeTemplateResponse(AbstractModel):
    r"""DeleteTranscodeTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteVodDomainRequest(AbstractModel):
    r"""DeleteVodDomain请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 要删除的点播加速域名。
        :type Domain: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Domain = None
        self._SubAppId = None

    @property
    def Domain(self):
        r"""要删除的点播加速域名。
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteVodDomainResponse(AbstractModel):
    r"""DeleteVodDomain返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteWatermarkTemplateRequest(AbstractModel):
    r"""DeleteWatermarkTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 水印模板唯一标识。
        :type Definition: int
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        r"""水印模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteWatermarkTemplateResponse(AbstractModel):
    r"""DeleteWatermarkTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteWordSamplesRequest(AbstractModel):
    r"""DeleteWordSamples请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Keywords: 关键词，数组长度限制：100 个词。
        :type Keywords: list of str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Keywords = None
        self._SubAppId = None

    @property
    def Keywords(self):
        r"""关键词，数组长度限制：100 个词。
        :rtype: list of str
        """
        return self._Keywords

    @Keywords.setter
    def Keywords(self, Keywords):
        self._Keywords = Keywords

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Keywords = params.get("Keywords")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteWordSamplesResponse(AbstractModel):
    r"""DeleteWordSamples返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DescribeAIAnalysisTemplatesRequest(AbstractModel):
    r"""DescribeAIAnalysisTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Definitions: 音视频内容分析模板唯一标识过滤条件，数组长度最大值：100。
        :type Definitions: list of int
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        """
        self._SubAppId = None
        self._Definitions = None
        self._Offset = None
        self._Limit = None

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Definitions(self):
        r"""音视频内容分析模板唯一标识过滤条件，数组长度最大值：100。
        :rtype: list of int
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        r"""分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAIAnalysisTemplatesResponse(AbstractModel):
    r"""DescribeAIAnalysisTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _AIAnalysisTemplateSet: 音视频内容分析模板详情列表。
        :type AIAnalysisTemplateSet: list of AIAnalysisTemplateItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._AIAnalysisTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AIAnalysisTemplateSet(self):
        r"""音视频内容分析模板详情列表。
        :rtype: list of AIAnalysisTemplateItem
        """
        return self._AIAnalysisTemplateSet

    @AIAnalysisTemplateSet.setter
    def AIAnalysisTemplateSet(self, AIAnalysisTemplateSet):
        self._AIAnalysisTemplateSet = AIAnalysisTemplateSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AIAnalysisTemplateSet") is not None:
            self._AIAnalysisTemplateSet = []
            for item in params.get("AIAnalysisTemplateSet"):
                obj = AIAnalysisTemplateItem()
                obj._deserialize(item)
                self._AIAnalysisTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAIRecognitionTemplatesRequest(AbstractModel):
    r"""DescribeAIRecognitionTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Definitions: 音视频内容识别模板唯一标识过滤条件，数组长度限制：100。
        :type Definitions: list of int
        :param _Type: 模板类型过滤条件，可选值：<li>Preset：系统预置模板；</li><li>Custom：用户自定义模板。</li>不填默认为空，即不对模板类型过滤。
        :type Type: str
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        """
        self._SubAppId = None
        self._Definitions = None
        self._Type = None
        self._Offset = None
        self._Limit = None

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Definitions(self):
        r"""音视频内容识别模板唯一标识过滤条件，数组长度限制：100。
        :rtype: list of int
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Type(self):
        r"""模板类型过滤条件，可选值：<li>Preset：系统预置模板；</li><li>Custom：用户自定义模板。</li>不填默认为空，即不对模板类型过滤。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Offset(self):
        r"""分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Definitions = params.get("Definitions")
        self._Type = params.get("Type")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAIRecognitionTemplatesResponse(AbstractModel):
    r"""DescribeAIRecognitionTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _AIRecognitionTemplateSet: 音视频内容识别模板详情列表。
        :type AIRecognitionTemplateSet: list of AIRecognitionTemplateItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._AIRecognitionTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AIRecognitionTemplateSet(self):
        r"""音视频内容识别模板详情列表。
        :rtype: list of AIRecognitionTemplateItem
        """
        return self._AIRecognitionTemplateSet

    @AIRecognitionTemplateSet.setter
    def AIRecognitionTemplateSet(self, AIRecognitionTemplateSet):
        self._AIRecognitionTemplateSet = AIRecognitionTemplateSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AIRecognitionTemplateSet") is not None:
            self._AIRecognitionTemplateSet = []
            for item in params.get("AIRecognitionTemplateSet"):
                obj = AIRecognitionTemplateItem()
                obj._deserialize(item)
                self._AIRecognitionTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAdaptiveDynamicStreamingTemplatesRequest(AbstractModel):
    r"""DescribeAdaptiveDynamicStreamingTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Definitions: 转自适应码流模板唯一标识过滤条件，数组长度限制：100。
        :type Definitions: list of int non-negative
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        :param _Type: 模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :type Type: str
        """
        self._SubAppId = None
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Definitions(self):
        r"""转自适应码流模板唯一标识过滤条件，数组长度限制：100。
        :rtype: list of int non-negative
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        r"""分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        r"""模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAdaptiveDynamicStreamingTemplatesResponse(AbstractModel):
    r"""DescribeAdaptiveDynamicStreamingTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _AdaptiveDynamicStreamingTemplateSet: 转自适应码流模板详情列表。
        :type AdaptiveDynamicStreamingTemplateSet: list of AdaptiveDynamicStreamingTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._AdaptiveDynamicStreamingTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AdaptiveDynamicStreamingTemplateSet(self):
        r"""转自适应码流模板详情列表。
        :rtype: list of AdaptiveDynamicStreamingTemplate
        """
        return self._AdaptiveDynamicStreamingTemplateSet

    @AdaptiveDynamicStreamingTemplateSet.setter
    def AdaptiveDynamicStreamingTemplateSet(self, AdaptiveDynamicStreamingTemplateSet):
        self._AdaptiveDynamicStreamingTemplateSet = AdaptiveDynamicStreamingTemplateSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AdaptiveDynamicStreamingTemplateSet") is not None:
            self._AdaptiveDynamicStreamingTemplateSet = []
            for item in params.get("AdaptiveDynamicStreamingTemplateSet"):
                obj = AdaptiveDynamicStreamingTemplate()
                obj._deserialize(item)
                self._AdaptiveDynamicStreamingTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAigcUsageDataRequest(AbstractModel):
    r"""DescribeAigcUsageData请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 起始日期。使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#52)。
        :type StartTime: str
        :param _EndTime: 结束日期，需大于等于起始日期。使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#52)。
        :type EndTime: str
        :param _AigcType: AIGC类型，取值有：<li> Video：视频。</li><li> Image：图片。</li>
        :type AigcType: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._StartTime = None
        self._EndTime = None
        self._AigcType = None
        self._SubAppId = None

    @property
    def StartTime(self):
        r"""起始日期。使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#52)。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""结束日期，需大于等于起始日期。使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#52)。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def AigcType(self):
        r"""AIGC类型，取值有：<li> Video：视频。</li><li> Image：图片。</li>
        :rtype: str
        """
        return self._AigcType

    @AigcType.setter
    def AigcType(self, AigcType):
        self._AigcType = AigcType

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._AigcType = params.get("AigcType")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAigcUsageDataResponse(AbstractModel):
    r"""DescribeAigcUsageData返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AigcUsageDataSet: AIGC统计数据。
        :type AigcUsageDataSet: list of AigcUsageDataItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AigcUsageDataSet = None
        self._RequestId = None

    @property
    def AigcUsageDataSet(self):
        r"""AIGC统计数据。
        :rtype: list of AigcUsageDataItem
        """
        return self._AigcUsageDataSet

    @AigcUsageDataSet.setter
    def AigcUsageDataSet(self, AigcUsageDataSet):
        self._AigcUsageDataSet = AigcUsageDataSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("AigcUsageDataSet") is not None:
            self._AigcUsageDataSet = []
            for item in params.get("AigcUsageDataSet"):
                obj = AigcUsageDataItem()
                obj._deserialize(item)
                self._AigcUsageDataSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAllClassRequest(AbstractModel):
    r"""DescribeAllClass请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._SubAppId = None

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAllClassResponse(AbstractModel):
    r"""DescribeAllClass返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ClassInfoSet: 分类信息集合
        :type ClassInfoSet: list of MediaClassInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ClassInfoSet = None
        self._RequestId = None

    @property
    def ClassInfoSet(self):
        r"""分类信息集合
        :rtype: list of MediaClassInfo
        """
        return self._ClassInfoSet

    @ClassInfoSet.setter
    def ClassInfoSet(self, ClassInfoSet):
        self._ClassInfoSet = ClassInfoSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ClassInfoSet") is not None:
            self._ClassInfoSet = []
            for item in params.get("ClassInfoSet"):
                obj = MediaClassInfo()
                obj._deserialize(item)
                self._ClassInfoSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAnimatedGraphicsTemplatesRequest(AbstractModel):
    r"""DescribeAnimatedGraphicsTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Definitions: 转动图模板唯一标识过滤条件，数组长度限制：100。
        :type Definitions: list of int non-negative
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        :param _Type: 模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :type Type: str
        """
        self._SubAppId = None
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Definitions(self):
        r"""转动图模板唯一标识过滤条件，数组长度限制：100。
        :rtype: list of int non-negative
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        r"""分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        r"""模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAnimatedGraphicsTemplatesResponse(AbstractModel):
    r"""DescribeAnimatedGraphicsTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _AnimatedGraphicsTemplateSet: 转动图模板详情列表。
        :type AnimatedGraphicsTemplateSet: list of AnimatedGraphicsTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._AnimatedGraphicsTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AnimatedGraphicsTemplateSet(self):
        r"""转动图模板详情列表。
        :rtype: list of AnimatedGraphicsTemplate
        """
        return self._AnimatedGraphicsTemplateSet

    @AnimatedGraphicsTemplateSet.setter
    def AnimatedGraphicsTemplateSet(self, AnimatedGraphicsTemplateSet):
        self._AnimatedGraphicsTemplateSet = AnimatedGraphicsTemplateSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AnimatedGraphicsTemplateSet") is not None:
            self._AnimatedGraphicsTemplateSet = []
            for item in params.get("AnimatedGraphicsTemplateSet"):
                obj = AnimatedGraphicsTemplate()
                obj._deserialize(item)
                self._AnimatedGraphicsTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCDNStatDetailsRequest(AbstractModel):
    r"""DescribeCDNStatDetails请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Metric: 查询指标，取值有：
<li>Traffic：流量，单位为 Byte。</li>
<li>Bandwidth：带宽，单位为 Bps。</li>
<li>Requests：请求数。</li>
<li>QUICRequests：QUIC 请求数。</li>
<li>IpVisit：IP 访问数。</li>
        :type Metric: str
        :param _StartTime: 起始时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type StartTime: str
        :param _EndTime: 结束时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type EndTime: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _DomainNames: 域名列表。一次最多查询20个域名的数据。默认返回所有域名叠加的用量数据。
        :type DomainNames: list of str
        :param _Area: 服务区域，取值有：
<li>Chinese Mainland：中国大陆。 </li>
<li>Asia Pacific Region 1：亚太一区，包括中国香港、中国澳门、新加坡、越南、泰国。 </li>
<li>Asia Pacific Region 2：亚太二区，包括中国台湾、日本、马来西亚、印度尼西亚、韩国。 </li>
<li>Asia Pacific Region 3：亚太三区，包括菲律宾、印度、澳大利亚和亚太其它国家和地区。 </li>
<li>Middle East：中东。 </li>
<li>Europe：欧洲。</li>
<li>North America：北美。</li>
<li>South America：南美。</li>
<li>Africa：非洲。</li>
默认为中国大陆。
        :type Area: str
        :param _Districts: 用户所在地区，Area 为 Chinese Mainland 时，取值为以下地区信息，当 Area 为其它值时， 忽略 Districts 参数。
<li>Beijing：北京。</li>
<li>Inner Mongolia：内蒙古。</li>
<li>Shanxi：山西。</li>
<li>Hebei：河北。</li>
<li>Tianjin：天津。</li>
<li>Ningxia：宁夏。</li>
<li>Shaanxi：陕西。</li>
<li>Gansu：甘肃。</li>
<li>Qinghai：青海。</li>
<li>Xinjiang：新疆。</li>
<li>Heilongjiang：黑龙江。</li>
<li>Jilin：吉林。</li>
<li>Liaoning：辽宁。</li>
<li>Fujian：福建。</li>
<li>Jiangsu：江苏。</li>
<li>Anhui：安徽。</li>
<li>Shandong：山东。</li>
<li>Shanghai：上海。</li>
<li>Zhejiang：浙江。</li>
<li>Henan：河南。</li>
<li>Hubei：湖北。</li>
<li>Jiangxi：江西。</li>
<li>Hunan：湖南。</li>
<li>Guizhou：贵州。</li>
<li>Yunnan：云南。</li>
<li>Chongqing：重庆。</li>
<li>Sichuan：四川。</li>
<li>Xizang：西藏。</li>
<li>Guangdong：广东。</li>
<li>Guangxi：广西。</li>
<li>Hainan：海南。</li>
<li>Hong Kong, Macao and Taiwan：港澳台。</li>
<li>Outside Chinese Mainland：海外。</li>
<li>Other：其他 。</li>
        :type Districts: list of str
        :param _Isps: 用户所属运营商信息，Area 为 Chinese Mainland 时，取值为以下运营商信息。当 Area 为其它值时忽略 Isps 参数。
<li>China Telecom：中国电信。 </li>
<li>China Unicom：中国联通。 </li>
<li>CERNET：教育网。</li>
<li>Great Wall Broadband Network：长城宽带。</li>
<li>China Mobile：中国移动。</li>
<li>China Mobile Tietong：中国铁通。</li>
<li>ISPs outside Chinese Mainland：海外运营商。</li>
<li>Other ISPs：其他运营商。</li>
        :type Isps: list of str
        :param _DataInterval: 每条数据的时间粒度，单位：分钟，取值有：
<li>5：5 分钟粒度，返回指定查询时间内5分钟粒度的明细数据。</li>
<li>1440：天粒度，返回指定查询时间内1天粒度的数据。起始时间和结束时间跨度大于24小时，只支持天粒度的数据。</li>
当 StartTime 和 EndTime 时间跨度大于24小时时，DataInterval 默认为 1440。
        :type DataInterval: int
        """
        self._Metric = None
        self._StartTime = None
        self._EndTime = None
        self._SubAppId = None
        self._DomainNames = None
        self._Area = None
        self._Districts = None
        self._Isps = None
        self._DataInterval = None

    @property
    def Metric(self):
        r"""查询指标，取值有：
<li>Traffic：流量，单位为 Byte。</li>
<li>Bandwidth：带宽，单位为 Bps。</li>
<li>Requests：请求数。</li>
<li>QUICRequests：QUIC 请求数。</li>
<li>IpVisit：IP 访问数。</li>
        :rtype: str
        """
        return self._Metric

    @Metric.setter
    def Metric(self, Metric):
        self._Metric = Metric

    @property
    def StartTime(self):
        r"""起始时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""结束时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def DomainNames(self):
        r"""域名列表。一次最多查询20个域名的数据。默认返回所有域名叠加的用量数据。
        :rtype: list of str
        """
        return self._DomainNames

    @DomainNames.setter
    def DomainNames(self, DomainNames):
        self._DomainNames = DomainNames

    @property
    def Area(self):
        r"""服务区域，取值有：
<li>Chinese Mainland：中国大陆。 </li>
<li>Asia Pacific Region 1：亚太一区，包括中国香港、中国澳门、新加坡、越南、泰国。 </li>
<li>Asia Pacific Region 2：亚太二区，包括中国台湾、日本、马来西亚、印度尼西亚、韩国。 </li>
<li>Asia Pacific Region 3：亚太三区，包括菲律宾、印度、澳大利亚和亚太其它国家和地区。 </li>
<li>Middle East：中东。 </li>
<li>Europe：欧洲。</li>
<li>North America：北美。</li>
<li>South America：南美。</li>
<li>Africa：非洲。</li>
默认为中国大陆。
        :rtype: str
        """
        return self._Area

    @Area.setter
    def Area(self, Area):
        self._Area = Area

    @property
    def Districts(self):
        r"""用户所在地区，Area 为 Chinese Mainland 时，取值为以下地区信息，当 Area 为其它值时， 忽略 Districts 参数。
<li>Beijing：北京。</li>
<li>Inner Mongolia：内蒙古。</li>
<li>Shanxi：山西。</li>
<li>Hebei：河北。</li>
<li>Tianjin：天津。</li>
<li>Ningxia：宁夏。</li>
<li>Shaanxi：陕西。</li>
<li>Gansu：甘肃。</li>
<li>Qinghai：青海。</li>
<li>Xinjiang：新疆。</li>
<li>Heilongjiang：黑龙江。</li>
<li>Jilin：吉林。</li>
<li>Liaoning：辽宁。</li>
<li>Fujian：福建。</li>
<li>Jiangsu：江苏。</li>
<li>Anhui：安徽。</li>
<li>Shandong：山东。</li>
<li>Shanghai：上海。</li>
<li>Zhejiang：浙江。</li>
<li>Henan：河南。</li>
<li>Hubei：湖北。</li>
<li>Jiangxi：江西。</li>
<li>Hunan：湖南。</li>
<li>Guizhou：贵州。</li>
<li>Yunnan：云南。</li>
<li>Chongqing：重庆。</li>
<li>Sichuan：四川。</li>
<li>Xizang：西藏。</li>
<li>Guangdong：广东。</li>
<li>Guangxi：广西。</li>
<li>Hainan：海南。</li>
<li>Hong Kong, Macao and Taiwan：港澳台。</li>
<li>Outside Chinese Mainland：海外。</li>
<li>Other：其他 。</li>
        :rtype: list of str
        """
        return self._Districts

    @Districts.setter
    def Districts(self, Districts):
        self._Districts = Districts

    @property
    def Isps(self):
        r"""用户所属运营商信息，Area 为 Chinese Mainland 时，取值为以下运营商信息。当 Area 为其它值时忽略 Isps 参数。
<li>China Telecom：中国电信。 </li>
<li>China Unicom：中国联通。 </li>
<li>CERNET：教育网。</li>
<li>Great Wall Broadband Network：长城宽带。</li>
<li>China Mobile：中国移动。</li>
<li>China Mobile Tietong：中国铁通。</li>
<li>ISPs outside Chinese Mainland：海外运营商。</li>
<li>Other ISPs：其他运营商。</li>
        :rtype: list of str
        """
        return self._Isps

    @Isps.setter
    def Isps(self, Isps):
        self._Isps = Isps

    @property
    def DataInterval(self):
        r"""每条数据的时间粒度，单位：分钟，取值有：
<li>5：5 分钟粒度，返回指定查询时间内5分钟粒度的明细数据。</li>
<li>1440：天粒度，返回指定查询时间内1天粒度的数据。起始时间和结束时间跨度大于24小时，只支持天粒度的数据。</li>
当 StartTime 和 EndTime 时间跨度大于24小时时，DataInterval 默认为 1440。
        :rtype: int
        """
        return self._DataInterval

    @DataInterval.setter
    def DataInterval(self, DataInterval):
        self._DataInterval = DataInterval


    def _deserialize(self, params):
        self._Metric = params.get("Metric")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._SubAppId = params.get("SubAppId")
        self._DomainNames = params.get("DomainNames")
        self._Area = params.get("Area")
        self._Districts = params.get("Districts")
        self._Isps = params.get("Isps")
        self._DataInterval = params.get("DataInterval")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCDNStatDetailsResponse(AbstractModel):
    r"""DescribeCDNStatDetails返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DataInterval: 每条数据的时间粒度，单位：分钟。
        :type DataInterval: int
        :param _Data: CDN 用量数据。
        :type Data: list of StatDataItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DataInterval = None
        self._Data = None
        self._RequestId = None

    @property
    def DataInterval(self):
        r"""每条数据的时间粒度，单位：分钟。
        :rtype: int
        """
        return self._DataInterval

    @DataInterval.setter
    def DataInterval(self, DataInterval):
        self._DataInterval = DataInterval

    @property
    def Data(self):
        r"""CDN 用量数据。
        :rtype: list of StatDataItem
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DataInterval = params.get("DataInterval")
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = StatDataItem()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCDNUsageDataRequest(AbstractModel):
    r"""DescribeCDNUsageData请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 起始日期，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type StartTime: str
        :param _EndTime: 结束日期，需大于开始日期，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type EndTime: str
        :param _DataType: CDN 统计数据类型，有效值：
<li>Flux：流量，单位为 byte。</li>
<li>Bandwidth：带宽，单位为 bps。</li>
        :type DataType: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _DataInterval: 用量数据的时间粒度，单位：分钟，取值有：
<li>5：5 分钟粒度，返回指定查询时间内5分钟粒度的明细数据。</li>
<li>60：小时粒度，返回指定查询时间内1小时粒度的数据。</li>
<li>1440：天粒度，返回指定查询时间内1天粒度的数据。</li>
默认值为1440，返回天粒度的数据。
        :type DataInterval: int
        :param _DomainNames: 域名列表。一次最多查询20个域名的用量数据。可以指定多个域名，查询这些域名叠加的用量数据。默认返回所有域名叠加的用量数据。
        :type DomainNames: list of str
        """
        self._StartTime = None
        self._EndTime = None
        self._DataType = None
        self._SubAppId = None
        self._DataInterval = None
        self._DomainNames = None

    @property
    def StartTime(self):
        r"""起始日期，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""结束日期，需大于开始日期，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def DataType(self):
        r"""CDN 统计数据类型，有效值：
<li>Flux：流量，单位为 byte。</li>
<li>Bandwidth：带宽，单位为 bps。</li>
        :rtype: str
        """
        return self._DataType

    @DataType.setter
    def DataType(self, DataType):
        self._DataType = DataType

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def DataInterval(self):
        r"""用量数据的时间粒度，单位：分钟，取值有：
<li>5：5 分钟粒度，返回指定查询时间内5分钟粒度的明细数据。</li>
<li>60：小时粒度，返回指定查询时间内1小时粒度的数据。</li>
<li>1440：天粒度，返回指定查询时间内1天粒度的数据。</li>
默认值为1440，返回天粒度的数据。
        :rtype: int
        """
        return self._DataInterval

    @DataInterval.setter
    def DataInterval(self, DataInterval):
        self._DataInterval = DataInterval

    @property
    def DomainNames(self):
        r"""域名列表。一次最多查询20个域名的用量数据。可以指定多个域名，查询这些域名叠加的用量数据。默认返回所有域名叠加的用量数据。
        :rtype: list of str
        """
        return self._DomainNames

    @DomainNames.setter
    def DomainNames(self, DomainNames):
        self._DomainNames = DomainNames


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._DataType = params.get("DataType")
        self._SubAppId = params.get("SubAppId")
        self._DataInterval = params.get("DataInterval")
        self._DomainNames = params.get("DomainNames")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCDNUsageDataResponse(AbstractModel):
    r"""DescribeCDNUsageData返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DataInterval: 时间粒度，单位：分钟。
        :type DataInterval: int
        :param _Data: CDN 统计数据。
        :type Data: list of StatDataItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DataInterval = None
        self._Data = None
        self._RequestId = None

    @property
    def DataInterval(self):
        r"""时间粒度，单位：分钟。
        :rtype: int
        """
        return self._DataInterval

    @DataInterval.setter
    def DataInterval(self, DataInterval):
        self._DataInterval = DataInterval

    @property
    def Data(self):
        r"""CDN 统计数据。
        :rtype: list of StatDataItem
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DataInterval = params.get("DataInterval")
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = StatDataItem()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCLSLogsetsRequest(AbstractModel):
    r"""DescribeCLSLogsets请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CLSRegion: 日志集所属的地域，取值有： <li>ap-guangzhou：广州；</li> <li>ap-beijing：北京；</li> <li>ap-chengdu：成都；</li> <li>ap-chongqing：重庆；</li> <li>ap-nanjing：南京；</li> <li>ap-shanghai：上海；</li> <li>ap-singapore：新加坡。</li>
        :type CLSRegion: str
        """
        self._CLSRegion = None

    @property
    def CLSRegion(self):
        r"""日志集所属的地域，取值有： <li>ap-guangzhou：广州；</li> <li>ap-beijing：北京；</li> <li>ap-chengdu：成都；</li> <li>ap-chongqing：重庆；</li> <li>ap-nanjing：南京；</li> <li>ap-shanghai：上海；</li> <li>ap-singapore：新加坡。</li>
        :rtype: str
        """
        return self._CLSRegion

    @CLSRegion.setter
    def CLSRegion(self, CLSRegion):
        self._CLSRegion = CLSRegion


    def _deserialize(self, params):
        self._CLSRegion = params.get("CLSRegion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCLSLogsetsResponse(AbstractModel):
    r"""DescribeCLSLogsets返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Logsets: 查询到的日志集列表。
        :type Logsets: list of CLSLogsetInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Logsets = None
        self._RequestId = None

    @property
    def Logsets(self):
        r"""查询到的日志集列表。
        :rtype: list of CLSLogsetInfo
        """
        return self._Logsets

    @Logsets.setter
    def Logsets(self, Logsets):
        self._Logsets = Logsets

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Logsets") is not None:
            self._Logsets = []
            for item in params.get("Logsets"):
                obj = CLSLogsetInfo()
                obj._deserialize(item)
                self._Logsets.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCLSPushTargetsRequest(AbstractModel):
    r"""DescribeCLSPushTargets请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domains: 点播域名。
        :type Domains: list of str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Domains = None
        self._SubAppId = None

    @property
    def Domains(self):
        r"""点播域名。
        :rtype: list of str
        """
        return self._Domains

    @Domains.setter
    def Domains(self, Domains):
        self._Domains = Domains

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Domains = params.get("Domains")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCLSPushTargetsResponse(AbstractModel):
    r"""DescribeCLSPushTargets返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 域名推送总数量。
        :type TotalCount: int
        :param _DomainCLSTargets: 域名推送 CLS 目标列表。
        :type DomainCLSTargets: list of DomainCLSTargetInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._DomainCLSTargets = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""域名推送总数量。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DomainCLSTargets(self):
        r"""域名推送 CLS 目标列表。
        :rtype: list of DomainCLSTargetInfo
        """
        return self._DomainCLSTargets

    @DomainCLSTargets.setter
    def DomainCLSTargets(self, DomainCLSTargets):
        self._DomainCLSTargets = DomainCLSTargets

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DomainCLSTargets") is not None:
            self._DomainCLSTargets = []
            for item in params.get("DomainCLSTargets"):
                obj = DomainCLSTargetInfo()
                obj._deserialize(item)
                self._DomainCLSTargets.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCLSTopicsRequest(AbstractModel):
    r"""DescribeCLSTopics请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CLSRegion: 日志集所属的地域，取值有： <li>ap-guangzhou：广州；</li> <li>ap-beijing：北京；</li> <li>ap-chengdu：成都；</li> <li>ap-chongqing：重庆；</li> <li>ap-nanjing：南京；</li> <li>ap-shanghai：上海；</li> <li>ap-singapore：新加坡。</li>
        :type CLSRegion: str
        :param _LogsetId: 日志主题所属日志集 ID。
        :type LogsetId: str
        :param _TopicIds: 日志主题 ID 列表。如果不填，表示查询所有的日志主题。
        :type TopicIds: list of str
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：20，最大值：100。
        :type Limit: int
        """
        self._CLSRegion = None
        self._LogsetId = None
        self._TopicIds = None
        self._Offset = None
        self._Limit = None

    @property
    def CLSRegion(self):
        r"""日志集所属的地域，取值有： <li>ap-guangzhou：广州；</li> <li>ap-beijing：北京；</li> <li>ap-chengdu：成都；</li> <li>ap-chongqing：重庆；</li> <li>ap-nanjing：南京；</li> <li>ap-shanghai：上海；</li> <li>ap-singapore：新加坡。</li>
        :rtype: str
        """
        return self._CLSRegion

    @CLSRegion.setter
    def CLSRegion(self, CLSRegion):
        self._CLSRegion = CLSRegion

    @property
    def LogsetId(self):
        r"""日志主题所属日志集 ID。
        :rtype: str
        """
        return self._LogsetId

    @LogsetId.setter
    def LogsetId(self, LogsetId):
        self._LogsetId = LogsetId

    @property
    def TopicIds(self):
        r"""日志主题 ID 列表。如果不填，表示查询所有的日志主题。
        :rtype: list of str
        """
        return self._TopicIds

    @TopicIds.setter
    def TopicIds(self, TopicIds):
        self._TopicIds = TopicIds

    @property
    def Offset(self):
        r"""分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回记录条数，默认值：20，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._CLSRegion = params.get("CLSRegion")
        self._LogsetId = params.get("LogsetId")
        self._TopicIds = params.get("TopicIds")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCLSTopicsResponse(AbstractModel):
    r"""DescribeCLSTopics返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 日志主题总数量。
        :type TotalCount: int
        :param _Topics: 日志主题列表。
        :type Topics: list of CLSTopicInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._Topics = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""日志主题总数量。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Topics(self):
        r"""日志主题列表。
        :rtype: list of CLSTopicInfo
        """
        return self._Topics

    @Topics.setter
    def Topics(self, Topics):
        self._Topics = Topics

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Topics") is not None:
            self._Topics = []
            for item in params.get("Topics"):
                obj = CLSTopicInfo()
                obj._deserialize(item)
                self._Topics.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCdnLogsRequest(AbstractModel):
    r"""DescribeCdnLogs请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DomainName: 域名。
        :type DomainName: str
        :param _StartTime: 获取日志起始时间点，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F)。
        :type StartTime: str
        :param _EndTime: 结束时间需大于起始时间；使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F)。
        :type EndTime: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Limit: 分页拉取的最大返回结果数。默认值：100；最大值：1000。
        :type Limit: int
        :param _Offset: 分页拉取的起始偏移量。默认值：0。
        :type Offset: int
        """
        self._DomainName = None
        self._StartTime = None
        self._EndTime = None
        self._SubAppId = None
        self._Limit = None
        self._Offset = None

    @property
    def DomainName(self):
        r"""域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def StartTime(self):
        r"""获取日志起始时间点，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F)。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""结束时间需大于起始时间；使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F)。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Limit(self):
        r"""分页拉取的最大返回结果数。默认值：100；最大值：1000。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""分页拉取的起始偏移量。默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._DomainName = params.get("DomainName")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._SubAppId = params.get("SubAppId")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCdnLogsResponse(AbstractModel):
    r"""DescribeCdnLogs返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 日志下载链接总数量。
        :type TotalCount: int
        :param _OverseaCdnLogs: 海外CDN节点的日志下载列表。如果域名没有开启海外加速，忽略该参数。
        :type OverseaCdnLogs: list of CdnLogInfo
        :param _DomesticCdnLogs: 国内CDN节点的日志下载列表。
        :type DomesticCdnLogs: list of CdnLogInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._OverseaCdnLogs = None
        self._DomesticCdnLogs = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""日志下载链接总数量。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def OverseaCdnLogs(self):
        r"""海外CDN节点的日志下载列表。如果域名没有开启海外加速，忽略该参数。
        :rtype: list of CdnLogInfo
        """
        return self._OverseaCdnLogs

    @OverseaCdnLogs.setter
    def OverseaCdnLogs(self, OverseaCdnLogs):
        self._OverseaCdnLogs = OverseaCdnLogs

    @property
    def DomesticCdnLogs(self):
        r"""国内CDN节点的日志下载列表。
        :rtype: list of CdnLogInfo
        """
        return self._DomesticCdnLogs

    @DomesticCdnLogs.setter
    def DomesticCdnLogs(self, DomesticCdnLogs):
        self._DomesticCdnLogs = DomesticCdnLogs

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("OverseaCdnLogs") is not None:
            self._OverseaCdnLogs = []
            for item in params.get("OverseaCdnLogs"):
                obj = CdnLogInfo()
                obj._deserialize(item)
                self._OverseaCdnLogs.append(obj)
        if params.get("DomesticCdnLogs") is not None:
            self._DomesticCdnLogs = []
            for item in params.get("DomesticCdnLogs"):
                obj = CdnLogInfo()
                obj._deserialize(item)
                self._DomesticCdnLogs.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeClientUploadAccelerationUsageDataRequest(AbstractModel):
    r"""DescribeClientUploadAccelerationUsageData请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 起始日期。使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#52)。
        :type StartTime: str
        :param _EndTime: 结束日期，需大于等于起始日期。使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#52)。
        :type EndTime: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Type: 客户端上传加速类型，取值有：
<li> AccelerationWithHTTP：HTTP 传输方式的上传加速。</li>
<li> AccelerationWithQUIC：QUIC 传输方式的上传加速。</li>
默认查询所有加速类型的用量 。
        :type Type: str
        """
        self._StartTime = None
        self._EndTime = None
        self._SubAppId = None
        self._Type = None

    @property
    def StartTime(self):
        r"""起始日期。使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#52)。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""结束日期，需大于等于起始日期。使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#52)。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Type(self):
        r"""客户端上传加速类型，取值有：
<li> AccelerationWithHTTP：HTTP 传输方式的上传加速。</li>
<li> AccelerationWithQUIC：QUIC 传输方式的上传加速。</li>
默认查询所有加速类型的用量 。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._SubAppId = params.get("SubAppId")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClientUploadAccelerationUsageDataResponse(AbstractModel):
    r"""DescribeClientUploadAccelerationUsageData返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ClientUploadAccelerationUsageDataSet: 客户端上传加速统计数据。
        :type ClientUploadAccelerationUsageDataSet: list of StatDataItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ClientUploadAccelerationUsageDataSet = None
        self._RequestId = None

    @property
    def ClientUploadAccelerationUsageDataSet(self):
        r"""客户端上传加速统计数据。
        :rtype: list of StatDataItem
        """
        return self._ClientUploadAccelerationUsageDataSet

    @ClientUploadAccelerationUsageDataSet.setter
    def ClientUploadAccelerationUsageDataSet(self, ClientUploadAccelerationUsageDataSet):
        self._ClientUploadAccelerationUsageDataSet = ClientUploadAccelerationUsageDataSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ClientUploadAccelerationUsageDataSet") is not None:
            self._ClientUploadAccelerationUsageDataSet = []
            for item in params.get("ClientUploadAccelerationUsageDataSet"):
                obj = StatDataItem()
                obj._deserialize(item)
                self._ClientUploadAccelerationUsageDataSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeContentReviewTemplatesRequest(AbstractModel):
    r"""DescribeContentReviewTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Definitions: 内容审核模板唯一标识过滤条件，数组长度限制：100。
        :type Definitions: list of int
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        """
        self._SubAppId = None
        self._Definitions = None
        self._Offset = None
        self._Limit = None

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Definitions(self):
        r"""内容审核模板唯一标识过滤条件，数组长度限制：100。
        :rtype: list of int
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        r"""分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeContentReviewTemplatesResponse(AbstractModel):
    r"""DescribeContentReviewTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _ContentReviewTemplateSet: 内容审核模板详情列表。
        :type ContentReviewTemplateSet: list of ContentReviewTemplateItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._ContentReviewTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ContentReviewTemplateSet(self):
        r"""内容审核模板详情列表。
        :rtype: list of ContentReviewTemplateItem
        """
        return self._ContentReviewTemplateSet

    @ContentReviewTemplateSet.setter
    def ContentReviewTemplateSet(self, ContentReviewTemplateSet):
        self._ContentReviewTemplateSet = ContentReviewTemplateSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ContentReviewTemplateSet") is not None:
            self._ContentReviewTemplateSet = []
            for item in params.get("ContentReviewTemplateSet"):
                obj = ContentReviewTemplateItem()
                obj._deserialize(item)
                self._ContentReviewTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCurrentPlaylistRequest(AbstractModel):
    r"""DescribeCurrentPlaylist请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。</b>
        :type SubAppId: int
        :param _RoundPlayId: 轮播播单唯一标识。
        :type RoundPlayId: str
        :param _Limit: 返回的播放列表的长度。最大10，默认值为5。
        :type Limit: int
        """
        self._SubAppId = None
        self._RoundPlayId = None
        self._Limit = None

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def RoundPlayId(self):
        r"""轮播播单唯一标识。
        :rtype: str
        """
        return self._RoundPlayId

    @RoundPlayId.setter
    def RoundPlayId(self, RoundPlayId):
        self._RoundPlayId = RoundPlayId

    @property
    def Limit(self):
        r"""返回的播放列表的长度。最大10，默认值为5。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._RoundPlayId = params.get("RoundPlayId")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCurrentPlaylistResponse(AbstractModel):
    r"""DescribeCurrentPlaylist返回参数结构体

    """

    def __init__(self):
        r"""
        :param _CurrentPlaylist: 当前播放列表信息。
        :type CurrentPlaylist: list of RoundPlayFilePlayInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._CurrentPlaylist = None
        self._RequestId = None

    @property
    def CurrentPlaylist(self):
        r"""当前播放列表信息。
        :rtype: list of RoundPlayFilePlayInfo
        """
        return self._CurrentPlaylist

    @CurrentPlaylist.setter
    def CurrentPlaylist(self, CurrentPlaylist):
        self._CurrentPlaylist = CurrentPlaylist

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("CurrentPlaylist") is not None:
            self._CurrentPlaylist = []
            for item in params.get("CurrentPlaylist"):
                obj = RoundPlayFilePlayInfo()
                obj._deserialize(item)
                self._CurrentPlaylist.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDailyMediaPlayStatRequest(AbstractModel):
    r"""DescribeDailyMediaPlayStat请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FileId: 媒体文件 ID 。
        :type FileId: str
        :param _StartDate: 起始日期，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。该参数仅日期部分有效。
        :type StartDate: str
        :param _EndDate: 结束日期，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。该参数仅日期部分有效。
        :type EndDate: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._FileId = None
        self._StartDate = None
        self._EndDate = None
        self._SubAppId = None

    @property
    def FileId(self):
        r"""媒体文件 ID 。
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def StartDate(self):
        r"""起始日期，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。该参数仅日期部分有效。
        :rtype: str
        """
        return self._StartDate

    @StartDate.setter
    def StartDate(self, StartDate):
        self._StartDate = StartDate

    @property
    def EndDate(self):
        r"""结束日期，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。该参数仅日期部分有效。
        :rtype: str
        """
        return self._EndDate

    @EndDate.setter
    def EndDate(self, EndDate):
        self._EndDate = EndDate

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._FileId = params.get("FileId")
        self._StartDate = params.get("StartDate")
        self._EndDate = params.get("EndDate")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDailyMediaPlayStatResponse(AbstractModel):
    r"""DescribeDailyMediaPlayStat返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DailyPlayStatInfoSet: 播放统计数据。
        :type DailyPlayStatInfoSet: list of DailyPlayStatInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DailyPlayStatInfoSet = None
        self._RequestId = None

    @property
    def DailyPlayStatInfoSet(self):
        r"""播放统计数据。
        :rtype: list of DailyPlayStatInfo
        """
        return self._DailyPlayStatInfoSet

    @DailyPlayStatInfoSet.setter
    def DailyPlayStatInfoSet(self, DailyPlayStatInfoSet):
        self._DailyPlayStatInfoSet = DailyPlayStatInfoSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DailyPlayStatInfoSet") is not None:
            self._DailyPlayStatInfoSet = []
            for item in params.get("DailyPlayStatInfoSet"):
                obj = DailyPlayStatInfo()
                obj._deserialize(item)
                self._DailyPlayStatInfoSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDailyMostPlayedStatRequest(AbstractModel):
    r"""DescribeDailyMostPlayedStat请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Date: 查询日期，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。该参数仅日期部分有效。
        :type Date: str
        :param _DomainName: 域名。查询该域名播放 Top100 的媒体文件的统计数据。默认查询所有域名的播放统计数据。
        :type DomainName: str
        :param _Metric: Top 数据的统计指标，取值有：
<li>Traffic：播放流量，按播放流量统计 Top100 的数据。</li>
<li>PlayTimes：播放次数，按播放次数统计播放 Top100 的数据。</li>
默认值为Traffic。
        :type Metric: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._Date = None
        self._DomainName = None
        self._Metric = None
        self._SubAppId = None

    @property
    def Date(self):
        r"""查询日期，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。该参数仅日期部分有效。
        :rtype: str
        """
        return self._Date

    @Date.setter
    def Date(self, Date):
        self._Date = Date

    @property
    def DomainName(self):
        r"""域名。查询该域名播放 Top100 的媒体文件的统计数据。默认查询所有域名的播放统计数据。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def Metric(self):
        r"""Top 数据的统计指标，取值有：
<li>Traffic：播放流量，按播放流量统计 Top100 的数据。</li>
<li>PlayTimes：播放次数，按播放次数统计播放 Top100 的数据。</li>
默认值为Traffic。
        :rtype: str
        """
        return self._Metric

    @Metric.setter
    def Metric(self, Metric):
        self._Metric = Metric

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Date = params.get("Date")
        self._DomainName = params.get("DomainName")
        self._Metric = params.get("Metric")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDailyMostPlayedStatResponse(AbstractModel):
    r"""DescribeDailyMostPlayedStat返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DailyPlayStatInfoSet: 媒体文件播放统计信息。
        :type DailyPlayStatInfoSet: list of DailyPlayStatInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DailyPlayStatInfoSet = None
        self._RequestId = None

    @property
    def DailyPlayStatInfoSet(self):
        r"""媒体文件播放统计信息。
        :rtype: list of DailyPlayStatInfo
        """
        return self._DailyPlayStatInfoSet

    @DailyPlayStatInfoSet.setter
    def DailyPlayStatInfoSet(self, DailyPlayStatInfoSet):
        self._DailyPlayStatInfoSet = DailyPlayStatInfoSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DailyPlayStatInfoSet") is not None:
            self._DailyPlayStatInfoSet = []
            for item in params.get("DailyPlayStatInfoSet"):
                obj = DailyPlayStatInfo()
                obj._deserialize(item)
                self._DailyPlayStatInfoSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDailyPlayStatFileListRequest(AbstractModel):
    r"""DescribeDailyPlayStatFileList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 起始日期，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type StartTime: str
        :param _EndTime: 结束日期，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type EndTime: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._StartTime = None
        self._EndTime = None
        self._SubAppId = None

    @property
    def StartTime(self):
        r"""起始日期，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""结束日期，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDailyPlayStatFileListResponse(AbstractModel):
    r"""DescribeDailyPlayStatFileList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _PlayStatFileSet: 播放统计文件列表。
        :type PlayStatFileSet: list of PlayStatFileInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._PlayStatFileSet = None
        self._RequestId = None

    @property
    def PlayStatFileSet(self):
        r"""播放统计文件列表。
        :rtype: list of PlayStatFileInfo
        """
        return self._PlayStatFileSet

    @PlayStatFileSet.setter
    def PlayStatFileSet(self, PlayStatFileSet):
        self._PlayStatFileSet = PlayStatFileSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("PlayStatFileSet") is not None:
            self._PlayStatFileSet = []
            for item in params.get("PlayStatFileSet"):
                obj = PlayStatFileInfo()
                obj._deserialize(item)
                self._PlayStatFileSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDefaultDistributionConfigRequest(AbstractModel):
    r"""DescribeDefaultDistributionConfig请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._SubAppId = None

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDefaultDistributionConfigResponse(AbstractModel):
    r"""DescribeDefaultDistributionConfig返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DomainName: 分发配置的域名(已废弃）。
        :type DomainName: str
        :param _Domain: 分发配置的域名。
        :type Domain: str
        :param _Scheme: 分发配置的协议，为 HTTP 或 HTTPS。
        :type Scheme: str
        :param _PlayKey: 播放密钥，由大小写字母（a - Z）或者数字（0 - 9）组成，长度在8 - 20个字符之间。
        :type PlayKey: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DomainName = None
        self._Domain = None
        self._Scheme = None
        self._PlayKey = None
        self._RequestId = None

    @property
    def DomainName(self):
        warnings.warn("parameter `DomainName` is deprecated", DeprecationWarning) 

        r"""分发配置的域名(已废弃）。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        warnings.warn("parameter `DomainName` is deprecated", DeprecationWarning) 

        self._DomainName = DomainName

    @property
    def Domain(self):
        r"""分发配置的域名。
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Scheme(self):
        r"""分发配置的协议，为 HTTP 或 HTTPS。
        :rtype: str
        """
        return self._Scheme

    @Scheme.setter
    def Scheme(self, Scheme):
        self._Scheme = Scheme

    @property
    def PlayKey(self):
        r"""播放密钥，由大小写字母（a - Z）或者数字（0 - 9）组成，长度在8 - 20个字符之间。
        :rtype: str
        """
        return self._PlayKey

    @PlayKey.setter
    def PlayKey(self, PlayKey):
        self._PlayKey = PlayKey

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DomainName = params.get("DomainName")
        self._Domain = params.get("Domain")
        self._Scheme = params.get("Scheme")
        self._PlayKey = params.get("PlayKey")
        self._RequestId = params.get("RequestId")


class DescribeDrmDataKeyRequest(AbstractModel):
    r"""DescribeDrmDataKey请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EdkList: 加密后的数据密钥列表，最大支持10个。
        :type EdkList: list of str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._EdkList = None
        self._SubAppId = None

    @property
    def EdkList(self):
        r"""加密后的数据密钥列表，最大支持10个。
        :rtype: list of str
        """
        return self._EdkList

    @EdkList.setter
    def EdkList(self, EdkList):
        self._EdkList = EdkList

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._EdkList = params.get("EdkList")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDrmDataKeyResponse(AbstractModel):
    r"""DescribeDrmDataKey返回参数结构体

    """

    def __init__(self):
        r"""
        :param _KeyList: 密钥列表，包含加密的数据密钥。
        :type KeyList: list of SimpleAesEdkPair
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._KeyList = None
        self._RequestId = None

    @property
    def KeyList(self):
        r"""密钥列表，包含加密的数据密钥。
        :rtype: list of SimpleAesEdkPair
        """
        return self._KeyList

    @KeyList.setter
    def KeyList(self, KeyList):
        self._KeyList = KeyList

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("KeyList") is not None:
            self._KeyList = []
            for item in params.get("KeyList"):
                obj = SimpleAesEdkPair()
                obj._deserialize(item)
                self._KeyList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDrmKeyProviderInfoRequest(AbstractModel):
    r"""DescribeDrmKeyProviderInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._SubAppId = None

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDrmKeyProviderInfoResponse(AbstractModel):
    r"""DescribeDrmKeyProviderInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SDMCInfo: 华曦达（SDMC）相关的 DRM 密钥提供商信息。
        :type SDMCInfo: :class:`tencentcloud.vod.v20180717.models.SDMCDrmKeyProviderInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SDMCInfo = None
        self._RequestId = None

    @property
    def SDMCInfo(self):
        r"""华曦达（SDMC）相关的 DRM 密钥提供商信息。
        :rtype: :class:`tencentcloud.vod.v20180717.models.SDMCDrmKeyProviderInfo`
        """
        return self._SDMCInfo

    @SDMCInfo.setter
    def SDMCInfo(self, SDMCInfo):
        self._SDMCInfo = SDMCInfo

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SDMCInfo") is not None:
            self._SDMCInfo = SDMCDrmKeyProviderInfo()
            self._SDMCInfo._deserialize(params.get("SDMCInfo"))
        self._RequestId = params.get("RequestId")


class DescribeEnhanceMediaTemplatesRequest(AbstractModel):
    r"""DescribeEnhanceMediaTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Definitions: 音画质重生模板列表。长度限制：100。
        :type Definitions: list of int
        :param _Type: 模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :type Type: str
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        """
        self._SubAppId = None
        self._Definitions = None
        self._Type = None
        self._Offset = None
        self._Limit = None

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Definitions(self):
        r"""音画质重生模板列表。长度限制：100。
        :rtype: list of int
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Type(self):
        r"""模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Offset(self):
        r"""分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Definitions = params.get("Definitions")
        self._Type = params.get("Type")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEnhanceMediaTemplatesResponse(AbstractModel):
    r"""DescribeEnhanceMediaTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _RebuildMediaTemplateSet: 音画质重生模板详情列表。
        :type RebuildMediaTemplateSet: list of RebuildMediaTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._RebuildMediaTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RebuildMediaTemplateSet(self):
        r"""音画质重生模板详情列表。
        :rtype: list of RebuildMediaTemplate
        """
        return self._RebuildMediaTemplateSet

    @RebuildMediaTemplateSet.setter
    def RebuildMediaTemplateSet(self, RebuildMediaTemplateSet):
        self._RebuildMediaTemplateSet = RebuildMediaTemplateSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("RebuildMediaTemplateSet") is not None:
            self._RebuildMediaTemplateSet = []
            for item in params.get("RebuildMediaTemplateSet"):
                obj = RebuildMediaTemplate()
                obj._deserialize(item)
                self._RebuildMediaTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeEventConfigRequest(AbstractModel):
    r"""DescribeEventConfig请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._SubAppId = None

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEventConfigResponse(AbstractModel):
    r"""DescribeEventConfig返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Mode: 接收事件通知的方式。"PUSH" 为 [普通回调](https://cloud.tencent.com/document/product/266/33779#.E6.99.AE.E9.80.9A.E5.9B.9E.E8.B0.83)，"PULL" 为 [可靠回调](https://cloud.tencent.com/document/product/266/33779#.E5.8F.AF.E9.9D.A0.E5.9B.9E.E8.B0.83)。
        :type Mode: str
        :param _NotificationUrl: 采用 [普通回调](https://cloud.tencent.com/document/product/266/33779#.E6.99.AE.E9.80.9A.E5.9B.9E.E8.B0.83) 模式时，用于接收 V3 版本事件通知的地址。
        :type NotificationUrl: str
        :param _UploadMediaCompleteEventSwitch: 是否接收 [视频上传完成](https://cloud.tencent.com/document/product/266/7830) 事件通知，"OFF" 为忽略该事件通知，"ON" 为接收事件通知。
        :type UploadMediaCompleteEventSwitch: str
        :param _DeleteMediaCompleteEventSwitch: 是否接收 [视频删除完成](https://cloud.tencent.com/document/product/266/13434) 事件通知，"OFF" 为忽略该事件通知，"ON" 为接收事件通知。
        :type DeleteMediaCompleteEventSwitch: str
        :param _PersistenceCompleteEventSwitch: 是否接收剪辑固化完成事件通知，"OFF" 为忽略该事件通知，"ON" 为接收事件通知。
        :type PersistenceCompleteEventSwitch: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Mode = None
        self._NotificationUrl = None
        self._UploadMediaCompleteEventSwitch = None
        self._DeleteMediaCompleteEventSwitch = None
        self._PersistenceCompleteEventSwitch = None
        self._RequestId = None

    @property
    def Mode(self):
        r"""接收事件通知的方式。"PUSH" 为 [普通回调](https://cloud.tencent.com/document/product/266/33779#.E6.99.AE.E9.80.9A.E5.9B.9E.E8.B0.83)，"PULL" 为 [可靠回调](https://cloud.tencent.com/document/product/266/33779#.E5.8F.AF.E9.9D.A0.E5.9B.9E.E8.B0.83)。
        :rtype: str
        """
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def NotificationUrl(self):
        r"""采用 [普通回调](https://cloud.tencent.com/document/product/266/33779#.E6.99.AE.E9.80.9A.E5.9B.9E.E8.B0.83) 模式时，用于接收 V3 版本事件通知的地址。
        :rtype: str
        """
        return self._NotificationUrl

    @NotificationUrl.setter
    def NotificationUrl(self, NotificationUrl):
        self._NotificationUrl = NotificationUrl

    @property
    def UploadMediaCompleteEventSwitch(self):
        r"""是否接收 [视频上传完成](https://cloud.tencent.com/document/product/266/7830) 事件通知，"OFF" 为忽略该事件通知，"ON" 为接收事件通知。
        :rtype: str
        """
        return self._UploadMediaCompleteEventSwitch

    @UploadMediaCompleteEventSwitch.setter
    def UploadMediaCompleteEventSwitch(self, UploadMediaCompleteEventSwitch):
        self._UploadMediaCompleteEventSwitch = UploadMediaCompleteEventSwitch

    @property
    def DeleteMediaCompleteEventSwitch(self):
        r"""是否接收 [视频删除完成](https://cloud.tencent.com/document/product/266/13434) 事件通知，"OFF" 为忽略该事件通知，"ON" 为接收事件通知。
        :rtype: str
        """
        return self._DeleteMediaCompleteEventSwitch

    @DeleteMediaCompleteEventSwitch.setter
    def DeleteMediaCompleteEventSwitch(self, DeleteMediaCompleteEventSwitch):
        self._DeleteMediaCompleteEventSwitch = DeleteMediaCompleteEventSwitch

    @property
    def PersistenceCompleteEventSwitch(self):
        r"""是否接收剪辑固化完成事件通知，"OFF" 为忽略该事件通知，"ON" 为接收事件通知。
        :rtype: str
        """
        return self._PersistenceCompleteEventSwitch

    @PersistenceCompleteEventSwitch.setter
    def PersistenceCompleteEventSwitch(self, PersistenceCompleteEventSwitch):
        self._PersistenceCompleteEventSwitch = PersistenceCompleteEventSwitch

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Mode = params.get("Mode")
        self._NotificationUrl = params.get("NotificationUrl")
        self._UploadMediaCompleteEventSwitch = params.get("UploadMediaCompleteEventSwitch")
        self._DeleteMediaCompleteEventSwitch = params.get("DeleteMediaCompleteEventSwitch")
        self._PersistenceCompleteEventSwitch = params.get("PersistenceCompleteEventSwitch")
        self._RequestId = params.get("RequestId")


class DescribeEventsStateRequest(AbstractModel):
    r"""DescribeEventsState请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._SubAppId = None

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEventsStateResponse(AbstractModel):
    r"""DescribeEventsState返回参数结构体

    """

    def __init__(self):
        r"""
        :param _CountOfEventsToPull: 待进行拉取的事件通知数，为近似值，约5秒延迟。
        :type CountOfEventsToPull: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._CountOfEventsToPull = None
        self._RequestId = None

    @property
    def CountOfEventsToPull(self):
        r"""待进行拉取的事件通知数，为近似值，约5秒延迟。
        :rtype: int
        """
        return self._CountOfEventsToPull

    @CountOfEventsToPull.setter
    def CountOfEventsToPull(self, CountOfEventsToPull):
        self._CountOfEventsToPull = CountOfEventsToPull

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._CountOfEventsToPull = params.get("CountOfEventsToPull")
        self._RequestId = params.get("RequestId")


class DescribeFileAttributesRequest(AbstractModel):
    r"""DescribeFileAttributes请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FileId: 媒体文件 ID
        :type FileId: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _SessionId: 用于去重的识别码，如果三天内曾有过相同的识别码的请求，则本次的请求会返回错误。最长 50 个字符，不带或者带空字符串表示不做去重。
        :type SessionId: str
        :param _SessionContext: 来源上下文，用于透传用户请求信息，任务流状态变更回调将返回该字段值，最长 1000 个字符。
        :type SessionContext: str
        :param _TasksPriority: 任务优先级，数值越大优先级越高，取值范围是-10到 10，不填代表0。
        :type TasksPriority: int
        :param _ExtInfo: 保留字段，特殊用途时使用。
        :type ExtInfo: str
        """
        self._FileId = None
        self._SubAppId = None
        self._SessionId = None
        self._SessionContext = None
        self._TasksPriority = None
        self._ExtInfo = None

    @property
    def FileId(self):
        r"""媒体文件 ID
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def SessionId(self):
        r"""用于去重的识别码，如果三天内曾有过相同的识别码的请求，则本次的请求会返回错误。最长 50 个字符，不带或者带空字符串表示不做去重。
        :rtype: str
        """
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def SessionContext(self):
        r"""来源上下文，用于透传用户请求信息，任务流状态变更回调将返回该字段值，最长 1000 个字符。
        :rtype: str
        """
        return self._SessionContext

    @SessionContext.setter
    def SessionContext(self, SessionContext):
        self._SessionContext = SessionContext

    @property
    def TasksPriority(self):
        r"""任务优先级，数值越大优先级越高，取值范围是-10到 10，不填代表0。
        :rtype: int
        """
        return self._TasksPriority

    @TasksPriority.setter
    def TasksPriority(self, TasksPriority):
        self._TasksPriority = TasksPriority

    @property
    def ExtInfo(self):
        r"""保留字段，特殊用途时使用。
        :rtype: str
        """
        return self._ExtInfo

    @ExtInfo.setter
    def ExtInfo(self, ExtInfo):
        self._ExtInfo = ExtInfo


    def _deserialize(self, params):
        self._FileId = params.get("FileId")
        self._SubAppId = params.get("SubAppId")
        self._SessionId = params.get("SessionId")
        self._SessionContext = params.get("SessionContext")
        self._TasksPriority = params.get("TasksPriority")
        self._ExtInfo = params.get("ExtInfo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFileAttributesResponse(AbstractModel):
    r"""DescribeFileAttributes返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务 ID 。
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        r"""任务 ID 。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class DescribeFileAttributesTask(AbstractModel):
    r"""获取文件属性任务信息

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务 ID。
        :type TaskId: str
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败：
<li>40000：输入参数不合法，请检查输入参数；</li>
<li>60000：源文件错误（如视频数据损坏），请确认源文件是否正常；</li>
<li>70000：内部服务错误，建议重试。</li>
        :type ErrCode: int
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _Message: 错误信息。
        :type Message: str
        :param _Progress: 任务进度，取值范围 [0-100] 。
        :type Progress: int
        :param _FileId: 媒体文件 ID。
        :type FileId: str
        :param _Output: 获取媒体文件属性任务的输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.vod.v20180717.models.DescribeFileAttributesTaskOutput`
        :param _SessionId: 用于去重的识别码，如果七天内曾有过相同的识别码的请求，则本次的请求会返回错误。最长 50 个字符，不带或者带空字符串表示不做去重。
        :type SessionId: str
        :param _SessionContext: 来源上下文，用于透传用户请求信息，任务流状态变更回调将返回该字段值，最长 1000 个字符。
        :type SessionContext: str
        """
        self._TaskId = None
        self._Status = None
        self._ErrCode = None
        self._ErrCodeExt = None
        self._Message = None
        self._Progress = None
        self._FileId = None
        self._Output = None
        self._SessionId = None
        self._SessionContext = None

    @property
    def TaskId(self):
        r"""任务 ID。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        r"""错误码，0 表示成功，其他值表示失败：
<li>40000：输入参数不合法，请检查输入参数；</li>
<li>60000：源文件错误（如视频数据损坏），请确认源文件是否正常；</li>
<li>70000：内部服务错误，建议重试。</li>
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [视频处理类错误码](https://cloud.tencent.com/document/product/266/50368#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Progress(self):
        r"""任务进度，取值范围 [0-100] 。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def FileId(self):
        r"""媒体文件 ID。
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def Output(self):
        r"""获取媒体文件属性任务的输出。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vod.v20180717.models.DescribeFileAttributesTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def SessionId(self):
        r"""用于去重的识别码，如果七天内曾有过相同的识别码的请求，则本次的请求会返回错误。最长 50 个字符，不带或者带空字符串表示不做去重。
        :rtype: str
        """
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def SessionContext(self):
        r"""来源上下文，用于透传用户请求信息，任务流状态变更回调将返回该字段值，最长 1000 个字符。
        :rtype: str
        """
        return self._SessionContext

    @SessionContext.setter
    def SessionContext(self, SessionContext):
        self._SessionContext = SessionContext


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._Message = params.get("Message")
        self._Progress = params.get("Progress")
        self._FileId = params.get("FileId")
        if params.get("Output") is not None:
            self._Output = DescribeFileAttributesTaskOutput()
            self._Output._deserialize(params.get("Output"))
        self._SessionId = params.get("SessionId")
        self._SessionContext = params.get("SessionContext")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFileAttributesTaskOutput(AbstractModel):
    r"""获取文件属性任务输出

    """

    def __init__(self):
        r"""
        :param _Md5: 媒体文件的 Md5 值。
        :type Md5: str
        :param _Sha1: 媒体文件的 Sha1 值。
        :type Sha1: str
        """
        self._Md5 = None
        self._Sha1 = None

    @property
    def Md5(self):
        r"""媒体文件的 Md5 值。
        :rtype: str
        """
        return self._Md5

    @Md5.setter
    def Md5(self, Md5):
        self._Md5 = Md5

    @property
    def Sha1(self):
        r"""媒体文件的 Sha1 值。
        :rtype: str
        """
        return self._Sha1

    @Sha1.setter
    def Sha1(self, Sha1):
        self._Sha1 = Sha1


    def _deserialize(self, params):
        self._Md5 = params.get("Md5")
        self._Sha1 = params.get("Sha1")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeHeadTailTemplatesRequest(AbstractModel):
    r"""DescribeHeadTailTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Definitions: 片头片尾模板号，数组长度限制：100。
        :type Definitions: list of int
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        """
        self._SubAppId = None
        self._Definitions = None
        self._Offset = None
        self._Limit = None

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Definitions(self):
        r"""片头片尾模板号，数组长度限制：100。
        :rtype: list of int
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        r"""分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeHeadTailTemplatesResponse(AbstractModel):
    r"""DescribeHeadTailTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _HeadTailTemplateSet: 片头片尾模板详情列表。
        :type HeadTailTemplateSet: list of HeadTailTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._HeadTailTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def HeadTailTemplateSet(self):
        r"""片头片尾模板详情列表。
        :rtype: list of HeadTailTemplate
        """
        return self._HeadTailTemplateSet

    @HeadTailTemplateSet.setter
    def HeadTailTemplateSet(self, HeadTailTemplateSet):
        self._HeadTailTemplateSet = HeadTailTemplateSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("HeadTailTemplateSet") is not None:
            self._HeadTailTemplateSet = []
            for item in params.get("HeadTailTemplateSet"):
                obj = HeadTailTemplate()
                obj._deserialize(item)
                self._HeadTailTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeImageProcessingTemplatesRequest(AbstractModel):
    r"""DescribeImageProcessingTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Definitions: 图片处理模板标识列表。长度限制：100。
        :type Definitions: list of int non-negative
        :param _Type: 模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :type Type: str
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        """
        self._SubAppId = None
        self._Definitions = None
        self._Type = None
        self._Offset = None
        self._Limit = None

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Definitions(self):
        r"""图片处理模板标识列表。长度限制：100。
        :rtype: list of int non-negative
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Type(self):
        r"""模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Offset(self):
        r"""分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Definitions = params.get("Definitions")
        self._Type = params.get("Type")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeImageProcessingTemplatesResponse(AbstractModel):
    r"""DescribeImageProcessingTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _ImageProcessingTemplateSet: 图片处理模板详情列表。
        :type ImageProcessingTemplateSet: list of ImageProcessingTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._ImageProcessingTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ImageProcessingTemplateSet(self):
        r"""图片处理模板详情列表。
        :rtype: list of ImageProcessingTemplate
        """
        return self._ImageProcessingTemplateSet

    @ImageProcessingTemplateSet.setter
    def ImageProcessingTemplateSet(self, ImageProcessingTemplateSet):
        self._ImageProcessingTemplateSet = ImageProcessingTemplateSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ImageProcessingTemplateSet") is not None:
            self._ImageProcessingTemplateSet = []
            for item in params.get("ImageProcessingTemplateSet"):
                obj = ImageProcessingTemplate()
                obj._deserialize(item)
                self._ImageProcessingTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeImageReviewUsageDataRequest(AbstractModel):
    r"""DescribeImageReviewUsageData请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 起始日期。使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#52)。
        :type StartTime: str
        :param _EndTime: 结束日期，需大于等于起始日期。使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#52)。
        :type EndTime: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._StartTime = None
        self._EndTime = None
        self._SubAppId = None

    @property
    def StartTime(self):
        r"""起始日期。使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#52)。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""结束日期，需大于等于起始日期。使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#52)。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeImageReviewUsageDataResponse(AbstractModel):
    r"""DescribeImageReviewUsageData返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ImageReviewUsageDataSet: 图片审核次数统计数据，展示查询时间范围内的图片审核次数的概览数据。
        :type ImageReviewUsageDataSet: list of ImageReviewUsageDataItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ImageReviewUsageDataSet = None
        self._RequestId = None

    @property
    def ImageReviewUsageDataSet(self):
        r"""图片审核次数统计数据，展示查询时间范围内的图片审核次数的概览数据。
        :rtype: list of ImageReviewUsageDataItem
        """
        return self._ImageReviewUsageDataSet

    @ImageReviewUsageDataSet.setter
    def ImageReviewUsageDataSet(self, ImageReviewUsageDataSet):
        self._ImageReviewUsageDataSet = ImageReviewUsageDataSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ImageReviewUsageDataSet") is not None:
            self._ImageReviewUsageDataSet = []
            for item in params.get("ImageReviewUsageDataSet"):
                obj = ImageReviewUsageDataItem()
                obj._deserialize(item)
                self._ImageReviewUsageDataSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeImageSpriteTemplatesRequest(AbstractModel):
    r"""DescribeImageSpriteTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Definitions: 雪碧图模板唯一标识过滤条件，数组长度限制：100。
        :type Definitions: list of int non-negative
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        :param _Type: 模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :type Type: str
        """
        self._SubAppId = None
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Definitions(self):
        r"""雪碧图模板唯一标识过滤条件，数组长度限制：100。
        :rtype: list of int non-negative
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        r"""分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        r"""模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeImageSpriteTemplatesResponse(AbstractModel):
    r"""DescribeImageSpriteTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _ImageSpriteTemplateSet: 雪碧图模板详情列表。
        :type ImageSpriteTemplateSet: list of ImageSpriteTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._ImageSpriteTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ImageSpriteTemplateSet(self):
        r"""雪碧图模板详情列表。
        :rtype: list of ImageSpriteTemplate
        """
        return self._ImageSpriteTemplateSet

    @ImageSpriteTemplateSet.setter
    def ImageSpriteTemplateSet(self, ImageSpriteTemplateSet):
        self._ImageSpriteTemplateSet = ImageSpriteTemplateSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ImageSpriteTemplateSet") is not None:
            self._ImageSpriteTemplateSet = []
            for item in params.get("ImageSpriteTemplateSet"):
                obj = ImageSpriteTemplate()
                obj._deserialize(item)
                self._ImageSpriteTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeJustInTimeTranscodeTemplatesRequest(AbstractModel):
    r"""DescribeJustInTimeTranscodeTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Names: 模板名过滤条件，数组长度限制：100。
        :type Names: list of str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Type: 模板类型过滤条件，可选值：
<li>Preset：系统预置任务流模板；</li>
<li>Custom：用户自定义任务流模板。</li>
        :type Type: str
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        """
        self._Names = None
        self._SubAppId = None
        self._Type = None
        self._Offset = None
        self._Limit = None

    @property
    def Names(self):
        r"""模板名过滤条件，数组长度限制：100。
        :rtype: list of str
        """
        return self._Names

    @Names.setter
    def Names(self, Names):
        self._Names = Names

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Type(self):
        r"""模板类型过滤条件，可选值：
<li>Preset：系统预置任务流模板；</li>
<li>Custom：用户自定义任务流模板。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Offset(self):
        r"""分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._Names = params.get("Names")
        self._SubAppId = params.get("SubAppId")
        self._Type = params.get("Type")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeJustInTimeTranscodeTemplatesResponse(AbstractModel):
    r"""DescribeJustInTimeTranscodeTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _JustInTimeTranscodeTemplateSet: 模板详情列表。
        :type JustInTimeTranscodeTemplateSet: list of JustInTimeTranscodeTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._JustInTimeTranscodeTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def JustInTimeTranscodeTemplateSet(self):
        r"""模板详情列表。
        :rtype: list of JustInTimeTranscodeTemplate
        """
        return self._JustInTimeTranscodeTemplateSet

    @JustInTimeTranscodeTemplateSet.setter
    def JustInTimeTranscodeTemplateSet(self, JustInTimeTranscodeTemplateSet):
        self._JustInTimeTranscodeTemplateSet = JustInTimeTranscodeTemplateSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("JustInTimeTranscodeTemplateSet") is not None:
            self._JustInTimeTranscodeTemplateSet = []
            for item in params.get("JustInTimeTranscodeTemplateSet"):
                obj = JustInTimeTranscodeTemplate()
                obj._deserialize(item)
                self._JustInTimeTranscodeTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLicenseUsageDataRequest(AbstractModel):
    r"""DescribeLicenseUsageData请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 起始日期。使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#52)。
        :type StartTime: str
        :param _EndTime: 结束日期，需大于等于起始日期。使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#52)。
        :type EndTime: str
        :param _LicenseType: License 类型，默认为 CommercialDRMLicense 。目前支持的 License 类型包括：
<li> CommercialDRMLicense: 商业级 DRM License</li>
        :type LicenseType: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._StartTime = None
        self._EndTime = None
        self._LicenseType = None
        self._SubAppId = None

    @property
    def StartTime(self):
        r"""起始日期。使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#52)。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""结束日期，需大于等于起始日期。使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#52)。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def LicenseType(self):
        r"""License 类型，默认为 CommercialDRMLicense 。目前支持的 License 类型包括：
<li> CommercialDRMLicense: 商业级 DRM License</li>
        :rtype: str
        """
        return self._LicenseType

    @LicenseType.setter
    def LicenseType(self, LicenseType):
        self._LicenseType = LicenseType

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._LicenseType = params.get("LicenseType")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLicenseUsageDataResponse(AbstractModel):
    r"""DescribeLicenseUsageData返回参数结构体

    """

    def __init__(self):
        r"""
        :param _LicenseUsageDataSet: License 查询次数统计数据，展示所查询 License 次数的明细数据。
        :type LicenseUsageDataSet: list of LicenseUsageDataItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._LicenseUsageDataSet = None
        self._RequestId = None

    @property
    def LicenseUsageDataSet(self):
        r"""License 查询次数统计数据，展示所查询 License 次数的明细数据。
        :rtype: list of LicenseUsageDataItem
        """
        return self._LicenseUsageDataSet

    @LicenseUsageDataSet.setter
    def LicenseUsageDataSet(self, LicenseUsageDataSet):
        self._LicenseUsageDataSet = LicenseUsageDataSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("LicenseUsageDataSet") is not None:
            self._LicenseUsageDataSet = []
            for item in params.get("LicenseUsageDataSet"):
                obj = LicenseUsageDataItem()
                obj._deserialize(item)
                self._LicenseUsageDataSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeMPSTemplatesRequest(AbstractModel):
    r"""DescribeMPSTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。</b>
        :type SubAppId: int
        :param _TemplateType: MPS 模板类型。根据需要查询的 MPS 模板的类型对结果进行过滤。取值：
<li>Transcode: 查询转码模板列表。</li>
        :type TemplateType: str
        :param _MPSDescribeTemplateParams: MPS 查询模板参数。该参数用于透传至媒体处理服务（MPS），从云点播侧查询 MPS 任务模板列表。目前仅支持通过此方式查询以下任务类型的模板：
1. 音视频增强：仅支持填写“[获取转码模板列表](https://cloud.tencent.com/document/product/862/37593)”接口中的 Definitions、Offset 和 Limit 几个参数的内容。目前仅支持在模板中配置以上参数，其他参数无需填写，若包含其它参数，系统将自动忽略。
        :type MPSDescribeTemplateParams: str
        """
        self._SubAppId = None
        self._TemplateType = None
        self._MPSDescribeTemplateParams = None

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def TemplateType(self):
        r"""MPS 模板类型。根据需要查询的 MPS 模板的类型对结果进行过滤。取值：
<li>Transcode: 查询转码模板列表。</li>
        :rtype: str
        """
        return self._TemplateType

    @TemplateType.setter
    def TemplateType(self, TemplateType):
        self._TemplateType = TemplateType

    @property
    def MPSDescribeTemplateParams(self):
        r"""MPS 查询模板参数。该参数用于透传至媒体处理服务（MPS），从云点播侧查询 MPS 任务模板列表。目前仅支持通过此方式查询以下任务类型的模板：
1. 音视频增强：仅支持填写“[获取转码模板列表](https://cloud.tencent.com/document/product/862/37593)”接口中的 Definitions、Offset 和 Limit 几个参数的内容。目前仅支持在模板中配置以上参数，其他参数无需填写，若包含其它参数，系统将自动忽略。
        :rtype: str
        """
        return self._MPSDescribeTemplateParams

    @MPSDescribeTemplateParams.setter
    def MPSDescribeTemplateParams(self, MPSDescribeTemplateParams):
        self._MPSDescribeTemplateParams = MPSDescribeTemplateParams


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._TemplateType = params.get("TemplateType")
        self._MPSDescribeTemplateParams = params.get("MPSDescribeTemplateParams")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMPSTemplatesResponse(AbstractModel):
    r"""DescribeMPSTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _MPSTemplateSet: MPS 任务模板详情列表。
        :type MPSTemplateSet: list of MPSTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._MPSTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def MPSTemplateSet(self):
        r"""MPS 任务模板详情列表。
        :rtype: list of MPSTemplate
        """
        return self._MPSTemplateSet

    @MPSTemplateSet.setter
    def MPSTemplateSet(self, MPSTemplateSet):
        self._MPSTemplateSet = MPSTemplateSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("MPSTemplateSet") is not None:
            self._MPSTemplateSet = []
            for item in params.get("MPSTemplateSet"):
                obj = MPSTemplate()
                obj._deserialize(item)
                self._MPSTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeMediaInfosRequest(AbstractModel):
    r"""DescribeMediaInfos请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FileIds: 媒体文件 ID 列表，N 从 0 开始取值，最大 19。
        :type FileIds: list of str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Filters: 指定所有媒体文件需要返回的信息，可同时指定多个信息，N 从 0 开始递增。如果未填写该字段，默认返回所有信息。选项有：
<li>basicInfo（视频基础信息）。</li>
<li>metaData（视频元信息）。</li>
<li>transcodeInfo（视频转码结果信息）。</li>
<li>animatedGraphicsInfo（视频转动图结果信息）。</li>
<li>imageSpriteInfo（视频雪碧图信息）。</li>
<li>snapshotByTimeOffsetInfo（视频指定时间点截图信息）。</li>
<li>sampleSnapshotInfo（采样截图信息）。</li>
<li>keyFrameDescInfo（打点信息）。</li>
<li>adaptiveDynamicStreamingInfo（转自适应码流信息）。</li>
<li>miniProgramReviewInfo（小程序审核信息）。</li>
<li>subtitleInfo（字幕信息）。</li>
<li>reviewInfo（审核信息）。</li>
        :type Filters: list of str
        """
        self._FileIds = None
        self._SubAppId = None
        self._Filters = None

    @property
    def FileIds(self):
        r"""媒体文件 ID 列表，N 从 0 开始取值，最大 19。
        :rtype: list of str
        """
        return self._FileIds

    @FileIds.setter
    def FileIds(self, FileIds):
        self._FileIds = FileIds

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Filters(self):
        r"""指定所有媒体文件需要返回的信息，可同时指定多个信息，N 从 0 开始递增。如果未填写该字段，默认返回所有信息。选项有：
<li>basicInfo（视频基础信息）。</li>
<li>metaData（视频元信息）。</li>
<li>transcodeInfo（视频转码结果信息）。</li>
<li>animatedGraphicsInfo（视频转动图结果信息）。</li>
<li>imageSpriteInfo（视频雪碧图信息）。</li>
<li>snapshotByTimeOffsetInfo（视频指定时间点截图信息）。</li>
<li>sampleSnapshotInfo（采样截图信息）。</li>
<li>keyFrameDescInfo（打点信息）。</li>
<li>adaptiveDynamicStreamingInfo（转自适应码流信息）。</li>
<li>miniProgramReviewInfo（小程序审核信息）。</li>
<li>subtitleInfo（字幕信息）。</li>
<li>reviewInfo（审核信息）。</li>
        :rtype: list of str
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._FileIds = params.get("FileIds")
        self._SubAppId = params.get("SubAppId")
        self._Filters = params.get("Filters")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMediaInfosResponse(AbstractModel):
    r"""DescribeMediaInfos返回参数结构体

    """

    def __init__(self):
        r"""
        :param _MediaInfoSet: 媒体文件信息列表。
        :type MediaInfoSet: list of MediaInfo
        :param _NotExistFileIdSet: 不存在的文件 ID 列表。
        :type NotExistFileIdSet: list of str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._MediaInfoSet = None
        self._NotExistFileIdSet = None
        self._RequestId = None

    @property
    def MediaInfoSet(self):
        r"""媒体文件信息列表。
        :rtype: list of MediaInfo
        """
        return self._MediaInfoSet

    @MediaInfoSet.setter
    def MediaInfoSet(self, MediaInfoSet):
        self._MediaInfoSet = MediaInfoSet

    @property
    def NotExistFileIdSet(self):
        r"""不存在的文件 ID 列表。
        :rtype: list of str
        """
        return self._NotExistFileIdSet

    @NotExistFileIdSet.setter
    def NotExistFileIdSet(self, NotExistFileIdSet):
        self._NotExistFileIdSet = NotExistFileIdSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("MediaInfoSet") is not None:
            self._MediaInfoSet = []
            for item in params.get("MediaInfoSet"):
                obj = MediaInfo()
                obj._deserialize(item)
                self._MediaInfoSet.append(obj)
        self._NotExistFileIdSet = params.get("NotExistFileIdSet")
        self._RequestId = params.get("RequestId")


class DescribeMediaPlayStatDetailsRequest(AbstractModel):
    r"""DescribeMediaPlayStatDetails请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FileId: 媒体文件 ID。
        :type FileId: str
        :param _StartTime: 起始时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type StartTime: str
        :param _EndTime: 结束时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type EndTime: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Interval: 统计时间粒度，有效值：
<li>Hour：以小时为粒度。</li>
<li>Day：以天为粒度。</li>
默认按时间跨度决定，小于1天以小时为粒度，大于等于1天则以天为粒度。
        :type Interval: str
        """
        self._FileId = None
        self._StartTime = None
        self._EndTime = None
        self._SubAppId = None
        self._Interval = None

    @property
    def FileId(self):
        r"""媒体文件 ID。
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def StartTime(self):
        r"""起始时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""结束时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Interval(self):
        r"""统计时间粒度，有效值：
<li>Hour：以小时为粒度。</li>
<li>Day：以天为粒度。</li>
默认按时间跨度决定，小于1天以小时为粒度，大于等于1天则以天为粒度。
        :rtype: str
        """
        return self._Interval

    @Interval.setter
    def Interval(self, Interval):
        self._Interval = Interval


    def _deserialize(self, params):
        self._FileId = params.get("FileId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._SubAppId = params.get("SubAppId")
        self._Interval = params.get("Interval")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMediaPlayStatDetailsResponse(AbstractModel):
    r"""DescribeMediaPlayStatDetails返回参数结构体

    """

    def __init__(self):
        r"""
        :param _PlayStatInfoSet: 播放统计数据。
        :type PlayStatInfoSet: list of PlayStatInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._PlayStatInfoSet = None
        self._RequestId = None

    @property
    def PlayStatInfoSet(self):
        r"""播放统计数据。
        :rtype: list of PlayStatInfo
        """
        return self._PlayStatInfoSet

    @PlayStatInfoSet.setter
    def PlayStatInfoSet(self, PlayStatInfoSet):
        self._PlayStatInfoSet = PlayStatInfoSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("PlayStatInfoSet") is not None:
            self._PlayStatInfoSet = []
            for item in params.get("PlayStatInfoSet"):
                obj = PlayStatInfo()
                obj._deserialize(item)
                self._PlayStatInfoSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeMediaProcessUsageDataRequest(AbstractModel):
    r"""DescribeMediaProcessUsageData请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 起始日期。使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#52)。
        :type StartTime: str
        :param _EndTime: 结束日期，需大于等于起始日期。使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#52)。
        :type EndTime: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Type: 查询视频处理任务类型，目前支持的任务类型包括：
<li> Transcoding: 普通转码</li>
<li> Transcoding-TESHD: 极速高清转码</li>
<li> Editing: 视频编辑</li>
<li> Editing-TESHD: 极速高清视频编辑</li>
<li> AdaptiveBitrateStreaming: 自适应码流</li>
<li> ContentAudit: 内容审核</li>
<li> ContentRecognition: 内容识别</li>
<li> RemoveWatermark: 去除水印</li>
<li> ExtractTraceWatermark: 提取水印</li>
<li> AddTraceWatermark: 添加水印</li>
<li> RebuildMedia: 音画质重生</li>
<li> QualityInspect: 音画质检测</li>
<li> VideoHighlight: 视频智能集锦</li>
<li> VideoTag: 视频智能标签</li>
<li> VideoClassification:  视频智能分类</li>
<li> VideoCover: 视频智能封面</li>
<li> VideoSegment: 视频智能拆条</li>
<li> VideoProduce: 视频制作</li>
<li> MediaCast: 媒体转推</li>
<li>Transcode: 转码，包含普通转码、极速高清和视频编辑（不推荐使用）</li>
<li>VoiceTranslation: 语音翻译</li>
<li>JITTranscoding: 即时转码</li>
<li>VideoSnapshot: 视频截图</li>
<li>JITEncryption: 即时加密</li>

        :type Type: str
        """
        self._StartTime = None
        self._EndTime = None
        self._SubAppId = None
        self._Type = None

    @property
    def StartTime(self):
        r"""起始日期。使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#52)。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""结束日期，需大于等于起始日期。使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#52)。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Type(self):
        r"""查询视频处理任务类型，目前支持的任务类型包括：
<li> Transcoding: 普通转码</li>
<li> Transcoding-TESHD: 极速高清转码</li>
<li> Editing: 视频编辑</li>
<li> Editing-TESHD: 极速高清视频编辑</li>
<li> AdaptiveBitrateStreaming: 自适应码流</li>
<li> ContentAudit: 内容审核</li>
<li> ContentRecognition: 内容识别</li>
<li> RemoveWatermark: 去除水印</li>
<li> ExtractTraceWatermark: 提取水印</li>
<li> AddTraceWatermark: 添加水印</li>
<li> RebuildMedia: 音画质重生</li>
<li> QualityInspect: 音画质检测</li>
<li> VideoHighlight: 视频智能集锦</li>
<li> VideoTag: 视频智能标签</li>
<li> VideoClassification:  视频智能分类</li>
<li> VideoCover: 视频智能封面</li>
<li> VideoSegment: 视频智能拆条</li>
<li> VideoProduce: 视频制作</li>
<li> MediaCast: 媒体转推</li>
<li>Transcode: 转码，包含普通转码、极速高清和视频编辑（不推荐使用）</li>
<li>VoiceTranslation: 语音翻译</li>
<li>JITTranscoding: 即时转码</li>
<li>VideoSnapshot: 视频截图</li>
<li>JITEncryption: 即时加密</li>

        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._SubAppId = params.get("SubAppId")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMediaProcessUsageDataResponse(AbstractModel):
    r"""DescribeMediaProcessUsageData返回参数结构体

    """

    def __init__(self):
        r"""
        :param _MediaProcessDataSet: 视频处理统计数据概览，展示所查询任务的概览以及详细数据。
        :type MediaProcessDataSet: list of TaskStatData
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._MediaProcessDataSet = None
        self._RequestId = None

    @property
    def MediaProcessDataSet(self):
        r"""视频处理统计数据概览，展示所查询任务的概览以及详细数据。
        :rtype: list of TaskStatData
        """
        return self._MediaProcessDataSet

    @MediaProcessDataSet.setter
    def MediaProcessDataSet(self, MediaProcessDataSet):
        self._MediaProcessDataSet = MediaProcessDataSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("MediaProcessDataSet") is not None:
            self._MediaProcessDataSet = []
            for item in params.get("MediaProcessDataSet"):
                obj = TaskStatData()
                obj._deserialize(item)
                self._MediaProcessDataSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribePersonSamplesRequest(AbstractModel):
    r"""DescribePersonSamples请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Type: 拉取的素材类型，可选值：
<li>UserDefine：用户自定义素材库；</li>
<li>Default：系统默认素材库。</li>

默认值：UserDefine，拉取用户自定义素材库素材。
说明：如果是拉取系统默认素材库，只能使用素材名字或者素材 ID + 素材名字的方式进行拉取，且五官图片只返回一张。
        :type Type: str
        :param _PersonIds: 素材 ID，数组长度限制：100。
        :type PersonIds: list of str
        :param _Names: 素材名称，数组长度限制：20。
        :type Names: list of str
        :param _Tags: 素材标签，数组长度限制：20。
        :type Tags: list of str
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：100，最大值：100。
        :type Limit: int
        """
        self._SubAppId = None
        self._Type = None
        self._PersonIds = None
        self._Names = None
        self._Tags = None
        self._Offset = None
        self._Limit = None

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Type(self):
        r"""拉取的素材类型，可选值：
<li>UserDefine：用户自定义素材库；</li>
<li>Default：系统默认素材库。</li>

默认值：UserDefine，拉取用户自定义素材库素材。
说明：如果是拉取系统默认素材库，只能使用素材名字或者素材 ID + 素材名字的方式进行拉取，且五官图片只返回一张。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def PersonIds(self):
        r"""素材 ID，数组长度限制：100。
        :rtype: list of str
        """
        return self._PersonIds

    @PersonIds.setter
    def PersonIds(self, PersonIds):
        self._PersonIds = PersonIds

    @property
    def Names(self):
        r"""素材名称，数组长度限制：20。
        :rtype: list of str
        """
        return self._Names

    @Names.setter
    def Names(self, Names):
        self._Names = Names

    @property
    def Tags(self):
        r"""素材标签，数组长度限制：20。
        :rtype: list of str
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def Offset(self):
        r"""分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回记录条数，默认值：100，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Type = params.get("Type")
        self._PersonIds = params.get("PersonIds")
        self._Names = params.get("Names")
        self._Tags = params.get("Tags")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePersonSamplesResponse(AbstractModel):
    r"""DescribePersonSamples返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合条件的记录总数。
        :type TotalCount: int
        :param _PersonSet: 人物信息。
        :type PersonSet: list of AiSamplePerson
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._PersonSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""符合条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def PersonSet(self):
        r"""人物信息。
        :rtype: list of AiSamplePerson
        """
        return self._PersonSet

    @PersonSet.setter
    def PersonSet(self, PersonSet):
        self._PersonSet = PersonSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("PersonSet") is not None:
            self._PersonSet = []
            for item in params.get("PersonSet"):
                obj = AiSamplePerson()
                obj._deserialize(item)
                self._PersonSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribePrepaidProductsRequest(AbstractModel):
    r"""DescribePrepaidProducts请求参数结构体

    """


class DescribePrepaidProductsResponse(AbstractModel):
    r"""DescribePrepaidProducts返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ProductInstanceSet: 购买的预付费商品实例列表。
        :type ProductInstanceSet: list of ProductInstance
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ProductInstanceSet = None
        self._RequestId = None

    @property
    def ProductInstanceSet(self):
        r"""购买的预付费商品实例列表。
        :rtype: list of ProductInstance
        """
        return self._ProductInstanceSet

    @ProductInstanceSet.setter
    def ProductInstanceSet(self, ProductInstanceSet):
        self._ProductInstanceSet = ProductInstanceSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ProductInstanceSet") is not None:
            self._ProductInstanceSet = []
            for item in params.get("ProductInstanceSet"):
                obj = ProductInstance()
                obj._deserialize(item)
                self._ProductInstanceSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeProcedureTemplatesRequest(AbstractModel):
    r"""DescribeProcedureTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Names: 任务流模板名字过滤条件，数组长度限制：100。
        :type Names: list of str
        :param _Type: 任务流模板类型过滤条件，可选值：
<li>Preset：系统预置任务流模板；</li>
<li>Custom：用户自定义任务流模板。</li>
        :type Type: str
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        """
        self._SubAppId = None
        self._Names = None
        self._Type = None
        self._Offset = None
        self._Limit = None

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Names(self):
        r"""任务流模板名字过滤条件，数组长度限制：100。
        :rtype: list of str
        """
        return self._Names

    @Names.setter
    def Names(self, Names):
        self._Names = Names

    @property
    def Type(self):
        r"""任务流模板类型过滤条件，可选值：
<li>Preset：系统预置任务流模板；</li>
<li>Custom：用户自定义任务流模板。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Offset(self):
        r"""分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Names = params.get("Names")
        self._Type = params.get("Type")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeProcedureTemplatesResponse(AbstractModel):
    r"""DescribeProcedureTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _ProcedureTemplateSet: 任务流模板详情列表。
        :type ProcedureTemplateSet: list of ProcedureTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._ProcedureTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ProcedureTemplateSet(self):
        r"""任务流模板详情列表。
        :rtype: list of ProcedureTemplate
        """
        return self._ProcedureTemplateSet

    @ProcedureTemplateSet.setter
    def ProcedureTemplateSet(self, ProcedureTemplateSet):
        self._ProcedureTemplateSet = ProcedureTemplateSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ProcedureTemplateSet") is not None:
            self._ProcedureTemplateSet = []
            for item in params.get("ProcedureTemplateSet"):
                obj = ProcedureTemplate()
                obj._deserialize(item)
                self._ProcedureTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeQualityInspectTemplatesRequest(AbstractModel):
    r"""DescribeQualityInspectTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Definitions: 音画质检测模板列表。长度限制：100。
        :type Definitions: list of int
        :param _Type: 模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :type Type: str
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        """
        self._SubAppId = None
        self._Definitions = None
        self._Type = None
        self._Offset = None
        self._Limit = None

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Definitions(self):
        r"""音画质检测模板列表。长度限制：100。
        :rtype: list of int
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Type(self):
        r"""模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Offset(self):
        r"""分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Definitions = params.get("Definitions")
        self._Type = params.get("Type")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeQualityInspectTemplatesResponse(AbstractModel):
    r"""DescribeQualityInspectTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _QualityInspectTemplateSet: 音画质检测模板详情列表。
        :type QualityInspectTemplateSet: list of QualityInspectTemplateItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._QualityInspectTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def QualityInspectTemplateSet(self):
        r"""音画质检测模板详情列表。
        :rtype: list of QualityInspectTemplateItem
        """
        return self._QualityInspectTemplateSet

    @QualityInspectTemplateSet.setter
    def QualityInspectTemplateSet(self, QualityInspectTemplateSet):
        self._QualityInspectTemplateSet = QualityInspectTemplateSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("QualityInspectTemplateSet") is not None:
            self._QualityInspectTemplateSet = []
            for item in params.get("QualityInspectTemplateSet"):
                obj = QualityInspectTemplateItem()
                obj._deserialize(item)
                self._QualityInspectTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRebuildMediaTemplatesRequest(AbstractModel):
    r"""DescribeRebuildMediaTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definitions: 视频重生模板列表。
        :type Definitions: list of int
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Type: 模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :type Type: str
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        """
        self._Definitions = None
        self._SubAppId = None
        self._Type = None
        self._Offset = None
        self._Limit = None

    @property
    def Definitions(self):
        r"""视频重生模板列表。
        :rtype: list of int
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Type(self):
        r"""模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Offset(self):
        r"""分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._SubAppId = params.get("SubAppId")
        self._Type = params.get("Type")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRebuildMediaTemplatesResponse(AbstractModel):
    r"""DescribeRebuildMediaTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _RebuildMediaTemplateSet: 视频重生模板详情列表。
        :type RebuildMediaTemplateSet: list of RebuildMediaTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._RebuildMediaTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RebuildMediaTemplateSet(self):
        r"""视频重生模板详情列表。
        :rtype: list of RebuildMediaTemplate
        """
        return self._RebuildMediaTemplateSet

    @RebuildMediaTemplateSet.setter
    def RebuildMediaTemplateSet(self, RebuildMediaTemplateSet):
        self._RebuildMediaTemplateSet = RebuildMediaTemplateSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("RebuildMediaTemplateSet") is not None:
            self._RebuildMediaTemplateSet = []
            for item in params.get("RebuildMediaTemplateSet"):
                obj = RebuildMediaTemplate()
                obj._deserialize(item)
                self._RebuildMediaTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeReviewDetailsRequest(AbstractModel):
    r"""DescribeReviewDetails请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 起始日期。使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type StartTime: str
        :param _EndTime: 结束日期，需大于起始日期。使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type EndTime: str
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        """
        self._StartTime = None
        self._EndTime = None
        self._SubAppId = None

    @property
    def StartTime(self):
        r"""起始日期。使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""结束日期，需大于起始日期。使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeReviewDetailsResponse(AbstractModel):
    r"""DescribeReviewDetails返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 发起内容智能识别次数。
        :type TotalCount: int
        :param _TotalDuration: 内容智能识别总时长。
        :type TotalDuration: int
        :param _Data: 内容智能识别时长统计数据，每天一个数据。
        :type Data: list of StatDataItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._TotalDuration = None
        self._Data = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""发起内容智能识别次数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TotalDuration(self):
        r"""内容智能识别总时长。
        :rtype: int
        """
        return self._TotalDuration

    @TotalDuration.setter
    def TotalDuration(self, TotalDuration):
        self._TotalDuration = TotalDuration

    @property
    def Data(self):
        r"""内容智能识别时长统计数据，每天一个数据。
        :rtype: list of StatDataItem
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        self._TotalDuration = params.get("TotalDuration")
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = StatDataItem()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeReviewTemplatesRequest(AbstractModel):
    r"""DescribeReviewTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _Definitions: 审核模板唯一标识过滤条件，数组长度限制：100。
        :type Definitions: list of int
        :param _Type: 模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :type Type: str
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        """
        self._SubAppId = None
        self._Definitions = None
        self._Type = None
        self._Offset = None
        self._Limit = None

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Definitions(self):
        r"""审核模板唯一标识过滤条件，数组长度限制：100。
        :rtype: list of int
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Type(self):
        r"""模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Offset(self):
        r"""分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Definitions = params.get("Definitions")
        self._Type = params.get("Type")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeReviewTemplatesResponse(AbstractModel):
    r"""DescribeReviewTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _ReviewTemplateSet: 审核模板详情列表。
        :type ReviewTemplateSet: list of ReviewTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._ReviewTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ReviewTemplateSet(self):
        r"""审核模板详情列表。
        :rtype: list of ReviewTemplate
        """
        return self._ReviewTemplateSet

    @ReviewTemplateSet.setter
    def ReviewTemplateSet(self, ReviewTemplateSet):
        self._ReviewTemplateSet = ReviewTemplateSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ReviewTemplateSet") is not None:
            self._ReviewTemplateSet = []
            for item in params.get("ReviewTemplateSet"):
                obj = ReviewTemplate()
                obj._deserialize(item)
                self._ReviewTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRoundPlaysRequest(AbstractModel):
    r"""DescribeRoundPlays请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :type SubAppId: int
        :param _RoundPlayIds: 过滤条件：轮播播单标识，数组长度限制：100。
        :type RoundPlayIds: list of str
        :param _Status: 过滤条件，轮播播单状态，可选值： <li>Enabled：启动状态；</li> <li>Disabled：停止状态。</li>
        :type Status: str
        :param _CreateTime: 过滤条件：轮播播单创建时间。
        :type CreateTime: :class:`tencentcloud.vod.v20180717.models.TimeRange`
        :param _UpdateTime: 过滤条件：轮播播单更新时间。
        :type UpdateTime: :class:`tencentcloud.vod.v20180717.models.TimeRange`
        :param _ScrollToken: 翻页标识，分批拉取时使用：当单次请求无法拉取所有数据，接口将会返回 ScrollToken，下一次请求携带该 Token，将会从下一条记录开始获取。
        :type ScrollToken: str
        :param _Offset: 分页偏移量，默认值：0。已经废弃，请根据 ScrollToken 参数进行分批次查询。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        """
        self._SubAppId = None
        self._RoundPlayIds = None
        self._Status = None
        self._CreateTime = None
        self._UpdateTime = None
        self._ScrollToken = None
        self._Offset = None
        self._Limit = None

    @property
    def SubAppId(self):
        r"""<b>点播[应用](/document/product/266/14574) ID。从2023年12月25日起开通点播的客户，如访问点播应用中的资源（无论是默认应用还是新创建的应用），必须将该字段填写为应用 ID。</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def RoundPlayIds(self):
        r"""过滤条件：轮播播单标识，数组长度限制：100。
        :rtype: list of str
        """
        return self._RoundPlayIds

    @RoundPlayIds.setter
    def RoundPlayIds(self, RoundPlayIds):
        self._RoundPlayIds = RoundPlayIds

    @property
    def Status(self):
        r"""过滤条件，轮播播单状态，可选值： <li>Enabled：启动状态；</li> <li>Disabled：停止状态。</li>
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def CreateTime(self):
        r"""过滤条件：轮播播单创建时间。
        :rtype: :class:`tencentcl