# -*- coding: utf8 -*-
# Copyright (c) 2017-2025 Tencent. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class AIAnalysisTemplateItem(AbstractModel):
    r"""AI 智能分析模板详情

    """

    def __init__(self):
        r"""
        :param _Definition: 智能分析模板唯一标识。
        :type Definition: int
        :param _Name: 智能分析模板名称。
        :type Name: str
        :param _Comment: 智能分析模板描述信息。
        :type Comment: str
        :param _ClassificationConfigure: 智能分类任务控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :type ClassificationConfigure: :class:`tencentcloud.mps.v20190612.models.ClassificationConfigureInfo`
        :param _TagConfigure: 智能标签任务控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :type TagConfigure: :class:`tencentcloud.mps.v20190612.models.TagConfigureInfo`
        :param _CoverConfigure: 智能封面任务控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :type CoverConfigure: :class:`tencentcloud.mps.v20190612.models.CoverConfigureInfo`
        :param _FrameTagConfigure: 智能按帧标签任务控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :type FrameTagConfigure: :class:`tencentcloud.mps.v20190612.models.FrameTagConfigureInfo`
        :param _CreateTime: 模板创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :type CreateTime: str
        :param _UpdateTime: 模板最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :type UpdateTime: str
        :param _Type: 模板类型，取值范围：
* Preset：系统预置模板；
* Custom：用户自定义模板。
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: str
        """
        self._Definition = None
        self._Name = None
        self._Comment = None
        self._ClassificationConfigure = None
        self._TagConfigure = None
        self._CoverConfigure = None
        self._FrameTagConfigure = None
        self._CreateTime = None
        self._UpdateTime = None
        self._Type = None

    @property
    def Definition(self):
        r"""智能分析模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Name(self):
        r"""智能分析模板名称。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        r"""智能分析模板描述信息。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def ClassificationConfigure(self):
        r"""智能分类任务控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.ClassificationConfigureInfo`
        """
        return self._ClassificationConfigure

    @ClassificationConfigure.setter
    def ClassificationConfigure(self, ClassificationConfigure):
        self._ClassificationConfigure = ClassificationConfigure

    @property
    def TagConfigure(self):
        r"""智能标签任务控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.TagConfigureInfo`
        """
        return self._TagConfigure

    @TagConfigure.setter
    def TagConfigure(self, TagConfigure):
        self._TagConfigure = TagConfigure

    @property
    def CoverConfigure(self):
        r"""智能封面任务控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.CoverConfigureInfo`
        """
        return self._CoverConfigure

    @CoverConfigure.setter
    def CoverConfigure(self, CoverConfigure):
        self._CoverConfigure = CoverConfigure

    @property
    def FrameTagConfigure(self):
        r"""智能按帧标签任务控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.FrameTagConfigureInfo`
        """
        return self._FrameTagConfigure

    @FrameTagConfigure.setter
    def FrameTagConfigure(self, FrameTagConfigure):
        self._FrameTagConfigure = FrameTagConfigure

    @property
    def CreateTime(self):
        r"""模板创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""模板最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def Type(self):
        r"""模板类型，取值范围：
* Preset：系统预置模板；
* Custom：用户自定义模板。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("ClassificationConfigure") is not None:
            self._ClassificationConfigure = ClassificationConfigureInfo()
            self._ClassificationConfigure._deserialize(params.get("ClassificationConfigure"))
        if params.get("TagConfigure") is not None:
            self._TagConfigure = TagConfigureInfo()
            self._TagConfigure._deserialize(params.get("TagConfigure"))
        if params.get("CoverConfigure") is not None:
            self._CoverConfigure = CoverConfigureInfo()
            self._CoverConfigure._deserialize(params.get("CoverConfigure"))
        if params.get("FrameTagConfigure") is not None:
            self._FrameTagConfigure = FrameTagConfigureInfo()
            self._FrameTagConfigure._deserialize(params.get("FrameTagConfigure"))
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AIRecognitionTemplateItem(AbstractModel):
    r"""视频内容识别模板详情

    """

    def __init__(self):
        r"""
        :param _Definition: 视频内容识别模板唯一标识。
        :type Definition: int
        :param _Name: 视频内容识别模板名称。
        :type Name: str
        :param _Comment: 视频内容识别模板描述信息。
        :type Comment: str
        :param _FaceConfigure: 人脸识别控制参数。
        :type FaceConfigure: :class:`tencentcloud.mps.v20190612.models.FaceConfigureInfo`
        :param _OcrFullTextConfigure: 文本全文识别控制参数。
        :type OcrFullTextConfigure: :class:`tencentcloud.mps.v20190612.models.OcrFullTextConfigureInfo`
        :param _OcrWordsConfigure: 文本关键词识别控制参数。
        :type OcrWordsConfigure: :class:`tencentcloud.mps.v20190612.models.OcrWordsConfigureInfo`
        :param _AsrFullTextConfigure: 语音全文识别控制参数。
        :type AsrFullTextConfigure: :class:`tencentcloud.mps.v20190612.models.AsrFullTextConfigureInfo`
        :param _AsrWordsConfigure: 语音关键词识别控制参数。
        :type AsrWordsConfigure: :class:`tencentcloud.mps.v20190612.models.AsrWordsConfigureInfo`
        :param _TranslateConfigure: 语音翻译控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :type TranslateConfigure: :class:`tencentcloud.mps.v20190612.models.TranslateConfigureInfo`
        :param _CreateTime: 模板创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :type CreateTime: str
        :param _UpdateTime: 模板最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :type UpdateTime: str
        :param _Type: 模板类型，取值范围：
* Preset：系统预置模板；
* Custom：用户自定义模板。
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: str
        """
        self._Definition = None
        self._Name = None
        self._Comment = None
        self._FaceConfigure = None
        self._OcrFullTextConfigure = None
        self._OcrWordsConfigure = None
        self._AsrFullTextConfigure = None
        self._AsrWordsConfigure = None
        self._TranslateConfigure = None
        self._CreateTime = None
        self._UpdateTime = None
        self._Type = None

    @property
    def Definition(self):
        r"""视频内容识别模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Name(self):
        r"""视频内容识别模板名称。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        r"""视频内容识别模板描述信息。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def FaceConfigure(self):
        r"""人脸识别控制参数。
        :rtype: :class:`tencentcloud.mps.v20190612.models.FaceConfigureInfo`
        """
        return self._FaceConfigure

    @FaceConfigure.setter
    def FaceConfigure(self, FaceConfigure):
        self._FaceConfigure = FaceConfigure

    @property
    def OcrFullTextConfigure(self):
        r"""文本全文识别控制参数。
        :rtype: :class:`tencentcloud.mps.v20190612.models.OcrFullTextConfigureInfo`
        """
        return self._OcrFullTextConfigure

    @OcrFullTextConfigure.setter
    def OcrFullTextConfigure(self, OcrFullTextConfigure):
        self._OcrFullTextConfigure = OcrFullTextConfigure

    @property
    def OcrWordsConfigure(self):
        r"""文本关键词识别控制参数。
        :rtype: :class:`tencentcloud.mps.v20190612.models.OcrWordsConfigureInfo`
        """
        return self._OcrWordsConfigure

    @OcrWordsConfigure.setter
    def OcrWordsConfigure(self, OcrWordsConfigure):
        self._OcrWordsConfigure = OcrWordsConfigure

    @property
    def AsrFullTextConfigure(self):
        r"""语音全文识别控制参数。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AsrFullTextConfigureInfo`
        """
        return self._AsrFullTextConfigure

    @AsrFullTextConfigure.setter
    def AsrFullTextConfigure(self, AsrFullTextConfigure):
        self._AsrFullTextConfigure = AsrFullTextConfigure

    @property
    def AsrWordsConfigure(self):
        r"""语音关键词识别控制参数。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AsrWordsConfigureInfo`
        """
        return self._AsrWordsConfigure

    @AsrWordsConfigure.setter
    def AsrWordsConfigure(self, AsrWordsConfigure):
        self._AsrWordsConfigure = AsrWordsConfigure

    @property
    def TranslateConfigure(self):
        r"""语音翻译控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.TranslateConfigureInfo`
        """
        return self._TranslateConfigure

    @TranslateConfigure.setter
    def TranslateConfigure(self, TranslateConfigure):
        self._TranslateConfigure = TranslateConfigure

    @property
    def CreateTime(self):
        r"""模板创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""模板最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def Type(self):
        r"""模板类型，取值范围：
* Preset：系统预置模板；
* Custom：用户自定义模板。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("FaceConfigure") is not None:
            self._FaceConfigure = FaceConfigureInfo()
            self._FaceConfigure._deserialize(params.get("FaceConfigure"))
        if params.get("OcrFullTextConfigure") is not None:
            self._OcrFullTextConfigure = OcrFullTextConfigureInfo()
            self._OcrFullTextConfigure._deserialize(params.get("OcrFullTextConfigure"))
        if params.get("OcrWordsConfigure") is not None:
            self._OcrWordsConfigure = OcrWordsConfigureInfo()
            self._OcrWordsConfigure._deserialize(params.get("OcrWordsConfigure"))
        if params.get("AsrFullTextConfigure") is not None:
            self._AsrFullTextConfigure = AsrFullTextConfigureInfo()
            self._AsrFullTextConfigure._deserialize(params.get("AsrFullTextConfigure"))
        if params.get("AsrWordsConfigure") is not None:
            self._AsrWordsConfigure = AsrWordsConfigureInfo()
            self._AsrWordsConfigure._deserialize(params.get("AsrWordsConfigure"))
        if params.get("TranslateConfigure") is not None:
            self._TranslateConfigure = TranslateConfigureInfo()
            self._TranslateConfigure._deserialize(params.get("TranslateConfigure"))
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ActionConfigInfo(AbstractModel):
    r"""动作识别参数配置

    """

    def __init__(self):
        r"""
        :param _Switch: 动作识别任务开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        r"""动作识别任务开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Activity(AbstractModel):
    r"""编排原子任务

    """

    def __init__(self):
        r"""
        :param _ActivityType: 原子任务类型：
<li>input: 起始节点</li>
<li>output：终止节点</li>
<li>action-trans：转码</li>
<li>action-samplesnapshot：采样截图</li>
<li>action-AIAnalysis: 分析</li>
<li>action-AIRecognition：识别</li>
<li>action-aiReview：审核</li>
<li>action-animated-graphics：转动图</li>
<li>action-image-sprite：雪碧图</li>
<li>action-snapshotByTimeOffset: 时间点截图</li>
<li>action-adaptive-substream：自适应码流</li>
<li>action-AIQualityControl：媒体质检</li>
<li>action-SmartSubtitles：智能字幕</li>
<li>action-exec-rules：判断规则</li>
<li>action-SmartErase：智能擦除</li>



        :type ActivityType: str
        :param _ReardriveIndex: 后驱节点索引数组
        :type ReardriveIndex: list of int
        :param _ActivityPara: 原子任务参数
注意：此字段可能返回 null，表示取不到有效值。
        :type ActivityPara: :class:`tencentcloud.mps.v20190612.models.ActivityPara`
        """
        self._ActivityType = None
        self._ReardriveIndex = None
        self._ActivityPara = None

    @property
    def ActivityType(self):
        r"""原子任务类型：
<li>input: 起始节点</li>
<li>output：终止节点</li>
<li>action-trans：转码</li>
<li>action-samplesnapshot：采样截图</li>
<li>action-AIAnalysis: 分析</li>
<li>action-AIRecognition：识别</li>
<li>action-aiReview：审核</li>
<li>action-animated-graphics：转动图</li>
<li>action-image-sprite：雪碧图</li>
<li>action-snapshotByTimeOffset: 时间点截图</li>
<li>action-adaptive-substream：自适应码流</li>
<li>action-AIQualityControl：媒体质检</li>
<li>action-SmartSubtitles：智能字幕</li>
<li>action-exec-rules：判断规则</li>
<li>action-SmartErase：智能擦除</li>



        :rtype: str
        """
        return self._ActivityType

    @ActivityType.setter
    def ActivityType(self, ActivityType):
        self._ActivityType = ActivityType

    @property
    def ReardriveIndex(self):
        r"""后驱节点索引数组
        :rtype: list of int
        """
        return self._ReardriveIndex

    @ReardriveIndex.setter
    def ReardriveIndex(self, ReardriveIndex):
        self._ReardriveIndex = ReardriveIndex

    @property
    def ActivityPara(self):
        r"""原子任务参数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.ActivityPara`
        """
        return self._ActivityPara

    @ActivityPara.setter
    def ActivityPara(self, ActivityPara):
        self._ActivityPara = ActivityPara


    def _deserialize(self, params):
        self._ActivityType = params.get("ActivityType")
        self._ReardriveIndex = params.get("ReardriveIndex")
        if params.get("ActivityPara") is not None:
            self._ActivityPara = ActivityPara()
            self._ActivityPara._deserialize(params.get("ActivityPara"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ActivityPara(AbstractModel):
    r"""编排原子任务

    """

    def __init__(self):
        r"""
        :param _TranscodeTask: 视频转码任务
注意：此字段可能返回 null，表示取不到有效值。
        :type TranscodeTask: :class:`tencentcloud.mps.v20190612.models.TranscodeTaskInput`
        :param _AnimatedGraphicTask: 视频转动图任务
注意：此字段可能返回 null，表示取不到有效值。
        :type AnimatedGraphicTask: :class:`tencentcloud.mps.v20190612.models.AnimatedGraphicTaskInput`
        :param _SnapshotByTimeOffsetTask: 视频按时间点截图任务
注意：此字段可能返回 null，表示取不到有效值。
        :type SnapshotByTimeOffsetTask: :class:`tencentcloud.mps.v20190612.models.SnapshotByTimeOffsetTaskInput`
        :param _SampleSnapshotTask: 视频采样截图任务
注意：此字段可能返回 null，表示取不到有效值。
        :type SampleSnapshotTask: :class:`tencentcloud.mps.v20190612.models.SampleSnapshotTaskInput`
        :param _ImageSpriteTask: 视频截雪碧图任务
注意：此字段可能返回 null，表示取不到有效值。
        :type ImageSpriteTask: :class:`tencentcloud.mps.v20190612.models.ImageSpriteTaskInput`
        :param _AdaptiveDynamicStreamingTask: 转自适应码流任务
注意：此字段可能返回 null，表示取不到有效值。
        :type AdaptiveDynamicStreamingTask: :class:`tencentcloud.mps.v20190612.models.AdaptiveDynamicStreamingTaskInput`
        :param _AiContentReviewTask: 视频内容审核类型任务
注意：此字段可能返回 null，表示取不到有效值。
        :type AiContentReviewTask: :class:`tencentcloud.mps.v20190612.models.AiContentReviewTaskInput`
        :param _AiAnalysisTask: 视频内容分析类型任务
注意：此字段可能返回 null，表示取不到有效值。
        :type AiAnalysisTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskInput`
        :param _AiRecognitionTask: 视频内容识别类型任务
注意：此字段可能返回 null，表示取不到有效值。
        :type AiRecognitionTask: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskInput`
        :param _QualityControlTask: 媒体质检任务
注意：此字段可能返回 null，表示取不到有效值。
        :type QualityControlTask: :class:`tencentcloud.mps.v20190612.models.AiQualityControlTaskInput`
        :param _ExecRulesTask: 任务条件判断
注意：此字段可能返回 null，表示取不到有效值。
        :type ExecRulesTask: :class:`tencentcloud.mps.v20190612.models.ExecRulesTask`
        :param _SmartSubtitlesTask: 智能字幕任务
注意：此字段可能返回 null，表示取不到有效值。
        :type SmartSubtitlesTask: :class:`tencentcloud.mps.v20190612.models.SmartSubtitlesTaskInput`
        :param _SmartEraseTask: 智能擦除任务
注意：此字段可能返回 null，表示取不到有效值。
        :type SmartEraseTask: :class:`tencentcloud.mps.v20190612.models.SmartEraseTaskInput`
        """
        self._TranscodeTask = None
        self._AnimatedGraphicTask = None
        self._SnapshotByTimeOffsetTask = None
        self._SampleSnapshotTask = None
        self._ImageSpriteTask = None
        self._AdaptiveDynamicStreamingTask = None
        self._AiContentReviewTask = None
        self._AiAnalysisTask = None
        self._AiRecognitionTask = None
        self._QualityControlTask = None
        self._ExecRulesTask = None
        self._SmartSubtitlesTask = None
        self._SmartEraseTask = None

    @property
    def TranscodeTask(self):
        r"""视频转码任务
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.TranscodeTaskInput`
        """
        return self._TranscodeTask

    @TranscodeTask.setter
    def TranscodeTask(self, TranscodeTask):
        self._TranscodeTask = TranscodeTask

    @property
    def AnimatedGraphicTask(self):
        r"""视频转动图任务
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AnimatedGraphicTaskInput`
        """
        return self._AnimatedGraphicTask

    @AnimatedGraphicTask.setter
    def AnimatedGraphicTask(self, AnimatedGraphicTask):
        self._AnimatedGraphicTask = AnimatedGraphicTask

    @property
    def SnapshotByTimeOffsetTask(self):
        r"""视频按时间点截图任务
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.SnapshotByTimeOffsetTaskInput`
        """
        return self._SnapshotByTimeOffsetTask

    @SnapshotByTimeOffsetTask.setter
    def SnapshotByTimeOffsetTask(self, SnapshotByTimeOffsetTask):
        self._SnapshotByTimeOffsetTask = SnapshotByTimeOffsetTask

    @property
    def SampleSnapshotTask(self):
        r"""视频采样截图任务
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.SampleSnapshotTaskInput`
        """
        return self._SampleSnapshotTask

    @SampleSnapshotTask.setter
    def SampleSnapshotTask(self, SampleSnapshotTask):
        self._SampleSnapshotTask = SampleSnapshotTask

    @property
    def ImageSpriteTask(self):
        r"""视频截雪碧图任务
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.ImageSpriteTaskInput`
        """
        return self._ImageSpriteTask

    @ImageSpriteTask.setter
    def ImageSpriteTask(self, ImageSpriteTask):
        self._ImageSpriteTask = ImageSpriteTask

    @property
    def AdaptiveDynamicStreamingTask(self):
        r"""转自适应码流任务
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AdaptiveDynamicStreamingTaskInput`
        """
        return self._AdaptiveDynamicStreamingTask

    @AdaptiveDynamicStreamingTask.setter
    def AdaptiveDynamicStreamingTask(self, AdaptiveDynamicStreamingTask):
        self._AdaptiveDynamicStreamingTask = AdaptiveDynamicStreamingTask

    @property
    def AiContentReviewTask(self):
        r"""视频内容审核类型任务
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiContentReviewTaskInput`
        """
        return self._AiContentReviewTask

    @AiContentReviewTask.setter
    def AiContentReviewTask(self, AiContentReviewTask):
        self._AiContentReviewTask = AiContentReviewTask

    @property
    def AiAnalysisTask(self):
        r"""视频内容分析类型任务
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskInput`
        """
        return self._AiAnalysisTask

    @AiAnalysisTask.setter
    def AiAnalysisTask(self, AiAnalysisTask):
        self._AiAnalysisTask = AiAnalysisTask

    @property
    def AiRecognitionTask(self):
        r"""视频内容识别类型任务
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskInput`
        """
        return self._AiRecognitionTask

    @AiRecognitionTask.setter
    def AiRecognitionTask(self, AiRecognitionTask):
        self._AiRecognitionTask = AiRecognitionTask

    @property
    def QualityControlTask(self):
        r"""媒体质检任务
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiQualityControlTaskInput`
        """
        return self._QualityControlTask

    @QualityControlTask.setter
    def QualityControlTask(self, QualityControlTask):
        self._QualityControlTask = QualityControlTask

    @property
    def ExecRulesTask(self):
        r"""任务条件判断
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.ExecRulesTask`
        """
        return self._ExecRulesTask

    @ExecRulesTask.setter
    def ExecRulesTask(self, ExecRulesTask):
        self._ExecRulesTask = ExecRulesTask

    @property
    def SmartSubtitlesTask(self):
        r"""智能字幕任务
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.SmartSubtitlesTaskInput`
        """
        return self._SmartSubtitlesTask

    @SmartSubtitlesTask.setter
    def SmartSubtitlesTask(self, SmartSubtitlesTask):
        self._SmartSubtitlesTask = SmartSubtitlesTask

    @property
    def SmartEraseTask(self):
        r"""智能擦除任务
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.SmartEraseTaskInput`
        """
        return self._SmartEraseTask

    @SmartEraseTask.setter
    def SmartEraseTask(self, SmartEraseTask):
        self._SmartEraseTask = SmartEraseTask


    def _deserialize(self, params):
        if params.get("TranscodeTask") is not None:
            self._TranscodeTask = TranscodeTaskInput()
            self._TranscodeTask._deserialize(params.get("TranscodeTask"))
        if params.get("AnimatedGraphicTask") is not None:
            self._AnimatedGraphicTask = AnimatedGraphicTaskInput()
            self._AnimatedGraphicTask._deserialize(params.get("AnimatedGraphicTask"))
        if params.get("SnapshotByTimeOffsetTask") is not None:
            self._SnapshotByTimeOffsetTask = SnapshotByTimeOffsetTaskInput()
            self._SnapshotByTimeOffsetTask._deserialize(params.get("SnapshotByTimeOffsetTask"))
        if params.get("SampleSnapshotTask") is not None:
            self._SampleSnapshotTask = SampleSnapshotTaskInput()
            self._SampleSnapshotTask._deserialize(params.get("SampleSnapshotTask"))
        if params.get("ImageSpriteTask") is not None:
            self._ImageSpriteTask = ImageSpriteTaskInput()
            self._ImageSpriteTask._deserialize(params.get("ImageSpriteTask"))
        if params.get("AdaptiveDynamicStreamingTask") is not None:
            self._AdaptiveDynamicStreamingTask = AdaptiveDynamicStreamingTaskInput()
            self._AdaptiveDynamicStreamingTask._deserialize(params.get("AdaptiveDynamicStreamingTask"))
        if params.get("AiContentReviewTask") is not None:
            self._AiContentReviewTask = AiContentReviewTaskInput()
            self._AiContentReviewTask._deserialize(params.get("AiContentReviewTask"))
        if params.get("AiAnalysisTask") is not None:
            self._AiAnalysisTask = AiAnalysisTaskInput()
            self._AiAnalysisTask._deserialize(params.get("AiAnalysisTask"))
        if params.get("AiRecognitionTask") is not None:
            self._AiRecognitionTask = AiRecognitionTaskInput()
            self._AiRecognitionTask._deserialize(params.get("AiRecognitionTask"))
        if params.get("QualityControlTask") is not None:
            self._QualityControlTask = AiQualityControlTaskInput()
            self._QualityControlTask._deserialize(params.get("QualityControlTask"))
        if params.get("ExecRulesTask") is not None:
            self._ExecRulesTask = ExecRulesTask()
            self._ExecRulesTask._deserialize(params.get("ExecRulesTask"))
        if params.get("SmartSubtitlesTask") is not None:
            self._SmartSubtitlesTask = SmartSubtitlesTaskInput()
            self._SmartSubtitlesTask._deserialize(params.get("SmartSubtitlesTask"))
        if params.get("SmartEraseTask") is not None:
            self._SmartEraseTask = SmartEraseTaskInput()
            self._SmartEraseTask._deserialize(params.get("SmartEraseTask"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ActivityResItem(AbstractModel):
    r"""编排子任务输出

    """

    def __init__(self):
        r"""
        :param _TranscodeTask: 转码任务输出
注意：此字段可能返回 null，表示取不到有效值。
        :type TranscodeTask: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskTranscodeResult`
        :param _AnimatedGraphicTask: 转动图任务输出
注意：此字段可能返回 null，表示取不到有效值。
        :type AnimatedGraphicTask: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskAnimatedGraphicResult`
        :param _SnapshotByTimeOffsetTask: 时间点截图任务输出
注意：此字段可能返回 null，表示取不到有效值。
        :type SnapshotByTimeOffsetTask: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskSnapshotByTimeOffsetResult`
        :param _SampleSnapshotTask: 采样截图任务输出
注意：此字段可能返回 null，表示取不到有效值。
        :type SampleSnapshotTask: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskSampleSnapshotResult`
        :param _ImageSpriteTask: 雪碧图任务输出
注意：此字段可能返回 null，表示取不到有效值。
        :type ImageSpriteTask: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskImageSpriteResult`
        :param _AdaptiveDynamicStreamingTask: 自适应码流任务输出
注意：此字段可能返回 null，表示取不到有效值。
        :type AdaptiveDynamicStreamingTask: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskAdaptiveDynamicStreamingResult`
        :param _RecognitionTask: 识别任务输出
注意：此字段可能返回 null，表示取不到有效值。
        :type RecognitionTask: :class:`tencentcloud.mps.v20190612.models.ScheduleRecognitionTaskResult`
        :param _ReviewTask: 审核任务输出
注意：此字段可能返回 null，表示取不到有效值。
        :type ReviewTask: :class:`tencentcloud.mps.v20190612.models.ScheduleReviewTaskResult`
        :param _AnalysisTask: 分析任务输出
注意：此字段可能返回 null，表示取不到有效值。
        :type AnalysisTask: :class:`tencentcloud.mps.v20190612.models.ScheduleAnalysisTaskResult`
        :param _QualityControlTask: 媒体质检任务输出
注意：此字段可能返回 null，表示取不到有效值。
        :type QualityControlTask: :class:`tencentcloud.mps.v20190612.models.ScheduleQualityControlTaskResult`
        :param _ExecRuleTask: 条件判断任务输出
注意：此字段可能返回 null，表示取不到有效值。
        :type ExecRuleTask: :class:`tencentcloud.mps.v20190612.models.ScheduleExecRuleTaskResult`
        :param _SmartSubtitlesTask: 智能字幕任务输出
注意：此字段可能返回 null，表示取不到有效值。
        :type SmartSubtitlesTask: :class:`tencentcloud.mps.v20190612.models.ScheduleSmartSubtitleTaskResult`
        :param _SmartEraseTask: 智能擦除任务输出
注意：此字段可能返回 null，表示取不到有效值。
        :type SmartEraseTask: :class:`tencentcloud.mps.v20190612.models.SmartEraseTaskResult`
        """
        self._TranscodeTask = None
        self._AnimatedGraphicTask = None
        self._SnapshotByTimeOffsetTask = None
        self._SampleSnapshotTask = None
        self._ImageSpriteTask = None
        self._AdaptiveDynamicStreamingTask = None
        self._RecognitionTask = None
        self._ReviewTask = None
        self._AnalysisTask = None
        self._QualityControlTask = None
        self._ExecRuleTask = None
        self._SmartSubtitlesTask = None
        self._SmartEraseTask = None

    @property
    def TranscodeTask(self):
        r"""转码任务输出
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskTranscodeResult`
        """
        return self._TranscodeTask

    @TranscodeTask.setter
    def TranscodeTask(self, TranscodeTask):
        self._TranscodeTask = TranscodeTask

    @property
    def AnimatedGraphicTask(self):
        r"""转动图任务输出
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskAnimatedGraphicResult`
        """
        return self._AnimatedGraphicTask

    @AnimatedGraphicTask.setter
    def AnimatedGraphicTask(self, AnimatedGraphicTask):
        self._AnimatedGraphicTask = AnimatedGraphicTask

    @property
    def SnapshotByTimeOffsetTask(self):
        r"""时间点截图任务输出
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskSnapshotByTimeOffsetResult`
        """
        return self._SnapshotByTimeOffsetTask

    @SnapshotByTimeOffsetTask.setter
    def SnapshotByTimeOffsetTask(self, SnapshotByTimeOffsetTask):
        self._SnapshotByTimeOffsetTask = SnapshotByTimeOffsetTask

    @property
    def SampleSnapshotTask(self):
        r"""采样截图任务输出
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskSampleSnapshotResult`
        """
        return self._SampleSnapshotTask

    @SampleSnapshotTask.setter
    def SampleSnapshotTask(self, SampleSnapshotTask):
        self._SampleSnapshotTask = SampleSnapshotTask

    @property
    def ImageSpriteTask(self):
        r"""雪碧图任务输出
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskImageSpriteResult`
        """
        return self._ImageSpriteTask

    @ImageSpriteTask.setter
    def ImageSpriteTask(self, ImageSpriteTask):
        self._ImageSpriteTask = ImageSpriteTask

    @property
    def AdaptiveDynamicStreamingTask(self):
        r"""自适应码流任务输出
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskAdaptiveDynamicStreamingResult`
        """
        return self._AdaptiveDynamicStreamingTask

    @AdaptiveDynamicStreamingTask.setter
    def AdaptiveDynamicStreamingTask(self, AdaptiveDynamicStreamingTask):
        self._AdaptiveDynamicStreamingTask = AdaptiveDynamicStreamingTask

    @property
    def RecognitionTask(self):
        r"""识别任务输出
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.ScheduleRecognitionTaskResult`
        """
        return self._RecognitionTask

    @RecognitionTask.setter
    def RecognitionTask(self, RecognitionTask):
        self._RecognitionTask = RecognitionTask

    @property
    def ReviewTask(self):
        r"""审核任务输出
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.ScheduleReviewTaskResult`
        """
        return self._ReviewTask

    @ReviewTask.setter
    def ReviewTask(self, ReviewTask):
        self._ReviewTask = ReviewTask

    @property
    def AnalysisTask(self):
        r"""分析任务输出
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.ScheduleAnalysisTaskResult`
        """
        return self._AnalysisTask

    @AnalysisTask.setter
    def AnalysisTask(self, AnalysisTask):
        self._AnalysisTask = AnalysisTask

    @property
    def QualityControlTask(self):
        r"""媒体质检任务输出
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.ScheduleQualityControlTaskResult`
        """
        return self._QualityControlTask

    @QualityControlTask.setter
    def QualityControlTask(self, QualityControlTask):
        self._QualityControlTask = QualityControlTask

    @property
    def ExecRuleTask(self):
        r"""条件判断任务输出
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.ScheduleExecRuleTaskResult`
        """
        return self._ExecRuleTask

    @ExecRuleTask.setter
    def ExecRuleTask(self, ExecRuleTask):
        self._ExecRuleTask = ExecRuleTask

    @property
    def SmartSubtitlesTask(self):
        r"""智能字幕任务输出
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.ScheduleSmartSubtitleTaskResult`
        """
        return self._SmartSubtitlesTask

    @SmartSubtitlesTask.setter
    def SmartSubtitlesTask(self, SmartSubtitlesTask):
        self._SmartSubtitlesTask = SmartSubtitlesTask

    @property
    def SmartEraseTask(self):
        r"""智能擦除任务输出
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.SmartEraseTaskResult`
        """
        return self._SmartEraseTask

    @SmartEraseTask.setter
    def SmartEraseTask(self, SmartEraseTask):
        self._SmartEraseTask = SmartEraseTask


    def _deserialize(self, params):
        if params.get("TranscodeTask") is not None:
            self._TranscodeTask = MediaProcessTaskTranscodeResult()
            self._TranscodeTask._deserialize(params.get("TranscodeTask"))
        if params.get("AnimatedGraphicTask") is not None:
            self._AnimatedGraphicTask = MediaProcessTaskAnimatedGraphicResult()
            self._AnimatedGraphicTask._deserialize(params.get("AnimatedGraphicTask"))
        if params.get("SnapshotByTimeOffsetTask") is not None:
            self._SnapshotByTimeOffsetTask = MediaProcessTaskSnapshotByTimeOffsetResult()
            self._SnapshotByTimeOffsetTask._deserialize(params.get("SnapshotByTimeOffsetTask"))
        if params.get("SampleSnapshotTask") is not None:
            self._SampleSnapshotTask = MediaProcessTaskSampleSnapshotResult()
            self._SampleSnapshotTask._deserialize(params.get("SampleSnapshotTask"))
        if params.get("ImageSpriteTask") is not None:
            self._ImageSpriteTask = MediaProcessTaskImageSpriteResult()
            self._ImageSpriteTask._deserialize(params.get("ImageSpriteTask"))
        if params.get("AdaptiveDynamicStreamingTask") is not None:
            self._AdaptiveDynamicStreamingTask = MediaProcessTaskAdaptiveDynamicStreamingResult()
            self._AdaptiveDynamicStreamingTask._deserialize(params.get("AdaptiveDynamicStreamingTask"))
        if params.get("RecognitionTask") is not None:
            self._RecognitionTask = ScheduleRecognitionTaskResult()
            self._RecognitionTask._deserialize(params.get("RecognitionTask"))
        if params.get("ReviewTask") is not None:
            self._ReviewTask = ScheduleReviewTaskResult()
            self._ReviewTask._deserialize(params.get("ReviewTask"))
        if params.get("AnalysisTask") is not None:
            self._AnalysisTask = ScheduleAnalysisTaskResult()
            self._AnalysisTask._deserialize(params.get("AnalysisTask"))
        if params.get("QualityControlTask") is not None:
            self._QualityControlTask = ScheduleQualityControlTaskResult()
            self._QualityControlTask._deserialize(params.get("QualityControlTask"))
        if params.get("ExecRuleTask") is not None:
            self._ExecRuleTask = ScheduleExecRuleTaskResult()
            self._ExecRuleTask._deserialize(params.get("ExecRuleTask"))
        if params.get("SmartSubtitlesTask") is not None:
            self._SmartSubtitlesTask = ScheduleSmartSubtitleTaskResult()
            self._SmartSubtitlesTask._deserialize(params.get("SmartSubtitlesTask"))
        if params.get("SmartEraseTask") is not None:
            self._SmartEraseTask = SmartEraseTaskResult()
            self._SmartEraseTask._deserialize(params.get("SmartEraseTask"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ActivityResult(AbstractModel):
    r"""编排任务输出

    """

    def __init__(self):
        r"""
        :param _ActivityType: 原子任务类型。
<li>Transcode：转码。</li>
<li>SampleSnapshot：采样截图。</li>
<li>AnimatedGraphics：转动图。</li>
<li>SnapshotByTimeOffset：时间点截图。</li>
<li>ImageSprites：雪碧图。</li>
<li>AdaptiveDynamicStreaming：自适应码流。</li>
<li>AiContentReview：内容审核。</li>
<li>AIRecognition：智能识别。</li>
<li>AIAnalysis：智能分析。</li>
<li>AiQualityControl：媒体质检。</li>
<li>SmartSubtitles：智能字幕。</li>
<li>SmartErase：智能擦除。</li>
        :type ActivityType: str
        :param _ActivityResItem: 原子任务输出。
        :type ActivityResItem: :class:`tencentcloud.mps.v20190612.models.ActivityResItem`
        """
        self._ActivityType = None
        self._ActivityResItem = None

    @property
    def ActivityType(self):
        r"""原子任务类型。
<li>Transcode：转码。</li>
<li>SampleSnapshot：采样截图。</li>
<li>AnimatedGraphics：转动图。</li>
<li>SnapshotByTimeOffset：时间点截图。</li>
<li>ImageSprites：雪碧图。</li>
<li>AdaptiveDynamicStreaming：自适应码流。</li>
<li>AiContentReview：内容审核。</li>
<li>AIRecognition：智能识别。</li>
<li>AIAnalysis：智能分析。</li>
<li>AiQualityControl：媒体质检。</li>
<li>SmartSubtitles：智能字幕。</li>
<li>SmartErase：智能擦除。</li>
        :rtype: str
        """
        return self._ActivityType

    @ActivityType.setter
    def ActivityType(self, ActivityType):
        self._ActivityType = ActivityType

    @property
    def ActivityResItem(self):
        r"""原子任务输出。
        :rtype: :class:`tencentcloud.mps.v20190612.models.ActivityResItem`
        """
        return self._ActivityResItem

    @ActivityResItem.setter
    def ActivityResItem(self, ActivityResItem):
        self._ActivityResItem = ActivityResItem


    def _deserialize(self, params):
        self._ActivityType = params.get("ActivityType")
        if params.get("ActivityResItem") is not None:
            self._ActivityResItem = ActivityResItem()
            self._ActivityResItem._deserialize(params.get("ActivityResItem"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AdaptiveDynamicStreamingInfoItem(AbstractModel):
    r"""转自适应码流信息

    """

    def __init__(self):
        r"""
        :param _Definition: 转自适应码流规格。
        :type Definition: int
        :param _Package: 打包格式，可能为 HLS和 MPEG-DASH 两种。
        :type Package: str
        :param _Path: 播放路径。
        :type Path: str
        :param _Storage: 自适应码流文件的存储位置。
        :type Storage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        self._Definition = None
        self._Package = None
        self._Path = None
        self._Storage = None

    @property
    def Definition(self):
        r"""转自适应码流规格。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Package(self):
        r"""打包格式，可能为 HLS和 MPEG-DASH 两种。
        :rtype: str
        """
        return self._Package

    @Package.setter
    def Package(self, Package):
        self._Package = Package

    @property
    def Path(self):
        r"""播放路径。
        :rtype: str
        """
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def Storage(self):
        r"""自适应码流文件的存储位置。
        :rtype: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        return self._Storage

    @Storage.setter
    def Storage(self, Storage):
        self._Storage = Storage


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Package = params.get("Package")
        self._Path = params.get("Path")
        if params.get("Storage") is not None:
            self._Storage = TaskOutputStorage()
            self._Storage._deserialize(params.get("Storage"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AdaptiveDynamicStreamingTaskInput(AbstractModel):
    r"""对视频转自适应码流的输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 转自适应码流模板 ID。
        :type Definition: int
        :param _WatermarkSet: 水印列表，支持多张图片或文字水印，最大可支持 10 张。
        :type WatermarkSet: list of WatermarkInput
        :param _BlindWatermark: 数字水印参数	
注意：此字段可能返回 null，表示取不到有效值。
        :type BlindWatermark: :class:`tencentcloud.mps.v20190612.models.BlindWatermarkInput`
        :param _OutputStorage: 转自适应码流后文件的目标存储，不填则继承上层的 OutputStorage 值。
注意：此字段可能返回 null，表示取不到有效值。
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _OutputObjectPath: 转自适应码流后，manifest 文件的输出路径，可以为相对路径或者绝对路径。
若需定义输出路径，路径需以`.{format}`结尾。变量名请参考 [文件名变量说明](https://cloud.tencent.com/document/product/862/37039)。
相对路径示例：
<li>文件名_{变量名}.{format}</li>
<li>文件名.{format}</li>
绝对路径示例：
<li>/自定义路径/文件名_{变量名}.{format}</li>
如果不填，则默认为相对路径：{inputName}_adaptiveDynamicStreaming_{definition}.{format}。
        :type OutputObjectPath: str
        :param _SubStreamObjectName: 转自适应码流后，子流文件的输出路径，只能为相对路径。如果不填，则默认为相对路径：`{inputName}_adaptiveDynamicStreaming_{definition}_{subStreamNumber}.{format}`。
        :type SubStreamObjectName: str
        :param _SegmentObjectName: 转自适应码流（仅 HLS）后，分片文件的输出路径，只能为相对路径。如果不填，则默认为相对路径：`{inputName}_adaptiveDynamicStreaming_{definition}_{subStreamNumber}_{segmentNumber}.{format}`。
        :type SegmentObjectName: str
        :param _AddOnSubtitles: 外挂字幕功能，指定要插入的字幕文件。
注意：此字段可能返回 null，表示取不到有效值。
        :type AddOnSubtitles: list of AddOnSubtitle
        :param _DrmInfo: Drm信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type DrmInfo: :class:`tencentcloud.mps.v20190612.models.DrmInfo`
        :param _DefinitionType: 自适应转码模板类型：
Common：音视频类型
PureAudio：纯音频类型
        :type DefinitionType: str
        :param _SubtitleTemplate: 硬字幕（压制字幕）功能，指定字幕来源、字体大小、位置等字幕参数。
注意：此字段可能返回 null，表示取不到有效值。
        :type SubtitleTemplate: :class:`tencentcloud.mps.v20190612.models.SubtitleTemplate`
        :param _StdExtInfo: 转码参数扩展字段
        :type StdExtInfo: str
        :param _KeyPTSList: 指定pts时间的帧设为关键帧，并切片。单位毫秒（允许相对偏差<=1ms）。当同时指定gop和切片时长时，会共同作用。注意需开启RawPts，保持帧率随源，并确保传入的pts时间在源中是有对应帧的。
注意：此字段可能返回 null，表示取不到有效值。
        :type KeyPTSList: list of int
        """
        self._Definition = None
        self._WatermarkSet = None
        self._BlindWatermark = None
        self._OutputStorage = None
        self._OutputObjectPath = None
        self._SubStreamObjectName = None
        self._SegmentObjectName = None
        self._AddOnSubtitles = None
        self._DrmInfo = None
        self._DefinitionType = None
        self._SubtitleTemplate = None
        self._StdExtInfo = None
        self._KeyPTSList = None

    @property
    def Definition(self):
        r"""转自适应码流模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def WatermarkSet(self):
        r"""水印列表，支持多张图片或文字水印，最大可支持 10 张。
        :rtype: list of WatermarkInput
        """
        return self._WatermarkSet

    @WatermarkSet.setter
    def WatermarkSet(self, WatermarkSet):
        self._WatermarkSet = WatermarkSet

    @property
    def BlindWatermark(self):
        r"""数字水印参数	
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.BlindWatermarkInput`
        """
        return self._BlindWatermark

    @BlindWatermark.setter
    def BlindWatermark(self, BlindWatermark):
        self._BlindWatermark = BlindWatermark

    @property
    def OutputStorage(self):
        r"""转自适应码流后文件的目标存储，不填则继承上层的 OutputStorage 值。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage

    @property
    def OutputObjectPath(self):
        r"""转自适应码流后，manifest 文件的输出路径，可以为相对路径或者绝对路径。
若需定义输出路径，路径需以`.{format}`结尾。变量名请参考 [文件名变量说明](https://cloud.tencent.com/document/product/862/37039)。
相对路径示例：
<li>文件名_{变量名}.{format}</li>
<li>文件名.{format}</li>
绝对路径示例：
<li>/自定义路径/文件名_{变量名}.{format}</li>
如果不填，则默认为相对路径：{inputName}_adaptiveDynamicStreaming_{definition}.{format}。
        :rtype: str
        """
        return self._OutputObjectPath

    @OutputObjectPath.setter
    def OutputObjectPath(self, OutputObjectPath):
        self._OutputObjectPath = OutputObjectPath

    @property
    def SubStreamObjectName(self):
        r"""转自适应码流后，子流文件的输出路径，只能为相对路径。如果不填，则默认为相对路径：`{inputName}_adaptiveDynamicStreaming_{definition}_{subStreamNumber}.{format}`。
        :rtype: str
        """
        return self._SubStreamObjectName

    @SubStreamObjectName.setter
    def SubStreamObjectName(self, SubStreamObjectName):
        self._SubStreamObjectName = SubStreamObjectName

    @property
    def SegmentObjectName(self):
        r"""转自适应码流（仅 HLS）后，分片文件的输出路径，只能为相对路径。如果不填，则默认为相对路径：`{inputName}_adaptiveDynamicStreaming_{definition}_{subStreamNumber}_{segmentNumber}.{format}`。
        :rtype: str
        """
        return self._SegmentObjectName

    @SegmentObjectName.setter
    def SegmentObjectName(self, SegmentObjectName):
        self._SegmentObjectName = SegmentObjectName

    @property
    def AddOnSubtitles(self):
        r"""外挂字幕功能，指定要插入的字幕文件。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of AddOnSubtitle
        """
        return self._AddOnSubtitles

    @AddOnSubtitles.setter
    def AddOnSubtitles(self, AddOnSubtitles):
        self._AddOnSubtitles = AddOnSubtitles

    @property
    def DrmInfo(self):
        r"""Drm信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.DrmInfo`
        """
        return self._DrmInfo

    @DrmInfo.setter
    def DrmInfo(self, DrmInfo):
        self._DrmInfo = DrmInfo

    @property
    def DefinitionType(self):
        r"""自适应转码模板类型：
Common：音视频类型
PureAudio：纯音频类型
        :rtype: str
        """
        return self._DefinitionType

    @DefinitionType.setter
    def DefinitionType(self, DefinitionType):
        self._DefinitionType = DefinitionType

    @property
    def SubtitleTemplate(self):
        r"""硬字幕（压制字幕）功能，指定字幕来源、字体大小、位置等字幕参数。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.SubtitleTemplate`
        """
        return self._SubtitleTemplate

    @SubtitleTemplate.setter
    def SubtitleTemplate(self, SubtitleTemplate):
        self._SubtitleTemplate = SubtitleTemplate

    @property
    def StdExtInfo(self):
        r"""转码参数扩展字段
        :rtype: str
        """
        return self._StdExtInfo

    @StdExtInfo.setter
    def StdExtInfo(self, StdExtInfo):
        self._StdExtInfo = StdExtInfo

    @property
    def KeyPTSList(self):
        r"""指定pts时间的帧设为关键帧，并切片。单位毫秒（允许相对偏差<=1ms）。当同时指定gop和切片时长时，会共同作用。注意需开启RawPts，保持帧率随源，并确保传入的pts时间在源中是有对应帧的。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of int
        """
        return self._KeyPTSList

    @KeyPTSList.setter
    def KeyPTSList(self, KeyPTSList):
        self._KeyPTSList = KeyPTSList


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        if params.get("WatermarkSet") is not None:
            self._WatermarkSet = []
            for item in params.get("WatermarkSet"):
                obj = WatermarkInput()
                obj._deserialize(item)
                self._WatermarkSet.append(obj)
        if params.get("BlindWatermark") is not None:
            self._BlindWatermark = BlindWatermarkInput()
            self._BlindWatermark._deserialize(params.get("BlindWatermark"))
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        self._OutputObjectPath = params.get("OutputObjectPath")
        self._SubStreamObjectName = params.get("SubStreamObjectName")
        self._SegmentObjectName = params.get("SegmentObjectName")
        if params.get("AddOnSubtitles") is not None:
            self._AddOnSubtitles = []
            for item in params.get("AddOnSubtitles"):
                obj = AddOnSubtitle()
                obj._deserialize(item)
                self._AddOnSubtitles.append(obj)
        if params.get("DrmInfo") is not None:
            self._DrmInfo = DrmInfo()
            self._DrmInfo._deserialize(params.get("DrmInfo"))
        self._DefinitionType = params.get("DefinitionType")
        if params.get("SubtitleTemplate") is not None:
            self._SubtitleTemplate = SubtitleTemplate()
            self._SubtitleTemplate._deserialize(params.get("SubtitleTemplate"))
        self._StdExtInfo = params.get("StdExtInfo")
        self._KeyPTSList = params.get("KeyPTSList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AdaptiveDynamicStreamingTemplate(AbstractModel):
    r"""转自适应码流模板详情

    """

    def __init__(self):
        r"""
        :param _Definition: 转自适应码流模板唯一标识。
        :type Definition: int
        :param _Type: 模板类型，取值范围：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :type Type: str
        :param _Name: 转自适应码流模板名称。
        :type Name: str
        :param _Comment: 转自适应码流模板描述信息。
        :type Comment: str
        :param _Format: 转自适应码流格式，取值范围：
<li>HLS，</li>
<li>MPEG-DASH。</li>
        :type Format: str
        :param _StreamInfos: 转自适应码流输入流参数信息，最多输入10路流。
        :type StreamInfos: list of AdaptiveStreamTemplate
        :param _DisableHigherVideoBitrate: 是否禁止视频低码率转高码率，取值范围：
<li>0：否，</li>
<li>1：是。</li>
        :type DisableHigherVideoBitrate: int
        :param _DisableHigherVideoResolution: 是否禁止视频分辨率转高分辨率，取值范围：
<li>0：否，</li>
<li>1：是。</li>
        :type DisableHigherVideoResolution: int
        :param _CreateTime: 模板创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type CreateTime: str
        :param _UpdateTime: 模板最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type UpdateTime: str
        :param _PureAudio: 是否为纯音频，0表示视频，1表示纯音频
注意：此字段可能返回 null，表示取不到有效值。
        :type PureAudio: int
        :param _SegmentType: hls 分片类型，可选值：
<li>ts-segment：HLS+TS 切片</li>
<li>ts-byterange：HLS+TS byte range</li>
<li>mp4-segment：HLS+MP4 切片</li>
<li>mp4-byterange：HLS+MP4 byte range</li>
<li>ts-packed-audio：TS+Packed Audio</li>
<li>mp4-packed-audio：MP4+Packed Audio</li>
默认值：ts-segment

注：自适应码流的hls分片格式已此字段为准
注意：此字段可能返回 null，表示取不到有效值。
        :type SegmentType: str
        """
        self._Definition = None
        self._Type = None
        self._Name = None
        self._Comment = None
        self._Format = None
        self._StreamInfos = None
        self._DisableHigherVideoBitrate = None
        self._DisableHigherVideoResolution = None
        self._CreateTime = None
        self._UpdateTime = None
        self._PureAudio = None
        self._SegmentType = None

    @property
    def Definition(self):
        r"""转自适应码流模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Type(self):
        r"""模板类型，取值范围：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        r"""转自适应码流模板名称。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        r"""转自适应码流模板描述信息。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def Format(self):
        r"""转自适应码流格式，取值范围：
<li>HLS，</li>
<li>MPEG-DASH。</li>
        :rtype: str
        """
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def StreamInfos(self):
        r"""转自适应码流输入流参数信息，最多输入10路流。
        :rtype: list of AdaptiveStreamTemplate
        """
        return self._StreamInfos

    @StreamInfos.setter
    def StreamInfos(self, StreamInfos):
        self._StreamInfos = StreamInfos

    @property
    def DisableHigherVideoBitrate(self):
        r"""是否禁止视频低码率转高码率，取值范围：
<li>0：否，</li>
<li>1：是。</li>
        :rtype: int
        """
        return self._DisableHigherVideoBitrate

    @DisableHigherVideoBitrate.setter
    def DisableHigherVideoBitrate(self, DisableHigherVideoBitrate):
        self._DisableHigherVideoBitrate = DisableHigherVideoBitrate

    @property
    def DisableHigherVideoResolution(self):
        r"""是否禁止视频分辨率转高分辨率，取值范围：
<li>0：否，</li>
<li>1：是。</li>
        :rtype: int
        """
        return self._DisableHigherVideoResolution

    @DisableHigherVideoResolution.setter
    def DisableHigherVideoResolution(self, DisableHigherVideoResolution):
        self._DisableHigherVideoResolution = DisableHigherVideoResolution

    @property
    def CreateTime(self):
        r"""模板创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""模板最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def PureAudio(self):
        r"""是否为纯音频，0表示视频，1表示纯音频
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._PureAudio

    @PureAudio.setter
    def PureAudio(self, PureAudio):
        self._PureAudio = PureAudio

    @property
    def SegmentType(self):
        r"""hls 分片类型，可选值：
<li>ts-segment：HLS+TS 切片</li>
<li>ts-byterange：HLS+TS byte range</li>
<li>mp4-segment：HLS+MP4 切片</li>
<li>mp4-byterange：HLS+MP4 byte range</li>
<li>ts-packed-audio：TS+Packed Audio</li>
<li>mp4-packed-audio：MP4+Packed Audio</li>
默认值：ts-segment

注：自适应码流的hls分片格式已此字段为准
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SegmentType

    @SegmentType.setter
    def SegmentType(self, SegmentType):
        self._SegmentType = SegmentType


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        self._Format = params.get("Format")
        if params.get("StreamInfos") is not None:
            self._StreamInfos = []
            for item in params.get("StreamInfos"):
                obj = AdaptiveStreamTemplate()
                obj._deserialize(item)
                self._StreamInfos.append(obj)
        self._DisableHigherVideoBitrate = params.get("DisableHigherVideoBitrate")
        self._DisableHigherVideoResolution = params.get("DisableHigherVideoResolution")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._PureAudio = params.get("PureAudio")
        self._SegmentType = params.get("SegmentType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AdaptiveStreamTemplate(AbstractModel):
    r"""自适应转码流参数模板

    """

    def __init__(self):
        r"""
        :param _Audio: 音频参数信息。
        :type Audio: :class:`tencentcloud.mps.v20190612.models.AudioTemplateInfo`
        :param _Video: 视频参数信息。
        :type Video: :class:`tencentcloud.mps.v20190612.models.VideoTemplateInfo`
        :param _RemoveAudio: 是否移除音频流，取值范围：
<li>0：否，</li>
<li>1：是。</li>
        :type RemoveAudio: int
        :param _RemoveVideo: 是否移除视频流，取值范围：
<li>0：否，</li>
<li>1：是。</li>
        :type RemoveVideo: int
        :param _AudioList: 音频参数信息列表。
注意：参数只在自适应转码使用音轨合并多音轨时使用, 参数数组长度最大为64。
注意：此字段可能返回 null，表示取不到有效值。
        :type AudioList: list of AudioTemplateInfo
        """
        self._Audio = None
        self._Video = None
        self._RemoveAudio = None
        self._RemoveVideo = None
        self._AudioList = None

    @property
    def Audio(self):
        r"""音频参数信息。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AudioTemplateInfo`
        """
        return self._Audio

    @Audio.setter
    def Audio(self, Audio):
        self._Audio = Audio

    @property
    def Video(self):
        r"""视频参数信息。
        :rtype: :class:`tencentcloud.mps.v20190612.models.VideoTemplateInfo`
        """
        return self._Video

    @Video.setter
    def Video(self, Video):
        self._Video = Video

    @property
    def RemoveAudio(self):
        r"""是否移除音频流，取值范围：
<li>0：否，</li>
<li>1：是。</li>
        :rtype: int
        """
        return self._RemoveAudio

    @RemoveAudio.setter
    def RemoveAudio(self, RemoveAudio):
        self._RemoveAudio = RemoveAudio

    @property
    def RemoveVideo(self):
        r"""是否移除视频流，取值范围：
<li>0：否，</li>
<li>1：是。</li>
        :rtype: int
        """
        return self._RemoveVideo

    @RemoveVideo.setter
    def RemoveVideo(self, RemoveVideo):
        self._RemoveVideo = RemoveVideo

    @property
    def AudioList(self):
        r"""音频参数信息列表。
注意：参数只在自适应转码使用音轨合并多音轨时使用, 参数数组长度最大为64。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of AudioTemplateInfo
        """
        return self._AudioList

    @AudioList.setter
    def AudioList(self, AudioList):
        self._AudioList = AudioList


    def _deserialize(self, params):
        if params.get("Audio") is not None:
            self._Audio = AudioTemplateInfo()
            self._Audio._deserialize(params.get("Audio"))
        if params.get("Video") is not None:
            self._Video = VideoTemplateInfo()
            self._Video._deserialize(params.get("Video"))
        self._RemoveAudio = params.get("RemoveAudio")
        self._RemoveVideo = params.get("RemoveVideo")
        if params.get("AudioList") is not None:
            self._AudioList = []
            for item in params.get("AudioList"):
                obj = AudioTemplateInfo()
                obj._deserialize(item)
                self._AudioList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddBlindWatermarkConfig(AbstractModel):
    r"""增加盲水印配置

    """

    def __init__(self):
        r"""
        :param _Switch: 能力配置开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
默认值：ON。
注意：此字段可能返回 null，表示取不到有效值。
        :type Switch: str
        :param _EmbedInfo: 盲水印嵌入数据
注意：此字段可能返回 null，表示取不到有效值。
        :type EmbedInfo: :class:`tencentcloud.mps.v20190612.models.BlindWatermarkEmbedInfo`
        """
        self._Switch = None
        self._EmbedInfo = None

    @property
    def Switch(self):
        r"""能力配置开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
默认值：ON。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def EmbedInfo(self):
        r"""盲水印嵌入数据
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.BlindWatermarkEmbedInfo`
        """
        return self._EmbedInfo

    @EmbedInfo.setter
    def EmbedInfo(self, EmbedInfo):
        self._EmbedInfo = EmbedInfo


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        if params.get("EmbedInfo") is not None:
            self._EmbedInfo = BlindWatermarkEmbedInfo()
            self._EmbedInfo._deserialize(params.get("EmbedInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddOnImageInput(AbstractModel):
    r"""图片处理编排中使用的输入参数。

    """

    def __init__(self):
        r"""
        :param _Image: 图片路径。
        :type Image: :class:`tencentcloud.mps.v20190612.models.MediaInputInfo`
        """
        self._Image = None

    @property
    def Image(self):
        r"""图片路径。
        :rtype: :class:`tencentcloud.mps.v20190612.models.MediaInputInfo`
        """
        return self._Image

    @Image.setter
    def Image(self, Image):
        self._Image = Image


    def _deserialize(self, params):
        if params.get("Image") is not None:
            self._Image = MediaInputInfo()
            self._Image._deserialize(params.get("Image"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddOnParameter(AbstractModel):
    r"""图片处理附加输入参数。

    """

    def __init__(self):
        r"""
        :param _ImageSet: 附加图片输入。
        :type ImageSet: list of AddOnImageInput
        :param _OutputConfig: 图片处理输出配置。
        :type OutputConfig: :class:`tencentcloud.mps.v20190612.models.ImageProcessOutputConfig`
        :param _ExtPrompt: 图片处理附加 prompt，只针对某些场景可用。
        :type ExtPrompt: list of ImageProcessPrompt
        """
        self._ImageSet = None
        self._OutputConfig = None
        self._ExtPrompt = None

    @property
    def ImageSet(self):
        r"""附加图片输入。
        :rtype: list of AddOnImageInput
        """
        return self._ImageSet

    @ImageSet.setter
    def ImageSet(self, ImageSet):
        self._ImageSet = ImageSet

    @property
    def OutputConfig(self):
        r"""图片处理输出配置。
        :rtype: :class:`tencentcloud.mps.v20190612.models.ImageProcessOutputConfig`
        """
        return self._OutputConfig

    @OutputConfig.setter
    def OutputConfig(self, OutputConfig):
        self._OutputConfig = OutputConfig

    @property
    def ExtPrompt(self):
        r"""图片处理附加 prompt，只针对某些场景可用。
        :rtype: list of ImageProcessPrompt
        """
        return self._ExtPrompt

    @ExtPrompt.setter
    def ExtPrompt(self, ExtPrompt):
        self._ExtPrompt = ExtPrompt


    def _deserialize(self, params):
        if params.get("ImageSet") is not None:
            self._ImageSet = []
            for item in params.get("ImageSet"):
                obj = AddOnImageInput()
                obj._deserialize(item)
                self._ImageSet.append(obj)
        if params.get("OutputConfig") is not None:
            self._OutputConfig = ImageProcessOutputConfig()
            self._OutputConfig._deserialize(params.get("OutputConfig"))
        if params.get("ExtPrompt") is not None:
            self._ExtPrompt = []
            for item in params.get("ExtPrompt"):
                obj = ImageProcessPrompt()
                obj._deserialize(item)
                self._ExtPrompt.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddOnSubtitle(AbstractModel):
    r"""外挂字幕。

    """

    def __init__(self):
        r"""
        :param _Type: 插入形式，可选值：
<li>subtitle-stream：插入字幕轨道</li>
<li>close-caption-708：CEA-708字幕编码到SEI帧</li>
<li>close-caption-608：CEA-608字幕编码到SEI帧</li>
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: str
        :param _Subtitle: 字幕文件。
注意：此字段可能返回 null，表示取不到有效值。
        :type Subtitle: :class:`tencentcloud.mps.v20190612.models.MediaInputInfo`
        :param _SubtitleName: 字幕名称	。
注意：仅支持中文、英文、数字、空格、下划线(_)、短横线(-)、句点(.)和中英文括号，长度不能超过64个字符。
注意：此字段可能返回 null，表示取不到有效值。
        :type SubtitleName: str
        :param _OutputFormat: 字幕输出格式。取值{"WebVTT","TTML"}。
默认值："WebVTT"
        :type OutputFormat: str
        :param _DefaultTrack: 默认字幕轨道。为true时指定当前字幕为默认字幕轨道，最多可指定1条默认字幕轨道。
默认值：false
        :type DefaultTrack: bool
        """
        self._Type = None
        self._Subtitle = None
        self._SubtitleName = None
        self._OutputFormat = None
        self._DefaultTrack = None

    @property
    def Type(self):
        r"""插入形式，可选值：
<li>subtitle-stream：插入字幕轨道</li>
<li>close-caption-708：CEA-708字幕编码到SEI帧</li>
<li>close-caption-608：CEA-608字幕编码到SEI帧</li>
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Subtitle(self):
        r"""字幕文件。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.MediaInputInfo`
        """
        return self._Subtitle

    @Subtitle.setter
    def Subtitle(self, Subtitle):
        self._Subtitle = Subtitle

    @property
    def SubtitleName(self):
        r"""字幕名称	。
注意：仅支持中文、英文、数字、空格、下划线(_)、短横线(-)、句点(.)和中英文括号，长度不能超过64个字符。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SubtitleName

    @SubtitleName.setter
    def SubtitleName(self, SubtitleName):
        self._SubtitleName = SubtitleName

    @property
    def OutputFormat(self):
        r"""字幕输出格式。取值{"WebVTT","TTML"}。
默认值："WebVTT"
        :rtype: str
        """
        return self._OutputFormat

    @OutputFormat.setter
    def OutputFormat(self, OutputFormat):
        self._OutputFormat = OutputFormat

    @property
    def DefaultTrack(self):
        r"""默认字幕轨道。为true时指定当前字幕为默认字幕轨道，最多可指定1条默认字幕轨道。
默认值：false
        :rtype: bool
        """
        return self._DefaultTrack

    @DefaultTrack.setter
    def DefaultTrack(self, DefaultTrack):
        self._DefaultTrack = DefaultTrack


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("Subtitle") is not None:
            self._Subtitle = MediaInputInfo()
            self._Subtitle._deserialize(params.get("Subtitle"))
        self._SubtitleName = params.get("SubtitleName")
        self._OutputFormat = params.get("OutputFormat")
        self._DefaultTrack = params.get("DefaultTrack")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AdvancedSuperResolutionConfig(AbstractModel):
    r"""超分配置

    """

    def __init__(self):
        r"""
        :param _Switch: 能力配置开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
默认值：ON。
        :type Switch: str
        :param _Type: 类型，可选值：
<li>standard：通用超分</li>
<li>super：高级超分super版。</li>
<li>ultra：高级超分ultra版。</li>
默认值：standard。
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: str
        :param _Mode: 输出图片模式，默认percent。
<li> aspect: 超分至指定宽高的较大矩形。</li>
<li> fixed: 超分至固定宽高，强制缩放。</li>
<li> percent: 超分倍率，可以为小数。</li>
注意：此字段可能返回 null，表示取不到有效值。
        :type Mode: str
        :param _Percent: 超分倍率，可以为小数。
注意：当Mode等于percent时使用。
注意：此字段可能返回 null，表示取不到有效值。
        :type Percent: float
        :param _Width: 目标图片宽度，不能超过4096。
注意：当Mode等于aspect或fixed时，优先使用此配置。
注意：此字段可能返回 null，表示取不到有效值。
        :type Width: int
        :param _Height: 目标图片高度，不能超过4096。
注意：当Mode等于aspect或fixed时，优先使用此配置。
注意：此字段可能返回 null，表示取不到有效值。
        :type Height: int
        :param _LongSide: 目标图片长边长度，不能超过4096。
注意：当Mode等于aspect或fixed，且未配置Width和Height字段时使用此配置。
注意：此字段可能返回 null，表示取不到有效值。
        :type LongSide: int
        :param _ShortSide: 目标图片短边长度，不能超过4096。
注意：当Mode等于aspect或fixed，且未配置Width和Height字段时使用此配置。
注意：此字段可能返回 null，表示取不到有效值。
        :type ShortSide: int
        """
        self._Switch = None
        self._Type = None
        self._Mode = None
        self._Percent = None
        self._Width = None
        self._Height = None
        self._LongSide = None
        self._ShortSide = None

    @property
    def Switch(self):
        r"""能力配置开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
默认值：ON。
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Type(self):
        r"""类型，可选值：
<li>standard：通用超分</li>
<li>super：高级超分super版。</li>
<li>ultra：高级超分ultra版。</li>
默认值：standard。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Mode(self):
        r"""输出图片模式，默认percent。
<li> aspect: 超分至指定宽高的较大矩形。</li>
<li> fixed: 超分至固定宽高，强制缩放。</li>
<li> percent: 超分倍率，可以为小数。</li>
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def Percent(self):
        r"""超分倍率，可以为小数。
注意：当Mode等于percent时使用。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: float
        """
        return self._Percent

    @Percent.setter
    def Percent(self, Percent):
        self._Percent = Percent

    @property
    def Width(self):
        r"""目标图片宽度，不能超过4096。
注意：当Mode等于aspect或fixed时，优先使用此配置。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        r"""目标图片高度，不能超过4096。
注意：当Mode等于aspect或fixed时，优先使用此配置。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def LongSide(self):
        r"""目标图片长边长度，不能超过4096。
注意：当Mode等于aspect或fixed，且未配置Width和Height字段时使用此配置。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._LongSide

    @LongSide.setter
    def LongSide(self, LongSide):
        self._LongSide = LongSide

    @property
    def ShortSide(self):
        r"""目标图片短边长度，不能超过4096。
注意：当Mode等于aspect或fixed，且未配置Width和Height字段时使用此配置。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._ShortSide

    @ShortSide.setter
    def ShortSide(self, ShortSide):
        self._ShortSide = ShortSide


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Type = params.get("Type")
        self._Mode = params.get("Mode")
        self._Percent = params.get("Percent")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._LongSide = params.get("LongSide")
        self._ShortSide = params.get("ShortSide")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisResult(AbstractModel):
    r"""智能分析结果

    """

    def __init__(self):
        r"""
        :param _Type: 任务的类型，可以取的值有：
<li>Classification：智能分类</li>
<li>Cover：智能封面</li>
<li>Tag：智能标签</li>
<li>FrameTag：智能按帧标签</li>
<li>Highlight：智能精彩集锦</li>
<li>DeLogo：智能擦除</li>
<li>Description：大模型摘要</li>
<li>Dubbing：智能译制</li>
<li>VideoRemake: 视频去重</li>
<li>VideoComprehension: 视频（音频）理解</li>
<li>Cutout：视频抠图</li>
<li>Reel：智能成片</li>
        :type Type: str
        :param _ClassificationTask: 视频内容分析智能分类任务的查询结果，当任务类型为 Classification 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type ClassificationTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskClassificationResult`
        :param _CoverTask: 视频内容分析智能封面任务的查询结果，当任务类型为 Cover 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type CoverTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskCoverResult`
        :param _TagTask: 视频内容分析智能标签任务的查询结果，当任务类型为 Tag 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type TagTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskTagResult`
        :param _FrameTagTask: 视频内容分析智能按帧标签任务的查询结果，当任务类型为 FrameTag 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type FrameTagTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskFrameTagResult`
        :param _HighlightTask: 视频内容分析集锦任务的查询结果，当任务类型为 Highlight时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type HighlightTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskHighlightResult`
        :param _DeLogoTask: 视频内容分析智能擦除任务的查询结果，当任务类型为 DeLogo 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type DeLogoTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskDelLogoResult`
        :param _SegmentTask: 视频内容分析拆条任务的查询结果，当任务类型为 SegmentRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type SegmentTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskSegmentResult`
        :param _HeadTailTask: 视频内容分析片头片尾任务的查询结果，当任务类型为 HeadTailRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type HeadTailTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskHeadTailResult`
        :param _DescriptionTask: 视频内容分析摘要任务的查询结果，当任务类型为 Description 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type DescriptionTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskDescriptionResult`
        :param _HorizontalToVerticalTask: 视频内容分析横转竖任务的查询结果，当任务类型为 HorizontalToVertical 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type HorizontalToVerticalTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskHorizontalToVerticalResult`
        :param _DubbingTask: 视频内容分析译制任务的查询结果，当任务类型为 Dubbing 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type DubbingTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskDubbingResult`
        :param _VideoRemakeTask: 视频内容分析去重任务的查询结果，当任务类型为 VideoRemake 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type VideoRemakeTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskVideoRemakeResult`
        :param _VideoComprehensionTask: 视频（音频）理解任务的查询结果，当任务类型为 VideoComprehension 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type VideoComprehensionTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskVideoComprehensionResult`
        :param _CutoutTask: 视频内容分析抠图任务的查询结果，当任务类型为Cutout时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type CutoutTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskCutoutResult`
        :param _ReelTask: 视频内容分析成片任务的查询结果，当任务类型为Reel时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type ReelTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskReelResult`
        """
        self._Type = None
        self._ClassificationTask = None
        self._CoverTask = None
        self._TagTask = None
        self._FrameTagTask = None
        self._HighlightTask = None
        self._DeLogoTask = None
        self._SegmentTask = None
        self._HeadTailTask = None
        self._DescriptionTask = None
        self._HorizontalToVerticalTask = None
        self._DubbingTask = None
        self._VideoRemakeTask = None
        self._VideoComprehensionTask = None
        self._CutoutTask = None
        self._ReelTask = None

    @property
    def Type(self):
        r"""任务的类型，可以取的值有：
<li>Classification：智能分类</li>
<li>Cover：智能封面</li>
<li>Tag：智能标签</li>
<li>FrameTag：智能按帧标签</li>
<li>Highlight：智能精彩集锦</li>
<li>DeLogo：智能擦除</li>
<li>Description：大模型摘要</li>
<li>Dubbing：智能译制</li>
<li>VideoRemake: 视频去重</li>
<li>VideoComprehension: 视频（音频）理解</li>
<li>Cutout：视频抠图</li>
<li>Reel：智能成片</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def ClassificationTask(self):
        r"""视频内容分析智能分类任务的查询结果，当任务类型为 Classification 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskClassificationResult`
        """
        return self._ClassificationTask

    @ClassificationTask.setter
    def ClassificationTask(self, ClassificationTask):
        self._ClassificationTask = ClassificationTask

    @property
    def CoverTask(self):
        r"""视频内容分析智能封面任务的查询结果，当任务类型为 Cover 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskCoverResult`
        """
        return self._CoverTask

    @CoverTask.setter
    def CoverTask(self, CoverTask):
        self._CoverTask = CoverTask

    @property
    def TagTask(self):
        r"""视频内容分析智能标签任务的查询结果，当任务类型为 Tag 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskTagResult`
        """
        return self._TagTask

    @TagTask.setter
    def TagTask(self, TagTask):
        self._TagTask = TagTask

    @property
    def FrameTagTask(self):
        r"""视频内容分析智能按帧标签任务的查询结果，当任务类型为 FrameTag 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskFrameTagResult`
        """
        return self._FrameTagTask

    @FrameTagTask.setter
    def FrameTagTask(self, FrameTagTask):
        self._FrameTagTask = FrameTagTask

    @property
    def HighlightTask(self):
        r"""视频内容分析集锦任务的查询结果，当任务类型为 Highlight时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskHighlightResult`
        """
        return self._HighlightTask

    @HighlightTask.setter
    def HighlightTask(self, HighlightTask):
        self._HighlightTask = HighlightTask

    @property
    def DeLogoTask(self):
        r"""视频内容分析智能擦除任务的查询结果，当任务类型为 DeLogo 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskDelLogoResult`
        """
        return self._DeLogoTask

    @DeLogoTask.setter
    def DeLogoTask(self, DeLogoTask):
        self._DeLogoTask = DeLogoTask

    @property
    def SegmentTask(self):
        r"""视频内容分析拆条任务的查询结果，当任务类型为 SegmentRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskSegmentResult`
        """
        return self._SegmentTask

    @SegmentTask.setter
    def SegmentTask(self, SegmentTask):
        self._SegmentTask = SegmentTask

    @property
    def HeadTailTask(self):
        r"""视频内容分析片头片尾任务的查询结果，当任务类型为 HeadTailRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskHeadTailResult`
        """
        return self._HeadTailTask

    @HeadTailTask.setter
    def HeadTailTask(self, HeadTailTask):
        self._HeadTailTask = HeadTailTask

    @property
    def DescriptionTask(self):
        r"""视频内容分析摘要任务的查询结果，当任务类型为 Description 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskDescriptionResult`
        """
        return self._DescriptionTask

    @DescriptionTask.setter
    def DescriptionTask(self, DescriptionTask):
        self._DescriptionTask = DescriptionTask

    @property
    def HorizontalToVerticalTask(self):
        r"""视频内容分析横转竖任务的查询结果，当任务类型为 HorizontalToVertical 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskHorizontalToVerticalResult`
        """
        return self._HorizontalToVerticalTask

    @HorizontalToVerticalTask.setter
    def HorizontalToVerticalTask(self, HorizontalToVerticalTask):
        self._HorizontalToVerticalTask = HorizontalToVerticalTask

    @property
    def DubbingTask(self):
        r"""视频内容分析译制任务的查询结果，当任务类型为 Dubbing 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskDubbingResult`
        """
        return self._DubbingTask

    @DubbingTask.setter
    def DubbingTask(self, DubbingTask):
        self._DubbingTask = DubbingTask

    @property
    def VideoRemakeTask(self):
        r"""视频内容分析去重任务的查询结果，当任务类型为 VideoRemake 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskVideoRemakeResult`
        """
        return self._VideoRemakeTask

    @VideoRemakeTask.setter
    def VideoRemakeTask(self, VideoRemakeTask):
        self._VideoRemakeTask = VideoRemakeTask

    @property
    def VideoComprehensionTask(self):
        r"""视频（音频）理解任务的查询结果，当任务类型为 VideoComprehension 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskVideoComprehensionResult`
        """
        return self._VideoComprehensionTask

    @VideoComprehensionTask.setter
    def VideoComprehensionTask(self, VideoComprehensionTask):
        self._VideoComprehensionTask = VideoComprehensionTask

    @property
    def CutoutTask(self):
        r"""视频内容分析抠图任务的查询结果，当任务类型为Cutout时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskCutoutResult`
        """
        return self._CutoutTask

    @CutoutTask.setter
    def CutoutTask(self, CutoutTask):
        self._CutoutTask = CutoutTask

    @property
    def ReelTask(self):
        r"""视频内容分析成片任务的查询结果，当任务类型为Reel时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskReelResult`
        """
        return self._ReelTask

    @ReelTask.setter
    def ReelTask(self, ReelTask):
        self._ReelTask = ReelTask


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("ClassificationTask") is not None:
            self._ClassificationTask = AiAnalysisTaskClassificationResult()
            self._ClassificationTask._deserialize(params.get("ClassificationTask"))
        if params.get("CoverTask") is not None:
            self._CoverTask = AiAnalysisTaskCoverResult()
            self._CoverTask._deserialize(params.get("CoverTask"))
        if params.get("TagTask") is not None:
            self._TagTask = AiAnalysisTaskTagResult()
            self._TagTask._deserialize(params.get("TagTask"))
        if params.get("FrameTagTask") is not None:
            self._FrameTagTask = AiAnalysisTaskFrameTagResult()
            self._FrameTagTask._deserialize(params.get("FrameTagTask"))
        if params.get("HighlightTask") is not None:
            self._HighlightTask = AiAnalysisTaskHighlightResult()
            self._HighlightTask._deserialize(params.get("HighlightTask"))
        if params.get("DeLogoTask") is not None:
            self._DeLogoTask = AiAnalysisTaskDelLogoResult()
            self._DeLogoTask._deserialize(params.get("DeLogoTask"))
        if params.get("SegmentTask") is not None:
            self._SegmentTask = AiAnalysisTaskSegmentResult()
            self._SegmentTask._deserialize(params.get("SegmentTask"))
        if params.get("HeadTailTask") is not None:
            self._HeadTailTask = AiAnalysisTaskHeadTailResult()
            self._HeadTailTask._deserialize(params.get("HeadTailTask"))
        if params.get("DescriptionTask") is not None:
            self._DescriptionTask = AiAnalysisTaskDescriptionResult()
            self._DescriptionTask._deserialize(params.get("DescriptionTask"))
        if params.get("HorizontalToVerticalTask") is not None:
            self._HorizontalToVerticalTask = AiAnalysisTaskHorizontalToVerticalResult()
            self._HorizontalToVerticalTask._deserialize(params.get("HorizontalToVerticalTask"))
        if params.get("DubbingTask") is not None:
            self._DubbingTask = AiAnalysisTaskDubbingResult()
            self._DubbingTask._deserialize(params.get("DubbingTask"))
        if params.get("VideoRemakeTask") is not None:
            self._VideoRemakeTask = AiAnalysisTaskVideoRemakeResult()
            self._VideoRemakeTask._deserialize(params.get("VideoRemakeTask"))
        if params.get("VideoComprehensionTask") is not None:
            self._VideoComprehensionTask = AiAnalysisTaskVideoComprehensionResult()
            self._VideoComprehensionTask._deserialize(params.get("VideoComprehensionTask"))
        if params.get("CutoutTask") is not None:
            self._CutoutTask = AiAnalysisTaskCutoutResult()
            self._CutoutTask._deserialize(params.get("CutoutTask"))
        if params.get("ReelTask") is not None:
            self._ReelTask = AiAnalysisTaskReelResult()
            self._ReelTask._deserialize(params.get("ReelTask"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskClassificationInput(AbstractModel):
    r"""智能分类任务输入类型

    """

    def __init__(self):
        r"""
        :param _Definition: 视频智能分类模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""视频智能分类模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskClassificationOutput(AbstractModel):
    r"""智能分类结果信息

    """

    def __init__(self):
        r"""
        :param _ClassificationSet: 视频智能分类列表。
        :type ClassificationSet: list of MediaAiAnalysisClassificationItem
        """
        self._ClassificationSet = None

    @property
    def ClassificationSet(self):
        r"""视频智能分类列表。
        :rtype: list of MediaAiAnalysisClassificationItem
        """
        return self._ClassificationSet

    @ClassificationSet.setter
    def ClassificationSet(self, ClassificationSet):
        self._ClassificationSet = ClassificationSet


    def _deserialize(self, params):
        if params.get("ClassificationSet") is not None:
            self._ClassificationSet = []
            for item in params.get("ClassificationSet"):
                obj = MediaAiAnalysisClassificationItem()
                obj._deserialize(item)
                self._ClassificationSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskClassificationResult(AbstractModel):
    r"""智能分类任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 智能分类任务输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskClassificationInput`
        :param _Output: 智能分类任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskClassificationOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""智能分类任务输入。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskClassificationInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""智能分类任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskClassificationOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskClassificationInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskClassificationOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskCoverInput(AbstractModel):
    r"""智能分类任务输入类型

    """

    def __init__(self):
        r"""
        :param _Definition: 视频智能封面模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""视频智能封面模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskCoverOutput(AbstractModel):
    r"""智能封面结果信息

    """

    def __init__(self):
        r"""
        :param _CoverSet: 智能封面列表。
        :type CoverSet: list of MediaAiAnalysisCoverItem
        :param _OutputStorage: 智能封面的存储位置。
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        self._CoverSet = None
        self._OutputStorage = None

    @property
    def CoverSet(self):
        r"""智能封面列表。
        :rtype: list of MediaAiAnalysisCoverItem
        """
        return self._CoverSet

    @CoverSet.setter
    def CoverSet(self, CoverSet):
        self._CoverSet = CoverSet

    @property
    def OutputStorage(self):
        r"""智能封面的存储位置。
        :rtype: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage


    def _deserialize(self, params):
        if params.get("CoverSet") is not None:
            self._CoverSet = []
            for item in params.get("CoverSet"):
                obj = MediaAiAnalysisCoverItem()
                obj._deserialize(item)
                self._CoverSet.append(obj)
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskCoverResult(AbstractModel):
    r"""智能封面结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 智能封面任务输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskCoverInput`
        :param _Output: 智能封面任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskCoverOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""智能封面任务输入。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskCoverInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""智能封面任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskCoverOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskCoverInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskCoverOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskCutoutInput(AbstractModel):
    r"""智能抠图任务输入类型

    """

    def __init__(self):
        r"""
        :param _Definition: 视频智能抠图模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""视频智能抠图模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskCutoutOutput(AbstractModel):
    r"""视频抠图结果信息

    """

    def __init__(self):
        r"""
        :param _Path: 视频智能抠图文件路径。
        :type Path: str
        :param _OutputStorage: 视频智能抠图的存储位置。
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        self._Path = None
        self._OutputStorage = None

    @property
    def Path(self):
        r"""视频智能抠图文件路径。
        :rtype: str
        """
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def OutputStorage(self):
        r"""视频智能抠图的存储位置。
        :rtype: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage


    def _deserialize(self, params):
        self._Path = params.get("Path")
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskCutoutResult(AbstractModel):
    r"""视频抠图结果数据结构

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 `PROCESSING`，`SUCCESS` 和 `FAIL` 三种
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _Message: 错误信息
        :type Message: str
        :param _Input: 抠图任务输入
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskCutoutInput`
        :param _Output: 抠图任务输出
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskCutoutOutput`
        :param _Progress: 任务进度
        :type Progress: int
        :param _BeginProcessTime: 任务开始执行的时间，采用 ISO 日期格式。
        :type BeginProcessTime: str
        :param _FinishTime: 任务结束执行的时间，采用 ISO 日期格式。
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        r"""任务状态，有 `PROCESSING`，`SUCCESS` 和 `FAIL` 三种
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def Message(self):
        r"""错误信息
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""抠图任务输入
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskCutoutInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""抠图任务输出
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskCutoutOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        r"""任务进度
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def BeginProcessTime(self):
        r"""任务开始执行的时间，采用 ISO 日期格式。
        :rtype: str
        """
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        r"""任务结束执行的时间，采用 ISO 日期格式。
        :rtype: str
        """
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskCutoutInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskCutoutOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskDelLogoInput(AbstractModel):
    r"""智能擦除任务输入类型

    """

    def __init__(self):
        r"""
        :param _Definition: 视频智能擦除模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""视频智能擦除模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskDelLogoOutput(AbstractModel):
    r"""智能擦除结果信息

    """

    def __init__(self):
        r"""
        :param _Path: 擦除后文件的路径。
        :type Path: str
        :param _OutputStorage: 擦除后文件的存储位置。
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _OriginSubtitlePath: 基于画面提取的字幕文件路径。
        :type OriginSubtitlePath: str
        :param _TranslateSubtitlePath: 基于画面提取的字幕翻译文件路径。
        :type TranslateSubtitlePath: str
        :param _SubtitlePos: 擦除的字幕位置。**注意**：仅对字幕提取且开启返回字幕位置时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type SubtitlePos: :class:`tencentcloud.mps.v20190612.models.SubtitlePosition`
        :param _VoiceClonedVideo: 音色克隆后的视频文件地址
注意：此字段可能返回 null，表示取不到有效值。
        :type VoiceClonedVideo: str
        :param _VoiceClonedMarkFile: 音色克隆的标注文件地址
注意：此字段可能返回 null，表示取不到有效值。
        :type VoiceClonedMarkFile: str
        """
        self._Path = None
        self._OutputStorage = None
        self._OriginSubtitlePath = None
        self._TranslateSubtitlePath = None
        self._SubtitlePos = None
        self._VoiceClonedVideo = None
        self._VoiceClonedMarkFile = None

    @property
    def Path(self):
        r"""擦除后文件的路径。
        :rtype: str
        """
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def OutputStorage(self):
        r"""擦除后文件的存储位置。
        :rtype: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage

    @property
    def OriginSubtitlePath(self):
        r"""基于画面提取的字幕文件路径。
        :rtype: str
        """
        return self._OriginSubtitlePath

    @OriginSubtitlePath.setter
    def OriginSubtitlePath(self, OriginSubtitlePath):
        self._OriginSubtitlePath = OriginSubtitlePath

    @property
    def TranslateSubtitlePath(self):
        r"""基于画面提取的字幕翻译文件路径。
        :rtype: str
        """
        return self._TranslateSubtitlePath

    @TranslateSubtitlePath.setter
    def TranslateSubtitlePath(self, TranslateSubtitlePath):
        self._TranslateSubtitlePath = TranslateSubtitlePath

    @property
    def SubtitlePos(self):
        r"""擦除的字幕位置。**注意**：仅对字幕提取且开启返回字幕位置时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.SubtitlePosition`
        """
        return self._SubtitlePos

    @SubtitlePos.setter
    def SubtitlePos(self, SubtitlePos):
        self._SubtitlePos = SubtitlePos

    @property
    def VoiceClonedVideo(self):
        r"""音色克隆后的视频文件地址
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._VoiceClonedVideo

    @VoiceClonedVideo.setter
    def VoiceClonedVideo(self, VoiceClonedVideo):
        self._VoiceClonedVideo = VoiceClonedVideo

    @property
    def VoiceClonedMarkFile(self):
        r"""音色克隆的标注文件地址
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._VoiceClonedMarkFile

    @VoiceClonedMarkFile.setter
    def VoiceClonedMarkFile(self, VoiceClonedMarkFile):
        self._VoiceClonedMarkFile = VoiceClonedMarkFile


    def _deserialize(self, params):
        self._Path = params.get("Path")
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        self._OriginSubtitlePath = params.get("OriginSubtitlePath")
        self._TranslateSubtitlePath = params.get("TranslateSubtitlePath")
        if params.get("SubtitlePos") is not None:
            self._SubtitlePos = SubtitlePosition()
            self._SubtitlePos._deserialize(params.get("SubtitlePos"))
        self._VoiceClonedVideo = params.get("VoiceClonedVideo")
        self._VoiceClonedMarkFile = params.get("VoiceClonedMarkFile")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskDelLogoResult(AbstractModel):
    r"""智能擦除结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCode: 错误码，0：成功，其他值：失败。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 智能擦除任务输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskDelLogoInput`
        :param _Output: 智能擦除任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskDelLogoOutput`
        """
        self._Status = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        r"""错误码，0：成功，其他值：失败。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""智能擦除任务输入。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskDelLogoInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""智能擦除任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskDelLogoOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskDelLogoInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskDelLogoOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskDescriptionInput(AbstractModel):
    r"""智能分类任务输入类型

    """

    def __init__(self):
        r"""
        :param _Definition: 视频智能描述模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""视频智能描述模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskDescriptionOutput(AbstractModel):
    r"""智能描述结果信息

    """

    def __init__(self):
        r"""
        :param _DescriptionSet: 视频智能描述列表。
        :type DescriptionSet: list of MediaAiAnalysisDescriptionItem
        """
        self._DescriptionSet = None

    @property
    def DescriptionSet(self):
        r"""视频智能描述列表。
        :rtype: list of MediaAiAnalysisDescriptionItem
        """
        return self._DescriptionSet

    @DescriptionSet.setter
    def DescriptionSet(self, DescriptionSet):
        self._DescriptionSet = DescriptionSet


    def _deserialize(self, params):
        if params.get("DescriptionSet") is not None:
            self._DescriptionSet = []
            for item in params.get("DescriptionSet"):
                obj = MediaAiAnalysisDescriptionItem()
                obj._deserialize(item)
                self._DescriptionSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskDescriptionResult(AbstractModel):
    r"""智能描述结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCode: 错误码，0：成功，其他值：失败。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 智能描述任务输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskDescriptionInput`
        :param _Output: 智能描述任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskDescriptionOutput`
        """
        self._Status = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        r"""错误码，0：成功，其他值：失败。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""智能描述任务输入。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskDescriptionInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""智能描述任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskDescriptionOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskDescriptionInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskDescriptionOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskDubbingInput(AbstractModel):
    r"""智能译制任务输入类型

    """

    def __init__(self):
        r"""
        :param _Definition: 视频译制模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""视频译制模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskDubbingOutput(AbstractModel):
    r"""智能译制结果信息

    """

    def __init__(self):
        r"""
        :param _VideoPath: 译制视频路径。
        :type VideoPath: str
        :param _SpeakerPath: 标记文件路径

        :type SpeakerPath: str
        :param _VoiceId: 音色id
        :type VoiceId: str
        :param _OutputStorage: 译制视频存储位置。
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        self._VideoPath = None
        self._SpeakerPath = None
        self._VoiceId = None
        self._OutputStorage = None

    @property
    def VideoPath(self):
        r"""译制视频路径。
        :rtype: str
        """
        return self._VideoPath

    @VideoPath.setter
    def VideoPath(self, VideoPath):
        self._VideoPath = VideoPath

    @property
    def SpeakerPath(self):
        r"""标记文件路径

        :rtype: str
        """
        return self._SpeakerPath

    @SpeakerPath.setter
    def SpeakerPath(self, SpeakerPath):
        self._SpeakerPath = SpeakerPath

    @property
    def VoiceId(self):
        r"""音色id
        :rtype: str
        """
        return self._VoiceId

    @VoiceId.setter
    def VoiceId(self, VoiceId):
        self._VoiceId = VoiceId

    @property
    def OutputStorage(self):
        r"""译制视频存储位置。
        :rtype: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage


    def _deserialize(self, params):
        self._VideoPath = params.get("VideoPath")
        self._SpeakerPath = params.get("SpeakerPath")
        self._VoiceId = params.get("VoiceId")
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskDubbingResult(AbstractModel):
    r"""智能译制结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCode: 错误码，0：成功，其他值：失败。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 智能译制任务输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskDubbingInput`
        :param _Output: 智能译制任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskDubbingOutput`
        """
        self._Status = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        r"""错误码，0：成功，其他值：失败。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""智能译制任务输入。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskDubbingInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""智能译制任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskDubbingOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskDubbingInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskDubbingOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskFrameTagInput(AbstractModel):
    r"""智能按帧标签任务输入类型

    """

    def __init__(self):
        r"""
        :param _Definition: 视频智能按帧标签模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""视频智能按帧标签模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskFrameTagOutput(AbstractModel):
    r"""智能按帧标签结果信息

    """

    def __init__(self):
        r"""
        :param _SegmentSet: 视频按帧标签列表。
        :type SegmentSet: list of MediaAiAnalysisFrameTagSegmentItem
        """
        self._SegmentSet = None

    @property
    def SegmentSet(self):
        r"""视频按帧标签列表。
        :rtype: list of MediaAiAnalysisFrameTagSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaAiAnalysisFrameTagSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskFrameTagResult(AbstractModel):
    r"""智能按帧标签结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 智能按帧标签任务输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskFrameTagInput`
        :param _Output: 智能按帧标签任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskFrameTagOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""智能按帧标签任务输入。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskFrameTagInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""智能按帧标签任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskFrameTagOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskFrameTagInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskFrameTagOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskHeadTailInput(AbstractModel):
    r"""片头片尾任务输入类型

    """

    def __init__(self):
        r"""
        :param _Definition: 片头片尾识别模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""片头片尾识别模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskHeadTailOutput(AbstractModel):
    r"""片头片尾结果信息

    """

    def __init__(self):
        r"""
        :param _HeadTimeOffset: 片头pts。
注意：此字段可能返回 null，表示取不到有效值。
        :type HeadTimeOffset: float
        :param _TailTimeOffset: 片尾pts。
注意：此字段可能返回 null，表示取不到有效值。
        :type TailTimeOffset: float
        """
        self._HeadTimeOffset = None
        self._TailTimeOffset = None

    @property
    def HeadTimeOffset(self):
        r"""片头pts。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: float
        """
        return self._HeadTimeOffset

    @HeadTimeOffset.setter
    def HeadTimeOffset(self, HeadTimeOffset):
        self._HeadTimeOffset = HeadTimeOffset

    @property
    def TailTimeOffset(self):
        r"""片尾pts。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: float
        """
        return self._TailTimeOffset

    @TailTimeOffset.setter
    def TailTimeOffset(self, TailTimeOffset):
        self._TailTimeOffset = TailTimeOffset


    def _deserialize(self, params):
        self._HeadTimeOffset = params.get("HeadTimeOffset")
        self._TailTimeOffset = params.get("TailTimeOffset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskHeadTailResult(AbstractModel):
    r"""片头片尾结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCode: 错误码，0：成功，其他值：失败。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 片头片尾任务输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskHeadTailInput`
        :param _Output: 片头片尾任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskHeadTailOutput`
        """
        self._Status = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        r"""错误码，0：成功，其他值：失败。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""片头片尾任务输入。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskHeadTailInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""片头片尾任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskHeadTailOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskHeadTailInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskHeadTailOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskHighlightInput(AbstractModel):
    r"""智能精彩片段任务输入类型

    """

    def __init__(self):
        r"""
        :param _Definition: 视频智能精彩片段模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""视频智能精彩片段模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskHighlightOutput(AbstractModel):
    r"""智能精彩片段结果信息

    """

    def __init__(self):
        r"""
        :param _HighlightSet: 视频智能精彩片段列表。
        :type HighlightSet: list of MediaAiAnalysisHighlightItem
        :param _OutputStorage: 精彩片段的存储位置。
注意：此字段可能返回 null，表示取不到有效值。
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        self._HighlightSet = None
        self._OutputStorage = None

    @property
    def HighlightSet(self):
        r"""视频智能精彩片段列表。
        :rtype: list of MediaAiAnalysisHighlightItem
        """
        return self._HighlightSet

    @HighlightSet.setter
    def HighlightSet(self, HighlightSet):
        self._HighlightSet = HighlightSet

    @property
    def OutputStorage(self):
        r"""精彩片段的存储位置。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage


    def _deserialize(self, params):
        if params.get("HighlightSet") is not None:
            self._HighlightSet = []
            for item in params.get("HighlightSet"):
                obj = MediaAiAnalysisHighlightItem()
                obj._deserialize(item)
                self._HighlightSet.append(obj)
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskHighlightResult(AbstractModel):
    r"""智能精彩片段结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCode: 错误码，0：成功，其他值：失败。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 智能精彩片段任务输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskHighlightInput`
        :param _Output: 智能精彩片段任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskHighlightOutput`
        """
        self._Status = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        r"""错误码，0：成功，其他值：失败。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""智能精彩片段任务输入。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskHighlightInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""智能精彩片段任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskHighlightOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskHighlightInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskHighlightOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskHorizontalToVerticalInput(AbstractModel):
    r"""智能横转竖任务输入类型

    """

    def __init__(self):
        r"""
        :param _Definition: 视频智能横转竖模板 ID
注意：此字段可能返回 null，表示取不到有效值。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""视频智能横转竖模板 ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskHorizontalToVerticalOutput(AbstractModel):
    r"""智能横转竖结果信息

    """

    def __init__(self):
        r"""
        :param _Path: 视频智能横转竖列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Path: str
        :param _OutputStorage: 智能横转竖视频的存储位置
注意：此字段可能返回 null，表示取不到有效值。
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _Confidence: 置信度。	
注意：此字段可能返回 null，表示取不到有效值。
        :type Confidence: float
        """
        self._Path = None
        self._OutputStorage = None
        self._Confidence = None

    @property
    def Path(self):
        r"""视频智能横转竖列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def OutputStorage(self):
        r"""智能横转竖视频的存储位置
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage

    @property
    def Confidence(self):
        r"""置信度。	
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence


    def _deserialize(self, params):
        self._Path = params.get("Path")
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        self._Confidence = params.get("Confidence")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskHorizontalToVerticalResult(AbstractModel):
    r"""智能横转竖结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种
注意：此字段可能返回 null，表示取不到有效值。
        :type Status: str
        :param _ErrCode: 错误码，0：成功，其他值：失败
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrCode: int
        :param _Message: 错误信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Message: str
        :param _Input: 智能横转竖任务输入
注意：此字段可能返回 null，表示取不到有效值。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskHorizontalToVerticalInput`
        :param _Output: 智能横转竖任务输出
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskHorizontalToVerticalOutput`
        """
        self._Status = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        r"""错误码，0：成功，其他值：失败
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""智能横转竖任务输入
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskHorizontalToVerticalInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""智能横转竖任务输出
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskHorizontalToVerticalOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskHorizontalToVerticalInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskHorizontalToVerticalOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskInput(AbstractModel):
    r"""AI 视频智能分析输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 视频内容分析模板 ID。
        :type Definition: int
        :param _ExtendedParameter: 扩展参数，其值为序列化的 json字符串。
注意：此参数为定制需求参数，参考如下：
[智能檫除](https://cloud.tencent.com/document/product/862/101530)
[智能拆条](https://cloud.tencent.com/document/product/862/112098)
[高光集锦](https://cloud.tencent.com/document/product/862/107280)
[智能横转竖](https://cloud.tencent.com/document/product/862/112112)
注意：此字段可能返回 null，表示取不到有效值。
        :type ExtendedParameter: str
        """
        self._Definition = None
        self._ExtendedParameter = None

    @property
    def Definition(self):
        r"""视频内容分析模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def ExtendedParameter(self):
        r"""扩展参数，其值为序列化的 json字符串。
注意：此参数为定制需求参数，参考如下：
[智能檫除](https://cloud.tencent.com/document/product/862/101530)
[智能拆条](https://cloud.tencent.com/document/product/862/112098)
[高光集锦](https://cloud.tencent.com/document/product/862/107280)
[智能横转竖](https://cloud.tencent.com/document/product/862/112112)
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ExtendedParameter

    @ExtendedParameter.setter
    def ExtendedParameter(self, ExtendedParameter):
        self._ExtendedParameter = ExtendedParameter


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._ExtendedParameter = params.get("ExtendedParameter")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskReelInput(AbstractModel):
    r"""智能成片任务输入类型

    """

    def __init__(self):
        r"""
        :param _Definition: 智能成片模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""智能成片模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskReelOutput(AbstractModel):
    r"""智能成片结果信息

    """

    def __init__(self):
        r"""
        :param _VideoPath: 成片视频路径。
        :type VideoPath: str
        :param _ScriptPath: 脚本文件路径

        :type ScriptPath: str
        :param _OutputStorage: 成片视频存储位置。
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        self._VideoPath = None
        self._ScriptPath = None
        self._OutputStorage = None

    @property
    def VideoPath(self):
        r"""成片视频路径。
        :rtype: str
        """
        return self._VideoPath

    @VideoPath.setter
    def VideoPath(self, VideoPath):
        self._VideoPath = VideoPath

    @property
    def ScriptPath(self):
        r"""脚本文件路径

        :rtype: str
        """
        return self._ScriptPath

    @ScriptPath.setter
    def ScriptPath(self, ScriptPath):
        self._ScriptPath = ScriptPath

    @property
    def OutputStorage(self):
        r"""成片视频存储位置。
        :rtype: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage


    def _deserialize(self, params):
        self._VideoPath = params.get("VideoPath")
        self._ScriptPath = params.get("ScriptPath")
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskReelResult(AbstractModel):
    r"""智能成片结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCode: 错误码，0：成功，其他值：失败。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 智能成片任务输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskReelInput`
        :param _Output: 智能成片任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskReelOutput`
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 媒体处理类错误码 列表。
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrCodeExt: str
        :param _Progress: 任务进度。
注意：此字段可能返回 null，表示取不到有效值。
        :type Progress: int
        :param _BeginProcessTime: 任务开始执行的时间，采用 ISO 日期格式。
注意：此字段可能返回 null，表示取不到有效值。
        :type BeginProcessTime: str
        :param _FinishTime: 任务执行完毕的时间，采用 ISO 日期格式。
注意：此字段可能返回 null，表示取不到有效值。
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._ErrCodeExt = None
        self._Progress = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        r"""错误码，0：成功，其他值：失败。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""智能成片任务输入。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskReelInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""智能成片任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskReelOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 媒体处理类错误码 列表。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def Progress(self):
        r"""任务进度。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def BeginProcessTime(self):
        r"""任务开始执行的时间，采用 ISO 日期格式。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        r"""任务执行完毕的时间，采用 ISO 日期格式。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskReelInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskReelOutput()
            self._Output._deserialize(params.get("Output"))
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._Progress = params.get("Progress")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskSegmentInput(AbstractModel):
    r"""拆条任务输入类型

    """

    def __init__(self):
        r"""
        :param _Definition: 拆条任务模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""拆条任务模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskSegmentOutput(AbstractModel):
    r"""智能拆条结果信息

    """

    def __init__(self):
        r"""
        :param _SegmentSet: 智能拆条子片段列表。
        :type SegmentSet: list of SegmentRecognitionItem
        :param _Abstract: 视频摘要，离线场景用。
注意：此字段可能返回 null，表示取不到有效值。
        :type Abstract: str
        """
        self._SegmentSet = None
        self._Abstract = None

    @property
    def SegmentSet(self):
        r"""智能拆条子片段列表。
        :rtype: list of SegmentRecognitionItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def Abstract(self):
        r"""视频摘要，离线场景用。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Abstract

    @Abstract.setter
    def Abstract(self, Abstract):
        self._Abstract = Abstract


    def _deserialize(self, params):
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = SegmentRecognitionItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._Abstract = params.get("Abstract")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskSegmentResult(AbstractModel):
    r"""拆条结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCode: 错误码，0：成功，其他值：失败。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 拆条任务输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskSegmentInput`
        :param _Output: 拆条任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskSegmentOutput`
        """
        self._Status = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        r"""错误码，0：成功，其他值：失败。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""拆条任务输入。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskSegmentInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""拆条任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskSegmentOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskSegmentInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskSegmentOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskTagInput(AbstractModel):
    r"""智能标签任务输入类型

    """

    def __init__(self):
        r"""
        :param _Definition: 视频智能标签模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""视频智能标签模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskTagOutput(AbstractModel):
    r"""智能标签结果信息

    """

    def __init__(self):
        r"""
        :param _TagSet: 视频智能标签列表。
        :type TagSet: list of MediaAiAnalysisTagItem
        """
        self._TagSet = None

    @property
    def TagSet(self):
        r"""视频智能标签列表。
        :rtype: list of MediaAiAnalysisTagItem
        """
        return self._TagSet

    @TagSet.setter
    def TagSet(self, TagSet):
        self._TagSet = TagSet


    def _deserialize(self, params):
        if params.get("TagSet") is not None:
            self._TagSet = []
            for item in params.get("TagSet"):
                obj = MediaAiAnalysisTagItem()
                obj._deserialize(item)
                self._TagSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskTagResult(AbstractModel):
    r"""智能标签结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 智能标签任务输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskTagInput`
        :param _Output: 智能标签任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskTagOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""智能标签任务输入。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskTagInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""智能标签任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskTagOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskTagInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskTagOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskVideoComprehensionInput(AbstractModel):
    r"""视频（音频）理解任务输入

    """

    def __init__(self):
        r"""
        :param _Definition: 视频（音频）理解模板ID
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""视频（音频）理解模板ID
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskVideoComprehensionOutput(AbstractModel):
    r"""视频（音频）理解输出内容结果信息

    """

    def __init__(self):
        r"""
        :param _VideoComprehensionAnalysisResult: 视频（音频）理解内容详情
        :type VideoComprehensionAnalysisResult: str
        """
        self._VideoComprehensionAnalysisResult = None

    @property
    def VideoComprehensionAnalysisResult(self):
        r"""视频（音频）理解内容详情
        :rtype: str
        """
        return self._VideoComprehensionAnalysisResult

    @VideoComprehensionAnalysisResult.setter
    def VideoComprehensionAnalysisResult(self, VideoComprehensionAnalysisResult):
        self._VideoComprehensionAnalysisResult = VideoComprehensionAnalysisResult


    def _deserialize(self, params):
        self._VideoComprehensionAnalysisResult = params.get("VideoComprehensionAnalysisResult")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskVideoComprehensionResult(AbstractModel):
    r"""视频（音频）理解结果

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 `PROCESSING`，`SUCCESS` 和 `FAIL` 三种。
        :type Status: str
        :param _ErrCode: 错误码，0：成功，其他值：失败
        :type ErrCode: int
        :param _Message: 错误信息
        :type Message: str
        :param _Input: 视频（音频）理解输入
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskVideoComprehensionInput`
        :param _Output: 视频（音频）理解输出
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskVideoComprehensionOutput`
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 媒体处理类错误码 列表
        :type ErrCodeExt: str
        :param _Progress: 任务进度
        :type Progress: int
        :param _BeginProcessTime: 任务开始执行的时间，采用 ISO 日期格式。
        :type BeginProcessTime: str
        :param _FinishTime: 任务执行完毕时间，采用 ISO 日期格式。
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._ErrCodeExt = None
        self._Progress = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        r"""任务状态，有 `PROCESSING`，`SUCCESS` 和 `FAIL` 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        r"""错误码，0：成功，其他值：失败
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""视频（音频）理解输入
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskVideoComprehensionInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""视频（音频）理解输出
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskVideoComprehensionOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 媒体处理类错误码 列表
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def Progress(self):
        r"""任务进度
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def BeginProcessTime(self):
        r"""任务开始执行的时间，采用 ISO 日期格式。
        :rtype: str
        """
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        r"""任务执行完毕时间，采用 ISO 日期格式。
        :rtype: str
        """
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskVideoComprehensionInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskVideoComprehensionOutput()
            self._Output._deserialize(params.get("Output"))
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._Progress = params.get("Progress")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskVideoRemakeInput(AbstractModel):
    r"""视频去重任务输入类型

    """

    def __init__(self):
        r"""
        :param _Definition: 视频智能去重模板 ID
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""视频智能去重模板 ID
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskVideoRemakeOutput(AbstractModel):
    r"""视频去重结果信息

    """

    def __init__(self):
        r"""
        :param _Path: 视频智能去重文件路径
        :type Path: str
        :param _OutputStorage: 智能视频去重的存储位置
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        self._Path = None
        self._OutputStorage = None

    @property
    def Path(self):
        r"""视频智能去重文件路径
        :rtype: str
        """
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def OutputStorage(self):
        r"""智能视频去重的存储位置
        :rtype: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage


    def _deserialize(self, params):
        self._Path = params.get("Path")
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskVideoRemakeResult(AbstractModel):
    r"""视频去重结果数据结构

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 `PROCESSING`，`SUCCESS` 和 `FAIL` 三种
        :type Status: str
        :param _ErrCode: 错误码，0：成功，其他值：失败
        :type ErrCode: int
        :param _Message: 错误信息
        :type Message: str
        :param _Input: 去重任务输入
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskVideoRemakeInput`
        :param _Output: 去重任务输出
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskVideoRemakeOutput`
        """
        self._Status = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""任务状态，有 `PROCESSING`，`SUCCESS` 和 `FAIL` 三种
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        r"""错误码，0：成功，其他值：失败
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""去重任务输入
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskVideoRemakeInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""去重任务输出
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskVideoRemakeOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskVideoRemakeInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskVideoRemakeOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiContentReviewResult(AbstractModel):
    r"""内容审核结果

    """

    def __init__(self):
        r"""
        :param _Type: 任务的类型，可以取的值有：
<li>Porn：图片鉴黄</li>
<li>Terrorism：图片敏感</li>
<li>Political：图片敏感</li>
<li>Porn.Asr：Asr 文字鉴黄</li>
<li>Porn.Ocr：Ocr 文字鉴黄</li>
<li>Political.Asr：Asr 文字敏感</li>
<li>Political.Ocr：Ocr 文字敏感</li>
<li>Terrorism.Ocr：Ocr 文字敏感</li>
<li>Prohibited.Asr：Asr 文字鉴违禁</li>
<li>Prohibited.Ocr：Ocr 文字鉴违禁</li>
        :type Type: str
        :param _SampleRate: 采样频率，即对视频每秒截取进行审核的帧数。
        :type SampleRate: float
        :param _Duration: 审核的视频时长，单位：秒。
        :type Duration: float
        :param _PornTask: 视频内容审核智能画面鉴黄任务的查询结果，当任务类型为 Porn 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type PornTask: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskPornResult`
        :param _TerrorismTask: 视频内容审核智能画面敏感任务的查询结果，当任务类型为 Terrorism 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type TerrorismTask: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskTerrorismResult`
        :param _PoliticalTask: 视频内容审核智能画面敏感任务的查询结果，当任务类型为 Political 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type PoliticalTask: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskPoliticalResult`
        :param _PornAsrTask: 视频内容审核 Asr 文字鉴黄任务的查询结果，当任务类型为 Porn.Asr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type PornAsrTask: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskPornAsrResult`
        :param _PornOcrTask: 视频内容审核 Ocr 文字鉴黄任务的查询结果，当任务类型为 Porn.Ocr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type PornOcrTask: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskPornOcrResult`
        :param _PoliticalAsrTask: 视频内容审核 Asr 文字敏感任务的查询结果，当任务类型为 Political.Asr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type PoliticalAsrTask: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskPoliticalAsrResult`
        :param _PoliticalOcrTask: 视频内容审核 Ocr 文字敏感任务的查询结果，当任务类型为 Political.Ocr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type PoliticalOcrTask: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskPoliticalOcrResult`
        :param _TerrorismOcrTask: 视频内容审核 Ocr 文字敏感任务的查询结果，当任务类型为 Terrorism.Ocr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type TerrorismOcrTask: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskTerrorismOcrResult`
        :param _ProhibitedAsrTask: 视频内容审核 Asr 文字鉴违禁任务的查询结果，当任务类型为 Prohibited.Asr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type ProhibitedAsrTask: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskProhibitedAsrResult`
        :param _ProhibitedOcrTask: 视频内容审核 Ocr 文字鉴违禁任务的查询结果，当任务类型为 Prohibited.Ocr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type ProhibitedOcrTask: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskProhibitedOcrResult`
        """
        self._Type = None
        self._SampleRate = None
        self._Duration = None
        self._PornTask = None
        self._TerrorismTask = None
        self._PoliticalTask = None
        self._PornAsrTask = None
        self._PornOcrTask = None
        self._PoliticalAsrTask = None
        self._PoliticalOcrTask = None
        self._TerrorismOcrTask = None
        self._ProhibitedAsrTask = None
        self._ProhibitedOcrTask = None

    @property
    def Type(self):
        r"""任务的类型，可以取的值有：
<li>Porn：图片鉴黄</li>
<li>Terrorism：图片敏感</li>
<li>Political：图片敏感</li>
<li>Porn.Asr：Asr 文字鉴黄</li>
<li>Porn.Ocr：Ocr 文字鉴黄</li>
<li>Political.Asr：Asr 文字敏感</li>
<li>Political.Ocr：Ocr 文字敏感</li>
<li>Terrorism.Ocr：Ocr 文字敏感</li>
<li>Prohibited.Asr：Asr 文字鉴违禁</li>
<li>Prohibited.Ocr：Ocr 文字鉴违禁</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def SampleRate(self):
        r"""采样频率，即对视频每秒截取进行审核的帧数。
        :rtype: float
        """
        return self._SampleRate

    @SampleRate.setter
    def SampleRate(self, SampleRate):
        self._SampleRate = SampleRate

    @property
    def Duration(self):
        r"""审核的视频时长，单位：秒。
        :rtype: float
        """
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration

    @property
    def PornTask(self):
        r"""视频内容审核智能画面鉴黄任务的查询结果，当任务类型为 Porn 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskPornResult`
        """
        return self._PornTask

    @PornTask.setter
    def PornTask(self, PornTask):
        self._PornTask = PornTask

    @property
    def TerrorismTask(self):
        r"""视频内容审核智能画面敏感任务的查询结果，当任务类型为 Terrorism 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskTerrorismResult`
        """
        return self._TerrorismTask

    @TerrorismTask.setter
    def TerrorismTask(self, TerrorismTask):
        self._TerrorismTask = TerrorismTask

    @property
    def PoliticalTask(self):
        r"""视频内容审核智能画面敏感任务的查询结果，当任务类型为 Political 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskPoliticalResult`
        """
        return self._PoliticalTask

    @PoliticalTask.setter
    def PoliticalTask(self, PoliticalTask):
        self._PoliticalTask = PoliticalTask

    @property
    def PornAsrTask(self):
        r"""视频内容审核 Asr 文字鉴黄任务的查询结果，当任务类型为 Porn.Asr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskPornAsrResult`
        """
        return self._PornAsrTask

    @PornAsrTask.setter
    def PornAsrTask(self, PornAsrTask):
        self._PornAsrTask = PornAsrTask

    @property
    def PornOcrTask(self):
        r"""视频内容审核 Ocr 文字鉴黄任务的查询结果，当任务类型为 Porn.Ocr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskPornOcrResult`
        """
        return self._PornOcrTask

    @PornOcrTask.setter
    def PornOcrTask(self, PornOcrTask):
        self._PornOcrTask = PornOcrTask

    @property
    def PoliticalAsrTask(self):
        r"""视频内容审核 Asr 文字敏感任务的查询结果，当任务类型为 Political.Asr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskPoliticalAsrResult`
        """
        return self._PoliticalAsrTask

    @PoliticalAsrTask.setter
    def PoliticalAsrTask(self, PoliticalAsrTask):
        self._PoliticalAsrTask = PoliticalAsrTask

    @property
    def PoliticalOcrTask(self):
        r"""视频内容审核 Ocr 文字敏感任务的查询结果，当任务类型为 Political.Ocr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskPoliticalOcrResult`
        """
        return self._PoliticalOcrTask

    @PoliticalOcrTask.setter
    def PoliticalOcrTask(self, PoliticalOcrTask):
        self._PoliticalOcrTask = PoliticalOcrTask

    @property
    def TerrorismOcrTask(self):
        r"""视频内容审核 Ocr 文字敏感任务的查询结果，当任务类型为 Terrorism.Ocr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskTerrorismOcrResult`
        """
        return self._TerrorismOcrTask

    @TerrorismOcrTask.setter
    def TerrorismOcrTask(self, TerrorismOcrTask):
        self._TerrorismOcrTask = TerrorismOcrTask

    @property
    def ProhibitedAsrTask(self):
        r"""视频内容审核 Asr 文字鉴违禁任务的查询结果，当任务类型为 Prohibited.Asr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskProhibitedAsrResult`
        """
        return self._ProhibitedAsrTask

    @ProhibitedAsrTask.setter
    def ProhibitedAsrTask(self, ProhibitedAsrTask):
        self._ProhibitedAsrTask = ProhibitedAsrTask

    @property
    def ProhibitedOcrTask(self):
        r"""视频内容审核 Ocr 文字鉴违禁任务的查询结果，当任务类型为 Prohibited.Ocr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskProhibitedOcrResult`
        """
        return self._ProhibitedOcrTask

    @ProhibitedOcrTask.setter
    def ProhibitedOcrTask(self, ProhibitedOcrTask):
        self._ProhibitedOcrTask = ProhibitedOcrTask


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._SampleRate = params.get("SampleRate")
        self._Duration = params.get("Duration")
        if params.get("PornTask") is not None:
            self._PornTask = AiReviewTaskPornResult()
            self._PornTask._deserialize(params.get("PornTask"))
        if params.get("TerrorismTask") is not None:
            self._TerrorismTask = AiReviewTaskTerrorismResult()
            self._TerrorismTask._deserialize(params.get("TerrorismTask"))
        if params.get("PoliticalTask") is not None:
            self._PoliticalTask = AiReviewTaskPoliticalResult()
            self._PoliticalTask._deserialize(params.get("PoliticalTask"))
        if params.get("PornAsrTask") is not None:
            self._PornAsrTask = AiReviewTaskPornAsrResult()
            self._PornAsrTask._deserialize(params.get("PornAsrTask"))
        if params.get("PornOcrTask") is not None:
            self._PornOcrTask = AiReviewTaskPornOcrResult()
            self._PornOcrTask._deserialize(params.get("PornOcrTask"))
        if params.get("PoliticalAsrTask") is not None:
            self._PoliticalAsrTask = AiReviewTaskPoliticalAsrResult()
            self._PoliticalAsrTask._deserialize(params.get("PoliticalAsrTask"))
        if params.get("PoliticalOcrTask") is not None:
            self._PoliticalOcrTask = AiReviewTaskPoliticalOcrResult()
            self._PoliticalOcrTask._deserialize(params.get("PoliticalOcrTask"))
        if params.get("TerrorismOcrTask") is not None:
            self._TerrorismOcrTask = AiReviewTaskTerrorismOcrResult()
            self._TerrorismOcrTask._deserialize(params.get("TerrorismOcrTask"))
        if params.get("ProhibitedAsrTask") is not None:
            self._ProhibitedAsrTask = AiReviewTaskProhibitedAsrResult()
            self._ProhibitedAsrTask._deserialize(params.get("ProhibitedAsrTask"))
        if params.get("ProhibitedOcrTask") is not None:
            self._ProhibitedOcrTask = AiReviewTaskProhibitedOcrResult()
            self._ProhibitedOcrTask._deserialize(params.get("ProhibitedOcrTask"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiContentReviewTaskInput(AbstractModel):
    r"""智能内容审核任务类型

    """

    def __init__(self):
        r"""
        :param _Definition: 视频内容审核模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""视频内容审核模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiParagraphInfo(AbstractModel):
    r"""分段信息。

    """

    def __init__(self):
        r"""
        :param _Summary: 分段摘要
注意：此字段可能返回 null，表示取不到有效值。
        :type Summary: str
        :param _Title: 分段标题
        :type Title: str
        :param _Keywords: 分段关键词
        :type Keywords: list of str
        :param _StartTimeOffset: 分段起始时间点，秒
注意：此字段可能返回 null，表示取不到有效值。
        :type StartTimeOffset: float
        :param _EndTimeOffset: 分段结束时间点，秒
注意：此字段可能返回 null，表示取不到有效值。
        :type EndTimeOffset: float
        """
        self._Summary = None
        self._Title = None
        self._Keywords = None
        self._StartTimeOffset = None
        self._EndTimeOffset = None

    @property
    def Summary(self):
        r"""分段摘要
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Summary

    @Summary.setter
    def Summary(self, Summary):
        self._Summary = Summary

    @property
    def Title(self):
        r"""分段标题
        :rtype: str
        """
        return self._Title

    @Title.setter
    def Title(self, Title):
        self._Title = Title

    @property
    def Keywords(self):
        r"""分段关键词
        :rtype: list of str
        """
        return self._Keywords

    @Keywords.setter
    def Keywords(self, Keywords):
        self._Keywords = Keywords

    @property
    def StartTimeOffset(self):
        r"""分段起始时间点，秒
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: float
        """
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        r"""分段结束时间点，秒
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: float
        """
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset


    def _deserialize(self, params):
        self._Summary = params.get("Summary")
        self._Title = params.get("Title")
        self._Keywords = params.get("Keywords")
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiQualityControlTaskInput(AbstractModel):
    r"""媒体质检输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 媒体质检模板 ID 。
可以直接使用预设模板，也可以在控制台自定义模板。预设模板如下：
- 10：开启所有质检项；
- 20：仅开启格式诊断对应质检项；
- 30：仅开启无参考打分对应质检项；
- 40：仅开启画面质量对应质检项。
注意：此字段可能返回 null，表示取不到有效值。
        :type Definition: int
        :param _ChannelExtPara: 渠道扩展参数json序列化字符串。
注意：此字段可能返回 null，表示取不到有效值。
        :type ChannelExtPara: str
        """
        self._Definition = None
        self._ChannelExtPara = None

    @property
    def Definition(self):
        r"""媒体质检模板 ID 。
可以直接使用预设模板，也可以在控制台自定义模板。预设模板如下：
- 10：开启所有质检项；
- 20：仅开启格式诊断对应质检项；
- 30：仅开启无参考打分对应质检项；
- 40：仅开启画面质量对应质检项。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def ChannelExtPara(self):
        r"""渠道扩展参数json序列化字符串。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ChannelExtPara

    @ChannelExtPara.setter
    def ChannelExtPara(self, ChannelExtPara):
        self._ChannelExtPara = ChannelExtPara


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._ChannelExtPara = params.get("ChannelExtPara")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionResult(AbstractModel):
    r"""智能识别结果。

    """

    def __init__(self):
        r"""
        :param _Type: 任务的类型，取值范围：
<li>FaceRecognition：人脸识别，</li>
<li>AsrWordsRecognition：语音关键词识别，</li>
<li>OcrWordsRecognition：文本关键词识别，</li>
<li>AsrFullTextRecognition：语音全文识别，</li>
<li>OcrFullTextRecognition：文本全文识别。</li>
<li>TransTextRecognition：语音翻译。</li>
        :type Type: str
        :param _FaceTask: 人脸识别结果，当 Type 为 
 FaceRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type FaceTask: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskFaceResult`
        :param _AsrWordsTask: 语音关键词识别结果，当 Type 为
 AsrWordsRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type AsrWordsTask: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskAsrWordsResult`
        :param _AsrFullTextTask: 语音全文识别结果，当 Type 为
 AsrFullTextRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type AsrFullTextTask: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskAsrFullTextResult`
        :param _OcrWordsTask: 文本关键词识别结果，当 Type 为
 OcrWordsRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type OcrWordsTask: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskOcrWordsResult`
        :param _OcrFullTextTask: 文本全文识别结果，当 Type 为
 OcrFullTextRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type OcrFullTextTask: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskOcrFullTextResult`
        :param _TransTextTask: 翻译结果，当 Type 为

TransTextRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type TransTextTask: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskTransTextResult`
        :param _ObjectTask: 物体识别结果，当Type 为

ObjectRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type ObjectTask: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskObjectResult`
        """
        self._Type = None
        self._FaceTask = None
        self._AsrWordsTask = None
        self._AsrFullTextTask = None
        self._OcrWordsTask = None
        self._OcrFullTextTask = None
        self._TransTextTask = None
        self._ObjectTask = None

    @property
    def Type(self):
        r"""任务的类型，取值范围：
<li>FaceRecognition：人脸识别，</li>
<li>AsrWordsRecognition：语音关键词识别，</li>
<li>OcrWordsRecognition：文本关键词识别，</li>
<li>AsrFullTextRecognition：语音全文识别，</li>
<li>OcrFullTextRecognition：文本全文识别。</li>
<li>TransTextRecognition：语音翻译。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def FaceTask(self):
        r"""人脸识别结果，当 Type 为 
 FaceRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskFaceResult`
        """
        return self._FaceTask

    @FaceTask.setter
    def FaceTask(self, FaceTask):
        self._FaceTask = FaceTask

    @property
    def AsrWordsTask(self):
        r"""语音关键词识别结果，当 Type 为
 AsrWordsRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskAsrWordsResult`
        """
        return self._AsrWordsTask

    @AsrWordsTask.setter
    def AsrWordsTask(self, AsrWordsTask):
        self._AsrWordsTask = AsrWordsTask

    @property
    def AsrFullTextTask(self):
        r"""语音全文识别结果，当 Type 为
 AsrFullTextRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskAsrFullTextResult`
        """
        return self._AsrFullTextTask

    @AsrFullTextTask.setter
    def AsrFullTextTask(self, AsrFullTextTask):
        self._AsrFullTextTask = AsrFullTextTask

    @property
    def OcrWordsTask(self):
        r"""文本关键词识别结果，当 Type 为
 OcrWordsRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskOcrWordsResult`
        """
        return self._OcrWordsTask

    @OcrWordsTask.setter
    def OcrWordsTask(self, OcrWordsTask):
        self._OcrWordsTask = OcrWordsTask

    @property
    def OcrFullTextTask(self):
        r"""文本全文识别结果，当 Type 为
 OcrFullTextRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskOcrFullTextResult`
        """
        return self._OcrFullTextTask

    @OcrFullTextTask.setter
    def OcrFullTextTask(self, OcrFullTextTask):
        self._OcrFullTextTask = OcrFullTextTask

    @property
    def TransTextTask(self):
        r"""翻译结果，当 Type 为

TransTextRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskTransTextResult`
        """
        return self._TransTextTask

    @TransTextTask.setter
    def TransTextTask(self, TransTextTask):
        self._TransTextTask = TransTextTask

    @property
    def ObjectTask(self):
        r"""物体识别结果，当Type 为

ObjectRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskObjectResult`
        """
        return self._ObjectTask

    @ObjectTask.setter
    def ObjectTask(self, ObjectTask):
        self._ObjectTask = ObjectTask


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("FaceTask") is not None:
            self._FaceTask = AiRecognitionTaskFaceResult()
            self._FaceTask._deserialize(params.get("FaceTask"))
        if params.get("AsrWordsTask") is not None:
            self._AsrWordsTask = AiRecognitionTaskAsrWordsResult()
            self._AsrWordsTask._deserialize(params.get("AsrWordsTask"))
        if params.get("AsrFullTextTask") is not None:
            self._AsrFullTextTask = AiRecognitionTaskAsrFullTextResult()
            self._AsrFullTextTask._deserialize(params.get("AsrFullTextTask"))
        if params.get("OcrWordsTask") is not None:
            self._OcrWordsTask = AiRecognitionTaskOcrWordsResult()
            self._OcrWordsTask._deserialize(params.get("OcrWordsTask"))
        if params.get("OcrFullTextTask") is not None:
            self._OcrFullTextTask = AiRecognitionTaskOcrFullTextResult()
            self._OcrFullTextTask._deserialize(params.get("OcrFullTextTask"))
        if params.get("TransTextTask") is not None:
            self._TransTextTask = AiRecognitionTaskTransTextResult()
            self._TransTextTask._deserialize(params.get("TransTextTask"))
        if params.get("ObjectTask") is not None:
            self._ObjectTask = AiRecognitionTaskObjectResult()
            self._ObjectTask._deserialize(params.get("ObjectTask"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrFullTextResult(AbstractModel):
    r"""语音全文识别结果。

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 语音全文识别任务输入信息。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskAsrFullTextResultInput`
        :param _Output: 语音全文识别任务输出信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskAsrFullTextResultOutput`
        :param _Progress: 任务进度。
注意：此字段可能返回 null，表示取不到有效值。
        :type Progress: int
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""语音全文识别任务输入信息。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskAsrFullTextResultInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""语音全文识别任务输出信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskAsrFullTextResultOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        r"""任务进度。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskAsrFullTextResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskAsrFullTextResultOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrFullTextResultInput(AbstractModel):
    r"""语音全文识别的输入。

    """

    def __init__(self):
        r"""
        :param _Definition: 语音全文识别模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""语音全文识别模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrFullTextResultOutput(AbstractModel):
    r"""语音全文识别结果。

    """

    def __init__(self):
        r"""
        :param _SegmentSet: 语音全文识别片段列表。
        :type SegmentSet: list of AiRecognitionTaskAsrFullTextSegmentItem
        :param _SubtitlePath: 字幕文件地址。
        :type SubtitlePath: str
        :param _OutputStorage: 字幕文件存储位置。
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        self._SegmentSet = None
        self._SubtitlePath = None
        self._OutputStorage = None

    @property
    def SegmentSet(self):
        r"""语音全文识别片段列表。
        :rtype: list of AiRecognitionTaskAsrFullTextSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SubtitlePath(self):
        r"""字幕文件地址。
        :rtype: str
        """
        return self._SubtitlePath

    @SubtitlePath.setter
    def SubtitlePath(self, SubtitlePath):
        self._SubtitlePath = SubtitlePath

    @property
    def OutputStorage(self):
        warnings.warn("parameter `OutputStorage` is deprecated", DeprecationWarning) 

        r"""字幕文件存储位置。
        :rtype: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        warnings.warn("parameter `OutputStorage` is deprecated", DeprecationWarning) 

        self._OutputStorage = OutputStorage


    def _deserialize(self, params):
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskAsrFullTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SubtitlePath = params.get("SubtitlePath")
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrFullTextSegmentItem(AbstractModel):
    r"""语音全文识别片段。

    """

    def __init__(self):
        r"""
        :param _Confidence: 识别片段置信度。取值：0~100。
        :type Confidence: float
        :param _StartTimeOffset: 识别片段起始的偏移时间，单位：秒。
        :type StartTimeOffset: float
        :param _EndTimeOffset: 识别片段终止的偏移时间，单位：秒。
        :type EndTimeOffset: float
        :param _Text: 识别文本。
        :type Text: str
        :param _Wordlist: 字词时间戳信息。
        :type Wordlist: list of WordResult
        """
        self._Confidence = None
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Text = None
        self._Wordlist = None

    @property
    def Confidence(self):
        r"""识别片段置信度。取值：0~100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def StartTimeOffset(self):
        r"""识别片段起始的偏移时间，单位：秒。
        :rtype: float
        """
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        r"""识别片段终止的偏移时间，单位：秒。
        :rtype: float
        """
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Text(self):
        r"""识别文本。
        :rtype: str
        """
        return self._Text

    @Text.setter
    def Text(self, Text):
        self._Text = Text

    @property
    def Wordlist(self):
        r"""字词时间戳信息。
        :rtype: list of WordResult
        """
        return self._Wordlist

    @Wordlist.setter
    def Wordlist(self, Wordlist):
        self._Wordlist = Wordlist


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Text = params.get("Text")
        if params.get("Wordlist") is not None:
            self._Wordlist = []
            for item in params.get("Wordlist"):
                obj = WordResult()
                obj._deserialize(item)
                self._Wordlist.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrWordsResult(AbstractModel):
    r"""语音关键词识别结果。

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 语音关键词识别任务输入信息。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskAsrWordsResultInput`
        :param _Output: 语音关键词识别任务输出信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskAsrWordsResultOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""语音关键词识别任务输入信息。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskAsrWordsResultInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""语音关键词识别任务输出信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskAsrWordsResultOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskAsrWordsResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskAsrWordsResultOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrWordsResultInput(AbstractModel):
    r"""语音关键词识别输入。

    """

    def __init__(self):
        r"""
        :param _Definition: 语音关键词识别模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""语音关键词识别模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrWordsResultItem(AbstractModel):
    r"""语音关键词识别结果。

    """

    def __init__(self):
        r"""
        :param _Word: 语音关键词。
        :type Word: str
        :param _SegmentSet: 语音关键词出现的时间片段列表。
        :type SegmentSet: list of AiRecognitionTaskAsrWordsSegmentItem
        """
        self._Word = None
        self._SegmentSet = None

    @property
    def Word(self):
        r"""语音关键词。
        :rtype: str
        """
        return self._Word

    @Word.setter
    def Word(self, Word):
        self._Word = Word

    @property
    def SegmentSet(self):
        r"""语音关键词出现的时间片段列表。
        :rtype: list of AiRecognitionTaskAsrWordsSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Word = params.get("Word")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskAsrWordsSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrWordsResultOutput(AbstractModel):
    r"""语音关键词识别输出。

    """

    def __init__(self):
        r"""
        :param _ResultSet: 语音关键词识别结果集。
        :type ResultSet: list of AiRecognitionTaskAsrWordsResultItem
        """
        self._ResultSet = None

    @property
    def ResultSet(self):
        r"""语音关键词识别结果集。
        :rtype: list of AiRecognitionTaskAsrWordsResultItem
        """
        return self._ResultSet

    @ResultSet.setter
    def ResultSet(self, ResultSet):
        self._ResultSet = ResultSet


    def _deserialize(self, params):
        if params.get("ResultSet") is not None:
            self._ResultSet = []
            for item in params.get("ResultSet"):
                obj = AiRecognitionTaskAsrWordsResultItem()
                obj._deserialize(item)
                self._ResultSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrWordsSegmentItem(AbstractModel):
    r"""语音识别片段。

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: 识别片段起始的偏移时间，单位：秒。
        :type StartTimeOffset: float
        :param _EndTimeOffset: 识别片段终止的偏移时间，单位：秒。
        :type EndTimeOffset: float
        :param _Confidence: 识别片段置信度。取值：0~100。
        :type Confidence: float
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Confidence = None

    @property
    def StartTimeOffset(self):
        r"""识别片段起始的偏移时间，单位：秒。
        :rtype: float
        """
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        r"""识别片段终止的偏移时间，单位：秒。
        :rtype: float
        """
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Confidence(self):
        r"""识别片段置信度。取值：0~100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Confidence = params.get("Confidence")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskFaceResult(AbstractModel):
    r"""人脸识别结果。

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 人脸识别任务输入信息。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskFaceResultInput`
        :param _Output: 人脸识别任务输出信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskFaceResultOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""人脸识别任务输入信息。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskFaceResultInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""人脸识别任务输出信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskFaceResultOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskFaceResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskFaceResultOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskFaceResultInput(AbstractModel):
    r"""人脸识别输入。

    """

    def __init__(self):
        r"""
        :param _Definition: 人脸识别模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""人脸识别模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskFaceResultItem(AbstractModel):
    r"""人脸识别结果

    """

    def __init__(self):
        r"""
        :param _Id: 人物唯一标识 ID。
        :type Id: str
        :param _Type: 人物库类型，表示识别出的人物来自哪个人物库：
<li>Default：默认人物库；</li>
<li>UserDefine：用户自定义人物库。</li>
        :type Type: str
        :param _Name: 人物名称。
        :type Name: str
        :param _SegmentSet: 人物出现的片段结果集。
        :type SegmentSet: list of AiRecognitionTaskFaceSegmentItem
        :param _Gender: 人物性别：
<li>Male：男性；</li>
<li>Female：女性。</li>
        :type Gender: str
        :param _Birthday: 人物出生日期。
        :type Birthday: str
        :param _Profession: 人物职业或者职务。
        :type Profession: str
        :param _SchoolOfGraduation: 人物毕业院校。
        :type SchoolOfGraduation: str
        :param _Abstract: 人物简介。
        :type Abstract: str
        :param _PlaceOfBirth: 人物出生地或者籍贯。
        :type PlaceOfBirth: str
        :param _PersonType: 人物类型：
<li>Politician：官员；</li>
<li>Artist：艺人。</li>
        :type PersonType: str
        :param _Remark: 敏感度标注：
<li>Normal：正常；</li>
<li>Sensitive：敏感。</li>
        :type Remark: str
        :param _Url: 截图链接
        :type Url: str
        """
        self._Id = None
        self._Type = None
        self._Name = None
        self._SegmentSet = None
        self._Gender = None
        self._Birthday = None
        self._Profession = None
        self._SchoolOfGraduation = None
        self._Abstract = None
        self._PlaceOfBirth = None
        self._PersonType = None
        self._Remark = None
        self._Url = None

    @property
    def Id(self):
        r"""人物唯一标识 ID。
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Type(self):
        r"""人物库类型，表示识别出的人物来自哪个人物库：
<li>Default：默认人物库；</li>
<li>UserDefine：用户自定义人物库。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        r"""人物名称。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SegmentSet(self):
        r"""人物出现的片段结果集。
        :rtype: list of AiRecognitionTaskFaceSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def Gender(self):
        r"""人物性别：
<li>Male：男性；</li>
<li>Female：女性。</li>
        :rtype: str
        """
        return self._Gender

    @Gender.setter
    def Gender(self, Gender):
        self._Gender = Gender

    @property
    def Birthday(self):
        r"""人物出生日期。
        :rtype: str
        """
        return self._Birthday

    @Birthday.setter
    def Birthday(self, Birthday):
        self._Birthday = Birthday

    @property
    def Profession(self):
        r"""人物职业或者职务。
        :rtype: str
        """
        return self._Profession

    @Profession.setter
    def Profession(self, Profession):
        self._Profession = Profession

    @property
    def SchoolOfGraduation(self):
        r"""人物毕业院校。
        :rtype: str
        """
        return self._SchoolOfGraduation

    @SchoolOfGraduation.setter
    def SchoolOfGraduation(self, SchoolOfGraduation):
        self._SchoolOfGraduation = SchoolOfGraduation

    @property
    def Abstract(self):
        r"""人物简介。
        :rtype: str
        """
        return self._Abstract

    @Abstract.setter
    def Abstract(self, Abstract):
        self._Abstract = Abstract

    @property
    def PlaceOfBirth(self):
        r"""人物出生地或者籍贯。
        :rtype: str
        """
        return self._PlaceOfBirth

    @PlaceOfBirth.setter
    def PlaceOfBirth(self, PlaceOfBirth):
        self._PlaceOfBirth = PlaceOfBirth

    @property
    def PersonType(self):
        r"""人物类型：
<li>Politician：官员；</li>
<li>Artist：艺人。</li>
        :rtype: str
        """
        return self._PersonType

    @PersonType.setter
    def PersonType(self, PersonType):
        self._PersonType = PersonType

    @property
    def Remark(self):
        r"""敏感度标注：
<li>Normal：正常；</li>
<li>Sensitive：敏感。</li>
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def Url(self):
        r"""截图链接
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskFaceSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._Gender = params.get("Gender")
        self._Birthday = params.get("Birthday")
        self._Profession = params.get("Profession")
        self._SchoolOfGraduation = params.get("SchoolOfGraduation")
        self._Abstract = params.get("Abstract")
        self._PlaceOfBirth = params.get("PlaceOfBirth")
        self._PersonType = params.get("PersonType")
        self._Remark = params.get("Remark")
        self._Url = params.get("Url")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskFaceResultOutput(AbstractModel):
    r"""智能人脸识别输出。

    """

    def __init__(self):
        r"""
        :param _ResultSet: 智能人脸识别结果集。
        :type ResultSet: list of AiRecognitionTaskFaceResultItem
        """
        self._ResultSet = None

    @property
    def ResultSet(self):
        r"""智能人脸识别结果集。
        :rtype: list of AiRecognitionTaskFaceResultItem
        """
        return self._ResultSet

    @ResultSet.setter
    def ResultSet(self, ResultSet):
        self._ResultSet = ResultSet


    def _deserialize(self, params):
        if params.get("ResultSet") is not None:
            self._ResultSet = []
            for item in params.get("ResultSet"):
                obj = AiRecognitionTaskFaceResultItem()
                obj._deserialize(item)
                self._ResultSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskFaceSegmentItem(AbstractModel):
    r"""人脸识别结果片段

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: 识别片段起始的偏移时间，单位：秒。
        :type StartTimeOffset: float
        :param _EndTimeOffset: 识别片段终止的偏移时间，单位：秒。
        :type EndTimeOffset: float
        :param _Confidence: 识别片段置信度。取值：0~100。
        :type Confidence: float
        :param _AreaCoordSet: 识别结果的区域坐标。数组包含 4 个元素 [x1,y1,x2,y2]，依次表示区域左上点、右下点的横纵坐标。
        :type AreaCoordSet: list of int
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Confidence = None
        self._AreaCoordSet = None

    @property
    def StartTimeOffset(self):
        r"""识别片段起始的偏移时间，单位：秒。
        :rtype: float
        """
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        r"""识别片段终止的偏移时间，单位：秒。
        :rtype: float
        """
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Confidence(self):
        r"""识别片段置信度。取值：0~100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def AreaCoordSet(self):
        r"""识别结果的区域坐标。数组包含 4 个元素 [x1,y1,x2,y2]，依次表示区域左上点、右下点的横纵坐标。
        :rtype: list of int
        """
        return self._AreaCoordSet

    @AreaCoordSet.setter
    def AreaCoordSet(self, AreaCoordSet):
        self._AreaCoordSet = AreaCoordSet


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Confidence = params.get("Confidence")
        self._AreaCoordSet = params.get("AreaCoordSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskInput(AbstractModel):
    r"""视频内容识别输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 视频智能识别模板 ID 。
        :type Definition: int
        :param _UserExtPara: 用户扩展字段，一般场景不用填。
        :type UserExtPara: str
        """
        self._Definition = None
        self._UserExtPara = None

    @property
    def Definition(self):
        r"""视频智能识别模板 ID 。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def UserExtPara(self):
        r"""用户扩展字段，一般场景不用填。
        :rtype: str
        """
        return self._UserExtPara

    @UserExtPara.setter
    def UserExtPara(self, UserExtPara):
        self._UserExtPara = UserExtPara


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._UserExtPara = params.get("UserExtPara")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskObjectResult(AbstractModel):
    r"""物体识别结果。

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCode: 错误码，0：成功，其他值：失败。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 物体识别任务输入信息。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskObjectResultInput`
        :param _Output: 物体识别任务输出信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskObjectResultOutput`
        """
        self._Status = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        r"""错误码，0：成功，其他值：失败。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""物体识别任务输入信息。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskObjectResultInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""物体识别任务输出信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskObjectResultOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskObjectResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskObjectResultOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskObjectResultInput(AbstractModel):
    r"""物体识别任务输入类型。

    """

    def __init__(self):
        r"""
        :param _Definition: 物体识别模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""物体识别模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskObjectResultItem(AbstractModel):
    r"""单个物体识别结果。

    """

    def __init__(self):
        r"""
        :param _Name: 识别的物体名称。
        :type Name: str
        :param _SegmentSet: 物体出现的片段列表。
        :type SegmentSet: list of AiRecognitionTaskObjectSeqmentItem
        """
        self._Name = None
        self._SegmentSet = None

    @property
    def Name(self):
        r"""识别的物体名称。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SegmentSet(self):
        r"""物体出现的片段列表。
        :rtype: list of AiRecognitionTaskObjectSeqmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Name = params.get("Name")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskObjectSeqmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskObjectResultOutput(AbstractModel):
    r"""智能物体识别输出。

    """

    def __init__(self):
        r"""
        :param _ResultSet: 智能物体识别结果集。
        :type ResultSet: list of AiRecognitionTaskObjectResultItem
        """
        self._ResultSet = None

    @property
    def ResultSet(self):
        r"""智能物体识别结果集。
        :rtype: list of AiRecognitionTaskObjectResultItem
        """
        return self._ResultSet

    @ResultSet.setter
    def ResultSet(self, ResultSet):
        self._ResultSet = ResultSet


    def _deserialize(self, params):
        if params.get("ResultSet") is not None:
            self._ResultSet = []
            for item in params.get("ResultSet"):
                obj = AiRecognitionTaskObjectResultItem()
                obj._deserialize(item)
                self._ResultSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskObjectSeqmentItem(AbstractModel):
    r"""物体识别结果片段。

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: 识别片段起始的偏移时间，单位：秒。
        :type StartTimeOffset: float
        :param _EndTimeOffset: 识别片段终止的偏移时间，单位：秒。
        :type EndTimeOffset: float
        :param _Confidence: 识别片段置信度。取值：0~100。
        :type Confidence: float
        :param _AreaCoordSet: 识别结果的区域坐标。数组包含 4 个元素 [x1,y1,x2,y2]，依次表示区域左上点、右下点的横纵坐标。
        :type AreaCoordSet: list of int
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Confidence = None
        self._AreaCoordSet = None

    @property
    def StartTimeOffset(self):
        r"""识别片段起始的偏移时间，单位：秒。
        :rtype: float
        """
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        r"""识别片段终止的偏移时间，单位：秒。
        :rtype: float
        """
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Confidence(self):
        r"""识别片段置信度。取值：0~100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def AreaCoordSet(self):
        r"""识别结果的区域坐标。数组包含 4 个元素 [x1,y1,x2,y2]，依次表示区域左上点、右下点的横纵坐标。
        :rtype: list of int
        """
        return self._AreaCoordSet

    @AreaCoordSet.setter
    def AreaCoordSet(self, AreaCoordSet):
        self._AreaCoordSet = AreaCoordSet


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Confidence = params.get("Confidence")
        self._AreaCoordSet = params.get("AreaCoordSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrFullTextResult(AbstractModel):
    r"""文本全文识别结果。

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 文本全文识别任务输入信息。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskOcrFullTextResultInput`
        :param _Output: 文本全文识别任务输出信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskOcrFullTextResultOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""文本全文识别任务输入信息。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskOcrFullTextResultInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""文本全文识别任务输出信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskOcrFullTextResultOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskOcrFullTextResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskOcrFullTextResultOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrFullTextResultInput(AbstractModel):
    r"""文本全文识别输入。

    """

    def __init__(self):
        r"""
        :param _Definition: 文本全文识别模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""文本全文识别模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrFullTextResultOutput(AbstractModel):
    r"""文本全文识别输出。

    """

    def __init__(self):
        r"""
        :param _SegmentSet: 文本全文识别结果集。
        :type SegmentSet: list of AiRecognitionTaskOcrFullTextSegmentItem
        """
        self._SegmentSet = None

    @property
    def SegmentSet(self):
        r"""文本全文识别结果集。
        :rtype: list of AiRecognitionTaskOcrFullTextSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskOcrFullTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrFullTextSegmentItem(AbstractModel):
    r"""文本全文识别片段。

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: 识别片段起始的偏移时间，单位：秒。
        :type StartTimeOffset: float
        :param _EndTimeOffset: 识别片段终止的偏移时间，单位：秒。
        :type EndTimeOffset: float
        :param _TextSet: 识别片段结果集。
        :type TextSet: list of AiRecognitionTaskOcrFullTextSegmentTextItem
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._TextSet = None

    @property
    def StartTimeOffset(self):
        r"""识别片段起始的偏移时间，单位：秒。
        :rtype: float
        """
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        r"""识别片段终止的偏移时间，单位：秒。
        :rtype: float
        """
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def TextSet(self):
        r"""识别片段结果集。
        :rtype: list of AiRecognitionTaskOcrFullTextSegmentTextItem
        """
        return self._TextSet

    @TextSet.setter
    def TextSet(self, TextSet):
        self._TextSet = TextSet


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        if params.get("TextSet") is not None:
            self._TextSet = []
            for item in params.get("TextSet"):
                obj = AiRecognitionTaskOcrFullTextSegmentTextItem()
                obj._deserialize(item)
                self._TextSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrFullTextSegmentTextItem(AbstractModel):
    r"""文本全文识别片段。

    """

    def __init__(self):
        r"""
        :param _Confidence: 识别片段置信度。取值：0~100。
        :type Confidence: float
        :param _AreaCoordSet: 识别结果的区域坐标。数组包含 4 个元素 [x1,y1,x2,y2]，依次表示区域左上点、右下点的横纵坐标。
        :type AreaCoordSet: list of int
        :param _Text: 识别文本。
        :type Text: str
        """
        self._Confidence = None
        self._AreaCoordSet = None
        self._Text = None

    @property
    def Confidence(self):
        r"""识别片段置信度。取值：0~100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def AreaCoordSet(self):
        r"""识别结果的区域坐标。数组包含 4 个元素 [x1,y1,x2,y2]，依次表示区域左上点、右下点的横纵坐标。
        :rtype: list of int
        """
        return self._AreaCoordSet

    @AreaCoordSet.setter
    def AreaCoordSet(self, AreaCoordSet):
        self._AreaCoordSet = AreaCoordSet

    @property
    def Text(self):
        r"""识别文本。
        :rtype: str
        """
        return self._Text

    @Text.setter
    def Text(self, Text):
        self._Text = Text


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._AreaCoordSet = params.get("AreaCoordSet")
        self._Text = params.get("Text")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrWordsResult(AbstractModel):
    r"""文本关键识别结果。

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 文本关键词识别任务输入信息。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskOcrWordsResultInput`
        :param _Output: 文本关键词识别任务输出信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskOcrWordsResultOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""文本关键词识别任务输入信息。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskOcrWordsResultInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""文本关键词识别任务输出信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskOcrWordsResultOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskOcrWordsResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskOcrWordsResultOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrWordsResultInput(AbstractModel):
    r"""文本关键词识别输入。

    """

    def __init__(self):
        r"""
        :param _Definition: 文本关键词识别模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""文本关键词识别模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrWordsResultItem(AbstractModel):
    r"""文本关键词识别结果。

    """

    def __init__(self):
        r"""
        :param _Word: 文本关键词。
        :type Word: str
        :param _SegmentSet: 文本关键出现的片段列表。
        :type SegmentSet: list of AiRecognitionTaskOcrWordsSegmentItem
        """
        self._Word = None
        self._SegmentSet = None

    @property
    def Word(self):
        r"""文本关键词。
        :rtype: str
        """
        return self._Word

    @Word.setter
    def Word(self, Word):
        self._Word = Word

    @property
    def SegmentSet(self):
        r"""文本关键出现的片段列表。
        :rtype: list of AiRecognitionTaskOcrWordsSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Word = params.get("Word")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskOcrWordsSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrWordsResultOutput(AbstractModel):
    r"""文本关键词识别输出。

    """

    def __init__(self):
        r"""
        :param _ResultSet: 文本关键词识别结果集。
        :type ResultSet: list of AiRecognitionTaskOcrWordsResultItem
        """
        self._ResultSet = None

    @property
    def ResultSet(self):
        r"""文本关键词识别结果集。
        :rtype: list of AiRecognitionTaskOcrWordsResultItem
        """
        return self._ResultSet

    @ResultSet.setter
    def ResultSet(self, ResultSet):
        self._ResultSet = ResultSet


    def _deserialize(self, params):
        if params.get("ResultSet") is not None:
            self._ResultSet = []
            for item in params.get("ResultSet"):
                obj = AiRecognitionTaskOcrWordsResultItem()
                obj._deserialize(item)
                self._ResultSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrWordsSegmentItem(AbstractModel):
    r"""文本识别片段。

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: 识别片段起始的偏移时间，单位：秒。
        :type StartTimeOffset: float
        :param _EndTimeOffset: 识别片段终止的偏移时间，单位：秒。
        :type EndTimeOffset: float
        :param _Confidence: 识别片段置信度。取值：0~100。
        :type Confidence: float
        :param _AreaCoordSet: 识别结果的区域坐标。数组包含 4 个元素 [x1,y1,x2,y2]，依次表示区域左上点、右下点的横纵坐标。
        :type AreaCoordSet: list of int
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Confidence = None
        self._AreaCoordSet = None

    @property
    def StartTimeOffset(self):
        r"""识别片段起始的偏移时间，单位：秒。
        :rtype: float
        """
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        r"""识别片段终止的偏移时间，单位：秒。
        :rtype: float
        """
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Confidence(self):
        r"""识别片段置信度。取值：0~100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def AreaCoordSet(self):
        r"""识别结果的区域坐标。数组包含 4 个元素 [x1,y1,x2,y2]，依次表示区域左上点、右下点的横纵坐标。
        :rtype: list of int
        """
        return self._AreaCoordSet

    @AreaCoordSet.setter
    def AreaCoordSet(self, AreaCoordSet):
        self._AreaCoordSet = AreaCoordSet


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Confidence = params.get("Confidence")
        self._AreaCoordSet = params.get("AreaCoordSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskTransTextResult(AbstractModel):
    r"""翻译结果。

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 翻译任务输入信息。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskTransTextResultInput`
        :param _Output: 翻译任务输出信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskTransTextResultOutput`
        :param _Progress: 任务进度。
注意：此字段可能返回 null，表示取不到有效值。
        :type Progress: int
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""翻译任务输入信息。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskTransTextResultInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""翻译任务输出信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskTransTextResultOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        r"""任务进度。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskTransTextResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskTransTextResultOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskTransTextResultInput(AbstractModel):
    r"""翻译的输入。

    """

    def __init__(self):
        r"""
        :param _Definition: 翻译模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""翻译模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskTransTextResultOutput(AbstractModel):
    r"""翻译结果。

    """

    def __init__(self):
        r"""
        :param _SegmentSet: 翻译片段列表。
        :type SegmentSet: list of AiRecognitionTaskTransTextSegmentItem
        :param _SubtitlePath: 字幕文件地址。
        :type SubtitlePath: str
        """
        self._SegmentSet = None
        self._SubtitlePath = None

    @property
    def SegmentSet(self):
        r"""翻译片段列表。
        :rtype: list of AiRecognitionTaskTransTextSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SubtitlePath(self):
        r"""字幕文件地址。
        :rtype: str
        """
        return self._SubtitlePath

    @SubtitlePath.setter
    def SubtitlePath(self, SubtitlePath):
        self._SubtitlePath = SubtitlePath


    def _deserialize(self, params):
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskTransTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SubtitlePath = params.get("SubtitlePath")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskTransTextSegmentItem(AbstractModel):
    r"""翻译片段。

    """

    def __init__(self):
        r"""
        :param _Confidence: 识别片段置信度。取值：0~100。
        :type Confidence: float
        :param _StartTimeOffset: 识别片段起始的偏移时间，单位：秒。
        :type StartTimeOffset: float
        :param _EndTimeOffset: 识别片段终止的偏移时间，单位：秒。
        :type EndTimeOffset: float
        :param _Text: 识别文本。
        :type Text: str
        :param _Trans: 翻译文本。
        :type Trans: str
        :param _Wordlist: 字词时间戳信息。
        :type Wordlist: list of WordResult
        """
        self._Confidence = None
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Text = None
        self._Trans = None
        self._Wordlist = None

    @property
    def Confidence(self):
        r"""识别片段置信度。取值：0~100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def StartTimeOffset(self):
        r"""识别片段起始的偏移时间，单位：秒。
        :rtype: float
        """
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        r"""识别片段终止的偏移时间，单位：秒。
        :rtype: float
        """
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Text(self):
        r"""识别文本。
        :rtype: str
        """
        return self._Text

    @Text.setter
    def Text(self, Text):
        self._Text = Text

    @property
    def Trans(self):
        r"""翻译文本。
        :rtype: str
        """
        return self._Trans

    @Trans.setter
    def Trans(self, Trans):
        self._Trans = Trans

    @property
    def Wordlist(self):
        r"""字词时间戳信息。
        :rtype: list of WordResult
        """
        return self._Wordlist

    @Wordlist.setter
    def Wordlist(self, Wordlist):
        self._Wordlist = Wordlist


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Text = params.get("Text")
        self._Trans = params.get("Trans")
        if params.get("Wordlist") is not None:
            self._Wordlist = []
            for item in params.get("Wordlist"):
                obj = WordResult()
                obj._deserialize(item)
                self._Wordlist.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPoliticalAsrTaskInput(AbstractModel):
    r"""内容审核 Asr 文字敏感任务输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPoliticalAsrTaskOutput(AbstractModel):
    r"""Asr 文字敏感信息

    """

    def __init__(self):
        r"""
        :param _Confidence: Asr 文字敏感评分，分值为0到100。
        :type Confidence: float
        :param _Suggestion: Asr 文字敏感结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :type Suggestion: str
        :param _SegmentSet: Asr 文字敏感嫌疑的视频片段列表。
        :type SegmentSet: list of MediaContentReviewAsrTextSegmentItem
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None

    @property
    def Confidence(self):
        r"""Asr 文字敏感评分，分值为0到100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        r"""Asr 文字敏感结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :rtype: str
        """
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        r"""Asr 文字敏感嫌疑的视频片段列表。
        :rtype: list of MediaContentReviewAsrTextSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewAsrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPoliticalOcrTaskInput(AbstractModel):
    r"""内容审核 Ocr 文字敏感任务输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPoliticalOcrTaskOutput(AbstractModel):
    r"""Ocr 文字敏感信息

    """

    def __init__(self):
        r"""
        :param _Confidence: Ocr 文字敏感评分，分值为0到100。
        :type Confidence: float
        :param _Suggestion: Ocr 文字敏感结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :type Suggestion: str
        :param _SegmentSet: Ocr 文字有敏感嫌疑的视频片段列表。
        :type SegmentSet: list of MediaContentReviewOcrTextSegmentItem
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None

    @property
    def Confidence(self):
        r"""Ocr 文字敏感评分，分值为0到100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        r"""Ocr 文字敏感结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :rtype: str
        """
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        r"""Ocr 文字有敏感嫌疑的视频片段列表。
        :rtype: list of MediaContentReviewOcrTextSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewOcrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPoliticalTaskInput(AbstractModel):
    r"""内容审核敏感任务输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPoliticalTaskOutput(AbstractModel):
    r"""涉敏信息

    """

    def __init__(self):
        r"""
        :param _Confidence: 视频涉敏评分，分值为0到100。
        :type Confidence: float
        :param _Suggestion: 涉敏结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :type Suggestion: str
        :param _Label: 视频涉敏结果标签。内容审核模板[画面涉敏任务控制参数](https://cloud.tencent.com/document/api/862/37615#AiReviewPoliticalTaskOutput)里 LabelSet 参数与此参数取值范围的对应关系：
violation_photo：
<li>violation_photo：违规图标。</li>
其他（即 politician/entertainment/sport/entrepreneur/scholar/celebrity/military）：
<li>politician：涉敏人物。</li>
        :type Label: str
        :param _SegmentSet: 有涉敏嫌疑的视频片段列表。
        :type SegmentSet: list of MediaContentReviewPoliticalSegmentItem
        """
        self._Confidence = None
        self._Suggestion = None
        self._Label = None
        self._SegmentSet = None

    @property
    def Confidence(self):
        r"""视频涉敏评分，分值为0到100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        r"""涉敏结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :rtype: str
        """
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def Label(self):
        r"""视频涉敏结果标签。内容审核模板[画面涉敏任务控制参数](https://cloud.tencent.com/document/api/862/37615#AiReviewPoliticalTaskOutput)里 LabelSet 参数与此参数取值范围的对应关系：
violation_photo：
<li>violation_photo：违规图标。</li>
其他（即 politician/entertainment/sport/entrepreneur/scholar/celebrity/military）：
<li>politician：涉敏人物。</li>
        :rtype: str
        """
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label

    @property
    def SegmentSet(self):
        r"""有涉敏嫌疑的视频片段列表。
        :rtype: list of MediaContentReviewPoliticalSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        self._Label = params.get("Label")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewPoliticalSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPornAsrTaskInput(AbstractModel):
    r"""内容审核 Asr 文字鉴黄任务输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 鉴黄模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""鉴黄模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPornAsrTaskOutput(AbstractModel):
    r"""Asr 文字涉黄信息

    """

    def __init__(self):
        r"""
        :param _Confidence: Asr 文字涉黄评分，分值为0到100。
        :type Confidence: float
        :param _Suggestion: Asr 文字涉黄结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :type Suggestion: str
        :param _SegmentSet: Asr 文字有涉黄嫌疑的视频片段列表。
        :type SegmentSet: list of MediaContentReviewAsrTextSegmentItem
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None

    @property
    def Confidence(self):
        r"""Asr 文字涉黄评分，分值为0到100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        r"""Asr 文字涉黄结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :rtype: str
        """
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        r"""Asr 文字有涉黄嫌疑的视频片段列表。
        :rtype: list of MediaContentReviewAsrTextSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewAsrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPornOcrTaskInput(AbstractModel):
    r"""内容审核 Ocr 文字鉴黄任务输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 鉴黄模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""鉴黄模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPornOcrTaskOutput(AbstractModel):
    r"""Ocr 文字涉黄信息

    """

    def __init__(self):
        r"""
        :param _Confidence: Ocr 文字涉黄评分，分值为0到100。
        :type Confidence: float
        :param _Suggestion: Ocr 文字涉黄结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :type Suggestion: str
        :param _SegmentSet: Ocr 文字有涉黄嫌疑的视频片段列表。
        :type SegmentSet: list of MediaContentReviewOcrTextSegmentItem
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None

    @property
    def Confidence(self):
        r"""Ocr 文字涉黄评分，分值为0到100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        r"""Ocr 文字涉黄结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :rtype: str
        """
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        r"""Ocr 文字有涉黄嫌疑的视频片段列表。
        :rtype: list of MediaContentReviewOcrTextSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewOcrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPornTaskInput(AbstractModel):
    r"""内容审核鉴黄任务输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 鉴黄模板 ID。
注意：此字段可能返回 null，表示取不到有效值。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""鉴黄模板 ID。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPornTaskOutput(AbstractModel):
    r"""鉴黄结果信息

    """

    def __init__(self):
        r"""
        :param _Confidence: 视频鉴黄评分，分值为0到100。
        :type Confidence: float
        :param _Suggestion: 鉴黄结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :type Suggestion: str
        :param _Label: 视频鉴黄结果标签，取值范围：
<li>porn：色情。</li>
<li>sexy：性感。</li>
<li>vulgar：低俗。</li>
<li>intimacy：亲密行为。</li>
        :type Label: str
        :param _SegmentSet: 有涉黄嫌疑的视频片段列表。
        :type SegmentSet: list of MediaContentReviewSegmentItem
        """
        self._Confidence = None
        self._Suggestion = None
        self._Label = None
        self._SegmentSet = None

    @property
    def Confidence(self):
        r"""视频鉴黄评分，分值为0到100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        r"""鉴黄结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :rtype: str
        """
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def Label(self):
        r"""视频鉴黄结果标签，取值范围：
<li>porn：色情。</li>
<li>sexy：性感。</li>
<li>vulgar：低俗。</li>
<li>intimacy：亲密行为。</li>
        :rtype: str
        """
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label

    @property
    def SegmentSet(self):
        r"""有涉黄嫌疑的视频片段列表。
        :rtype: list of MediaContentReviewSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        self._Label = params.get("Label")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewProhibitedAsrTaskInput(AbstractModel):
    r"""内容审核 Asr 文字鉴违禁任务输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 鉴违禁模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""鉴违禁模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewProhibitedAsrTaskOutput(AbstractModel):
    r"""Asr 文字涉违禁信息

    """

    def __init__(self):
        r"""
        :param _Confidence: Asr 文字涉违禁评分，分值为0到100。
        :type Confidence: float
        :param _Suggestion: Asr 文字涉违禁结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :type Suggestion: str
        :param _SegmentSet: Asr 文字有涉违禁嫌疑的视频片段列表。
        :type SegmentSet: list of MediaContentReviewAsrTextSegmentItem
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None

    @property
    def Confidence(self):
        r"""Asr 文字涉违禁评分，分值为0到100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        r"""Asr 文字涉违禁结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :rtype: str
        """
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        r"""Asr 文字有涉违禁嫌疑的视频片段列表。
        :rtype: list of MediaContentReviewAsrTextSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewAsrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewProhibitedOcrTaskInput(AbstractModel):
    r"""内容审核 Ocr 文字鉴违禁任务输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 鉴违禁模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""鉴违禁模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewProhibitedOcrTaskOutput(AbstractModel):
    r"""Ocr 文字涉违禁信息

    """

    def __init__(self):
        r"""
        :param _Confidence: Ocr 文字涉违禁评分，分值为0到100。
        :type Confidence: float
        :param _Suggestion: Ocr 文字涉违禁结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :type Suggestion: str
        :param _SegmentSet: Ocr 文字有涉违禁嫌疑的视频片段列表。
        :type SegmentSet: list of MediaContentReviewOcrTextSegmentItem
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None

    @property
    def Confidence(self):
        r"""Ocr 文字涉违禁评分，分值为0到100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        r"""Ocr 文字涉违禁结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :rtype: str
        """
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        r"""Ocr 文字有涉违禁嫌疑的视频片段列表。
        :rtype: list of MediaContentReviewOcrTextSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewOcrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskPoliticalAsrResult(AbstractModel):
    r"""内容审核 Asr 文字敏感任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 内容审核 Asr 文字敏感任务输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiReviewPoliticalAsrTaskInput`
        :param _Output: 内容审核 Asr 文字敏感任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiReviewPoliticalAsrTaskOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""内容审核 Asr 文字敏感任务输入。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewPoliticalAsrTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""内容审核 Asr 文字敏感任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewPoliticalAsrTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewPoliticalAsrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewPoliticalAsrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskPoliticalOcrResult(AbstractModel):
    r"""内容审核 Ocr 文字敏感任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS，FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 内容审核 Ocr 文字敏感任务输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiReviewPoliticalOcrTaskInput`
        :param _Output: 内容审核 Ocr 文字敏感任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiReviewPoliticalOcrTaskOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS，FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""内容审核 Ocr 文字敏感任务输入。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewPoliticalOcrTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""内容审核 Ocr 文字敏感任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewPoliticalOcrTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewPoliticalOcrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewPoliticalOcrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskPoliticalResult(AbstractModel):
    r"""内容审核涉敏任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 内容审核涉敏任务输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiReviewPoliticalTaskInput`
        :param _Output: 内容审核涉敏任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiReviewPoliticalTaskOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""内容审核涉敏任务输入。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewPoliticalTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""内容审核涉敏任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewPoliticalTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewPoliticalTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewPoliticalTaskOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskPornAsrResult(AbstractModel):
    r"""内容审核 Asr 文字鉴黄任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 内容审核 Asr 文字鉴黄任务输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiReviewPornAsrTaskInput`
        :param _Output: 内容审核 Asr 文字鉴黄任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiReviewPornAsrTaskOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""内容审核 Asr 文字鉴黄任务输入。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewPornAsrTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""内容审核 Asr 文字鉴黄任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewPornAsrTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewPornAsrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewPornAsrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskPornOcrResult(AbstractModel):
    r"""内容审核 Ocr 文字鉴黄任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 内容审核 Ocr 文字鉴黄任务输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiReviewPornOcrTaskInput`
        :param _Output: 内容审核 Ocr 文字鉴黄任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiReviewPornOcrTaskOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""内容审核 Ocr 文字鉴黄任务输入。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewPornOcrTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""内容审核 Ocr 文字鉴黄任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewPornOcrTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewPornOcrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewPornOcrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskPornResult(AbstractModel):
    r"""内容审核鉴黄任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 内容审核鉴黄任务输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiReviewPornTaskInput`
        :param _Output: 内容审核鉴黄任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiReviewPornTaskOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""内容审核鉴黄任务输入。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewPornTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""内容审核鉴黄任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewPornTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewPornTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewPornTaskOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskProhibitedAsrResult(AbstractModel):
    r"""内容审核 Asr 文字鉴任违禁务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 内容审核 Asr 文字鉴违禁任务输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiReviewProhibitedAsrTaskInput`
        :param _Output: 内容审核 Asr 文字鉴违禁任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiReviewProhibitedAsrTaskOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""内容审核 Asr 文字鉴违禁任务输入。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewProhibitedAsrTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""内容审核 Asr 文字鉴违禁任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewProhibitedAsrTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewProhibitedAsrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewProhibitedAsrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskProhibitedOcrResult(AbstractModel):
    r"""内容审核 Ocr 文字鉴任违禁务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 内容审核 Ocr 文字鉴违禁任务输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiReviewProhibitedOcrTaskInput`
        :param _Output: 内容审核 Ocr 文字鉴违禁任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiReviewProhibitedOcrTaskOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""内容审核 Ocr 文字鉴违禁任务输入。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewProhibitedOcrTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""内容审核 Ocr 文字鉴违禁任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewProhibitedOcrTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewProhibitedOcrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewProhibitedOcrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskTerrorismOcrResult(AbstractModel):
    r"""内容审核 Ocr 文字敏感任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 内容审核 Ocr 文字敏感任务输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiReviewTerrorismOcrTaskInput`
        :param _Output: 内容审核 Ocr 文字敏感任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiReviewTerrorismOcrTaskOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""内容审核 Ocr 文字敏感任务输入。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewTerrorismOcrTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""内容审核 Ocr 文字敏感任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewTerrorismOcrTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewTerrorismOcrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewTerrorismOcrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskTerrorismResult(AbstractModel):
    r"""内容审核涉敏任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 内容审核涉敏任务输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiReviewTerrorismTaskInput`
        :param _Output: 内容审核涉敏任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiReviewTerrorismTaskOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""内容审核涉敏任务输入。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewTerrorismTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""内容审核涉敏任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewTerrorismTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewTerrorismTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewTerrorismTaskOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTerrorismOcrTaskInput(AbstractModel):
    r"""内容审核 Ocr 文字敏感任务输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTerrorismOcrTaskOutput(AbstractModel):
    r"""Ocr 文字涉敏信息

    """

    def __init__(self):
        r"""
        :param _Confidence: Ocr 文字涉敏评分，分值为0到100。
        :type Confidence: float
        :param _Suggestion: Ocr 文字涉敏结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :type Suggestion: str
        :param _SegmentSet: Ocr 文字有涉敏嫌疑的视频片段列表。
        :type SegmentSet: list of MediaContentReviewOcrTextSegmentItem
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None

    @property
    def Confidence(self):
        r"""Ocr 文字涉敏评分，分值为0到100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        r"""Ocr 文字涉敏结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :rtype: str
        """
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        r"""Ocr 文字有涉敏嫌疑的视频片段列表。
        :rtype: list of MediaContentReviewOcrTextSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewOcrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTerrorismTaskInput(AbstractModel):
    r"""内容审核涉敏任务输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTerrorismTaskOutput(AbstractModel):
    r"""涉敏信息

    """

    def __init__(self):
        r"""
        :param _Confidence: 视频涉敏评分，分值为0到100。
        :type Confidence: float
        :param _Suggestion: 涉敏结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :type Suggestion: str
        :param _Label: 视频涉敏结果标签，取值范围：
<li>guns：武器枪支。</li>
<li>crowd：人群聚集。</li>
<li>police：警察部队。</li>
<li>bloody：血腥画面。</li>
<li>banners：涉敏旗帜。</li>
<li>militant：武装分子。</li>
<li>explosion：爆炸火灾。</li>
<li>terrorists：涉敏人物。</li>
<li>scenario：涉敏画面。</li>
        :type Label: str
        :param _SegmentSet: 有涉敏嫌疑的视频片段列表。
        :type SegmentSet: list of MediaContentReviewSegmentItem
        """
        self._Confidence = None
        self._Suggestion = None
        self._Label = None
        self._SegmentSet = None

    @property
    def Confidence(self):
        r"""视频涉敏评分，分值为0到100。
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        r"""涉敏结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :rtype: str
        """
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def Label(self):
        r"""视频涉敏结果标签，取值范围：
<li>guns：武器枪支。</li>
<li>crowd：人群聚集。</li>
<li>police：警察部队。</li>
<li>bloody：血腥画面。</li>
<li>banners：涉敏旗帜。</li>
<li>militant：武装分子。</li>
<li>explosion：爆炸火灾。</li>
<li>terrorists：涉敏人物。</li>
<li>scenario：涉敏画面。</li>
        :rtype: str
        """
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label

    @property
    def SegmentSet(self):
        r"""有涉敏嫌疑的视频片段列表。
        :rtype: list of MediaContentReviewSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        self._Label = params.get("Label")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSampleFaceInfo(AbstractModel):
    r"""AI 样本管理，人脸信息。

    """

    def __init__(self):
        r"""
        :param _FaceId: 人脸图片 ID。
        :type FaceId: str
        :param _Url: 人脸图片地址。
        :type Url: str
        """
        self._FaceId = None
        self._Url = None

    @property
    def FaceId(self):
        r"""人脸图片 ID。
        :rtype: str
        """
        return self._FaceId

    @FaceId.setter
    def FaceId(self, FaceId):
        self._FaceId = FaceId

    @property
    def Url(self):
        r"""人脸图片地址。
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url


    def _deserialize(self, params):
        self._FaceId = params.get("FaceId")
        self._Url = params.get("Url")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSampleFaceOperation(AbstractModel):
    r"""AI 样本管理，人脸数据操作。

    """

    def __init__(self):
        r"""
        :param _Type: 操作类型，可选值：add（添加）、delete（删除）、reset（重置）。重置操作将清空该人物已有人脸数据，并添加 FaceContents 指定人脸数据。
        :type Type: str
        :param _FaceIds: 人脸 ID 集合，当 Type为delete 时，该字段必填。
        :type FaceIds: list of str
        :param _FaceContents: 人脸图片 [Base64](https://tools.ietf.org/html/rfc4648) 编码后的字符串集合。
<li>当 Type为add 或 reset 时，该字段必填；</li>
<li>数组长度限制：5 张图片。</li>
注意：图片必须是单人像正面人脸较清晰的照片，像素不低于 200*200。
        :type FaceContents: list of str
        """
        self._Type = None
        self._FaceIds = None
        self._FaceContents = None

    @property
    def Type(self):
        r"""操作类型，可选值：add（添加）、delete（删除）、reset（重置）。重置操作将清空该人物已有人脸数据，并添加 FaceContents 指定人脸数据。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def FaceIds(self):
        r"""人脸 ID 集合，当 Type为delete 时，该字段必填。
        :rtype: list of str
        """
        return self._FaceIds

    @FaceIds.setter
    def FaceIds(self, FaceIds):
        self._FaceIds = FaceIds

    @property
    def FaceContents(self):
        r"""人脸图片 [Base64](https://tools.ietf.org/html/rfc4648) 编码后的字符串集合。
<li>当 Type为add 或 reset 时，该字段必填；</li>
<li>数组长度限制：5 张图片。</li>
注意：图片必须是单人像正面人脸较清晰的照片，像素不低于 200*200。
        :rtype: list of str
        """
        return self._FaceContents

    @FaceContents.setter
    def FaceContents(self, FaceContents):
        self._FaceContents = FaceContents


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._FaceIds = params.get("FaceIds")
        self._FaceContents = params.get("FaceContents")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSampleFailFaceInfo(AbstractModel):
    r"""AI 样本管理，处理失败的人脸信息

    """

    def __init__(self):
        r"""
        :param _Index: 对应入参 FaceContents 中错误图片下标，从 0 开始。
        :type Index: int
        :param _ErrCode: 错误码，取值：
<li>0：成功；</li>
<li>其他：失败。</li>
        :type ErrCode: int
        :param _Message: 错误描述。
        :type Message: str
        """
        self._Index = None
        self._ErrCode = None
        self._Message = None

    @property
    def Index(self):
        r"""对应入参 FaceContents 中错误图片下标，从 0 开始。
        :rtype: int
        """
        return self._Index

    @Index.setter
    def Index(self, Index):
        self._Index = Index

    @property
    def ErrCode(self):
        r"""错误码，取值：
<li>0：成功；</li>
<li>其他：失败。</li>
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""错误描述。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message


    def _deserialize(self, params):
        self._Index = params.get("Index")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSamplePerson(AbstractModel):
    r"""AI 样本管理，人物信息。

    """

    def __init__(self):
        r"""
        :param _PersonId: 人物 ID。
        :type PersonId: str
        :param _Name: 人物名称。
        :type Name: str
        :param _Description: 人物描述。
        :type Description: str
        :param _FaceInfoSet: 人脸信息。
        :type FaceInfoSet: list of AiSampleFaceInfo
        :param _TagSet: 人物标签。
        :type TagSet: list of str
        :param _UsageSet: 应用场景。
        :type UsageSet: list of str
        :param _CreateTime: 创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :type CreateTime: str
        :param _UpdateTime: 最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :type UpdateTime: str
        """
        self._PersonId = None
        self._Name = None
        self._Description = None
        self._FaceInfoSet = None
        self._TagSet = None
        self._UsageSet = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def PersonId(self):
        r"""人物 ID。
        :rtype: str
        """
        return self._PersonId

    @PersonId.setter
    def PersonId(self, PersonId):
        self._PersonId = PersonId

    @property
    def Name(self):
        r"""人物名称。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Description(self):
        r"""人物描述。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def FaceInfoSet(self):
        r"""人脸信息。
        :rtype: list of AiSampleFaceInfo
        """
        return self._FaceInfoSet

    @FaceInfoSet.setter
    def FaceInfoSet(self, FaceInfoSet):
        self._FaceInfoSet = FaceInfoSet

    @property
    def TagSet(self):
        r"""人物标签。
        :rtype: list of str
        """
        return self._TagSet

    @TagSet.setter
    def TagSet(self, TagSet):
        self._TagSet = TagSet

    @property
    def UsageSet(self):
        r"""应用场景。
        :rtype: list of str
        """
        return self._UsageSet

    @UsageSet.setter
    def UsageSet(self, UsageSet):
        self._UsageSet = UsageSet

    @property
    def CreateTime(self):
        r"""创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._PersonId = params.get("PersonId")
        self._Name = params.get("Name")
        self._Description = params.get("Description")
        if params.get("FaceInfoSet") is not None:
            self._FaceInfoSet = []
            for item in params.get("FaceInfoSet"):
                obj = AiSampleFaceInfo()
                obj._deserialize(item)
                self._FaceInfoSet.append(obj)
        self._TagSet = params.get("TagSet")
        self._UsageSet = params.get("UsageSet")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSampleTagOperation(AbstractModel):
    r"""AI 样本管理，标签操作。

    """

    def __init__(self):
        r"""
        :param _Type: 操作类型，可选值：add（添加）、delete（删除）、reset（重置）。
        :type Type: str
        :param _Tags: 标签，长度限制：128 个字符。
        :type Tags: list of str
        """
        self._Type = None
        self._Tags = None

    @property
    def Type(self):
        r"""操作类型，可选值：add（添加）、delete（删除）、reset（重置）。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Tags(self):
        r"""标签，长度限制：128 个字符。
        :rtype: list of str
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Tags = params.get("Tags")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSampleWord(AbstractModel):
    r"""AI 样本管理，关键词输出信息。

    """

    def __init__(self):
        r"""
        :param _Keyword: 关键词。
        :type Keyword: str
        :param _TagSet: 关键词标签。
        :type TagSet: list of str
        :param _UsageSet: 关键词应用场景。
        :type UsageSet: list of str
        :param _CreateTime: 创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :type CreateTime: str
        :param _UpdateTime: 最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :type UpdateTime: str
        """
        self._Keyword = None
        self._TagSet = None
        self._UsageSet = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def Keyword(self):
        r"""关键词。
        :rtype: str
        """
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword

    @property
    def TagSet(self):
        r"""关键词标签。
        :rtype: list of str
        """
        return self._TagSet

    @TagSet.setter
    def TagSet(self, TagSet):
        self._TagSet = TagSet

    @property
    def UsageSet(self):
        r"""关键词应用场景。
        :rtype: list of str
        """
        return self._UsageSet

    @UsageSet.setter
    def UsageSet(self, UsageSet):
        self._UsageSet = UsageSet

    @property
    def CreateTime(self):
        r"""创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._Keyword = params.get("Keyword")
        self._TagSet = params.get("TagSet")
        self._UsageSet = params.get("UsageSet")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSampleWordInfo(AbstractModel):
    r"""AI 样本管理，关键词输入信息。

    """

    def __init__(self):
        r"""
        :param _Keyword: 关键词，长度限制：20 个字符。
        :type Keyword: str
        :param _Tags: 关键词标签
<li>数组长度限制：20 个标签；</li>
<li>单个标签长度限制：128 个字符。</li>
        :type Tags: list of str
        """
        self._Keyword = None
        self._Tags = None

    @property
    def Keyword(self):
        r"""关键词，长度限制：20 个字符。
        :rtype: str
        """
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword

    @property
    def Tags(self):
        r"""关键词标签
<li>数组长度限制：20 个标签；</li>
<li>单个标签长度限制：128 个字符。</li>
        :rtype: list of str
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._Keyword = params.get("Keyword")
        self._Tags = params.get("Tags")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AigcImageExtraParam(AbstractModel):
    r"""用于AIGC创作图片时用到的扩展参数信息。

    """

    def __init__(self):
        r"""
        :param _AspectRatio: 指定所生成视频的宽高比。

不同模型支持的宽高比:
1. GEM支持：1:1、3:2、2:3、3:4、4:3、4:5、5:4、9:16、16:9 和 21:9。

注：具体模型的宽高比参数，可查看相应模型官网获取更完整描述。
        :type AspectRatio: str
        :param _Resolution: 指定图片输出分辨率。

支持该参数的模型：
支持选择: 720P, 1080P, 2K, 4K。

        :type Resolution: str
        """
        self._AspectRatio = None
        self._Resolution = None

    @property
    def AspectRatio(self):
        r"""指定所生成视频的宽高比。

不同模型支持的宽高比:
1. GEM支持：1:1、3:2、2:3、3:4、4:3、4:5、5:4、9:16、16:9 和 21:9。

注：具体模型的宽高比参数，可查看相应模型官网获取更完整描述。
        :rtype: str
        """
        return self._AspectRatio

    @AspectRatio.setter
    def AspectRatio(self, AspectRatio):
        self._AspectRatio = AspectRatio

    @property
    def Resolution(self):
        r"""指定图片输出分辨率。

支持该参数的模型：
支持选择: 720P, 1080P, 2K, 4K。

        :rtype: str
        """
        return self._Resolution

    @Resolution.setter
    def Resolution(self, Resolution):
        self._Resolution = Resolution


    def _deserialize(self, params):
        self._AspectRatio = params.get("AspectRatio")
        self._Resolution = params.get("Resolution")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AigcImageInfo(AbstractModel):
    r"""用于AIGC创作的图片信息。

    """

    def __init__(self):
        r"""
        :param _ImageUrl: 用于指导视频生成的图片 URL。该URL需外网可访问。同时允许爬虫拉取。
        :type ImageUrl: str
        :param _ReferenceType: 参考类型。
注意：
1. 当模型使用Vidu的q2多参考生图时，也可用于指定主体id。
2. 当使用GV模型时，可作为参考方式,可选asset(素材)、style(风格)。
        :type ReferenceType: str
        """
        self._ImageUrl = None
        self._ReferenceType = None

    @property
    def ImageUrl(self):
        r"""用于指导视频生成的图片 URL。该URL需外网可访问。同时允许爬虫拉取。
        :rtype: str
        """
        return self._ImageUrl

    @ImageUrl.setter
    def ImageUrl(self, ImageUrl):
        self._ImageUrl = ImageUrl

    @property
    def ReferenceType(self):
        r"""参考类型。
注意：
1. 当模型使用Vidu的q2多参考生图时，也可用于指定主体id。
2. 当使用GV模型时，可作为参考方式,可选asset(素材)、style(风格)。
        :rtype: str
        """
        return self._ReferenceType

    @ReferenceType.setter
    def ReferenceType(self, ReferenceType):
        self._ReferenceType = ReferenceType


    def _deserialize(self, params):
        self._ImageUrl = params.get("ImageUrl")
        self._ReferenceType = params.get("ReferenceType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AigcStoreCosParam(AbstractModel):
    r"""Aigc结果文件上传COS时，需传入的信息。 需创建并授权LVB_QCSRole角色。

    """

    def __init__(self):
        r"""
        :param _CosBucketName: 存储至 cos 的 bucket 桶名称。需要cos存储时，该值必填。 示例值：bucket。
        :type CosBucketName: str
        :param _CosBucketRegion: 存储至 cos 的 bucket 区域。与bucket所属区域相同，上传cos时必填。 示例值：ap-guangzhou
        :type CosBucketRegion: str
        :param _CosBucketPath: 存储至 cos 的 bucket 路径。
可选。
示例值：my_file
        :type CosBucketPath: str
        """
        self._CosBucketName = None
        self._CosBucketRegion = None
        self._CosBucketPath = None

    @property
    def CosBucketName(self):
        r"""存储至 cos 的 bucket 桶名称。需要cos存储时，该值必填。 示例值：bucket。
        :rtype: str
        """
        return self._CosBucketName

    @CosBucketName.setter
    def CosBucketName(self, CosBucketName):
        self._CosBucketName = CosBucketName

    @property
    def CosBucketRegion(self):
        r"""存储至 cos 的 bucket 区域。与bucket所属区域相同，上传cos时必填。 示例值：ap-guangzhou
        :rtype: str
        """
        return self._CosBucketRegion

    @CosBucketRegion.setter
    def CosBucketRegion(self, CosBucketRegion):
        self._CosBucketRegion = CosBucketRegion

    @property
    def CosBucketPath(self):
        r"""存储至 cos 的 bucket 路径。
可选。
示例值：my_file
        :rtype: str
        """
        return self._CosBucketPath

    @CosBucketPath.setter
    def CosBucketPath(self, CosBucketPath):
        self._CosBucketPath = CosBucketPath


    def _deserialize(self, params):
        self._CosBucketName = params.get("CosBucketName")
        self._CosBucketRegion = params.get("CosBucketRegion")
        self._CosBucketPath = params.get("CosBucketPath")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AigcVideoExtraParam(AbstractModel):
    r"""用于AIGC创作视频时用到的扩展参数信息。

    """

    def __init__(self):
        r"""
        :param _Resolution: 生成视频的分辨率，分辨率与选择模型及设置的视频时长相关。 

不同模型支持的分辨率选项:
1. Kling 720P(默认), 1080P。
2. Hailuo 768P(默认), 1080P。
3. Vidu 720P(默认)，1080P。
4. GV 720P(默认),1080P。
5. OS 720P, 图片仅支持1280x720、720x1280，暂不支持指定。

注意：除模型可支持的分辨率外，还可以生成 2K、4K分辨率。
        :type Resolution: str
        :param _AspectRatio: 指定所生成视频的宽高比。 

不同模型对于此参数的支持：
1. Kling 仅文生视频支持, 16:9(默认值)、9:16、 1:1。
2. Hailuo 暂不支持。
3. Vidu 仅文生和参考图生视频 支持[16:9、9:16、4:3、3:4、1:1]，其中仅q2支持4:3、3:4。
4. GV 16:9(默认值)、9:16。
5. OS 仅文生视频支持, 16:9(默认), 9:16。

注：关于具体模型支持的宽高比例，可查看具体模型官网介绍获取更完整描述。
        :type AspectRatio: str
        :param _LogoAdd: 是否添加图标水印。
1. Hailuo 支持此参数。
2. Kling 支持此参数。
3. Vidu 支持此参数。
        :type LogoAdd: int
        :param _EnableAudio: 为视频生成音频。接受的值包括 true 或 false。 

支持此参数的模型：
1. GV，默认true。
2. OS，默认true。
        :type EnableAudio: bool
        :param _OffPeak: 错峰模型，目前仅支持Vidu模型。
错峰模式下提交的任务，会在48小时内生成，未能完成的任务会被自动取消。
        :type OffPeak: bool
        """
        self._Resolution = None
        self._AspectRatio = None
        self._LogoAdd = None
        self._EnableAudio = None
        self._OffPeak = None

    @property
    def Resolution(self):
        r"""生成视频的分辨率，分辨率与选择模型及设置的视频时长相关。 

不同模型支持的分辨率选项:
1. Kling 720P(默认), 1080P。
2. Hailuo 768P(默认), 1080P。
3. Vidu 720P(默认)，1080P。
4. GV 720P(默认),1080P。
5. OS 720P, 图片仅支持1280x720、720x1280，暂不支持指定。

注意：除模型可支持的分辨率外，还可以生成 2K、4K分辨率。
        :rtype: str
        """
        return self._Resolution

    @Resolution.setter
    def Resolution(self, Resolution):
        self._Resolution = Resolution

    @property
    def AspectRatio(self):
        r"""指定所生成视频的宽高比。 

不同模型对于此参数的支持：
1. Kling 仅文生视频支持, 16:9(默认值)、9:16、 1:1。
2. Hailuo 暂不支持。
3. Vidu 仅文生和参考图生视频 支持[16:9、9:16、4:3、3:4、1:1]，其中仅q2支持4:3、3:4。
4. GV 16:9(默认值)、9:16。
5. OS 仅文生视频支持, 16:9(默认), 9:16。

注：关于具体模型支持的宽高比例，可查看具体模型官网介绍获取更完整描述。
        :rtype: str
        """
        return self._AspectRatio

    @AspectRatio.setter
    def AspectRatio(self, AspectRatio):
        self._AspectRatio = AspectRatio

    @property
    def LogoAdd(self):
        r"""是否添加图标水印。
1. Hailuo 支持此参数。
2. Kling 支持此参数。
3. Vidu 支持此参数。
        :rtype: int
        """
        return self._LogoAdd

    @LogoAdd.setter
    def LogoAdd(self, LogoAdd):
        self._LogoAdd = LogoAdd

    @property
    def EnableAudio(self):
        r"""为视频生成音频。接受的值包括 true 或 false。 

支持此参数的模型：
1. GV，默认true。
2. OS，默认true。
        :rtype: bool
        """
        return self._EnableAudio

    @EnableAudio.setter
    def EnableAudio(self, EnableAudio):
        self._EnableAudio = EnableAudio

    @property
    def OffPeak(self):
        r"""错峰模型，目前仅支持Vidu模型。
错峰模式下提交的任务，会在48小时内生成，未能完成的任务会被自动取消。
        :rtype: bool
        """
        return self._OffPeak

    @OffPeak.setter
    def OffPeak(self, OffPeak):
        self._OffPeak = OffPeak


    def _deserialize(self, params):
        self._Resolution = params.get("Resolution")
        self._AspectRatio = params.get("AspectRatio")
        self._LogoAdd = params.get("LogoAdd")
        self._EnableAudio = params.get("EnableAudio")
        self._OffPeak = params.get("OffPeak")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AigcVideoReferenceImageInfo(AbstractModel):
    r"""用于AIGC生视频创作的参考图片信息。

    """

    def __init__(self):
        r"""
        :param _ImageUrl: 用于指导视频生成的图片 URL。该URL需外网可访问。同时允许爬虫拉取。
        :type ImageUrl: str
        :param _ReferenceType: 参考类型。
注意：
1. 当使用GV模型时，可作为参考方式,可选asset(素材)、style(风格)。
        :type ReferenceType: str
        """
        self._ImageUrl = None
        self._ReferenceType = None

    @property
    def ImageUrl(self):
        r"""用于指导视频生成的图片 URL。该URL需外网可访问。同时允许爬虫拉取。
        :rtype: str
        """
        return self._ImageUrl

    @ImageUrl.setter
    def ImageUrl(self, ImageUrl):
        self._ImageUrl = ImageUrl

    @property
    def ReferenceType(self):
        r"""参考类型。
注意：
1. 当使用GV模型时，可作为参考方式,可选asset(素材)、style(风格)。
        :rtype: str
        """
        return self._ReferenceType

    @ReferenceType.setter
    def ReferenceType(self, ReferenceType):
        self._ReferenceType = ReferenceType


    def _deserialize(self, params):
        self._ImageUrl = params.get("ImageUrl")
        self._ReferenceType = params.get("ReferenceType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AnimatedGraphicTaskInput(AbstractModel):
    r"""转动图任务类型。

    """

    def __init__(self):
        r"""
        :param _Definition: 视频转动图模板 ID。
        :type Definition: int
        :param _StartTimeOffset: 动图在视频中的开始时间，单位为秒。
        :type StartTimeOffset: float
        :param _EndTimeOffset: 动图在视频中的结束时间，单位为秒。
        :type EndTimeOffset: float
        :param _OutputStorage: 转动图后文件的目标存储，不填则继承上层的 OutputStorage 值。
注意：此字段可能返回 null，表示取不到有效值。
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _OutputObjectPath: 转动图后文件的输出路径，可以为相对路径或者绝对路径。
若需定义输出路径，路径需以`.{format}`结尾。变量名请参考 [文件名变量说明](https://cloud.tencent.com/document/product/862/37039)。
相对路径示例：
<li>文件名_{变量名}.{format}</li>
<li>文件名.{format}</li>
绝对路径示例：
<li>/自定义路径/文件名_{变量名}.{format}</li>
如果不填，则默认为相对路径：`{inputName}_animatedGraphic_{definition}.{format}`。
        :type OutputObjectPath: str
        """
        self._Definition = None
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._OutputStorage = None
        self._OutputObjectPath = None

    @property
    def Definition(self):
        r"""视频转动图模板 ID。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def StartTimeOffset(self):
        r"""动图在视频中的开始时间，单位为秒。
        :rtype: float
        """
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        r"""动图在视频中的结束时间，单位为秒。
        :rtype: float
        """
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def OutputStorage(self):
        r"""转动图后文件的目标存储，不填则继承上层的 OutputStorage 值。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage

    @property
    def OutputObjectPath(self):
        r"""转动图后文件的输出路径，可以为相对路径或者绝对路径。
若需定义输出路径，路径需以`.{format}`结尾。变量名请参考 [文件名变量说明](https://cloud.tencent.com/document/product/862/37039)。
相对路径示例：
<li>文件名_{变量名}.{format}</li>
<li>文件名.{format}</li>
绝对路径示例：
<li>/自定义路径/文件名_{变量名}.{format}</li>
如果不填，则默认为相对路径：`{inputName}_animatedGraphic_{definition}.{format}`。
        :rtype: str
        """
        return self._OutputObjectPath

    @OutputObjectPath.setter
    def OutputObjectPath(self, OutputObjectPath):
        self._OutputObjectPath = OutputObjectPath


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        self._OutputObjectPath = params.get("OutputObjectPath")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AnimatedGraphicsTemplate(AbstractModel):
    r"""转动图模板详情。

    """

    def __init__(self):
        r"""
        :param _Definition: 转动图模板唯一标识。
        :type Definition: int
        :param _Type: 模板类型，取值范围：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :type Type: str
        :param _Name: 转动图模板名称。
        :type Name: str
        :param _Comment: 转动图模板描述。
        :type Comment: str
        :param _Width: 动图宽度（或长边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Width: int
        :param _Height: 动图高度（或短边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Height: int
        :param _ResolutionAdaptive: 分辨率自适应，可选值：
<li>open：开启，此时，Width 代表视频的长边，Height 表示视频的短边；</li>
<li>close：关闭，此时，Width 代表视频的宽度，Height 表示视频的高度。</li>
默认值：open。
        :type ResolutionAdaptive: str
        :param _Format: 动图格式。
        :type Format: str
        :param _Fps: 帧率。
        :type Fps: int
        :param _Quality: 图片质量。
        :type Quality: float
        :param _CreateTime: 模板创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :type CreateTime: str
        :param _UpdateTime: 模板最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :type UpdateTime: str
        """
        self._Definition = None
        self._Type = None
        self._Name = None
        self._Comment = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._Format = None
        self._Fps = None
        self._Quality = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def Definition(self):
        r"""转动图模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Type(self):
        r"""模板类型，取值范围：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        r"""转动图模板名称。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        r"""转动图模板描述。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def Width(self):
        r"""动图宽度（或长边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :rtype: int
        """
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        r"""动图高度（或短边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :rtype: int
        """
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        r"""分辨率自适应，可选值：
<li>open：开启，此时，Width 代表视频的长边，Height 表示视频的短边；</li>
<li>close：关闭，此时，Width 代表视频的宽度，Height 表示视频的高度。</li>
默认值：open。
        :rtype: str
        """
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def Format(self):
        r"""动图格式。
        :rtype: str
        """
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def Fps(self):
        r"""帧率。
        :rtype: int
        """
        return self._Fps

    @Fps.setter
    def Fps(self, Fps):
        self._Fps = Fps

    @property
    def Quality(self):
        r"""图片质量。
        :rtype: float
        """
        return self._Quality

    @Quality.setter
    def Quality(self, Quality):
        self._Quality = Quality

    @property
    def CreateTime(self):
        r"""模板创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""模板最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._Format = params.get("Format")
        self._Fps = params.get("Fps")
        self._Quality = params.get("Quality")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ArtifactRepairConfig(AbstractModel):
    r"""去伪影（毛刺）配置

    """

    def __init__(self):
        r"""
        :param _Switch: 能力配置开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
默认值：ON。
        :type Switch: str
        :param _Type: 类型，可选值：
<li>weak</li>
<li>strong</li>
默认值：weak。
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: str
        """
        self._Switch = None
        self._Type = None

    @property
    def Switch(self):
        r"""能力配置开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
默认值：ON。
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Type(self):
        r"""类型，可选值：
<li>weak</li>
<li>strong</li>
默认值：weak。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AsrFullTextConfigureInfo(AbstractModel):
    r"""语音全文识别任务控制参数

    """

    def __init__(self):
        r"""
        :param _Switch: 语音全文识别任务开关，可选值：
<li>ON：开启智能语音全文识别任务；</li>
<li>OFF：关闭智能语音全文识别任务。</li>
        :type Switch: str
        :param _SubtitleFormat: 生成的字幕文件格式，不填或者填空字符串表示不生成字幕文件，可选值：
<li>vtt：生成 WebVTT 字幕文件。</li>
        :type SubtitleFormat: str
        :param _SourceLanguage: 视频源语言。
        :type SourceLanguage: str
        """
        self._Switch = None
        self._SubtitleFormat = None
        self._SourceLanguage = None

    @property
    def Switch(self):
        r"""语音全文识别任务开关，可选值：
<li>ON：开启智能语音全文识别任务；</li>
<li>OFF：关闭智能语音全文识别任务。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def SubtitleFormat(self):
        r"""生成的字幕文件格式，不填或者填空字符串表示不生成字幕文件，可选值：
<li>vtt：生成 WebVTT 字幕文件。</li>
        :rtype: str
        """
        return self._SubtitleFormat

    @SubtitleFormat.setter
    def SubtitleFormat(self, SubtitleFormat):
        self._SubtitleFormat = SubtitleFormat

    @property
    def SourceLanguage(self):
        r"""视频源语言。
        :rtype: str
        """
        return self._SourceLanguage

    @SourceLanguage.setter
    def SourceLanguage(self, SourceLanguage):
        self._SourceLanguage = SourceLanguage


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._SubtitleFormat = params.get("SubtitleFormat")
        self._SourceLanguage = params.get("SourceLanguage")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AsrFullTextConfigureInfoForUpdate(AbstractModel):
    r"""语音全文识别任务控制参数

    """

    def __init__(self):
        r"""
        :param _Switch: 语音全文识别任务开关，可选值：
<li>ON：开启智能语音全文识别任务；</li>
<li>OFF：关闭智能语音全文识别任务。</li>
        :type Switch: str
        :param _SubtitleFormat: 生成的字幕文件格式，填空字符串表示不生成字幕文件，可选值：
<li>vtt：生成 WebVTT 字幕文件。</li>
        :type SubtitleFormat: str
        :param _SourceLanguage: 视频源语言。
        :type SourceLanguage: str
        """
        self._Switch = None
        self._SubtitleFormat = None
        self._SourceLanguage = None

    @property
    def Switch(self):
        r"""语音全文识别任务开关，可选值：
<li>ON：开启智能语音全文识别任务；</li>
<li>OFF：关闭智能语音全文识别任务。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def SubtitleFormat(self):
        r"""生成的字幕文件格式，填空字符串表示不生成字幕文件，可选值：
<li>vtt：生成 WebVTT 字幕文件。</li>
        :rtype: str
        """
        return self._SubtitleFormat

    @SubtitleFormat.setter
    def SubtitleFormat(self, SubtitleFormat):
        self._SubtitleFormat = SubtitleFormat

    @property
    def SourceLanguage(self):
        r"""视频源语言。
        :rtype: str
        """
        return self._SourceLanguage

    @SourceLanguage.setter
    def SourceLanguage(self, SourceLanguage):
        self._SourceLanguage = SourceLanguage


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._SubtitleFormat = params.get("SubtitleFormat")
        self._SourceLanguage = params.get("SourceLanguage")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AsrHotWordsConfigure(AbstractModel):
    r"""智能字幕热词参数

    """

    def __init__(self):
        r"""
        :param _Switch: 热词开关
注意：此字段可能返回 null，表示取不到有效值。
        :type Switch: str
        :param _LibraryId: 热词库ID
注意：此字段可能返回 null，表示取不到有效值。
        :type LibraryId: str
        """
        self._Switch = None
        self._LibraryId = None

    @property
    def Switch(self):
        r"""热词开关
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def LibraryId(self):
        r"""热词库ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._LibraryId

    @LibraryId.setter
    def LibraryId(self, LibraryId):
        self._LibraryId = LibraryId


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._LibraryId = params.get("LibraryId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AsrHotwordsSet(AbstractModel):
    r"""热词库查询返回结果集

    """

    def __init__(self):
        r"""
        :param _HotwordsId: 热词库 Id
注意：此字段可能返回 null，表示取不到有效值。
        :type HotwordsId: str
        :param _Status: 当前热词库状态，数值表示绑定该热词库的智能字幕模板数量。
Status 为 0 ，表示该热词库没有被智能字幕模板引用可以删除；
Status 不为 0，表示该热词库不能被删除。
注意：此字段可能返回 null，表示取不到有效值。
        :type Status: int
        :param _Name: 热词库名称
注意：此字段可能返回 null，表示取不到有效值。
        :type Name: str
        :param _WordCount: 热词库中的热词数量
注意：此字段可能返回 null，表示取不到有效值。
        :type WordCount: int
        :param _FileName: 热词文件上传时的文件名
注意：此字段可能返回 null，表示取不到有效值。
        :type FileName: str
        :param _CreateTime: 热词库创建时间 ISOUTC 时间格式  2006-01-02T15:04:05Z
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: str
        :param _UpdateTime: 热词库创建时间 ISOUTC 时间格式  2006-01-02T15:04:05Z
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        :param _Type: 0：临时热词库
1：文件热词库
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: int
        """
        self._HotwordsId = None
        self._Status = None
        self._Name = None
        self._WordCount = None
        self._FileName = None
        self._CreateTime = None
        self._UpdateTime = None
        self._Type = None

    @property
    def HotwordsId(self):
        r"""热词库 Id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._HotwordsId

    @HotwordsId.setter
    def HotwordsId(self, HotwordsId):
        self._HotwordsId = HotwordsId

    @property
    def Status(self):
        r"""当前热词库状态，数值表示绑定该热词库的智能字幕模板数量。
Status 为 0 ，表示该热词库没有被智能字幕模板引用可以删除；
Status 不为 0，表示该热词库不能被删除。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Name(self):
        r"""热词库名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def WordCount(self):
        r"""热词库中的热词数量
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._WordCount

    @WordCount.setter
    def WordCount(self, WordCount):
        self._WordCount = WordCount

    @property
    def FileName(self):
        r"""热词文件上传时的文件名
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._FileName

    @FileName.setter
    def FileName(self, FileName):
        self._FileName = FileName

    @property
    def CreateTime(self):
        r"""热词库创建时间 ISOUTC 时间格式  2006-01-02T15:04:05Z
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""热词库创建时间 ISOUTC 时间格式  2006-01-02T15:04:05Z
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def Type(self):
        r"""0：临时热词库
1：文件热词库
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._HotwordsId = params.get("HotwordsId")
        self._Status = params.get("Status")
        self._Name = params.get("Name")
        self._WordCount = params.get("WordCount")
        self._FileName = params.get("FileName")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AsrHotwordsSetItem(AbstractModel):
    r"""单个热词信息

    """

    def __init__(self):
        r"""
        :param _Id: 热词的序号
注意：此字段可能返回 null，表示取不到有效值。
        :type Id: int
        :param _Text: 热词文本
注意：此字段可能返回 null，表示取不到有效值。
        :type Text: str
        :param _Weight: 词语权重，取值范围 1-10,11,100
注意：此字段可能返回 null，表示取不到有效值。
        :type Weight: int
        """
        self._Id = None
        self._Text = None
        self._Weight = None

    @property
    def Id(self):
        r"""热词的序号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Text(self):
        r"""热词文本
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Text

    @Text.setter
    def Text(self, Text):
        self._Text = Text

    @property
    def Weight(self):
        r"""词语权重，取值范围 1-10,11,100
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Weight

    @Weight.setter
    def Weight(self, Weight):
        self._Weight = Weight


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Text = params.get("Text")
        self._Weight = params.get("Weight")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AsrWordsConfigureInfo(AbstractModel):
    r"""语音关键词识别控制参数。

    """

    def __init__(self):
        r"""
        :param _Switch: 语音关键词识别任务开关，可选值：
<li>ON：开启语音关键词识别任务；</li>
<li>OFF：关闭语音关键词识别任务。</li>
        :type Switch: str
        :param _LabelSet: 关键词过滤标签，指定需要返回的关键词的标签。如果未填或者为空，则全部结果都返回。
标签个数最多 10 个，每个标签长度最多 16 个字符。
        :type LabelSet: list of str
        """
        self._Switch = None
        self._LabelSet = None

    @property
    def Switch(self):
        r"""语音关键词识别任务开关，可选值：
<li>ON：开启语音关键词识别任务；</li>
<li>OFF：关闭语音关键词识别任务。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def LabelSet(self):
        r"""关键词过滤标签，指定需要返回的关键词的标签。如果未填或者为空，则全部结果都返回。
标签个数最多 10 个，每个标签长度最多 16 个字符。
        :rtype: list of str
        """
        return self._LabelSet

    @LabelSet.setter
    def LabelSet(self, LabelSet):
        self._LabelSet = LabelSet


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._LabelSet = params.get("LabelSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AsrWordsConfigureInfoForUpdate(AbstractModel):
    r"""语音关键词识别控制参数。

    """

    def __init__(self):
        r"""
        :param _Switch: 语音关键词识别任务开关，可选值：
<li>ON：开启语音关键词识别任务；</li>
<li>OFF：关闭语音关键词识别任务。</li>
        :type Switch: str
        :param _LabelSet: 关键词过滤标签，指定需要返回的关键词的标签。如果未填或者为空，则全部结果都返回。
标签个数最多 10 个，每个标签长度最多 16 个字符。
        :type LabelSet: list of str
        """
        self._Switch = None
        self._LabelSet = None

    @property
    def Switch(self):
        r"""语音关键词识别任务开关，可选值：
<li>ON：开启语音关键词识别任务；</li>
<li>OFF：关闭语音关键词识别任务。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def LabelSet(self):
        r"""关键词过滤标签，指定需要返回的关键词的标签。如果未填或者为空，则全部结果都返回。
标签个数最多 10 个，每个标签长度最多 16 个字符。
        :rtype: list of str
        """
        return self._LabelSet

    @LabelSet.setter
    def LabelSet(self, LabelSet):
        self._LabelSet = LabelSet


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._LabelSet = params.get("LabelSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioBeautifyConfig(AbstractModel):
    r"""音量美化配置

    """

    def __init__(self):
        r"""
        :param _Switch: 能力配置开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
默认值：ON。
        :type Switch: str
        :param _Types: 类型，可多选，可选值：
<li>declick：杂音去除</li>
<li>deesser：齿音压制</li>
默认值：declick。
注意：此字段可能返回 null，表示取不到有效值。
        :type Types: list of str
        """
        self._Switch = None
        self._Types = None

    @property
    def Switch(self):
        r"""能力配置开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
默认值：ON。
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Types(self):
        r"""类型，可多选，可选值：
<li>declick：杂音去除</li>
<li>deesser：齿音压制</li>
默认值：declick。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._Types

    @Types.setter
    def Types(self, Types):
        self._Types = Types


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Types = params.get("Types")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioDenoiseConfig(AbstractModel):
    r"""音频降噪配置

    """

    def __init__(self):
        r"""
        :param _Switch: 能力配置开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
默认值：ON。
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        r"""能力配置开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
默认值：ON。
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioEnhanceConfig(AbstractModel):
    r"""音频增强配置

    """

    def __init__(self):
        r"""
        :param _Denoise: 音频降噪配置。
注意：此字段可能返回 null，表示取不到有效值。
        :type Denoise: :class:`tencentcloud.mps.v20190612.models.AudioDenoiseConfig`
        :param _Separate: 音频分离配置。
注意：此字段可能返回 null，表示取不到有效值。
        :type Separate: :class:`tencentcloud.mps.v20190612.models.AudioSeparateConfig`
        :param _VolumeBalance: 音量均衡配置。
注意：此字段可能返回 null，表示取不到有效值。
        :type VolumeBalance: :class:`tencentcloud.mps.v20190612.models.VolumeBalanceConfig`
        :param _Beautify: 音频美化配置。
注意：此字段可能返回 null，表示取不到有效值。
        :type Beautify: :class:`tencentcloud.mps.v20190612.models.AudioBeautifyConfig`
        """
        self._Denoise = None
        self._Separate = None
        self._VolumeBalance = None
        self._Beautify = None

    @property
    def Denoise(self):
        r"""音频降噪配置。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AudioDenoiseConfig`
        """
        return self._Denoise

    @Denoise.setter
    def Denoise(self, Denoise):
        self._Denoise = Denoise

    @property
    def Separate(self):
        r"""音频分离配置。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AudioSeparateConfig`
        """
        return self._Separate

    @Separate.setter
    def Separate(self, Separate):
        self._Separate = Separate

    @property
    def VolumeBalance(self):
        r"""音量均衡配置。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.VolumeBalanceConfig`
        """
        return self._VolumeBalance

    @VolumeBalance.setter
    def VolumeBalance(self, VolumeBalance):
        self._VolumeBalance = VolumeBalance

    @property
    def Beautify(self):
        r"""音频美化配置。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AudioBeautifyConfig`
        """
        return self._Beautify

    @Beautify.setter
    def Beautify(self, Beautify):
        self._Beautify = Beautify


    def _deserialize(self, params):
        if params.get("Denoise") is not None:
            self._Denoise = AudioDenoiseConfig()
            self._Denoise._deserialize(params.get("Denoise"))
        if params.get("Separate") is not None:
            self._Separate = AudioSeparateConfig()
            self._Separate._deserialize(params.get("Separate"))
        if params.get("VolumeBalance") is not None:
            self._VolumeBalance = VolumeBalanceConfig()
            self._VolumeBalance._deserialize(params.get("VolumeBalance"))
        if params.get("Beautify") is not None:
            self._Beautify = AudioBeautifyConfig()
            self._Beautify._deserialize(params.get("Beautify"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioSeparateConfig(AbstractModel):
    r"""音频分离配置

    """

    def __init__(self):
        r"""
        :param _Switch: 能力配置开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
默认值：ON。
        :type Switch: str
        :param _Type: 场景类型，可选值：
<li>normal：人声背景声场景</li>
<li>music：演唱伴奏场景</li>
默认值：normal。
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: str
        :param _Track: 输出音轨，可选值：
<li>vocal：输出人声</li>
<li>background：应用场景为normal时输出背景声，应用场景为music时输出伴奏</li>
默认值：vocal。
注意：此字段可能返回 null，表示取不到有效值。
        :type Track: str
        """
        self._Switch = None
        self._Type = None
        self._Track = None

    @property
    def Switch(self):
        r"""能力配置开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
默认值：ON。
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Type(self):
        r"""场景类型，可选值：
<li>normal：人声背景声场景</li>
<li>music：演唱伴奏场景</li>
默认值：normal。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Track(self):
        r"""输出音轨，可选值：
<li>vocal：输出人声</li>
<li>background：应用场景为normal时输出背景声，应用场景为music时输出伴奏</li>
默认值：vocal。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Track

    @Track.setter
    def Track(self, Track):
        self._Track = Track


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Type = params.get("Type")
        self._Track = params.get("Track")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioTemplateInfo(AbstractModel):
    r"""音频流配置参数

    """

    def __init__(self):
        r"""
        :param _Codec: 音频流的编码格式。
当不需要对音频进行转码时，可选值为：
<li>copy。</li>
当外层参数 Container 为 mp3 时，可选值为：
<li>mp3。</li>
当外层参数 Container 为 ogg 或 flac 时，可选值为：
<li>flac。</li>
当外层参数 Container 为 m4a 时，可选值为：
<li>aac；</li>
<li>ac3。</li>
当外层参数 Container 为 mp4 或 flv 时，可选值为：
<li>aac：更适合 mp4；</li>
<li>mp3：更适合 flv；</li>
<li>mp2。</li>
当外层参数 Container 为 hls 时，可选值为：
<li>aac；</li>
<li>mp3;</li>
<li>eac3：自适应转码音轨合并时使用。</li>
        :type Codec: str
        :param _Bitrate: 音频流的码率，取值范围：0 和 [26, 256]，单位：kbps。
当取值为 0，表示音频码率和原始音频保持一致。
注意：如果使用自适应转码音轨合并TrackChannelInfo参数，取值范围：
1）、不能填0；
2）、Codec为：aac时，取值范围：[26, 256];
3）、Codec为：ac3时，取值范围：[26, 640];
4)、Codec为：eac3时，取值范围：[26, 6144]，备注：当SampleRate为44100HZ，最大值为：5644，当SampleRate为48000HZ，最大值为：6144，


        :type Bitrate: int
        :param _SampleRate: 音频流的采样率，不同编码标准支持的采样率选项不同。填0代表使用源音频的采样率数值。
详细参考[音频采样率支持范围文档](https://cloud.tencent.com/document/product/862/77166#f3b039f1-d817-4a96-b4e4-90132d31cd53)
单位：Hz
注意：请确保源音频流的采样率在上述选项范围内，否则可能导致转码失败！
        :type SampleRate: int
        :param _AudioChannel: 音频通道方式，可选值：
<li>1：单通道</li>
<li>2：双通道</li>
<li>6：5.1声道</li>
当媒体的封装格式是音频格式时（flac，ogg，mp3，m4a）时，声道数不允许设为5.1声道。
默认值：2。
        :type AudioChannel: int
        :param _TrackChannelInfo: 合并音轨信息。
注意：此字段只是自适应转码生效，
注意：此字段可能返回 null，表示取不到有效值。
        :type TrackChannelInfo: :class:`tencentcloud.mps.v20190612.models.AudioTrackChannelInfo`
        """
        self._Codec = None
        self._Bitrate = None
        self._SampleRate = None
        self._AudioChannel = None
        self._TrackChannelInfo = None

    @property
    def Codec(self):
        r"""音频流的编码格式。
当不需要对音频进行转码时，可选值为：
<li>copy。</li>
当外层参数 Container 为 mp3 时，可选值为：
<li>mp3。</li>
当外层参数 Container 为 ogg 或 flac 时，可选值为：
<li>flac。</li>
当外层参数 Container 为 m4a 时，可选值为：
<li>aac；</li>
<li>ac3。</li>
当外层参数 Container 为 mp4 或 flv 时，可选值为：
<li>aac：更适合 mp4；</li>
<li>mp3：更适合 flv；</li>
<li>mp2。</li>
当外层参数 Container 为 hls 时，可选值为：
<li>aac；</li>
<li>mp3;</li>
<li>eac3：自适应转码音轨合并时使用。</li>
        :rtype: str
        """
        return self._Codec

    @Codec.setter
    def Codec(self, Codec):
        self._Codec = Codec

    @property
    def Bitrate(self):
        r"""音频流的码率，取值范围：0 和 [26, 256]，单位：kbps。
当取值为 0，表示音频码率和原始音频保持一致。
注意：如果使用自适应转码音轨合并TrackChannelInfo参数，取值范围：
1）、不能填0；
2）、Codec为：aac时，取值范围：[26, 256];
3）、Codec为：ac3时，取值范围：[26, 640];
4)、Codec为：eac3时，取值范围：[26, 6144]，备注：当SampleRate为44100HZ，最大值为：5644，当SampleRate为48000HZ，最大值为：6144，


        :rtype: int
        """
        return self._Bitrate

    @Bitrate.setter
    def Bitrate(self, Bitrate):
        self._Bitrate = Bitrate

    @property
    def SampleRate(self):
        r"""音频流的采样率，不同编码标准支持的采样率选项不同。填0代表使用源音频的采样率数值。
详细参考[音频采样率支持范围文档](https://cloud.tencent.com/document/product/862/77166#f3b039f1-d817-4a96-b4e4-90132d31cd53)
单位：Hz
注意：请确保源音频流的采样率在上述选项范围内，否则可能导致转码失败！
        :rtype: int
        """
        return self._SampleRate

    @SampleRate.setter
    def SampleRate(self, SampleRate):
        self._SampleRate = SampleRate

    @property
    def AudioChannel(self):
        r"""音频通道方式，可选值：
<li>1：单通道</li>
<li>2：双通道</li>
<li>6：5.1声道</li>
当媒体的封装格式是音频格式时（flac，ogg，mp3，m4a）时，声道数不允许设为5.1声道。
默认值：2。
        :rtype: int
        """
        return self._AudioChannel

    @AudioChannel.setter
    def AudioChannel(self, AudioChannel):
        self._AudioChannel = AudioChannel

    @property
    def TrackChannelInfo(self):
        r"""合并音轨信息。
注意：此字段只是自适应转码生效，
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AudioTrackChannelInfo`
        """
        return self._TrackChannelInfo

    @TrackChannelInfo.setter
    def TrackChannelInfo(self, TrackChannelInfo):
        self._TrackChannelInfo = TrackChannelInfo


    def _deserialize(self, params):
        self._Codec = params.get("Codec")
        self._Bitrate = params.get("Bitrate")
        self._SampleRate = params.get("SampleRate")
        self._AudioChannel = params.get("AudioChannel")
        if params.get("TrackChannelInfo") is not None:
            self._TrackChannelInfo = AudioTrackChannelInfo()
            self._TrackChannelInfo._deserialize(params.get("TrackChannelInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioTemplateInfoForUpdate(AbstractModel):
    r"""音频流配置参数

    """

    def __init__(self):
        r"""
        :param _Codec: 音频流的编码格式。
当不需要对音频进行转码时，可选值为：
<li>copy。</li>
当外层参数 Container 为 mp3 时，可选值为：
<li>mp3。</li>
当外层参数 Container 为 ogg 或 flac 时，可选值为：
<li>flac。</li>
当外层参数 Container 为 m4a 时，可选值为：
<li>aac；</li>
<li>ac3。</li>
当外层参数 Container 为 mp4 或 flv 时，可选值为：
<li>aac：更适合 mp4；</li>
<li>mp3：更适合 flv；</li>
<li>mp2。</li>
当外层参数 Container 为 hls 时，可选值为：
<li>aac；</li>
<li>mp3。</li>
注意：此字段可能返回 null，表示取不到有效值。
        :type Codec: str
        :param _Bitrate: 音频流的码率，取值范围：0 和 [26, 256]，单位：kbps。 当取值为 0，表示音频码率和原始音频保持一致。
注意：此字段可能返回 null，表示取不到有效值。
        :type Bitrate: int
        :param _SampleRate: 音频流的采样率，不同编码标准支持的采样率选项不同。填0代表使用源音频的采样率数值。
详细参考[音频采样率支持范围文档](https://cloud.tencent.com/document/product/862/77166#f3b039f1-d817-4a96-b4e4-90132d31cd53)
单位：Hz
注意：请确保源音频流的采样率在上述选项范围内，否则可能导致转码失败！
注意：此字段可能返回 null，表示取不到有效值。
        :type SampleRate: int
        :param _AudioChannel: 音频通道方式，可选值：
<li>1：单通道</li>
<li>2：双通道</li>
<li>6：5.1声道</li>
当媒体的封装格式是音频格式时（flac，ogg，mp3，m4a）时，声道数不允许设为5.1声道。
注意：此字段可能返回 null，表示取不到有效值。
        :type AudioChannel: int
        :param _StreamSelects: 指定输出要保留的音频轨道。默认是全部保留源的。
注意：此字段可能返回 null，表示取不到有效值。
        :type StreamSelects: list of int
        """
        self._Codec = None
        self._Bitrate = None
        self._SampleRate = None
        self._AudioChannel = None
        self._StreamSelects = None

    @property
    def Codec(self):
        r"""音频流的编码格式。
当不需要对音频进行转码时，可选值为：
<li>copy。</li>
当外层参数 Container 为 mp3 时，可选值为：
<li>mp3。</li>
当外层参数 Container 为 ogg 或 flac 时，可选值为：
<li>flac。</li>
当外层参数 Container 为 m4a 时，可选值为：
<li>aac；</li>
<li>ac3。</li>
当外层参数 Container 为 mp4 或 flv 时，可选值为：
<li>aac：更适合 mp4；</li>
<li>mp3：更适合 flv；</li>
<li>mp2。</li>
当外层参数 Container 为 hls 时，可选值为：
<li>aac；</li>
<li>mp3。</li>
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Codec

    @Codec.setter
    def Codec(self, Codec):
        self._Codec = Codec

    @property
    def Bitrate(self):
        r"""音频流的码率，取值范围：0 和 [26, 256]，单位：kbps。 当取值为 0，表示音频码率和原始音频保持一致。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Bitrate

    @Bitrate.setter
    def Bitrate(self, Bitrate):
        self._Bitrate = Bitrate

    @property
    def SampleRate(self):
        r"""音频流的采样率，不同编码标准支持的采样率选项不同。填0代表使用源音频的采样率数值。
详细参考[音频采样率支持范围文档](https://cloud.tencent.com/document/product/862/77166#f3b039f1-d817-4a96-b4e4-90132d31cd53)
单位：Hz
注意：请确保源音频流的采样率在上述选项范围内，否则可能导致转码失败！
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._SampleRate

    @SampleRate.setter
    def SampleRate(self, SampleRate):
        self._SampleRate = SampleRate

    @property
    def AudioChannel(self):
        r"""音频通道方式，可选值：
<li>1：单通道</li>
<li>2：双通道</li>
<li>6：5.1声道</li>
当媒体的封装格式是音频格式时（flac，ogg，mp3，m4a）时，声道数不允许设为5.1声道。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._AudioChannel

    @AudioChannel.setter
    def AudioChannel(self, AudioChannel):
        self._AudioChannel = AudioChannel

    @property
    def StreamSelects(self):
        r"""指定输出要保留的音频轨道。默认是全部保留源的。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of int
        """
        return self._StreamSelects

    @StreamSelects.setter
    def StreamSelects(self, StreamSelects):
        self._StreamSelects = StreamSelects


    def _deserialize(self, params):
        self._Codec = params.get("Codec")
        self._Bitrate = params.get("Bitrate")
        self._SampleRate = params.get("SampleRate")
        self._AudioChannel = params.get("AudioChannel")
        self._StreamSelects = params.get("StreamSelects")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioTrackChannelInfo(AbstractModel):
    r"""音轨信息

    """

    def __init__(self):
        r"""
        :param _ChannelsRemix: 是否开启混音，可选值：
0：表示不开启混音
1：表示开启混音
默认值：0
注意：此字段可能返回 null，表示取不到有效值。
        :type ChannelsRemix: int
        :param _SelectType: 合并音轨输入类型，可选值：
track：表示使用音轨id；
track_channel： 表示使用音轨id和声道id；
默认：track。
注意：如果原视频是多声道，建议使用track_channel。
注意：此字段可能返回 null，表示取不到有效值。
        :type SelectType: str
        :param _InputTrackInfo: 音轨信息
注意：此字段可能返回 null，表示取不到有效值。
        :type InputTrackInfo: list of TrackInfo
        """
        self._ChannelsRemix = None
        self._SelectType = None
        self._InputTrackInfo = None

    @property
    def ChannelsRemix(self):
        r"""是否开启混音，可选值：
0：表示不开启混音
1：表示开启混音
默认值：0
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._ChannelsRemix

    @ChannelsRemix.setter
    def ChannelsRemix(self, ChannelsRemix):
        self._ChannelsRemix = ChannelsRemix

    @property
    def SelectType(self):
        r"""合并音轨输入类型，可选值：
track：表示使用音轨id；
track_channel： 表示使用音轨id和声道id；
默认：track。
注意：如果原视频是多声道，建议使用track_channel。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SelectType

    @SelectType.setter
    def SelectType(self, SelectType):
        self._SelectType = SelectType

    @property
    def InputTrackInfo(self):
        r"""音轨信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of TrackInfo
        """
        return self._InputTrackInfo

    @InputTrackInfo.setter
    def InputTrackInfo(self, InputTrackInfo):
        self._InputTrackInfo = InputTrackInfo


    def _deserialize(self, params):
        self._ChannelsRemix = params.get("ChannelsRemix")
        self._SelectType = params.get("SelectType")
        if params.get("InputTrackInfo") is not None:
            self._InputTrackInfo = []
            for item in params.get("InputTrackInfo"):
                obj = TrackInfo()
                obj._deserialize(item)
                self._InputTrackInfo.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AwsS3FileUploadTrigger(AbstractModel):
    r"""AWS S3 文件是上传触发器。

    """

    def __init__(self):
        r"""
        :param _S3Bucket: 绑定的 AWS S3 存储桶。
        :type S3Bucket: str
        :param _S3Region: 绑定的桶所在 AWS 区域，目前支持：  
us-east-1  
eu-west-3
        :type S3Region: str
        :param _Dir: 绑定的输入路径目录，必须为绝对路径，即以 `/` 开头和结尾。如`/movie/201907/`，不填代表根目录`/`。	
        :type Dir: str
        :param _Formats: 允许触发的文件格式列表，如 ["mp4", "flv", "mov"]。不填代表所有格式的文件都可以触发工作流。	
        :type Formats: list of str
        :param _S3SecretId: 绑定的 AWS S3 存储桶的秘钥ID。
注意：此字段可能返回 null，表示取不到有效值。
        :type S3SecretId: str
        :param _S3SecretKey: 绑定的 AWS S3 存储桶的秘钥Key。
注意：此字段可能返回 null，表示取不到有效值。
        :type S3SecretKey: str
        :param _AwsSQS: 绑定的 AWS S3 存储桶对应的 SQS事件队列。
注意：队列和桶需要在同一区域。
注意：此字段可能返回 null，表示取不到有效值。
        :type AwsSQS: :class:`tencentcloud.mps.v20190612.models.AwsSQS`
        """
        self._S3Bucket = None
        self._S3Region = None
        self._Dir = None
        self._Formats = None
        self._S3SecretId = None
        self._S3SecretKey = None
        self._AwsSQS = None

    @property
    def S3Bucket(self):
        r"""绑定的 AWS S3 存储桶。
        :rtype: str
        """
        return self._S3Bucket

    @S3Bucket.setter
    def S3Bucket(self, S3Bucket):
        self._S3Bucket = S3Bucket

    @property
    def S3Region(self):
        r"""绑定的桶所在 AWS 区域，目前支持：  
us-east-1  
eu-west-3
        :rtype: str
        """
        return self._S3Region

    @S3Region.setter
    def S3Region(self, S3Region):
        self._S3Region = S3Region

    @property
    def Dir(self):
        r"""绑定的输入路径目录，必须为绝对路径，即以 `/` 开头和结尾。如`/movie/201907/`，不填代表根目录`/`。	
        :rtype: str
        """
        return self._Dir

    @Dir.setter
    def Dir(self, Dir):
        self._Dir = Dir

    @property
    def Formats(self):
        r"""允许触发的文件格式列表，如 ["mp4", "flv", "mov"]。不填代表所有格式的文件都可以触发工作流。	
        :rtype: list of str
        """
        return self._Formats

    @Formats.setter
    def Formats(self, Formats):
        self._Formats = Formats

    @property
    def S3SecretId(self):
        r"""绑定的 AWS S3 存储桶的秘钥ID。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._S3SecretId

    @S3SecretId.setter
    def S3SecretId(self, S3SecretId):
        self._S3SecretId = S3SecretId

    @property
    def S3SecretKey(self):
        r"""绑定的 AWS S3 存储桶的秘钥Key。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._S3SecretKey

    @S3SecretKey.setter
    def S3SecretKey(self, S3SecretKey):
        self._S3SecretKey = S3SecretKey

    @property
    def AwsSQS(self):
        r"""绑定的 AWS S3 存储桶对应的 SQS事件队列。
注意：队列和桶需要在同一区域。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AwsSQS`
        """
        return self._AwsSQS

    @AwsSQS.setter
    def AwsSQS(self, AwsSQS):
        self._AwsSQS = AwsSQS


    def _deserialize(self, params):
        self._S3Bucket = params.get("S3Bucket")
        self._S3Region = params.get("S3Region")
        self._Dir = params.get("Dir")
        self._Formats = params.get("Formats")
        self._S3SecretId = params.get("S3SecretId")
        self._S3SecretKey = params.get("S3SecretKey")
        if params.get("AwsSQS") is not None:
            self._AwsSQS = AwsSQS()
            self._AwsSQS._deserialize(params.get("AwsSQS"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AwsSQS(AbstractModel):
    r"""Aws SQS 队列信息

    """

    def __init__(self):
        r"""
        :param _SQSRegion: SQS 队列区域。
注意：此字段可能返回 null，表示取不到有效值。
        :type SQSRegion: str
        :param _SQSQueueName: SQS 队列名称。
注意：此字段可能返回 null，表示取不到有效值。
        :type SQSQueueName: str
        :param _S3SecretId: 读写SQS的秘钥id。
注意：此字段可能返回 null，表示取不到有效值。
        :type S3SecretId: str
        :param _S3SecretKey: 读写SQS的秘钥key。
注意：此字段可能返回 null，表示取不到有效值。
        :type S3SecretKey: str
        """
        self._SQSRegion = None
        self._SQSQueueName = None
        self._S3SecretId = None
        self._S3SecretKey = None

    @property
    def SQSRegion(self):
        r"""SQS 队列区域。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SQSRegion

    @SQSRegion.setter
    def SQSRegion(self, SQSRegion):
        self._SQSRegion = SQSRegion

    @property
    def SQSQueueName(self):
        r"""SQS 队列名称。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SQSQueueName

    @SQSQueueName.setter
    def SQSQueueName(self, SQSQueueName):
        self._SQSQueueName = SQSQueueName

    @property
    def S3SecretId(self):
        r"""读写SQS的秘钥id。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._S3SecretId

    @S3SecretId.setter
    def S3SecretId(self, S3SecretId):
        self._S3SecretId = S3SecretId

    @property
    def S3SecretKey(self):
        r"""读写SQS的秘钥key。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._S3SecretKey

    @S3SecretKey.setter
    def S3SecretKey(self, S3SecretKey):
        self._S3SecretKey = S3SecretKey


    def _deserialize(self, params):
        self._SQSRegion = params.get("SQSRegion")
        self._SQSQueueName = params.get("SQSQueueName")
        self._S3SecretId = params.get("S3SecretId")
        self._S3SecretKey = params.get("S3SecretKey")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchDeleteStreamLinkFlowRequest(AbstractModel):
    r"""BatchDeleteStreamLinkFlow请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EventId: EventId。
        :type EventId: str
        :param _FlowIds: Event关联的流Id数组，如果不传默认删除Event下面的所有媒体传输流。
        :type FlowIds: list of str
        """
        self._EventId = None
        self._FlowIds = None

    @property
    def EventId(self):
        r"""EventId。
        :rtype: str
        """
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId

    @property
    def FlowIds(self):
        r"""Event关联的流Id数组，如果不传默认删除Event下面的所有媒体传输流。
        :rtype: list of str
        """
        return self._FlowIds

    @FlowIds.setter
    def FlowIds(self, FlowIds):
        self._FlowIds = FlowIds


    def _deserialize(self, params):
        self._EventId = params.get("EventId")
        self._FlowIds = params.get("FlowIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchDeleteStreamLinkFlowResponse(AbstractModel):
    r"""BatchDeleteStreamLinkFlow返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class BatchProcessMediaRequest(AbstractModel):
    r"""BatchProcessMedia请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InputInfo: 媒体处理的文件输入信息。
        :type InputInfo: list of MediaInputInfo
        :param _OutputStorage: 媒体处理输出文件的目标存储。不填则继承 InputInfo 中的存储位置。
注意：当InputInfo.Type为URL时，该参数是必填项
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _OutputDir: 媒体处理生成的文件输出的目标目录，必选以 / 开头和结尾，如`/movie/201907/`。
如果不填，表示与 InputInfo 中文件所在的目录一致。
        :type OutputDir: str
        :param _SmartSubtitlesTask: 智能字幕
        :type SmartSubtitlesTask: :class:`tencentcloud.mps.v20190612.models.SmartSubtitlesTaskInput`
        :param _TaskNotifyConfig: 任务的事件通知信息，不填代表不获取事件通知。
        :type TaskNotifyConfig: :class:`tencentcloud.mps.v20190612.models.TaskNotifyConfig`
        :param _TasksPriority: 任务流的优先级，数值越大优先级越高，取值范围是-10到 10，不填代表0。
        :type TasksPriority: int
        :param _SessionContext: 来源上下文，用于透传用户请求信息，任务流状态变更回调将返回该字段值，最长 1000 个字符。
        :type SessionContext: str
        :param _ResourceId: 资源ID，需要保证对应资源是开启状态。默认为帐号主资源ID。
        :type ResourceId: str
        :param _SkipMateData: 是否跳过元信息获取，可选值： 
0：表示不跳过 
1：表示跳过 
默认值：0	
        :type SkipMateData: int
        """
        self._InputInfo = None
        self._OutputStorage = None
        self._OutputDir = None
        self._SmartSubtitlesTask = None
        self._TaskNotifyConfig = None
        self._TasksPriority = None
        self._SessionContext = None
        self._ResourceId = None
        self._SkipMateData = None

    @property
    def InputInfo(self):
        r"""媒体处理的文件输入信息。
        :rtype: list of MediaInputInfo
        """
        return self._InputInfo

    @InputInfo.setter
    def InputInfo(self, InputInfo):
        self._InputInfo = InputInfo

    @property
    def OutputStorage(self):
        r"""媒体处理输出文件的目标存储。不填则继承 InputInfo 中的存储位置。
注意：当InputInfo.Type为URL时，该参数是必填项
        :rtype: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage

    @property
    def OutputDir(self):
        r"""媒体处理生成的文件输出的目标目录，必选以 / 开头和结尾，如`/movie/201907/`。
如果不填，表示与 InputInfo 中文件所在的目录一致。
        :rtype: str
        """
        return self._OutputDir

    @OutputDir.setter
    def OutputDir(self, OutputDir):
        self._OutputDir = OutputDir

    @property
    def SmartSubtitlesTask(self):
        r"""智能字幕
        :rtype: :class:`tencentcloud.mps.v20190612.models.SmartSubtitlesTaskInput`
        """
        return self._SmartSubtitlesTask

    @SmartSubtitlesTask.setter
    def SmartSubtitlesTask(self, SmartSubtitlesTask):
        self._SmartSubtitlesTask = SmartSubtitlesTask

    @property
    def TaskNotifyConfig(self):
        r"""任务的事件通知信息，不填代表不获取事件通知。
        :rtype: :class:`tencentcloud.mps.v20190612.models.TaskNotifyConfig`
        """
        return self._TaskNotifyConfig

    @TaskNotifyConfig.setter
    def TaskNotifyConfig(self, TaskNotifyConfig):
        self._TaskNotifyConfig = TaskNotifyConfig

    @property
    def TasksPriority(self):
        r"""任务流的优先级，数值越大优先级越高，取值范围是-10到 10，不填代表0。
        :rtype: int
        """
        return self._TasksPriority

    @TasksPriority.setter
    def TasksPriority(self, TasksPriority):
        self._TasksPriority = TasksPriority

    @property
    def SessionContext(self):
        r"""来源上下文，用于透传用户请求信息，任务流状态变更回调将返回该字段值，最长 1000 个字符。
        :rtype: str
        """
        return self._SessionContext

    @SessionContext.setter
    def SessionContext(self, SessionContext):
        self._SessionContext = SessionContext

    @property
    def ResourceId(self):
        r"""资源ID，需要保证对应资源是开启状态。默认为帐号主资源ID。
        :rtype: str
        """
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId

    @property
    def SkipMateData(self):
        r"""是否跳过元信息获取，可选值： 
0：表示不跳过 
1：表示跳过 
默认值：0	
        :rtype: int
        """
        return self._SkipMateData

    @SkipMateData.setter
    def SkipMateData(self, SkipMateData):
        self._SkipMateData = SkipMateData


    def _deserialize(self, params):
        if params.get("InputInfo") is not None:
            self._InputInfo = []
            for item in params.get("InputInfo"):
                obj = MediaInputInfo()
                obj._deserialize(item)
                self._InputInfo.append(obj)
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        self._OutputDir = params.get("OutputDir")
        if params.get("SmartSubtitlesTask") is not None:
            self._SmartSubtitlesTask = SmartSubtitlesTaskInput()
            self._SmartSubtitlesTask._deserialize(params.get("SmartSubtitlesTask"))
        if params.get("TaskNotifyConfig") is not None:
            self._TaskNotifyConfig = TaskNotifyConfig()
            self._TaskNotifyConfig._deserialize(params.get("TaskNotifyConfig"))
        self._TasksPriority = params.get("TasksPriority")
        self._SessionContext = params.get("SessionContext")
        self._ResourceId = params.get("ResourceId")
        self._SkipMateData = params.get("SkipMateData")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchProcessMediaResponse(AbstractModel):
    r"""BatchProcessMedia返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务 ID。
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        r"""任务 ID。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class BatchSmartSubtitlesResult(AbstractModel):
    r"""智能字幕结果。

    """

    def __init__(self):
        r"""
        :param _Input: 智能字幕任务输入信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type Input: :class:`tencentcloud.mps.v20190612.models.SmartSubtitleTaskResultInput`
        :param _Outputs: 智能字幕输出信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Outputs: list of SmartSubtitleTaskBatchOutput
        """
        self._Input = None
        self._Outputs = None

    @property
    def Input(self):
        r"""智能字幕任务输入信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.SmartSubtitleTaskResultInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Outputs(self):
        r"""智能字幕输出信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of SmartSubtitleTaskBatchOutput
        """
        return self._Outputs

    @Outputs.setter
    def Outputs(self, Outputs):
        self._Outputs = Outputs


    def _deserialize(self, params):
        if params.get("Input") is not None:
            self._Input = SmartSubtitleTaskResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Outputs") is not None:
            self._Outputs = []
            for item in params.get("Outputs"):
                obj = SmartSubtitleTaskBatchOutput()
                obj._deserialize(item)
                self._Outputs.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchStartStreamLinkFlowRequest(AbstractModel):
    r"""BatchStartStreamLinkFlow请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EventId: EventId。
        :type EventId: str
        :param _FlowIds: Event关联的流Id数组，如果不传默认启动Event下面的所有媒体传输流。
        :type FlowIds: list of str
        """
        self._EventId = None
        self._FlowIds = None

    @property
    def EventId(self):
        r"""EventId。
        :rtype: str
        """
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId

    @property
    def FlowIds(self):
        r"""Event关联的流Id数组，如果不传默认启动Event下面的所有媒体传输流。
        :rtype: list of str
        """
        return self._FlowIds

    @FlowIds.setter
    def FlowIds(self, FlowIds):
        self._FlowIds = FlowIds


    def _deserialize(self, params):
        self._EventId = params.get("EventId")
        self._FlowIds = params.get("FlowIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchStartStreamLinkFlowResponse(AbstractModel):
    r"""BatchStartStreamLinkFlow返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class BatchStopStreamLinkFlowRequest(AbstractModel):
    r"""BatchStopStreamLinkFlow请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EventId: EventId。
        :type EventId: str
        :param _FlowIds: 流Id，如果不传默认停止Event下所有的媒体传输流。
        :type FlowIds: list of str
        """
        self._EventId = None
        self._FlowIds = None

    @property
    def EventId(self):
        r"""EventId。
        :rtype: str
        """
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId

    @property
    def FlowIds(self):
        r"""流Id，如果不传默认停止Event下所有的媒体传输流。
        :rtype: list of str
        """
        return self._FlowIds

    @FlowIds.setter
    def FlowIds(self, FlowIds):
        self._FlowIds = FlowIds


    def _deserialize(self, params):
        self._EventId = params.get("EventId")
        self._FlowIds = params.get("FlowIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchStopStreamLinkFlowResponse(AbstractModel):
    r"""BatchStopStreamLinkFlow返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class BatchSubTaskResult(AbstractModel):
    r"""批量任务子任务结果

    """

    def __init__(self):
        r"""
        :param _InputInfos: 批量任务输入信息
注意：此字段可能返回 null，表示取不到有效值。
        :type InputInfos: list of MediaInputInfo
        :param _Metadatas: 原始视频的元信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type Metadatas: list of MediaMetaData
        :param _SmartSubtitlesTaskResult: 智能字幕任务的执行结果
注意：此字段可能返回 null，表示取不到有效值。
        :type SmartSubtitlesTaskResult: :class:`tencentcloud.mps.v20190612.models.BatchSmartSubtitlesResult`
        """
        self._InputInfos = None
        self._Metadatas = None
        self._SmartSubtitlesTaskResult = None

    @property
    def InputInfos(self):
        r"""批量任务输入信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of MediaInputInfo
        """
        return self._InputInfos

    @InputInfos.setter
    def InputInfos(self, InputInfos):
        self._InputInfos = InputInfos

    @property
    def Metadatas(self):
        r"""原始视频的元信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of MediaMetaData
        """
        return self._Metadatas

    @Metadatas.setter
    def Metadatas(self, Metadatas):
        self._Metadatas = Metadatas

    @property
    def SmartSubtitlesTaskResult(self):
        r"""智能字幕任务的执行结果
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.BatchSmartSubtitlesResult`
        """
        return self._SmartSubtitlesTaskResult

    @SmartSubtitlesTaskResult.setter
    def SmartSubtitlesTaskResult(self, SmartSubtitlesTaskResult):
        self._SmartSubtitlesTaskResult = SmartSubtitlesTaskResult


    def _deserialize(self, params):
        if params.get("InputInfos") is not None:
            self._InputInfos = []
            for item in params.get("InputInfos"):
                obj = MediaInputInfo()
                obj._deserialize(item)
                self._InputInfos.append(obj)
        if params.get("Metadatas") is not None:
            self._Metadatas = []
            for item in params.get("Metadatas"):
                obj = MediaMetaData()
                obj._deserialize(item)
                self._Metadatas.append(obj)
        if params.get("SmartSubtitlesTaskResult") is not None:
            self._SmartSubtitlesTaskResult = BatchSmartSubtitlesResult()
            self._SmartSubtitlesTaskResult._deserialize(params.get("SmartSubtitlesTaskResult"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BeautyConfig(AbstractModel):
    r"""美颜配置

    """

    def __init__(self):
        r"""
        :param _BeautyEffectItems: 美颜效果
        :type BeautyEffectItems: list of BeautyEffectItemConfig
        :param _BeautyFilterItems: 美颜滤镜
        :type BeautyFilterItems: list of BeautyFilterItemConfig
        """
        self._BeautyEffectItems = None
        self._BeautyFilterItems = None

    @property
    def BeautyEffectItems(self):
        r"""美颜效果
        :rtype: list of BeautyEffectItemConfig
        """
        return self._BeautyEffectItems

    @BeautyEffectItems.setter
    def BeautyEffectItems(self, BeautyEffectItems):
        self._BeautyEffectItems = BeautyEffectItems

    @property
    def BeautyFilterItems(self):
        r"""美颜滤镜
        :rtype: list of BeautyFilterItemConfig
        """
        return self._BeautyFilterItems

    @BeautyFilterItems.setter
    def BeautyFilterItems(self, BeautyFilterItems):
        self._BeautyFilterItems = BeautyFilterItems


    def _deserialize(self, params):
        if params.get("BeautyEffectItems") is not None:
            self._BeautyEffectItems = []
            for item in params.get("BeautyEffectItems"):
                obj = BeautyEffectItemConfig()
                obj._deserialize(item)
                self._BeautyEffectItems.append(obj)
        if params.get("BeautyFilterItems") is not None:
            self._BeautyFilterItems = []
            for item in params.get("BeautyFilterItems"):
                obj = BeautyFilterItemConfig()
                obj._deserialize(item)
                self._BeautyFilterItems.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BeautyEffectItemConfig(AbstractModel):
    r"""美颜效果配置项

    """

    def __init__(self):
        r"""
        :param _Type: 类型名称。取值如下：
<li>Whiten：美白</li>
<li>BlackAlpha1：美黑</li>
<li>BlackAlpha2：较强美黑</li>
<li>FoundationAlpha2：美白-粉白</li>
<li>Clear：清晰度</li>
<li>Sharpen：锐化</li>
<li>Smooth：磨皮</li>
<li>BeautyThinFace：瘦脸</li>
<li>NatureFace：自然脸型</li>
<li>VFace：V脸</li>
<li>EnlargeEye：大眼</li>
<li>EyeLighten：亮眼</li>
<li>RemoveEyeBags：祛眼袋</li>
<li>ThinNose：瘦鼻</li>
<li>RemoveLawLine：祛法令纹</li>
<li>CheekboneThin：瘦颧骨</li>
<li>FaceFeatureLipsLut：口红</li>
<li>ToothWhiten：牙齿美白</li>
<li>FaceFeatureSoftlight：柔光</li>
<li>Makeup：美妆</li>
        :type Type: str
        :param _Switch: 能力配置开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
默认值：ON。
        :type Switch: str
        :param _Value: 效果强度，值范围：[0, 100]。
        :type Value: int
        :param _ResourcePath: 附加资源路径。
        :type ResourcePath: str
        :param _ExtInfo: 自定义参数。
        :type ExtInfo: str
        """
        self._Type = None
        self._Switch = None
        self._Value = None
        self._ResourcePath = None
        self._ExtInfo = None

    @property
    def Type(self):
        r"""类型名称。取值如下：
<li>Whiten：美白</li>
<li>BlackAlpha1：美黑</li>
<li>BlackAlpha2：较强美黑</li>
<li>FoundationAlpha2：美白-粉白</li>
<li>Clear：清晰度</li>
<li>Sharpen：锐化</li>
<li>Smooth：磨皮</li>
<li>BeautyThinFace：瘦脸</li>
<li>NatureFace：自然脸型</li>
<li>VFace：V脸</li>
<li>EnlargeEye：大眼</li>
<li>EyeLighten：亮眼</li>
<li>RemoveEyeBags：祛眼袋</li>
<li>ThinNose：瘦鼻</li>
<li>RemoveLawLine：祛法令纹</li>
<li>CheekboneThin：瘦颧骨</li>
<li>FaceFeatureLipsLut：口红</li>
<li>ToothWhiten：牙齿美白</li>
<li>FaceFeatureSoftlight：柔光</li>
<li>Makeup：美妆</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Switch(self):
        r"""能力配置开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
默认值：ON。
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Value(self):
        r"""效果强度，值范围：[0, 100]。
        :rtype: int
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value

    @property
    def ResourcePath(self):
        r"""附加资源路径。
        :rtype: str
        """
        return self._ResourcePath

    @ResourcePath.setter
    def ResourcePath(self, ResourcePath):
        self._ResourcePath = ResourcePath

    @property
    def ExtInfo(self):
        r"""自定义参数。
        :rtype: str
        """
        return self._ExtInfo

    @ExtInfo.setter
    def ExtInfo(self, ExtInfo):
        self._ExtInfo = ExtInfo


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Switch = params.get("Switch")
        self._Value = params.get("Value")
        self._ResourcePath = params.get("ResourcePath")
        self._ExtInfo = params.get("ExtInfo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BeautyFilterItemConfig(AbstractModel):
    r"""美颜滤镜配置项

    """

    def __init__(self):
        r"""
        :param _Type: 类型名称。取值如下：

<li>Dongjing：东京</li>
<li>Qingjiaopian：轻胶片</li>
<li>Meiwei：美味</li>
        :type Type: str
        :param _Switch: 能力配置开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
默认值：ON。
        :type Switch: str
        :param _Value: 效果强度，值范围：[-100, 100]。
        :type Value: int
        """
        self._Type = None
        self._Switch = None
        self._Value = None

    @property
    def Type(self):
        r"""类型名称。取值如下：

<li>Dongjing：东京</li>
<li>Qingjiaopian：轻胶片</li>
<li>Meiwei：美味</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Switch(self):
        r"""能力配置开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
默认值：ON。
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Value(self):
        r"""效果强度，值范围：[-100, 100]。
        :rtype: int
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Switch = params.get("Switch")
        self._Value = params.get("Value")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BlindWatermarkConfig(AbstractModel):
    r"""盲水印配置

    """

    def __init__(self):
        r"""
        :param _AddBlindWatermark: 增加盲水印
注意：此字段可能返回 null，表示取不到有效值。
        :type AddBlindWatermark: :class:`tencentcloud.mps.v20190612.models.AddBlindWatermarkConfig`
        :param _ExtractBlindWatermark: 提取盲水印
注意：此字段可能返回 null，表示取不到有效值。
        :type ExtractBlindWatermark: :class:`tencentcloud.mps.v20190612.models.ExtractBlindWatermarkConfig`
        :param _RemoveBlindWatermark: 移除盲水印
注意：此字段可能返回 null，表示取不到有效值。
        :type RemoveBlindWatermark: :class:`tencentcloud.mps.v20190612.models.RemoveBlindWatermarkConfig`
        """
        self._AddBlindWatermark = None
        self._ExtractBlindWatermark = None
        self._RemoveBlindWatermark = None

    @property
    def AddBlindWatermark(self):
        r"""增加盲水印
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AddBlindWatermarkConfig`
        """
        return self._AddBlindWatermark

    @AddBlindWatermark.setter
    def AddBlindWatermark(self, AddBlindWatermark):
        self._AddBlindWatermark = AddBlindWatermark

    @property
    def ExtractBlindWatermark(self):
        r"""提取盲水印
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.ExtractBlindWatermarkConfig`
        """
        return self._ExtractBlindWatermark

    @ExtractBlindWatermark.setter
    def ExtractBlindWatermark(self, ExtractBlindWatermark):
        self._ExtractBlindWatermark = ExtractBlindWatermark

    @property
    def RemoveBlindWatermark(self):
        r"""移除盲水印
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.RemoveBlindWatermarkConfig`
        """
        return self._RemoveBlindWatermark

    @RemoveBlindWatermark.setter
    def RemoveBlindWatermark(self, RemoveBlindWatermark):
        self._RemoveBlindWatermark = RemoveBlindWatermark


    def _deserialize(self, params):
        if params.get("AddBlindWatermark") is not None:
            self._AddBlindWatermark = AddBlindWatermarkConfig()
            self._AddBlindWatermark._deserialize(params.get("AddBlindWatermark"))
        if params.get("ExtractBlindWatermark") is not None:
            self._ExtractBlindWatermark = ExtractBlindWatermarkConfig()
            self._ExtractBlindWatermark._deserialize(params.get("ExtractBlindWatermark"))
        if params.get("RemoveBlindWatermark") is not None:
            self._RemoveBlindWatermark = RemoveBlindWatermarkConfig()
            self._RemoveBlindWatermark._deserialize(params.get("RemoveBlindWatermark"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BlindWatermarkEmbedInfo(AbstractModel):
    r"""嵌入盲水印配置

    """

    def __init__(self):
        r"""
        :param _EmbedText: 盲水印文字，经过URL安全的Base64编码的4Byte数据。Base64解码之后，少于4Byte将会填充0x00到4Byte，超过4Byte将会截断为4Byte。
注意：此字段可能返回 null，表示取不到有效值。
        :type EmbedText: str
        """
        self._EmbedText = None

    @property
    def EmbedText(self):
        r"""盲水印文字，经过URL安全的Base64编码的4Byte数据。Base64解码之后，少于4Byte将会填充0x00到4Byte，超过4Byte将会截断为4Byte。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._EmbedText

    @EmbedText.setter
    def EmbedText(self, EmbedText):
        self._EmbedText = EmbedText


    def _deserialize(self, params):
        self._EmbedText = params.get("EmbedText")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BlindWatermarkInput(AbstractModel):
    r"""媒体处理任务中的数字水印参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 数字水印模板ID
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""数字水印模板ID
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BlindWatermarkTemplate(AbstractModel):
    r"""数字水印模板详情

    """

    def __init__(self):
        r"""
        :param _Definition: 数字水印模板唯一标识。
        :type Definition: int
        :param _Type: 数字水印类型，可选值：<li>blind-basic：基础版权数字水印；</li><li>blind-nagra：NAGRA取证水印；</li>
        :type Type: str
        :param _Name: 数字水印模板名称。
        :type Name: str
        :param _TextContent: 数字水印模板文本内容，长度不超过64个字符。
        :type TextContent: str
        :param _Comment: 数字水印模板描述信息。
        :type Comment: str
        :param _CreateTime: 数字水印模板创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :type CreateTime: str
        :param _UpdateTime: 数字水印模板最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :type UpdateTime: str
        """
        self._Definition = None
        self._Type = None
        self._Name = None
        self._TextContent = None
        self._Comment = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def Definition(self):
        r"""数字水印模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Type(self):
        r"""数字水印类型，可选值：<li>blind-basic：基础版权数字水印；</li><li>blind-nagra：NAGRA取证水印；</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        r"""数字水印模板名称。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def TextContent(self):
        r"""数字水印模板文本内容，长度不超过64个字符。
        :rtype: str
        """
        return self._TextContent

    @TextContent.setter
    def TextContent(self, TextContent):
        self._TextContent = TextContent

    @property
    def Comment(self):
        r"""数字水印模板描述信息。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def CreateTime(self):
        r"""数字水印模板创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""数字水印模板最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        self._TextContent = params.get("TextContent")
        self._Comment = params.get("Comment")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClassificationConfigureInfo(AbstractModel):
    r"""智能分类任务控制参数

    """

    def __init__(self):
        r"""
        :param _Switch: 智能分类任务开关，可选值：
<li>ON：开启智能分类任务；</li>
<li>OFF：关闭智能分类任务。</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        r"""智能分类任务开关，可选值：
<li>ON：开启智能分类任务；</li>
<li>OFF：关闭智能分类任务。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClassificationConfigureInfoForUpdate(AbstractModel):
    r"""智能分类任务控制参数

    """

    def __init__(self):
        r"""
        :param _Switch: 智能分类任务开关，可选值：
<li>ON：开启智能分类任务；</li>
<li>OFF：关闭智能分类任务。</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        r"""智能分类任务开关，可选值：
<li>ON：开启智能分类任务；</li>
<li>OFF：关闭智能分类任务。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ColorEnhanceConfig(AbstractModel):
    r"""色彩增强配置

    """

    def __init__(self):
        r"""
        :param _Switch: 能力配置开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
默认值：ON。
        :type Switch: str
        :param _Type: 类型，可选值：
<li>weak</li>
<li>normal</li>
<li>strong</li>
默认值：weak。
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: str
        """
        self._Switch = None
        self._Type = None

    @property
    def Switch(self):
        r"""能力配置开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
默认值：ON。
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Type(self):
        r"""类型，可选值：
<li>weak</li>
<li>normal</li>
<li>strong</li>
默认值：weak。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeAudioItem(AbstractModel):
    r"""视频编辑/合成任务 音频元素信息。

    """

    def __init__(self):
        r"""
        :param _SourceMedia: 元素对应媒体信息。
        :type SourceMedia: :class:`tencentcloud.mps.v20190612.models.ComposeSourceMedia`
        :param _TrackTime: 元素在轨道时间轴上的时间信息，不填则紧跟上一个元素。
        :type TrackTime: :class:`tencentcloud.mps.v20190612.models.ComposeTrackTime`
        :param _AudioOperations: 对音频进行操作，如静音等。
        :type AudioOperations: list of ComposeAudioOperation
        """
        self._SourceMedia = None
        self._TrackTime = None
        self._AudioOperations = None

    @property
    def SourceMedia(self):
        r"""元素对应媒体信息。
        :rtype: :class:`tencentcloud.mps.v20190612.models.ComposeSourceMedia`
        """
        return self._SourceMedia

    @SourceMedia.setter
    def SourceMedia(self, SourceMedia):
        self._SourceMedia = SourceMedia

    @property
    def TrackTime(self):
        r"""元素在轨道时间轴上的时间信息，不填则紧跟上一个元素。
        :rtype: :class:`tencentcloud.mps.v20190612.models.ComposeTrackTime`
        """
        return self._TrackTime

    @TrackTime.setter
    def TrackTime(self, TrackTime):
        self._TrackTime = TrackTime

    @property
    def AudioOperations(self):
        r"""对音频进行操作，如静音等。
        :rtype: list of ComposeAudioOperation
        """
        return self._AudioOperations

    @AudioOperations.setter
    def AudioOperations(self, AudioOperations):
        self._AudioOperations = AudioOperations


    def _deserialize(self, params):
        if params.get("SourceMedia") is not None:
            self._SourceMedia = ComposeSourceMedia()
            self._SourceMedia._deserialize(params.get("SourceMedia"))
        if params.get("TrackTime") is not None:
            self._TrackTime = ComposeTrackTime()
            self._TrackTime._deserialize(params.get("TrackTime"))
        if params.get("AudioOperations") is not None:
            self._AudioOperations = []
            for item in params.get("AudioOperations"):
                obj = ComposeAudioOperation()
                obj._deserialize(item)
                self._AudioOperations.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeAudioOperation(AbstractModel):
    r"""视频编辑/合成任务 音频操作。

    """

    def __init__(self):
        r"""
        :param _Type: 音频操作类型，取值有：
<li>Volume：音量调节。</li>
        :type Type: str
        :param _Volume:  当 Type = Volume 时有效。音量调节参数，取值范围: 0~5。 
<li>0 表示静音。</li>
<li>小于1 表示降低音量。</li>
<li>1 表示不变。</li>
<li>大于1表示升高音量。</li>
        :type Volume: float
        """
        self._Type = None
        self._Volume = None

    @property
    def Type(self):
        r"""音频操作类型，取值有：
<li>Volume：音量调节。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Volume(self):
        r""" 当 Type = Volume 时有效。音量调节参数，取值范围: 0~5。 
<li>0 表示静音。</li>
<li>小于1 表示降低音量。</li>
<li>1 表示不变。</li>
<li>大于1表示升高音量。</li>
        :rtype: float
        """
        return self._Volume

    @Volume.setter
    def Volume(self, Volume):
        self._Volume = Volume


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Volume = params.get("Volume")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeAudioStream(AbstractModel):
    r"""视频编辑/合成任务 音频流信息。

    """

    def __init__(self):
        r"""
        :param _Codec: 音频流的编码方式，可选值：
<li>AAC：AAC 编码（默认），用于容器为 mp4。</li>
<li>MP3：mp3 编码，用于容器为 mp3。</li>
        :type Codec: str
        :param _SampleRate: 音频流的采样率，单位：Hz，可选值：
<li>16000（默认）</li>
<li>32000</li>
<li>44100</li>
<li>48000</li>
        :type SampleRate: int
        :param _AudioChannel: 声道数，可选值：
<li>1：单声道 。</li>
<li>2：双声道（默认）。</li>
        :type AudioChannel: int
        :param _Bitrate: 参考码率，单位 kbps，范围：26~10000。
如果设置，编码时会尽量按该码率进行编码。
如果不设置，服务将根据音频参数自动采用合适的码率。
        :type Bitrate: int
        """
        self._Codec = None
        self._SampleRate = None
        self._AudioChannel = None
        self._Bitrate = None

    @property
    def Codec(self):
        r"""音频流的编码方式，可选值：
<li>AAC：AAC 编码（默认），用于容器为 mp4。</li>
<li>MP3：mp3 编码，用于容器为 mp3。</li>
        :rtype: str
        """
        return self._Codec

    @Codec.setter
    def Codec(self, Codec):
        self._Codec = Codec

    @property
    def SampleRate(self):
        r"""音频流的采样率，单位：Hz，可选值：
<li>16000（默认）</li>
<li>32000</li>
<li>44100</li>
<li>48000</li>
        :rtype: int
        """
        return self._SampleRate

    @SampleRate.setter
    def SampleRate(self, SampleRate):
        self._SampleRate = SampleRate

    @property
    def AudioChannel(self):
        r"""声道数，可选值：
<li>1：单声道 。</li>
<li>2：双声道（默认）。</li>
        :rtype: int
        """
        return self._AudioChannel

    @AudioChannel.setter
    def AudioChannel(self, AudioChannel):
        self._AudioChannel = AudioChannel

    @property
    def Bitrate(self):
        r"""参考码率，单位 kbps，范围：26~10000。
如果设置，编码时会尽量按该码率进行编码。
如果不设置，服务将根据音频参数自动采用合适的码率。
        :rtype: int
        """
        return self._Bitrate

    @Bitrate.setter
    def Bitrate(self, Bitrate):
        self._Bitrate = Bitrate


    def _deserialize(self, params):
        self._Codec = params.get("Codec")
        self._SampleRate = params.get("SampleRate")
        self._AudioChannel = params.get("AudioChannel")
        self._Bitrate = params.get("Bitrate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeCanvas(AbstractModel):
    r"""视频编辑/合成任务画布信息。

    """

    def __init__(self):
        r"""
        :param _Color: 背景颜色对应的 RGB 参考值，取值格式： #RRGGBB，如 #F0F0F0 。 
默认值：#000000（黑色）。
        :type Color: str
        :param _Width: 画布宽度，即输出视频的宽度，取值范围：0~ 3840，单位：px。  
默认值：0，表示和第一个视频宽度一致。
        :type Width: int
        :param _Height: 画布高度，即输出视频的高度，取值范围：0~ 3840，单位：px。  
默认值：0，表示和第一个视频高度一致。
        :type Height: int
        """
        self._Color = None
        self._Width = None
        self._Height = None

    @property
    def Color(self):
        r"""背景颜色对应的 RGB 参考值，取值格式： #RRGGBB，如 #F0F0F0 。 
默认值：#000000（黑色）。
        :rtype: str
        """
        return self._Color

    @Color.setter
    def Color(self, Color):
        self._Color = Color

    @property
    def Width(self):
        r"""画布宽度，即输出视频的宽度，取值范围：0~ 3840，单位：px。  
默认值：0，表示和第一个视频宽度一致。
        :rtype: int
        """
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        r"""画布高度，即输出视频的高度，取值范围：0~ 3840，单位：px。  
默认值：0，表示和第一个视频高度一致。
        :rtype: int
        """
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height


    def _deserialize(self, params):
        self._Color = params.get("Color")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeEmptyItem(AbstractModel):
    r"""视频编辑/合成任务 空白占位元素信息。

    """

    def __init__(self):
        r"""
        :param _Duration: 元素时长，时间支持：
<li>以 s 结尾，表示时间点单位为秒，如 3.5s 表示时间点为第3.5秒。</li>
        :type Duration: str
        """
        self._Duration = None

    @property
    def Duration(self):
        r"""元素时长，时间支持：
<li>以 s 结尾，表示时间点单位为秒，如 3.5s 表示时间点为第3.5秒。</li>
        :rtype: str
        """
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration


    def _deserialize(self, params):
        self._Duration = params.get("Duration")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeImageItem(AbstractModel):
    r"""视频编辑/合成任务 图片元素信息。

    """

    def __init__(self):
        r"""
        :param _SourceMedia: 元素对应媒体信息。
        :type SourceMedia: :class:`tencentcloud.mps.v20190612.models.ComposeSourceMedia`
        :param _TrackTime: 元素在轨道时间轴上的时间信息，不填则紧跟上一个元素。
        :type TrackTime: :class:`tencentcloud.mps.v20190612.models.ComposeTrackTime`
        :param _XPos: 元素中心点距离画布原点的水平位置。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示元素 XPos 为画布宽度指定百分比的位置，如 10% 表示 XPos 为画布宽度的 10%。</li>
<li>当字符串以 px 结尾，表示元素 XPos 单位为像素，如 100px 表示 XPos 为100像素。</li>
默认：50%。
        :type XPos: str
        :param _YPos: 元素中心点距离画布原点的垂直位置。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示元素 YPos 为画布高度指定百分比的位置，如 10% 表示 YPos 为画布高度的 10%。</li>
<li>当字符串以 px 结尾，表示元素 YPos 单位为像素，如 100px 表示 YPos 为100像素。</li>
默认：50%。
        :type YPos: str
        :param _Width: 视频片段的宽度。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示元素 Width 为画布宽度的百分比大小，如 10% 表示 Width 为画布宽度的 10%。</li>
<li>当字符串以 px 结尾，表示元素 Width 单位为像素，如 100px 表示 Width 为100像素。</li>
为空（或0） 的场景：
<li>当 Width、Height 均为空，则 Width 和 Height 取源素材本身的 Width、Height。</li>
<li>当 Width 为空，Height 非空，则 Width 按源素材比例缩放。</li>
<li>当 Width 非空，Height 为空，则 Height 按源素材比例缩放。</li>
        :type Width: str
        :param _Height: 元素的高度。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示元素 Height 为画布高度的百分比大小，如 10% 表示 Height 为画布高度的 10%。</li>
<li>当字符串以 px 结尾，表示元素 Height 单位为像素，如 100px 表示 Height 为100像素。</li>
为空（或0） 的场景：
<li>当 Width、Height 均为空，则 Width 和 Height 取源素材本身的 Width、Height。</li>
<li>当 Width 为空，Height 非空，则 Width 按源素材比例缩放。</li>
<li>当 Width 非空，Height 为空，则 Height 按源素材比例缩放。</li>
        :type Height: str
        :param _ImageOperations: 对图像画面进行的操作，如图像旋转等。
        :type ImageOperations: list of ComposeImageOperation
        """
        self._SourceMedia = None
        self._TrackTime = None
        self._XPos = None
        self._YPos = None
        self._Width = None
        self._Height = None
        self._ImageOperations = None

    @property
    def SourceMedia(self):
        r"""元素对应媒体信息。
        :rtype: :class:`tencentcloud.mps.v20190612.models.ComposeSourceMedia`
        """
        return self._SourceMedia

    @SourceMedia.setter
    def SourceMedia(self, SourceMedia):
        self._SourceMedia = SourceMedia

    @property
    def TrackTime(self):
        r"""元素在轨道时间轴上的时间信息，不填则紧跟上一个元素。
        :rtype: :class:`tencentcloud.mps.v20190612.models.ComposeTrackTime`
        """
        return self._TrackTime

    @TrackTime.setter
    def TrackTime(self, TrackTime):
        self._TrackTime = TrackTime

    @property
    def XPos(self):
        r"""元素中心点距离画布原点的水平位置。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示元素 XPos 为画布宽度指定百分比的位置，如 10% 表示 XPos 为画布宽度的 10%。</li>
<li>当字符串以 px 结尾，表示元素 XPos 单位为像素，如 100px 表示 XPos 为100像素。</li>
默认：50%。
        :rtype: str
        """
        return self._XPos

    @XPos.setter
    def XPos(self, XPos):
        self._XPos = XPos

    @property
    def YPos(self):
        r"""元素中心点距离画布原点的垂直位置。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示元素 YPos 为画布高度指定百分比的位置，如 10% 表示 YPos 为画布高度的 10%。</li>
<li>当字符串以 px 结尾，表示元素 YPos 单位为像素，如 100px 表示 YPos 为100像素。</li>
默认：50%。
        :rtype: str
        """
        return self._YPos

    @YPos.setter
    def YPos(self, YPos):
        self._YPos = YPos

    @property
    def Width(self):
        r"""视频片段的宽度。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示元素 Width 为画布宽度的百分比大小，如 10% 表示 Width 为画布宽度的 10%。</li>
<li>当字符串以 px 结尾，表示元素 Width 单位为像素，如 100px 表示 Width 为100像素。</li>
为空（或0） 的场景：
<li>当 Width、Height 均为空，则 Width 和 Height 取源素材本身的 Width、Height。</li>
<li>当 Width 为空，Height 非空，则 Width 按源素材比例缩放。</li>
<li>当 Width 非空，Height 为空，则 Height 按源素材比例缩放。</li>
        :rtype: str
        """
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        r"""元素的高度。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示元素 Height 为画布高度的百分比大小，如 10% 表示 Height 为画布高度的 10%。</li>
<li>当字符串以 px 结尾，表示元素 Height 单位为像素，如 100px 表示 Height 为100像素。</li>
为空（或0） 的场景：
<li>当 Width、Height 均为空，则 Width 和 Height 取源素材本身的 Width、Height。</li>
<li>当 Width 为空，Height 非空，则 Width 按源素材比例缩放。</li>
<li>当 Width 非空，Height 为空，则 Height 按源素材比例缩放。</li>
        :rtype: str
        """
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ImageOperations(self):
        r"""对图像画面进行的操作，如图像旋转等。
        :rtype: list of ComposeImageOperation
        """
        return self._ImageOperations

    @ImageOperations.setter
    def ImageOperations(self, ImageOperations):
        self._ImageOperations = ImageOperations


    def _deserialize(self, params):
        if params.get("SourceMedia") is not None:
            self._SourceMedia = ComposeSourceMedia()
            self._SourceMedia._deserialize(params.get("SourceMedia"))
        if params.get("TrackTime") is not None:
            self._TrackTime = ComposeTrackTime()
            self._TrackTime._deserialize(params.get("TrackTime"))
        self._XPos = params.get("XPos")
        self._YPos = params.get("YPos")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        if params.get("ImageOperations") is not None:
            self._ImageOperations = []
            for item in params.get("ImageOperations"):
                obj = ComposeImageOperation()
                obj._deserialize(item)
                self._ImageOperations.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeImageOperation(AbstractModel):
    r"""视频编辑/合成任务 视频图像转换操作。

    """

    def __init__(self):
        r"""
        :param _Type: 类型，取值有：
<li>Rotate：图像旋转。</li>
<li>Flip：图像翻转。</li>
        :type Type: str
        :param _RotateAngle: 当 Type = Rotate 时有效。图像以中心点为原点进行旋转的角度，取值范围0~360。
        :type RotateAngle: float
        :param _FlipType: 当 Type = Flip 时有效。图像翻转动作，取值有： 
<li>Horizental：水平翻转，即左右镜像。</li>
<li>Vertical：垂直翻转，即上下镜像。</li>
        :type FlipType: str
        """
        self._Type = None
        self._RotateAngle = None
        self._FlipType = None

    @property
    def Type(self):
        r"""类型，取值有：
<li>Rotate：图像旋转。</li>
<li>Flip：图像翻转。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def RotateAngle(self):
        r"""当 Type = Rotate 时有效。图像以中心点为原点进行旋转的角度，取值范围0~360。
        :rtype: float
        """
        return self._RotateAngle

    @RotateAngle.setter
    def RotateAngle(self, RotateAngle):
        self._RotateAngle = RotateAngle

    @property
    def FlipType(self):
        r"""当 Type = Flip 时有效。图像翻转动作，取值有： 
<li>Horizental：水平翻转，即左右镜像。</li>
<li>Vertical：垂直翻转，即上下镜像。</li>
        :rtype: str
        """
        return self._FlipType

    @FlipType.setter
    def FlipType(self, FlipType):
        self._FlipType = FlipType


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._RotateAngle = params.get("RotateAngle")
        self._FlipType = params.get("FlipType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeMediaConfig(AbstractModel):
    r"""视频编辑/合成任务 信息。

    关于 轨道、元素、时间轴 关系示意图：

    ![image](https://ie-mps-1258344699.cos.ap-nanjing.tencentcos.cn/common/cloud/EditMedia-Compose-Track-Item.png)

    """

    def __init__(self):
        r"""
        :param _TargetInfo: 合成目标视频信息。
        :type TargetInfo: :class:`tencentcloud.mps.v20190612.models.ComposeTargetInfo`
        :param _Canvas: 合成目标视频的画布信息。
        :type Canvas: :class:`tencentcloud.mps.v20190612.models.ComposeCanvas`
        :param _Styles: 全局样式，和轨道 Tracks 配合使用，用于定于样式，如字幕样式。
        :type Styles: list of ComposeStyles
        :param _Tracks: 用于描述合成视频的轨道列表，包括：视频、音频、图片、文字等元素组成的多个轨道信息。关于轨道和时间：
<ul><li>轨道时间轴即为目标视频时间轴。</li><li>时间轴上相同时间点的不同轨道上的元素会重叠：</li><ul><li>视频、图片、文字：按轨道顺序进行图像的叠加，轨道顺序靠前的在上面。</li><li>音频 ：进行混音。</li></ul></ul>注意：同一轨道中各个元素（除字幕元素外）的轨道时间不能重叠。
        :type Tracks: list of ComposeMediaTrack
        """
        self._TargetInfo = None
        self._Canvas = None
        self._Styles = None
        self._Tracks = None

    @property
    def TargetInfo(self):
        r"""合成目标视频信息。
        :rtype: :class:`tencentcloud.mps.v20190612.models.ComposeTargetInfo`
        """
        return self._TargetInfo

    @TargetInfo.setter
    def TargetInfo(self, TargetInfo):
        self._TargetInfo = TargetInfo

    @property
    def Canvas(self):
        r"""合成目标视频的画布信息。
        :rtype: :class:`tencentcloud.mps.v20190612.models.ComposeCanvas`
        """
        return self._Canvas

    @Canvas.setter
    def Canvas(self, Canvas):
        self._Canvas = Canvas

    @property
    def Styles(self):
        r"""全局样式，和轨道 Tracks 配合使用，用于定于样式，如字幕样式。
        :rtype: list of ComposeStyles
        """
        return self._Styles

    @Styles.setter
    def Styles(self, Styles):
        self._Styles = Styles

    @property
    def Tracks(self):
        r"""用于描述合成视频的轨道列表，包括：视频、音频、图片、文字等元素组成的多个轨道信息。关于轨道和时间：
<ul><li>轨道时间轴即为目标视频时间轴。</li><li>时间轴上相同时间点的不同轨道上的元素会重叠：</li><ul><li>视频、图片、文字：按轨道顺序进行图像的叠加，轨道顺序靠前的在上面。</li><li>音频 ：进行混音。</li></ul></ul>注意：同一轨道中各个元素（除字幕元素外）的轨道时间不能重叠。
        :rtype: list of ComposeMediaTrack
        """
        return self._Tracks

    @Tracks.setter
    def Tracks(self, Tracks):
        self._Tracks = Tracks


    def _deserialize(self, params):
        if params.get("TargetInfo") is not None:
            self._TargetInfo = ComposeTargetInfo()
            self._TargetInfo._deserialize(params.get("TargetInfo"))
        if params.get("Canvas") is not None:
            self._Canvas = ComposeCanvas()
            self._Canvas._deserialize(params.get("Canvas"))
        if params.get("Styles") is not None:
            self._Styles = []
            for item in params.get("Styles"):
                obj = ComposeStyles()
                obj._deserialize(item)
                self._Styles.append(obj)
        if params.get("Tracks") is not None:
            self._Tracks = []
            for item in params.get("Tracks"):
                obj = ComposeMediaTrack()
                obj._deserialize(item)
                self._Tracks.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeMediaItem(AbstractModel):
    r"""视频编辑/合成任务 轨道元素信息。

    """

    def __init__(self):
        r"""
        :param _Type: 元素类型。取值有：
<li>Video：视频元素。</li>
<li>Audio：音频元素。</li>
<li>Image：图片元素。</li>
<li>Transition：转场元素。</li>
<li>Subtitle：字幕元素。</li>
<li>Empty：空白元素。</li>
        :type Type: str
        :param _Video: 视频元素，当 Type = Video 时有效。
        :type Video: :class:`tencentcloud.mps.v20190612.models.ComposeVideoItem`
        :param _Audio: 音频元素，当 Type = Audio 时有效。
        :type Audio: :class:`tencentcloud.mps.v20190612.models.ComposeAudioItem`
        :param _Image: 图片元素，当 Type = Image 时有效。
        :type Image: :class:`tencentcloud.mps.v20190612.models.ComposeImageItem`
        :param _Transition: 转场元素，当 Type = Transition 时有效。
        :type Transition: :class:`tencentcloud.mps.v20190612.models.ComposeTransitionItem`
        :param _Subtitle: 字幕元素，当 Type = Subtitle 是有效。
        :type Subtitle: :class:`tencentcloud.mps.v20190612.models.ComposeSubtitleItem`
        :param _Empty: 空白元素，当 Type = Empty 时有效。用于时间轴的占位。
        :type Empty: :class:`tencentcloud.mps.v20190612.models.ComposeEmptyItem`
        """
        self._Type = None
        self._Video = None
        self._Audio = None
        self._Image = None
        self._Transition = None
        self._Subtitle = None
        self._Empty = None

    @property
    def Type(self):
        r"""元素类型。取值有：
<li>Video：视频元素。</li>
<li>Audio：音频元素。</li>
<li>Image：图片元素。</li>
<li>Transition：转场元素。</li>
<li>Subtitle：字幕元素。</li>
<li>Empty：空白元素。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Video(self):
        r"""视频元素，当 Type = Video 时有效。
        :rtype: :class:`tencentcloud.mps.v20190612.models.ComposeVideoItem`
        """
        return self._Video

    @Video.setter
    def Video(self, Video):
        self._Video = Video

    @property
    def Audio(self):
        r"""音频元素，当 Type = Audio 时有效。
        :rtype: :class:`tencentcloud.mps.v20190612.models.ComposeAudioItem`
        """
        return self._Audio

    @Audio.setter
    def Audio(self, Audio):
        self._Audio = Audio

    @property
    def Image(self):
        r"""图片元素，当 Type = Image 时有效。
        :rtype: :class:`tencentcloud.mps.v20190612.models.ComposeImageItem`
        """
        return self._Image

    @Image.setter
    def Image(self, Image):
        self._Image = Image

    @property
    def Transition(self):
        r"""转场元素，当 Type = Transition 时有效。
        :rtype: :class:`tencentcloud.mps.v20190612.models.ComposeTransitionItem`
        """
        return self._Transition

    @Transition.setter
    def Transition(self, Transition):
        self._Transition = Transition

    @property
    def Subtitle(self):
        r"""字幕元素，当 Type = Subtitle 是有效。
        :rtype: :class:`tencentcloud.mps.v20190612.models.ComposeSubtitleItem`
        """
        return self._Subtitle

    @Subtitle.setter
    def Subtitle(self, Subtitle):
        self._Subtitle = Subtitle

    @property
    def Empty(self):
        r"""空白元素，当 Type = Empty 时有效。用于时间轴的占位。
        :rtype: :class:`tencentcloud.mps.v20190612.models.ComposeEmptyItem`
        """
        return self._Empty

    @Empty.setter
    def Empty(self, Empty):
        self._Empty = Empty


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("Video") is not None:
            self._Video = ComposeVideoItem()
            self._Video._deserialize(params.get("Video"))
        if params.get("Audio") is not None:
            self._Audio = ComposeAudioItem()
            self._Audio._deserialize(params.get("Audio"))
        if params.get("Image") is not None:
            self._Image = ComposeImageItem()
            self._Image._deserialize(params.get("Image"))
        if params.get("Transition") is not None:
            self._Transition = ComposeTransitionItem()
            self._Transition._deserialize(params.get("Transition"))
        if params.get("Subtitle") is not None:
            self._Subtitle = ComposeSubtitleItem()
            self._Subtitle._deserialize(params.get("Subtitle"))
        if params.get("Empty") is not None:
            self._Empty = ComposeEmptyItem()
            self._Empty._deserialize(params.get("Empty"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeMediaTrack(AbstractModel):
    r"""视频编辑/合成任务 轨道信息。

    """

    def __init__(self):
        r"""
        :param _Type: 轨道类型，取值有：<ul><li>Video ：视频轨道。视频轨道可由以下元素组成：</li><ul><li>Video 元素</li><li>Image 元素</li><li>Transition 元素</li><li>Empty 元素</li></ul><li>Audio ：音频轨道。音频轨道可由以下元素组成：</li><ul><li>Audio 元素</li><li>Transition 元素</li><li>Empty 元素</li></ul><li>Title：文字轨道。文字轨道可由以下元素组成：</li><ul><li>Subtitle 元素</li></ul></ul>
        :type Type: str
        :param _Items: 轨道上的元素列表。
        :type Items: list of ComposeMediaItem
        """
        self._Type = None
        self._Items = None

    @property
    def Type(self):
        r"""轨道类型，取值有：<ul><li>Video ：视频轨道。视频轨道可由以下元素组成：</li><ul><li>Video 元素</li><li>Image 元素</li><li>Transition 元素</li><li>Empty 元素</li></ul><li>Audio ：音频轨道。音频轨道可由以下元素组成：</li><ul><li>Audio 元素</li><li>Transition 元素</li><li>Empty 元素</li></ul><li>Title：文字轨道。文字轨道可由以下元素组成：</li><ul><li>Subtitle 元素</li></ul></ul>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Items(self):
        r"""轨道上的元素列表。
        :rtype: list of ComposeMediaItem
        """
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = ComposeMediaItem()
                obj._deserialize(item)
                self._Items.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeSourceMedia(AbstractModel):
    r"""视频编辑/合成任务  媒体素材源信息。

    """

    def __init__(self):
        r"""
        :param _FileId: 媒体对应的素材ID，即 FileInfos 列表中对应素材的 ID。
        :type FileId: str
        :param _StartTime: 媒体位于素材的起始时间，时间点支持 s、% 两种格式：
<li>当字符串以 s 结尾，表示时间点单位为秒，如 3.5s 表示时间点为第3.5秒；</li>
<li>当字符串以 % 结尾，表示时间点为素材时长的百分比大小，如10%表示时间点为素材第10% 的时刻。</li>
默认：0s
        :type StartTime: str
        :param _EndTime: 媒体位于素材的结束时间，和 StartTime 构成媒体在源素材的时间区间，时间点支持 s、% 两种格式：
<li>当字符串以 s 结尾，表示时间点单位为秒，如 3.5s 表示时间点为第3.5秒；</li>
<li>当字符串以 % 结尾，表示时间点为素材时长的百分比大小，如10%表示时间点为素材第10%的时间。</li>
默认：如果对应轨道时长有设置，则默认轨道时长，否则为素材时长，无时长的素材默认为 1 秒。
注意：至少需要大于 StartTime 0.02 秒。

        :type EndTime: str
        """
        self._FileId = None
        self._StartTime = None
        self._EndTime = None

    @property
    def FileId(self):
        r"""媒体对应的素材ID，即 FileInfos 列表中对应素材的 ID。
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def StartTime(self):
        r"""媒体位于素材的起始时间，时间点支持 s、% 两种格式：
<li>当字符串以 s 结尾，表示时间点单位为秒，如 3.5s 表示时间点为第3.5秒；</li>
<li>当字符串以 % 结尾，表示时间点为素材时长的百分比大小，如10%表示时间点为素材第10% 的时刻。</li>
默认：0s
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""媒体位于素材的结束时间，和 StartTime 构成媒体在源素材的时间区间，时间点支持 s、% 两种格式：
<li>当字符串以 s 结尾，表示时间点单位为秒，如 3.5s 表示时间点为第3.5秒；</li>
<li>当字符串以 % 结尾，表示时间点为素材时长的百分比大小，如10%表示时间点为素材第10%的时间。</li>
默认：如果对应轨道时长有设置，则默认轨道时长，否则为素材时长，无时长的素材默认为 1 秒。
注意：至少需要大于 StartTime 0.02 秒。

        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._FileId = params.get("FileId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeStyles(AbstractModel):
    r"""视频编辑/合成任务 样式信息。

    """

    def __init__(self):
        r"""
        :param _Id: 样式 Id，用于和轨道元素中的样式关联。
注意：允许字母、数字、-、_ 组合，最长 32 字符。
        :type Id: str
        :param _Type: 样式类型，取值有：
<li>Subtitle：字幕样式。</li>
        :type Type: str
        :param _Subtitle: 字幕样式信息，当 Type = Subtitle 时有效。
        :type Subtitle: :class:`tencentcloud.mps.v20190612.models.ComposeSubtitleStyle`
        """
        self._Id = None
        self._Type = None
        self._Subtitle = None

    @property
    def Id(self):
        r"""样式 Id，用于和轨道元素中的样式关联。
注意：允许字母、数字、-、_ 组合，最长 32 字符。
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Type(self):
        r"""样式类型，取值有：
<li>Subtitle：字幕样式。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Subtitle(self):
        r"""字幕样式信息，当 Type = Subtitle 时有效。
        :rtype: :class:`tencentcloud.mps.v20190612.models.ComposeSubtitleStyle`
        """
        return self._Subtitle

    @Subtitle.setter
    def Subtitle(self, Subtitle):
        self._Subtitle = Subtitle


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Type = params.get("Type")
        if params.get("Subtitle") is not None:
            self._Subtitle = ComposeSubtitleStyle()
            self._Subtitle._deserialize(params.get("Subtitle"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeSubtitleItem(AbstractModel):
    r"""视频编辑/合成任务 字幕元素信息。

    """

    def __init__(self):
        r"""
        :param _StyleId: 字幕样式，Styles 列表中对应的 Subtitle样式的 ID。
        :type StyleId: str
        :param _Text: 字幕文本。<br/>注：长文本可能超出画面范围，建议使用 \n 进行换行。
        :type Text: str
        :param _TrackTime: 元素在轨道时间轴上的时间信息，不填则紧跟上一个元素。	
        :type TrackTime: :class:`tencentcloud.mps.v20190612.models.ComposeTrackTime`
        """
        self._StyleId = None
        self._Text = None
        self._TrackTime = None

    @property
    def StyleId(self):
        r"""字幕样式，Styles 列表中对应的 Subtitle样式的 ID。
        :rtype: str
        """
        return self._StyleId

    @StyleId.setter
    def StyleId(self, StyleId):
        self._StyleId = StyleId

    @property
    def Text(self):
        r"""字幕文本。<br/>注：长文本可能超出画面范围，建议使用 \n 进行换行。
        :rtype: str
        """
        return self._Text

    @Text.setter
    def Text(self, Text):
        self._Text = Text

    @property
    def TrackTime(self):
        r"""元素在轨道时间轴上的时间信息，不填则紧跟上一个元素。	
        :rtype: :class:`tencentcloud.mps.v20190612.models.ComposeTrackTime`
        """
        return self._TrackTime

    @TrackTime.setter
    def TrackTime(self, TrackTime):
        self._TrackTime = TrackTime


    def _deserialize(self, params):
        self._StyleId = params.get("StyleId")
        self._Text = params.get("Text")
        if params.get("TrackTime") is not None:
            self._TrackTime = ComposeTrackTime()
            self._TrackTime._deserialize(params.get("TrackTime"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeSubtitleStyle(AbstractModel):
    r"""视频编辑/合成任务 字幕样式。

    """

    def __init__(self):
        r"""
        :param _Height: 字幕高度。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示为画布高度的百分比大小，如 10% 表示为画布高度的 10%。</li>
<li>当字符串以 px 结尾，表示单位为像素，如 100px 表示为100像素。</li>
默认为 FontSize 大小。
        :type Height: str
        :param _MarginBottom: 字幕距离下边框距离，支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示为画布高度的百分比大小，如 10% 表示为画布高度的 10%。</li>
<li>当字符串以 px 结尾，表示单位为像素，如 100px 表示为100像素。</li>
默认：0px
        :type MarginBottom: str
        :param _FontType: 字体类型，支持：
<li>SimHei：黑体（默认）。</li>
<li>SimSun：宋体。</li>
        :type FontType: str
        :param _FontSize: 字体大小，支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示为画布高度的百分比大小，如 10% 表示为画布高度的 10%。</li>
<li>当字符串以 px 结尾，表示单位为像素，如 100px 表示为100像素。</li>
默认：2%
        :type FontSize: str
        :param _FontBold: 是否使用粗体，和字体相关，可选值：
<li>0：否（默认）。</li>
<li>1：是。</li>
        :type FontBold: int
        :param _FontItalic: 是否使用斜体，和字体相关，可选值：
<li>0：否（默认）。</li>
<li>1：是。</li>
        :type FontItalic: int
        :param _FontColor: 字体颜色，格式：#RRGGBBAA。  
默认值：0x000000FF（黑色）。  
注意：其中 AA 部分指的是透明度，为可选。

        :type FontColor: str
        :param _FontAlign: 文字对齐方式：
<li>Center：居中（默认）。</li>
<li>Left：左对齐。</li>
<li>Right：右对齐。</li>
        :type FontAlign: str
        :param _FontAlignMargin: 用于字幕对齐留白：
<li>FontAlign=Left 时，表示距离左边距离。</li>
<li>FontAlign=Right时，表示距离右边距离。</li>
支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示为画布宽度的百分比大小，如 10% 表示为画布宽度的 10%。</li>
<li>当字符串以 px 结尾，表示单位为像素，如 100px 表示为100像素。</li>
        :type FontAlignMargin: str
        :param _BorderWidth: 字体边框宽度，支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示为画布高度的百分比大小，如 10% 表示为画布高度的 10%。</li>
<li>当字符串以 px 结尾，表示单位为像素，如 100px 表示为100像素。</li>
默认： 0，表示不需要边框。
        :type BorderWidth: str
        :param _BorderColor: 边框颜色，当 BorderWidth 不为 0 时生效，其值格式和 FontColor 一致。
        :type BorderColor: str
        :param _BottomColor: 文字底色，其值格式和 FontColor 一致。  
默认为空， 表示不使用底色。
        :type BottomColor: str
        """
        self._Height = None
        self._MarginBottom = None
        self._FontType = None
        self._FontSize = None
        self._FontBold = None
        self._FontItalic = None
        self._FontColor = None
        self._FontAlign = None
        self._FontAlignMargin = None
        self._BorderWidth = None
        self._BorderColor = None
        self._BottomColor = None

    @property
    def Height(self):
        r"""字幕高度。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示为画布高度的百分比大小，如 10% 表示为画布高度的 10%。</li>
<li>当字符串以 px 结尾，表示单位为像素，如 100px 表示为100像素。</li>
默认为 FontSize 大小。
        :rtype: str
        """
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def MarginBottom(self):
        r"""字幕距离下边框距离，支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示为画布高度的百分比大小，如 10% 表示为画布高度的 10%。</li>
<li>当字符串以 px 结尾，表示单位为像素，如 100px 表示为100像素。</li>
默认：0px
        :rtype: str
        """
        return self._MarginBottom

    @MarginBottom.setter
    def MarginBottom(self, MarginBottom):
        self._MarginBottom = MarginBottom

    @property
    def FontType(self):
        r"""字体类型，支持：
<li>SimHei：黑体（默认）。</li>
<li>SimSun：宋体。</li>
        :rtype: str
        """
        return self._FontType

    @FontType.setter
    def FontType(self, FontType):
        self._FontType = FontType

    @property
    def FontSize(self):
        r"""字体大小，支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示为画布高度的百分比大小，如 10% 表示为画布高度的 10%。</li>
<li>当字符串以 px 结尾，表示单位为像素，如 100px 表示为100像素。</li>
默认：2%
        :rtype: str
        """
        return self._FontSize

    @FontSize.setter
    def FontSize(self, FontSize):
        self._FontSize = FontSize

    @property
    def FontBold(self):
        r"""是否使用粗体，和字体相关，可选值：
<li>0：否（默认）。</li>
<li>1：是。</li>
        :rtype: int
        """
        return self._FontBold

    @FontBold.setter
    def FontBold(self, FontBold):
        self._FontBold = FontBold

    @property
    def FontItalic(self):
        r"""是否使用斜体，和字体相关，可选值：
<li>0：否（默认）。</li>
<li>1：是。</li>
        :rtype: int
        """
        return self._FontItalic

    @FontItalic.setter
    def FontItalic(self, FontItalic):
        self._FontItalic = FontItalic

    @property
    def FontColor(self):
        r"""字体颜色，格式：#RRGGBBAA。  
默认值：0x000000FF（黑色）。  
注意：其中 AA 部分指的是透明度，为可选。

        :rtype: str
        """
        return self._FontColor

    @FontColor.setter
    def FontColor(self, FontColor):
        self._FontColor = FontColor

    @property
    def FontAlign(self):
        r"""文字对齐方式：
<li>Center：居中（默认）。</li>
<li>Left：左对齐。</li>
<li>Right：右对齐。</li>
        :rtype: str
        """
        return self._FontAlign

    @FontAlign.setter
    def FontAlign(self, FontAlign):
        self._FontAlign = FontAlign

    @property
    def FontAlignMargin(self):
        r"""用于字幕对齐留白：
<li>FontAlign=Left 时，表示距离左边距离。</li>
<li>FontAlign=Right时，表示距离右边距离。</li>
支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示为画布宽度的百分比大小，如 10% 表示为画布宽度的 10%。</li>
<li>当字符串以 px 结尾，表示单位为像素，如 100px 表示为100像素。</li>
        :rtype: str
        """
        return self._FontAlignMargin

    @FontAlignMargin.setter
    def FontAlignMargin(self, FontAlignMargin):
        self._FontAlignMargin = FontAlignMargin

    @property
    def BorderWidth(self):
        r"""字体边框宽度，支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示为画布高度的百分比大小，如 10% 表示为画布高度的 10%。</li>
<li>当字符串以 px 结尾，表示单位为像素，如 100px 表示为100像素。</li>
默认： 0，表示不需要边框。
        :rtype: str
        """
        return self._BorderWidth

    @BorderWidth.setter
    def BorderWidth(self, BorderWidth):
        self._BorderWidth = BorderWidth

    @property
    def BorderColor(self):
        r"""边框颜色，当 BorderWidth 不为 0 时生效，其值格式和 FontColor 一致。
        :rtype: str
        """
        return self._BorderColor

    @BorderColor.setter
    def BorderColor(self, BorderColor):
        self._BorderColor = BorderColor

    @property
    def BottomColor(self):
        r"""文字底色，其值格式和 FontColor 一致。  
默认为空， 表示不使用底色。
        :rtype: str
        """
        return self._BottomColor

    @BottomColor.setter
    def BottomColor(self, BottomColor):
        self._BottomColor = BottomColor


    def _deserialize(self, params):
        self._Height = params.get("Height")
        self._MarginBottom = params.get("MarginBottom")
        self._FontType = params.get("FontType")
        self._FontSize = params.get("FontSize")
        self._FontBold = params.get("FontBold")
        self._FontItalic = params.get("FontItalic")
        self._FontColor = params.get("FontColor")
        self._FontAlign = params.get("FontAlign")
        self._FontAlignMargin = params.get("FontAlignMargin")
        self._BorderWidth = params.get("BorderWidth")
        self._BorderColor = params.get("BorderColor")
        self._BottomColor = params.get("BottomColor")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeTargetInfo(AbstractModel):
    r"""视频编辑/合成任务 目标视频信息。

    """

    def __init__(self):
        r"""
        :param _Container: 封装容器格式，可选值：
<li>mp4：视频文件（默认）。</li>
<li>mp3：纯音频文件。</li>
        :type Container: str
        :param _RemoveVideo: 是否去除视频数据，可选值：
<li>0：保留（默认）。</li>
<li>1：去除。</li>
        :type RemoveVideo: int
        :param _RemoveAudio: 是否去除音频数据，可选值：
<li>0：保留（默认）。</li>
<li>1：去除。</li>
        :type RemoveAudio: int
        :param _VideoStream: 输出视频流信息。
        :type VideoStream: :class:`tencentcloud.mps.v20190612.models.ComposeVideoStream`
        :param _AudioStream: 输出音频流信息。
        :type AudioStream: :class:`tencentcloud.mps.v20190612.models.ComposeAudioStream`
        """
        self._Container = None
        self._RemoveVideo = None
        self._RemoveAudio = None
        self._VideoStream = None
        self._AudioStream = None

    @property
    def Container(self):
        r"""封装容器格式，可选值：
<li>mp4：视频文件（默认）。</li>
<li>mp3：纯音频文件。</li>
        :rtype: str
        """
        return self._Container

    @Container.setter
    def Container(self, Container):
        self._Container = Container

    @property
    def RemoveVideo(self):
        r"""是否去除视频数据，可选值：
<li>0：保留（默认）。</li>
<li>1：去除。</li>
        :rtype: int
        """
        return self._RemoveVideo

    @RemoveVideo.setter
    def RemoveVideo(self, RemoveVideo):
        self._RemoveVideo = RemoveVideo

    @property
    def RemoveAudio(self):
        r"""是否去除音频数据，可选值：
<li>0：保留（默认）。</li>
<li>1：去除。</li>
        :rtype: int
        """
        return self._RemoveAudio

    @RemoveAudio.setter
    def RemoveAudio(self, RemoveAudio):
        self._RemoveAudio = RemoveAudio

    @property
    def VideoStream(self):
        r"""输出视频流信息。
        :rtype: :class:`tencentcloud.mps.v20190612.models.ComposeVideoStream`
        """
        return self._VideoStream

    @VideoStream.setter
    def VideoStream(self, VideoStream):
        self._VideoStream = VideoStream

    @property
    def AudioStream(self):
        r"""输出音频流信息。
        :rtype: :class:`tencentcloud.mps.v20190612.models.ComposeAudioStream`
        """
        return self._AudioStream

    @AudioStream.setter
    def AudioStream(self, AudioStream):
        self._AudioStream = AudioStream


    def _deserialize(self, params):
        self._Container = params.get("Container")
        self._RemoveVideo = params.get("RemoveVideo")
        self._RemoveAudio = params.get("RemoveAudio")
        if params.get("VideoStream") is not None:
            self._VideoStream = ComposeVideoStream()
            self._VideoStream._deserialize(params.get("VideoStream"))
        if params.get("AudioStream") is not None:
            self._AudioStream = ComposeAudioStream()
            self._AudioStream._deserialize(params.get("AudioStream"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeTrackTime(AbstractModel):
    r"""视频编辑/合成任务 对应元素在目标视频轨道上的时间信息。

    """

    def __init__(self):
        r"""
        :param _Start: 元素在轨道上的起始时间，时间点支持：
<li>以 s 结尾，表示时间点单位为秒，如 3.5s 表示时间点为第3.5秒；</li>
注意：不填则默认为前一个元素的结束时间，此时可以通过 ComposeEmptyItem 元素来进行占位，实现轨道起始时间设置。
        :type Start: str
        :param _Duration: 元素时长，时间支持：
<li>以 s 结尾，表示时间点单位为秒，如 3.5s 表示时间点为第3.5秒；</li>
默认：取对应 ComposeSourceMedia 媒体的有效时长（即 EndTime-StartTime），没有 ComposeSourceMedia 则默认为 1 秒。
        :type Duration: str
        """
        self._Start = None
        self._Duration = None

    @property
    def Start(self):
        r"""元素在轨道上的起始时间，时间点支持：
<li>以 s 结尾，表示时间点单位为秒，如 3.5s 表示时间点为第3.5秒；</li>
注意：不填则默认为前一个元素的结束时间，此时可以通过 ComposeEmptyItem 元素来进行占位，实现轨道起始时间设置。
        :rtype: str
        """
        return self._Start

    @Start.setter
    def Start(self, Start):
        self._Start = Start

    @property
    def Duration(self):
        r"""元素时长，时间支持：
<li>以 s 结尾，表示时间点单位为秒，如 3.5s 表示时间点为第3.5秒；</li>
默认：取对应 ComposeSourceMedia 媒体的有效时长（即 EndTime-StartTime），没有 ComposeSourceMedia 则默认为 1 秒。
        :rtype: str
        """
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration


    def _deserialize(self, params):
        self._Start = params.get("Start")
        self._Duration = params.get("Duration")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeTransitionItem(AbstractModel):
    r"""视频编辑/合成任务 转场元素信息。

    """

    def __init__(self):
        r"""
        :param _Duration: 元素时长，时间支持：<li>以 s 结尾，表示时间点单位为秒，如 3s 表示时间点为第3秒。</li>
默认：1s
注意：
<li>必须是整数s，否则向下取整。</li>
<li>转场 前后必须紧挨着两个不为 Empty 的元素。</li>
<li>转场 Duration 必须小于前一个元素的 Duration，同时必须小于后一个元素的 Duration。</li>
<li>进行转场处理的两个元素，第二个元素在轨道上的起始时间会自动调整为前一个元素的结束时间减去转场的 Duration。</li>
        :type Duration: str
        :param _Transitions: 转场操作列表。
默认：淡入淡出。
注意：图像转场操作和音频转场操作各自最多支持一个。
        :type Transitions: list of ComposeTransitionOperation
        """
        self._Duration = None
        self._Transitions = None

    @property
    def Duration(self):
        r"""元素时长，时间支持：<li>以 s 结尾，表示时间点单位为秒，如 3s 表示时间点为第3秒。</li>
默认：1s
注意：
<li>必须是整数s，否则向下取整。</li>
<li>转场 前后必须紧挨着两个不为 Empty 的元素。</li>
<li>转场 Duration 必须小于前一个元素的 Duration，同时必须小于后一个元素的 Duration。</li>
<li>进行转场处理的两个元素，第二个元素在轨道上的起始时间会自动调整为前一个元素的结束时间减去转场的 Duration。</li>
        :rtype: str
        """
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration

    @property
    def Transitions(self):
        r"""转场操作列表。
默认：淡入淡出。
注意：图像转场操作和音频转场操作各自最多支持一个。
        :rtype: list of ComposeTransitionOperation
        """
        return self._Transitions

    @Transitions.setter
    def Transitions(self, Transitions):
        self._Transitions = Transitions


    def _deserialize(self, params):
        self._Duration = params.get("Duration")
        if params.get("Transitions") is not None:
            self._Transitions = []
            for item in params.get("Transitions"):
                obj = ComposeTransitionOperation()
                obj._deserialize(item)
                self._Transitions.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeTransitionOperation(AbstractModel):
    r"""视频编辑/合成任务 元素转场信息。

    """

    def __init__(self):
        r"""
        :param _Type: 转场类型。

图像的转场操作，用于两个视频片段图像间的转场处理：
<li>ImageFadeInFadeOut：图像淡入淡出。</li>
<li>BowTieHorizontal：水平蝴蝶结。</li>
<li>BowTieVertical：垂直蝴蝶结。</li>
<li>ButterflyWaveScrawler：晃动。</li>
<li>Cannabisleaf：枫叶。</li>
<li>Circle：弧形收放。</li>
<li>CircleCrop：圆环聚拢。</li>
<li>Circleopen：椭圆聚拢。</li>
<li>Crosswarp：横向翘曲。</li>
<li>Cube：立方体。</li>
<li>DoomScreenTransition：幕布。</li>
<li>Doorway：门廊。</li>
<li>Dreamy：波浪。</li>
<li>DreamyZoom：水平聚拢。</li>
<li>FilmBurn：火烧云。</li>
<li>GlitchMemories：抖动。</li>
<li>Heart：心形。</li>
<li>InvertedPageCurl：翻页。</li>
<li>Luma：腐蚀。</li>
<li>Mosaic：九宫格。</li>
<li>Pinwheel：风车。</li>
<li>PolarFunction：椭圆扩散。</li>
<li>PolkaDotsCurtain：弧形扩散。</li>
<li>Radial：雷达扫描。</li>
<li>RotateScaleFade：上下收放。</li>
<li>Squeeze：上下聚拢。</li>
<li>Swap：放大切换。</li>
<li>Swirl：螺旋。</li>
<li>UndulatingBurnOutSwirl：水流蔓延。</li>
<li>Windowblinds：百叶窗。</li>
<li>WipeDown：向下收起。</li>
<li>WipeLeft：向左收起。</li>
<li>WipeRight：向右收起。</li>
<li>WipeUp：向上收起。</li>
<li>ZoomInCircles：水波纹。</li> 
音频的转场操作，用于两个音频片段间的转场处理：
<li>AudioFadeInFadeOut：声音淡入淡出。</li>
        :type Type: str
        """
        self._Type = None

    @property
    def Type(self):
        r"""转场类型。

图像的转场操作，用于两个视频片段图像间的转场处理：
<li>ImageFadeInFadeOut：图像淡入淡出。</li>
<li>BowTieHorizontal：水平蝴蝶结。</li>
<li>BowTieVertical：垂直蝴蝶结。</li>
<li>ButterflyWaveScrawler：晃动。</li>
<li>Cannabisleaf：枫叶。</li>
<li>Circle：弧形收放。</li>
<li>CircleCrop：圆环聚拢。</li>
<li>Circleopen：椭圆聚拢。</li>
<li>Crosswarp：横向翘曲。</li>
<li>Cube：立方体。</li>
<li>DoomScreenTransition：幕布。</li>
<li>Doorway：门廊。</li>
<li>Dreamy：波浪。</li>
<li>DreamyZoom：水平聚拢。</li>
<li>FilmBurn：火烧云。</li>
<li>GlitchMemories：抖动。</li>
<li>Heart：心形。</li>
<li>InvertedPageCurl：翻页。</li>
<li>Luma：腐蚀。</li>
<li>Mosaic：九宫格。</li>
<li>Pinwheel：风车。</li>
<li>PolarFunction：椭圆扩散。</li>
<li>PolkaDotsCurtain：弧形扩散。</li>
<li>Radial：雷达扫描。</li>
<li>RotateScaleFade：上下收放。</li>
<li>Squeeze：上下聚拢。</li>
<li>Swap：放大切换。</li>
<li>Swirl：螺旋。</li>
<li>UndulatingBurnOutSwirl：水流蔓延。</li>
<li>Windowblinds：百叶窗。</li>
<li>WipeDown：向下收起。</li>
<li>WipeLeft：向左收起。</li>
<li>WipeRight：向右收起。</li>
<li>WipeUp：向上收起。</li>
<li>ZoomInCircles：水波纹。</li> 
音频的转场操作，用于两个音频片段间的转场处理：
<li>AudioFadeInFadeOut：声音淡入淡出。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeVideoItem(AbstractModel):
    r"""视频编辑/合成任务 视频元素信息。

    """

    def __init__(self):
        r"""
        :param _SourceMedia: 元素对应媒体信息。
        :type SourceMedia: :class:`tencentcloud.mps.v20190612.models.ComposeSourceMedia`
        :param _TrackTime: 元素在轨道时间轴上的时间信息，不填则紧跟上一个元素。
        :type TrackTime: :class:`tencentcloud.mps.v20190612.models.ComposeTrackTime`
        :param _XPos: 元素中心点距离画布原点的水平位置。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示元素 XPos 为画布宽度指定百分比的位置，如 10% 表示 XPos 为画布宽度的 10%。</li>
<li>当字符串以 px 结尾，表示元素 XPos 单位为像素，如 100px 表示 XPos 为100像素。</li>
默认：50%。
        :type XPos: str
        :param _YPos: 元素中心点距离画布原点的垂直位置。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示元素 YPos 为画布高度指定百分比的位置，如 10% 表示 YPos 为画布高度的 10%。</li>
<li>当字符串以 px 结尾，表示元素 YPos 单位为像素，如 100px 表示 YPos 为100像素。</li>
默认：50%。
        :type YPos: str
        :param _Width: 视频片段的宽度。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示元素 Width 为画布宽度的百分比大小，如 10% 表示 Width 为画布宽度的 10%。</li>
<li>当字符串以 px 结尾，表示元素 Width 单位为像素，如 100px 表示 Width 为100像素。</li>
为空（或0） 的场景：
<li>当 Width、Height 均为空，则 Width 和 Height 取源素材本身的 Width、Height。</li>
<li>当 Width 为空，Height 非空，则 Width 按源素材比例缩放。</li>
<li>当 Width 非空，Height 为空，则 Height 按源素材比例缩放。</li>
        :type Width: str
        :param _Height: 元素的高度。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示元素 Height 为画布高度的百分比大小，如 10% 表示 Height 为画布高度的 10%。</li>
<li>当字符串以 px 结尾，表示元素 Height 单位为像素，如 100px 表示 Height 为100像素。</li>
为空（或0） 的场景：
<li>当 Width、Height 均为空，则 Width 和 Height 取源素材本身的 Width、Height。</li>
<li>当 Width 为空，Height 非空，则 Width 按源素材比例缩放。</li>
<li>当 Width 非空，Height 为空，则 Height 按源素材比例缩放。</li>
        :type Height: str
        :param _ImageOperations: 对图像画面进行的操作，如图像旋转等。
        :type ImageOperations: list of ComposeImageOperation
        :param _AudioOperations: 对音频进行操作，如静音等。
        :type AudioOperations: list of ComposeAudioOperation
        """
        self._SourceMedia = None
        self._TrackTime = None
        self._XPos = None
        self._YPos = None
        self._Width = None
        self._Height = None
        self._ImageOperations = None
        self._AudioOperations = None

    @property
    def SourceMedia(self):
        r"""元素对应媒体信息。
        :rtype: :class:`tencentcloud.mps.v20190612.models.ComposeSourceMedia`
        """
        return self._SourceMedia

    @SourceMedia.setter
    def SourceMedia(self, SourceMedia):
        self._SourceMedia = SourceMedia

    @property
    def TrackTime(self):
        r"""元素在轨道时间轴上的时间信息，不填则紧跟上一个元素。
        :rtype: :class:`tencentcloud.mps.v20190612.models.ComposeTrackTime`
        """
        return self._TrackTime

    @TrackTime.setter
    def TrackTime(self, TrackTime):
        self._TrackTime = TrackTime

    @property
    def XPos(self):
        r"""元素中心点距离画布原点的水平位置。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示元素 XPos 为画布宽度指定百分比的位置，如 10% 表示 XPos 为画布宽度的 10%。</li>
<li>当字符串以 px 结尾，表示元素 XPos 单位为像素，如 100px 表示 XPos 为100像素。</li>
默认：50%。
        :rtype: str
        """
        return self._XPos

    @XPos.setter
    def XPos(self, XPos):
        self._XPos = XPos

    @property
    def YPos(self):
        r"""元素中心点距离画布原点的垂直位置。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示元素 YPos 为画布高度指定百分比的位置，如 10% 表示 YPos 为画布高度的 10%。</li>
<li>当字符串以 px 结尾，表示元素 YPos 单位为像素，如 100px 表示 YPos 为100像素。</li>
默认：50%。
        :rtype: str
        """
        return self._YPos

    @YPos.setter
    def YPos(self, YPos):
        self._YPos = YPos

    @property
    def Width(self):
        r"""视频片段的宽度。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示元素 Width 为画布宽度的百分比大小，如 10% 表示 Width 为画布宽度的 10%。</li>
<li>当字符串以 px 结尾，表示元素 Width 单位为像素，如 100px 表示 Width 为100像素。</li>
为空（或0） 的场景：
<li>当 Width、Height 均为空，则 Width 和 Height 取源素材本身的 Width、Height。</li>
<li>当 Width 为空，Height 非空，则 Width 按源素材比例缩放。</li>
<li>当 Width 非空，Height 为空，则 Height 按源素材比例缩放。</li>
        :rtype: str
        """
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        r"""元素的高度。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示元素 Height 为画布高度的百分比大小，如 10% 表示 Height 为画布高度的 10%。</li>
<li>当字符串以 px 结尾，表示元素 Height 单位为像素，如 100px 表示 Height 为100像素。</li>
为空（或0） 的场景：
<li>当 Width、Height 均为空，则 Width 和 Height 取源素材本身的 Width、Height。</li>
<li>当 Width 为空，Height 非空，则 Width 按源素材比例缩放。</li>
<li>当 Width 非空，Height 为空，则 Height 按源素材比例缩放。</li>
        :rtype: str
        """
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ImageOperations(self):
        r"""对图像画面进行的操作，如图像旋转等。
        :rtype: list of ComposeImageOperation
        """
        return self._ImageOperations

    @ImageOperations.setter
    def ImageOperations(self, ImageOperations):
        self._ImageOperations = ImageOperations

    @property
    def AudioOperations(self):
        r"""对音频进行操作，如静音等。
        :rtype: list of ComposeAudioOperation
        """
        return self._AudioOperations

    @AudioOperations.setter
    def AudioOperations(self, AudioOperations):
        self._AudioOperations = AudioOperations


    def _deserialize(self, params):
        if params.get("SourceMedia") is not None:
            self._SourceMedia = ComposeSourceMedia()
            self._SourceMedia._deserialize(params.get("SourceMedia"))
        if params.get("TrackTime") is not None:
            self._TrackTime = ComposeTrackTime()
            self._TrackTime._deserialize(params.get("TrackTime"))
        self._XPos = params.get("XPos")
        self._YPos = params.get("YPos")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        if params.get("ImageOperations") is not None:
            self._ImageOperations = []
            for item in params.get("ImageOperations"):
                obj = ComposeImageOperation()
                obj._deserialize(item)
                self._ImageOperations.append(obj)
        if params.get("AudioOperations") is not None:
            self._AudioOperations = []
            for item in params.get("AudioOperations"):
                obj = ComposeAudioOperation()
                obj._deserialize(item)
                self._AudioOperations.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeVideoStream(AbstractModel):
    r"""视频编辑/合成任务 视频流信息。

    """

    def __init__(self):
        r"""
        :param _Codec: 视频流的编码方式，可选值：
<li>H.264：H.264 编码（默认）。</li>
        :type Codec: str
        :param _Fps: 视频帧率，取值范围：[0, 60]，单位：Hz。  
默认值：0，表示和第一个视频帧率一致。
        :type Fps: int
        :param _Bitrate: 参考码率，单位 kbps，范围：50~35000。
如果设置，编码时会尽量按该码率进行编码。
如果不设置，服务将通过画面复杂度自动采用合适的码率。
        :type Bitrate: int
        """
        self._Codec = None
        self._Fps = None
        self._Bitrate = None

    @property
    def Codec(self):
        r"""视频流的编码方式，可选值：
<li>H.264：H.264 编码（默认）。</li>
        :rtype: str
        """
        return self._Codec

    @Codec.setter
    def Codec(self, Codec):
        self._Codec = Codec

    @property
    def Fps(self):
        r"""视频帧率，取值范围：[0, 60]，单位：Hz。  
默认值：0，表示和第一个视频帧率一致。
        :rtype: int
        """
        return self._Fps

    @Fps.setter
    def Fps(self, Fps):
        self._Fps = Fps

    @property
    def Bitrate(self):
        r"""参考码率，单位 kbps，范围：50~35000。
如果设置，编码时会尽量按该码率进行编码。
如果不设置，服务将通过画面复杂度自动采用合适的码率。
        :rtype: int
        """
        return self._Bitrate

    @Bitrate.setter
    def Bitrate(self, Bitrate):
        self._Bitrate = Bitrate


    def _deserialize(self, params):
        self._Codec = params.get("Codec")
        self._Fps = params.get("Fps")
        self._Bitrate = params.get("Bitrate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ContainerDiagnoseResultItem(AbstractModel):
    r"""容器格式诊断结果

    """

    def __init__(self):
        r"""
        :param _Category: 诊断出的异常类别，取值范围：
DecodeParamException：解码参数异常
TimeStampException：时间戳异常
FrameException： 帧率异常
StreamStatusException：流状态异常
StreamInfo：流信息异常
StreamAbnormalCharacteristics：流特征异常
DecodeException：解码异常
HLSRequirements：HLS 格式异常
注意：此字段可能返回 null，表示取不到有效值。
        :type Category: str
        :param _Type: 诊断出的具体异常类型，取值如下：

VideoResolutionChanged：视频分辨率变化
AudioSampleRateChanged：音频采样率变化
AudioChannelsChanged：音频通道数变化
ParameterSetsChanged：流参数集信息发生变化
DarOrSarInvalid：视频的宽高比异常
TimestampFallback：DTS时间戳回退
DtsJitter：DTS抖动过大
PtsJitter：PTS抖动过大
AACDurationDeviation：AAC帧时间戳间隔不合理
AudioDroppingFrames：音频丢帧
VideoDroppingFrames：视频丢帧
AVTimestampInterleave：音视频交织不合理
PtsLessThanDts：媒体流的 pts 小于 dts
ReceiveFpsJitter：网络接收帧率抖动过大
ReceiveFpsTooSmall：网络接收视频帧率过小
FpsJitter：通过PTS计算得到的流帧率抖动过大
StreamOpenFailed：流打开失败
StreamEnd：流结束
StreamParseFailed：流解析失败
VideoFirstFrameNotIdr：首帧不是IDR帧
StreamNALUError：NALU起始码错误
TsStreamNoAud：mpegts的H26x流缺失 AUD NALU
AudioStreamLack：无音频流
VideoStreamLack：无视频流
LackAudioRecover：缺失音频流恢复
LackVideoRecover：缺失视频流恢复
VideoBitrateOutofRange：视频流码率(kbps)超出范围
AudioBitrateOutofRange：音频流码率(kbps)超出范围
VideoDecodeFailed：视频解码错误
AudioDecodeFailed：音频解码错误
AudioOutOfPhase：双通道音频相位相反
VideoDuplicatedFrame：视频流中存在重复帧
AudioDuplicatedFrame：音频流中存在重复帧
VideoRotation：视频画面旋转
TsMultiPrograms：MPEG2-TS流有多个program
Mp4InvalidCodecFourcc：MP4中codec fourcc不符合Apple HLS要求
HLSBadM3u8Format：无效的m3u8文件
HLSInvalidMasterM3u8：无效的main m3u8文件
HLSInvalidMediaM3u8：无效的media m3u8文件
HLSMasterM3u8Recommended：main m3u8缺少标准推荐的参数
HLSMediaM3u8Recommended：media m3u8缺少标准推荐的参数
HLSMediaM3u8DiscontinuityExist：media m3u8存在EXT-X-DISCONTINUITY
HLSMediaSegmentsStreamNumChange：切片的流数目发生变化
HLSMediaSegmentsPTSJitterDeviation：切片间PTS跳变且没有EXT-X-DISCONTINUITY
HLSMediaSegmentsDTSJitterDeviation：切片间DTS跳变且没有EXT-X-DISCONTINUITY
TimecodeTrackExist：MP4存在tmcd轨道
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: str
        :param _SeverityLevel: 诊断出的异常级别，取值范围：
Fatal：影响后续播放和解析，
Error： 可能会影响播放，
Warning： 可能会有潜在风险，但不一定会影响播放，
Notice：比较重要的流信息，
Info：一般性的流信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type SeverityLevel: str
        :param _DateTimeSet: 警告出现的时间点，形式如 “2022-12-25T13:14:16Z”
注意：此字段可能返回 null，表示取不到有效值。
        :type DateTimeSet: list of str
        :param _TimestampSet: 时间戳
注意：此字段可能返回 null，表示取不到有效值。
        :type TimestampSet: list of float
        """
        self._Category = None
        self._Type = None
        self._SeverityLevel = None
        self._DateTimeSet = None
        self._TimestampSet = None

    @property
    def Category(self):
        r"""诊断出的异常类别，取值范围：
DecodeParamException：解码参数异常
TimeStampException：时间戳异常
FrameException： 帧率异常
StreamStatusException：流状态异常
StreamInfo：流信息异常
StreamAbnormalCharacteristics：流特征异常
DecodeException：解码异常
HLSRequirements：HLS 格式异常
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Category

    @Category.setter
    def Category(self, Category):
        self._Category = Category

    @property
    def Type(self):
        r"""诊断出的具体异常类型，取值如下：

VideoResolutionChanged：视频分辨率变化
AudioSampleRateChanged：音频采样率变化
AudioChannelsChanged：音频通道数变化
ParameterSetsChanged：流参数集信息发生变化
DarOrSarInvalid：视频的宽高比异常
TimestampFallback：DTS时间戳回退
DtsJitter：DTS抖动过大
PtsJitter：PTS抖动过大
AACDurationDeviation：AAC帧时间戳间隔不合理
AudioDroppingFrames：音频丢帧
VideoDroppingFrames：视频丢帧
AVTimestampInterleave：音视频交织不合理
PtsLessThanDts：媒体流的 pts 小于 dts
ReceiveFpsJitter：网络接收帧率抖动过大
ReceiveFpsTooSmall：网络接收视频帧率过小
FpsJitter：通过PTS计算得到的流帧率抖动过大
StreamOpenFailed：流打开失败
StreamEnd：流结束
StreamParseFailed：流解析失败
VideoFirstFrameNotIdr：首帧不是IDR帧
StreamNALUError：NALU起始码错误
TsStreamNoAud：mpegts的H26x流缺失 AUD NALU
AudioStreamLack：无音频流
VideoStreamLack：无视频流
LackAudioRecover：缺失音频流恢复
LackVideoRecover：缺失视频流恢复
VideoBitrateOutofRange：视频流码率(kbps)超出范围
AudioBitrateOutofRange：音频流码率(kbps)超出范围
VideoDecodeFailed：视频解码错误
AudioDecodeFailed：音频解码错误
AudioOutOfPhase：双通道音频相位相反
VideoDuplicatedFrame：视频流中存在重复帧
AudioDuplicatedFrame：音频流中存在重复帧
VideoRotation：视频画面旋转
TsMultiPrograms：MPEG2-TS流有多个program
Mp4InvalidCodecFourcc：MP4中codec fourcc不符合Apple HLS要求
HLSBadM3u8Format：无效的m3u8文件
HLSInvalidMasterM3u8：无效的main m3u8文件
HLSInvalidMediaM3u8：无效的media m3u8文件
HLSMasterM3u8Recommended：main m3u8缺少标准推荐的参数
HLSMediaM3u8Recommended：media m3u8缺少标准推荐的参数
HLSMediaM3u8DiscontinuityExist：media m3u8存在EXT-X-DISCONTINUITY
HLSMediaSegmentsStreamNumChange：切片的流数目发生变化
HLSMediaSegmentsPTSJitterDeviation：切片间PTS跳变且没有EXT-X-DISCONTINUITY
HLSMediaSegmentsDTSJitterDeviation：切片间DTS跳变且没有EXT-X-DISCONTINUITY
TimecodeTrackExist：MP4存在tmcd轨道
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def SeverityLevel(self):
        r"""诊断出的异常级别，取值范围：
Fatal：影响后续播放和解析，
Error： 可能会影响播放，
Warning： 可能会有潜在风险，但不一定会影响播放，
Notice：比较重要的流信息，
Info：一般性的流信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SeverityLevel

    @SeverityLevel.setter
    def SeverityLevel(self, SeverityLevel):
        self._SeverityLevel = SeverityLevel

    @property
    def DateTimeSet(self):
        r"""警告出现的时间点，形式如 “2022-12-25T13:14:16Z”
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._DateTimeSet

    @DateTimeSet.setter
    def DateTimeSet(self, DateTimeSet):
        self._DateTimeSet = DateTimeSet

    @property
    def TimestampSet(self):
        r"""时间戳
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of float
        """
        return self._TimestampSet

    @TimestampSet.setter
    def TimestampSet(self, TimestampSet):
        self._TimestampSet = TimestampSet


    def _deserialize(self, params):
        self._Category = params.get("Category")
        self._Type = params.get("Type")
        self._SeverityLevel = params.get("SeverityLevel")
        self._DateTimeSet = params.get("DateTimeSet")
        self._TimestampSet = params.get("TimestampSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ContentReviewTemplateItem(AbstractModel):
    r"""内容审核模板详情

    """

    def __init__(self):
        r"""
        :param _Definition: 内容审核模板唯一标识。
        :type Definition: int
        :param _Name: 内容审核模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Comment: 内容审核模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _PornConfigure: 鉴黄控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :type PornConfigure: :class:`tencentcloud.mps.v20190612.models.PornConfigureInfo`
        :param _TerrorismConfigure: 涉敏控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :type TerrorismConfigure: :class:`tencentcloud.mps.v20190612.models.TerrorismConfigureInfo`
        :param _PoliticalConfigure: 涉敏控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :type PoliticalConfigure: :class:`tencentcloud.mps.v20190612.models.PoliticalConfigureInfo`
        :param _ProhibitedConfigure: 违禁控制参数。违禁内容包括：
<li>谩骂；</li>
<li>涉毒违法。</li>
注意：此字段可能返回 null，表示取不到有效值。
        :type ProhibitedConfigure: :class:`tencentcloud.mps.v20190612.models.ProhibitedConfigureInfo`
        :param _UserDefineConfigure: 用户自定义内容审核控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :type UserDefineConfigure: :class:`tencentcloud.mps.v20190612.models.UserDefineConfigureInfo`
        :param _CreateTime: 模板创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :type CreateTime: str
        :param _UpdateTime: 模板最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :type UpdateTime: str
        :param _Type: 模板类型，取值范围：
* Preset：系统预置模板；
* Custom：用户自定义模板。
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: str
        """
        self._Definition = None
        self._Name = None
        self._Comment = None
        self._PornConfigure = None
        self._TerrorismConfigure = None
        self._PoliticalConfigure = None
        self._ProhibitedConfigure = None
        self._UserDefineConfigure = None
        self._CreateTime = None
        self._UpdateTime = None
        self._Type = None

    @property
    def Definition(self):
        r"""内容审核模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Name(self):
        r"""内容审核模板名称，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        r"""内容审核模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def PornConfigure(self):
        r"""鉴黄控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.PornConfigureInfo`
        """
        return self._PornConfigure

    @PornConfigure.setter
    def PornConfigure(self, PornConfigure):
        self._PornConfigure = PornConfigure

    @property
    def TerrorismConfigure(self):
        r"""涉敏控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.TerrorismConfigureInfo`
        """
        return self._TerrorismConfigure

    @TerrorismConfigure.setter
    def TerrorismConfigure(self, TerrorismConfigure):
        self._TerrorismConfigure = TerrorismConfigure

    @property
    def PoliticalConfigure(self):
        r"""涉敏控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.PoliticalConfigureInfo`
        """
        return self._PoliticalConfigure

    @PoliticalConfigure.setter
    def PoliticalConfigure(self, PoliticalConfigure):
        self._PoliticalConfigure = PoliticalConfigure

    @property
    def ProhibitedConfigure(self):
        r"""违禁控制参数。违禁内容包括：
<li>谩骂；</li>
<li>涉毒违法。</li>
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.ProhibitedConfigureInfo`
        """
        return self._ProhibitedConfigure

    @ProhibitedConfigure.setter
    def ProhibitedConfigure(self, ProhibitedConfigure):
        self._ProhibitedConfigure = ProhibitedConfigure

    @property
    def UserDefineConfigure(self):
        r"""用户自定义内容审核控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.UserDefineConfigureInfo`
        """
        return self._UserDefineConfigure

    @UserDefineConfigure.setter
    def UserDefineConfigure(self, UserDefineConfigure):
        self._UserDefineConfigure = UserDefineConfigure

    @property
    def CreateTime(self):
        r"""模板创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""模板最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def Type(self):
        r"""模板类型，取值范围：
* Preset：系统预置模板；
* Custom：用户自定义模板。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("PornConfigure") is not None:
            self._PornConfigure = PornConfigureInfo()
            self._PornConfigure._deserialize(params.get("PornConfigure"))
        if params.get("TerrorismConfigure") is not None:
            self._TerrorismConfigure = TerrorismConfigureInfo()
            self._TerrorismConfigure._deserialize(params.get("TerrorismConfigure"))
        if params.get("PoliticalConfigure") is not None:
            self._PoliticalConfigure = PoliticalConfigureInfo()
            self._PoliticalConfigure._deserialize(params.get("PoliticalConfigure"))
        if params.get("ProhibitedConfigure") is not None:
            self._ProhibitedConfigure = ProhibitedConfigureInfo()
            self._ProhibitedConfigure._deserialize(params.get("ProhibitedConfigure"))
        if params.get("UserDefineConfigure") is not None:
            self._UserDefineConfigure = UserDefineConfigureInfo()
            self._UserDefineConfigure._deserialize(params.get("UserDefineConfigure"))
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CosFileUploadTrigger(AbstractModel):
    r"""绑定到 COS 的输入规则。

    """

    def __init__(self):
        r"""
        :param _Bucket: 工作流绑定的 COS Bucket 名，如 TopRankVideo-125xxx88。
        :type Bucket: str
        :param _Region: 工作流绑定的 COS Bucket 所属园区，如 ap-chongiqng。
        :type Region: str
        :param _Dir: 工作流绑定的输入路径目录，必须为绝对路径，即以 `/` 开头和结尾。如`/movie/201907/`，不填代表根目录`/`。
        :type Dir: str
        :param _Formats: 支持的所有格式如下：

- 视频文件扩展名，支持以下选择，共15种：
`.mp4`、`.avi`、`.mov`、`.wmv`、`.flv`、`.mkv`、`.mpg`、`.mpeg`、`.rm`、`.rmvb`、`.asf`、`.3gp`、`.webm`、`.ts`、`.m4v`

- 音频文件扩展名，支持以下选择，共7种：
`.mp3`、`.wav`、`.aac`、`.flac`、`.ogg`、`.m4a`、`.amr`

- 字幕文件扩展名，支持以下选择，共2种：
`.vtt`、`.srt`

- `*`：支持任意文件格式

- 不传或者传空列表：支持系统预设文件格式（视频：`.mp4`、`.ts`、`.flv`、`.wmv`、`.asf`、`.rm`、`.rmvb`、`.mpg`、`.mpeg`、`.3gp`、`.mov`、`.webm`、`.mkv`、`.avi`、`.m4v`，音频：`.mp3`、`.m4a`、`.flac`、`.ogg`、`.wav`、`.amr`、`.aac`，字幕：`.vtt`、`.srt`）

**注意**：
1. 如果传入的格式列表中有`*`则表示为支持任意文件格式。
2. 扩展名传入时带不带`.`都可以，比如 `.mp4` 或 `mp4` 均支持。
3. 自定义文件扩展名需满足数字、字母字符，长度在[1,64]范围内。
        :type Formats: list of str
        """
        self._Bucket = None
        self._Region = None
        self._Dir = None
        self._Formats = None

    @property
    def Bucket(self):
        r"""工作流绑定的 COS Bucket 名，如 TopRankVideo-125xxx88。
        :rtype: str
        """
        return self._Bucket

    @Bucket.setter
    def Bucket(self, Bucket):
        self._Bucket = Bucket

    @property
    def Region(self):
        r"""工作流绑定的 COS Bucket 所属园区，如 ap-chongiqng。
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Dir(self):
        r"""工作流绑定的输入路径目录，必须为绝对路径，即以 `/` 开头和结尾。如`/movie/201907/`，不填代表根目录`/`。
        :rtype: str
        """
        return self._Dir

    @Dir.setter
    def Dir(self, Dir):
        self._Dir = Dir

    @property
    def Formats(self):
        r"""支持的所有格式如下：

- 视频文件扩展名，支持以下选择，共15种：
`.mp4`、`.avi`、`.mov`、`.wmv`、`.flv`、`.mkv`、`.mpg`、`.mpeg`、`.rm`、`.rmvb`、`.asf`、`.3gp`、`.webm`、`.ts`、`.m4v`

- 音频文件扩展名，支持以下选择，共7种：
`.mp3`、`.wav`、`.aac`、`.flac`、`.ogg`、`.m4a`、`.amr`

- 字幕文件扩展名，支持以下选择，共2种：
`.vtt`、`.srt`

- `*`：支持任意文件格式

- 不传或者传空列表：支持系统预设文件格式（视频：`.mp4`、`.ts`、`.flv`、`.wmv`、`.asf`、`.rm`、`.rmvb`、`.mpg`、`.mpeg`、`.3gp`、`.mov`、`.webm`、`.mkv`、`.avi`、`.m4v`，音频：`.mp3`、`.m4a`、`.flac`、`.ogg`、`.wav`、`.amr`、`.aac`，字幕：`.vtt`、`.srt`）

**注意**：
1. 如果传入的格式列表中有`*`则表示为支持任意文件格式。
2. 扩展名传入时带不带`.`都可以，比如 `.mp4` 或 `mp4` 均支持。
3. 自定义文件扩展名需满足数字、字母字符，长度在[1,64]范围内。
        :rtype: list of str
        """
        return self._Formats

    @Formats.setter
    def Formats(self, Formats):
        self._Formats = Formats


    def _deserialize(self, params):
        self._Bucket = params.get("Bucket")
        self._Region = params.get("Region")
        self._Dir = params.get("Dir")
        self._Formats = params.get("Formats")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CosInputInfo(AbstractModel):
    r"""媒体处理 COS 对象信息。

    """

    def __init__(self):
        r"""
        :param _Bucket: 媒体处理对象文件所在的 COS Bucket 名，如 TopRankVideo-125xxx88。
        :type Bucket: str
        :param _Region: 媒体处理对象文件所在的 COS Bucket 所属园区，如 ap-chongqing。
        :type Region: str
        :param _Object: 媒体处理对象文件的输入路径，如`/movie/201907/WildAnimal.mov`。
        :type Object: str
        """
        self._Bucket = None
        self._Region = None
        self._Object = None

    @property
    def Bucket(self):
        r"""媒体处理对象文件所在的 COS Bucket 名，如 TopRankVideo-125xxx88。
        :rtype: str
        """
        return self._Bucket

    @Bucket.setter
    def Bucket(self, Bucket):
        self._Bucket = Bucket

    @property
    def Region(self):
        r"""媒体处理对象文件所在的 COS Bucket 所属园区，如 ap-chongqing。
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Object(self):
        r"""媒体处理对象文件的输入路径，如`/movie/201907/WildAnimal.mov`。
        :rtype: str
        """
        return self._Object

    @Object.setter
    def Object(self, Object):
        self._Object = Object


    def _deserialize(self, params):
        self._Bucket = params.get("Bucket")
        self._Region = params.get("Region")
        self._Object = params.get("Object")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CosOutputStorage(AbstractModel):
    r"""媒体处理 COS 输出对象信息。

    """

    def __init__(self):
        r"""
        :param _Bucket: 媒体处理生成的文件输出的目标 Bucket 名，如 TopRankVideo-125xxx88。如果不填，表示继承上层。
        :type Bucket: str
        :param _Region: 媒体处理生成的文件输出的目标 Bucket 的园区，如 ap-chongqing。如果不填，表示继承上层。
        :type Region: str
        """
        self._Bucket = None
        self._Region = None

    @property
    def Bucket(self):
        r"""媒体处理生成的文件输出的目标 Bucket 名，如 TopRankVideo-125xxx88。如果不填，表示继承上层。
        :rtype: str
        """
        return self._Bucket

    @Bucket.setter
    def Bucket(self, Bucket):
        self._Bucket = Bucket

    @property
    def Region(self):
        r"""媒体处理生成的文件输出的目标 Bucket 的园区，如 ap-chongqing。如果不填，表示继承上层。
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region


    def _deserialize(self, params):
        self._Bucket = params.get("Bucket")
        self._Region = params.get("Region")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CoverConfigureInfo(AbstractModel):
    r"""智能封面任务控制参数

    """

    def __init__(self):
        r"""
        :param _Switch: 智能封面任务开关，可选值：
<li>ON：开启智能封面任务；</li>
<li>OFF：关闭智能封面任务。</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        r"""智能封面任务开关，可选值：
<li>ON：开启智能封面任务；</li>
<li>OFF：关闭智能封面任务。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CoverConfigureInfoForUpdate(AbstractModel):
    r"""智能封面任务控制参数

    """

    def __init__(self):
        r"""
        :param _Switch: 智能封面任务开关，可选值：
<li>ON：开启智能封面任务；</li>
<li>OFF：关闭智能封面任务。</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        r"""智能封面任务开关，可选值：
<li>ON：开启智能封面任务；</li>
<li>OFF：关闭智能封面任务。</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAIAnalysisTemplateRequest(AbstractModel):
    r"""CreateAIAnalysisTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 视频内容分析模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Comment: 视频内容分析模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _ClassificationConfigure: 智能分类任务控制参数。
        :type ClassificationConfigure: :class:`tencentcloud.mps.v20190612.models.ClassificationConfigureInfo`
        :param _TagConfigure: 智能标签任务控制参数。
        :type TagConfigure: :class:`tencentcloud.mps.v20190612.models.TagConfigureInfo`
        :param _CoverConfigure: 智能封面任务控制参数。
        :type CoverConfigure: :class:`tencentcloud.mps.v20190612.models.CoverConfigureInfo`
        :param _FrameTagConfigure: 智能按帧标签任务控制参数。
        :type FrameTagConfigure: :class:`tencentcloud.mps.v20190612.models.FrameTagConfigureInfo`
        """
        self._Name = None
        self._Comment = None
        self._ClassificationConfigure = None
        self._TagConfigure = None
        self._CoverConfigure = None
        self._FrameTagConfigure = None

    @property
    def Name(self):
        r"""视频内容分析模板名称，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        r"""视频内容分析模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def ClassificationConfigure(self):
        r"""智能分类任务控制参数。
        :rtype: :class:`tencentcloud.mps.v20190612.models.ClassificationConfigureInfo`
        """
        return self._ClassificationConfigure

    @ClassificationConfigure.setter
    def ClassificationConfigure(self, ClassificationConfigure):
        self._ClassificationConfigure = ClassificationConfigure

    @property
    def TagConfigure(self):
        r"""智能标签任务控制参数。
        :rtype: :class:`tencentcloud.mps.v20190612.models.TagConfigureInfo`
        """
        return self._TagConfigure

    @TagConfigure.setter
    def TagConfigure(self, TagConfigure):
        self._TagConfigure = TagConfigure

    @property
    def CoverConfigure(self):
        r"""智能封面任务控制参数。
        :rtype: :class:`tencentcloud.mps.v20190612.models.CoverConfigureInfo`
        """
        return self._CoverConfigure

    @CoverConfigure.setter
    def CoverConfigure(self, CoverConfigure):
        self._CoverConfigure = CoverConfigure

    @property
    def FrameTagConfigure(self):
        r"""智能按帧标签任务控制参数。
        :rtype: :class:`tencentcloud.mps.v20190612.models.FrameTagConfigureInfo`
        """
        return self._FrameTagConfigure

    @FrameTagConfigure.setter
    def FrameTagConfigure(self, FrameTagConfigure):
        self._FrameTagConfigure = FrameTagConfigure


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("ClassificationConfigure") is not None:
            self._ClassificationConfigure = ClassificationConfigureInfo()
            self._ClassificationConfigure._deserialize(params.get("ClassificationConfigure"))
        if params.get("TagConfigure") is not None:
            self._TagConfigure = TagConfigureInfo()
            self._TagConfigure._deserialize(params.get("TagConfigure"))
        if params.get("CoverConfigure") is not None:
            self._CoverConfigure = CoverConfigureInfo()
            self._CoverConfigure._deserialize(params.get("CoverConfigure"))
        if params.get("FrameTagConfigure") is not None:
            self._FrameTagConfigure = FrameTagConfigureInfo()
            self._FrameTagConfigure._deserialize(params.get("FrameTagConfigure"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAIAnalysisTemplateResponse(AbstractModel):
    r"""CreateAIAnalysisTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 视频内容分析模板唯一标识。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""视频内容分析模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateAIRecognitionTemplateRequest(AbstractModel):
    r"""CreateAIRecognitionTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 视频内容识别模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Comment: 视频内容识别模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _FaceConfigure: 人脸识别控制参数。
        :type FaceConfigure: :class:`tencentcloud.mps.v20190612.models.FaceConfigureInfo`
        :param _OcrFullTextConfigure: 文本全文识别控制参数。
        :type OcrFullTextConfigure: :class:`tencentcloud.mps.v20190612.models.OcrFullTextConfigureInfo`
        :param _OcrWordsConfigure: 文本关键词识别控制参数。
        :type OcrWordsConfigure: :class:`tencentcloud.mps.v20190612.models.OcrWordsConfigureInfo`
        :param _AsrFullTextConfigure: 语音全文识别控制参数。
        :type AsrFullTextConfigure: :class:`tencentcloud.mps.v20190612.models.AsrFullTextConfigureInfo`
        :param _AsrWordsConfigure: 语音关键词识别控制参数。
        :type AsrWordsConfigure: :class:`tencentcloud.mps.v20190612.models.AsrWordsConfigureInfo`
        :param _TranslateConfigure: 语音翻译控制参数。
        :type TranslateConfigure: :class:`tencentcloud.mps.v20190612.models.TranslateConfigureInfo`
        """
        self._Name = None
        self._Comment = None
        self._FaceConfigure = None
        self._OcrFullTextConfigure = None
        self._OcrWordsConfigure = None
        self._AsrFullTextConfigure = None
        self._AsrWordsConfigure = None
        self._TranslateConfigure = None

    @property
    def Name(self):
        r"""视频内容识别模板名称，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        r"""视频内容识别模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def FaceConfigure(self):
        r"""人脸识别控制参数。
        :rtype: :class:`tencentcloud.mps.v20190612.models.FaceConfigureInfo`
        """
        return self._FaceConfigure

    @FaceConfigure.setter
    def FaceConfigure(self, FaceConfigure):
        self._FaceConfigure = FaceConfigure

    @property
    def OcrFullTextConfigure(self):
        r"""文本全文识别控制参数。
        :rtype: :class:`tencentcloud.mps.v20190612.models.OcrFullTextConfigureInfo`
        """
        return self._OcrFullTextConfigure

    @OcrFullTextConfigure.setter
    def OcrFullTextConfigure(self, OcrFullTextConfigure):
        self._OcrFullTextConfigure = OcrFullTextConfigure

    @property
    def OcrWordsConfigure(self):
        r"""文本关键词识别控制参数。
        :rtype: :class:`tencentcloud.mps.v20190612.models.OcrWordsConfigureInfo`
        """
        return self._OcrWordsConfigure

    @OcrWordsConfigure.setter
    def OcrWordsConfigure(self, OcrWordsConfigure):
        self._OcrWordsConfigure = OcrWordsConfigure

    @property
    def AsrFullTextConfigure(self):
        r"""语音全文识别控制参数。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AsrFullTextConfigureInfo`
        """
        return self._AsrFullTextConfigure

    @AsrFullTextConfigure.setter
    def AsrFullTextConfigure(self, AsrFullTextConfigure):
        self._AsrFullTextConfigure = AsrFullTextConfigure

    @property
    def AsrWordsConfigure(self):
        r"""语音关键词识别控制参数。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AsrWordsConfigureInfo`
        """
        return self._AsrWordsConfigure

    @AsrWordsConfigure.setter
    def AsrWordsConfigure(self, AsrWordsConfigure):
        self._AsrWordsConfigure = AsrWordsConfigure

    @property
    def TranslateConfigure(self):
        r"""语音翻译控制参数。
        :rtype: :class:`tencentcloud.mps.v20190612.models.TranslateConfigureInfo`
        """
        return self._TranslateConfigure

    @TranslateConfigure.setter
    def TranslateConfigure(self, TranslateConfigure):
        self._TranslateConfigure = TranslateConfigure


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("FaceConfigure") is not None:
            self._FaceConfigure = FaceConfigureInfo()
            self._FaceConfigure._deserialize(params.get("FaceConfigure"))
        if params.get("OcrFullTextConfigure") is not None:
            self._OcrFullTextConfigure = OcrFullTextConfigureInfo()
            self._OcrFullTextConfigure._deserialize(params.get("OcrFullTextConfigure"))
        if params.get("OcrWordsConfigure") is not None:
            self._OcrWordsConfigure = OcrWordsConfigureInfo()
            self._OcrWordsConfigure._deserialize(params.get("OcrWordsConfigure"))
        if params.get("AsrFullTextConfigure") is not None:
            self._AsrFullTextConfigure = AsrFullTextConfigureInfo()
            self._AsrFullTextConfigure._deserialize(params.get("AsrFullTextConfigure"))
        if params.get("AsrWordsConfigure") is not None:
            self._AsrWordsConfigure = AsrWordsConfigureInfo()
            self._AsrWordsConfigure._deserialize(params.get("AsrWordsConfigure"))
        if params.get("TranslateConfigure") is not None:
            self._TranslateConfigure = TranslateConfigureInfo()
            self._TranslateConfigure._deserialize(params.get("TranslateConfigure"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAIRecognitionTemplateResponse(AbstractModel):
    r"""CreateAIRecognitionTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 视频内容识别模板唯一标识。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""视频内容识别模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateAdaptiveDynamicStreamingTemplateRequest(AbstractModel):
    r"""CreateAdaptiveDynamicStreamingTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Format: 自适应转码格式，取值范围：
<li>HLS，</li>
<li>MPEG-DASH。</li>
        :type Format: str
        :param _StreamInfos: 转自适应码流输出子流参数信息，最多输出10路子流。
注意：各个子流的帧率必须保持一致；如果不一致，采用第一个子流的帧率作为输出帧率。
        :type StreamInfos: list of AdaptiveStreamTemplate
        :param _Name: 模板名称，长度限制：64 个字符。
        :type Name: str
        :param _DisableHigherVideoBitrate: 是否禁止视频低码率转高码率，取值范围：
<li>0：否，</li>
<li>1：是。</li>
默认为否。
        :type DisableHigherVideoBitrate: int
        :param _DisableHigherVideoResolution: 是否禁止视频分辨率转高分辨率，取值范围：
<li>0：否，</li>
<li>1：是。</li>
默认为否。
        :type DisableHigherVideoResolution: int
        :param _Comment: 模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _PureAudio: 是否为纯音频，0表示视频模板，1表示纯音频模板
当值为1：
1. StreamInfos.N.RemoveVideo=1
2. StreamInfos.N.RemoveAudio=0
3. StreamInfos.N.Video.Codec=copy
当值为0：
1. StreamInfos.N.Video.Codec不能为copy
2. StreamInfos.N.Video.Fps不能为null
注意：
此值只是区分模板类型，任务使用RemoveAudio和RemoveVideo的值
        :type PureAudio: int
        :param _SegmentType: 分片类型，可选值： <li>ts-segment：HLS+TS 切片</li> <li>ts-byterange：HLS+TS byte range</li> <li>mp4-segment：HLS+MP4 切片</li> <li>mp4-byterange：HLS/DASH+MP4 byte range</li> <li>ts-packed-audio：HLS+TS+Packed Audio 切片</li> <li>mp4-packed-audio：HLS+MP4+Packed Audio 切片</li> <li>ts-ts-segment：HLS+TS+TS 切片</li> <li>ts-ts-byterange：HLS+TS+TS byte range</li> <li>mp4-mp4-segment：HLS+MP4+MP4 切片</li> <li>mp4-mp4-byterange：HLS/DASH+MP4+MP4 byte range</li> <li>ts-packed-audio-byterange：HLS+TS+Packed Audio byte range</li> <li>mp4-packed-audio-byterange：HLS+MP4+Packed Audio byte range</li> 默认值：ts-segment 注：自适应码流的分片格式以此字段为准。DASH格式下SegmentType只能为mp4-byterange或mp4-mp4-byterange。
        :type SegmentType: str
        """
        self._Format = None
        self._StreamInfos = None
        self._Name = None
        self._DisableHigherVideoBitrate = None
        self._DisableHigherVideoResolution = None
        self._Comment = None
        self._PureAudio = None
        self._SegmentType = None

    @property
    def Format(self):
        r"""自适应转码格式，取值范围：
<li>HLS，</li>
<li>MPEG-DASH。</li>
        :rtype: str
        """
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def StreamInfos(self):
        r"""转自适应码流输出子流参数信息，最多输出10路子流。
注意：各个子流的帧率必须保持一致；如果不一致，采用第一个子流的帧率作为输出帧率。
        :rtype: list of AdaptiveStreamTemplate
        """
        return self._StreamInfos

    @StreamInfos.setter
    def StreamInfos(self, StreamInfos):
        self._StreamInfos = StreamInfos

    @property
    def Name(self):
        r"""模板名称，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def DisableHigherVideoBitrate(self):
        r"""是否禁止视频低码率转高码率，取值范围：
<li>0：否，</li>
<li>1：是。</li>
默认为否。
        :rtype: int
        """
        return self._DisableHigherVideoBitrate

    @DisableHigherVideoBitrate.setter
    def DisableHigherVideoBitrate(self, DisableHigherVideoBitrate):
        self._DisableHigherVideoBitrate = DisableHigherVideoBitrate

    @property
    def DisableHigherVideoResolution(self):
        r"""是否禁止视频分辨率转高分辨率，取值范围：
<li>0：否，</li>
<li>1：是。</li>
默认为否。
        :rtype: int
        """
        return self._DisableHigherVideoResolution

    @DisableHigherVideoResolution.setter
    def DisableHigherVideoResolution(self, DisableHigherVideoResolution):
        self._DisableHigherVideoResolution = DisableHigherVideoResolution

    @property
    def Comment(self):
        r"""模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def PureAudio(self):
        r"""是否为纯音频，0表示视频模板，1表示纯音频模板
当值为1：
1. StreamInfos.N.RemoveVideo=1
2. StreamInfos.N.RemoveAudio=0
3. StreamInfos.N.Video.Codec=copy
当值为0：
1. StreamInfos.N.Video.Codec不能为copy
2. StreamInfos.N.Video.Fps不能为null
注意：
此值只是区分模板类型，任务使用RemoveAudio和RemoveVideo的值
        :rtype: int
        """
        return self._PureAudio

    @PureAudio.setter
    def PureAudio(self, PureAudio):
        self._PureAudio = PureAudio

    @property
    def SegmentType(self):
        r"""分片类型，可选值： <li>ts-segment：HLS+TS 切片</li> <li>ts-byterange：HLS+TS byte range</li> <li>mp4-segment：HLS+MP4 切片</li> <li>mp4-byterange：HLS/DASH+MP4 byte range</li> <li>ts-packed-audio：HLS+TS+Packed Audio 切片</li> <li>mp4-packed-audio：HLS+MP4+Packed Audio 切片</li> <li>ts-ts-segment：HLS+TS+TS 切片</li> <li>ts-ts-byterange：HLS+TS+TS byte range</li> <li>mp4-mp4-segment：HLS+MP4+MP4 切片</li> <li>mp4-mp4-byterange：HLS/DASH+MP4+MP4 byte range</li> <li>ts-packed-audio-byterange：HLS+TS+Packed Audio byte range</li> <li>mp4-packed-audio-byterange：HLS+MP4+Packed Audio byte range</li> 默认值：ts-segment 注：自适应码流的分片格式以此字段为准。DASH格式下SegmentType只能为mp4-byterange或mp4-mp4-byterange。
        :rtype: str
        """
        return self._SegmentType

    @SegmentType.setter
    def SegmentType(self, SegmentType):
        self._SegmentType = SegmentType


    def _deserialize(self, params):
        self._Format = params.get("Format")
        if params.get("StreamInfos") is not None:
            self._StreamInfos = []
            for item in params.get("StreamInfos"):
                obj = AdaptiveStreamTemplate()
                obj._deserialize(item)
                self._StreamInfos.append(obj)
        self._Name = params.get("Name")
        self._DisableHigherVideoBitrate = params.get("DisableHigherVideoBitrate")
        self._DisableHigherVideoResolution = params.get("DisableHigherVideoResolution")
        self._Comment = params.get("Comment")
        self._PureAudio = params.get("PureAudio")
        self._SegmentType = params.get("SegmentType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAdaptiveDynamicStreamingTemplateResponse(AbstractModel):
    r"""CreateAdaptiveDynamicStreamingTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 自适应转码模板唯一标识。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""自适应转码模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateAigcImageTaskRequest(AbstractModel):
    r"""CreateAigcImageTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ModelName: 模型名称。
当前支持的模型列表：
Hunyuan,
GEM，
Qwen。
        :type ModelName: str
        :param _ModelVersion: 指定模型特定版本号。默认使用系统当前所支持的模型稳定版本。

1. GEM， 可选[2.5,3.0]。
        :type ModelVersion: str
        :param _Prompt: 生成图片的描述。(注：最大支持1000字符)。当未传入参考图片时，此参数必填。
        :type Prompt: str
        :param _NegativePrompt: 用于描述您想要阻止模型生成的内容。 注意：部分模型支持。 例如： 顶部照明、明亮的色彩 人物、动物 多辆汽车、风。
        :type NegativePrompt: str
        :param _EnhancePrompt: 默认取值为False，模型会严格地遵循指令。如果需要更精细的prompt获得最佳效果，可将此参数设置为True，将自动优化传入的prompt，以提升生成质量。
        :type EnhancePrompt: bool
        :param _ImageInfos: 用于传入参考的资源图片信息，默认支持传入一张图片。

支持多图输入的模型：
1. GEM，可支持最多3张图片输入作为资源图。

注意：
1. 推荐图片小于7M，各模型限制不同。
2. 图片格式支持：jpeg, png, webp。
        :type ImageInfos: list of AigcImageInfo
        :param _ExtraParameters: 用于传入模型要求的额外参数。
        :type ExtraParameters: :class:`tencentcloud.mps.v20190612.models.AigcImageExtraParam`
        :param _StoreCosParam: 文件结果指定存储Cos桶信息。 注意：需开通Cos，创建并授权MPS_QcsRole角色。
        :type StoreCosParam: :class:`tencentcloud.mps.v20190612.models.AigcStoreCosParam`
        :param _Operator: 接口操作者名称。
        :type Operator: str
        """
        self._ModelName = None
        self._ModelVersion = None
        self._Prompt = None
        self._NegativePrompt = None
        self._EnhancePrompt = None
        self._ImageInfos = None
        self._ExtraParameters = None
        self._StoreCosParam = None
        self._Operator = None

    @property
    def ModelName(self):
        r"""模型名称。
当前支持的模型列表：
Hunyuan,
GEM，
Qwen。
        :rtype: str
        """
        return self._ModelName

    @ModelName.setter
    def ModelName(self, ModelName):
        self._ModelName = ModelName

    @property
    def ModelVersion(self):
        r"""指定模型特定版本号。默认使用系统当前所支持的模型稳定版本。

1. GEM， 可选[2.5,3.0]。
        :rtype: str
        """
        return self._ModelVersion

    @ModelVersion.setter
    def ModelVersion(self, ModelVersion):
        self._ModelVersion = ModelVersion

    @property
    def Prompt(self):
        r"""生成图片的描述。(注：最大支持1000字符)。当未传入参考图片时，此参数必填。
        :rtype: str
        """
        return self._Prompt

    @Prompt.setter
    def Prompt(self, Prompt):
        self._Prompt = Prompt

    @property
    def NegativePrompt(self):
        r"""用于描述您想要阻止模型生成的内容。 注意：部分模型支持。 例如： 顶部照明、明亮的色彩 人物、动物 多辆汽车、风。
        :rtype: str
        """
        return self._NegativePrompt

    @NegativePrompt.setter
    def NegativePrompt(self, NegativePrompt):
        self._NegativePrompt = NegativePrompt

    @property
    def EnhancePrompt(self):
        r"""默认取值为False，模型会严格地遵循指令。如果需要更精细的prompt获得最佳效果，可将此参数设置为True，将自动优化传入的prompt，以提升生成质量。
        :rtype: bool
        """
        return self._EnhancePrompt

    @EnhancePrompt.setter
    def EnhancePrompt(self, EnhancePrompt):
        self._EnhancePrompt = EnhancePrompt

    @property
    def ImageInfos(self):
        r"""用于传入参考的资源图片信息，默认支持传入一张图片。

支持多图输入的模型：
1. GEM，可支持最多3张图片输入作为资源图。

注意：
1. 推荐图片小于7M，各模型限制不同。
2. 图片格式支持：jpeg, png, webp。
        :rtype: list of AigcImageInfo
        """
        return self._ImageInfos

    @ImageInfos.setter
    def ImageInfos(self, ImageInfos):
        self._ImageInfos = ImageInfos

    @property
    def ExtraParameters(self):
        r"""用于传入模型要求的额外参数。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AigcImageExtraParam`
        """
        return self._ExtraParameters

    @ExtraParameters.setter
    def ExtraParameters(self, ExtraParameters):
        self._ExtraParameters = ExtraParameters

    @property
    def StoreCosParam(self):
        r"""文件结果指定存储Cos桶信息。 注意：需开通Cos，创建并授权MPS_QcsRole角色。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AigcStoreCosParam`
        """
        return self._StoreCosParam

    @StoreCosParam.setter
    def StoreCosParam(self, StoreCosParam):
        self._StoreCosParam = StoreCosParam

    @property
    def Operator(self):
        r"""接口操作者名称。
        :rtype: str
        """
        return self._Operator

    @Operator.setter
    def Operator(self, Operator):
        self._Operator = Operator


    def _deserialize(self, params):
        self._ModelName = params.get("ModelName")
        self._ModelVersion = params.get("ModelVersion")
        self._Prompt = params.get("Prompt")
        self._NegativePrompt = params.get("NegativePrompt")
        self._EnhancePrompt = params.get("EnhancePrompt")
        if params.get("ImageInfos") is not None:
            self._ImageInfos = []
            for item in params.get("ImageInfos"):
                obj = AigcImageInfo()
                obj._deserialize(item)
                self._ImageInfos.append(obj)
        if params.get("ExtraParameters") is not None:
            self._ExtraParameters = AigcImageExtraParam()
            self._ExtraParameters._deserialize(params.get("ExtraParameters"))
        if params.get("StoreCosParam") is not None:
            self._StoreCosParam = AigcStoreCosParam()
            self._StoreCosParam._deserialize(params.get("StoreCosParam"))
        self._Operator = params.get("Operator")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAigcImageTaskResponse(AbstractModel):
    r"""CreateAigcImageTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 返回的任务ID。
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        r"""返回的任务ID。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class CreateAigcVideoTaskRequest(AbstractModel):
    r"""CreateAigcVideoTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ModelName: 模型名称。
当前支持的模型列表:
Hunyuan,
Hailuo，
Kling，
Vidu，
OS，
GV。
        :type ModelName: str
        :param _ModelVersion: 指定模型特定版本号。默认使用系统当前所支持的模型稳定版本。
1. Hailuo， 可选[02、2.3]。
2. Kling，可选[2.0、2.1、2.5、O1、2.6]。
3. Vidu,可选[q2、q2-pro、q2-turbo]。
4. GV, 可选[3.1]。
5. OS，可选[2.0]。
        :type ModelVersion: str
        :param _SceneType: 指定场景生视频。
注意：仅部分模型支持指定场景。
1. Kling支持动作控制，motion_control。
2. Mingmou支持横转竖，land2port。
3. Vidu支持特效模板，template_effect。
        :type SceneType: str
        :param _Prompt: 生成视频的描述。(注：最大支持2000字符)。当未传入图片时，此参数必填。
        :type Prompt: str
        :param _NegativePrompt: 用于描述您想要阻止模型生成的内容。
注意：部分模型支持。
例如：
顶部照明、明亮的色彩
人物、动物
多辆汽车、风。
        :type NegativePrompt: str
        :param _EnhancePrompt: 默认取值为False，模型会严格地遵循指令。如果需要更精细的prompt获得最佳效果，可将此参数设置为True，将自动优化传入的prompt，以提升生成质量。
        :type EnhancePrompt: bool
        :param _ImageUrl: 用于指导视频生成的图片 URL。该URL需外网可访问。
注意：
1. 推荐图片大小不超过10M，不同模型大小限制不相同。
2. 支持的图片格式：jpeg、png。
3. 使用OS模型时，需输入图片尺寸为: 1280x720、720x1280。
        :type ImageUrl: str
        :param _LastImageUrl: 模型将以此参数传入的图片作为尾帧画面来生成视频。
支持此参数的模型：
1. GV，传入尾帧图片时，必须同时传入ImageUrl作为首帧。
2. Kling， 在Resolution:1080P的情况下 2.1版本支持首尾帧。
3. Vidu, q2-pro, q2-turbo 支持首尾帧。

注意：
1. 推荐图片大小不超过10M，各模型限制不同。
2. 支持的图片格式：jpeg、png。
        :type LastImageUrl: str
        :param _ImageInfos: 最多包含三张素材资源图片的列表，用于描述模型在生成视频时要使用的资源图片。

支持多图输入的模型：
1. GV，使用多图输入时，不可使用ImageUrl和LastImageUrl。
2. Vidu，支持多图参考生视频。q2模型1-7张图片，可通过ImageInfos里面的ReferenceType作为主体id来传入。

注意：
1. 图片大小不超过10M。
2. 支持的图片格式：jpeg、png。
        :type ImageInfos: list of AigcVideoReferenceImageInfo
        :param _Duration: 生成视频的时长。
注意：
1. Kling支持 5、10秒。默认: 5秒。
2. Hailuo的std模式可支持6、10秒，其他仅6秒。默认：6秒。
3. Vidu支持1-10秒。
4. GV支持 8秒。 默认：8秒。
5. OS支持4、8、12秒。 默认：8秒。
        :type Duration: int
        :param _ExtraParameters: 用于传入要求的额外参数。
        :type ExtraParameters: :class:`tencentcloud.mps.v20190612.models.AigcVideoExtraParam`
        :param _StoreCosParam: 文件结果指定存储Cos桶信息。 注意：需开通Cos，创建并授权MPS_QcsRole角色。
        :type StoreCosParam: :class:`tencentcloud.mps.v20190612.models.AigcStoreCosParam`
        :param _AdditionalParameters: 用于传入一些模型需要的特殊场景参数，Json格式序列化成字符串。
示例：
{\"camera_control\":{\"type\":\"simple\"}}
        :type AdditionalParameters: str
        :param _Operator: 接口操作者名称。
        :type Operator: str
        """
        self._ModelName = None
        self._ModelVersion = None
        self._SceneType = None
        self._Prompt = None
        self._NegativePrompt = None
        self._EnhancePrompt = None
        self._ImageUrl = None
        self._LastImageUrl = None
        self._ImageInfos = None
        self._Duration = None
        self._ExtraParameters = None
        self._StoreCosParam = None
        self._AdditionalParameters = None
        self._Operator = None

    @property
    def ModelName(self):
        r"""模型名称。
当前支持的模型列表:
Hunyuan,
Hailuo，
Kling，
Vidu，
OS，
GV。
        :rtype: str
        """
        return self._ModelName

    @ModelName.setter
    def ModelName(self, ModelName):
        self._ModelName = ModelName

    @property
    def ModelVersion(self):
        r"""指定模型特定版本号。默认使用系统当前所支持的模型稳定版本。
1. Hailuo， 可选[02、2.3]。
2. Kling，可选[2.0、2.1、2.5、O1、2.6]。
3. Vidu,可选[q2、q2-pro、q2-turbo]。
4. GV, 可选[3.1]。
5. OS，可选[2.0]。
        :rtype: str
        """
        return self._ModelVersion

    @ModelVersion.setter
    def ModelVersion(self, ModelVersion):
        self._ModelVersion = ModelVersion

    @property
    def SceneType(self):
        r"""指定场景生视频。
注意：仅部分模型支持指定场景。
1. Kling支持动作控制，motion_control。
2. Mingmou支持横转竖，land2port。
3. Vidu支持特效模板，template_effect。
        :rtype: str
        """
        return self._SceneType

    @SceneType.setter
    def SceneType(self, SceneType):
        self._SceneType = SceneType

    @property
    def Prompt(self):
        r"""生成视频的描述。(注：最大支持2000字符)。当未传入图片时，此参数必填。
        :rtype: str
        """
        return self._Prompt

    @Prompt.setter
    def Prompt(self, Prompt):
        self._Prompt = Prompt

    @property
    def NegativePrompt(self):
        r"""用于描述您想要阻止模型生成的内容。
注意：部分模型支持。
例如：
顶部照明、明亮的色彩
人物、动物
多辆汽车、风。
        :rtype: str
        """
        return self._NegativePrompt

    @NegativePrompt.setter
    def NegativePrompt(self, NegativePrompt):
        self._NegativePrompt = NegativePrompt

    @property
    def EnhancePrompt(self):
        r"""默认取值为False，模型会严格地遵循指令。如果需要更精细的prompt获得最佳效果，可将此参数设置为True，将自动优化传入的prompt，以提升生成质量。
        :rtype: bool
        """
        return self._EnhancePrompt

    @EnhancePrompt.setter
    def EnhancePrompt(self, EnhancePrompt):
        self._EnhancePrompt = EnhancePrompt

    @property
    def ImageUrl(self):
        r"""用于指导视频生成的图片 URL。该URL需外网可访问。
注意：
1. 推荐图片大小不超过10M，不同模型大小限制不相同。
2. 支持的图片格式：jpeg、png。
3. 使用OS模型时，需输入图片尺寸为: 1280x720、720x1280。
        :rtype: str
        """
        return self._ImageUrl

    @ImageUrl.setter
    def ImageUrl(self, ImageUrl):
        self._ImageUrl = ImageUrl

    @property
    def LastImageUrl(self):
        r"""模型将以此参数传入的图片作为尾帧画面来生成视频。
支持此参数的模型：
1. GV，传入尾帧图片时，必须同时传入ImageUrl作为首帧。
2. Kling， 在Resolution:1080P的情况下 2.1版本支持首尾帧。
3. Vidu, q2-pro, q2-turbo 支持首尾帧。

注意：
1. 推荐图片大小不超过10M，各模型限制不同。
2. 支持的图片格式：jpeg、png。
        :rtype: str
        """
        return self._LastImageUrl

    @LastImageUrl.setter
    def LastImageUrl(self, LastImageUrl):
        self._LastImageUrl = LastImageUrl

    @property
    def ImageInfos(self):
        r"""最多包含三张素材资源图片的列表，用于描述模型在生成视频时要使用的资源图片。

支持多图输入的模型：
1. GV，使用多图输入时，不可使用ImageUrl和LastImageUrl。
2. Vidu，支持多图参考生视频。q2模型1-7张图片，可通过ImageInfos里面的ReferenceType作为主体id来传入。

注意：
1. 图片大小不超过10M。
2. 支持的图片格式：jpeg、png。
        :rtype: list of AigcVideoReferenceImageInfo
        """
        return self._ImageInfos

    @ImageInfos.setter
    def ImageInfos(self, ImageInfos):
        self._ImageInfos = ImageInfos

    @property
    def Duration(self):
        r"""生成视频的时长。
注意：
1. Kling支持 5、10秒。默认: 5秒。
2. Hailuo的std模式可支持6、10秒，其他仅6秒。默认：6秒。
3. Vidu支持1-10秒。
4. GV支持 8秒。 默认：8秒。
5. OS支持4、8、12秒。 默认：8秒。
        :rtype: int
        """
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration

    @property
    def ExtraParameters(self):
        r"""用于传入要求的额外参数。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AigcVideoExtraParam`
        """
        return self._ExtraParameters

    @ExtraParameters.setter
    def ExtraParameters(self, ExtraParameters):
        self._ExtraParameters = ExtraParameters

    @property
    def StoreCosParam(self):
        r"""文件结果指定存储Cos桶信息。 注意：需开通Cos，创建并授权MPS_QcsRole角色。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AigcStoreCosParam`
        """
        return self._StoreCosParam

    @StoreCosParam.setter
    def StoreCosParam(self, StoreCosParam):
        self._StoreCosParam = StoreCosParam

    @property
    def AdditionalParameters(self):
        r"""用于传入一些模型需要的特殊场景参数，Json格式序列化成字符串。
示例：
{\"camera_control\":{\"type\":\"simple\"}}
        :rtype: str
        """
        return self._AdditionalParameters

    @AdditionalParameters.setter
    def AdditionalParameters(self, AdditionalParameters):
        self._AdditionalParameters = AdditionalParameters

    @property
    def Operator(self):
        r"""接口操作者名称。
        :rtype: str
        """
        return self._Operator

    @Operator.setter
    def Operator(self, Operator):
        self._Operator = Operator


    def _deserialize(self, params):
        self._ModelName = params.get("ModelName")
        self._ModelVersion = params.get("ModelVersion")
        self._SceneType = params.get("SceneType")
        self._Prompt = params.get("Prompt")
        self._NegativePrompt = params.get("NegativePrompt")
        self._EnhancePrompt = params.get("EnhancePrompt")
        self._ImageUrl = params.get("ImageUrl")
        self._LastImageUrl = params.get("LastImageUrl")
        if params.get("ImageInfos") is not None:
            self._ImageInfos = []
            for item in params.get("ImageInfos"):
                obj = AigcVideoReferenceImageInfo()
                obj._deserialize(item)
                self._ImageInfos.append(obj)
        self._Duration = params.get("Duration")
        if params.get("ExtraParameters") is not None:
            self._ExtraParameters = AigcVideoExtraParam()
            self._ExtraParameters._deserialize(params.get("ExtraParameters"))
        if params.get("StoreCosParam") is not None:
            self._StoreCosParam = AigcStoreCosParam()
            self._StoreCosParam._deserialize(params.get("StoreCosParam"))
        self._AdditionalParameters = params.get("AdditionalParameters")
        self._Operator = params.get("Operator")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAigcVideoTaskResponse(AbstractModel):
    r"""CreateAigcVideoTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务创建成功后，返回的任务ID。
调用查询接口，轮询获取任务进度及生成结果。
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        r"""任务创建成功后，返回的任务ID。
调用查询接口，轮询获取任务进度及生成结果。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class CreateAnimatedGraphicsTemplateRequest(AbstractModel):
    r"""CreateAnimatedGraphicsTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Fps: 帧率，取值范围：[1, 30]，单位：Hz。
        :type Fps: int
        :param _Width: 动图宽度（或长边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Width: int
        :param _Height: 动图高度（或短边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Height: int
        :param _ResolutionAdaptive: 分辨率自适应，可选值：
<li>open：开启，此时，Width 代表视频的长边，Height 表示视频的短边；</li>
<li>close：关闭，此时，Width 代表视频的宽度，Height 表示视频的高度。</li>
默认值：open。
        :type ResolutionAdaptive: str
        :param _Format: 动图格式，取值为 gif 和 webp。默认为 gif。
        :type Format: str
        :param _Quality: 图片质量，取值范围：[1, 100]，默认值为 75。
        :type Quality: float
        :param _Name: 转动图模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Comment: 模板描述信息，长度限制：256 个字符。
        :type Comment: str
        """
        self._Fps = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._Format = None
        self._Quality = None
        self._Name = None
        self._Comment = None

    @property
    def Fps(self):
        r"""帧率，取值范围：[1, 30]，单位：Hz。
        :rtype: int
        """
        return self._Fps

    @Fps.setter
    def Fps(self, Fps):
        self._Fps = Fps

    @property
    def Width(self):
        r"""动图宽度（或长边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :rtype: int
        """
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        r"""动图高度（或短边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :rtype: int
        """
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        r"""分辨率自适应，可选值：
<li>open：开启，此时，Width 代表视频的长边，Height 表示视频的短边；</li>
<li>close：关闭，此时，Width 代表视频的宽度，Height 表示视频的高度。</li>
默认值：open。
        :rtype: str
        """
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def Format(self):
        r"""动图格式，取值为 gif 和 webp。默认为 gif。
        :rtype: str
        """
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def Quality(self):
        r"""图片质量，取值范围：[1, 100]，默认值为 75。
        :rtype: float
        """
        return self._Quality

    @Quality.setter
    def Quality(self, Quality):
        self._Quality = Quality

    @property
    def Name(self):
        r"""转动图模板名称，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        r"""模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment


    def _deserialize(self, params):
        self._Fps = params.get("Fps")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._Format = params.get("Format")
        self._Quality = params.get("Quality")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAnimatedGraphicsTemplateResponse(AbstractModel):
    r"""CreateAnimatedGraphicsTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 转动图模板唯一标识。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""转动图模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateAsrHotwordsRequest(AbstractModel):
    r"""CreateAsrHotwords请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Type: 0 临时热词 1 文件热词
        :type Type: int
        :param _Name: 热词库名称
        :type Name: str
        :param _Content: 热词库文本，Type为 0 必选
        :type Content: str
        :param _FileContent: 热词库文件的 base64 的内容，Type 为 1 必选


        :type FileContent: str
        :param _FileName: 上传的文件名
        :type FileName: str
        """
        self._Type = None
        self._Name = None
        self._Content = None
        self._FileContent = None
        self._FileName = None

    @property
    def Type(self):
        r"""0 临时热词 1 文件热词
        :rtype: int
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        r"""热词库名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Content(self):
        r"""热词库文本，Type为 0 必选
        :rtype: str
        """
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content

    @property
    def FileContent(self):
        r"""热词库文件的 base64 的内容，Type 为 1 必选


        :rtype: str
        """
        return self._FileContent

    @FileContent.setter
    def FileContent(self, FileContent):
        self._FileContent = FileContent

    @property
    def FileName(self):
        r"""上传的文件名
        :rtype: str
        """
        return self._FileName

    @FileName.setter
    def FileName(self, FileName):
        self._FileName = FileName


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        self._Content = params.get("Content")
        self._FileContent = params.get("FileContent")
        self._FileName = params.get("FileName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAsrHotwordsResponse(AbstractModel):
    r"""CreateAsrHotwords返回参数结构体

    """

    def __init__(self):
        r"""
        :param _HotwordsId: 热词库 id
        :type HotwordsId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._HotwordsId = None
        self._RequestId = None

    @property
    def HotwordsId(self):
        r"""热词库 id
        :rtype: str
        """
        return self._HotwordsId

    @HotwordsId.setter
    def HotwordsId(self, HotwordsId):
        self._HotwordsId = HotwordsId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._HotwordsId = params.get("HotwordsId")
        self._RequestId = params.get("RequestId")


class CreateBlindWatermarkTemplateRequest(AbstractModel):
    r"""CreateBlindWatermarkTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Type: 数字水印类型，可选值：<li>blind-basic：基础版权数字水印；</li><li>blind-nagra：NAGRA水印；</li>
        :type Type: str
        :param _TextContent: 数字水印文字内容，长度不超过64个字符，NAGRA水印类型的模板创建后不支持修改文字内容。
        :type TextContent: str
        :param _Name: 数字水印模板名称，支持中文、英文、数字、_、-和. 六种格式，长度限制：64 个字符。
        :type Name: str
        :param _Comment: 数字水印模板描述信息，长度限制：256 个字符。
        :type Comment: str
        """
        self._Type = None
        self._TextContent = None
        self._Name = None
        self._Comment = None

    @property
    def Type(self):
        r"""数字水印类型，可选值：<li>blind-basic：基础版权数字水印；</li><li>blind-nagra：NAGRA水印；</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def TextContent(self):
        r"""数字水印文字内容，长度不超过64个字符，NAGRA水印类型的模板创建后不支持修改文字内容。
        :rtype: str
        """
        return self._TextContent

    @TextContent.setter
    def TextContent(self, TextContent):
        self._TextContent = TextContent

    @property
    def Name(self):
        r"""数字水印模板名称，支持中文、英文、数字、_、-和. 六种格式，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        r"""数字水印模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._TextContent = params.get("TextContent")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateBlindWatermarkTemplateResponse(AbstractModel):
    r"""CreateBlindWatermarkTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 数字水印模板唯一标识。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""数字水印模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateContentReviewTemplateRequest(AbstractModel):
    r"""CreateContentReviewTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 内容审核模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Comment: 内容审核模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _PornConfigure: 鉴黄任务控制参数。
        :type PornConfigure: :class:`tencentcloud.mps.v20190612.models.PornConfigureInfo`
        :param _TerrorismConfigure: 涉暴任务控制参数。
        :type TerrorismConfigure: :class:`tencentcloud.mps.v20190612.models.TerrorismConfigureInfo`
        :param _PoliticalConfigure: 涉敏任务控制参数。
        :type PoliticalConfigure: :class:`tencentcloud.mps.v20190612.models.PoliticalConfigureInfo`
        :param _ProhibitedConfigure: 违禁控制参数。违禁内容包括：
<li>谩骂；</li>
<li>涉毒违法。</li>
注意：此参数尚未支持。
        :type ProhibitedConfigure: :class:`tencentcloud.mps.v20190612.models.ProhibitedConfigureInfo`
        :param _UserDefineConfigure: 用户自定义内容审核控制参数。
        :type UserDefineConfigure: :class:`tencentcloud.mps.v20190612.models.UserDefineConfigureInfo`
        """
        self._Name = None
        self._Comment = None
        self._PornConfigure = None
        self._TerrorismConfigure = None
        self._PoliticalConfigure = None
        self._ProhibitedConfigure = None
        self._UserDefineConfigure = None

    @property
    def Name(self):
        r"""内容审核模板名称，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        r"""内容审核模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def PornConfigure(self):
        r"""鉴黄任务控制参数。
        :rtype: :class:`tencentcloud.mps.v20190612.models.PornConfigureInfo`
        """
        return self._PornConfigure

    @PornConfigure.setter
    def PornConfigure(self, PornConfigure):
        self._PornConfigure = PornConfigure

    @property
    def TerrorismConfigure(self):
        r"""涉暴任务控制参数。
        :rtype: :class:`tencentcloud.mps.v20190612.models.TerrorismConfigureInfo`
        """
        return self._TerrorismConfigure

    @TerrorismConfigure.setter
    def TerrorismConfigure(self, TerrorismConfigure):
        self._TerrorismConfigure = TerrorismConfigure

    @property
    def PoliticalConfigure(self):
        r"""涉敏任务控制参数。
        :rtype: :class:`tencentcloud.mps.v20190612.models.PoliticalConfigureInfo`
        """
        return self._PoliticalConfigure

    @PoliticalConfigure.setter
    def PoliticalConfigure(self, PoliticalConfigure):
        self._PoliticalConfigure = PoliticalConfigure

    @property
    def ProhibitedConfigure(self):
        r"""违禁控制参数。违禁内容包括：
<li>谩骂；</li>
<li>涉毒违法。</li>
注意：此参数尚未支持。
        :rtype: :class:`tencentcloud.mps.v20190612.models.ProhibitedConfigureInfo`
        """
        return self._ProhibitedConfigure

    @ProhibitedConfigure.setter
    def ProhibitedConfigure(self, ProhibitedConfigure):
        self._ProhibitedConfigure = ProhibitedConfigure

    @property
    def UserDefineConfigure(self):
        r"""用户自定义内容审核控制参数。
        :rtype: :class:`tencentcloud.mps.v20190612.models.UserDefineConfigureInfo`
        """
        return self._UserDefineConfigure

    @UserDefineConfigure.setter
    def UserDefineConfigure(self, UserDefineConfigure):
        self._UserDefineConfigure = UserDefineConfigure


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("PornConfigure") is not None:
            self._PornConfigure = PornConfigureInfo()
            self._PornConfigure._deserialize(params.get("PornConfigure"))
        if params.get("TerrorismConfigure") is not None:
            self._TerrorismConfigure = TerrorismConfigureInfo()
            self._TerrorismConfigure._deserialize(params.get("TerrorismConfigure"))
        if params.get("PoliticalConfigure") is not None:
            self._PoliticalConfigure = PoliticalConfigureInfo()
            self._PoliticalConfigure._deserialize(params.get("PoliticalConfigure"))
        if params.get("ProhibitedConfigure") is not None:
            self._ProhibitedConfigure = ProhibitedConfigureInfo()
            self._ProhibitedConfigure._deserialize(params.get("ProhibitedConfigure"))
        if params.get("UserDefineConfigure") is not None:
            self._UserDefineConfigure = UserDefineConfigureInfo()
            self._UserDefineConfigure._deserialize(params.get("UserDefineConfigure"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateContentReviewTemplateResponse(AbstractModel):
    r"""CreateContentReviewTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 内容审核模板唯一标识。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""内容审核模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateImageSpriteTemplateRequest(AbstractModel):
    r"""CreateImageSpriteTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SampleType: 采样类型，取值：
<li>Percent：按百分比。</li>
<li>Time：按时间间隔。</li>
        :type SampleType: str
        :param _SampleInterval: 采样间隔。
<li>当 SampleType 为 Percent 时，指定采样间隔的百分比。</li>
<li>当 SampleType 为 Time 时，指定采样间隔的时间，单位为秒。</li>
        :type SampleInterval: int
        :param _RowCount: 雪碧图中小图的行数。
        :type RowCount: int
        :param _ColumnCount: 雪碧图中小图的列数。
        :type ColumnCount: int
        :param _Name: 雪碧图模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Width: 雪碧图中小图的宽度（或长边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Width: int
        :param _Height: 雪碧图中小图的高度（或短边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Height: int
        :param _ResolutionAdaptive: 分辨率自适应，可选值：
<li>open：开启，此时，Width 代表视频的长边，Height 表示视频的短边；</li>
<li>close：关闭，此时，Width 代表视频的宽度，Height 表示视频的高度。</li>
默认值：open。
        :type ResolutionAdaptive: str
        :param _FillType: 填充方式，当视频流配置宽高参数与原始视频的宽高比不一致时，对转码的处理方式，即为“填充”。可选填充方式：
<li> stretch：拉伸，对每一帧进行拉伸，填满整个画面，可能导致转码后的视频被“压扁“或者“拉长“；</li>
<li>black：留黑，保持视频宽高比不变，边缘剩余部分使用黑色填充。</li>
默认值：black 。
        :type FillType: str
        :param _Comment: 模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _Format: 图片格式，取值为 jpg、png、webp。默认为 jpg。
        :type Format: str
        """
        self._SampleType = None
        self._SampleInterval = None
        self._RowCount = None
        self._ColumnCount = None
        self._Name = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._FillType = None
        self._Comment = None
        self._Format = None

    @property
    def SampleType(self):
        r"""采样类型，取值：
<li>Percent：按百分比。</li>
<li>Time：按时间间隔。</li>
        :rtype: str
        """
        return self._SampleType

    @SampleType.setter
    def SampleType(self, SampleType):
        self._SampleType = SampleType

    @property
    def SampleInterval(self):
        r"""采样间隔。
<li>当 SampleType 为 Percent 时，指定采样间隔的百分比。</li>
<li>当 SampleType 为 Time 时，指定采样间隔的时间，单位为秒。</li>
        :rtype: int
        """
        return self._SampleInterval

    @SampleInterval.setter
    def SampleInterval(self, SampleInterval):
        self._SampleInterval = SampleInterval

    @property
    def RowCount(self):
        r"""雪碧图中小图的行数。
        :rtype: int
        """
        return self._RowCount

    @RowCount.setter
    def RowCount(self, RowCount):
        self._RowCount = RowCount

    @property
    def ColumnCount(self):
        r"""雪碧图中小图的列数。
        :rtype: int
        """
        return self._ColumnCount

    @ColumnCount.setter
    def ColumnCount(self, ColumnCount):
        self._ColumnCount = ColumnCount

    @property
    def Name(self):
        r"""雪碧图模板名称，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Width(self):
        r"""雪碧图中小图的宽度（或长边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :rtype: int
        """
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        r"""雪碧图中小图的高度（或短边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :rtype: int
        """
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        r"""分辨率自适应，可选值：
<li>open：开启，此时，Width 代表视频的长边，Height 表示视频的短边；</li>
<li>close：关闭，此时，Width 代表视频的宽度，Height 表示视频的高度。</li>
默认值：open。
        :rtype: str
        """
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def FillType(self):
        r"""填充方式，当视频流配置宽高参数与原始视频的宽高比不一致时，对转码的处理方式，即为“填充”。可选填充方式：
<li> stretch：拉伸，对每一帧进行拉伸，填满整个画面，可能导致转码后的视频被“压扁“或者“拉长“；</li>
<li>black：留黑，保持视频宽高比不变，边缘剩余部分使用黑色填充。</li>
默认值：black 。
        :rtype: str
        """
        return self._FillType

    @FillType.setter
    def FillType(self, FillType):
        self._FillType = FillType

    @property
    def Comment(self):
        r"""模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def Format(self):
        r"""图片格式，取值为 jpg、png、webp。默认为 jpg。
        :rtype: str
        """
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format


    def _deserialize(self, params):
        self._SampleType = params.get("SampleType")
        self._SampleInterval = params.get("SampleInterval")
        self._RowCount = params.get("RowCount")
        self._ColumnCount = params.get("ColumnCount")
        self._Name = params.get("Name")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._FillType = params.get("FillType")
        self._Comment = params.get("Comment")
        self._Format = params.get("Format")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateImageSpriteTemplateResponse(AbstractModel):
    r"""CreateImageSpriteTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 雪碧图模板唯一标识。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""雪碧图模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateInput(AbstractModel):
    r"""创建输入的配置信息。

    """

    def __init__(self):
        r"""
        :param _InputName: 输入名称，可填大小写、数字和下划线，长度为[1, 32]。
        :type InputName: str
        :param _Protocol: 输入的协议，可选[SRT|RTP|RTMP|RTMP_PULL|RTSP_PULL|RIST]。
        :type Protocol: str
        :param _Description: 输入描述，长度为[0, 255]。
        :type Description: str
        :param _AllowIpList: 输入的IP白名单，格式为CIDR。
        :type AllowIpList: list of str
        :param _SRTSettings: 输入的SRT配置信息。
        :type SRTSettings: :class:`tencentcloud.mps.v20190612.models.CreateInputSRTSettings`
        :param _RTPSettings: 输入的RTP配置信息。
        :type RTPSettings: :class:`tencentcloud.mps.v20190612.models.CreateInputRTPSettings`
        :param _FailOver: 输入的主备开关，可选[OPEN|CLOSE]，默认为CLOSE。
        :type FailOver: str
        :param _RTMPPullSettings: 输入的RTMP_PULL配置信息。
        :type RTMPPullSettings: :class:`tencentcloud.mps.v20190612.models.CreateInputRTMPPullSettings`
        :param _RTSPPullSettings: 输入的RTSP_PULL配置信息。
        :type RTSPPullSettings: :class:`tencentcloud.mps.v20190612.models.CreateInputRTSPPullSettings`
        :param _HLSPullSettings: 输入的HLS_PULL配置信息。
        :type HLSPullSettings: :class:`tencentcloud.mps.v20190612.models.CreateInputHLSPullSettings`
        :param _ResilientStream: 延播平滑吐流配置信息。
        :type ResilientStream: :class:`tencentcloud.mps.v20190612.models.ResilientStreamConf`
        :param _SecurityGroupIds: 绑定的输入安全组 ID。 
        :type SecurityGroupIds: list of str
        :param _Zones: 可用区，非必填，如果开启容灾必须输入两个不同的可用区，否则最多只允许输入一个可用区。	
        :type Zones: list of str
        :param _RISTSettings: 输入的RIST配置信息。
        :type RISTSettings: :class:`tencentcloud.mps.v20190612.models.CreateInputRISTSettings`
        :param _InputRegion: 输入节点的地区
        :type InputRegion: str
        :param _FailOverOption: 冷热备相关
        :type FailOverOption: :class:`tencentcloud.mps.v20190612.models.FailOverOption`
        """
        self._InputName = None
        self._Protocol = None
        self._Description = None
        self._AllowIpList = None
        self._SRTSettings = None
        self._RTPSettings = None
        self._FailOver = None
        self._RTMPPullSettings = None
        self._RTSPPullSettings = None
        self._HLSPullSettings = None
        self._ResilientStream = None
        self._SecurityGroupIds = None
        self._Zones = None
        self._RISTSettings = None
        self._InputRegion = None
        self._FailOverOption = None

    @property
    def InputName(self):
        r"""输入名称，可填大小写、数字和下划线，长度为[1, 32]。
        :rtype: str
        """
        return self._InputName

    @InputName.setter
    def InputName(self, InputName):
        self._InputName = InputName

    @property
    def Protocol(self):
        r"""输入的协议，可选[SRT|RTP|RTMP|RTMP_PULL|RTSP_PULL|RIST]。
        :rtype: str
        """
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def Description(self):
        r"""输入描述，长度为[0, 255]。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def AllowIpList(self):
        r"""输入的IP白名单，格式为CIDR。
        :rtype: list of str
        """
        return self._AllowIpList

    @AllowIpList.setter
    def AllowIpList(self, AllowIpList):
        self._AllowIpList = AllowIpList

    @property
    def SRTSettings(self):
        r"""输入的SRT配置信息。
        :rtype: :class:`tencentcloud.mps.v20190612.models.CreateInputSRTSettings`
        """
        return self._SRTSettings

    @SRTSettings.setter
    def SRTSettings(self, SRTSettings):
        self._SRTSettings = SRTSettings

    @property
    def RTPSettings(self):
        r"""输入的RTP配置信息。
        :rtype: :class:`tencentcloud.mps.v20190612.models.CreateInputRTPSettings`
        """
        return self._RTPSettings

    @RTPSettings.setter
    def RTPSettings(self, RTPSettings):
        self._RTPSettings = RTPSettings

    @property
    def FailOver(self):
        r"""输入的主备开关，可选[OPEN|CLOSE]，默认为CLOSE。
        :rtype: str
        """
        return self._FailOver

    @FailOver.setter
    def FailOver(self, FailOver):
        self._FailOver = FailOver

    @property
    def RTMPPullSettings(self):
        r"""输入的RTMP_PULL配置信息。
        :rtype: :class:`tencentcloud.mps.v20190612.models.CreateInputRTMPPullSettings`
        """
        return self._RTMPPullSettings

    @RTMPPullSettings.setter
    def RTMPPullSettings(self, RTMPPullSettings):
        self._RTMPPullSettings = RTMPPullSettings

    @property
    def RTSPPullSettings(self):
        r"""输入的RTSP_PULL配置信息。
        :rtype: :class:`tencentcloud.mps.v20190612.models.CreateInputRTSPPullSettings`
        """
        return self._RTSPPullSettings

    @RTSPPullSettings.setter
    def RTSPPullSettings(self, RTSPPullSettings):
        self._RTSPPullSettings = RTSPPullSettings

    @property
    def HLSPullSettings(self):
        r"""输入的HLS_PULL配置信息。
        :rtype: :class:`tencentcloud.mps.v20190612.models.CreateInputHLSPullSettings`
        """
        return self._HLSPullSettings

    @HLSPullSettings.setter
    def HLSPullSettings(self, HLSPullSettings):
        self._HLSPullSettings = HLSPullSettings

    @property
    def ResilientStream(self):
        r"""延播平滑吐流配置信息。
        :rtype: :class:`tencentcloud.mps.v20190612.models.ResilientStreamConf`
        """
        return self._ResilientStream

    @ResilientStream.setter
    def ResilientStream(self, ResilientStream):
        self._ResilientStream = ResilientStream

    @property
    def SecurityGroupIds(self):
        r"""绑定的输入安全组 ID。 
        :rtype: list of str
        """
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds

    @property
    def Zones(self):
        r"""可用区，非必填，如果开启容灾必须输入两个不同的可用区，否则最多只允许输入一个可用区。	
        :rtype: list of str
        """
        return self._Zones

    @Zones.setter
    def Zones(self, Zones):
        self._Zones = Zones

    @property
    def RISTSettings(self):
        r"""输入的RIST配置信息。
        :rtype: :class:`tencentcloud.mps.v20190612.models.CreateInputRISTSettings`
        """
        return self._RISTSettings

    @RISTSettings.setter
    def RISTSettings(self, RISTSettings):
        self._RISTSettings = RISTSettings

    @property
    def InputRegion(self):
        r"""输入节点的地区
        :rtype: str
        """
        return self._InputRegion

    @InputRegion.setter
    def InputRegion(self, InputRegion):
        self._InputRegion = InputRegion

    @property
    def FailOverOption(self):
        r"""冷热备相关
        :rtype: :class:`tencentcloud.mps.v20190612.models.FailOverOption`
        """
        return self._FailOverOption

    @FailOverOption.setter
    def FailOverOption(self, FailOverOption):
        self._FailOverOption = FailOverOption


    def _deserialize(self, params):
        self._InputName = params.get("InputName")
        self._Protocol = params.get("Protocol")
        self._Description = params.get("Description")
        self._AllowIpList = params.get("AllowIpList")
        if params.get("SRTSettings") is not None:
            self._SRTSettings = CreateInputSRTSettings()
            self._SRTSettings._deserialize(params.get("SRTSettings"))
        if params.get("RTPSettings") is not None:
            self._RTPSettings = CreateInputRTPSettings()
            self._RTPSettings._deserialize(params.get("RTPSettings"))
        self._FailOver = params.get("FailOver")
        if params.get("RTMPPullSettings") is not None:
            self._RTMPPullSettings = CreateInputRTMPPullSettings()
            self._RTMPPullSettings._deserialize(params.get("RTMPPullSettings"))
        if params.get("RTSPPullSettings") is not None:
            self._RTSPPullSettings = CreateInputRTSPPullSettings()
            self._RTSPPullSettings._deserialize(params.get("RTSPPullSettings"))
        if params.get("HLSPullSettings") is not None:
            self._HLSPullSettings = CreateInputHLSPullSettings()
            self._HLSPullSettings._deserialize(params.get("HLSPullSettings"))
        if params.get("ResilientStream") is not None:
            self._ResilientStream = ResilientStreamConf()
            self._ResilientStream._deserialize(params.get("ResilientStream"))
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        self._Zones = params.get("Zones")
        if params.get("RISTSettings") is not None:
            self._RISTSettings = CreateInputRISTSettings()
            self._RISTSettings._deserialize(params.get("RISTSettings"))
        self._InputRegion = params.get("InputRegion")
        if params.get("FailOverOption") is not None:
            self._FailOverOption = FailOverOption()
            self._FailOverOption._deserialize(params.get("FailOverOption"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateInputHLSPullSettings(AbstractModel):
    r"""创建的输入HLS拉流的配置信息。

    """

    def __init__(self):
        r"""
        :param _SourceAddresses: HLS源站的源站地址，有且只能有一个。
        :type SourceAddresses: list of HLSPullSourceAddress
        """
        self._SourceAddresses = None

    @property
    def SourceAddresses(self):
        r"""HLS源站的源站地址，有且只能有一个。
        :rtype: list of HLSPullSourceAddress
        """
        return self._SourceAddresses

    @SourceAddresses.setter
    def SourceAddresses(self, SourceAddresses):
        self._SourceAddresses = SourceAddresses


    def _deserialize(self, params):
        if params.get("SourceAddresses") is not None:
            self._SourceAddresses = []
            for item in params.get("SourceAddresses"):
                obj = HLSPullSourceAddress()
                obj._deserialize(item)
                self._SourceAddresses.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateInputRISTSettings(AbstractModel):
    r"""创建的输入RIST的配置信息。

    """

    def __init__(self):
        r"""
        :param _Mode: RIST模式，可选[LISTENER]，默认为LISTENER。
        :type Mode: str
        :param _Profile: RIST配置方案，可选[MAIN|SIMPLE]，默认为MAIN。
        :type Profile: str
        :param _Buffer: RIST缓冲区大小，单位为毫秒。最小值为50毫秒，最大值为5000毫秒。默认值：120
        :type Buffer: int
        """
        self._Mode = None
        self._Profile = None
        self._Buffer = None

    @property
    def Mode(self):
        r"""RIST模式，可选[LISTENER]，默认为LISTENER。
        :rtype: str
        """
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def Profile(self):
        r"""RIST配置方案，可选[MAIN|SIMPLE]，默认为MAIN。
        :rtype: str
        """
        return self._Profile

    @Profile.setter
    def Profile(self, Profile):
        self._Profile = Profile

    @property
    def Buffer(self):
        r"""RIST缓冲区大小，单位为毫秒。最小值为50毫秒，最大值为5000毫秒。默认值：120
        :rtype: int
        """
        return self._Buffer

    @Buffer.setter
    def Buffer(self, Buffer):
        self._Buffer = Buffer


    def _deserialize(self, params):
        self._Mode = params.get("Mode")
        self._Profile = params.get("Profile")
        self._Buffer = params.get("Buffer")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateInputRTMPPullSettings(AbstractModel):
    r"""创建的输入RTMP拉流的配置信息。

    """

    def __init__(self):
        r"""
        :param _SourceAddresses: RTMP源站的源站地址，有且只能有一个。
        :type SourceAddresses: list of RTMPPullSourceAddress
        """
        self._SourceAddresses = None

    @property
    def SourceAddresses(self):
        r"""RTMP源站的源站地址，有且只能有一个。
        :rtype: list of RTMPPullSourceAddress
        """
        return self._SourceAddresses

    @SourceAddresses.setter
    def SourceAddresses(self, SourceAddresses):
        self._SourceAddresses = SourceAddresses


    def _deserialize(self, params):
        if params.get("SourceAddresses") is not None:
            self._SourceAddresses = []
            for item in params.get("SourceAddresses"):
                obj = RTMPPullSourceAddress()
                obj._deserialize(item)
                self._SourceAddresses.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateInputRTPSettings(AbstractModel):
    r"""创建输入的RTP配置信息。

    """

    def __init__(self):
        r"""
        :param _FEC: 默认为“none”，可选值['none']。
        :type FEC: str
        :param _IdleTimeout: 空闲超时时间，默认5000，单位ms，范围为[1000, 10000]。
        :type IdleTimeout: int
        """
        self._FEC = None
        self._IdleTimeout = None

    @property
    def FEC(self):
        r"""默认为“none”，可选值['none']。
        :rtype: str
        """
        return self._FEC

    @FEC.setter
    def FEC(self, FEC):
        self._FEC = FEC

    @property
    def IdleTimeout(self):
        r"""空闲超时时间，默认5000，单位ms，范围为[1000, 10000]。
        :rtype: int
        """
        return self._IdleTimeout

    @IdleTimeout.setter
    def IdleTimeout(self, IdleTimeout):
        self._IdleTimeout = IdleTimeout


    def _deserialize(self, params):
        self._FEC = params.get("FEC")
        self._IdleTimeout = params.get("IdleTimeout")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateInputRTSPPullSettings(AbstractModel):
    r"""创建的输入RTSP拉流的配置信息。

    """

    def __init__(self):
        r"""
        :param _SourceAddresses: RTSP源站的源站地址，有且只能有一个。
        :type SourceAddresses: list of RTSPPullSourceAddress
        """
        self._SourceAddresses = None

    @property
    def SourceAddresses(self):
        r"""RTSP源站的源站地址，有且只能有一个。
        :rtype: list of RTSPPullSourceAddress
        """
        return self._SourceAddresses

    @SourceAddresses.setter
    def SourceAddresses(self, SourceAddresses):
        self._SourceAddresses = SourceAddresses


    def _deserialize(self, params):
        if params.get("SourceAddresses") is not None:
            self._SourceAddresses = []
            for item in params.get("SourceAddresses"):
                obj = RTSPPullSourceAddress()
                obj._deserialize(item)
                self._SourceAddresses.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateInputSRTSettings(AbstractModel):
    r"""创建的输入SRT的配置信息。

    """

    def __init__(self):
        r"""
        :param _Mode: SRT模式，可选[LISTENER|CALLER]，默认为LISTENER。
        :type Mode: str
        :param _StreamId: 流Id，可选大小写字母、数字和特殊字符（.#!:&,=_-），长度为0~512。具体格式可以参考：https://github.com/Haivision/srt/blob/master/docs/features/access-control.md#standard-keys。
        :type StreamId: str
        :param _Latency: 延迟，默认120，单位ms，范围为[0, 3000]。
        :type Latency: int
        :param _RecvLatency: 接收延迟，默认120，单位ms，范围为[0, 3000]。
        :type RecvLatency: int
        :param _PeerLatency: 对端延迟，默认120，单位ms，范围为[0, 3000]。
        :type PeerLatency: int
        :param _PeerIdleTimeout: 对端超时时间，默认5000，单位ms，范围为[1000, 10000]。
        :type PeerIdleTimeout: int
        :param _Passphrase: 解密密钥，默认为空，表示不加密。只可填ascii码值，长度为[10, 79]。
        :type Passphrase: str
        :param _PbKeyLen: 密钥长度，默认为0，可选[0|16|24|32]。
        :type PbKeyLen: int
        :param _SourceAddresses: SRT对端地址，当Mode为CALLER时必填，且只能填1组。
        :type SourceAddresses: list of SRTSourceAddressReq
        :param _FEC: SRT FEC 设置
        :type FEC: :class:`tencentcloud.mps.v20190612.models.SRTFECSimpleOptions`
        """
        self._Mode = None
        self._StreamId = None
        self._Latency = None
        self._RecvLatency = None
        self._PeerLatency = None
        self._PeerIdleTimeout = None
        self._Passphrase = None
        self._PbKeyLen = None
        self._SourceAddresses = None
        self._FEC = None

    @property
    def Mode(self):
        r"""SRT模式，可选[LISTENER|CALLER]，默认为LISTENER。
        :rtype: str
        """
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def StreamId(self):
        r"""流Id，可选大小写字母、数字和特殊字符（.#!:&,=_-），长度为0~512。具体格式可以参考：https://github.com/Haivision/srt/blob/master/docs/features/access-control.md#standard-keys。
        :rtype: str
        """
        return self._StreamId

    @StreamId.setter
    def StreamId(self, StreamId):
        self._StreamId = StreamId

    @property
    def Latency(self):
        r"""延迟，默认120，单位ms，范围为[0, 3000]。
        :rtype: int
        """
        return self._Latency

    @Latency.setter
    def Latency(self, Latency):
        self._Latency = Latency

    @property
    def RecvLatency(self):
        r"""接收延迟，默认120，单位ms，范围为[0, 3000]。
        :rtype: int
        """
        return self._RecvLatency

    @RecvLatency.setter
    def RecvLatency(self, RecvLatency):
        self._RecvLatency = RecvLatency

    @property
    def PeerLatency(self):
        r"""对端延迟，默认120，单位ms，范围为[0, 3000]。
        :rtype: int
        """
        return self._PeerLatency

    @PeerLatency.setter
    def PeerLatency(self, PeerLatency):
        self._PeerLatency = PeerLatency

    @property
    def PeerIdleTimeout(self):
        r"""对端超时时间，默认5000，单位ms，范围为[1000, 10000]。
        :rtype: int
        """
        return self._PeerIdleTimeout

    @PeerIdleTimeout.setter
    def PeerIdleTimeout(self, PeerIdleTimeout):
        self._PeerIdleTimeout = PeerIdleTimeout

    @property
    def Passphrase(self):
        r"""解密密钥，默认为空，表示不加密。只可填ascii码值，长度为[10, 79]。
        :rtype: str
        """
        return self._Passphrase

    @Passphrase.setter
    def Passphrase(self, Passphrase):
        self._Passphrase = Passphrase

    @property
    def PbKeyLen(self):
        r"""密钥长度，默认为0，可选[0|16|24|32]。
        :rtype: int
        """
        return self._PbKeyLen

    @PbKeyLen.setter
    def PbKeyLen(self, PbKeyLen):
        self._PbKeyLen = PbKeyLen

    @property
    def SourceAddresses(self):
        r"""SRT对端地址，当Mode为CALLER时必填，且只能填1组。
        :rtype: list of SRTSourceAddressReq
        """
        return self._SourceAddresses

    @SourceAddresses.setter
    def SourceAddresses(self, SourceAddresses):
        self._SourceAddresses = SourceAddresses

    @property
    def FEC(self):
        r"""SRT FEC 设置
        :rtype: :class:`tencentcloud.mps.v20190612.models.SRTFECSimpleOptions`
        """
        return self._FEC

    @FEC.setter
    def FEC(self, FEC):
        self._FEC = FEC


    def _deserialize(self, params):
        self._Mode = params.get("Mode")
        self._StreamId = params.get("StreamId")
        self._Latency = params.get("Latency")
        self._RecvLatency = params.get("RecvLatency")
        self._PeerLatency = params.get("PeerLatency")
        self._PeerIdleTimeout = params.get("PeerIdleTimeout")
        self._Passphrase = params.get("Passphrase")
        self._PbKeyLen = params.get("PbKeyLen")
        if params.get("SourceAddresses") is not None:
            self._SourceAddresses = []
            for item in params.get("SourceAddresses"):
                obj = SRTSourceAddressReq()
                obj._deserialize(item)
                self._SourceAddresses.append(obj)
        if params.get("FEC") is not None:
            self._FEC = SRTFECSimpleOptions()
            self._FEC._deserialize(params.get("FEC"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateLiveRecordTemplateRequest(AbstractModel):
    r"""CreateLiveRecordTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _HLSConfigure: HLS配置参数，和MP4Configure需要二选一必填。
        :type HLSConfigure: :class:`tencentcloud.mps.v20190612.models.HLSConfigureInfo`
        :param _MP4Configure: MP4配置参数，和HLSConfigure需要二选一必填。
        :type MP4Configure: :class:`tencentcloud.mps.v20190612.models.MP4ConfigureInfo`
        :param _Name: 录制模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Comment: 模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _RecordType: 录制类型，取值为video（音视频录制）、audio（纯音频录制）、auto（自动探测）。不填时默认值为video。
        :type RecordType: str
        """
        self._HLSConfigure = None
        self._MP4Configure = None
        self._Name = None
        self._Comment = None
        self._RecordType = None

    @property
    def HLSConfigure(self):
        r"""HLS配置参数，和MP4Configure需要二选一必填。
        :rtype: :class:`tencentcloud.mps.v20190612.models.HLSConfigureInfo`
        """
        return self._HLSConfigure

    @HLSConfigure.setter
    def HLSConfigure(self, HLSConfigure):
        self._HLSConfigure = HLSConfigure

    @property
    def MP4Configure(self):
        r"""MP4配置参数，和HLSConfigure需要二选一必填。
        :rtype: :class:`tencentcloud.mps.v20190612.models.MP4ConfigureInfo`
        """
        return self._MP4Configure

    @MP4Configure.setter
    def MP4Configure(self, MP4Configure):
        self._MP4Configure = MP4Configure

    @property
    def Name(self):
        r"""录制模板名称，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        r"""模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def RecordType(self):
        r"""录制类型，取值为video（音视频录制）、audio（纯音频录制）、auto（自动探测）。不填时默认值为video。
        :rtype: str
        """
        return self._RecordType

    @RecordType.setter
    def RecordType(self, RecordType):
        self._RecordType = RecordType


    def _deserialize(self, params):
        if params.get("HLSConfigure") is not None:
            self._HLSConfigure = HLSConfigureInfo()
            self._HLSConfigure._deserialize(params.get("HLSConfigure"))
        if params.get("MP4Configure") is not None:
            self._MP4Configure = MP4ConfigureInfo()
            self._MP4Configure._deserialize(params.get("MP4Configure"))
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        self._RecordType = params.get("RecordType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateLiveRecordTemplateResponse(AbstractModel):
    r"""CreateLiveRecordTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 录制模板唯一标识。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""录制模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateMediaEvaluationRequest(AbstractModel):
    r"""CreateMediaEvaluation请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InputInfo: 评测的原文件输入信息。目前输入对象的类型有 COS 和 URL。
        :type InputInfo: :class:`tencentcloud.mps.v20190612.models.MediaInputInfo`
        :param _EvaluationTask: 评测任务参数。
        :type EvaluationTask: :class:`tencentcloud.mps.v20190612.models.EvaluationTaskInput`
        :param _OutputStorage: 评测的输出文件的目标存储。不填则继承 InputInfo 中的存储位置。目前输出对象存储位置的类型有COS。
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _OutputDir: 评测生成文件的输出目录，必选以 / 开头和结尾，如/movie/201907/。 如果不填，表示与 InputInfo 中文件所在的目录一致。
        :type OutputDir: str
        :param _TaskNotifyConfig: 任务的事件通知信息，不填代表不获取事件通知。
        :type TaskNotifyConfig: :class:`tencentcloud.mps.v20190612.models.TaskNotifyConfig`
        :param _TasksPriority: 任务优先级，数值越大优先级越高，取值范围是-10到 10，不填代表0。
        :type TasksPriority: int
        :param _SessionId: 用于去重的识别码，如果三天内曾有过相同的识别码的请求，则本次的请求会返回错误。最长 50 个字符，不带或者带空字符串表示不做去重。
        :type SessionId: str
        :param _SessionContext: 来源上下文，用于透传用户请求信息，任务流状态变更回调将返回该字段值，最长 1000 个字符。
        :type SessionContext: str
        """
        self._InputInfo = None
        self._EvaluationTask = None
        self._OutputStorage = None
        self._OutputDir = None
        self._TaskNotifyConfig = None
        self._TasksPriority = None
        self._SessionId = None
        self._SessionContext = None

    @property
    def InputInfo(self):
        r"""评测的原文件输入信息。目前输入对象的类型有 COS 和 URL。
        :rtype: :class:`tencentcloud.mps.v20190612.models.MediaInputInfo`
        """
        return self._InputInfo

    @InputInfo.setter
    def InputInfo(self, InputInfo):
        self._InputInfo = InputInfo

    @property
    def EvaluationTask(self):
        r"""评测任务参数。
        :rtype: :class:`tencentcloud.mps.v20190612.models.EvaluationTaskInput`
        """
        return self._EvaluationTask

    @EvaluationTask.setter
    def EvaluationTask(self, EvaluationTask):
        self._EvaluationTask = EvaluationTask

    @property
    def OutputStorage(self):
        r"""评测的输出文件的目标存储。不填则继承 InputInfo 中的存储位置。目前输出对象存储位置的类型有COS。
        :rtype: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage

    @property
    def OutputDir(self):
        r"""评测生成文件的输出目录，必选以 / 开头和结尾，如/movie/201907/。 如果不填，表示与 InputInfo 中文件所在的目录一致。
        :rtype: str
        """
        return self._OutputDir

    @OutputDir.setter
    def OutputDir(self, OutputDir):
        self._OutputDir = OutputDir

    @property
    def TaskNotifyConfig(self):
        r"""任务的事件通知信息，不填代表不获取事件通知。
        :rtype: :class:`tencentcloud.mps.v20190612.models.TaskNotifyConfig`
        """
        return self._TaskNotifyConfig

    @TaskNotifyConfig.setter
    def TaskNotifyConfig(self, TaskNotifyConfig):
        self._TaskNotifyConfig = TaskNotifyConfig

    @property
    def TasksPriority(self):
        r"""任务优先级，数值越大优先级越高，取值范围是-10到 10，不填代表0。
        :rtype: int
        """
        return self._TasksPriority

    @TasksPriority.setter
    def TasksPriority(self, TasksPriority):
        self._TasksPriority = TasksPriority

    @property
    def SessionId(self):
        r"""用于去重的识别码，如果三天内曾有过相同的识别码的请求，则本次的请求会返回错误。最长 50 个字符，不带或者带空字符串表示不做去重。
        :rtype: str
        """
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def SessionContext(self):
        r"""来源上下文，用于透传用户请求信息，任务流状态变更回调将返回该字段值，最长 1000 个字符。
        :rtype: str
        """
        return self._SessionContext

    @SessionContext.setter
    def SessionContext(self, SessionContext):
        self._SessionContext = SessionContext


    def _deserialize(self, params):
        if params.get("InputInfo") is not None:
            self._InputInfo = MediaInputInfo()
            self._InputInfo._deserialize(params.get("InputInfo"))
        if params.get("EvaluationTask") is not None:
            self._EvaluationTask = EvaluationTaskInput()
            self._EvaluationTask._deserialize(params.get("EvaluationTask"))
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        self._OutputDir = params.get("OutputDir")
        if params.get("TaskNotifyConfig") is not None:
            self._TaskNotifyConfig = TaskNotifyConfig()
            self._TaskNotifyConfig._deserialize(params.get("TaskNotifyConfig"))
        self._TasksPriority = params.get("TasksPriority")
        self._SessionId = params.get("SessionId")
        self._SessionContext = params.get("SessionContext")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateMediaEvaluationResponse(AbstractModel):
    r"""CreateMediaEvaluation返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务 ID。
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        r"""任务 ID。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class CreateOutputInfo(AbstractModel):
    r"""创建输出的配置信息。

    """

    def __init__(self):
        r"""
        :param _OutputName: 输出的名称。
        :type OutputName: str
        :param _Description: 输出描述。
        :type Description: str
        :param _Protocol: 输出的转推协议，支持SRT|RTP|RTMP|RTMP_PULL|RTSP_PULL|RIST。
        :type Protocol: str
        :param _OutputRegion: 输出地区。
        :type OutputRegion: str
        :param _OutputType: 输出类型：Internet/TencentCSS
        :type OutputType: str
        :param _OutputKind: 输出模块类型，包括Pinpoint（单点输出，最多支持四路并发输出）；MultiMesh（多路输出，支持大于四路的并发输出，目前可以达到200路）。默认类型为 Pinpoint 输出。对于单个 Flow 一个区域最多只能有一个 MultiMesh 输出
        :type OutputKind: str
        :param _SRTSettings: 输出的SRT的配置。
        :type SRTSettings: :class:`tencentcloud.mps.v20190612.models.CreateOutputSRTSettings`
        :param _RTMPSettings: 输出的RTMP的配置。
        :type RTMPSettings: :class:`tencentcloud.mps.v20190612.models.CreateOutputRTMPSettings`
        :param _RTPSettings: 输出的RTP的配置。
        :type RTPSettings: :class:`tencentcloud.mps.v20190612.models.CreateOutputInfoRTPSettings`
        :param _AllowIpList: IP白名单列表，格式为CIDR，如0.0.0.0/0。
当Protocol为RTMP_PULL有效，为空代表不限制客户端IP。
        :type AllowIpList: list of str
        :param _MaxConcurrent: 最大拉流并发数，最大4，默认4。
        :type MaxConcurrent: int
        :param _SecurityGroupIds: 绑定的输入安全组 ID。 
        :type SecurityGroupIds: list of str
        :param _Zones: 可用区，output最多只支持输入一个可用区。	
        :type Zones: list of str
        :param _RISTSettings: 输出的RIST的配置。
        :type RISTSettings: :class:`tencentcloud.mps.v20190612.models.CreateOutputRistSettings`
        :param _PidSelector: 对于含有多个音/视频轨的流，可以指定需要使用的轨道。PidSelector 与 TrackSelector 只能存在一个
        :type PidSelector: :class:`tencentcloud.mps.v20190612.models.PidSelector`
        :param _StreamSelector: 对于含有多个音/视频轨的流，可以指定需要使用的轨道。PidSelector 与 TrackSelector 只能存在一个
        :type StreamSelector: :class:`tencentcloud.mps.v20190612.models.StreamSelector`
        """
        self._OutputName = None
        self._Description = None
        self._Protocol = None
        self._OutputRegion = None
        self._OutputType = None
        self._OutputKind = None
        self._SRTSettings = None
        self._RTMPSettings = None
        self._RTPSettings = None
        self._AllowIpList = None
        self._MaxConcurrent = None
        self._SecurityGroupIds = None
        self._Zones = None
        self._RISTSettings = None
        self._PidSelector = None
        self._StreamSelector = None

    @property
    def OutputName(self):
        r"""输出的名称。
        :rtype: str
        """
        return self._OutputName

    @OutputName.setter
    def OutputName(self, OutputName):
        self._OutputName = OutputName

    @property
    def Description(self):
        r"""输出描述。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Protocol(self):
        r"""输出的转推协议，支持SRT|RTP|RTMP|RTMP_PULL|RTSP_PULL|RIST。
        :rtype: str
        """
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def OutputRegion(self):
        r"""输出地区。
        :rtype: str
        """
        return self._OutputRegion

    @OutputRegion.setter
    def OutputRegion(self, OutputRegion):
        self._OutputRegion = OutputRegion

    @property
    def OutputType(self):
        r"""输出类型：Internet/TencentCSS
        :rtype: str
        """
        return self._OutputType

    @OutputType.setter
    def OutputType(self, OutputType):
        self._OutputType = OutputType

    @property
    def OutputKind(self):
        r"""输出模块类型，包括Pinpoint（单点输出，最多支持四路并发输出）；MultiMesh（多路输出，支持大于四路的并发输出，目前可以达到200路）。默认类型为 Pinpoint 输出。对于单个 Flow 一个区域最多只能有一个 MultiMesh 输出
        :rtype: str
        """
        return self._OutputKind

    @OutputKind.setter
    def OutputKind(self, OutputKind):
        self._OutputKind = OutputKind

    @property
    def SRTSettings(self):
        r"""输出的SRT的配置。
        :rtype: :class:`tencentcloud.mps.v20190612.models.CreateOutputSRTSettings`
        """
        return self._SRTSettings

    @SRTSettings.setter
    def SRTSettings(self, SRTSettings):
        self._SRTSettings = SRTSettings

    @property
    def RTMPSettings(self):
        r"""输出的RTMP的配置。
        :rtype: :class:`tencentcloud.mps.v20190612.models.CreateOutputRTMPSettings`
        """
        return self._RTMPSettings

    @RTMPSettings.setter
    def RTMPSettings(self, RTMPSettings):
        self._RTMPSettings = RTMPSettings

    @property
    def RTPSettings(self):
        r"""输出的RTP的配置。
        :rtype: :class:`tencentcloud.mps.v20190612.models.CreateOutputInfoRTPSettings`
        """
        return self._RTPSettings

    @RTPSettings.setter
    def RTPSettings(self, RTPSettings):
        self._RTPSettings = RTPSettings

    @property
    def AllowIpList(self):
        r"""IP白名单列表，格式为CIDR，如0.0.0.0/0。
当Protocol为RTMP_PULL有效，为空代表不限制客户端IP。
        :rtype: list of str
        """
        return self._AllowIpList

    @AllowIpList.setter
    def AllowIpList(self, AllowIpList):
        self._AllowIpList = AllowIpList

    @property
    def MaxConcurrent(self):
        r"""最大拉流并发数，最大4，默认4。
        :rtype: int
        """
        return self._MaxConcurrent

    @MaxConcurrent.setter
    def MaxConcurrent(self, MaxConcurrent):
        self._MaxConcurrent = MaxConcurrent

    @property
    def SecurityGroupIds(self):
        r"""绑定的输入安全组 ID。 
        :rtype: list of str
        """
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds

    @property
    def Zones(self):
        r"""可用区，output最多只支持输入一个可用区。	
        :rtype: list of str
        """
        return self._Zones

    @Zones.setter
    def Zones(self, Zones):
        self._Zones = Zones

    @property
    def RISTSettings(self):
        r"""输出的RIST的配置。
        :rtype: :class:`tencentcloud.mps.v20190612.models.CreateOutputRistSettings`
        """
        return self._RISTSettings

    @RISTSettings.setter
    def RISTSettings(self, RISTSettings):
        self._RISTSettings = RISTSettings

    @property
    def PidSelector(self):
        warnings.warn("parameter `PidSelector` is deprecated", DeprecationWarning) 

        r"""对于含有多个音/视频轨的流，可以指定需要使用的轨道。PidSelector 与 TrackSelector 只能存在一个
        :rtype: :class:`tencentcloud.mps.v20190612.models.PidSelector`
        """
        return self._PidSelector

    @PidSelector.setter
    def PidSelector(self, PidSelector):
        warnings.warn("parameter `PidSelector` is deprecated", DeprecationWarning) 

        self._PidSelector = PidSelector

    @property
    def StreamSelector(self):
        r"""对于含有多个音/视频轨的流，可以指定需要使用的轨道。PidSelector 与 TrackSelector 只能存在一个
        :rtype: :class:`tencentcloud.mps.v20190612.models.StreamSelector`
        """
        return self._StreamSelector

    @StreamSelector.setter
    def StreamSelector(self, StreamSelector):
        self._StreamSelector = StreamSelector


    def _deserialize(self, params):
        self._OutputName = params.get("OutputName")
        self._Description = params.get("Description")
        self._Protocol = params.get("Protocol")
        self._OutputRegion = params.get("OutputRegion")
        self._OutputType = params.get("OutputType")
        self._OutputKind = params.get("OutputKind")
        if params.get("SRTSettings") is not None:
            self._SRTSettings = CreateOutputSRTSettings()
            self._SRTSettings._deserialize(params.get("SRTSettings"))
        if params.get("RTMPSettings") is not None:
            self._RTMPSettings = CreateOutputRTMPSettings()
            self._RTMPSettings._deserialize(params.get("RTMPSettings"))
        if params.get("RTPSettings") is not None:
            self._RTPSettings = CreateOutputInfoRTPSettings()
            self._RTPSettings._deserialize(params.get("RTPSettings"))
        self._AllowIpList = params.get("AllowIpList")
        self._MaxConcurrent = params.get("MaxConcurrent")
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        self._Zones = params.get("Zones")
        if params.get("RISTSettings") is not None:
            self._RISTSettings = CreateOutputRistSettings()
            self._RISTSettings._deserialize(params.get("RISTSettings"))
        if params.get("PidSelector") is not None:
            self._PidSelector = PidSelector()
            self._PidSelector._deserialize(params.get("PidSelector"))
        if params.get("StreamSelector") is not None:
            self._StreamSelector = StreamSelector()
            self._StreamSelector._deserialize(params.get("StreamSelector"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOutputInfoRTPSettings(AbstractModel):
    r"""创建媒体传输流的输出的RTP配置。

    """

    def __init__(self):
        r"""
        :param _Destinations: 转推的目标地址，可填1~2个。
        :type Destinations: list of CreateOutputRTPSettingsDestinations
        :param _FEC: 只能填none。
        :type FEC: str
        :param _IdleTimeout: 空闲超时时间，单位ms。
        :type IdleTimeout: int
        """
        self._Destinations = None
        self._FEC = None
        self._IdleTimeout = None

    @property
    def Destinations(self):
        r"""转推的目标地址，可填1~2个。
        :rtype: list of CreateOutputRTPSettingsDestinations
        """
        return self._Destinations

    @Destinations.setter
    def Destinations(self, Destinations):
        self._Destinations = Destinations

    @property
    def FEC(self):
        r"""只能填none。
        :rtype: str
        """
        return self._FEC

    @FEC.setter
    def FEC(self, FEC):
        self._FEC = FEC

    @property
    def IdleTimeout(self):
        r"""空闲超时时间，单位ms。
        :rtype: int
        """
        return self._IdleTimeout

    @IdleTimeout.setter
    def IdleTimeout(self, IdleTimeout):
        self._IdleTimeout = IdleTimeout


    def _deserialize(self, params):
        if params.get("Destinations") is not None:
            self._Destinations = []
            for item in params.get("Destinations"):
                obj = CreateOutputRTPSettingsDestinations()
                obj._deserialize(item)
                self._Destinations.append(obj)
        self._FEC = params.get("FEC")
        self._IdleTimeout = params.get("IdleTimeout")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOutputRTMPSettings(AbstractModel):
    r"""创建媒体传输流的输出的RTMP配置。

    """

    def __init__(self):
        r"""
        :param _Destinations: 转推的目标地址，可填1~2个。
        :type Destinations: list of CreateOutputRtmpSettingsDestinations
        :param _ChunkSize: RTMP的Chunk大小，范围为[4096, 40960]。
        :type ChunkSize: int
        """
        self._Destinations = None
        self._ChunkSize = None

    @property
    def Destinations(self):
        r"""转推的目标地址，可填1~2个。
        :rtype: list of CreateOutputRtmpSettingsDestinations
        """
        return self._Destinations

    @Destinations.setter
    def Destinations(self, Destinations):
        self._Destinations = Destinations

    @property
    def ChunkSize(self):
        r"""RTMP的Chunk大小，范围为[4096, 40960]。
        :rtype: int
        """
        return self._ChunkSize

    @ChunkSize.setter
    def ChunkSize(self, ChunkSize):
        self._ChunkSize = ChunkSize


    def _deserialize(self, params):
        if params.get("Destinations") is not None:
            self._Destinations = []
            for item in params.get("Destinations"):
                obj = CreateOutputRtmpSettingsDestinations()
                obj._deserialize(item)
                self._Destinations.append(obj)
        self._ChunkSize = params.get("ChunkSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOutputRTPSettingsDestinations(AbstractModel):
    r"""创建媒体传输流的输出的RTP的目标地址。

    """

    def __init__(self):
        r"""
        :param _Ip: 转推的目标IP。
        :type Ip: str
        :param _Port: 转推的目标端口。
        :type Port: int
        """
        self._Ip = None
        self._Port = None

    @property
    def Ip(self):
        r"""转推的目标IP。
        :rtype: str
        """
        return self._Ip

    @Ip.setter
    def Ip(self, Ip):
        self._Ip = Ip

    @property
    def Port(self):
        r"""转推的目标端口。
        :rtype: int
        """
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port


    def _deserialize(self, params):
        self._Ip = params.get("Ip")
        self._Port = params.get("Port")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOutputRistSettings(AbstractModel):
    r"""创建媒体传输流的输出的RIST配置。

    """

    def __init__(self):
        r"""
        :param _Mode: RIST模式，可选[LISTENER|CALLER]，默认为LISTENER。
        :type Mode: str
        :param _Profile: RIST配置方案，可选[MAIN|SIMPLE]，默认为MAIN。
        :type Profile: str
        :param _Buffer: RIST缓冲区大小，单位为毫秒。最小值为50毫秒，最大值为5000毫秒。默认值：120
        :type Buffer: int
        """
        self._Mode = None
        self._Profile = None
        self._Buffer = None

    @property
    def Mode(self):
        r"""RIST模式，可选[LISTENER|CALLER]，默认为LISTENER。
        :rtype: str
        """
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def Profile(self):
        r"""RIST配置方案，可选[MAIN|SIMPLE]，默认为MAIN。
        :rtype: str
        """
        return self._Profile

    @Profile.setter
    def Profile(self, Profile):
        self._Profile = Profile

    @property
    def Buffer(self):
        r"""RIST缓冲区大小，单位为毫秒。最小值为50毫秒，最大值为5000毫秒。默认值：120
        :rtype: int
        """
        return self._Buffer

    @Buffer.setter
    def Buffer(self, Buffer):
        self._Buffer = Buffer


    def _deserialize(self, params):
        self._Mode = params.get("Mode")
        self._Profile = params.get("Profile")
        self._Buffer = params.get("Buffer")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOutputRtmpSettingsDestinations(AbstractModel):
    r"""创建媒体传输流的输出的RTMP的目标地址。

    """

    def __init__(self):
        r"""
        :param _Url: 转推的URL，格式如：rtmp://domain/live。
        :type Url: str
        :param _StreamKey: 转推的StreamKey，格式如：stream?key=value。
        :type StreamKey: str
        """
        self._Url = None
        self._StreamKey = None

    @property
    def Url(self):
        r"""转推的URL，格式如：rtmp://domain/live。
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def StreamKey(self):
        r"""转推的StreamKey，格式如：stream?key=value。
        :rtype: str
        """
        return self._StreamKey

    @StreamKey.setter
    def StreamKey(self, StreamKey):
        self._StreamKey = StreamKey


    def _deserialize(self, params):
        self._Url = params.get("Url")
        self._StreamKey = params.get("StreamKey")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOutputSRTSettings(AbstractModel):
    r"""创建媒体传输流的输出的SRT配置。

    """

    def __init__(self):
        r"""
        :param _Destinations: 转推的目标地址，当Mode为CALLER时必填，且只能填1组。
        :type Destinations: list of CreateOutputSRTSettingsDestinations
        :param _StreamId: 转推SRT的流Id，可选大小写字母、数字和特殊字符（.#!:&,=_-），长度为0~512。
        :type StreamId: str
        :param _Latency: 转推SRT的延迟，默认120，单位ms，范围为[0, 3000]。此参数同时设置了发送方和接收方的延迟（recvlatency和peerlatency）为相同的值。建议配置为至少3倍RTT，以确保在网络拥塞时能够有效处理数据包的重传和确认
        :type Latency: int
        :param _RecvLatency: 转推SRT的接收延迟，默认120，单位ms，范围为[0, 3000]。 此参数表示接收方用于缓存数据包的时间长度
        :type RecvLatency: int
        :param _PeerLatency: 转推SRT的对端延迟，默认120，单位ms，范围为[0, 3000]。 此参数由发送方设置，用于告知接收方其期望的延迟缓冲时间
        :type PeerLatency: int
        :param _PeerIdleTimeout: 转推SRT的对端空闲超时时间，默认5000，单位ms，范围为[1000, 10000]。 如果连接在设定的超时时间内没有活动，将会被关闭
        :type PeerIdleTimeout: int
        :param _Passphrase: 转推SRT的加密密钥，默认为空，表示不加密。只可填ascii码值，长度为[10, 79]。
        :type Passphrase: str
        :param _PbKeyLen: 转推SRT的密钥长度，默认为0，可选[0|16|24|32]。
        :type PbKeyLen: int
        :param _Mode: SRT模式，可选[LISTENER|CALLER]，默认为CALLER。
        :type Mode: str
        :param _FEC: SRT FEC 设置
        :type FEC: :class:`tencentcloud.mps.v20190612.models.SRTFECFullOptions`
        """
        self._Destinations = None
        self._StreamId = None
        self._Latency = None
        self._RecvLatency = None
        self._PeerLatency = None
        self._PeerIdleTimeout = None
        self._Passphrase = None
        self._PbKeyLen = None
        self._Mode = None
        self._FEC = None

    @property
    def Destinations(self):
        r"""转推的目标地址，当Mode为CALLER时必填，且只能填1组。
        :rtype: list of CreateOutputSRTSettingsDestinations
        """
        return self._Destinations

    @Destinations.setter
    def Destinations(self, Destinations):
        self._Destinations = Destinations

    @property
    def StreamId(self):
        r"""转推SRT的流Id，可选大小写字母、数字和特殊字符（.#!:&,=_-），长度为0~512。
        :rtype: str
        """
        return self._StreamId

    @StreamId.setter
    def StreamId(self, StreamId):
        self._StreamId = StreamId

    @property
    def Latency(self):
        r"""转推SRT的延迟，默认120，单位ms，范围为[0, 3000]。此参数同时设置了发送方和接收方的延迟（recvlatency和peerlatency）为相同的值。建议配置为至少3倍RTT，以确保在网络拥塞时能够有效处理数据包的重传和确认
        :rtype: int
        """
        return self._Latency

    @Latency.setter
    def Latency(self, Latency):
        self._Latency = Latency

    @property
    def RecvLatency(self):
        r"""转推SRT的接收延迟，默认120，单位ms，范围为[0, 3000]。 此参数表示接收方用于缓存数据包的时间长度
        :rtype: int
        """
        return self._RecvLatency

    @RecvLatency.setter
    def RecvLatency(self, RecvLatency):
        self._RecvLatency = RecvLatency

    @property
    def PeerLatency(self):
        r"""转推SRT的对端延迟，默认120，单位ms，范围为[0, 3000]。 此参数由发送方设置，用于告知接收方其期望的延迟缓冲时间
        :rtype: int
        """
        return self._PeerLatency

    @PeerLatency.setter
    def PeerLatency(self, PeerLatency):
        self._PeerLatency = PeerLatency

    @property
    def PeerIdleTimeout(self):
        r"""转推SRT的对端空闲超时时间，默认5000，单位ms，范围为[1000, 10000]。 如果连接在设定的超时时间内没有活动，将会被关闭
        :rtype: int
        """
        return self._PeerIdleTimeout

    @PeerIdleTimeout.setter
    def PeerIdleTimeout(self, PeerIdleTimeout):
        self._PeerIdleTimeout = PeerIdleTimeout

    @property
    def Passphrase(self):
        r"""转推SRT的加密密钥，默认为空，表示不加密。只可填ascii码值，长度为[10, 79]。
        :rtype: str
        """
        return self._Passphrase

    @Passphrase.setter
    def Passphrase(self, Passphrase):
        self._Passphrase = Passphrase

    @property
    def PbKeyLen(self):
        r"""转推SRT的密钥长度，默认为0，可选[0|16|24|32]。
        :rtype: int
        """
        return self._PbKeyLen

    @PbKeyLen.setter
    def PbKeyLen(self, PbKeyLen):
        self._PbKeyLen = PbKeyLen

    @property
    def Mode(self):
        r"""SRT模式，可选[LISTENER|CALLER]，默认为CALLER。
        :rtype: str
        """
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def FEC(self):
        r"""SRT FEC 设置
        :rtype: :class:`tencentcloud.mps.v20190612.models.SRTFECFullOptions`
        """
        return self._FEC

    @FEC.setter
    def FEC(self, FEC):
        self._FEC = FEC


    def _deserialize(self, params):
        if params.get("Destinations") is not None:
            self._Destinations = []
            for item in params.get("Destinations"):
                obj = CreateOutputSRTSettingsDestinations()
                obj._deserialize(item)
                self._Destinations.append(obj)
        self._StreamId = params.get("StreamId")
        self._Latency = params.get("Latency")
        self._RecvLatency = params.get("RecvLatency")
        self._PeerLatency = params.get("PeerLatency")
        self._PeerIdleTimeout = params.get("PeerIdleTimeout")
        self._Passphrase = params.get("Passphrase")
        self._PbKeyLen = params.get("PbKeyLen")
        self._Mode = params.get("Mode")
        if params.get("FEC") is not None:
            self._FEC = SRTFECFullOptions()
            self._FEC._deserialize(params.get("FEC"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOutputSRTSettingsDestinations(AbstractModel):
    r"""创建媒体传输流的输出SRT的目标地址。

    """

    def __init__(self):
        r"""
        :param _Ip: 输出的IP或域名。
        :type Ip: str
        :param _Port: 输出的端口。
        :type Port: int
        """
        self._Ip = None
        self._Port = None

    @property
    def Ip(self):
        r"""输出的IP或域名。
        :rtype: str
        """
        return self._Ip

    @Ip.setter
    def Ip(self, Ip):
        self._Ip = Ip

    @property
    def Port(self):
        r"""输出的端口。
        :rtype: int
        """
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port


    def _deserialize(self, params):
        self._Ip = params.get("Ip")
        self._Port = params.get("Port")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreatePersonSampleRequest(AbstractModel):
    r"""CreatePersonSample请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 素材名称，长度限制：20 个字符。
        :type Name: str
        :param _Usages: 素材应用场景，可选值：
1. Recognition：用于内容识别，等价于 Recognition.Face。
2. Review：用于不适宜内容识别，等价于 Review.Face。
3. All：包含以上全部，等价于 1+2。
        :type Usages: list of str
        :param _Description: 素材描述，长度限制：1024 个字符。
        :type Description: str
        :param _FaceContents: 素材图片 [Base64](https://tools.ietf.org/html/rfc4648) 编码后的字符串，仅支持 jpeg、png 图片格式。数组长度限制：5 张图片。
注意：图片必须是单人像五官较清晰的照片，像素不低于 200*200。
        :type FaceContents: list of str
        :param _Tags: 素材标签
<li>数组长度限制：20 个标签；</li>
<li>单个标签长度限制：128 个字符。</li>
        :type Tags: list of str
        """
        self._Name = None
        self._Usages = None
        self._Description = None
        self._FaceContents = None
        self._Tags = None

    @property
    def Name(self):
        r"""素材名称，长度限制：20 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Usages(self):
        r"""素材应用场景，可选值：
1. Recognition：用于内容识别，等价于 Recognition.Face。
2. Review：用于不适宜内容识别，等价于 Review.Face。
3. All：包含以上全部，等价于 1+2。
        :rtype: list of str
        """
        return self._Usages

    @Usages.setter
    def Usages(self, Usages):
        self._Usages = Usages

    @property
    def Description(self):
        r"""素材描述，长度限制：1024 个字符。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def FaceContents(self):
        r"""素材图片 [Base64](https://tools.ietf.org/html/rfc4648) 编码后的字符串，仅支持 jpeg、png 图片格式。数组长度限制：5 张图片。
注意：图片必须是单人像五官较清晰的照片，像素不低于 200*200。
        :rtype: list of str
        """
        return self._FaceContents

    @FaceContents.setter
    def FaceContents(self, FaceContents):
        self._FaceContents = FaceContents

    @property
    def Tags(self):
        r"""素材标签
<li>数组长度限制：20 个标签；</li>
<li>单个标签长度限制：128 个字符。</li>
        :rtype: list of str
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Usages = params.get("Usages")
        self._Description = params.get("Description")
        self._FaceContents = params.get("FaceContents")
        self._Tags = params.get("Tags")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreatePersonSampleResponse(AbstractModel):
    r"""CreatePersonSample返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Person: 素材信息。
        :type Person: :class:`tencentcloud.mps.v20190612.models.AiSamplePerson`
        :param _FailFaceInfoSet: 处理失败的五官定位信息。
        :type FailFaceInfoSet: list of AiSampleFailFaceInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Person = None
        self._FailFaceInfoSet = None
        self._RequestId = None

    @property
    def Person(self):
        r"""素材信息。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiSamplePerson`
        """
        return self._Person

    @Person.setter
    def Person(self, Person):
        self._Person = Person

    @property
    def FailFaceInfoSet(self):
        r"""处理失败的五官定位信息。
        :rtype: list of AiSampleFailFaceInfo
        """
        return self._FailFaceInfoSet

    @FailFaceInfoSet.setter
    def FailFaceInfoSet(self, FailFaceInfoSet):
        self._FailFaceInfoSet = FailFaceInfoSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Person") is not None:
            self._Person = AiSamplePerson()
            self._Person._deserialize(params.get("Person"))
        if params.get("FailFaceInfoSet") is not None:
            self._FailFaceInfoSet = []
            for item in params.get("FailFaceInfoSet"):
                obj = AiSampleFailFaceInfo()
                obj._deserialize(item)
                self._FailFaceInfoSet.append(obj)
        self._RequestId = params.get("RequestId")


class CreateProcessImageTemplateRequest(AbstractModel):
    r"""CreateProcessImageTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProcessImageTemplate: 图片处理模板。
        :type ProcessImageTemplate: :class:`tencentcloud.mps.v20190612.models.ImageTaskInput`
        :param _Name: 图片处理模板名称，长度限制：64个字符。
        :type Name: str
        :param _Comment: 图片处理模板描述信息，长度限制：256个字符。
        :type Comment: str
        """
        self._ProcessImageTemplate = None
        self._Name = None
        self._Comment = None

    @property
    def ProcessImageTemplate(self):
        r"""图片处理模板。
        :rtype: :class:`tencentcloud.mps.v20190612.models.ImageTaskInput`
        """
        return self._ProcessImageTemplate

    @ProcessImageTemplate.setter
    def ProcessImageTemplate(self, ProcessImageTemplate):
        self._ProcessImageTemplate = ProcessImageTemplate

    @property
    def Name(self):
        r"""图片处理模板名称，长度限制：64个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        r"""图片处理模板描述信息，长度限制：256个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment


    def _deserialize(self, params):
        if params.get("ProcessImageTemplate") is not None:
            self._ProcessImageTemplate = ImageTaskInput()
            self._ProcessImageTemplate._deserialize(params.get("ProcessImageTemplate"))
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateProcessImageTemplateResponse(AbstractModel):
    r"""CreateProcessImageTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 图片处理模板唯一标识
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""图片处理模板唯一标识
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateQualityControlTemplateRequest(AbstractModel):
    r"""CreateQualityControlTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 媒体质检模板名称，长度限制：64 个字符。
        :type Name: str
        :param _QualityControlItemSet: 媒体质检控制参数。
        :type QualityControlItemSet: list of QualityControlItemConfig
        :param _Comment: 媒体质检模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _RecordFormat: 录制文件格式。可选值：
<li>PNG: PNG图片</li>
        :type RecordFormat: str
        :param _Strategy: 媒体质检抽检策略。
        :type Strategy: :class:`tencentcloud.mps.v20190612.models.QualityControlStrategy`
        """
        self._Name = None
        self._QualityControlItemSet = None
        self._Comment = None
        self._RecordFormat = None
        self._Strategy = None

    @property
    def Name(self):
        r"""媒体质检模板名称，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def QualityControlItemSet(self):
        r"""媒体质检控制参数。
        :rtype: list of QualityControlItemConfig
        """
        return self._QualityControlItemSet

    @QualityControlItemSet.setter
    def QualityControlItemSet(self, QualityControlItemSet):
        self._QualityControlItemSet = QualityControlItemSet

    @property
    def Comment(self):
        r"""媒体质检模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def RecordFormat(self):
        r"""录制文件格式。可选值：
<li>PNG: PNG图片</li>
        :rtype: str
        """
        return self._RecordFormat

    @RecordFormat.setter
    def RecordFormat(self, RecordFormat):
        self._RecordFormat = RecordFormat

    @property
    def Strategy(self):
        r"""媒体质检抽检策略。
        :rtype: :class:`tencentcloud.mps.v20190612.models.QualityControlStrategy`
        """
        return self._Strategy

    @Strategy.setter
    def Strategy(self, Strategy):
        self._Strategy = Strategy


    def _deserialize(self, params):
        self._Name = params.get("Name")
        if params.get("QualityControlItemSet") is not None:
            self._QualityControlItemSet = []
            for item in params.get("QualityControlItemSet"):
                obj = QualityControlItemConfig()
                obj._deserialize(item)
                self._QualityControlItemSet.append(obj)
        self._Comment = params.get("Comment")
        self._RecordFormat = params.get("RecordFormat")
        if params.get("Strategy") is not None:
            self._Strategy = QualityControlStrategy()
            self._Strategy._deserialize(params.get("Strategy"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateQualityControlTemplateResponse(AbstractModel):
    r"""CreateQualityControlTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 媒体质检模板唯一标识。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""媒体质检模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateSampleSnapshotTemplateRequest(AbstractModel):
    r"""CreateSampleSnapshotTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SampleType: 采样截图类型，取值：
<li>Percent：按百分比。</li>
<li>Time：按时间间隔。</li>
        :type SampleType: str
        :param _SampleInterval: 采样间隔。
<li>当 SampleType 为 Percent 时，指定采样间隔的百分比。</li>
<li>当 SampleType 为 Time 时，指定采样间隔的时间，单位为秒。</li>
        :type SampleInterval: int
        :param _Name: 采样截图模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Width: 截图宽度（或长边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Width: int
        :param _Height: 截图高度（或短边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Height: int
        :param _ResolutionAdaptive: 分辨率自适应，可选值：
<li>open：开启，此时，Width 代表视频的长边，Height 表示视频的短边；</li>
<li>close：关闭，此时，Width 代表视频的宽度，Height 表示视频的高度。</li>
默认值：open。
        :type ResolutionAdaptive: str
        :param _Format: 图片格式，取值为 jpg、png、webp。默认为 jpg。
        :type Format: str
        :param _Comment: 模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _FillType: 填充方式，当视频流配置宽高参数与原始视频的宽高比不一致时，对转码的处理方式，即为“填充”。可选填充方式：
<li> stretch：拉伸，对每一帧进行拉伸，填满整个画面，可能导致转码后的视频被“压扁“或者“拉长“；</li>
<li>black：留黑，保持视频宽高比不变，边缘剩余部分使用黑色填充。</li>
<li>white：留白，保持视频宽高比不变，边缘剩余部分使用白色填充。</li>
<li>gauss：高斯模糊，保持视频宽高比不变，边缘剩余部分使用高斯模糊。</li>
默认值：black 。
        :type FillType: str
        """
        self._SampleType = None
        self._SampleInterval = None
        self._Name = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._Format = None
        self._Comment = None
        self._FillType = None

    @property
    def SampleType(self):
        r"""采样截图类型，取值：
<li>Percent：按百分比。</li>
<li>Time：按时间间隔。</li>
        :rtype: str
        """
        return self._SampleType

    @SampleType.setter
    def SampleType(self, SampleType):
        self._SampleType = SampleType

    @property
    def SampleInterval(self):
        r"""采样间隔。
<li>当 SampleType 为 Percent 时，指定采样间隔的百分比。</li>
<li>当 SampleType 为 Time 时，指定采样间隔的时间，单位为秒。</li>
        :rtype: int
        """
        return self._SampleInterval

    @SampleInterval.setter
    def SampleInterval(self, SampleInterval):
        self._SampleInterval = SampleInterval

    @property
    def Name(self):
        r"""采样截图模板名称，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Width(self):
        r"""截图宽度（或长边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :rtype: int
        """
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        r"""截图高度（或短边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :rtype: int
        """
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        r"""分辨率自适应，可选值：
<li>open：开启，此时，Width 代表视频的长边，Height 表示视频的短边；</li>
<li>close：关闭，此时，Width 代表视频的宽度，Height 表示视频的高度。</li>
默认值：open。
        :rtype: str
        """
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def Format(self):
        r"""图片格式，取值为 jpg、png、webp。默认为 jpg。
        :rtype: str
        """
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def Comment(self):
        r"""模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def FillType(self):
        r"""填充方式，当视频流配置宽高参数与原始视频的宽高比不一致时，对转码的处理方式，即为“填充”。可选填充方式：
<li> stretch：拉伸，对每一帧进行拉伸，填满整个画面，可能导致转码后的视频被“压扁“或者“拉长“；</li>
<li>black：留黑，保持视频宽高比不变，边缘剩余部分使用黑色填充。</li>
<li>white：留白，保持视频宽高比不变，边缘剩余部分使用白色填充。</li>
<li>gauss：高斯模糊，保持视频宽高比不变，边缘剩余部分使用高斯模糊。</li>
默认值：black 。
        :rtype: str
        """
        return self._FillType

    @FillType.setter
    def FillType(self, FillType):
        self._FillType = FillType


    def _deserialize(self, params):
        self._SampleType = params.get("SampleType")
        self._SampleInterval = params.get("SampleInterval")
        self._Name = params.get("Name")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._Format = params.get("Format")
        self._Comment = params.get("Comment")
        self._FillType = params.get("FillType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSampleSnapshotTemplateResponse(AbstractModel):
    r"""CreateSampleSnapshotTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 采样截图模板唯一标识。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""采样截图模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateScheduleRequest(AbstractModel):
    r"""CreateSchedule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ScheduleName: 编排名称，最多128字符。同一个用户该名称唯一。
        :type ScheduleName: str
        :param _Trigger: 编排绑定的触发规则，当上传视频命中该规则到该对象时即触发编排。
        :type Trigger: :class:`tencentcloud.mps.v20190612.models.WorkflowTrigger`
        :param _Activities: 编排任务列表。
        :type Activities: list of Activity
        :param _OutputStorage: 媒体处理的文件输出存储位置。不填则继承 Trigger 中的存储位置。
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _OutputDir: 媒体处理生成的文件输出的目标目录，必选以 / 开头和结尾，如`/movie/201907/`。
如果不填，表示与触发文件所在的目录一致。
        :type OutputDir: str
        :param _TaskNotifyConfig: 任务的事件通知配置，不填代表不获取事件通知。
        :type TaskNotifyConfig: :class:`tencentcloud.mps.v20190612.models.TaskNotifyConfig`
        :param _ResourceId: 资源ID，需要保证对应资源是开启状态。默认为账号主资源ID。
        :type ResourceId: str
        """
        self._ScheduleName = None
        self._Trigger = None
        self._Activities = None
        self._OutputStorage = None
        self._OutputDir = None
        self._TaskNotifyConfig = None
        self._ResourceId = None

    @property
    def ScheduleName(self):
        r"""编排名称，最多128字符。同一个用户该名称唯一。
        :rtype: str
        """
        return self._ScheduleName

    @ScheduleName.setter
    def ScheduleName(self, ScheduleName):
        self._ScheduleName = ScheduleName

    @property
    def Trigger(self):
        r"""编排绑定的触发规则，当上传视频命中该规则到该对象时即触发编排。
        :rtype: :class:`tencentcloud.mps.v20190612.models.WorkflowTrigger`
        """
        return self._Trigger

    @Trigger.setter
    def Trigger(self, Trigger):
        self._Trigger = Trigger

    @property
    def Activities(self):
        r"""编排任务列表。
        :rtype: list of Activity
        """
        return self._Activities

    @Activities.setter
    def Activities(self, Activities):
        self._Activities = Activities

    @property
    def OutputStorage(self):
        r"""媒体处理的文件输出存储位置。不填则继承 Trigger 中的存储位置。
        :rtype: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage

    @property
    def OutputDir(self):
        r"""媒体处理生成的文件输出的目标目录，必选以 / 开头和结尾，如`/movie/201907/`。
如果不填，表示与触发文件所在的目录一致。
        :rtype: str
        """
        return self._OutputDir

    @OutputDir.setter
    def OutputDir(self, OutputDir):
        self._OutputDir = OutputDir

    @property
    def TaskNotifyConfig(self):
        r"""任务的事件通知配置，不填代表不获取事件通知。
        :rtype: :class:`tencentcloud.mps.v20190612.models.TaskNotifyConfig`
        """
        return self._TaskNotifyConfig

    @TaskNotifyConfig.setter
    def TaskNotifyConfig(self, TaskNotifyConfig):
        self._TaskNotifyConfig = TaskNotifyConfig

    @property
    def ResourceId(self):
        r"""资源ID，需要保证对应资源是开启状态。默认为账号主资源ID。
        :rtype: str
        """
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId


    def _deserialize(self, params):
        self._ScheduleName = params.get("ScheduleName")
        if params.get("Trigger") is not None:
            self._Trigger = WorkflowTrigger()
            self._Trigger._deserialize(params.get("Trigger"))
        if params.get("Activities") is not None:
            self._Activities = []
            for item in params.get("Activities"):
                obj = Activity()
                obj._deserialize(item)
                self._Activities.append(obj)
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        self._OutputDir = params.get("OutputDir")
        if params.get("TaskNotifyConfig") is not None:
            self._TaskNotifyConfig = TaskNotifyConfig()
            self._TaskNotifyConfig._deserialize(params.get("TaskNotifyConfig"))
        self._ResourceId = params.get("ResourceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateScheduleResponse(AbstractModel):
    r"""CreateSchedule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ScheduleId: 编排 ID。
        :type ScheduleId: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ScheduleId = None
        self._RequestId = None

    @property
    def ScheduleId(self):
        r"""编排 ID。
        :rtype: int
        """
        return self._ScheduleId

    @ScheduleId.setter
    def ScheduleId(self, ScheduleId):
        self._ScheduleId = ScheduleId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ScheduleId = params.get("ScheduleId")
        self._RequestId = params.get("RequestId")


class CreateSmartEraseTemplateRequest(AbstractModel):
    r"""CreateSmartEraseTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 智能擦除模板名称长度限制：64 个字符。
        :type Name: str
        :param _EraseType: 擦除类型
- subtitle 去字幕
- watermark 去水印
- privacy 隐私保护
        :type EraseType: str
        :param _Comment: 智能擦除模板描述信息长度限制：256 个字符。
        :type Comment: str
        :param _EraseSubtitleConfig: 字幕擦除配置，EraseType取subtitle时必填且仅此时生效。
        :type EraseSubtitleConfig: :class:`tencentcloud.mps.v20190612.models.SmartEraseSubtitleConfig`
        :param _EraseWatermarkConfig: 水印擦除配置，EraseType取watermark时必填且仅此时生效。
        :type EraseWatermarkConfig: :class:`tencentcloud.mps.v20190612.models.SmartEraseWatermarkConfig`
        :param _ErasePrivacyConfig: 隐私保护配置，EraseType取privacy时必填且仅此时生效。
        :type ErasePrivacyConfig: :class:`tencentcloud.mps.v20190612.models.SmartErasePrivacyConfig`
        """
        self._Name = None
        self._EraseType = None
        self._Comment = None
        self._EraseSubtitleConfig = None
        self._EraseWatermarkConfig = None
        self._ErasePrivacyConfig = None

    @property
    def Name(self):
        r"""智能擦除模板名称长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def EraseType(self):
        r"""擦除类型
- subtitle 去字幕
- watermark 去水印
- privacy 隐私保护
        :rtype: str
        """
        return self._EraseType

    @EraseType.setter
    def EraseType(self, EraseType):
        self._EraseType = EraseType

    @property
    def Comment(self):
        r"""智能擦除模板描述信息长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def EraseSubtitleConfig(self):
        r"""字幕擦除配置，EraseType取subtitle时必填且仅此时生效。
        :rtype: :class:`tencentcloud.mps.v20190612.models.SmartEraseSubtitleConfig`
        """
        return self._EraseSubtitleConfig

    @EraseSubtitleConfig.setter
    def EraseSubtitleConfig(self, EraseSubtitleConfig):
        self._EraseSubtitleConfig = EraseSubtitleConfig

    @property
    def EraseWatermarkConfig(self):
        r"""水印擦除配置，EraseType取watermark时必填且仅此时生效。
        :rtype: :class:`tencentcloud.mps.v20190612.models.SmartEraseWatermarkConfig`
        """
        return self._EraseWatermarkConfig

    @EraseWatermarkConfig.setter
    def EraseWatermarkConfig(self, EraseWatermarkConfig):
        self._EraseWatermarkConfig = EraseWatermarkConfig

    @property
    def ErasePrivacyConfig(self):
        r"""隐私保护配置，EraseType取privacy时必填且仅此时生效。
        :rtype: :class:`tencentcloud.mps.v20190612.models.SmartErasePrivacyConfig`
        """
        return self._ErasePrivacyConfig

    @ErasePrivacyConfig.setter
    def ErasePrivacyConfig(self, ErasePrivacyConfig):
        self._ErasePrivacyConfig = ErasePrivacyConfig


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._EraseType = params.get("EraseType")
        self._Comment = params.get("Comment")
        if params.get("EraseSubtitleConfig") is not None:
            self._EraseSubtitleConfig = SmartEraseSubtitleConfig()
            self._EraseSubtitleConfig._deserialize(params.get("EraseSubtitleConfig"))
        if params.get("EraseWatermarkConfig") is not None:
            self._EraseWatermarkConfig = SmartEraseWatermarkConfig()
            self._EraseWatermarkConfig._deserialize(params.get("EraseWatermarkConfig"))
        if params.get("ErasePrivacyConfig") is not None:
            self._ErasePrivacyConfig = SmartErasePrivacyConfig()
            self._ErasePrivacyConfig._deserialize(params.get("ErasePrivacyConfig"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSmartEraseTemplateResponse(AbstractModel):
    r"""CreateSmartEraseTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 智能擦除模板唯一标识
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""智能擦除模板唯一标识
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateSmartSubtitleTemplateRequest(AbstractModel):
    r"""CreateSmartSubtitleTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 智能字幕模板名称
长度限制：64 个字符。
        :type Name: str
        :param _VideoSrcLanguage: 智能字幕视频源语言
OCR识别仅支持以下语言：
`zh_en`：中英
`multi`：其他
ASR识别和纯字幕翻译当前支持以下语言：
`auto`：自动识别（仅在纯字幕翻译中支持）
`zh`：简体中文
`en`：英语
`ja`：日语
`ko`：韩语
`zh-PY`：中英粤
`zh_medical`：中文医疗
`vi`：越南语
`ms`：马来语
`id`：印度尼西亚语
`fil`：菲律宾语
`th`：泰语
`pt`：葡萄牙语
`tr`：土耳其语
`ar`：阿拉伯语
`es`：西班牙语
`hi`：印地语
`fr`：法语
`de`：德语
`it`：意大利语
`zh_dialect`：中文方言
`zh_en`：中英
`yue`：粤语
`ru`：俄语
`prime_zh`：中英方言
`af-ZA`：南非荷兰语（南非）
`sq-AL`：阿尔巴尼亚语（阿尔巴尼亚）
`am-ET`：阿姆哈拉语（埃塞俄比亚）
`ar-DZ`：阿拉伯语（阿尔及利亚）
`ar-BH`：阿拉伯语（巴林）
`ar-EG`：阿拉伯语（埃及）
`ar-IQ`：阿拉伯语（伊拉克）
`ar-IL`：阿拉伯语（以色列）
`ar-JO`：阿拉伯语（约旦）
`ar-KW`：阿拉伯语（科威特）
`ar-LB`：阿拉伯语（黎巴嫩）
`ar-MR`：阿拉伯语（毛里塔尼亚）
`ar-MA`：阿拉伯语（摩洛哥）
`ar-OM`：阿拉伯语（阿曼）
`ar-QA`：阿拉伯语（卡塔尔）
`ar-SA`：阿拉伯语（沙特阿拉伯）
`ar-PS`：阿拉伯语（巴勒斯坦国）
`ar-SY`：阿拉伯语（叙利亚）
`ar-TN`：阿拉伯语（突尼斯）
`ar-AE`：阿拉伯语（阿拉伯联合酋长国）
`ar-YE`：阿拉伯语（也门）
`hy-AM`：亚美尼亚语（亚美尼亚）
`az-AZ`：阿塞拜疆语（阿塞拜疆）
`eu-ES`：巴斯克语（西班牙）
`bn-BD`：孟加拉语（孟加拉）
`bn-IN`：孟加拉语（印度）
`bs-BA`：波斯尼亚语（波斯尼亚和黑塞哥维那）
`bg-BG`：保加利亚语（保加利亚）
`my-MM`：缅甸语（缅甸）
`ca-ES`：加泰罗尼亚语（西班牙）
`hr-HR`：克罗地亚语（克罗地亚）
`cs-CZ`：捷克语（捷克共和国）
`da-DK`：丹麦语（丹麦）
`nl-BE`：荷兰语（比利时）
`nl-NL`：荷兰语（荷兰）
`en-AU`：英语（澳大利亚）
`en-CA`：英语（加拿大）
`en-GH`：英语（加纳）
`en-HK`：英语（中国香港）
`en-IN`：英语（印度）
`en-IE`：英语（爱尔兰）
`en-KE`：英语（肯尼亚）
`en-NZ`：英语（新西兰）
`en-NG`：英语（尼日利亚）
`en-PK`：英语（巴基斯坦）
`en-PH`：英语（菲律宾）
`en-SG`：英语（新加坡）
`en-ZA`：英语（南非）
`en-TZ`：英语（坦桑尼亚）
`en-GB`：英语（英国）
`en-US`：英语（美国）
`et-EE`：爱沙尼亚语（爱沙尼亚）
`fil-PH`：菲律宾语（菲律宾）
`fi-FI`：芬兰语（芬兰）
`fr-BE`：法语（比利时）
`fr-CA`：法语（加拿大）
`fr-FR`：法语（法国）
`fr-CH`：法语（瑞士）
`gl-ES`：加利西亚语（西班牙）
`ka-GE`：格鲁吉亚语（格鲁吉亚）
`el-GR`：希腊语（希腊）
`gu-IN`：古吉拉特语（印度）
`iw-IL`：希伯来语（以色列）
`hi-IN`：印地语（印度）
`hu-HU`：匈牙利语（匈牙利）
`is-IS`：冰岛语（冰岛）
`id-ID`：印度尼西亚语（印度尼西亚）
`it-IT`：意大利语（意大利）
`it-CH`：意大利语（瑞士）
`ja-JP`：日语（日本）
`jv-ID`：爪哇语（印度尼西亚）
`kn-IN`：卡纳达语（印度）
`kk-KZ`：哈萨克语（哈萨克斯坦）
`km-KH`：高棉语（柬埔寨）
`rw-RW`：卢旺达语（卢旺达）
`ko-KR`：韩语（韩国）
`lo-LA`：老挝语（老挝）
`lv-LV`：拉脱维亚语（拉脱维亚）
`lt-LT`：立陶宛语（立陶宛）
`mk-MK`：马其顿语（北马其顿）
`ms-MY`：马来语（马来西亚）
`ml-IN`：马拉雅拉姆语（印度）
`mr-IN`：马拉地语（印度）
`mn-MN`：蒙古语（蒙古）
`ne-NP`：尼泊尔语（尼泊尔）
`no-NO`：博克马尔挪威语（挪威）
`fa-IR`：波斯语（伊朗）
`pl-PL`：波兰语（波兰）
`pt-BR`：葡萄牙语（巴西）
`pt-PT`：葡萄牙语（葡萄牙）
`ro-RO`：罗马尼亚语（罗马尼亚）
`ru-RU`：俄语（俄罗斯）
`sr-RS`：塞尔维亚语（塞尔维亚）
`si-LK`：僧伽罗语（斯里兰卡）
`sk-SK`：斯洛伐克语（斯洛伐克）
`sl-SI`：斯洛文尼亚语（斯洛文尼亚）
`st-ZA`：南索托语（南非）
`es-AR`：西班牙语（阿根廷）
`es-BO`：西班牙语（玻利维亚）
`es-CL`：西班牙语（智利）
`es-CO`：西班牙语（哥伦比亚）
`es-CR`：西班牙语（哥斯达黎加）
`es-DO`：西班牙语（多米尼加共和国）
`es-EC`：西班牙语（厄瓜多尔）
`es-SV`：西班牙语（萨尔瓦多）
`es-GT`：西班牙语（危地马拉）
`es-HN`：西班牙语（洪都拉斯）
`es-MX`：西班牙语（墨西哥）
`es-NI`：西班牙语（尼加拉瓜）
`es-PA`：西班牙语（巴拿马）
`es-PY`：西班牙语（巴拉圭）
`es-PE`：西班牙语（秘鲁）
`es-PR`：西班牙语（波多黎各）
`es-ES`：西班牙语（西班牙）
`es-US`：西班牙语（美国）
`es-UY`：西班牙语（乌拉圭）
`es-VE`：西班牙语（委内瑞拉）
`su-ID`：巽他语（印度尼西亚）
`sw-KE`：斯瓦希里语（肯尼亚）
`sw-TZ`：斯瓦希里语（坦桑尼亚）
`sv-SE`：瑞典语（瑞典）
`ta-IN`：泰米尔语（印度）
`ta-MY`：泰米尔语（马来西亚）
`ta-SG`：泰米尔语（新加坡）
`ta-LK`：泰米尔语（斯里兰卡）
`te-IN`：泰卢固语（印度）
`th-TH`：泰语（泰国）
`ts-ZA`：聪加语（南非）
`tr-TR`：土耳其语（土耳其）
`uk-UA`：乌克兰语（乌克兰）
`ur-IN`：乌尔都语（印度）
`ur-PK`：乌尔都语（巴基斯坦）
`uz-UZ`：乌兹别克语（乌兹别克斯坦）
`ve-ZA`：文达语（南非）
`vi-VN`：越南语（越南）
`xh-ZA`：科萨语（南非）
`zu-ZA`：祖鲁语（南非）

        :type VideoSrcLanguage: str
        :param _SubtitleType: 智能字幕字幕语言类型
0: 源语言
1: 翻译语言
2: 源语言+翻译语言
当TranslateSwitch为OFF时仅支持取0
当TranslateSwitch为ON时仅支持取1或2
        :type SubtitleType: int
        :param _Comment: 智能字幕模板描述信息
长度限制：256 个字符。
        :type Comment: str
        :param _SubtitleFormat: 智能字幕文件格式:
- ASR识别翻译处理类型下：
     - vtt: WebVTT 格式字幕
     - srt: SRT 格式字幕
     - 不填或填空：不生成字幕文件
- 纯字幕翻译处理类型下：
    - original：与源文件一致
    - vtt: WebVTT 格式字幕
    - srt: SRT 格式字幕
- OCR识别翻译处理类型下：
     - vtt: WebVTT 格式字幕
     - srt: SRT 格式字幕

**注意**：
- ASR识别方式下，翻译大于等于2种语言时不允许传空或不传；
- 纯字幕翻译和OCR识别翻译方式下，不允许传空或不传
        :type SubtitleFormat: str
        :param _AsrHotWordsConfigure: ASR热词库参数
        :type AsrHotWordsConfigure: :class:`tencentcloud.mps.v20190612.models.AsrHotWordsConfigure`
        :param _TranslateSwitch: 字幕翻译开关
`ON`: 开启翻译
`OFF`: 关闭翻译

**注意**：纯字幕翻译方式下，不传默认是打开的，不允许传空或`OFF`；
        :type TranslateSwitch: str
        :param _TranslateDstLanguage: 字幕翻译目标语言
当TranslateSwitch为ON的时候生效，翻译语言列表：
`ab`：阿布哈兹语
`ace`：亚齐语
`ach`：阿乔利语
`af`：南非荷兰语
`ak`：契维语（阿坎语）
`am`：Amharic
`ar`：阿拉伯语
`as`：阿萨姆语
`ay`：艾马拉语
`az`：阿塞拜疆语
`ba`：巴什基尔语
`ban`：巴厘语
`bbc`：巴塔克托巴语
`bem`：Bemba
`bew`：Betawi
`bg`：保加利亚语
`bho`：博杰普尔语
`bik`：Bikol
`bm`：班巴拉语
`bn`：孟加拉语
`br`：布列塔尼语
`bs`：波斯尼亚语
`btx`：巴塔克卡罗语
`bts`：巴塔克西马隆贡语
`bua`：布里亚特语
`ca`：加泰罗尼亚语
`ceb`：宿务语
`cgg`：Kiga
`chm`：草原马里语
`ckb`：库尔德语（索拉尼语）
`cnh`：哈卡钦语
`co`：科西嘉语
`crh`：克里米亚鞑靼语
`crs`：塞舌尔克里奥尔语
`cs`：捷克语
`cv`：楚瓦什语
`cy`：威尔士语
`da`：丹麦语
`de`：德语
`din`：Dinka
`doi`：多格来语
`dov`：敦贝语
`dv`：第维埃语
`dz`：宗卡语
`ee`：Ewe
`el`：希腊语
`en`：英语
`eo`：世界语
`es`：西班牙语
`et`：爱沙尼亚语
`eu`：巴斯克语
`fa`：波斯语
`ff`：富拉语
`fi`：芬兰语
`fil`：菲律宾语（塔加拉语）
`fj`：斐济语
`fr`：法语
`fr-CA`：法语（加拿大）
`fr-FR`：法语（法国）
`fy`：弗里斯兰语
`ga`：爱尔兰语
`gaa`：加 (Ga) 语
`gd`：苏格兰盖尔语
`gl`：加利西亚语
`gn`：瓜拉尼语
`gom`：贡根语
`gu`：古吉拉特语
`gv`：马恩岛语
`ha`：Hausa
`haw`：夏威夷语
`he`：希伯来语
`hi`：印地语
`hil`：希利盖农语
`hmn`：苗语
`hr`：克罗地亚语
`hrx`：洪斯吕克语
`ht`：海地克里奥尔语
`hu`：匈牙利语
`hy`：亚美尼亚语
`id`：印度尼西亚语
`ig`：Igbo
`ilo`：伊洛果语
`is`：冰岛语
`it`：意大利语
`iw`：希伯来语
`ja`：日语
`jv`：爪哇语
`ka`：格鲁吉亚语
`kk`：哈萨克语
`km`：高棉语
`kn`：卡纳达语
`ko`：韩语
`kri`：Krio
`ku`：库尔德语（库尔曼吉语）
`ktu`：吉土巴语
`ky`：吉尔吉斯语
`la`：拉丁语
`lb`：卢森堡语
`lg`：干达语（卢干达语）
`li`：林堡语
`lij`：利古里亚语
`lmo`：伦巴第语
`ln`：林加拉语
`lo`：老挝语
`lt`：立陶宛语
`ltg`：拉特加莱语
`luo`：Luo
`lus`：米佐语
`lv`：拉脱维亚语
`mai`：迈蒂利语
`mak`：马卡萨
`mg`：马尔加什语
`mi`：毛利语
`min`：米南语
`mk`：马其顿语
`ml`：马拉雅拉姆语
`mn`：蒙古语
`mr`：马拉地语
`ms`：马来语
`mt`：马耳他语
`my`：缅甸语
`ne`：尼泊尔语
`new`：尼瓦尔语
`nl`：荷兰语
`no`：挪威语
`nr`：恩德贝莱语（南部）
`nso`：北索托语（塞佩蒂语）
`nus`：努尔语
`ny`：齐切瓦语（尼扬贾语）
`oc`：奥克斯坦语
`om`：Oromo
`or`：奥里亚语
`pa`：旁遮普语
`pag`：邦阿西楠语
`pam`：邦板牙语
`pap`：Papiamento
`pl`：波兰语
`ps`：Pashto
`pt`：葡萄牙语
`pt-BR`：葡萄牙语（巴西）
`pt-PT`：葡萄牙语（葡萄牙）
`qu`：克丘亚语
`ro`：罗马尼亚语
`rom`：罗姆语
`rn`：Rundi
`ru`：俄语
`rw`：卢旺达语
`sa`：梵语
`scn`：西西里语
`sd`：信德语
`sg`：Sango
`shn`：掸语
`si`：僧伽罗语
`sk`：斯洛伐克语
`sl`：斯洛文尼亚语
`sm`：萨摩亚语
`sn`：修纳语
`so`：索马里语
`sq`：阿尔巴尼亚语
`sr`：塞尔维亚语
`ss`：斯瓦特语
`st`：塞索托语
`su`：巽他语
`sv`：瑞典语
`sw`：斯瓦希里语
`szl`：西里西亚语
`ta`：泰米尔语
`te`：泰卢固语
`tet`：德顿语
`tg`：塔吉克语
`th`：泰语
`ti`：提格里尼亚语
`tk`：土库曼语
`tn`：茨瓦纳语
`tr`：土耳其语
`ts`：聪加语
`tt`：鞑靼语
`ug`：维吾尔语
`uk`：乌克兰语
`ur`：乌尔都语
`uz`：乌兹别克语
`vi`：越南语
`xh`：科萨语
`yi`：意第绪语
`yo`：约鲁巴语
`yua`：尤卡坦玛雅语
`yue`：粤语
`zh`：简体中文
`zh-TW`：中文（繁体）
`zu`：祖鲁语

**注意**：多语言方式，则使用 `/` 分割，如：`en/ja`，表示英语和日语。
        :type TranslateDstLanguage: str
        :param _ProcessType: 字幕处理类型：
- 0：ASR识别字幕
- 1：纯字幕翻译
- 2：OCR识别字幕

**注意**：不传的情况下默认类型为 ASR识别字幕
        :type ProcessType: int
        :param _SelectingSubtitleAreasConfig: 字幕OCR提取框选区域配置
        :type SelectingSubtitleAreasConfig: :class:`tencentcloud.mps.v20190612.models.SelectingSubtitleAreasConfig`
        """
        self._Name = None
        self._VideoSrcLanguage = None
        self._SubtitleType = None
        self._Comment = None
        self._SubtitleFormat = None
        self._AsrHotWordsConfigure = None
        self._TranslateSwitch = None
        self._TranslateDstLanguage = None
        self._ProcessType = None
        self._SelectingSubtitleAreasConfig = None

    @property
    def Name(self):
        r"""智能字幕模板名称
长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def VideoSrcLanguage(self):
        r"""智能字幕视频源语言
OCR识别仅支持以下语言：
`zh_en`：中英
`multi`：其他
ASR识别和纯字幕翻译当前支持以下语言：
`auto`：自动识别（仅在纯字幕翻译中支持）
`zh`：简体中文
`en`：英语
`ja`：日语
`ko`：韩语
`zh-PY`：中英粤
`zh_medical`：中文医疗
`vi`：越南语
`ms`：马来语
`id`：印度尼西亚语
`fil`：菲律宾语
`th`：泰语
`pt`：葡萄牙语
`tr`：土耳其语
`ar`：阿拉伯语
`es`：西班牙语
`hi`：印地语
`fr`：法语
`de`：德语
`it`：意大利语
`zh_dialect`：中文方言
`zh_en`：中英
`yue`：粤语
`ru`：俄语
`prime_zh`：中英方言
`af-ZA`：南非荷兰语（南非）
`sq-AL`：阿尔巴尼亚语（阿尔巴尼亚）
`am-ET`：阿姆哈拉语（埃塞俄比亚）
`ar-DZ`：阿拉伯语（阿尔及利亚）
`ar-BH`：阿拉伯语（巴林）
`ar-EG`：阿拉伯语（埃及）
`ar-IQ`：阿拉伯语（伊拉克）
`ar-IL`：阿拉伯语（以色列）
`ar-JO`：阿拉伯语（约旦）
`ar-KW`：阿拉伯语（科威特）
`ar-LB`：阿拉伯语（黎巴嫩）
`ar-MR`：阿拉伯语（毛里塔尼亚）
`ar-MA`：阿拉伯语（摩洛哥）
`ar-OM`：阿拉伯语（阿曼）
`ar-QA`：阿拉伯语（卡塔尔）
`ar-SA`：阿拉伯语（沙特阿拉伯）
`ar-PS`：阿拉伯语（巴勒斯坦国）
`ar-SY`：阿拉伯语（叙利亚）
`ar-TN`：阿拉伯语（突尼斯）
`ar-AE`：阿拉伯语（阿拉伯联合酋长国）
`ar-YE`：阿拉伯语（也门）
`hy-AM`：亚美尼亚语（亚美尼亚）
`az-AZ`：阿塞拜疆语（阿塞拜疆）
`eu-ES`：巴斯克语（西班牙）
`bn-BD`：孟加拉语（孟加拉）
`bn-IN`：孟加拉语（印度）
`bs-BA`：波斯尼亚语（波斯尼亚和黑塞哥维那）
`bg-BG`：保加利亚语（保加利亚）
`my-MM`：缅甸语（缅甸）
`ca-ES`：加泰罗尼亚语（西班牙）
`hr-HR`：克罗地亚语（克罗地亚）
`cs-CZ`：捷克语（捷克共和国）
`da-DK`：丹麦语（丹麦）
`nl-BE`：荷兰语（比利时）
`nl-NL`：荷兰语（荷兰）
`en-AU`：英语（澳大利亚）
`en-CA`：英语（加拿大）
`en-GH`：英语（加纳）
`en-HK`：英语（中国香港）
`en-IN`：英语（印度）
`en-IE`：英语（爱尔兰）
`en-KE`：英语（肯尼亚）
`en-NZ`：英语（新西兰）
`en-NG`：英语（尼日利亚）
`en-PK`：英语（巴基斯坦）
`en-PH`：英语（菲律宾）
`en-SG`：英语（新加坡）
`en-ZA`：英语（南非）
`en-TZ`：英语（坦桑尼亚）
`en-GB`：英语（英国）
`en-US`：英语（美国）
`et-EE`：爱沙尼亚语（爱沙尼亚）
`fil-PH`：菲律宾语（菲律宾）
`fi-FI`：芬兰语（芬兰）
`fr-BE`：法语（比利时）
`fr-CA`：法语（加拿大）
`fr-FR`：法语（法国）
`fr-CH`：法语（瑞士）
`gl-ES`：加利西亚语（西班牙）
`ka-GE`：格鲁吉亚语（格鲁吉亚）
`el-GR`：希腊语（希腊）
`gu-IN`：古吉拉特语（印度）
`iw-IL`：希伯来语（以色列）
`hi-IN`：印地语（印度）
`hu-HU`：匈牙利语（匈牙利）
`is-IS`：冰岛语（冰岛）
`id-ID`：印度尼西亚语（印度尼西亚）
`it-IT`：意大利语（意大利）
`it-CH`：意大利语（瑞士）
`ja-JP`：日语（日本）
`jv-ID`：爪哇语（印度尼西亚）
`kn-IN`：卡纳达语（印度）
`kk-KZ`：哈萨克语（哈萨克斯坦）
`km-KH`：高棉语（柬埔寨）
`rw-RW`：卢旺达语（卢旺达）
`ko-KR`：韩语（韩国）
`lo-LA`：老挝语（老挝）
`lv-LV`：拉脱维亚语（拉脱维亚）
`lt-LT`：立陶宛语（立陶宛）
`mk-MK`：马其顿语（北马其顿）
`ms-MY`：马来语（马来西亚）
`ml-IN`：马拉雅拉姆语（印度）
`mr-IN`：马拉地语（印度）
`mn-MN`：蒙古语（蒙古）
`ne-NP`：尼泊尔语（尼泊尔）
`no-NO`：博克马尔挪威语（挪威）
`fa-IR`：波斯语（伊朗）
`pl-PL`：波兰语（波兰）
`pt-BR`：葡萄牙语（巴西）
`pt-PT`：葡萄牙语（葡萄牙）
`ro-RO`：罗马尼亚语（罗马尼亚）
`ru-RU`：俄语（俄罗斯）
`sr-RS`：塞尔维亚语（塞尔维亚）
`si-LK`：僧伽罗语（斯里兰卡）
`sk-SK`：斯洛伐克语（斯洛伐克）
`sl-SI`：斯洛文尼亚语（斯洛文尼亚）
`st-ZA`：南索托语（南非）
`es-AR`：西班牙语（阿根廷）
`es-BO`：西班牙语（玻利维亚）
`es-CL`：西班牙语（智利）
`es-CO`：西班牙语（哥伦比亚）
`es-CR`：西班牙语（哥斯达黎加）
`es-DO`：西班牙语（多米尼加共和国）
`es-EC`：西班牙语（厄瓜多尔）
`es-SV`：西班牙语（萨尔瓦多）
`es-GT`：西班牙语（危地马拉）
`es-HN`：西班牙语（洪都拉斯）
`es-MX`：西班牙语（墨西哥）
`es-NI`：西班牙语（尼加拉瓜）
`es-PA`：西班牙语（巴拿马）
`es-PY`：西班牙语（巴拉圭）
`es-PE`：西班牙语（秘鲁）
`es-PR`：西班牙语（波多黎各）
`es-ES`：西班牙语（西班牙）
`es-US`：西班牙语（美国）
`es-UY`：西班牙语（乌拉圭）
`es-VE`：西班牙语（委内瑞拉）
`su-ID`：巽他语（印度尼西亚）
`sw-KE`：斯瓦希里语（肯尼亚）
`sw-TZ`：斯瓦希里语（坦桑尼亚）
`sv-SE`：瑞典语（瑞典）
`ta-IN`：泰米尔语（印度）
`ta-MY`：泰米尔语（马来西亚）
`ta-SG`：泰米尔语（新加坡）
`ta-LK`：泰米尔语（斯里兰卡）
`te-IN`：泰卢固语（印度）
`th-TH`：泰语（泰国）
`ts-ZA`：聪加语（南非）
`tr-TR`：土耳其语（土耳其）
`uk-UA`：乌克兰语（乌克兰）
`ur-IN`：乌尔都语（印度）
`ur-PK`：乌尔都语（巴基斯坦）
`uz-UZ`：乌兹别克语（乌兹别克斯坦）
`ve-ZA`：文达语（南非）
`vi-VN`：越南语（越南）
`xh-ZA`：科萨语（南非）
`zu-ZA`：祖鲁语（南非）

        :rtype: str
        """
        return self._VideoSrcLanguage

    @VideoSrcLanguage.setter
    def VideoSrcLanguage(self, VideoSrcLanguage):
        self._VideoSrcLanguage = VideoSrcLanguage

    @property
    def SubtitleType(self):
        r"""智能字幕字幕语言类型
0: 源语言
1: 翻译语言
2: 源语言+翻译语言
当TranslateSwitch为OFF时仅支持取0
当TranslateSwitch为ON时仅支持取1或2
        :rtype: int
        """
        return self._SubtitleType

    @SubtitleType.setter
    def SubtitleType(self, SubtitleType):
        self._SubtitleType = SubtitleType

    @property
    def Comment(self):
        r"""智能字幕模板描述信息
长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def SubtitleFormat(self):
        r"""智能字幕文件格式:
- ASR识别翻译处理类型下：
     - vtt: WebVTT 格式字幕
     - srt: SRT 格式字幕
     - 不填或填空：不生成字幕文件
- 纯字幕翻译处理类型下：
    - original：与源文件一致
    - vtt: WebVTT 格式字幕
    - srt: SRT 格式字幕
- OCR识别翻译处理类型下：
     - vtt: WebVTT 格式字幕
     - srt: SRT 格式字幕

**注意**：
- ASR识别方式下，翻译大于等于2种语言时不允许传空或不传；
- 纯字幕翻译和OCR识别翻译方式下，不允许传空或不传
        :rtype: str
        """
        return self._SubtitleFormat

    @SubtitleFormat.setter
    def SubtitleFormat(self, SubtitleFormat):
        self._SubtitleFormat = SubtitleFormat

    @property
    def AsrHotWordsConfigure(self):
        r"""ASR热词库参数
        :rtype: :class:`tencentcloud.mps.v20190612.models.AsrHotWordsConfigure`
        """
        return self._AsrHotWordsConfigure

    @AsrHotWordsConfigure.setter
    def AsrHotWordsConfigure(self, AsrHotWordsConfigure):
        self._AsrHotWordsConfigure = AsrHotWordsConfigure

    @property
    def TranslateSwitch(self):
        r"""字幕翻译开关
`ON`: 开启翻译
`OFF`: 关闭翻译

**注意**：纯字幕翻译方式下，不传默认是打开的，不允许传空或`OFF`；
        :rtype: str
        """
        return self._TranslateSwitch

    @TranslateSwitch.setter
    def TranslateSwitch(self, TranslateSwitch):
        self._TranslateSwitch = TranslateSwitch

    @property
    def TranslateDstLanguage(self):
        r"""字幕翻译目标语言
当TranslateSwitch为ON的时候生效，翻译语言列表：
`ab`：阿布哈兹语
`ace`：亚齐语
`ach`：阿乔利语
`af`：南非荷兰语
`ak`：契维语（阿坎语）
`am`：Amharic
`ar`：阿拉伯语
`as`：阿萨姆语
`ay`：艾马拉语
`az`：阿塞拜疆语
`ba`：巴什基尔语
`ban`：巴厘语
`bbc`：巴塔克托巴语
`bem`：Bemba
`bew`：Betawi
`bg`：保加利亚语
`bho`：博杰普尔语
`bik`：Bikol
`bm`：班巴拉语
`bn`：孟加拉语
`br`：布列塔尼语
`bs`：波斯尼亚语
`btx`：巴塔克卡罗语
`bts`：巴塔克西马隆贡语
`bua`：布里亚特语
`ca`：加泰罗尼亚语
`ceb`：宿务语
`cgg`：Kiga
`chm`：草原马里语
`ckb`：库尔德语（索拉尼语）
`cnh`：哈卡钦语
`co`：科西嘉语
`crh`：克里米亚鞑靼语
`crs`：塞舌尔克里奥尔语
`cs`：捷克语
`cv`：楚瓦什语
`cy`：威尔士语
`da`：丹麦语
`de`：德语
`din`：Dinka
`doi`：多格来语
`dov`：敦贝语
`dv`：第维埃语
`dz`：宗卡语
`ee`：Ewe
`el`：希腊语
`en`：英语
`eo`：世界语
`es`：西班牙语
`et`：爱沙尼亚语
`eu`：巴斯克语
`fa`：波斯语
`ff`：富拉语
`fi`：芬兰语
`fil`：菲律宾语（塔加拉语）
`fj`：斐济语
`fr`：法语
`fr-CA`：法语（加拿大）
`fr-FR`：法语（法国）
`fy`：弗里斯兰语
`ga`：爱尔兰语
`gaa`：加 (Ga) 语
`gd`：苏格兰盖尔语
`gl`：加利西亚语
`gn`：瓜拉尼语
`gom`：贡根语
`gu`：古吉拉特语
`gv`：马恩岛语
`ha`：Hausa
`haw`：夏威夷语
`he`：希伯来语
`hi`：印地语
`hil`：希利盖农语
`hmn`：苗语
`hr`：克罗地亚语
`hrx`：洪斯吕克语
`ht`：海地克里奥尔语
`hu`：匈牙利语
`hy`：亚美尼亚语
`id`：印度尼西亚语
`ig`：Igbo
`ilo`：伊洛果语
`is`：冰岛语
`it`：意大利语
`iw`：希伯来语
`ja`：日语
`jv`：爪哇语
`ka`：格鲁吉亚语
`kk`：哈萨克语
`km`：高棉语
`kn`：卡纳达语
`ko`：韩语
`kri`：Krio
`ku`：库尔德语（库尔曼吉语）
`ktu`：吉土巴语
`ky`：吉尔吉斯语
`la`：拉丁语
`lb`：卢森堡语
`lg`：干达语（卢干达语）
`li`：林堡语
`lij`：利古里亚语
`lmo`：伦巴第语
`ln`：林加拉语
`lo`：老挝语
`lt`：立陶宛语
`ltg`：拉特加莱语
`luo`：Luo
`lus`：米佐语
`lv`：拉脱维亚语
`mai`：迈蒂利语
`mak`：马卡萨
`mg`：马尔加什语
`mi`：毛利语
`min`：米南语
`mk`：马其顿语
`ml`：马拉雅拉姆语
`mn`：蒙古语
`mr`：马拉地语
`ms`：马来语
`mt`：马耳他语
`my`：缅甸语
`ne`：尼泊尔语
`new`：尼瓦尔语
`nl`：荷兰语
`no`：挪威语
`nr`：恩德贝莱语（南部）
`nso`：北索托语（塞佩蒂语）
`nus`：努尔语
`ny`：齐切瓦语（尼扬贾语）
`oc`：奥克斯坦语
`om`：Oromo
`or`：奥里亚语
`pa`：旁遮普语
`pag`：邦阿西楠语
`pam`：邦板牙语
`pap`：Papiamento
`pl`：波兰语
`ps`：Pashto
`pt`：葡萄牙语
`pt-BR`：葡萄牙语（巴西）
`pt-PT`：葡萄牙语（葡萄牙）
`qu`：克丘亚语
`ro`：罗马尼亚语
`rom`：罗姆语
`rn`：Rundi
`ru`：俄语
`rw`：卢旺达语
`sa`：梵语
`scn`：西西里语
`sd`：信德语
`sg`：Sango
`shn`：掸语
`si`：僧伽罗语
`sk`：斯洛伐克语
`sl`：斯洛文尼亚语
`sm`：萨摩亚语
`sn`：修纳语
`so`：索马里语
`sq`：阿尔巴尼亚语
`sr`：塞尔维亚语
`ss`：斯瓦特语
`st`：塞索托语
`su`：巽他语
`sv`：瑞典语
`sw`：斯瓦希里语
`szl`：西里西亚语
`ta`：泰米尔语
`te`：泰卢固语
`tet`：德顿语
`tg`：塔吉克语
`th`：泰语
`ti`：提格里尼亚语
`tk`：土库曼语
`tn`：茨瓦纳语
`tr`：土耳其语
`ts`：聪加语
`tt`：鞑靼语
`ug`：维吾尔语
`uk`：乌克兰语
`ur`：乌尔都语
`uz`：乌兹别克语
`vi`：越南语
`xh`：科萨语
`yi`：意第绪语
`yo`：约鲁巴语
`yua`：尤卡坦玛雅语
`yue`：粤语
`zh`：简体中文
`zh-TW`：中文（繁体）
`zu`：祖鲁语

**注意**：多语言方式，则使用 `/` 分割，如：`en/ja`，表示英语和日语。
        :rtype: str
        """
        return self._TranslateDstLanguage

    @TranslateDstLanguage.setter
    def TranslateDstLanguage(self, TranslateDstLanguage):
        self._TranslateDstLanguage = TranslateDstLanguage

    @property
    def ProcessType(self):
        r"""字幕处理类型：
- 0：ASR识别字幕
- 1：纯字幕翻译
- 2：OCR识别字幕

**注意**：不传的情况下默认类型为 ASR识别字幕
        :rtype: int
        """
        return self._ProcessType

    @ProcessType.setter
    def ProcessType(self, ProcessType):
        self._ProcessType = ProcessType

    @property
    def SelectingSubtitleAreasConfig(self):
        r"""字幕OCR提取框选区域配置
        :rtype: :class:`tencentcloud.mps.v20190612.models.SelectingSubtitleAreasConfig`
        """
        return self._SelectingSubtitleAreasConfig

    @SelectingSubtitleAreasConfig.setter
    def SelectingSubtitleAreasConfig(self, SelectingSubtitleAreasConfig):
        self._SelectingSubtitleAreasConfig = SelectingSubtitleAreasConfig


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._VideoSrcLanguage = params.get("VideoSrcLanguage")
        self._SubtitleType = params.get("SubtitleType")
        self._Comment = params.get("Comment")
        self._SubtitleFormat = params.get("SubtitleFormat")
        if params.get("AsrHotWordsConfigure") is not None:
            self._AsrHotWordsConfigure = AsrHotWordsConfigure()
            self._AsrHotWordsConfigure._deserialize(params.get("AsrHotWordsConfigure"))
        self._TranslateSwitch = params.get("TranslateSwitch")
        self._TranslateDstLanguage = params.get("TranslateDstLanguage")
        self._ProcessType = params.get("ProcessType")
        if params.get("SelectingSubtitleAreasConfig") is not None:
            self._SelectingSubtitleAreasConfig = SelectingSubtitleAreasConfig()
            self._SelectingSubtitleAreasConfig._deserialize(params.get("SelectingSubtitleAreasConfig"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSmartSubtitleTemplateResponse(AbstractModel):
    r"""CreateSmartSubtitleTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 智能字幕模板唯一标识。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""智能字幕模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateSnapshotByTimeOffsetTemplateRequest(AbstractModel):
    r"""CreateSnapshotByTimeOffsetTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 指定时间点截图模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Width: 截图宽度（或长边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Width: int
        :param _Height: 截图高度（或短边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Height: int
        :param _ResolutionAdaptive: 分辨率自适应，可选值：
<li>open：开启，此时，Width 代表视频的长边，Height 表示视频的短边；</li>
<li>close：关闭，此时，Width 代表视频的宽度，Height 表示视频的高度。</li>
默认值：open。
        :type ResolutionAdaptive: str
        :param _Format: 图片格式，取值可以为 jpg、png、webp。默认为 jpg。
        :type Format: str
        :param _Comment: 模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _FillType: 填充方式，当视频流配置宽高参数与原始视频的宽高比不一致时，对转码的处理方式，即为“填充”。可选填充方式：
<li> stretch：拉伸，对每一帧进行拉伸，填满整个画面，可能导致转码后的视频被“压扁“或者“拉长“；</li>
<li>black：留黑，保持视频宽高比不变，边缘剩余部分使用黑色填充。</li>
<li>white：留白，保持视频宽高比不变，边缘剩余部分使用白色填充。</li>
<li>gauss：高斯模糊，保持视频宽高比不变，边缘剩余部分使用高斯模糊。</li>
默认值：black 。
        :type FillType: str
        """
        self._Name = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._Format = None
        self._Comment = None
        self._FillType = None

    @property
    def Name(self):
        r"""指定时间点截图模板名称，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Width(self):
        r"""截图宽度（或长边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :rtype: int
        """
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        r"""截图高度（或短边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :rtype: int
        """
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        r"""分辨率自适应，可选值：
<li>open：开启，此时，Width 代表视频的长边，Height 表示视频的短边；</li>
<li>close：关闭，此时，Width 代表视频的宽度，Height 表示视频的高度。</li>
默认值：open。
        :rtype: str
        """
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def Format(self):
        r"""图片格式，取值可以为 jpg、png、webp。默认为 jpg。
        :rtype: str
        """
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def Comment(self):
        r"""模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def FillType(self):
        r"""填充方式，当视频流配置宽高参数与原始视频的宽高比不一致时，对转码的处理方式，即为“填充”。可选填充方式：
<li> stretch：拉伸，对每一帧进行拉伸，填满整个画面，可能导致转码后的视频被“压扁“或者“拉长“；</li>
<li>black：留黑，保持视频宽高比不变，边缘剩余部分使用黑色填充。</li>
<li>white：留白，保持视频宽高比不变，边缘剩余部分使用白色填充。</li>
<li>gauss：高斯模糊，保持视频宽高比不变，边缘剩余部分使用高斯模糊。</li>
默认值：black 。
        :rtype: str
        """
        return self._FillType

    @FillType.setter
    def FillType(self, FillType):
        self._FillType = FillType


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._Format = params.get("Format")
        self._Comment = params.get("Comment")
        self._FillType = params.get("FillType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSnapshotByTimeOffsetTemplateResponse(AbstractModel):
    r"""CreateSnapshotByTimeOffsetTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 时间点截图模板唯一标识。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""时间点截图模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateStreamLinkEventRequest(AbstractModel):
    r"""CreateStreamLinkEvent请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EventName: 事件名称。
        :type EventName: str
        :param _Description: 事件描述。
        :type Description: str
        """
        self._EventName = None
        self._Description = None

    @property
    def EventName(self):
        r"""事件名称。
        :rtype: str
        """
        return self._EventName

    @EventName.setter
    def EventName(self, EventName):
        self._EventName = EventName

    @property
    def Description(self):
        r"""事件描述。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._EventName = params.get("EventName")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateStreamLinkEventResponse(AbstractModel):
    r"""CreateStreamLinkEvent返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Info: 创建的Event信息。
        :type Info: :class:`tencentcloud.mps.v20190612.models.DescribeEvent`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Info = None
        self._RequestId = None

    @property
    def Info(self):
        r"""创建的Event信息。
        :rtype: :class:`tencentcloud.mps.v20190612.models.DescribeEvent`
        """
        return self._Info

    @Info.setter
    def Info(self, Info):
        self._Info = Info

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Info") is not None:
            self._Info = DescribeEvent()
            self._Info._deserialize(params.get("Info"))
        self._RequestId = params.get("RequestId")


class CreateStreamLinkFlowRequest(AbstractModel):
    r"""CreateStreamLinkFlow请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FlowName: 流名称。
        :type FlowName: str
        :param _MaxBandwidth: 最大带宽，单位bps，可选[10000000, 20000000, 50000000]。
        :type MaxBandwidth: int
        :param _InputGroup: 流的输入组。
        :type InputGroup: list of CreateInput
        :param _EventId: 该Flow关联的媒体传输事件ID，每个flow只能关联一个Event。
        :type EventId: str
        :param _OutputGroup: 流的输出组。
        :type OutputGroup: list of CreateOutputInfo
        """
        self._FlowName = None
        self._MaxBandwidth = None
        self._InputGroup = None
        self._EventId = None
        self._OutputGroup = None

    @property
    def FlowName(self):
        r"""流名称。
        :rtype: str
        """
        return self._FlowName

    @FlowName.setter
    def FlowName(self, FlowName):
        self._FlowName = FlowName

    @property
    def MaxBandwidth(self):
        r"""最大带宽，单位bps，可选[10000000, 20000000, 50000000]。
        :rtype: int
        """
        return self._MaxBandwidth

    @MaxBandwidth.setter
    def MaxBandwidth(self, MaxBandwidth):
        self._MaxBandwidth = MaxBandwidth

    @property
    def InputGroup(self):
        r"""流的输入组。
        :rtype: list of CreateInput
        """
        return self._InputGroup

    @InputGroup.setter
    def InputGroup(self, InputGroup):
        self._InputGroup = InputGroup

    @property
    def EventId(self):
        r"""该Flow关联的媒体传输事件ID，每个flow只能关联一个Event。
        :rtype: str
        """
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId

    @property
    def OutputGroup(self):
        r"""流的输出组。
        :rtype: list of CreateOutputInfo
        """
        return self._OutputGroup

    @OutputGroup.setter
    def OutputGroup(self, OutputGroup):
        self._OutputGroup = OutputGroup


    def _deserialize(self, params):
        self._FlowName = params.get("FlowName")
        self._MaxBandwidth = params.get("MaxBandwidth")
        if params.get("InputGroup") is not None:
            self._InputGroup = []
            for item in params.get("InputGroup"):
                obj = CreateInput()
                obj._deserialize(item)
                self._InputGroup.append(obj)
        self._EventId = params.get("EventId")
        if params.get("OutputGroup") is not None:
            self._OutputGroup = []
            for item in params.get("OutputGroup"):
                obj = CreateOutputInfo()
                obj._deserialize(item)
                self._OutputGroup.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateStreamLinkFlowResponse(AbstractModel):
    r"""CreateStreamLinkFlow返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Info: 创建的Flow信息。
        :type Info: :class:`tencentcloud.mps.v20190612.models.DescribeFlow`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Info = None
        self._RequestId = None

    @property
    def Info(self):
        r"""创建的Flow信息。
        :rtype: :class:`tencentcloud.mps.v20190612.models.DescribeFlow`
        """
        return self._Info

    @Info.setter
    def Info(self, Info):
        self._Info = Info

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Info") is not None:
            self._Info = DescribeFlow()
            self._Info._deserialize(params.get("Info"))
        self._RequestId = params.get("RequestId")


class CreateStreamLinkInputRequest(AbstractModel):
    r"""CreateStreamLinkInput请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FlowId: 媒体传输流ID。
        :type FlowId: str
        :param _InputGroup: 流的输入组。
        :type InputGroup: list of CreateInput
        """
        self._FlowId = None
        self._InputGroup = None

    @property
    def FlowId(self):
        r"""媒体传输流ID。
        :rtype: str
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def InputGroup(self):
        r"""流的输入组。
        :rtype: list of CreateInput
        """
        return self._InputGroup

    @InputGroup.setter
    def InputGroup(self, InputGroup):
        self._InputGroup = InputGroup


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        if params.get("InputGroup") is not None:
            self._InputGroup = []
            for item in params.get("InputGroup"):
                obj = CreateInput()
                obj._deserialize(item)
                self._InputGroup.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateStreamLinkInputResponse(AbstractModel):
    r"""CreateStreamLinkInput返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Info: 创建的Flow信息。
        :type Info: :class:`tencentcloud.mps.v20190612.models.DescribeFlow`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Info = None
        self._RequestId = None

    @property
    def Info(self):
        r"""创建的Flow信息。
        :rtype: :class:`tencentcloud.mps.v20190612.models.DescribeFlow`
        """
        return self._Info

    @Info.setter
    def Info(self, Info):
        self._Info = Info

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Info") is not None:
            self._Info = DescribeFlow()
            self._Info._deserialize(params.get("Info"))
        self._RequestId = params.get("RequestId")


class CreateStreamLinkOutputInfoRequest(AbstractModel):
    r"""CreateStreamLinkOutputInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FlowId: 传输流Id。
        :type FlowId: str
        :param _Output: 传输流的Output配置。
        :type Output: :class:`tencentcloud.mps.v20190612.models.CreateOutputInfo`
        """
        self._FlowId = None
        self._Output = None

    @property
    def FlowId(self):
        r"""传输流Id。
        :rtype: str
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def Output(self):
        r"""传输流的Output配置。
        :rtype: :class:`tencentcloud.mps.v20190612.models.CreateOutputInfo`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        if params.get("Output") is not None:
            self._Output = CreateOutputInfo()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateStreamLinkOutputInfoResponse(AbstractModel):
    r"""CreateStreamLinkOutputInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Info: 创建后的Output信息。
        :type Info: :class:`tencentcloud.mps.v20190612.models.DescribeOutput`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Info = None
        self._RequestId = None

    @property
    def Info(self):
        r"""创建后的Output信息。
        :rtype: :class:`tencentcloud.mps.v20190612.models.DescribeOutput`
        """
        return self._Info

    @Info.setter
    def Info(self, Info):
        self._Info = Info

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Info") is not None:
            self._Info = DescribeOutput()
            self._Info._deserialize(params.get("Info"))
        self._RequestId = params.get("RequestId")


class CreateStreamLinkSecurityGroupRequest(AbstractModel):
    r"""CreateStreamLinkSecurityGroup请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 安全组名称，限制大小写、数字和下划线，Region下唯一。
        :type Name: str
        :param _Whitelist: 白名单列表，数量限制[1, 10]。
        :type Whitelist: list of str
        """
        self._Name = None
        self._Whitelist = None

    @property
    def Name(self):
        r"""安全组名称，限制大小写、数字和下划线，Region下唯一。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Whitelist(self):
        r"""白名单列表，数量限制[1, 10]。
        :rtype: list of str
        """
        return self._Whitelist

    @Whitelist.setter
    def Whitelist(self, Whitelist):
        self._Whitelist = Whitelist


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Whitelist = params.get("Whitelist")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateStreamLinkSecurityGroupResponse(AbstractModel):
    r"""CreateStreamLinkSecurityGroup返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 安全组 ID。
        :type Id: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Id = None
        self._RequestId = None

    @property
    def Id(self):
        r"""安全组 ID。
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._RequestId = params.get("RequestId")


class CreateTranscodeTemplateRequest(AbstractModel):
    r"""CreateTranscodeTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Container: 封装格式，可选值：mp4、flv、hls、ts、webm、mkv、mxf、mov、mp3、flac、ogg、m4a。其中，mp3、flac、ogg、m4a 为纯音频文件。
        :type Container: str
        :param _Name: 转码模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Comment: 模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _RemoveVideo: 是否去除视频数据，可选值：
<li>0：保留</li>
<li>1：去除</li>
默认值：0。
        :type RemoveVideo: int
        :param _RemoveAudio: 是否去除音频数据，可选值：
<li>0：保留</li>
<li>1：去除</li>
默认值：0。
        :type RemoveAudio: int
        :param _VideoTemplate: 视频流配置参数，当 RemoveVideo 为 0，该字段必填。
        :type VideoTemplate: :class:`tencentcloud.mps.v20190612.models.VideoTemplateInfo`
        :param _AudioTemplate: 音频流配置参数，当 RemoveAudio 为 0，该字段必填。
        :type AudioTemplate: :class:`tencentcloud.mps.v20190612.models.AudioTemplateInfo`
        :param _TEHDConfig: 极速高清转码参数。
        :type TEHDConfig: :class:`tencentcloud.mps.v20190612.models.TEHDConfig`
        :param _EnhanceConfig: 音视频增强配置。
        :type EnhanceConfig: :class:`tencentcloud.mps.v20190612.models.EnhanceConfig`
        :param _StdExtInfo: 扩展参数，序列化的 json 字符串。
        :type StdExtInfo: str
        """
        self._Container = None
        self._Name = None
        self._Comment = None
        self._RemoveVideo = None
        self._RemoveAudio = None
        self._VideoTemplate = None
        self._AudioTemplate = None
        self._TEHDConfig = None
        self._EnhanceConfig = None
        self._StdExtInfo = None

    @property
    def Container(self):
        r"""封装格式，可选值：mp4、flv、hls、ts、webm、mkv、mxf、mov、mp3、flac、ogg、m4a。其中，mp3、flac、ogg、m4a 为纯音频文件。
        :rtype: str
        """
        return self._Container

    @Container.setter
    def Container(self, Container):
        self._Container = Container

    @property
    def Name(self):
        r"""转码模板名称，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        r"""模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def RemoveVideo(self):
        r"""是否去除视频数据，可选值：
<li>0：保留</li>
<li>1：去除</li>
默认值：0。
        :rtype: int
        """
        return self._RemoveVideo

    @RemoveVideo.setter
    def RemoveVideo(self, RemoveVideo):
        self._RemoveVideo = RemoveVideo

    @property
    def RemoveAudio(self):
        r"""是否去除音频数据，可选值：
<li>0：保留</li>
<li>1：去除</li>
默认值：0。
        :rtype: int
        """
        return self._RemoveAudio

    @RemoveAudio.setter
    def RemoveAudio(self, RemoveAudio):
        self._RemoveAudio = RemoveAudio

    @property
    def VideoTemplate(self):
        r"""视频流配置参数，当 RemoveVideo 为 0，该字段必填。
        :rtype: :class:`tencentcloud.mps.v20190612.models.VideoTemplateInfo`
        """
        return self._VideoTemplate

    @VideoTemplate.setter
    def VideoTemplate(self, VideoTemplate):
        self._VideoTemplate = VideoTemplate

    @property
    def AudioTemplate(self):
        r"""音频流配置参数，当 RemoveAudio 为 0，该字段必填。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AudioTemplateInfo`
        """
        return self._AudioTemplate

    @AudioTemplate.setter
    def AudioTemplate(self, AudioTemplate):
        self._AudioTemplate = AudioTemplate

    @property
    def TEHDConfig(self):
        r"""极速高清转码参数。
        :rtype: :class:`tencentcloud.mps.v20190612.models.TEHDConfig`
        """
        return self._TEHDConfig

    @TEHDConfig.setter
    def TEHDConfig(self, TEHDConfig):
        self._TEHDConfig = TEHDConfig

    @property
    def EnhanceConfig(self):
        r"""音视频增强配置。
        :rtype: :class:`tencentcloud.mps.v20190612.models.EnhanceConfig`
        """
        return self._EnhanceConfig

    @EnhanceConfig.setter
    def EnhanceConfig(self, EnhanceConfig):
        self._EnhanceConfig = EnhanceConfig

    @property
    def StdExtInfo(self):
        r"""扩展参数，序列化的 json 字符串。
        :rtype: str
        """
        return self._StdExtInfo

    @StdExtInfo.setter
    def StdExtInfo(self, StdExtInfo):
        self._StdExtInfo = StdExtInfo


    def _deserialize(self, params):
        self._Container = params.get("Container")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        self._RemoveVideo = params.get("RemoveVideo")
        self._RemoveAudio = params.get("RemoveAudio")
        if params.get("VideoTemplate") is not None:
            self._VideoTemplate = VideoTemplateInfo()
            self._VideoTemplate._deserialize(params.get("VideoTemplate"))
        if params.get("AudioTemplate") is not None:
            self._AudioTemplate = AudioTemplateInfo()
            self._AudioTemplate._deserialize(params.get("AudioTemplate"))
        if params.get("TEHDConfig") is not None:
            self._TEHDConfig = TEHDConfig()
            self._TEHDConfig._deserialize(params.get("TEHDConfig"))
        if params.get("EnhanceConfig") is not None:
            self._EnhanceConfig = EnhanceConfig()
            self._EnhanceConfig._deserialize(params.get("EnhanceConfig"))
        self._StdExtInfo = params.get("StdExtInfo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTranscodeTemplateResponse(AbstractModel):
    r"""CreateTranscodeTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 转码模板唯一标识。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""转码模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateVideoDatabaseEntryTaskRequest(AbstractModel):
    r"""CreateVideoDatabaseEntryTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InputInfo: 待入库视频信息
        :type InputInfo: :class:`tencentcloud.mps.v20190612.models.MediaInputInfo`
        :param _TaskNotifyConfig: 可选，入库任务完成后向指定的回调地址传递任务结果，目前仅支持URL
        :type TaskNotifyConfig: :class:`tencentcloud.mps.v20190612.models.TaskNotifyConfig`
        """
        self._InputInfo = None
        self._TaskNotifyConfig = None

    @property
    def InputInfo(self):
        r"""待入库视频信息
        :rtype: :class:`tencentcloud.mps.v20190612.models.MediaInputInfo`
        """
        return self._InputInfo

    @InputInfo.setter
    def InputInfo(self, InputInfo):
        self._InputInfo = InputInfo

    @property
    def TaskNotifyConfig(self):
        r"""可选，入库任务完成后向指定的回调地址传递任务结果，目前仅支持URL
        :rtype: :class:`tencentcloud.mps.v20190612.models.TaskNotifyConfig`
        """
        return self._TaskNotifyConfig

    @TaskNotifyConfig.setter
    def TaskNotifyConfig(self, TaskNotifyConfig):
        self._TaskNotifyConfig = TaskNotifyConfig


    def _deserialize(self, params):
        if params.get("InputInfo") is not None:
            self._InputInfo = MediaInputInfo()
            self._InputInfo._deserialize(params.get("InputInfo"))
        if params.get("TaskNotifyConfig") is not None:
            self._TaskNotifyConfig = TaskNotifyConfig()
            self._TaskNotifyConfig._deserialize(params.get("TaskNotifyConfig"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVideoDatabaseEntryTaskResponse(AbstractModel):
    r"""CreateVideoDatabaseEntryTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        r"""任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class CreateVideoSearchTaskRequest(AbstractModel):
    r"""CreateVideoSearchTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SearchValueInput: 用于检索任务的输入
        :type SearchValueInput: :class:`tencentcloud.mps.v20190612.models.SearchValueInput`
        :param _Limit: 返回视频的最大数量，取值范围[1,20]，将返回最相近的前Limit条视频,默认为5
        :type Limit: int
        :param _TaskNotifyConfig: 可选，用于检索任务完成后向回调方发送检索结果，目前仅支持URL方式
        :type TaskNotifyConfig: :class:`tencentcloud.mps.v20190612.models.TaskNotifyConfig`
        """
        self._SearchValueInput = None
        self._Limit = None
        self._TaskNotifyConfig = None

    @property
    def SearchValueInput(self):
        r"""用于检索任务的输入
        :rtype: :class:`tencentcloud.mps.v20190612.models.SearchValueInput`
        """
        return self._SearchValueInput

    @SearchValueInput.setter
    def SearchValueInput(self, SearchValueInput):
        self._SearchValueInput = SearchValueInput

    @property
    def Limit(self):
        r"""返回视频的最大数量，取值范围[1,20]，将返回最相近的前Limit条视频,默认为5
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def TaskNotifyConfig(self):
        r"""可选，用于检索任务完成后向回调方发送检索结果，目前仅支持URL方式
        :rtype: :class:`tencentcloud.mps.v20190612.models.TaskNotifyConfig`
        """
        return self._TaskNotifyConfig

    @TaskNotifyConfig.setter
    def TaskNotifyConfig(self, TaskNotifyConfig):
        self._TaskNotifyConfig = TaskNotifyConfig


    def _deserialize(self, params):
        if params.get("SearchValueInput") is not None:
            self._SearchValueInput = SearchValueInput()
            self._SearchValueInput._deserialize(params.get("SearchValueInput"))
        self._Limit = params.get("Limit")
        if params.get("TaskNotifyConfig") is not None:
            self._TaskNotifyConfig = TaskNotifyConfig()
            self._TaskNotifyConfig._deserialize(params.get("TaskNotifyConfig"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVideoSearchTaskResponse(AbstractModel):
    r"""CreateVideoSearchTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 检索任务的Id，用于后续查询任务状态和返回任务结果时标识任务
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        r"""检索任务的Id，用于后续查询任务状态和返回任务结果时标识任务
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class CreateWatermarkTemplateRequest(AbstractModel):
    r"""CreateWatermarkTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Type: 水印类型，可选值：
<li>image：图片水印；</li>
<li>text：文字水印；</li>
<li>svg：SVG 水印。</li>
        :type Type: str
        :param _Name: 水印模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Comment: 模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _CoordinateOrigin: 原点位置，可选值：
<li>TopLeft：表示坐标原点位于视频图像左上角，水印原点为图片或文字的左上角；</li>
<li>TopRight：表示坐标原点位于视频图像的右上角，水印原点为图片或文字的右上角；</li>
<li>BottomLeft：表示坐标原点位于视频图像的左下角，水印原点为图片或文字的左下角；</li>
<li>BottomRight：表示坐标原点位于视频图像的右下角，水印原点为图片或文字的右下角。</li>
默认值：TopLeft。
        :type CoordinateOrigin: str
        :param _XPos: 水印原点距离视频图像坐标原点的水平位置。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示水印 XPos 为视频宽度指定百分比，如 10% 表示 XPos 为视频宽度的 10%；</li>
<li>当字符串以 px 结尾，表示水印 XPos 为指定像素，如 100px 表示 XPos 为 100 像素。</li>
默认值：0px。
        :type XPos: str
        :param _YPos: 水印原点距离视频图像坐标原点的垂直位置。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示水印 YPos 为视频高度指定百分比，如 10% 表示 YPos 为视频高度的 10%；</li>
<li>当字符串以 px 结尾，表示水印 YPos 为指定像素，如 100px 表示 YPos 为 100 像素。</li>
默认值：0px。
        :type YPos: str
        :param _ImageTemplate: 图片水印模板，仅当 Type 为 image，该字段必填且有效。
        :type ImageTemplate: :class:`tencentcloud.mps.v20190612.models.ImageWatermarkInput`
        :param _TextTemplate: 文字水印模板，仅当 Type 为 text，该字段必填且有效。
        :type TextTemplate: :class:`tencentcloud.mps.v20190612.models.TextWatermarkTemplateInput`
        :param _SvgTemplate: SVG 水印模板，仅当 Type 为 svg，该字段必填且有效。
        :type SvgTemplate: :class:`tencentcloud.mps.v20190612.models.SvgWatermarkInput`
        """
        self._Type = None
        self._Name = None
        self._Comment = None
        self._CoordinateOrigin = None
        self._XPos = None
        self._YPos = None
        self._ImageTemplate = None
        self._TextTemplate = None
        self._SvgTemplate = None

    @property
    def Type(self):
        r"""水印类型，可选值：
<li>image：图片水印；</li>
<li>text：文字水印；</li>
<li>svg：SVG 水印。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        r"""水印模板名称，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        r"""模板描述信息，长度限制：256 个字符。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def CoordinateOrigin(self):
        r"""原点位置，可选值：
<li>TopLeft：表示坐标原点位于视频图像左上角，水印原点为图片或文字的左上角；</li>
<li>TopRight：表示坐标原点位于视频图像的右上角，水印原点为图片或文字的右上角；</li>
<li>BottomLeft：表示坐标原点位于视频图像的左下角，水印原点为图片或文字的左下角；</li>
<li>BottomRight：表示坐标原点位于视频图像的右下角，水印原点为图片或文字的右下角。</li>
默认值：TopLeft。
        :rtype: str
        """
        return self._CoordinateOrigin

    @CoordinateOrigin.setter
    def CoordinateOrigin(self, CoordinateOrigin):
        self._CoordinateOrigin = CoordinateOrigin

    @property
    def XPos(self):
        r"""水印原点距离视频图像坐标原点的水平位置。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示水印 XPos 为视频宽度指定百分比，如 10% 表示 XPos 为视频宽度的 10%；</li>
<li>当字符串以 px 结尾，表示水印 XPos 为指定像素，如 100px 表示 XPos 为 100 像素。</li>
默认值：0px。
        :rtype: str
        """
        return self._XPos

    @XPos.setter
    def XPos(self, XPos):
        self._XPos = XPos

    @property
    def YPos(self):
        r"""水印原点距离视频图像坐标原点的垂直位置。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示水印 YPos 为视频高度指定百分比，如 10% 表示 YPos 为视频高度的 10%；</li>
<li>当字符串以 px 结尾，表示水印 YPos 为指定像素，如 100px 表示 YPos 为 100 像素。</li>
默认值：0px。
        :rtype: str
        """
        return self._YPos

    @YPos.setter
    def YPos(self, YPos):
        self._YPos = YPos

    @property
    def ImageTemplate(self):
        r"""图片水印模板，仅当 Type 为 image，该字段必填且有效。
        :rtype: :class:`tencentcloud.mps.v20190612.models.ImageWatermarkInput`
        """
        return self._ImageTemplate

    @ImageTemplate.setter
    def ImageTemplate(self, ImageTemplate):
        self._ImageTemplate = ImageTemplate

    @property
    def TextTemplate(self):
        r"""文字水印模板，仅当 Type 为 text，该字段必填且有效。
        :rtype: :class:`tencentcloud.mps.v20190612.models.TextWatermarkTemplateInput`
        """
        return self._TextTemplate

    @TextTemplate.setter
    def TextTemplate(self, TextTemplate):
        self._TextTemplate = TextTemplate

    @property
    def SvgTemplate(self):
        r"""SVG 水印模板，仅当 Type 为 svg，该字段必填且有效。
        :rtype: :class:`tencentcloud.mps.v20190612.models.SvgWatermarkInput`
        """
        return self._SvgTemplate

    @SvgTemplate.setter
    def SvgTemplate(self, SvgTemplate):
        self._SvgTemplate = SvgTemplate


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        self._CoordinateOrigin = params.get("CoordinateOrigin")
        self._XPos = params.get("XPos")
        self._YPos = params.get("YPos")
        if params.get("ImageTemplate") is not None:
            self._ImageTemplate = ImageWatermarkInput()
            self._ImageTemplate._deserialize(params.get("ImageTemplate"))
        if params.get("TextTemplate") is not None:
            self._TextTemplate = TextWatermarkTemplateInput()
            self._TextTemplate._deserialize(params.get("TextTemplate"))
        if params.get("SvgTemplate") is not None:
            self._SvgTemplate = SvgWatermarkInput()
            self._SvgTemplate._deserialize(params.get("SvgTemplate"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateWatermarkTemplateResponse(AbstractModel):
    r"""CreateWatermarkTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 水印模板唯一标识。
        :type Definition: int
        :param _ImageUrl: 水印图片地址，仅当 Type 为 image，该字段有效。
        :type ImageUrl: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._ImageUrl = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""水印模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def ImageUrl(self):
        r"""水印图片地址，仅当 Type 为 image，该字段有效。
        :rtype: str
        """
        return self._ImageUrl

    @ImageUrl.setter
    def ImageUrl(self, ImageUrl):
        self._ImageUrl = ImageUrl

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._ImageUrl = params.get("ImageUrl")
        self._RequestId = params.get("RequestId")


class CreateWordSamplesRequest(AbstractModel):
    r"""CreateWordSamples请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Usages: <b>关键词应用场景，可选值：</b>
1. Recognition.Ocr：通过光学字符识别技术，进行内容识别；
2. Recognition.Asr：通过音频识别技术，进行内容识别；
3. Review.Ocr：通过光学字符识别技术，进行不适宜内容识别；
4. Review.Asr：通过音频识别技术，进行不适宜内容识别；
<b>可合并简写为：</b>
5. Recognition：通过光学字符识别技术、音频识别技术，进行内容识别，等价于 1+2；
6. Review：通过光学字符识别技术、音频识别技术，进行不适宜内容识别，等价于 3+4；
7. All：通过光学字符识别技术、音频识别技术，进行内容识别、不适宜内容识别，等价于 1+2+3+4。
        :type Usages: list of str
        :param _Words: 关键词，数组长度限制：100。
        :type Words: list of AiSampleWordInfo
        """
        self._Usages = None
        self._Words = None

    @property
    def Usages(self):
        r"""<b>关键词应用场景，可选值：</b>
1. Recognition.Ocr：通过光学字符识别技术，进行内容识别；
2. Recognition.Asr：通过音频识别技术，进行内容识别；
3. Review.Ocr：通过光学字符识别技术，进行不适宜内容识别；
4. Review.Asr：通过音频识别技术，进行不适宜内容识别；
<b>可合并简写为：</b>
5. Recognition：通过光学字符识别技术、音频识别技术，进行内容识别，等价于 1+2；
6. Review：通过光学字符识别技术、音频识别技术，进行不适宜内容识别，等价于 3+4；
7. All：通过光学字符识别技术、音频识别技术，进行内容识别、不适宜内容识别，等价于 1+2+3+4。
        :rtype: list of str
        """
        return self._Usages

    @Usages.setter
    def Usages(self, Usages):
        self._Usages = Usages

    @property
    def Words(self):
        r"""关键词，数组长度限制：100。
        :rtype: list of AiSampleWordInfo
        """
        return self._Words

    @Words.setter
    def Words(self, Words):
        self._Words = Words


    def _deserialize(self, params):
        self._Usages = params.get("Usages")
        if params.get("Words") is not None:
            self._Words = []
            for item in params.get("Words"):
                obj = AiSampleWordInfo()
                obj._deserialize(item)
                self._Words.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateWordSamplesResponse(AbstractModel):
    r"""CreateWordSamples返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateWorkflowRequest(AbstractModel):
    r"""CreateWorkflow请求参数结构体

    """

    def __init__(self):
        r"""
        :param _WorkflowName: 工作流名称，最多128字符。同一个用户该名称唯一。
        :type WorkflowName: str
        :param _Trigger: 工作流绑定的触发规则，当上传视频命中该规则到该对象时即触发工作流。
        :type Trigger: :class:`tencentcloud.mps.v20190612.models.WorkflowTrigger`
        :param _OutputStorage: 媒体处理的文件输出存储位置。不填则继承 Trigger 中的存储位置。
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _OutputDir: 媒体处理生成的文件输出的目标目录，必选以 / 开头和结尾，如`/movie/201907/`。
如果不填，表示与触发文件所在的目录一致。
        :type OutputDir: str
        :param _MediaProcessTask: 媒体处理类型任务参数。
        :type MediaProcessTask: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskInput`
        :param _AiContentReviewTask: 视频内容审核类型任务参数。
        :type AiContentReviewTask: :class:`tencentcloud.mps.v20190612.models.AiContentReviewTaskInput`
        :param _AiAnalysisTask: 视频内容分析类型任务参数。
        :type AiAnalysisTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskInput`
        :param _AiRecognitionTask: 视频内容识别类型任务参数。
        :type AiRecognitionTask: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskInput`
        :param _TaskNotifyConfig: 任务的事件通知配置，不填代表不获取事件通知。
        :type TaskNotifyConfig: :class:`tencentcloud.mps.v20190612.models.TaskNotifyConfig`
        :param _TaskPriority: 工作流的优先级，数值越大优先级越高，取值范围是 -10 到 10，不填代表 0。
        :type TaskPriority: int
        """
        self._WorkflowName = None
        self._Trigger = None
        self._OutputStorage = None
        self._OutputDir = None
        self._MediaProcessTask = None
        self._AiContentReviewTask = None
        self._AiAnalysisTask = None
        self._AiRecognitionTask = None
        self._TaskNotifyConfig = None
        self._TaskPriority = None

    @property
    def WorkflowName(self):
        r"""工作流名称，最多128字符。同一个用户该名称唯一。
        :rtype: str
        """
        return self._WorkflowName

    @WorkflowName.setter
    def WorkflowName(self, WorkflowName):
        self._WorkflowName = WorkflowName

    @property
    def Trigger(self):
        r"""工作流绑定的触发规则，当上传视频命中该规则到该对象时即触发工作流。
        :rtype: :class:`tencentcloud.mps.v20190612.models.WorkflowTrigger`
        """
        return self._Trigger

    @Trigger.setter
    def Trigger(self, Trigger):
        self._Trigger = Trigger

    @property
    def OutputStorage(self):
        r"""媒体处理的文件输出存储位置。不填则继承 Trigger 中的存储位置。
        :rtype: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage

    @property
    def OutputDir(self):
        r"""媒体处理生成的文件输出的目标目录，必选以 / 开头和结尾，如`/movie/201907/`。
如果不填，表示与触发文件所在的目录一致。
        :rtype: str
        """
        return self._OutputDir

    @OutputDir.setter
    def OutputDir(self, OutputDir):
        self._OutputDir = OutputDir

    @property
    def MediaProcessTask(self):
        r"""媒体处理类型任务参数。
        :rtype: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskInput`
        """
        return self._MediaProcessTask

    @MediaProcessTask.setter
    def MediaProcessTask(self, MediaProcessTask):
        self._MediaProcessTask = MediaProcessTask

    @property
    def AiContentReviewTask(self):
        r"""视频内容审核类型任务参数。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiContentReviewTaskInput`
        """
        return self._AiContentReviewTask

    @AiContentReviewTask.setter
    def AiContentReviewTask(self, AiContentReviewTask):
        self._AiContentReviewTask = AiContentReviewTask

    @property
    def AiAnalysisTask(self):
        r"""视频内容分析类型任务参数。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskInput`
        """
        return self._AiAnalysisTask

    @AiAnalysisTask.setter
    def AiAnalysisTask(self, AiAnalysisTask):
        self._AiAnalysisTask = AiAnalysisTask

    @property
    def AiRecognitionTask(self):
        r"""视频内容识别类型任务参数。
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskInput`
        """
        return self._AiRecognitionTask

    @AiRecognitionTask.setter
    def AiRecognitionTask(self, AiRecognitionTask):
        self._AiRecognitionTask = AiRecognitionTask

    @property
    def TaskNotifyConfig(self):
        r"""任务的事件通知配置，不填代表不获取事件通知。
        :rtype: :class:`tencentcloud.mps.v20190612.models.TaskNotifyConfig`
        """
        return self._TaskNotifyConfig

    @TaskNotifyConfig.setter
    def TaskNotifyConfig(self, TaskNotifyConfig):
        self._TaskNotifyConfig = TaskNotifyConfig

    @property
    def TaskPriority(self):
        r"""工作流的优先级，数值越大优先级越高，取值范围是 -10 到 10，不填代表 0。
        :rtype: int
        """
        return self._TaskPriority

    @TaskPriority.setter
    def TaskPriority(self, TaskPriority):
        self._TaskPriority = TaskPriority


    def _deserialize(self, params):
        self._WorkflowName = params.get("WorkflowName")
        if params.get("Trigger") is not None:
            self._Trigger = WorkflowTrigger()
            self._Trigger._deserialize(params.get("Trigger"))
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        self._OutputDir = params.get("OutputDir")
        if params.get("MediaProcessTask") is not None:
            self._MediaProcessTask = MediaProcessTaskInput()
            self._MediaProcessTask._deserialize(params.get("MediaProcessTask"))
        if params.get("AiContentReviewTask") is not None:
            self._AiContentReviewTask = AiContentReviewTaskInput()
            self._AiContentReviewTask._deserialize(params.get("AiContentReviewTask"))
        if params.get("AiAnalysisTask") is not None:
            self._AiAnalysisTask = AiAnalysisTaskInput()
            self._AiAnalysisTask._deserialize(params.get("AiAnalysisTask"))
        if params.get("AiRecognitionTask") is not None:
            self._AiRecognitionTask = AiRecognitionTaskInput()
            self._AiRecognitionTask._deserialize(params.get("AiRecognitionTask"))
        if params.get("TaskNotifyConfig") is not None:
            self._TaskNotifyConfig = TaskNotifyConfig()
            self._TaskNotifyConfig._deserialize(params.get("TaskNotifyConfig"))
        self._TaskPriority = params.get("TaskPriority")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateWorkflowResponse(AbstractModel):
    r"""CreateWorkflow返回参数结构体

    """

    def __init__(self):
        r"""
        :param _WorkflowId: 工作流 ID。
        :type WorkflowId: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._WorkflowId = None
        self._RequestId = None

    @property
    def WorkflowId(self):
        r"""工作流 ID。
        :rtype: int
        """
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._WorkflowId = params.get("WorkflowId")
        self._RequestId = params.get("RequestId")


class DeleteAIAnalysisTemplateRequest(AbstractModel):
    r"""DeleteAIAnalysisTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 视频内容分析模板唯一标识。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""视频内容分析模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAIAnalysisTemplateResponse(AbstractModel):
    r"""DeleteAIAnalysisTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteAIRecognitionTemplateRequest(AbstractModel):
    r"""DeleteAIRecognitionTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 视频内容识别模板唯一标识。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""视频内容识别模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAIRecognitionTemplateResponse(AbstractModel):
    r"""DeleteAIRecognitionTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteAdaptiveDynamicStreamingTemplateRequest(AbstractModel):
    r"""DeleteAdaptiveDynamicStreamingTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 自适应转码模板唯一标识。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""自适应转码模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAdaptiveDynamicStreamingTemplateResponse(AbstractModel):
    r"""DeleteAdaptiveDynamicStreamingTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteAnimatedGraphicsTemplateRequest(AbstractModel):
    r"""DeleteAnimatedGraphicsTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 转动图模板唯一标识。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""转动图模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAnimatedGraphicsTemplateResponse(AbstractModel):
    r"""DeleteAnimatedGraphicsTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteAsrHotwordsRequest(AbstractModel):
    r"""DeleteAsrHotwords请求参数结构体

    """

    def __init__(self):
        r"""
        :param _HotwordsId: 删除的热词库 id
        :type HotwordsId: str
        """
        self._HotwordsId = None

    @property
    def HotwordsId(self):
        r"""删除的热词库 id
        :rtype: str
        """
        return self._HotwordsId

    @HotwordsId.setter
    def HotwordsId(self, HotwordsId):
        self._HotwordsId = HotwordsId


    def _deserialize(self, params):
        self._HotwordsId = params.get("HotwordsId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAsrHotwordsResponse(AbstractModel):
    r"""DeleteAsrHotwords返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteBlindWatermarkTemplateRequest(AbstractModel):
    r"""DeleteBlindWatermarkTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 数字水印模板唯一标识。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""数字水印模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteBlindWatermarkTemplateResponse(AbstractModel):
    r"""DeleteBlindWatermarkTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteContentReviewTemplateRequest(AbstractModel):
    r"""DeleteContentReviewTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 内容审核模板唯一标识。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""内容审核模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteContentReviewTemplateResponse(AbstractModel):
    r"""DeleteContentReviewTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteImageSpriteTemplateRequest(AbstractModel):
    r"""DeleteImageSpriteTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 雪碧图模板唯一标识。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""雪碧图模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteImageSpriteTemplateResponse(AbstractModel):
    r"""DeleteImageSpriteTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteLiveRecordTemplateRequest(AbstractModel):
    r"""DeleteLiveRecordTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 录制模板唯一标识。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""录制模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteLiveRecordTemplateResponse(AbstractModel):
    r"""DeleteLiveRecordTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeletePersonSampleRequest(AbstractModel):
    r"""DeletePersonSample请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PersonId: 素材 ID。
        :type PersonId: str
        """
        self._PersonId = None

    @property
    def PersonId(self):
        r"""素材 ID。
        :rtype: str
        """
        return self._PersonId

    @PersonId.setter
    def PersonId(self, PersonId):
        self._PersonId = PersonId


    def _deserialize(self, params):
        self._PersonId = params.get("PersonId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeletePersonSampleResponse(AbstractModel):
    r"""DeletePersonSample返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteProcessImageTemplateRequest(AbstractModel):
    r"""DeleteProcessImageTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 图片处理模板唯一标识。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""图片处理模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteProcessImageTemplateResponse(AbstractModel):
    r"""DeleteProcessImageTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteQualityControlTemplateRequest(AbstractModel):
    r"""DeleteQualityControlTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 媒体质检模板唯一标识。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""媒体质检模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteQualityControlTemplateResponse(AbstractModel):
    r"""DeleteQualityControlTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteSampleSnapshotTemplateRequest(AbstractModel):
    r"""DeleteSampleSnapshotTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 采样截图模板唯一标识。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""采样截图模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSampleSnapshotTemplateResponse(AbstractModel):
    r"""DeleteSampleSnapshotTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteScheduleRequest(AbstractModel):
    r"""DeleteSchedule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ScheduleId: 编排唯一标识。
        :type ScheduleId: int
        """
        self._ScheduleId = None

    @property
    def ScheduleId(self):
        r"""编排唯一标识。
        :rtype: int
        """
        return self._ScheduleId

    @ScheduleId.setter
    def ScheduleId(self, ScheduleId):
        self._ScheduleId = ScheduleId


    def _deserialize(self, params):
        self._ScheduleId = params.get("ScheduleId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteScheduleResponse(AbstractModel):
    r"""DeleteSchedule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteSmartEraseTemplateRequest(AbstractModel):
    r"""DeleteSmartEraseTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 智能擦除模板唯一标识。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""智能擦除模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSmartEraseTemplateResponse(AbstractModel):
    r"""DeleteSmartEraseTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteSmartSubtitleTemplateRequest(AbstractModel):
    r"""DeleteSmartSubtitleTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 智能字幕模板唯一标识。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""智能字幕模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSmartSubtitleTemplateResponse(AbstractModel):
    r"""DeleteSmartSubtitleTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteSnapshotByTimeOffsetTemplateRequest(AbstractModel):
    r"""DeleteSnapshotByTimeOffsetTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 指定时间点截图模板唯一标识。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""指定时间点截图模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSnapshotByTimeOffsetTemplateResponse(AbstractModel):
    r"""DeleteSnapshotByTimeOffsetTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteStreamLinkEventRequest(AbstractModel):
    r"""DeleteStreamLinkEvent请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EventId: 媒体传输事件Id，删除前需要保证该Event关联的所有Flow都已经删除。
        :type EventId: str
        """
        self._EventId = None

    @property
    def EventId(self):
        r"""媒体传输事件Id，删除前需要保证该Event关联的所有Flow都已经删除。
        :rtype: str
        """
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId


    def _deserialize(self, params):
        self._EventId = params.get("EventId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteStreamLinkEventResponse(AbstractModel):
    r"""DeleteStreamLinkEvent返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteStreamLinkFlowRequest(AbstractModel):
    r"""DeleteStreamLinkFlow请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FlowId: 传输流Id。
        :type FlowId: str
        """
        self._FlowId = None

    @property
    def FlowId(self):
        r"""传输流Id。
        :rtype: str
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteStreamLinkFlowResponse(AbstractModel):
    r"""DeleteStreamLinkFlow返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteStreamLinkOutputRequest(AbstractModel):
    r"""DeleteStreamLinkOutput请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FlowId: 流Id。
        :type FlowId: str
        :param _OutputId: 输出Id。
        :type OutputId: str
        """
        self._FlowId = None
        self._OutputId = None

    @property
    def FlowId(self):
        r"""流Id。
        :rtype: str
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def OutputId(self):
        r"""输出Id。
        :rtype: str
        """
        return self._OutputId

    @OutputId.setter
    def OutputId(self, OutputId):
        self._OutputId = OutputId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._OutputId = params.get("OutputId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteStreamLinkOutputResponse(AbstractModel):
    r"""DeleteStreamLinkOutput返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteStreamLinkSecurityGroupRequest(AbstractModel):
    r"""DeleteStreamLinkSecurityGroup请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 安全组 ID。
        :type Id: str
        """
        self._Id = None

    @property
    def Id(self):
        r"""安全组 ID。
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteStreamLinkSecurityGroupResponse(AbstractModel):
    r"""DeleteStreamLinkSecurityGroup返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteTranscodeTemplateRequest(AbstractModel):
    r"""DeleteTranscodeTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 转码模板唯一标识。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""转码模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteTranscodeTemplateResponse(AbstractModel):
    r"""DeleteTranscodeTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteWatermarkTemplateRequest(AbstractModel):
    r"""DeleteWatermarkTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 水印模板唯一标识。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""水印模板唯一标识。
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteWatermarkTemplateResponse(AbstractModel):
    r"""DeleteWatermarkTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteWordSamplesRequest(AbstractModel):
    r"""DeleteWordSamples请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Keywords: 关键词，数组长度限制：100 个词。
        :type Keywords: list of str
        """
        self._Keywords = None

    @property
    def Keywords(self):
        r"""关键词，数组长度限制：100 个词。
        :rtype: list of str
        """
        return self._Keywords

    @Keywords.setter
    def Keywords(self, Keywords):
        self._Keywords = Keywords


    def _deserialize(self, params):
        self._Keywords = params.get("Keywords")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteWordSamplesResponse(AbstractModel):
    r"""DeleteWordSamples返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteWorkflowRequest(AbstractModel):
    r"""DeleteWorkflow请求参数结构体

    """

    def __init__(self):
        r"""
        :param _WorkflowId: 工作流 ID。
        :type WorkflowId: int
        """
        self._WorkflowId = None

    @property
    def WorkflowId(self):
        r"""工作流 ID。
        :rtype: int
        """
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId


    def _deserialize(self, params):
        self._WorkflowId = params.get("WorkflowId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteWorkflowResponse(AbstractModel):
    r"""DeleteWorkflow返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DescribeAIAnalysisTemplatesRequest(AbstractModel):
    r"""DescribeAIAnalysisTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definitions: 视频内容分析模板唯一标识过滤条件，数组长度限制：100。
        :type Definitions: list of int
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        :param _Type: 模板类型过滤条件，不填则返回所有，可选值：
* Preset：系统预置模板；
* Custom：用户自定义模板。
        :type Type: str
        :param _Name: 视频内容分析模板标识过滤条件，长度限制：64 个字符。
        :type Name: str
        """
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None
        self._Name = None

    @property
    def Definitions(self):
        r"""视频内容分析模板唯一标识过滤条件，数组长度限制：100。
        :rtype: list of int
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        r"""分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        r"""模板类型过滤条件，不填则返回所有，可选值：
* Preset：系统预置模板；
* Custom：用户自定义模板。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        r"""视频内容分析模板标识过滤条件，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAIAnalysisTemplatesResponse(AbstractModel):
    r"""DescribeAIAnalysisTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _AIAnalysisTemplateSet: 视频内容分析模板详情列表。
        :type AIAnalysisTemplateSet: list of AIAnalysisTemplateItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._AIAnalysisTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AIAnalysisTemplateSet(self):
        r"""视频内容分析模板详情列表。
        :rtype: list of AIAnalysisTemplateItem
        """
        return self._AIAnalysisTemplateSet

    @AIAnalysisTemplateSet.setter
    def AIAnalysisTemplateSet(self, AIAnalysisTemplateSet):
        self._AIAnalysisTemplateSet = AIAnalysisTemplateSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AIAnalysisTemplateSet") is not None:
            self._AIAnalysisTemplateSet = []
            for item in params.get("AIAnalysisTemplateSet"):
                obj = AIAnalysisTemplateItem()
                obj._deserialize(item)
                self._AIAnalysisTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAIRecognitionTemplatesRequest(AbstractModel):
    r"""DescribeAIRecognitionTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definitions: 视频内容识别模板唯一标识过滤条件，数组长度限制：100。
        :type Definitions: list of int
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：50。
        :type Limit: int
        :param _Type: 模板类型过滤条件，不填则返回所有，可选值：
* Preset：系统预置模板；
* Custom：用户自定义模板。
        :type Type: str
        :param _Name: 视频内容识别模板标识过滤条件，长度限制：64 个字符。
        :type Name: str
        """
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None
        self._Name = None

    @property
    def Definitions(self):
        r"""视频内容识别模板唯一标识过滤条件，数组长度限制：100。
        :rtype: list of int
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        r"""分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回记录条数，默认值：10，最大值：50。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        r"""模板类型过滤条件，不填则返回所有，可选值：
* Preset：系统预置模板；
* Custom：用户自定义模板。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        r"""视频内容识别模板标识过滤条件，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAIRecognitionTemplatesResponse(AbstractModel):
    r"""DescribeAIRecognitionTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _AIRecognitionTemplateSet: 视频内容识别模板详情列表。
        :type AIRecognitionTemplateSet: list of AIRecognitionTemplateItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._AIRecognitionTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AIRecognitionTemplateSet(self):
        r"""视频内容识别模板详情列表。
        :rtype: list of AIRecognitionTemplateItem
        """
        return self._AIRecognitionTemplateSet

    @AIRecognitionTemplateSet.setter
    def AIRecognitionTemplateSet(self, AIRecognitionTemplateSet):
        self._AIRecognitionTemplateSet = AIRecognitionTemplateSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AIRecognitionTemplateSet") is not None:
            self._AIRecognitionTemplateSet = []
            for item in params.get("AIRecognitionTemplateSet"):
                obj = AIRecognitionTemplateItem()
                obj._deserialize(item)
                self._AIRecognitionTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAdaptiveDynamicStreamingTemplatesRequest(AbstractModel):
    r"""DescribeAdaptiveDynamicStreamingTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definitions: 转自适应码流模板唯一标识过滤条件，数组长度限制：100。
        :type Definitions: list of int non-negative
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        :param _Type: 模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :type Type: str
        :param _PureAudio: 是否为纯音频，0表示视频，1表示纯音频
默认值：0
        :type PureAudio: int
        :param _Name: 自适应转码模板标识过滤条件，长度限制：64 个字符
        :type Name: str
        """
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None
        self._PureAudio = None
        self._Name = None

    @property
    def Definitions(self):
        r"""转自适应码流模板唯一标识过滤条件，数组长度限制：100。
        :rtype: list of int non-negative
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        r"""分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        r"""模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def PureAudio(self):
        r"""是否为纯音频，0表示视频，1表示纯音频
默认值：0
        :rtype: int
        """
        return self._PureAudio

    @PureAudio.setter
    def PureAudio(self, PureAudio):
        self._PureAudio = PureAudio

    @property
    def Name(self):
        r"""自适应转码模板标识过滤条件，长度限制：64 个字符
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        self._PureAudio = params.get("PureAudio")
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAdaptiveDynamicStreamingTemplatesResponse(AbstractModel):
    r"""DescribeAdaptiveDynamicStreamingTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _AdaptiveDynamicStreamingTemplateSet: 转自适应码流模板详情列表。
        :type AdaptiveDynamicStreamingTemplateSet: list of AdaptiveDynamicStreamingTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._AdaptiveDynamicStreamingTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AdaptiveDynamicStreamingTemplateSet(self):
        r"""转自适应码流模板详情列表。
        :rtype: list of AdaptiveDynamicStreamingTemplate
        """
        return self._AdaptiveDynamicStreamingTemplateSet

    @AdaptiveDynamicStreamingTemplateSet.setter
    def AdaptiveDynamicStreamingTemplateSet(self, AdaptiveDynamicStreamingTemplateSet):
        self._AdaptiveDynamicStreamingTemplateSet = AdaptiveDynamicStreamingTemplateSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AdaptiveDynamicStreamingTemplateSet") is not None:
            self._AdaptiveDynamicStreamingTemplateSet = []
            for item in params.get("AdaptiveDynamicStreamingTemplateSet"):
                obj = AdaptiveDynamicStreamingTemplate()
                obj._deserialize(item)
                self._AdaptiveDynamicStreamingTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAigcImageTaskRequest(AbstractModel):
    r"""DescribeAigcImageTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 创建的AIGC生图片任务ID。
        :type TaskId: str
        """
        self._TaskId = None

    @property
    def TaskId(self):
        r"""创建的AIGC生图片任务ID。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAigcImageTaskResponse(AbstractModel):
    r"""DescribeAigcImageTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Status: 任务当前状态。 WAIT：等待中， RUN：执行中， FAIL：任务失败， DONE：任务成功。
        :type Status: str
        :param _ImageUrls: 当任务状态为 DONE时，返回的图片Url列表，图片存储12小时，请尽快取走使用。
        :type ImageUrls: list of str
        :param _Message: 当任务状态为 FAIL时，返回失败信息。
        :type Message: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Status = None
        self._ImageUrls = None
        self._Message = None
        self._RequestId = None

    @property
    def Status(self):
        r"""任务当前状态。 WAIT：等待中， RUN：执行中， FAIL：任务失败， DONE：任务成功。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ImageUrls(self):
        r"""当任务状态为 DONE时，返回的图片Url列表，图片存储12小时，请尽快取走使用。
        :rtype: list of str
        """
        return self._ImageUrls

    @ImageUrls.setter
    def ImageUrls(self, ImageUrls):
        self._ImageUrls = ImageUrls

    @property
    def Message(self):
        r"""当任务状态为 FAIL时，返回失败信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ImageUrls = params.get("ImageUrls")
        self._Message = params.get("Message")
        self._RequestId = params.get("RequestId")


class DescribeAigcVideoTaskRequest(AbstractModel):
    r"""DescribeAigcVideoTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 创建AIGC生视频任务时，返回的任务ID。
        :type TaskId: str
        """
        self._TaskId = None

    @property
    def TaskId(self):
        r"""创建AIGC生视频任务时，返回的任务ID。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAigcVideoTaskResponse(AbstractModel):
    r"""DescribeAigcVideoTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Status: 任务当前状态。 WAIT：等待中， RUN：执行中， FAIL：任务失败， DONE：任务成功。
        :type Status: str
        :param _VideoUrls: 当任务状态为 DONE时，返回视频Url列表，视频存储12小时，请尽快取走使用。
        :type VideoUrls: list of str
        :param _Resolution: 输出视频的分辨率。示例：1080*720；
        :type Resolution: str
        :param _Message: 当任务状态为 FAIL时，返回失败信息。
        :type Message: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Status = None
        self._VideoUrls = None
        self._Resolution = None
        self._Message = None
        self._RequestId = None

    @property
    def Status(self):
        r"""任务当前状态。 WAIT：等待中， RUN：执行中， FAIL：任务失败， DONE：任务成功。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def VideoUrls(self):
        r"""当任务状态为 DONE时，返回视频Url列表，视频存储12小时，请尽快取走使用。
        :rtype: list of str
        """
        return self._VideoUrls

    @VideoUrls.setter
    def VideoUrls(self, VideoUrls):
        self._VideoUrls = VideoUrls

    @property
    def Resolution(self):
        r"""输出视频的分辨率。示例：1080*720；
        :rtype: str
        """
        return self._Resolution

    @Resolution.setter
    def Resolution(self, Resolution):
        self._Resolution = Resolution

    @property
    def Message(self):
        r"""当任务状态为 FAIL时，返回失败信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._VideoUrls = params.get("VideoUrls")
        self._Resolution = params.get("Resolution")
        self._Message = params.get("Message")
        self._RequestId = params.get("RequestId")


class DescribeAnimatedGraphicsTemplatesRequest(AbstractModel):
    r"""DescribeAnimatedGraphicsTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definitions: 转动图模板唯一标识过滤条件，数组长度限制：100。
        :type Definitions: list of int non-negative
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        :param _Type: 模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :type Type: str
        :param _Name: 转动图模板标识过滤条件，长度限制：64 个字符。
        :type Name: str
        """
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None
        self._Name = None

    @property
    def Definitions(self):
        r"""转动图模板唯一标识过滤条件，数组长度限制：100。
        :rtype: list of int non-negative
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        r"""分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        r"""模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        r"""转动图模板标识过滤条件，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAnimatedGraphicsTemplatesResponse(AbstractModel):
    r"""DescribeAnimatedGraphicsTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _AnimatedGraphicsTemplateSet: 转动图模板详情列表。
        :type AnimatedGraphicsTemplateSet: list of AnimatedGraphicsTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._AnimatedGraphicsTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AnimatedGraphicsTemplateSet(self):
        r"""转动图模板详情列表。
        :rtype: list of AnimatedGraphicsTemplate
        """
        return self._AnimatedGraphicsTemplateSet

    @AnimatedGraphicsTemplateSet.setter
    def AnimatedGraphicsTemplateSet(self, AnimatedGraphicsTemplateSet):
        self._AnimatedGraphicsTemplateSet = AnimatedGraphicsTemplateSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AnimatedGraphicsTemplateSet") is not None:
            self._AnimatedGraphicsTemplateSet = []
            for item in params.get("AnimatedGraphicsTemplateSet"):
                obj = AnimatedGraphicsTemplate()
                obj._deserialize(item)
                self._AnimatedGraphicsTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAsrHotwordsListRequest(AbstractModel):
    r"""DescribeAsrHotwordsList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _HotwordsId: 检索参数，根据热词库 id 查询
        :type HotwordsId: str
        :param _Name: 检索参数，根据热词库名称查询
        :type Name: str
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认返回所有热词库
        :type Limit: int
        :param _OrderType: 热词排序顺序

0：升序（默认）
1：降序
        :type OrderType: int
        :param _OrderBy: 根据某个字段排序，默认使用创建时间，使用非法字段视为默认情况

- CreateTime：创建时间排序
- UpdateTime：更新时间排序
- Name：热词库名称排序
- WordCount：热词数量排序
- HotwordsId：热词库 id 排序
        :type OrderBy: str
        :param _Types: 0 临时热词 1 文件热词
        :type Types: list of int non-negative
        """
        self._HotwordsId = None
        self._Name = None
        self._Offset = None
        self._Limit = None
        self._OrderType = None
        self._OrderBy = None
        self._Types = None

    @property
    def HotwordsId(self):
        r"""检索参数，根据热词库 id 查询
        :rtype: str
        """
        return self._HotwordsId

    @HotwordsId.setter
    def HotwordsId(self, HotwordsId):
        self._HotwordsId = HotwordsId

    @property
    def Name(self):
        r"""检索参数，根据热词库名称查询
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Offset(self):
        r"""分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回记录条数，默认返回所有热词库
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def OrderType(self):
        r"""热词排序顺序

0：升序（默认）
1：降序
        :rtype: int
        """
        return self._OrderType

    @OrderType.setter
    def OrderType(self, OrderType):
        self._OrderType = OrderType

    @property
    def OrderBy(self):
        r"""根据某个字段排序，默认使用创建时间，使用非法字段视为默认情况

- CreateTime：创建时间排序
- UpdateTime：更新时间排序
- Name：热词库名称排序
- WordCount：热词数量排序
- HotwordsId：热词库 id 排序
        :rtype: str
        """
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy

    @property
    def Types(self):
        r"""0 临时热词 1 文件热词
        :rtype: list of int non-negative
        """
        return self._Types

    @Types.setter
    def Types(self, Types):
        self._Types = Types


    def _deserialize(self, params):
        self._HotwordsId = params.get("HotwordsId")
        self._Name = params.get("Name")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._OrderType = params.get("OrderType")
        self._OrderBy = params.get("OrderBy")
        self._Types = params.get("Types")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAsrHotwordsListResponse(AbstractModel):
    r"""DescribeAsrHotwordsList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总热词库数量
        :type TotalCount: int
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认返回所有热词库
        :type Limit: int
        :param _AsrHotwordsSet: 热词库列表
        :type AsrHotwordsSet: list of AsrHotwordsSet
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._Offset = None
        self._Limit = None
        self._AsrHotwordsSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""总热词库数量
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Offset(self):
        r"""分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回记录条数，默认返回所有热词库
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def AsrHotwordsSet(self):
        r"""热词库列表
        :rtype: list of AsrHotwordsSet
        """
        return self._AsrHotwordsSet

    @AsrHotwordsSet.setter
    def AsrHotwordsSet(self, AsrHotwordsSet):
        self._AsrHotwordsSet = AsrHotwordsSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("AsrHotwordsSet") is not None:
            self._AsrHotwordsSet = []
            for item in params.get("AsrHotwordsSet"):
                obj = AsrHotwordsSet()
                obj._deserialize(item)
                self._AsrHotwordsSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAsrHotwordsRequest(AbstractModel):
    r"""DescribeAsrHotwords请求参数结构体

    """

    def __init__(self):
        r"""
        :param _HotwordsId: 需要查询的热词库 id
**注意：HotwordsId 与 Name 必须选择填写一个，如果同时填写，HotwordsId 优先级高于 Name**
        :type HotwordsId: str
        :param _Name: 热词库名称，
**注意：HotwordsId 与 Name 必须选择填写一个，如果同时填写，HotwordsId 优先级高于 Name**
        :type Name: str
        :param _Offset: 分页偏移量，默认值：0。

        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        :param _OrderBy: 热词排序字段，目前可选值为

- Default：默认文件中的顺序
- Weight：权重排序
- Lexical：热词文本排序
        :type OrderBy: str
        :param _OrderType: 热词排序顺序 0：升序（默认） 1：降序
        :type OrderType: int
        """
        self._HotwordsId = None
        self._Name = None
        self._Offset = None
        self._Limit = None
        self._OrderBy = None
        self._OrderType = None

    @property
    def HotwordsId(self):
        r"""需要查询的热词库 id
**注意：HotwordsId 与 Name 必须选择填写一个，如果同时填写，HotwordsId 优先级高于 Name**
        :rtype: str
        """
        return self._HotwordsId

    @HotwordsId.setter
    def HotwordsId(self, HotwordsId):
        self._HotwordsId = HotwordsId

    @property
    def Name(self):
        r"""热词库名称，
**注意：HotwordsId 与 Name 必须选择填写一个，如果同时填写，HotwordsId 优先级高于 Name**
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Offset(self):
        r"""分页偏移量，默认值：0。

        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def OrderBy(self):
        r"""热词排序字段，目前可选值为

- Default：默认文件中的顺序
- Weight：权重排序
- Lexical：热词文本排序
        :rtype: str
        """
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy

    @property
    def OrderType(self):
        r"""热词排序顺序 0：升序（默认） 1：降序
        :rtype: int
        """
        return self._OrderType

    @OrderType.setter
    def OrderType(self, OrderType):
        self._OrderType = OrderType


    def _deserialize(self, params):
        self._HotwordsId = params.get("HotwordsId")
        self._Name = params.get("Name")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._OrderBy = params.get("OrderBy")
        self._OrderType = params.get("OrderType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAsrHotwordsResponse(AbstractModel):
    r"""DescribeAsrHotwords返回参数结构体

    """

    def __init__(self):
        r"""
        :param _HotwordsId: 需要查询的热词库 id
        :type HotwordsId: str
        :param _Status: 当前热词库 id 状态，为 0 表示查询的时刻，没有模板绑定这个热词库，可以删除
        :type Status: int
        :param _Name: 热词库的名称
        :type Name: str
        :param _Type: 临时热词库为 0，返回创建时候的字符串
文件热词库为 1，返回创建是上传的文件内容


        :type Type: int
        :param _FileName: 热词文件上传时的文件名
        :type FileName: str
        :param _HotWords: 查询返回的热词库列表
        :type HotWords: list of AsrHotwordsSetItem
        :param _Content: 热词库文本，根据 Type 区分
如果 Type 为 0，是热词库字符串
如果 Type 是 1，是热词库文本文件的文件内容 base64 编码
        :type Content: str
        :param _WordCount: 当前热词库包含的词语数量
        :type WordCount: int
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        :param _CreateTime: 热词库创建时间 ISOUTC 格式 "2006-01-02T15:04:05Z"
        :type CreateTime: str
        :param _UpdateTime: 热词库修改时间 ISOUTC 格式 "2006-01-02T15:04:05Z"
        :type UpdateTime: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._HotwordsId = None
        self._Status = None
        self._Name = None
        self._Type = None
        self._FileName = None
        self._HotWords = None
        self._Content = None
        self._WordCount = None
        self._Offset = None
        self._Limit = None
        self._CreateTime = None
        self._UpdateTime = None
        self._RequestId = None

    @property
    def HotwordsId(self):
        r"""需要查询的热词库 id
        :rtype: str
        """
        return self._HotwordsId

    @HotwordsId.setter
    def HotwordsId(self, HotwordsId):
        self._HotwordsId = HotwordsId

    @property
    def Status(self):
        r"""当前热词库 id 状态，为 0 表示查询的时刻，没有模板绑定这个热词库，可以删除
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Name(self):
        r"""热词库的名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Type(self):
        r"""临时热词库为 0，返回创建时候的字符串
文件热词库为 1，返回创建是上传的文件内容


        :rtype: int
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def FileName(self):
        r"""热词文件上传时的文件名
        :rtype: str
        """
        return self._FileName

    @FileName.setter
    def FileName(self, FileName):
        self._FileName = FileName

    @property
    def HotWords(self):
        r"""查询返回的热词库列表
        :rtype: list of AsrHotwordsSetItem
        """
        return self._HotWords

    @HotWords.setter
    def HotWords(self, HotWords):
        self._HotWords = HotWords

    @property
    def Content(self):
        r"""热词库文本，根据 Type 区分
如果 Type 为 0，是热词库字符串
如果 Type 是 1，是热词库文本文件的文件内容 base64 编码
        :rtype: str
        """
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content

    @property
    def WordCount(self):
        r"""当前热词库包含的词语数量
        :rtype: int
        """
        return self._WordCount

    @WordCount.setter
    def WordCount(self, WordCount):
        self._WordCount = WordCount

    @property
    def Offset(self):
        r"""分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def CreateTime(self):
        r"""热词库创建时间 ISOUTC 格式 "2006-01-02T15:04:05Z"
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""热词库修改时间 ISOUTC 格式 "2006-01-02T15:04:05Z"
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._HotwordsId = params.get("HotwordsId")
        self._Status = params.get("Status")
        self._Name = params.get("Name")
        self._Type = params.get("Type")
        self._FileName = params.get("FileName")
        if params.get("HotWords") is not None:
            self._HotWords = []
            for item in params.get("HotWords"):
                obj = AsrHotwordsSetItem()
                obj._deserialize(item)
                self._HotWords.append(obj)
        self._Content = params.get("Content")
        self._WordCount = params.get("WordCount")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._RequestId = params.get("RequestId")


class DescribeBatchTaskDetailRequest(AbstractModel):
    r"""DescribeBatchTaskDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 视频处理任务的任务 ID。
        :type TaskId: str
        """
        self._TaskId = None

    @property
    def TaskId(self):
        r"""视频处理任务的任务 ID。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBatchTaskDetailResponse(AbstractModel):
    r"""DescribeBatchTaskDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskType: 任务类型，目前取值有：
<li>BatchTask：视频工作流批量处理任务。</li>
        :type TaskType: str
        :param _Status: 任务状态，取值：
<li>WAITING：等待中；</li>
<li>PROCESSING：处理中；</li>
<li>FINISH：已完成。</li>
        :type Status: str
        :param _CreateTime: 任务的创建时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :type CreateTime: str
        :param _BeginProcessTime: 任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :type BeginProcessTime: str
        :param _FinishTime: 任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :type FinishTime: str
        :param _TaskId: 媒体处理任务 ID。
        :type TaskId: str
        :param _BatchTaskResult: 视频处理任务信息，仅当 TaskType 为 BatchTask，该字段有值。
        :type BatchTaskResult: :class:`tencentcloud.mps.v20190612.models.BatchSubTaskResult`
        :param _TaskNotifyConfig: 任务的事件通知信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskNotifyConfig: :class:`tencentcloud.mps.v20190612.models.TaskNotifyConfig`
        :param _TasksPriority: 任务流的优先级，取值范围为 [-10, 10]。
        :type TasksPriority: int
        :param _SessionId: 用于去重的识别码，如果七天内曾有过相同的识别码的请求，则本次的请求会返回错误。最长50个字符，不带或者带空字符串表示不做去重。
        :type SessionId: str
        :param _SessionContext: 来源上下文，用于透传用户请求信息，任务流状态变更回调将返回该字段值，最长1000个字符。
        :type SessionContext: str
        :param _ExtInfo: 扩展信息字段，仅用于特定场景。
        :type ExtInfo: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskType = None
        self._Status = None
        self._CreateTime = None
        self._BeginProcessTime = None
        self._FinishTime = None
        self._TaskId = None
        self._BatchTaskResult = None
        self._TaskNotifyConfig = None
        self._TasksPriority = None
        self._SessionId = None
        self._SessionContext = None
        self._ExtInfo = None
        self._RequestId = None

    @property
    def TaskType(self):
        r"""任务类型，目前取值有：
<li>BatchTask：视频工作流批量处理任务。</li>
        :rtype: str
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def Status(self):
        r"""任务状态，取值：
<li>WAITING：等待中；</li>
<li>PROCESSING：处理中；</li>
<li>FINISH：已完成。</li>
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def CreateTime(self):
        r"""任务的创建时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def BeginProcessTime(self):
        r"""任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :rtype: str
        """
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        r"""任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :rtype: str
        """
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime

    @property
    def TaskId(self):
        r"""媒体处理任务 ID。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def BatchTaskResult(self):
        r"""视频处理任务信息，仅当 TaskType 为 BatchTask，该字段有值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.BatchSubTaskResult`
        """
        return self._BatchTaskResult

    @BatchTaskResult.setter
    def BatchTaskResult(self, BatchTaskResult):
        self._BatchTaskResult = BatchTaskResult

    @property
    def TaskNotifyConfig(self):
        r"""任务的事件通知信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.TaskNotifyConfig`
        """
        return self._TaskNotifyConfig

    @TaskNotifyConfig.setter
    def TaskNotifyConfig(self, TaskNotifyConfig):
        self._TaskNotifyConfig = TaskNotifyConfig

    @property
    def TasksPriority(self):
        r"""任务流的优先级，取值范围为 [-10, 10]。
        :rtype: int
        """
        return self._TasksPriority

    @TasksPriority.setter
    def TasksPriority(self, TasksPriority):
        self._TasksPriority = TasksPriority

    @property
    def SessionId(self):
        r"""用于去重的识别码，如果七天内曾有过相同的识别码的请求，则本次的请求会返回错误。最长50个字符，不带或者带空字符串表示不做去重。
        :rtype: str
        """
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def SessionContext(self):
        r"""来源上下文，用于透传用户请求信息，任务流状态变更回调将返回该字段值，最长1000个字符。
        :rtype: str
        """
        return self._SessionContext

    @SessionContext.setter
    def SessionContext(self, SessionContext):
        self._SessionContext = SessionContext

    @property
    def ExtInfo(self):
        r"""扩展信息字段，仅用于特定场景。
        :rtype: str
        """
        return self._ExtInfo

    @ExtInfo.setter
    def ExtInfo(self, ExtInfo):
        self._ExtInfo = ExtInfo

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskType = params.get("TaskType")
        self._Status = params.get("Status")
        self._CreateTime = params.get("CreateTime")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        self._TaskId = params.get("TaskId")
        if params.get("BatchTaskResult") is not None:
            self._BatchTaskResult = BatchSubTaskResult()
            self._BatchTaskResult._deserialize(params.get("BatchTaskResult"))
        if params.get("TaskNotifyConfig") is not None:
            self._TaskNotifyConfig = TaskNotifyConfig()
            self._TaskNotifyConfig._deserialize(params.get("TaskNotifyConfig"))
        self._TasksPriority = params.get("TasksPriority")
        self._SessionId = params.get("SessionId")
        self._SessionContext = params.get("SessionContext")
        self._ExtInfo = params.get("ExtInfo")
        self._RequestId = params.get("RequestId")


class DescribeBlindWatermarkTemplatesRequest(AbstractModel):
    r"""DescribeBlindWatermarkTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definitions: 数字水印模板唯一标识过滤条件，数组长度限制：100。
        :type Definitions: list of int
        :param _Name: 数字水印模板标识过滤条件，长度限制：64 个字符。
        :type Name: str
        :param _Type: 数字水印类型，可选值：<li>blind-basic：基础版权数字水印；</li><li>blind-nagra：Nagra取证水印；</li>
        :type Type: str
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数
<li>默认值：10；</li>
<li>最大值：100。</li>
        :type Limit: int
        """
        self._Definitions = None
        self._Name = None
        self._Type = None
        self._Offset = None
        self._Limit = None

    @property
    def Definitions(self):
        r"""数字水印模板唯一标识过滤条件，数组长度限制：100。
        :rtype: list of int
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Name(self):
        r"""数字水印模板标识过滤条件，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Type(self):
        r"""数字水印类型，可选值：<li>blind-basic：基础版权数字水印；</li><li>blind-nagra：Nagra取证水印；</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Offset(self):
        r"""分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回记录条数
<li>默认值：10；</li>
<li>最大值：100。</li>
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Name = params.get("Name")
        self._Type = params.get("Type")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBlindWatermarkTemplatesResponse(AbstractModel):
    r"""DescribeBlindWatermarkTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _BlindWatermarkTemplateSet: 数字水印模板详情列表。
        :type BlindWatermarkTemplateSet: list of BlindWatermarkTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._BlindWatermarkTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def BlindWatermarkTemplateSet(self):
        r"""数字水印模板详情列表。
        :rtype: list of BlindWatermarkTemplate
        """
        return self._BlindWatermarkTemplateSet

    @BlindWatermarkTemplateSet.setter
    def BlindWatermarkTemplateSet(self, BlindWatermarkTemplateSet):
        self._BlindWatermarkTemplateSet = BlindWatermarkTemplateSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("BlindWatermarkTemplateSet") is not None:
            self._BlindWatermarkTemplateSet = []
            for item in params.get("BlindWatermarkTemplateSet"):
                obj = BlindWatermarkTemplate()
                obj._deserialize(item)
                self._BlindWatermarkTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeContentReviewTemplatesRequest(AbstractModel):
    r"""DescribeContentReviewTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definitions: 智能审核模板唯一标识过滤条件，数组长度限制：50。
        :type Definitions: list of int
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：50。
        :type Limit: int
        :param _Type: 模板类型过滤条件，不填则返回所有，可选值：
* Preset：系统预置模板；
* Custom：用户自定义模板。
        :type Type: str
        :param _Name: 智能审核模板标识过滤条件，长度限制：64 个字符。
        :type Name: str
        """
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None
        self._Name = None

    @property
    def Definitions(self):
        r"""智能审核模板唯一标识过滤条件，数组长度限制：50。
        :rtype: list of int
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        r"""分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回记录条数，默认值：10，最大值：50。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        r"""模板类型过滤条件，不填则返回所有，可选值：
* Preset：系统预置模板；
* Custom：用户自定义模板。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        r"""智能审核模板标识过滤条件，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeContentReviewTemplatesResponse(AbstractModel):
    r"""DescribeContentReviewTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _ContentReviewTemplateSet: 内容审核模板详情列表。
        :type ContentReviewTemplateSet: list of ContentReviewTemplateItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._ContentReviewTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ContentReviewTemplateSet(self):
        r"""内容审核模板详情列表。
        :rtype: list of ContentReviewTemplateItem
        """
        return self._ContentReviewTemplateSet

    @ContentReviewTemplateSet.setter
    def ContentReviewTemplateSet(self, ContentReviewTemplateSet):
        self._ContentReviewTemplateSet = ContentReviewTemplateSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ContentReviewTemplateSet") is not None:
            self._ContentReviewTemplateSet = []
            for item in params.get("ContentReviewTemplateSet"):
                obj = ContentReviewTemplateItem()
                obj._deserialize(item)
                self._ContentReviewTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeEvent(AbstractModel):
    r"""查询Event的配置信息。

    """

    def __init__(self):
        r"""
        :param _EventName: Event的名称。
        :type EventName: str
        :param _EventId: Event的Id，唯一标识一个event。
        :type EventId: str
        :param _CreateTime: Event创建时间，格式为yyyy-MM-ddTHH:mm:ssZ。
        :type CreateTime: str
        :param _Description: Event的描述。
        :type Description: str
        :param _Status: Event的状态信息
0：未运行
1：运行中
        :type Status: int
        :param _AttachedFlowGroup: Event关联的Flow列表。
注意：此字段可能返回 null，表示取不到有效值。
        :type AttachedFlowGroup: list of DescribeFlowId
        """
        self._EventName = None
        self._EventId = None
        self._CreateTime = None
        self._Description = None
        self._Status = None
        self._AttachedFlowGroup = None

    @property
    def EventName(self):
        r"""Event的名称。
        :rtype: str
        """
        return self._EventName

    @EventName.setter
    def EventName(self, EventName):
        self._EventName = EventName

    @property
    def EventId(self):
        r"""Event的Id，唯一标识一个event。
        :rtype: str
        """
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId

    @property
    def CreateTime(self):
        r"""Event创建时间，格式为yyyy-MM-ddTHH:mm:ssZ。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def Description(self):
        r"""Event的描述。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Status(self):
        r"""Event的状态信息
0：未运行
1：运行中
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def AttachedFlowGroup(self):
        r"""Event关联的Flow列表。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of DescribeFlowId
        """
        return self._AttachedFlowGroup

    @AttachedFlowGroup.setter
    def AttachedFlowGroup(self, AttachedFlowGroup):
        self._AttachedFlowGroup = AttachedFlowGroup


    def _deserialize(self, params):
        self._EventName = params.get("EventName")
        self._EventId = params.get("EventId")
        self._CreateTime = params.get("CreateTime")
        self._Description = params.get("Description")
        self._Status = params.get("Status")
        if params.get("AttachedFlowGroup") is not None:
            self._AttachedFlowGroup = []
            for item in params.get("AttachedFlowGroup"):
                obj = DescribeFlowId()
                obj._deserialize(item)
                self._AttachedFlowGroup.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFlow(AbstractModel):
    r"""查询Flow的配置信息。

    """

    def __init__(self):
        r"""
        :param _FlowId: 流Id。
        :type FlowId: str
        :param _FlowName: 流名称。
        :type FlowName: str
        :param _State: 流状态，目前有IDLE/RUNNING。
        :type State: str
        :param _MaxBandwidth: 最大带宽值。
        :type MaxBandwidth: int
        :param _InputGroup: 输入组。
        :type InputGroup: list of DescribeInput
        :param _OutputGroup: 输出组。
注意：此字段可能返回 null，表示取不到有效值。
        :type OutputGroup: list of DescribeOutput
        :param _EventId: 该Flow关联的媒体传输事件EventId。
        :type EventId: str
        :param _Region: 媒体传输输入流所属的区域，取值和InputRegion相同。
        :type Region: str
        :param _AllowedInputProtocols: 该Flow允许创建的输入协议
        :type AllowedInputProtocols: list of str
        :param _AllowedOutputProtocols: 该Flow允许创建的输出协议
        :type AllowedOutputProtocols: list of str
        """
        self._FlowId = None
        self._FlowName = None
        self._State = None
        self._MaxBandwidth = None
        self._InputGroup = None
        self._OutputGroup = None
        self._EventId = None
        self._Region = None
        self._AllowedInputProtocols = None
        self._AllowedOutputProtocols = None

    @property
    def FlowId(self):
        r"""流Id。
        :rtype: str
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def FlowName(self):
        r"""流名称。
        :rtype: str
        """
        return self._FlowName

    @FlowName.setter
    def FlowName(self, FlowName):
        self._FlowName = FlowName

    @property
    def State(self):
        r"""流状态，目前有IDLE/RUNNING。
        :rtype: str
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def MaxBandwidth(self):
        r"""最大带宽值。
        :rtype: int
        """
        return self._MaxBandwidth

    @MaxBandwidth.setter
    def MaxBandwidth(self, MaxBandwidth):
        self._MaxBandwidth = MaxBandwidth

    @property
    def InputGroup(self):
        r"""输入组。
        :rtype: list of DescribeInput
        """
        return self._InputGroup

    @InputGroup.setter
    def InputGroup(self, InputGroup):
        self._InputGroup = InputGroup

    @property
    def OutputGroup(self):
        r"""输出组。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of DescribeOutput
        """
        return self._OutputGroup

    @OutputGroup.setter
    def OutputGroup(self, OutputGroup):
        self._OutputGroup = OutputGroup

    @property
    def EventId(self):
        r"""该Flow关联的媒体传输事件EventId。
        :rtype: str
        """
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId

    @property
    def Region(self):
        r"""媒体传输输入流所属的区域，取值和InputRegion相同。
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def AllowedInputProtocols(self):
        r"""该Flow允许创建的输入协议
        :rtype: list of str
        """
        return self._AllowedInputProtocols

    @AllowedInputProtocols.setter
    def AllowedInputProtocols(self, AllowedInputProtocols):
        self._AllowedInputProtocols = AllowedInputProtocols

    @property
    def AllowedOutputProtocols(self):
        r"""该Flow允许创建的输出协议
        :rtype: list of str
        """
        return self._AllowedOutputProtocols

    @AllowedOutputProtocols.setter
    def AllowedOutputProtocols(self, AllowedOutputProtocols):
        self._AllowedOutputProtocols = AllowedOutputProtocols


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._FlowName = params.get("FlowName")
        self._State = params.get("State")
        self._MaxBandwidth = params.get("MaxBandwidth")
        if params.get("InputGroup") is not None:
            self._InputGroup = []
            for item in params.get("InputGroup"):
                obj = DescribeInput()
                obj._deserialize(item)
                self._InputGroup.append(obj)
        if params.get("OutputGroup") is not None:
            self._OutputGroup = []
            for item in params.get("OutputGroup"):
                obj = DescribeOutput()
                obj._deserialize(item)
                self._OutputGroup.append(obj)
        self._EventId = params.get("EventId")
        self._Region = params.get("Region")
        self._AllowedInputProtocols = params.get("AllowedInputProtocols")
        self._AllowedOutputProtocols = params.get("AllowedOutputProtocols")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFlowId(AbstractModel):
    r"""Event管理的Flow列表

    """

    def __init__(self):
        r"""
        :param _FlowId: FlowId，唯一标识一个flow。
        :type FlowId: str
        :param _Region: flow所在的区域名称。
        :type Region: str
        """
        self._FlowId = None
        self._Region = None

    @property
    def FlowId(self):
        r"""FlowId，唯一标识一个flow。
        :rtype: str
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def Region(self):
        r"""flow所在的区域名称。
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._Region = params.get("Region")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeGroupAttachFlowsByIdRequest(AbstractModel):
    r"""DescribeGroupAttachFlowsById请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 媒体传输安全组ID。
        :type Id: str
        """
        self._Id = None

    @property
    def Id(self):
        r"""媒体传输安全组ID。
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeGroupAttachFlowsByIdResponse(AbstractModel):
    r"""DescribeGroupAttachFlowsById返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Infos: 安全组反查的Flow信息列表。
        :type Infos: list of FlowInOutResp
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Infos = None
        self._RequestId = None

    @property
    def Infos(self):
        r"""安全组反查的Flow信息列表。
        :rtype: list of FlowInOutResp
        """
        return self._Infos

    @Infos.setter
    def Infos(self, Infos):
        self._Infos = Infos

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Infos") is not None:
            self._Infos = []
            for item in params.get("Infos"):
                obj = FlowInOutResp()
                obj._deserialize(item)
                self._Infos.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeHLSPullSourceAddress(AbstractModel):
    r"""查询输入的HLS配置信息。

    """

    def __init__(self):
        r"""
        :param _Url: HLS源站的Url地址。
注意：此字段可能返回 null，表示取不到有效值。
        :type Url: str
        """
        self._Url = None

    @property
    def Url(self):
        r"""HLS源站的Url地址。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url


    def _deserialize(self, params):
        self._Url = params.get("Url")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeImageSpriteTemplatesRequest(AbstractModel):
    r"""DescribeImageSpriteTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definitions: 雪碧图模板唯一标识过滤条件，数组长度限制：100。
        :type Definitions: list of int non-negative
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        :param _Type: 模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :type Type: str
        :param _Name: 雪碧图模板标识过滤条件，长度限制：64 个字符。
        :type Name: str
        """
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None
        self._Name = None

    @property
    def Definitions(self):
        r"""雪碧图模板唯一标识过滤条件，数组长度限制：100。
        :rtype: list of int non-negative
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        r"""分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        r"""模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        r"""雪碧图模板标识过滤条件，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeImageSpriteTemplatesResponse(AbstractModel):
    r"""DescribeImageSpriteTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _ImageSpriteTemplateSet: 雪碧图模板详情列表。
        :type ImageSpriteTemplateSet: list of ImageSpriteTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._ImageSpriteTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ImageSpriteTemplateSet(self):
        r"""雪碧图模板详情列表。
        :rtype: list of ImageSpriteTemplate
        """
        return self._ImageSpriteTemplateSet

    @ImageSpriteTemplateSet.setter
    def ImageSpriteTemplateSet(self, ImageSpriteTemplateSet):
        self._ImageSpriteTemplateSet = ImageSpriteTemplateSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ImageSpriteTemplateSet") is not None:
            self._ImageSpriteTemplateSet = []
            for item in params.get("ImageSpriteTemplateSet"):
                obj = ImageSpriteTemplate()
                obj._deserialize(item)
                self._ImageSpriteTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeImageTaskDetailRequest(AbstractModel):
    r"""DescribeImageTaskDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 图片处理任务的任务 ID。
        :type TaskId: str
        """
        self._TaskId = None

    @property
    def TaskId(self):
        r"""图片处理任务的任务 ID。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeImageTaskDetailResponse(AbstractModel):
    r"""DescribeImageTaskDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskType: 任务类型，目前取值有：
<li>WorkflowTask：工作流处理任务。</li>
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskType: str
        :param _Status: 任务状态，取值：
<li>WAITING：等待中；</li>
<li>PROCESSING：处理中；</li>
<li>FINISH：已完成。</li>
注意：此字段可能返回 null，表示取不到有效值。
        :type Status: str
        :param _ErrCode: 任务失败时的错误码。
        :type ErrCode: int
        :param _ErrMsg: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrMsg: str
        :param _Message: 任务异常Message。
        :type Message: str
        :param _ImageProcessTaskResultSet: 图片处理任务的执行状态与结果。
注意：此字段可能返回 null，表示取不到有效值。
        :type ImageProcessTaskResultSet: list of ImageProcessTaskResult
        :param _CreateTime: 任务的创建时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: str
        :param _FinishTime: 任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
注意：此字段可能返回 null，表示取不到有效值。
        :type FinishTime: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskType = None
        self._Status = None
        self._ErrCode = None
        self._ErrMsg = None
        self._Message = None
        self._ImageProcessTaskResultSet = None
        self._CreateTime = None
        self._FinishTime = None
        self._RequestId = None

    @property
    def TaskType(self):
        r"""任务类型，目前取值有：
<li>WorkflowTask：工作流处理任务。</li>
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def Status(self):
        r"""任务状态，取值：
<li>WAITING：等待中；</li>
<li>PROCESSING：处理中；</li>
<li>FINISH：已完成。</li>
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        r"""任务失败时的错误码。
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrMsg(self):
        r"""错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :rtype: str
        """
        return self._ErrMsg

    @ErrMsg.setter
    def ErrMsg(self, ErrMsg):
        self._ErrMsg = ErrMsg

    @property
    def Message(self):
        r"""任务异常Message。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def ImageProcessTaskResultSet(self):
        r"""图片处理任务的执行状态与结果。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of ImageProcessTaskResult
        """
        return self._ImageProcessTaskResultSet

    @ImageProcessTaskResultSet.setter
    def ImageProcessTaskResultSet(self, ImageProcessTaskResultSet):
        self._ImageProcessTaskResultSet = ImageProcessTaskResultSet

    @property
    def CreateTime(self):
        r"""任务的创建时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def FinishTime(self):
        r"""任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskType = params.get("TaskType")
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._ErrMsg = params.get("ErrMsg")
        self._Message = params.get("Message")
        if params.get("ImageProcessTaskResultSet") is not None:
            self._ImageProcessTaskResultSet = []
            for item in params.get("ImageProcessTaskResultSet"):
                obj = ImageProcessTaskResult()
                obj._deserialize(item)
                self._ImageProcessTaskResultSet.append(obj)
        self._CreateTime = params.get("CreateTime")
        self._FinishTime = params.get("FinishTime")
        self._RequestId = params.get("RequestId")


class DescribeInput(AbstractModel):
    r"""查询输入配置信息。

    """

    def __init__(self):
        r"""
        :param _InputId: 输入Id。
        :type InputId: str
        :param _InputName: 输入名称。
        :type InputName: str
        :param _Description: 输入描述。
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        :param _Protocol: 输入协议。
        :type Protocol: str
        :param _InputAddressList: 输入地址列表。
        :type InputAddressList: list of InputAddress
        :param _AllowIpList: 输入IP白名单列表。
        :type AllowIpList: list of str
        :param _SRTSettings: 输入的SRT配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type SRTSettings: :class:`tencentcloud.mps.v20190612.models.DescribeInputSRTSettings`
        :param _RTPSettings: 输入的RTP配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type RTPSettings: :class:`tencentcloud.mps.v20190612.models.DescribeInputRTPSettings`
        :param _InputRegion: 输入的地区。
        :type InputRegion: str
        :param _RTMPSettings: 输入的RTMP配置信息。
        :type RTMPSettings: :class:`tencentcloud.mps.v20190612.models.DescribeInputRTMPSettings`
        :param _FailOver: 输入的主备开关。
注意：此字段可能返回 null，表示取不到有效值。
        :type FailOver: str
        :param _RTMPPullSettings: 输入的RTMP_PULL配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type RTMPPullSettings: :class:`tencentcloud.mps.v20190612.models.DescribeInputRTMPPullSettings`
        :param _RTSPPullSettings: 输入的RTSP_PULL配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type RTSPPullSettings: :class:`tencentcloud.mps.v20190612.models.DescribeInputRTSPPullSettings`
        :param _HLSPullSettings: 输入的HLS_PULL配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type HLSPullSettings: :class:`tencentcloud.mps.v20190612.models.DescribeInputHLSPullSettings`
        :param _ResilientStream: 延播平滑吐流配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type ResilientStream: :class:`tencentcloud.mps.v20190612.models.ResilientStreamConf`
        :param _SecurityGroupIds: 绑定的输入安全组 ID。	
注意：此字段可能返回 null，表示取不到有效值。
        :type SecurityGroupIds: list of str
        :param _Zones: 可用区配置，开启容灾情况下最多有两个，顺序和pipeline 0、1对应，否则最多只有一个可用区。	
        :type Zones: list of str
        :param _RISTSettings: 输入的RIST配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type RISTSettings: :class:`tencentcloud.mps.v20190612.models.DescribeInputRISTSettings`
        :param _StreamUrls: 输入模块配置相关的URL信息，包含提供的推流地址，或者配置的第三方源流地址
        :type StreamUrls: list of StreamUrlDetail
        """
        self._InputId = None
        self._InputName = None
        self._Description = None
        self._Protocol = None
        self._InputAddressList = None
        self._AllowIpList = None
        self._SRTSettings = None
        self._RTPSettings = None
        self._InputRegion = None
        self._RTMPSettings = None
        self._FailOver = None
        self._RTMPPullSettings = None
        self._RTSPPullSettings = None
        self._HLSPullSettings = None
        self._ResilientStream = None
        self._SecurityGroupIds = None
        self._Zones = None
        self._RISTSettings = None
        self._StreamUrls = None

    @property
    def InputId(self):
        r"""输入Id。
        :rtype: str
        """
        return self._InputId

    @InputId.setter
    def InputId(self, InputId):
        self._InputId = InputId

    @property
    def InputName(self):
        r"""输入名称。
        :rtype: str
        """
        return self._InputName

    @InputName.setter
    def InputName(self, InputName):
        self._InputName = InputName

    @property
    def Description(self):
        r"""输入描述。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Protocol(self):
        r"""输入协议。
        :rtype: str
        """
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def InputAddressList(self):
        r"""输入地址列表。
        :rtype: list of InputAddress
        """
        return self._InputAddressList

    @InputAddressList.setter
    def InputAddressList(self, InputAddressList):
        self._InputAddressList = InputAddressList

    @property
    def AllowIpList(self):
        r"""输入IP白名单列表。
        :rtype: list of str
        """
        return self._AllowIpList

    @AllowIpList.setter
    def AllowIpList(self, AllowIpList):
        self._AllowIpList = AllowIpList

    @property
    def SRTSettings(self):
        r"""输入的SRT配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.DescribeInputSRTSettings`
        """
        return self._SRTSettings

    @SRTSettings.setter
    def SRTSettings(self, SRTSettings):
        self._SRTSettings = SRTSettings

    @property
    def RTPSettings(self):
        r"""输入的RTP配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.DescribeInputRTPSettings`
        """
        return self._RTPSettings

    @RTPSettings.setter
    def RTPSettings(self, RTPSettings):
        self._RTPSettings = RTPSettings

    @property
    def InputRegion(self):
        r"""输入的地区。
        :rtype: str
        """
        return self._InputRegion

    @InputRegion.setter
    def InputRegion(self, InputRegion):
        self._InputRegion = InputRegion

    @property
    def RTMPSettings(self):
        r"""输入的RTMP配置信息。
        :rtype: :class:`tencentcloud.mps.v20190612.models.DescribeInputRTMPSettings`
        """
        return self._RTMPSettings

    @RTMPSettings.setter
    def RTMPSettings(self, RTMPSettings):
        self._RTMPSettings = RTMPSettings

    @property
    def FailOver(self):
        r"""输入的主备开关。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._FailOver

    @FailOver.setter
    def FailOver(self, FailOver):
        self._FailOver = FailOver

    @property
    def RTMPPullSettings(self):
        r"""输入的RTMP_PULL配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.DescribeInputRTMPPullSettings`
        """
        return self._RTMPPullSettings

    @RTMPPullSettings.setter
    def RTMPPullSettings(self, RTMPPullSettings):
        self._RTMPPullSettings = RTMPPullSettings

    @property
    def RTSPPullSettings(self):
        r"""输入的RTSP_PULL配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.DescribeInputRTSPPullSettings`
        """
        return self._RTSPPullSettings

    @RTSPPullSettings.setter
    def RTSPPullSettings(self, RTSPPullSettings):
        self._RTSPPullSettings = RTSPPullSettings

    @property
    def HLSPullSettings(self):
        r"""输入的HLS_PULL配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.DescribeInputHLSPullSettings`
        """
        return self._HLSPullSettings

    @HLSPullSettings.setter
    def HLSPullSettings(self, HLSPullSettings):
        self._HLSPullSettings = HLSPullSettings

    @property
    def ResilientStream(self):
        r"""延播平滑吐流配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.ResilientStreamConf`
        """
        return self._ResilientStream

    @ResilientStream.setter
    def ResilientStream(self, ResilientStream):
        self._ResilientStream = ResilientStream

    @property
    def SecurityGroupIds(self):
        r"""绑定的输入安全组 ID。	
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds

    @property
    def Zones(self):
        r"""可用区配置，开启容灾情况下最多有两个，顺序和pipeline 0、1对应，否则最多只有一个可用区。	
        :rtype: list of str
        """
        return self._Zones

    @Zones.setter
    def Zones(self, Zones):
        self._Zones = Zones

    @property
    def RISTSettings(self):
        r"""输入的RIST配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.DescribeInputRISTSettings`
        """
        return self._RISTSettings

    @RISTSettings.setter
    def RISTSettings(self, RISTSettings):
        self._RISTSettings = RISTSettings

    @property
    def StreamUrls(self):
        r"""输入模块配置相关的URL信息，包含提供的推流地址，或者配置的第三方源流地址
        :rtype: list of StreamUrlDetail
        """
        return self._StreamUrls

    @StreamUrls.setter
    def StreamUrls(self, StreamUrls):
        self._StreamUrls = StreamUrls


    def _deserialize(self, params):
        self._InputId = params.get("InputId")
        self._InputName = params.get("InputName")
        self._Description = params.get("Description")
        self._Protocol = params.get("Protocol")
        if params.get("InputAddressList") is not None:
            self._InputAddressList = []
            for item in params.get("InputAddressList"):
                obj = InputAddress()
                obj._deserialize(item)
                self._InputAddressList.append(obj)
        self._AllowIpList = params.get("AllowIpList")
        if params.get("SRTSettings") is not None:
            self._SRTSettings = DescribeInputSRTSettings()
            self._SRTSettings._deserialize(params.get("SRTSettings"))
        if params.get("RTPSettings") is not None:
            self._RTPSettings = DescribeInputRTPSettings()
            self._RTPSettings._deserialize(params.get("RTPSettings"))
        self._InputRegion = params.get("InputRegion")
        if params.get("RTMPSettings") is not None:
            self._RTMPSettings = DescribeInputRTMPSettings()
            self._RTMPSettings._deserialize(params.get("RTMPSettings"))
        self._FailOver = params.get("FailOver")
        if params.get("RTMPPullSettings") is not None:
            self._RTMPPullSettings = DescribeInputRTMPPullSettings()
            self._RTMPPullSettings._deserialize(params.get("RTMPPullSettings"))
        if params.get("RTSPPullSettings") is not None:
            self._RTSPPullSettings = DescribeInputRTSPPullSettings()
            self._RTSPPullSettings._deserialize(params.get("RTSPPullSettings"))
        if params.get("HLSPullSettings") is not None:
            self._HLSPullSettings = DescribeInputHLSPullSettings()
            self._HLSPullSettings._deserialize(params.get("HLSPullSettings"))
        if params.get("ResilientStream") is not None:
            self._ResilientStream = ResilientStreamConf()
            self._ResilientStream._deserialize(params.get("ResilientStream"))
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        self._Zones = params.get("Zones")
        if params.get("RISTSettings") is not None:
            self._RISTSettings = DescribeInputRISTSettings()
            self._RISTSettings._deserialize(params.get("RISTSettings"))
        if params.get("StreamUrls") is not None:
            self._StreamUrls = []
            for item in params.get("StreamUrls"):
                obj = StreamUrlDetail()
                obj._deserialize(item)
                self._StreamUrls.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInputHLSPullSettings(AbstractModel):
    r"""查询输入的HLS配置信息。

    """

    def __init__(self):
        r"""
        :param _SourceAddresses: HLS源站地址信息。
        :type SourceAddresses: list of DescribeHLSPullSourceAddress
        """
        self._SourceAddresses = None

    @property
    def SourceAddresses(self):
        r"""HLS源站地址信息。
        :rtype: list of DescribeHLSPullSourceAddress
        """
        return self._SourceAddresses

    @SourceAddresses.setter
    def SourceAddresses(self, SourceAddresses):
        self._SourceAddresses = SourceAddresses


    def _deserialize(self, params):
        if params.get("SourceAddresses") is not None:
            self._SourceAddresses = []
            for item in params.get("SourceAddresses"):
                obj = DescribeHLSPullSourceAddress()
                obj._deserialize(item)
                self._SourceAddresses.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInputRISTSettings(AbstractModel):
    r"""查询输入的RIST配置信息。

    """

    def __init__(self):
        r"""
        :param _Mode: RIST模式，可选[LISTENER|CALLER]，默认为LISTENER。
        :type Mode: str
        :param _Profile: RIST配置方案，可选[MAIN|SIMPLE]，默认为MAIN。
        :type Profile: str
        :param _Buffer: RIST缓冲区大小，单位为毫秒。最小值为50毫秒，最大值为5000毫秒。默认值：120
        :type Buffer: int
        """
        self._Mode = None
        self._Profile = None
        self._Buffer = None

    @property
    def Mode(self):
        r"""RIST模式，可选[LISTENER|CALLER]，默认为LISTENER。
        :rtype: str
        """
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def Profile(self):
        r"""RIST配置方案，可选[MAIN|SIMPLE]，默认为MAIN。
        :rtype: str
        """
        return self._Profile

    @Profile.setter
    def Profile(self, Profile):
        self._Profile = Profile

    @property
    def Buffer(self):
        r"""RIST缓冲区大小，单位为毫秒。最小值为50毫秒，最大值为5000毫秒。默认值：120
        :rtype: int
        """
        return self._Buffer

    @Buffer.setter
    def Buffer(self, Buffer):
        self._Buffer = Buffer


    def _deserialize(self, params):
        self._Mode = params.get("Mode")
        self._Profile = params.get("Profile")
        self._Buffer = params.get("Buffer")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInputRTMPPullSettings(AbstractModel):
    r"""查询输入的RTMP配置信息。

    """

    def __init__(self):
        r"""
        :param _SourceAddresses: RTMP源站地址信息。
        :type SourceAddresses: list of DescribeRTMPPullSourceAddress
        """
        self._SourceAddresses = None

    @property
    def SourceAddresses(self):
        r"""RTMP源站地址信息。
        :rtype: list of DescribeRTMPPullSourceAddress
        """
        return self._SourceAddresses

    @SourceAddresses.setter
    def SourceAddresses(self, SourceAddresses):
        self._SourceAddresses = SourceAddresses


    def _deserialize(self, params):
        if params.get("SourceAddresses") is not None:
            self._SourceAddresses = []
            for item in params.get("SourceAddresses"):
                obj = DescribeRTMPPullSourceAddress()
                obj._deserialize(item)
                self._SourceAddresses.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInputRTMPSettings(AbstractModel):
    r"""查询输入的RTMP配置信息。

    """

    def __init__(self):
        r"""
        :param _AppName: RTMP的推流路径。
注意：此字段可能返回 null，表示取不到有效值。
        :type AppName: str
        :param _StreamKey: RTMP的推流StreamKey。
RTMP的推流地址拼接规则为：rtmp://Ip:1935/AppName/StreamKey
        :type StreamKey: str
        """
        self._AppName = None
        self._StreamKey = None

    @property
    def AppName(self):
        r"""RTMP的推流路径。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def StreamKey(self):
        r"""RTMP的推流StreamKey。
RTMP的推流地址拼接规则为：rtmp://Ip:1935/AppName/StreamKey
        :rtype: str
        """
        return self._StreamKey

    @StreamKey.setter
    def StreamKey(self, StreamKey):
        self._StreamKey = StreamKey


    def _deserialize(self, params):
        self._AppName = params.get("AppName")
        self._StreamKey = params.get("StreamKey")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInputRTPSettings(AbstractModel):
    r"""查询输入的RTP配置信息。

    """

    def __init__(self):
        r"""
        :param _FEC: 是否FEC。
        :type FEC: str
        :param _IdleTimeout: 空闲超时时间。
        :type IdleTimeout: int
        """
        self._FEC = None
        self._IdleTimeout = None

    @property
    def FEC(self):
        r"""是否FEC。
        :rtype: str
        """
        return self._FEC

    @FEC.setter
    def FEC(self, FEC):
        self._FEC = FEC

    @property
    def IdleTimeout(self):
        r"""空闲超时时间。
        :rtype: int
        """
        return self._IdleTimeout

    @IdleTimeout.setter
    def IdleTimeout(self, IdleTimeout):
        self._IdleTimeout = IdleTimeout


    def _deserialize(self, params):
        self._FEC = params.get("FEC")
        self._IdleTimeout = params.get("IdleTimeout")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInputRTSPPullSettings(AbstractModel):
    r"""查询输入的RTSP配置信息。

    """

    def __init__(self):
        r"""
        :param _SourceAddresses: RTSP源站地址信息。
        :type SourceAddresses: list of DescribeRTSPPullSourceAddress
        """
        self._SourceAddresses = None

    @property
    def SourceAddresses(self):
        r"""RTSP源站地址信息。
        :rtype: list of DescribeRTSPPullSourceAddress
        """
        return self._SourceAddresses

    @SourceAddresses.setter
    def SourceAddresses(self, SourceAddresses):
        self._SourceAddresses = SourceAddresses


    def _deserialize(self, params):
        if params.get("SourceAddresses") is not None:
            self._SourceAddresses = []
            for item in params.get("SourceAddresses"):
                obj = DescribeRTSPPullSourceAddress()
                obj._deserialize(item)
                self._SourceAddresses.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInputSRTSettings(AbstractModel):
    r"""查询输入的SRT配置信息。

    """

    def __init__(self):
        r"""
        :param _Mode: SRT模式。
注意：此字段可能返回 null，表示取不到有效值。
        :type Mode: str
        :param _StreamId: 流Id。
        :type StreamId: str
        :param _Latency: 延迟。
        :type Latency: int
        :param _RecvLatency: 接收延迟。
        :type RecvLatency: int
        :param _PeerLatency: 对端延迟。
        :type PeerLatency: int
        :param _PeerIdleTimeout: 对端空闲超时时间。
        :type PeerIdleTimeout: int
        :param _Passphrase: 解密密钥。
        :type Passphrase: str
        :param _PbKeyLen: 密钥长度。
        :type PbKeyLen: int
        :param _SourceAddresses: SRT对端地址。
注意：此字段可能返回 null，表示取不到有效值。
        :type SourceAddresses: list of SRTSourceAddressResp
        :param _FEC: FEC  设置
        :type FEC: :class:`tencentcloud.mps.v20190612.models.SRTFECSimpleOptions`
        """
        self._Mode = None
        self._StreamId = None
        self._Latency = None
        self._RecvLatency = None
        self._PeerLatency = None
        self._PeerIdleTimeout = None
        self._Passphrase = None
        self._PbKeyLen = None
        self._SourceAddresses = None
        self._FEC = None

    @property
    def Mode(self):
        r"""SRT模式。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def StreamId(self):
        r"""流Id。
        :rtype: str
        """
        return self._StreamId

    @StreamId.setter
    def StreamId(self, StreamId):
        self._StreamId = StreamId

    @property
    def Latency(self):
        r"""延迟。
        :rtype: int
        """
        return self._Latency

    @Latency.setter
    def Latency(self, Latency):
        self._Latency = Latency

    @property
    def RecvLatency(self):
        r"""接收延迟。
        :rtype: int
        """
        return self._RecvLatency

    @RecvLatency.setter
    def RecvLatency(self, RecvLatency):
        self._RecvLatency = RecvLatency

    @property
    def PeerLatency(self):
        r"""对端延迟。
        :rtype: int
        """
        return self._PeerLatency

    @PeerLatency.setter
    def PeerLatency(self, PeerLatency):
        self._PeerLatency = PeerLatency

    @property
    def PeerIdleTimeout(self):
        r"""对端空闲超时时间。
        :rtype: int
        """
        return self._PeerIdleTimeout

    @PeerIdleTimeout.setter
    def PeerIdleTimeout(self, PeerIdleTimeout):
        self._PeerIdleTimeout = PeerIdleTimeout

    @property
    def Passphrase(self):
        r"""解密密钥。
        :rtype: str
        """
        return self._Passphrase

    @Passphrase.setter
    def Passphrase(self, Passphrase):
        self._Passphrase = Passphrase

    @property
    def PbKeyLen(self):
        r"""密钥长度。
        :rtype: int
        """
        return self._PbKeyLen

    @PbKeyLen.setter
    def PbKeyLen(self, PbKeyLen):
        self._PbKeyLen = PbKeyLen

    @property
    def SourceAddresses(self):
        r"""SRT对端地址。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of SRTSourceAddressResp
        """
        return self._SourceAddresses

    @SourceAddresses.setter
    def SourceAddresses(self, SourceAddresses):
        self._SourceAddresses = SourceAddresses

    @property
    def FEC(self):
        r"""FEC  设置
        :rtype: :class:`tencentcloud.mps.v20190612.models.SRTFECSimpleOptions`
        """
        return self._FEC

    @FEC.setter
    def FEC(self, FEC):
        self._FEC = FEC


    def _deserialize(self, params):
        self._Mode = params.get("Mode")
        self._StreamId = params.get("StreamId")
        self._Latency = params.get("Latency")
        self._RecvLatency = params.get("RecvLatency")
        self._PeerLatency = params.get("PeerLatency")
        self._PeerIdleTimeout = params.get("PeerIdleTimeout")
        self._Passphrase = params.get("Passphrase")
        self._PbKeyLen = params.get("PbKeyLen")
        if params.get("SourceAddresses") is not None:
            self._SourceAddresses = []
            for item in params.get("SourceAddresses"):
                obj = SRTSourceAddressResp()
                obj._deserialize(item)
                self._SourceAddresses.append(obj)
        if params.get("FEC") is not None:
            self._FEC = SRTFECSimpleOptions()
            self._FEC._deserialize(params.get("FEC"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLiveRecordTemplatesRequest(AbstractModel):
    r"""DescribeLiveRecordTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definitions: 录制模板唯一标识过滤条件，数组长度限制：100。
        :type Definitions: list of int
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        :param _Type: 模板类型过滤条件，不填则返回所有，可选值：
* Preset：系统预置模板；
* Custom：用户自定义模板。
        :type Type: str
        :param _Name: 录制模板标识过滤条件，长度限制：64 个字符。
        :type Name: str
        """
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None
        self._Name = None

    @property
    def Definitions(self):
        r"""录制模板唯一标识过滤条件，数组长度限制：100。
        :rtype: list of int
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        r"""分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        r"""模板类型过滤条件，不填则返回所有，可选值：
* Preset：系统预置模板；
* Custom：用户自定义模板。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        r"""录制模板标识过滤条件，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLiveRecordTemplatesResponse(AbstractModel):
    r"""DescribeLiveRecordTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _LiveRecordTemplateSet: 录制模板详情列表。
        :type LiveRecordTemplateSet: list of LiveRecordTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._LiveRecordTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def LiveRecordTemplateSet(self):
        r"""录制模板详情列表。
        :rtype: list of LiveRecordTemplate
        """
        return self._LiveRecordTemplateSet

    @LiveRecordTemplateSet.setter
    def LiveRecordTemplateSet(self, LiveRecordTemplateSet):
        self._LiveRecordTemplateSet = LiveRecordTemplateSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("LiveRecordTemplateSet") is not None:
            self._LiveRecordTemplateSet = []
            for item in params.get("LiveRecordTemplateSet"):
                obj = LiveRecordTemplate()
                obj._deserialize(item)
                self._LiveRecordTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeMediaMetaDataRequest(AbstractModel):
    r"""DescribeMediaMetaData请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InputInfo: 需要获取元信息的文件输入信息。
        :type InputInfo: :class:`tencentcloud.mps.v20190612.models.MediaInputInfo`
        """
        self._InputInfo = None

    @property
    def InputInfo(self):
        r"""需要获取元信息的文件输入信息。
        :rtype: :class:`tencentcloud.mps.v20190612.models.MediaInputInfo`
        """
        return self._InputInfo

    @InputInfo.setter
    def InputInfo(self, InputInfo):
        self._InputInfo = InputInfo


    def _deserialize(self, params):
        if params.get("InputInfo") is not None:
            self._InputInfo = MediaInputInfo()
            self._InputInfo._deserialize(params.get("InputInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMediaMetaDataResponse(AbstractModel):
    r"""DescribeMediaMetaData返回参数结构体

    """

    def __init__(self):
        r"""
        :param _MetaData: 媒体元信息。
        :type MetaData: :class:`tencentcloud.mps.v20190612.models.MediaMetaData`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._MetaData = None
        self._RequestId = None

    @property
    def MetaData(self):
        r"""媒体元信息。
        :rtype: :class:`tencentcloud.mps.v20190612.models.MediaMetaData`
        """
        return self._MetaData

    @MetaData.setter
    def MetaData(self, MetaData):
        self._MetaData = MetaData

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("MetaData") is not None:
            self._MetaData = MediaMetaData()
            self._MetaData._deserialize(params.get("MetaData"))
        self._RequestId = params.get("RequestId")


class DescribeOutput(AbstractModel):
    r"""查询输出的配置信息。

    """

    def __init__(self):
        r"""
        :param _OutputId: 输出Id。
        :type OutputId: str
        :param _OutputName: 输出名称。
        :type OutputName: str
        :param _OutputType: 输出类型。
        :type OutputType: str
        :param _OutputKind: 输出模块类型，包括Pinpoint（单点输出，最多支持四路并发输出）；MultiMesh（多路输出，支持大于四路的并发输出，目前可以达到200路）。默认类型为 Pinpoint 输出。对于单个 Flow 一个区域最多只能有一个 MultiMesh 输出。
        :type OutputKind: str
        :param _Description: 输出描述。
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        :param _Protocol: 输出协议。
        :type Protocol: str
        :param _OutputAddressList: 输出的出口地址信息列表。
        :type OutputAddressList: list of OutputAddress
        :param _OutputRegion: 输出的地区。
注意：此字段可能返回 null，表示取不到有效值。
        :type OutputRegion: str
        :param _SRTSettings: 输出的SRT配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type SRTSettings: :class:`tencentcloud.mps.v20190612.models.DescribeOutputSRTSettings`
        :param _RTPSettings: 输出的RTP配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type RTPSettings: :class:`tencentcloud.mps.v20190612.models.DescribeOutputRTPSettings`
        :param _RTMPSettings: 输出的RTMP配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type RTMPSettings: :class:`tencentcloud.mps.v20190612.models.DescribeOutputRTMPSettings`
        :param _RTMPPullSettings: 输出的RTMP拉流配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type RTMPPullSettings: :class:`tencentcloud.mps.v20190612.models.DescribeOutputRTMPPullSettings`
        :param _AllowIpList: CIDR白名单列表。
当Protocol为RTMP_PULL有效，为空代表不限制客户端IP。
注意：此字段可能返回 null，表示取不到有效值。
        :type AllowIpList: list of str
        :param _RTSPPullSettings: 输出的RTSP拉流配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type RTSPPullSettings: :class:`tencentcloud.mps.v20190612.models.DescribeOutputRTSPPullSettings`
        :param _HLSPullSettings: 输出的HLS拉流配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type HLSPullSettings: :class:`tencentcloud.mps.v20190612.models.DescribeOutputHLSPullSettings`
        :param _MaxConcurrent: 最大拉流并发数，最大为4，默认4。
        :type MaxConcurrent: int
        :param _SecurityGroupIds: 绑定的安全组 ID。
注意：此字段可能返回 null，表示取不到有效值。
        :type SecurityGroupIds: list of str
        :param _Zones: 可用区，output目前最多只支持一个。	
        :type Zones: list of str
        :param _RISTSettings: 输出的RIST配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type RISTSettings: :class:`tencentcloud.mps.v20190612.models.DescribeOutputRISTSettings`
        :param _PidSelector: 对于含有多个音/视频轨的流，可以指定需要使用的轨道
        :type PidSelector: :class:`tencentcloud.mps.v20190612.models.PidSelector`
        :param _StreamUrls: 输出模块配置，相关的URL，包括提供的拉流地址，或者配置的输出到第三方的转推地址
        :type StreamUrls: list of StreamUrlDetail
        :param _StreamSelector: 对于含有多个音/视频轨的流，可以指定需要使用的轨道
        :type StreamSelector: :class:`tencentcloud.mps.v20190612.models.StreamSelector`
        """
        self._OutputId = None
        self._OutputName = None
        self._OutputType = None
        self._OutputKind = None
        self._Description = None
        self._Protocol = None
        self._OutputAddressList = None
        self._OutputRegion = None
        self._SRTSettings = None
        self._RTPSettings = None
        self._RTMPSettings = None
        self._RTMPPullSettings = None
        self._AllowIpList = None
        self._RTSPPullSettings = None
        self._HLSPullSettings = None
        self._MaxConcurrent = None
        self._SecurityGroupIds = None
        self._Zones = None
        self._RISTSettings = None
        self._PidSelector = None
        self._StreamUrls = None
        self._StreamSelector = None

    @property
    def OutputId(self):
        r"""输出Id。
        :rtype: str
        """
        return self._OutputId

    @OutputId.setter
    def OutputId(self, OutputId):
        self._OutputId = OutputId

    @property
    def OutputName(self):
        r"""输出名称。
        :rtype: str
        """
        return self._OutputName

    @OutputName.setter
    def OutputName(self, OutputName):
        self._OutputName = OutputName

    @property
    def OutputType(self):
        r"""输出类型。
        :rtype: str
        """
        return self._OutputType

    @OutputType.setter
    def OutputType(self, OutputType):
        self._OutputType = OutputType

    @property
    def OutputKind(self):
        r"""输出模块类型，包括Pinpoint（单点输出，最多支持四路并发输出）；MultiMesh（多路输出，支持大于四路的并发输出，目前可以达到200路）。默认类型为 Pinpoint 输出。对于单个 Flow 一个区域最多只能有一个 MultiMesh 输出。
        :rtype: str
        """
        return self._OutputKind

    @OutputKind.setter
    def OutputKind(self, OutputKind):
        self._OutputKind = OutputKind

    @property
    def Description(self):
        r"""输出描述。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Protocol(self):
        r"""输出协议。
        :rtype: str
        """
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def OutputAddressList(self):
        r"""输出的出口地址信息列表。
        :rtype: list of OutputAddress
        """
        return self._OutputAddressList

    @OutputAddressList.setter
    def OutputAddressList(self, OutputAddressList):
        self._OutputAddressList = OutputAddressList

    @property
    def OutputRegion(self):
        r"""输出的地区。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._OutputRegion

    @OutputRegion.setter
    def OutputRegion(self, OutputRegion):
        self._OutputRegion = OutputRegion

    @property
    def SRTSettings(self):
        r"""输出的SRT配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.DescribeOutputSRTSettings`
        """
        return self._SRTSettings

    @SRTSettings.setter
    def SRTSettings(self, SRTSettings):
        self._SRTSettings = SRTSettings

    @property
    def RTPSettings(self):
        r"""输出的RTP配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.DescribeOutputRTPSettings`
        """
        return self._RTPSettings

    @RTPSettings.setter
    def RTPSettings(self, RTPSettings):
        self._RTPSettings = RTPSettings

    @property
    def RTMPSettings(self):
        r"""输出的RTMP配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.DescribeOutputRTMPSettings`
        """
        return self._RTMPSettings

    @RTMPSettings.setter
    def RTMPSettings(self, RTMPSettings):
        self._RTMPSettings = RTMPSettings

    @property
    def RTMPPullSettings(self):
        r"""输出的RTMP拉流配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.DescribeOutputRTMPPullSettings`
        """
        return self._RTMPPullSettings

    @RTMPPullSettings.setter
    def RTMPPullSettings(self, RTMPPullSettings):
        self._RTMPPullSettings = RTMPPullSettings

    @property
    def AllowIpList(self):
        r"""CIDR白名单列表。
当Protocol为RTMP_PULL有效，为空代表不限制客户端IP。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._AllowIpList

    @AllowIpList.setter
    def AllowIpList(self, AllowIpList):
        self._AllowIpList = AllowIpList

    @property
    def RTSPPullSettings(self):
        r"""输出的RTSP拉流配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.DescribeOutputRTSPPullSettings`
        """
        return self._RTSPPullSettings

    @RTSPPullSettings.setter
    def RTSPPullSettings(self, RTSPPullSettings):
        self._RTSPPullSettings = RTSPPullSettings

    @property
    def HLSPullSettings(self):
        r"""输出的HLS拉流配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.DescribeOutputHLSPullSettings`
        """
        return self._HLSPullSettings

    @HLSPullSettings.setter
    def HLSPullSettings(self, HLSPullSettings):
        self._HLSPullSettings = HLSPullSettings

    @property
    def MaxConcurrent(self):
        r"""最大拉流并发数，最大为4，默认4。
        :rtype: int
        """
        return self._MaxConcurrent

    @MaxConcurrent.setter
    def MaxConcurrent(self, MaxConcurrent):
        self._MaxConcurrent = MaxConcurrent

    @property
    def SecurityGroupIds(self):
        r"""绑定的安全组 ID。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds

    @property
    def Zones(self):
        r"""可用区，output目前最多只支持一个。	
        :rtype: list of str
        """
        return self._Zones

    @Zones.setter
    def Zones(self, Zones):
        self._Zones = Zones

    @property
    def RISTSettings(self):
        r"""输出的RIST配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.mps.v20190612.models.DescribeOutputRISTSettings`
        """
        return self._RISTSettings

    @RISTSettings.setter
    def RISTSettings(self, RISTSettings):
        self._RISTSettings = RISTSettings

    @property
    def PidSelector(self):
        warnings.warn("parameter `PidSelector` is deprecated", DeprecationWarning) 

        r"""对于含有多个音/视频轨的流，可以指定需要使用的轨道
        :rtype: :class:`tencentcloud.mps.v20190612.models.PidSelector`
        """
        return self._PidSelector

    @PidSelector.setter
    def PidSelector(self, PidSelector):
        warnings.warn("parameter `PidSelector` is deprecated", DeprecationWarning) 

        self._PidSelector = PidSelector

    @property
    def StreamUrls(self):
        r"""输出模块配置，相关的URL，包括提供的拉流地址，或者配置的输出到第三方的转推地址
        :rtype: list of StreamUrlDetail
        """
        return self._StreamUrls

    @StreamUrls.setter
    def StreamUrls(self, StreamUrls):
        self._StreamUrls = StreamUrls

    @property
    def StreamSelector(self):
        r"""对于含有多个音/视频轨的流，可以指定需要使用的轨道
        :rtype: :class:`tencentcloud.mps.v20190612.models.StreamSelector`
        """
        return self._StreamSelector

    @StreamSelector.setter
    def StreamSelector(self, StreamSelector):
        self._StreamSelector = StreamSelector


    def _deserialize(self, params):
        self._OutputId = params.get("OutputId")
        self._OutputName = params.get("OutputName")
        self._OutputType = params.get("OutputType")
        self._OutputKind = params.get("OutputKind")
        self._Description = params.get("Description")
        self._Protocol = params.get("Protocol")
        if params.get("OutputAddressList") is not None:
            self._OutputAddressList = []
            for item in params.get("OutputAddressList"):
                obj = OutputAddress()
                obj._deserialize(item)
                self._OutputAddressList.append(obj)
        self._OutputRegion = params.get("OutputRegion")
        if params.get("SRTSettings") is not None:
            self._SRTSettings = DescribeOutputSRTSettings()
            self._SRTSettings._deserialize(params.get("SRTSettings"))
        if params.get("RTPSettings") is not None:
            self._RTPSettings = DescribeOutputRTPSettings()
            self._RTPSettings._deserialize(params.get("RTPSettings"))
        if params.get("RTMPSettings") is not None:
            self._RTMPSettings = DescribeOutputRTMPSettings()
            self._RTMPSettings._deserialize(params.get("RTMPSettings"))
        if params.get("RTMPPullSettings") is not None:
            self._RTMPPullSettings = DescribeOutputRTMPPullSettings()
            self._RTMPPullSettings._deserialize(params.get("RTMPPullSettings"))
        self._AllowIpList = params.get("AllowIpList")
        if params.get("RTSPPullSettings") is not None:
            self._RTSPPullSettings = DescribeOutputRTSPPullSettings()
            self._RTSPPullSettings._deserialize(params.get("RTSPPullSettings"))
        if params.get("HLSPullSettings") is not None:
            self._HLSPullSettings = DescribeOutputHLSPullSettings()
            self._HLSPullSettings._deserialize(params.get("HLSPullSettings"))
        self._MaxConcurrent = params.get("MaxConcurrent")
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        self._Zones = params.get("Zones")
        if params.get("RISTSettings") is not None:
            self._RISTSettings = DescribeOutputRISTSettings()
            self._RISTSettings._deserialize(params.get("RISTSettings"))
        if params.get("PidSelector") is not None:
            self._PidSelector = PidSelector()
            self._PidSelector._deserialize(params.get("PidSelector"))
        if params.get("StreamUrls") is not None:
            self._StreamUrls = []
            for item in params.get("StreamUrls"):
                obj = StreamUrlDetail()
                obj._deserialize(item)
                self._StreamUrls.append(obj)
        if params.get("StreamSelector") is not None:
            self._StreamSelector = StreamSelector()
            self._StreamSelector._deserialize(params.get("StreamSelector"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOutputHLSPullServerUrl(AbstractModel):
    r"""查询输出的HLS拉流URL信息。

    """

    def __init__(self):
        r"""
        :param _Url: HLS拉流地址的Url。
        :type Url: str
        """
        self._Url = None

    @property
    def Url(self):
        r"""HLS拉流地址的Url。
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url


    def _deserialize(self, params):
        self._Url = params.get("Url")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOutputHLSPullSettings(AbstractModel):
    r"""查询输出的HLS拉流配置信息。

    """

    def __init__(self):
        r"""
        :param _ServerUrls: HLS拉流地址列表。
注意：此字段可能返回 null，表示取不到有效值。
        :type ServerUrls: list of DescribeOutputHLSPullServerUrl
        """
        self._ServerUrls = None

    @property
    def ServerUrls(self):
        r"""HLS拉流地址列表。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of DescribeOutputHLSPullServerUrl
        """
        return self._ServerUrls

    @ServerUrls.setter
    def ServerUrls(self, ServerUrls):
        self._ServerUrls = ServerUrls


    def _deserialize(self, params):
        if params.get("ServerUrls") is not None:
            self._ServerUrls = []
            for item in params.get("ServerUrls"):
                obj = DescribeOutputHLSPullServerUrl()
                obj._deserialize(item)
                self._ServerUrls.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOutputRISTSettings(AbstractModel):
    r"""查询输出的RIST拉流配置信息。

    """

    def __init__(self):
        r"""
        :param _Mode: RIST模式，可选[LISTENER|CALLER]，默认为LISTENER。
        :type Mode: str
        :param _Profile: RIST配置方案，可选[MAIN|SIMPLE]，默认为MAIN。
        :type Profile: str
        :param _Buffer: RIST缓冲区大小，单位为毫秒。最小值为50毫秒，最大值为5000毫秒。默认值：120
        :type Buffer: int
        :param _SourceAddresses: 服务器监听地址，RIST模式为LISTENER时使用。
注意：此字段可能返回 null，表示取不到有效值。
        :type SourceAddresses: list of OutputRISTSourceAddressResp
        """
        self._Mode = None
        self._Profile = None
        self._Buffer = None
        self._SourceAddresses = None

    @property
    def Mode(self):
        r"""RIST模式，可选[LISTENER|CALLER]，默认为LISTENER。
        :rtype: str
        """
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def Profile(self):
        r"""RIST配置方案，可选[MAIN|SIMPLE]，默认为MAIN。
        :rtype: str
        """
        return self._Profile

    @Profile.setter
    def Profile(self, Profile):
        self._Profile = Profile

    @property
    def Buffer(self):
        r"""RIST缓冲区大小，单位为毫秒。最小值为50毫秒，最大值为5000毫秒。默认值：120
        :rtype: int
        """
        return self._Buffer

    @Buffer.setter
    def Buffer(self, Buffer):
        self._Buffer = Buffer

    @property
    def SourceAddresses(self):
        r"""服务器监听地址，RIST模式为LISTENER时使用。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of OutputRISTSourceAddressResp
        """
        return self._SourceAddresses

    @SourceAddresses.setter
    def SourceAddresses(self, SourceAddresses):
        self._SourceAddresses = SourceAddresses


    def _deserialize(self, params):
        self._Mode = params.get("Mode")
        self._Profile = params.get("Profile")
        self._Buffer = params.get("Buffer")
        if params.get("SourceAddresses") is not None:
            self._SourceAddresses = []
            for item in params.get("SourceAddresses"):
                obj = OutputRISTSourceAddressResp()
                obj._deserialize(item)
                self._SourceAddresses.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOutputRTMPPullServerUrl(AbstractModel):
    r"""查询输出的RTMP拉流URL信息。

    """

    def __init__(self):
        r"""
        :param _TcUrl: RTMP拉流地址的tcUrl。
        :type TcUrl: str
        :param _StreamKey: RTMP拉流地址的流key。
        :type StreamKey: str
        """
        self._TcUrl = None
        self._StreamKey = None

    @property
    def TcUrl(self):
        r"""RTMP拉流地址的tcUrl。
        :rtype: str
        """
        return self._TcUrl

    @TcUrl.setter
    def TcUrl(self, TcUrl):
        self._TcUrl = TcUrl

    @property
    def StreamKey(self):
        r"""RTMP拉流地址的流key。
        :rtype: str
        """
        return self._StreamKey

    @StreamKey.setter
    def StreamKey(self, StreamKey):
        self._StreamKey = StreamKey


    def _deserialize(self, params):
        self._TcUrl = params.get("TcUrl")
        self._StreamKey = params.get("StreamKey")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOutputRTMPPullSettings(AbstractModel):
    r"""查询输出的RTMP拉流配置信息。

    """

    def __init__(self):
        r"""
        :param _ServerUrls: 拉流地址列表。
注意：此字段可能返回 null，表示取不到有效值。
        :type ServerUrls: list of DescribeOutputRTMPPullServerUrl
        """
        self._ServerUrls = None

    @property
    def ServerUrls(self):
        r"""拉流地址列表。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of DescribeOutputRTMPPullServerUrl
        """
        return self._ServerUrls

    @ServerUrls.setter
    def ServerUrls(self, ServerUrls):
        self._ServerUrls = ServerUrls


    def _deserialize(self, params):
        if params.get("ServerUrls") is not None:
            self._ServerUrls = []
            for item in params.get("ServerUrls"):
                obj = DescribeOutputRTMPPullServerUrl()
                obj._deserialize(item)
                self._ServerUrls.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOutputRTMPSettings(AbstractModel):
    r"""查询输出的RTMP配置信息。

    """

    def __init__(self):
        r"""
        :param _IdleTimeout: 空闲超时时间。
注意：此字段可能返回 null，表示取不到有效值。
        :type IdleTimeout: int
        :param _ChunkSize: Chunk大小。
注意：此字段可能返回 null，表示取不到有效值。
        :type ChunkSize: int
        :param _Destinations: 转推RTMP的目标地址信息列表。
注意：此字段可能返回 null，表示取不到有效值。
        :type Destinations: list of RTMPAddressDestination
        """
        self._IdleTimeout = None
        self._ChunkSize = None
        self._Destinations = None

    @property
    def IdleTimeout(self):
        r"""空闲超时时间。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._IdleTimeout

    @IdleTimeout.setter
    def IdleTimeout(self, IdleTimeout):
        self._IdleTimeout = IdleTimeout

    @property
    def ChunkSize(self):
        r"""Chunk大小。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._ChunkSize

    @ChunkSize.setter
    def ChunkSize(self, ChunkSize):
        self._ChunkSize = ChunkSize

    @property
    def Destinations(self):
        r"""转推RTMP的目标地址信息列表。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of RTMPAddressDestination
        """
        return self._Destinations

    @Destinations.setter
    def Destinations(self, Destinations):
        self._Destinations = Destinations


    def _deserialize(self, params):
        self._IdleTimeout = params.get("IdleTimeout")
        self._ChunkSize = params.get("ChunkSize")
        if params.get("Destinations") is not None:
            self._Destinations = []
            for item in params.get("Destinations"):
                obj = RTMPAddressDestination()
                obj._deserialize(item)
                self._Destinations.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOutputRTPSettings(AbstractModel):
    r"""查询输出的RTP配置信息。

    """

    def __init__(self):
        r"""
        :param _Destinations: 转推RTP的目标地址信息列表。
注意：此字段可能返回 null，表示取不到有效值。
        :type Destinations: list of RTPAddressDestination
        :param _FEC: 是否FEC。
注意：此字段可能返回 null，表示取不到有效值。
        :type FEC: str
        :param _IdleTimeout: 空闲超时时间。
注意：此字段可能返回 null，表示取不到有效值。
        :type IdleTimeout: int
        """
        self._Destinations = None
        self._FEC = None
        self._IdleTimeout = None

    @property
    def Destinations(self):
        r"""转推RTP的目标地址信息列表。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of RTPAddressDestination
        """
        return self._Destinations

    @Destinations.setter
    def Destinations(self, Destinations):
        self._Destinations = Destinations

    @property
    def FEC(self):
        r"""是否FEC。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._FEC

    @FEC.setter
    def FEC(self, FEC):
        self._FEC = FEC

    @property
    def IdleTimeout(self):
        r"""空闲超时时间。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._IdleTimeout

    @IdleTimeout.setter
    def IdleTimeout(self, IdleTimeout):
        self._IdleTimeout = IdleTimeout


    def _deserialize(self, params):
        if params.get("Destinations") is not None:
            self._Destinations = []
            for item in params.get("Destinations"):
                obj = RTPAddressDestination()
                obj._deserialize(item)
                self._Destinations.append(obj)
        self._FEC = params.get("FEC")
        self._IdleTimeout = params.get("IdleTimeout")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOutputRTSPPullServerUrl(AbstractModel):
    r"""查询输出的RTSP拉流URL信息。

    """

    def __init__(self):
        r"""
        :param _Url: RTSP拉流地址的Url。
        :type Url: str
        """
        self._Url = None

    @property
    def Url(self):
        r"""RTSP拉流地址的Url。
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url


    def _deserialize(self, params):
        self._Url = params.get("Url")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOutputRTSPPullSettings(AbstractModel):
    r"""查询输出的RTSP拉流配置信息。

    """

    def __init__(self):
        r"""
        :param _ServerUrls: RTSP拉流地址列表。
注意：此字段可能返回 null，表示取不到有效值。
        :type ServerUrls: list of DescribeOutputRTSPPullServerUrl
        """
        self._ServerUrls = None

    @property
    def ServerUrls(self):
        r"""RTSP拉流地址列表。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of DescribeOutputRTSPPullServerUrl
        """
        return self._ServerUrls

    @ServerUrls.setter
    def ServerUrls(self, ServerUrls):
        self._ServerUrls = ServerUrls


    def _deserialize(self, params):
        if params.get("ServerUrls") is not None:
            self._ServerUrls = []
            for item in params.get("ServerUrls"):
                obj = DescribeOutputRTSPPullServerUrl()
                obj._deserialize(item)
                self._ServerUrls.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOutputSRTSettings(AbstractModel):
    r"""查询输出的SRT配置信息。

    """

    def __init__(self):
        r"""
        :param _Destinations: 转推的目标的地址信息列表，SRT模式为CALLER时使用。
注意：此字段可能返回 null，表示取不到有效值。
        :type Destinations: list of SRTAddressDestination
        :param _StreamId: 流Id。
注意：此字段可能返回 null，表示取不到有效值。
        :type StreamId: str
        :param _Latency: 延迟。
注意：此字段可能返回 null，表示取不到有效值。
        :type Latency: int
        :param _RecvLatency: 接收延迟。
注意：此字段可能返回 null，表示取不到有效值。
        :type RecvLatency: int
        :param _PeerLatency: 对端延迟。
注意：此字段可能返回 null，表示取不到有效值。
        :type PeerLatency: int
        :param _PeerIdleTimeout: 对端空闲超时时间。
注意：此字段可能返回 null，表示取不到有效值。
        :type PeerIdleTimeout: int
        :param _Passphrase: 加密密钥。
注意：此字段可能返回 null，表示取不到有效值。
        :type Passphrase: str
        :param _PbKeyLen: 加密密钥长度。
注意：此字段可能返回 null，表示取不到有效值。
        :type PbKeyLen: int
        :param _Mode: SRT模式。
注意：此字段可能返回 null，表示取不到有效值。
        :type Mode: str
        :param _SourceAddresses: 服务器监听地址，SRT模式为LISTENER时使用。
注意：此字段可能返回 null，表示取不到有效值。
        :type SourceAddresses: list of OutputSRTSourceAddressResp
        :param _FEC: FEC 配置
        :type FEC: :class:`tencentcloud.mps.v20190612.models.SRTFECFullOptions`
        """
        self._Destinations = None
        self._StreamId = None
        self._Latency = None
        self._RecvLatency = None
        self._PeerLatency = None
        self._PeerIdleTimeout = None
        self._Passphrase = None
        self._PbKeyLen = None
        self._Mode = None
        self._SourceAddresses = None
        self._FEC = None

    @property
    def Destinations(self):
        r"""转推的目标的地址信息列表，SRT模式为CALLER时使用。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of SRTAddressDestination
        """
        return self._Destinations

    @Destinations.setter
    def Destinations(self, Destinations):
        self._Destinations = Destinations

    @property
    def StreamId(self):
        r"""流Id。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._StreamId

    @StreamId.setter
    def StreamId(self, StreamId):
        self._StreamId = StreamId

    @property
    def Latency(self):
        r"""延迟。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Latency

    @Latency.setter
    def Latency(self, Latency):
        self._Latency = Latency

    @property
    def RecvLatency(self):
        r"""接收延迟。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._RecvLatency

    @RecvLatency.setter
    def RecvLatency(self, RecvLatency):
        self._RecvLatency = RecvLatency

    @property
    def PeerLatency(self):
        r"""对端延迟。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._PeerLatency

    @PeerLatency.setter
    def PeerLatency(self, PeerLatency):
        self._PeerLatency = PeerLatency

    @property
    def PeerIdleTimeout(self):
        r"""对端空闲超时时间。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._PeerIdleTimeout

    @PeerIdleTimeout.setter
    def PeerIdleTimeout(self, PeerIdleTimeout):
        self._PeerIdleTimeout = PeerIdleTimeout

    @property
    def Passphrase(self):
        r"""加密密钥。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Passphrase

    @Passphrase.setter
    def Passphrase(self, Passphrase):
        self._Passphrase = Passphrase

    @property
    def PbKeyLen(self):
        r"""加密密钥长度。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._PbKeyLen

    @PbKeyLen.setter
    def PbKeyLen(self, PbKeyLen):
        self._PbKeyLen = PbKeyLen

    @property
    def Mode(self):
        r"""SRT模式。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def SourceAddresses(self):
        r"""服务器监听地址，SRT模式为LISTENER时使用。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of OutputSRTSourceAddressResp
        """
        return self._SourceAddresses

    @SourceAddresses.setter
    def SourceAddresses(self, SourceAddresses):
        self._SourceAddresses = SourceAddresses

    @property
    def FEC(self):
        r"""FEC 配置
        :rtype: :class:`tencentcloud.mps.v20190612.models.SRTFECFullOptions`
        """
        return self._FEC

    @FEC.setter
    def FEC(self, FEC):
        self._FEC = FEC


    def _deserialize(self, params):
        if params.get("Destinations") is not None:
            self._Destinations = []
            for item in params.get("Destinations"):
                obj = SRTAddressDestination()
                obj._deserialize(item)
                self._Destinations.append(obj)
        self._StreamId = params.get("StreamId")
        self._Latency = params.get("Latency")
        self._RecvLatency = params.get("RecvLatency")
        self._PeerLatency = params.get("PeerLatency")
        self._PeerIdleTimeout = params.get("PeerIdleTimeout")
        self._Passphrase = params.get("Passphrase")
        self._PbKeyLen = params.get("PbKeyLen")
        self._Mode = params.get("Mode")
        if params.get("SourceAddresses") is not None:
            self._SourceAddresses = []
            for item in params.get("SourceAddresses"):
                obj = OutputSRTSourceAddressResp()
                obj._deserialize(item)
                self._SourceAddresses.append(obj)
        if params.get("FEC") is not None:
            self._FEC = SRTFECFullOptions()
            self._FEC._deserialize(params.get("FEC"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePersonSamplesRequest(AbstractModel):
    r"""DescribePersonSamples请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Type: 拉取的素材类型，可选值：
<li>UserDefine：用户自定义素材库；</li>
<li>Default：系统默认素材库。</li>

默认值：UserDefine，拉取用户自定义素材库素材。
说明：如果是拉取系统默认素材库，只能使用素材名字或者素材 ID + 素材名字的方式进行拉取，且人脸图片只返回一张。
        :type Type: str
        :param _PersonIds: 素材 ID，数组长度限制：100。
        :type PersonIds: list of str
        :param _Names: 素材名称，数组长度限制：20。
        :type Names: list of str
        :param _Tags: 素材标签，数组长度限制：20。
        :type Tags: list of str
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：100，最大值：100。
        :type Limit: int
        """
        self._Type = None
        self._PersonIds = None
        self._Names = None
        self._Tags = None
        self._Offset = None
        self._Limit = None

    @property
    def Type(self):
        r"""拉取的素材类型，可选值：
<li>UserDefine：用户自定义素材库；</li>
<li>Default：系统默认素材库。</li>

默认值：UserDefine，拉取用户自定义素材库素材。
说明：如果是拉取系统默认素材库，只能使用素材名字或者素材 ID + 素材名字的方式进行拉取，且人脸图片只返回一张。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def PersonIds(self):
        r"""素材 ID，数组长度限制：100。
        :rtype: list of str
        """
        return self._PersonIds

    @PersonIds.setter
    def PersonIds(self, PersonIds):
        self._PersonIds = PersonIds

    @property
    def Names(self):
        r"""素材名称，数组长度限制：20。
        :rtype: list of str
        """
        return self._Names

    @Names.setter
    def Names(self, Names):
        self._Names = Names

    @property
    def Tags(self):
        r"""素材标签，数组长度限制：20。
        :rtype: list of str
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def Offset(self):
        r"""分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回记录条数，默认值：100，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._PersonIds = params.get("PersonIds")
        self._Names = params.get("Names")
        self._Tags = params.get("Tags")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePersonSamplesResponse(AbstractModel):
    r"""DescribePersonSamples返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合条件的记录总数。
        :type TotalCount: int
        :param _PersonSet: 素材信息。
        :type PersonSet: list of AiSamplePerson
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._PersonSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""符合条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def PersonSet(self):
        r"""素材信息。
        :rtype: list of AiSamplePerson
        """
        return self._PersonSet

    @PersonSet.setter
    def PersonSet(self, PersonSet):
        self._PersonSet = PersonSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("PersonSet") is not None:
            self._PersonSet = []
            for item in params.get("PersonSet"):
                obj = AiSamplePerson()
                obj._deserialize(item)
                self._PersonSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeProcessImageTemplatesRequest(AbstractModel):
    r"""DescribeProcessImageTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definitions: 图片处理模板唯一标识过滤条件，数组长度限制：100。
        :type Definitions: list of int
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数 默认值：10；最大值：100。
        :type Limit: int
        :param _Name: 图片处理模板标识过滤条件。
        :type Name: str
        :param _OrderType: 排序方式，OrderBy设置后才有效，可选值：   0：升序   1：降序  默认 0。
        :type OrderType: int
        :param _OrderBy: 排序字段，可选值：  
Definition：模板唯一标识； 
默认值：创建时间。
        :type OrderBy: str
        :param _Type: 模板类型过滤条件，可选值： <li>Preset：系统预置模板；</li> <li>Custom：用户自定义模板。</li>
        :type Type: str
        """
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Name = None
        self._OrderType = None
        self._OrderBy = None
        self._Type = None

    @property
    def Definitions(self):
        r"""图片处理模板唯一标识过滤条件，数组长度限制：100。
        :rtype: list of int
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        r"""分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回记录条数 默认值：10；最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Name(self):
        r"""图片处理模板标识过滤条件。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def OrderType(self):
        r"""排序方式，OrderBy设置后才有效，可选值：   0：升序   1：降序  默认 0。
        :rtype: int
        """
        return self._OrderType

    @OrderType.setter
    def OrderType(self, OrderType):
        self._OrderType = OrderType

    @property
    def OrderBy(self):
        r"""排序字段，可选值：  
Definition：模板唯一标识； 
默认值：创建时间。
        :rtype: str
        """
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy

    @property
    def Type(self):
        r"""模板类型过滤条件，可选值： <li>Preset：系统预置模板；</li> <li>Custom：用户自定义模板。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Name = params.get("Name")
        self._OrderType = params.get("OrderType")
        self._OrderBy = params.get("OrderBy")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeProcessImageTemplatesResponse(AbstractModel):
    r"""DescribeProcessImageTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _ProcessImageTemplateSet: 图片处理模板详情列表。
        :type ProcessImageTemplateSet: list of ProcessImageTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._ProcessImageTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ProcessImageTemplateSet(self):
        r"""图片处理模板详情列表。
        :rtype: list of ProcessImageTemplate
        """
        return self._ProcessImageTemplateSet

    @ProcessImageTemplateSet.setter
    def ProcessImageTemplateSet(self, ProcessImageTemplateSet):
        self._ProcessImageTemplateSet = ProcessImageTemplateSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ProcessImageTemplateSet") is not None:
            self._ProcessImageTemplateSet = []
            for item in params.get("ProcessImageTemplateSet"):
                obj = ProcessImageTemplate()
                obj._deserialize(item)
                self._ProcessImageTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeQualityControlTemplatesRequest(AbstractModel):
    r"""DescribeQualityControlTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definitions: 媒体质检模板唯一标识过滤条件，数组长度限制：100。
        :type Definitions: list of int
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数
<li>默认值：10；</li>
<li>最大值：100。</li>
        :type Limit: int
        :param _Type: "Preset"：预设，Custom":自定义模板
        :type Type: str
        :param _Name: 媒体质检模板标识过滤条件，长度限制：64 个字符。
        :type Name: str
        """
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None
        self._Name = None

    @property
    def Definitions(self):
        r"""媒体质检模板唯一标识过滤条件，数组长度限制：100。
        :rtype: list of int
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        r"""分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回记录条数
<li>默认值：10；</li>
<li>最大值：100。</li>
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        r""""Preset"：预设，Custom":自定义模板
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        r"""媒体质检模板标识过滤条件，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeQualityControlTemplatesResponse(AbstractModel):
    r"""DescribeQualityControlTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _QualityControlTemplateSet: 媒体质检模板详情列表。
        :type QualityControlTemplateSet: list of QualityControlTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._QualityControlTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def QualityControlTemplateSet(self):
        r"""媒体质检模板详情列表。
        :rtype: list of QualityControlTemplate
        """
        return self._QualityControlTemplateSet

    @QualityControlTemplateSet.setter
    def QualityControlTemplateSet(self, QualityControlTemplateSet):
        self._QualityControlTemplateSet = QualityControlTemplateSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("QualityControlTemplateSet") is not None:
            self._QualityControlTemplateSet = []
            for item in params.get("QualityControlTemplateSet"):
                obj = QualityControlTemplate()
                obj._deserialize(item)
                self._QualityControlTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRTMPPullSourceAddress(AbstractModel):
    r"""查询输入的RTMP配置信息。

    """

    def __init__(self):
        r"""
        :param _TcUrl: RTMP源站的TcUrl地址。
注意：此字段可能返回 null，表示取不到有效值。
        :type TcUrl: str
        :param _StreamKey: RTMP源站的StreamKey。
RTMP源站地址拼接规则为：$TcUrl/$StreamKey。
        :type StreamKey: str
        """
        self._TcUrl = None
        self._StreamKey = None

    @property
    def TcUrl(self):
        r"""RTMP源站的TcUrl地址。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TcUrl

    @TcUrl.setter
    def TcUrl(self, TcUrl):
        self._TcUrl = TcUrl

    @property
    def StreamKey(self):
        r"""RTMP源站的StreamKey。
RTMP源站地址拼接规则为：$TcUrl/$StreamKey。
        :rtype: str
        """
        return self._StreamKey

    @StreamKey.setter
    def StreamKey(self, StreamKey):
        self._StreamKey = StreamKey


    def _deserialize(self, params):
        self._TcUrl = params.get("TcUrl")
        self._StreamKey = params.get("StreamKey")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRTSPPullSourceAddress(AbstractModel):
    r"""查询输入的RTSP配置信息。

    """

    def __init__(self):
        r"""
        :param _Url: RTSP源站的Url地址。
注意：此字段可能返回 null，表示取不到有效值。
        :type Url: str
        """
        self._Url = None

    @property
    def Url(self):
        r"""RTSP源站的Url地址。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url


    def _deserialize(self, params):
        self._Url = params.get("Url")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSampleSnapshotTemplatesRequest(AbstractModel):
    r"""DescribeSampleSnapshotTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definitions: 采样截图模板唯一标识过滤条件，数组长度限制：100。
        :type Definitions: list of int non-negative
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        :param _Type: 模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :type Type: str
        :param _Name: 采样截图模板标识过滤条件，长度限制：64 个字符。
        :type Name: str
        """
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None
        self._Name = None

    @property
    def Definitions(self):
        r"""采样截图模板唯一标识过滤条件，数组长度限制：100。
        :rtype: list of int non-negative
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        r"""分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        r"""模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        r"""采样截图模板标识过滤条件，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSampleSnapshotTemplatesResponse(AbstractModel):
    r"""DescribeSampleSnapshotTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _SampleSnapshotTemplateSet: 采样截图模板详情列表。
        :type SampleSnapshotTemplateSet: list of SampleSnapshotTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._SampleSnapshotTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def SampleSnapshotTemplateSet(self):
        r"""采样截图模板详情列表。
        :rtype: list of SampleSnapshotTemplate
        """
        return self._SampleSnapshotTemplateSet

    @SampleSnapshotTemplateSet.setter
    def SampleSnapshotTemplateSet(self, SampleSnapshotTemplateSet):
        self._SampleSnapshotTemplateSet = SampleSnapshotTemplateSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("SampleSnapshotTemplateSet") is not None:
            self._SampleSnapshotTemplateSet = []
            for item in params.get("SampleSnapshotTemplateSet"):
                obj = SampleSnapshotTemplate()
                obj._deserialize(item)
                self._SampleSnapshotTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSchedulesRequest(AbstractModel):
    r"""DescribeSchedules请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ScheduleIds: 编排 ID 过滤条件，数组长度限制：100。
        :type ScheduleIds: list of int
        :param _TriggerType: 编排触发类型，可选值：
<li>CosFileUpload： 腾讯云 COS 文件上传触发</li>
<li>AwsS3FileUpload：Aws S3 文件上传触发。</li>
不填或者为空表示全部。
        :type TriggerType: str
        :param _Status: 状态，取值范围：
<li>Enabled：已启用，</li>
<li>Disabled：已禁用。</li>
不填此参数，则不区编排状态。
        :type Status: str
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        """
        self._ScheduleIds = None
        self._TriggerType = None
        self._Status = None
        self._Offset = None
        self._Limit = None

    @property
    def ScheduleIds(self):
        r"""编排 ID 过滤条件，数组长度限制：100。
        :rtype: list of int
        """
        return self._ScheduleIds

    @ScheduleIds.setter
    def ScheduleIds(self, ScheduleIds):
        self._ScheduleIds = ScheduleIds

    @property
    def TriggerType(self):
        r"""编排触发类型，可选值：
<li>CosFileUpload： 腾讯云 COS 文件上传触发</li>
<li>AwsS3FileUpload：Aws S3 文件上传触发。</li>
不填或者为空表示全部。
        :rtype: str
        """
        return self._TriggerType

    @TriggerType.setter
    def TriggerType(self, TriggerType):
        self._TriggerType = TriggerType

    @property
    def Status(self):
        r"""状态，取值范围：
<li>Enabled：已启用，</li>
<li>Disabled：已禁用。</li>
不填此参数，则不区编排状态。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Offset(self):
        r"""分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._ScheduleIds = params.get("ScheduleIds")
        self._TriggerType = params.get("TriggerType")
        self._Status = params.get("Status")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSchedulesResponse(AbstractModel):
    r"""DescribeSchedules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _ScheduleInfoSet: 编排信息数组。
        :type ScheduleInfoSet: list of SchedulesInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._ScheduleInfoSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ScheduleInfoSet(self):
        r"""编排信息数组。
        :rtype: list of SchedulesInfo
        """
        return self._ScheduleInfoSet

    @ScheduleInfoSet.setter
    def ScheduleInfoSet(self, ScheduleInfoSet):
        self._ScheduleInfoSet = ScheduleInfoSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ScheduleInfoSet") is not None:
            self._ScheduleInfoSet = []
            for item in params.get("ScheduleInfoSet"):
                obj = SchedulesInfo()
                obj._deserialize(item)
                self._ScheduleInfoSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSmartEraseTemplatesRequest(AbstractModel):
    r"""DescribeSmartEraseTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definitions: 智能擦除模板唯一标识过滤条件，数组长度限制：100。
        :type Definitions: list of int
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        :param _Type: 模板类型过滤条件，不填则返回所有，可选值：
* Preset：系统预置模板；
* Custom：用户自定义模板。
        :type Type: str
        :param _EraseType: 智能擦除模板擦除类型过滤条件。
- subtitle 去字幕
- watermark 去水印
- privacy 隐私保护
        :type EraseType: str
        :param _Name: 智能擦除模板名过滤条件，长度限制：64 个字符。
        :type Name: str
        """
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None
        self._EraseType = None
        self._Name = None

    @property
    def Definitions(self):
        r"""智能擦除模板唯一标识过滤条件，数组长度限制：100。
        :rtype: list of int
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        r"""分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        r"""模板类型过滤条件，不填则返回所有，可选值：
* Preset：系统预置模板；
* Custom：用户自定义模板。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def EraseType(self):
        r"""智能擦除模板擦除类型过滤条件。
- subtitle 去字幕
- watermark 去水印
- privacy 隐私保护
        :rtype: str
        """
        return self._EraseType

    @EraseType.setter
    def EraseType(self, EraseType):
        self._EraseType = EraseType

    @property
    def Name(self):
        r"""智能擦除模板名过滤条件，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        self._EraseType = params.get("EraseType")
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSmartEraseTemplatesResponse(AbstractModel):
    r"""DescribeSmartEraseTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _SmartEraseTemplateSet: 智能擦除模板详情列表。
        :type SmartEraseTemplateSet: list of SmartEraseTemplateItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._SmartEraseTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def SmartEraseTemplateSet(self):
        r"""智能擦除模板详情列表。
        :rtype: list of SmartEraseTemplateItem
        """
        return self._SmartEraseTemplateSet

    @SmartEraseTemplateSet.setter
    def SmartEraseTemplateSet(self, SmartEraseTemplateSet):
        self._SmartEraseTemplateSet = SmartEraseTemplateSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("SmartEraseTemplateSet") is not None:
            self._SmartEraseTemplateSet = []
            for item in params.get("SmartEraseTemplateSet"):
                obj = SmartEraseTemplateItem()
                obj._deserialize(item)
                self._SmartEraseTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSmartSubtitleTemplatesRequest(AbstractModel):
    r"""DescribeSmartSubtitleTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definitions: 智能字幕模板唯一标识过滤条件，数组长度限制：100。
        :type Definitions: list of int
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        :param _Type: 模板类型过滤条件，不填则返回所有，可选值：
* Preset：系统预置模板；
* Custom：用户自定义模板。
        :type Type: str
        :param _Name: 智能字幕模板标识过滤条件，长度限制：64 个字符。
        :type Name: str
        :param _ProcessType: 字幕处理类型：
- 0：ASR识别字幕
- 1：纯字幕翻译
        :type ProcessType: int
        """
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None
        self._Name = None
        self._ProcessType = None

    @property
    def Definitions(self):
        r"""智能字幕模板唯一标识过滤条件，数组长度限制：100。
        :rtype: list of int
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        r"""分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        r"""模板类型过滤条件，不填则返回所有，可选值：
* Preset：系统预置模板；
* Custom：用户自定义模板。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        r"""智能字幕模板标识过滤条件，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def ProcessType(self):
        r"""字幕处理类型：
- 0：ASR识别字幕
- 1：纯字幕翻译
        :rtype: int
        """
        return self._ProcessType

    @ProcessType.setter
    def ProcessType(self, ProcessType):
        self._ProcessType = ProcessType


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        self._ProcessType = params.get("ProcessType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSmartSubtitleTemplatesResponse(AbstractModel):
    r"""DescribeSmartSubtitleTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _SmartSubtitleTemplateSet: 智能字幕模板详情列表。
        :type SmartSubtitleTemplateSet: list of SmartSubtitleTemplateItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._SmartSubtitleTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def SmartSubtitleTemplateSet(self):
        r"""智能字幕模板详情列表。
        :rtype: list of SmartSubtitleTemplateItem
        """
        return self._SmartSubtitleTemplateSet

    @SmartSubtitleTemplateSet.setter
    def SmartSubtitleTemplateSet(self, SmartSubtitleTemplateSet):
        self._SmartSubtitleTemplateSet = SmartSubtitleTemplateSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("SmartSubtitleTemplateSet") is not None:
            self._SmartSubtitleTemplateSet = []
            for item in params.get("SmartSubtitleTemplateSet"):
                obj = SmartSubtitleTemplateItem()
                obj._deserialize(item)
                self._SmartSubtitleTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSnapshotByTimeOffsetTemplatesRequest(AbstractModel):
    r"""DescribeSnapshotByTimeOffsetTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definitions: 指定时间点截图模板唯一标识过滤条件，数组长度限制：100。
        :type Definitions: list of int non-negative
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        :param _Type: 模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :type Type: str
        :param _Name: 指定时间点截图模板标识过滤条件，长度限制：64 个字符。
        :type Name: str
        """
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None
        self._Name = None

    @property
    def Definitions(self):
        r"""指定时间点截图模板唯一标识过滤条件，数组长度限制：100。
        :rtype: list of int non-negative
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        r"""分页偏移量，默认值：0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回记录条数，默认值：10，最大值：100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        r"""模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        r"""指定时间点截图模板标识过滤条件，长度限制：64 个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSnapshotByTimeOffsetTemplatesResponse(AbstractModel):
    r"""DescribeSnapshotByTimeOffsetTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _SnapshotByTimeOffsetTemplateSet: 指定时间点截图模板详情列表。
        :type SnapshotByTimeOffsetTemplateSet: list of SnapshotByTimeOffsetTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._SnapshotByTimeOffsetTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""符合过滤条件的记录总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def SnapshotByTimeOffsetTemplateSet(self):
        r"""指定时间点截图模板详情列表。
        :rtype: list of SnapshotByTimeOffsetTemplate
        """
        return self._SnapshotByTimeOffsetTemplateSet

    @SnapshotByTimeOffsetTemplateSet.setter
    def SnapshotByTimeOffsetTemplateSet(self, SnapshotByTimeOffsetTemplateSet):
        self._SnapshotByTimeOffsetTemplateSet = SnapshotByTimeOffsetTemplateSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("SnapshotByTimeOffsetTemplateSet") is not None:
            self._SnapshotByTimeOffsetTemplateSet = []
            for item in params.get("SnapshotByTimeOffsetTemplateSet"):
                obj = SnapshotByTimeOffsetTemplate()
                obj._deserialize(item)
                self._SnapshotByTimeOffsetTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeStreamLinkActivateStateRequest(AbstractModel):
    r"""DescribeStreamLinkActivateState请求参数结构体

    """


class DescribeStreamLinkActivateStateResponse(AbstractModel):
    r"""DescribeStreamLinkActivateState返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Status: 用户已激活为0，否则为非0。
        :type Status: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Status = None
        self._RequestId = None

    @property
    def Status(self):
        r"""用户已激活为0，否则为非0。
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._RequestId = params.get("RequestId")


class DescribeStreamLinkEventAttachedFlowsRequest(AbstractModel):
    r"""DescribeStreamLinkEventAttachedFlows请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EventId: EventId。
        :type EventId: str
        :param _PageNum: 当前页数，默认1。
        :type PageNum: int
        :param _PageSize: 每页大小，默认1000。
        :type PageSize: int
        """
        self._EventId = None
        self._PageNum = None
        self._PageSize = None

    @property
    def EventId(self):
        r"""EventId。
        :rtype: str
        """
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId

    @property
    def PageNum(self):
        r"""当前页数，默认1。
        :rtype: int
        """
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum

    @property
    def PageSize(self):
        r"""每页大小，默认1000。
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        self._EventId = params.get("EventId")
        self._PageNum = params.get("PageNum")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeStreamLinkEventAttachedFlowsResponse(AbstractModel):
    r"""DescribeStreamLinkEventAttachedFlows返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Infos: 流的配置信息列表。
        :type Infos: list of DescribeFlow
        :param _TotalNum: 总数量。
        :type TotalNum: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Infos = None
        self._TotalNum = None
        self._RequestId = None

    @property
    def Infos(self):
        r"""流的配置信息列表。
        :rtype: list of DescribeFlow
        """
        return self._Infos

    @Infos.setter
    def Infos(self, Infos):
        self._Infos = Infos

    @property
    def TotalNum(self):
        r"""总数量。
        :rtype: int
        """
        return self._TotalNum

    @TotalNum.setter
    def TotalNum(self, TotalNum):
        self._TotalNum = TotalNum

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Infos") is not None:
            self._Infos = []
            for item in params.get("Infos"):
                obj = DescribeFlow()
                obj._deserialize(item)
                self._Infos.append(obj)
        self._TotalNum = params.get("TotalNum")
        self._RequestId = params.get("RequestId")


class DescribeStreamLinkEventRequest(AbstractModel):
    r"""DescribeStreamLinkEvent请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EventId: 媒体传输事件ID。
        :type EventId: str
        """
        self._EventId = None

    @property
    def EventId(self):
        r"""媒体传输事件ID。
        :rtype: str
        """
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId


    def _deserialize(self, params):
        self._EventId = params.get("EventId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeStreamLinkEventResponse(AbstractModel):
    r"""DescribeStreamLinkEvent返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Info: 媒体传输事件的配置信息。
        :type Info: :class:`tencentcloud.mps.v20190612.models.DescribeEvent`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Info = None
        self._RequestId = None

    @property
    def Info(self):
        r"""媒体传输事件的配置信息。
        :rtype: :class:`tencentcloud.mps.v20190612.models.DescribeEvent`
        """
        return self._Info

    @Info.setter
    def Info(self, Info):
        self._Info = Info

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Info") is not None:
            self._Info = DescribeEvent()
            self._Info._deserialize(params.get("Info"))
        self._RequestId = params.get("RequestId")


class DescribeStreamLinkEventsRequest(AbstractModel):
    r"""DescribeStreamLinkEvents请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PageNum: 当前页数，默认1。
        :type PageNum: int
        :param _PageSize: 每页大小，默认10。
        :type PageSize: int
        """
        self._PageNum = None
        self._PageSize = None

    @property
    def PageNum(self):
        r"""当前页数，默认1。
        :rtype: int
        """
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum

    @property
    def PageSize(self):
        r"""每页大小，默认10。
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        self._PageNum = params.get("PageNum")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeStreamLinkEventsResponse(AbstractModel):
    r"""DescribeStreamLinkEvents返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Infos: 媒体传输事件的配置信息列表。
        :type Infos: list of DescribeEvent
        :param _PageNum: 当前页数。
        :type PageNum: int
        :param _PageSize: 每页大小。
        :type PageSize: int
        :param _TotalNum: 总数量。
        :type TotalNum: int
        :param _TotalPage: 总页数。
        :type TotalPage: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Infos = None
        self._PageNum = None
        self._PageSize = None
        self._TotalNum = None
        self._TotalPage = None
        self._RequestId = None

    @property
    def Infos(self):
        r"""媒体传输事件的配置信息列表。
        :rtype: list of DescribeEvent
        """
        return self._Infos

    @Infos.setter
    def Infos(self, Infos):
        self._Infos = Infos

    @property
    def PageNum(self):
        r"""当前页数。
        :rtype: int
        """
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum

    @property
    def PageSize(self):
        r"""每页大小。
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def TotalNum(self):
        r"""总数量。
        :rtype: int
        """
        return self._TotalNum

    @TotalNum.setter
    def TotalNum(self, TotalNum):
        self._TotalNum = TotalNum

    @property
    def TotalPage(self):
        r"""总页数。
        :rtype: int
        """
        return self._TotalPage

    @TotalPage.setter
    def TotalPage(self, TotalPage):
        self._TotalPage = TotalPage

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Infos") is not None:
            self._Infos = []
            for item in params.get("Infos"):
                obj = DescribeEvent()
                obj._deserialize(item)
                self._Infos.append(obj)
        self._PageNum = params.get("PageNum")
        self._PageSize = params.get("PageSize")
        self._TotalNum = params.get("TotalNum")
        self._TotalPage = params.get("TotalPage")
        self._RequestId = params.get("RequestId")


class DescribeStreamLinkFlowLogsRequest(AbstractModel):
    r"""DescribeStreamLinkFlowLogs请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FlowId: 传输流Id。
        :type FlowId: str
        :param _StartTime: 统计的开始时间，默认为前一小时，最多支持查询近7天。
UTC时间，如'2020-01-01T12:00:00Z'。
        :type StartTime: str
        :param _EndTime: 统计的结束时间，默认为StartTime后一小时，最多支持查询24小时的数据。
UTC时间，如'2020-01-01T12:00:00Z'。
        :type EndTime: str
        :param _Type: 输入或输出类型，可选[input|output]。
        :type Type: list of str
        :param _Pipeline: 主通道或备通道，可选[0|1]。
        :type Pipeline: list of str
        :param _PageSize: 每页大小，默认100，范围为[1, 1000]。
        :type PageSize: int
        :param _SortType: 按Timestamp升序或降序排序，默认降序，可选[desc|asc]。
        :type SortType: str
        :param _PageNum: 页码，默认1，范围为[1, 1000]。
        :type PageNum: int
        """
        self._FlowId = None
        self._StartTime = None
        self._EndTime = None
        self._Type = None
        self._Pipeline = None
        self._PageSize = None
        self._SortType = None
        self._PageNum = None

    @property
    def FlowId(self):
        r"""传输流Id。
        :rtype: str
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def StartTime(self):
        r"""统计的开始时间，默认为前一小时，最多支持查询近7天。
UTC时间，如'2020-01-01T12:00:00Z'。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""统计的结束时间，默认为StartTime后一小时，最多支持查询24小时的数据。
UTC时间，如'2020-01-01T12:00:00Z'。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Type(self):
        r"""输入或输出类型，可选[input|output]。
        :rtype: list of str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Pipeline(self):
        r"""主通道或备通道，可选[0|1]。
        :rtype: list of str
        """
        return self._Pipeline

    @Pipeline.setter
    def Pipeline(self, Pipeline):
        self._Pipeline = Pipeline

    @property
    def PageSize(self):
        r"""每页大小，默认100，范围为[1, 1000]。
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def SortType(self):
        r"""按Timestamp升序或降序排序，默认降序，可选[desc|asc]。
        :rtype: str
        """
        return self._SortType

    @SortType.setter
    def SortType(self, SortType):
        self._SortType = SortType

    @property
    def PageNum(self):
        r"""页码，默认1，范围为[1, 1000]。
        :rtype: int
        """
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Type = params.get("Type")
        self._Pipeline = params.get("Pipeline")
        self._PageSize = params.get("PageSize")
        self._SortType = params.get("SortType")
        self._PageNum = params.get("PageNum")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeStreamLinkFlowLogsResponse(AbstractModel):
    r"""DescribeStreamLinkFlowLogs返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Infos: 日志信息列表。
        :type Infos: list of FlowLogInfo
        :param _PageNum: 当前页码。
        :type PageNum: int
        :param _PageSize: 每页大小。
        :type PageSize: int
        :param _TotalNum: 总数量。
        :type TotalNum: int
        :param _TotalPage: 总页数。
        :type TotalPage: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Infos = None
        self._PageNum = None
        self._PageSize = None
        self._TotalNum = None
        self._TotalPage = None
        self._RequestId = None

    @property
    def Infos(self):
        r"""日志信息列表。
        :rtype: list of FlowLogInfo
        """
        return self._Infos

    @Infos.setter
    def Infos(self, Infos):
        self._Infos = Infos

    @property
    def PageNum(self):
        r"""当前页码。
        :rtype: int
        """
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum

    @property
    def PageSize(self):
        r"""每页大小。
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def TotalNum(self):
        r"""总数量。
        :rtype: int
        """
        return self._TotalNum

    @TotalNum.setter
    def TotalNum(self, TotalNum):
        self._TotalNum = TotalNum

    @property
    def TotalPage(self):
        r"""总页数。
        :rtype: int
        """
        return self._TotalPage

    @TotalPage.setter
    def TotalPage(self, TotalPage):
        self._TotalPage = TotalPage

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Infos") is not None:
            self._Infos = []
            for item in params.get("Infos"):
                obj = FlowLogInfo()
                obj._deserialize(item)
                self._Infos.append(obj)
        self._PageNum = params.get("PageNum")
        self._PageSize = params.get("PageSize")
        self._TotalNum = params.get("TotalNum")
        self._TotalPage = params.get("TotalPage")
        self._RequestId = params.get("RequestId")


class DescribeStreamLinkFlowMediaStatisticsRequest(AbstractModel):
    r"""DescribeStreamLinkFlowMediaStatistics请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FlowId: 传输流ID。
        :type FlowId: str
        :param _Type: 输入或输出类型，可选[input|output]。
        :type Type: str
        :param _InputOutputId: 输入或输出Id。
        :type InputOutputId: str
        :param _Pipeline: 主通道或备通道，可选[0|1]。
        :type Pipeline: str
        :param _Period: 查询间隔，可选[5s|1min|5min|15min]。
        :type Period: str
        :param _StartTime: 统计的开始时间，默认为前一小时，最多支持查询近7天。
UTC时间，如'2020-01-01T12:00:00Z'。
        :type StartTime: str
        :param _EndTime: 统计的结束时间，默认为StartTime后一小时，最多支持查询24小时的数据。
UTC时间，如'2020-01-01T12:00:00Z'。
        :type EndTime: str
        :param _RemoteIp: 对端客户端或者服务端的IP地址
        :type RemoteIp: str
        """
        self._FlowId = None
        self._Type = None
        self._InputOutputId = None
        self._Pipeline = None
        self._Period = None
        self._StartTime = None
        self._EndTime = None
        self._RemoteIp = None

    @property
    def FlowId(self):
        r"""传输流ID。
        :rtype: str
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def Type(self):
        r"""输入或输出类型，可选[input|output]。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def InputOutputId(self):
        r"""输入或输出Id。
        :rtype: str
        """
        return self._InputOutputId

    @InputOutputId.setter
    def InputOutputId(self, InputOutputId):
        self._InputOutputId = InputOutputId

    @property
    def Pipeline(self):
        r"""主通道或备通道，可选[0|1]。
        :rtype: str
        """
        return self._Pipeline

    @Pipeline.setter
    def Pipeline(self, Pipeline):
        self._Pipeline = Pipeline

    @property
    def Period(self):
        r"""查询间隔，可选[5s|1min|5min|15min]。
        :rtype: str
        """
        return self._Period

    @Period.setter
    def Period(self, Period):
        self._Period = Period

    @property
    def StartTime(self):
        r"""统计的开始时间，默认为前一小时，最多支持查询近7天。
UTC时间，如'2020-01-01T12:00:00Z'。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""统计的结束时间，默认为StartTime后一小时，最多支持查询24小时的数据。
UTC时间，如'2020-01-01T12:00:00Z'。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def RemoteIp(self):
        r"""对端客户端或者服务端的IP地址
        :rtype: str
        """
        return self._RemoteIp

    @RemoteIp.setter
    def RemoteIp(self, RemoteIp):
        self._RemoteIp = RemoteIp


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._Type = params.get("Type")
        self._InputOutputId = params.get("InputOutputId")
        self._Pipeline = params.get("Pipeline")
        self._Period = params.get("Period")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._RemoteIp = params.get("RemoteIp")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeStreamLinkFlowMediaStatisticsResponse(AbstractModel):
    r"""DescribeStreamLinkFlowMediaStatistics返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Infos: 传输流的媒体数据列表。
        :type Infos: list of FlowMediaInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Infos = None
        self._RequestId = None

    @property
    def Infos(self):
        r"""传输流的媒体数据列表。
        :rtype: list of FlowMediaInfo
        """
        return self._Infos

    @Infos.setter
    def Infos(self, Infos):
        self._Infos = Infos

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Infos") is not None:
            self._Infos = []
            for item in params.get("Infos"):
                obj = FlowMediaInfo()
                obj._deserialize(item)
                self._Infos.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeStreamLinkFlowRealtimeStatusRequest(AbstractModel):
    r"""DescribeStreamLinkFlowRealtimeStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FlowId: 流ID。
        :type FlowId: str
        :param _InputIds: 输入id数组，如果输入输出数组都为空，则代表全量查询。
        :type InputIds: list of str
        :param _OutputIds: 输出id数组，如果输入输出数组都为空，则代表全量查询。
        :type OutputIds: list of str
        """
        self._FlowId = None
        self._InputIds = None
        self._OutputIds = None

    @property
    def FlowId(self):
        r"""流ID。
        :rtype: str
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def InputIds(self):
        r"""输入id数组，如果输入输出数组都为空，则代表全量查询。
        :rtype: list of str
        """
        return self._InputIds

    @InputIds.setter
    def InputIds(self, InputIds):
        self._InputIds = InputIds

    @property
    def OutputIds(self):
        r"""输出id数组，如果输入输出数组都为空，则代表全量查询。
        :rtype: list of str
        """
        return self._OutputIds

    @OutputIds.setter
    def OutputIds(self, OutputIds):
        self._OutputIds = OutputIds


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._InputIds = params.get("InputIds")
        self._OutputIds = params.get("OutputIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeStreamLinkFlowRealtimeStatusResponse(AbstractModel):
    r"""DescribeStreamLinkFlowRealtimeStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Timestamp: 查询时间，单位s。
        :type Timestamp: int
        :param _Datas: 实时数据信息列表。
        :type Datas: list of FlowRealtimeStatusItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Timestamp = None
        self._Datas = None
        self._RequestId = None

    @property
    def Timestamp(self):
        r"""查询时间，单位s。
        :rtype: int
        """
        return self._Timestamp

    @Timestamp.setter
    def Timestamp(self, Timestamp):
        self._Timestamp = Timestamp

    @property
    def Datas(self):
        r"""实时数据信息列表。
        :rtype: list of FlowRealtimeStatusItem
        """
        return self._Datas

    @Datas.setter
    def Datas(self, Datas):
        self._Datas = Datas

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Timestamp = params.get("Timestamp")
        if params.get("Datas") is not None:
            self._Datas = []
            for item in params.get("Datas"):
                obj = FlowRealtimeStatusItem()
                obj._deserialize(item)
                self._Datas.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeStreamLinkFlowRequest(AbstractModel):
    r"""DescribeStreamLinkFlow请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FlowId: 流Id。
        :type FlowId: str
        """
        self._FlowId = None

    @property
    def FlowId(self):
        r"""流Id。
        :rtype: str
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeStreamLinkFlowResponse(AbstractModel):
    r"""DescribeStreamLinkFlow返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Info: 流的配置信息。
        :type Info: :class:`tencentcloud.mps.v20190612.models.DescribeFlow`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Info = None
        self._RequestId = None

    @property
    def Info(self):
        r"""流的配置信息。
        :rtype: :class:`tencentcloud.mps.v20190612.models.DescribeFlow`
        """
        return self._Info

    @Info.setter
    def Info(self, Info):
        self._Info = Info

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Info") is not None:
            self._Info = DescribeFlow()
            self._Info._deserialize(params.get("Info"))
        self._RequestId = params.get("RequestId")


class DescribeStreamLinkFlowSRTStatisticsRequest(AbstractModel):
    r"""DescribeStreamLinkFlowSRTStatistics请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FlowId: 传输流ID。
        :type FlowId: str
        :param _Type: 输入或输出类型，可选[input|output]。
        :type Type: str
        :param _InputOutputId: 输入或输出Id。
        :type InputOutputId: str
        :param _Pipeline: 主通道或备通道，可选[0|1]。
        :type Pipeline: str
        :param _StartTime: 统计的开始时间，默认为前一小时，最多支持查询近7天。
UTC时间，如'2020-01-01T12:00:00Z'。
        :type StartTime: str
        :param _EndTime: 统计的结束时间，默认为StartTime后一小时，最多支持查询24小时的数据。
UTC时间，如'2020-01-01T12:00:00Z'。
        :type EndTime: str
        :param _Period: 查询间隔，可选[5s|1min|5min|15min]。
        :type Period: str
        :param _RemoteIp: 对端客户端或者服务端的IP地址
        :type RemoteIp: str
        """
        self._FlowId = None
        self._Type = None
        self._InputOutputId = None
        self._Pipeline = None
        self._StartTime = None
        self._EndTime = None
        self._Period = None
        self._RemoteIp = None

    @property
    def FlowId(self):
        r"""传输流ID。
        :rtype: str
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def Type(self):
        r"""输入或输出类型，可选[input|output]。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def InputOutputId(self):
        r"""输入或输出Id。
        :rtype: str
        """
        return self._InputOutputId

    @InputOutputId.setter
    def InputOutputId(self, InputOutputId):
        self._InputOutputId = InputOutputId

    @property
    def Pipeline(self):
        r"""主通道或备通道，可选[0|1]。
        :rtype: str
        """
        return self._Pipeline

    @Pipeline.setter
    def Pipeline(self, Pipeline):
        self._Pipeline = Pipeline

    @property
    def StartTime(self):
        r"""统计的开始时间，默认为前一小时，最多支持查询近7天。
UTC时间，如'2020-01-01T12:00:00Z'。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""统计的结束时间，默认为StartTime后一小时，最多支持查询24小时的数据。
UTC时间，如'2020-01-01T12:00:00Z'。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Period(self):
        r"""查询间隔，可选[5s|1min|5min|15min]。
        :rtype: str
        """
        return self._Period

    @Period.setter
    def Period(self, Period):
        self._Period = Period

    @property
    def RemoteIp(self):
        r"""对端客户端或者服务端的IP地址
        :rtype: str
        """
        return self._RemoteIp

    @RemoteIp.setter
    def RemoteIp(self, RemoteIp):
        self._RemoteIp = RemoteIp


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._Type = params.get("Type")
        self._InputOutputId = params.get("InputOutputId")
        self._Pipeline = params.get("Pipeline")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Period = params.get("Period")
        self._RemoteIp = params.get("RemoteIp")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeStreamLinkFlowSRTStatisticsResponse(AbstractModel):
    r"""DescribeStreamLinkFlowSRTStatistics返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Infos: 传输流的SRT质量数据列表。
        :type Infos: list of FlowSRTInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Infos = None
        self._RequestId = None

    @property
    def Infos(self):
        r"""传输流的SRT质量数据列表。
        :rtype: list of FlowSRTInfo
        """
        return self._Infos

    @Infos.setter
    def Infos(self, Infos):
        self._Infos = Infos

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Infos") is not None:
            self._Infos = []
            for item in params.get("Infos"):
                obj = FlowSRTInfo()
                obj._deserialize(item)
                self._Infos.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeStreamLinkFlowStatisticsRequest(AbstractModel):
    r"""DescribeStreamLinkFlowStatistics请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FlowId: 传输流ID。
        :type FlowId: str
        :param _Type: 输入或输出类型，可选[input|output]。
        :type Type: str
        :param _InputOutputId: 输入或输出Id。
        :type InputOutputId: str
        :param _Pipeline: 主通道或备通道，可选[0|1]。
        :type Pipeline: str
        :param _Period: 查询间隔，可选[5s|1min|5min|15min]。
        :type Period: str
        :param _StartTime: 统计的开始时间，默认为前一小时，最多支持查询近7天。
UTC时间，如'2020-01-01T12:00:00Z'。
        :type StartTime: str
        :param _EndTime: 统计的结束时间，默认为StartTime后一小时，最多支持查询24小时的数据。
UTC时间，如'2020-01-01T12:00:00Z'。
        :type EndTime: str
        :param _RemoteIp: 对端客户端或者服务端的IP地址
        :type RemoteIp: str
        """
        self._FlowId = None
        self._Type = None
        self._InputOutputId = None
        self._Pipeline = None
        self._Period = None
        self._StartTime = None
        self._EndTime = None
        self._RemoteIp = None

    @property
    def FlowId(self):
        r"""传输流ID。
        :rtype: str
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def Type(self):
        r"""输入或输出类型，可选[input|output]。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def InputOutputId(self):
        r"""输入或输出Id。
        :rtype: str
        """
        return self._InputOutputId

    @InputOutputId.sett