# -*- coding: utf8 -*-
# Copyright (c) 2017-2025 Tencent. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.



from tencentcloud.common.abstract_client_async import AbstractClient
from tencentcloud.market.v20191010 import models
from typing import Dict


class MarketClient(AbstractClient):
    _apiVersion = '2019-10-10'
    _endpoint = 'market.tencentcloudapi.com'
    _service = 'market'

    async def FlowProductRemind(
            self,
            request: models.FlowProductRemindRequest,
            opts: Dict = None,
    ) -> models.FlowProductRemindResponse:
        """
        计量商品用量提醒，用于服务商调用云服务，云服务向客户发送提醒信息
        """
        
        kwargs = {}
        kwargs["action"] = "FlowProductRemind"
        kwargs["params"] = request._serialize()
        kwargs["resp_cls"] = models.FlowProductRemindResponse
        kwargs["headers"] = request.headers
        kwargs["opts"] = opts or {}
        
        return await self.call_and_deserialize(**kwargs)
        
    async def GetUsagePlanUsageAmount(
            self,
            request: models.GetUsagePlanUsageAmountRequest,
            opts: Dict = None,
    ) -> models.GetUsagePlanUsageAmountResponse:
        """
        该接口可以根据InstanceId查询实例的api的使用情况。
        """
        
        kwargs = {}
        kwargs["action"] = "GetUsagePlanUsageAmount"
        kwargs["params"] = request._serialize()
        kwargs["resp_cls"] = models.GetUsagePlanUsageAmountResponse
        kwargs["headers"] = request.headers
        kwargs["opts"] = opts or {}
        
        return await self.call_and_deserialize(**kwargs)