# -*- coding: utf8 -*-
# Copyright (c) 2017-2025 Tencent. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.



from tencentcloud.common.abstract_client_async import AbstractClient
from tencentcloud.vdb.v20230616 import models
from typing import Dict


class VdbClient(AbstractClient):
    _apiVersion = '2023-06-16'
    _endpoint = 'vdb.tencentcloudapi.com'
    _service = 'vdb'

    async def AssociateSecurityGroups(
            self,
            request: models.AssociateSecurityGroupsRequest,
            opts: Dict = None,
    ) -> models.AssociateSecurityGroupsResponse:
        """
        本接口 (AssociateSecurityGroups) 用于安全组批量绑定多个指定实例。
        """
        
        kwargs = {}
        kwargs["action"] = "AssociateSecurityGroups"
        kwargs["params"] = request._serialize()
        kwargs["resp_cls"] = models.AssociateSecurityGroupsResponse
        kwargs["headers"] = request.headers
        kwargs["opts"] = opts or {}
        
        return await self.call_and_deserialize(**kwargs)
        
    async def CreateInstance(
            self,
            request: models.CreateInstanceRequest,
            opts: Dict = None,
    ) -> models.CreateInstanceResponse:
        """
        本接口（CreateInstance）用于创建向量数据库实例。
        """
        
        kwargs = {}
        kwargs["action"] = "CreateInstance"
        kwargs["params"] = request._serialize()
        kwargs["resp_cls"] = models.CreateInstanceResponse
        kwargs["headers"] = request.headers
        kwargs["opts"] = opts or {}
        
        return await self.call_and_deserialize(**kwargs)
        
    async def DescribeDBSecurityGroups(
            self,
            request: models.DescribeDBSecurityGroupsRequest,
            opts: Dict = None,
    ) -> models.DescribeDBSecurityGroupsResponse:
        """
        本接口(DescribeDBSecurityGroups)用于查询实例的安全组详情。
        """
        
        kwargs = {}
        kwargs["action"] = "DescribeDBSecurityGroups"
        kwargs["params"] = request._serialize()
        kwargs["resp_cls"] = models.DescribeDBSecurityGroupsResponse
        kwargs["headers"] = request.headers
        kwargs["opts"] = opts or {}
        
        return await self.call_and_deserialize(**kwargs)
        
    async def DescribeInstanceMaintenanceWindow(
            self,
            request: models.DescribeInstanceMaintenanceWindowRequest,
            opts: Dict = None,
    ) -> models.DescribeInstanceMaintenanceWindowResponse:
        """
        本接口（DescribeInstanceMaintenanceWindow）用于查看实例维护时间窗。
        """
        
        kwargs = {}
        kwargs["action"] = "DescribeInstanceMaintenanceWindow"
        kwargs["params"] = request._serialize()
        kwargs["resp_cls"] = models.DescribeInstanceMaintenanceWindowResponse
        kwargs["headers"] = request.headers
        kwargs["opts"] = opts or {}
        
        return await self.call_and_deserialize(**kwargs)
        
    async def DescribeInstanceNodes(
            self,
            request: models.DescribeInstanceNodesRequest,
            opts: Dict = None,
    ) -> models.DescribeInstanceNodesResponse:
        """
        查询实例pod列表
        """
        
        kwargs = {}
        kwargs["action"] = "DescribeInstanceNodes"
        kwargs["params"] = request._serialize()
        kwargs["resp_cls"] = models.DescribeInstanceNodesResponse
        kwargs["headers"] = request.headers
        kwargs["opts"] = opts or {}
        
        return await self.call_and_deserialize(**kwargs)
        
    async def DescribeInstances(
            self,
            request: models.DescribeInstancesRequest,
            opts: Dict = None,
    ) -> models.DescribeInstancesResponse:
        """
        查询实例列表
        """
        
        kwargs = {}
        kwargs["action"] = "DescribeInstances"
        kwargs["params"] = request._serialize()
        kwargs["resp_cls"] = models.DescribeInstancesResponse
        kwargs["headers"] = request.headers
        kwargs["opts"] = opts or {}
        
        return await self.call_and_deserialize(**kwargs)
        
    async def DescribePriceCreateInstance(
            self,
            request: models.DescribePriceCreateInstanceRequest,
            opts: Dict = None,
    ) -> models.DescribePriceCreateInstanceResponse:
        """
        查询新购实例价格
        """
        
        kwargs = {}
        kwargs["action"] = "DescribePriceCreateInstance"
        kwargs["params"] = request._serialize()
        kwargs["resp_cls"] = models.DescribePriceCreateInstanceResponse
        kwargs["headers"] = request.headers
        kwargs["opts"] = opts or {}
        
        return await self.call_and_deserialize(**kwargs)
        
    async def DescribePriceRenewInstance(
            self,
            request: models.DescribePriceRenewInstanceRequest,
            opts: Dict = None,
    ) -> models.DescribePriceRenewInstanceResponse:
        """
        查询实例续费价格（包年包月）
        """
        
        kwargs = {}
        kwargs["action"] = "DescribePriceRenewInstance"
        kwargs["params"] = request._serialize()
        kwargs["resp_cls"] = models.DescribePriceRenewInstanceResponse
        kwargs["headers"] = request.headers
        kwargs["opts"] = opts or {}
        
        return await self.call_and_deserialize(**kwargs)
        
    async def DescribePriceResizeInstance(
            self,
            request: models.DescribePriceResizeInstanceRequest,
            opts: Dict = None,
    ) -> models.DescribePriceResizeInstanceResponse:
        """
        查询实例变配价格
        """
        
        kwargs = {}
        kwargs["action"] = "DescribePriceResizeInstance"
        kwargs["params"] = request._serialize()
        kwargs["resp_cls"] = models.DescribePriceResizeInstanceResponse
        kwargs["headers"] = request.headers
        kwargs["opts"] = opts or {}
        
        return await self.call_and_deserialize(**kwargs)
        
    async def DestroyInstances(
            self,
            request: models.DestroyInstancesRequest,
            opts: Dict = None,
    ) -> models.DestroyInstancesResponse:
        """
        本接口（DestroyInstances）用于销毁实例。
        """
        
        kwargs = {}
        kwargs["action"] = "DestroyInstances"
        kwargs["params"] = request._serialize()
        kwargs["resp_cls"] = models.DestroyInstancesResponse
        kwargs["headers"] = request.headers
        kwargs["opts"] = opts or {}
        
        return await self.call_and_deserialize(**kwargs)
        
    async def DisassociateSecurityGroups(
            self,
            request: models.DisassociateSecurityGroupsRequest,
            opts: Dict = None,
    ) -> models.DisassociateSecurityGroupsResponse:
        """
        本接口(DisassociateSecurityGroups)用于安全组批量解绑实例。
        """
        
        kwargs = {}
        kwargs["action"] = "DisassociateSecurityGroups"
        kwargs["params"] = request._serialize()
        kwargs["resp_cls"] = models.DisassociateSecurityGroupsResponse
        kwargs["headers"] = request.headers
        kwargs["opts"] = opts or {}
        
        return await self.call_and_deserialize(**kwargs)
        
    async def IsolateInstance(
            self,
            request: models.IsolateInstanceRequest,
            opts: Dict = None,
    ) -> models.IsolateInstanceResponse:
        """
        本接口（IsolateInstance）用于隔离实例于回收站，在回收站保护时长内可恢复实例。
        """
        
        kwargs = {}
        kwargs["action"] = "IsolateInstance"
        kwargs["params"] = request._serialize()
        kwargs["resp_cls"] = models.IsolateInstanceResponse
        kwargs["headers"] = request.headers
        kwargs["opts"] = opts or {}
        
        return await self.call_and_deserialize(**kwargs)
        
    async def ModifyDBInstanceSecurityGroups(
            self,
            request: models.ModifyDBInstanceSecurityGroupsRequest,
            opts: Dict = None,
    ) -> models.ModifyDBInstanceSecurityGroupsResponse:
        """
        本接口(ModifyDBInstanceSecurityGroups)用于修改实例绑定的安全组。
        """
        
        kwargs = {}
        kwargs["action"] = "ModifyDBInstanceSecurityGroups"
        kwargs["params"] = request._serialize()
        kwargs["resp_cls"] = models.ModifyDBInstanceSecurityGroupsResponse
        kwargs["headers"] = request.headers
        kwargs["opts"] = opts or {}
        
        return await self.call_and_deserialize(**kwargs)
        
    async def ModifyInstanceMaintenanceWindow(
            self,
            request: models.ModifyInstanceMaintenanceWindowRequest,
            opts: Dict = None,
    ) -> models.ModifyInstanceMaintenanceWindowResponse:
        """
        本接口（ModifyInstanceMaintenanceWindow）用于修改实例维护时间窗范围。
        """
        
        kwargs = {}
        kwargs["action"] = "ModifyInstanceMaintenanceWindow"
        kwargs["params"] = request._serialize()
        kwargs["resp_cls"] = models.ModifyInstanceMaintenanceWindowResponse
        kwargs["headers"] = request.headers
        kwargs["opts"] = opts or {}
        
        return await self.call_and_deserialize(**kwargs)
        
    async def RecoverInstance(
            self,
            request: models.RecoverInstanceRequest,
            opts: Dict = None,
    ) -> models.RecoverInstanceResponse:
        """
        本接口（RecoverInstance）用于恢复在回收站隔离的实例。
        """
        
        kwargs = {}
        kwargs["action"] = "RecoverInstance"
        kwargs["params"] = request._serialize()
        kwargs["resp_cls"] = models.RecoverInstanceResponse
        kwargs["headers"] = request.headers
        kwargs["opts"] = opts or {}
        
        return await self.call_and_deserialize(**kwargs)
        
    async def ScaleOutInstance(
            self,
            request: models.ScaleOutInstanceRequest,
            opts: Dict = None,
    ) -> models.ScaleOutInstanceResponse:
        """
        本接口（ScaleOutInstance）用于水平扩容节点数量。
        """
        
        kwargs = {}
        kwargs["action"] = "ScaleOutInstance"
        kwargs["params"] = request._serialize()
        kwargs["resp_cls"] = models.ScaleOutInstanceResponse
        kwargs["headers"] = request.headers
        kwargs["opts"] = opts or {}
        
        return await self.call_and_deserialize(**kwargs)
        
    async def ScaleUpInstance(
            self,
            request: models.ScaleUpInstanceRequest,
            opts: Dict = None,
    ) -> models.ScaleUpInstanceResponse:
        """
        本接口（ScaleUpInstance）用于升级节点配置规格。
        """
        
        kwargs = {}
        kwargs["action"] = "ScaleUpInstance"
        kwargs["params"] = request._serialize()
        kwargs["resp_cls"] = models.ScaleUpInstanceResponse
        kwargs["headers"] = request.headers
        kwargs["opts"] = opts or {}
        
        return await self.call_and_deserialize(**kwargs)