# -*- coding: utf8 -*-
# Copyright (c) 2017-2025 Tencent. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class AccessInfo(AbstractModel):
    r"""引擎的访问信息

    """

    def __init__(self):
        r"""
        :param _AccessType: 访问引擎的方法
注意：此字段可能返回 null，表示取不到有效值。
        :type AccessType: str
        :param _AccessConnectionInfos: 访问引擎的url，内部的部分参数需要根据实际情况替换
注意：此字段可能返回 null，表示取不到有效值。
        :type AccessConnectionInfos: list of str
        """
        self._AccessType = None
        self._AccessConnectionInfos = None

    @property
    def AccessType(self):
        r"""访问引擎的方法
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AccessType

    @AccessType.setter
    def AccessType(self, AccessType):
        self._AccessType = AccessType

    @property
    def AccessConnectionInfos(self):
        r"""访问引擎的url，内部的部分参数需要根据实际情况替换
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._AccessConnectionInfos

    @AccessConnectionInfos.setter
    def AccessConnectionInfos(self, AccessConnectionInfos):
        self._AccessConnectionInfos = AccessConnectionInfos


    def _deserialize(self, params):
        self._AccessType = params.get("AccessType")
        self._AccessConnectionInfos = params.get("AccessConnectionInfos")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddDMSPartitionsRequest(AbstractModel):
    r"""AddDMSPartitions请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Partitions: 分区
        :type Partitions: list of DMSPartition
        """
        self._Partitions = None

    @property
    def Partitions(self):
        r"""分区
        :rtype: list of DMSPartition
        """
        return self._Partitions

    @Partitions.setter
    def Partitions(self, Partitions):
        self._Partitions = Partitions


    def _deserialize(self, params):
        if params.get("Partitions") is not None:
            self._Partitions = []
            for item in params.get("Partitions"):
                obj = DMSPartition()
                obj._deserialize(item)
                self._Partitions.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddDMSPartitionsResponse(AbstractModel):
    r"""AddDMSPartitions返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Total: 成功数量
        :type Total: int
        :param _Partitions: 分区值
        :type Partitions: list of DMSPartition
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Total = None
        self._Partitions = None
        self._RequestId = None

    @property
    def Total(self):
        r"""成功数量
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Partitions(self):
        r"""分区值
        :rtype: list of DMSPartition
        """
        return self._Partitions

    @Partitions.setter
    def Partitions(self, Partitions):
        self._Partitions = Partitions

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("Partitions") is not None:
            self._Partitions = []
            for item in params.get("Partitions"):
                obj = DMSPartition()
                obj._deserialize(item)
                self._Partitions.append(obj)
        self._RequestId = params.get("RequestId")


class AddOptimizerEnginesRequest(AbstractModel):
    r"""AddOptimizerEngines请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Catalog: 数据目录名称
        :type Catalog: str
        :param _Engines: 引擎信息列表
        :type Engines: list of OptimizerEngineInfo
        :param _Database: 数据库名称
        :type Database: str
        :param _Table: 数据表名称
        :type Table: str
        """
        self._Catalog = None
        self._Engines = None
        self._Database = None
        self._Table = None

    @property
    def Catalog(self):
        r"""数据目录名称
        :rtype: str
        """
        return self._Catalog

    @Catalog.setter
    def Catalog(self, Catalog):
        self._Catalog = Catalog

    @property
    def Engines(self):
        r"""引擎信息列表
        :rtype: list of OptimizerEngineInfo
        """
        return self._Engines

    @Engines.setter
    def Engines(self, Engines):
        self._Engines = Engines

    @property
    def Database(self):
        r"""数据库名称
        :rtype: str
        """
        return self._Database

    @Database.setter
    def Database(self, Database):
        self._Database = Database

    @property
    def Table(self):
        r"""数据表名称
        :rtype: str
        """
        return self._Table

    @Table.setter
    def Table(self, Table):
        self._Table = Table


    def _deserialize(self, params):
        self._Catalog = params.get("Catalog")
        if params.get("Engines") is not None:
            self._Engines = []
            for item in params.get("Engines"):
                obj = OptimizerEngineInfo()
                obj._deserialize(item)
                self._Engines.append(obj)
        self._Database = params.get("Database")
        self._Table = params.get("Table")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddOptimizerEnginesResponse(AbstractModel):
    r"""AddOptimizerEngines返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AddUsersToWorkGroupRequest(AbstractModel):
    r"""AddUsersToWorkGroup请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AddInfo: 要操作的工作组和用户信息
        :type AddInfo: :class:`tencentcloud.dlc.v20210125.models.UserIdSetOfWorkGroupId`
        """
        self._AddInfo = None

    @property
    def AddInfo(self):
        r"""要操作的工作组和用户信息
        :rtype: :class:`tencentcloud.dlc.v20210125.models.UserIdSetOfWorkGroupId`
        """
        return self._AddInfo

    @AddInfo.setter
    def AddInfo(self, AddInfo):
        self._AddInfo = AddInfo


    def _deserialize(self, params):
        if params.get("AddInfo") is not None:
            self._AddInfo = UserIdSetOfWorkGroupId()
            self._AddInfo._deserialize(params.get("AddInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddUsersToWorkGroupResponse(AbstractModel):
    r"""AddUsersToWorkGroup返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AlterDMSDatabaseRequest(AbstractModel):
    r"""AlterDMSDatabase请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CurrentName: 当前名称
        :type CurrentName: str
        :param _SchemaName: schema名称
        :type SchemaName: str
        :param _Location: 路径
        :type Location: str
        :param _Asset: 基础对象
        :type Asset: :class:`tencentcloud.dlc.v20210125.models.Asset`
        :param _DatasourceConnectionName: 数据源连接名
        :type DatasourceConnectionName: str
        """
        self._CurrentName = None
        self._SchemaName = None
        self._Location = None
        self._Asset = None
        self._DatasourceConnectionName = None

    @property
    def CurrentName(self):
        r"""当前名称
        :rtype: str
        """
        return self._CurrentName

    @CurrentName.setter
    def CurrentName(self, CurrentName):
        self._CurrentName = CurrentName

    @property
    def SchemaName(self):
        r"""schema名称
        :rtype: str
        """
        return self._SchemaName

    @SchemaName.setter
    def SchemaName(self, SchemaName):
        self._SchemaName = SchemaName

    @property
    def Location(self):
        r"""路径
        :rtype: str
        """
        return self._Location

    @Location.setter
    def Location(self, Location):
        self._Location = Location

    @property
    def Asset(self):
        r"""基础对象
        :rtype: :class:`tencentcloud.dlc.v20210125.models.Asset`
        """
        return self._Asset

    @Asset.setter
    def Asset(self, Asset):
        self._Asset = Asset

    @property
    def DatasourceConnectionName(self):
        r"""数据源连接名
        :rtype: str
        """
        return self._DatasourceConnectionName

    @DatasourceConnectionName.setter
    def DatasourceConnectionName(self, DatasourceConnectionName):
        self._DatasourceConnectionName = DatasourceConnectionName


    def _deserialize(self, params):
        self._CurrentName = params.get("CurrentName")
        self._SchemaName = params.get("SchemaName")
        self._Location = params.get("Location")
        if params.get("Asset") is not None:
            self._Asset = Asset()
            self._Asset._deserialize(params.get("Asset"))
        self._DatasourceConnectionName = params.get("DatasourceConnectionName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AlterDMSDatabaseResponse(AbstractModel):
    r"""AlterDMSDatabase返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AlterDMSPartitionRequest(AbstractModel):
    r"""AlterDMSPartition请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CurrentDbName: 当前名称，变更前db名称
        :type CurrentDbName: str
        :param _CurrentTableName: 当前名称，变更前table名称
        :type CurrentTableName: str
        :param _CurrentValues: 当前名称，变更前Part名称
        :type CurrentValues: str
        :param _Partition: 分区
        :type Partition: :class:`tencentcloud.dlc.v20210125.models.DMSPartition`
        :param _DatasourceConnectionName: 数据源连接名
        :type DatasourceConnectionName: str
        """
        self._CurrentDbName = None
        self._CurrentTableName = None
        self._CurrentValues = None
        self._Partition = None
        self._DatasourceConnectionName = None

    @property
    def CurrentDbName(self):
        r"""当前名称，变更前db名称
        :rtype: str
        """
        return self._CurrentDbName

    @CurrentDbName.setter
    def CurrentDbName(self, CurrentDbName):
        self._CurrentDbName = CurrentDbName

    @property
    def CurrentTableName(self):
        r"""当前名称，变更前table名称
        :rtype: str
        """
        return self._CurrentTableName

    @CurrentTableName.setter
    def CurrentTableName(self, CurrentTableName):
        self._CurrentTableName = CurrentTableName

    @property
    def CurrentValues(self):
        r"""当前名称，变更前Part名称
        :rtype: str
        """
        return self._CurrentValues

    @CurrentValues.setter
    def CurrentValues(self, CurrentValues):
        self._CurrentValues = CurrentValues

    @property
    def Partition(self):
        r"""分区
        :rtype: :class:`tencentcloud.dlc.v20210125.models.DMSPartition`
        """
        return self._Partition

    @Partition.setter
    def Partition(self, Partition):
        self._Partition = Partition

    @property
    def DatasourceConnectionName(self):
        r"""数据源连接名
        :rtype: str
        """
        return self._DatasourceConnectionName

    @DatasourceConnectionName.setter
    def DatasourceConnectionName(self, DatasourceConnectionName):
        self._DatasourceConnectionName = DatasourceConnectionName


    def _deserialize(self, params):
        self._CurrentDbName = params.get("CurrentDbName")
        self._CurrentTableName = params.get("CurrentTableName")
        self._CurrentValues = params.get("CurrentValues")
        if params.get("Partition") is not None:
            self._Partition = DMSPartition()
            self._Partition._deserialize(params.get("Partition"))
        self._DatasourceConnectionName = params.get("DatasourceConnectionName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AlterDMSPartitionResponse(AbstractModel):
    r"""AlterDMSPartition返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AlterDMSTableRequest(AbstractModel):
    r"""AlterDMSTable请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CurrentName: 当前名称
        :type CurrentName: str
        :param _CurrentDbName: 当前数据库名称
        :type CurrentDbName: str
        :param _Asset: 基础对象
        :type Asset: :class:`tencentcloud.dlc.v20210125.models.Asset`
        :param _Type: 表类型
        :type Type: str
        :param _DbName: 数据库名称
        :type DbName: str
        :param _StorageSize: 存储大小
        :type StorageSize: int
        :param _RecordCount: 记录数量
        :type RecordCount: int
        :param _LifeTime: 生命周期
        :type LifeTime: int
        :param _DataUpdateTime: 数据更新时间
        :type DataUpdateTime: str
        :param _StructUpdateTime: 结构更新时间
        :type StructUpdateTime: str
        :param _LastAccessTime: 最后访问时间
        :type LastAccessTime: str
        :param _Sds: 存储对象
        :type Sds: :class:`tencentcloud.dlc.v20210125.models.DMSSds`
        :param _Columns: 列
        :type Columns: list of DMSColumn
        :param _PartitionKeys: 分区键值
        :type PartitionKeys: list of DMSColumn
        :param _ViewOriginalText: 视图文本
        :type ViewOriginalText: str
        :param _ViewExpandedText: 视图文本
        :type ViewExpandedText: str
        :param _Partitions: 分区
        :type Partitions: list of DMSPartition
        :param _Name: 当前表名
        :type Name: str
        :param _DatasourceConnectionName: 数据源连接名
        :type DatasourceConnectionName: str
        """
        self._CurrentName = None
        self._CurrentDbName = None
        self._Asset = None
        self._Type = None
        self._DbName = None
        self._StorageSize = None
        self._RecordCount = None
        self._LifeTime = None
        self._DataUpdateTime = None
        self._StructUpdateTime = None
        self._LastAccessTime = None
        self._Sds = None
        self._Columns = None
        self._PartitionKeys = None
        self._ViewOriginalText = None
        self._ViewExpandedText = None
        self._Partitions = None
        self._Name = None
        self._DatasourceConnectionName = None

    @property
    def CurrentName(self):
        r"""当前名称
        :rtype: str
        """
        return self._CurrentName

    @CurrentName.setter
    def CurrentName(self, CurrentName):
        self._CurrentName = CurrentName

    @property
    def CurrentDbName(self):
        r"""当前数据库名称
        :rtype: str
        """
        return self._CurrentDbName

    @CurrentDbName.setter
    def CurrentDbName(self, CurrentDbName):
        self._CurrentDbName = CurrentDbName

    @property
    def Asset(self):
        r"""基础对象
        :rtype: :class:`tencentcloud.dlc.v20210125.models.Asset`
        """
        return self._Asset

    @Asset.setter
    def Asset(self, Asset):
        self._Asset = Asset

    @property
    def Type(self):
        r"""表类型
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def DbName(self):
        r"""数据库名称
        :rtype: str
        """
        return self._DbName

    @DbName.setter
    def DbName(self, DbName):
        self._DbName = DbName

    @property
    def StorageSize(self):
        r"""存储大小
        :rtype: int
        """
        return self._StorageSize

    @StorageSize.setter
    def StorageSize(self, StorageSize):
        self._StorageSize = StorageSize

    @property
    def RecordCount(self):
        r"""记录数量
        :rtype: int
        """
        return self._RecordCount

    @RecordCount.setter
    def RecordCount(self, RecordCount):
        self._RecordCount = RecordCount

    @property
    def LifeTime(self):
        r"""生命周期
        :rtype: int
        """
        return self._LifeTime

    @LifeTime.setter
    def LifeTime(self, LifeTime):
        self._LifeTime = LifeTime

    @property
    def DataUpdateTime(self):
        r"""数据更新时间
        :rtype: str
        """
        return self._DataUpdateTime

    @DataUpdateTime.setter
    def DataUpdateTime(self, DataUpdateTime):
        self._DataUpdateTime = DataUpdateTime

    @property
    def StructUpdateTime(self):
        r"""结构更新时间
        :rtype: str
        """
        return self._StructUpdateTime

    @StructUpdateTime.setter
    def StructUpdateTime(self, StructUpdateTime):
        self._StructUpdateTime = StructUpdateTime

    @property
    def LastAccessTime(self):
        r"""最后访问时间
        :rtype: str
        """
        return self._LastAccessTime

    @LastAccessTime.setter
    def LastAccessTime(self, LastAccessTime):
        self._LastAccessTime = LastAccessTime

    @property
    def Sds(self):
        r"""存储对象
        :rtype: :class:`tencentcloud.dlc.v20210125.models.DMSSds`
        """
        return self._Sds

    @Sds.setter
    def Sds(self, Sds):
        self._Sds = Sds

    @property
    def Columns(self):
        r"""列
        :rtype: list of DMSColumn
        """
        return self._Columns

    @Columns.setter
    def Columns(self, Columns):
        self._Columns = Columns

    @property
    def PartitionKeys(self):
        r"""分区键值
        :rtype: list of DMSColumn
        """
        return self._PartitionKeys

    @PartitionKeys.setter
    def PartitionKeys(self, PartitionKeys):
        self._PartitionKeys = PartitionKeys

    @property
    def ViewOriginalText(self):
        r"""视图文本
        :rtype: str
        """
        return self._ViewOriginalText

    @ViewOriginalText.setter
    def ViewOriginalText(self, ViewOriginalText):
        self._ViewOriginalText = ViewOriginalText

    @property
    def ViewExpandedText(self):
        r"""视图文本
        :rtype: str
        """
        return self._ViewExpandedText

    @ViewExpandedText.setter
    def ViewExpandedText(self, ViewExpandedText):
        self._ViewExpandedText = ViewExpandedText

    @property
    def Partitions(self):
        r"""分区
        :rtype: list of DMSPartition
        """
        return self._Partitions

    @Partitions.setter
    def Partitions(self, Partitions):
        self._Partitions = Partitions

    @property
    def Name(self):
        r"""当前表名
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def DatasourceConnectionName(self):
        r"""数据源连接名
        :rtype: str
        """
        return self._DatasourceConnectionName

    @DatasourceConnectionName.setter
    def DatasourceConnectionName(self, DatasourceConnectionName):
        self._DatasourceConnectionName = DatasourceConnectionName


    def _deserialize(self, params):
        self._CurrentName = params.get("CurrentName")
        self._CurrentDbName = params.get("CurrentDbName")
        if params.get("Asset") is not None:
            self._Asset = Asset()
            self._Asset._deserialize(params.get("Asset"))
        self._Type = params.get("Type")
        self._DbName = params.get("DbName")
        self._StorageSize = params.get("StorageSize")
        self._RecordCount = params.get("RecordCount")
        self._LifeTime = params.get("LifeTime")
        self._DataUpdateTime = params.get("DataUpdateTime")
        self._StructUpdateTime = params.get("StructUpdateTime")
        self._LastAccessTime = params.get("LastAccessTime")
        if params.get("Sds") is not None:
            self._Sds = DMSSds()
            self._Sds._deserialize(params.get("Sds"))
        if params.get("Columns") is not None:
            self._Columns = []
            for item in params.get("Columns"):
                obj = DMSColumn()
                obj._deserialize(item)
                self._Columns.append(obj)
        if params.get("PartitionKeys") is not None:
            self._PartitionKeys = []
            for item in params.get("PartitionKeys"):
                obj = DMSColumn()
                obj._deserialize(item)
                self._PartitionKeys.append(obj)
        self._ViewOriginalText = params.get("ViewOriginalText")
        self._ViewExpandedText = params.get("ViewExpandedText")
        if params.get("Partitions") is not None:
            self._Partitions = []
            for item in params.get("Partitions"):
                obj = DMSPartition()
                obj._deserialize(item)
                self._Partitions.append(obj)
        self._Name = params.get("Name")
        self._DatasourceConnectionName = params.get("DatasourceConnectionName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AlterDMSTableResponse(AbstractModel):
    r"""AlterDMSTable返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AnalysisTaskResults(AbstractModel):
    r"""洞察分析结果返回体

    """

    def __init__(self):
        r"""
        :param _Id: 任务Id
        :type Id: str
        :param _InstanceStartTime: 任务创建时间，毫秒时间戳
        :type InstanceStartTime: int
        :param _InstanceCompleteTime: 任务结束时间，毫秒时间戳
        :type InstanceCompleteTime: int
        :param _State: 任务状态：0 初始化， 1 执行中， 2 执行成功，3 数据写入中，4 排队中。-1 执行失败，-3 已取消。
        :type State: int
        :param _SQL: 任务SQL语句
        :type SQL: str
        :param _DataEngineName: 计算资源名字
        :type DataEngineName: str
        :param _JobTimeSum: 单位毫秒，引擎内执行耗时, 反映真正用于计算所需的耗时，即从  Spark 任务第一个 Task  开始执行到任务结束之间的耗时。
具体的：会统计任务的每个 Spark Stage 第一个 Task 到最后一个 Task 完成时长之和，不包含任务开始的排队耗时（即剔除从任务提交到 Spark Task 开始执行之间的调度等其他耗时），也不包含任务执行过程中多个 Spark Stage 之间因 executor 资源不足而等待执行 Task 所消耗的时间。
        :type JobTimeSum: int
        :param _TaskTimeSum: 单位秒，累计 CPU* 秒 ( 累计 CPU * 时 = 累计 CPU* 秒/ 3600)，统计参与计算所用 Spark Executor 每个 core 的 CPU 执行时长总和
        :type TaskTimeSum: int
        :param _InputRecordsSum: 数据扫描总行数
        :type InputRecordsSum: int
        :param _InputBytesSum: 数据扫描总 bytes
        :type InputBytesSum: int
        :param _OutputRecordsSum: 输出总行数
        :type OutputRecordsSum: int
        :param _OutputBytesSum: 输出总 bytes
        :type OutputBytesSum: int
        :param _ShuffleReadBytesSum: shuffle read 总 bytes
        :type ShuffleReadBytesSum: int
        :param _ShuffleReadRecordsSum: shuffle read 总行数
        :type ShuffleReadRecordsSum: int
        :param _AnalysisStatus: 洞察结果类型分类，一个 json 数组，有如下几种类型：SPARK-StageScheduleDelay（资源抢占）, SPARK-ShuffleFailure（Shuffle异常）, SPARK-SlowTask（慢task）, SPARK-DataSkew（数据倾斜）, SPARK-InsufficientResource（磁盘或内存不足）
        :type AnalysisStatus: str
        :param _OutputFilesNum: 任务输出文件总数
        :type OutputFilesNum: int
        :param _OutputSmallFilesNum: 任务输出小文件总数
        :type OutputSmallFilesNum: int
        """
        self._Id = None
        self._InstanceStartTime = None
        self._InstanceCompleteTime = None
        self._State = None
        self._SQL = None
        self._DataEngineName = None
        self._JobTimeSum = None
        self._TaskTimeSum = None
        self._InputRecordsSum = None
        self._InputBytesSum = None
        self._OutputRecordsSum = None
        self._OutputBytesSum = None
        self._ShuffleReadBytesSum = None
        self._ShuffleReadRecordsSum = None
        self._AnalysisStatus = None
        self._OutputFilesNum = None
        self._OutputSmallFilesNum = None

    @property
    def Id(self):
        r"""任务Id
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def InstanceStartTime(self):
        r"""任务创建时间，毫秒时间戳
        :rtype: int
        """
        return self._InstanceStartTime

    @InstanceStartTime.setter
    def InstanceStartTime(self, InstanceStartTime):
        self._InstanceStartTime = InstanceStartTime

    @property
    def InstanceCompleteTime(self):
        r"""任务结束时间，毫秒时间戳
        :rtype: int
        """
        return self._InstanceCompleteTime

    @InstanceCompleteTime.setter
    def InstanceCompleteTime(self, InstanceCompleteTime):
        self._InstanceCompleteTime = InstanceCompleteTime

    @property
    def State(self):
        r"""任务状态：0 初始化， 1 执行中， 2 执行成功，3 数据写入中，4 排队中。-1 执行失败，-3 已取消。
        :rtype: int
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def SQL(self):
        r"""任务SQL语句
        :rtype: str
        """
        return self._SQL

    @SQL.setter
    def SQL(self, SQL):
        self._SQL = SQL

    @property
    def DataEngineName(self):
        r"""计算资源名字
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName

    @property
    def JobTimeSum(self):
        r"""单位毫秒，引擎内执行耗时, 反映真正用于计算所需的耗时，即从  Spark 任务第一个 Task  开始执行到任务结束之间的耗时。
具体的：会统计任务的每个 Spark Stage 第一个 Task 到最后一个 Task 完成时长之和，不包含任务开始的排队耗时（即剔除从任务提交到 Spark Task 开始执行之间的调度等其他耗时），也不包含任务执行过程中多个 Spark Stage 之间因 executor 资源不足而等待执行 Task 所消耗的时间。
        :rtype: int
        """
        return self._JobTimeSum

    @JobTimeSum.setter
    def JobTimeSum(self, JobTimeSum):
        self._JobTimeSum = JobTimeSum

    @property
    def TaskTimeSum(self):
        r"""单位秒，累计 CPU* 秒 ( 累计 CPU * 时 = 累计 CPU* 秒/ 3600)，统计参与计算所用 Spark Executor 每个 core 的 CPU 执行时长总和
        :rtype: int
        """
        return self._TaskTimeSum

    @TaskTimeSum.setter
    def TaskTimeSum(self, TaskTimeSum):
        self._TaskTimeSum = TaskTimeSum

    @property
    def InputRecordsSum(self):
        r"""数据扫描总行数
        :rtype: int
        """
        return self._InputRecordsSum

    @InputRecordsSum.setter
    def InputRecordsSum(self, InputRecordsSum):
        self._InputRecordsSum = InputRecordsSum

    @property
    def InputBytesSum(self):
        r"""数据扫描总 bytes
        :rtype: int
        """
        return self._InputBytesSum

    @InputBytesSum.setter
    def InputBytesSum(self, InputBytesSum):
        self._InputBytesSum = InputBytesSum

    @property
    def OutputRecordsSum(self):
        r"""输出总行数
        :rtype: int
        """
        return self._OutputRecordsSum

    @OutputRecordsSum.setter
    def OutputRecordsSum(self, OutputRecordsSum):
        self._OutputRecordsSum = OutputRecordsSum

    @property
    def OutputBytesSum(self):
        r"""输出总 bytes
        :rtype: int
        """
        return self._OutputBytesSum

    @OutputBytesSum.setter
    def OutputBytesSum(self, OutputBytesSum):
        self._OutputBytesSum = OutputBytesSum

    @property
    def ShuffleReadBytesSum(self):
        r"""shuffle read 总 bytes
        :rtype: int
        """
        return self._ShuffleReadBytesSum

    @ShuffleReadBytesSum.setter
    def ShuffleReadBytesSum(self, ShuffleReadBytesSum):
        self._ShuffleReadBytesSum = ShuffleReadBytesSum

    @property
    def ShuffleReadRecordsSum(self):
        r"""shuffle read 总行数
        :rtype: int
        """
        return self._ShuffleReadRecordsSum

    @ShuffleReadRecordsSum.setter
    def ShuffleReadRecordsSum(self, ShuffleReadRecordsSum):
        self._ShuffleReadRecordsSum = ShuffleReadRecordsSum

    @property
    def AnalysisStatus(self):
        r"""洞察结果类型分类，一个 json 数组，有如下几种类型：SPARK-StageScheduleDelay（资源抢占）, SPARK-ShuffleFailure（Shuffle异常）, SPARK-SlowTask（慢task）, SPARK-DataSkew（数据倾斜）, SPARK-InsufficientResource（磁盘或内存不足）
        :rtype: str
        """
        return self._AnalysisStatus

    @AnalysisStatus.setter
    def AnalysisStatus(self, AnalysisStatus):
        self._AnalysisStatus = AnalysisStatus

    @property
    def OutputFilesNum(self):
        r"""任务输出文件总数
        :rtype: int
        """
        return self._OutputFilesNum

    @OutputFilesNum.setter
    def OutputFilesNum(self, OutputFilesNum):
        self._OutputFilesNum = OutputFilesNum

    @property
    def OutputSmallFilesNum(self):
        r"""任务输出小文件总数
        :rtype: int
        """
        return self._OutputSmallFilesNum

    @OutputSmallFilesNum.setter
    def OutputSmallFilesNum(self, OutputSmallFilesNum):
        self._OutputSmallFilesNum = OutputSmallFilesNum


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._InstanceStartTime = params.get("InstanceStartTime")
        self._InstanceCompleteTime = params.get("InstanceCompleteTime")
        self._State = params.get("State")
        self._SQL = params.get("SQL")
        self._DataEngineName = params.get("DataEngineName")
        self._JobTimeSum = params.get("JobTimeSum")
        self._TaskTimeSum = params.get("TaskTimeSum")
        self._InputRecordsSum = params.get("InputRecordsSum")
        self._InputBytesSum = params.get("InputBytesSum")
        self._OutputRecordsSum = params.get("OutputRecordsSum")
        self._OutputBytesSum = params.get("OutputBytesSum")
        self._ShuffleReadBytesSum = params.get("ShuffleReadBytesSum")
        self._ShuffleReadRecordsSum = params.get("ShuffleReadRecordsSum")
        self._AnalysisStatus = params.get("AnalysisStatus")
        self._OutputFilesNum = params.get("OutputFilesNum")
        self._OutputSmallFilesNum = params.get("OutputSmallFilesNum")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Asset(AbstractModel):
    r"""元数据基本对象

    """

    def __init__(self):
        r"""
        :param _Id: 主键
注意：此字段可能返回 null，表示取不到有效值。
        :type Id: int
        :param _Name: 名称
注意：此字段可能返回 null，表示取不到有效值。
        :type Name: str
        :param _Guid: 对象GUID值
注意：此字段可能返回 null，表示取不到有效值。
        :type Guid: str
        :param _Catalog: 数据目录
注意：此字段可能返回 null，表示取不到有效值。
        :type Catalog: str
        :param _Description: 描述信息
        :type Description: str
        :param _Owner: 对象owner
        :type Owner: str
        :param _OwnerAccount: 对象owner账户
        :type OwnerAccount: str
        :param _PermValues: 权限
        :type PermValues: list of KVPair
        :param _Params: 附加属性
        :type Params: list of KVPair
        :param _BizParams: 附加业务属性
        :type BizParams: list of KVPair
        :param _DataVersion: 数据版本
        :type DataVersion: int
        :param _CreateTime: 创建时间
        :type CreateTime: str
        :param _ModifiedTime: 修改时间
        :type ModifiedTime: str
        :param _DatasourceId: 数据源主键
        :type DatasourceId: int
        """
        self._Id = None
        self._Name = None
        self._Guid = None
        self._Catalog = None
        self._Description = None
        self._Owner = None
        self._OwnerAccount = None
        self._PermValues = None
        self._Params = None
        self._BizParams = None
        self._DataVersion = None
        self._CreateTime = None
        self._ModifiedTime = None
        self._DatasourceId = None

    @property
    def Id(self):
        r"""主键
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Name(self):
        r"""名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Guid(self):
        r"""对象GUID值
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Guid

    @Guid.setter
    def Guid(self, Guid):
        self._Guid = Guid

    @property
    def Catalog(self):
        r"""数据目录
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Catalog

    @Catalog.setter
    def Catalog(self, Catalog):
        self._Catalog = Catalog

    @property
    def Description(self):
        r"""描述信息
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Owner(self):
        r"""对象owner
        :rtype: str
        """
        return self._Owner

    @Owner.setter
    def Owner(self, Owner):
        self._Owner = Owner

    @property
    def OwnerAccount(self):
        r"""对象owner账户
        :rtype: str
        """
        return self._OwnerAccount

    @OwnerAccount.setter
    def OwnerAccount(self, OwnerAccount):
        self._OwnerAccount = OwnerAccount

    @property
    def PermValues(self):
        r"""权限
        :rtype: list of KVPair
        """
        return self._PermValues

    @PermValues.setter
    def PermValues(self, PermValues):
        self._PermValues = PermValues

    @property
    def Params(self):
        r"""附加属性
        :rtype: list of KVPair
        """
        return self._Params

    @Params.setter
    def Params(self, Params):
        self._Params = Params

    @property
    def BizParams(self):
        r"""附加业务属性
        :rtype: list of KVPair
        """
        return self._BizParams

    @BizParams.setter
    def BizParams(self, BizParams):
        self._BizParams = BizParams

    @property
    def DataVersion(self):
        r"""数据版本
        :rtype: int
        """
        return self._DataVersion

    @DataVersion.setter
    def DataVersion(self, DataVersion):
        self._DataVersion = DataVersion

    @property
    def CreateTime(self):
        r"""创建时间
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ModifiedTime(self):
        r"""修改时间
        :rtype: str
        """
        return self._ModifiedTime

    @ModifiedTime.setter
    def ModifiedTime(self, ModifiedTime):
        self._ModifiedTime = ModifiedTime

    @property
    def DatasourceId(self):
        r"""数据源主键
        :rtype: int
        """
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Name = params.get("Name")
        self._Guid = params.get("Guid")
        self._Catalog = params.get("Catalog")
        self._Description = params.get("Description")
        self._Owner = params.get("Owner")
        self._OwnerAccount = params.get("OwnerAccount")
        if params.get("PermValues") is not None:
            self._PermValues = []
            for item in params.get("PermValues"):
                obj = KVPair()
                obj._deserialize(item)
                self._PermValues.append(obj)
        if params.get("Params") is not None:
            self._Params = []
            for item in params.get("Params"):
                obj = KVPair()
                obj._deserialize(item)
                self._Params.append(obj)
        if params.get("BizParams") is not None:
            self._BizParams = []
            for item in params.get("BizParams"):
                obj = KVPair()
                obj._deserialize(item)
                self._BizParams.append(obj)
        self._DataVersion = params.get("DataVersion")
        self._CreateTime = params.get("CreateTime")
        self._ModifiedTime = params.get("ModifiedTime")
        self._DatasourceId = params.get("DatasourceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssignMangedTablePropertiesRequest(AbstractModel):
    r"""AssignMangedTableProperties请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TableBaseInfo: 表基本信息
        :type TableBaseInfo: :class:`tencentcloud.dlc.v20210125.models.TableBaseInfo`
        :param _Columns: 表字段信息
        :type Columns: list of TColumn
        :param _Partitions: 表分区信息
        :type Partitions: list of TPartition
        :param _Properties: 表属性信息
        :type Properties: list of Property
        :param _UpsertKeys: V2 upsert表 upsert键
        :type UpsertKeys: list of str
        """
        self._TableBaseInfo = None
        self._Columns = None
        self._Partitions = None
        self._Properties = None
        self._UpsertKeys = None

    @property
    def TableBaseInfo(self):
        r"""表基本信息
        :rtype: :class:`tencentcloud.dlc.v20210125.models.TableBaseInfo`
        """
        return self._TableBaseInfo

    @TableBaseInfo.setter
    def TableBaseInfo(self, TableBaseInfo):
        self._TableBaseInfo = TableBaseInfo

    @property
    def Columns(self):
        r"""表字段信息
        :rtype: list of TColumn
        """
        return self._Columns

    @Columns.setter
    def Columns(self, Columns):
        self._Columns = Columns

    @property
    def Partitions(self):
        r"""表分区信息
        :rtype: list of TPartition
        """
        return self._Partitions

    @Partitions.setter
    def Partitions(self, Partitions):
        self._Partitions = Partitions

    @property
    def Properties(self):
        r"""表属性信息
        :rtype: list of Property
        """
        return self._Properties

    @Properties.setter
    def Properties(self, Properties):
        self._Properties = Properties

    @property
    def UpsertKeys(self):
        r"""V2 upsert表 upsert键
        :rtype: list of str
        """
        return self._UpsertKeys

    @UpsertKeys.setter
    def UpsertKeys(self, UpsertKeys):
        self._UpsertKeys = UpsertKeys


    def _deserialize(self, params):
        if params.get("TableBaseInfo") is not None:
            self._TableBaseInfo = TableBaseInfo()
            self._TableBaseInfo._deserialize(params.get("TableBaseInfo"))
        if params.get("Columns") is not None:
            self._Columns = []
            for item in params.get("Columns"):
                obj = TColumn()
                obj._deserialize(item)
                self._Columns.append(obj)
        if params.get("Partitions") is not None:
            self._Partitions = []
            for item in params.get("Partitions"):
                obj = TPartition()
                obj._deserialize(item)
                self._Partitions.append(obj)
        if params.get("Properties") is not None:
            self._Properties = []
            for item in params.get("Properties"):
                obj = Property()
                obj._deserialize(item)
                self._Properties.append(obj)
        self._UpsertKeys = params.get("UpsertKeys")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssignMangedTablePropertiesResponse(AbstractModel):
    r"""AssignMangedTableProperties返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Properties: 分配的原生表表属性
        :type Properties: list of Property
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Properties = None
        self._RequestId = None

    @property
    def Properties(self):
        r"""分配的原生表表属性
        :rtype: list of Property
        """
        return self._Properties

    @Properties.setter
    def Properties(self, Properties):
        self._Properties = Properties

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Properties") is not None:
            self._Properties = []
            for item in params.get("Properties"):
                obj = Property()
                obj._deserialize(item)
                self._Properties.append(obj)
        self._RequestId = params.get("RequestId")


class AssociateDatasourceHouseRequest(AbstractModel):
    r"""AssociateDatasourceHouse请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DatasourceConnectionName: 网络配置名称
        :type DatasourceConnectionName: str
        :param _DatasourceConnectionType: 数据源类型
        :type DatasourceConnectionType: str
        :param _DatasourceConnectionConfig: 数据源网络配置
        :type DatasourceConnectionConfig: :class:`tencentcloud.dlc.v20210125.models.DatasourceConnectionConfig`
        :param _DataEngineNames: 引擎名称，只允许绑定一个引擎
        :type DataEngineNames: list of str
        :param _NetworkConnectionType: 网络类型，2-跨源型，4-增强型
        :type NetworkConnectionType: int
        :param _NetworkConnectionDesc: 网络配置描述
        :type NetworkConnectionDesc: str
        """
        self._DatasourceConnectionName = None
        self._DatasourceConnectionType = None
        self._DatasourceConnectionConfig = None
        self._DataEngineNames = None
        self._NetworkConnectionType = None
        self._NetworkConnectionDesc = None

    @property
    def DatasourceConnectionName(self):
        r"""网络配置名称
        :rtype: str
        """
        return self._DatasourceConnectionName

    @DatasourceConnectionName.setter
    def DatasourceConnectionName(self, DatasourceConnectionName):
        self._DatasourceConnectionName = DatasourceConnectionName

    @property
    def DatasourceConnectionType(self):
        r"""数据源类型
        :rtype: str
        """
        return self._DatasourceConnectionType

    @DatasourceConnectionType.setter
    def DatasourceConnectionType(self, DatasourceConnectionType):
        self._DatasourceConnectionType = DatasourceConnectionType

    @property
    def DatasourceConnectionConfig(self):
        r"""数据源网络配置
        :rtype: :class:`tencentcloud.dlc.v20210125.models.DatasourceConnectionConfig`
        """
        return self._DatasourceConnectionConfig

    @DatasourceConnectionConfig.setter
    def DatasourceConnectionConfig(self, DatasourceConnectionConfig):
        self._DatasourceConnectionConfig = DatasourceConnectionConfig

    @property
    def DataEngineNames(self):
        r"""引擎名称，只允许绑定一个引擎
        :rtype: list of str
        """
        return self._DataEngineNames

    @DataEngineNames.setter
    def DataEngineNames(self, DataEngineNames):
        self._DataEngineNames = DataEngineNames

    @property
    def NetworkConnectionType(self):
        r"""网络类型，2-跨源型，4-增强型
        :rtype: int
        """
        return self._NetworkConnectionType

    @NetworkConnectionType.setter
    def NetworkConnectionType(self, NetworkConnectionType):
        self._NetworkConnectionType = NetworkConnectionType

    @property
    def NetworkConnectionDesc(self):
        r"""网络配置描述
        :rtype: str
        """
        return self._NetworkConnectionDesc

    @NetworkConnectionDesc.setter
    def NetworkConnectionDesc(self, NetworkConnectionDesc):
        self._NetworkConnectionDesc = NetworkConnectionDesc


    def _deserialize(self, params):
        self._DatasourceConnectionName = params.get("DatasourceConnectionName")
        self._DatasourceConnectionType = params.get("DatasourceConnectionType")
        if params.get("DatasourceConnectionConfig") is not None:
            self._DatasourceConnectionConfig = DatasourceConnectionConfig()
            self._DatasourceConnectionConfig._deserialize(params.get("DatasourceConnectionConfig"))
        self._DataEngineNames = params.get("DataEngineNames")
        self._NetworkConnectionType = params.get("NetworkConnectionType")
        self._NetworkConnectionDesc = params.get("NetworkConnectionDesc")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssociateDatasourceHouseResponse(AbstractModel):
    r"""AssociateDatasourceHouse返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AttachDataMaskPolicyRequest(AbstractModel):
    r"""AttachDataMaskPolicy请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DataMaskStrategyPolicySet: 要绑定的数据脱敏策略权限对象集合
        :type DataMaskStrategyPolicySet: list of DataMaskStrategyPolicy
        """
        self._DataMaskStrategyPolicySet = None

    @property
    def DataMaskStrategyPolicySet(self):
        r"""要绑定的数据脱敏策略权限对象集合
        :rtype: list of DataMaskStrategyPolicy
        """
        return self._DataMaskStrategyPolicySet

    @DataMaskStrategyPolicySet.setter
    def DataMaskStrategyPolicySet(self, DataMaskStrategyPolicySet):
        self._DataMaskStrategyPolicySet = DataMaskStrategyPolicySet


    def _deserialize(self, params):
        if params.get("DataMaskStrategyPolicySet") is not None:
            self._DataMaskStrategyPolicySet = []
            for item in params.get("DataMaskStrategyPolicySet"):
                obj = DataMaskStrategyPolicy()
                obj._deserialize(item)
                self._DataMaskStrategyPolicySet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AttachDataMaskPolicyResponse(AbstractModel):
    r"""AttachDataMaskPolicy返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AttachUserPolicyRequest(AbstractModel):
    r"""AttachUserPolicy请求参数结构体

    """

    def __init__(self):
        r"""
        :param _UserId: 用户Id，和子用户uin相同，需要先使用CreateUser接口创建用户。可以使用DescribeUsers接口查看。
        :type UserId: str
        :param _PolicySet: 鉴权策略集合
        :type PolicySet: list of Policy
        :param _AccountType: 用户来源类型TencentAccount（普通腾讯云用户） / EntraAccount（微软用户）
        :type AccountType: str
        """
        self._UserId = None
        self._PolicySet = None
        self._AccountType = None

    @property
    def UserId(self):
        r"""用户Id，和子用户uin相同，需要先使用CreateUser接口创建用户。可以使用DescribeUsers接口查看。
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def PolicySet(self):
        r"""鉴权策略集合
        :rtype: list of Policy
        """
        return self._PolicySet

    @PolicySet.setter
    def PolicySet(self, PolicySet):
        self._PolicySet = PolicySet

    @property
    def AccountType(self):
        r"""用户来源类型TencentAccount（普通腾讯云用户） / EntraAccount（微软用户）
        :rtype: str
        """
        return self._AccountType

    @AccountType.setter
    def AccountType(self, AccountType):
        self._AccountType = AccountType


    def _deserialize(self, params):
        self._UserId = params.get("UserId")
        if params.get("PolicySet") is not None:
            self._PolicySet = []
            for item in params.get("PolicySet"):
                obj = Policy()
                obj._deserialize(item)
                self._PolicySet.append(obj)
        self._AccountType = params.get("AccountType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AttachUserPolicyResponse(AbstractModel):
    r"""AttachUserPolicy返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AttachWorkGroupPolicyRequest(AbstractModel):
    r"""AttachWorkGroupPolicy请求参数结构体

    """

    def __init__(self):
        r"""
        :param _WorkGroupId: 工作组Id
        :type WorkGroupId: int
        :param _PolicySet: 要绑定的策略集合
        :type PolicySet: list of Policy
        """
        self._WorkGroupId = None
        self._PolicySet = None

    @property
    def WorkGroupId(self):
        r"""工作组Id
        :rtype: int
        """
        return self._WorkGroupId

    @WorkGroupId.setter
    def WorkGroupId(self, WorkGroupId):
        self._WorkGroupId = WorkGroupId

    @property
    def PolicySet(self):
        r"""要绑定的策略集合
        :rtype: list of Policy
        """
        return self._PolicySet

    @PolicySet.setter
    def PolicySet(self, PolicySet):
        self._PolicySet = PolicySet


    def _deserialize(self, params):
        self._WorkGroupId = params.get("WorkGroupId")
        if params.get("PolicySet") is not None:
            self._PolicySet = []
            for item in params.get("PolicySet"):
                obj = Policy()
                obj._deserialize(item)
                self._PolicySet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AttachWorkGroupPolicyResponse(AbstractModel):
    r"""AttachWorkGroupPolicy返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class BatchSQLCostInfo(AbstractModel):
    r"""spark session batch SQL的消耗信息

    """

    def __init__(self):
        r"""
        :param _BatchId: 任务id
        :type BatchId: str
        :param _DataEngineName: 引擎名称
        :type DataEngineName: str
        :param _DataEngineId: 引擎id
        :type DataEngineId: str
        :param _Cost: 本次消耗，单位cu
        :type Cost: float
        :param _TimeCost: 时间开销，秒
        :type TimeCost: int
        :param _Operator: 操作者
        :type Operator: str
        """
        self._BatchId = None
        self._DataEngineName = None
        self._DataEngineId = None
        self._Cost = None
        self._TimeCost = None
        self._Operator = None

    @property
    def BatchId(self):
        r"""任务id
        :rtype: str
        """
        return self._BatchId

    @BatchId.setter
    def BatchId(self, BatchId):
        self._BatchId = BatchId

    @property
    def DataEngineName(self):
        r"""引擎名称
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName

    @property
    def DataEngineId(self):
        r"""引擎id
        :rtype: str
        """
        return self._DataEngineId

    @DataEngineId.setter
    def DataEngineId(self, DataEngineId):
        self._DataEngineId = DataEngineId

    @property
    def Cost(self):
        r"""本次消耗，单位cu
        :rtype: float
        """
        return self._Cost

    @Cost.setter
    def Cost(self, Cost):
        self._Cost = Cost

    @property
    def TimeCost(self):
        r"""时间开销，秒
        :rtype: int
        """
        return self._TimeCost

    @TimeCost.setter
    def TimeCost(self, TimeCost):
        self._TimeCost = TimeCost

    @property
    def Operator(self):
        r"""操作者
        :rtype: str
        """
        return self._Operator

    @Operator.setter
    def Operator(self, Operator):
        self._Operator = Operator


    def _deserialize(self, params):
        self._BatchId = params.get("BatchId")
        self._DataEngineName = params.get("DataEngineName")
        self._DataEngineId = params.get("DataEngineId")
        self._Cost = params.get("Cost")
        self._TimeCost = params.get("TimeCost")
        self._Operator = params.get("Operator")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchSqlTask(AbstractModel):
    r"""SparkSQL批任务信息

    """

    def __init__(self):
        r"""
        :param _TaskId: SQL子任务唯一标识
        :type TaskId: str
        :param _ExecuteSQL: 运行SQL
        :type ExecuteSQL: str
        :param _Message: 任务信息，成功则返回：Task Success!，失败则返回异常信息
        :type Message: str
        """
        self._TaskId = None
        self._ExecuteSQL = None
        self._Message = None

    @property
    def TaskId(self):
        r"""SQL子任务唯一标识
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ExecuteSQL(self):
        r"""运行SQL
        :rtype: str
        """
        return self._ExecuteSQL

    @ExecuteSQL.setter
    def ExecuteSQL(self, ExecuteSQL):
        self._ExecuteSQL = ExecuteSQL

    @property
    def Message(self):
        r"""任务信息，成功则返回：Task Success!，失败则返回异常信息
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ExecuteSQL = params.get("ExecuteSQL")
        self._Message = params.get("Message")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BindWorkGroupsToUserRequest(AbstractModel):
    r"""BindWorkGroupsToUser请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AddInfo: 绑定的用户和工作组信息
        :type AddInfo: :class:`tencentcloud.dlc.v20210125.models.WorkGroupIdSetOfUserId`
        """
        self._AddInfo = None

    @property
    def AddInfo(self):
        r"""绑定的用户和工作组信息
        :rtype: :class:`tencentcloud.dlc.v20210125.models.WorkGroupIdSetOfUserId`
        """
        return self._AddInfo

    @AddInfo.setter
    def AddInfo(self, AddInfo):
        self._AddInfo = AddInfo


    def _deserialize(self, params):
        if params.get("AddInfo") is not None:
            self._AddInfo = WorkGroupIdSetOfUserId()
            self._AddInfo._deserialize(params.get("AddInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BindWorkGroupsToUserResponse(AbstractModel):
    r"""BindWorkGroupsToUser返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CHDFSProductVpcInfo(AbstractModel):
    r"""chdfs产品vpc信息

    """

    def __init__(self):
        r"""
        :param _VpcId: vpc id

        :type VpcId: str
        :param _VpcName: vpc名称
        :type VpcName: str
        :param _VpcCidrBlock: vpc子网信息列表
        :type VpcCidrBlock: list of VpcCidrBlock
        :param _RuleId: 规则Id
        :type RuleId: int
        :param _AccessGroupId: 权限组Id
        :type AccessGroupId: str
        """
        self._VpcId = None
        self._VpcName = None
        self._VpcCidrBlock = None
        self._RuleId = None
        self._AccessGroupId = None

    @property
    def VpcId(self):
        r"""vpc id

        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def VpcName(self):
        r"""vpc名称
        :rtype: str
        """
        return self._VpcName

    @VpcName.setter
    def VpcName(self, VpcName):
        self._VpcName = VpcName

    @property
    def VpcCidrBlock(self):
        r"""vpc子网信息列表
        :rtype: list of VpcCidrBlock
        """
        return self._VpcCidrBlock

    @VpcCidrBlock.setter
    def VpcCidrBlock(self, VpcCidrBlock):
        self._VpcCidrBlock = VpcCidrBlock

    @property
    def RuleId(self):
        r"""规则Id
        :rtype: int
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def AccessGroupId(self):
        r"""权限组Id
        :rtype: str
        """
        return self._AccessGroupId

    @AccessGroupId.setter
    def AccessGroupId(self, AccessGroupId):
        self._AccessGroupId = AccessGroupId


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._VpcName = params.get("VpcName")
        if params.get("VpcCidrBlock") is not None:
            self._VpcCidrBlock = []
            for item in params.get("VpcCidrBlock"):
                obj = VpcCidrBlock()
                obj._deserialize(item)
                self._VpcCidrBlock.append(obj)
        self._RuleId = params.get("RuleId")
        self._AccessGroupId = params.get("AccessGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CSV(AbstractModel):
    r"""CSV类型数据格式

    """

    def __init__(self):
        r"""
        :param _CodeCompress: 压缩格式，["Snappy", "Gzip", "None"选一]。
        :type CodeCompress: str
        :param _CSVSerde: CSV序列化及反序列化数据结构。
        :type CSVSerde: :class:`tencentcloud.dlc.v20210125.models.CSVSerde`
        :param _HeadLines: 标题行，默认为0。
        :type HeadLines: int
        :param _Format: 格式，默认值为CSV
        :type Format: str
        """
        self._CodeCompress = None
        self._CSVSerde = None
        self._HeadLines = None
        self._Format = None

    @property
    def CodeCompress(self):
        r"""压缩格式，["Snappy", "Gzip", "None"选一]。
        :rtype: str
        """
        return self._CodeCompress

    @CodeCompress.setter
    def CodeCompress(self, CodeCompress):
        self._CodeCompress = CodeCompress

    @property
    def CSVSerde(self):
        r"""CSV序列化及反序列化数据结构。
        :rtype: :class:`tencentcloud.dlc.v20210125.models.CSVSerde`
        """
        return self._CSVSerde

    @CSVSerde.setter
    def CSVSerde(self, CSVSerde):
        self._CSVSerde = CSVSerde

    @property
    def HeadLines(self):
        r"""标题行，默认为0。
        :rtype: int
        """
        return self._HeadLines

    @HeadLines.setter
    def HeadLines(self, HeadLines):
        self._HeadLines = HeadLines

    @property
    def Format(self):
        r"""格式，默认值为CSV
        :rtype: str
        """
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format


    def _deserialize(self, params):
        self._CodeCompress = params.get("CodeCompress")
        if params.get("CSVSerde") is not None:
            self._CSVSerde = CSVSerde()
            self._CSVSerde._deserialize(params.get("CSVSerde"))
        self._HeadLines = params.get("HeadLines")
        self._Format = params.get("Format")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CSVSerde(AbstractModel):
    r"""CSV序列化及反序列化数据结构

    """

    def __init__(self):
        r"""
        :param _Escape: CSV序列化转义符，默认为"\\"，最长8个字符，如 Escape: "/\"
        :type Escape: str
        :param _Quote: CSV序列化字段域符，默认为"'"，最长8个字符, 如 Quote: "\""
        :type Quote: str
        :param _Separator: CSV序列化分隔符，默认为"\t"，最长8个字符, 如 Separator: "\t"
        :type Separator: str
        """
        self._Escape = None
        self._Quote = None
        self._Separator = None

    @property
    def Escape(self):
        r"""CSV序列化转义符，默认为"\\"，最长8个字符，如 Escape: "/\"
        :rtype: str
        """
        return self._Escape

    @Escape.setter
    def Escape(self, Escape):
        self._Escape = Escape

    @property
    def Quote(self):
        r"""CSV序列化字段域符，默认为"'"，最长8个字符, 如 Quote: "\""
        :rtype: str
        """
        return self._Quote

    @Quote.setter
    def Quote(self, Quote):
        self._Quote = Quote

    @property
    def Separator(self):
        r"""CSV序列化分隔符，默认为"\t"，最长8个字符, 如 Separator: "\t"
        :rtype: str
        """
        return self._Separator

    @Separator.setter
    def Separator(self, Separator):
        self._Separator = Separator


    def _deserialize(self, params):
        self._Escape = params.get("Escape")
        self._Quote = params.get("Quote")
        self._Separator = params.get("Separator")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CancelNotebookSessionStatementBatchRequest(AbstractModel):
    r"""CancelNotebookSessionStatementBatch请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SessionId: Session唯一标识
        :type SessionId: str
        :param _BatchId: 批任务唯一标识
        :type BatchId: str
        """
        self._SessionId = None
        self._BatchId = None

    @property
    def SessionId(self):
        r"""Session唯一标识
        :rtype: str
        """
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def BatchId(self):
        r"""批任务唯一标识
        :rtype: str
        """
        return self._BatchId

    @BatchId.setter
    def BatchId(self, BatchId):
        self._BatchId = BatchId


    def _deserialize(self, params):
        self._SessionId = params.get("SessionId")
        self._BatchId = params.get("BatchId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CancelNotebookSessionStatementBatchResponse(AbstractModel):
    r"""CancelNotebookSessionStatementBatch返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CancelNotebookSessionStatementRequest(AbstractModel):
    r"""CancelNotebookSessionStatement请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SessionId: Session唯一标识
        :type SessionId: str
        :param _StatementId: Session Statement唯一标识
        :type StatementId: str
        """
        self._SessionId = None
        self._StatementId = None

    @property
    def SessionId(self):
        r"""Session唯一标识
        :rtype: str
        """
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def StatementId(self):
        r"""Session Statement唯一标识
        :rtype: str
        """
        return self._StatementId

    @StatementId.setter
    def StatementId(self, StatementId):
        self._StatementId = StatementId


    def _deserialize(self, params):
        self._SessionId = params.get("SessionId")
        self._StatementId = params.get("StatementId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CancelNotebookSessionStatementResponse(AbstractModel):
    r"""CancelNotebookSessionStatement返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CancelSparkSessionBatchSQLRequest(AbstractModel):
    r"""CancelSparkSessionBatchSQL请求参数结构体

    """

    def __init__(self):
        r"""
        :param _BatchId: 批任务唯一标识
        :type BatchId: str
        :param _CustomKey: 用户自定义主键，若不为空，则使用该值进行查询
        :type CustomKey: str
        """
        self._BatchId = None
        self._CustomKey = None

    @property
    def BatchId(self):
        r"""批任务唯一标识
        :rtype: str
        """
        return self._BatchId

    @BatchId.setter
    def BatchId(self, BatchId):
        self._BatchId = BatchId

    @property
    def CustomKey(self):
        r"""用户自定义主键，若不为空，则使用该值进行查询
        :rtype: str
        """
        return self._CustomKey

    @CustomKey.setter
    def CustomKey(self, CustomKey):
        self._CustomKey = CustomKey


    def _deserialize(self, params):
        self._BatchId = params.get("BatchId")
        self._CustomKey = params.get("CustomKey")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CancelSparkSessionBatchSQLResponse(AbstractModel):
    r"""CancelSparkSessionBatchSQL返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CancelTaskRequest(AbstractModel):
    r"""CancelTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务Id，全局唯一
        :type TaskId: str
        """
        self._TaskId = None

    @property
    def TaskId(self):
        r"""任务Id，全局唯一
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CancelTaskResponse(AbstractModel):
    r"""CancelTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CancelTasksRequest(AbstractModel):
    r"""CancelTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务Id数组，全局唯一
        :type TaskId: list of str
        :param _Config: 配置信息，key-value数组，对外不可见。key1：AuthorityRole（鉴权角色，默认传SubUin，base64加密，仅在jdbc提交任务时使用）
        :type Config: list of KVPair
        """
        self._TaskId = None
        self._Config = None

    @property
    def TaskId(self):
        r"""任务Id数组，全局唯一
        :rtype: list of str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Config(self):
        r"""配置信息，key-value数组，对外不可见。key1：AuthorityRole（鉴权角色，默认传SubUin，base64加密，仅在jdbc提交任务时使用）
        :rtype: list of KVPair
        """
        return self._Config

    @Config.setter
    def Config(self, Config):
        self._Config = Config


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        if params.get("Config") is not None:
            self._Config = []
            for item in params.get("Config"):
                obj = KVPair()
                obj._deserialize(item)
                self._Config.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CancelTasksResponse(AbstractModel):
    r"""CancelTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CheckDataEngineConfigPairsValidityRequest(AbstractModel):
    r"""CheckDataEngineConfigPairsValidity请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ChildImageVersionId: 引擎小版本ID
        :type ChildImageVersionId: str
        :param _DataEngineConfigPairs: 用户自定义参数
        :type DataEngineConfigPairs: list of DataEngineConfigPair
        :param _ImageVersionId: 引擎大版本ID，存在小版本ID时仅需传入小版本ID，不存在时会获取当前大版本下最新的小版本ID。
        :type ImageVersionId: str
        """
        self._ChildImageVersionId = None
        self._DataEngineConfigPairs = None
        self._ImageVersionId = None

    @property
    def ChildImageVersionId(self):
        r"""引擎小版本ID
        :rtype: str
        """
        return self._ChildImageVersionId

    @ChildImageVersionId.setter
    def ChildImageVersionId(self, ChildImageVersionId):
        self._ChildImageVersionId = ChildImageVersionId

    @property
    def DataEngineConfigPairs(self):
        r"""用户自定义参数
        :rtype: list of DataEngineConfigPair
        """
        return self._DataEngineConfigPairs

    @DataEngineConfigPairs.setter
    def DataEngineConfigPairs(self, DataEngineConfigPairs):
        self._DataEngineConfigPairs = DataEngineConfigPairs

    @property
    def ImageVersionId(self):
        r"""引擎大版本ID，存在小版本ID时仅需传入小版本ID，不存在时会获取当前大版本下最新的小版本ID。
        :rtype: str
        """
        return self._ImageVersionId

    @ImageVersionId.setter
    def ImageVersionId(self, ImageVersionId):
        self._ImageVersionId = ImageVersionId


    def _deserialize(self, params):
        self._ChildImageVersionId = params.get("ChildImageVersionId")
        if params.get("DataEngineConfigPairs") is not None:
            self._DataEngineConfigPairs = []
            for item in params.get("DataEngineConfigPairs"):
                obj = DataEngineConfigPair()
                obj._deserialize(item)
                self._DataEngineConfigPairs.append(obj)
        self._ImageVersionId = params.get("ImageVersionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckDataEngineConfigPairsValidityResponse(AbstractModel):
    r"""CheckDataEngineConfigPairsValidity返回参数结构体

    """

    def __init__(self):
        r"""
        :param _IsAvailable: 参数有效性：ture:有效，false:至少存在一个无效参数；
        :type IsAvailable: bool
        :param _UnavailableConfig: 无效参数集合
        :type UnavailableConfig: list of str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._IsAvailable = None
        self._UnavailableConfig = None
        self._RequestId = None

    @property
    def IsAvailable(self):
        r"""参数有效性：ture:有效，false:至少存在一个无效参数；
        :rtype: bool
        """
        return self._IsAvailable

    @IsAvailable.setter
    def IsAvailable(self, IsAvailable):
        self._IsAvailable = IsAvailable

    @property
    def UnavailableConfig(self):
        r"""无效参数集合
        :rtype: list of str
        """
        return self._UnavailableConfig

    @UnavailableConfig.setter
    def UnavailableConfig(self, UnavailableConfig):
        self._UnavailableConfig = UnavailableConfig

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._IsAvailable = params.get("IsAvailable")
        self._UnavailableConfig = params.get("UnavailableConfig")
        self._RequestId = params.get("RequestId")


class CheckDataEngineImageCanBeRollbackRequest(AbstractModel):
    r"""CheckDataEngineImageCanBeRollback请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DataEngineId: 引擎唯一id
        :type DataEngineId: str
        """
        self._DataEngineId = None

    @property
    def DataEngineId(self):
        r"""引擎唯一id
        :rtype: str
        """
        return self._DataEngineId

    @DataEngineId.setter
    def DataEngineId(self, DataEngineId):
        self._DataEngineId = DataEngineId


    def _deserialize(self, params):
        self._DataEngineId = params.get("DataEngineId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckDataEngineImageCanBeRollbackResponse(AbstractModel):
    r"""CheckDataEngineImageCanBeRollback返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ToRecordId: 回滚后日志记录id
        :type ToRecordId: str
        :param _FromRecordId: 回滚前日志记录id
        :type FromRecordId: str
        :param _IsRollback: 是否能够回滚
        :type IsRollback: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ToRecordId = None
        self._FromRecordId = None
        self._IsRollback = None
        self._RequestId = None

    @property
    def ToRecordId(self):
        r"""回滚后日志记录id
        :rtype: str
        """
        return self._ToRecordId

    @ToRecordId.setter
    def ToRecordId(self, ToRecordId):
        self._ToRecordId = ToRecordId

    @property
    def FromRecordId(self):
        r"""回滚前日志记录id
        :rtype: str
        """
        return self._FromRecordId

    @FromRecordId.setter
    def FromRecordId(self, FromRecordId):
        self._FromRecordId = FromRecordId

    @property
    def IsRollback(self):
        r"""是否能够回滚
        :rtype: bool
        """
        return self._IsRollback

    @IsRollback.setter
    def IsRollback(self, IsRollback):
        self._IsRollback = IsRollback

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ToRecordId = params.get("ToRecordId")
        self._FromRecordId = params.get("FromRecordId")
        self._IsRollback = params.get("IsRollback")
        self._RequestId = params.get("RequestId")


class CheckDataEngineImageCanBeUpgradeRequest(AbstractModel):
    r"""CheckDataEngineImageCanBeUpgrade请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DataEngineId: 集群id
        :type DataEngineId: str
        """
        self._DataEngineId = None

    @property
    def DataEngineId(self):
        r"""集群id
        :rtype: str
        """
        return self._DataEngineId

    @DataEngineId.setter
    def DataEngineId(self, DataEngineId):
        self._DataEngineId = DataEngineId


    def _deserialize(self, params):
        self._DataEngineId = params.get("DataEngineId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckDataEngineImageCanBeUpgradeResponse(AbstractModel):
    r"""CheckDataEngineImageCanBeUpgrade返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ChildImageVersionId: 当前大版本下，可升级的集群镜像小版本id
        :type ChildImageVersionId: str
        :param _IsUpgrade: 是否能够升级
        :type IsUpgrade: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ChildImageVersionId = None
        self._IsUpgrade = None
        self._RequestId = None

    @property
    def ChildImageVersionId(self):
        r"""当前大版本下，可升级的集群镜像小版本id
        :rtype: str
        """
        return self._ChildImageVersionId

    @ChildImageVersionId.setter
    def ChildImageVersionId(self, ChildImageVersionId):
        self._ChildImageVersionId = ChildImageVersionId

    @property
    def IsUpgrade(self):
        r"""是否能够升级
        :rtype: bool
        """
        return self._IsUpgrade

    @IsUpgrade.setter
    def IsUpgrade(self, IsUpgrade):
        self._IsUpgrade = IsUpgrade

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ChildImageVersionId = params.get("ChildImageVersionId")
        self._IsUpgrade = params.get("IsUpgrade")
        self._RequestId = params.get("RequestId")


class CheckLockMetaDataRequest(AbstractModel):
    r"""CheckLockMetaData请求参数结构体

    """

    def __init__(self):
        r"""
        :param _LockId: 锁ID
        :type LockId: int
        :param _DatasourceConnectionName: 数据源名称
        :type DatasourceConnectionName: str
        :param _TxnId: 事务ID
        :type TxnId: int
        :param _ElapsedMs: 过期时间ms
        :type ElapsedMs: int
        """
        self._LockId = None
        self._DatasourceConnectionName = None
        self._TxnId = None
        self._ElapsedMs = None

    @property
    def LockId(self):
        r"""锁ID
        :rtype: int
        """
        return self._LockId

    @LockId.setter
    def LockId(self, LockId):
        self._LockId = LockId

    @property
    def DatasourceConnectionName(self):
        r"""数据源名称
        :rtype: str
        """
        return self._DatasourceConnectionName

    @DatasourceConnectionName.setter
    def DatasourceConnectionName(self, DatasourceConnectionName):
        self._DatasourceConnectionName = DatasourceConnectionName

    @property
    def TxnId(self):
        r"""事务ID
        :rtype: int
        """
        return self._TxnId

    @TxnId.setter
    def TxnId(self, TxnId):
        self._TxnId = TxnId

    @property
    def ElapsedMs(self):
        r"""过期时间ms
        :rtype: int
        """
        return self._ElapsedMs

    @ElapsedMs.setter
    def ElapsedMs(self, ElapsedMs):
        self._ElapsedMs = ElapsedMs


    def _deserialize(self, params):
        self._LockId = params.get("LockId")
        self._DatasourceConnectionName = params.get("DatasourceConnectionName")
        self._TxnId = params.get("TxnId")
        self._ElapsedMs = params.get("ElapsedMs")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckLockMetaDataResponse(AbstractModel):
    r"""CheckLockMetaData返回参数结构体

    """

    def __init__(self):
        r"""
        :param _LockId: 锁ID
        :type LockId: int
        :param _LockState: 锁状态：ACQUIRED、WAITING、ABORT、NOT_ACQUIRED
        :type LockState: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._LockId = None
        self._LockState = None
        self._RequestId = None

    @property
    def LockId(self):
        r"""锁ID
        :rtype: int
        """
        return self._LockId

    @LockId.setter
    def LockId(self, LockId):
        self._LockId = LockId

    @property
    def LockState(self):
        r"""锁状态：ACQUIRED、WAITING、ABORT、NOT_ACQUIRED
        :rtype: str
        """
        return self._LockState

    @LockState.setter
    def LockState(self, LockState):
        self._LockState = LockState

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._LockId = params.get("LockId")
        self._LockState = params.get("LockState")
        self._RequestId = params.get("RequestId")


class Column(AbstractModel):
    r"""数据表列信息。

    """

    def __init__(self):
        r"""
        :param _Name: 列名称，不区分大小写，最大支持25个字符。
        :type Name: str
        :param _Type: string|tinyint|smallint|int|bigint|boolean|float|double|decimal|timestamp|date|binary|array|map|struct|uniontype
        :type Type: str
        :param _Comment: 对该类的注释。
注意：此字段可能返回 null，表示取不到有效值。
        :type Comment: str
        :param _Precision: 表示整个 numeric 的长度
        :type Precision: int
        :param _Scale: 表示小数部分的长度
        :type Scale: int
        :param _Nullable: 是否为null
        :type Nullable: str
        :param _Position: 字段位置，小的在前
        :type Position: int
        :param _CreateTime: 字段创建时间
        :type CreateTime: str
        :param _ModifiedTime: 字段修改时间
        :type ModifiedTime: str
        :param _IsPartition: 是否为分区字段
        :type IsPartition: bool
        :param _DataMaskStrategyInfo: 数据脱敏策略信息
注意：此字段可能返回 null，表示取不到有效值。
        :type DataMaskStrategyInfo: :class:`tencentcloud.dlc.v20210125.models.DataMaskStrategyInfo`
        """
        self._Name = None
        self._Type = None
        self._Comment = None
        self._Precision = None
        self._Scale = None
        self._Nullable = None
        self._Position = None
        self._CreateTime = None
        self._ModifiedTime = None
        self._IsPartition = None
        self._DataMaskStrategyInfo = None

    @property
    def Name(self):
        r"""列名称，不区分大小写，最大支持25个字符。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Type(self):
        r"""string|tinyint|smallint|int|bigint|boolean|float|double|decimal|timestamp|date|binary|array|map|struct|uniontype
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Comment(self):
        r"""对该类的注释。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def Precision(self):
        r"""表示整个 numeric 的长度
        :rtype: int
        """
        return self._Precision

    @Precision.setter
    def Precision(self, Precision):
        self._Precision = Precision

    @property
    def Scale(self):
        r"""表示小数部分的长度
        :rtype: int
        """
        return self._Scale

    @Scale.setter
    def Scale(self, Scale):
        self._Scale = Scale

    @property
    def Nullable(self):
        r"""是否为null
        :rtype: str
        """
        return self._Nullable

    @Nullable.setter
    def Nullable(self, Nullable):
        self._Nullable = Nullable

    @property
    def Position(self):
        r"""字段位置，小的在前
        :rtype: int
        """
        return self._Position

    @Position.setter
    def Position(self, Position):
        self._Position = Position

    @property
    def CreateTime(self):
        r"""字段创建时间
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ModifiedTime(self):
        r"""字段修改时间
        :rtype: str
        """
        return self._ModifiedTime

    @ModifiedTime.setter
    def ModifiedTime(self, ModifiedTime):
        self._ModifiedTime = ModifiedTime

    @property
    def IsPartition(self):
        r"""是否为分区字段
        :rtype: bool
        """
        return self._IsPartition

    @IsPartition.setter
    def IsPartition(self, IsPartition):
        self._IsPartition = IsPartition

    @property
    def DataMaskStrategyInfo(self):
        r"""数据脱敏策略信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.dlc.v20210125.models.DataMaskStrategyInfo`
        """
        return self._DataMaskStrategyInfo

    @DataMaskStrategyInfo.setter
    def DataMaskStrategyInfo(self, DataMaskStrategyInfo):
        self._DataMaskStrategyInfo = DataMaskStrategyInfo


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Type = params.get("Type")
        self._Comment = params.get("Comment")
        self._Precision = params.get("Precision")
        self._Scale = params.get("Scale")
        self._Nullable = params.get("Nullable")
        self._Position = params.get("Position")
        self._CreateTime = params.get("CreateTime")
        self._ModifiedTime = params.get("ModifiedTime")
        self._IsPartition = params.get("IsPartition")
        if params.get("DataMaskStrategyInfo") is not None:
            self._DataMaskStrategyInfo = DataMaskStrategyInfo()
            self._DataMaskStrategyInfo._deserialize(params.get("DataMaskStrategyInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CommonMetrics(AbstractModel):
    r"""任务公共指标

    """

    def __init__(self):
        r"""
        :param _CreateTaskTime: 创建任务时长，单位：ms
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTaskTime: float
        :param _ProcessTime: 预处理总时长，单位：ms
注意：此字段可能返回 null，表示取不到有效值。
        :type ProcessTime: float
        :param _QueueTime: 排队时长，单位：ms
注意：此字段可能返回 null，表示取不到有效值。
        :type QueueTime: float
        :param _ExecutionTime: 执行时长，单位：ms
注意：此字段可能返回 null，表示取不到有效值。
        :type ExecutionTime: float
        :param _IsResultCacheHit: 是否命中结果缓存
注意：此字段可能返回 null，表示取不到有效值。
        :type IsResultCacheHit: bool
        :param _MatchedMVBytes: 匹配物化视图数据量
注意：此字段可能返回 null，表示取不到有效值。
        :type MatchedMVBytes: int
        :param _MatchedMVs: 匹配物化视图列表
注意：此字段可能返回 null，表示取不到有效值。
        :type MatchedMVs: str
        :param _AffectedBytes: 结果数据量，单位：byte
注意：此字段可能返回 null，表示取不到有效值。
        :type AffectedBytes: str
        :param _AffectedRows: 	结果行数
注意：此字段可能返回 null，表示取不到有效值。
        :type AffectedRows: int
        :param _ProcessedBytes: 扫描数据量，单位：byte
注意：此字段可能返回 null，表示取不到有效值。
        :type ProcessedBytes: int
        :param _ProcessedRows: 	扫描行数
注意：此字段可能返回 null，表示取不到有效值。
        :type ProcessedRows: int
        """
        self._CreateTaskTime = None
        self._ProcessTime = None
        self._QueueTime = None
        self._ExecutionTime = None
        self._IsResultCacheHit = None
        self._MatchedMVBytes = None
        self._MatchedMVs = None
        self._AffectedBytes = None
        self._AffectedRows = None
        self._ProcessedBytes = None
        self._ProcessedRows = None

    @property
    def CreateTaskTime(self):
        r"""创建任务时长，单位：ms
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: float
        """
        return self._CreateTaskTime

    @CreateTaskTime.setter
    def CreateTaskTime(self, CreateTaskTime):
        self._CreateTaskTime = CreateTaskTime

    @property
    def ProcessTime(self):
        r"""预处理总时长，单位：ms
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: float
        """
        return self._ProcessTime

    @ProcessTime.setter
    def ProcessTime(self, ProcessTime):
        self._ProcessTime = ProcessTime

    @property
    def QueueTime(self):
        r"""排队时长，单位：ms
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: float
        """
        return self._QueueTime

    @QueueTime.setter
    def QueueTime(self, QueueTime):
        self._QueueTime = QueueTime

    @property
    def ExecutionTime(self):
        r"""执行时长，单位：ms
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: float
        """
        return self._ExecutionTime

    @ExecutionTime.setter
    def ExecutionTime(self, ExecutionTime):
        self._ExecutionTime = ExecutionTime

    @property
    def IsResultCacheHit(self):
        r"""是否命中结果缓存
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._IsResultCacheHit

    @IsResultCacheHit.setter
    def IsResultCacheHit(self, IsResultCacheHit):
        self._IsResultCacheHit = IsResultCacheHit

    @property
    def MatchedMVBytes(self):
        r"""匹配物化视图数据量
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._MatchedMVBytes

    @MatchedMVBytes.setter
    def MatchedMVBytes(self, MatchedMVBytes):
        self._MatchedMVBytes = MatchedMVBytes

    @property
    def MatchedMVs(self):
        r"""匹配物化视图列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._MatchedMVs

    @MatchedMVs.setter
    def MatchedMVs(self, MatchedMVs):
        self._MatchedMVs = MatchedMVs

    @property
    def AffectedBytes(self):
        r"""结果数据量，单位：byte
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AffectedBytes

    @AffectedBytes.setter
    def AffectedBytes(self, AffectedBytes):
        self._AffectedBytes = AffectedBytes

    @property
    def AffectedRows(self):
        r"""	结果行数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._AffectedRows

    @AffectedRows.setter
    def AffectedRows(self, AffectedRows):
        self._AffectedRows = AffectedRows

    @property
    def ProcessedBytes(self):
        r"""扫描数据量，单位：byte
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._ProcessedBytes

    @ProcessedBytes.setter
    def ProcessedBytes(self, ProcessedBytes):
        self._ProcessedBytes = ProcessedBytes

    @property
    def ProcessedRows(self):
        r"""	扫描行数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._ProcessedRows

    @ProcessedRows.setter
    def ProcessedRows(self, ProcessedRows):
        self._ProcessedRows = ProcessedRows


    def _deserialize(self, params):
        self._CreateTaskTime = params.get("CreateTaskTime")
        self._ProcessTime = params.get("ProcessTime")
        self._QueueTime = params.get("QueueTime")
        self._ExecutionTime = params.get("ExecutionTime")
        self._IsResultCacheHit = params.get("IsResultCacheHit")
        self._MatchedMVBytes = params.get("MatchedMVBytes")
        self._MatchedMVs = params.get("MatchedMVs")
        self._AffectedBytes = params.get("AffectedBytes")
        self._AffectedRows = params.get("AffectedRows")
        self._ProcessedBytes = params.get("ProcessedBytes")
        self._ProcessedRows = params.get("ProcessedRows")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CoreInfo(AbstractModel):
    r"""任务 core 用量信息

    """

    def __init__(self):
        r"""
        :param _Timestamp: 时间戳(毫秒)数组
        :type Timestamp: list of int
        :param _CoreUsage: core 用量
        :type CoreUsage: list of int
        """
        self._Timestamp = None
        self._CoreUsage = None

    @property
    def Timestamp(self):
        r"""时间戳(毫秒)数组
        :rtype: list of int
        """
        return self._Timestamp

    @Timestamp.setter
    def Timestamp(self, Timestamp):
        self._Timestamp = Timestamp

    @property
    def CoreUsage(self):
        r"""core 用量
        :rtype: list of int
        """
        return self._CoreUsage

    @CoreUsage.setter
    def CoreUsage(self, CoreUsage):
        self._CoreUsage = CoreUsage


    def _deserialize(self, params):
        self._Timestamp = params.get("Timestamp")
        self._CoreUsage = params.get("CoreUsage")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CosPermission(AbstractModel):
    r"""cos权限描述

    """

    def __init__(self):
        r"""
        :param _CosPath: cos路径
注意：此字段可能返回 null，表示取不到有效值。
        :type CosPath: str
        :param _Permissions: 权限【"read","write"】
注意：此字段可能返回 null，表示取不到有效值。
        :type Permissions: list of str
        """
        self._CosPath = None
        self._Permissions = None

    @property
    def CosPath(self):
        r"""cos路径
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CosPath

    @CosPath.setter
    def CosPath(self, CosPath):
        self._CosPath = CosPath

    @property
    def Permissions(self):
        r"""权限【"read","write"】
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._Permissions

    @Permissions.setter
    def Permissions(self, Permissions):
        self._Permissions = Permissions


    def _deserialize(self, params):
        self._CosPath = params.get("CosPath")
        self._Permissions = params.get("Permissions")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCHDFSBindingProductRequest(AbstractModel):
    r"""CreateCHDFSBindingProduct请求参数结构体

    """

    def __init__(self):
        r"""
        :param _MountPoint: 需要绑定的元数据加速桶名
        :type MountPoint: str
        :param _BucketType: 桶的类型，分为cos和lakefs
        :type BucketType: str
        :param _ProductName: 产品名称
        :type ProductName: str
        :param _EngineName: 引擎名称，ProductName选择DLC产品时，必传此参数。其他产品可不传
        :type EngineName: str
        :param _VpcInfo: vpc信息，产品名称为other时必传此参数
        :type VpcInfo: list of VpcInfo
        """
        self._MountPoint = None
        self._BucketType = None
        self._ProductName = None
        self._EngineName = None
        self._VpcInfo = None

    @property
    def MountPoint(self):
        r"""需要绑定的元数据加速桶名
        :rtype: str
        """
        return self._MountPoint

    @MountPoint.setter
    def MountPoint(self, MountPoint):
        self._MountPoint = MountPoint

    @property
    def BucketType(self):
        r"""桶的类型，分为cos和lakefs
        :rtype: str
        """
        return self._BucketType

    @BucketType.setter
    def BucketType(self, BucketType):
        self._BucketType = BucketType

    @property
    def ProductName(self):
        r"""产品名称
        :rtype: str
        """
        return self._ProductName

    @ProductName.setter
    def ProductName(self, ProductName):
        self._ProductName = ProductName

    @property
    def EngineName(self):
        r"""引擎名称，ProductName选择DLC产品时，必传此参数。其他产品可不传
        :rtype: str
        """
        return self._EngineName

    @EngineName.setter
    def EngineName(self, EngineName):
        self._EngineName = EngineName

    @property
    def VpcInfo(self):
        r"""vpc信息，产品名称为other时必传此参数
        :rtype: list of VpcInfo
        """
        return self._VpcInfo

    @VpcInfo.setter
    def VpcInfo(self, VpcInfo):
        self._VpcInfo = VpcInfo


    def _deserialize(self, params):
        self._MountPoint = params.get("MountPoint")
        self._BucketType = params.get("BucketType")
        self._ProductName = params.get("ProductName")
        self._EngineName = params.get("EngineName")
        if params.get("VpcInfo") is not None:
            self._VpcInfo = []
            for item in params.get("VpcInfo"):
                obj = VpcInfo()
                obj._deserialize(item)
                self._VpcInfo.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCHDFSBindingProductResponse(AbstractModel):
    r"""CreateCHDFSBindingProduct返回参数结构体

    """

    def __init__(self):
        r"""
        :param _MountPointAssociates: 绑定信息
        :type MountPointAssociates: list of MountPointAssociates
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._MountPointAssociates = None
        self._RequestId = None

    @property
    def MountPointAssociates(self):
        r"""绑定信息
        :rtype: list of MountPointAssociates
        """
        return self._MountPointAssociates

    @MountPointAssociates.setter
    def MountPointAssociates(self, MountPointAssociates):
        self._MountPointAssociates = MountPointAssociates

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("MountPointAssociates") is not None:
            self._MountPointAssociates = []
            for item in params.get("MountPointAssociates"):
                obj = MountPointAssociates()
                obj._deserialize(item)
                self._MountPointAssociates.append(obj)
        self._RequestId = params.get("RequestId")


class CreateDMSDatabaseRequest(AbstractModel):
    r"""CreateDMSDatabase请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Asset: 基础元数据对象
        :type Asset: :class:`tencentcloud.dlc.v20210125.models.Asset`
        :param _SchemaName: Schema目录
        :type SchemaName: str
        :param _Location: Db存储路径
        :type Location: str
        :param _Name: 数据库名称
        :type Name: str
        :param _DatasourceConnectionName: 数据源连接名
        :type DatasourceConnectionName: str
        """
        self._Asset = None
        self._SchemaName = None
        self._Location = None
        self._Name = None
        self._DatasourceConnectionName = None

    @property
    def Asset(self):
        r"""基础元数据对象
        :rtype: :class:`tencentcloud.dlc.v20210125.models.Asset`
        """
        return self._Asset

    @Asset.setter
    def Asset(self, Asset):
        self._Asset = Asset

    @property
    def SchemaName(self):
        r"""Schema目录
        :rtype: str
        """
        return self._SchemaName

    @SchemaName.setter
    def SchemaName(self, SchemaName):
        self._SchemaName = SchemaName

    @property
    def Location(self):
        r"""Db存储路径
        :rtype: str
        """
        return self._Location

    @Location.setter
    def Location(self, Location):
        self._Location = Location

    @property
    def Name(self):
        r"""数据库名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def DatasourceConnectionName(self):
        r"""数据源连接名
        :rtype: str
        """
        return self._DatasourceConnectionName

    @DatasourceConnectionName.setter
    def DatasourceConnectionName(self, DatasourceConnectionName):
        self._DatasourceConnectionName = DatasourceConnectionName


    def _deserialize(self, params):
        if params.get("Asset") is not None:
            self._Asset = Asset()
            self._Asset._deserialize(params.get("Asset"))
        self._SchemaName = params.get("SchemaName")
        self._Location = params.get("Location")
        self._Name = params.get("Name")
        self._DatasourceConnectionName = params.get("DatasourceConnectionName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDMSDatabaseResponse(AbstractModel):
    r"""CreateDMSDatabase返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateDMSTableRequest(AbstractModel):
    r"""CreateDMSTable请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Asset: 基础对象
        :type Asset: :class:`tencentcloud.dlc.v20210125.models.Asset`
        :param _Type: 表类型：EXTERNAL_TABLE, VIRTUAL_VIEW, MATERIALIZED_VIEW
        :type Type: str
        :param _DbName: 数据库名称
        :type DbName: str
        :param _StorageSize: 存储大小
        :type StorageSize: int
        :param _RecordCount: 记录数量
        :type RecordCount: int
        :param _LifeTime: 生命周期
        :type LifeTime: int
        :param _DataUpdateTime: 数据更新时间
        :type DataUpdateTime: str
        :param _StructUpdateTime: 结构更新时间
        :type StructUpdateTime: str
        :param _LastAccessTime: 最后访问时间
        :type LastAccessTime: str
        :param _Sds: 存储对象
        :type Sds: :class:`tencentcloud.dlc.v20210125.models.DMSSds`
        :param _Columns: 列
        :type Columns: list of DMSColumn
        :param _PartitionKeys: 分区键值
        :type PartitionKeys: list of DMSColumn
        :param _ViewOriginalText: 视图文本
        :type ViewOriginalText: str
        :param _ViewExpandedText: 视图文本
        :type ViewExpandedText: str
        :param _Partitions: 分区
        :type Partitions: list of DMSPartition
        :param _Name: 表名称
        :type Name: str
        :param _DatasourceConnectionName: 数据源连接名
        :type DatasourceConnectionName: str
        """
        self._Asset = None
        self._Type = None
        self._DbName = None
        self._StorageSize = None
        self._RecordCount = None
        self._LifeTime = None
        self._DataUpdateTime = None
        self._StructUpdateTime = None
        self._LastAccessTime = None
        self._Sds = None
        self._Columns = None
        self._PartitionKeys = None
        self._ViewOriginalText = None
        self._ViewExpandedText = None
        self._Partitions = None
        self._Name = None
        self._DatasourceConnectionName = None

    @property
    def Asset(self):
        r"""基础对象
        :rtype: :class:`tencentcloud.dlc.v20210125.models.Asset`
        """
        return self._Asset

    @Asset.setter
    def Asset(self, Asset):
        self._Asset = Asset

    @property
    def Type(self):
        r"""表类型：EXTERNAL_TABLE, VIRTUAL_VIEW, MATERIALIZED_VIEW
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def DbName(self):
        r"""数据库名称
        :rtype: str
        """
        return self._DbName

    @DbName.setter
    def DbName(self, DbName):
        self._DbName = DbName

    @property
    def StorageSize(self):
        r"""存储大小
        :rtype: int
        """
        return self._StorageSize

    @StorageSize.setter
    def StorageSize(self, StorageSize):
        self._StorageSize = StorageSize

    @property
    def RecordCount(self):
        r"""记录数量
        :rtype: int
        """
        return self._RecordCount

    @RecordCount.setter
    def RecordCount(self, RecordCount):
        self._RecordCount = RecordCount

    @property
    def LifeTime(self):
        r"""生命周期
        :rtype: int
        """
        return self._LifeTime

    @LifeTime.setter
    def LifeTime(self, LifeTime):
        self._LifeTime = LifeTime

    @property
    def DataUpdateTime(self):
        r"""数据更新时间
        :rtype: str
        """
        return self._DataUpdateTime

    @DataUpdateTime.setter
    def DataUpdateTime(self, DataUpdateTime):
        self._DataUpdateTime = DataUpdateTime

    @property
    def StructUpdateTime(self):
        r"""结构更新时间
        :rtype: str
        """
        return self._StructUpdateTime

    @StructUpdateTime.setter
    def StructUpdateTime(self, StructUpdateTime):
        self._StructUpdateTime = StructUpdateTime

    @property
    def LastAccessTime(self):
        r"""最后访问时间
        :rtype: str
        """
        return self._LastAccessTime

    @LastAccessTime.setter
    def LastAccessTime(self, LastAccessTime):
        self._LastAccessTime = LastAccessTime

    @property
    def Sds(self):
        r"""存储对象
        :rtype: :class:`tencentcloud.dlc.v20210125.models.DMSSds`
        """
        return self._Sds

    @Sds.setter
    def Sds(self, Sds):
        self._Sds = Sds

    @property
    def Columns(self):
        r"""列
        :rtype: list of DMSColumn
        """
        return self._Columns

    @Columns.setter
    def Columns(self, Columns):
        self._Columns = Columns

    @property
    def PartitionKeys(self):
        r"""分区键值
        :rtype: list of DMSColumn
        """
        return self._PartitionKeys

    @PartitionKeys.setter
    def PartitionKeys(self, PartitionKeys):
        self._PartitionKeys = PartitionKeys

    @property
    def ViewOriginalText(self):
        r"""视图文本
        :rtype: str
        """
        return self._ViewOriginalText

    @ViewOriginalText.setter
    def ViewOriginalText(self, ViewOriginalText):
        self._ViewOriginalText = ViewOriginalText

    @property
    def ViewExpandedText(self):
        r"""视图文本
        :rtype: str
        """
        return self._ViewExpandedText

    @ViewExpandedText.setter
    def ViewExpandedText(self, ViewExpandedText):
        self._ViewExpandedText = ViewExpandedText

    @property
    def Partitions(self):
        r"""分区
        :rtype: list of DMSPartition
        """
        return self._Partitions

    @Partitions.setter
    def Partitions(self, Partitions):
        self._Partitions = Partitions

    @property
    def Name(self):
        r"""表名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def DatasourceConnectionName(self):
        r"""数据源连接名
        :rtype: str
        """
        return self._DatasourceConnectionName

    @DatasourceConnectionName.setter
    def DatasourceConnectionName(self, DatasourceConnectionName):
        self._DatasourceConnectionName = DatasourceConnectionName


    def _deserialize(self, params):
        if params.get("Asset") is not None:
            self._Asset = Asset()
            self._Asset._deserialize(params.get("Asset"))
        self._Type = params.get("Type")
        self._DbName = params.get("DbName")
        self._StorageSize = params.get("StorageSize")
        self._RecordCount = params.get("RecordCount")
        self._LifeTime = params.get("LifeTime")
        self._DataUpdateTime = params.get("DataUpdateTime")
        self._StructUpdateTime = params.get("StructUpdateTime")
        self._LastAccessTime = params.get("LastAccessTime")
        if params.get("Sds") is not None:
            self._Sds = DMSSds()
            self._Sds._deserialize(params.get("Sds"))
        if params.get("Columns") is not None:
            self._Columns = []
            for item in params.get("Columns"):
                obj = DMSColumn()
                obj._deserialize(item)
                self._Columns.append(obj)
        if params.get("PartitionKeys") is not None:
            self._PartitionKeys = []
            for item in params.get("PartitionKeys"):
                obj = DMSColumn()
                obj._deserialize(item)
                self._PartitionKeys.append(obj)
        self._ViewOriginalText = params.get("ViewOriginalText")
        self._ViewExpandedText = params.get("ViewExpandedText")
        if params.get("Partitions") is not None:
            self._Partitions = []
            for item in params.get("Partitions"):
                obj = DMSPartition()
                obj._deserialize(item)
                self._Partitions.append(obj)
        self._Name = params.get("Name")
        self._DatasourceConnectionName = params.get("DatasourceConnectionName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDMSTableResponse(AbstractModel):
    r"""CreateDMSTable返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateDataEngineRequest(AbstractModel):
    r"""CreateDataEngine请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EngineType: 引擎类型spark/presto
        :type EngineType: str
        :param _DataEngineName: 虚拟集群名称
        :type DataEngineName: str
        :param _ClusterType: 集群类型 spark_private/presto_private/presto_cu/spark_cu
        :type ClusterType: str
        :param _Mode: 计费模式 0=共享模式 1=按量计费 2=包年包月
        :type Mode: int
        :param _AutoResume: 是否自动启动集群
        :type AutoResume: bool
        :param _MinClusters: 最小资源
        :type MinClusters: int
        :param _MaxClusters: 最大资源
        :type MaxClusters: int
        :param _DefaultDataEngine: 是否为默认虚拟集群
        :type DefaultDataEngine: bool
        :param _CidrBlock: VPC网段
        :type CidrBlock: str
        :param _Message: 描述信息
        :type Message: str
        :param _Size: 集群规模
        :type Size: int
        :param _PayMode: 计费类型，后付费：0，预付费：1。当前只支持后付费，不填默认为后付费。
        :type PayMode: int
        :param _TimeSpan: 资源使用时长，后付费：固定填1，预付费：最少填1，代表购买资源一个月，最长不超过120。默认1
        :type TimeSpan: int
        :param _TimeUnit: 资源使用时长的单位，后付费：h，预付费：m。默认为h
        :type TimeUnit: str
        :param _AutoRenew: 资源的自动续费标志。后付费无需续费，固定填0；预付费下：0表示手动续费、1代表自动续费、2代表不续费，在0下如果是大客户，会自动帮大客户续费。默认为0
        :type AutoRenew: int
        :param _Tags: 创建资源的时候需要绑定的标签信息
        :type Tags: list of TagInfo
        :param _AutoSuspend: 是否自定挂起集群：false（默认）：不自动挂起、true：自动挂起
        :type AutoSuspend: bool
        :param _CrontabResumeSuspend: 定时启停集群策略：0（默认）：关闭定时策略、1：开启定时策略（注：定时启停策略与自动挂起策略互斥）
        :type CrontabResumeSuspend: int
        :param _CrontabResumeSuspendStrategy: 定时启停策略，复杂类型：包含启停时间、挂起集群策略
        :type CrontabResumeSuspendStrategy: :class:`tencentcloud.dlc.v20210125.models.CrontabResumeSuspendStrategy`
        :param _EngineExecType: 引擎执行任务类型，有效值：SQL/BATCH，标准引擎默认为BATCH
        :type EngineExecType: str
        :param _MaxConcurrency: 单个集群最大并发任务数，默认5
        :type MaxConcurrency: int
        :param _TolerableQueueTime: 可容忍的排队时间，默认0。当任务排队的时间超过可容忍的时间时可能会触发扩容。如果该参数为0，则表示一旦有任务排队就可能立即触发扩容。
        :type TolerableQueueTime: int
        :param _AutoSuspendTime: 集群自动挂起时间，默认10分钟
        :type AutoSuspendTime: int
        :param _ResourceType: 资源类型。Standard_CU：标准型；Memory_CU：内存型
        :type ResourceType: str
        :param _DataEngineConfigPairs: 集群高级配置
        :type DataEngineConfigPairs: list of DataEngineConfigPair
        :param _ImageVersionName: 集群镜像版本名字。如SuperSQL-P 1.1;SuperSQL-S 3.2等,不传，默认创建最新镜像版本的集群
        :type ImageVersionName: str
        :param _MainClusterName: 主集群名称，创建容灾集群时指定
        :type MainClusterName: str
        :param _ElasticSwitch: spark jar 包年包月集群是否开启弹性
        :type ElasticSwitch: bool
        :param _ElasticLimit: spark jar 包年包月集群弹性上限
        :type ElasticLimit: int
        :param _SessionResourceTemplate: spark作业集群session资源配置模板
        :type SessionResourceTemplate: :class:`tencentcloud.dlc.v20210125.models.SessionResourceTemplate`
        :param _AutoAuthorization: 自动授权
        :type AutoAuthorization: bool
        :param _EngineNetworkId: 引擎网络ID
        :type EngineNetworkId: str
        :param _EngineGeneration: 引擎世代，SuperSQL：代表supersql引擎，Native：代表标准引擎。默认值为SuperSQL
        :type EngineGeneration: str
        """
        self._EngineType = None
        self._DataEngineName = None
        self._ClusterType = None
        self._Mode = None
        self._AutoResume = None
        self._MinClusters = None
        self._MaxClusters = None
        self._DefaultDataEngine = None
        self._CidrBlock = None
        self._Message = None
        self._Size = None
        self._PayMode = None
        self._TimeSpan = None
        self._TimeUnit = None
        self._AutoRenew = None
        self._Tags = None
        self._AutoSuspend = None
        self._CrontabResumeSuspend = None
        self._CrontabResumeSuspendStrategy = None
        self._EngineExecType = None
        self._MaxConcurrency = None
        self._TolerableQueueTime = None
        self._AutoSuspendTime = None
        self._ResourceType = None
        self._DataEngineConfigPairs = None
        self._ImageVersionName = None
        self._MainClusterName = None
        self._ElasticSwitch = None
        self._ElasticLimit = None
        self._SessionResourceTemplate = None
        self._AutoAuthorization = None
        self._EngineNetworkId = None
        self._EngineGeneration = None

    @property
    def EngineType(self):
        r"""引擎类型spark/presto
        :rtype: str
        """
        return self._EngineType

    @EngineType.setter
    def EngineType(self, EngineType):
        self._EngineType = EngineType

    @property
    def DataEngineName(self):
        r"""虚拟集群名称
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName

    @property
    def ClusterType(self):
        r"""集群类型 spark_private/presto_private/presto_cu/spark_cu
        :rtype: str
        """
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType

    @property
    def Mode(self):
        r"""计费模式 0=共享模式 1=按量计费 2=包年包月
        :rtype: int
        """
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def AutoResume(self):
        r"""是否自动启动集群
        :rtype: bool
        """
        return self._AutoResume

    @AutoResume.setter
    def AutoResume(self, AutoResume):
        self._AutoResume = AutoResume

    @property
    def MinClusters(self):
        r"""最小资源
        :rtype: int
        """
        return self._MinClusters

    @MinClusters.setter
    def MinClusters(self, MinClusters):
        self._MinClusters = MinClusters

    @property
    def MaxClusters(self):
        r"""最大资源
        :rtype: int
        """
        return self._MaxClusters

    @MaxClusters.setter
    def MaxClusters(self, MaxClusters):
        self._MaxClusters = MaxClusters

    @property
    def DefaultDataEngine(self):
        warnings.warn("parameter `DefaultDataEngine` is deprecated", DeprecationWarning) 

        r"""是否为默认虚拟集群
        :rtype: bool
        """
        return self._DefaultDataEngine

    @DefaultDataEngine.setter
    def DefaultDataEngine(self, DefaultDataEngine):
        warnings.warn("parameter `DefaultDataEngine` is deprecated", DeprecationWarning) 

        self._DefaultDataEngine = DefaultDataEngine

    @property
    def CidrBlock(self):
        r"""VPC网段
        :rtype: str
        """
        return self._CidrBlock

    @CidrBlock.setter
    def CidrBlock(self, CidrBlock):
        self._CidrBlock = CidrBlock

    @property
    def Message(self):
        r"""描述信息
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Size(self):
        r"""集群规模
        :rtype: int
        """
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size

    @property
    def PayMode(self):
        r"""计费类型，后付费：0，预付费：1。当前只支持后付费，不填默认为后付费。
        :rtype: int
        """
        return self._PayMode

    @PayMode.setter
    def PayMode(self, PayMode):
        self._PayMode = PayMode

    @property
    def TimeSpan(self):
        r"""资源使用时长，后付费：固定填1，预付费：最少填1，代表购买资源一个月，最长不超过120。默认1
        :rtype: int
        """
        return self._TimeSpan

    @TimeSpan.setter
    def TimeSpan(self, TimeSpan):
        self._TimeSpan = TimeSpan

    @property
    def TimeUnit(self):
        r"""资源使用时长的单位，后付费：h，预付费：m。默认为h
        :rtype: str
        """
        return self._TimeUnit

    @TimeUnit.setter
    def TimeUnit(self, TimeUnit):
        self._TimeUnit = TimeUnit

    @property
    def AutoRenew(self):
        r"""资源的自动续费标志。后付费无需续费，固定填0；预付费下：0表示手动续费、1代表自动续费、2代表不续费，在0下如果是大客户，会自动帮大客户续费。默认为0
        :rtype: int
        """
        return self._AutoRenew

    @AutoRenew.setter
    def AutoRenew(self, AutoRenew):
        self._AutoRenew = AutoRenew

    @property
    def Tags(self):
        r"""创建资源的时候需要绑定的标签信息
        :rtype: list of TagInfo
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def AutoSuspend(self):
        r"""是否自定挂起集群：false（默认）：不自动挂起、true：自动挂起
        :rtype: bool
        """
        return self._AutoSuspend

    @AutoSuspend.setter
    def AutoSuspend(self, AutoSuspend):
        self._AutoSuspend = AutoSuspend

    @property
    def CrontabResumeSuspend(self):
        r"""定时启停集群策略：0（默认）：关闭定时策略、1：开启定时策略（注：定时启停策略与自动挂起策略互斥）
        :rtype: int
        """
        return self._CrontabResumeSuspend

    @CrontabResumeSuspend.setter
    def CrontabResumeSuspend(self, CrontabResumeSuspend):
        self._CrontabResumeSuspend = CrontabResumeSuspend

    @property
    def CrontabResumeSuspendStrategy(self):
        r"""定时启停策略，复杂类型：包含启停时间、挂起集群策略
        :rtype: :class:`tencentcloud.dlc.v20210125.models.CrontabResumeSuspendStrategy`
        """
        return self._CrontabResumeSuspendStrategy

    @CrontabResumeSuspendStrategy.setter
    def CrontabResumeSuspendStrategy(self, CrontabResumeSuspendStrategy):
        self._CrontabResumeSuspendStrategy = CrontabResumeSuspendStrategy

    @property
    def EngineExecType(self):
        r"""引擎执行任务类型，有效值：SQL/BATCH，标准引擎默认为BATCH
        :rtype: str
        """
        return self._EngineExecType

    @EngineExecType.setter
    def EngineExecType(self, EngineExecType):
        self._EngineExecType = EngineExecType

    @property
    def MaxConcurrency(self):
        r"""单个集群最大并发任务数，默认5
        :rtype: int
        """
        return self._MaxConcurrency

    @MaxConcurrency.setter
    def MaxConcurrency(self, MaxConcurrency):
        self._MaxConcurrency = MaxConcurrency

    @property
    def TolerableQueueTime(self):
        r"""可容忍的排队时间，默认0。当任务排队的时间超过可容忍的时间时可能会触发扩容。如果该参数为0，则表示一旦有任务排队就可能立即触发扩容。
        :rtype: int
        """
        return self._TolerableQueueTime

    @TolerableQueueTime.setter
    def TolerableQueueTime(self, TolerableQueueTime):
        self._TolerableQueueTime = TolerableQueueTime

    @property
    def AutoSuspendTime(self):
        r"""集群自动挂起时间，默认10分钟
        :rtype: int
        """
        return self._AutoSuspendTime

    @AutoSuspendTime.setter
    def AutoSuspendTime(self, AutoSuspendTime):
        self._AutoSuspendTime = AutoSuspendTime

    @property
    def ResourceType(self):
        r"""资源类型。Standard_CU：标准型；Memory_CU：内存型
        :rtype: str
        """
        return self._ResourceType

    @ResourceType.setter
    def ResourceType(self, ResourceType):
        self._ResourceType = ResourceType

    @property
    def DataEngineConfigPairs(self):
        r"""集群高级配置
        :rtype: list of DataEngineConfigPair
        """
        return self._DataEngineConfigPairs

    @DataEngineConfigPairs.setter
    def DataEngineConfigPairs(self, DataEngineConfigPairs):
        self._DataEngineConfigPairs = DataEngineConfigPairs

    @property
    def ImageVersionName(self):
        r"""集群镜像版本名字。如SuperSQL-P 1.1;SuperSQL-S 3.2等,不传，默认创建最新镜像版本的集群
        :rtype: str
        """
        return self._ImageVersionName

    @ImageVersionName.setter
    def ImageVersionName(self, ImageVersionName):
        self._ImageVersionName = ImageVersionName

    @property
    def MainClusterName(self):
        r"""主集群名称，创建容灾集群时指定
        :rtype: str
        """
        return self._MainClusterName

    @MainClusterName.setter
    def MainClusterName(self, MainClusterName):
        self._MainClusterName = MainClusterName

    @property
    def ElasticSwitch(self):
        r"""spark jar 包年包月集群是否开启弹性
        :rtype: bool
        """
        return self._ElasticSwitch

    @ElasticSwitch.setter
    def ElasticSwitch(self, ElasticSwitch):
        self._ElasticSwitch = ElasticSwitch

    @property
    def ElasticLimit(self):
        r"""spark jar 包年包月集群弹性上限
        :rtype: int
        """
        return self._ElasticLimit

    @ElasticLimit.setter
    def ElasticLimit(self, ElasticLimit):
        self._ElasticLimit = ElasticLimit

    @property
    def SessionResourceTemplate(self):
        r"""spark作业集群session资源配置模板
        :rtype: :class:`tencentcloud.dlc.v20210125.models.SessionResourceTemplate`
        """
        return self._SessionResourceTemplate

    @SessionResourceTemplate.setter
    def SessionResourceTemplate(self, SessionResourceTemplate):
        self._SessionResourceTemplate = SessionResourceTemplate

    @property
    def AutoAuthorization(self):
        r"""自动授权
        :rtype: bool
        """
        return self._AutoAuthorization

    @AutoAuthorization.setter
    def AutoAuthorization(self, AutoAuthorization):
        self._AutoAuthorization = AutoAuthorization

    @property
    def EngineNetworkId(self):
        r"""引擎网络ID
        :rtype: str
        """
        return self._EngineNetworkId

    @EngineNetworkId.setter
    def EngineNetworkId(self, EngineNetworkId):
        self._EngineNetworkId = EngineNetworkId

    @property
    def EngineGeneration(self):
        r"""引擎世代，SuperSQL：代表supersql引擎，Native：代表标准引擎。默认值为SuperSQL
        :rtype: str
        """
        return self._EngineGeneration

    @EngineGeneration.setter
    def EngineGeneration(self, EngineGeneration):
        self._EngineGeneration = EngineGeneration


    def _deserialize(self, params):
        self._EngineType = params.get("EngineType")
        self._DataEngineName = params.get("DataEngineName")
        self._ClusterType = params.get("ClusterType")
        self._Mode = params.get("Mode")
        self._AutoResume = params.get("AutoResume")
        self._MinClusters = params.get("MinClusters")
        self._MaxClusters = params.get("MaxClusters")
        self._DefaultDataEngine = params.get("DefaultDataEngine")
        self._CidrBlock = params.get("CidrBlock")
        self._Message = params.get("Message")
        self._Size = params.get("Size")
        self._PayMode = params.get("PayMode")
        self._TimeSpan = params.get("TimeSpan")
        self._TimeUnit = params.get("TimeUnit")
        self._AutoRenew = params.get("AutoRenew")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = TagInfo()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._AutoSuspend = params.get("AutoSuspend")
        self._CrontabResumeSuspend = params.get("CrontabResumeSuspend")
        if params.get("CrontabResumeSuspendStrategy") is not None:
            self._CrontabResumeSuspendStrategy = CrontabResumeSuspendStrategy()
            self._CrontabResumeSuspendStrategy._deserialize(params.get("CrontabResumeSuspendStrategy"))
        self._EngineExecType = params.get("EngineExecType")
        self._MaxConcurrency = params.get("MaxConcurrency")
        self._TolerableQueueTime = params.get("TolerableQueueTime")
        self._AutoSuspendTime = params.get("AutoSuspendTime")
        self._ResourceType = params.get("ResourceType")
        if params.get("DataEngineConfigPairs") is not None:
            self._DataEngineConfigPairs = []
            for item in params.get("DataEngineConfigPairs"):
                obj = DataEngineConfigPair()
                obj._deserialize(item)
                self._DataEngineConfigPairs.append(obj)
        self._ImageVersionName = params.get("ImageVersionName")
        self._MainClusterName = params.get("MainClusterName")
        self._ElasticSwitch = params.get("ElasticSwitch")
        self._ElasticLimit = params.get("ElasticLimit")
        if params.get("SessionResourceTemplate") is not None:
            self._SessionResourceTemplate = SessionResourceTemplate()
            self._SessionResourceTemplate._deserialize(params.get("SessionResourceTemplate"))
        self._AutoAuthorization = params.get("AutoAuthorization")
        self._EngineNetworkId = params.get("EngineNetworkId")
        self._EngineGeneration = params.get("EngineGeneration")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDataEngineResponse(AbstractModel):
    r"""CreateDataEngine返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DataEngineId: 虚拟引擎id
        :type DataEngineId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DataEngineId = None
        self._RequestId = None

    @property
    def DataEngineId(self):
        r"""虚拟引擎id
        :rtype: str
        """
        return self._DataEngineId

    @DataEngineId.setter
    def DataEngineId(self, DataEngineId):
        self._DataEngineId = DataEngineId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DataEngineId = params.get("DataEngineId")
        self._RequestId = params.get("RequestId")


class CreateDataMaskStrategyRequest(AbstractModel):
    r"""CreateDataMaskStrategy请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Strategy: 数据脱敏策略详情
        :type Strategy: :class:`tencentcloud.dlc.v20210125.models.DataMaskStrategyInfo`
        """
        self._Strategy = None

    @property
    def Strategy(self):
        r"""数据脱敏策略详情
        :rtype: :class:`tencentcloud.dlc.v20210125.models.DataMaskStrategyInfo`
        """
        return self._Strategy

    @Strategy.setter
    def Strategy(self, Strategy):
        self._Strategy = Strategy


    def _deserialize(self, params):
        if params.get("Strategy") is not None:
            self._Strategy = DataMaskStrategyInfo()
            self._Strategy._deserialize(params.get("Strategy"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDataMaskStrategyResponse(AbstractModel):
    r"""CreateDataMaskStrategy返回参数结构体

    """

    def __init__(self):
        r"""
        :param _StrategyId: 策略id
        :type StrategyId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._StrategyId = None
        self._RequestId = None

    @property
    def StrategyId(self):
        r"""策略id
        :rtype: str
        """
        return self._StrategyId

    @StrategyId.setter
    def StrategyId(self, StrategyId):
        self._StrategyId = StrategyId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._StrategyId = params.get("StrategyId")
        self._RequestId = params.get("RequestId")


class CreateDatabaseRequest(AbstractModel):
    r"""CreateDatabase请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DatabaseInfo: 数据库基础信息
        :type DatabaseInfo: :class:`tencentcloud.dlc.v20210125.models.DatabaseInfo`
        :param _DatasourceConnectionName: 数据源名称，默认为DataLakeCatalog
        :type DatasourceConnectionName: str
        """
        self._DatabaseInfo = None
        self._DatasourceConnectionName = None

    @property
    def DatabaseInfo(self):
        r"""数据库基础信息
        :rtype: :class:`tencentcloud.dlc.v20210125.models.DatabaseInfo`
        """
        return self._DatabaseInfo

    @DatabaseInfo.setter
    def DatabaseInfo(self, DatabaseInfo):
        self._DatabaseInfo = DatabaseInfo

    @property
    def DatasourceConnectionName(self):
        r"""数据源名称，默认为DataLakeCatalog
        :rtype: str
        """
        return self._DatasourceConnectionName

    @DatasourceConnectionName.setter
    def DatasourceConnectionName(self, DatasourceConnectionName):
        self._DatasourceConnectionName = DatasourceConnectionName


    def _deserialize(self, params):
        if params.get("DatabaseInfo") is not None:
            self._DatabaseInfo = DatabaseInfo()
            self._DatabaseInfo._deserialize(params.get("DatabaseInfo"))
        self._DatasourceConnectionName = params.get("DatasourceConnectionName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDatabaseResponse(AbstractModel):
    r"""CreateDatabase返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Execution: 生成的建库执行语句对象。
        :type Execution: :class:`tencentcloud.dlc.v20210125.models.Execution`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Execution = None
        self._RequestId = None

    @property
    def Execution(self):
        r"""生成的建库执行语句对象。
        :rtype: :class:`tencentcloud.dlc.v20210125.models.Execution`
        """
        return self._Execution

    @Execution.setter
    def Execution(self, Execution):
        self._Execution = Execution

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Execution") is not None:
            self._Execution = Execution()
            self._Execution._deserialize(params.get("Execution"))
        self._RequestId = params.get("RequestId")


class CreateDatasourceConnectionRequest(AbstractModel):
    r"""CreateDatasourceConnection请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DatasourceConnectionName: 数据连接名称
        :type DatasourceConnectionName: str
        :param _DatasourceConnectionType: 数据连接类型
        :type DatasourceConnectionType: str
        :param _DatasourceConnectionConfig: 数据连接属性
        :type DatasourceConnectionConfig: :class:`tencentcloud.dlc.v20210125.models.DatasourceConnectionConfig`
        :param _ServiceType: 数据连接所属服务
        :type ServiceType: str
        :param _DatasourceConnectionDesc: 数据连接描述
        :type DatasourceConnectionDesc: str
        :param _DataEngineNames: 数据引擎名称数组
        :type DataEngineNames: list of str
        :param _NetworkConnectionName: 网络连接名称
        :type NetworkConnectionName: str
        :param _NetworkConnectionDesc: 网络连接描述
        :type NetworkConnectionDesc: str
        :param _NetworkConnectionType: 网络连接类型 （2-夸源型，4-增强型）
        :type NetworkConnectionType: int
        :param _CustomConfig: 自定义配置
        :type CustomConfig: list of CustomConfig
        """
        self._DatasourceConnectionName = None
        self._DatasourceConnectionType = None
        self._DatasourceConnectionConfig = None
        self._ServiceType = None
        self._DatasourceConnectionDesc = None
        self._DataEngineNames = None
        self._NetworkConnectionName = None
        self._NetworkConnectionDesc = None
        self._NetworkConnectionType = None
        self._CustomConfig = None

    @property
    def DatasourceConnectionName(self):
        r"""数据连接名称
        :rtype: str
        """
        return self._DatasourceConnectionName

    @DatasourceConnectionName.setter
    def DatasourceConnectionName(self, DatasourceConnectionName):
        self._DatasourceConnectionName = DatasourceConnectionName

    @property
    def DatasourceConnectionType(self):
        r"""数据连接类型
        :rtype: str
        """
        return self._DatasourceConnectionType

    @DatasourceConnectionType.setter
    def DatasourceConnectionType(self, DatasourceConnectionType):
        self._DatasourceConnectionType = DatasourceConnectionType

    @property
    def DatasourceConnectionConfig(self):
        r"""数据连接属性
        :rtype: :class:`tencentcloud.dlc.v20210125.models.DatasourceConnectionConfig`
        """
        return self._DatasourceConnectionConfig

    @DatasourceConnectionConfig.setter
    def DatasourceConnectionConfig(self, DatasourceConnectionConfig):
        self._DatasourceConnectionConfig = DatasourceConnectionConfig

    @property
    def ServiceType(self):
        r"""数据连接所属服务
        :rtype: str
        """
        return self._ServiceType

    @ServiceType.setter
    def ServiceType(self, ServiceType):
        self._ServiceType = ServiceType

    @property
    def DatasourceConnectionDesc(self):
        r"""数据连接描述
        :rtype: str
        """
        return self._DatasourceConnectionDesc

    @DatasourceConnectionDesc.setter
    def DatasourceConnectionDesc(self, DatasourceConnectionDesc):
        self._DatasourceConnectionDesc = DatasourceConnectionDesc

    @property
    def DataEngineNames(self):
        r"""数据引擎名称数组
        :rtype: list of str
        """
        return self._DataEngineNames

    @DataEngineNames.setter
    def DataEngineNames(self, DataEngineNames):
        self._DataEngineNames = DataEngineNames

    @property
    def NetworkConnectionName(self):
        r"""网络连接名称
        :rtype: str
        """
        return self._NetworkConnectionName

    @NetworkConnectionName.setter
    def NetworkConnectionName(self, NetworkConnectionName):
        self._NetworkConnectionName = NetworkConnectionName

    @property
    def NetworkConnectionDesc(self):
        r"""网络连接描述
        :rtype: str
        """
        return self._NetworkConnectionDesc

    @NetworkConnectionDesc.setter
    def NetworkConnectionDesc(self, NetworkConnectionDesc):
        self._NetworkConnectionDesc = NetworkConnectionDesc

    @property
    def NetworkConnectionType(self):
        r"""网络连接类型 （2-夸源型，4-增强型）
        :rtype: int
        """
        return self._NetworkConnectionType

    @NetworkConnectionType.setter
    def NetworkConnectionType(self, NetworkConnectionType):
        self._NetworkConnectionType = NetworkConnectionType

    @property
    def CustomConfig(self):
        r"""自定义配置
        :rtype: list of CustomConfig
        """
        return self._CustomConfig

    @CustomConfig.setter
    def CustomConfig(self, CustomConfig):
        self._CustomConfig = CustomConfig


    def _deserialize(self, params):
        self._DatasourceConnectionName = params.get("DatasourceConnectionName")
        self._DatasourceConnectionType = params.get("DatasourceConnectionType")
        if params.get("DatasourceConnectionConfig") is not None:
            self._DatasourceConnectionConfig = DatasourceConnectionConfig()
            self._DatasourceConnectionConfig._deserialize(params.get("DatasourceConnectionConfig"))
        self._ServiceType = params.get("ServiceType")
        self._DatasourceConnectionDesc = params.get("DatasourceConnectionDesc")
        self._DataEngineNames = params.get("DataEngineNames")
        self._NetworkConnectionName = params.get("NetworkConnectionName")
        self._NetworkConnectionDesc = params.get("NetworkConnectionDesc")
        self._NetworkConnectionType = params.get("NetworkConnectionType")
        if params.get("CustomConfig") is not None:
            self._CustomConfig = []
            for item in params.get("CustomConfig"):
                obj = CustomConfig()
                obj._deserialize(item)
                self._CustomConfig.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDatasourceConnectionResponse(AbstractModel):
    r"""CreateDatasourceConnection返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DatasourceConnectionId: 数据连接Id
        :type DatasourceConnectionId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DatasourceConnectionId = None
        self._RequestId = None

    @property
    def DatasourceConnectionId(self):
        r"""数据连接Id
        :rtype: str
        """
        return self._DatasourceConnectionId

    @DatasourceConnectionId.setter
    def DatasourceConnectionId(self, DatasourceConnectionId):
        self._DatasourceConnectionId = DatasourceConnectionId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DatasourceConnectionId = params.get("DatasourceConnectionId")
        self._RequestId = params.get("RequestId")


class CreateExportTaskRequest(AbstractModel):
    r"""CreateExportTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InputType: 数据来源，lakefsStorage、taskResult
        :type InputType: str
        :param _InputConf: 导出任务输入配置
        :type InputConf: list of KVPair
        :param _OutputConf: 导出任务输出配置
        :type OutputConf: list of KVPair
        :param _OutputType: 目标数据源的类型，目前支持导出到cos
        :type OutputType: str
        """
        self._InputType = None
        self._InputConf = None
        self._OutputConf = None
        self._OutputType = None

    @property
    def InputType(self):
        r"""数据来源，lakefsStorage、taskResult
        :rtype: str
        """
        return self._InputType

    @InputType.setter
    def InputType(self, InputType):
        self._InputType = InputType

    @property
    def InputConf(self):
        r"""导出任务输入配置
        :rtype: list of KVPair
        """
        return self._InputConf

    @InputConf.setter
    def InputConf(self, InputConf):
        self._InputConf = InputConf

    @property
    def OutputConf(self):
        r"""导出任务输出配置
        :rtype: list of KVPair
        """
        return self._OutputConf

    @OutputConf.setter
    def OutputConf(self, OutputConf):
        self._OutputConf = OutputConf

    @property
    def OutputType(self):
        r"""目标数据源的类型，目前支持导出到cos
        :rtype: str
        """
        return self._OutputType

    @OutputType.setter
    def OutputType(self, OutputType):
        self._OutputType = OutputType


    def _deserialize(self, params):
        self._InputType = params.get("InputType")
        if params.get("InputConf") is not None:
            self._InputConf = []
            for item in params.get("InputConf"):
                obj = KVPair()
                obj._deserialize(item)
                self._InputConf.append(obj)
        if params.get("OutputConf") is not None:
            self._OutputConf = []
            for item in params.get("OutputConf"):
                obj = KVPair()
                obj._deserialize(item)
                self._OutputConf.append(obj)
        self._OutputType = params.get("OutputType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateExportTaskResponse(AbstractModel):
    r"""CreateExportTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        r"""任务id
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class CreateImportTaskRequest(AbstractModel):
    r"""CreateImportTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InputType: 数据来源，cos
        :type InputType: str
        :param _InputConf: 输入配置
        :type InputConf: list of KVPair
        :param _OutputConf: 输出配置
        :type OutputConf: list of KVPair
        :param _OutputType: 目标数据源的类型，目前支持导入到托管存储，即lakefsStorage
        :type OutputType: str
        """
        self._InputType = None
        self._InputConf = None
        self._OutputConf = None
        self._OutputType = None

    @property
    def InputType(self):
        r"""数据来源，cos
        :rtype: str
        """
        return self._InputType

    @InputType.setter
    def InputType(self, InputType):
        self._InputType = InputType

    @property
    def InputConf(self):
        r"""输入配置
        :rtype: list of KVPair
        """
        return self._InputConf

    @InputConf.setter
    def InputConf(self, InputConf):
        self._InputConf = InputConf

    @property
    def OutputConf(self):
        r"""输出配置
        :rtype: list of KVPair
        """
        return self._OutputConf

    @OutputConf.setter
    def OutputConf(self, OutputConf):
        self._OutputConf = OutputConf

    @property
    def OutputType(self):
        r"""目标数据源的类型，目前支持导入到托管存储，即lakefsStorage
        :rtype: str
        """
        return self._OutputType

    @OutputType.setter
    def OutputType(self, OutputType):
        self._OutputType = OutputType


    def _deserialize(self, params):
        self._InputType = params.get("InputType")
        if params.get("InputConf") is not None:
            self._InputConf = []
            for item in params.get("InputConf"):
                obj = KVPair()
                obj._deserialize(item)
                self._InputConf.append(obj)
        if params.get("OutputConf") is not None:
            self._OutputConf = []
            for item in params.get("OutputConf"):
                obj = KVPair()
                obj._deserialize(item)
                self._OutputConf.append(obj)
        self._OutputType = params.get("OutputType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateImportTaskResponse(AbstractModel):
    r"""CreateImportTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        r"""任务id
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class CreateInternalTableRequest(AbstractModel):
    r"""CreateInternalTable请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TableBaseInfo: 表基本信息
        :type TableBaseInfo: :class:`tencentcloud.dlc.v20210125.models.TableBaseInfo`
        :param _Columns: 表字段信息
        :type Columns: list of TColumn
        :param _Partitions: 表分区信息
        :type Partitions: list of TPartition
        :param _Properties: 表属性信息
        :type Properties: list of Property
        """
        self._TableBaseInfo = None
        self._Columns = None
        self._Partitions = None
        self._Properties = None

    @property
    def TableBaseInfo(self):
        r"""表基本信息
        :rtype: :class:`tencentcloud.dlc.v20210125.models.TableBaseInfo`
        """
        return self._TableBaseInfo

    @TableBaseInfo.setter
    def TableBaseInfo(self, TableBaseInfo):
        self._TableBaseInfo = TableBaseInfo

    @property
    def Columns(self):
        r"""表字段信息
        :rtype: list of TColumn
        """
        return self._Columns

    @Columns.setter
    def Columns(self, Columns):
        self._Columns = Columns

    @property
    def Partitions(self):
        r"""表分区信息
        :rtype: list of TPartition
        """
        return self._Partitions

    @Partitions.setter
    def Partitions(self, Partitions):
        self._Partitions = Partitions

    @property
    def Properties(self):
        r"""表属性信息
        :rtype: list of Property
        """
        return self._Properties

    @Properties.setter
    def Properties(self, Properties):
        self._Properties = Properties


    def _deserialize(self, params):
        if params.get("TableBaseInfo") is not None:
            self._TableBaseInfo = TableBaseInfo()
            self._TableBaseInfo._deserialize(params.get("TableBaseInfo"))
        if params.get("Columns") is not None:
            self._Columns = []
            for item in params.get("Columns"):
                obj = TColumn()
                obj._deserialize(item)
                self._Columns.append(obj)
        if params.get("Partitions") is not None:
            self._Partitions = []
            for item in params.get("Partitions"):
                obj = TPartition()
                obj._deserialize(item)
                self._Partitions.append(obj)
        if params.get("Properties") is not None:
            self._Properties = []
            for item in params.get("Properties"):
                obj = Property()
                obj._deserialize(item)
                self._Properties.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateInternalTableResponse(AbstractModel):
    r"""CreateInternalTable返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Execution: 创建托管存储内表sql语句描述
        :type Execution: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Execution = None
        self._RequestId = None

    @property
    def Execution(self):
        r"""创建托管存储内表sql语句描述
        :rtype: str
        """
        return self._Execution

    @Execution.setter
    def Execution(self, Execution):
        self._Execution = Execution

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Execution = params.get("Execution")
        self._RequestId = params.get("RequestId")


class CreateNotebookSessionRequest(AbstractModel):
    r"""CreateNotebookSession请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: Session名称
        :type Name: str
        :param _Kind: 类型，当前支持：spark、pyspark、sparkr、sql
        :type Kind: str
        :param _DataEngineName: DLC Spark作业引擎名称
        :type DataEngineName: str
        :param _ProgramDependentFiles: session文件地址，当前支持：cosn://和lakefs://两种路径
        :type ProgramDependentFiles: list of str
        :param _ProgramDependentJars: 依赖的jar程序地址，当前支持：cosn://和lakefs://两种路径
        :type ProgramDependentJars: list of str
        :param _ProgramDependentPython: 依赖的python程序地址，当前支持：cosn://和lakefs://两种路径
        :type ProgramDependentPython: list of str
        :param _ProgramArchives: 依赖的pyspark虚拟环境地址，当前支持：cosn://和lakefs://两种路径
        :type ProgramArchives: list of str
        :param _DriverSize: 指定的Driver规格，当前支持：small（默认，1cu）、medium（2cu）、large（4cu）、xlarge（8cu）
        :type DriverSize: str
        :param _ExecutorSize: 指定的Executor规格，当前支持：small（默认，1cu）、medium（2cu）、large（4cu）、xlarge（8cu）
        :type ExecutorSize: str
        :param _ExecutorNumbers: 指定的Executor数量，默认为1
        :type ExecutorNumbers: int
        :param _Arguments: Session相关配置，当前支持：
1. dlc.eni: 用户配置的eni网关信息，可以通过该字段设置；
2. dlc.role.arn: 用户配置的roleArn鉴权策略配置信息，可以通过该字段设置；
3. dlc.sql.set.config: 用户配置的集群配置信息，可以通过该字段设置；
        :type Arguments: list of KVPair
        :param _ProxyUser: 代理用户，默认为root
        :type ProxyUser: str
        :param _TimeoutInSecond: 指定的Session超时时间，单位秒，默认3600秒
        :type TimeoutInSecond: int
        :param _ExecutorMaxNumbers: 指定的Executor数量（最大值），默认为1，当开启动态分配有效，若未开启，则该值等于ExecutorNumbers
        :type ExecutorMaxNumbers: int
        :param _SparkImage: 指定spark版本名称，当前任务使用该spark镜像运行
        :type SparkImage: str
        :param _IsInherit: 是否继承集群的资源类配置：0：自定义（默认），1：继承集群；
        :type IsInherit: int
        """
        self._Name = None
        self._Kind = None
        self._DataEngineName = None
        self._ProgramDependentFiles = None
        self._ProgramDependentJars = None
        self._ProgramDependentPython = None
        self._ProgramArchives = None
        self._DriverSize = None
        self._ExecutorSize = None
        self._ExecutorNumbers = None
        self._Arguments = None
        self._ProxyUser = None
        self._TimeoutInSecond = None
        self._ExecutorMaxNumbers = None
        self._SparkImage = None
        self._IsInherit = None

    @property
    def Name(self):
        r"""Session名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Kind(self):
        r"""类型，当前支持：spark、pyspark、sparkr、sql
        :rtype: str
        """
        return self._Kind

    @Kind.setter
    def Kind(self, Kind):
        self._Kind = Kind

    @property
    def DataEngineName(self):
        r"""DLC Spark作业引擎名称
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName

    @property
    def ProgramDependentFiles(self):
        r"""session文件地址，当前支持：cosn://和lakefs://两种路径
        :rtype: list of str
        """
        return self._ProgramDependentFiles

    @ProgramDependentFiles.setter
    def ProgramDependentFiles(self, ProgramDependentFiles):
        self._ProgramDependentFiles = ProgramDependentFiles

    @property
    def ProgramDependentJars(self):
        r"""依赖的jar程序地址，当前支持：cosn://和lakefs://两种路径
        :rtype: list of str
        """
        return self._ProgramDependentJars

    @ProgramDependentJars.setter
    def ProgramDependentJars(self, ProgramDependentJars):
        self._ProgramDependentJars = ProgramDependentJars

    @property
    def ProgramDependentPython(self):
        r"""依赖的python程序地址，当前支持：cosn://和lakefs://两种路径
        :rtype: list of str
        """
        return self._ProgramDependentPython

    @ProgramDependentPython.setter
    def ProgramDependentPython(self, ProgramDependentPython):
        self._ProgramDependentPython = ProgramDependentPython

    @property
    def ProgramArchives(self):
        r"""依赖的pyspark虚拟环境地址，当前支持：cosn://和lakefs://两种路径
        :rtype: list of str
        """
        return self._ProgramArchives

    @ProgramArchives.setter
    def ProgramArchives(self, ProgramArchives):
        self._ProgramArchives = ProgramArchives

    @property
    def DriverSize(self):
        r"""指定的Driver规格，当前支持：small（默认，1cu）、medium（2cu）、large（4cu）、xlarge（8cu）
        :rtype: str
        """
        return self._DriverSize

    @DriverSize.setter
    def DriverSize(self, DriverSize):
        self._DriverSize = DriverSize

    @property
    def ExecutorSize(self):
        r"""指定的Executor规格，当前支持：small（默认，1cu）、medium（2cu）、large（4cu）、xlarge（8cu）
        :rtype: str
        """
        return self._ExecutorSize

    @ExecutorSize.setter
    def ExecutorSize(self, ExecutorSize):
        self._ExecutorSize = ExecutorSize

    @property
    def ExecutorNumbers(self):
        r"""指定的Executor数量，默认为1
        :rtype: int
        """
        return self._ExecutorNumbers

    @ExecutorNumbers.setter
    def ExecutorNumbers(self, ExecutorNumbers):
        self._ExecutorNumbers = ExecutorNumbers

    @property
    def Arguments(self):
        r"""Session相关配置，当前支持：
1. dlc.eni: 用户配置的eni网关信息，可以通过该字段设置；
2. dlc.role.arn: 用户配置的roleArn鉴权策略配置信息，可以通过该字段设置；
3. dlc.sql.set.config: 用户配置的集群配置信息，可以通过该字段设置；
        :rtype: list of KVPair
        """
        return self._Arguments

    @Arguments.setter
    def Arguments(self, Arguments):
        self._Arguments = Arguments

    @property
    def ProxyUser(self):
        r"""代理用户，默认为root
        :rtype: str
        """
        return self._ProxyUser

    @ProxyUser.setter
    def ProxyUser(self, ProxyUser):
        self._ProxyUser = ProxyUser

    @property
    def TimeoutInSecond(self):
        r"""指定的Session超时时间，单位秒，默认3600秒
        :rtype: int
        """
        return self._TimeoutInSecond

    @TimeoutInSecond.setter
    def TimeoutInSecond(self, TimeoutInSecond):
        self._TimeoutInSecond = TimeoutInSecond

    @property
    def ExecutorMaxNumbers(self):
        r"""指定的Executor数量（最大值），默认为1，当开启动态分配有效，若未开启，则该值等于ExecutorNumbers
        :rtype: int
        """
        return self._ExecutorMaxNumbers

    @ExecutorMaxNumbers.setter
    def ExecutorMaxNumbers(self, ExecutorMaxNumbers):
        self._ExecutorMaxNumbers = ExecutorMaxNumbers

    @property
    def SparkImage(self):
        r"""指定spark版本名称，当前任务使用该spark镜像运行
        :rtype: str
        """
        return self._SparkImage

    @SparkImage.setter
    def SparkImage(self, SparkImage):
        self._SparkImage = SparkImage

    @property
    def IsInherit(self):
        r"""是否继承集群的资源类配置：0：自定义（默认），1：继承集群；
        :rtype: int
        """
        return self._IsInherit

    @IsInherit.setter
    def IsInherit(self, IsInherit):
        self._IsInherit = IsInherit


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Kind = params.get("Kind")
        self._DataEngineName = params.get("DataEngineName")
        self._ProgramDependentFiles = params.get("ProgramDependentFiles")
        self._ProgramDependentJars = params.get("ProgramDependentJars")
        self._ProgramDependentPython = params.get("ProgramDependentPython")
        self._ProgramArchives = params.get("ProgramArchives")
        self._DriverSize = params.get("DriverSize")
        self._ExecutorSize = params.get("ExecutorSize")
        self._ExecutorNumbers = params.get("ExecutorNumbers")
        if params.get("Arguments") is not None:
            self._Arguments = []
            for item in params.get("Arguments"):
                obj = KVPair()
                obj._deserialize(item)
                self._Arguments.append(obj)
        self._ProxyUser = params.get("ProxyUser")
        self._TimeoutInSecond = params.get("TimeoutInSecond")
        self._ExecutorMaxNumbers = params.get("ExecutorMaxNumbers")
        self._SparkImage = params.get("SparkImage")
        self._IsInherit = params.get("IsInherit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateNotebookSessionResponse(AbstractModel):
    r"""CreateNotebookSession返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SessionId: Session唯一标识
        :type SessionId: str
        :param _SparkAppId: Spark任务返回的AppId
        :type SparkAppId: str
        :param _State: Session状态，包含：not_started（未启动）、starting（已启动）、idle（等待输入）、busy(正在运行statement)、shutting_down（停止）、error（异常）、dead（已退出）、killed（被杀死）、success（正常停止）
        :type State: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SessionId = None
        self._SparkAppId = None
        self._State = None
        self._RequestId = None

    @property
    def SessionId(self):
        r"""Session唯一标识
        :rtype: str
        """
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def SparkAppId(self):
        r"""Spark任务返回的AppId
        :rtype: str
        """
        return self._SparkAppId

    @SparkAppId.setter
    def SparkAppId(self, SparkAppId):
        self._SparkAppId = SparkAppId

    @property
    def State(self):
        r"""Session状态，包含：not_started（未启动）、starting（已启动）、idle（等待输入）、busy(正在运行statement)、shutting_down（停止）、error（异常）、dead（已退出）、killed（被杀死）、success（正常停止）
        :rtype: str
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SessionId = params.get("SessionId")
        self._SparkAppId = params.get("SparkAppId")
        self._State = params.get("State")
        self._RequestId = params.get("RequestId")


class CreateNotebookSessionStatementRequest(AbstractModel):
    r"""CreateNotebookSessionStatement请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SessionId: Session唯一标识
        :type SessionId: str
        :param _Code: 执行的代码
        :type Code: str
        :param _Kind: 类型，当前支持：spark、pyspark、sparkr、sql
        :type Kind: str
        """
        self._SessionId = None
        self._Code = None
        self._Kind = None

    @property
    def SessionId(self):
        r"""Session唯一标识
        :rtype: str
        """
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def Code(self):
        r"""执行的代码
        :rtype: str
        """
        return self._Code

    @Code.setter
    def Code(self, Code):
        self._Code = Code

    @property
    def Kind(self):
        r"""类型，当前支持：spark、pyspark、sparkr、sql
        :rtype: str
        """
        return self._Kind

    @Kind.setter
    def Kind(self, Kind):
        self._Kind = Kind


    def _deserialize(self, params):
        self._SessionId = params.get("SessionId")
        self._Code = params.get("Code")
        self._Kind = params.get("Kind")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateNotebookSessionStatementResponse(AbstractModel):
    r"""CreateNotebookSessionStatement返回参数结构体

    """

    def __init__(self):
        r"""
        :param _NotebookSessionStatement: Session Statement详情
        :type NotebookSessionStatement: :class:`tencentcloud.dlc.v20210125.models.NotebookSessionStatementInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._NotebookSessionStatement = None
        self._RequestId = None

    @property
    def NotebookSessionStatement(self):
        r"""Session Statement详情
        :rtype: :class:`tencentcloud.dlc.v20210125.models.NotebookSessionStatementInfo`
        """
        return self._NotebookSessionStatement

    @NotebookSessionStatement.setter
    def NotebookSessionStatement(self, NotebookSessionStatement):
        self._NotebookSessionStatement = NotebookSessionStatement

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NotebookSessionStatement") is not None:
            self._NotebookSessionStatement = NotebookSessionStatementInfo()
            self._NotebookSessionStatement._deserialize(params.get("NotebookSessionStatement"))
        self._RequestId = params.get("RequestId")


class CreateNotebookSessionStatementSupportBatchSQLRequest(AbstractModel):
    r"""CreateNotebookSessionStatementSupportBatchSQL请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SessionId: Session唯一标识
        :type SessionId: str
        :param _Code: 执行的代码
        :type Code: str
        :param _Kind: 类型，当前支持：sql
        :type Kind: str
        :param _SaveResult: 是否保存运行结果
        :type SaveResult: bool
        """
        self._SessionId = None
        self._Code = None
        self._Kind = None
        self._SaveResult = None

    @property
    def SessionId(self):
        r"""Session唯一标识
        :rtype: str
        """
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def Code(self):
        r"""执行的代码
        :rtype: str
        """
        return self._Code

    @Code.setter
    def Code(self, Code):
        self._Code = Code

    @property
    def Kind(self):
        r"""类型，当前支持：sql
        :rtype: str
        """
        return self._Kind

    @Kind.setter
    def Kind(self, Kind):
        self._Kind = Kind

    @property
    def SaveResult(self):
        r"""是否保存运行结果
        :rtype: bool
        """
        return self._SaveResult

    @SaveResult.setter
    def SaveResult(self, SaveResult):
        self._SaveResult = SaveResult


    def _deserialize(self, params):
        self._SessionId = params.get("SessionId")
        self._Code = params.get("Code")
        self._Kind = params.get("Kind")
        self._SaveResult = params.get("SaveResult")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateNotebookSessionStatementSupportBatchSQLResponse(AbstractModel):
    r"""CreateNotebookSessionStatementSupportBatchSQL返回参数结构体

    """

    def __init__(self):
        r"""
        :param _NotebookSessionStatementBatches: Session Statement详情
        :type NotebookSessionStatementBatches: :class:`tencentcloud.dlc.v20210125.models.NotebookSessionStatementBatchInformation`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._NotebookSessionStatementBatches = None
        self._RequestId = None

    @property
    def NotebookSessionStatementBatches(self):
        r"""Session Statement详情
        :rtype: :class:`tencentcloud.dlc.v20210125.models.NotebookSessionStatementBatchInformation`
        """
        return self._NotebookSessionStatementBatches

    @NotebookSessionStatementBatches.setter
    def NotebookSessionStatementBatches(self, NotebookSessionStatementBatches):
        self._NotebookSessionStatementBatches = NotebookSessionStatementBatches

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NotebookSessionStatementBatches") is not None:
            self._NotebookSessionStatementBatches = NotebookSessionStatementBatchInformation()
            self._NotebookSessionStatementBatches._deserialize(params.get("NotebookSessionStatementBatches"))
        self._RequestId = params.get("RequestId")


class CreateResultDownloadRequest(AbstractModel):
    r"""CreateResultDownload请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 查询结果任务Id
        :type TaskId: str
        :param _Format: 下载格式
        :type Format: str
        :param _Force: 是否重新生成下载文件，仅当之前任务状态为 timeout | error 时有效
        :type Force: bool
        """
        self._TaskId = None
        self._Format = None
        self._Force = None

    @property
    def TaskId(self):
        r"""查询结果任务Id
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Format(self):
        r"""下载格式
        :rtype: str
        """
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def Force(self):
        r"""是否重新生成下载文件，仅当之前任务状态为 timeout | error 时有效
        :rtype: bool
        """
        return self._Force

    @Force.setter
    def Force(self, Force):
        self._Force = Force


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Format = params.get("Format")
        self._Force = params.get("Force")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateResultDownloadResponse(AbstractModel):
    r"""CreateResultDownload返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DownloadId: 下载任务Id
        :type DownloadId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DownloadId = None
        self._RequestId = None

    @property
    def DownloadId(self):
        r"""下载任务Id
        :rtype: str
        """
        return self._DownloadId

    @DownloadId.setter
    def DownloadId(self, DownloadId):
        self._DownloadId = DownloadId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadId = params.get("DownloadId")
        self._RequestId = params.get("RequestId")


class CreateScriptRequest(AbstractModel):
    r"""CreateScript请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ScriptName: 脚本名称，最大不能超过255个字符。
        :type ScriptName: str
        :param _SQLStatement: base64编码后的sql语句
        :type SQLStatement: str
        :param _ScriptDesc: 脚本描述， 不能超过50个字符
        :type ScriptDesc: str
        :param _DatabaseName: 数据库名称
        :type DatabaseName: str
        """
        self._ScriptName = None
        self._SQLStatement = None
        self._ScriptDesc = None
        self._DatabaseName = None

    @property
    def ScriptName(self):
        r"""脚本名称，最大不能超过255个字符。
        :rtype: str
        """
        return self._ScriptName

    @ScriptName.setter
    def ScriptName(self, ScriptName):
        self._ScriptName = ScriptName

    @property
    def SQLStatement(self):
        r"""base64编码后的sql语句
        :rtype: str
        """
        return self._SQLStatement

    @SQLStatement.setter
    def SQLStatement(self, SQLStatement):
        self._SQLStatement = SQLStatement

    @property
    def ScriptDesc(self):
        r"""脚本描述， 不能超过50个字符
        :rtype: str
        """
        return self._ScriptDesc

    @ScriptDesc.setter
    def ScriptDesc(self, ScriptDesc):
        self._ScriptDesc = ScriptDesc

    @property
    def DatabaseName(self):
        r"""数据库名称
        :rtype: str
        """
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName


    def _deserialize(self, params):
        self._ScriptName = params.get("ScriptName")
        self._SQLStatement = params.get("SQLStatement")
        self._ScriptDesc = params.get("ScriptDesc")
        self._DatabaseName = params.get("DatabaseName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateScriptResponse(AbstractModel):
    r"""CreateScript返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateSparkAppRequest(AbstractModel):
    r"""CreateSparkApp请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AppName: spark作业名
        :type AppName: str
        :param _AppType: spark作业类型，1代表spark jar作业，2代表spark streaming作业
        :type AppType: int
        :param _DataEngine: 执行spark作业的数据引擎名称
        :type DataEngine: str
        :param _AppFile: spark作业程序包文件路径
        :type AppFile: str
        :param _RoleArn: 数据访问策略，CAM Role arn，控制台通过数据作业—>作业配置获取，SDK通过DescribeUserRoles接口获取对应的值；
        :type RoleArn: int
        :param _AppDriverSize: 指定的Driver规格，当前支持：small（默认，1cu）、medium（2cu）、large（4cu）、xlarge（8cu）
        :type AppDriverSize: str
        :param _AppExecutorSize: 指定的Executor规格，当前支持：small（默认，1cu）、medium（2cu）、large（4cu）、xlarge（8cu）
        :type AppExecutorSize: str
        :param _AppExecutorNums: spark作业executor个数
        :type AppExecutorNums: int
        :param _Eni: 该字段已下线，请使用字段Datasource
        :type Eni: str
        :param _IsLocal: spark作业程序包是否本地上传，cos：存放与cos，lakefs：本地上传（控制台使用，该方式不支持直接接口调用）
        :type IsLocal: str
        :param _MainClass: spark作业主类
        :type MainClass: str
        :param _AppConf: spark配置，以换行符分隔
        :type AppConf: str
        :param _IsLocalJars: spark 作业依赖jar包是否本地上传，cos：存放与cos，lakefs：本地上传（控制台使用，该方式不支持直接接口调用）
        :type IsLocalJars: str
        :param _AppJars: spark 作业依赖jar包（--jars），以逗号分隔
        :type AppJars: str
        :param _IsLocalFiles: spark作业依赖文件资源是否本地上传，cos：存放与cos，lakefs：本地上传（控制台使用，该方式不支持直接接口调用）
        :type IsLocalFiles: str
        :param _AppFiles: spark作业依赖文件资源（--files）（非jar、zip），以逗号分隔
        :type AppFiles: str
        :param _CmdArgs: spark作业程序入参，空格分割
        :type CmdArgs: str
        :param _MaxRetries: 最大重试次数，只对spark流任务生效
        :type MaxRetries: int
        :param _DataSource: 数据源名称
        :type DataSource: str
        :param _IsLocalPythonFiles: pyspark：依赖上传方式，cos：存放与cos，lakefs：本地上传（控制台使用，该方式不支持直接接口调用）
        :type IsLocalPythonFiles: str
        :param _AppPythonFiles: pyspark作业依赖python资源（--py-files），支持py/zip/egg等归档格式，多文件以逗号分隔
        :type AppPythonFiles: str
        :param _IsLocalArchives: spark作业依赖archives资源是否本地上传，cos：存放与cos，lakefs：本地上传（控制台使用，该方式不支持直接接口调用）
        :type IsLocalArchives: str
        :param _AppArchives: spark作业依赖archives资源（--archives），支持tar.gz/tgz/tar等归档格式，以逗号分隔
        :type AppArchives: str
        :param _SparkImage: Spark Image 版本号
        :type SparkImage: str
        :param _SparkImageVersion: Spark Image 版本名称
        :type SparkImageVersion: str
        :param _AppExecutorMaxNumbers: 指定的Executor数量（最大值），默认为1，当开启动态分配有效，若未开启，则该值等于AppExecutorNums
        :type AppExecutorMaxNumbers: int
        :param _SessionId: 关联dlc查询脚本id
        :type SessionId: str
        :param _IsInherit: 任务资源配置是否继承集群模板，0（默认）不继承，1：继承
        :type IsInherit: int
        :param _IsSessionStarted: 是否使用session脚本的sql运行任务：false：否，true：是
        :type IsSessionStarted: bool
        :param _DependencyPackages: 依赖包信息
        :type DependencyPackages: list of DependencyPackage
        """
        self._AppName = None
        self._AppType = None
        self._DataEngine = None
        self._AppFile = None
        self._RoleArn = None
        self._AppDriverSize = None
        self._AppExecutorSize = None
        self._AppExecutorNums = None
        self._Eni = None
        self._IsLocal = None
        self._MainClass = None
        self._AppConf = None
        self._IsLocalJars = None
        self._AppJars = None
        self._IsLocalFiles = None
        self._AppFiles = None
        self._CmdArgs = None
        self._MaxRetries = None
        self._DataSource = None
        self._IsLocalPythonFiles = None
        self._AppPythonFiles = None
        self._IsLocalArchives = None
        self._AppArchives = None
        self._SparkImage = None
        self._SparkImageVersion = None
        self._AppExecutorMaxNumbers = None
        self._SessionId = None
        self._IsInherit = None
        self._IsSessionStarted = None
        self._DependencyPackages = None

    @property
    def AppName(self):
        r"""spark作业名
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def AppType(self):
        r"""spark作业类型，1代表spark jar作业，2代表spark streaming作业
        :rtype: int
        """
        return self._AppType

    @AppType.setter
    def AppType(self, AppType):
        self._AppType = AppType

    @property
    def DataEngine(self):
        r"""执行spark作业的数据引擎名称
        :rtype: str
        """
        return self._DataEngine

    @DataEngine.setter
    def DataEngine(self, DataEngine):
        self._DataEngine = DataEngine

    @property
    def AppFile(self):
        r"""spark作业程序包文件路径
        :rtype: str
        """
        return self._AppFile

    @AppFile.setter
    def AppFile(self, AppFile):
        self._AppFile = AppFile

    @property
    def RoleArn(self):
        r"""数据访问策略，CAM Role arn，控制台通过数据作业—>作业配置获取，SDK通过DescribeUserRoles接口获取对应的值；
        :rtype: int
        """
        return self._RoleArn

    @RoleArn.setter
    def RoleArn(self, RoleArn):
        self._RoleArn = RoleArn

    @property
    def AppDriverSize(self):
        r"""指定的Driver规格，当前支持：small（默认，1cu）、medium（2cu）、large（4cu）、xlarge（8cu）
        :rtype: str
        """
        return self._AppDriverSize

    @AppDriverSize.setter
    def AppDriverSize(self, AppDriverSize):
        self._AppDriverSize = AppDriverSize

    @property
    def AppExecutorSize(self):
        r"""指定的Executor规格，当前支持：small（默认，1cu）、medium（2cu）、large（4cu）、xlarge（8cu）
        :rtype: str
        """
        return self._AppExecutorSize

    @AppExecutorSize.setter
    def AppExecutorSize(self, AppExecutorSize):
        self._AppExecutorSize = AppExecutorSize

    @property
    def AppExecutorNums(self):
        r"""spark作业executor个数
        :rtype: int
        """
        return self._AppExecutorNums

    @AppExecutorNums.setter
    def AppExecutorNums(self, AppExecutorNums):
        self._AppExecutorNums = AppExecutorNums

    @property
    def Eni(self):
        r"""该字段已下线，请使用字段Datasource
        :rtype: str
        """
        return self._Eni

    @Eni.setter
    def Eni(self, Eni):
        self._Eni = Eni

    @property
    def IsLocal(self):
        r"""spark作业程序包是否本地上传，cos：存放与cos，lakefs：本地上传（控制台使用，该方式不支持直接接口调用）
        :rtype: str
        """
        return self._IsLocal

    @IsLocal.setter
    def IsLocal(self, IsLocal):
        self._IsLocal = IsLocal

    @property
    def MainClass(self):
        r"""spark作业主类
        :rtype: str
        """
        return self._MainClass

    @MainClass.setter
    def MainClass(self, MainClass):
        self._MainClass = MainClass

    @property
    def AppConf(self):
        r"""spark配置，以换行符分隔
        :rtype: str
        """
        return self._AppConf

    @AppConf.setter
    def AppConf(self, AppConf):
        self._AppConf = AppConf

    @property
    def IsLocalJars(self):
        r"""spark 作业依赖jar包是否本地上传，cos：存放与cos，lakefs：本地上传（控制台使用，该方式不支持直接接口调用）
        :rtype: str
        """
        return self._IsLocalJars

    @IsLocalJars.setter
    def IsLocalJars(self, IsLocalJars):
        self._IsLocalJars = IsLocalJars

    @property
    def AppJars(self):
        r"""spark 作业依赖jar包（--jars），以逗号分隔
        :rtype: str
        """
        return self._AppJars

    @AppJars.setter
    def AppJars(self, AppJars):
        self._AppJars = AppJars

    @property
    def IsLocalFiles(self):
        r"""spark作业依赖文件资源是否本地上传，cos：存放与cos，lakefs：本地上传（控制台使用，该方式不支持直接接口调用）
        :rtype: str
        """
        return self._IsLocalFiles

    @IsLocalFiles.setter
    def IsLocalFiles(self, IsLocalFiles):
        self._IsLocalFiles = IsLocalFiles

    @property
    def AppFiles(self):
        r"""spark作业依赖文件资源（--files）（非jar、zip），以逗号分隔
        :rtype: str
        """
        return self._AppFiles

    @AppFiles.setter
    def AppFiles(self, AppFiles):
        self._AppFiles = AppFiles

    @property
    def CmdArgs(self):
        r"""spark作业程序入参，空格分割
        :rtype: str
        """
        return self._CmdArgs

    @CmdArgs.setter
    def CmdArgs(self, CmdArgs):
        self._CmdArgs = CmdArgs

    @property
    def MaxRetries(self):
        r"""最大重试次数，只对spark流任务生效
        :rtype: int
        """
        return self._MaxRetries

    @MaxRetries.setter
    def MaxRetries(self, MaxRetries):
        self._MaxRetries = MaxRetries

    @property
    def DataSource(self):
        r"""数据源名称
        :rtype: str
        """
        return self._DataSource

    @DataSource.setter
    def DataSource(self, DataSource):
        self._DataSource = DataSource

    @property
    def IsLocalPythonFiles(self):
        r"""pyspark：依赖上传方式，cos：存放与cos，lakefs：本地上传（控制台使用，该方式不支持直接接口调用）
        :rtype: str
        """
        return self._IsLocalPythonFiles

    @IsLocalPythonFiles.setter
    def IsLocalPythonFiles(self, IsLocalPythonFiles):
        self._IsLocalPythonFiles = IsLocalPythonFiles

    @property
    def AppPythonFiles(self):
        r"""pyspark作业依赖python资源（--py-files），支持py/zip/egg等归档格式，多文件以逗号分隔
        :rtype: str
        """
        return self._AppPythonFiles

    @AppPythonFiles.setter
    def AppPythonFiles(self, AppPythonFiles):
        self._AppPythonFiles = AppPythonFiles

    @property
    def IsLocalArchives(self):
        r"""spark作业依赖archives资源是否本地上传，cos：存放与cos，lakefs：本地上传（控制台使用，该方式不支持直接接口调用）
        :rtype: str
        """
        return self._IsLocalArchives

    @IsLocalArchives.setter
    def IsLocalArchives(self, IsLocalArchives):
        self._IsLocalArchives = IsLocalArchives

    @property
    def AppArchives(self):
        r"""spark作业依赖archives资源（--archives），支持tar.gz/tgz/tar等归档格式，以逗号分隔
        :rtype: str
        """
        return self._AppArchives

    @AppArchives.setter
    def AppArchives(self, AppArchives):
        self._AppArchives = AppArchives

    @property
    def SparkImage(self):
        r"""Spark Image 版本号
        :rtype: str
        """
        return self._SparkImage

    @SparkImage.setter
    def SparkImage(self, SparkImage):
        self._SparkImage = SparkImage

    @property
    def SparkImageVersion(self):
        r"""Spark Image 版本名称
        :rtype: str
        """
        return self._SparkImageVersion

    @SparkImageVersion.setter
    def SparkImageVersion(self, SparkImageVersion):
        self._SparkImageVersion = SparkImageVersion

    @property
    def AppExecutorMaxNumbers(self):
        r"""指定的Executor数量（最大值），默认为1，当开启动态分配有效，若未开启，则该值等于AppExecutorNums
        :rtype: int
        """
        return self._AppExecutorMaxNumbers

    @AppExecutorMaxNumbers.setter
    def AppExecutorMaxNumbers(self, AppExecutorMaxNumbers):
        self._AppExecutorMaxNumbers = AppExecutorMaxNumbers

    @property
    def SessionId(self):
        r"""关联dlc查询脚本id
        :rtype: str
        """
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def IsInherit(self):
        r"""任务资源配置是否继承集群模板，0（默认）不继承，1：继承
        :rtype: int
        """
        return self._IsInherit

    @IsInherit.setter
    def IsInherit(self, IsInherit):
        self._IsInherit = IsInherit

    @property
    def IsSessionStarted(self):
        r"""是否使用session脚本的sql运行任务：false：否，true：是
        :rtype: bool
        """
        return self._IsSessionStarted

    @IsSessionStarted.setter
    def IsSessionStarted(self, IsSessionStarted):
        self._IsSessionStarted = IsSessionStarted

    @property
    def DependencyPackages(self):
        r"""依赖包信息
        :rtype: list of DependencyPackage
        """
        return self._DependencyPackages

    @DependencyPackages.setter
    def DependencyPackages(self, DependencyPackages):
        self._DependencyPackages = DependencyPackages


    def _deserialize(self, params):
        self._AppName = params.get("AppName")
        self._AppType = params.get("AppType")
        self._DataEngine = params.get("DataEngine")
        self._AppFile = params.get("AppFile")
        self._RoleArn = params.get("RoleArn")
        self._AppDriverSize = params.get("AppDriverSize")
        self._AppExecutorSize = params.get("AppExecutorSize")
        self._AppExecutorNums = params.get("AppExecutorNums")
        self._Eni = params.get("Eni")
        self._IsLocal = params.get("IsLocal")
        self._MainClass = params.get("MainClass")
        self._AppConf = params.get("AppConf")
        self._IsLocalJars = params.get("IsLocalJars")
        self._AppJars = params.get("AppJars")
        self._IsLocalFiles = params.get("IsLocalFiles")
        self._AppFiles = params.get("AppFiles")
        self._CmdArgs = params.get("CmdArgs")
        self._MaxRetries = params.get("MaxRetries")
        self._DataSource = params.get("DataSource")
        self._IsLocalPythonFiles = params.get("IsLocalPythonFiles")
        self._AppPythonFiles = params.get("AppPythonFiles")
        self._IsLocalArchives = params.get("IsLocalArchives")
        self._AppArchives = params.get("AppArchives")
        self._SparkImage = params.get("SparkImage")
        self._SparkImageVersion = params.get("SparkImageVersion")
        self._AppExecutorMaxNumbers = params.get("AppExecutorMaxNumbers")
        self._SessionId = params.get("SessionId")
        self._IsInherit = params.get("IsInherit")
        self._IsSessionStarted = params.get("IsSessionStarted")
        if params.get("DependencyPackages") is not None:
            self._DependencyPackages = []
            for item in params.get("DependencyPackages"):
                obj = DependencyPackage()
                obj._deserialize(item)
                self._DependencyPackages.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSparkAppResponse(AbstractModel):
    r"""CreateSparkApp返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SparkAppId: App唯一标识
        :type SparkAppId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SparkAppId = None
        self._RequestId = None

    @property
    def SparkAppId(self):
        r"""App唯一标识
        :rtype: str
        """
        return self._SparkAppId

    @SparkAppId.setter
    def SparkAppId(self, SparkAppId):
        self._SparkAppId = SparkAppId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SparkAppId = params.get("SparkAppId")
        self._RequestId = params.get("RequestId")


class CreateSparkAppTaskRequest(AbstractModel):
    r"""CreateSparkAppTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _JobName: spark作业名
        :type JobName: str
        :param _CmdArgs: spark作业程序入参，以空格分隔；一般用于周期性调用使用
        :type CmdArgs: str
        :param _SourceInfo: 任务来源信息
        :type SourceInfo: list of KVPair
        """
        self._JobName = None
        self._CmdArgs = None
        self._SourceInfo = None

    @property
    def JobName(self):
        r"""spark作业名
        :rtype: str
        """
        return self._JobName

    @JobName.setter
    def JobName(self, JobName):
        self._JobName = JobName

    @property
    def CmdArgs(self):
        r"""spark作业程序入参，以空格分隔；一般用于周期性调用使用
        :rtype: str
        """
        return self._CmdArgs

    @CmdArgs.setter
    def CmdArgs(self, CmdArgs):
        self._CmdArgs = CmdArgs

    @property
    def SourceInfo(self):
        r"""任务来源信息
        :rtype: list of KVPair
        """
        return self._SourceInfo

    @SourceInfo.setter
    def SourceInfo(self, SourceInfo):
        self._SourceInfo = SourceInfo


    def _deserialize(self, params):
        self._JobName = params.get("JobName")
        self._CmdArgs = params.get("CmdArgs")
        if params.get("SourceInfo") is not None:
            self._SourceInfo = []
            for item in params.get("SourceInfo"):
                obj = KVPair()
                obj._deserialize(item)
                self._SourceInfo.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSparkAppTaskResponse(AbstractModel):
    r"""CreateSparkAppTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _BatchId: 批Id
        :type BatchId: str
        :param _TaskId: 任务Id
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._BatchId = None
        self._TaskId = None
        self._RequestId = None

    @property
    def BatchId(self):
        r"""批Id
        :rtype: str
        """
        return self._BatchId

    @BatchId.setter
    def BatchId(self, BatchId):
        self._BatchId = BatchId

    @property
    def TaskId(self):
        r"""任务Id
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._BatchId = params.get("BatchId")
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class CreateSparkSessionBatchSQLRequest(AbstractModel):
    r"""CreateSparkSessionBatchSQL请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DataEngineName: DLC Spark作业引擎名称
        :type DataEngineName: str
        :param _ExecuteSQL: 运行sql，需要base64编码。
        :type ExecuteSQL: str
        :param _DriverSize: 指定的Driver规格，当前支持：small（默认，1cu）、medium（2cu）、large（4cu）、xlarge（8cu）
        :type DriverSize: str
        :param _ExecutorSize: 指定的Executor规格，当前支持：small（默认，1cu）、medium（2cu）、large（4cu）、xlarge（8cu）
        :type ExecutorSize: str
        :param _ExecutorNumbers: 指定的Executor数量，默认为1
        :type ExecutorNumbers: int
        :param _ExecutorMaxNumbers: 指定的Executor数量（最大值），默认为1，当开启动态分配有效，若未开启，则该值等于ExecutorNumbers
        :type ExecutorMaxNumbers: int
        :param _TimeoutInSecond: 指定的Session超时时间，单位秒，默认3600秒
        :type TimeoutInSecond: int
        :param _SessionId: Session唯一标识，当指定sessionid，则使用该session运行任务。
        :type SessionId: str
        :param _SessionName: 指定要创建的session名称
        :type SessionName: str
        :param _Arguments: Session相关配置，当前支持：1.dlc.eni：用户配置的eni网关信息，可以用过该字段设置；
2.dlc.role.arn：用户配置的roleArn鉴权策略配置信息，可以用过该字段设置；
3.dlc.sql.set.config：用户配置的集群配置信息，可以用过该字段设置；
        :type Arguments: list of KVPair
        :param _IsInherit: 是否继承集群的资源类配置：0：不继承（默认），1：继承集群；
        :type IsInherit: int
        :param _CustomKey: 用户自定义主键，需唯一
        :type CustomKey: str
        :param _SourceInfo: 任务来源信息
        :type SourceInfo: list of KVPair
        """
        self._DataEngineName = None
        self._ExecuteSQL = None
        self._DriverSize = None
        self._ExecutorSize = None
        self._ExecutorNumbers = None
        self._ExecutorMaxNumbers = None
        self._TimeoutInSecond = None
        self._SessionId = None
        self._SessionName = None
        self._Arguments = None
        self._IsInherit = None
        self._CustomKey = None
        self._SourceInfo = None

    @property
    def DataEngineName(self):
        r"""DLC Spark作业引擎名称
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName

    @property
    def ExecuteSQL(self):
        r"""运行sql，需要base64编码。
        :rtype: str
        """
        return self._ExecuteSQL

    @ExecuteSQL.setter
    def ExecuteSQL(self, ExecuteSQL):
        self._ExecuteSQL = ExecuteSQL

    @property
    def DriverSize(self):
        r"""指定的Driver规格，当前支持：small（默认，1cu）、medium（2cu）、large（4cu）、xlarge（8cu）
        :rtype: str
        """
        return self._DriverSize

    @DriverSize.setter
    def DriverSize(self, DriverSize):
        self._DriverSize = DriverSize

    @property
    def ExecutorSize(self):
        r"""指定的Executor规格，当前支持：small（默认，1cu）、medium（2cu）、large（4cu）、xlarge（8cu）
        :rtype: str
        """
        return self._ExecutorSize

    @ExecutorSize.setter
    def ExecutorSize(self, ExecutorSize):
        self._ExecutorSize = ExecutorSize

    @property
    def ExecutorNumbers(self):
        r"""指定的Executor数量，默认为1
        :rtype: int
        """
        return self._ExecutorNumbers

    @ExecutorNumbers.setter
    def ExecutorNumbers(self, ExecutorNumbers):
        self._ExecutorNumbers = ExecutorNumbers

    @property
    def ExecutorMaxNumbers(self):
        r"""指定的Executor数量（最大值），默认为1，当开启动态分配有效，若未开启，则该值等于ExecutorNumbers
        :rtype: int
        """
        return self._ExecutorMaxNumbers

    @ExecutorMaxNumbers.setter
    def ExecutorMaxNumbers(self, ExecutorMaxNumbers):
        self._ExecutorMaxNumbers = ExecutorMaxNumbers

    @property
    def TimeoutInSecond(self):
        r"""指定的Session超时时间，单位秒，默认3600秒
        :rtype: int
        """
        return self._TimeoutInSecond

    @TimeoutInSecond.setter
    def TimeoutInSecond(self, TimeoutInSecond):
        self._TimeoutInSecond = TimeoutInSecond

    @property
    def SessionId(self):
        r"""Session唯一标识，当指定sessionid，则使用该session运行任务。
        :rtype: str
        """
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def SessionName(self):
        r"""指定要创建的session名称
        :rtype: str
        """
        return self._SessionName

    @SessionName.setter
    def SessionName(self, SessionName):
        self._SessionName = SessionName

    @property
    def Arguments(self):
        r"""Session相关配置，当前支持：1.dlc.eni：用户配置的eni网关信息，可以用过该字段设置；
2.dlc.role.arn：用户配置的roleArn鉴权策略配置信息，可以用过该字段设置；
3.dlc.sql.set.config：用户配置的集群配置信息，可以用过该字段设置；
        :rtype: list of KVPair
        """
        return self._Arguments

    @Arguments.setter
    def Arguments(self, Arguments):
        self._Arguments = Arguments

    @property
    def IsInherit(self):
        r"""是否继承集群的资源类配置：0：不继承（默认），1：继承集群；
        :rtype: int
        """
        return self._IsInherit

    @IsInherit.setter
    def IsInherit(self, IsInherit):
        self._IsInherit = IsInherit

    @property
    def CustomKey(self):
        r"""用户自定义主键，需唯一
        :rtype: str
        """
        return self._CustomKey

    @CustomKey.setter
    def CustomKey(self, CustomKey):
        self._CustomKey = CustomKey

    @property
    def SourceInfo(self):
        r"""任务来源信息
        :rtype: list of KVPair
        """
        return self._SourceInfo

    @SourceInfo.setter
    def SourceInfo(self, SourceInfo):
        self._SourceInfo = SourceInfo


    def _deserialize(self, params):
        self._DataEngineName = params.get("DataEngineName")
        self._ExecuteSQL = params.get("ExecuteSQL")
        self._DriverSize = params.get("DriverSize")
        self._ExecutorSize = params.get("ExecutorSize")
        self._ExecutorNumbers = params.get("ExecutorNumbers")
        self._ExecutorMaxNumbers = params.get("ExecutorMaxNumbers")
        self._TimeoutInSecond = params.get("TimeoutInSecond")
        self._SessionId = params.get("SessionId")
        self._SessionName = params.get("SessionName")
        if params.get("Arguments") is not None:
            self._Arguments = []
            for item in params.get("Arguments"):
                obj = KVPair()
                obj._deserialize(item)
                self._Arguments.append(obj)
        self._IsInherit = params.get("IsInherit")
        self._CustomKey = params.get("CustomKey")
        if params.get("SourceInfo") is not None:
            self._SourceInfo = []
            for item in params.get("SourceInfo"):
                obj = KVPair()
                obj._deserialize(item)
                self._SourceInfo.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSparkSessionBatchSQLResponse(AbstractModel):
    r"""CreateSparkSessionBatchSQL返回参数结构体

    """

    def __init__(self):
        r"""
        :param _BatchId: 批任务唯一标识
        :type BatchId: str
        :param _Statements: Statement任务列表信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Statements: list of StatementInformation
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._BatchId = None
        self._Statements = None
        self._RequestId = None

    @property
    def BatchId(self):
        r"""批任务唯一标识
        :rtype: str
        """
        return self._BatchId

    @BatchId.setter
    def BatchId(self, BatchId):
        self._BatchId = BatchId

    @property
    def Statements(self):
        r"""Statement任务列表信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of StatementInformation
        """
        return self._Statements

    @Statements.setter
    def Statements(self, Statements):
        self._Statements = Statements

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._BatchId = params.get("BatchId")
        if params.get("Statements") is not None:
            self._Statements = []
            for item in params.get("Statements"):
                obj = StatementInformation()
                obj._deserialize(item)
                self._Statements.append(obj)
        self._RequestId = params.get("RequestId")


class CreateSparkSubmitTaskRequest(AbstractModel):
    r"""CreateSparkSubmitTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskName: 任务名称
        :type TaskName: str
        :param _TaskType: 任务类型：当前支持1: BatchType, 2: StreamingType, 4: SQLType
        :type TaskType: int
        :param _DataEngineName: 引擎名称，当前仅支持Spark批作业集群
        :type DataEngineName: str
        :param _PackagePath: 指定运行的程序脚本路径，当前仅支持jar和py，对于SQLType该值设为空字符串
        :type PackagePath: str
        :param _RoleArn: 指定的鉴权信息
        :type RoleArn: int
        :param _IsInherit: 运行任务所需资源是否继承自集群上配置资源信息，0（默认，不继承）、1（继承，当设置为该值，则任务级资源配置可不额外指定）
        :type IsInherit: int
        :param _MainClass: jar任务时需要指定主程序
        :type MainClass: str
        :param _DriverSize: 当前DriverSize规格仅支持（内存型集群则使用m前缀的枚举值）: small/medium/large/xlarge/m.small/m.medium/m.large/m.xlarge
        :type DriverSize: str
        :param _ExecutorSize: 当前ExecutorSize规格仅支持（内存型集群则使用m前缀的枚举值）: small/medium/large/xlarge/m.small/m.medium/m.large/m.xlarge
        :type ExecutorSize: str
        :param _ExecutorNumbers: 指定使用的executor数量，最小为1
        :type ExecutorNumbers: int
        :param _ExecutorMaxNumbers: 指定使用的executor最大数量, 当该值大于ExecutorNums则自动开启动态
        :type ExecutorMaxNumbers: int
        :param _CmdArgs: 提交任务的附加配置集合，当前支持Key包含：MAINARGS：程序入口参数，空格分割(SqlType任务通过该值指定base64加密后的sql)、SPARKCONFIG：Spark配置，以换行符分隔、ENI：Eni连接信息、DEPENDENCYPACKAGEPATH：依赖的程序包（--jars、--py-files:支持py/zip/egg等归档格式），多文件以逗号分隔、DEPENDENCYFILEPATH：依赖文件资源（--files: 非jar、zip），多文件以逗号分隔、DEPENDENCYARCHIVESPATH：依赖archives资源（--archives: 支持tar.gz/tgz/tar等归档格式)，多文件以逗号分隔、MAXRETRIES：任务重试次数，非流任务默认为1、SPARKIMAGE：Spark镜像版本号，支持使用dlc镜像/用户自定的tcr镜像运行任务、SPARKIMAGEVERSION：Spark镜像版本名称，与SPARKIMAGE一一对应；SPARKPRESETCODE：base64后的notebook预置代码；SPARKENV：base64后的spark环境变量；SPARKGITINFO：base64后的git相关信息
        :type CmdArgs: list of KVPair
        :param _SourceInfo: 任务来源信息
        :type SourceInfo: list of KVPair
        :param _ResourceGroupName: ai资源组名称
        :type ResourceGroupName: str
        """
        self._TaskName = None
        self._TaskType = None
        self._DataEngineName = None
        self._PackagePath = None
        self._RoleArn = None
        self._IsInherit = None
        self._MainClass = None
        self._DriverSize = None
        self._ExecutorSize = None
        self._ExecutorNumbers = None
        self._ExecutorMaxNumbers = None
        self._CmdArgs = None
        self._SourceInfo = None
        self._ResourceGroupName = None

    @property
    def TaskName(self):
        r"""任务名称
        :rtype: str
        """
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def TaskType(self):
        r"""任务类型：当前支持1: BatchType, 2: StreamingType, 4: SQLType
        :rtype: int
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def DataEngineName(self):
        r"""引擎名称，当前仅支持Spark批作业集群
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName

    @property
    def PackagePath(self):
        r"""指定运行的程序脚本路径，当前仅支持jar和py，对于SQLType该值设为空字符串
        :rtype: str
        """
        return self._PackagePath

    @PackagePath.setter
    def PackagePath(self, PackagePath):
        self._PackagePath = PackagePath

    @property
    def RoleArn(self):
        r"""指定的鉴权信息
        :rtype: int
        """
        return self._RoleArn

    @RoleArn.setter
    def RoleArn(self, RoleArn):
        self._RoleArn = RoleArn

    @property
    def IsInherit(self):
        r"""运行任务所需资源是否继承自集群上配置资源信息，0（默认，不继承）、1（继承，当设置为该值，则任务级资源配置可不额外指定）
        :rtype: int
        """
        return self._IsInherit

    @IsInherit.setter
    def IsInherit(self, IsInherit):
        self._IsInherit = IsInherit

    @property
    def MainClass(self):
        r"""jar任务时需要指定主程序
        :rtype: str
        """
        return self._MainClass

    @MainClass.setter
    def MainClass(self, MainClass):
        self._MainClass = MainClass

    @property
    def DriverSize(self):
        r"""当前DriverSize规格仅支持（内存型集群则使用m前缀的枚举值）: small/medium/large/xlarge/m.small/m.medium/m.large/m.xlarge
        :rtype: str
        """
        return self._DriverSize

    @DriverSize.setter
    def DriverSize(self, DriverSize):
        self._DriverSize = DriverSize

    @property
    def ExecutorSize(self):
        r"""当前ExecutorSize规格仅支持（内存型集群则使用m前缀的枚举值）: small/medium/large/xlarge/m.small/m.medium/m.large/m.xlarge
        :rtype: str
        """
        return self._ExecutorSize

    @ExecutorSize.setter
    def ExecutorSize(self, ExecutorSize):
        self._ExecutorSize = ExecutorSize

    @property
    def ExecutorNumbers(self):
        r"""指定使用的executor数量，最小为1
        :rtype: int
        """
        return self._ExecutorNumbers

    @ExecutorNumbers.setter
    def ExecutorNumbers(self, ExecutorNumbers):
        self._ExecutorNumbers = ExecutorNumbers

    @property
    def ExecutorMaxNumbers(self):
        r"""指定使用的executor最大数量, 当该值大于ExecutorNums则自动开启动态
        :rtype: int
        """
        return self._ExecutorMaxNumbers

    @ExecutorMaxNumbers.setter
    def ExecutorMaxNumbers(self, ExecutorMaxNumbers):
        self._ExecutorMaxNumbers = ExecutorMaxNumbers

    @property
    def CmdArgs(self):
        r"""提交任务的附加配置集合，当前支持Key包含：MAINARGS：程序入口参数，空格分割(SqlType任务通过该值指定base64加密后的sql)、SPARKCONFIG：Spark配置，以换行符分隔、ENI：Eni连接信息、DEPENDENCYPACKAGEPATH：依赖的程序包（--jars、--py-files:支持py/zip/egg等归档格式），多文件以逗号分隔、DEPENDENCYFILEPATH：依赖文件资源（--files: 非jar、zip），多文件以逗号分隔、DEPENDENCYARCHIVESPATH：依赖archives资源（--archives: 支持tar.gz/tgz/tar等归档格式)，多文件以逗号分隔、MAXRETRIES：任务重试次数，非流任务默认为1、SPARKIMAGE：Spark镜像版本号，支持使用dlc镜像/用户自定的tcr镜像运行任务、SPARKIMAGEVERSION：Spark镜像版本名称，与SPARKIMAGE一一对应；SPARKPRESETCODE：base64后的notebook预置代码；SPARKENV：base64后的spark环境变量；SPARKGITINFO：base64后的git相关信息
        :rtype: list of KVPair
        """
        return self._CmdArgs

    @CmdArgs.setter
    def CmdArgs(self, CmdArgs):
        self._CmdArgs = CmdArgs

    @property
    def SourceInfo(self):
        r"""任务来源信息
        :rtype: list of KVPair
        """
        return self._SourceInfo

    @SourceInfo.setter
    def SourceInfo(self, SourceInfo):
        self._SourceInfo = SourceInfo

    @property
    def ResourceGroupName(self):
        r"""ai资源组名称
        :rtype: str
        """
        return self._ResourceGroupName

    @ResourceGroupName.setter
    def ResourceGroupName(self, ResourceGroupName):
        self._ResourceGroupName = ResourceGroupName


    def _deserialize(self, params):
        self._TaskName = params.get("TaskName")
        self._TaskType = params.get("TaskType")
        self._DataEngineName = params.get("DataEngineName")
        self._PackagePath = params.get("PackagePath")
        self._RoleArn = params.get("RoleArn")
        self._IsInherit = params.get("IsInherit")
        self._MainClass = params.get("MainClass")
        self._DriverSize = params.get("DriverSize")
        self._ExecutorSize = params.get("ExecutorSize")
        self._ExecutorNumbers = params.get("ExecutorNumbers")
        self._ExecutorMaxNumbers = params.get("ExecutorMaxNumbers")
        if params.get("CmdArgs") is not None:
            self._CmdArgs = []
            for item in params.get("CmdArgs"):
                obj = KVPair()
                obj._deserialize(item)
                self._CmdArgs.append(obj)
        if params.get("SourceInfo") is not None:
            self._SourceInfo = []
            for item in params.get("SourceInfo"):
                obj = KVPair()
                obj._deserialize(item)
                self._SourceInfo.append(obj)
        self._ResourceGroupName = params.get("ResourceGroupName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSparkSubmitTaskResponse(AbstractModel):
    r"""CreateSparkSubmitTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _BatchId: 批作业ID
        :type BatchId: str
        :param _TaskId: 批任务ID，用改ID进行任务的查询与删除等
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._BatchId = None
        self._TaskId = None
        self._RequestId = None

    @property
    def BatchId(self):
        r"""批作业ID
        :rtype: str
        """
        return self._BatchId

    @BatchId.setter
    def BatchId(self, BatchId):
        self._BatchId = BatchId

    @property
    def TaskId(self):
        r"""批任务ID，用改ID进行任务的查询与删除等
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._BatchId = params.get("BatchId")
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class CreateStandardEngineResourceGroupRequest(AbstractModel):
    r"""CreateStandardEngineResourceGroup请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EngineResourceGroupName: 标准引擎资源组名称
        :type EngineResourceGroupName: str
        :param _DataEngineName: 标准引擎名称
        :type DataEngineName: str
        :param _AutoLaunch: 自动启动，（任务提交自动拉起资源组）0-自动启动，1-不自动启动
        :type AutoLaunch: int
        :param _AutoPause: 自动挂起资源组。0-自动挂起，1-不自动挂起
        :type AutoPause: int
        :param _DriverCuSpec: driver的cu规格：
当前支持：small（默认，1cu）、medium（2cu）、large（4cu）、xlarge（8cu），内存型cu为cpu：men=1:8，m.small（1cu内存型）、m.medium（2cu内存型）、m.large（4cu内存型）、m.xlarge（8cu内存型）
        :type DriverCuSpec: str
        :param _ExecutorCuSpec: executor的cu规格：
当前支持：small（默认，1cu）、medium（2cu）、large（4cu）、xlarge（8cu），内存型cu为cpu：men=1:8，m.small（1cu内存型）、m.medium（2cu内存型）、m.large（4cu内存型）、m.xlarge（8cu内存型）
        :type ExecutorCuSpec: str
        :param _MinExecutorNums: executor最小数量，
        :type MinExecutorNums: int
        :param _MaxExecutorNums: executor最大数量
        :type MaxExecutorNums: int
        :param _IsLaunchNow: 创建资源组后是否直接拉起，0-拉起，1-不拉起
        :type IsLaunchNow: int
        :param _AutoPauseTime: 自动挂起时间，单位分钟，取值范围在1-999（在无任务AutoPauseTime后，资源组自动挂起）
        :type AutoPauseTime: int
        :param _StaticConfigPairs: 资源组静态参数，需要重启资源组生效
        :type StaticConfigPairs: list of EngineResourceGroupConfigPair
        :param _DynamicConfigPairs: 资源组动态参数，下一个任务生效。
        :type DynamicConfigPairs: list of EngineResourceGroupConfigPair
        :param _MaxConcurrency: 任务并发数，默人是5个
        :type MaxConcurrency: int
        :param _NetworkConfigNames: 网络配置名称
        :type NetworkConfigNames: list of str
        :param _PublicDomain: 自定义镜像域名
        :type PublicDomain: str
        :param _RegistryId: 自定义镜像实例id
        :type RegistryId: str
        :param _FrameType: AI类型资源组的框架类型，machine-learning，python，spark-ml，不填默认为machine-learning
        :type FrameType: str
        :param _ImageType: 镜像类型，bulit-in：内置，custom：自定义，不填默认为bulit-in
        :type ImageType: str
        :param _ImageName: 镜像名称
        :type ImageName: str
        :param _ImageVersion: 镜像id
        :type ImageVersion: str
        :param _Size: AI资源组有效，资源组可用资源上限，该值需要小于引擎资源上限
        :type Size: int
        :param _ResourceGroupScene: 资源组场景
        :type ResourceGroupScene: str
        :param _RegionName: 自定义镜像所在地域
        :type RegionName: str
        :param _PythonCuSpec: python类型资源组python单机节点资源上限，该值要小于资源组的资源上限.small:1cu medium:2cu large:4cu xlarge:8cu 4xlarge:16cu 8xlarge:32cu 16xlarge:64cu，如果是高内存型资源，在类型前面加上m.
        :type PythonCuSpec: str
        :param _SparkSpecMode: 仅SQL资源组资源配置模式，fast：快速模式，custom：自定义模式
        :type SparkSpecMode: str
        :param _SparkSize: 仅SQL资源组资源上限，仅用于快速模块
        :type SparkSize: int
        :param _DriverGPUSpec: GPUDriver规格
        :type DriverGPUSpec: int
        :param _ExecutorGPUSpec: GPUExecutor规格
        :type ExecutorGPUSpec: int
        :param _GPULimitSize: GPU上限
        :type GPULimitSize: int
        :param _GPUSize: GPU规格
        :type GPUSize: int
        :param _PythonGPUSpec: Pod GPU规格上限
        :type PythonGPUSpec: int
        """
        self._EngineResourceGroupName = None
        self._DataEngineName = None
        self._AutoLaunch = None
        self._AutoPause = None
        self._DriverCuSpec = None
        self._ExecutorCuSpec = None
        self._MinExecutorNums = None
        self._MaxExecutorNums = None
        self._IsLaunchNow = None
        self._AutoPauseTime = None
        self._StaticConfigPairs = None
        self._DynamicConfigPairs = None
        self._MaxConcurrency = None
        self._NetworkConfigNames = None
        self._PublicDomain = None
        self._RegistryId = None
        self._FrameType = None
        self._ImageType = None
        self._ImageName = None
        self._ImageVersion = None
        self._Size = None
        self._ResourceGroupScene = None
        self._RegionName = None
        self._PythonCuSpec = None
        self._SparkSpecMode = None
        self._SparkSize = None
        self._DriverGPUSpec = None
        self._ExecutorGPUSpec = None
        self._GPULimitSize = None
        self._GPUSize = None
        self._PythonGPUSpec = None

    @property
    def EngineResourceGroupName(self):
        r"""标准引擎资源组名称
        :rtype: str
        """
        return self._EngineResourceGroupName

    @EngineResourceGroupName.setter
    def EngineResourceGroupName(self, EngineResourceGroupName):
        self._EngineResourceGroupName = EngineResourceGroupName

    @property
    def DataEngineName(self):
        r"""标准引擎名称
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName

    @property
    def AutoLaunch(self):
        r"""自动启动，（任务提交自动拉起资源组）0-自动启动，1-不自动启动
        :rtype: int
        """
        return self._AutoLaunch

    @AutoLaunch.setter
    def AutoLaunch(self, AutoLaunch):
        self._AutoLaunch = AutoLaunch

    @property
    def AutoPause(self):
        r"""自动挂起资源组。0-自动挂起，1-不自动挂起
        :rtype: int
        """
        return self._AutoPause

    @AutoPause.setter
    def AutoPause(self, AutoPause):
        self._AutoPause = AutoPause

    @property
    def DriverCuSpec(self):
        r"""driver的cu规格：
当前支持：small（默认，1cu）、medium（2cu）、large（4cu）、xlarge（8cu），内存型cu为cpu：men=1:8，m.small（1cu内存型）、m.medium（2cu内存型）、m.large（4cu内存型）、m.xlarge（8cu内存型）
        :rtype: str
        """
        return self._DriverCuSpec

    @DriverCuSpec.setter
    def DriverCuSpec(self, DriverCuSpec):
        self._DriverCuSpec = DriverCuSpec

    @property
    def ExecutorCuSpec(self):
        r"""executor的cu规格：
当前支持：small（默认，1cu）、medium（2cu）、large（4cu）、xlarge（8cu），内存型cu为cpu：men=1:8，m.small（1cu内存型）、m.medium（2cu内存型）、m.large（4cu内存型）、m.xlarge（8cu内存型）
        :rtype: str
        """
        return self._ExecutorCuSpec

    @ExecutorCuSpec.setter
    def ExecutorCuSpec(self, ExecutorCuSpec):
        self._ExecutorCuSpec = ExecutorCuSpec

    @property
    def MinExecutorNums(self):
        r"""executor最小数量，
        :rtype: int
        """
        return self._MinExecutorNums

    @MinExecutorNums.setter
    def MinExecutorNums(self, MinExecutorNums):
        self._MinExecutorNums = MinExecutorNums

    @property
    def MaxExecutorNums(self):
        r"""executor最大数量
        :rtype: int
        """
        return self._MaxExecutorNums

    @MaxExecutorNums.setter
    def MaxExecutorNums(self, MaxExecutorNums):
        self._MaxExecutorNums = MaxExecutorNums

    @property
    def IsLaunchNow(self):
        r"""创建资源组后是否直接拉起，0-拉起，1-不拉起
        :rtype: int
        """
        return self._IsLaunchNow

    @IsLaunchNow.setter
    def IsLaunchNow(self, IsLaunchNow):
        self._IsLaunchNow = IsLaunchNow

    @property
    def AutoPauseTime(self):
        r"""自动挂起时间，单位分钟，取值范围在1-999（在无任务AutoPauseTime后，资源组自动挂起）
        :rtype: int
        """
        return self._AutoPauseTime

    @AutoPauseTime.setter
    def AutoPauseTime(self, AutoPauseTime):
        self._AutoPauseTime = AutoPauseTime

    @property
    def StaticConfigPairs(self):
        r"""资源组静态参数，需要重启资源组生效
        :rtype: list of EngineResourceGroupConfigPair
        """
        return self._StaticConfigPairs

    @StaticConfigPairs.setter
    def StaticConfigPairs(self, StaticConfigPairs):
        self._StaticConfigPairs = StaticConfigPairs

    @property
    def DynamicConfigPairs(self):
        r"""资源组动态参数，下一个任务生效。
        :rtype: list of EngineResourceGroupConfigPair
        """
        return self._DynamicConfigPairs

    @DynamicConfigPairs.setter
    def DynamicConfigPairs(self, DynamicConfigPairs):
        self._DynamicConfigPairs = DynamicConfigPairs

    @property
    def MaxConcurrency(self):
        r"""任务并发数，默人是5个
        :rtype: int
        """
        return self._MaxConcurrency

    @MaxConcurrency.setter
    def MaxConcurrency(self, MaxConcurrency):
        self._MaxConcurrency = MaxConcurrency

    @property
    def NetworkConfigNames(self):
        r"""网络配置名称
        :rtype: list of str
        """
        return self._NetworkConfigNames

    @NetworkConfigNames.setter
    def NetworkConfigNames(self, NetworkConfigNames):
        self._NetworkConfigNames = NetworkConfigNames

    @property
    def PublicDomain(self):
        r"""自定义镜像域名
        :rtype: str
        """
        return self._PublicDomain

    @PublicDomain.setter
    def PublicDomain(self, PublicDomain):
        self._PublicDomain = PublicDomain

    @property
    def RegistryId(self):
        r"""自定义镜像实例id
        :rtype: str
        """
        return self._RegistryId

    @RegistryId.setter
    def RegistryId(self, RegistryId):
        self._RegistryId = RegistryId

    @property
    def FrameType(self):
        r"""AI类型资源组的框架类型，machine-learning，python，spark-ml，不填默认为machine-learning
        :rtype: str
        """
        return self._FrameType

    @FrameType.setter
    def FrameType(self, FrameType):
        self._FrameType = FrameType

    @property
    def ImageType(self):
        r"""镜像类型，bulit-in：内置，custom：自定义，不填默认为bulit-in
        :rtype: str
        """
        return self._ImageType

    @ImageType.setter
    def ImageType(self, ImageType):
        self._ImageType = ImageType

    @property
    def ImageName(self):
        r"""镜像名称
        :rtype: str
        """
        return self._ImageName

    @ImageName.setter
    def ImageName(self, ImageName):
        self._ImageName = ImageName

    @property
    def ImageVersion(self):
        r"""镜像id
        :rtype: str
        """
        return self._ImageVersion

    @ImageVersion.setter
    def ImageVersion(self, ImageVersion):
        self._ImageVersion = ImageVersion

    @property
    def Size(self):
        r"""AI资源组有效，资源组可用资源上限，该值需要小于引擎资源上限
        :rtype: int
        """
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size

    @property
    def ResourceGroupScene(self):
        r"""资源组场景
        :rtype: str
        """
        return self._ResourceGroupScene

    @ResourceGroupScene.setter
    def ResourceGroupScene(self, ResourceGroupScene):
        self._ResourceGroupScene = ResourceGroupScene

    @property
    def RegionName(self):
        r"""自定义镜像所在地域
        :rtype: str
        """
        return self._RegionName

    @RegionName.setter
    def RegionName(self, RegionName):
        self._RegionName = RegionName

    @property
    def PythonCuSpec(self):
        r"""python类型资源组python单机节点资源上限，该值要小于资源组的资源上限.small:1cu medium:2cu large:4cu xlarge:8cu 4xlarge:16cu 8xlarge:32cu 16xlarge:64cu，如果是高内存型资源，在类型前面加上m.
        :rtype: str
        """
        return self._PythonCuSpec

    @PythonCuSpec.setter
    def PythonCuSpec(self, PythonCuSpec):
        self._PythonCuSpec = PythonCuSpec

    @property
    def SparkSpecMode(self):
        r"""仅SQL资源组资源配置模式，fast：快速模式，custom：自定义模式
        :rtype: str
        """
        return self._SparkSpecMode

    @SparkSpecMode.setter
    def SparkSpecMode(self, SparkSpecMode):
        self._SparkSpecMode = SparkSpecMode

    @property
    def SparkSize(self):
        r"""仅SQL资源组资源上限，仅用于快速模块
        :rtype: int
        """
        return self._SparkSize

    @SparkSize.setter
    def SparkSize(self, SparkSize):
        self._SparkSize = SparkSize

    @property
    def DriverGPUSpec(self):
        r"""GPUDriver规格
        :rtype: int
        """
        return self._DriverGPUSpec

    @DriverGPUSpec.setter
    def DriverGPUSpec(self, DriverGPUSpec):
        self._DriverGPUSpec = DriverGPUSpec

    @property
    def ExecutorGPUSpec(self):
        r"""GPUExecutor规格
        :rtype: int
        """
        return self._ExecutorGPUSpec

    @ExecutorGPUSpec.setter
    def ExecutorGPUSpec(self, ExecutorGPUSpec):
        self._ExecutorGPUSpec = ExecutorGPUSpec

    @property
    def GPULimitSize(self):
        r"""GPU上限
        :rtype: int
        """
        return self._GPULimitSize

    @GPULimitSize.setter
    def GPULimitSize(self, GPULimitSize):
        self._GPULimitSize = GPULimitSize

    @property
    def GPUSize(self):
        r"""GPU规格
        :rtype: int
        """
        return self._GPUSize

    @GPUSize.setter
    def GPUSize(self, GPUSize):
        self._GPUSize = GPUSize

    @property
    def PythonGPUSpec(self):
        r"""Pod GPU规格上限
        :rtype: int
        """
        return self._PythonGPUSpec

    @PythonGPUSpec.setter
    def PythonGPUSpec(self, PythonGPUSpec):
        self._PythonGPUSpec = PythonGPUSpec


    def _deserialize(self, params):
        self._EngineResourceGroupName = params.get("EngineResourceGroupName")
        self._DataEngineName = params.get("DataEngineName")
        self._AutoLaunch = params.get("AutoLaunch")
        self._AutoPause = params.get("AutoPause")
        self._DriverCuSpec = params.get("DriverCuSpec")
        self._ExecutorCuSpec = params.get("ExecutorCuSpec")
        self._MinExecutorNums = params.get("MinExecutorNums")
        self._MaxExecutorNums = params.get("MaxExecutorNums")
        self._IsLaunchNow = params.get("IsLaunchNow")
        self._AutoPauseTime = params.get("AutoPauseTime")
        if params.get("StaticConfigPairs") is not None:
            self._StaticConfigPairs = []
            for item in params.get("StaticConfigPairs"):
                obj = EngineResourceGroupConfigPair()
                obj._deserialize(item)
                self._StaticConfigPairs.append(obj)
        if params.get("DynamicConfigPairs") is not None:
            self._DynamicConfigPairs = []
            for item in params.get("DynamicConfigPairs"):
                obj = EngineResourceGroupConfigPair()
                obj._deserialize(item)
                self._DynamicConfigPairs.append(obj)
        self._MaxConcurrency = params.get("MaxConcurrency")
        self._NetworkConfigNames = params.get("NetworkConfigNames")
        self._PublicDomain = params.get("PublicDomain")
        self._RegistryId = params.get("RegistryId")
        self._FrameType = params.get("FrameType")
        self._ImageType = params.get("ImageType")
        self._ImageName = params.get("ImageName")
        self._ImageVersion = params.get("ImageVersion")
        self._Size = params.get("Size")
        self._ResourceGroupScene = params.get("ResourceGroupScene")
        self._RegionName = params.get("RegionName")
        self._PythonCuSpec = params.get("PythonCuSpec")
        self._SparkSpecMode = params.get("SparkSpecMode")
        self._SparkSize = params.get("SparkSize")
        self._DriverGPUSpec = params.get("DriverGPUSpec")
        self._ExecutorGPUSpec = params.get("ExecutorGPUSpec")
        self._GPULimitSize = params.get("GPULimitSize")
        self._GPUSize = params.get("GPUSize")
        self._PythonGPUSpec = params.get("PythonGPUSpec")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateStandardEngineResourceGroupResponse(AbstractModel):
    r"""CreateStandardEngineResourceGroup返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateStoreLocationRequest(AbstractModel):
    r"""CreateStoreLocation请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StoreLocation: 计算结果存储cos路径，如：cosn://bucketname/
        :type StoreLocation: str
        """
        self._StoreLocation = None

    @property
    def StoreLocation(self):
        r"""计算结果存储cos路径，如：cosn://bucketname/
        :rtype: str
        """
        return self._StoreLocation

    @StoreLocation.setter
    def StoreLocation(self, StoreLocation):
        self._StoreLocation = StoreLocation


    def _deserialize(self, params):
        self._StoreLocation = params.get("StoreLocation")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateStoreLocationResponse(AbstractModel):
    r"""CreateStoreLocation返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateTableRequest(AbstractModel):
    r"""CreateTable请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TableInfo: 数据表配置信息
        :type TableInfo: :class:`tencentcloud.dlc.v20210125.models.TableInfo`
        """
        self._TableInfo = None

    @property
    def TableInfo(self):
        r"""数据表配置信息
        :rtype: :class:`tencentcloud.dlc.v20210125.models.TableInfo`
        """
        return self._TableInfo

    @TableInfo.setter
    def TableInfo(self, TableInfo):
        self._TableInfo = TableInfo


    def _deserialize(self, params):
        if params.get("TableInfo") is not None:
            self._TableInfo = TableInfo()
            self._TableInfo._deserialize(params.get("TableInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTableResponse(AbstractModel):
    r"""CreateTable返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Execution: 生成的建表执行语句对象。
        :type Execution: :class:`tencentcloud.dlc.v20210125.models.Execution`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Execution = None
        self._RequestId = None

    @property
    def Execution(self):
        r"""生成的建表执行语句对象。
        :rtype: :class:`tencentcloud.dlc.v20210125.models.Execution`
        """
        return self._Execution

    @Execution.setter
    def Execution(self, Execution):
        self._Execution = Execution

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Execution") is not None:
            self._Execution = Execution()
            self._Execution._deserialize(params.get("Execution"))
        self._RequestId = params.get("RequestId")


class CreateTaskRequest(AbstractModel):
    r"""CreateTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Task: 计算任务，该参数中包含任务类型及其相关配置信息
        :type Task: :class:`tencentcloud.dlc.v20210125.models.Task`
        :param _DatabaseName: 数据库名称。如果SQL语句中有数据库名称，优先使用SQL语句中的数据库，否则使用该参数指定的数据库（注：当提交建库sql时，该字段传空字符串）。
        :type DatabaseName: str
        :param _DatasourceConnectionName: 默认数据源名称。
        :type DatasourceConnectionName: str
        :param _DataEngineName: 数据引擎名称，不填提交到默认集群
        :type DataEngineName: str
        :param _ResourceGroupName: 标准spark执行任务resourceGroupName
        :type ResourceGroupName: str
        :param _SourceInfo: 任务来源信息
        :type SourceInfo: list of KVPair
        """
        self._Task = None
        self._DatabaseName = None
        self._DatasourceConnectionName = None
        self._DataEngineName = None
        self._ResourceGroupName = None
        self._SourceInfo = None

    @property
    def Task(self):
        r"""计算任务，该参数中包含任务类型及其相关配置信息
        :rtype: :class:`tencentcloud.dlc.v20210125.models.Task`
        """
        return self._Task

    @Task.setter
    def Task(self, Task):
        self._Task = Task

    @property
    def DatabaseName(self):
        r"""数据库名称。如果SQL语句中有数据库名称，优先使用SQL语句中的数据库，否则使用该参数指定的数据库（注：当提交建库sql时，该字段传空字符串）。
        :rtype: str
        """
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def DatasourceConnectionName(self):
        r"""默认数据源名称。
        :rtype: str
        """
        return self._DatasourceConnectionName

    @DatasourceConnectionName.setter
    def DatasourceConnectionName(self, DatasourceConnectionName):
        self._DatasourceConnectionName = DatasourceConnectionName

    @property
    def DataEngineName(self):
        r"""数据引擎名称，不填提交到默认集群
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName

    @property
    def ResourceGroupName(self):
        r"""标准spark执行任务resourceGroupName
        :rtype: str
        """
        return self._ResourceGroupName

    @ResourceGroupName.setter
    def ResourceGroupName(self, ResourceGroupName):
        self._ResourceGroupName = ResourceGroupName

    @property
    def SourceInfo(self):
        r"""任务来源信息
        :rtype: list of KVPair
        """
        return self._SourceInfo

    @SourceInfo.setter
    def SourceInfo(self, SourceInfo):
        self._SourceInfo = SourceInfo


    def _deserialize(self, params):
        if params.get("Task") is not None:
            self._Task = Task()
            self._Task._deserialize(params.get("Task"))
        self._DatabaseName = params.get("DatabaseName")
        self._DatasourceConnectionName = params.get("DatasourceConnectionName")
        self._DataEngineName = params.get("DataEngineName")
        self._ResourceGroupName = params.get("ResourceGroupName")
        if params.get("SourceInfo") is not None:
            self._SourceInfo = []
            for item in params.get("SourceInfo"):
                obj = KVPair()
                obj._deserialize(item)
                self._SourceInfo.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTaskResponse(AbstractModel):
    r"""CreateTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务ID
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        r"""任务ID
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class CreateTasksInOrderRequest(AbstractModel):
    r"""CreateTasksInOrder请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DatabaseName: 数据库名称。如果SQL语句中有数据库名称，优先使用SQL语句中的数据库，否则使用该参数指定的数据库。
        :type DatabaseName: str
        :param _Tasks: SQL任务信息
        :type Tasks: :class:`tencentcloud.dlc.v20210125.models.TasksInfo`
        :param _DatasourceConnectionName: 数据源名称，默认为COSDataCatalog
        :type DatasourceConnectionName: str
        """
        self._DatabaseName = None
        self._Tasks = None
        self._DatasourceConnectionName = None

    @property
    def DatabaseName(self):
        r"""数据库名称。如果SQL语句中有数据库名称，优先使用SQL语句中的数据库，否则使用该参数指定的数据库。
        :rtype: str
        """
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def Tasks(self):
        r"""SQL任务信息
        :rtype: :class:`tencentcloud.dlc.v20210125.models.TasksInfo`
        """
        return self._Tasks

    @Tasks.setter
    def Tasks(self, Tasks):
        self._Tasks = Tasks

    @property
    def DatasourceConnectionName(self):
        r"""数据源名称，默认为COSDataCatalog
        :rtype: str
        """
        return self._DatasourceConnectionName

    @DatasourceConnectionName.setter
    def DatasourceConnectionName(self, DatasourceConnectionName):
        self._DatasourceConnectionName = DatasourceConnectionName


    def _deserialize(self, params):
        self._DatabaseName = params.get("DatabaseName")
        if params.get("Tasks") is not None:
            self._Tasks = TasksInfo()
            self._Tasks._deserialize(params.get("Tasks"))
        self._DatasourceConnectionName = params.get("DatasourceConnectionName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTasksInOrderResponse(AbstractModel):
    r"""CreateTasksInOrder返回参数结构体

    """

    def __init__(self):
        r"""
        :param _BatchId: 本批次提交的任务的批次Id
        :type BatchId: str
        :param _TaskIdSet: 任务Id集合，按照执行顺序排列
        :type TaskIdSet: list of str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._BatchId = None
        self._TaskIdSet = None
        self._RequestId = None

    @property
    def BatchId(self):
        r"""本批次提交的任务的批次Id
        :rtype: str
        """
        return self._BatchId

    @BatchId.setter
    def BatchId(self, BatchId):
        self._BatchId = BatchId

    @property
    def TaskIdSet(self):
        r"""任务Id集合，按照执行顺序排列
        :rtype: list of str
        """
        return self._TaskIdSet

    @TaskIdSet.setter
    def TaskIdSet(self, TaskIdSet):
        self._TaskIdSet = TaskIdSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._BatchId = params.get("BatchId")
        self._TaskIdSet = params.get("TaskIdSet")
        self._RequestId = params.get("RequestId")


class CreateTasksRequest(AbstractModel):
    r"""CreateTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DatabaseName: 数据库名称。如果SQL语句中有数据库名称，优先使用SQL语句中的数据库，否则使用该参数指定的数据库（注：当提交建库sql时，该字段传空字符串）。
        :type DatabaseName: str
        :param _Tasks: SQL任务信息
        :type Tasks: :class:`tencentcloud.dlc.v20210125.models.TasksInfo`
        :param _DatasourceConnectionName: 数据源名称，默认为DataLakeCatalog
        :type DatasourceConnectionName: str
        :param _DataEngineName: 计算引擎名称，不填任务提交到默认集群
        :type DataEngineName: str
        :param _ResourceGroupName: spark集群资源组名称
        :type ResourceGroupName: str
        :param _IsMultiStatement: 是否使用multi- statement方式运行一批次任务，true: 是，false: 否
        :type IsMultiStatement: bool
        :param _SourceInfo: 任务来源信息
        :type SourceInfo: list of KVPair
        """
        self._DatabaseName = None
        self._Tasks = None
        self._DatasourceConnectionName = None
        self._DataEngineName = None
        self._ResourceGroupName = None
        self._IsMultiStatement = None
        self._SourceInfo = None

    @property
    def DatabaseName(self):
        r"""数据库名称。如果SQL语句中有数据库名称，优先使用SQL语句中的数据库，否则使用该参数指定的数据库（注：当提交建库sql时，该字段传空字符串）。
        :rtype: str
        """
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def Tasks(self):
        r"""SQL任务信息
        :rtype: :class:`tencentcloud.dlc.v20210125.models.TasksInfo`
        """
        return self._Tasks

    @Tasks.setter
    def Tasks(self, Tasks):
        self._Tasks = Tasks

    @property
    def DatasourceConnectionName(self):
        r"""数据源名称，默认为DataLakeCatalog
        :rtype: str
        """
        return self._DatasourceConnectionName

    @DatasourceConnectionName.setter
    def DatasourceConnectionName(self, DatasourceConnectionName):
        self._DatasourceConnectionName = DatasourceConnectionName

    @property
    def DataEngineName(self):
        r"""计算引擎名称，不填任务提交到默认集群
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName

    @property
    def ResourceGroupName(self):
        r"""spark集群资源组名称
        :rtype: str
        """
        return self._ResourceGroupName

    @ResourceGroupName.setter
    def ResourceGroupName(self, ResourceGroupName):
        self._ResourceGroupName = ResourceGroupName

    @property
    def IsMultiStatement(self):
        r"""是否使用multi- statement方式运行一批次任务，true: 是，false: 否
        :rtype: bool
        """
        return self._IsMultiStatement

    @IsMultiStatement.setter
    def IsMultiStatement(self, IsMultiStatement):
        self._IsMultiStatement = IsMultiStatement

    @property
    def SourceInfo(self):
        r"""任务来源信息
        :rtype: list of KVPair
        """
        return self._SourceInfo

    @SourceInfo.setter
    def SourceInfo(self, SourceInfo):
        self._SourceInfo = SourceInfo


    def _deserialize(self, params):
        self._DatabaseName = params.get("DatabaseName")
        if params.get("Tasks") is not None:
            self._Tasks = TasksInfo()
            self._Tasks._deserialize(params.get("Tasks"))
        self._DatasourceConnectionName = params.get("DatasourceConnectionName")
        self._DataEngineName = params.get("DataEngineName")
        self._ResourceGroupName = params.get("ResourceGroupName")
        self._IsMultiStatement = params.get("IsMultiStatement")
        if params.get("SourceInfo") is not None:
            self._SourceInfo = []
            for item in params.get("SourceInfo"):
                obj = KVPair()
                obj._deserialize(item)
                self._SourceInfo.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTasksResponse(AbstractModel):
    r"""CreateTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _BatchId: 本批次提交的任务的批次Id
        :type BatchId: str
        :param _TaskIdSet: 任务Id集合，按照执行顺序排列
        :type TaskIdSet: list of str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._BatchId = None
        self._TaskIdSet = None
        self._RequestId = None

    @property
    def BatchId(self):
        r"""本批次提交的任务的批次Id
        :rtype: str
        """
        return self._BatchId

    @BatchId.setter
    def BatchId(self, BatchId):
        self._BatchId = BatchId

    @property
    def TaskIdSet(self):
        r"""任务Id集合，按照执行顺序排列
        :rtype: list of str
        """
        return self._TaskIdSet

    @TaskIdSet.setter
    def TaskIdSet(self, TaskIdSet):
        self._TaskIdSet = TaskIdSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._BatchId = params.get("BatchId")
        self._TaskIdSet = params.get("TaskIdSet")
        self._RequestId = params.get("RequestId")


class CreateTcIcebergTableRequest(AbstractModel):
    r"""CreateTcIcebergTable请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TableBaseInfo: 表基本信息
        :type TableBaseInfo: :class:`tencentcloud.dlc.v20210125.models.TableBaseInfo`
        :param _Columns: 表字段信息
        :type Columns: list of TColumn
        :param _DryRun: 为true时只获取sql而不执行
        :type DryRun: bool
        :param _Partitions: 表分区信息
        :type Partitions: list of TPartition
        :param _Properties: 表属性信息
        :type Properties: list of Property
        """
        self._TableBaseInfo = None
        self._Columns = None
        self._DryRun = None
        self._Partitions = None
        self._Properties = None

    @property
    def TableBaseInfo(self):
        r"""表基本信息
        :rtype: :class:`tencentcloud.dlc.v20210125.models.TableBaseInfo`
        """
        return self._TableBaseInfo

    @TableBaseInfo.setter
    def TableBaseInfo(self, TableBaseInfo):
        self._TableBaseInfo = TableBaseInfo

    @property
    def Columns(self):
        r"""表字段信息
        :rtype: list of TColumn
        """
        return self._Columns

    @Columns.setter
    def Columns(self, Columns):
        self._Columns = Columns

    @property
    def DryRun(self):
        r"""为true时只获取sql而不执行
        :rtype: bool
        """
        return self._DryRun

    @DryRun.setter
    def DryRun(self, DryRun):
        self._DryRun = DryRun

    @property
    def Partitions(self):
        r"""表分区信息
        :rtype: list of TPartition
        """
        return self._Partitions

    @Partitions.setter
    def Partitions(self, Partitions):
        self._Partitions = Partitions

    @property
    def Properties(self):
        r"""表属性信息
        :rtype: list of Property
        """
        return self._Properties

    @Properties.setter
    def Properties(self, Properties):
        self._Properties = Properties


    def _deserialize(self, params):
        if params.get("TableBaseInfo") is not None:
            self._TableBaseInfo = TableBaseInfo()
            self._TableBaseInfo._deserialize(params.get("TableBaseInfo"))
        if params.get("Columns") is not None:
            self._Columns = []
            for item in params.get("Columns"):
                obj = TColumn()
                obj._deserialize(item)
                self._Columns.append(obj)
        self._DryRun = params.get("DryRun")
        if params.get("Partitions") is not None:
            self._Partitions = []
            for item in params.get("Partitions"):
                obj = TPartition()
                obj._deserialize(item)
                self._Partitions.append(obj)
        if params.get("Properties") is not None:
            self._Properties = []
            for item in params.get("Properties"):
                obj = Property()
                obj._deserialize(item)
                self._Properties.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTcIcebergTableResponse(AbstractModel):
    r"""CreateTcIcebergTable返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SessionId: amoro的SessionId
        :type SessionId: str
        :param _SQL: 执行的sql
        :type SQL: str
        :param _DryRun: 为true时只返回sql而不实际执行
        :type DryRun: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SessionId = None
        self._SQL = None
        self._DryRun = None
        self._RequestId = None

    @property
    def SessionId(self):
        r"""amoro的SessionId
        :rtype: str
        """
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def SQL(self):
        r"""执行的sql
        :rtype: str
        """
        return self._SQL

    @SQL.setter
    def SQL(self, SQL):
        self._SQL = SQL

    @property
    def DryRun(self):
        r"""为true时只返回sql而不实际执行
        :rtype: bool
        """
        return self._DryRun

    @DryRun.setter
    def DryRun(self, DryRun):
        self._DryRun = DryRun

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SessionId = params.get("SessionId")
        self._SQL = params.get("SQL")
        self._DryRun = params.get("DryRun")
        self._RequestId = params.get("RequestId")


class CreateUserRequest(AbstractModel):
    r"""CreateUser请求参数结构体

    """

    def __init__(self):
        r"""
        :param _UserId: 需要授权的子用户uin，可以通过腾讯云控制台右上角 → “账号信息” → “账号ID进行查看”。
        :type UserId: str
        :param _UserDescription: 用户描述信息，方便区分不同用户
        :type UserDescription: str
        :param _PolicySet: 绑定到用户的权限集合
        :type PolicySet: list of Policy
        :param _UserType: 用户类型。ADMIN：管理员 COMMON：一般用户。当用户类型为管理员的时候，不能设置权限集合和绑定的工作组集合，管理员默认拥有所有权限。该参数不填默认为COMMON
        :type UserType: str
        :param _WorkGroupIds: 绑定到用户的工作组ID集合。
        :type WorkGroupIds: list of int
        :param _UserAlias: 用户别名，字符长度小50
        :type UserAlias: str
        :param _AccountType: 账号类型，UserAccount：用户账号 RoleAccount：角色账号，默认为用户账号
        :type AccountType: str
        """
        self._UserId = None
        self._UserDescription = None
        self._PolicySet = None
        self._UserType = None
        self._WorkGroupIds = None
        self._UserAlias = None
        self._AccountType = None

    @property
    def UserId(self):
        r"""需要授权的子用户uin，可以通过腾讯云控制台右上角 → “账号信息” → “账号ID进行查看”。
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def UserDescription(self):
        r"""用户描述信息，方便区分不同用户
        :rtype: str
        """
        return self._UserDescription

    @UserDescription.setter
    def UserDescription(self, UserDescription):
        self._UserDescription = UserDescription

    @property
    def PolicySet(self):
        r"""绑定到用户的权限集合
        :rtype: list of Policy
        """
        return self._PolicySet

    @PolicySet.setter
    def PolicySet(self, PolicySet):
        self._PolicySet = PolicySet

    @property
    def UserType(self):
        r"""用户类型。ADMIN：管理员 COMMON：一般用户。当用户类型为管理员的时候，不能设置权限集合和绑定的工作组集合，管理员默认拥有所有权限。该参数不填默认为COMMON
        :rtype: str
        """
        return self._UserType

    @UserType.setter
    def UserType(self, UserType):
        self._UserType = UserType

    @property
    def WorkGroupIds(self):
        r"""绑定到用户的工作组ID集合。
        :rtype: list of int
        """
        return self._WorkGroupIds

    @WorkGroupIds.setter
    def WorkGroupIds(self, WorkGroupIds):
        self._WorkGroupIds = WorkGroupIds

    @property
    def UserAlias(self):
        r"""用户别名，字符长度小50
        :rtype: str
        """
        return self._UserAlias

    @UserAlias.setter
    def UserAlias(self, UserAlias):
        self._UserAlias = UserAlias

    @property
    def AccountType(self):
        r"""账号类型，UserAccount：用户账号 RoleAccount：角色账号，默认为用户账号
        :rtype: str
        """
        return self._AccountType

    @AccountType.setter
    def AccountType(self, AccountType):
        self._AccountType = AccountType


    def _deserialize(self, params):
        self._UserId = params.get("UserId")
        self._UserDescription = params.get("UserDescription")
        if params.get("PolicySet") is not None:
            self._PolicySet = []
            for item in params.get("PolicySet"):
                obj = Policy()
                obj._deserialize(item)
                self._PolicySet.append(obj)
        self._UserType = params.get("UserType")
        self._WorkGroupIds = params.get("WorkGroupIds")
        self._UserAlias = params.get("UserAlias")
        self._AccountType = params.get("AccountType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateUserResponse(AbstractModel):
    r"""CreateUser返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateUserVpcConnectionRequest(AbstractModel):
    r"""CreateUserVpcConnection请求参数结构体

    """

    def __init__(self):
        r"""
        :param _UserVpcId: 用户vpcid
        :type UserVpcId: str
        :param _UserSubnetId: 用户子网
        :type UserSubnetId: str
        :param _UserVpcEndpointName: 用户终端节点名称
        :type UserVpcEndpointName: str
        :param _EngineNetworkId: 引擎网络ID
        :type EngineNetworkId: str
        :param _UserVpcEndpointVip: 手动指定vip，不填自动分配子网下的一个ip
        :type UserVpcEndpointVip: str
        """
        self._UserVpcId = None
        self._UserSubnetId = None
        self._UserVpcEndpointName = None
        self._EngineNetworkId = None
        self._UserVpcEndpointVip = None

    @property
    def UserVpcId(self):
        r"""用户vpcid
        :rtype: str
        """
        return self._UserVpcId

    @UserVpcId.setter
    def UserVpcId(self, UserVpcId):
        self._UserVpcId = UserVpcId

    @property
    def UserSubnetId(self):
        r"""用户子网
        :rtype: str
        """
        return self._UserSubnetId

    @UserSubnetId.setter
    def UserSubnetId(self, UserSubnetId):
        self._UserSubnetId = UserSubnetId

    @property
    def UserVpcEndpointName(self):
        r"""用户终端节点名称
        :rtype: str
        """
        return self._UserVpcEndpointName

    @UserVpcEndpointName.setter
    def UserVpcEndpointName(self, UserVpcEndpointName):
        self._UserVpcEndpointName = UserVpcEndpointName

    @property
    def EngineNetworkId(self):
        r"""引擎网络ID
        :rtype: str
        """
        return self._EngineNetworkId

    @EngineNetworkId.setter
    def EngineNetworkId(self, EngineNetworkId):
        self._EngineNetworkId = EngineNetworkId

    @property
    def UserVpcEndpointVip(self):
        r"""手动指定vip，不填自动分配子网下的一个ip
        :rtype: str
        """
        return self._UserVpcEndpointVip

    @UserVpcEndpointVip.setter
    def UserVpcEndpointVip(self, UserVpcEndpointVip):
        self._UserVpcEndpointVip = UserVpcEndpointVip


    def _deserialize(self, params):
        self._UserVpcId = params.get("UserVpcId")
        self._UserSubnetId = params.get("UserSubnetId")
        self._UserVpcEndpointName = params.get("UserVpcEndpointName")
        self._EngineNetworkId = params.get("EngineNetworkId")
        self._UserVpcEndpointVip = params.get("UserVpcEndpointVip")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateUserVpcConnectionResponse(AbstractModel):
    r"""CreateUserVpcConnection返回参数结构体

    """

    def __init__(self):
        r"""
        :param _UserVpcEndpointId: 终端节点IP
        :type UserVpcEndpointId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._UserVpcEndpointId = None
        self._RequestId = None

    @property
    def UserVpcEndpointId(self):
        r"""终端节点IP
        :rtype: str
        """
        return self._UserVpcEndpointId

    @UserVpcEndpointId.setter
    def UserVpcEndpointId(self, UserVpcEndpointId):
        self._UserVpcEndpointId = UserVpcEndpointId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._UserVpcEndpointId = params.get("UserVpcEndpointId")
        self._RequestId = params.get("RequestId")


class CreateWorkGroupRequest(AbstractModel):
    r"""CreateWorkGroup请求参数结构体

    """

    def __init__(self):
        r"""
        :param _WorkGroupName: 工作组名称
        :type WorkGroupName: str
        :param _WorkGroupDescription: 工作组描述
        :type WorkGroupDescription: str
        :param _PolicySet: 工作组绑定的鉴权策略集合
        :type PolicySet: list of Policy
        :param _UserIds: 需要绑定到工作组的用户Id集合
        :type UserIds: list of str
        """
        self._WorkGroupName = None
        self._WorkGroupDescription = None
        self._PolicySet = None
        self._UserIds = None

    @property
    def WorkGroupName(self):
        r"""工作组名称
        :rtype: str
        """
        return self._WorkGroupName

    @WorkGroupName.setter
    def WorkGroupName(self, WorkGroupName):
        self._WorkGroupName = WorkGroupName

    @property
    def WorkGroupDescription(self):
        r"""工作组描述
        :rtype: str
        """
        return self._WorkGroupDescription

    @WorkGroupDescription.setter
    def WorkGroupDescription(self, WorkGroupDescription):
        self._WorkGroupDescription = WorkGroupDescription

    @property
    def PolicySet(self):
        r"""工作组绑定的鉴权策略集合
        :rtype: list of Policy
        """
        return self._PolicySet

    @PolicySet.setter
    def PolicySet(self, PolicySet):
        self._PolicySet = PolicySet

    @property
    def UserIds(self):
        r"""需要绑定到工作组的用户Id集合
        :rtype: list of str
        """
        return self._UserIds

    @UserIds.setter
    def UserIds(self, UserIds):
        self._UserIds = UserIds


    def _deserialize(self, params):
        self._WorkGroupName = params.get("WorkGroupName")
        self._WorkGroupDescription = params.get("WorkGroupDescription")
        if params.get("PolicySet") is not None:
            self._PolicySet = []
            for item in params.get("PolicySet"):
                obj = Policy()
                obj._deserialize(item)
                self._PolicySet.append(obj)
        self._UserIds = params.get("UserIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateWorkGroupResponse(AbstractModel):
    r"""CreateWorkGroup返回参数结构体

    """

    def __init__(self):
        r"""
        :param _WorkGroupId: 工作组Id，全局唯一
        :type WorkGroupId: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._WorkGroupId = None
        self._RequestId = None

    @property
    def WorkGroupId(self):
        r"""工作组Id，全局唯一
        :rtype: int
        """
        return self._WorkGroupId

    @WorkGroupId.setter
    def WorkGroupId(self, WorkGroupId):
        self._WorkGroupId = WorkGroupId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._WorkGroupId = params.get("WorkGroupId")
        self._RequestId = params.get("RequestId")


class CrontabResumeSuspendStrategy(AbstractModel):
    r"""定时启停策略信息

    """

    def __init__(self):
        r"""
        :param _ResumeTime: 定时拉起时间：如：周一&周三8点
        :type ResumeTime: str
        :param _SuspendTime: 定时挂起时间：如：周一&周三20点
        :type SuspendTime: str
        :param _SuspendStrategy: 挂起配置：0（默认）：等待任务结束后挂起、1：强制挂起
        :type SuspendStrategy: int
        """
        self._ResumeTime = None
        self._SuspendTime = None
        self._SuspendStrategy = None

    @property
    def ResumeTime(self):
        r"""定时拉起时间：如：周一&周三8点
        :rtype: str
        """
        return self._ResumeTime

    @ResumeTime.setter
    def ResumeTime(self, ResumeTime):
        self._ResumeTime = ResumeTime

    @property
    def SuspendTime(self):
        r"""定时挂起时间：如：周一&周三20点
        :rtype: str
        """
        return self._SuspendTime

    @SuspendTime.setter
    def SuspendTime(self, SuspendTime):
        self._SuspendTime = SuspendTime

    @property
    def SuspendStrategy(self):
        r"""挂起配置：0（默认）：等待任务结束后挂起、1：强制挂起
        :rtype: int
        """
        return self._SuspendStrategy

    @SuspendStrategy.setter
    def SuspendStrategy(self, SuspendStrategy):
        self._SuspendStrategy = SuspendStrategy


    def _deserialize(self, params):
        self._ResumeTime = params.get("ResumeTime")
        self._SuspendTime = params.get("SuspendTime")
        self._SuspendStrategy = params.get("SuspendStrategy")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CustomConfig(AbstractModel):
    r"""自定义参数

    """

    def __init__(self):
        r"""
        :param _ConfigKey: 自定义参数名
        :type ConfigKey: str
        :param _ConfigValue: 自定义参数值
        :type ConfigValue: str
        """
        self._ConfigKey = None
        self._ConfigValue = None

    @property
    def ConfigKey(self):
        r"""自定义参数名
        :rtype: str
        """
        return self._ConfigKey

    @ConfigKey.setter
    def ConfigKey(self, ConfigKey):
        self._ConfigKey = ConfigKey

    @property
    def ConfigValue(self):
        r"""自定义参数值
        :rtype: str
        """
        return self._ConfigValue

    @ConfigValue.setter
    def ConfigValue(self, ConfigValue):
        self._ConfigValue = ConfigValue


    def _deserialize(self, params):
        self._ConfigKey = params.get("ConfigKey")
        self._ConfigValue = params.get("ConfigValue")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DLCCatalogAccess(AbstractModel):
    r"""DLC 数据目录访问权限

    """

    def __init__(self):
        r"""
        :param _VpcId: VPCID
        :type VpcId: str
        :param _Product: 产品类型
        :type Product: str
        :param _Description: 描述信息
        :type Description: str
        :param _CreateTime: 创建时间
        :type CreateTime: str
        """
        self._VpcId = None
        self._Product = None
        self._Description = None
        self._CreateTime = None

    @property
    def VpcId(self):
        r"""VPCID
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def Product(self):
        r"""产品类型
        :rtype: str
        """
        return self._Product

    @Product.setter
    def Product(self, Product):
        self._Product = Product

    @property
    def Description(self):
        r"""描述信息
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def CreateTime(self):
        r"""创建时间
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._Product = params.get("Product")
        self._Description = params.get("Description")
        self._CreateTime = params.get("CreateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DMSColumn(AbstractModel):
    r"""迁移列对象

    """

    def __init__(self):
        r"""
        :param _Name: 名称
注意：此字段可能返回 null，表示取不到有效值。
        :type Name: str
        :param _Description: 描述
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        :param _Type: 类型
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: str
        :param _Position: 排序
注意：此字段可能返回 null，表示取不到有效值。
        :type Position: int
        :param _Params: 附加参数
注意：此字段可能返回 null，表示取不到有效值。
        :type Params: list of KVPair
        :param _BizParams: 业务参数
注意：此字段可能返回 null，表示取不到有效值。
        :type BizParams: list of KVPair
        :param _IsPartition: 是否分区
注意：此字段可能返回 null，表示取不到有效值。
        :type IsPartition: bool
        """
        self._Name = None
        self._Description = None
        self._Type = None
        self._Position = None
        self._Params = None
        self._BizParams = None
        self._IsPartition = None

    @property
    def Name(self):
        r"""名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Description(self):
        r"""描述
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Type(self):
        r"""类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Position(self):
        r"""排序
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Position

    @Position.setter
    def Position(self, Position):
        self._Position = Position

    @property
    def Params(self):
        r"""附加参数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of KVPair
        """
        return self._Params

    @Params.setter
    def Params(self, Params):
        self._Params = Params

    @property
    def BizParams(self):
        r"""业务参数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of KVPair
        """
        return self._BizParams

    @BizParams.setter
    def BizParams(self, BizParams):
        self._BizParams = BizParams

    @property
    def IsPartition(self):
        r"""是否分区
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._IsPartition

    @IsPartition.setter
    def IsPartition(self, IsPartition):
        self._IsPartition = IsPartition


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Description = params.get("Description")
        self._Type = params.get("Type")
        self._Position = params.get("Position")
        if params.get("Params") is not None:
            self._Params = []
            for item in params.get("Params"):
                obj = KVPair()
                obj._deserialize(item)
                self._Params.append(obj)
        if params.get("BizParams") is not None:
            self._BizParams = []
            for item in params.get("BizParams"):
                obj = KVPair()
                obj._deserialize(item)
                self._BizParams.append(obj)
        self._IsPartition = params.get("IsPartition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DMSColumnOrder(AbstractModel):
    r"""列排序对象

    """

    def __init__(self):
        r"""
        :param _Col: 列名
注意：此字段可能返回 null，表示取不到有效值。
        :type Col: str
        :param _Order: 排序
注意：此字段可能返回 null，表示取不到有效值。
        :type Order: int
        """
        self._Col = None
        self._Order = None

    @property
    def Col(self):
        r"""列名
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Col

    @Col.setter
    def Col(self, Col):
        self._Col = Col

    @property
    def Order(self):
        r"""排序
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._Col = params.get("Col")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DMSPartition(AbstractModel):
    r"""迁移元数据分区对象

    """

    def __init__(self):
        r"""
        :param _DatabaseName: 数据库名称
        :type DatabaseName: str
        :param _SchemaName: 数据目录名称
        :type SchemaName: str
        :param _TableName: 表名称
        :type TableName: str
        :param _DataVersion: 数据版本
        :type DataVersion: int
        :param _Name: 分区名称
        :type Name: str
        :param _Values: 值列表
        :type Values: list of str
        :param _StorageSize: 存储大小
        :type StorageSize: int
        :param _RecordCount: 记录数量
        :type RecordCount: int
        :param _CreateTime: 创建时间
        :type CreateTime: str
        :param _ModifiedTime: 修改时间
        :type ModifiedTime: str
        :param _LastAccessTime: 最后访问时间
        :type LastAccessTime: str
        :param _Params: 附件属性
        :type Params: list of KVPair
        :param _Sds: 存储对象
        :type Sds: :class:`tencentcloud.dlc.v20210125.models.DMSSds`
        :param _DatasourceConnectionName: 数据源连接名
        :type DatasourceConnectionName: str
        """
        self._DatabaseName = None
        self._SchemaName = None
        self._TableName = None
        self._DataVersion = None
        self._Name = None
        self._Values = None
        self._StorageSize = None
        self._RecordCount = None
        self._CreateTime = None
        self._ModifiedTime = None
        self._LastAccessTime = None
        self._Params = None
        self._Sds = None
        self._DatasourceConnectionName = None

    @property
    def DatabaseName(self):
        r"""数据库名称
        :rtype: str
        """
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def SchemaName(self):
        r"""数据目录名称
        :rtype: str
        """
        return self._SchemaName

    @SchemaName.setter
    def SchemaName(self, SchemaName):
        self._SchemaName = SchemaName

    @property
    def TableName(self):
        r"""表名称
        :rtype: str
        """
        return self._TableName

    @TableName.setter
    def TableName(self, TableName):
        self._TableName = TableName

    @property
    def DataVersion(self):
        r"""数据版本
        :rtype: int
        """
        return self._DataVersion

    @DataVersion.setter
    def DataVersion(self, DataVersion):
        self._DataVersion = DataVersion

    @property
    def Name(self):
        r"""分区名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Values(self):
        r"""值列表
        :rtype: list of str
        """
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values

    @property
    def StorageSize(self):
        r"""存储大小
        :rtype: int
        """
        return self._StorageSize

    @StorageSize.setter
    def StorageSize(self, StorageSize):
        self._StorageSize = StorageSize

    @property
    def RecordCount(self):
        r"""记录数量
        :rtype: int
        """
        return self._RecordCount

    @RecordCount.setter
    def RecordCount(self, RecordCount):
        self._RecordCount = RecordCount

    @property
    def CreateTime(self):
        r"""创建时间
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ModifiedTime(self):
        r"""修改时间
        :rtype: str
        """
        return self._ModifiedTime

    @ModifiedTime.setter
    def ModifiedTime(self, ModifiedTime):
        self._ModifiedTime = ModifiedTime

    @property
    def LastAccessTime(self):
        r"""最后访问时间
        :rtype: str
        """
        return self._LastAccessTime

    @LastAccessTime.setter
    def LastAccessTime(self, LastAccessTime):
        self._LastAccessTime = LastAccessTime

    @property
    def Params(self):
        r"""附件属性
        :rtype: list of KVPair
        """
        return self._Params

    @Params.setter
    def Params(self, Params):
        self._Params = Params

    @property
    def Sds(self):
        r"""存储对象
        :rtype: :class:`tencentcloud.dlc.v20210125.models.DMSSds`
        """
        return self._Sds

    @Sds.setter
    def Sds(self, Sds):
        self._Sds = Sds

    @property
    def DatasourceConnectionName(self):
        r"""数据源连接名
        :rtype: str
        """
        return self._DatasourceConnectionName

    @DatasourceConnectionName.setter
    def DatasourceConnectionName(self, DatasourceConnectionName):
        self._DatasourceConnectionName = DatasourceConnectionName


    def _deserialize(self, params):
        self._DatabaseName = params.get("DatabaseName")
        self._SchemaName = params.get("SchemaName")
        self._TableName = params.get("TableName")
        self._DataVersion = params.get("DataVersion")
        self._Name = params.get("Name")
        self._Values = params.get("Values")
        self._StorageSize = params.get("StorageSize")
        self._RecordCount = params.get("RecordCount")
        self._CreateTime = params.get("CreateTime")
        self._ModifiedTime = params.get("ModifiedTime")
        self._LastAccessTime = params.get("LastAccessTime")
        if params.get("Params") is not None:
            self._Params = []
            for item in params.get("Params"):
                obj = KVPair()
                obj._deserialize(item)
                self._Params.append(obj)
        if params.get("Sds") is not None:
            self._Sds = DMSSds()
            self._Sds._deserialize(params.get("Sds"))
        self._DatasourceConnectionName = params.get("DatasourceConnectionName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DMSSds(AbstractModel):
    r"""元数据存储描述属性

    """

    def __init__(self):
        r"""
        :param _Location: 存储地址
注意：此字段可能返回 null，表示取不到有效值。
        :type Location: str
        :param _InputFormat: 输入格式
注意：此字段可能返回 null，表示取不到有效值。
        :type InputFormat: str
        :param _OutputFormat: 输出格式
注意：此字段可能返回 null，表示取不到有效值。
        :type OutputFormat: str
        :param _NumBuckets: bucket数量
注意：此字段可能返回 null，表示取不到有效值。
        :type NumBuckets: int
        :param _Compressed: 是是否压缩
注意：此字段可能返回 null，表示取不到有效值。
        :type Compressed: bool
        :param _StoredAsSubDirectories: 是否有子目录
注意：此字段可能返回 null，表示取不到有效值。
        :type StoredAsSubDirectories: bool
        :param _SerdeLib: 序列化lib
注意：此字段可能返回 null，表示取不到有效值。
        :type SerdeLib: str
        :param _SerdeName: 序列化名称
注意：此字段可能返回 null，表示取不到有效值。
        :type SerdeName: str
        :param _BucketCols: 桶名称
注意：此字段可能返回 null，表示取不到有效值。
        :type BucketCols: list of str
        :param _SerdeParams: 序列化参数
注意：此字段可能返回 null，表示取不到有效值。
        :type SerdeParams: list of KVPair
        :param _Params: 附加参数
注意：此字段可能返回 null，表示取不到有效值。
        :type Params: list of KVPair
        :param _SortCols: 列排序(Expired)
注意：此字段可能返回 null，表示取不到有效值。
        :type SortCols: :class:`tencentcloud.dlc.v20210125.models.DMSColumnOrder`
        :param _Cols: 列
注意：此字段可能返回 null，表示取不到有效值。
        :type Cols: list of DMSColumn
        :param _SortColumns: 列排序字段
注意：此字段可能返回 null，表示取不到有效值。
        :type SortColumns: list of DMSColumnOrder
        """
        self._Location = None
        self._InputFormat = None
        self._OutputFormat = None
        self._NumBuckets = None
        self._Compressed = None
        self._StoredAsSubDirectories = None
        self._SerdeLib = None
        self._SerdeName = None
        self._BucketCols = None
        self._SerdeParams = None
        self._Params = None
        self._SortCols = None
        self._Cols = None
        self._SortColumns = None

    @property
    def Location(self):
        r"""存储地址
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Location

    @Location.setter
    def Location(self, Location):
        self._Location = Location

    @property
    def InputFormat(self):
        r"""输入格式
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._InputFormat

    @InputFormat.setter
    def InputFormat(self, InputFormat):
        self._InputFormat = InputFormat

    @property
    def OutputFormat(self):
        r"""输出格式
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._OutputFormat

    @OutputFormat.setter
    def OutputFormat(self, OutputFormat):
        self._OutputFormat = OutputFormat

    @property
    def NumBuckets(self):
        r"""bucket数量
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._NumBuckets

    @NumBuckets.setter
    def NumBuckets(self, NumBuckets):
        self._NumBuckets = NumBuckets

    @property
    def Compressed(self):
        r"""是是否压缩
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._Compressed

    @Compressed.setter
    def Compressed(self, Compressed):
        self._Compressed = Compressed

    @property
    def StoredAsSubDirectories(self):
        r"""是否有子目录
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._StoredAsSubDirectories

    @StoredAsSubDirectories.setter
    def StoredAsSubDirectories(self, StoredAsSubDirectories):
        self._StoredAsSubDirectories = StoredAsSubDirectories

    @property
    def SerdeLib(self):
        r"""序列化lib
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SerdeLib

    @SerdeLib.setter
    def SerdeLib(self, SerdeLib):
        self._SerdeLib = SerdeLib

    @property
    def SerdeName(self):
        r"""序列化名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SerdeName

    @SerdeName.setter
    def SerdeName(self, SerdeName):
        self._SerdeName = SerdeName

    @property
    def BucketCols(self):
        r"""桶名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._BucketCols

    @BucketCols.setter
    def BucketCols(self, BucketCols):
        self._BucketCols = BucketCols

    @property
    def SerdeParams(self):
        r"""序列化参数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of KVPair
        """
        return self._SerdeParams

    @SerdeParams.setter
    def SerdeParams(self, SerdeParams):
        self._SerdeParams = SerdeParams

    @property
    def Params(self):
        r"""附加参数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of KVPair
        """
        return self._Params

    @Params.setter
    def Params(self, Params):
        self._Params = Params

    @property
    def SortCols(self):
        r"""列排序(Expired)
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.dlc.v20210125.models.DMSColumnOrder`
        """
        return self._SortCols

    @SortCols.setter
    def SortCols(self, SortCols):
        self._SortCols = SortCols

    @property
    def Cols(self):
        r"""列
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of DMSColumn
        """
        return self._Cols

    @Cols.setter
    def Cols(self, Cols):
        self._Cols = Cols

    @property
    def SortColumns(self):
        r"""列排序字段
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of DMSColumnOrder
        """
        return self._SortColumns

    @SortColumns.setter
    def SortColumns(self, SortColumns):
        self._SortColumns = SortColumns


    def _deserialize(self, params):
        self._Location = params.get("Location")
        self._InputFormat = params.get("InputFormat")
        self._OutputFormat = params.get("OutputFormat")
        self._NumBuckets = params.get("NumBuckets")
        self._Compressed = params.get("Compressed")
        self._StoredAsSubDirectories = params.get("StoredAsSubDirectories")
        self._SerdeLib = params.get("SerdeLib")
        self._SerdeName = params.get("SerdeName")
        self._BucketCols = params.get("BucketCols")
        if params.get("SerdeParams") is not None:
            self._SerdeParams = []
            for item in params.get("SerdeParams"):
                obj = KVPair()
                obj._deserialize(item)
                self._SerdeParams.append(obj)
        if params.get("Params") is not None:
            self._Params = []
            for item in params.get("Params"):
                obj = KVPair()
                obj._deserialize(item)
                self._Params.append(obj)
        if params.get("SortCols") is not None:
            self._SortCols = DMSColumnOrder()
            self._SortCols._deserialize(params.get("SortCols"))
        if params.get("Cols") is not None:
            self._Cols = []
            for item in params.get("Cols"):
                obj = DMSColumn()
                obj._deserialize(item)
                self._Cols.append(obj)
        if params.get("SortColumns") is not None:
            self._SortColumns = []
            for item in params.get("SortColumns"):
                obj = DMSColumnOrder()
                obj._deserialize(item)
                self._SortColumns.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DMSTable(AbstractModel):
    r"""DMSTable基本信息

    """

    def __init__(self):
        r"""
        :param _ViewOriginalText: 视图文本
注意：此字段可能返回 null，表示取不到有效值。
        :type ViewOriginalText: str
        :param _ViewExpandedText: 视图文本
注意：此字段可能返回 null，表示取不到有效值。
        :type ViewExpandedText: str
        :param _Retention: hive维护版本
注意：此字段可能返回 null，表示取不到有效值。
        :type Retention: int
        :param _Sds: 存储对象
注意：此字段可能返回 null，表示取不到有效值。
        :type Sds: :class:`tencentcloud.dlc.v20210125.models.DMSSds`
        :param _PartitionKeys: 分区列
注意：此字段可能返回 null，表示取不到有效值。
        :type PartitionKeys: list of DMSColumn
        :param _Partitions: 分区
注意：此字段可能返回 null，表示取不到有效值。
        :type Partitions: list of DMSPartition
        :param _Type: 表类型
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: str
        :param _DbName: 数据库名称
注意：此字段可能返回 null，表示取不到有效值。
        :type DbName: str
        :param _SchemaName: Schema名称
注意：此字段可能返回 null，表示取不到有效值。
        :type SchemaName: str
        :param _StorageSize: 存储大小
注意：此字段可能返回 null，表示取不到有效值。
        :type StorageSize: int
        :param _RecordCount: 记录数量
注意：此字段可能返回 null，表示取不到有效值。
        :type RecordCount: int
        :param _LifeTime: 生命周期
注意：此字段可能返回 null，表示取不到有效值。
        :type LifeTime: int
        :param _LastAccessTime: 最后访问时间
注意：此字段可能返回 null，表示取不到有效值。
        :type LastAccessTime: str
        :param _DataUpdateTime: 数据更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type DataUpdateTime: str
        :param _StructUpdateTime: 结构更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type StructUpdateTime: str
        :param _Columns: 列
注意：此字段可能返回 null，表示取不到有效值。
        :type Columns: list of DMSColumn
        :param _Name: 表名
注意：此字段可能返回 null，表示取不到有效值。
        :type Name: str
        """
        self._ViewOriginalText = None
        self._ViewExpandedText = None
        self._Retention = None
        self._Sds = None
        self._PartitionKeys = None
        self._Partitions = None
        self._Type = None
        self._DbName = None
        self._SchemaName = None
        self._StorageSize = None
        self._RecordCount = None
        self._LifeTime = None
        self._LastAccessTime = None
        self._DataUpdateTime = None
        self._StructUpdateTime = None
        self._Columns = None
        self._Name = None

    @property
    def ViewOriginalText(self):
        r"""视图文本
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ViewOriginalText

    @ViewOriginalText.setter
    def ViewOriginalText(self, ViewOriginalText):
        self._ViewOriginalText = ViewOriginalText

    @property
    def ViewExpandedText(self):
        r"""视图文本
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ViewExpandedText

    @ViewExpandedText.setter
    def ViewExpandedText(self, ViewExpandedText):
        self._ViewExpandedText = ViewExpandedText

    @property
    def Retention(self):
        r"""hive维护版本
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Retention

    @Retention.setter
    def Retention(self, Retention):
        self._Retention = Retention

    @property
    def Sds(self):
        r"""存储对象
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.dlc.v20210125.models.DMSSds`
        """
        return self._Sds

    @Sds.setter
    def Sds(self, Sds):
        self._Sds = Sds

    @property
    def PartitionKeys(self):
        r"""分区列
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of DMSColumn
        """
        return self._PartitionKeys

    @PartitionKeys.setter
    def PartitionKeys(self, PartitionKeys):
        self._PartitionKeys = PartitionKeys

    @property
    def Partitions(self):
        r"""分区
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of DMSPartition
        """
        return self._Partitions

    @Partitions.setter
    def Partitions(self, Partitions):
        self._Partitions = Partitions

    @property
    def Type(self):
        r"""表类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def DbName(self):
        r"""数据库名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DbName

    @DbName.setter
    def DbName(self, DbName):
        self._DbName = DbName

    @property
    def SchemaName(self):
        r"""Schema名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SchemaName

    @SchemaName.setter
    def SchemaName(self, SchemaName):
        self._SchemaName = SchemaName

    @property
    def StorageSize(self):
        r"""存储大小
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._StorageSize

    @StorageSize.setter
    def StorageSize(self, StorageSize):
        self._StorageSize = StorageSize

    @property
    def RecordCount(self):
        r"""记录数量
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._RecordCount

    @RecordCount.setter
    def RecordCount(self, RecordCount):
        self._RecordCount = RecordCount

    @property
    def LifeTime(self):
        r"""生命周期
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._LifeTime

    @LifeTime.setter
    def LifeTime(self, LifeTime):
        self._LifeTime = LifeTime

    @property
    def LastAccessTime(self):
        r"""最后访问时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._LastAccessTime

    @LastAccessTime.setter
    def LastAccessTime(self, LastAccessTime):
        self._LastAccessTime = LastAccessTime

    @property
    def DataUpdateTime(self):
        r"""数据更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DataUpdateTime

    @DataUpdateTime.setter
    def DataUpdateTime(self, DataUpdateTime):
        self._DataUpdateTime = DataUpdateTime

    @property
    def StructUpdateTime(self):
        r"""结构更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._StructUpdateTime

    @StructUpdateTime.setter
    def StructUpdateTime(self, StructUpdateTime):
        self._StructUpdateTime = StructUpdateTime

    @property
    def Columns(self):
        r"""列
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of DMSColumn
        """
        return self._Columns

    @Columns.setter
    def Columns(self, Columns):
        self._Columns = Columns

    @property
    def Name(self):
        r"""表名
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._ViewOriginalText = params.get("ViewOriginalText")
        self._ViewExpandedText = params.get("ViewExpandedText")
        self._Retention = params.get("Retention")
        if params.get("Sds") is not None:
            self._Sds = DMSSds()
            self._Sds._deserialize(params.get("Sds"))
        if params.get("PartitionKeys") is not None:
            self._PartitionKeys = []
            for item in params.get("PartitionKeys"):
                obj = DMSColumn()
                obj._deserialize(item)
                self._PartitionKeys.append(obj)
        if params.get("Partitions") is not None:
            self._Partitions = []
            for item in params.get("Partitions"):
                obj = DMSPartition()
                obj._deserialize(item)
                self._Partitions.append(obj)
        self._Type = params.get("Type")
        self._DbName = params.get("DbName")
        self._SchemaName = params.get("SchemaName")
        self._StorageSize = params.get("StorageSize")
        self._RecordCount = params.get("RecordCount")
        self._LifeTime = params.get("LifeTime")
        self._LastAccessTime = params.get("LastAccessTime")
        self._DataUpdateTime = params.get("DataUpdateTime")
        self._StructUpdateTime = params.get("StructUpdateTime")
        if params.get("Columns") is not None:
            self._Columns = []
            for item in params.get("Columns"):
                obj = DMSColumn()
                obj._deserialize(item)
                self._Columns.append(obj)
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DMSTableInfo(AbstractModel):
    r"""DMSTable信息

    """

    def __init__(self):
        r"""
        :param _Table: DMS表信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Table: :class:`tencentcloud.dlc.v20210125.models.DMSTable`
        :param _Asset: 基础对象信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Asset: :class:`tencentcloud.dlc.v20210125.models.Asset`
        """
        self._Table = None
        self._Asset = None

    @property
    def Table(self):
        r"""DMS表信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.dlc.v20210125.models.DMSTable`
        """
        return self._Table

    @Table.setter
    def Table(self, Table):
        self._Table = Table

    @property
    def Asset(self):
        r"""基础对象信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.dlc.v20210125.models.Asset`
        """
        return self._Asset

    @Asset.setter
    def Asset(self, Asset):
        self._Asset = Asset


    def _deserialize(self, params):
        if params.get("Table") is not None:
            self._Table = DMSTable()
            self._Table._deserialize(params.get("Table"))
        if params.get("Asset") is not None:
            self._Asset = Asset()
            self._Asset._deserialize(params.get("Asset"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataEngineBasicInfo(AbstractModel):
    r"""DataEngine基本信息

    """

    def __init__(self):
        r"""
        :param _DataEngineName: DataEngine名称
        :type DataEngineName: str
        :param _State: 数据引擎状态  -2已删除 -1失败 0初始化中 1挂起 2运行中 3准备删除 4删除中
        :type State: int
        :param _CreateTime: 创建时间
        :type CreateTime: int
        :param _UpdateTime: 更新时间
        :type UpdateTime: int
        :param _Message: 返回信息
        :type Message: str
        :param _DataEngineId: 引擎id
        :type DataEngineId: str
        :param _DataEngineType: 引擎类型，有效值：PrestoSQL/SparkSQL/SparkBatch
        :type DataEngineType: str
        :param _AppId: 用户ID
        :type AppId: int
        :param _UserUin: 账号ID
        :type UserUin: str
        """
        self._DataEngineName = None
        self._State = None
        self._CreateTime = None
        self._UpdateTime = None
        self._Message = None
        self._DataEngineId = None
        self._DataEngineType = None
        self._AppId = None
        self._UserUin = None

    @property
    def DataEngineName(self):
        r"""DataEngine名称
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName

    @property
    def State(self):
        r"""数据引擎状态  -2已删除 -1失败 0初始化中 1挂起 2运行中 3准备删除 4删除中
        :rtype: int
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def CreateTime(self):
        r"""创建时间
        :rtype: int
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""更新时间
        :rtype: int
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def Message(self):
        r"""返回信息
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def DataEngineId(self):
        r"""引擎id
        :rtype: str
        """
        return self._DataEngineId

    @DataEngineId.setter
    def DataEngineId(self, DataEngineId):
        self._DataEngineId = DataEngineId

    @property
    def DataEngineType(self):
        r"""引擎类型，有效值：PrestoSQL/SparkSQL/SparkBatch
        :rtype: str
        """
        return self._DataEngineType

    @DataEngineType.setter
    def DataEngineType(self, DataEngineType):
        self._DataEngineType = DataEngineType

    @property
    def AppId(self):
        r"""用户ID
        :rtype: int
        """
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId

    @property
    def UserUin(self):
        r"""账号ID
        :rtype: str
        """
        return self._UserUin

    @UserUin.setter
    def UserUin(self, UserUin):
        self._UserUin = UserUin


    def _deserialize(self, params):
        self._DataEngineName = params.get("DataEngineName")
        self._State = params.get("State")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._Message = params.get("Message")
        self._DataEngineId = params.get("DataEngineId")
        self._DataEngineType = params.get("DataEngineType")
        self._AppId = params.get("AppId")
        self._UserUin = params.get("UserUin")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataEngineConfigInstanceInfo(AbstractModel):
    r"""引擎配置信息

    """

    def __init__(self):
        r"""
        :param _DataEngineId: 引擎ID
        :type DataEngineId: str
        :param _DataEngineConfigPairs: 用户自定义配置项集合
        :type DataEngineConfigPairs: list of DataEngineConfigPair
        :param _SessionResourceTemplate: 作业集群资源参数配置模板
        :type SessionResourceTemplate: :class:`tencentcloud.dlc.v20210125.models.SessionResourceTemplate`
        """
        self._DataEngineId = None
        self._DataEngineConfigPairs = None
        self._SessionResourceTemplate = None

    @property
    def DataEngineId(self):
        r"""引擎ID
        :rtype: str
        """
        return self._DataEngineId

    @DataEngineId.setter
    def DataEngineId(self, DataEngineId):
        self._DataEngineId = DataEngineId

    @property
    def DataEngineConfigPairs(self):
        r"""用户自定义配置项集合
        :rtype: list of DataEngineConfigPair
        """
        return self._DataEngineConfigPairs

    @DataEngineConfigPairs.setter
    def DataEngineConfigPairs(self, DataEngineConfigPairs):
        self._DataEngineConfigPairs = DataEngineConfigPairs

    @property
    def SessionResourceTemplate(self):
        r"""作业集群资源参数配置模板
        :rtype: :class:`tencentcloud.dlc.v20210125.models.SessionResourceTemplate`
        """
        return self._SessionResourceTemplate

    @SessionResourceTemplate.setter
    def SessionResourceTemplate(self, SessionResourceTemplate):
        self._SessionResourceTemplate = SessionResourceTemplate


    def _deserialize(self, params):
        self._DataEngineId = params.get("DataEngineId")
        if params.get("DataEngineConfigPairs") is not None:
            self._DataEngineConfigPairs = []
            for item in params.get("DataEngineConfigPairs"):
                obj = DataEngineConfigPair()
                obj._deserialize(item)
                self._DataEngineConfigPairs.append(obj)
        if params.get("SessionResourceTemplate") is not None:
            self._SessionResourceTemplate = SessionResourceTemplate()
            self._SessionResourceTemplate._deserialize(params.get("SessionResourceTemplate"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataEngineConfigPair(AbstractModel):
    r"""引擎配置

    """

    def __init__(self):
        r"""
        :param _ConfigItem: 配置项
        :type ConfigItem: str
        :param _ConfigValue: 配置值
        :type ConfigValue: str
        """
        self._ConfigItem = None
        self._ConfigValue = None

    @property
    def ConfigItem(self):
        r"""配置项
        :rtype: str
        """
        return self._ConfigItem

    @ConfigItem.setter
    def ConfigItem(self, ConfigItem):
        self._ConfigItem = ConfigItem

    @property
    def ConfigValue(self):
        r"""配置值
        :rtype: str
        """
        return self._ConfigValue

    @ConfigValue.setter
    def ConfigValue(self, ConfigValue):
        self._ConfigValue = ConfigValue


    def _deserialize(self, params):
        self._ConfigItem = params.get("ConfigItem")
        self._ConfigValue = params.get("ConfigValue")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataEngineImageSessionParameter(AbstractModel):
    r"""集群Session配置信息.

    """

    def __init__(self):
        r"""
        :param _ParameterId: 配置id
        :type ParameterId: str
        :param _ChildImageVersionId: 小版本镜像ID
        :type ChildImageVersionId: str
        :param _EngineType: 集群类型：SparkSQL/PrestoSQL/SparkBatch
        :type EngineType: str
        :param _KeyName: 参数key
        :type KeyName: str
        :param _KeyDescription: Key描述信息
注意：此字段可能返回 null，表示取不到有效值。
        :type KeyDescription: str
        :param _ValueType: value类型
        :type ValueType: str
        :param _ValueLengthLimit: value长度限制
注意：此字段可能返回 null，表示取不到有效值。
        :type ValueLengthLimit: str
        :param _ValueRegexpLimit: value正则限制
注意：此字段可能返回 null，表示取不到有效值。
        :type ValueRegexpLimit: str
        :param _ValueDefault: value默认值
注意：此字段可能返回 null，表示取不到有效值。
        :type ValueDefault: str
        :param _IsPublic: 是否为公共版本：1：公共；2：私有
        :type IsPublic: int
        :param _ParameterType: 配置类型：1：session配置（默认）；2：common配置；3：cluster配置
        :type ParameterType: int
        :param _SubmitMethod: 提交方式：User(用户)、BackGround（后台）
        :type SubmitMethod: str
        :param _Operator: 操作者
注意：此字段可能返回 null，表示取不到有效值。
        :type Operator: str
        :param _InsertTime: 插入时间
        :type InsertTime: str
        :param _UpdateTime: 更新时间
        :type UpdateTime: str
        """
        self._ParameterId = None
        self._ChildImageVersionId = None
        self._EngineType = None
        self._KeyName = None
        self._KeyDescription = None
        self._ValueType = None
        self._ValueLengthLimit = None
        self._ValueRegexpLimit = None
        self._ValueDefault = None
        self._IsPublic = None
        self._ParameterType = None
        self._SubmitMethod = None
        self._Operator = None
        self._InsertTime = None
        self._UpdateTime = None

    @property
    def ParameterId(self):
        r"""配置id
        :rtype: str
        """
        return self._ParameterId

    @ParameterId.setter
    def ParameterId(self, ParameterId):
        self._ParameterId = ParameterId

    @property
    def ChildImageVersionId(self):
        r"""小版本镜像ID
        :rtype: str
        """
        return self._ChildImageVersionId

    @ChildImageVersionId.setter
    def ChildImageVersionId(self, ChildImageVersionId):
        self._ChildImageVersionId = ChildImageVersionId

    @property
    def EngineType(self):
        r"""集群类型：SparkSQL/PrestoSQL/SparkBatch
        :rtype: str
        """
        return self._EngineType

    @EngineType.setter
    def EngineType(self, EngineType):
        self._EngineType = EngineType

    @property
    def KeyName(self):
        r"""参数key
        :rtype: str
        """
        return self._KeyName

    @KeyName.setter
    def KeyName(self, KeyName):
        self._KeyName = KeyName

    @property
    def KeyDescription(self):
        r"""Key描述信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._KeyDescription

    @KeyDescription.setter
    def KeyDescription(self, KeyDescription):
        self._KeyDescription = KeyDescription

    @property
    def ValueType(self):
        r"""value类型
        :rtype: str
        """
        return self._ValueType

    @ValueType.setter
    def ValueType(self, ValueType):
        self._ValueType = ValueType

    @property
    def ValueLengthLimit(self):
        r"""value长度限制
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ValueLengthLimit

    @ValueLengthLimit.setter
    def ValueLengthLimit(self, ValueLengthLimit):
        self._ValueLengthLimit = ValueLengthLimit

    @property
    def ValueRegexpLimit(self):
        r"""value正则限制
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ValueRegexpLimit

    @ValueRegexpLimit.setter
    def ValueRegexpLimit(self, ValueRegexpLimit):
        self._ValueRegexpLimit = ValueRegexpLimit

    @property
    def ValueDefault(self):
        r"""value默认值
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ValueDefault

    @ValueDefault.setter
    def ValueDefault(self, ValueDefault):
        self._ValueDefault = ValueDefault

    @property
    def IsPublic(self):
        r"""是否为公共版本：1：公共；2：私有
        :rtype: int
        """
        return self._IsPublic

    @IsPublic.setter
    def IsPublic(self, IsPublic):
        self._IsPublic = IsPublic

    @property
    def ParameterType(self):
        r"""配置类型：1：session配置（默认）；2：common配置；3：cluster配置
        :rtype: int
        """
        return self._ParameterType

    @ParameterType.setter
    def ParameterType(self, ParameterType):
        self._ParameterType = ParameterType

    @property
    def SubmitMethod(self):
        r"""提交方式：User(用户)、BackGround（后台）
        :rtype: str
        """
        return self._SubmitMethod

    @SubmitMethod.setter
    def SubmitMethod(self, SubmitMethod):
        self._SubmitMethod = SubmitMethod

    @property
    def Operator(self):
        r"""操作者
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Operator

    @Operator.setter
    def Operator(self, Operator):
        self._Operator = Operator

    @property
    def InsertTime(self):
        r"""插入时间
        :rtype: str
        """
        return self._InsertTime

    @InsertTime.setter
    def InsertTime(self, InsertTime):
        self._InsertTime = InsertTime

    @property
    def UpdateTime(self):
        r"""更新时间
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._ParameterId = params.get("ParameterId")
        self._ChildImageVersionId = params.get("ChildImageVersionId")
        self._EngineType = params.get("EngineType")
        self._KeyName = params.get("KeyName")
        self._KeyDescription = params.get("KeyDescription")
        self._ValueType = params.get("ValueType")
        self._ValueLengthLimit = params.get("ValueLengthLimit")
        self._ValueRegexpLimit = params.get("ValueRegexpLimit")
        self._ValueDefault = params.get("ValueDefault")
        self._IsPublic = params.get("IsPublic")
        self._ParameterType = params.get("ParameterType")
        self._SubmitMethod = params.get("SubmitMethod")
        self._Operator = params.get("Operator")
        self._InsertTime = params.get("InsertTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataEngineImageVersion(AbstractModel):
    r"""集群大版本镜像信息。

    """

    def __init__(self):
        r"""
        :param _ImageVersionId: 镜像大版本ID
        :type ImageVersionId: str
        :param _ImageVersion: 镜像大版本名称
        :type ImageVersion: str
        :param _Description: 镜像大版本描述
        :type Description: str
        :param _IsPublic: 是否为公共版本：1：公共；2：私有
        :type IsPublic: int
        :param _EngineType: 集群类型：SparkSQL/PrestoSQL/SparkBatch
        :type EngineType: str
        :param _IsSharedEngine: 版本状态：1：初始化；2：上线；3：下线
        :type IsSharedEngine: int
        :param _State: 版本状态：1：初始化；2：上线；3：下线
        :type State: int
        :param _InsertTime: 插入时间
        :type InsertTime: str
        :param _UpdateTime: 更新时间
        :type UpdateTime: str
        """
        self._ImageVersionId = None
        self._ImageVersion = None
        self._Description = None
        self._IsPublic = None
        self._EngineType = None
        self._IsSharedEngine = None
        self._State = None
        self._InsertTime = None
        self._UpdateTime = None

    @property
    def ImageVersionId(self):
        r"""镜像大版本ID
        :rtype: str
        """
        return self._ImageVersionId

    @ImageVersionId.setter
    def ImageVersionId(self, ImageVersionId):
        self._ImageVersionId = ImageVersionId

    @property
    def ImageVersion(self):
        r"""镜像大版本名称
        :rtype: str
        """
        return self._ImageVersion

    @ImageVersion.setter
    def ImageVersion(self, ImageVersion):
        self._ImageVersion = ImageVersion

    @property
    def Description(self):
        r"""镜像大版本描述
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def IsPublic(self):
        r"""是否为公共版本：1：公共；2：私有
        :rtype: int
        """
        return self._IsPublic

    @IsPublic.setter
    def IsPublic(self, IsPublic):
        self._IsPublic = IsPublic

    @property
    def EngineType(self):
        r"""集群类型：SparkSQL/PrestoSQL/SparkBatch
        :rtype: str
        """
        return self._EngineType

    @EngineType.setter
    def EngineType(self, EngineType):
        self._EngineType = EngineType

    @property
    def IsSharedEngine(self):
        r"""版本状态：1：初始化；2：上线；3：下线
        :rtype: int
        """
        return self._IsSharedEngine

    @IsSharedEngine.setter
    def IsSharedEngine(self, IsSharedEngine):
        self._IsSharedEngine = IsSharedEngine

    @property
    def State(self):
        r"""版本状态：1：初始化；2：上线；3：下线
        :rtype: int
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def InsertTime(self):
        r"""插入时间
        :rtype: str
        """
        return self._InsertTime

    @InsertTime.setter
    def InsertTime(self, InsertTime):
        self._InsertTime = InsertTime

    @property
    def UpdateTime(self):
        r"""更新时间
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._ImageVersionId = params.get("ImageVersionId")
        self._ImageVersion = params.get("ImageVersion")
        self._Description = params.get("Description")
        self._IsPublic = params.get("IsPublic")
        self._EngineType = params.get("EngineType")
        self._IsSharedEngine = params.get("IsSharedEngine")
        self._State = params.get("State")
        self._InsertTime = params.get("InsertTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataEngineInfo(AbstractModel):
    r"""DataEngine详细信息

    """

    def __init__(self):
        r"""
        :param _DataEngineName: DataEngine名称
        :type DataEngineName: str
        :param _EngineType: 引擎类型 spark/presto
        :type EngineType: str
        :param _ClusterType: 集群资源类型 spark_private/presto_private/presto_cu/spark_cu
        :type ClusterType: str
        :param _QuotaId: 引用ID
        :type QuotaId: str
        :param _State: 数据引擎状态  -2已删除 -1失败 0初始化中 1挂起 2运行中 3准备删除 4删除中
        :type State: int
        :param _CreateTime: 创建时间
        :type CreateTime: int
        :param _UpdateTime: 更新时间
        :type UpdateTime: int
        :param _Size: 集群规格
注意：此字段可能返回 null，表示取不到有效值。
        :type Size: int
        :param _Mode: 计费模式 0共享模式 1按量计费 2包年包月
        :type Mode: int
        :param _MinClusters: 最小集群数
注意：此字段可能返回 null，表示取不到有效值。
        :type MinClusters: int
        :param _MaxClusters: 最大集群数
注意：此字段可能返回 null，表示取不到有效值。
        :type MaxClusters: int
        :param _AutoResume: 是否自动恢复
注意：此字段可能返回 null，表示取不到有效值。
        :type AutoResume: bool
        :param _SpendAfter: 自动恢复时间
注意：此字段可能返回 null，表示取不到有效值。
        :type SpendAfter: int
        :param _CidrBlock: 集群网段
注意：此字段可能返回 null，表示取不到有效值。
        :type CidrBlock: str
        :param _DefaultDataEngine: 是否为默认引擎
注意：此字段可能返回 null，表示取不到有效值。
        :type DefaultDataEngine: bool
        :param _Message: 返回信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Message: str
        :param _DataEngineId: 引擎id
        :type DataEngineId: str
        :param _SubAccountUin: 操作者
        :type SubAccountUin: str
        :param _ExpireTime: 到期时间
        :type ExpireTime: str
        :param _IsolatedTime: 隔离时间
        :type IsolatedTime: str
        :param _ReversalTime: 冲正时间
        :type ReversalTime: str
        :param _UserAlias: 用户名称
注意：此字段可能返回 null，表示取不到有效值。
        :type UserAlias: str
        :param _TagList: 标签对集合
注意：此字段可能返回 null，表示取不到有效值。
        :type TagList: list of TagInfo
        :param _Permissions: 引擎拥有的权限
注意：此字段可能返回 null，表示取不到有效值。
        :type Permissions: list of str
        :param _AutoSuspend: 是否自定挂起集群：false（默认）：不自动挂起、true：自动挂起
注意：此字段可能返回 null，表示取不到有效值。
        :type AutoSuspend: bool
        :param _CrontabResumeSuspend: 定时启停集群策略：0（默认）：关闭定时策略、1：开启定时策略（注：定时启停策略与自动挂起策略互斥）
注意：此字段可能返回 null，表示取不到有效值。
        :type CrontabResumeSuspend: int
        :param _CrontabResumeSuspendStrategy: 定时启停策略，复杂类型：包含启停时间、挂起集群策略
注意：此字段可能返回 null，表示取不到有效值。
        :type CrontabResumeSuspendStrategy: :class:`tencentcloud.dlc.v20210125.models.CrontabResumeSuspendStrategy`
        :param _EngineExecType: 引擎执行任务类型，有效值：SQL/BATCH
注意：此字段可能返回 null，表示取不到有效值。
        :type EngineExecType: str
        :param _RenewFlag: 自动续费标志，0，初始状态，默认不自动续费，若用户有预付费不停服特权，自动续费。1：自动续费。2：明确不自动续费
注意：此字段可能返回 null，表示取不到有效值。
        :type RenewFlag: int
        :param _AutoSuspendTime: 集群自动挂起时间
注意：此字段可能返回 null，表示取不到有效值。
        :type AutoSuspendTime: int
        :param _NetworkConnectionSet: 网络连接配置
注意：此字段可能返回 null，表示取不到有效值。
        :type NetworkConnectionSet: list of NetworkConnection
        :param _UiURL: ui的跳转地址
注意：此字段可能返回 null，表示取不到有效值。
        :type UiURL: str
        :param _ResourceType: 引擎的资源类型
注意：此字段可能返回 null，表示取不到有效值。
        :type ResourceType: str
        :param _ImageVersionId: 集群镜像版本ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ImageVersionId: str
        :param _ChildImageVersionId: 集群镜像小版本ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ChildImageVersionId: str
        :param _ImageVersionName: 集群镜像版本名字
注意：此字段可能返回 null，表示取不到有效值。
        :type ImageVersionName: str
        :param _StartStandbyCluster: 是否开启备集群
注意：此字段可能返回 null，表示取不到有效值。
        :type StartStandbyCluster: bool
        :param _ElasticSwitch: spark jar 包年包月集群是否开启弹性
注意：此字段可能返回 null，表示取不到有效值。
        :type ElasticSwitch: bool
        :param _ElasticLimit: spark jar 包年包月集群弹性上限
注意：此字段可能返回 null，表示取不到有效值。
        :type ElasticLimit: int
        :param _DefaultHouse: 是否为默认引擎
注意：此字段可能返回 null，表示取不到有效值。
        :type DefaultHouse: bool
        :param _MaxConcurrency: 单个集群任务最大并发数
注意：此字段可能返回 null，表示取不到有效值。
        :type MaxConcurrency: int
        :param _TolerableQueueTime: 任务排队上限时间
注意：此字段可能返回 null，表示取不到有效值。
        :type TolerableQueueTime: int
        :param _UserAppId: 用户appid
注意：此字段可能返回 null，表示取不到有效值。
        :type UserAppId: int
        :param _UserUin: 用户uin
注意：此字段可能返回 null，表示取不到有效值。
        :type UserUin: str
        :param _SessionResourceTemplate: SessionResourceTemplate
注意：此字段可能返回 null，表示取不到有效值。
        :type SessionResourceTemplate: :class:`tencentcloud.dlc.v20210125.models.SessionResourceTemplate`
        :param _AutoAuthorization: 自动授权开关
注意：此字段可能返回 null，表示取不到有效值。
        :type AutoAuthorization: bool
        :param _EngineGeneration: 引擎版本，支持Native/SuperSQL
注意：此字段可能返回 null，表示取不到有效值。
        :type EngineGeneration: str
        :param _EngineTypeDetail: 引擎详细类型，支持：SparkSQL/SparkBatch/PrestoSQL/Kyuubi
注意：此字段可能返回 null，表示取不到有效值。
        :type EngineTypeDetail: str
        :param _EngineNetworkId: 引擎网络ID
注意：此字段可能返回 null，表示取不到有效值。
        :type EngineNetworkId: str
        :param _EngineResourceGroupCount: 标准引擎关联的资源组个数
注意：此字段可能返回 null，表示取不到有效值。
        :type EngineResourceGroupCount: int
        :param _EngineResourceUsedCU: 引擎当前使用量（Cu）
注意：此字段可能返回 null，表示取不到有效值。
        :type EngineResourceUsedCU: int
        :param _AccessInfos: 引擎的访问信息
注意：此字段可能返回 null，表示取不到有效值。
        :type AccessInfos: list of AccessInfo
        :param _EngineNetworkName: 引擎所在网络名称
注意：此字段可能返回 null，表示取不到有效值。
        :type EngineNetworkName: str
        :param _IsPoolMode: 是否使用预留池
注意：此字段可能返回 null，表示取不到有效值。
        :type IsPoolMode: str
        :param _IsSupportAI: 是否支持AI，false: 不支持；true：支持
注意：此字段可能返回 null，表示取不到有效值。
        :type IsSupportAI: bool
        :param _GatewayId: 网关id
注意：此字段可能返回 null，表示取不到有效值。
        :type GatewayId: str
        :param _GatewayState: 网关状态
注意：此字段可能返回 null，表示取不到有效值。
        :type GatewayState: int
        :param _IsAIGateway: 是否能执行AI任务
注意：此字段可能返回 null，表示取不到有效值。
        :type IsAIGateway: bool
        :param _IsAIEngine: 1:AI引擎，0:非AI引擎
注意：此字段可能返回 null，表示取不到有效值。
        :type IsAIEngine: int
        :param _ScheduleElasticityConf: 引擎资源弹性伸缩策略
        :type ScheduleElasticityConf: :class:`tencentcloud.dlc.v20210125.models.ScheduleElasticityConf`
        :param _GPUInfo: GPU 信息
        :type GPUInfo: :class:`tencentcloud.dlc.v20210125.models.GPUInfo`
        :param _EngineResourceUsedGPU: GPU 使用量
        :type EngineResourceUsedGPU: int
        :param _GPUTotalSize: GPU 总规格
        :type GPUTotalSize: int
        :param _InstanceModel: GPU 机型
        :type InstanceModel: str
        :param _NodeNum: 节点数量
        :type NodeNum: int
        :param _SizeWithElastic: 引擎规格，包含负载弹性或分时弹性
        :type SizeWithElastic: int
        :param _MaxElasticSize: 最大弹性值，包含负载弹性或分时弹性
        :type MaxElasticSize: int
        """
        self._DataEngineName = None
        self._EngineType = None
        self._ClusterType = None
        self._QuotaId = None
        self._State = None
        self._CreateTime = None
        self._UpdateTime = None
        self._Size = None
        self._Mode = None
        self._MinClusters = None
        self._MaxClusters = None
        self._AutoResume = None
        self._SpendAfter = None
        self._CidrBlock = None
        self._DefaultDataEngine = None
        self._Message = None
        self._DataEngineId = None
        self._SubAccountUin = None
        self._ExpireTime = None
        self._IsolatedTime = None
        self._ReversalTime = None
        self._UserAlias = None
        self._TagList = None
        self._Permissions = None
        self._AutoSuspend = None
        self._CrontabResumeSuspend = None
        self._CrontabResumeSuspendStrategy = None
        self._EngineExecType = None
        self._RenewFlag = None
        self._AutoSuspendTime = None
        self._NetworkConnectionSet = None
        self._UiURL = None
        self._ResourceType = None
        self._ImageVersionId = None
        self._ChildImageVersionId = None
        self._ImageVersionName = None
        self._StartStandbyCluster = None
        self._ElasticSwitch = None
        self._ElasticLimit = None
        self._DefaultHouse = None
        self._MaxConcurrency = None
        self._TolerableQueueTime = None
        self._UserAppId = None
        self._UserUin = None
        self._SessionResourceTemplate = None
        self._AutoAuthorization = None
        self._EngineGeneration = None
        self._EngineTypeDetail = None
        self._EngineNetworkId = None
        self._EngineResourceGroupCount = None
        self._EngineResourceUsedCU = None
        self._AccessInfos = None
        self._EngineNetworkName = None
        self._IsPoolMode = None
        self._IsSupportAI = None
        self._GatewayId = None
        self._GatewayState = None
        self._IsAIGateway = None
        self._IsAIEngine = None
        self._ScheduleElasticityConf = None
        self._GPUInfo = None
        self._EngineResourceUsedGPU = None
        self._GPUTotalSize = None
        self._InstanceModel = None
        self._NodeNum = None
        self._SizeWithElastic = None
        self._MaxElasticSize = None

    @property
    def DataEngineName(self):
        r"""DataEngine名称
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName

    @property
    def EngineType(self):
        r"""引擎类型 spark/presto
        :rtype: str
        """
        return self._EngineType

    @EngineType.setter
    def EngineType(self, EngineType):
        self._EngineType = EngineType

    @property
    def ClusterType(self):
        r"""集群资源类型 spark_private/presto_private/presto_cu/spark_cu
        :rtype: str
        """
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType

    @property
    def QuotaId(self):
        r"""引用ID
        :rtype: str
        """
        return self._QuotaId

    @QuotaId.setter
    def QuotaId(self, QuotaId):
        self._QuotaId = QuotaId

    @property
    def State(self):
        r"""数据引擎状态  -2已删除 -1失败 0初始化中 1挂起 2运行中 3准备删除 4删除中
        :rtype: int
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def CreateTime(self):
        r"""创建时间
        :rtype: int
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""更新时间
        :rtype: int
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def Size(self):
        r"""集群规格
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size

    @property
    def Mode(self):
        r"""计费模式 0共享模式 1按量计费 2包年包月
        :rtype: int
        """
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def MinClusters(self):
        r"""最小集群数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._MinClusters

    @MinClusters.setter
    def MinClusters(self, MinClusters):
        self._MinClusters = MinClusters

    @property
    def MaxClusters(self):
        r"""最大集群数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._MaxClusters

    @MaxClusters.setter
    def MaxClusters(self, MaxClusters):
        self._MaxClusters = MaxClusters

    @property
    def AutoResume(self):
        r"""是否自动恢复
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._AutoResume

    @AutoResume.setter
    def AutoResume(self, AutoResume):
        self._AutoResume = AutoResume

    @property
    def SpendAfter(self):
        r"""自动恢复时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._SpendAfter

    @SpendAfter.setter
    def SpendAfter(self, SpendAfter):
        self._SpendAfter = SpendAfter

    @property
    def CidrBlock(self):
        r"""集群网段
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CidrBlock

    @CidrBlock.setter
    def CidrBlock(self, CidrBlock):
        self._CidrBlock = CidrBlock

    @property
    def DefaultDataEngine(self):
        r"""是否为默认引擎
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._DefaultDataEngine

    @DefaultDataEngine.setter
    def DefaultDataEngine(self, DefaultDataEngine):
        self._DefaultDataEngine = DefaultDataEngine

    @property
    def Message(self):
        r"""返回信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def DataEngineId(self):
        r"""引擎id
        :rtype: str
        """
        return self._DataEngineId

    @DataEngineId.setter
    def DataEngineId(self, DataEngineId):
        self._DataEngineId = DataEngineId

    @property
    def SubAccountUin(self):
        r"""操作者
        :rtype: str
        """
        return self._SubAccountUin

    @SubAccountUin.setter
    def SubAccountUin(self, SubAccountUin):
        self._SubAccountUin = SubAccountUin

    @property
    def ExpireTime(self):
        r"""到期时间
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def IsolatedTime(self):
        r"""隔离时间
        :rtype: str
        """
        return self._IsolatedTime

    @IsolatedTime.setter
    def IsolatedTime(self, IsolatedTime):
        self._IsolatedTime = IsolatedTime

    @property
    def ReversalTime(self):
        r"""冲正时间
        :rtype: str
        """
        return self._ReversalTime

    @ReversalTime.setter
    def ReversalTime(self, ReversalTime):
        self._ReversalTime = ReversalTime

    @property
    def UserAlias(self):
        r"""用户名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._UserAlias

    @UserAlias.setter
    def UserAlias(self, UserAlias):
        self._UserAlias = UserAlias

    @property
    def TagList(self):
        r"""标签对集合
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of TagInfo
        """
        return self._TagList

    @TagList.setter
    def TagList(self, TagList):
        self._TagList = TagList

    @property
    def Permissions(self):
        r"""引擎拥有的权限
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._Permissions

    @Permissions.setter
    def Permissions(self, Permissions):
        self._Permissions = Permissions

    @property
    def AutoSuspend(self):
        r"""是否自定挂起集群：false（默认）：不自动挂起、true：自动挂起
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._AutoSuspend

    @AutoSuspend.setter
    def AutoSuspend(self, AutoSuspend):
        self._AutoSuspend = AutoSuspend

    @property
    def CrontabResumeSuspend(self):
        r"""定时启停集群策略：0（默认）：关闭定时策略、1：开启定时策略（注：定时启停策略与自动挂起策略互斥）
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._CrontabResumeSuspend

    @CrontabResumeSuspend.setter
    def CrontabResumeSuspend(self, CrontabResumeSuspend):
        self._CrontabResumeSuspend = CrontabResumeSuspend

    @property
    def CrontabResumeSuspendStrategy(self):
        r"""定时启停策略，复杂类型：包含启停时间、挂起集群策略
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.dlc.v20210125.models.CrontabResumeSuspendStrategy`
        """
        return self._CrontabResumeSuspendStrategy

    @CrontabResumeSuspendStrategy.setter
    def CrontabResumeSuspendStrategy(self, CrontabResumeSuspendStrategy):
        self._CrontabResumeSuspendStrategy = CrontabResumeSuspendStrategy

    @property
    def EngineExecType(self):
        r"""引擎执行任务类型，有效值：SQL/BATCH
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._EngineExecType

    @EngineExecType.setter
    def EngineExecType(self, EngineExecType):
        self._EngineExecType = EngineExecType

    @property
    def RenewFlag(self):
        r"""自动续费标志，0，初始状态，默认不自动续费，若用户有预付费不停服特权，自动续费。1：自动续费。2：明确不自动续费
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag

    @property
    def AutoSuspendTime(self):
        r"""集群自动挂起时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._AutoSuspendTime

    @AutoSuspendTime.setter
    def AutoSuspendTime(self, AutoSuspendTime):
        self._AutoSuspendTime = AutoSuspendTime

    @property
    def NetworkConnectionSet(self):
        r"""网络连接配置
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of NetworkConnection
        """
        return self._NetworkConnectionSet

    @NetworkConnectionSet.setter
    def NetworkConnectionSet(self, NetworkConnectionSet):
        self._NetworkConnectionSet = NetworkConnectionSet

    @property
    def UiURL(self):
        r"""ui的跳转地址
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._UiURL

    @UiURL.setter
    def UiURL(self, UiURL):
        self._UiURL = UiURL

    @property
    def ResourceType(self):
        r"""引擎的资源类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ResourceType

    @ResourceType.setter
    def ResourceType(self, ResourceType):
        self._ResourceType = ResourceType

    @property
    def ImageVersionId(self):
        r"""集群镜像版本ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ImageVersionId

    @ImageVersionId.setter
    def ImageVersionId(self, ImageVersionId):
        self._ImageVersionId = ImageVersionId

    @property
    def ChildImageVersionId(self):
        r"""集群镜像小版本ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ChildImageVersionId

    @ChildImageVersionId.setter
    def ChildImageVersionId(self, ChildImageVersionId):
        self._ChildImageVersionId = ChildImageVersionId

    @property
    def ImageVersionName(self):
        r"""集群镜像版本名字
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ImageVersionName

    @ImageVersionName.setter
    def ImageVersionName(self, ImageVersionName):
        self._ImageVersionName = ImageVersionName

    @property
    def StartStandbyCluster(self):
        r"""是否开启备集群
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._StartStandbyCluster

    @StartStandbyCluster.setter
    def StartStandbyCluster(self, StartStandbyCluster):
        self._StartStandbyCluster = StartStandbyCluster

    @property
    def ElasticSwitch(self):
        r"""spark jar 包年包月集群是否开启弹性
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._ElasticSwitch

    @ElasticSwitch.setter
    def ElasticSwitch(self, ElasticSwitch):
        self._ElasticSwitch = ElasticSwitch

    @property
    def ElasticLimit(self):
        r"""spark jar 包年包月集群弹性上限
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._ElasticLimit

    @ElasticLimit.setter
    def ElasticLimit(self, ElasticLimit):
        self._ElasticLimit = ElasticLimit

    @property
    def DefaultHouse(self):
        r"""是否为默认引擎
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._DefaultHouse

    @DefaultHouse.setter
    def DefaultHouse(self, DefaultHouse):
        self._DefaultHouse = DefaultHouse

    @property
    def MaxConcurrency(self):
        r"""单个集群任务最大并发数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._MaxConcurrency

    @MaxConcurrency.setter
    def MaxConcurrency(self, MaxConcurrency):
        self._MaxConcurrency = MaxConcurrency

    @property
    def TolerableQueueTime(self):
        r"""任务排队上限时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TolerableQueueTime

    @TolerableQueueTime.setter
    def TolerableQueueTime(self, TolerableQueueTime):
        self._TolerableQueueTime = TolerableQueueTime

    @property
    def UserAppId(self):
        r"""用户appid
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._UserAppId

    @UserAppId.setter
    def UserAppId(self, UserAppId):
        self._UserAppId = UserAppId

    @property
    def UserUin(self):
        r"""用户uin
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._UserUin

    @UserUin.setter
    def UserUin(self, UserUin):
        self._UserUin = UserUin

    @property
    def SessionResourceTemplate(self):
        r"""SessionResourceTemplate
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.dlc.v20210125.models.SessionResourceTemplate`
        """
        return self._SessionResourceTemplate

    @SessionResourceTemplate.setter
    def SessionResourceTemplate(self, SessionResourceTemplate):
        self._SessionResourceTemplate = SessionResourceTemplate

    @property
    def AutoAuthorization(self):
        r"""自动授权开关
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._AutoAuthorization

    @AutoAuthorization.setter
    def AutoAuthorization(self, AutoAuthorization):
        self._AutoAuthorization = AutoAuthorization

    @property
    def EngineGeneration(self):
        r"""引擎版本，支持Native/SuperSQL
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._EngineGeneration

    @EngineGeneration.setter
    def EngineGeneration(self, EngineGeneration):
        self._EngineGeneration = EngineGeneration

    @property
    def EngineTypeDetail(self):
        r"""引擎详细类型，支持：SparkSQL/SparkBatch/PrestoSQL/Kyuubi
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._EngineTypeDetail

    @EngineTypeDetail.setter
    def EngineTypeDetail(self, EngineTypeDetail):
        self._EngineTypeDetail = EngineTypeDetail

    @property
    def EngineNetworkId(self):
        r"""引擎网络ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._EngineNetworkId

    @EngineNetworkId.setter
    def EngineNetworkId(self, EngineNetworkId):
        self._EngineNetworkId = EngineNetworkId

    @property
    def EngineResourceGroupCount(self):
        r"""标准引擎关联的资源组个数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._EngineResourceGroupCount

    @EngineResourceGroupCount.setter
    def EngineResourceGroupCount(self, EngineResourceGroupCount):
        self._EngineResourceGroupCount = EngineResourceGroupCount

    @property
    def EngineResourceUsedCU(self):
        r"""引擎当前使用量（Cu）
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._EngineResourceUsedCU

    @EngineResourceUsedCU.setter
    def EngineResourceUsedCU(self, EngineResourceUsedCU):
        self._EngineResourceUsedCU = EngineResourceUsedCU

    @property
    def AccessInfos(self):
        r"""引擎的访问信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of AccessInfo
        """
        return self._AccessInfos

    @AccessInfos.setter
    def AccessInfos(self, AccessInfos):
        self._AccessInfos = AccessInfos

    @property
    def EngineNetworkName(self):
        r"""引擎所在网络名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._EngineNetworkName

    @EngineNetworkName.setter
    def EngineNetworkName(self, EngineNetworkName):
        self._EngineNetworkName = EngineNetworkName

    @property
    def IsPoolMode(self):
        r"""是否使用预留池
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._IsPoolMode

    @IsPoolMode.setter
    def IsPoolMode(self, IsPoolMode):
        self._IsPoolMode = IsPoolMode

    @property
    def IsSupportAI(self):
        r"""是否支持AI，false: 不支持；true：支持
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._IsSupportAI

    @IsSupportAI.setter
    def IsSupportAI(self, IsSupportAI):
        self._IsSupportAI = IsSupportAI

    @property
    def GatewayId(self):
        r"""网关id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._GatewayId

    @GatewayId.setter
    def GatewayId(self, GatewayId):
        self._GatewayId = GatewayId

    @property
    def GatewayState(self):
        r"""网关状态
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._GatewayState

    @GatewayState.setter
    def GatewayState(self, GatewayState):
        self._GatewayState = GatewayState

    @property
    def IsAIGateway(self):
        r"""是否能执行AI任务
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._IsAIGateway

    @IsAIGateway.setter
    def IsAIGateway(self, IsAIGateway):
        self._IsAIGateway = IsAIGateway

    @property
    def IsAIEngine(self):
        r"""1:AI引擎，0:非AI引擎
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._IsAIEngine

    @IsAIEngine.setter
    def IsAIEngine(self, IsAIEngine):
        self._IsAIEngine = IsAIEngine

    @property
    def ScheduleElasticityConf(self):
        r"""引擎资源弹性伸缩策略
        :rtype: :class:`tencentcloud.dlc.v20210125.models.ScheduleElasticityConf`
        """
        return self._ScheduleElasticityConf

    @ScheduleElasticityConf.setter
    def ScheduleElasticityConf(self, ScheduleElasticityConf):
        self._ScheduleElasticityConf = ScheduleElasticityConf

    @property
    def GPUInfo(self):
        r"""GPU 信息
        :rtype: :class:`tencentcloud.dlc.v20210125.models.GPUInfo`
        """
        return self._GPUInfo

    @GPUInfo.setter
    def GPUInfo(self, GPUInfo):
        self._GPUInfo = GPUInfo

    @property
    def EngineResourceUsedGPU(self):
        r"""GPU 使用量
        :rtype: int
        """
        return self._EngineResourceUsedGPU

    @EngineResourceUsedGPU.setter
    def EngineResourceUsedGPU(self, EngineResourceUsedGPU):
        self._EngineResourceUsedGPU = EngineResourceUsedGPU

    @property
    def GPUTotalSize(self):
        r"""GPU 总规格
        :rtype: int
        """
        return self._GPUTotalSize

    @GPUTotalSize.setter
    def GPUTotalSize(self, GPUTotalSize):
        self._GPUTotalSize = GPUTotalSize

    @property
    def InstanceModel(self):
        r"""GPU 机型
        :rtype: str
        """
        return self._InstanceModel

    @InstanceModel.setter
    def InstanceModel(self, InstanceModel):
        self._InstanceModel = InstanceModel

    @property
    def NodeNum(self):
        r"""节点数量
        :rtype: int
        """
        return self._NodeNum

    @NodeNum.setter
    def NodeNum(self, NodeNum):
        self._NodeNum = NodeNum

    @property
    def SizeWithElastic(self):
        r"""引擎规格，包含负载弹性或分时弹性
        :rtype: int
        """
        return self._SizeWithElastic

    @SizeWithElastic.setter
    def SizeWithElastic(self, SizeWithElastic):
        self._SizeWithElastic = SizeWithElastic

    @property
    def MaxElasticSize(self):
        r"""最大弹性值，包含负载弹性或分时弹性
        :rtype: int
        """
        return self._MaxElasticSize

    @MaxElasticSize.setter
    def MaxElasticSize(self, MaxElasticSize):
        self._MaxElasticSize = MaxElasticSize


    def _deserialize(self, params):
        self._DataEngineName = params.get("DataEngineName")
        self._EngineType = params.get("EngineType")
        self._ClusterType = params.get("ClusterType")
        self._QuotaId = params.get("QuotaId")
        self._State = params.get("State")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._Size = params.get("Size")
        self._Mode = params.get("Mode")
        self._MinClusters = params.get("MinClusters")
        self._MaxClusters = params.get("MaxClusters")
        self._AutoResume = params.get("AutoResume")
        self._SpendAfter = params.get("SpendAfter")
        self._CidrBlock = params.get("CidrBlock")
        self._DefaultDataEngine = params.get("DefaultDataEngine")
        self._Message = params.get("Message")
        self._DataEngineId = params.get("DataEngineId")
        self._SubAccountUin = params.get("SubAccountUin")
        self._ExpireTime = params.get("ExpireTime")
        self._IsolatedTime = params.get("IsolatedTime")
        self._ReversalTime = params.get("ReversalTime")
        self._UserAlias = params.get("UserAlias")
        if params.get("TagList") is not None:
            self._TagList = []
            for item in params.get("TagList"):
                obj = TagInfo()
                obj._deserialize(item)
                self._TagList.append(obj)
        self._Permissions = params.get("Permissions")
        self._AutoSuspend = params.get("AutoSuspend")
        self._CrontabResumeSuspend = params.get("CrontabResumeSuspend")
        if params.get("CrontabResumeSuspendStrategy") is not None:
            self._CrontabResumeSuspendStrategy = CrontabResumeSuspendStrategy()
            self._CrontabResumeSuspendStrategy._deserialize(params.get("CrontabResumeSuspendStrategy"))
        self._EngineExecType = params.get("EngineExecType")
        self._RenewFlag = params.get("RenewFlag")
        self._AutoSuspendTime = params.get("AutoSuspendTime")
        if params.get("NetworkConnectionSet") is not None:
            self._NetworkConnectionSet = []
            for item in params.get("NetworkConnectionSet"):
                obj = NetworkConnection()
                obj._deserialize(item)
                self._NetworkConnectionSet.append(obj)
        self._UiURL = params.get("UiURL")
        self._ResourceType = params.get("ResourceType")
        self._ImageVersionId = params.get("ImageVersionId")
        self._ChildImageVersionId = params.get("ChildImageVersionId")
        self._ImageVersionName = params.get("ImageVersionName")
        self._StartStandbyCluster = params.get("StartStandbyCluster")
        self._ElasticSwitch = params.get("ElasticSwitch")
        self._ElasticLimit = params.get("ElasticLimit")
        self._DefaultHouse = params.get("DefaultHouse")
        self._MaxConcurrency = params.get("MaxConcurrency")
        self._TolerableQueueTime = params.get("TolerableQueueTime")
        self._UserAppId = params.get("UserAppId")
        self._UserUin = params.get("UserUin")
        if params.get("SessionResourceTemplate") is not None:
            self._SessionResourceTemplate = SessionResourceTemplate()
            self._SessionResourceTemplate._deserialize(params.get("SessionResourceTemplate"))
        self._AutoAuthorization = params.get("AutoAuthorization")
        self._EngineGeneration = params.get("EngineGeneration")
        self._EngineTypeDetail = params.get("EngineTypeDetail")
        self._EngineNetworkId = params.get("EngineNetworkId")
        self._EngineResourceGroupCount = params.get("EngineResourceGroupCount")
        self._EngineResourceUsedCU = params.get("EngineResourceUsedCU")
        if params.get("AccessInfos") is not None:
            self._AccessInfos = []
            for item in params.get("AccessInfos"):
                obj = AccessInfo()
                obj._deserialize(item)
                self._AccessInfos.append(obj)
        self._EngineNetworkName = params.get("EngineNetworkName")
        self._IsPoolMode = params.get("IsPoolMode")
        self._IsSupportAI = params.get("IsSupportAI")
        self._GatewayId = params.get("GatewayId")
        self._GatewayState = params.get("GatewayState")
        self._IsAIGateway = params.get("IsAIGateway")
        self._IsAIEngine = params.get("IsAIEngine")
        if params.get("ScheduleElasticityConf") is not None:
            self._ScheduleElasticityConf = ScheduleElasticityConf()
            self._ScheduleElasticityConf._deserialize(params.get("ScheduleElasticityConf"))
        if params.get("GPUInfo") is not None:
            self._GPUInfo = GPUInfo()
            self._GPUInfo._deserialize(params.get("GPUInfo"))
        self._EngineResourceUsedGPU = params.get("EngineResourceUsedGPU")
        self._GPUTotalSize = params.get("GPUTotalSize")
        self._InstanceModel = params.get("InstanceModel")
        self._NodeNum = params.get("NodeNum")
        self._SizeWithElastic = params.get("SizeWithElastic")
        self._MaxElasticSize = params.get("MaxElasticSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataEngineScaleInfo(AbstractModel):
    r"""引擎规格详情

    """

    def __init__(self):
        r"""
        :param _DataEngineId: 引擎ID
        :type DataEngineId: str
        :param _DataEngineName: 引擎名称
        :type DataEngineName: str
        :param _ScaleDetail: 引擎规格详情
        :type ScaleDetail: list of DataEngineScaleInfoDetail
        """
        self._DataEngineId = None
        self._DataEngineName = None
        self._ScaleDetail = None

    @property
    def DataEngineId(self):
        r"""引擎ID
        :rtype: str
        """
        return self._DataEngineId

    @DataEngineId.setter
    def DataEngineId(self, DataEngineId):
        self._DataEngineId = DataEngineId

    @property
    def DataEngineName(self):
        r"""引擎名称
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName

    @property
    def ScaleDetail(self):
        r"""引擎规格详情
        :rtype: list of DataEngineScaleInfoDetail
        """
        return self._ScaleDetail

    @ScaleDetail.setter
    def ScaleDetail(self, ScaleDetail):
        self._ScaleDetail = ScaleDetail


    def _deserialize(self, params):
        self._DataEngineId = params.get("DataEngineId")
        self._DataEngineName = params.get("DataEngineName")
        if params.get("ScaleDetail") is not None:
            self._ScaleDetail = []
            for item in params.get("ScaleDetail"):
                obj = DataEngineScaleInfoDetail()
                obj._deserialize(item)
                self._ScaleDetail.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataEngineScaleInfoDetail(AbstractModel):
    r"""引擎规格详情

    """

    def __init__(self):
        r"""
        :param _StartTime: 统计开始时间，格式为：yyyy-MM-dd HH:mm:ss
        :type StartTime: str
        :param _EndTime: 统计结束时间，格式为：yyyy-MM-dd HH:mm:ss
        :type EndTime: str
        :param _CU: 当前统计时间段，引擎规格
        :type CU: int
        """
        self._StartTime = None
        self._EndTime = None
        self._CU = None

    @property
    def StartTime(self):
        r"""统计开始时间，格式为：yyyy-MM-dd HH:mm:ss
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""统计结束时间，格式为：yyyy-MM-dd HH:mm:ss
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def CU(self):
        r"""当前统计时间段，引擎规格
        :rtype: int
        """
        return self._CU

    @CU.setter
    def CU(self, CU):
        self._CU = CU


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._CU = params.get("CU")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataFormat(AbstractModel):
    r"""数据表数据格式。

    """

    def __init__(self):
        r"""
        :param _TextFile: 文本格式，TextFile。
注意：此字段可能返回 null，表示取不到有效值。
        :type TextFile: :class:`tencentcloud.dlc.v20210125.models.TextFile`
        :param _CSV: 文本格式，CSV。
注意：此字段可能返回 null，表示取不到有效值。
        :type CSV: :class:`tencentcloud.dlc.v20210125.models.CSV`
        :param _Json: 文本格式，Json。
注意：此字段可能返回 null，表示取不到有效值。
        :type Json: :class:`tencentcloud.dlc.v20210125.models.Other`
        :param _Parquet: Parquet格式
注意：此字段可能返回 null，表示取不到有效值。
        :type Parquet: :class:`tencentcloud.dlc.v20210125.models.Other`
        :param _ORC: ORC格式
注意：此字段可能返回 null，表示取不到有效值。
        :type ORC: :class:`tencentcloud.dlc.v20210125.models.Other`
        :param _AVRO: AVRO格式
注意：此字段可能返回 null，表示取不到有效值。
        :type AVRO: :class:`tencentcloud.dlc.v20210125.models.Other`
        """
        self._TextFile = None
        self._CSV = None
        self._Json = None
        self._Parquet = None
        self._ORC = None
        self._AVRO = None

    @property
    def TextFile(self):
        r"""文本格式，TextFile。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.dlc.v20210125.models.TextFile`
        """
        return self._TextFile

    @TextFile.setter
    def TextFile(self, TextFile):
        self._TextFile = TextFile

    @property
    def CSV(self):
        r"""文本格式，CSV。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.dlc.v20210125.models.CSV`
        """
        return self._CSV

    @CSV.setter
    def CSV(self, CSV):
        self._CSV = CSV

    @property
    def Json(self):
        r"""文本格式，Json。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.dlc.v20210125.models.Other`
        """
        return self._Json

    @Json.setter
    def Json(self, Json):
        self._Json = Json

    @property
    def Parquet(self):
        r"""Parquet格式
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.dlc.v20210125.models.Other`
        """
        return self._Parquet

    @Parquet.setter
    def Parquet(self, Parquet):
        self._Parquet = Parquet

    @property
    def ORC(self):
        r"""ORC格式
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.dlc.v20210125.models.Other`
        """
        return self._ORC

    @ORC.setter
    def ORC(self, ORC):
        self._ORC = ORC

    @property
    def AVRO(self):
        r"""AVRO格式
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.dlc.v20210125.models.Other`
        """
        return self._AVRO

    @AVRO.setter
    def AVRO(self, AVRO):
        self._AVRO = AVRO


    def _deserialize(self, params):
        if params.get("TextFile") is not None:
            self._TextFile = TextFile()
            self._TextFile._deserialize(params.get("TextFile"))
        if params.get("CSV") is not None:
            self._CSV = CSV()
            self._CSV._deserialize(params.get("CSV"))
        if params.get("Json") is not None:
            self._Json = Other()
            self._Json._deserialize(params.get("Json"))
        if params.get("Parquet") is not None:
            self._Parquet = Other()
            self._Parquet._deserialize(params.get("Parquet"))
        if params.get("ORC") is not None:
            self._ORC = Other()
            self._ORC._deserialize(params.get("ORC"))
        if params.get("AVRO") is not None:
            self._AVRO = Other()
            self._AVRO._deserialize(params.get("AVRO"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataGovernPolicy(AbstractModel):
    r"""数据治理规则

    """

    def __init__(self):
        r"""
        :param _RuleType: 治理规则类型，Customize: 自定义；Intelligence: 智能治理
        :type RuleType: str
        :param _GovernEngine: 治理引擎
        :type GovernEngine: str
        """
        self._RuleType = None
        self._GovernEngine = None

    @property
    def RuleType(self):
        r"""治理规则类型，Customize: 自定义；Intelligence: 智能治理
        :rtype: str
        """
        return self._RuleType

    @RuleType.setter
    def RuleType(self, RuleType):
        self._RuleType = RuleType

    @property
    def GovernEngine(self):
        r"""治理引擎
        :rtype: str
        """
        return self._GovernEngine

    @GovernEngine.setter
    def GovernEngine(self, GovernEngine):
        self._GovernEngine = GovernEngine


    def _deserialize(self, params):
        self._RuleType = params.get("RuleType")
        self._GovernEngine = params.get("GovernEngine")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataMaskStrategy(AbstractModel):
    r"""数据脱敏策略信息

    """

    def __init__(self):
        r"""
        :param _StrategyId: 策略ID
注意：此字段可能返回 null，表示取不到有效值。
        :type StrategyId: str
        :param _UserAppId: 用户AppId
注意：此字段可能返回 null，表示取不到有效值。
        :type UserAppId: str
        :param _Uin: 用户Uin
注意：此字段可能返回 null，表示取不到有效值。
        :type Uin: str
        :param _SubAccountUin: 操作用户子账号uin
注意：此字段可能返回 null，表示取不到有效值。
        :type SubAccountUin: str
        :param _StrategyName: 策略名称
注意：此字段可能返回 null，表示取不到有效值。
        :type StrategyName: str
        :param _StrategyType: MASK_SHOW_FIRST_4; MASK_SHOW_LAST_4;MASK_HASH; MASK_DATE_SHOW_YEAR; MASK_NULL; MASK_DEFAULT 等
注意：此字段可能返回 null，表示取不到有效值。
        :type StrategyType: str
        :param _StrategyDesc: 策略描述
注意：此字段可能返回 null，表示取不到有效值。
        :type StrategyDesc: str
        :param _Groups: 用户组策略列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Groups: list of GroupInfo
        :param _Users: 用户子账号uin列表，按;拼接
注意：此字段可能返回 null，表示取不到有效值。
        :type Users: str
        :param _State: 1: 生效中； 0：已删除
注意：此字段可能返回 null，表示取不到有效值。
        :type State: int
        :param _CreateTime: 策略创建时间，毫秒时间戳
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: int
        :param _UpdateTime: 策略更新时间，毫秒时间戳
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: int
        """
        self._StrategyId = None
        self._UserAppId = None
        self._Uin = None
        self._SubAccountUin = None
        self._StrategyName = None
        self._StrategyType = None
        self._StrategyDesc = None
        self._Groups = None
        self._Users = None
        self._State = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def StrategyId(self):
        r"""策略ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._StrategyId

    @StrategyId.setter
    def StrategyId(self, StrategyId):
        self._StrategyId = StrategyId

    @property
    def UserAppId(self):
        r"""用户AppId
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._UserAppId

    @UserAppId.setter
    def UserAppId(self, UserAppId):
        self._UserAppId = UserAppId

    @property
    def Uin(self):
        r"""用户Uin
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Uin

    @Uin.setter
    def Uin(self, Uin):
        self._Uin = Uin

    @property
    def SubAccountUin(self):
        r"""操作用户子账号uin
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SubAccountUin

    @SubAccountUin.setter
    def SubAccountUin(self, SubAccountUin):
        self._SubAccountUin = SubAccountUin

    @property
    def StrategyName(self):
        r"""策略名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._StrategyName

    @StrategyName.setter
    def StrategyName(self, StrategyName):
        self._StrategyName = StrategyName

    @property
    def StrategyType(self):
        r"""MASK_SHOW_FIRST_4; MASK_SHOW_LAST_4;MASK_HASH; MASK_DATE_SHOW_YEAR; MASK_NULL; MASK_DEFAULT 等
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._StrategyType

    @StrategyType.setter
    def StrategyType(self, StrategyType):
        self._StrategyType = StrategyType

    @property
    def StrategyDesc(self):
        r"""策略描述
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._StrategyDesc

    @StrategyDesc.setter
    def StrategyDesc(self, StrategyDesc):
        self._StrategyDesc = StrategyDesc

    @property
    def Groups(self):
        r"""用户组策略列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of GroupInfo
        """
        return self._Groups

    @Groups.setter
    def Groups(self, Groups):
        self._Groups = Groups

    @property
    def Users(self):
        r"""用户子账号uin列表，按;拼接
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Users

    @Users.setter
    def Users(self, Users):
        self._Users = Users

    @property
    def State(self):
        r"""1: 生效中； 0：已删除
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def CreateTime(self):
        r"""策略创建时间，毫秒时间戳
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""策略更新时间，毫秒时间戳
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._StrategyId = params.get("StrategyId")
        self._UserAppId = params.get("UserAppId")
        self._Uin = params.get("Uin")
        self._SubAccountUin = params.get("SubAccountUin")
        self._StrategyName = params.get("StrategyName")
        self._StrategyType = params.get("StrategyType")
        self._StrategyDesc = params.get("StrategyDesc")
        if params.get("Groups") is not None:
            self._Groups = []
            for item in params.get("Groups"):
                obj = GroupInfo()
                obj._deserialize(item)
                self._Groups.append(obj)
        self._Users = params.get("Users")
        self._State = params.get("State")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataMaskStrategyInfo(AbstractModel):
    r"""数据脱敏策略信息

    """

    def __init__(self):
        r"""
        :param _StrategyName: 策略名称
        :type StrategyName: str
        :param _StrategyType: MASK_SHOW_FIRST_4; MASK_SHOW_LAST_4;MASK_HASH; MASK_DATE_SHOW_YEAR; MASK_NULL; MASK_DEFAULT 等
        :type StrategyType: str
        :param _StrategyDesc: 策略描述
        :type StrategyDesc: str
        :param _Groups: 用户组策略列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Groups: list of GroupInfo
        :param _Users: 用户子账号uin列表，按;拼接
        :type Users: str
        :param _StrategyId: 策略Id
        :type StrategyId: str
        """
        self._StrategyName = None
        self._StrategyType = None
        self._StrategyDesc = None
        self._Groups = None
        self._Users = None
        self._StrategyId = None

    @property
    def StrategyName(self):
        r"""策略名称
        :rtype: str
        """
        return self._StrategyName

    @StrategyName.setter
    def StrategyName(self, StrategyName):
        self._StrategyName = StrategyName

    @property
    def StrategyType(self):
        r"""MASK_SHOW_FIRST_4; MASK_SHOW_LAST_4;MASK_HASH; MASK_DATE_SHOW_YEAR; MASK_NULL; MASK_DEFAULT 等
        :rtype: str
        """
        return self._StrategyType

    @StrategyType.setter
    def StrategyType(self, StrategyType):
        self._StrategyType = StrategyType

    @property
    def StrategyDesc(self):
        r"""策略描述
        :rtype: str
        """
        return self._StrategyDesc

    @StrategyDesc.setter
    def StrategyDesc(self, StrategyDesc):
        self._StrategyDesc = StrategyDesc

    @property
    def Groups(self):
        r"""用户组策略列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of GroupInfo
        """
        return self._Groups

    @Groups.setter
    def Groups(self, Groups):
        self._Groups = Groups

    @property
    def Users(self):
        r"""用户子账号uin列表，按;拼接
        :rtype: str
        """
        return self._Users

    @Users.setter
    def Users(self, Users):
        self._Users = Users

    @property
    def StrategyId(self):
        r"""策略Id
        :rtype: str
        """
        return self._StrategyId

    @StrategyId.setter
    def StrategyId(self, StrategyId):
        self._StrategyId = StrategyId


    def _deserialize(self, params):
        self._StrategyName = params.get("StrategyName")
        self._StrategyType = params.get("StrategyType")
        self._StrategyDesc = params.get("StrategyDesc")
        if params.get("Groups") is not None:
            self._Groups = []
            for item in params.get("Groups"):
                obj = GroupInfo()
                obj._deserialize(item)
                self._Groups.append(obj)
        self._Users = params.get("Users")
        self._StrategyId = params.get("StrategyId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataMaskStrategyPolicy(AbstractModel):
    r"""数据脱敏策略权限对象

    """

    def __init__(self):
        r"""
        :param _PolicyInfo: 数据脱敏权限对象
注意：此字段可能返回 null，表示取不到有效值。
        :type PolicyInfo: :class:`tencentcloud.dlc.v20210125.models.Policy`
        :param _DataMaskStrategyId: 数据脱敏策略ID
注意：此字段可能返回 null，表示取不到有效值。
        :type DataMaskStrategyId: str
        :param _ColumnType: 绑定字段类型
注意：此字段可能返回 null，表示取不到有效值。
        :type ColumnType: str
        """
        self._PolicyInfo = None
        self._DataMaskStrategyId = None
        self._ColumnType = None

    @property
    def PolicyInfo(self):
        r"""数据脱敏权限对象
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.dlc.v20210125.models.Policy`
        """
        return self._PolicyInfo

    @PolicyInfo.setter
    def PolicyInfo(self, PolicyInfo):
        self._PolicyInfo = PolicyInfo

    @property
    def DataMaskStrategyId(self):
        r"""数据脱敏策略ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DataMaskStrategyId

    @DataMaskStrategyId.setter
    def DataMaskStrategyId(self, DataMaskStrategyId):
        self._DataMaskStrategyId = DataMaskStrategyId

    @property
    def ColumnType(self):
        r"""绑定字段类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ColumnType

    @ColumnType.setter
    def ColumnType(self, ColumnType):
        self._ColumnType = ColumnType


    def _deserialize(self, params):
        if params.get("PolicyInfo") is not None:
            self._PolicyInfo = Policy()
            self._PolicyInfo._deserialize(params.get("PolicyInfo"))
        self._DataMaskStrategyId = params.get("DataMaskStrategyId")
        self._ColumnType = params.get("ColumnType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataSourceInfo(AbstractModel):
    r"""数据源详细信息

    """

    def __init__(self):
        r"""
        :param _InstanceId: 数据源实例的唯一ID
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceId: str
        :param _InstanceName: 数据源的名称
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceName: str
        :param _JdbcUrl: 数据源的JDBC访问链接
注意：此字段可能返回 null，表示取不到有效值。
        :type JdbcUrl: str
        :param _User: 用于访问数据源的用户名
注意：此字段可能返回 null，表示取不到有效值。
        :type User: str
        :param _Password: 数据源访问密码，需要base64编码
注意：此字段可能返回 null，表示取不到有效值。
        :type Password: str
        :param _Location: 数据源的VPC和子网信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Location: :class:`tencentcloud.dlc.v20210125.models.DatasourceConnectionLocation`
        :param _DbName: 默认数据库名
注意：此字段可能返回 null，表示取不到有效值。
        :type DbName: str
        """
        self._InstanceId = None
        self._InstanceName = None
        self._JdbcUrl = None
        self._User = None
        self._Password = None
        self._Location = None
        self._DbName = None

    @property
    def InstanceId(self):
        r"""数据源实例的唯一ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def InstanceName(self):
        r"""数据源的名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def JdbcUrl(self):
        r"""数据源的JDBC访问链接
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._JdbcUrl

    @JdbcUrl.setter
    def JdbcUrl(self, JdbcUrl):
        self._JdbcUrl = JdbcUrl

    @property
    def User(self):
        r"""用于访问数据源的用户名
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def Password(self):
        r"""数据源访问密码，需要base64编码
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Password

    @Password.setter
    def Password(self, Password):
        self._Password = Password

    @property
    def Location(self):
        r"""数据源的VPC和子网信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.dlc.v20210125.models.DatasourceConnectionLocation`
        """
        return self._Location

    @Location.setter
    def Location(self, Location):
        self._Location = Location

    @property
    def DbName(self):
        r"""默认数据库名
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DbName

    @DbName.setter
    def DbName(self, DbName):
        self._DbName = DbName


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._InstanceName = params.get("InstanceName")
        self._JdbcUrl = params.get("JdbcUrl")
        self._User = params.get("User")
        self._Password = params.get("Password")
        if params.get("Location") is not None:
            self._Location = DatasourceConnectionLocation()
            self._Location._deserialize(params.get("Location"))
        self._DbName = params.get("DbName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DatabaseInfo(AbstractModel):
    r"""数据库对象

    """

    def __init__(self):
        r"""
        :param _DatabaseName: 数据库名称，长度0~128，支持数字、字母下划线，不允许数字大头，统一转换为小写。
        :type DatabaseName: str
        :param _Comment: 数据库描述信息，长度 0~500。
注意：此字段可能返回 null，表示取不到有效值。
        :type Comment: str
        :param _Properties: 数据库属性列表。
注意：此字段可能返回 null，表示取不到有效值。
        :type Properties: list of Property
        :param _Location: 数据库cos路径
        :type Location: str
        """
        self._DatabaseName = None
        self._Comment = None
        self._Properties = None
        self._Location = None

    @property
    def DatabaseName(self):
        r"""数据库名称，长度0~128，支持数字、字母下划线，不允许数字大头，统一转换为小写。
        :rtype: str
        """
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def Comment(self):
        r"""数据库描述信息，长度 0~500。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def Properties(self):
        r"""数据库属性列表。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of Property
        """
        return self._Properties

    @Properties.setter
    def Properties(self, Properties):
        self._Properties = Properties

    @property
    def Location(self):
        r"""数据库cos路径
        :rtype: str
        """
        return self._Location

    @Location.setter
    def Location(self, Location):
        self._Location = Location


    def _deserialize(self, params):
        self._DatabaseName = params.get("DatabaseName")
        self._Comment = params.get("Comment")
        if params.get("Properties") is not None:
            self._Properties = []
            for item in params.get("Properties"):
                obj = Property()
                obj._deserialize(item)
                self._Properties.append(obj)
        self._Location = params.get("Location")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DatabaseResponseInfo(AbstractModel):
    r"""数据库对象

    """

    def __init__(self):
        r"""
        :param _DatabaseName: 数据库名称。
        :type DatabaseName: str
        :param _Comment: 数据库描述信息，长度 0~256。
        :type Comment: str
        :param _Properties: 允许针对数据库的属性元数据信息进行指定。
注意：此字段可能返回 null，表示取不到有效值。
        :type Properties: list of Property
        :param _CreateTime: 数据库创建时间戳，单位：s。
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: str
        :param _ModifiedTime: 数据库更新时间戳，单位：s。
注意：此字段可能返回 null，表示取不到有效值。
        :type ModifiedTime: str
        :param _Location: cos存储路径
        :type Location: str
        :param _UserAlias: 建库用户昵称
        :type UserAlias: str
        :param _UserSubUin: 建库用户ID
        :type UserSubUin: str
        :param _GovernPolicy: 数据治理配置项
注意：此字段可能返回 null，表示取不到有效值。
        :type GovernPolicy: :class:`tencentcloud.dlc.v20210125.models.DataGovernPolicy`
        :param _DatabaseId: 数据库ID（无效字段）
        :type DatabaseId: str
        """
        self._DatabaseName = None
        self._Comment = None
        self._Properties = None
        self._CreateTime = None
        self._ModifiedTime = None
        self._Location = None
        self._UserAlias = None
        self._UserSubUin = None
        self._GovernPolicy = None
        self._DatabaseId = None

    @property
    def DatabaseName(self):
        r"""数据库名称。
        :rtype: str
        """
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def Comment(self):
        r"""数据库描述信息，长度 0~256。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def Properties(self):
        r"""允许针对数据库的属性元数据信息进行指定。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of Property
        """
        return self._Properties

    @Properties.setter
    def Properties(self, Properties):
        self._Properties = Properties

    @property
    def CreateTime(self):
        r"""数据库创建时间戳，单位：s。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ModifiedTime(self):
        r"""数据库更新时间戳，单位：s。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ModifiedTime

    @ModifiedTime.setter
    def ModifiedTime(self, ModifiedTime):
        self._ModifiedTime = ModifiedTime

    @property
    def Location(self):
        r"""cos存储路径
        :rtype: str
        """
        return self._Location

    @Location.setter
    def Location(self, Location):
        self._Location = Location

    @property
    def UserAlias(self):
        r"""建库用户昵称
        :rtype: str
        """
        return self._UserAlias

    @UserAlias.setter
    def UserAlias(self, UserAlias):
        self._UserAlias = UserAlias

    @property
    def UserSubUin(self):
        r"""建库用户ID
        :rtype: str
        """
        return self._UserSubUin

    @UserSubUin.setter
    def UserSubUin(self, UserSubUin):
        self._UserSubUin = UserSubUin

    @property
    def GovernPolicy(self):
        r"""数据治理配置项
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.dlc.v20210125.models.DataGovernPolicy`
        """
        return self._GovernPolicy

    @GovernPolicy.setter
    def GovernPolicy(self, GovernPolicy):
        self._GovernPolicy = GovernPolicy

    @property
    def DatabaseId(self):
        r"""数据库ID（无效字段）
        :rtype: str
        """
        return self._DatabaseId

    @DatabaseId.setter
    def DatabaseId(self, DatabaseId):
        self._DatabaseId = DatabaseId


    def _deserialize(self, params):
        self._DatabaseName = params.get("DatabaseName")
        self._Comment = params.get("Comment")
        if params.get("Properties") is not None:
            self._Properties = []
            for item in params.get("Properties"):
                obj = Property()
                obj._deserialize(item)
                self._Properties.append(obj)
        self._CreateTime = params.get("CreateTime")
        self._ModifiedTime = params.get("ModifiedTime")
        self._Location = params.get("Location")
        self._UserAlias = params.get("UserAlias")
        self._UserSubUin = params.get("UserSubUin")
        if params.get("GovernPolicy") is not None:
            self._GovernPolicy = DataGovernPolicy()
            self._GovernPolicy._deserialize(params.get("GovernPolicy"))
        self._DatabaseId = params.get("DatabaseId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DatasourceConnectionConfig(AbstractModel):
    r"""数据源属性

    """

    def __init__(self):
        r"""
        :param _Mysql: Mysql数据源连接的属性
注意：此字段可能返回 null，表示取不到有效值。
        :type Mysql: :class:`tencentcloud.dlc.v20210125.models.MysqlInfo`
        :param _Hive: Hive数据源连接的属性
注意：此字段可能返回 null，表示取不到有效值。
        :type Hive: :class:`tencentcloud.dlc.v20210125.models.HiveInfo`
        :param _Kafka: Kafka数据源连接的属性
注意：此字段可能返回 null，表示取不到有效值。
        :type Kafka: :class:`tencentcloud.dlc.v20210125.models.KafkaInfo`
        :param _OtherDatasourceConnection: 其他数据源连接的属性
注意：此字段可能返回 null，表示取不到有效值。
        :type OtherDatasourceConnection: :class:`tencentcloud.dlc.v20210125.models.OtherDatasourceConnection`
        :param _PostgreSql: PostgreSQL数据源连接的属性
注意：此字段可能返回 null，表示取不到有效值。
        :type PostgreSql: :class:`tencentcloud.dlc.v20210125.models.DataSourceInfo`
        :param _SqlServer: SQLServer数据源连接的属性
注意：此字段可能返回 null，表示取不到有效值。
        :type SqlServer: :class:`tencentcloud.dlc.v20210125.models.DataSourceInfo`
        :param _ClickHouse: ClickHouse数据源连接的属性
注意：此字段可能返回 null，表示取不到有效值。
        :type ClickHouse: :class:`tencentcloud.dlc.v20210125.models.DataSourceInfo`
        :param _Elasticsearch: Elasticsearch数据源连接的属性
注意：此字段可能返回 null，表示取不到有效值。
        :type Elasticsearch: :class:`tencentcloud.dlc.v20210125.models.ElasticsearchInfo`
        :param _TDSQLPostgreSql: TDSQL-PostgreSQL数据源连接的属性
注意：此字段可能返回 null，表示取不到有效值。
        :type TDSQLPostgreSql: :class:`tencentcloud.dlc.v20210125.models.DataSourceInfo`
        :param _TCHouseD: Doris数据源连接的属性
注意：此字段可能返回 null，表示取不到有效值。
        :type TCHouseD: :class:`tencentcloud.dlc.v20210125.models.TCHouseD`
        :param _TccHive: TccHive数据目录连接信息
        :type TccHive: :class:`tencentcloud.dlc.v20210125.models.TccHive`
        :param _MongoDB: MongoDB 数据源
        :type MongoDB: :class:`tencentcloud.dlc.v20210125.models.DataSourceInfo`
        """
        self._Mysql = None
        self._Hive = None
        self._Kafka = None
        self._OtherDatasourceConnection = None
        self._PostgreSql = None
        self._SqlServer = None
        self._ClickHouse = None
        self._Elasticsearch = None
        self._TDSQLPostgreSql = None
        self._TCHouseD = None
        self._TccHive = None
        self._MongoDB = None

    @property
    def Mysql(self):
        r"""Mysql数据源连接的属性
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.dlc.v20210125.models.MysqlInfo`
        """
        return self._Mysql

    @Mysql.setter
    def Mysql(self, Mysql):
        self._Mysql = Mysql

    @property
    def Hive(self):
        r"""Hive数据源连接的属性
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.dlc.v20210125.models.HiveInfo`
        """
        return self._Hive

    @Hive.setter
    def Hive(self, Hive):
        self._Hive = Hive

    @property
    def Kafka(self):
        r"""Kafka数据源连接的属性
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.dlc.v20210125.models.KafkaInfo`
        """
        return self._Kafka

    @Kafka.setter
    def Kafka(self, Kafka):
        self._Kafka = Kafka

    @property
    def OtherDatasourceConnection(self):
        r"""其他数据源连接的属性
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.dlc.v20210125.models.OtherDatasourceConnection`
        """
        return self._OtherDatasourceConnection

    @OtherDatasourceConnection.setter
    def OtherDatasourceConnection(self, OtherDatasourceConnection):
        self._OtherDatasourceConnection = OtherDatasourceConnection

    @property
    def PostgreSql(self):
        r"""PostgreSQL数据源连接的属性
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.dlc.v20210125.models.DataSourceInfo`
        """
        return self._PostgreSql

    @PostgreSql.setter
    def PostgreSql(self, PostgreSql):
        self._PostgreSql = PostgreSql

    @property
    def SqlServer(self):
        r"""SQLServer数据源连接的属性
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.dlc.v20210125.models.DataSourceInfo`
        """
        return self._SqlServer

    @SqlServer.setter
    def SqlServer(self, SqlServer):
        self._SqlServer = SqlServer

    @property
    def ClickHouse(self):
        r"""ClickHouse数据源连接的属性
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.dlc.v20210125.models.DataSourceInfo`
        """
        return self._ClickHouse

    @ClickHouse.setter
    def ClickHouse(self, ClickHouse):
        self._ClickHouse = ClickHouse

    @property
    def Elasticsearch(self):
        r"""Elasticsearch数据源连接的属性
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.dlc.v20210125.models.ElasticsearchInfo`
        """
        return self._Elasticsearch

    @Elasticsearch.setter
    def Elasticsearch(self, Elasticsearch):
        self._Elasticsearch = Elasticsearch

    @property
    def TDSQLPostgreSql(self):
        r"""TDSQL-PostgreSQL数据源连接的属性
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.dlc.v20210125.models.DataSourceInfo`
        """
        return self._TDSQLPostgreSql

    @TDSQLPostgreSql.setter
    def TDSQLPostgreSql(self, TDSQLPostgreSql):
        self._TDSQLPostgreSql = TDSQLPostgreSql

    @property
    def TCHouseD(self):
        r"""Doris数据源连接的属性
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.dlc.v20210125.models.TCHouseD`
        """
        return self._TCHouseD

    @TCHouseD.setter
    def TCHouseD(self, TCHouseD):
        self._TCHouseD = TCHouseD

    @property
    def TccHive(self):
        r"""TccHive数据目录连接信息
        :rtype: :class:`tencentcloud.dlc.v20210125.models.TccHive`
        """
        return self._TccHive

    @TccHive.setter
    def TccHive(self, TccHive):
        self._TccHive = TccHive

    @property
    def MongoDB(self):
        r"""MongoDB 数据源
        :rtype: :class:`tencentcloud.dlc.v20210125.models.DataSourceInfo`
        """
        return self._MongoDB

    @MongoDB.setter
    def MongoDB(self, MongoDB):
        self._MongoDB = MongoDB


    def _deserialize(self, params):
        if params.get("Mysql") is not None:
            self._Mysql = MysqlInfo()
            self._Mysql._deserialize(params.get("Mysql"))
        if params.get("Hive") is not None:
            self._Hive = HiveInfo()
            self._Hive._deserialize(params.get("Hive"))
        if params.get("Kafka") is not None:
            self._Kafka = KafkaInfo()
            self._Kafka._deserialize(params.get("Kafka"))
        if params.get("OtherDatasourceConnection") is not None:
            self._OtherDatasourceConnection = OtherDatasourceConnection()
            self._OtherDatasourceConnection._deserialize(params.get("OtherDatasourceConnection"))
        if params.get("PostgreSql") is not None:
            self._PostgreSql = DataSourceInfo()
            self._PostgreSql._deserialize(params.get("PostgreSql"))
        if params.get("SqlServer") is not None:
            self._SqlServer = DataSourceInfo()
            self._SqlServer._deserialize(params.get("SqlServer"))
        if params.get("ClickHouse") is not None:
            self._ClickHouse = DataSourceInfo()
            self._ClickHouse._deserialize(params.get("ClickHouse"))
        if params.get("Elasticsearch") is not None:
            self._Elasticsearch = ElasticsearchInfo()
            self._Elasticsearch._deserialize(params.get("Elasticsearch"))
        if params.get("TDSQLPostgreSql") is not None:
            self._TDSQLPostgreSql = DataSourceInfo()
            self._TDSQLPostgreSql._deserialize(params.get("TDSQLPostgreSql"))
        if params.get("TCHouseD") is not None:
            self._TCHouseD = TCHouseD()
            self._TCHouseD._deserialize(params.get("TCHouseD"))
        if params.get("TccHive") is not None:
            self._TccHive = TccHive()
            self._TccHive._deserialize(params.get("TccHive"))
        if params.get("MongoDB") is not None:
            self._MongoDB = DataSourceInfo()
            self._MongoDB._deserialize(params.get("MongoDB"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DatasourceConnectionInfo(AbstractModel):
    r"""数据源信息

    """

    def __init__(self):
        r"""
        :param _Id: 数据源数字Id
        :type Id: int
        :param _DatasourceConnectionId: 数据源字符串Id
        :type DatasourceConnectionId: str
        :param _DatasourceConnectionName: 数据源名称
        :type DatasourceConnectionName: str
        :param _DatasourceConnectionDesc: 数据源描述
        :type DatasourceConnectionDesc: str
        :param _DatasourceConnectionType: 数据源类型，支持DataLakeCatalog、IcebergCatalog、Result、Mysql、HiveCos、HiveHdfs
        :type DatasourceConnectionType: str
        :param _DatasourceConnectionConfig: 数据源属性
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceConnectionConfig: :class:`tencentcloud.dlc.v20210125.models.DatasourceConnectionConfig`
        :param _State: 数据源状态：0（初始化）、1（成功）、-1（已删除）、-2（失败）、-3（删除中）
        :type State: int
        :param _Region: 地域
        :type Region: str
        :param _AppId: 用户AppId
        :type AppId: str
        :param _CreateTime: 数据源创建时间
        :type CreateTime: str
        :param _UpdateTime: 数据源最近一次更新时间
        :type UpdateTime: str
        :param _Message: 数据源同步失败原因
        :type Message: str
        :param _DataEngines: 数据源绑定的计算引擎信息
注意：此字段可能返回 null，表示取不到有效值。
        :type DataEngines: list of DataEngineInfo
        :param _UserAlias: 创建人
        :type UserAlias: str
        :param _NetworkConnectionSet: 网络配置列表
注意：此字段可能返回 null，表示取不到有效值。
        :type NetworkConnectionSet: list of NetworkConnection
        :param _ConnectivityState: 连通性状态：0（未测试，默认）、1（正常）、2（失败）
        :type ConnectivityState: int
        :param _ConnectivityTips: 连通性测试提示信息
        :type ConnectivityTips: str
        :param _CustomConfig: 自定义参数
        :type CustomConfig: list of CustomConfig
        :param _AllowRollback: 是否允许回退
        :type AllowRollback: bool
        """
        self._Id = None
        self._DatasourceConnectionId = None
        self._DatasourceConnectionName = None
        self._DatasourceConnectionDesc = None
        self._DatasourceConnectionType = None
        self._DatasourceConnectionConfig = None
        self._State = None
        self._Region = None
        self._AppId = None
        self._CreateTime = None
        self._UpdateTime = None
        self._Message = None
        self._DataEngines = None
        self._UserAlias = None
        self._NetworkConnectionSet = None
        self._ConnectivityState = None
        self._ConnectivityTips = None
        self._CustomConfig = None
        self._AllowRollback = None

    @property
    def Id(self):
        r"""数据源数字Id
        :rtype: int
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def DatasourceConnectionId(self):
        r"""数据源字符串Id
        :rtype: str
        """
        return self._DatasourceConnectionId

    @DatasourceConnectionId.setter
    def DatasourceConnectionId(self, DatasourceConnectionId):
        self._DatasourceConnectionId = DatasourceConnectionId

    @property
    def DatasourceConnectionName(self):
        r"""数据源名称
        :rtype: str
        """
        return self._DatasourceConnectionName

    @DatasourceConnectionName.setter
    def DatasourceConnectionName(self, DatasourceConnectionName):
        self._DatasourceConnectionName = DatasourceConnectionName

    @property
    def DatasourceConnectionDesc(self):
        r"""数据源描述
        :rtype: str
        """
        return self._DatasourceConnectionDesc

    @DatasourceConnectionDesc.setter
    def DatasourceConnectionDesc(self, DatasourceConnectionDesc):
        self._DatasourceConnectionDesc = DatasourceConnectionDesc

    @property
    def DatasourceConnectionType(self):
        r"""数据源类型，支持DataLakeCatalog、IcebergCatalog、Result、Mysql、HiveCos、HiveHdfs
        :rtype: str
        """
        return self._DatasourceConnectionType

    @DatasourceConnectionType.setter
    def DatasourceConnectionType(self, DatasourceConnectionType):
        self._DatasourceConnectionType = DatasourceConnectionType

    @property
    def DatasourceConnectionConfig(self):
        r"""数据源属性
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.dlc.v20210125.models.DatasourceConnectionConfig`
        """
        return self._DatasourceConnectionConfig

    @DatasourceConnectionConfig.setter
    def DatasourceConnectionConfig(self, DatasourceConnectionConfig):
        self._DatasourceConnectionConfig = DatasourceConnectionConfig

    @property
    def State(self):
        r"""数据源状态：0（初始化）、1（成功）、-1（已删除）、-2（失败）、-3（删除中）
        :rtype: int
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def Region(self):
        r"""地域
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def AppId(self):
        r"""用户AppId
        :rtype: str
        """
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId

    @property
    def CreateTime(self):
        r"""数据源创建时间
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""数据源最近一次更新时间
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def Message(self):
        r"""数据源同步失败原因
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def DataEngines(self):
        r"""数据源绑定的计算引擎信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of DataEngineInfo
        """
        return self._DataEngines

    @DataEngines.setter
    def DataEngines(self, DataEngines):
        self._DataEngines = DataEngines

    @property
    def UserAlias(self):
        r"""创建人
        :rtype: str
        """
        return self._UserAlias

    @UserAlias.setter
    def UserAlias(self, UserAlias):
        self._UserAlias = UserAlias

    @property
    def NetworkConnectionSet(self):
        r"""网络配置列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of NetworkConnection
        """
        return self._NetworkConnectionSet

    @NetworkConnectionSet.setter
    def NetworkConnectionSet(self, NetworkConnectionSet):
        self._NetworkConnectionSet = NetworkConnectionSet

    @property
    def ConnectivityState(self):
        r"""连通性状态：0（未测试，默认）、1（正常）、2（失败）
        :rtype: int
        """
        return self._ConnectivityState

    @ConnectivityState.setter
    def ConnectivityState(self, ConnectivityState):
        self._ConnectivityState = ConnectivityState

    @property
    def ConnectivityTips(self):
        r"""连通性测试提示信息
        :rtype: str
        """
        return self._ConnectivityTips

    @ConnectivityTips.setter
    def ConnectivityTips(self, ConnectivityTips):
        self._ConnectivityTips = ConnectivityTips

    @property
    def CustomConfig(self):
        r"""自定义参数
        :rtype: list of CustomConfig
        """
        return self._CustomConfig

    @CustomConfig.setter
    def CustomConfig(self, CustomConfig):
        self._CustomConfig = CustomConfig

    @property
    def AllowRollback(self):
        r"""是否允许回退
        :rtype: bool
        """
        return self._AllowRollback

    @AllowRollback.setter
    def AllowRollback(self, AllowRollback):
        self._AllowRollback = AllowRollback


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._DatasourceConnectionId = params.get("DatasourceConnectionId")
        self._DatasourceConnectionName = params.get("DatasourceConnectionName")
        self._DatasourceConnectionDesc = params.get("DatasourceConnectionDesc")
        self._DatasourceConnectionType = params.get("DatasourceConnectionType")
        if params.get("DatasourceConnectionConfig") is not None:
            self._DatasourceConnectionConfig = DatasourceConnectionConfig()
            self._DatasourceConnectionConfig._deserialize(params.get("DatasourceConnectionConfig"))
        self._State = params.get("State")
        self._Region = params.get("Region")
        self._AppId = params.get("AppId")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._Message = params.get("Message")
        if params.get("DataEngines") is not None:
            self._DataEngines = []
            for item in params.get("DataEngines"):
                obj = DataEngineInfo()
                obj._deserialize(item)
                self._DataEngines.append(obj)
        self._UserAlias = params.get("UserAlias")
        if params.get("NetworkConnectionSet") is not None:
            self._NetworkConnectionSet = []
            for item in params.get("NetworkConnectionSet"):
                obj = NetworkConnection()
                obj._deserialize(item)
                self._NetworkConnectionSet.append(obj)
        self._ConnectivityState = params.get("ConnectivityState")
        self._ConnectivityTips = params.get("ConnectivityTips")
        if params.get("CustomConfig") is not None:
            self._CustomConfig = []
            for item in params.get("CustomConfig"):
                obj = CustomConfig()
                obj._deserialize(item)
                self._CustomConfig.append(obj)
        self._AllowRollback = params.get("AllowRollback")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DatasourceConnectionLocation(AbstractModel):
    r"""数据源连接的网络信息

    """

    def __init__(self):
        r"""
        :param _VpcId: 数据连接所在Vpc实例Id，如“vpc-azd4dt1c”。
        :type VpcId: str
        :param _VpcCidrBlock: Vpc的IPv4 CIDR
        :type VpcCidrBlock: str
        :param _SubnetId: 数据连接所在子网的实例Id，如“subnet-bthucmmy”
        :type SubnetId: str
        :param _SubnetCidrBlock: Subnet的IPv4 CIDR
        :type SubnetCidrBlock: str
        """
        self._VpcId = None
        self._VpcCidrBlock = None
        self._SubnetId = None
        self._SubnetCidrBlock = None

    @property
    def VpcId(self):
        r"""数据连接所在Vpc实例Id，如“vpc-azd4dt1c”。
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def VpcCidrBlock(self):
        r"""Vpc的IPv4 CIDR
        :rtype: str
        """
        return self._VpcCidrBlock

    @VpcCidrBlock.setter
    def VpcCidrBlock(self, VpcCidrBlock):
        self._VpcCidrBlock = VpcCidrBlock

    @property
    def SubnetId(self):
        r"""数据连接所在子网的实例Id，如“subnet-bthucmmy”
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def SubnetCidrBlock(self):
        r"""Subnet的IPv4 CIDR
        :rtype: str
        """
        return self._SubnetCidrBlock

    @SubnetCidrBlock.setter
    def SubnetCidrBlock(self, SubnetCidrBlock):
        self._SubnetCidrBlock = SubnetCidrBlock


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._VpcCidrBlock = params.get("VpcCidrBlock")
        self._SubnetId = params.get("SubnetId")
        self._SubnetCidrBlock = params.get("SubnetCidrBlock")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCHDFSBindingProductRequest(AbstractModel):
    r"""DeleteCHDFSBindingProduct请求参数结构体

    """

    def __init__(self):
        r"""
        :param _MountPoint: 需要解绑的元数据加速桶名
        :type MountPoint: str
        :param _BucketType: 桶的类型，分为cos和lakefs
        :type BucketType: str
        :param _ProductName: 产品名称
        :type ProductName: str
        :param _EngineName: 引擎名称，ProductName选择DLC产品时，必传此参数。其他产品可不传
        :type EngineName: str
        :param _VpcInfo: vpc信息，ProductName选择other时，必传此参数
        :type VpcInfo: list of VpcInfo
        """
        self._MountPoint = None
        self._BucketType = None
        self._ProductName = None
        self._EngineName = None
        self._VpcInfo = None

    @property
    def MountPoint(self):
        r"""需要解绑的元数据加速桶名
        :rtype: str
        """
        return self._MountPoint

    @MountPoint.setter
    def MountPoint(self, MountPoint):
        self._MountPoint = MountPoint

    @property
    def BucketType(self):
        r"""桶的类型，分为cos和lakefs
        :rtype: str
        """
        return self._BucketType

    @BucketType.setter
    def BucketType(self, BucketType):
        self._BucketType = BucketType

    @property
    def ProductName(self):
        r"""产品名称
        :rtype: str
        """
        return self._ProductName

    @ProductName.setter
    def ProductName(self, ProductName):
        self._ProductName = ProductName

    @property
    def EngineName(self):
        r"""引擎名称，ProductName选择DLC产品时，必传此参数。其他产品可不传
        :rtype: str
        """
        return self._EngineName

    @EngineName.setter
    def EngineName(self, EngineName):
        self._EngineName = EngineName

    @property
    def VpcInfo(self):
        r"""vpc信息，ProductName选择other时，必传此参数
        :rtype: list of VpcInfo
        """
        return self._VpcInfo

    @VpcInfo.setter
    def VpcInfo(self, VpcInfo):
        self._VpcInfo = VpcInfo


    def _deserialize(self, params):
        self._MountPoint = params.get("MountPoint")
        self._BucketType = params.get("BucketType")
        self._ProductName = params.get("ProductName")
        self._EngineName = params.get("EngineName")
        if params.get("VpcInfo") is not None:
            self._VpcInfo = []
            for item in params.get("VpcInfo"):
                obj = VpcInfo()
                obj._deserialize(item)
                self._VpcInfo.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCHDFSBindingProductResponse(AbstractModel):
    r"""DeleteCHDFSBindingProduct返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteDataEngineRequest(AbstractModel):
    r"""DeleteDataEngine请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DataEngineNames: 删除虚拟集群的名称数组
        :type DataEngineNames: list of str
        """
        self._DataEngineNames = None

    @property
    def DataEngineNames(self):
        r"""删除虚拟集群的名称数组
        :rtype: list of str
        """
        return self._DataEngineNames

    @DataEngineNames.setter
    def DataEngineNames(self, DataEngineNames):
        self._DataEngineNames = DataEngineNames


    def _deserialize(self, params):
        self._DataEngineNames = params.get("DataEngineNames")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteDataEngineResponse(AbstractModel):
    r"""DeleteDataEngine返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteDataMaskStrategyRequest(AbstractModel):
    r"""DeleteDataMaskStrategy请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StrategyId: 数据脱敏策略Id
        :type StrategyId: str
        """
        self._StrategyId = None

    @property
    def StrategyId(self):
        r"""数据脱敏策略Id
        :rtype: str
        """
        return self._StrategyId

    @StrategyId.setter
    def StrategyId(self, StrategyId):
        self._StrategyId = StrategyId


    def _deserialize(self, params):
        self._StrategyId = params.get("StrategyId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteDataMaskStrategyResponse(AbstractModel):
    r"""DeleteDataMaskStrategy返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteNativeSparkSessionRequest(AbstractModel):
    r"""DeleteNativeSparkSession请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DataEngineId: 引擎id
        :type DataEngineId: str
        :param _ResourceGroupId: 资源组id
        :type ResourceGroupId: str
        :param _EngineSessionName: spark session名称
        :type EngineSessionName: str
        """
        self._DataEngineId = None
        self._ResourceGroupId = None
        self._EngineSessionName = None

    @property
    def DataEngineId(self):
        r"""引擎id
        :rtype: str
        """
        return self._DataEngineId

    @DataEngineId.setter
    def DataEngineId(self, DataEngineId):
        self._DataEngineId = DataEngineId

    @property
    def ResourceGroupId(self):
        r"""资源组id
        :rtype: str
        """
        return self._ResourceGroupId

    @ResourceGroupId.setter
    def ResourceGroupId(self, ResourceGroupId):
        self._ResourceGroupId = ResourceGroupId

    @property
    def EngineSessionName(self):
        r"""spark session名称
        :rtype: str
        """
        return self._EngineSessionName

    @EngineSessionName.setter
    def EngineSessionName(self, EngineSessionName):
        self._EngineSessionName = EngineSessionName


    def _deserialize(self, params):
        self._DataEngineId = params.get("DataEngineId")
        self._ResourceGroupId = params.get("ResourceGroupId")
        self._EngineSessionName = params.get("EngineSessionName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteNativeSparkSessionResponse(AbstractModel):
    r"""DeleteNativeSparkSession返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteNotebookSessionRequest(AbstractModel):
    r"""DeleteNotebookSession请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SessionId: Session唯一标识
        :type SessionId: str
        """
        self._SessionId = None

    @property
    def SessionId(self):
        r"""Session唯一标识
        :rtype: str
        """
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId


    def _deserialize(self, params):
        self._SessionId = params.get("SessionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteNotebookSessionResponse(AbstractModel):
    r"""DeleteNotebookSession返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteScriptRequest(AbstractModel):
    r"""DeleteScript请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ScriptIds: 脚本id，其可以通过DescribeScripts接口提取
        :type ScriptIds: list of str
        """
        self._ScriptIds = None

    @property
    def ScriptIds(self):
        r"""脚本id，其可以通过DescribeScripts接口提取
        :rtype: list of str
        """
        return self._ScriptIds

    @ScriptIds.setter
    def ScriptIds(self, ScriptIds):
        self._ScriptIds = ScriptIds


    def _deserialize(self, params):
        self._ScriptIds = params.get("ScriptIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteScriptResponse(AbstractModel):
    r"""DeleteScript返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ScriptsAffected: 删除的脚本数量
        :type ScriptsAffected: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ScriptsAffected = None
        self._RequestId = None

    @property
    def ScriptsAffected(self):
        r"""删除的脚本数量
        :rtype: int
        """
        return self._ScriptsAffected

    @ScriptsAffected.setter
    def ScriptsAffected(self, ScriptsAffected):
        self._ScriptsAffected = ScriptsAffected

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ScriptsAffected = params.get("ScriptsAffected")
        self._RequestId = params.get("RequestId")


class DeleteSparkAppRequest(AbstractModel):
    r"""DeleteSparkApp请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AppName: spark作业名
        :type AppName: str
        """
        self._AppName = None

    @property
    def AppName(self):
        r"""spark作业名
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName


    def _deserialize(self, params):
        self._AppName = params.get("AppName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSparkAppResponse(AbstractModel):
    r"""DeleteSparkApp返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteStandardEngineResourceGroupRequest(AbstractModel):
    r"""DeleteStandardEngineResourceGroup请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EngineResourceGroupName: 标准引擎资源组名称
        :type EngineResourceGroupName: str
        """
        self._EngineResourceGroupName = None

    @property
    def EngineResourceGroupName(self):
        r"""标准引擎资源组名称
        :rtype: str
        """
        return self._EngineResourceGroupName

    @EngineResourceGroupName.setter
    def EngineResourceGroupName(self, EngineResourceGroupName):
        self._EngineResourceGroupName = EngineResourceGroupName


    def _deserialize(self, params):
        self._EngineResourceGroupName = params.get("EngineResourceGroupName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteStandardEngineResourceGroupResponse(AbstractModel):
    r"""DeleteStandardEngineResourceGroup返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteTableRequest(AbstractModel):
    r"""DeleteTable请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TableBaseInfo: 表基本信息
        :type TableBaseInfo: :class:`tencentcloud.dlc.v20210125.models.TableBaseInfo`
        """
        self._TableBaseInfo = None

    @property
    def TableBaseInfo(self):
        r"""表基本信息
        :rtype: :class:`tencentcloud.dlc.v20210125.models.TableBaseInfo`
        """
        return self._TableBaseInfo

    @TableBaseInfo.setter
    def TableBaseInfo(self, TableBaseInfo):
        self._TableBaseInfo = TableBaseInfo


    def _deserialize(self, params):
        if params.get("TableBaseInfo") is not None:
            self._TableBaseInfo = TableBaseInfo()
            self._TableBaseInfo._deserialize(params.get("TableBaseInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteTableResponse(AbstractModel):
    r"""DeleteTable返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteThirdPartyAccessUserRequest(AbstractModel):
    r"""DeleteThirdPartyAccessUser请求参数结构体

    """


class DeleteThirdPartyAccessUserResponse(AbstractModel):
    r"""DeleteThirdPartyAccessUser返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteUserRequest(AbstractModel):
    r"""DeleteUser请求参数结构体

    """

    def __init__(self):
        r"""
        :param _UserIds: 需要删除的用户的Id
        :type UserIds: list of str
        :param _AccountType: 用户来源类型TencentAccount（普通腾讯云用户） / EntraAccount（微软用户）
        :type AccountType: str
        """
        self._UserIds = None
        self._AccountType = None

    @property
    def UserIds(self):
        r"""需要删除的用户的Id
        :rtype: list of str
        """
        return self._UserIds

    @UserIds.setter
    def UserIds(self, UserIds):
        self._UserIds = UserIds

    @property
    def AccountType(self):
        r"""用户来源类型TencentAccount（普通腾讯云用户） / EntraAccount（微软用户）
        :rtype: str
        """
        return self._AccountType

    @AccountType.setter
    def AccountType(self, AccountType):
        self._AccountType = AccountType


    def _deserialize(self, params):
        self._UserIds = params.get("UserIds")
        self._AccountType = params.get("AccountType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteUserResponse(AbstractModel):
    r"""DeleteUser返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteUserVpcConnectionRequest(AbstractModel):
    r"""DeleteUserVpcConnection请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EngineNetworkId: 引擎网络ID
        :type EngineNetworkId: str
        :param _UserVpcEndpointId: 终端节点ID
        :type UserVpcEndpointId: str
        """
        self._EngineNetworkId = None
        self._UserVpcEndpointId = None

    @property
    def EngineNetworkId(self):
        r"""引擎网络ID
        :rtype: str
        """
        return self._EngineNetworkId

    @EngineNetworkId.setter
    def EngineNetworkId(self, EngineNetworkId):
        self._EngineNetworkId = EngineNetworkId

    @property
    def UserVpcEndpointId(self):
        r"""终端节点ID
        :rtype: str
        """
        return self._UserVpcEndpointId

    @UserVpcEndpointId.setter
    def UserVpcEndpointId(self, UserVpcEndpointId):
        self._UserVpcEndpointId = UserVpcEndpointId


    def _deserialize(self, params):
        self._EngineNetworkId = params.get("EngineNetworkId")
        self._UserVpcEndpointId = params.get("UserVpcEndpointId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteUserVpcConnectionResponse(AbstractModel):
    r"""DeleteUserVpcConnection返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteUsersFromWorkGroupRequest(AbstractModel):
    r"""DeleteUsersFromWorkGroup请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AddInfo: 要删除的用户信息
        :type AddInfo: :class:`tencentcloud.dlc.v20210125.models.UserIdSetOfWorkGroupId`
        """
        self._AddInfo = None

    @property
    def AddInfo(self):
        r"""要删除的用户信息
        :rtype: :class:`tencentcloud.dlc.v20210125.models.UserIdSetOfWorkGroupId`
        """
        return self._AddInfo

    @AddInfo.setter
    def AddInfo(self, AddInfo):
        self._AddInfo = AddInfo


    def _deserialize(self, params):
        if params.get("AddInfo") is not None:
            self._AddInfo = UserIdSetOfWorkGroupId()
            self._AddInfo._deserialize(params.get("AddInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteUsersFromWorkGroupResponse(AbstractModel):
    r"""DeleteUsersFromWorkGroup返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteWorkGroupRequest(AbstractModel):
    r"""DeleteWorkGroup请求参数结构体

    """

    def __init__(self):
        r"""
        :param _WorkGroupIds: 要删除的工作组Id集合
        :type WorkGroupIds: list of int
        """
        self._WorkGroupIds = None

    @property
    def WorkGroupIds(self):
        r"""要删除的工作组Id集合
        :rtype: list of int
        """
        return self._WorkGroupIds

    @WorkGroupIds.setter
    def WorkGroupIds(self, WorkGroupIds):
        self._WorkGroupIds = WorkGroupIds


    def _deserialize(self, params):
        self._WorkGroupIds = params.get("WorkGroupIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteWorkGroupResponse(AbstractModel):
    r"""DeleteWorkGroup返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DependencyPackage(AbstractModel):
    r"""任务依赖包信息

    """

    def __init__(self):
        r"""
        :param _PackageSource: 依赖包类型
注意：此字段可能返回 null，表示取不到有效值。
        :type PackageSource: str
        :param _MavenPackage: 依赖包信息
注意：此字段可能返回 null，表示取不到有效值。
        :type MavenPackage: str
        :param _MavenRepository: 依赖包仓库
注意：此字段可能返回 null，表示取不到有效值。
        :type MavenRepository: str
        :param _MavenExclusion: maven包exclusion信息
注意：此字段可能返回 null，表示取不到有效值。
        :type MavenExclusion: str
        :param _PypiPackage: pypi包信息
注意：此字段可能返回 null，表示取不到有效值。
        :type PypiPackage: str
        :param _PypiIndexUrl: pypi索引地址
注意：此字段可能返回 null，表示取不到有效值。
        :type PypiIndexUrl: str
        :param _PackageType: 文件包的类型
注意：此字段可能返回 null，表示取不到有效值。
        :type PackageType: str
        :param _PackagePath: 文件包的路径
注意：此字段可能返回 null，表示取不到有效值。
        :type PackagePath: str
        """
        self._PackageSource = None
        self._MavenPackage = None
        self._MavenRepository = None
        self._MavenExclusion = None
        self._PypiPackage = None
        self._PypiIndexUrl = None
        self._PackageType = None
        self._PackagePath = None

    @property
    def PackageSource(self):
        r"""依赖包类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PackageSource

    @PackageSource.setter
    def PackageSource(self, PackageSource):
        self._PackageSource = PackageSource

    @property
    def MavenPackage(self):
        r"""依赖包信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._MavenPackage

    @MavenPackage.setter
    def MavenPackage(self, MavenPackage):
        self._MavenPackage = MavenPackage

    @property
    def MavenRepository(self):
        r"""依赖包仓库
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._MavenRepository

    @MavenRepository.setter
    def MavenRepository(self, MavenRepository):
        self._MavenRepository = MavenRepository

    @property
    def MavenExclusion(self):
        r"""maven包exclusion信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._MavenExclusion

    @MavenExclusion.setter
    def MavenExclusion(self, MavenExclusion):
        self._MavenExclusion = MavenExclusion

    @property
    def PypiPackage(self):
        r"""pypi包信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PypiPackage

    @PypiPackage.setter
    def PypiPackage(self, PypiPackage):
        self._PypiPackage = PypiPackage

    @property
    def PypiIndexUrl(self):
        r"""pypi索引地址
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PypiIndexUrl

    @PypiIndexUrl.setter
    def PypiIndexUrl(self, PypiIndexUrl):
        self._PypiIndexUrl = PypiIndexUrl

    @property
    def PackageType(self):
        r"""文件包的类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PackageType

    @PackageType.setter
    def PackageType(self, PackageType):
        self._PackageType = PackageType

    @property
    def PackagePath(self):
        r"""文件包的路径
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PackagePath

    @PackagePath.setter
    def PackagePath(self, PackagePath):
        self._PackagePath = PackagePath


    def _deserialize(self, params):
        self._PackageSource = params.get("PackageSource")
        self._MavenPackage = params.get("MavenPackage")
        self._MavenRepository = params.get("MavenRepository")
        self._MavenExclusion = params.get("MavenExclusion")
        self._PypiPackage = params.get("PypiPackage")
        self._PypiIndexUrl = params.get("PypiIndexUrl")
        self._PackageType = params.get("PackageType")
        self._PackagePath = params.get("PackagePath")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAdvancedStoreLocationRequest(AbstractModel):
    r"""DescribeAdvancedStoreLocation请求参数结构体

    """


class DescribeAdvancedStoreLocationResponse(AbstractModel):
    r"""DescribeAdvancedStoreLocation返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Enable: 是否启用高级设置：0-否，1-是
        :type Enable: int
        :param _StoreLocation: 查询结果保存cos路径
        :type StoreLocation: str
        :param _HasLakeFs: 是否有托管存储权限
        :type HasLakeFs: bool
        :param _LakeFsStatus: 托管存储状态，HasLakeFs等于true时，该值才有意义
        :type LakeFsStatus: str
        :param _BucketType: 托管存储桶类型
        :type BucketType: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Enable = None
        self._StoreLocation = None
        self._HasLakeFs = None
        self._LakeFsStatus = None
        self._BucketType = None
        self._RequestId = None

    @property
    def Enable(self):
        r"""是否启用高级设置：0-否，1-是
        :rtype: int
        """
        return self._Enable

    @Enable.setter
    def Enable(self, Enable):
        self._Enable = Enable

    @property
    def StoreLocation(self):
        r"""查询结果保存cos路径
        :rtype: str
        """
        return self._StoreLocation

    @StoreLocation.setter
    def StoreLocation(self, StoreLocation):
        self._StoreLocation = StoreLocation

    @property
    def HasLakeFs(self):
        r"""是否有托管存储权限
        :rtype: bool
        """
        return self._HasLakeFs

    @HasLakeFs.setter
    def HasLakeFs(self, HasLakeFs):
        self._HasLakeFs = HasLakeFs

    @property
    def LakeFsStatus(self):
        r"""托管存储状态，HasLakeFs等于true时，该值才有意义
        :rtype: str
        """
        return self._LakeFsStatus

    @LakeFsStatus.setter
    def LakeFsStatus(self, LakeFsStatus):
        self._LakeFsStatus = LakeFsStatus

    @property
    def BucketType(self):
        r"""托管存储桶类型
        :rtype: str
        """
        return self._BucketType

    @BucketType.setter
    def BucketType(self, BucketType):
        self._BucketType = BucketType

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Enable = params.get("Enable")
        self._StoreLocation = params.get("StoreLocation")
        self._HasLakeFs = params.get("HasLakeFs")
        self._LakeFsStatus = params.get("LakeFsStatus")
        self._BucketType = params.get("BucketType")
        self._RequestId = params.get("RequestId")


class DescribeClusterMonitorInfosRequest(AbstractModel):
    r"""DescribeClusterMonitorInfos请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DataEngineId: 引擎Id
        :type DataEngineId: str
        :param _TimeStart: 任务创建时间的起始时间
        :type TimeStart: str
        :param _TimeEnd: 任务创建时间的结束时间
        :type TimeEnd: str
        :param _MetricName: 指标名称
        :type MetricName: str
        """
        self._DataEngineId = None
        self._TimeStart = None
        self._TimeEnd = None
        self._MetricName = None

    @property
    def DataEngineId(self):
        r"""引擎Id
        :rtype: str
        """
        return self._DataEngineId

    @DataEngineId.setter
    def DataEngineId(self, DataEngineId):
        self._DataEngineId = DataEngineId

    @property
    def TimeStart(self):
        r"""任务创建时间的起始时间
        :rtype: str
        """
        return self._TimeStart

    @TimeStart.setter
    def TimeStart(self, TimeStart):
        self._TimeStart = TimeStart

    @property
    def TimeEnd(self):
        r"""任务创建时间的结束时间
        :rtype: str
        """
        return self._TimeEnd

    @TimeEnd.setter
    def TimeEnd(self, TimeEnd):
        self._TimeEnd = TimeEnd

    @property
    def MetricName(self):
        r"""指标名称
        :rtype: str
        """
        return self._MetricName

    @MetricName.setter
    def MetricName(self, MetricName):
        self._MetricName = MetricName


    def _deserialize(self, params):
        self._DataEngineId = params.get("DataEngineId")
        self._TimeStart = params.get("TimeStart")
        self._TimeEnd = params.get("TimeEnd")
        self._MetricName = params.get("MetricName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClusterMonitorInfosResponse(AbstractModel):
    r"""DescribeClusterMonitorInfos返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Info: 集群监控信息列表
        :type Info: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Info = None
        self._RequestId = None

    @property
    def Info(self):
        r"""集群监控信息列表
        :rtype: str
        """
        return self._Info

    @Info.setter
    def Info(self, Info):
        self._Info = Info

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Info = params.get("Info")
        self._RequestId = params.get("RequestId")


class DescribeDLCCatalogAccessRequest(AbstractModel):
    r"""DescribeDLCCatalogAccess请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 显示条数
        :type Limit: int
        :param _Offset: 记录数量
        :type Offset: int
        :param _Filter: 过滤条件
        :type Filter: :class:`tencentcloud.dlc.v20210125.models.Filter`
        """
        self._Limit = None
        self._Offset = None
        self._Filter = None

    @property
    def Limit(self):
        r"""显示条数
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""记录数量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filter(self):
        r"""过滤条件
        :rtype: :class:`tencentcloud.dlc.v20210125.models.Filter`
        """
        return self._Filter

    @Filter.setter
    def Filter(self, Filter):
        self._Filter = Filter


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filter") is not None:
            self._Filter = Filter()
            self._Filter._deserialize(params.get("Filter"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDLCCatalogAccessResponse(AbstractModel):
    r"""DescribeDLCCatalogAccess返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总数
        :type TotalCount: int
        :param _Rows: DLCCatalog授权列表
        :type Rows: list of DLCCatalogAccess
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._Rows = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""总数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Rows(self):
        r"""DLCCatalog授权列表
        :rtype: list of DLCCatalogAccess
        """
        return self._Rows

    @Rows.setter
    def Rows(self, Rows):
        self._Rows = Rows

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Rows") is not None:
            self._Rows = []
            for item in params.get("Rows"):
                obj = DLCCatalogAccess()
                obj._deserialize(item)
                self._Rows.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDMSDatabaseRequest(AbstractModel):
    r"""DescribeDMSDatabase请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 数据库名称
        :type Name: str
        :param _SchemaName: schema名称
        :type SchemaName: str
        :param _Pattern: 匹配规则，只支持填*
        :type Pattern: str
        :param _DatasourceConnectionName: 数据源连接名
        :type DatasourceConnectionName: str
        """
        self._Name = None
        self._SchemaName = None
        self._Pattern = None
        self._DatasourceConnectionName = None

    @property
    def Name(self):
        r"""数据库名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SchemaName(self):
        r"""schema名称
        :rtype: str
        """
        return self._SchemaName

    @SchemaName.setter
    def SchemaName(self, SchemaName):
        self._SchemaName = SchemaName

    @property
    def Pattern(self):
        r"""匹配规则，只支持填*
        :rtype: str
        """
        return self._Pattern

    @Pattern.setter
    def Pattern(self, Pattern):
        self._Pattern = Pattern

    @property
    def DatasourceConnectionName(self):
        r"""数据源连接名
        :rtype: str
        """
        return self._DatasourceConnectionName

    @DatasourceConnectionName.setter
    def DatasourceConnectionName(self, DatasourceConnectionName):
        self._DatasourceConnectionName = DatasourceConnectionName


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._SchemaName = params.get("SchemaName")
        self._Pattern = params.get("Pattern")
        self._DatasourceConnectionName = params.get("DatasourceConnectionName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDMSDatabaseResponse(AbstractModel):
    r"""DescribeDMSDatabase返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 数据库名称
        :type Name: str
        :param _SchemaName: schema名称
        :type SchemaName: str
        :param _Location: 存储地址
        :type Location: str
        :param _Asset: 数据对象
        :type Asset: :class:`tencentcloud.dlc.v20210125.models.Asset`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Name = None
        self._SchemaName = None
        self._Location = None
        self._Asset = None
        self._RequestId = None

    @property
    def Name(self):
        r"""数据库名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SchemaName(self):
        r"""schema名称
        :rtype: str
        """
        return self._SchemaName

    @SchemaName.setter
    def SchemaName(self, SchemaName):
        self._SchemaName = SchemaName

    @property
    def Location(self):
        r"""存储地址
        :rtype: str
        """
        return self._Location

    @Location.setter
    def Location(self, Location):
        self._Location = Location

    @property
    def Asset(self):
        r"""数据对象
        :rtype: :class:`tencentcloud.dlc.v20210125.models.Asset`
        """
        return self._Asset

    @Asset.setter
    def Asset(self, Asset):
        self._Asset = Asset

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._SchemaName = params.get("SchemaName")
        self._Location = params.get("Location")
        if params.get("Asset") is not None:
            self._Asset = Asset()
            self._Asset._deserialize(params.get("Asset"))
        self._RequestId = params.get("RequestId")


class DescribeDMSPartitionsRequest(AbstractModel):
    r"""DescribeDMSPartitions请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DatabaseName: 数据库名
        :type DatabaseName: str
        :param _TableName: 表名称
        :type TableName: str
        :param _SchemaName: schema名称
        :type SchemaName: str
        :param _Name: 名称
        :type Name: str
        :param _Values: 单个分区名称，精准匹配
        :type Values: list of str
        :param _PartitionNames: 多个分区名称，精准匹配
        :type PartitionNames: list of str
        :param _PartValues: 多个分区字段的匹配，模糊匹配
        :type PartValues: list of str
        :param _Filter: 过滤SQL
        :type Filter: str
        :param _MaxParts: 最大分区数量
        :type MaxParts: int
        :param _Offset: 翻页跳过数量
        :type Offset: int
        :param _Limit: 页面数量
        :type Limit: int
        :param _Expression: 表达式
        :type Expression: str
        :param _DatasourceConnectionName: 数据源连接名
        :type DatasourceConnectionName: str
        """
        self._DatabaseName = None
        self._TableName = None
        self._SchemaName = None
        self._Name = None
        self._Values = None
        self._PartitionNames = None
        self._PartValues = None
        self._Filter = None
        self._MaxParts = None
        self._Offset = None
        self._Limit = None
        self._Expression = None
        self._DatasourceConnectionName = None

    @property
    def DatabaseName(self):
        r"""数据库名
        :rtype: str
        """
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def TableName(self):
        r"""表名称
        :rtype: str
        """
        return self._TableName

    @TableName.setter
    def TableName(self, TableName):
        self._TableName = TableName

    @property
    def SchemaName(self):
        r"""schema名称
        :rtype: str
        """
        return self._SchemaName

    @SchemaName.setter
    def SchemaName(self, SchemaName):
        self._SchemaName = SchemaName

    @property
    def Name(self):
        r"""名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Values(self):
        r"""单个分区名称，精准匹配
        :rtype: list of str
        """
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values

    @property
    def PartitionNames(self):
        r"""多个分区名称，精准匹配
        :rtype: list of str
        """
        return self._PartitionNames

    @PartitionNames.setter
    def PartitionNames(self, PartitionNames):
        self._PartitionNames = PartitionNames

    @property
    def PartValues(self):
        r"""多个分区字段的匹配，模糊匹配
        :rtype: list of str
        """
        return self._PartValues

    @PartValues.setter
    def PartValues(self, PartValues):
        self._PartValues = PartValues

    @property
    def Filter(self):
        r"""过滤SQL
        :rtype: str
        """
        return self._Filter

    @Filter.setter
    def Filter(self, Filter):
        self._Filter = Filter

    @property
    def MaxParts(self):
        r"""最大分区数量
        :rtype: int
        """
        return self._MaxParts

    @MaxParts.setter
    def MaxParts(self, MaxParts):
        self._MaxParts = MaxParts

    @property
    def Offset(self):
        r"""翻页跳过数量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""页面数量
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Expression(self):
        r"""表达式
        :rtype: str
        """
        return self._Expression

    @Expression.setter
    def Expression(self, Expression):
        self._Expression = Expression

    @property
    def DatasourceConnectionName(self):
        r"""数据源连接名
        :rtype: str
        """
        return self._DatasourceConnectionName

    @DatasourceConnectionName.setter
    def DatasourceConnectionName(self, DatasourceConnectionName):
        self._DatasourceConnectionName = DatasourceConnectionName


    def _deserialize(self, params):
        self._DatabaseName = params.get("DatabaseName")
        self._TableName = params.get("TableName")
        self._SchemaName = params.get("SchemaName")
        self._Name = params.get("Name")
        self._Values = params.get("Values")
        self._PartitionNames = params.get("PartitionNames")
        self._PartValues = params.get("PartValues")
        self._Filter = params.get("Filter")
        self._MaxParts = params.get("MaxParts")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Expression = params.get("Expression")
        self._DatasourceConnectionName = params.get("DatasourceConnectionName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDMSPartitionsResponse(AbstractModel):
    r"""DescribeDMSPartitions返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Partitions: 分区信息
        :type Partitions: list of DMSPartition
        :param _Total: 总数
        :type Total: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Partitions = None
        self._Total = None
        self._RequestId = None

    @property
    def Partitions(self):
        r"""分区信息
        :rtype: list of DMSPartition
        """
        return self._Partitions

    @Partitions.setter
    def Partitions(self, Partitions):
        self._Partitions = Partitions

    @property
    def Total(self):
        r"""总数
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Partitions") is not None:
            self._Partitions = []
            for item in params.get("Partitions"):
                obj = DMSPartition()
                obj._deserialize(item)
                self._Partitions.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeDMSTableRequest(AbstractModel):
    r"""DescribeDMSTable请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DbName: 数据库名称
        :type DbName: str
        :param _SchemaName: 数据库schema名称
        :type SchemaName: str
        :param _Name: 表名称
        :type Name: str
        :param _Catalog: catalog类型
        :type Catalog: str
        :param _Keyword: 查询关键词
        :type Keyword: str
        :param _Pattern: 查询模式，只支持填*
        :type Pattern: str
        :param _Type: 表类型
        :type Type: str
        :param _DatasourceConnectionName: 数据源连接名
        :type DatasourceConnectionName: str
        """
        self._DbName = None
        self._SchemaName = None
        self._Name = None
        self._Catalog = None
        self._Keyword = None
        self._Pattern = None
        self._Type = None
        self._DatasourceConnectionName = None

    @property
    def DbName(self):
        r"""数据库名称
        :rtype: str
        """
        return self._DbName

    @DbName.setter
    def DbName(self, DbName):
        self._DbName = DbName

    @property
    def SchemaName(self):
        r"""数据库schema名称
        :rtype: str
        """
        return self._SchemaName

    @SchemaName.setter
    def SchemaName(self, SchemaName):
        self._SchemaName = SchemaName

    @property
    def Name(self):
        r"""表名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Catalog(self):
        r"""catalog类型
        :rtype: str
        """
        return self._Catalog

    @Catalog.setter
    def Catalog(self, Catalog):
        self._Catalog = Catalog

    @property
    def Keyword(self):
        r"""查询关键词
        :rtype: str
        """
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword

    @property
    def Pattern(self):
        r"""查询模式，只支持填*
        :rtype: str
        """
        return self._Pattern

    @Pattern.setter
    def Pattern(self, Pattern):
        self._Pattern = Pattern

    @property
    def Type(self):
        r"""表类型
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def DatasourceConnectionName(self):
        r"""数据源连接名
        :rtype: str
        """
        return self._DatasourceConnectionName

    @DatasourceConnectionName.setter
    def DatasourceConnectionName(self, DatasourceConnectionName):
        self._DatasourceConnectionName = DatasourceConnectionName


    def _deserialize(self, params):
        self._DbName = params.get("DbName")
        self._SchemaName = params.get("SchemaName")
        self._Name = params.get("Name")
        self._Catalog = params.get("Catalog")
        self._Keyword = params.get("Keyword")
        self._Pattern = params.get("Pattern")
        self._Type = params.get("Type")
        self._DatasourceConnectionName = params.get("DatasourceConnectionName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDMSTableResponse(AbstractModel):
    r"""DescribeDMSTable返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Asset: 基础对象
        :type Asset: :class:`tencentcloud.dlc.v20210125.models.Asset`
        :param _ViewOriginalText: 视图文本
        :type ViewOriginalText: str
        :param _ViewExpandedText: 视图文本
        :type ViewExpandedText: str
        :param _Retention: hive维护版本
        :type Retention: int
        :param _Sds: 存储对象
        :type Sds: :class:`tencentcloud.dlc.v20210125.models.DMSSds`
        :param _PartitionKeys: 分区列
注意：此字段可能返回 null，表示取不到有效值。
        :type PartitionKeys: list of DMSColumn
        :param _Partitions: 分区
注意：此字段可能返回 null，表示取不到有效值。
        :type Partitions: list of DMSPartition
        :param _Type: 表类型
        :type Type: str
        :param _DbName: 数据库名称
        :type DbName: str
        :param _SchemaName: Schame名称
        :type SchemaName: str
        :param _StorageSize: 存储大小
        :type StorageSize: int
        :param _RecordCount: 记录数量
        :type RecordCount: int
        :param _LifeTime: 生命周期
        :type LifeTime: int
        :param _LastAccessTime: 最后访问时间
        :type LastAccessTime: str
        :param _DataUpdateTime: 数据更新时间
        :type DataUpdateTime: str
        :param _StructUpdateTime: 结构更新时间
        :type StructUpdateTime: str
        :param _Columns: 列
注意：此字段可能返回 null，表示取不到有效值。
        :type Columns: list of DMSColumn
        :param _Name: 表名称
        :type Name: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Asset = None
        self._ViewOriginalText = None
        self._ViewExpandedText = None
        self._Retention = None
        self._Sds = None
        self._PartitionKeys = None
        self._Partitions = None
        self._Type = None
        self._DbName = None
        self._SchemaName = None
        self._StorageSize = None
        self._RecordCount = None
        self._LifeTime = None
        self._LastAccessTime = None
        self._DataUpdateTime = None
        self._StructUpdateTime = None
        self._Columns = None
        self._Name = None
        self._RequestId = None

    @property
    def Asset(self):
        r"""基础对象
        :rtype: :class:`tencentcloud.dlc.v20210125.models.Asset`
        """
        return self._Asset

    @Asset.setter
    def Asset(self, Asset):
        self._Asset = Asset

    @property
    def ViewOriginalText(self):
        r"""视图文本
        :rtype: str
        """
        return self._ViewOriginalText

    @ViewOriginalText.setter
    def ViewOriginalText(self, ViewOriginalText):
        self._ViewOriginalText = ViewOriginalText

    @property
    def ViewExpandedText(self):
        r"""视图文本
        :rtype: str
        """
        return self._ViewExpandedText

    @ViewExpandedText.setter
    def ViewExpandedText(self, ViewExpandedText):
        self._ViewExpandedText = ViewExpandedText

    @property
    def Retention(self):
        r"""hive维护版本
        :rtype: int
        """
        return self._Retention

    @Retention.setter
    def Retention(self, Retention):
        self._Retention = Retention

    @property
    def Sds(self):
        r"""存储对象
        :rtype: :class:`tencentcloud.dlc.v20210125.models.DMSSds`
        """
        return self._Sds

    @Sds.setter
    def Sds(self, Sds):
        self._Sds = Sds

    @property
    def PartitionKeys(self):
        r"""分区列
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of DMSColumn
        """
        return self._PartitionKeys

    @PartitionKeys.setter
    def PartitionKeys(self, PartitionKeys):
        self._PartitionKeys = PartitionKeys

    @property
    def Partitions(self):
        r"""分区
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of DMSPartition
        """
        return self._Partitions

    @Partitions.setter
    def Partitions(self, Partitions):
        self._Partitions = Partitions

    @property
    def Type(self):
        r"""表类型
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def DbName(self):
        r"""数据库名称
        :rtype: str
        """
        return self._DbName

    @DbName.setter
    def DbName(self, DbName):
        self._DbName = DbName

    @property
    def SchemaName(self):
        r"""Schame名称
        :rtype: str
        """
        return self._SchemaName

    @SchemaName.setter
    def SchemaName(self, SchemaName):
        self._SchemaName = SchemaName

    @property
    def StorageSize(self):
        r"""存储大小
        :rtype: int
        """
        return self._StorageSize

    @StorageSize.setter
    def StorageSize(self, StorageSize):
        self._StorageSize = StorageSize

    @property
    def RecordCount(self):
        r"""记录数量
        :rtype: int
        """
        return self._RecordCount

    @RecordCount.setter
    def RecordCount(self, RecordCount):
        self._RecordCount = RecordCount

    @property
    def LifeTime(self):
        r"""生命周期
        :rtype: int
        """
        return self._LifeTime

    @LifeTime.setter
    def LifeTime(self, LifeTime):
        self._LifeTime = LifeTime

    @property
    def LastAccessTime(self):
        r"""最后访问时间
        :rtype: str
        """
        return self._LastAccessTime

    @LastAccessTime.setter
    def LastAccessTime(self, LastAccessTime):
        self._LastAccessTime = LastAccessTime

    @property
    def DataUpdateTime(self):
        r"""数据更新时间
        :rtype: str
        """
        return self._DataUpdateTime

    @DataUpdateTime.setter
    def DataUpdateTime(self, DataUpdateTime):
        self._DataUpdateTime = DataUpdateTime

    @property
    def StructUpdateTime(self):
        r"""结构更新时间
        :rtype: str
        """
        return self._StructUpdateTime

    @StructUpdateTime.setter
    def StructUpdateTime(self, StructUpdateTime):
        self._StructUpdateTime = StructUpdateTime

    @property
    def Columns(self):
        r"""列
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of DMSColumn
        """
        return self._Columns

    @Columns.setter
    def Columns(self, Columns):
        self._Columns = Columns

    @property
    def Name(self):
        r"""表名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Asset") is not None:
            self._Asset = Asset()
            self._Asset._deserialize(params.get("Asset"))
        self._ViewOriginalText = params.get("ViewOriginalText")
        self._ViewExpandedText = params.get("ViewExpandedText")
        self._Retention = params.get("Retention")
        if params.get("Sds") is not None:
            self._Sds = DMSSds()
            self._Sds._deserialize(params.get("Sds"))
        if params.get("PartitionKeys") is not None:
            self._PartitionKeys = []
            for item in params.get("PartitionKeys"):
                obj = DMSColumn()
                obj._deserialize(item)
                self._PartitionKeys.append(obj)
        if params.get("Partitions") is not None:
            self._Partitions = []
            for item in params.get("Partitions"):
                obj = DMSPartition()
                obj._deserialize(item)
                self._Partitions.append(obj)
        self._Type = params.get("Type")
        self._DbName = params.get("DbName")
        self._SchemaName = params.get("SchemaName")
        self._StorageSize = params.get("StorageSize")
        self._RecordCount = params.get("RecordCount")
        self._LifeTime = params.get("LifeTime")
        self._LastAccessTime = params.get("LastAccessTime")
        self._DataUpdateTime = params.get("DataUpdateTime")
        self._StructUpdateTime = params.get("StructUpdateTime")
        if params.get("Columns") is not None:
            self._Columns = []
            for item in params.get("Columns"):
                obj = DMSColumn()
                obj._deserialize(item)
                self._Columns.append(obj)
        self._Name = params.get("Name")
        self._RequestId = params.get("RequestId")


class DescribeDMSTablesRequest(AbstractModel):
    r"""DescribeDMSTables请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DbName: 数据库名称
        :type DbName: str
        :param _SchemaName: 数据库schema名称
        :type SchemaName: str
        :param _Name: 表名称
        :type Name: str
        :param _Catalog: catalog类型
        :type Catalog: str
        :param _Keyword: 查询关键词
        :type Keyword: str
        :param _Pattern: 查询模式，只支持填*
        :type Pattern: str
        :param _Type: 表类型
        :type Type: str
        :param _StartTime: 筛选参数：更新开始时间
        :type StartTime: str
        :param _EndTime: 筛选参数：更新结束时间
        :type EndTime: str
        :param _Limit: 分页参数
        :type Limit: int
        :param _Offset: 分页参数
        :type Offset: int
        :param _Sort: 排序字段：create_time：创建时间
        :type Sort: str
        :param _Asc: 排序字段：true：升序（默认），false：降序
        :type Asc: bool
        :param _DatasourceConnectionName: 数据源连接名
        :type DatasourceConnectionName: str
        """
        self._DbName = None
        self._SchemaName = None
        self._Name = None
        self._Catalog = None
        self._Keyword = None
        self._Pattern = None
        self._Type = None
        self._StartTime = None
        self._EndTime = None
        self._Limit = None
        self._Offset = None
        self._Sort = None
        self._Asc = None
        self._DatasourceConnectionName = None

    @property
    def DbName(self):
        r"""数据库名称
        :rtype: str
        """
        return self._DbName

    @DbName.setter
    def DbName(self, DbName):
        self._DbName = DbName

    @property
    def SchemaName(self):
        r"""数据库schema名称
        :rtype: str
        """
        return self._SchemaName

    @SchemaName.setter
    def SchemaName(self, SchemaName):
        self._SchemaName = SchemaName

    @property
    def Name(self):
        r"""表名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Catalog(self):
        r"""catalog类型
        :rtype: str
        """
        return self._Catalog

    @Catalog.setter
    def Catalog(self, Catalog):
        self._Catalog = Catalog

    @property
    def Keyword(self):
        r"""查询关键词
        :rtype: str
        """
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword

    @property
    def Pattern(self):
        r"""查询模式，只支持填*
        :rtype: str
        """
        return self._Pattern

    @Pattern.setter
    def Pattern(self, Pattern):
        self._Pattern = Pattern

    @property
    def Type(self):
        r"""表类型
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def StartTime(self):
        r"""筛选参数：更新开始时间
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""筛选参数：更新结束时间
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Limit(self):
        r"""分页参数
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""分页参数
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Sort(self):
        r"""排序字段：create_time：创建时间
        :rtype: str
        """
        return self._Sort

    @Sort.setter
    def Sort(self, Sort):
        self._Sort = Sort

    @property
    def Asc(self):
        r"""排序字段：true：升序（默认），false：降序
        :rtype: bool
        """
        return self._Asc

    @Asc.setter
    def Asc(self, Asc):
        self._Asc = Asc

    @property
    def DatasourceConnectionName(self):
        r"""数据源连接名
        :rtype: str
        """
        return self._DatasourceConnectionName

    @DatasourceConnectionName.setter
    def DatasourceConnectionName(self, DatasourceConnectionName):
        self._DatasourceConnectionName = DatasourceConnectionName


    def _deserialize(self, params):
        self._DbName = params.get("DbName")
        self._SchemaName = params.get("SchemaName")
        self._Name = params.get("Name")
        self._Catalog = params.get("Catalog")
        self._Keyword = params.get("Keyword")
        self._Pattern = params.get("Pattern")
        self._Type = params.get("Type")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Sort = params.get("Sort")
        self._Asc = params.get("Asc")
        self._DatasourceConnectionName = params.get("DatasourceConnectionName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDMSTablesResponse(AbstractModel):
    r"""DescribeDMSTables返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TableList: DMS元数据列表信息
注意：此字段可能返回 null，表示取不到有效值。
        :type TableList: list of DMSTableInfo
        :param _TotalCount: 统计值
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TableList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def TableList(self):
        r"""DMS元数据列表信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of DMSTableInfo
        """
        return self._TableList

    @TableList.setter
    def TableList(self, TableList):
        self._TableList = TableList

    @property
    def TotalCount(self):
        r"""统计值
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TableList") is not None:
            self._TableList = []
            for item in params.get("TableList"):
                obj = DMSTableInfo()
                obj._deserialize(item)
                self._TableList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeDataEngineEventsRequest(AbstractModel):
    r"""DescribeDataEngineEvents请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DataEngineName: 虚拟集群名称
        :type DataEngineName: str
        :param _Limit: 返回数量，默认为10，最大为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0
        :type Offset: int
        :param _SessionId: 资源组id
        :type SessionId: str
        """
        self._DataEngineName = None
        self._Limit = None
        self._Offset = None
        self._SessionId = None

    @property
    def DataEngineName(self):
        r"""虚拟集群名称
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName

    @property
    def Limit(self):
        r"""返回数量，默认为10，最大为100
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""偏移量，默认为0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def SessionId(self):
        r"""资源组id
        :rtype: str
        """
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId


    def _deserialize(self, params):
        self._DataEngineName = params.get("DataEngineName")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._SessionId = params.get("SessionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDataEngineEventsResponse(AbstractModel):
    r"""DescribeDataEngineEvents返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Events: 事件详细信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Events: list of HouseEventsInfo
        :param _Page: 分页号
        :type Page: int
        :param _Size: 分页大小
        :type Size: int
        :param _TotalPages: 总页数
        :type TotalPages: int
        :param _TotalCount: 总条数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Events = None
        self._Page = None
        self._Size = None
        self._TotalPages = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def Events(self):
        r"""事件详细信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of HouseEventsInfo
        """
        return self._Events

    @Events.setter
    def Events(self, Events):
        self._Events = Events

    @property
    def Page(self):
        r"""分页号
        :rtype: int
        """
        return self._Page

    @Page.setter
    def Page(self, Page):
        self._Page = Page

    @property
    def Size(self):
        r"""分页大小
        :rtype: int
        """
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size

    @property
    def TotalPages(self):
        r"""总页数
        :rtype: int
        """
        return self._TotalPages

    @TotalPages.setter
    def TotalPages(self, TotalPages):
        self._TotalPages = TotalPages

    @property
    def TotalCount(self):
        r"""总条数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Events") is not None:
            self._Events = []
            for item in params.get("Events"):
                obj = HouseEventsInfo()
                obj._deserialize(item)
                self._Events.append(obj)
        self._Page = params.get("Page")
        self._Size = params.get("Size")
        self._TotalPages = params.get("TotalPages")
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeDataEngineImageVersionsRequest(AbstractModel):
    r"""DescribeDataEngineImageVersions请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EngineType: 引擎类型：SparkSQL、PrestoSQL、SparkBatch、StandardSpark、StandardPresto
        :type EngineType: str
        :param _Sort: 排序字段: InsertTime（插入时间，默认），UpdateTime（更新时间）
        :type Sort: str
        :param _Asc: 排序方式：false（降序，默认），true（升序）
        :type Asc: bool
        """
        self._EngineType = None
        self._Sort = None
        self._Asc = None

    @property
    def EngineType(self):
        r"""引擎类型：SparkSQL、PrestoSQL、SparkBatch、StandardSpark、StandardPresto
        :rtype: str
        """
        return self._EngineType

    @EngineType.setter
    def EngineType(self, EngineType):
        self._EngineType = EngineType

    @property
    def Sort(self):
        r"""排序字段: InsertTime（插入时间，默认），UpdateTime（更新时间）
        :rtype: str
        """
        return self._Sort

    @Sort.setter
    def Sort(self, Sort):
        self._Sort = Sort

    @property
    def Asc(self):
        r"""排序方式：false（降序，默认），true（升序）
        :rtype: bool
        """
        return self._Asc

    @Asc.setter
    def Asc(self, Asc):
        self._Asc = Asc


    def _deserialize(self, params):
        self._EngineType = params.get("EngineType")
        self._Sort = params.get("Sort")
        self._Asc = params.get("Asc")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDataEngineImageVersionsResponse(AbstractModel):
    r"""DescribeDataEngineImageVersions返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ImageParentVersions: 集群大版本镜像信息列表
        :type ImageParentVersions: list of DataEngineImageVersion
        :param _Total: 总数
        :type Total: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ImageParentVersions = None
        self._Total = None
        self._RequestId = None

    @property
    def ImageParentVersions(self):
        r"""集群大版本镜像信息列表
        :rtype: list of DataEngineImageVersion
        """
        return self._ImageParentVersions

    @ImageParentVersions.setter
    def ImageParentVersions(self, ImageParentVersions):
        self._ImageParentVersions = ImageParentVersions

    @property
    def Total(self):
        r"""总数
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ImageParentVersions") is not None:
            self._ImageParentVersions = []
            for item in params.get("ImageParentVersions"):
                obj = DataEngineImageVersion()
                obj._deserialize(item)
                self._ImageParentVersions.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeDataEnginePythonSparkImagesRequest(AbstractModel):
    r"""DescribeDataEnginePythonSparkImages请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ChildImageVersionId: 集群镜像小版本ID
        :type ChildImageVersionId: str
        """
        self._ChildImageVersionId = None

    @property
    def ChildImageVersionId(self):
        r"""集群镜像小版本ID
        :rtype: str
        """
        return self._ChildImageVersionId

    @ChildImageVersionId.setter
    def ChildImageVersionId(self, ChildImageVersionId):
        self._ChildImageVersionId = ChildImageVersionId


    def _deserialize(self, params):
        self._ChildImageVersionId = params.get("ChildImageVersionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDataEnginePythonSparkImagesResponse(AbstractModel):
    r"""DescribeDataEnginePythonSparkImages返回参数结构体

    """

    def __init__(self):
        r"""
        :param _PythonSparkImages: PYSPARK镜像信息列表
        :type PythonSparkImages: list of PythonSparkImage
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._PythonSparkImages = None
        self._RequestId = None

    @property
    def PythonSparkImages(self):
        r"""PYSPARK镜像信息列表
        :rtype: list of PythonSparkImage
        """
        return self._PythonSparkImages

    @PythonSparkImages.setter
    def PythonSparkImages(self, PythonSparkImages):
        self._PythonSparkImages = PythonSparkImages

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("PythonSparkImages") is not None:
            self._PythonSparkImages = []
            for item in params.get("PythonSparkImages"):
                obj = PythonSparkImage()
                obj._deserialize(item)
                self._PythonSparkImages.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDataEngineRequest(AbstractModel):
    r"""DescribeDataEngine请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DataEngineName: House名称
        :type DataEngineName: str
        """
        self._DataEngineName = None

    @property
    def DataEngineName(self):
        r"""House名称
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName


    def _deserialize(self, params):
        self._DataEngineName = params.get("DataEngineName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDataEngineResponse(AbstractModel):
    r"""DescribeDataEngine返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DataEngine: 数据引擎详细信息
        :type DataEngine: :class:`tencentcloud.dlc.v20210125.models.DataEngineInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DataEngine = None
        self._RequestId = None

    @property
    def DataEngine(self):
        r"""数据引擎详细信息
        :rtype: :class:`tencentcloud.dlc.v20210125.models.DataEngineInfo`
        """
        return self._DataEngine

    @DataEngine.setter
    def DataEngine(self, DataEngine):
        self._DataEngine = DataEngine

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DataEngine") is not None:
            self._DataEngine = DataEngineInfo()
            self._DataEngine._deserialize(params.get("DataEngine"))
        self._RequestId = params.get("RequestId")


class DescribeDataEngineSessionParametersRequest(AbstractModel):
    r"""DescribeDataEngineSessionParameters请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DataEngineId: 引擎id
        :type DataEngineId: str
        :param _DataEngineName: 引擎名称，当指定引擎名称后优先使用名称获取配置
        :type DataEngineName: str
        """
        self._DataEngineId = None
        self._DataEngineName = None

    @property
    def DataEngineId(self):
        r"""引擎id
        :rtype: str
        """
        return self._DataEngineId

    @DataEngineId.setter
    def DataEngineId(self, DataEngineId):
        self._DataEngineId = DataEngineId

    @property
    def DataEngineName(self):
        r"""引擎名称，当指定引擎名称后优先使用名称获取配置
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName


    def _deserialize(self, params):
        self._DataEngineId = params.get("DataEngineId")
        self._DataEngineName = params.get("DataEngineName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDataEngineSessionParametersResponse(AbstractModel):
    r"""DescribeDataEngineSessionParameters返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DataEngineParameters: 集群Session配置列表
        :type DataEngineParameters: list of DataEngineImageSessionParameter
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DataEngineParameters = None
        self._RequestId = None

    @property
    def DataEngineParameters(self):
        r"""集群Session配置列表
        :rtype: list of DataEngineImageSessionParameter
        """
        return self._DataEngineParameters

    @DataEngineParameters.setter
    def DataEngineParameters(self, DataEngineParameters):
        self._DataEngineParameters = DataEngineParameters

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DataEngineParameters") is not None:
            self._DataEngineParameters = []
            for item in params.get("DataEngineParameters"):
                obj = DataEngineImageSessionParameter()
                obj._deserialize(item)
                self._DataEngineParameters.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDataEnginesRequest(AbstractModel):
    r"""DescribeDataEngines请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤类型，支持如下的过滤类型，传参Name应为以下其中一个, data-engine-name - String（数据引擎名称）：engine-type - String（引擎类型：spark：spark 引擎，presto：presto引擎），state - String (数据引擎状态 -2已删除 -1失败 0初始化中 1挂起 2运行中 3准备删除 4删除中) ， mode - String（计费模式 0共享模式 1按量计费 2包年包月） ， create-time - String（创建时间，10位时间戳） message - String （描述信息），cluster-type - String (集群资源类型 spark_private/presto_private/presto_cu/spark_cu/kyuubi_cu)，engine-id - String（数据引擎ID），key-word - String（数据引擎名称或集群资源类型或描述信息模糊搜索），engine-exec-type - String（引擎执行任务类型，SQL/BATCH），engine-network-id - String（引擎网络Id）
        :type Filters: list of Filter
        :param _SortBy: 排序字段，支持如下字段类型，create-time
        :type SortBy: str
        :param _Sorting: 排序方式，desc表示正序，asc表示反序， 默认为asc。
        :type Sorting: str
        :param _Limit: 返回数量，默认为10，最大值为100。
        :type Limit: int
        :param _DatasourceConnectionName: 已废弃，请使用DatasourceConnectionNameSet
        :type DatasourceConnectionName: str
        :param _ExcludePublicEngine: 是否不返回共享引擎，true不返回共享引擎，false可以返回共享引擎
        :type ExcludePublicEngine: bool
        :param _AccessTypes: 参数应该为引擎权限类型，有效类型："USE", "MODIFY", "OPERATE", "MONITOR", "DELETE"
        :type AccessTypes: list of str
        :param _EngineExecType: 引擎执行任务类型，有效值：SQL/BATCH，默认为SQL
        :type EngineExecType: str
        :param _EngineType: 引擎类型，有效值：spark/presto/kyuubi，为空时默认获取非kyuubi引擎（网关引擎）
        :type EngineType: str
        :param _DatasourceConnectionNameSet: 网络配置列表，若传入该参数，则返回网络配置关联的计算引擎
        :type DatasourceConnectionNameSet: list of str
        :param _EngineGeneration: 引擎版本，有效值：Native/SuperSQL，为空时默认获取SuperSQL引擎
        :type EngineGeneration: str
        :param _EngineTypeDetail: 引擎类型，支持：SparkSQL、SparkBatch、PrestoSQL、Kyuubi
        :type EngineTypeDetail: str
        :param _ListHasListener: 默认 false, 为 true 时仅列出具有洞察 listener 的引擎
        :type ListHasListener: bool
        """
        self._Offset = None
        self._Filters = None
        self._SortBy = None
        self._Sorting = None
        self._Limit = None
        self._DatasourceConnectionName = None
        self._ExcludePublicEngine = None
        self._AccessTypes = None
        self._EngineExecType = None
        self._EngineType = None
        self._DatasourceConnectionNameSet = None
        self._EngineGeneration = None
        self._EngineTypeDetail = None
        self._ListHasListener = None

    @property
    def Offset(self):
        r"""偏移量，默认为0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        r"""过滤类型，支持如下的过滤类型，传参Name应为以下其中一个, data-engine-name - String（数据引擎名称）：engine-type - String（引擎类型：spark：spark 引擎，presto：presto引擎），state - String (数据引擎状态 -2已删除 -1失败 0初始化中 1挂起 2运行中 3准备删除 4删除中) ， mode - String（计费模式 0共享模式 1按量计费 2包年包月） ， create-time - String（创建时间，10位时间戳） message - String （描述信息），cluster-type - String (集群资源类型 spark_private/presto_private/presto_cu/spark_cu/kyuubi_cu)，engine-id - String（数据引擎ID），key-word - String（数据引擎名称或集群资源类型或描述信息模糊搜索），engine-exec-type - String（引擎执行任务类型，SQL/BATCH），engine-network-id - String（引擎网络Id）
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def SortBy(self):
        r"""排序字段，支持如下字段类型，create-time
        :rtype: str
        """
        return self._SortBy

    @SortBy.setter
    def SortBy(self, SortBy):
        self._SortBy = SortBy

    @property
    def Sorting(self):
        r"""排序方式，desc表示正序，asc表示反序， 默认为asc。
        :rtype: str
        """
        return self._Sorting

    @Sorting.setter
    def Sorting(self, Sorting):
        self._Sorting = Sorting

    @property
    def Limit(self):
        r"""返回数量，默认为10，最大值为100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def DatasourceConnectionName(self):
        r"""已废弃，请使用DatasourceConnectionNameSet
        :rtype: str
        """
        return self._DatasourceConnectionName

    @DatasourceConnectionName.setter
    def DatasourceConnectionName(self, DatasourceConnectionName):
        self._DatasourceConnectionName = DatasourceConnectionName

    @property
    def ExcludePublicEngine(self):
        r"""是否不返回共享引擎，true不返回共享引擎，false可以返回共享引擎
        :rtype: bool
        """
        return self._ExcludePublicEngine

    @ExcludePublicEngine.setter
    def ExcludePublicEngine(self, ExcludePublicEngine):
        self._ExcludePublicEngine = ExcludePublicEngine

    @property
    def AccessTypes(self):
        r"""参数应该为引擎权限类型，有效类型："USE", "MODIFY", "OPERATE", "MONITOR", "DELETE"
        :rtype: list of str
        """
        return self._AccessTypes

    @AccessTypes.setter
    def AccessTypes(self, AccessTypes):
        self._AccessTypes = AccessTypes

    @property
    def EngineExecType(self):
        r"""引擎执行任务类型，有效值：SQL/BATCH，默认为SQL
        :rtype: str
        """
        return self._EngineExecType

    @EngineExecType.setter
    def EngineExecType(self, EngineExecType):
        self._EngineExecType = EngineExecType

    @property
    def EngineType(self):
        r"""引擎类型，有效值：spark/presto/kyuubi，为空时默认获取非kyuubi引擎（网关引擎）
        :rtype: str
        """
        return self._EngineType

    @EngineType.setter
    def EngineType(self, EngineType):
        self._EngineType = EngineType

    @property
    def DatasourceConnectionNameSet(self):
        r"""网络配置列表，若传入该参数，则返回网络配置关联的计算引擎
        :rtype: list of str
        """
        return self._DatasourceConnectionNameSet

    @DatasourceConnectionNameSet.setter
    def DatasourceConnectionNameSet(self, DatasourceConnectionNameSet):
        self._DatasourceConnectionNameSet = DatasourceConnectionNameSet

    @property
    def EngineGeneration(self):
        r"""引擎版本，有效值：Native/SuperSQL，为空时默认获取SuperSQL引擎
        :rtype: str
        """
        return self._EngineGeneration

    @EngineGeneration.setter
    def EngineGeneration(self, EngineGeneration):
        self._EngineGeneration = EngineGeneration

    @property
    def EngineTypeDetail(self):
        r"""引擎类型，支持：SparkSQL、SparkBatch、PrestoSQL、Kyuubi
        :rtype: str
        """
        return self._EngineTypeDetail

    @EngineTypeDetail.setter
    def EngineTypeDetail(self, EngineTypeDetail):
        self._EngineTypeDetail = EngineTypeDetail

    @property
    def ListHasListener(self):
        r"""默认 false, 为 true 时仅列出具有洞察 listener 的引擎
        :rtype: bool
        """
        return self._ListHasListener

    @ListHasListener.setter
    def ListHasListener(self, ListHasListener):
        self._ListHasListener = ListHasListener


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._SortBy = params.get("SortBy")
        self._Sorting = params.get("Sorting")
        self._Limit = params.get("Limit")
        self._DatasourceConnectionName = params.get("DatasourceConnectionName")
        self._ExcludePublicEngine = params.get("ExcludePublicEngine")
        self._AccessTypes = params.get("AccessTypes")
        self._EngineExecType = params.get("EngineExecType")
        self._EngineType = params.get("EngineType")
        self._DatasourceConnectionNameSet = params.get("DatasourceConnectionNameSet")
        self._EngineGeneration = params.get("EngineGeneration")
        self._EngineTypeDetail = params.get("EngineTypeDetail")
        self._ListHasListener = params.get("ListHasListener")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDataEnginesResponse(AbstractModel):
    r"""DescribeDataEngines返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DataEngines: 数据引擎列表
注意：此字段可能返回 null，表示取不到有效值。
        :type DataEngines: list of DataEngineInfo
        :param _TotalCount: 总条数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DataEngines = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def DataEngines(self):
        r"""数据引擎列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of DataEngineInfo
        """
        return self._DataEngines

    @DataEngines.setter
    def DataEngines(self, DataEngines):
        self._DataEngines = DataEngines

    @property
    def TotalCount(self):
        r"""总条数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DataEngines") is not None:
            self._DataEngines = []
            for item in params.get("DataEngines"):
                obj = DataEngineInfo()
                obj._deserialize(item)
                self._DataEngines.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeDataEnginesScaleDetailRequest(AbstractModel):
    r"""DescribeDataEnginesScaleDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DataEngineNames: 引擎名称列表
        :type DataEngineNames: list of str
        :param _StartTime: 开始时间，时间格式：yyyy-MM-dd HH:mm:ss，最长查询一个月内的记录
        :type StartTime: str
        :param _EndTime: 结束时间，时间格式：yyyy-MM-dd HH:mm:ss，最长查询一个月内的记录
        :type EndTime: str
        """
        self._DataEngineNames = None
        self._StartTime = None
        self._EndTime = None

    @property
    def DataEngineNames(self):
        r"""引擎名称列表
        :rtype: list of str
        """
        return self._DataEngineNames

    @DataEngineNames.setter
    def DataEngineNames(self, DataEngineNames):
        self._DataEngineNames = DataEngineNames

    @property
    def StartTime(self):
        r"""开始时间，时间格式：yyyy-MM-dd HH:mm:ss，最长查询一个月内的记录
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""结束时间，时间格式：yyyy-MM-dd HH:mm:ss，最长查询一个月内的记录
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._DataEngineNames = params.get("DataEngineNames")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDataEnginesScaleDetailResponse(AbstractModel):
    r"""DescribeDataEnginesScaleDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Scales: 引擎规格统计详细信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Scales: list of DataEngineScaleInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Scales = None
        self._RequestId = None

    @property
    def Scales(self):
        r"""引擎规格统计详细信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of DataEngineScaleInfo
        """
        return self._Scales

    @Scales.setter
    def Scales(self, Scales):
        self._Scales = Scales

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Scales") is not None:
            self._Scales = []
            for item in params.get("Scales"):
                obj = DataEngineScaleInfo()
                obj._deserialize(item)
                self._Scales.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDataMaskStrategiesRequest(AbstractModel):
    r"""DescribeDataMaskStrategies请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 分页参数，单页返回数据量，默认10
        :type Limit: int
        :param _Offset: 分页参数，数据便偏移量，默认0
        :type Offset: int
        :param _Filters: 过滤字段，strategy-name: 按策略名称搜索
        :type Filters: list of Filter
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def Limit(self):
        r"""分页参数，单页返回数据量，默认10
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""分页参数，数据便偏移量，默认0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        r"""过滤字段，strategy-name: 按策略名称搜索
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDataMaskStrategiesResponse(AbstractModel):
    r"""DescribeDataMaskStrategies返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总数据脱敏策略数
        :type TotalCount: int
        :param _Strategies: 数据脱敏策略列表
        :type Strategies: list of DataMaskStrategy
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._Strategies = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""总数据脱敏策略数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Strategies(self):
        r"""数据脱敏策略列表
        :rtype: list of DataMaskStrategy
        """
        return self._Strategies

    @Strategies.setter
    def Strategies(self, Strategies):
        self._Strategies = Strategies

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Strategies") is not None:
            self._Strategies = []
            for item in params.get("Strategies"):
                obj = DataMaskStrategy()
                obj._deserialize(item)
                self._Strategies.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDatabasesRequest(AbstractModel):
    r"""DescribeDatabases请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 返回数量，默认为10，最大值为100。
        :type Limit: int
        :param _Offset: 数据偏移量，从0开始，默认为0。
        :type Offset: int
        :param _KeyWord: 模糊匹配，库名关键字。
        :type KeyWord: str
        :param _DatasourceConnectionName: 数据源唯名称，该名称可以通过DescribeDatasourceConnection接口查询到。默认为DataLakeCatalog
        :type DatasourceConnectionName: str
        :param _Sort: 排序字段，CreateTime：创建时间，Name：数据库名称
        :type Sort: str
        :param _Asc: 排序类型：false：降序（默认）、true：升序
        :type Asc: bool
        :param _DescribeType: 查询类型：all：全部数据（默认）、permission：有权限的数据
注意：此字段需要开启白名单使用，如果需要使用，请提交工单联系我们。
        :type DescribeType: str
        """
        self._Limit = None
        self._Offset = None
        self._KeyWord = None
        self._DatasourceConnectionName = None
        self._Sort = None
        self._Asc = None
        self._DescribeType = None

    @property
    def Limit(self):
        r"""返回数量，默认为10，最大值为100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""数据偏移量，从0开始，默认为0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def KeyWord(self):
        r"""模糊匹配，库名关键字。
        :rtype: str
        """
        return self._KeyWord

    @KeyWord.setter
    def KeyWord(self, KeyWord):
        self._KeyWord = KeyWord

    @property
    def DatasourceConnectionName(self):
        r"""数据源唯名称，该名称可以通过DescribeDatasourceConnection接口查询到。默认为DataLakeCatalog
        :rtype: str
        """
        return self._DatasourceConnectionName

    @DatasourceConnectionName.setter
    def DatasourceConnectionName(self, DatasourceConnectionName):
        self._DatasourceConnectionName = DatasourceConnectionName

    @property
    def Sort(self):
        r"""排序字段，CreateTime：创建时间，Name：数据库名称
        :rtype: str
        """
        return self._Sort

    @Sort.setter
    def Sort(self, Sort):
        self._Sort = Sort

    @property
    def Asc(self):
        r"""排序类型：false：降序（默认）、true：升序
        :rtype: bool
        """
        return self._Asc

    @Asc.setter
    def Asc(self, Asc):
        self._Asc = Asc

    @property
    def DescribeType(self):
        r"""查询类型：all：全部数据（默认）、permission：有权限的数据
注意：此字段需要开启白名单使用，如果需要使用，请提交工单联系我们。
        :rtype: str
        """
        return self._DescribeType

    @DescribeType.setter
    def DescribeType(self, DescribeType):
        self._DescribeType = DescribeType


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._KeyWord = params.get("KeyWord")
        self._DatasourceConnectionName = params.get("DatasourceConnectionName")
        self._Sort = params.get("Sort")
        self._Asc = params.get("Asc")
        self._DescribeType = params.get("DescribeType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDatabasesResponse(AbstractModel):
    r"""DescribeDatabases返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DatabaseList: 数据库对象列表。
        :type DatabaseList: list of DatabaseResponseInfo
        :param _TotalCount: 实例总数。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DatabaseList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def DatabaseList(self):
        r"""数据库对象列表。
        :rtype: list of DatabaseResponseInfo
        """
        return self._DatabaseList

    @DatabaseList.setter
    def DatabaseList(self, DatabaseList):
        self._DatabaseList = DatabaseList

    @property
    def TotalCount(self):
        r"""实例总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DatabaseList") is not None:
            self._DatabaseList = []
            for item in params.get("DatabaseList"):
                obj = DatabaseResponseInfo()
                obj._deserialize(item)
                self._DatabaseList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeDatasourceConnectionRequest(AbstractModel):
    r"""DescribeDatasourceConnection请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DatasourceConnectionIds: 连接ID列表，指定要查询的连接ID
        :type DatasourceConnectionIds: list of str
        :param _Filters: 过滤条件，当前支持的过滤键为：DatasourceConnectionName（数据源连接名）。
DatasourceConnectionType   （数据源连接连接类型）
        :type Filters: list of Filter
        :param _Offset: 偏移量，默认为0
        :type Offset: int
        :param _Limit: 返回数量，默认20，最大值100
        :type Limit: int
        :param _SortBy: 排序字段，支持如下字段类型，create-time（默认，创建时间）、update-time（更新时间）
        :type SortBy: str
        :param _Sorting: 排序方式，desc表示正序，asc表示反序， 默认为desc
        :type Sorting: str
        :param _StartTime: 筛选字段：起始时间
        :type StartTime: str
        :param _EndTime: 筛选字段：截止时间
        :type EndTime: str
        :param _DatasourceConnectionNames: 连接名称列表，指定要查询的连接名称
        :type DatasourceConnectionNames: list of str
        :param _DatasourceConnectionTypes: 连接类型，支持Mysql/HiveCos/Kafka/DataLakeCatalog
        :type DatasourceConnectionTypes: list of str
        :param _HiveVersion: 返回指定hive版本的数据源，该参数指定后，会过滤掉该参数指定版本以外的hive数据源，非hive数据源正常返回
        :type HiveVersion: list of str
        """
        self._DatasourceConnectionIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._SortBy = None
        self._Sorting = None
        self._StartTime = None
        self._EndTime = None
        self._DatasourceConnectionNames = None
        self._DatasourceConnectionTypes = None
        self._HiveVersion = None

    @property
    def DatasourceConnectionIds(self):
        r"""连接ID列表，指定要查询的连接ID
        :rtype: list of str
        """
        return self._DatasourceConnectionIds

    @DatasourceConnectionIds.setter
    def DatasourceConnectionIds(self, DatasourceConnectionIds):
        self._DatasourceConnectionIds = DatasourceConnectionIds

    @property
    def Filters(self):
        r"""过滤条件，当前支持的过滤键为：DatasourceConnectionName（数据源连接名）。
DatasourceConnectionType   （数据源连接连接类型）
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""偏移量，默认为0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回数量，默认20，最大值100
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def SortBy(self):
        r"""排序字段，支持如下字段类型，create-time（默认，创建时间）、update-time（更新时间）
        :rtype: str
        """
        return self._SortBy

    @SortBy.setter
    def SortBy(self, SortBy):
        self._SortBy = SortBy

    @property
    def Sorting(self):
        r"""排序方式，desc表示正序，asc表示反序， 默认为desc
        :rtype: str
        """
        return self._Sorting

    @Sorting.setter
    def Sorting(self, Sorting):
        self._Sorting = Sorting

    @property
    def StartTime(self):
        r"""筛选字段：起始时间
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""筛选字段：截止时间
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def DatasourceConnectionNames(self):
        r"""连接名称列表，指定要查询的连接名称
        :rtype: list of str
        """
        return self._DatasourceConnectionNames

    @DatasourceConnectionNames.setter
    def DatasourceConnectionNames(self, DatasourceConnectionNames):
        self._DatasourceConnectionNames = DatasourceConnectionNames

    @property
    def DatasourceConnectionTypes(self):
        r"""连接类型，支持Mysql/HiveCos/Kafka/DataLakeCatalog
        :rtype: list of str
        """
        return self._DatasourceConnectionTypes

    @DatasourceConnectionTypes.setter
    def DatasourceConnectionTypes(self, DatasourceConnectionTypes):
        self._DatasourceConnectionTypes = DatasourceConnectionTypes

    @property
    def HiveVersion(self):
        r"""返回指定hive版本的数据源，该参数指定后，会过滤掉该参数指定版本以外的hive数据源，非hive数据源正常返回
        :rtype: list of str
        """
        return self._HiveVersion

    @HiveVersion.setter
    def HiveVersion(self, HiveVersion):
        self._HiveVersion = HiveVersion


    def _deserialize(self, params):
        self._DatasourceConnectionIds = params.get("DatasourceConnectionIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._SortBy = params.get("SortBy")
        self._Sorting = params.get("Sorting")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._DatasourceConnectionNames = params.get("DatasourceConnectionNames")
        self._DatasourceConnectionTypes = params.get("DatasourceConnectionTypes")
        self._HiveVersion = params.get("HiveVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDatasourceConnectionResponse(AbstractModel):
    r"""DescribeDatasourceConnection返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 数据连接总数
        :type TotalCount: int
        :param _ConnectionSet: 数据连接对象集合
        :type ConnectionSet: list of DatasourceConnectionInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._ConnectionSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""数据连接总数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ConnectionSet(self):
        r"""数据连接对象集合
        :rtype: list of DatasourceConnectionInfo
        """
        return self._ConnectionSet

    @ConnectionSet.setter
    def ConnectionSet(self, ConnectionSet):
        self._ConnectionSet = ConnectionSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ConnectionSet") is not None:
            self._ConnectionSet = []
            for item in params.get("ConnectionSet"):
                obj = DatasourceConnectionInfo()
                obj._deserialize(item)
                self._ConnectionSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeEngineNetworksRequest(AbstractModel):
    r"""DescribeEngineNetworks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SortBy: 排序字段
        :type SortBy: str
        :param _Sorting: 升序，降序
        :type Sorting: str
        :param _Filters: 过滤条件可选，engine-network-id--引擎网络ID，engine-network-state--引擎网络状态
        :type Filters: list of Filter
        :param _Limit: 数据条数
        :type Limit: int
        :param _Offset: 偏移量
        :type Offset: int
        """
        self._SortBy = None
        self._Sorting = None
        self._Filters = None
        self._Limit = None
        self._Offset = None

    @property
    def SortBy(self):
        r"""排序字段
        :rtype: str
        """
        return self._SortBy

    @SortBy.setter
    def SortBy(self, SortBy):
        self._SortBy = SortBy

    @property
    def Sorting(self):
        r"""升序，降序
        :rtype: str
        """
        return self._Sorting

    @Sorting.setter
    def Sorting(self, Sorting):
        self._Sorting = Sorting

    @property
    def Filters(self):
        r"""过滤条件可选，engine-network-id--引擎网络ID，engine-network-state--引擎网络状态
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        r"""数据条数
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._SortBy = params.get("SortBy")
        self._Sorting = params.get("Sorting")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEngineNetworksResponse(AbstractModel):
    r"""DescribeEngineNetworks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _EngineNetworkInfos: 引擎网络信息
        :type EngineNetworkInfos: list of EngineNetworkInfo
        :param _Total: 总数
        :type Total: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._EngineNetworkInfos = None
        self._Total = None
        self._RequestId = None

    @property
    def EngineNetworkInfos(self):
        r"""引擎网络信息
        :rtype: list of EngineNetworkInfo
        """
        return self._EngineNetworkInfos

    @EngineNetworkInfos.setter
    def EngineNetworkInfos(self, EngineNetworkInfos):
        self._EngineNetworkInfos = EngineNetworkInfos

    @property
    def Total(self):
        r"""总数
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("EngineNetworkInfos") is not None:
            self._EngineNetworkInfos = []
            for item in params.get("EngineNetworkInfos"):
                obj = EngineNetworkInfo()
                obj._deserialize(item)
                self._EngineNetworkInfos.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeEngineNodeSpecRequest(AbstractModel):
    r"""DescribeEngineNodeSpec请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DataEngineName: 引擎名称
        :type DataEngineName: str
        """
        self._DataEngineName = None

    @property
    def DataEngineName(self):
        r"""引擎名称
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName


    def _deserialize(self, params):
        self._DataEngineName = params.get("DataEngineName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEngineNodeSpecResponse(AbstractModel):
    r"""DescribeEngineNodeSpec返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DriverSpec: driver可用的规格
注意：此字段可能返回 null，表示取不到有效值。
        :type DriverSpec: list of SpecInfo
        :param _ExecutorSpec: executor可用的规格
注意：此字段可能返回 null，表示取不到有效值。
        :type ExecutorSpec: list of SpecInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DriverSpec = None
        self._ExecutorSpec = None
        self._RequestId = None

    @property
    def DriverSpec(self):
        r"""driver可用的规格
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of SpecInfo
        """
        return self._DriverSpec

    @DriverSpec.setter
    def DriverSpec(self, DriverSpec):
        self._DriverSpec = DriverSpec

    @property
    def ExecutorSpec(self):
        r"""executor可用的规格
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of SpecInfo
        """
        return self._ExecutorSpec

    @ExecutorSpec.setter
    def ExecutorSpec(self, ExecutorSpec):
        self._ExecutorSpec = ExecutorSpec

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DriverSpec") is not None:
            self._DriverSpec = []
            for item in params.get("DriverSpec"):
                obj = SpecInfo()
                obj._deserialize(item)
                self._DriverSpec.append(obj)
        if params.get("ExecutorSpec") is not None:
            self._ExecutorSpec = []
            for item in params.get("ExecutorSpec"):
                obj = SpecInfo()
                obj._deserialize(item)
                self._ExecutorSpec.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeEngineUsageInfoRequest(AbstractModel):
    r"""DescribeEngineUsageInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DataEngineId: 数据引擎ID
        :type DataEngineId: str
        """
        self._DataEngineId = None

    @property
    def DataEngineId(self):
        r"""数据引擎ID
        :rtype: str
        """
        return self._DataEngineId

    @DataEngineId.setter
    def DataEngineId(self, DataEngineId):
        self._DataEngineId = DataEngineId


    def _deserialize(self, params):
        self._DataEngineId = params.get("DataEngineId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEngineUsageInfoResponse(AbstractModel):
    r"""DescribeEngineUsageInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Total: 集群总规格
        :type Total: int
        :param _Used: 已占用集群规格
        :type Used: int
        :param _Available: 剩余集群规格
        :type Available: int
        :param _AvailPercent: 剩余集群规格百分比
        :type AvailPercent: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Total = None
        self._Used = None
        self._Available = None
        self._AvailPercent = None
        self._RequestId = None

    @property
    def Total(self):
        r"""集群总规格
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Used(self):
        r"""已占用集群规格
        :rtype: int
        """
        return self._Used

    @Used.setter
    def Used(self, Used):
        self._Used = Used

    @property
    def Available(self):
        r"""剩余集群规格
        :rtype: int
        """
        return self._Available

    @Available.setter
    def Available(self, Available):
        self._Available = Available

    @property
    def AvailPercent(self):
        r"""剩余集群规格百分比
        :rtype: int
        """
        return self._AvailPercent

    @AvailPercent.setter
    def AvailPercent(self, AvailPercent):
        self._AvailPercent = AvailPercent

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        self._Used = params.get("Used")
        self._Available = params.get("Available")
        self._AvailPercent = params.get("AvailPercent")
        self._RequestId = params.get("RequestId")


class DescribeForbiddenTableProRequest(AbstractModel):
    r"""DescribeForbiddenTablePro请求参数结构体

    """


class DescribeForbiddenTableProResponse(AbstractModel):
    r"""DescribeForbiddenTablePro返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DescribeLakeFsDirSummaryRequest(AbstractModel):
    r"""DescribeLakeFsDirSummary请求参数结构体

    """


class DescribeLakeFsDirSummaryResponse(AbstractModel):
    r"""DescribeLakeFsDirSummary返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DescribeLakeFsInfoRequest(AbstractModel):
    r"""DescribeLakeFsInfo请求参数结构体

    """


class DescribeLakeFsInfoResponse(AbstractModel):
    r"""DescribeLakeFsInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _LakeFsInfos: 托管存储信息
注意：此字段可能返回 null，表示取不到有效值。
        :type LakeFsInfos: list of LakeFsInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._LakeFsInfos = None
        self._RequestId = None

    @property
    def LakeFsInfos(self):
        r"""托管存储信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of LakeFsInfo
        """
        return self._LakeFsInfos

    @LakeFsInfos.setter
    def LakeFsInfos(self, LakeFsInfos):
        self._LakeFsInfos = LakeFsInfos

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("LakeFsInfos") is not None:
            self._LakeFsInfos = []
            for item in params.get("LakeFsInfos"):
                obj = LakeFsInfo()
                obj._deserialize(item)
                self._LakeFsInfos.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLakeFsTaskResultRequest(AbstractModel):
    r"""DescribeLakeFsTaskResult请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FsPath: 需要访问的任务结果路径
        :type FsPath: str
        """
        self._FsPath = None

    @property
    def FsPath(self):
        r"""需要访问的任务结果路径
        :rtype: str
        """
        return self._FsPath

    @FsPath.setter
    def FsPath(self, FsPath):
        self._FsPath = FsPath


    def _deserialize(self, params):
        self._FsPath = params.get("FsPath")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLakeFsTaskResultResponse(AbstractModel):
    r"""DescribeLakeFsTaskResult返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AccessToken: 路径的访问实例
        :type AccessToken: :class:`tencentcloud.dlc.v20210125.models.LakeFileSystemToken`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AccessToken = None
        self._RequestId = None

    @property
    def AccessToken(self):
        r"""路径的访问实例
        :rtype: :class:`tencentcloud.dlc.v20210125.models.LakeFileSystemToken`
        """
        return self._AccessToken

    @AccessToken.setter
    def AccessToken(self, AccessToken):
        self._AccessToken = AccessToken

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("AccessToken") is not None:
            self._AccessToken = LakeFileSystemToken()
            self._AccessToken._deserialize(params.get("AccessToken"))
        self._RequestId = params.get("RequestId")


class DescribeNativeSparkSessionsRequest(AbstractModel):
    r"""DescribeNativeSparkSessions请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DataEngineId: 引擎ID
        :type DataEngineId: str
        :param _ResourceGroupId: 资源组ID
        :type ResourceGroupId: str
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _UserUin: 用户Uin
        :type UserUin: str
        """
        self._DataEngineId = None
        self._ResourceGroupId = None
        self._ProjectId = None
        self._UserUin = None

    @property
    def DataEngineId(self):
        r"""引擎ID
        :rtype: str
        """
        return self._DataEngineId

    @DataEngineId.setter
    def DataEngineId(self, DataEngineId):
        self._DataEngineId = DataEngineId

    @property
    def ResourceGroupId(self):
        r"""资源组ID
        :rtype: str
        """
        return self._ResourceGroupId

    @ResourceGroupId.setter
    def ResourceGroupId(self, ResourceGroupId):
        self._ResourceGroupId = ResourceGroupId

    @property
    def ProjectId(self):
        r"""项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def UserUin(self):
        r"""用户Uin
        :rtype: str
        """
        return self._UserUin

    @UserUin.setter
    def UserUin(self, UserUin):
        self._UserUin = UserUin


    def _deserialize(self, params):
        self._DataEngineId = params.get("DataEngineId")
        self._ResourceGroupId = params.get("ResourceGroupId")
        self._ProjectId = params.get("ProjectId")
        self._UserUin = params.get("UserUin")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNativeSparkSessionsResponse(AbstractModel):
    r"""DescribeNativeSparkSessions返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SparkSessionsList: spark session列表
        :type SparkSessionsList: list of SparkSessionInfo
        :param _TotalSpec: 资源组总规格
        :type TotalSpec: int
        :param _TotalAvailable: 资源组当前可用规格
        :type TotalAvailable: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SparkSessionsList = None
        self._TotalSpec = None
        self._TotalAvailable = None
        self._RequestId = None

    @property
    def SparkSessionsList(self):
        r"""spark session列表
        :rtype: list of SparkSessionInfo
        """
        return self._SparkSessionsList

    @SparkSessionsList.setter
    def SparkSessionsList(self, SparkSessionsList):
        self._SparkSessionsList = SparkSessionsList

    @property
    def TotalSpec(self):
        r"""资源组总规格
        :rtype: int
        """
        return self._TotalSpec

    @TotalSpec.setter
    def TotalSpec(self, TotalSpec):
        self._TotalSpec = TotalSpec

    @property
    def TotalAvailable(self):
        r"""资源组当前可用规格
        :rtype: int
        """
        return self._TotalAvailable

    @TotalAvailable.setter
    def TotalAvailable(self, TotalAvailable):
        self._TotalAvailable = TotalAvailable

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SparkSessionsList") is not None:
            self._SparkSessionsList = []
            for item in params.get("SparkSessionsList"):
                obj = SparkSessionInfo()
                obj._deserialize(item)
                self._SparkSessionsList.append(obj)
        self._TotalSpec = params.get("TotalSpec")
        self._TotalAvailable = params.get("TotalAvailable")
        self._RequestId = params.get("RequestId")


class DescribeNetworkConnectionsRequest(AbstractModel):
    r"""DescribeNetworkConnections请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NetworkConnectionType: 网络配置类型
        :type NetworkConnectionType: int
        :param _DataEngineName: 计算引擎名称
        :type DataEngineName: str
        :param _DatasourceConnectionVpcId: 数据源vpcid
        :type DatasourceConnectionVpcId: str
        :param _Limit: 返回数量，默认为10，最大值为100。
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _NetworkConnectionName: 网络配置名称
        :type NetworkConnectionName: str
        """
        self._NetworkConnectionType = None
        self._DataEngineName = None
        self._DatasourceConnectionVpcId = None
        self._Limit = None
        self._Offset = None
        self._NetworkConnectionName = None

    @property
    def NetworkConnectionType(self):
        r"""网络配置类型
        :rtype: int
        """
        return self._NetworkConnectionType

    @NetworkConnectionType.setter
    def NetworkConnectionType(self, NetworkConnectionType):
        self._NetworkConnectionType = NetworkConnectionType

    @property
    def DataEngineName(self):
        r"""计算引擎名称
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName

    @property
    def DatasourceConnectionVpcId(self):
        r"""数据源vpcid
        :rtype: str
        """
        return self._DatasourceConnectionVpcId

    @DatasourceConnectionVpcId.setter
    def DatasourceConnectionVpcId(self, DatasourceConnectionVpcId):
        self._DatasourceConnectionVpcId = DatasourceConnectionVpcId

    @property
    def Limit(self):
        r"""返回数量，默认为10，最大值为100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""偏移量，默认为0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def NetworkConnectionName(self):
        r"""网络配置名称
        :rtype: str
        """
        return self._NetworkConnectionName

    @NetworkConnectionName.setter
    def NetworkConnectionName(self, NetworkConnectionName):
        self._NetworkConnectionName = NetworkConnectionName


    def _deserialize(self, params):
        self._NetworkConnectionType = params.get("NetworkConnectionType")
        self._DataEngineName = params.get("DataEngineName")
        self._DatasourceConnectionVpcId = params.get("DatasourceConnectionVpcId")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._NetworkConnectionName = params.get("NetworkConnectionName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetworkConnectionsResponse(AbstractModel):
    r"""DescribeNetworkConnections返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总条数
        :type TotalCount: int
        :param _NetworkConnectionSet: 网络配置列表
        :type NetworkConnectionSet: list of NetworkConnection
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._NetworkConnectionSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""总条数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def NetworkConnectionSet(self):
        r"""网络配置列表
        :rtype: list of NetworkConnection
        """
        return self._NetworkConnectionSet

    @NetworkConnectionSet.setter
    def NetworkConnectionSet(self, NetworkConnectionSet):
        self._NetworkConnectionSet = NetworkConnectionSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("NetworkConnectionSet") is not None:
            self._NetworkConnectionSet = []
            for item in params.get("NetworkConnectionSet"):
                obj = NetworkConnection()
                obj._deserialize(item)
                self._NetworkConnectionSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeNotebookSessionLogRequest(AbstractModel):
    r"""DescribeNotebookSessionLog请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SessionId: Session唯一标识
        :type SessionId: str
        :param _Limit: 分页参数，默认200
        :type Limit: int
        :param _Offset: 分页参数，默认0
        :type Offset: int
        """
        self._SessionId = None
        self._Limit = None
        self._Offset = None

    @property
    def SessionId(self):
        r"""Session唯一标识
        :rtype: str
        """
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def Limit(self):
        r"""分页参数，默认200
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""分页参数，默认0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._SessionId = params.get("SessionId")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNotebookSessionLogResponse(AbstractModel):
    r"""DescribeNotebookSessionLog返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Logs: 日志信息，默认获取最新的200条
        :type Logs: list of str
        :param _Limit: 分页参数，默认200
        :type Limit: int
        :param _Offset: 分页参数，默认0
        :type Offset: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Logs = None
        self._Limit = None
        self._Offset = None
        self._RequestId = None

    @property
    def Logs(self):
        r"""日志信息，默认获取最新的200条
        :rtype: list of str
        """
        return self._Logs

    @Logs.setter
    def Logs(self, Logs):
        self._Logs = Logs

    @property
    def Limit(self):
        r"""分页参数，默认200
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""分页参数，默认0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Logs = params.get("Logs")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._RequestId = params.get("RequestId")


class DescribeNotebookSessionRequest(AbstractModel):
    r"""DescribeNotebookSession请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SessionId: Session唯一标识
        :type SessionId: str
        """
        self._SessionId = None

    @property
    def SessionId(self):
        r"""Session唯一标识
        :rtype: str
        """
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId


    def _deserialize(self, params):
        self._SessionId = params.get("SessionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNotebookSessionResponse(AbstractModel):
    r"""DescribeNotebookSession返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Session: Session详情信息
        :type Session: :class:`tencentcloud.dlc.v20210125.models.NotebookSessionInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Session = None
        self._RequestId = None

    @property
    def Session(self):
        r"""Session详情信息
        :rtype: :class:`tencentcloud.dlc.v20210125.models.NotebookSessionInfo`
        """
        return self._Session

    @Session.setter
    def Session(self, Session):
        self._Session = Session

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Session") is not None:
            self._Session = NotebookSessionInfo()
            self._Session._deserialize(params.get("Session"))
        self._RequestId = params.get("RequestId")


class DescribeNotebookSessionStatementRequest(AbstractModel):
    r"""DescribeNotebookSessionStatement请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SessionId: Session唯一标识
        :type SessionId: str
        :param _StatementId: Session Statement唯一标识
        :type StatementId: str
        :param _TaskId: 任务唯一标识
        :type TaskId: str
        """
        self._SessionId = None
        self._StatementId = None
        self._TaskId = None

    @property
    def SessionId(self):
        r"""Session唯一标识
        :rtype: str
        """
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def StatementId(self):
        r"""Session Statement唯一标识
        :rtype: str
        """
        return self._StatementId

    @StatementId.setter
    def StatementId(self, StatementId):
        self._StatementId = StatementId

    @property
    def TaskId(self):
        r"""任务唯一标识
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._SessionId = params.get("SessionId")
        self._StatementId = params.get("StatementId")
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNotebookSessionStatementResponse(AbstractModel):
    r"""DescribeNotebookSessionStatement返回参数结构体

    """

    def __init__(self):
        r"""
        :param _NotebookSessionStatement: Session Statement详情
        :type NotebookSessionStatement: :class:`tencentcloud.dlc.v20210125.models.NotebookSessionStatementInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._NotebookSessionStatement = None
        self._RequestId = None

    @property
    def NotebookSessionStatement(self):
        r"""Session Statement详情
        :rtype: :class:`tencentcloud.dlc.v20210125.models.NotebookSessionStatementInfo`
        """
        return self._NotebookSessionStatement

    @NotebookSessionStatement.setter
    def NotebookSessionStatement(self, NotebookSessionStatement):
        self._NotebookSessionStatement = NotebookSessionStatement

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NotebookSessionStatement") is not None:
            self._NotebookSessionStatement = NotebookSessionStatementInfo()
            self._NotebookSessionStatement._deserialize(params.get("NotebookSessionStatement"))
        self._RequestId = params.get("RequestId")


class DescribeNotebookSessionStatementSqlResultRequest(AbstractModel):
    r"""DescribeNotebookSessionStatementSqlResult请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务唯一ID
        :type TaskId: str
        :param _MaxResults: 返回结果的最大行数，范围0~1000，默认为1000.
        :type MaxResults: int
        :param _NextToken: 上一次请求响应返回的分页信息。第一次可以不带，从头开始返回数据，每次返回MaxResults字段设置的数据量。
        :type NextToken: str
        :param _BatchId: 批次Id
        :type BatchId: str
        :param _DataFieldCutLen: 返回结果集中字段值长度截取，如果超过该长度则截取到该长度
        :type DataFieldCutLen: int
        """
        self._TaskId = None
        self._MaxResults = None
        self._NextToken = None
        self._BatchId = None
        self._DataFieldCutLen = None

    @property
    def TaskId(self):
        r"""任务唯一ID
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def MaxResults(self):
        r"""返回结果的最大行数，范围0~1000，默认为1000.
        :rtype: int
        """
        return self._MaxResults

    @MaxResults.setter
    def MaxResults(self, MaxResults):
        self._MaxResults = MaxResults

    @property
    def NextToken(self):
        r"""上一次请求响应返回的分页信息。第一次可以不带，从头开始返回数据，每次返回MaxResults字段设置的数据量。
        :rtype: str
        """
        return self._NextToken

    @NextToken.setter
    def NextToken(self, NextToken):
        self._NextToken = NextToken

    @property
    def BatchId(self):
        r"""批次Id
        :rtype: str
        """
        return self._BatchId

    @BatchId.setter
    def BatchId(self, BatchId):
        self._BatchId = BatchId

    @property
    def DataFieldCutLen(self):
        r"""返回结果集中字段值长度截取，如果超过该长度则截取到该长度
        :rtype: int
        """
        return self._DataFieldCutLen

    @DataFieldCutLen.setter
    def DataFieldCutLen(self, DataFieldCutLen):
        self._DataFieldCutLen = DataFieldCutLen


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._MaxResults = params.get("MaxResults")
        self._NextToken = params.get("NextToken")
        self._BatchId = params.get("BatchId")
        self._DataFieldCutLen = params.get("DataFieldCutLen")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNotebookSessionStatementSqlResultResponse(AbstractModel):
    r"""DescribeNotebookSessionStatementSqlResult返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务Id
        :type TaskId: str
        :param _ResultSet: 结果数据
        :type ResultSet: str
        :param _ResultSchema: schema
        :type ResultSchema: list of Column
        :param _NextToken: 分页信息
        :type NextToken: str
        :param _OutputPath: 存储结果地址
        :type OutputPath: str
        :param _UseTime: 引擎计算耗时
        :type UseTime: int
        :param _AffectRows: 结果条数
        :type AffectRows: int
        :param _DataAmount: 数据扫描量
        :type DataAmount: int
        :param _UiUrl: spark ui地址
        :type UiUrl: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._ResultSet = None
        self._ResultSchema = None
        self._NextToken = None
        self._OutputPath = None
        self._UseTime = None
        self._AffectRows = None
        self._DataAmount = None
        self._UiUrl = None
        self._RequestId = None

    @property
    def TaskId(self):
        r"""任务Id
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ResultSet(self):
        r"""结果数据
        :rtype: str
        """
        return self._ResultSet

    @ResultSet.setter
    def ResultSet(self, ResultSet):
        self._ResultSet = ResultSet

    @property
    def ResultSchema(self):
        r"""schema
        :rtype: list of Column
        """
        return self._ResultSchema

    @ResultSchema.setter
    def ResultSchema(self, ResultSchema):
        self._ResultSchema = ResultSchema

    @property
    def NextToken(self):
        r"""分页信息
        :rtype: str
        """
        return self._NextToken

    @NextToken.setter
    def NextToken(self, NextToken):
        self._NextToken = NextToken

    @property
    def OutputPath(self):
        r"""存储结果地址
        :rtype: str
        """
        return self._OutputPath

    @OutputPath.setter
    def OutputPath(self, OutputPath):
        self._OutputPath = OutputPath

    @property
    def UseTime(self):
        r"""引擎计算耗时
        :rtype: int
        """
        return self._UseTime

    @UseTime.setter
    def UseTime(self, UseTime):
        self._UseTime = UseTime

    @property
    def AffectRows(self):
        r"""结果条数
        :rtype: int
        """
        return self._AffectRows

    @AffectRows.setter
    def AffectRows(self, AffectRows):
        self._AffectRows = AffectRows

    @property
    def DataAmount(self):
        r"""数据扫描量
        :rtype: int
        """
        return self._DataAmount

    @DataAmount.setter
    def DataAmount(self, DataAmount):
        self._DataAmount = DataAmount

    @property
    def UiUrl(self):
        r"""spark ui地址
        :rtype: str
        """
        return self._UiUrl

    @UiUrl.setter
    def UiUrl(self, UiUrl):
        self._UiUrl = UiUrl

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ResultSet = params.get("ResultSet")
        if params.get("ResultSchema") is not None:
            self._ResultSchema = []
            for item in params.get("ResultSchema"):
                obj = Column()
                obj._deserialize(item)
                self._ResultSchema.append(obj)
        self._NextToken = params.get("NextToken")
        self._OutputPath = params.get("OutputPath")
        self._UseTime = params.get("UseTime")
        self._AffectRows = params.get("AffectRows")
        self._DataAmount = params.get("DataAmount")
        self._UiUrl = params.get("UiUrl")
        self._RequestId = params.get("RequestId")


class DescribeNotebookSessionStatementsRequest(AbstractModel):
    r"""DescribeNotebookSessionStatements请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SessionId: Session唯一标识
        :type SessionId: str
        :param _BatchId: 批任务id
        :type BatchId: str
        """
        self._SessionId = None
        self._BatchId = None

    @property
    def SessionId(self):
        r"""Session唯一标识
        :rtype: str
        """
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def BatchId(self):
        r"""批任务id
        :rtype: str
        """
        return self._BatchId

    @BatchId.setter
    def BatchId(self, BatchId):
        self._BatchId = BatchId


    def _deserialize(self, params):
        self._SessionId = params.get("SessionId")
        self._BatchId = params.get("BatchId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNotebookSessionStatementsResponse(AbstractModel):
    r"""DescribeNotebookSessionStatements返回参数结构体

    """

    def __init__(self):
        r"""
        :param _NotebookSessionStatements: Session Statement详情
        :type NotebookSessionStatements: :class:`tencentcloud.dlc.v20210125.models.NotebookSessionStatementBatchInformation`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._NotebookSessionStatements = None
        self._RequestId = None

    @property
    def NotebookSessionStatements(self):
        r"""Session Statement详情
        :rtype: :class:`tencentcloud.dlc.v20210125.models.NotebookSessionStatementBatchInformation`
        """
        return self._NotebookSessionStatements

    @NotebookSessionStatements.setter
    def NotebookSessionStatements(self, NotebookSessionStatements):
        self._NotebookSessionStatements = NotebookSessionStatements

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NotebookSessionStatements") is not None:
            self._NotebookSessionStatements = NotebookSessionStatementBatchInformation()
            self._NotebookSessionStatements._deserialize(params.get("NotebookSessionStatements"))
        self._RequestId = params.get("RequestId")


class DescribeNotebookSessionsRequest(AbstractModel):
    r"""DescribeNotebookSessions请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DataEngineName: DLC Spark作业引擎名称
        :type DataEngineName: str
        :param _State: Session状态，包含：not_started（未启动）、starting（已启动）、idle（等待输入）、busy(正在运行statement)、shutting_down（停止）、error（异常）、dead（已退出）、killed（被杀死）、success（正常停止）
        :type State: list of str
        :param _SortFields: 排序字段（默认按创建时间）
        :type SortFields: list of str
        :param _Asc: 排序字段：true：升序、false：降序（默认）
        :type Asc: bool
        :param _Limit: 分页参数，默认10
        :type Limit: int
        :param _Offset: 分页参数，默认0
        :type Offset: int
        :param _Filters: 过滤类型，支持如下的过滤类型，传参Name应为以下其中一个, engine-generation - String（引擎时代： supersql：supersql引擎，native：标准引擎）：notebook-keyword - String（数据引擎名称或sessionid或sessionname的模糊搜索）
        :type Filters: list of Filter
        """
        self._DataEngineName = None
        self._State = None
        self._SortFields = None
        self._Asc = None
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def DataEngineName(self):
        r"""DLC Spark作业引擎名称
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName

    @property
    def State(self):
        r"""Session状态，包含：not_started（未启动）、starting（已启动）、idle（等待输入）、busy(正在运行statement)、shutting_down（停止）、error（异常）、dead（已退出）、killed（被杀死）、success（正常停止）
        :rtype: list of str
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def SortFields(self):
        r"""排序字段（默认按创建时间）
        :rtype: list of str
        """
        return self._SortFields

    @SortFields.setter
    def SortFields(self, SortFields):
        self._SortFields = SortFields

    @property
    def Asc(self):
        r"""排序字段：true：升序、false：降序（默认）
        :rtype: bool
        """
        return self._Asc

    @Asc.setter
    def Asc(self, Asc):
        self._Asc = Asc

    @property
    def Limit(self):
        r"""分页参数，默认10
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""分页参数，默认0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        r"""过滤类型，支持如下的过滤类型，传参Name应为以下其中一个, engine-generation - String（引擎时代： supersql：supersql引擎，native：标准引擎）：notebook-keyword - String（数据引擎名称或sessionid或sessionname的模糊搜索）
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._DataEngineName = params.get("DataEngineName")
        self._State = params.get("State")
        self._SortFields = params.get("SortFields")
        self._Asc = params.get("Asc")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNotebookSessionsResponse(AbstractModel):
    r"""DescribeNotebookSessions返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalElements: session总数量
        :type TotalElements: int
        :param _TotalPages: 总页数
        :type TotalPages: int
        :param _Page: 当前页码
        :type Page: int
        :param _Size: 当前页数量
        :type Size: int
        :param _Sessions: session列表信息
        :type Sessions: list of NotebookSessions
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalElements = None
        self._TotalPages = None
        self._Page = None
        self._Size = None
        self._Sessions = None
        self._RequestId = None

    @property
    def TotalElements(self):
        r"""session总数量
        :rtype: int
        """
        return self._TotalElements

    @TotalElements.setter
    def TotalElements(self, TotalElements):
        self._TotalElements = TotalElements

    @property
    def TotalPages(self):
        r"""总页数
        :rtype: int
        """
        return self._TotalPages

    @TotalPages.setter
    def TotalPages(self, TotalPages):
        self._TotalPages = TotalPages

    @property
    def Page(self):
        r"""当前页码
        :rtype: int
        """
        return self._Page

    @Page.setter
    def Page(self, Page):
        self._Page = Page

    @property
    def Size(self):
        r"""当前页数量
        :rtype: int
        """
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size

    @property
    def Sessions(self):
        r"""session列表信息
        :rtype: list of NotebookSessions
        """
        return self._Sessions

    @Sessions.setter
    def Sessions(self, Sessions):
        self._Sessions = Sessions

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalElements = params.get("TotalElements")
        self._TotalPages = params.get("TotalPages")
        self._Page = params.get("Page")
        self._Size = params.get("Size")
        if params.get("Sessions") is not None:
            self._Sessions = []
            for item in params.get("Sessions"):
                obj = NotebookSessions()
                obj._deserialize(item)
                self._Sessions.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeOtherCHDFSBindingListRequest(AbstractModel):
    r"""DescribeOtherCHDFSBindingList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _BucketId: 桶名
        :type BucketId: str
        """
        self._BucketId = None

    @property
    def BucketId(self):
        r"""桶名
        :rtype: str
        """
        return self._BucketId

    @BucketId.setter
    def BucketId(self, BucketId):
        self._BucketId = BucketId


    def _deserialize(self, params):
        self._BucketId = params.get("BucketId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOtherCHDFSBindingListResponse(AbstractModel):
    r"""DescribeOtherCHDFSBindingList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _OtherCHDFSBindingList: 非DLC 产品绑定列表
        :type OtherCHDFSBindingList: list of OtherCHDFSBinding
        :param _Total: 总记录数
        :type Total: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._OtherCHDFSBindingList = None
        self._Total = None
        self._RequestId = None

    @property
    def OtherCHDFSBindingList(self):
        r"""非DLC 产品绑定列表
        :rtype: list of OtherCHDFSBinding
        """
        return self._OtherCHDFSBindingList

    @OtherCHDFSBindingList.setter
    def OtherCHDFSBindingList(self, OtherCHDFSBindingList):
        self._OtherCHDFSBindingList = OtherCHDFSBindingList

    @property
    def Total(self):
        r"""总记录数
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("OtherCHDFSBindingList") is not None:
            self._OtherCHDFSBindingList = []
            for item in params.get("OtherCHDFSBindingList"):
                obj = OtherCHDFSBinding()
                obj._deserialize(item)
                self._OtherCHDFSBindingList.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeResourceGroupUsageInfoRequest(AbstractModel):
    r"""DescribeResourceGroupUsageInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SessionId: 资源组ID
        :type SessionId: str
        """
        self._SessionId = None

    @property
    def SessionId(self):
        r"""资源组ID
        :rtype: str
        """
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId


    def _deserialize(self, params):
        self._SessionId = params.get("SessionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeResourceGroupUsageInfoResponse(AbstractModel):
    r"""DescribeResourceGroupUsageInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Total: 资源上限
        :type Total: int
        :param _Used: 已占用资源
        :type Used: int
        :param _Available: 剩余可用资源
        :type Available: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Total = None
        self._Used = None
        self._Available = None
        self._RequestId = None

    @property
    def Total(self):
        r"""资源上限
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Used(self):
        r"""已占用资源
        :rtype: int
        """
        return self._Used

    @Used.setter
    def Used(self, Used):
        self._Used = Used

    @property
    def Available(self):
        r"""剩余可用资源
        :rtype: int
        """
        return self._Available

    @Available.setter
    def Available(self, Available):
        self._Available = Available

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        self._Used = params.get("Used")
        self._Available = params.get("Available")
        self._RequestId = params.get("RequestId")


class DescribeResultDownloadRequest(AbstractModel):
    r"""DescribeResultDownload请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DownloadId: 查询任务Id
        :type DownloadId: str
        """
        self._DownloadId = None

    @property
    def DownloadId(self):
        r"""查询任务Id
        :rtype: str
        """
        return self._DownloadId

    @DownloadId.setter
    def DownloadId(self, DownloadId):
        self._DownloadId = DownloadId


    def _deserialize(self, params):
        self._DownloadId = params.get("DownloadId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeResultDownloadResponse(AbstractModel):
    r"""DescribeResultDownload返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Path: 下载文件路径
        :type Path: str
        :param _Status: 任务状态 init | queue | format | compress | success|  timeout | error
        :type Status: str
        :param _Reason: 任务异常原因
        :type Reason: str
        :param _SecretId: 临时SecretId
        :type SecretId: str
        :param _SecretKey: 临时SecretKey
        :type SecretKey: str
        :param _Token: 临时Token
        :type Token: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Path = None
        self._Status = None
        self._Reason = None
        self._SecretId = None
        self._SecretKey = None
        self._Token = None
        self._RequestId = None

    @property
    def Path(self):
        r"""下载文件路径
        :rtype: str
        """
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def Status(self):
        r"""任务状态 init | queue | format | compress | success|  timeout | error
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Reason(self):
        r"""任务异常原因
        :rtype: str
        """
        return self._Reason

    @Reason.setter
    def Reason(self, Reason):
        self._Reason = Reason

    @property
    def SecretId(self):
        r"""临时SecretId
        :rtype: str
        """
        return self._SecretId

    @SecretId.setter
    def SecretId(self, SecretId):
        self._SecretId = SecretId

    @property
    def SecretKey(self):
        r"""临时SecretKey
        :rtype: str
        """
        return self._SecretKey

    @SecretKey.setter
    def SecretKey(self, SecretKey):
        self._SecretKey = SecretKey

    @property
    def Token(self):
        r"""临时Token
        :rtype: str
        """
        return self._Token

    @Token.setter
    def Token(self, Token):
        self._Token = Token

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Path = params.get("Path")
        self._Status = params.get("Status")
        self._Reason = params.get("Reason")
        self._SecretId = params.get("SecretId")
        self._SecretKey = params.get("SecretKey")
        self._Token = params.get("Token")
        self._RequestId = params.get("RequestId")


class DescribeScriptsRequest(AbstractModel):
    r"""DescribeScripts请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 返回数量，默认为10，最大值为100。
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _SortBy: 按字段排序，支持如下字段类型，update-time
        :type SortBy: str
        :param _Sorting: 排序方式，desc表示正序，asc表示反序，默认asc
        :type Sorting: str
        :param _Filters: 过滤条件，如下支持的过滤类型，传参Name应为其一
script-id - String - （过滤条件）script-id取值形如：157de0d1-26b4-4df2-a2d0-b64afc406c25。
script-name-keyword - String - （过滤条件）数据表名称,形如：script-test。
        :type Filters: list of Filter
        """
        self._Limit = None
        self._Offset = None
        self._SortBy = None
        self._Sorting = None
        self._Filters = None

    @property
    def Limit(self):
        r"""返回数量，默认为10，最大值为100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""偏移量，默认为0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def SortBy(self):
        r"""按字段排序，支持如下字段类型，update-time
        :rtype: str
        """
        return self._SortBy

    @SortBy.setter
    def SortBy(self, SortBy):
        self._SortBy = SortBy

    @property
    def Sorting(self):
        r"""排序方式，desc表示正序，asc表示反序，默认asc
        :rtype: str
        """
        return self._Sorting

    @Sorting.setter
    def Sorting(self, Sorting):
        self._Sorting = Sorting

    @property
    def Filters(self):
        r"""过滤条件，如下支持的过滤类型，传参Name应为其一
script-id - String - （过滤条件）script-id取值形如：157de0d1-26b4-4df2-a2d0-b64afc406c25。
script-name-keyword - String - （过滤条件）数据表名称,形如：script-test。
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._SortBy = params.get("SortBy")
        self._Sorting = params.get("Sorting")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeScriptsResponse(AbstractModel):
    r"""DescribeScripts返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Scripts: Script列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Scripts: list of Script
        :param _TotalCount: 实例总数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Scripts = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def Scripts(self):
        r"""Script列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of Script
        """
        return self._Scripts

    @Scripts.setter
    def Scripts(self, Scripts):
        self._Scripts = Scripts

    @property
    def TotalCount(self):
        r"""实例总数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Scripts") is not None:
            self._Scripts = []
            for item in params.get("Scripts"):
                obj = Script()
                obj._deserialize(item)
                self._Scripts.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeSessionImageVersionRequest(AbstractModel):
    r"""DescribeSessionImageVersion请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DataEngineId: 引擎Id
        :type DataEngineId: str
        :param _FrameworkType: 框架类型：machine-learning、python、spark-ml
        :type FrameworkType: str
        """
        self._DataEngineId = None
        self._FrameworkType = None

    @property
    def DataEngineId(self):
        r"""引擎Id
        :rtype: str
        """
        return self._DataEngineId

    @DataEngineId.setter
    def DataEngineId(self, DataEngineId):
        self._DataEngineId = DataEngineId

    @property
    def FrameworkType(self):
        r"""框架类型：machine-learning、python、spark-ml
        :rtype: str
        """
        return self._FrameworkType

    @FrameworkType.setter
    def FrameworkType(self, FrameworkType):
        self._FrameworkType = FrameworkType


    def _deserialize(self, params):
        self._DataEngineId = params.get("DataEngineId")
        self._FrameworkType = params.get("FrameworkType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSessionImageVersionResponse(AbstractModel):
    r"""DescribeSessionImageVersion返回参数结构体

    """

    def __init__(self):
        r"""
        :param _EngineSessionImages: 扩展镜像列表
注意：此字段可能返回 null，表示取不到有效值。
        :type EngineSessionImages: list of EngineSessionImage
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._EngineSessionImages = None
        self._RequestId = None

    @property
    def EngineSessionImages(self):
        r"""扩展镜像列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of EngineSessionImage
        """
        return self._EngineSessionImages

    @EngineSessionImages.setter
    def EngineSessionImages(self, EngineSessionImages):
        self._EngineSessionImages = EngineSessionImages

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("EngineSessionImages") is not None:
            self._EngineSessionImages = []
            for item in params.get("EngineSessionImages"):
                obj = EngineSessionImage()
                obj._deserialize(item)
                self._EngineSessionImages.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSparkAppJobRequest(AbstractModel):
    r"""DescribeSparkAppJob请求参数结构体

    """

    def __init__(self):
        r"""
        :param _JobId: spark作业Id，与JobName同时存在时，JobName无效，JobId与JobName至少存在一个
        :type JobId: str
        :param _JobName: spark作业名
        :type JobName: str
        """
        self._JobId = None
        self._JobName = None

    @property
    def JobId(self):
        r"""spark作业Id，与JobName同时存在时，JobName无效，JobId与JobName至少存在一个
        :rtype: str
        """
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def JobName(self):
        r"""spark作业名
        :rtype: str
        """
        return self._JobName

    @JobName.setter
    def JobName(self, JobName):
        self._JobName = JobName


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._JobName = params.get("JobName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSparkAppJobResponse(AbstractModel):
    r"""DescribeSparkAppJob返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Job: spark作业详情
注意：此字段可能返回 null，表示取不到有效值。
        :type Job: :class:`tencentcloud.dlc.v20210125.models.SparkJobInfo`
        :param _IsExists: 查询的spark作业是否存在
        :type IsExists: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Job = None
        self._IsExists = None
        self._RequestId = None

    @property
    def Job(self):
        r"""spark作业详情
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.dlc.v20210125.models.SparkJobInfo`
        """
        return self._Job

    @Job.setter
    def Job(self, Job):
        self._Job = Job

    @property
    def IsExists(self):
        r"""查询的spark作业是否存在
        :rtype: bool
        """
        return self._IsExists

    @IsExists.setter
    def IsExists(self, IsExists):
        self._IsExists = IsExists

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Job") is not None:
            self._Job = SparkJobInfo()
            self._Job._deserialize(params.get("Job"))
        self._IsExists = params.get("IsExists")
        self._RequestId = params.get("RequestId")


class DescribeSparkAppJobsRequest(AbstractModel):
    r"""DescribeSparkAppJobs请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SortBy: 返回结果按照该字段排序
        :type SortBy: str
        :param _Sorting: 正序或者倒序，例如：desc
        :type Sorting: str
        :param _Filters: 过滤条件，如下支持的过滤类型，传参Name应为其一:spark-job-name（作业名称），spark-job-id（作业id），spark-app-type（作业类型，1：批任务，2：流任务，4：SQL作业），user-name（创建人），key-word（作业名称或ID关键词模糊搜索）
        :type Filters: list of Filter
        :param _StartTime: 更新时间起始点，支持格式：yyyy-MM-dd HH:mm:ss
        :type StartTime: str
        :param _EndTime: 更新时间截止点，支持格式：yyyy-MM-dd HH:mm:ss
        :type EndTime: str
        :param _Offset: 查询列表偏移量, 默认值0
        :type Offset: int
        :param _Limit: 查询列表限制数量, 默认值100
        :type Limit: int
        """
        self._SortBy = None
        self._Sorting = None
        self._Filters = None
        self._StartTime = None
        self._EndTime = None
        self._Offset = None
        self._Limit = None

    @property
    def SortBy(self):
        r"""返回结果按照该字段排序
        :rtype: str
        """
        return self._SortBy

    @SortBy.setter
    def SortBy(self, SortBy):
        self._SortBy = SortBy

    @property
    def Sorting(self):
        r"""正序或者倒序，例如：desc
        :rtype: str
        """
        return self._Sorting

    @Sorting.setter
    def Sorting(self, Sorting):
        self._Sorting = Sorting

    @property
    def Filters(self):
        r"""过滤条件，如下支持的过滤类型，传参Name应为其一:spark-job-name（作业名称），spark-job-id（作业id），spark-app-type（作业类型，1：批任务，2：流任务，4：SQL作业），user-name（创建人），key-word（作业名称或ID关键词模糊搜索）
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def StartTime(self):
        r"""更新时间起始点，支持格式：yyyy-MM-dd HH:mm:ss
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""更新时间截止点，支持格式：yyyy-MM-dd HH:mm:ss
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Offset(self):
        r"""查询列表偏移量, 默认值0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""查询列表限制数量, 默认值100
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SortBy = params.get("SortBy")
        self._Sorting = params.get("Sorting")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSparkAppJobsResponse(AbstractModel):
    r"""DescribeSparkAppJobs返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SparkAppJobs: spark作业列表详情
        :type SparkAppJobs: list of SparkJobInfo
        :param _TotalCount: spark作业总数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SparkAppJobs = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SparkAppJobs(self):
        r"""spark作业列表详情
        :rtype: list of SparkJobInfo
        """
        return self._SparkAppJobs

    @SparkAppJobs.setter
    def SparkAppJobs(self, SparkAppJobs):
        self._SparkAppJobs = SparkAppJobs

    @property
    def TotalCount(self):
        r"""spark作业总数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SparkAppJobs") is not None:
            self._SparkAppJobs = []
            for item in params.get("SparkAppJobs"):
                obj = SparkJobInfo()
                obj._deserialize(item)
                self._SparkAppJobs.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeSparkAppTasksRequest(AbstractModel):
    r"""DescribeSparkAppTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _JobId: spark作业Id
        :type JobId: str
        :param _Offset: 分页查询偏移量
        :type Offset: int
        :param _Limit: 分页查询Limit
        :type Limit: int
        :param _TaskId: 执行实例id
        :type TaskId: str
        :param _StartTime: 更新时间起始点，支持格式：yyyy-MM-dd HH:mm:ss
        :type StartTime: str
        :param _EndTime: 更新时间截止点，支持格式：yyyy-MM-dd HH:mm:ss
        :type EndTime: str
        :param _Filters: 按照该参数过滤,支持task-state
        :type Filters: list of Filter
        """
        self._JobId = None
        self._Offset = None
        self._Limit = None
        self._TaskId = None
        self._StartTime = None
        self._EndTime = None
        self._Filters = None

    @property
    def JobId(self):
        r"""spark作业Id
        :rtype: str
        """
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def Offset(self):
        r"""分页查询偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""分页查询Limit
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def TaskId(self):
        r"""执行实例id
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def StartTime(self):
        r"""更新时间起始点，支持格式：yyyy-MM-dd HH:mm:ss
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""更新时间截止点，支持格式：yyyy-MM-dd HH:mm:ss
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Filters(self):
        r"""按照该参数过滤,支持task-state
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._TaskId = params.get("TaskId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSparkAppTasksResponse(AbstractModel):
    r"""DescribeSparkAppTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Tasks: 任务结果（该字段已废弃）
注意：此字段可能返回 null，表示取不到有效值。
        :type Tasks: :class:`tencentcloud.dlc.v20210125.models.TaskResponseInfo`
        :param _TotalCount: 任务总数
        :type TotalCount: int
        :param _SparkAppTasks: 任务结果列表
注意：此字段可能返回 null，表示取不到有效值。
        :type SparkAppTasks: list of TaskResponseInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Tasks = None
        self._TotalCount = None
        self._SparkAppTasks = None
        self._RequestId = None

    @property
    def Tasks(self):
        r"""任务结果（该字段已废弃）
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.dlc.v20210125.models.TaskResponseInfo`
        """
        return self._Tasks

    @Tasks.setter
    def Tasks(self, Tasks):
        self._Tasks = Tasks

    @property
    def TotalCount(self):
        r"""任务总数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def SparkAppTasks(self):
        r"""任务结果列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of TaskResponseInfo
        """
        return self._SparkAppTasks

    @SparkAppTasks.setter
    def SparkAppTasks(self, SparkAppTasks):
        self._SparkAppTasks = SparkAppTasks

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Tasks") is not None:
            self._Tasks = TaskResponseInfo()
            self._Tasks._deserialize(params.get("Tasks"))
        self._TotalCount = params.get("TotalCount")
        if params.get("SparkAppTasks") is not None:
            self._SparkAppTasks = []
            for item in params.get("SparkAppTasks"):
                obj = TaskResponseInfo()
                obj._deserialize(item)
                self._SparkAppTasks.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSparkSessionBatchSQLCostRequest(AbstractModel):
    r"""DescribeSparkSessionBatchSQLCost请求参数结构体

    """

    def __init__(self):
        r"""
        :param _BatchIds: SparkSQL唯一标识
        :type BatchIds: list of str
        """
        self._BatchIds = None

    @property
    def BatchIds(self):
        r"""SparkSQL唯一标识
        :rtype: list of str
        """
        return self._BatchIds

    @BatchIds.setter
    def BatchIds(self, BatchIds):
        self._BatchIds = BatchIds


    def _deserialize(self, params):
        self._BatchIds = params.get("BatchIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSparkSessionBatchSQLCostResponse(AbstractModel):
    r"""DescribeSparkSessionBatchSQLCost返回参数结构体

    """

    def __init__(self):
        r"""
        :param _CostInfo: 任务消耗
注意：此字段可能返回 null，表示取不到有效值。
        :type CostInfo: list of BatchSQLCostInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._CostInfo = None
        self._RequestId = None

    @property
    def CostInfo(self):
        r"""任务消耗
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of BatchSQLCostInfo
        """
        return self._CostInfo

    @CostInfo.setter
    def CostInfo(self, CostInfo):
        self._CostInfo = CostInfo

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("CostInfo") is not None:
            self._CostInfo = []
            for item in params.get("CostInfo"):
                obj = BatchSQLCostInfo()
                obj._deserialize(item)
                self._CostInfo.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSparkSessionBatchSQLRequest(AbstractModel):
    r"""DescribeSparkSessionBatchSQL请求参数结构体

    """

    def __init__(self):
        r"""
        :param _BatchId: SparkSQL唯一标识
        :type BatchId: str
        :param _CustomKey: 用户自定义主键, 若不为空，则按照该值查询
        :type CustomKey: str
        """
        self._BatchId = None
        self._CustomKey = None

    @property
    def BatchId(self):
        r"""SparkSQL唯一标识
        :rtype: str
        """
        return self._BatchId

    @BatchId.setter
    def BatchId(self, BatchId):
        self._BatchId = BatchId

    @property
    def CustomKey(self):
        r"""用户自定义主键, 若不为空，则按照该值查询
        :rtype: str
        """
        return self._CustomKey

    @CustomKey.setter
    def CustomKey(self, CustomKey):
        self._CustomKey = CustomKey


    def _deserialize(self, params):
        self._BatchId = params.get("BatchId")
        self._CustomKey = params.get("CustomKey")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSparkSessionBatchSQLResponse(AbstractModel):
    r"""DescribeSparkSessionBatchSQL返回参数结构体

    """

    def __init__(self):
        r"""
        :param _State: 状态：0：运行中、1：成功、2：失败、3：取消、4：超时；
        :type State: int
        :param _Tasks: SQL子任务列表，仅展示运行完成的子任务，若某个任务运行失败，后续其它子任务不返回
注意：此字段可能返回 null，表示取不到有效值。
        :type Tasks: list of BatchSqlTask
        :param _Event: 非sql运行的异常事件信息，包含资源创建失败、调度异常，JOB超时等，正常运行下该Event值为空
        :type Event: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._State = None
        self._Tasks = None
        self._Event = None
        self._RequestId = None

    @property
    def State(self):
        r"""状态：0：运行中、1：成功、2：失败、3：取消、4：超时；
        :rtype: int
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def Tasks(self):
        r"""SQL子任务列表，仅展示运行完成的子任务，若某个任务运行失败，后续其它子任务不返回
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of BatchSqlTask
        """
        return self._Tasks

    @Tasks.setter
    def Tasks(self, Tasks):
        self._Tasks = Tasks

    @property
    def Event(self):
        r"""非sql运行的异常事件信息，包含资源创建失败、调度异常，JOB超时等，正常运行下该Event值为空
        :rtype: str
        """
        return self._Event

    @Event.setter
    def Event(self, Event):
        self._Event = Event

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._State = params.get("State")
        if params.get("Tasks") is not None:
            self._Tasks = []
            for item in params.get("Tasks"):
                obj = BatchSqlTask()
                obj._deserialize(item)
                self._Tasks.append(obj)
        self._Event = params.get("Event")
        self._RequestId = params.get("RequestId")


class DescribeSparkSessionBatchSqlLogRequest(AbstractModel):
    r"""DescribeSparkSessionBatchSqlLog请求参数结构体

    """

    def __init__(self):
        r"""
        :param _BatchId: SparkSQL唯一标识
        :type BatchId: str
        :param _CustomKey: 用户自定义主键，若不为空，则按照该值进行查询
        :type CustomKey: str
        """
        self._BatchId = None
        self._CustomKey = None

    @property
    def BatchId(self):
        r"""SparkSQL唯一标识
        :rtype: str
        """
        return self._BatchId

    @BatchId.setter
    def BatchId(self, BatchId):
        self._BatchId = BatchId

    @property
    def CustomKey(self):
        r"""用户自定义主键，若不为空，则按照该值进行查询
        :rtype: str
        """
        return self._CustomKey

    @CustomKey.setter
    def CustomKey(self, CustomKey):
        self._CustomKey = CustomKey


    def _deserialize(self, params):
        self._BatchId = params.get("BatchId")
        self._CustomKey = params.get("CustomKey")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSparkSessionBatchSqlLogResponse(AbstractModel):
    r"""DescribeSparkSessionBatchSqlLog返回参数结构体

    """

    def __init__(self):
        r"""
        :param _State: 状态：0：运行中、1：成功、2：失败、3：取消、4：超时；
        :type State: int
        :param _LogSet: 日志信息列表
注意：此字段可能返回 null，表示取不到有效值。
        :type LogSet: list of SparkSessionBatchLog
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._State = None
        self._LogSet = None
        self._RequestId = None

    @property
    def State(self):
        r"""状态：0：运行中、1：成功、2：失败、3：取消、4：超时；
        :rtype: int
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def LogSet(self):
        r"""日志信息列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of SparkSessionBatchLog
        """
        return self._LogSet

    @LogSet.setter
    def LogSet(self, LogSet):
        self._LogSet = LogSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._State = params.get("State")
        if params.get("LogSet") is not None:
            self._LogSet = []
            for item in params.get("LogSet"):
                obj = SparkSessionBatchLog()
                obj._deserialize(item)
                self._LogSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeStandardEngineResourceGroupConfigInfoRequest(AbstractModel):
    r"""DescribeStandardEngineResourceGroupConfigInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SortBy: 排序字段
        :type SortBy: str
        :param _Sorting: 升序，降序
        :type Sorting: str
        :param _Filters: 过滤条件可选，engine-resource-group-id--引擎资源组ID，engine-id---引擎ID
        :type Filters: list of Filter
        :param _Limit: 数据条数，默认10
        :type Limit: int
        :param _Offset: 偏移量，默认0
        :type Offset: int
        """
        self._SortBy = None
        self._Sorting = None
        self._Filters = None
        self._Limit = None
        self._Offset = None

    @property
    def SortBy(self):
        r"""排序字段
        :rtype: str
        """
        return self._SortBy

    @SortBy.setter
    def SortBy(self, SortBy):
        self._SortBy = SortBy

    @property
    def Sorting(self):
        r"""升序，降序
        :rtype: str
        """
        return self._Sorting

    @Sorting.setter
    def Sorting(self, Sorting):
        self._Sorting = Sorting

    @property
    def Filters(self):
        r"""过滤条件可选，engine-resource-group-id--引擎资源组ID，engine-id---引擎ID
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        r"""数据条数，默认10
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""偏移量，默认0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._SortBy = params.get("SortBy")
        self._Sorting = params.get("Sorting")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeStandardEngineResourceGroupConfigInfoResponse(AbstractModel):
    r"""DescribeStandardEngineResourceGroupConfigInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Total: 总数
        :type Total: int
        :param _StandardEngineResourceGroupConfigInfos: 标准引擎资源组，配置相关信息
        :type StandardEngineResourceGroupConfigInfos: list of StandardEngineResourceGroupConfigInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Total = None
        self._StandardEngineResourceGroupConfigInfos = None
        self._RequestId = None

    @property
    def Total(self):
        r"""总数
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def StandardEngineResourceGroupConfigInfos(self):
        r"""标准引擎资源组，配置相关信息
        :rtype: list of StandardEngineResourceGroupConfigInfo
        """
        return self._StandardEngineResourceGroupConfigInfos

    @StandardEngineResourceGroupConfigInfos.setter
    def StandardEngineResourceGroupConfigInfos(self, StandardEngineResourceGroupConfigInfos):
        self._StandardEngineResourceGroupConfigInfos = StandardEngineResourceGroupConfigInfos

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("StandardEngineResourceGroupConfigInfos") is not None:
            self._StandardEngineResourceGroupConfigInfos = []
            for item in params.get("StandardEngineResourceGroupConfigInfos"):
                obj = StandardEngineResourceGroupConfigInfo()
                obj._deserialize(item)
                self._StandardEngineResourceGroupConfigInfos.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeStandardEngineResourceGroupsRequest(AbstractModel):
    r"""DescribeStandardEngineResourceGroups请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SortBy: 排序字段
        :type SortBy: str
        :param _Sorting: 升序，降序
        :type Sorting: str
        :param _Filters: 过滤条件可选，app-id--用户appID，engine-resource-group-id--引擎资源组ID，data-engine-name--引擎名称，engine-resource-group-name---引擎资源组名称（模糊查询），engine-resource-group-state---引擎资源组状态engine-resource-group-name-unique --引擎资源组名称（完全匹配）
        :type Filters: list of Filter
        :param _Limit: 数据条数，默认10
        :type Limit: int
        :param _Offset: 偏移量，默认0
        :type Offset: int
        """
        self._SortBy = None
        self._Sorting = None
        self._Filters = None
        self._Limit = None
        self._Offset = None

    @property
    def SortBy(self):
        r"""排序字段
        :rtype: str
        """
        return self._SortBy

    @SortBy.setter
    def SortBy(self, SortBy):
        self._SortBy = SortBy

    @property
    def Sorting(self):
        r"""升序，降序
        :rtype: str
        """
        return self._Sorting

    @Sorting.setter
    def Sorting(self, Sorting):
        self._Sorting = Sorting

    @property
    def Filters(self):
        r"""过滤条件可选，app-id--用户appID，engine-resource-group-id--引擎资源组ID，data-engine-name--引擎名称，engine-resource-group-name---引擎资源组名称（模糊查询），engine-resource-group-state---引擎资源组状态engine-resource-group-name-unique --引擎资源组名称（完全匹配）
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        r"""数据条数，默认10
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""偏移量，默认0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._SortBy = params.get("SortBy")
        self._Sorting = params.get("Sorting")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeStandardEngineResourceGroupsResponse(AbstractModel):
    r"""DescribeStandardEngineResourceGroups返回参数结构体

    """

    def __init__(self):
        r"""
        :param _UserEngineResourceGroupInfos: 标准引擎资源组信息
        :type UserEngineResourceGroupInfos: list of StandardEngineResourceGroupInfo
        :param _Total: 资源组总数
        :type Total: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._UserEngineResourceGroupInfos = None
        self._Total = None
        self._RequestId = None

    @property
    def UserEngineResourceGroupInfos(self):
        r"""标准引擎资源组信息
        :rtype: list of StandardEngineResourceGroupInfo
        """
        return self._UserEngineResourceGroupInfos

    @UserEngineResourceGroupInfos.setter
    def UserEngineResourceGroupInfos(self, UserEngineResourceGroupInfos):
        self._UserEngineResourceGroupInfos = UserEngineResourceGroupInfos

    @property
    def Total(self):
        r"""资源组总数
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("UserEngineResourceGroupInfos") is not None:
            self._UserEngineResourceGroupInfos = []
            for item in params.get("UserEngineResourceGroupInfos"):
                obj = StandardEngineResourceGroupInfo()
                obj._deserialize(item)
                self._UserEngineResourceGroupInfos.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeStoreLocationRequest(AbstractModel):
    r"""DescribeStoreLocation请求参数结构体

    """


class DescribeStoreLocationResponse(AbstractModel):
    r"""DescribeStoreLocation返回参数结构体

    """

    def __init__(self):
        r"""
        :param _StoreLocation: 返回用户设置的结果存储位置路径，如果未设置则返回空字符串：""
        :type StoreLocation: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._StoreLocation = None
        self._RequestId = None

    @property
    def StoreLocation(self):
        r"""返回用户设置的结果存储位置路径，如果未设置则返回空字符串：""
        :rtype: str
        """
        return self._StoreLocation

    @StoreLocation.setter
    def StoreLocation(self, StoreLocation):
        self._StoreLocation = StoreLocation

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._StoreLocation = params.get("StoreLocation")
        self._RequestId = params.get("RequestId")


class DescribeSubUserAccessPolicyRequest(AbstractModel):
    r"""DescribeSubUserAccessPolicy请求参数结构体

    """


class DescribeSubUserAccessPolicyResponse(AbstractModel):
    r"""DescribeSubUserAccessPolicy返回参数结构体

    """

    def __init__(self):
        r"""
        :param _PolicyDocument: 子用户访问策略
        :type PolicyDocument: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._PolicyDocument = None
        self._RequestId = None

    @property
    def PolicyDocument(self):
        r"""子用户访问策略
        :rtype: str
        """
        return self._PolicyDocument

    @PolicyDocument.setter
    def PolicyDocument(self, PolicyDocument):
        self._PolicyDocument = PolicyDocument

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._PolicyDocument = params.get("PolicyDocument")
        self._RequestId = params.get("RequestId")


class DescribeTablePartitionsRequest(AbstractModel):
    r"""DescribeTablePartitions请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Catalog: 数据目录名称
        :type Catalog: str
        :param _Database: 数据库名称
        :type Database: str
        :param _Table: 数据表名称
        :type Table: str
        :param _Offset: 查询偏移位置
        :type Offset: int
        :param _Limit: 当次查询的数量限制
        :type Limit: int
        :param _FuzzyPartition: 模糊查询的分区名称
        :type FuzzyPartition: str
        :param _Sorts: 排序信息
        :type Sorts: list of Sort
        :param _Cursor: 分页查询的游标信息
        :type Cursor: str
        """
        self._Catalog = None
        self._Database = None
        self._Table = None
        self._Offset = None
        self._Limit = None
        self._FuzzyPartition = None
        self._Sorts = None
        self._Cursor = None

    @property
    def Catalog(self):
        r"""数据目录名称
        :rtype: str
        """
        return self._Catalog

    @Catalog.setter
    def Catalog(self, Catalog):
        self._Catalog = Catalog

    @property
    def Database(self):
        r"""数据库名称
        :rtype: str
        """
        return self._Database

    @Database.setter
    def Database(self, Database):
        self._Database = Database

    @property
    def Table(self):
        r"""数据表名称
        :rtype: str
        """
        return self._Table

    @Table.setter
    def Table(self, Table):
        self._Table = Table

    @property
    def Offset(self):
        r"""查询偏移位置
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""当次查询的数量限制
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def FuzzyPartition(self):
        r"""模糊查询的分区名称
        :rtype: str
        """
        return self._FuzzyPartition

    @FuzzyPartition.setter
    def FuzzyPartition(self, FuzzyPartition):
        self._FuzzyPartition = FuzzyPartition

    @property
    def Sorts(self):
        r"""排序信息
        :rtype: list of Sort
        """
        return self._Sorts

    @Sorts.setter
    def Sorts(self, Sorts):
        self._Sorts = Sorts

    @property
    def Cursor(self):
        r"""分页查询的游标信息
        :rtype: str
        """
        return self._Cursor

    @Cursor.setter
    def Cursor(self, Cursor):
        self._Cursor = Cursor


    def _deserialize(self, params):
        self._Catalog = params.get("Catalog")
        self._Database = params.get("Database")
        self._Table = params.get("Table")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._FuzzyPartition = params.get("FuzzyPartition")
        if params.get("Sorts") is not None:
            self._Sorts = []
            for item in params.get("Sorts"):
                obj = Sort()
                obj._deserialize(item)
                self._Sorts.append(obj)
        self._Cursor = params.get("Cursor")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTablePartitionsResponse(AbstractModel):
    r"""DescribeTablePartitions返回参数结构体

    """

    def __init__(self):
        r"""
        :param _MixedPartitions: 分区信息值
        :type MixedPartitions: :class:`tencentcloud.dlc.v20210125.models.MixedTablePartitions`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._MixedPartitions = None
        self._RequestId = None

    @property
    def MixedPartitions(self):
        r"""分区信息值
        :rtype: :class:`tencentcloud.dlc.v20210125.models.MixedTablePartitions`
        """
        return self._MixedPartitions

    @MixedPartitions.setter
    def MixedPartitions(self, MixedPartitions):
        self._MixedPartitions = MixedPartitions

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("MixedPartitions") is not None:
            self._MixedPartitions = MixedTablePartitions()
            self._MixedPartitions._deserialize(params.get("MixedPartitions"))
        self._RequestId = params.get("RequestId")


class DescribeTableRequest(AbstractModel):
    r"""DescribeTable请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TableName: 查询对象表名称
        :type TableName: str
        :param _DatabaseName: 查询表所在的数据库名称。
        :type DatabaseName: str
        :param _DatasourceConnectionName: 查询表所在的数据源名称
        :type DatasourceConnectionName: str
        """
        self._TableName = None
        self._DatabaseName = None
        self._DatasourceConnectionName = None

    @property
    def TableName(self):
        r"""查询对象表名称
        :rtype: str
        """
        return self._TableName

    @TableName.setter
    def TableName(self, TableName):
        self._TableName = TableName

    @property
    def DatabaseName(self):
        r"""查询表所在的数据库名称。
        :rtype: str
        """
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def DatasourceConnectionName(self):
        r"""查询表所在的数据源名称
        :rtype: str
        """
        return self._DatasourceConnectionName

    @DatasourceConnectionName.setter
    def DatasourceConnectionName(self, DatasourceConnectionName):
        self._DatasourceConnectionName = DatasourceConnectionName


    def _deserialize(self, params):
        self._TableName = params.get("TableName")
        self._DatabaseName = params.get("DatabaseName")
        self._DatasourceConnectionName = params.get("DatasourceConnectionName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTableResponse(AbstractModel):
    r"""DescribeTable返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Table: 数据表对象
        :type Table: :class:`tencentcloud.dlc.v20210125.models.TableResponseInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Table = None
        self._RequestId = None

    @property
    def Table(self):
        r"""数据表对象
        :rtype: :class:`tencentcloud.dlc.v20210125.models.TableResponseInfo`
        """
        return self._Table

    @Table.setter
    def Table(self, Table):
        self._Table = Table

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Table") is not None:
            self._Table = TableResponseInfo()
            self._Table._deserialize(params.get("Table"))
        self._RequestId = params.get("RequestId")


class DescribeTablesNameRequest(AbstractModel):
    r"""DescribeTablesName请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DatabaseName: 列出该数据库下所属数据表。
        :type DatabaseName: str
        :param _Limit: 返回数量，默认为10，最大值为100。
        :type Limit: int
        :param _Offset: 数据偏移量，从0开始，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件，如下支持的过滤类型，传参Name应为其一
table-name - String - （过滤条件）数据表名称,形如：table-001。
table-id - String - （过滤条件）table id形如：12342。
        :type Filters: list of Filter
        :param _DatasourceConnectionName: 指定查询的数据源名称，默认为DataLakeCatalog
        :type DatasourceConnectionName: str
        :param _StartTime: 起始时间：用于对更新时间的筛选，格式为yyyy-mm-dd HH:MM:SS
        :type StartTime: str
        :param _EndTime: 终止时间：用于对更新时间的筛选，格式为yyyy-mm-dd HH:MM:SS
        :type EndTime: str
        :param _Sort: 排序字段，支持：CreateTime（创建时间）、UpdateTime（更新时间）、StorageSize（存储空间）、RecordCount（行数）、Name（表名称）（不传则默认按name升序）
        :type Sort: str
        :param _Asc: 排序字段，false：降序（默认）；true：升序
        :type Asc: bool
        :param _TableType: table type，表类型查询,可用值:EXTERNAL_TABLE,INDEX_TABLE,MANAGED_TABLE,MATERIALIZED_VIEW,TABLE,VIEW,VIRTUAL_VIEW
        :type TableType: str
        :param _TableFormat: 筛选字段-表格式：不传（默认）为查全部；LAKEFS：托管表；ICEBERG：非托管iceberg表；HIVE：非托管hive表；OTHER：非托管其它；
        :type TableFormat: str
        """
        self._DatabaseName = None
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._DatasourceConnectionName = None
        self._StartTime = None
        self._EndTime = None
        self._Sort = None
        self._Asc = None
        self._TableType = None
        self._TableFormat = None

    @property
    def DatabaseName(self):
        r"""列出该数据库下所属数据表。
        :rtype: str
        """
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def Limit(self):
        r"""返回数量，默认为10，最大值为100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""数据偏移量，从0开始，默认为0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        r"""过滤条件，如下支持的过滤类型，传参Name应为其一
table-name - String - （过滤条件）数据表名称,形如：table-001。
table-id - String - （过滤条件）table id形如：12342。
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def DatasourceConnectionName(self):
        r"""指定查询的数据源名称，默认为DataLakeCatalog
        :rtype: str
        """
        return self._DatasourceConnectionName

    @DatasourceConnectionName.setter
    def DatasourceConnectionName(self, DatasourceConnectionName):
        self._DatasourceConnectionName = DatasourceConnectionName

    @property
    def StartTime(self):
        r"""起始时间：用于对更新时间的筛选，格式为yyyy-mm-dd HH:MM:SS
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""终止时间：用于对更新时间的筛选，格式为yyyy-mm-dd HH:MM:SS
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Sort(self):
        r"""排序字段，支持：CreateTime（创建时间）、UpdateTime（更新时间）、StorageSize（存储空间）、RecordCount（行数）、Name（表名称）（不传则默认按name升序）
        :rtype: str
        """
        return self._Sort

    @Sort.setter
    def Sort(self, Sort):
        self._Sort = Sort

    @property
    def Asc(self):
        r"""排序字段，false：降序（默认）；true：升序
        :rtype: bool
        """
        return self._Asc

    @Asc.setter
    def Asc(self, Asc):
        self._Asc = Asc

    @property
    def TableType(self):
        r"""table type，表类型查询,可用值:EXTERNAL_TABLE,INDEX_TABLE,MANAGED_TABLE,MATERIALIZED_VIEW,TABLE,VIEW,VIRTUAL_VIEW
        :rtype: str
        """
        return self._TableType

    @TableType.setter
    def TableType(self, TableType):
        self._TableType = TableType

    @property
    def TableFormat(self):
        r"""筛选字段-表格式：不传（默认）为查全部；LAKEFS：托管表；ICEBERG：非托管iceberg表；HIVE：非托管hive表；OTHER：非托管其它；
        :rtype: str
        """
        return self._TableFormat

    @TableFormat.setter
    def TableFormat(self, TableFormat):
        self._TableFormat = TableFormat


    def _deserialize(self, params):
        self._DatabaseName = params.get("DatabaseName")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._DatasourceConnectionName = params.get("DatasourceConnectionName")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Sort = params.get("Sort")
        self._Asc = params.get("Asc")
        self._TableType = params.get("TableType")
        self._TableFormat = params.get("TableFormat")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTablesNameResponse(AbstractModel):
    r"""DescribeTablesName返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TableNameList: 数据表名称对象列表。
        :type TableNameList: list of str
        :param _TotalCount: 实例总数。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TableNameList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def TableNameList(self):
        r"""数据表名称对象列表。
        :rtype: list of str
        """
        return self._TableNameList

    @TableNameList.setter
    def TableNameList(self, TableNameList):
        self._TableNameList = TableNameList

    @property
    def TotalCount(self):
        r"""实例总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TableNameList = params.get("TableNameList")
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeTablesRequest(AbstractModel):
    r"""DescribeTables请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DatabaseName: 列出该数据库下所属数据表。
        :type DatabaseName: str
        :param _Limit: 返回数量，默认为10，最大值为100。
        :type Limit: int
        :param _Offset: 数据偏移量，从0开始，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件，如下支持的过滤类型，传参Name应为其一
table-name - String - （过滤条件）数据表名称,形如：table-001。
table-id - String - （过滤条件）table id形如：12342。
        :type Filters: list of Filter
        :param _DatasourceConnectionName: 指定查询的数据源名称，默认为DataLakeCatalog
        :type DatasourceConnectionName: str
        :param _StartTime: 起始时间：用于对更新时间的筛选，格式为yyyy-mm-dd HH:MM:SS
        :type StartTime: str
        :param _EndTime: 终止时间：用于对更新时间的筛选，格式为yyyy-mm-dd HH:MM:SS
        :type EndTime: str
        :param _Sort: 排序字段，支持：CreateTime（创建时间）、UpdateTime（更新时间）、StorageSize（存储空间）、RecordCount（行数）、Name（表名称）（不传则默认按name升序）
        :type Sort: str
        :param _Asc: 排序字段，false：降序（默认）；true：升序
        :type Asc: bool
        :param _TableType: table type，表类型查询,可用值:EXTERNAL_TABLE,INDEX_TABLE,MANAGED_TABLE,MATERIALIZED_VIEW,TABLE,VIEW,VIRTUAL_VIEW
        :type TableType: str
        :param _TableFormat: 筛选字段-表格式：不传（默认）为查全部；LAKEFS：托管表；ICEBERG：非托管iceberg表；HIVE：非托管hive表；OTHER：非托管其它；
        :type TableFormat: str
        :param _DescribeType: 查询类型：all：全部数据（默认）、permission：有权限的数据
注意：此字段需要开启白名单使用，如果需要使用，请提交工单联系我们。
        :type DescribeType: str
        """
        self._DatabaseName = None
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._DatasourceConnectionName = None
        self._StartTime = None
        self._EndTime = None
        self._Sort = None
        self._Asc = None
        self._TableType = None
        self._TableFormat = None
        self._DescribeType = None

    @property
    def DatabaseName(self):
        r"""列出该数据库下所属数据表。
        :rtype: str
        """
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def Limit(self):
        r"""返回数量，默认为10，最大值为100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""数据偏移量，从0开始，默认为0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        r"""过滤条件，如下支持的过滤类型，传参Name应为其一
table-name - String - （过滤条件）数据表名称,形如：table-001。
table-id - String - （过滤条件）table id形如：12342。
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def DatasourceConnectionName(self):
        r"""指定查询的数据源名称，默认为DataLakeCatalog
        :rtype: str
        """
        return self._DatasourceConnectionName

    @DatasourceConnectionName.setter
    def DatasourceConnectionName(self, DatasourceConnectionName):
        self._DatasourceConnectionName = DatasourceConnectionName

    @property
    def StartTime(self):
        r"""起始时间：用于对更新时间的筛选，格式为yyyy-mm-dd HH:MM:SS
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""终止时间：用于对更新时间的筛选，格式为yyyy-mm-dd HH:MM:SS
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Sort(self):
        r"""排序字段，支持：CreateTime（创建时间）、UpdateTime（更新时间）、StorageSize（存储空间）、RecordCount（行数）、Name（表名称）（不传则默认按name升序）
        :rtype: str
        """
        return self._Sort

    @Sort.setter
    def Sort(self, Sort):
        self._Sort = Sort

    @property
    def Asc(self):
        r"""排序字段，false：降序（默认）；true：升序
        :rtype: bool
        """
        return self._Asc

    @Asc.setter
    def Asc(self, Asc):
        self._Asc = Asc

    @property
    def TableType(self):
        r"""table type，表类型查询,可用值:EXTERNAL_TABLE,INDEX_TABLE,MANAGED_TABLE,MATERIALIZED_VIEW,TABLE,VIEW,VIRTUAL_VIEW
        :rtype: str
        """
        return self._TableType

    @TableType.setter
    def TableType(self, TableType):
        self._TableType = TableType

    @property
    def TableFormat(self):
        r"""筛选字段-表格式：不传（默认）为查全部；LAKEFS：托管表；ICEBERG：非托管iceberg表；HIVE：非托管hive表；OTHER：非托管其它；
        :rtype: str
        """
        return self._TableFormat

    @TableFormat.setter
    def TableFormat(self, TableFormat):
        self._TableFormat = TableFormat

    @property
    def DescribeType(self):
        r"""查询类型：all：全部数据（默认）、permission：有权限的数据
注意：此字段需要开启白名单使用，如果需要使用，请提交工单联系我们。
        :rtype: str
        """
        return self._DescribeType

    @DescribeType.setter
    def DescribeType(self, DescribeType):
        self._DescribeType = DescribeType


    def _deserialize(self, params):
        self._DatabaseName = params.get("DatabaseName")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._DatasourceConnectionName = params.get("DatasourceConnectionName")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Sort = params.get("Sort")
        self._Asc = params.get("Asc")
        self._TableType = params.get("TableType")
        self._TableFormat = params.get("TableFormat")
        self._DescribeType = params.get("DescribeType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTablesResponse(AbstractModel):
    r"""DescribeTables返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TableList: 数据表对象列表。
        :type TableList: list of TableResponseInfo
        :param _TotalCount: 实例总数。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TableList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def TableList(self):
        r"""数据表对象列表。
        :rtype: list of TableResponseInfo
        """
        return self._TableList

    @TableList.setter
    def TableList(self, TableList):
        self._TableList = TableList

    @property
    def TotalCount(self):
        r"""实例总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TableList") is not None:
            self._TableList = []
            for item in params.get("TableList"):
                obj = TableResponseInfo()
                obj._deserialize(item)
                self._TableList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeTaskListRequest(AbstractModel):
    r"""DescribeTaskList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 返回数量，默认为10，最大值为100。
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件，如下支持的过滤类型，传参Name应为以下其中一个,其中task-id支持最大50个过滤个数，其他过滤参数支持的总数不超过5个。
task-id - String - （任务ID准确过滤）task-id取值形如：e386471f-139a-4e59-877f-50ece8135b99。
task-state - String - （任务状态过滤）取值范围 0(初始化)， 1(运行中)， 2(成功)， -1(失败)。
task-sql-keyword - String - （SQL语句关键字模糊过滤）取值形如：DROP TABLE。
task-operator- string （子uin过滤）
task-kind - string （任务类型过滤）
        :type Filters: list of Filter
        :param _SortBy: 排序字段，支持如下字段类型，create-time（创建时间，默认）、update-time（更新时间）
        :type SortBy: str
        :param _Sorting: 排序方式，desc表示正序，asc表示反序， 默认为asc。
        :type Sorting: str
        :param _StartTime: 起始时间点，格式为yyyy-mm-dd HH:MM:SS。默认为45天前的当前时刻
        :type StartTime: str
        :param _EndTime: 结束时间点，格式为yyyy-mm-dd HH:MM:SS时间跨度在(0,30天]，支持最近45天数据查询。默认为当前时刻
        :type EndTime: str
        :param _DataEngineName: 数据引擎名称，用于筛选
        :type DataEngineName: str
        :param _ResourceGroupName: spark引擎资源组名称
        :type ResourceGroupName: str
        :param _HouseIds: 引擎id列表
        :type HouseIds: list of str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._SortBy = None
        self._Sorting = None
        self._StartTime = None
        self._EndTime = None
        self._DataEngineName = None
        self._ResourceGroupName = None
        self._HouseIds = None

    @property
    def Limit(self):
        r"""返回数量，默认为10，最大值为100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""偏移量，默认为0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        r"""过滤条件，如下支持的过滤类型，传参Name应为以下其中一个,其中task-id支持最大50个过滤个数，其他过滤参数支持的总数不超过5个。
task-id - String - （任务ID准确过滤）task-id取值形如：e386471f-139a-4e59-877f-50ece8135b99。
task-state - String - （任务状态过滤）取值范围 0(初始化)， 1(运行中)， 2(成功)， -1(失败)。
task-sql-keyword - String - （SQL语句关键字模糊过滤）取值形如：DROP TABLE。
task-operator- string （子uin过滤）
task-kind - string （任务类型过滤）
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def SortBy(self):
        r"""排序字段，支持如下字段类型，create-time（创建时间，默认）、update-time（更新时间）
        :rtype: str
        """
        return self._SortBy

    @SortBy.setter
    def SortBy(self, SortBy):
        self._SortBy = SortBy

    @property
    def Sorting(self):
        r"""排序方式，desc表示正序，asc表示反序， 默认为asc。
        :rtype: str
        """
        return self._Sorting

    @Sorting.setter
    def Sorting(self, Sorting):
        self._Sorting = Sorting

    @property
    def StartTime(self):
        r"""起始时间点，格式为yyyy-mm-dd HH:MM:SS。默认为45天前的当前时刻
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""结束时间点，格式为yyyy-mm-dd HH:MM:SS时间跨度在(0,30天]，支持最近45天数据查询。默认为当前时刻
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def DataEngineName(self):
        r"""数据引擎名称，用于筛选
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName

    @property
    def ResourceGroupName(self):
        r"""spark引擎资源组名称
        :rtype: str
        """
        return self._ResourceGroupName

    @ResourceGroupName.setter
    def ResourceGroupName(self, ResourceGroupName):
        self._ResourceGroupName = ResourceGroupName

    @property
    def HouseIds(self):
        r"""引擎id列表
        :rtype: list of str
        """
        return self._HouseIds

    @HouseIds.setter
    def HouseIds(self, HouseIds):
        self._HouseIds = HouseIds


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._SortBy = params.get("SortBy")
        self._Sorting = params.get("Sorting")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._DataEngineName = params.get("DataEngineName")
        self._ResourceGroupName = params.get("ResourceGroupName")
        self._HouseIds = params.get("HouseIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskListResponse(AbstractModel):
    r"""DescribeTaskList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskList: 任务对象列表。
        :type TaskList: list of TaskFullRespInfo
        :param _TotalCount: 实例总数。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def TaskList(self):
        r"""任务对象列表。
        :rtype: list of TaskFullRespInfo
        """
        return self._TaskList

    @TaskList.setter
    def TaskList(self, TaskList):
        self._TaskList = TaskList

    @property
    def TotalCount(self):
        r"""实例总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TaskList") is not None:
            self._TaskList = []
            for item in params.get("TaskList"):
                obj = TaskFullRespInfo()
                obj._deserialize(item)
                self._TaskList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeTaskLogRequest(AbstractModel):
    r"""DescribeTaskLog请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 列表返回的Id
        :type TaskId: str
        :param _StartTime: 开始运行时间，unix时间戳（毫秒）
        :type StartTime: int
        :param _EndTime: 结束运行时间，unix时间戳（毫秒）
        :type EndTime: int
        :param _Limit: 分页大小，最大1000，配合Context一起使用
        :type Limit: int
        :param _Context: 下一次分页参数，第一次传空。透传上次接口返回的Context值，可获取后续更多日志，总计最多可获取1万条原始日志，过期时间1小时。
        :type Context: str
        :param _Asc: 是否升序排列，true:升序排序，false:倒序，默认false，倒序排列
        :type Asc: bool
        :param _Filters: 预览日志的通用过滤条件
        :type Filters: list of Filter
        :param _BatchId: SparkSQL任务唯一ID
        :type BatchId: str
        """
        self._TaskId = None
        self._StartTime = None
        self._EndTime = None
        self._Limit = None
        self._Context = None
        self._Asc = None
        self._Filters = None
        self._BatchId = None

    @property
    def TaskId(self):
        r"""列表返回的Id
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def StartTime(self):
        r"""开始运行时间，unix时间戳（毫秒）
        :rtype: int
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""结束运行时间，unix时间戳（毫秒）
        :rtype: int
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Limit(self):
        r"""分页大小，最大1000，配合Context一起使用
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Context(self):
        r"""下一次分页参数，第一次传空。透传上次接口返回的Context值，可获取后续更多日志，总计最多可获取1万条原始日志，过期时间1小时。
        :rtype: str
        """
        return self._Context

    @Context.setter
    def Context(self, Context):
        self._Context = Context

    @property
    def Asc(self):
        r"""是否升序排列，true:升序排序，false:倒序，默认false，倒序排列
        :rtype: bool
        """
        return self._Asc

    @Asc.setter
    def Asc(self, Asc):
        self._Asc = Asc

    @property
    def Filters(self):
        r"""预览日志的通用过滤条件
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def BatchId(self):
        r"""SparkSQL任务唯一ID
        :rtype: str
        """
        return self._BatchId

    @BatchId.setter
    def BatchId(self, BatchId):
        self._BatchId = BatchId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Limit = params.get("Limit")
        self._Context = params.get("Context")
        self._Asc = params.get("Asc")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._BatchId = params.get("BatchId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskLogResponse(AbstractModel):
    r"""DescribeTaskLog返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Context: 下一次分页参数
        :type Context: str
        :param _ListOver: 是否获取完结
        :type ListOver: bool
        :param _Results: 日志详情
        :type Results: list of JobLogResult
        :param _LogUrl: 日志url
        :type LogUrl: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Context = None
        self._ListOver = None
        self._Results = None
        self._LogUrl = None
        self._RequestId = None

    @property
    def Context(self):
        r"""下一次分页参数
        :rtype: str
        """
        return self._Context

    @Context.setter
    def Context(self, Context):
        self._Context = Context

    @property
    def ListOver(self):
        r"""是否获取完结
        :rtype: bool
        """
        return self._ListOver

    @ListOver.setter
    def ListOver(self, ListOver):
        self._ListOver = ListOver

    @property
    def Results(self):
        r"""日志详情
        :rtype: list of JobLogResult
        """
        return self._Results

    @Results.setter
    def Results(self, Results):
        self._Results = Results

    @property
    def LogUrl(self):
        r"""日志url
        :rtype: str
        """
        return self._LogUrl

    @LogUrl.setter
    def LogUrl(self, LogUrl):
        self._LogUrl = LogUrl

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Context = params.get("Context")
        self._ListOver = params.get("ListOver")
        if params.get("Results") is not None:
            self._Results = []
            for item in params.get("Results"):
                obj = JobLogResult()
                obj._deserialize(item)
                self._Results.append(obj)
        self._LogUrl = params.get("LogUrl")
        self._RequestId = params.get("RequestId")


class DescribeTaskMonitorInfosRequest(AbstractModel):
    r"""DescribeTaskMonitorInfos请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskIdList: 任务ID列表，上限50个
        :type TaskIdList: list of str
        :param _HouseName: 引擎名称
        :type HouseName: str
        :param _CreateTimeStart: 任务创建时间的起始时间
        :type CreateTimeStart: str
        :param _CreateTimeEnd: 任务创建时间的结束时间
        :type CreateTimeEnd: str
        :param _Limit: 每一页条数
        :type Limit: int
        :param _Offset: 偏移量
        :type Offset: int
        """
        self._TaskIdList = None
        self._HouseName = None
        self._CreateTimeStart = None
        self._CreateTimeEnd = None
        self._Limit = None
        self._Offset = None

    @property
    def TaskIdList(self):
        r"""任务ID列表，上限50个
        :rtype: list of str
        """
        return self._TaskIdList

    @TaskIdList.setter
    def TaskIdList(self, TaskIdList):
        self._TaskIdList = TaskIdList

    @property
    def HouseName(self):
        r"""引擎名称
        :rtype: str
        """
        return self._HouseName

    @HouseName.setter
    def HouseName(self, HouseName):
        self._HouseName = HouseName

    @property
    def CreateTimeStart(self):
        r"""任务创建时间的起始时间
        :rtype: str
        """
        return self._CreateTimeStart

    @CreateTimeStart.setter
    def CreateTimeStart(self, CreateTimeStart):
        self._CreateTimeStart = CreateTimeStart

    @property
    def CreateTimeEnd(self):
        r"""任务创建时间的结束时间
        :rtype: str
        """
        return self._CreateTimeEnd

    @CreateTimeEnd.setter
    def CreateTimeEnd(self, CreateTimeEnd):
        self._CreateTimeEnd = CreateTimeEnd

    @property
    def Limit(self):
        r"""每一页条数
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._TaskIdList = params.get("TaskIdList")
        self._HouseName = params.get("HouseName")
        self._CreateTimeStart = params.get("CreateTimeStart")
        self._CreateTimeEnd = params.get("CreateTimeEnd")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskMonitorInfosResponse(AbstractModel):
    r"""DescribeTaskMonitorInfos返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskMonitorInfoList: 任务监控信息列表
        :type TaskMonitorInfoList: list of TaskMonitorInfo
        :param _TotalCount: 任务总数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskMonitorInfoList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def TaskMonitorInfoList(self):
        r"""任务监控信息列表
        :rtype: list of TaskMonitorInfo
        """
        return self._TaskMonitorInfoList

    @TaskMonitorInfoList.setter
    def TaskMonitorInfoList(self, TaskMonitorInfoList):
        self._TaskMonitorInfoList = TaskMonitorInfoList

    @property
    def TotalCount(self):
        r"""任务总数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TaskMonitorInfoList") is not None:
            self._TaskMonitorInfoList = []
            for item in params.get("TaskMonitorInfoList"):
                obj = TaskMonitorInfo()
                obj._deserialize(item)
                self._TaskMonitorInfoList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeTaskResourceUsageRequest(AbstractModel):
    r"""DescribeTaskResourceUsage请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskInstanceId: 任务 id
        :type TaskInstanceId: str
        """
        self._TaskInstanceId = None

    @property
    def TaskInstanceId(self):
        r"""任务 id
        :rtype: str
        """
        return self._TaskInstanceId

    @TaskInstanceId.setter
    def TaskInstanceId(self, TaskInstanceId):
        self._TaskInstanceId = TaskInstanceId


    def _deserialize(self, params):
        self._TaskInstanceId = params.get("TaskInstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskResourceUsageResponse(AbstractModel):
    r"""DescribeTaskResourceUsage返回参数结构体

    """

    def __init__(self):
        r"""
        :param _CoreInfo: core 用量信息
        :type CoreInfo: :class:`tencentcloud.dlc.v20210125.models.CoreInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._CoreInfo = None
        self._RequestId = None

    @property
    def CoreInfo(self):
        r"""core 用量信息
        :rtype: :class:`tencentcloud.dlc.v20210125.models.CoreInfo`
        """
        return self._CoreInfo

    @CoreInfo.setter
    def CoreInfo(self, CoreInfo):
        self._CoreInfo = CoreInfo

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("CoreInfo") is not None:
            self._CoreInfo = CoreInfo()
            self._CoreInfo._deserialize(params.get("CoreInfo"))
        self._RequestId = params.get("RequestId")


class DescribeTaskResultRequest(AbstractModel):
    r"""DescribeTaskResult请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务唯一ID，仅支持30天内的任务
        :type TaskId: str
        :param _NextToken: 上一次请求响应返回的分页信息。第一次可以不带，从头开始返回数据，每次返回MaxResults字段设置的数据量。
        :type NextToken: str
        :param _MaxResults: 返回结果的最大行数，范围0~1000，默认为1000.
        :type MaxResults: int
        :param _IsTransformDataType: 是否转化数据类型
        :type IsTransformDataType: bool
        :param _DataFieldCutLen: 返回结果集中字段长度截取，如果字段值长度超过该长度则截取到该长度
        :type DataFieldCutLen: int
        """
        self._TaskId = None
        self._NextToken = None
        self._MaxResults = None
        self._IsTransformDataType = None
        self._DataFieldCutLen = None

    @property
    def TaskId(self):
        r"""任务唯一ID，仅支持30天内的任务
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def NextToken(self):
        r"""上一次请求响应返回的分页信息。第一次可以不带，从头开始返回数据，每次返回MaxResults字段设置的数据量。
        :rtype: str
        """
        return self._NextToken

    @NextToken.setter
    def NextToken(self, NextToken):
        self._NextToken = NextToken

    @property
    def MaxResults(self):
        r"""返回结果的最大行数，范围0~1000，默认为1000.
        :rtype: int
        """
        return self._MaxResults

    @MaxResults.setter
    def MaxResults(self, MaxResults):
        self._MaxResults = MaxResults

    @property
    def IsTransformDataType(self):
        r"""是否转化数据类型
        :rtype: bool
        """
        return self._IsTransformDataType

    @IsTransformDataType.setter
    def IsTransformDataType(self, IsTransformDataType):
        self._IsTransformDataType = IsTransformDataType

    @property
    def DataFieldCutLen(self):
        r"""返回结果集中字段长度截取，如果字段值长度超过该长度则截取到该长度
        :rtype: int
        """
        return self._DataFieldCutLen

    @DataFieldCutLen.setter
    def DataFieldCutLen(self, DataFieldCutLen):
        self._DataFieldCutLen = DataFieldCutLen


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._NextToken = params.get("NextToken")
        self._MaxResults = params.get("MaxResults")
        self._IsTransformDataType = params.get("IsTransformDataType")
        self._DataFieldCutLen = params.get("DataFieldCutLen")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskResultResponse(AbstractModel):
    r"""DescribeTaskResult返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskInfo: 查询的任务信息，返回为空表示输入任务ID对应的任务不存在。只有当任务状态为成功（2）的时候，才会返回任务的结果。
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskInfo: :class:`tencentcloud.dlc.v20210125.models.TaskResultInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskInfo = None
        self._RequestId = None

    @property
    def TaskInfo(self):
        r"""查询的任务信息，返回为空表示输入任务ID对应的任务不存在。只有当任务状态为成功（2）的时候，才会返回任务的结果。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.dlc.v20210125.models.TaskResultInfo`
        """
        return self._TaskInfo

    @TaskInfo.setter
    def TaskInfo(self, TaskInfo):
        self._TaskInfo = TaskInfo

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TaskInfo") is not None:
            self._TaskInfo = TaskResultInfo()
            self._TaskInfo._deserialize(params.get("TaskInfo"))
        self._RequestId = params.get("RequestId")


class DescribeTasksAnalysisRequest(AbstractModel):
    r"""DescribeTasksAnalysis请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DataEngineName: 数据引擎名称，用于筛选
        :type DataEngineName: str
        :param _Limit: 返回数量，默认为10，最大值为100。
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件，如下支持的过滤类型，传参Name应为以下其中一个: task-id - String - （任务ID准确过滤）task-id 取值形如：e386471f-139a-4e59-877f-50ece8135b99。task-state - String - （任务状态过滤）取值范围 0(初始化)， 1(运行中)， 2(成功)， -1(失败)，rule-id - String - （洞察类型）取值范围 SPARK-StageScheduleDelay（资源抢占）, SPARK-ShuffleFailure（Shuffle异常）, SPARK-SlowTask（慢task）, SPARK-DataSkew（数据倾斜）, SPARK-InsufficientResource（磁盘或内存不足）
        :type Filters: list of Filter
        :param _SortBy: 排序字段，支持如下字段类型，instance-start-time (任务开始时间）,job-time-sum （单位毫秒，引擎内执行耗时）,task-time-sum （CU资源消耗，单位秒）,input-bytes-sum（数据扫描总大小，单位bytes）,shuffle-read-bytes-sum（数据shuffle总大小，单位bytes）
        :type SortBy: str
        :param _Sorting: 排序方式，desc表示正序，asc表示反序， 默认为asc。
        :type Sorting: str
        :param _StartTime: 任务开始时间点，格式为yyyy-mm-dd HH:MM:SS时间跨度在(0,30天]，支持最近30天数据查询。默认为当前时刻
        :type StartTime: str
        :param _EndTime: 结束时间点，格式为yyyy-mm-dd HH:MM:SS时间跨度在(0,30天]，支持最近30天数据查询。默认为当前时刻
        :type EndTime: str
        """
        self._DataEngineName = None
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._SortBy = None
        self._Sorting = None
        self._StartTime = None
        self._EndTime = None

    @property
    def DataEngineName(self):
        r"""数据引擎名称，用于筛选
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName

    @property
    def Limit(self):
        r"""返回数量，默认为10，最大值为100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""偏移量，默认为0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        r"""过滤条件，如下支持的过滤类型，传参Name应为以下其中一个: task-id - String - （任务ID准确过滤）task-id 取值形如：e386471f-139a-4e59-877f-50ece8135b99。task-state - String - （任务状态过滤）取值范围 0(初始化)， 1(运行中)， 2(成功)， -1(失败)，rule-id - String - （洞察类型）取值范围 SPARK-StageScheduleDelay（资源抢占）, SPARK-ShuffleFailure（Shuffle异常）, SPARK-SlowTask（慢task）, SPARK-DataSkew（数据倾斜）, SPARK-InsufficientResource（磁盘或内存不足）
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def SortBy(self):
        r"""排序字段，支持如下字段类型，instance-start-time (任务开始时间）,job-time-sum （单位毫秒，引擎内执行耗时）,task-time-sum （CU资源消耗，单位秒）,input-bytes-sum（数据扫描总大小，单位bytes）,shuffle-read-bytes-sum（数据shuffle总大小，单位bytes）
        :rtype: str
        """
        return self._SortBy

    @SortBy.setter
    def SortBy(self, SortBy):
        self._SortBy = SortBy

    @property
    def Sorting(self):
        r"""排序方式，desc表示正序，asc表示反序， 默认为asc。
        :rtype: str
        """
        return self._Sorting

    @Sorting.setter
    def Sorting(self, Sorting):
        self._Sorting = Sorting

    @property
    def StartTime(self):
        r"""任务开始时间点，格式为yyyy-mm-dd HH:MM:SS时间跨度在(0,30天]，支持最近30天数据查询。默认为当前时刻
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""结束时间点，格式为yyyy-mm-dd HH:MM:SS时间跨度在(0,30天]，支持最近30天数据查询。默认为当前时刻
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._DataEngineName = params.get("DataEngineName")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._SortBy = params.get("SortBy")
        self._Sorting = params.get("Sorting")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTasksAnalysisResponse(AbstractModel):
    r"""DescribeTasksAnalysis返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskList: 洞察结果分页列表
        :type TaskList: list of AnalysisTaskResults
        :param _TotalCount: 洞察结果总数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def TaskList(self):
        r"""洞察结果分页列表
        :rtype: list of AnalysisTaskResults
        """
        return self._TaskList

    @TaskList.setter
    def TaskList(self, TaskList):
        self._TaskList = TaskList

    @property
    def TotalCount(self):
        r"""洞察结果总数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TaskList") is not None:
            self._TaskList = []
            for item in params.get("TaskList"):
                obj = AnalysisTaskResults()
                obj._deserialize(item)
                self._TaskList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeTasksCostInfoRequest(AbstractModel):
    r"""DescribeTasksCostInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件，如下支持的过滤类型，传参Name应为以下其中一个,其中task-id支持最大50个过滤个数，其他过滤参数支持的总数不超过5个。
task-id - String - （任务ID准确过滤）task-id取值形如：e386471f-139a-4e59-877f-50ece8135b99。
task-state - String - （任务状态过滤）取值范围 0(初始化)， 1(运行中)， 2(成功)， -1(失败)。
task-sql-keyword - String - （SQL语句关键字模糊过滤）取值形如：DROP TABLE。
task-operator- string （子uin过滤）
        :type Filters: list of Filter
        :param _StartTime: 起始时间点，格式为yyyy-mm-dd HH:MM:SS。默认为45天前的当前时刻
        :type StartTime: str
        :param _EndTime: 结束时间点，格式为yyyy-mm-dd HH:MM:SS时间跨度在(0,30天]，支持最近45天数据查询。默认为当前时刻
        :type EndTime: str
        :param _DataEngineName: 数据引擎名称，用于筛选
        :type DataEngineName: str
        :param _SearchAfter: 下一页的标识
        :type SearchAfter: str
        :param _PageSize: 每页的大小
        :type PageSize: int
        """
        self._Filters = None
        self._StartTime = None
        self._EndTime = None
        self._DataEngineName = None
        self._SearchAfter = None
        self._PageSize = None

    @property
    def Filters(self):
        r"""过滤条件，如下支持的过滤类型，传参Name应为以下其中一个,其中task-id支持最大50个过滤个数，其他过滤参数支持的总数不超过5个。
task-id - String - （任务ID准确过滤）task-id取值形如：e386471f-139a-4e59-877f-50ece8135b99。
task-state - String - （任务状态过滤）取值范围 0(初始化)， 1(运行中)， 2(成功)， -1(失败)。
task-sql-keyword - String - （SQL语句关键字模糊过滤）取值形如：DROP TABLE。
task-operator- string （子uin过滤）
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def StartTime(self):
        r"""起始时间点，格式为yyyy-mm-dd HH:MM:SS。默认为45天前的当前时刻
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""结束时间点，格式为yyyy-mm-dd HH:MM:SS时间跨度在(0,30天]，支持最近45天数据查询。默认为当前时刻
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def DataEngineName(self):
        r"""数据引擎名称，用于筛选
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName

    @property
    def SearchAfter(self):
        r"""下一页的标识
        :rtype: str
        """
        return self._SearchAfter

    @SearchAfter.setter
    def SearchAfter(self, SearchAfter):
        self._SearchAfter = SearchAfter

    @property
    def PageSize(self):
        r"""每页的大小
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._DataEngineName = params.get("DataEngineName")
        self._SearchAfter = params.get("SearchAfter")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTasksCostInfoResponse(AbstractModel):
    r"""DescribeTasksCostInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SearchAfter: 下一页的标识
        :type SearchAfter: str
        :param _Data: 返回的数据，字符串类型的二维数组，首行为列中文名称
        :type Data: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SearchAfter = None
        self._Data = None
        self._RequestId = None

    @property
    def SearchAfter(self):
        r"""下一页的标识
        :rtype: str
        """
        return self._SearchAfter

    @SearchAfter.setter
    def SearchAfter(self, SearchAfter):
        self._SearchAfter = SearchAfter

    @property
    def Data(self):
        r"""返回的数据，字符串类型的二维数组，首行为列中文名称
        :rtype: str
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SearchAfter = params.get("SearchAfter")
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DescribeTasksOverviewRequest(AbstractModel):
    r"""DescribeTasksOverview请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 开始时间
        :type StartTime: str
        :param _EndTime: 结束时间
        :type EndTime: str
        :param _Filters: 筛选条件
        :type Filters: list of Filter
        :param _DataEngineName: 引擎名
        :type DataEngineName: str
        :param _HouseIds: DataEngine-dm8bjs29
        :type HouseIds: list of str
        """
        self._StartTime = None
        self._EndTime = None
        self._Filters = None
        self._DataEngineName = None
        self._HouseIds = None

    @property
    def StartTime(self):
        r"""开始时间
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""结束时间
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Filters(self):
        r"""筛选条件
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def DataEngineName(self):
        r"""引擎名
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName

    @property
    def HouseIds(self):
        r"""DataEngine-dm8bjs29
        :rtype: list of str
        """
        return self._HouseIds

    @HouseIds.setter
    def HouseIds(self, HouseIds):
        self._HouseIds = HouseIds


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._DataEngineName = params.get("DataEngineName")
        self._HouseIds = params.get("HouseIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTasksOverviewResponse(AbstractModel):
    r"""DescribeTasksOverview返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TasksOverview: 各类任务个数大于0
        :type TasksOverview: :class:`tencentcloud.dlc.v20210125.models.TasksOverview`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TasksOverview = None
        self._RequestId = None

    @property
    def TasksOverview(self):
        r"""各类任务个数大于0
        :rtype: :class:`tencentcloud.dlc.v20210125.models.TasksOverview`
        """
        return self._TasksOverview

    @TasksOverview.setter
    def TasksOverview(self, TasksOverview):
        self._TasksOverview = TasksOverview

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TasksOverview") is not None:
            self._TasksOverview = TasksOverview()
            self._TasksOverview._deserialize(params.get("TasksOverview"))
        self._RequestId = params.get("RequestId")


class DescribeTasksRequest(AbstractModel):
    r"""DescribeTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 返回数量，默认为10，最大值为100。
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件，如下支持的过滤类型，传参Name应为以下其中一个,其中task-id支持最大50个过滤个数，其他过滤参数支持的总数不超过5个。
task-id - String - （任务ID准确过滤）task-id取值形如：e386471f-139a-4e59-877f-50ece8135b99。
task-state - String - （任务状态过滤）取值范围 0(初始化)， 1(运行中)， 2(成功)， -1(失败)。
task-sql-keyword - String - （SQL语句关键字模糊过滤）取值形如：DROP TABLE。
task-operator- string （子uin过滤）
task-kind - string （任务类型过滤）
        :type Filters: list of Filter
        :param _SortBy: 排序字段，支持如下字段类型，create-time（创建时间，默认）、update-time（更新时间）
        :type SortBy: str
        :param _Sorting: 排序方式，desc表示正序，asc表示反序， 默认为asc。
        :type Sorting: str
        :param _StartTime: 起始时间点，格式为yyyy-mm-dd HH:MM:SS。默认为45天前的当前时刻
        :type StartTime: str
        :param _EndTime: 结束时间点，格式为yyyy-mm-dd HH:MM:SS时间跨度在(0,30天]，支持最近45天数据查询。默认为当前时刻
        :type EndTime: str
        :param _DataEngineName: 数据引擎名称，用于筛选
        :type DataEngineName: str
        :param _ResourceGroupName: spark引擎资源组名称
        :type ResourceGroupName: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._SortBy = None
        self._Sorting = None
        self._StartTime = None
        self._EndTime = None
        self._DataEngineName = None
        self._ResourceGroupName = None

    @property
    def Limit(self):
        r"""返回数量，默认为10，最大值为100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""偏移量，默认为0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        r"""过滤条件，如下支持的过滤类型，传参Name应为以下其中一个,其中task-id支持最大50个过滤个数，其他过滤参数支持的总数不超过5个。
task-id - String - （任务ID准确过滤）task-id取值形如：e386471f-139a-4e59-877f-50ece8135b99。
task-state - String - （任务状态过滤）取值范围 0(初始化)， 1(运行中)， 2(成功)， -1(失败)。
task-sql-keyword - String - （SQL语句关键字模糊过滤）取值形如：DROP TABLE。
task-operator- string （子uin过滤）
task-kind - string （任务类型过滤）
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def SortBy(self):
        r"""排序字段，支持如下字段类型，create-time（创建时间，默认）、update-time（更新时间）
        :rtype: str
        """
        return self._SortBy

    @SortBy.setter
    def SortBy(self, SortBy):
        self._SortBy = SortBy

    @property
    def Sorting(self):
        r"""排序方式，desc表示正序，asc表示反序， 默认为asc。
        :rtype: str
        """
        return self._Sorting

    @Sorting.setter
    def Sorting(self, Sorting):
        self._Sorting = Sorting

    @property
    def StartTime(self):
        r"""起始时间点，格式为yyyy-mm-dd HH:MM:SS。默认为45天前的当前时刻
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""结束时间点，格式为yyyy-mm-dd HH:MM:SS时间跨度在(0,30天]，支持最近45天数据查询。默认为当前时刻
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def DataEngineName(self):
        r"""数据引擎名称，用于筛选
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName

    @property
    def ResourceGroupName(self):
        r"""spark引擎资源组名称
        :rtype: str
        """
        return self._ResourceGroupName

    @ResourceGroupName.setter
    def ResourceGroupName(self, ResourceGroupName):
        self._ResourceGroupName = ResourceGroupName


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._SortBy = params.get("SortBy")
        self._Sorting = params.get("Sorting")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._DataEngineName = params.get("DataEngineName")
        self._ResourceGroupName = params.get("ResourceGroupName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTasksResponse(AbstractModel):
    r"""DescribeTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskList: 任务对象列表。
        :type TaskList: list of TaskResponseInfo
        :param _TotalCount: 实例总数。
        :type TotalCount: int
        :param _TasksOverview: 任务概览信息
注意：此字段可能返回 null，表示取不到有效值。
        :type TasksOverview: :class:`tencentcloud.dlc.v20210125.models.TasksOverview`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskList = None
        self._TotalCount = None
        self._TasksOverview = None
        self._RequestId = None

    @property
    def TaskList(self):
        r"""任务对象列表。
        :rtype: list of TaskResponseInfo
        """
        return self._TaskList

    @TaskList.setter
    def TaskList(self, TaskList):
        self._TaskList = TaskList

    @property
    def TotalCount(self):
        r"""实例总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TasksOverview(self):
        r"""任务概览信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.dlc.v20210125.models.TasksOverview`
        """
        return self._TasksOverview

    @TasksOverview.setter
    def TasksOverview(self, TasksOverview):
        self._TasksOverview = TasksOverview

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TaskList") is not None:
            self._TaskList = []
            for item in params.get("TaskList"):
                obj = TaskResponseInfo()
                obj._deserialize(item)
                self._TaskList.append(obj)
        self._TotalCount = params.get("TotalCount")
        if params.get("TasksOverview") is not None:
            self._TasksOverview = TasksOverview()
            self._TasksOverview._deserialize(params.get("TasksOverview"))
        self._RequestId = params.get("RequestId")


class DescribeThirdPartyAccessUserRequest(AbstractModel):
    r"""DescribeThirdPartyAccessUser请求参数结构体

    """


class DescribeThirdPartyAccessUserResponse(AbstractModel):
    r"""DescribeThirdPartyAccessUser返回参数结构体

    """

    def __init__(self):
        r"""
        :param _UserInfo: 用户信息
        :type UserInfo: :class:`tencentcloud.dlc.v20210125.models.OpendThirdAccessUserInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._UserInfo = None
        self._RequestId = None

    @property
    def UserInfo(self):
        r"""用户信息
        :rtype: :class:`tencentcloud.dlc.v20210125.models.OpendThirdAccessUserInfo`
        """
        return self._UserInfo

    @UserInfo.setter
    def UserInfo(self, UserInfo):
        self._UserInfo = UserInfo

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("UserInfo") is not None:
            self._UserInfo = OpendThirdAccessUserInfo()
            self._UserInfo._deserialize(params.get("UserInfo"))
        self._RequestId = params.get("RequestId")


class DescribeUDFPolicyRequest(AbstractModel):
    r"""DescribeUDFPolicy请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: udf名称
        :type Name: str
        :param _DatabaseName: 数据库名(全局UDF：global-function)
        :type DatabaseName: str
        :param _CatalogName: 数据目录名
        :type CatalogName: str
        """
        self._Name = None
        self._DatabaseName = None
        self._CatalogName = None

    @property
    def Name(self):
        r"""udf名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def DatabaseName(self):
        r"""数据库名(全局UDF：global-function)
        :rtype: str
        """
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def CatalogName(self):
        r"""数据目录名
        :rtype: str
        """
        return self._CatalogName

    @CatalogName.setter
    def CatalogName(self, CatalogName):
        self._CatalogName = CatalogName


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._DatabaseName = params.get("DatabaseName")
        self._CatalogName = params.get("CatalogName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUDFPolicyResponse(AbstractModel):
    r"""DescribeUDFPolicy返回参数结构体

    """

    def __init__(self):
        r"""
        :param _UDFPolicyInfos: UDF权限信息
        :type UDFPolicyInfos: list of UDFPolicyInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._UDFPolicyInfos = None
        self._RequestId = None

    @property
    def UDFPolicyInfos(self):
        r"""UDF权限信息
        :rtype: list of UDFPolicyInfo
        """
        return self._UDFPolicyInfos

    @UDFPolicyInfos.setter
    def UDFPolicyInfos(self, UDFPolicyInfos):
        self._UDFPolicyInfos = UDFPolicyInfos

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("UDFPolicyInfos") is not None:
            self._UDFPolicyInfos = []
            for item in params.get("UDFPolicyInfos"):
                obj = UDFPolicyInfo()
                obj._deserialize(item)
                self._UDFPolicyInfos.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeUpdatableDataEnginesRequest(AbstractModel):
    r"""DescribeUpdatableDataEngines请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DataEngineConfigCommand: 引擎配置操作命令，UpdateSparkSQLLakefsPath 更新托管表路径，UpdateSparkSQLResultPath 更新结果桶路径
        :type DataEngineConfigCommand: str
        :param _UseLakeFs: 是否使用托管存储作为结果存储
        :type UseLakeFs: bool
        :param _CustomResultPath: 用户自定义结果存储路径
        :type CustomResultPath: str
        """
        self._DataEngineConfigCommand = None
        self._UseLakeFs = None
        self._CustomResultPath = None

    @property
    def DataEngineConfigCommand(self):
        r"""引擎配置操作命令，UpdateSparkSQLLakefsPath 更新托管表路径，UpdateSparkSQLResultPath 更新结果桶路径
        :rtype: str
        """
        return self._DataEngineConfigCommand

    @DataEngineConfigCommand.setter
    def DataEngineConfigCommand(self, DataEngineConfigCommand):
        self._DataEngineConfigCommand = DataEngineConfigCommand

    @property
    def UseLakeFs(self):
        r"""是否使用托管存储作为结果存储
        :rtype: bool
        """
        return self._UseLakeFs

    @UseLakeFs.setter
    def UseLakeFs(self, UseLakeFs):
        self._UseLakeFs = UseLakeFs

    @property
    def CustomResultPath(self):
        r"""用户自定义结果存储路径
        :rtype: str
        """
        return self._CustomResultPath

    @CustomResultPath.setter
    def CustomResultPath(self, CustomResultPath):
        self._CustomResultPath = CustomResultPath


    def _deserialize(self, params):
        self._DataEngineConfigCommand = params.get("DataEngineConfigCommand")
        self._UseLakeFs = params.get("UseLakeFs")
        self._CustomResultPath = params.get("CustomResultPath")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUpdatableDataEnginesResponse(AbstractModel):
    r"""DescribeUpdatableDataEngines返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DataEngineBasicInfos: 集群基础信息
        :type DataEngineBasicInfos: list of DataEngineBasicInfo
        :param _TotalCount: 集群个数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DataEngineBasicInfos = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def DataEngineBasicInfos(self):
        r"""集群基础信息
        :rtype: list of DataEngineBasicInfo
        """
        return self._DataEngineBasicInfos

    @DataEngineBasicInfos.setter
    def DataEngineBasicInfos(self, DataEngineBasicInfos):
        self._DataEngineBasicInfos = DataEngineBasicInfos

    @property
    def TotalCount(self):
        r"""集群个数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DataEngineBasicInfos") is not None:
            self._DataEngineBasicInfos = []
            for item in params.get("DataEngineBasicInfos"):
                obj = DataEngineBasicInfo()
                obj._deserialize(item)
                self._DataEngineBasicInfos.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeUserDataEngineConfigRequest(AbstractModel):
    r"""DescribeUserDataEngineConfig请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Sorting: 排序方式，desc表示倒序，asc表示正序
        :type Sorting: str
        :param _Limit: 返回数量，默认为10，最大值为100。
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _SortBy: 排序字段，支持如下字段类型，create-time
        :type SortBy: str
        :param _Filters: 过滤条件，如下支持的过滤类型，传参Name应为以下其中一个,每种过滤参数支持的过滤值不超过5个。
app-id - String - （appid过滤）
engine-id - String - （引擎ID过滤）
        :type Filters: list of Filter
        """
        self._Sorting = None
        self._Limit = None
        self._Offset = None
        self._SortBy = None
        self._Filters = None

    @property
    def Sorting(self):
        r"""排序方式，desc表示倒序，asc表示正序
        :rtype: str
        """
        return self._Sorting

    @Sorting.setter
    def Sorting(self, Sorting):
        self._Sorting = Sorting

    @property
    def Limit(self):
        r"""返回数量，默认为10，最大值为100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""偏移量，默认为0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def SortBy(self):
        r"""排序字段，支持如下字段类型，create-time
        :rtype: str
        """
        return self._SortBy

    @SortBy.setter
    def SortBy(self, SortBy):
        self._SortBy = SortBy

    @property
    def Filters(self):
        r"""过滤条件，如下支持的过滤类型，传参Name应为以下其中一个,每种过滤参数支持的过滤值不超过5个。
app-id - String - （appid过滤）
engine-id - String - （引擎ID过滤）
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Sorting = params.get("Sorting")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._SortBy = params.get("SortBy")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUserDataEngineConfigResponse(AbstractModel):
    r"""DescribeUserDataEngineConfig返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DataEngineConfigInstanceInfos: 用户引擎自定义配置项列表。
        :type DataEngineConfigInstanceInfos: list of DataEngineConfigInstanceInfo
        :param _TotalCount: 配置项总数。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DataEngineConfigInstanceInfos = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def DataEngineConfigInstanceInfos(self):
        r"""用户引擎自定义配置项列表。
        :rtype: list of DataEngineConfigInstanceInfo
        """
        return self._DataEngineConfigInstanceInfos

    @DataEngineConfigInstanceInfos.setter
    def DataEngineConfigInstanceInfos(self, DataEngineConfigInstanceInfos):
        self._DataEngineConfigInstanceInfos = DataEngineConfigInstanceInfos

    @property
    def TotalCount(self):
        r"""配置项总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DataEngineConfigInstanceInfos") is not None:
            self._DataEngineConfigInstanceInfos = []
            for item in params.get("DataEngineConfigInstanceInfos"):
                obj = DataEngineConfigInstanceInfo()
                obj._deserialize(item)
                self._DataEngineConfigInstanceInfos.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeUserInfoRequest(AbstractModel):
    r"""DescribeUserInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _UserId: 用户Id
        :type UserId: str
        :param _Type: 必传字段，查询的信息类型，Group：工作组 DataAuth：数据权限 EngineAuth:引擎权限 RowFilter：行级别权限
        :type Type: str
        :param _Filters: 查询的过滤条件。

当Type为Group时，支持Key为workgroup-name的模糊搜索；

当Type为DataAuth时，支持key：

policy-type：权限类型。

policy-source：数据来源。

data-name：库表的模糊搜索。

当Type为EngineAuth时，支持key：

policy-type：权限类型。

policy-source：数据来源。

engine-name：库表的模糊搜索。
        :type Filters: list of Filter
        :param _SortBy: 排序字段。

当Type为Group时，支持create-time、group-name

当Type为DataAuth时，支持create-time

当Type为EngineAuth时，支持create-time
        :type SortBy: str
        :param _Sorting: 排序方式，desc表示正序，asc表示反序， 默认为asc
        :type Sorting: str
        :param _Limit: 返回数量，默认20，最大值100
        :type Limit: int
        :param _Offset: 偏移量，默认为0
        :type Offset: int
        :param _AccountType: 用户来源类型TencentAccount（普通腾讯云用户） / EntraAccount（微软用户）
        :type AccountType: str
        """
        self._UserId = None
        self._Type = None
        self._Filters = None
        self._SortBy = None
        self._Sorting = None
        self._Limit = None
        self._Offset = None
        self._AccountType = None

    @property
    def UserId(self):
        r"""用户Id
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def Type(self):
        r"""必传字段，查询的信息类型，Group：工作组 DataAuth：数据权限 EngineAuth:引擎权限 RowFilter：行级别权限
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Filters(self):
        r"""查询的过滤条件。

当Type为Group时，支持Key为workgroup-name的模糊搜索；

当Type为DataAuth时，支持key：

policy-type：权限类型。

policy-source：数据来源。

data-name：库表的模糊搜索。

当Type为EngineAuth时，支持key：

policy-type：权限类型。

policy-source：数据来源。

engine-name：库表的模糊搜索。
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def SortBy(self):
        r"""排序字段。

当Type为Group时，支持create-time、group-name

当Type为DataAuth时，支持create-time

当Type为EngineAuth时，支持create-time
        :rtype: str
        """
        return self._SortBy

    @SortBy.setter
    def SortBy(self, SortBy):
        self._SortBy = SortBy

    @property
    def Sorting(self):
        r"""排序方式，desc表示正序，asc表示反序， 默认为asc
        :rtype: str
        """
        return self._Sorting

    @Sorting.setter
    def Sorting(self, Sorting):
        self._Sorting = Sorting

    @property
    def Limit(self):
        r"""返回数量，默认20，最大值100
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""偏移量，默认为0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def AccountType(self):
        r"""用户来源类型TencentAccount（普通腾讯云用户） / EntraAccount（微软用户）
        :rtype: str
        """
        return self._AccountType

    @AccountType.setter
    def AccountType(self, AccountType):
        self._AccountType = AccountType


    def _deserialize(self, params):
        self._UserId = params.get("UserId")
        self._Type = params.get("Type")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._SortBy = params.get("SortBy")
        self._Sorting = params.get("Sorting")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._AccountType = params.get("AccountType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUserInfoResponse(AbstractModel):
    r"""DescribeUserInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _UserInfo: 用户详细信息
注意：此字段可能返回 null，表示取不到有效值。
        :type UserInfo: :class:`tencentcloud.dlc.v20210125.models.UserDetailInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._UserInfo = None
        self._RequestId = None

    @property
    def UserInfo(self):
        r"""用户详细信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.dlc.v20210125.models.UserDetailInfo`
        """
        return self._UserInfo

    @UserInfo.setter
    def UserInfo(self, UserInfo):
        self._UserInfo = UserInfo

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("UserInfo") is not None:
            self._UserInfo = UserDetailInfo()
            self._UserInfo._deserialize(params.get("UserInfo"))
        self._RequestId = params.get("RequestId")


class DescribeUserRegisterTimeRequest(AbstractModel):
    r"""DescribeUserRegisterTime请求参数结构体

    """


class DescribeUserRegisterTimeResponse(AbstractModel):
    r"""DescribeUserRegisterTime返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RegisterTime: 用户注册时间
        :type RegisterTime: int
        :param _IsOldUser: 是否时老用户
        :type IsOldUser: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RegisterTime = None
        self._IsOldUser = None
        self._RequestId = None

    @property
    def RegisterTime(self):
        r"""用户注册时间
        :rtype: int
        """
        return self._RegisterTime

    @RegisterTime.setter
    def RegisterTime(self, RegisterTime):
        self._RegisterTime = RegisterTime

    @property
    def IsOldUser(self):
        r"""是否时老用户
        :rtype: bool
        """
        return self._IsOldUser

    @IsOldUser.setter
    def IsOldUser(self, IsOldUser):
        self._IsOldUser = IsOldUser

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RegisterTime = params.get("RegisterTime")
        self._IsOldUser = params.get("IsOldUser")
        self._RequestId = params.get("RequestId")


class DescribeUserRolesRequest(AbstractModel):
    r"""DescribeUserRoles请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 列举的数量限制
        :type Limit: int
        :param _Offset: 列举的偏移位置
        :type Offset: int
        :param _Fuzzy: 按照arn模糊列举
        :type Fuzzy: str
        :param _SortBy: 返回结果按照该字段排序
        :type SortBy: str
        :param _Sorting: 正序或者倒序，例如：desc
        :type Sorting: str
        :param _IsDefault: 是否设置为常驻：1非常驻（默认）、2常驻（仅能设置一个常驻）
        :type IsDefault: int
        """
        self._Limit = None
        self._Offset = None
        self._Fuzzy = None
        self._SortBy = None
        self._Sorting = None
        self._IsDefault = None

    @property
    def Limit(self):
        r"""列举的数量限制
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""列举的偏移位置
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Fuzzy(self):
        r"""按照arn模糊列举
        :rtype: str
        """
        return self._Fuzzy

    @Fuzzy.setter
    def Fuzzy(self, Fuzzy):
        self._Fuzzy = Fuzzy

    @property
    def SortBy(self):
        r"""返回结果按照该字段排序
        :rtype: str
        """
        return self._SortBy

    @SortBy.setter
    def SortBy(self, SortBy):
        self._SortBy = SortBy

    @property
    def Sorting(self):
        r"""正序或者倒序，例如：desc
        :rtype: str
        """
        return self._Sorting

    @Sorting.setter
    def Sorting(self, Sorting):
        self._Sorting = Sorting

    @property
    def IsDefault(self):
        r"""是否设置为常驻：1非常驻（默认）、2常驻（仅能设置一个常驻）
        :rtype: int
        """
        return self._IsDefault

    @IsDefault.setter
    def IsDefault(self, IsDefault):
        self._IsDefault = IsDefault


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Fuzzy = params.get("Fuzzy")
        self._SortBy = params.get("SortBy")
        self._Sorting = params.get("Sorting")
        self._IsDefault = params.get("IsDefault")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUserRolesResponse(AbstractModel):
    r"""DescribeUserRoles返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Total: 符合列举条件的总数量
        :type Total: int
        :param _UserRoles: 用户角色信息
        :type UserRoles: list of UserRole
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Total = None
        self._UserRoles = None
        self._RequestId = None

    @property
    def Total(self):
        r"""符合列举条件的总数量
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def UserRoles(self):
        r"""用户角色信息
        :rtype: list of UserRole
        """
        return self._UserRoles

    @UserRoles.setter
    def UserRoles(self, UserRoles):
        self._UserRoles = UserRoles

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("UserRoles") is not None:
            self._UserRoles = []
            for item in params.get("UserRoles"):
                obj = UserRole()
                obj._deserialize(item)
                self._UserRoles.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeUserTypeRequest(AbstractModel):
    r"""DescribeUserType请求参数结构体

    """

    def __init__(self):
        r"""
        :param _UserId: 用户ID（UIN），如果不填默认为调用方的子UIN
        :type UserId: str
        :param _AccountType: 用户来源类型TencentAccount（普通腾讯云用户） / EntraAccount（微软用户）
        :type AccountType: str
        """
        self._UserId = None
        self._AccountType = None

    @property
    def UserId(self):
        r"""用户ID（UIN），如果不填默认为调用方的子UIN
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def AccountType(self):
        r"""用户来源类型TencentAccount（普通腾讯云用户） / EntraAccount（微软用户）
        :rtype: str
        """
        return self._AccountType

    @AccountType.setter
    def AccountType(self, AccountType):
        self._AccountType = AccountType


    def _deserialize(self, params):
        self._UserId = params.get("UserId")
        self._AccountType = params.get("AccountType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUserTypeResponse(AbstractModel):
    r"""DescribeUserType返回参数结构体

    """

    def __init__(self):
        r"""
        :param _UserType: 用户类型。ADMIN：管理员 COMMON：普通用户
        :type UserType: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._UserType = None
        self._RequestId = None

    @property
    def UserType(self):
        r"""用户类型。ADMIN：管理员 COMMON：普通用户
        :rtype: str
        """
        return self._UserType

    @UserType.setter
    def UserType(self, UserType):
        self._UserType = UserType

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._UserType = params.get("UserType")
        self._RequestId = params.get("RequestId")


class DescribeUserVpcConnectionRequest(AbstractModel):
    r"""DescribeUserVpcConnection请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EngineNetworkId: 引擎网络ID
        :type EngineNetworkId: str
        :param _DataEngineIds: 引擎ID集合
        :type DataEngineIds: list of str
        :param _UserVpcEndpointIds: 终端节点ID集合
        :type UserVpcEndpointIds: list of str
        """
        self._EngineNetworkId = None
        self._DataEngineIds = None
        self._UserVpcEndpointIds = None

    @property
    def EngineNetworkId(self):
        r"""引擎网络ID
        :rtype: str
        """
        return self._EngineNetworkId

    @EngineNetworkId.setter
    def EngineNetworkId(self, EngineNetworkId):
        self._EngineNetworkId = EngineNetworkId

    @property
    def DataEngineIds(self):
        r"""引擎ID集合
        :rtype: list of str
        """
        return self._DataEngineIds

    @DataEngineIds.setter
    def DataEngineIds(self, DataEngineIds):
        self._DataEngineIds = DataEngineIds

    @property
    def UserVpcEndpointIds(self):
        r"""终端节点ID集合
        :rtype: list of str
        """
        return self._UserVpcEndpointIds

    @UserVpcEndpointIds.setter
    def UserVpcEndpointIds(self, UserVpcEndpointIds):
        self._UserVpcEndpointIds = UserVpcEndpointIds


    def _deserialize(self, params):
        self._EngineNetworkId = params.get("EngineNetworkId")
        self._DataEngineIds = params.get("DataEngineIds")
        self._UserVpcEndpointIds = params.get("UserVpcEndpointIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUserVpcConnectionResponse(AbstractModel):
    r"""DescribeUserVpcConnection返回参数结构体

    """

    def __init__(self):
        r"""
        :param _UserVpcConnectionInfos: 用户vpc连接信息
注意：此字段可能返回 null，表示取不到有效值。
        :type UserVpcConnectionInfos: list of UserVpcConnectionInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._UserVpcConnectionInfos = None
        self._RequestId = None

    @property
    def UserVpcConnectionInfos(self):
        r"""用户vpc连接信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of UserVpcConnectionInfo
        """
        return self._UserVpcConnectionInfos

    @UserVpcConnectionInfos.setter
    def UserVpcConnectionInfos(self, UserVpcConnectionInfos):
        self._UserVpcConnectionInfos = UserVpcConnectionInfos

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("UserVpcConnectionInfos") is not None:
            self._UserVpcConnectionInfos = []
            for item in params.get("UserVpcConnectionInfos"):
                obj = UserVpcConnectionInfo()
                obj._deserialize(item)
                self._UserVpcConnectionInfos.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeUsersRequest(AbstractModel):
    r"""DescribeUsers请求参数结构体

    """

    def __init__(self):
        r"""
        :param _UserId: 指定查询的子用户uin，用户需要通过CreateUser接口创建。
        :type UserId: str
        :param _Offset: 偏移量，默认为0
        :type Offset: int
        :param _Limit: 返回数量，默认20，最大值100
        :type Limit: int
        :param _SortBy: 排序字段，支持如下字段类型，create-time
        :type SortBy: str
        :param _Sorting: 排序方式，desc表示正序，asc表示反序， 默认为asc
        :type Sorting: str
        :param _Filters: 过滤条件，支持如下字段类型，user-type：根据用户类型过滤。user-keyword：根据用户名称过滤
        :type Filters: list of Filter
        :param _AccountType: 用户来源类型TencentAccount（普通腾讯云用户） / EntraAccount（微软用户）
        :type AccountType: str
        """
        self._UserId = None
        self._Offset = None
        self._Limit = None
        self._SortBy = None
        self._Sorting = None
        self._Filters = None
        self._AccountType = None

    @property
    def UserId(self):
        r"""指定查询的子用户uin，用户需要通过CreateUser接口创建。
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def Offset(self):
        r"""偏移量，默认为0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回数量，默认20，最大值100
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def SortBy(self):
        r"""排序字段，支持如下字段类型，create-time
        :rtype: str
        """
        return self._SortBy

    @SortBy.setter
    def SortBy(self, SortBy):
        self._SortBy = SortBy

    @property
    def Sorting(self):
        r"""排序方式，desc表示正序，asc表示反序， 默认为asc
        :rtype: str
        """
        return self._Sorting

    @Sorting.setter
    def Sorting(self, Sorting):
        self._Sorting = Sorting

    @property
    def Filters(self):
        r"""过滤条件，支持如下字段类型，user-type：根据用户类型过滤。user-keyword：根据用户名称过滤
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def AccountType(self):
        r"""用户来源类型TencentAccount（普通腾讯云用户） / EntraAccount（微软用户）
        :rtype: str
        """
        return self._AccountType

    @AccountType.setter
    def AccountType(self, AccountType):
        self._AccountType = AccountType


    def _deserialize(self, params):
        self._UserId = params.get("UserId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._SortBy = params.get("SortBy")
        self._Sorting = params.get("Sorting")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._AccountType = params.get("AccountType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUsersResponse(AbstractModel):
    r"""DescribeUsers返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 查询到的用户总数
        :type TotalCount: int
        :param _UserSet: 查询到的授权用户信息集合
        :type UserSet: list of UserInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._UserSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""查询到的用户总数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def UserSet(self):
        r"""查询到的授权用户信息集合
        :rtype: list of UserInfo
        """
        return self._UserSet

    @UserSet.setter
    def UserSet(self, UserSet):
        self._UserSet = UserSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("UserSet") is not None:
            self._UserSet = []
            for item in params.get("UserSet"):
                obj = UserInfo()
                obj._deserialize(item)
                self._UserSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeViewsRequest(AbstractModel):
    r"""DescribeViews请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DatabaseName: 列出该数据库下所属数据表。
        :type DatabaseName: str
        :param _Limit: 返回数量，默认为10，最大值为100。
        :type Limit: int
        :param _Offset: 数据偏移量，从0开始，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件，如下支持的过滤类型，传参Name应为其一
view-name - String - （过滤条件）数据表名称,形如：view-001。
view-id - String - （过滤条件）view id形如：12342。
        :type Filters: list of Filter
        :param _DatasourceConnectionName: 数据库所属的数据源名称
        :type DatasourceConnectionName: str
        :param _Sort: 排序字段
        :type Sort: str
        :param _Asc: 排序规则，true:升序；false:降序
        :type Asc: bool
        :param _StartTime: 按视图更新时间筛选，开始时间，如2021-11-11 00:00:00
        :type StartTime: str
        :param _EndTime: 按视图更新时间筛选，结束时间，如2021-11-12 00:00:00
        :type EndTime: str
        :param _DescribeType: 查询类型：all：全部数据（默认）、permission：有权限的数据
注意：此字段需要开启白名单使用，如果需要使用，请提交工单联系我们。
        :type DescribeType: str
        """
        self._DatabaseName = None
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._DatasourceConnectionName = None
        self._Sort = None
        self._Asc = None
        self._StartTime = None
        self._EndTime = None
        self._DescribeType = None

    @property
    def DatabaseName(self):
        r"""列出该数据库下所属数据表。
        :rtype: str
        """
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def Limit(self):
        r"""返回数量，默认为10，最大值为100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""数据偏移量，从0开始，默认为0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        r"""过滤条件，如下支持的过滤类型，传参Name应为其一
view-name - String - （过滤条件）数据表名称,形如：view-001。
view-id - String - （过滤条件）view id形如：12342。
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def DatasourceConnectionName(self):
        r"""数据库所属的数据源名称
        :rtype: str
        """
        return self._DatasourceConnectionName

    @DatasourceConnectionName.setter
    def DatasourceConnectionName(self, DatasourceConnectionName):
        self._DatasourceConnectionName = DatasourceConnectionName

    @property
    def Sort(self):
        r"""排序字段
        :rtype: str
        """
        return self._Sort

    @Sort.setter
    def Sort(self, Sort):
        self._Sort = Sort

    @property
    def Asc(self):
        r"""排序规则，true:升序；false:降序
        :rtype: bool
        """
        return self._Asc

    @Asc.setter
    def Asc(self, Asc):
        self._Asc = Asc

    @property
    def StartTime(self):
        r"""按视图更新时间筛选，开始时间，如2021-11-11 00:00:00
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""按视图更新时间筛选，结束时间，如2021-11-12 00:00:00
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def DescribeType(self):
        r"""查询类型：all：全部数据（默认）、permission：有权限的数据
注意：此字段需要开启白名单使用，如果需要使用，请提交工单联系我们。
        :rtype: str
        """
        return self._DescribeType

    @DescribeType.setter
    def DescribeType(self, DescribeType):
        self._DescribeType = DescribeType


    def _deserialize(self, params):
        self._DatabaseName = params.get("DatabaseName")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._DatasourceConnectionName = params.get("DatasourceConnectionName")
        self._Sort = params.get("Sort")
        self._Asc = params.get("Asc")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._DescribeType = params.get("DescribeType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeViewsResponse(AbstractModel):
    r"""DescribeViews返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ViewList: 视图对象列表。
        :type ViewList: list of ViewResponseInfo
        :param _TotalCount: 实例总数。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ViewList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def ViewList(self):
        r"""视图对象列表。
        :rtype: list of ViewResponseInfo
        """
        return self._ViewList

    @ViewList.setter
    def ViewList(self, ViewList):
        self._ViewList = ViewList

    @property
    def TotalCount(self):
        r"""实例总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ViewList") is not None:
            self._ViewList = []
            for item in params.get("ViewList"):
                obj = ViewResponseInfo()
                obj._deserialize(item)
                self._ViewList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeWorkGroupInfoRequest(AbstractModel):
    r"""DescribeWorkGroupInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _WorkGroupId: 工作组Id
        :type WorkGroupId: int
        :param _Type: 查询信息类型：User：用户信息 DataAuth：数据权限 EngineAuth：引擎权限
        :type Type: str
        :param _Filters: 查询的过滤条件。

当Type为User时，支持Key为user-name的模糊搜索；

当Type为DataAuth时，支持key：

policy-type：权限类型。

policy-source：数据来源。

data-name：库表的模糊搜索。

当Type为EngineAuth时，支持key：

policy-type：权限类型。

policy-source：数据来源。

engine-name：库表的模糊搜索。
        :type Filters: list of Filter
        :param _SortBy: 排序字段。

当Type为User时，支持create-time、user-name

当Type为DataAuth时，支持create-time

当Type为EngineAuth时，支持create-time
        :type SortBy: str
        :param _Sorting: 排序方式，desc表示正序，asc表示反序， 默认为asc
        :type Sorting: str
        :param _Limit: 返回数量，默认20，最大值100
        :type Limit: int
        :param _Offset: 偏移量，默认为0
        :type Offset: int
        """
        self._WorkGroupId = None
        self._Type = None
        self._Filters = None
        self._SortBy = None
        self._Sorting = None
        self._Limit = None
        self._Offset = None

    @property
    def WorkGroupId(self):
        r"""工作组Id
        :rtype: int
        """
        return self._WorkGroupId

    @WorkGroupId.setter
    def WorkGroupId(self, WorkGroupId):
        self._WorkGroupId = WorkGroupId

    @property
    def Type(self):
        r"""查询信息类型：User：用户信息 DataAuth：数据权限 EngineAuth：引擎权限
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Filters(self):
        r"""查询的过滤条件。

当Type为User时，支持Key为user-name的模糊搜索；

当Type为DataAuth时，支持key：

policy-type：权限类型。

policy-source：数据来源。

data-name：库表的模糊搜索。

当Type为EngineAuth时，支持key：

policy-type：权限类型。

policy-source：数据来源。

engine-name：库表的模糊搜索。
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def SortBy(self):
        r"""排序字段。

当Type为User时，支持create-time、user-name

当Type为DataAuth时，支持create-time

当Type为EngineAuth时，支持create-time
        :rtype: str
        """
        return self._SortBy

    @SortBy.setter
    def SortBy(self, SortBy):
        self._SortBy = SortBy

    @property
    def Sorting(self):
        r"""排序方式，desc表示正序，asc表示反序， 默认为asc
        :rtype: str
        """
        return self._Sorting

    @Sorting.setter
    def Sorting(self, Sorting):
        self._Sorting = Sorting

    @property
    def Limit(self):
        r"""返回数量，默认20，最大值100
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""偏移量，默认为0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._WorkGroupId = params.get("WorkGroupId")
        self._Type = params.get("Type")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._SortBy = params.get("SortBy")
        self._Sorting = params.get("Sorting")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeWorkGroupInfoResponse(AbstractModel):
    r"""DescribeWorkGroupInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _WorkGroupInfo: 工作组详细信息
注意：此字段可能返回 null，表示取不到有效值。
        :type WorkGroupInfo: :class:`tencentcloud.dlc.v20210125.models.WorkGroupDetailInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._WorkGroupInfo = None
        self._RequestId = None

    @property
    def WorkGroupInfo(self):
        r"""工作组详细信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.dlc.v20210125.models.WorkGroupDetailInfo`
        """
        return self._WorkGroupInfo

    @WorkGroupInfo.setter
    def WorkGroupInfo(self, WorkGroupInfo):
        self._WorkGroupInfo = WorkGroupInfo

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("WorkGroupInfo") is not None:
            self._WorkGroupInfo = WorkGroupDetailInfo()
            self._WorkGroupInfo._deserialize(params.get("WorkGroupInfo"))
        self._RequestId = params.get("RequestId")


class DescribeWorkGroupsRequest(AbstractModel):
    r"""DescribeWorkGroups请求参数结构体

    """

    def __init__(self):
        r"""
        :param _WorkGroupId: 查询的工作组Id，不填或填0表示不过滤。
        :type WorkGroupId: int
        :param _Filters: 过滤条件，当前仅支持按照工作组名称进行模糊搜索。Key为workgroup-name
        :type Filters: list of Filter
        :param _Offset: 偏移量，默认为0
        :type Offset: int
        :param _Limit: 返回数量，默认20，最大值100
        :type Limit: int
        :param _SortBy: 排序字段，支持如下字段类型，create-time
        :type SortBy: str
        :param _Sorting: 排序方式，desc表示正序，asc表示反序， 默认为asc
        :type Sorting: str
        """
        self._WorkGroupId = None
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._SortBy = None
        self._Sorting = None

    @property
    def WorkGroupId(self):
        r"""查询的工作组Id，不填或填0表示不过滤。
        :rtype: int
        """
        return self._WorkGroupId

    @WorkGroupId.setter
    def WorkGroupId(self, WorkGroupId):
        self._WorkGroupId = WorkGroupId

    @property
    def Filters(self):
        r"""过滤条件，当前仅支持按照工作组名称进行模糊搜索。Key为workgroup-name
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""偏移量，默认为0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回数量，默认20，最大值100
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def SortBy(self):
        r"""排序字段，支持如下字段类型，create-time
        :rtype: str
        """
        return self._SortBy

    @SortBy.setter
    def SortBy(self, SortBy):
        self._SortBy = SortBy

    @property
    def Sorting(self):
        r"""排序方式，desc表示正序，asc表示反序， 默认为asc
        :rtype: str
        """
        return self._Sorting

    @Sorting.setter
    def Sorting(self, Sorting):
        self._Sorting = Sorting


    def _deserialize(self, params):
        self._WorkGroupId = params.get("WorkGroupId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._SortBy = params.get("SortBy")
        self._Sorting = params.get("Sorting")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeWorkGroupsResponse(AbstractModel):
    r"""DescribeWorkGroups返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 工作组总数
        :type TotalCount: int
        :param _WorkGroupSet: 工作组信息集合
        :type WorkGroupSet: list of WorkGroupInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._WorkGroupSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""工作组总数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def WorkGroupSet(self):
        r"""工作组信息集合
        :rtype: list of WorkGroupInfo
        """
        return self._WorkGroupSet

    @WorkGroupSet.setter
    def WorkGroupSet(self, WorkGroupSet):
        self._WorkGroupSet = WorkGroupSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("WorkGroupSet") is not None:
            self._WorkGroupSet = []
            for item in params.get("WorkGroupSet"):
                obj = WorkGroupInfo()
                obj._deserialize(item)
                self._WorkGroupSet.append(obj)
        self._RequestId = params.get("RequestId")


class DetachUserPolicyRequest(AbstractModel):
    r"""DetachUserPolicy请求参数结构体

    """

    def __init__(self):
        r"""
        :param _UserId: 用户Id，和CAM侧Uin匹配
        :type UserId: str
        :param _PolicySet: 解绑的权限集合
        :type PolicySet: list of Policy
        :param _AccountType: 用户来源类型TencentAccount（普通腾讯云用户） / EntraAccount（微软用户）
        :type AccountType: str
        """
        self._UserId = None
        self._PolicySet = None
        self._AccountType = None

    @property
    def UserId(self):
        r"""用户Id，和CAM侧Uin匹配
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def PolicySet(self):
        r"""解绑的权限集合
        :rtype: list of Policy
        """
        return self._PolicySet

    @PolicySet.setter
    def PolicySet(self, PolicySet):
        self._PolicySet = PolicySet

    @property
    def AccountType(self):
        r"""用户来源类型TencentAccount（普通腾讯云用户） / EntraAccount（微软用户）
        :rtype: str
        """
        return self._AccountType

    @AccountType.setter
    def AccountType(self, AccountType):
        self._AccountType = AccountType


    def _deserialize(self, params):
        self._UserId = params.get("UserId")
        if params.get("PolicySet") is not None:
            self._PolicySet = []
            for item in params.get("PolicySet"):
                obj = Policy()
                obj._deserialize(item)
                self._PolicySet.append(obj)
        self._AccountType = params.get("AccountType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DetachUserPolicyResponse(AbstractModel):
    r"""DetachUserPolicy返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DetachWorkGroupPolicyRequest(AbstractModel):
    r"""DetachWorkGroupPolicy请求参数结构体

    """

    def __init__(self):
        r"""
        :param _WorkGroupId: 工作组Id
        :type WorkGroupId: int
        :param _PolicySet: 解绑的权限集合
        :type PolicySet: list of Policy
        """
        self._WorkGroupId = None
        self._PolicySet = None

    @property
    def WorkGroupId(self):
        r"""工作组Id
        :rtype: int
        """
        return self._WorkGroupId

    @WorkGroupId.setter
    def WorkGroupId(self, WorkGroupId):
        self._WorkGroupId = WorkGroupId

    @property
    def PolicySet(self):
        r"""解绑的权限集合
        :rtype: list of Policy
        """
        return self._PolicySet

    @PolicySet.setter
    def PolicySet(self, PolicySet):
        self._PolicySet = PolicySet


    def _deserialize(self, params):
        self._WorkGroupId = params.get("WorkGroupId")
        if params.get("PolicySet") is not None:
            self._PolicySet = []
            for item in params.get("PolicySet"):
                obj = Policy()
                obj._deserialize(item)
                self._PolicySet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DetachWorkGroupPolicyResponse(AbstractModel):
    r"""DetachWorkGroupPolicy返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DropDMSDatabaseRequest(AbstractModel):
    r"""DropDMSDatabase请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 数据库名称
        :type Name: str
        :param _DeleteData: 是否删除数据
        :type DeleteData: bool
        :param _Cascade: 是否级联删除
        :type Cascade: bool
        :param _DatasourceConnectionName: 数据源连接名
        :type DatasourceConnectionName: str
        """
        self._Name = None
        self._DeleteData = None
        self._Cascade = None
        self._DatasourceConnectionName = None

    @property
    def Name(self):
        r"""数据库名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def DeleteData(self):
        r"""是否删除数据
        :rtype: bool
        """
        return self._DeleteData

    @DeleteData.setter
    def DeleteData(self, DeleteData):
        self._DeleteData = DeleteData

    @property
    def Cascade(self):
        r"""是否级联删除
        :rtype: bool
        """
        return self._Cascade

    @Cascade.setter
    def Cascade(self, Cascade):
        self._Cascade = Cascade

    @property
    def DatasourceConnectionName(self):
        r"""数据源连接名
        :rtype: str
        """
        return self._DatasourceConnectionName

    @DatasourceConnectionName.setter
    def DatasourceConnectionName(self, DatasourceConnectionName):
        self._DatasourceConnectionName = DatasourceConnectionName


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._DeleteData = params.get("DeleteData")
        self._Cascade = params.get("Cascade")
        self._DatasourceConnectionName = params.get("DatasourceConnectionName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DropDMSDatabaseResponse(AbstractModel):
    r"""DropDMSDatabase返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DropDMSPartitionsRequest(AbstractModel):
    r"""DropDMSPartitions请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DatabaseName: 数据库名称
        :type DatabaseName: str
        :param _SchemaName: 数据库Schema名称
        :type SchemaName: str
        :param _TableName: 数据表名称
        :type TableName: str
        :param _Name: 分区名称
        :type Name: str
        :param _Values: 单个分区名称
        :type Values: list of str
        :param _DeleteData: 是否删除分区数据
        :type DeleteData: bool
        :param _DatasourceConnectionName: 数据源连接名
        :type DatasourceConnectionName: str
        """
        self._DatabaseName = None
        self._SchemaName = None
        self._TableName = None
        self._Name = None
        self._Values = None
        self._DeleteData = None
        self._DatasourceConnectionName = None

    @property
    def DatabaseName(self):
        r"""数据库名称
        :rtype: str
        """
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def SchemaName(self):
        r"""数据库Schema名称
        :rtype: str
        """
        return self._SchemaName

    @SchemaName.setter
    def SchemaName(self, SchemaName):
        self._SchemaName = SchemaName

    @property
    def TableName(self):
        r"""数据表名称
        :rtype: str
        """
        return self._TableName

    @TableName.setter
    def TableName(self, TableName):
        self._TableName = TableName

    @property
    def Name(self):
        r"""分区名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Values(self):
        r"""单个分区名称
        :rtype: list of str
        """
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values

    @property
    def DeleteData(self):
        r"""是否删除分区数据
        :rtype: bool
        """
        return self._DeleteData

    @DeleteData.setter
    def DeleteData(self, DeleteData):
        self._DeleteData = DeleteData

    @property
    def DatasourceConnectionName(self):
        r"""数据源连接名
        :rtype: str
        """
        return self._DatasourceConnectionName

    @DatasourceConnectionName.setter
    def DatasourceConnectionName(self, DatasourceConnectionName):
        self._DatasourceConnectionName = DatasourceConnectionName


    def _deserialize(self, params):
        self._DatabaseName = params.get("DatabaseName")
        self._SchemaName = params.get("SchemaName")
        self._TableName = params.get("TableName")
        self._Name = params.get("Name")
        self._Values = params.get("Values")
        self._DeleteData = params.get("DeleteData")
        self._DatasourceConnectionName = params.get("DatasourceConnectionName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DropDMSPartitionsResponse(AbstractModel):
    r"""DropDMSPartitions返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Status: 状态
        :type Status: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Status = None
        self._RequestId = None

    @property
    def Status(self):
        r"""状态
        :rtype: bool
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._RequestId = params.get("RequestId")


class DropDMSTableRequest(AbstractModel):
    r"""DropDMSTable请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DbName: 数据库名称
        :type DbName: str
        :param _Name: 表名称
        :type Name: str
        :param _DeleteData: 是否删除数据
        :type DeleteData: bool
        :param _EnvProps: 环境属性
        :type EnvProps: :class:`tencentcloud.dlc.v20210125.models.KVPair`
        :param _DatasourceConnectionName: 数据目录信息
        :type DatasourceConnectionName: str
        """
        self._DbName = None
        self._Name = None
        self._DeleteData = None
        self._EnvProps = None
        self._DatasourceConnectionName = None

    @property
    def DbName(self):
        r"""数据库名称
        :rtype: str
        """
        return self._DbName

    @DbName.setter
    def DbName(self, DbName):
        self._DbName = DbName

    @property
    def Name(self):
        r"""表名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def DeleteData(self):
        r"""是否删除数据
        :rtype: bool
        """
        return self._DeleteData

    @DeleteData.setter
    def DeleteData(self, DeleteData):
        self._DeleteData = DeleteData

    @property
    def EnvProps(self):
        r"""环境属性
        :rtype: :class:`tencentcloud.dlc.v20210125.models.KVPair`
        """
        return self._EnvProps

    @EnvProps.setter
    def EnvProps(self, EnvProps):
        self._EnvProps = EnvProps

    @property
    def DatasourceConnectionName(self):
        r"""数据目录信息
        :rtype: str
        """
        return self._DatasourceConnectionName

    @DatasourceConnectionName.setter
    def DatasourceConnectionName(self, DatasourceConnectionName):
        self._DatasourceConnectionName = DatasourceConnectionName


    def _deserialize(self, params):
        self._DbName = params.get("DbName")
        self._Name = params.get("Name")
        self._DeleteData = params.get("DeleteData")
        if params.get("EnvProps") is not None:
            self._EnvProps = KVPair()
            self._EnvProps._deserialize(params.get("EnvProps"))
        self._DatasourceConnectionName = params.get("DatasourceConnectionName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DropDMSTableResponse(AbstractModel):
    r"""DropDMSTable返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ElasticPlan(AbstractModel):
    r"""引擎资源弹性伸缩计划

    """

    def __init__(self):
        r"""
        :param _MinElasticClusters: 最小集群数
        :type MinElasticClusters: int
        :param _MaxElasticClusters: 最大集群数
        :type MaxElasticClusters: int
        :param _TolerableQueueTime: 最大排队时间
        :type TolerableQueueTime: int
        :param _StartTime: 开始时间，Once格式：yyyy-MM-dd HH:mm:ss; 非Once格式： HH:mm:ss
        :type StartTime: str
        :param _EndTime: 结束时间，Once格式：yyyy-MM-dd HH:mm:ss; 非Once格式： HH:mm:ss
        :type EndTime: str
        :param _ElasticLimit: 分时弹性上限
        :type ElasticLimit: int
        """
        self._MinElasticClusters = None
        self._MaxElasticClusters = None
        self._TolerableQueueTime = None
        self._StartTime = None
        self._EndTime = None
        self._ElasticLimit = None

    @property
    def MinElasticClusters(self):
        r"""最小集群数
        :rtype: int
        """
        return self._MinElasticClusters

    @MinElasticClusters.setter
    def MinElasticClusters(self, MinElasticClusters):
        self._MinElasticClusters = MinElasticClusters

    @property
    def MaxElasticClusters(self):
        r"""最大集群数
        :rtype: int
        """
        return self._MaxElasticClusters

    @MaxElasticClusters.setter
    def MaxElasticClusters(self, MaxElasticClusters):
        self._MaxElasticClusters = MaxElasticClusters

    @property
    def TolerableQueueTime(self):
        r"""最大排队时间
        :rtype: int
        """
        return self._TolerableQueueTime

    @TolerableQueueTime.setter
    def TolerableQueueTime(self, TolerableQueueTime):
        self._TolerableQueueTime = TolerableQueueTime

    @property
    def StartTime(self):
        r"""开始时间，Once格式：yyyy-MM-dd HH:mm:ss; 非Once格式： HH:mm:ss
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""结束时间，Once格式：yyyy-MM-dd HH:mm:ss; 非Once格式： HH:mm:ss
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def ElasticLimit(self):
        r"""分时弹性上限
        :rtype: int
        """
        return self._ElasticLimit

    @ElasticLimit.setter
    def ElasticLimit(self, ElasticLimit):
        self._ElasticLimit = ElasticLimit


    def _deserialize(self, params):
        self._MinElasticClusters = params.get("MinElasticClusters")
        self._MaxElasticClusters = params.get("MaxElasticClusters")
        self._TolerableQueueTime = params.get("TolerableQueueTime")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._ElasticLimit = params.get("ElasticLimit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ElasticsearchInfo(AbstractModel):
    r"""Elasticsearch数据源的详细信息

    """

    def __init__(self):
        r"""
        :param _InstanceId: 数据源ID
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceId: str
        :param _InstanceName: 数据源名称
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceName: str
        :param _User: 用户名
注意：此字段可能返回 null，表示取不到有效值。
        :type User: str
        :param _Password: 密码，需要base64编码
注意：此字段可能返回 null，表示取不到有效值。
        :type Password: str
        :param _Location: 数据源的VPC和子网信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Location: :class:`tencentcloud.dlc.v20210125.models.DatasourceConnectionLocation`
        :param _DbName: 默认数据库名称
注意：此字段可能返回 null，表示取不到有效值。
        :type DbName: str
        :param _ServiceInfo: 访问Elasticsearch的ip、端口信息
注意：此字段可能返回 null，表示取不到有效值。
        :type ServiceInfo: list of IpPortPair
        """
        self._InstanceId = None
        self._InstanceName = None
        self._User = None
        self._Password = None
        self._Location = None
        self._DbName = None
        self._ServiceInfo = None

    @property
    def InstanceId(self):
        r"""数据源ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def InstanceName(self):
        r"""数据源名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def User(self):
        r"""用户名
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def Password(self):
        r"""密码，需要base64编码
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Password

    @Password.setter
    def Password(self, Password):
        self._Password = Password

    @property
    def Location(self):
        r"""数据源的VPC和子网信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.dlc.v20210125.models.DatasourceConnectionLocation`
        """
        return self._Location

    @Location.setter
    def Location(self, Location):
        self._Location = Location

    @property
    def DbName(self):
        r"""默认数据库名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DbName

    @DbName.setter
    def DbName(self, DbName):
        self._DbName = DbName

    @property
    def ServiceInfo(self):
        r"""访问Elasticsearch的ip、端口信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of IpPortPair
        """
        return self._ServiceInfo

    @ServiceInfo.setter
    def ServiceInfo(self, ServiceInfo):
        self._ServiceInfo = ServiceInfo


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._InstanceName = params.get("InstanceName")
        self._User = params.get("User")
        self._Password = params.get("Password")
        if params.get("Location") is not None:
            self._Location = DatasourceConnectionLocation()
            self._Location._deserialize(params.get("Location"))
        self._DbName = params.get("DbName")
        if params.get("ServiceInfo") is not None:
            self._ServiceInfo = []
            for item in params.get("ServiceInfo"):
                obj = IpPortPair()
                obj._deserialize(item)
                self._ServiceInfo.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EngineNetworkInfo(AbstractModel):
    r"""引擎网络信息

    """

    def __init__(self):
        r"""
        :param _EngineNetworkName: 引擎网络名字
注意：此字段可能返回 null，表示取不到有效值。
        :type EngineNetworkName: str
        :param _EngineNetworkState: 引擎网络状态，0--初始化，2--可用，-1--已删除
注意：此字段可能返回 null，表示取不到有效值。
        :type EngineNetworkState: int
        :param _EngineNetworkCidr: 引擎网络cidr
注意：此字段可能返回 null，表示取不到有效值。
        :type EngineNetworkCidr: str
        :param _EngineNetworkId: 引擎网络ID
注意：此字段可能返回 null，表示取不到有效值。
        :type EngineNetworkId: str
        :param _CreateTime: 创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: int
        :param _UpdateTime: 更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: int
        :param _PrivateLinkNumber: 私有连接个数
注意：此字段可能返回 null，表示取不到有效值。
        :type PrivateLinkNumber: int
        :param _EngineNumber: 计算引擎个数
注意：此字段可能返回 null，表示取不到有效值。
        :type EngineNumber: int
        :param _GateWayInfo: 网关信息
注意：此字段可能返回 null，表示取不到有效值。
        :type GateWayInfo: list of GatewayInfo
        """
        self._EngineNetworkName = None
        self._EngineNetworkState = None
        self._EngineNetworkCidr = None
        self._EngineNetworkId = None
        self._CreateTime = None
        self._UpdateTime = None
        self._PrivateLinkNumber = None
        self._EngineNumber = None
        self._GateWayInfo = None

    @property
    def EngineNetworkName(self):
        r"""引擎网络名字
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._EngineNetworkName

    @EngineNetworkName.setter
    def EngineNetworkName(self, EngineNetworkName):
        self._EngineNetworkName = EngineNetworkName

    @property
    def EngineNetworkState(self):
        r"""引擎网络状态，0--初始化，2--可用，-1--已删除
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._EngineNetworkState

    @EngineNetworkState.setter
    def EngineNetworkState(self, EngineNetworkState):
        self._EngineNetworkState = EngineNetworkState

    @property
    def EngineNetworkCidr(self):
        r"""引擎网络cidr
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._EngineNetworkCidr

    @EngineNetworkCidr.setter
    def EngineNetworkCidr(self, EngineNetworkCidr):
        self._EngineNetworkCidr = EngineNetworkCidr

    @property
    def EngineNetworkId(self):
        r"""引擎网络ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._EngineNetworkId

    @EngineNetworkId.setter
    def EngineNetworkId(self, EngineNetworkId):
        self._EngineNetworkId = EngineNetworkId

    @property
    def CreateTime(self):
        r"""创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def PrivateLinkNumber(self):
        r"""私有连接个数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._PrivateLinkNumber

    @PrivateLinkNumber.setter
    def PrivateLinkNumber(self, PrivateLinkNumber):
        self._PrivateLinkNumber = PrivateLinkNumber

    @property
    def EngineNumber(self):
        r"""计算引擎个数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._EngineNumber

    @EngineNumber.setter
    def EngineNumber(self, EngineNumber):
        self._EngineNumber = EngineNumber

    @property
    def GateWayInfo(self):
        r"""网关信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of GatewayInfo
        """
        return self._GateWayInfo

    @GateWayInfo.setter
    def GateWayInfo(self, GateWayInfo):
        self._GateWayInfo = GateWayInfo


    def _deserialize(self, params):
        self._EngineNetworkName = params.get("EngineNetworkName")
        self._EngineNetworkState = params.get("EngineNetworkState")
        self._EngineNetworkCidr = params.get("EngineNetworkCidr")
        self._EngineNetworkId = params.get("EngineNetworkId")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._PrivateLinkNumber = params.get("PrivateLinkNumber")
        self._EngineNumber = params.get("EngineNumber")
        if params.get("GateWayInfo") is not None:
            self._GateWayInfo = []
            for item in params.get("GateWayInfo"):
                obj = GatewayInfo()
                obj._deserialize(item)
                self._GateWayInfo.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EngineResourceGroupConfigPair(AbstractModel):
    r"""引擎资源组参数 配置项

    """

    def __init__(self):
        r"""
        :param _ConfigItem: 配置项
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigItem: str
        :param _ConfigValue: 配置项的值
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfigValue: str
        """
        self._ConfigItem = None
        self._ConfigValue = None

    @property
    def ConfigItem(self):
        r"""配置项
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ConfigItem

    @ConfigItem.setter
    def ConfigItem(self, ConfigItem):
        self._ConfigItem = ConfigItem

    @property
    def ConfigValue(self):
        r"""配置项的值
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ConfigValue

    @ConfigValue.setter
    def ConfigValue(self, ConfigValue):
        self._ConfigValue = ConfigValue


    def _deserialize(self, params):
        self._ConfigItem = params.get("ConfigItem")
        self._ConfigValue = params.get("ConfigValue")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EngineSessionImage(AbstractModel):
    r"""TensorFlow、Pytorch、SK-learn镜像信息列表

    """

    def __init__(self):
        r"""
        :param _SparkImageId: Spark镜像唯一id
注意：此字段可能返回 null，表示取不到有效值。
        :type SparkImageId: str
        :param _SparkImageVersion: Spark镜像版本名称
注意：此字段可能返回 null，表示取不到有效值。
        :type SparkImageVersion: str
        :param _SparkImageType: 小版本镜像类型.1:TensorFlow、2:Pytorch、3:SK-learn

注意：此字段可能返回 null，表示取不到有效值。
        :type SparkImageType: int
        :param _SparkImageTag: 镜像地址
注意：此字段可能返回 null，表示取不到有效值。
        :type SparkImageTag: str
        """
        self._SparkImageId = None
        self._SparkImageVersion = None
        self._SparkImageType = None
        self._SparkImageTag = None

    @property
    def SparkImageId(self):
        r"""Spark镜像唯一id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SparkImageId

    @SparkImageId.setter
    def SparkImageId(self, SparkImageId):
        self._SparkImageId = SparkImageId

    @property
    def SparkImageVersion(self):
        r"""Spark镜像版本名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SparkImageVersion

    @SparkImageVersion.setter
    def SparkImageVersion(self, SparkImageVersion):
        self._SparkImageVersion = SparkImageVersion

    @property
    def SparkImageType(self):
        r"""小版本镜像类型.1:TensorFlow、2:Pytorch、3:SK-learn

注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._SparkImageType

    @SparkImageType.setter
    def SparkImageType(self, SparkImageType):
        self._SparkImageType = SparkImageType

    @property
    def SparkImageTag(self):
        r"""镜像地址
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SparkImageTag

    @SparkImageTag.setter
    def SparkImageTag(self, SparkImageTag):
        self._SparkImageTag = SparkImageTag


    def _deserialize(self, params):
        self._SparkImageId = params.get("SparkImageId")
        self._SparkImageVersion = params.get("SparkImageVersion")
        self._SparkImageType = params.get("SparkImageType")
        self._SparkImageTag = params.get("SparkImageTag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Execution(AbstractModel):
    r"""SQL语句对象

    """

    def __init__(self):
        r"""
        :param _SQL: 自动生成SQL语句。
        :type SQL: str
        """
        self._SQL = None

    @property
    def SQL(self):
        r"""自动生成SQL语句。
        :rtype: str
        """
        return self._SQL

    @SQL.setter
    def SQL(self, SQL):
        self._SQL = SQL


    def _deserialize(self, params):
        self._SQL = params.get("SQL")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FavorInfo(AbstractModel):
    r"""FavorInfo

    """

    def __init__(self):
        r"""
        :param _Priority: 优先事项
        :type Priority: int
        :param _Catalog: Catalog名称
        :type Catalog: str
        :param _DataBase: DataBase名称
        :type DataBase: str
        :param _Table: Table名称
        :type Table: str
        """
        self._Priority = None
        self._Catalog = None
        self._DataBase = None
        self._Table = None

    @property
    def Priority(self):
        r"""优先事项
        :rtype: int
        """
        return self._Priority

    @Priority.setter
    def Priority(self, Priority):
        self._Priority = Priority

    @property
    def Catalog(self):
        r"""Catalog名称
        :rtype: str
        """
        return self._Catalog

    @Catalog.setter
    def Catalog(self, Catalog):
        self._Catalog = Catalog

    @property
    def DataBase(self):
        r"""DataBase名称
        :rtype: str
        """
        return self._DataBase

    @DataBase.setter
    def DataBase(self, DataBase):
        self._DataBase = DataBase

    @property
    def Table(self):
        r"""Table名称
        :rtype: str
        """
        return self._Table

    @Table.setter
    def Table(self, Table):
        self._Table = Table


    def _deserialize(self, params):
        self._Priority = params.get("Priority")
        self._Catalog = params.get("Catalog")
        self._DataBase = params.get("DataBase")
        self._Table = params.get("Table")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Filter(AbstractModel):
    r"""查询列表过滤条件参数

    """

    def __init__(self):
        r"""
        :param _Name: 属性名称, 若存在多个Filter时，Filter间的关系为逻辑或（OR）关系。
        :type Name: str
        :param _Values: 属性值, 若同一个Filter存在多个Values，同一Filter下Values间的关系为逻辑或（OR）关系。
        :type Values: list of str
        """
        self._Name = None
        self._Values = None

    @property
    def Name(self):
        r"""属性名称, 若存在多个Filter时，Filter间的关系为逻辑或（OR）关系。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Values(self):
        r"""属性值, 若同一个Filter存在多个Values，同一Filter下Values间的关系为逻辑或（OR）关系。
        :rtype: list of str
        """
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Values = params.get("Values")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GPUInfo(AbstractModel):
    r"""GPU 机型

    """

    def __init__(self):
        r"""
        :param _BillingItem: 计费项
        :type BillingItem: str
        :param _Model: 机型
        :type Model: str
        :param _CU: cu
        :type CU: int
        :param _Type: gpu 机型
        :type Type: str
        :param _Num: 数量
        :type Num: int
        :param _GPUMemory: 显存
        :type GPUMemory: int
        :param _InstanceType: 机型
        :type InstanceType: str
        :param _SaleStatus: 售卖情况（1-缺货，2-低库存，3-充足）
        :type SaleStatus: int
        """
        self._BillingItem = None
        self._Model = None
        self._CU = None
        self._Type = None
        self._Num = None
        self._GPUMemory = None
        self._InstanceType = None
        self._SaleStatus = None

    @property
    def BillingItem(self):
        r"""计费项
        :rtype: str
        """
        return self._BillingItem

    @BillingItem.setter
    def BillingItem(self, BillingItem):
        self._BillingItem = BillingItem

    @property
    def Model(self):
        r"""机型
        :rtype: str
        """
        return self._Model

    @Model.setter
    def Model(self, Model):
        self._Model = Model

    @property
    def CU(self):
        r"""cu
        :rtype: int
        """
        return self._CU

    @CU.setter
    def CU(self, CU):
        self._CU = CU

    @property
    def Type(self):
        r"""gpu 机型
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Num(self):
        r"""数量
        :rtype: int
        """
        return self._Num

    @Num.setter
    def Num(self, Num):
        self._Num = Num

    @property
    def GPUMemory(self):
        r"""显存
        :rtype: int
        """
        return self._GPUMemory

    @GPUMemory.setter
    def GPUMemory(self, GPUMemory):
        self._GPUMemory = GPUMemory

    @property
    def InstanceType(self):
        r"""机型
        :rtype: str
        """
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def SaleStatus(self):
        r"""售卖情况（1-缺货，2-低库存，3-充足）
        :rtype: int
        """
        return self._SaleStatus

    @SaleStatus.setter
    def SaleStatus(self, SaleStatus):
        self._SaleStatus = SaleStatus


    def _deserialize(self, params):
        self._BillingItem = params.get("BillingItem")
        self._Model = params.get("Model")
        self._CU = params.get("CU")
        self._Type = params.get("Type")
        self._Num = params.get("Num")
        self._GPUMemory = params.get("GPUMemory")
        self._InstanceType = params.get("InstanceType")
        self._SaleStatus = params.get("SaleStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GatewayInfo(AbstractModel):
    r"""网关基础信息，包括id，名称，规格和状态

    """

    def __init__(self):
        r"""
        :param _GatewayId: 网关ID，
注意：此字段可能返回 null，表示取不到有效值。
        :type GatewayId: str
        :param _GatewayName: 网关名称，全局唯一
注意：此字段可能返回 null，表示取不到有效值。
        :type GatewayName: str
        :param _Size: 网关的规格
注意：此字段可能返回 null，表示取不到有效值。
        :type Size: int
        :param _State: -2已删除 -1失败 0初始化中 1挂起 2运行中 3准备删除 4删除中 5挂起中 6启动中 7隔离中 8隔离 9续费中 10变配中 11冲正中
注意：此字段可能返回 null，表示取不到有效值。
        :type State: int
        :param _PayMode: 计费模式
注意：此字段可能返回 null，表示取不到有效值。
        :type PayMode: int
        :param _Mode: 模式
注意：此字段可能返回 null，表示取不到有效值。
        :type Mode: int
        """
        self._GatewayId = None
        self._GatewayName = None
        self._Size = None
        self._State = None
        self._PayMode = None
        self._Mode = None

    @property
    def GatewayId(self):
        r"""网关ID，
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._GatewayId

    @GatewayId.setter
    def GatewayId(self, GatewayId):
        self._GatewayId = GatewayId

    @property
    def GatewayName(self):
        r"""网关名称，全局唯一
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._GatewayName

    @GatewayName.setter
    def GatewayName(self, GatewayName):
        self._GatewayName = GatewayName

    @property
    def Size(self):
        r"""网关的规格
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size

    @property
    def State(self):
        r"""-2已删除 -1失败 0初始化中 1挂起 2运行中 3准备删除 4删除中 5挂起中 6启动中 7隔离中 8隔离 9续费中 10变配中 11冲正中
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def PayMode(self):
        r"""计费模式
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._PayMode

    @PayMode.setter
    def PayMode(self, PayMode):
        self._PayMode = PayMode

    @property
    def Mode(self):
        r"""模式
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode


    def _deserialize(self, params):
        self._GatewayId = params.get("GatewayId")
        self._GatewayName = params.get("GatewayName")
        self._Size = params.get("Size")
        self._State = params.get("State")
        self._PayMode = params.get("PayMode")
        self._Mode = params.get("Mode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GenerateCreateMangedTableSqlRequest(AbstractModel):
    r"""GenerateCreateMangedTableSql请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TableBaseInfo: 表基本信息
        :type TableBaseInfo: :class:`tencentcloud.dlc.v20210125.models.TableBaseInfo`
        :param _Columns: 表字段信息
        :type Columns: list of TColumn
        :param _Partitions: 表分区信息
        :type Partitions: list of TPartition
        :param _Properties: 表属性信息
        :type Properties: list of Property
        :param _UpsertKeys: V2 upsert表 upsert键
        :type UpsertKeys: list of str
        """
        self._TableBaseInfo = None
        self._Columns = None
        self._Partitions = None
        self._Properties = None
        self._UpsertKeys = None

    @property
    def TableBaseInfo(self):
        r"""表基本信息
        :rtype: :class:`tencentcloud.dlc.v20210125.models.TableBaseInfo`
        """
        return self._TableBaseInfo

    @TableBaseInfo.setter
    def TableBaseInfo(self, TableBaseInfo):
        self._TableBaseInfo = TableBaseInfo

    @property
    def Columns(self):
        r"""表字段信息
        :rtype: list of TColumn
        """
        return self._Columns

    @Columns.setter
    def Columns(self, Columns):
        self._Columns = Columns

    @property
    def Partitions(self):
        r"""表分区信息
        :rtype: list of TPartition
        """
        return self._Partitions

    @Partitions.setter
    def Partitions(self, Partitions):
        self._Partitions = Partitions

    @property
    def Properties(self):
        r"""表属性信息
        :rtype: list of Property
        """
        return self._Properties

    @Properties.setter
    def Properties(self, Properties):
        self._Properties = Properties

    @property
    def UpsertKeys(self):
        r"""V2 upsert表 upsert键
        :rtype: list of str
        """
        return self._UpsertKeys

    @UpsertKeys.setter
    def UpsertKeys(self, UpsertKeys):
        self._UpsertKeys = UpsertKeys


    def _deserialize(self, params):
        if params.get("TableBaseInfo") is not None:
            self._TableBaseInfo = TableBaseInfo()
            self._TableBaseInfo._deserialize(params.get("TableBaseInfo"))
        if params.get("Columns") is not None:
            self._Columns = []
            for item in params.get("Columns"):
                obj = TColumn()
                obj._deserialize(item)
                self._Columns.append(obj)
        if params.get("Partitions") is not None:
            self._Partitions = []
            for item in params.get("Partitions"):
                obj = TPartition()
                obj._deserialize(item)
                self._Partitions.append(obj)
        if params.get("Properties") is not None:
            self._Properties = []
            for item in params.get("Properties"):
                obj = Property()
                obj._deserialize(item)
                self._Properties.append(obj)
        self._UpsertKeys = params.get("UpsertKeys")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GenerateCreateMangedTableSqlResponse(AbstractModel):
    r"""GenerateCreateMangedTableSql返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Execution: 创建托管存储内表sql语句描述
        :type Execution: :class:`tencentcloud.dlc.v20210125.models.Execution`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Execution = None
        self._RequestId = None

    @property
    def Execution(self):
        r"""创建托管存储内表sql语句描述
        :rtype: :class:`tencentcloud.dlc.v20210125.models.Execution`
        """
        return self._Execution

    @Execution.setter
    def Execution(self, Execution):
        self._Execution = Execution

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Execution") is not None:
            self._Execution = Execution()
            self._Execution._deserialize(params.get("Execution"))
        self._RequestId = params.get("RequestId")


class GetOptimizerPolicyRequest(AbstractModel):
    r"""GetOptimizerPolicy请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SmartPolicy: 策略描述
        :type SmartPolicy: :class:`tencentcloud.dlc.v20210125.models.SmartPolicy`
        """
        self._SmartPolicy = None

    @property
    def SmartPolicy(self):
        r"""策略描述
        :rtype: :class:`tencentcloud.dlc.v20210125.models.SmartPolicy`
        """
        return self._SmartPolicy

    @SmartPolicy.setter
    def SmartPolicy(self, SmartPolicy):
        self._SmartPolicy = SmartPolicy


    def _deserialize(self, params):
        if params.get("SmartPolicy") is not None:
            self._SmartPolicy = SmartPolicy()
            self._SmartPolicy._deserialize(params.get("SmartPolicy"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetOptimizerPolicyResponse(AbstractModel):
    r"""GetOptimizerPolicy返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SmartOptimizerPolicy: 智能优化策略
        :type SmartOptimizerPolicy: :class:`tencentcloud.dlc.v20210125.models.SmartOptimizerPolicy`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SmartOptimizerPolicy = None
        self._RequestId = None

    @property
    def SmartOptimizerPolicy(self):
        r"""智能优化策略
        :rtype: :class:`tencentcloud.dlc.v20210125.models.SmartOptimizerPolicy`
        """
        return self._SmartOptimizerPolicy

    @SmartOptimizerPolicy.setter
    def SmartOptimizerPolicy(self, SmartOptimizerPolicy):
        self._SmartOptimizerPolicy = SmartOptimizerPolicy

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SmartOptimizerPolicy") is not None:
            self._SmartOptimizerPolicy = SmartOptimizerPolicy()
            self._SmartOptimizerPolicy._deserialize(params.get("SmartOptimizerPolicy"))
        self._RequestId = params.get("RequestId")


class GrantDLCCatalogAccessRequest(AbstractModel):
    r"""GrantDLCCatalogAccess请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpcId: 授权VpcId
        :type VpcId: str
        :param _Product: 产品(EMR|DLC|Doris|Inlong|Wedata)
        :type Product: str
        :param _Description: 描述
        :type Description: str
        :param _VpcUin: VPC所属账号UIN
        :type VpcUin: str
        :param _VpcAppId: VPC所属账号AppId
        :type VpcAppId: int
        """
        self._VpcId = None
        self._Product = None
        self._Description = None
        self._VpcUin = None
        self._VpcAppId = None

    @property
    def VpcId(self):
        r"""授权VpcId
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def Product(self):
        r"""产品(EMR|DLC|Doris|Inlong|Wedata)
        :rtype: str
        """
        return self._Product

    @Product.setter
    def Product(self, Product):
        self._Product = Product

    @property
    def Description(self):
        r"""描述
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def VpcUin(self):
        r"""VPC所属账号UIN
        :rtype: str
        """
        return self._VpcUin

    @VpcUin.setter
    def VpcUin(self, VpcUin):
        self._VpcUin = VpcUin

    @property
    def VpcAppId(self):
        r"""VPC所属账号AppId
        :rtype: int
        """
        return self._VpcAppId

    @VpcAppId.setter
    def VpcAppId(self, VpcAppId):
        self._VpcAppId = VpcAppId


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._Product = params.get("Product")
        self._Description = params.get("Description")
        self._VpcUin = params.get("VpcUin")
        self._VpcAppId = params.get("VpcAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GrantDLCCatalogAccessResponse(AbstractModel):
    r"""GrantDLCCatalogAccess返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class GroupInfo(AbstractModel):
    r"""数据脱敏用户组信息

    """

    def __init__(self):
        r"""
        :param _WorkGroupId: 用户组ID
        :type WorkGroupId: int
        :param _StrategyType: 策略类型
        :type StrategyType: str
        """
        self._WorkGroupId = None
        self._StrategyType = None

    @property
    def WorkGroupId(self):
        r"""用户组ID
        :rtype: int
        """
        return self._WorkGroupId

    @WorkGroupId.setter
    def WorkGroupId(self, WorkGroupId):
        self._WorkGroupId = WorkGroupId

    @property
    def StrategyType(self):
        r"""策略类型
        :rtype: str
        """
        return self._StrategyType

    @StrategyType.setter
    def StrategyType(self, StrategyType):
        self._StrategyType = StrategyType


    def _deserialize(self, params):
        self._WorkGroupId = params.get("WorkGroupId")
        self._StrategyType = params.get("StrategyType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HiveInfo(AbstractModel):
    r"""hive类型数据源的信息

    """

    def __init__(self):
        r"""
        :param _MetaStoreUrl: hive metastore的地址
        :type MetaStoreUrl: str
        :param _Type: hive数据源类型，代表数据储存的位置，COS或者HDFS
        :type Type: str
        :param _Location: 数据源所在的私有网络信息
        :type Location: :class:`tencentcloud.dlc.v20210125.models.DatasourceConnectionLocation`
        :param _User: 如果类型为HDFS，需要传一个用户名
        :type User: str
        :param _HighAvailability: 如果类型为HDFS，需要选择是否高可用
        :type HighAvailability: bool
        :param _BucketUrl: 如果类型为COS，需要填写COS桶连接
        :type BucketUrl: str
        :param _HdfsProperties: json字符串。如果类型为HDFS，需要填写该字段
        :type HdfsProperties: str
        :param _Mysql: Hive的元数据库信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Mysql: :class:`tencentcloud.dlc.v20210125.models.MysqlInfo`
        :param _InstanceId: emr集群Id
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceId: str
        :param _InstanceName: emr集群名称
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceName: str
        :param _HiveVersion: EMR集群中hive组件的版本号
        :type HiveVersion: str
        :param _KerberosInfo: Kerberos详细信息
注意：此字段可能返回 null，表示取不到有效值。
        :type KerberosInfo: :class:`tencentcloud.dlc.v20210125.models.KerberosInfo`
        :param _KerberosEnable: 是否开启Kerberos
注意：此字段可能返回 null，表示取不到有效值。
        :type KerberosEnable: bool
        """
        self._MetaStoreUrl = None
        self._Type = None
        self._Location = None
        self._User = None
        self._HighAvailability = None
        self._BucketUrl = None
        self._HdfsProperties = None
        self._Mysql = None
        self._InstanceId = None
        self._InstanceName = None
        self._HiveVersion = None
        self._KerberosInfo = None
        self._KerberosEnable = None

    @property
    def MetaStoreUrl(self):
        r"""hive metastore的地址
        :rtype: str
        """
        return self._MetaStoreUrl

    @MetaStoreUrl.setter
    def MetaStoreUrl(self, MetaStoreUrl):
        self._MetaStoreUrl = MetaStoreUrl

    @property
    def Type(self):
        r"""hive数据源类型，代表数据储存的位置，COS或者HDFS
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Location(self):
        r"""数据源所在的私有网络信息
        :rtype: :class:`tencentcloud.dlc.v20210125.models.DatasourceConnectionLocation`
        """
        return self._Location

    @Location.setter
    def Location(self, Location):
        self._Location = Location

    @property
    def User(self):
        r"""如果类型为HDFS，需要传一个用户名
        :rtype: str
        """
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def HighAvailability(self):
        r"""如果类型为HDFS，需要选择是否高可用
        :rtype: bool
        """
        return self._HighAvailability

    @HighAvailability.setter
    def HighAvailability(self, HighAvailability):
        self._HighAvailability = HighAvailability

    @property
    def BucketUrl(self):
        r"""如果类型为COS，需要填写COS桶连接
        :rtype: str
        """
        return self._BucketUrl

    @BucketUrl.setter
    def BucketUrl(self, BucketUrl):
        self._BucketUrl = BucketUrl

    @property
    def HdfsProperties(self):
        r"""json字符串。如果类型为HDFS，需要填写该字段
        :rtype: str
        """
        return self._HdfsProperties

    @HdfsProperties.setter
    def HdfsProperties(self, HdfsProperties):
        self._HdfsProperties = HdfsProperties

    @property
    def Mysql(self):
        r"""Hive的元数据库信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.dlc.v20210125.models.MysqlInfo`
        """
        return self._Mysql

    @Mysql.setter
    def Mysql(self, Mysql):
        self._Mysql = Mysql

    @property
    def InstanceId(self):
        r"""emr集群Id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def InstanceName(self):
        r"""emr集群名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def HiveVersion(self):
        r"""EMR集群中hive组件的版本号
        :rtype: str
        """
        return self._HiveVersion

    @HiveVersion.setter
    def HiveVersion(self, HiveVersion):
        self._HiveVersion = HiveVersion

    @property
    def KerberosInfo(self):
        r"""Kerberos详细信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.dlc.v20210125.models.KerberosInfo`
        """
        return self._KerberosInfo

    @KerberosInfo.setter
    def KerberosInfo(self, KerberosInfo):
        self._KerberosInfo = KerberosInfo

    @property
    def KerberosEnable(self):
        r"""是否开启Kerberos
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._KerberosEnable

    @KerberosEnable.setter
    def KerberosEnable(self, KerberosEnable):
        self._KerberosEnable = KerberosEnable


    def _deserialize(self, params):
        self._MetaStoreUrl = params.get("MetaStoreUrl")
        self._Type = params.get("Type")
        if params.get("Location") is not None:
            self._Location = DatasourceConnectionLocation()
            self._Location._deserialize(params.get("Location"))
        self._User = params.get("User")
        self._HighAvailability = params.get("HighAvailability")
        self._BucketUrl = params.get("BucketUrl")
        self._HdfsProperties = params.get("HdfsProperties")
        if params.get("Mysql") is not None:
            self._Mysql = MysqlInfo()
            self._Mysql._deserialize(params.get("Mysql"))
        self._InstanceId = params.get("InstanceId")
        self._InstanceName = params.get("InstanceName")
        self._HiveVersion = params.get("HiveVersion")
        if params.get("KerberosInfo") is not None:
            self._KerberosInfo = KerberosInfo()
            self._KerberosInfo._deserialize(params.get("KerberosInfo"))
        self._KerberosEnable = params.get("KerberosEnable")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HiveTablePartition(AbstractModel):
    r"""Hive表分区信息

    """

    def __init__(self):
        r"""
        :param _Partition: 分区信息名称
        :type Partition: str
        :param _Records: 分区记录数
        :type Records: int
        :param _DataFileStorage: 分区数据文件存储量
        :type DataFileStorage: int
        :param _CreateTime: 分区创建时间
        :type CreateTime: str
        :param _ModifiedTime: 分区schema更新时间
        :type ModifiedTime: str
        :param _LastAccessTime: 最后一次分区更新的访问时间
        :type LastAccessTime: str
        """
        self._Partition = None
        self._Records = None
        self._DataFileStorage = None
        self._CreateTime = None
        self._ModifiedTime = None
        self._LastAccessTime = None

    @property
    def Partition(self):
        r"""分区信息名称
        :rtype: str
        """
        return self._Partition

    @Partition.setter
    def Partition(self, Partition):
        self._Partition = Partition

    @property
    def Records(self):
        r"""分区记录数
        :rtype: int
        """
        return self._Records

    @Records.setter
    def Records(self, Records):
        self._Records = Records

    @property
    def DataFileStorage(self):
        r"""分区数据文件存储量
        :rtype: int
        """
        return self._DataFileStorage

    @DataFileStorage.setter
    def DataFileStorage(self, DataFileStorage):
        self._DataFileStorage = DataFileStorage

    @property
    def CreateTime(self):
        r"""分区创建时间
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ModifiedTime(self):
        r"""分区schema更新时间
        :rtype: str
        """
        return self._ModifiedTime

    @ModifiedTime.setter
    def ModifiedTime(self, ModifiedTime):
        self._ModifiedTime = ModifiedTime

    @property
    def LastAccessTime(self):
        r"""最后一次分区更新的访问时间
        :rtype: str
        """
        return self._LastAccessTime

    @LastAccessTime.setter
    def LastAccessTime(self, LastAccessTime):
        self._LastAccessTime = LastAccessTime


    def _deserialize(self, params):
        self._Partition = params.get("Partition")
        self._Records = params.get("Records")
        self._DataFileStorage = params.get("DataFileStorage")
        self._CreateTime = params.get("CreateTime")
        self._ModifiedTime = params.get("ModifiedTime")
        self._LastAccessTime = params.get("LastAccessTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HouseEventsInfo(AbstractModel):
    r"""集群事件日志

    """

    def __init__(self):
        r"""
        :param _Time: 事件时间
注意：此字段可能返回 null，表示取不到有效值。
        :type Time: list of str
        :param _EventsAction: 事件类型
注意：此字段可能返回 null，表示取不到有效值。
        :type EventsAction: list of str
        :param _ClusterInfo: 集群信息
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterInfo: list of str
        """
        self._Time = None
        self._EventsAction = None
        self._ClusterInfo = None

    @property
    def Time(self):
        r"""事件时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._Time

    @Time.setter
    def Time(self, Time):
        self._Time = Time

    @property
    def EventsAction(self):
        r"""事件类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._EventsAction

    @EventsAction.setter
    def EventsAction(self, EventsAction):
        self._EventsAction = EventsAction

    @property
    def ClusterInfo(self):
        r"""集群信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._ClusterInfo

    @ClusterInfo.setter
    def ClusterInfo(self, ClusterInfo):
        self._ClusterInfo = ClusterInfo


    def _deserialize(self, params):
        self._Time = params.get("Time")
        self._EventsAction = params.get("EventsAction")
        self._ClusterInfo = params.get("ClusterInfo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IcebergTablePartition(AbstractModel):
    r"""Iceberg表分区信息

    """

    def __init__(self):
        r"""
        :param _Partition: 分区信息名称
        :type Partition: str
        :param _Records: 分区记录数
        :type Records: int
        :param _DataFileSize: 分区数据文件数量
        :type DataFileSize: int
        :param _DataFileStorage: 分区数据文件存储量
        :type DataFileStorage: int
        :param _CreateTime: 分区创建时间
        :type CreateTime: str
        :param _UpdateTime: 分区更新时间
        :type UpdateTime: str
        :param _LastUpdateSnapshotId: 最后一次分区更新的快照ID
        :type LastUpdateSnapshotId: str
        :param _Location: 分区的location
        :type Location: :class:`tencentcloud.dlc.v20210125.models.LocationInfo`
        """
        self._Partition = None
        self._Records = None
        self._DataFileSize = None
        self._DataFileStorage = None
        self._CreateTime = None
        self._UpdateTime = None
        self._LastUpdateSnapshotId = None
        self._Location = None

    @property
    def Partition(self):
        r"""分区信息名称
        :rtype: str
        """
        return self._Partition

    @Partition.setter
    def Partition(self, Partition):
        self._Partition = Partition

    @property
    def Records(self):
        r"""分区记录数
        :rtype: int
        """
        return self._Records

    @Records.setter
    def Records(self, Records):
        self._Records = Records

    @property
    def DataFileSize(self):
        r"""分区数据文件数量
        :rtype: int
        """
        return self._DataFileSize

    @DataFileSize.setter
    def DataFileSize(self, DataFileSize):
        self._DataFileSize = DataFileSize

    @property
    def DataFileStorage(self):
        r"""分区数据文件存储量
        :rtype: int
        """
        return self._DataFileStorage

    @DataFileStorage.setter
    def DataFileStorage(self, DataFileStorage):
        self._DataFileStorage = DataFileStorage

    @property
    def CreateTime(self):
        r"""分区创建时间
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""分区更新时间
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def LastUpdateSnapshotId(self):
        r"""最后一次分区更新的快照ID
        :rtype: str
        """
        return self._LastUpdateSnapshotId

    @LastUpdateSnapshotId.setter
    def LastUpdateSnapshotId(self, LastUpdateSnapshotId):
        self._LastUpdateSnapshotId = LastUpdateSnapshotId

    @property
    def Location(self):
        r"""分区的location
        :rtype: :class:`tencentcloud.dlc.v20210125.models.LocationInfo`
        """
        return self._Location

    @Location.setter
    def Location(self, Location):
        self._Location = Location


    def _deserialize(self, params):
        self._Partition = params.get("Partition")
        self._Records = params.get("Records")
        self._DataFileSize = params.get("DataFileSize")
        self._DataFileStorage = params.get("DataFileStorage")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._LastUpdateSnapshotId = params.get("LastUpdateSnapshotId")
        if params.get("Location") is not None:
            self._Location = LocationInfo()
            self._Location._deserialize(params.get("Location"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IpPortPair(AbstractModel):
    r"""ip端口对信息

    """

    def __init__(self):
        r"""
        :param _Ip: ip信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Ip: str
        :param _Port: 端口信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Port: int
        """
        self._Ip = None
        self._Port = None

    @property
    def Ip(self):
        r"""ip信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Ip

    @Ip.setter
    def Ip(self, Ip):
        self._Ip = Ip

    @property
    def Port(self):
        r"""端口信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port


    def _deserialize(self, params):
        self._Ip = params.get("Ip")
        self._Port = params.get("Port")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class JobLogResult(AbstractModel):
    r"""日志详情

    """

    def __init__(self):
        r"""
        :param _Time: 日志时间戳，毫秒
注意：此字段可能返回 null，表示取不到有效值。
        :type Time: int
        :param _TopicId: 日志topic id
注意：此字段可能返回 null，表示取不到有效值。
        :type TopicId: str
        :param _TopicName: 日志topic name
注意：此字段可能返回 null，表示取不到有效值。
        :type TopicName: str
        :param _LogJson: 日志内容，json字符串
注意：此字段可能返回 null，表示取不到有效值。
        :type LogJson: str
        :param _PkgLogId: 日志ID
注意：此字段可能返回 null，表示取不到有效值。
        :type PkgLogId: str
        """
        self._Time = None
        self._TopicId = None
        self._TopicName = None
        self._LogJson = None
        self._PkgLogId = None

    @property
    def Time(self):
        r"""日志时间戳，毫秒
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Time

    @Time.setter
    def Time(self, Time):
        self._Time = Time

    @property
    def TopicId(self):
        r"""日志topic id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TopicId

    @TopicId.setter
    def TopicId(self, TopicId):
        self._TopicId = TopicId

    @property
    def TopicName(self):
        r"""日志topic name
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName

    @property
    def LogJson(self):
        r"""日志内容，json字符串
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._LogJson

    @LogJson.setter
    def LogJson(self, LogJson):
        self._LogJson = LogJson

    @property
    def PkgLogId(self):
        r"""日志ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PkgLogId

    @PkgLogId.setter
    def PkgLogId(self, PkgLogId):
        self._PkgLogId = PkgLogId


    def _deserialize(self, params):
        self._Time = params.get("Time")
        self._TopicId = params.get("TopicId")
        self._TopicName = params.get("TopicName")
        self._LogJson = params.get("LogJson")
        self._PkgLogId = params.get("PkgLogId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class KVPair(AbstractModel):
    r"""配置格式

    """

    def __init__(self):
        r"""
        :param _Key: 配置的key值
        :type Key: str
        :param _Value: 配置的value值
        :type Value: str
        """
        self._Key = None
        self._Value = None

    @property
    def Key(self):
        r"""配置的key值
        :rtype: str
        """
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def Value(self):
        r"""配置的value值
        :rtype: str
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value


    def _deserialize(self, params):
        self._Key = params.get("Key")
        self._Value = params.get("Value")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class KafkaInfo(AbstractModel):
    r"""Kafka连接信息

    """

    def __init__(self):
        r"""
        :param _InstanceId: kafka实例Id
        :type InstanceId: str
        :param _Location: kafka数据源的网络信息
        :type Location: :class:`tencentcloud.dlc.v20210125.models.DatasourceConnectionLocation`
        """
        self._InstanceId = None
        self._Location = None

    @property
    def InstanceId(self):
        r"""kafka实例Id
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Location(self):
        r"""kafka数据源的网络信息
        :rtype: :class:`tencentcloud.dlc.v20210125.models.DatasourceConnectionLocation`
        """
        return self._Location

    @Location.setter
    def Location(self, Location):
        self._Location = Location


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        if params.get("Location") is not None:
            self._Location = DatasourceConnectionLocation()
            self._Location._deserialize(params.get("Location"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class KerberosInfo(AbstractModel):
    r"""Kerberos详细信息

    """

    def __init__(self):
        r"""
        :param _Krb5Conf: Krb5Conf文件值
        :type Krb5Conf: str
        :param _KeyTab: KeyTab文件值
        :type KeyTab: str
        :param _ServicePrincipal: 服务主体
        :type ServicePrincipal: str
        """
        self._Krb5Conf = None
        self._KeyTab = None
        self._ServicePrincipal = None

    @property
    def Krb5Conf(self):
        r"""Krb5Conf文件值
        :rtype: str
        """
        return self._Krb5Conf

    @Krb5Conf.setter
    def Krb5Conf(self, Krb5Conf):
        self._Krb5Conf = Krb5Conf

    @property
    def KeyTab(self):
        r"""KeyTab文件值
        :rtype: str
        """
        return self._KeyTab

    @KeyTab.setter
    def KeyTab(self, KeyTab):
        self._KeyTab = KeyTab

    @property
    def ServicePrincipal(self):
        r"""服务主体
        :rtype: str
        """
        return self._ServicePrincipal

    @ServicePrincipal.setter
    def ServicePrincipal(self, ServicePrincipal):
        self._ServicePrincipal = ServicePrincipal


    def _deserialize(self, params):
        self._Krb5Conf = params.get("Krb5Conf")
        self._KeyTab = params.get("KeyTab")
        self._ServicePrincipal = params.get("ServicePrincipal")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LakeFileSystemToken(AbstractModel):
    r"""LakeFileSystem使用的临时token

    """

    def __init__(self):
        r"""
        :param _SecretId: Token使用的临时密钥的ID
        :type SecretId: str
        :param _SecretKey: Token使用的临时密钥
        :type SecretKey: str
        :param _Token: Token信息
        :type Token: str
        :param _ExpiredTime: 过期时间
        :type ExpiredTime: int
        :param _IssueTime: 颁布时间
        :type IssueTime: int
        """
        self._SecretId = None
        self._SecretKey = None
        self._Token = None
        self._ExpiredTime = None
        self._IssueTime = None

    @property
    def SecretId(self):
        r"""Token使用的临时密钥的ID
        :rtype: str
        """
        return self._SecretId

    @SecretId.setter
    def SecretId(self, SecretId):
        self._SecretId = SecretId

    @property
    def SecretKey(self):
        r"""Token使用的临时密钥
        :rtype: str
        """
        return self._SecretKey

    @SecretKey.setter
    def SecretKey(self, SecretKey):
        self._SecretKey = SecretKey

    @property
    def Token(self):
        r"""Token信息
        :rtype: str
        """
        return self._Token

    @Token.setter
    def Token(self, Token):
        self._Token = Token

    @property
    def ExpiredTime(self):
        r"""过期时间
        :rtype: int
        """
        return self._ExpiredTime

    @ExpiredTime.setter
    def ExpiredTime(self, ExpiredTime):
        self._ExpiredTime = ExpiredTime

    @property
    def IssueTime(self):
        r"""颁布时间
        :rtype: int
        """
        return self._IssueTime

    @IssueTime.setter
    def IssueTime(self, IssueTime):
        self._IssueTime = IssueTime


    def _deserialize(self, params):
        self._SecretId = params.get("SecretId")
        self._SecretKey = params.get("SecretKey")
        self._Token = params.get("Token")
        self._ExpiredTime = params.get("ExpiredTime")
        self._IssueTime = params.get("IssueTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LakeFsInfo(AbstractModel):
    r"""描述DLC托管存储基本信息

    """

    def __init__(self):
        r"""
        :param _Name: 托管存储名称
        :type Name: str
        :param _Type: 托管存储类型
        :type Type: str
        :param _SpaceUsedSize: 存储用量
        :type SpaceUsedSize: float
        :param _CreateTimeStamp: 创建时候的时间戳
        :type CreateTimeStamp: int
        :param _DefaultBucket: 是否是用户默认桶，0：默认桶，1：非默认桶
        :type DefaultBucket: int
        :param _ShortName: 托管存储short name
        :type ShortName: str
        :param _Description: 桶描述信息
        :type Description: str
        :param _Status: 托管桶状态，当前取值为：creating、bind、readOnly、isolate
        :type Status: str
        :param _TagList: 托管存储桶标签列表
        :type TagList: list of TagInfo
        """
        self._Name = None
        self._Type = None
        self._SpaceUsedSize = None
        self._CreateTimeStamp = None
        self._DefaultBucket = None
        self._ShortName = None
        self._Description = None
        self._Status = None
        self._TagList = None

    @property
    def Name(self):
        r"""托管存储名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Type(self):
        r"""托管存储类型
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def SpaceUsedSize(self):
        r"""存储用量
        :rtype: float
        """
        return self._SpaceUsedSize

    @SpaceUsedSize.setter
    def SpaceUsedSize(self, SpaceUsedSize):
        self._SpaceUsedSize = SpaceUsedSize

    @property
    def CreateTimeStamp(self):
        r"""创建时候的时间戳
        :rtype: int
        """
        return self._CreateTimeStamp

    @CreateTimeStamp.setter
    def CreateTimeStamp(self, CreateTimeStamp):
        self._CreateTimeStamp = CreateTimeStamp

    @property
    def DefaultBucket(self):
        r"""是否是用户默认桶，0：默认桶，1：非默认桶
        :rtype: int
        """
        return self._DefaultBucket

    @DefaultBucket.setter
    def DefaultBucket(self, DefaultBucket):
        self._DefaultBucket = DefaultBucket

    @property
    def ShortName(self):
        r"""托管存储short name
        :rtype: str
        """
        return self._ShortName

    @ShortName.setter
    def ShortName(self, ShortName):
        self._ShortName = ShortName

    @property
    def Description(self):
        r"""桶描述信息
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Status(self):
        r"""托管桶状态，当前取值为：creating、bind、readOnly、isolate
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def TagList(self):
        r"""托管存储桶标签列表
        :rtype: list of TagInfo
        """
        return self._TagList

    @TagList.setter
    def TagList(self, TagList):
        self._TagList = TagList


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Type = params.get("Type")
        self._SpaceUsedSize = params.get("SpaceUsedSize")
        self._CreateTimeStamp = params.get("CreateTimeStamp")
        self._DefaultBucket = params.get("DefaultBucket")
        self._ShortName = params.get("ShortName")
        self._Description = params.get("Description")
        self._Status = params.get("Status")
        if params.get("TagList") is not None:
            self._TagList = []
            for item in params.get("TagList"):
                obj = TagInfo()
                obj._deserialize(item)
                self._TagList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LaunchStandardEngineResourceGroupsRequest(AbstractModel):
    r"""LaunchStandardEngineResourceGroups请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EngineResourceGroupNames: 标准引擎资源组名称
        :type EngineResourceGroupNames: list of str
        """
        self._EngineResourceGroupNames = None

    @property
    def EngineResourceGroupNames(self):
        r"""标准引擎资源组名称
        :rtype: list of str
        """
        return self._EngineResourceGroupNames

    @EngineResourceGroupNames.setter
    def EngineResourceGroupNames(self, EngineResourceGroupNames):
        self._EngineResourceGroupNames = EngineResourceGroupNames


    def _deserialize(self, params):
        self._EngineResourceGroupNames = params.get("EngineResourceGroupNames")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LaunchStandardEngineResourceGroupsResponse(AbstractModel):
    r"""LaunchStandardEngineResourceGroups返回参数结构体

    """

    def __init__(self):
        r"""
        :param _OperateEngineResourceGroupFailMessages: 批量操作资源组时，操作失败的资源组相关信息
注意：此字段可能返回 null，表示取不到有效值。
        :type OperateEngineResourceGroupFailMessages: list of OperateEngineResourceGroupFailMessage
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._OperateEngineResourceGroupFailMessages = None
        self._RequestId = None

    @property
    def OperateEngineResourceGroupFailMessages(self):
        r"""批量操作资源组时，操作失败的资源组相关信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of OperateEngineResourceGroupFailMessage
        """
        return self._OperateEngineResourceGroupFailMessages

    @OperateEngineResourceGroupFailMessages.setter
    def OperateEngineResourceGroupFailMessages(self, OperateEngineResourceGroupFailMessages):
        self._OperateEngineResourceGroupFailMessages = OperateEngineResourceGroupFailMessages

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("OperateEngineResourceGroupFailMessages") is not None:
            self._OperateEngineResourceGroupFailMessages = []
            for item in params.get("OperateEngineResourceGroupFailMessages"):
                obj = OperateEngineResourceGroupFailMessage()
                obj._deserialize(item)
                self._OperateEngineResourceGroupFailMessages.append(obj)
        self._RequestId = params.get("RequestId")


class ListTaskJobLogDetailRequest(AbstractModel):
    r"""ListTaskJobLogDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 开始运行时间，unix时间戳（毫秒）
        :type StartTime: int
        :param _EndTime: 结束运行时间，unix时间戳（毫秒）
        :type EndTime: int
        :param _Limit: 分页大小，最大1000，配合Context一起使用
        :type Limit: int
        :param _Context: 下一次分页参数，第一次传空
        :type Context: str
        :param _TaskId: 列表返回的Id
        :type TaskId: str
        :param _Asc: 最近1000条日志是否升序排列，true:升序排序，false:倒序，默认false，倒序排列
        :type Asc: bool
        :param _Filters: 预览日志的通用过滤条件
        :type Filters: list of Filter
        :param _BatchId: SparkSQL任务唯一ID
        :type BatchId: str
        :param _DataEngineId: 引擎id
        :type DataEngineId: str
        :param _ResourceGroupId: 资源组id
        :type ResourceGroupId: str
        """
        self._StartTime = None
        self._EndTime = None
        self._Limit = None
        self._Context = None
        self._TaskId = None
        self._Asc = None
        self._Filters = None
        self._BatchId = None
        self._DataEngineId = None
        self._ResourceGroupId = None

    @property
    def StartTime(self):
        r"""开始运行时间，unix时间戳（毫秒）
        :rtype: int
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""结束运行时间，unix时间戳（毫秒）
        :rtype: int
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Limit(self):
        r"""分页大小，最大1000，配合Context一起使用
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Context(self):
        r"""下一次分页参数，第一次传空
        :rtype: str
        """
        return self._Context

    @Context.setter
    def Context(self, Context):
        self._Context = Context

    @property
    def TaskId(self):
        r"""列表返回的Id
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Asc(self):
        r"""最近1000条日志是否升序排列，true:升序排序，false:倒序，默认false，倒序排列
        :rtype: bool
        """
        return self._Asc

    @Asc.setter
    def Asc(self, Asc):
        self._Asc = Asc

    @property
    def Filters(self):
        r"""预览日志的通用过滤条件
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def BatchId(self):
        r"""SparkSQL任务唯一ID
        :rtype: str
        """
        return self._BatchId

    @BatchId.setter
    def BatchId(self, BatchId):
        self._BatchId = BatchId

    @property
    def DataEngineId(self):
        r"""引擎id
        :rtype: str
        """
        return self._DataEngineId

    @DataEngineId.setter
    def DataEngineId(self, DataEngineId):
        self._DataEngineId = DataEngineId

    @property
    def ResourceGroupId(self):
        r"""资源组id
        :rtype: str
        """
        return self._ResourceGroupId

    @ResourceGroupId.setter
    def ResourceGroupId(self, ResourceGroupId):
        self._ResourceGroupId = ResourceGroupId


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Limit = params.get("Limit")
        self._Context = params.get("Context")
        self._TaskId = params.get("TaskId")
        self._Asc = params.get("Asc")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._BatchId = params.get("BatchId")
        self._DataEngineId = params.get("DataEngineId")
        self._ResourceGroupId = params.get("ResourceGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ListTaskJobLogDetailResponse(AbstractModel):
    r"""ListTaskJobLogDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Context: 下一次分页参数
        :type Context: str
        :param _ListOver: 是否获取完结
        :type ListOver: bool
        :param _Results: 日志详情
        :type Results: list of JobLogResult
        :param _LogUrl: 日志url(字段已废弃)
        :type LogUrl: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Context = None
        self._ListOver = None
        self._Results = None
        self._LogUrl = None
        self._RequestId = None

    @property
    def Context(self):
        r"""下一次分页参数
        :rtype: str
        """
        return self._Context

    @Context.setter
    def Context(self, Context):
        self._Context = Context

    @property
    def ListOver(self):
        r"""是否获取完结
        :rtype: bool
        """
        return self._ListOver

    @ListOver.setter
    def ListOver(self, ListOver):
        self._ListOver = ListOver

    @property
    def Results(self):
        r"""日志详情
        :rtype: list of JobLogResult
        """
        return self._Results

    @Results.setter
    def Results(self, Results):
        self._Results = Results

    @property
    def LogUrl(self):
        r"""日志url(字段已废弃)
        :rtype: str
        """
        return self._LogUrl

    @LogUrl.setter
    def LogUrl(self, LogUrl):
        self._LogUrl = LogUrl

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Context = params.get("Context")
        self._ListOver = params.get("ListOver")
        if params.get("Results") is not None:
            self._Results = []
            for item in params.get("Results"):
                obj = JobLogResult()
                obj._deserialize(item)
                self._Results.append(obj)
        self._LogUrl = params.get("LogUrl")
        self._RequestId = params.get("RequestId")


class ListTaskJobLogNameRequest(AbstractModel):
    r"""ListTaskJobLogName请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 查询的taskId
        :type TaskId: str
        :param _BatchId: SparkSQL批任务唯一ID
        :type BatchId: str
        """
        self._TaskId = None
        self._BatchId = None

    @property
    def TaskId(self):
        r"""查询的taskId
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def BatchId(self):
        r"""SparkSQL批任务唯一ID
        :rtype: str
        """
        return self._BatchId

    @BatchId.setter
    def BatchId(self, BatchId):
        self._BatchId = BatchId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._BatchId = params.get("BatchId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ListTaskJobLogNameResponse(AbstractModel):
    r"""ListTaskJobLogName返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Names: 日志名称列表
        :type Names: list of str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Names = None
        self._RequestId = None

    @property
    def Names(self):
        r"""日志名称列表
        :rtype: list of str
        """
        return self._Names

    @Names.setter
    def Names(self, Names):
        self._Names = Names

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Names = params.get("Names")
        self._RequestId = params.get("RequestId")


class LocationInfo(AbstractModel):
    r"""Location信息结构

    """

    def __init__(self):
        r"""
        :param _Bucket: 桶名称
        :type Bucket: str
        :param _DataLocation: location路径
        :type DataLocation: str
        """
        self._Bucket = None
        self._DataLocation = None

    @property
    def Bucket(self):
        r"""桶名称
        :rtype: str
        """
        return self._Bucket

    @Bucket.setter
    def Bucket(self, Bucket):
        self._Bucket = Bucket

    @property
    def DataLocation(self):
        r"""location路径
        :rtype: str
        """
        return self._DataLocation

    @DataLocation.setter
    def DataLocation(self, DataLocation):
        self._DataLocation = DataLocation


    def _deserialize(self, params):
        self._Bucket = params.get("Bucket")
        self._DataLocation = params.get("DataLocation")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LockComponentInfo(AbstractModel):
    r"""元数据加锁内容

    """

    def __init__(self):
        r"""
        :param _DbName: 数据库名称
        :type DbName: str
        :param _TableName: 表名称
        :type TableName: str
        :param _Partition: 分区
        :type Partition: str
        :param _LockType: 锁类型：SHARED_READ、SHARED_WRITE、EXCLUSIVE
        :type LockType: str
        :param _LockLevel: 锁级别：DB、TABLE、PARTITION
        :type LockLevel: str
        :param _DataOperationType: 锁操作：SELECT,INSERT,UPDATE,DELETE,UNSET,NO_TXN
        :type DataOperationType: str
        :param _IsAcid: 是否保持Acid
        :type IsAcid: bool
        :param _IsDynamicPartitionWrite: 是否动态分区写
        :type IsDynamicPartitionWrite: bool
        """
        self._DbName = None
        self._TableName = None
        self._Partition = None
        self._LockType = None
        self._LockLevel = None
        self._DataOperationType = None
        self._IsAcid = None
        self._IsDynamicPartitionWrite = None

    @property
    def DbName(self):
        r"""数据库名称
        :rtype: str
        """
        return self._DbName

    @DbName.setter
    def DbName(self, DbName):
        self._DbName = DbName

    @property
    def TableName(self):
        r"""表名称
        :rtype: str
        """
        return self._TableName

    @TableName.setter
    def TableName(self, TableName):
        self._TableName = TableName

    @property
    def Partition(self):
        r"""分区
        :rtype: str
        """
        return self._Partition

    @Partition.setter
    def Partition(self, Partition):
        self._Partition = Partition

    @property
    def LockType(self):
        r"""锁类型：SHARED_READ、SHARED_WRITE、EXCLUSIVE
        :rtype: str
        """
        return self._LockType

    @LockType.setter
    def LockType(self, LockType):
        self._LockType = LockType

    @property
    def LockLevel(self):
        r"""锁级别：DB、TABLE、PARTITION
        :rtype: str
        """
        return self._LockLevel

    @LockLevel.setter
    def LockLevel(self, LockLevel):
        self._LockLevel = LockLevel

    @property
    def DataOperationType(self):
        r"""锁操作：SELECT,INSERT,UPDATE,DELETE,UNSET,NO_TXN
        :rtype: str
        """
        return self._DataOperationType

    @DataOperationType.setter
    def DataOperationType(self, DataOperationType):
        self._DataOperationType = DataOperationType

    @property
    def IsAcid(self):
        r"""是否保持Acid
        :rtype: bool
        """
        return self._IsAcid

    @IsAcid.setter
    def IsAcid(self, IsAcid):
        self._IsAcid = IsAcid

    @property
    def IsDynamicPartitionWrite(self):
        r"""是否动态分区写
        :rtype: bool
        """
        return self._IsDynamicPartitionWrite

    @IsDynamicPartitionWrite.setter
    def IsDynamicPartitionWrite(self, IsDynamicPartitionWrite):
        self._IsDynamicPartitionWrite = IsDynamicPartitionWrite


    def _deserialize(self, params):
        self._DbName = params.get("DbName")
        self._TableName = params.get("TableName")
        self._Partition = params.get("Partition")
        self._LockType = params.get("LockType")
        self._LockLevel = params.get("LockLevel")
        self._DataOperationType = params.get("DataOperationType")
        self._IsAcid = params.get("IsAcid")
        self._IsDynamicPartitionWrite = params.get("IsDynamicPartitionWrite")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LockMetaDataRequest(AbstractModel):
    r"""LockMetaData请求参数结构体

    """

    def __init__(self):
        r"""
        :param _LockComponentList: 加锁内容
        :type LockComponentList: list of LockComponentInfo
        :param _DatasourceConnectionName: 数据源名称
        :type DatasourceConnectionName: str
        :param _TxnId: 事务id
        :type TxnId: int
        :param _AgentInfo: 客户端信息
        :type AgentInfo: str
        :param _Hostname: 主机名
        :type Hostname: str
        """
        self._LockComponentList = None
        self._DatasourceConnectionName = None
        self._TxnId = None
        self._AgentInfo = None
        self._Hostname = None

    @property
    def LockComponentList(self):
        r"""加锁内容
        :rtype: list of LockComponentInfo
        """
        return self._LockComponentList

    @LockComponentList.setter
    def LockComponentList(self, LockComponentList):
        self._LockComponentList = LockComponentList

    @property
    def DatasourceConnectionName(self):
        r"""数据源名称
        :rtype: str
        """
        return self._DatasourceConnectionName

    @DatasourceConnectionName.setter
    def DatasourceConnectionName(self, DatasourceConnectionName):
        self._DatasourceConnectionName = DatasourceConnectionName

    @property
    def TxnId(self):
        r"""事务id
        :rtype: int
        """
        return self._TxnId

    @TxnId.setter
    def TxnId(self, TxnId):
        self._TxnId = TxnId

    @property
    def AgentInfo(self):
        r"""客户端信息
        :rtype: str
        """
        return self._AgentInfo

    @AgentInfo.setter
    def AgentInfo(self, AgentInfo):
        self._AgentInfo = AgentInfo

    @property
    def Hostname(self):
        r"""主机名
        :rtype: str
        """
        return self._Hostname

    @Hostname.setter
    def Hostname(self, Hostname):
        self._Hostname = Hostname


    def _deserialize(self, params):
        if params.get("LockComponentList") is not None:
            self._LockComponentList = []
            for item in params.get("LockComponentList"):
                obj = LockComponentInfo()
                obj._deserialize(item)
                self._LockComponentList.append(obj)
        self._DatasourceConnectionName = params.get("DatasourceConnectionName")
        self._TxnId = params.get("TxnId")
        self._AgentInfo = params.get("AgentInfo")
        self._Hostname = params.get("Hostname")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LockMetaDataResponse(AbstractModel):
    r"""LockMetaData返回参数结构体

    """

    def __init__(self):
        r"""
        :param _LockId: 锁id
        :type LockId: int
        :param _LockState: 锁状态：ACQUIRED、WAITING、ABORT、NOT_ACQUIRED
        :type LockState: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._LockId = None
        self._LockState = None
        self._RequestId = None

    @property
    def LockId(self):
        r"""锁id
        :rtype: int
        """
        return self._LockId

    @LockId.setter
    def LockId(self, LockId):
        self._LockId = LockId

    @property
    def LockState(self):
        r"""锁状态：ACQUIRED、WAITING、ABORT、NOT_ACQUIRED
        :rtype: str
        """
        return self._LockState

    @LockState.setter
    def LockState(self, LockState):
        self._LockState = LockState

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._LockId = params.get("LockId")
        self._LockState = params.get("LockState")
        self._RequestId = params.get("RequestId")


class MixedTablePartitions(AbstractModel):
    r"""DLC分区信息查询返回数据结构

    """

    def __init__(self):
        r"""
        :param _TableFormat: 数据表格式
        :type TableFormat: str
        :param _TotalSize: 分区总数
        :type TotalSize: int
        :param _NextCursor: 分页查询的游标信息，在获取下一页信息时需要回传到服务端
        :type NextCursor: str
        :param _IcebergPartitions: iceberg表分区信息
        :type IcebergPartitions: list of IcebergTablePartition
        :param _HivePartitions: hive表分区信息
        :type HivePartitions: list of HiveTablePartition
        """
        self._TableFormat = None
        self._TotalSize = None
        self._NextCursor = None
        self._IcebergPartitions = None
        self._HivePartitions = None

    @property
    def TableFormat(self):
        r"""数据表格式
        :rtype: str
        """
        return self._TableFormat

    @TableFormat.setter
    def TableFormat(self, TableFormat):
        self._TableFormat = TableFormat

    @property
    def TotalSize(self):
        r"""分区总数
        :rtype: int
        """
        return self._TotalSize

    @TotalSize.setter
    def TotalSize(self, TotalSize):
        self._TotalSize = TotalSize

    @property
    def NextCursor(self):
        r"""分页查询的游标信息，在获取下一页信息时需要回传到服务端
        :rtype: str
        """
        return self._NextCursor

    @NextCursor.setter
    def NextCursor(self, NextCursor):
        self._NextCursor = NextCursor

    @property
    def IcebergPartitions(self):
        r"""iceberg表分区信息
        :rtype: list of IcebergTablePartition
        """
        return self._IcebergPartitions

    @IcebergPartitions.setter
    def IcebergPartitions(self, IcebergPartitions):
        self._IcebergPartitions = IcebergPartitions

    @property
    def HivePartitions(self):
        r"""hive表分区信息
        :rtype: list of HiveTablePartition
        """
        return self._HivePartitions

    @HivePartitions.setter
    def HivePartitions(self, HivePartitions):
        self._HivePartitions = HivePartitions


    def _deserialize(self, params):
        self._TableFormat = params.get("TableFormat")
        self._TotalSize = params.get("TotalSize")
        self._NextCursor = params.get("NextCursor")
        if params.get("IcebergPartitions") is not None:
            self._IcebergPartitions = []
            for item in params.get("IcebergPartitions"):
                obj = IcebergTablePartition()
                obj._deserialize(item)
                self._IcebergPartitions.append(obj)
        if params.get("HivePartitions") is not None:
            self._HivePartitions = []
            for item in params.get("HivePartitions"):
                obj = HiveTablePartition()
                obj._deserialize(item)
                self._HivePartitions.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAdvancedStoreLocationRequest(AbstractModel):
    r"""ModifyAdvancedStoreLocation请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StoreLocation: 查询结果保存cos路径
        :type StoreLocation: str
        :param _Enable: 是否启用高级设置：0-否，1-是
        :type Enable: int
        """
        self._StoreLocation = None
        self._Enable = None

    @property
    def StoreLocation(self):
        r"""查询结果保存cos路径
        :rtype: str
        """
        return self._StoreLocation

    @StoreLocation.setter
    def StoreLocation(self, StoreLocation):
        self._StoreLocation = StoreLocation

    @property
    def Enable(self):
        r"""是否启用高级设置：0-否，1-是
        :rtype: int
        """
        return self._Enable

    @Enable.setter
    def Enable(self, Enable):
        self._Enable = Enable


    def _deserialize(self, params):
        self._StoreLocation = params.get("StoreLocation")
        self._Enable = params.get("Enable")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAdvancedStoreLocationResponse(AbstractModel):
    r"""ModifyAdvancedStoreLocation返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyDataEngineDescriptionRequest(AbstractModel):
    r"""ModifyDataEngineDescription请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DataEngineName: 要修改的引擎的名称
        :type DataEngineName: str
        :param _Message: 引擎的描述信息，最大长度为250
        :type Message: str
        """
        self._DataEngineName = None
        self._Message = None

    @property
    def DataEngineName(self):
        r"""要修改的引擎的名称
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName

    @property
    def Message(self):
        r"""引擎的描述信息，最大长度为250
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message


    def _deserialize(self, params):
        self._DataEngineName = params.get("DataEngineName")
        self._Message = params.get("Message")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyDataEngineDescriptionResponse(AbstractModel):
    r"""ModifyDataEngineDescription返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyGovernEventRuleRequest(AbstractModel):
    r"""ModifyGovernEventRule请求参数结构体

    """


class ModifyGovernEventRuleResponse(AbstractModel):
    r"""ModifyGovernEventRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifySparkAppBatchRequest(AbstractModel):
    r"""ModifySparkAppBatch请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SparkAppId: 需要批量修改的Spark作业任务ID列表
        :type SparkAppId: list of str
        :param _DataEngine: 引擎ID
        :type DataEngine: str
        :param _AppDriverSize: driver规格：small,medium,large,xlarge；内存型(引擎类型)：m.small,m.medium,m.large,m.xlarge
        :type AppDriverSize: str
        :param _AppExecutorSize: executor规格：small,medium,large,xlarge；内存型(引擎类型)：m.small,m.medium,m.large,m.xlarge
        :type AppExecutorSize: str
        :param _AppExecutorNums: 指定executor数量，最小值为1，最大值小于集群规格
        :type AppExecutorNums: int
        :param _AppExecutorMaxNumbers: 指定executor max数量（动态配置场景下），最小值为1，最大值小于集群规格（当ExecutorMaxNumbers小于ExecutorNums时，改值设定为ExecutorNums）
        :type AppExecutorMaxNumbers: int
        :param _IsInherit: 任务资源配置是否继承集群模板，0（默认）不继承，1：继承
        :type IsInherit: int
        """
        self._SparkAppId = None
        self._DataEngine = None
        self._AppDriverSize = None
        self._AppExecutorSize = None
        self._AppExecutorNums = None
        self._AppExecutorMaxNumbers = None
        self._IsInherit = None

    @property
    def SparkAppId(self):
        r"""需要批量修改的Spark作业任务ID列表
        :rtype: list of str
        """
        return self._SparkAppId

    @SparkAppId.setter
    def SparkAppId(self, SparkAppId):
        self._SparkAppId = SparkAppId

    @property
    def DataEngine(self):
        r"""引擎ID
        :rtype: str
        """
        return self._DataEngine

    @DataEngine.setter
    def DataEngine(self, DataEngine):
        self._DataEngine = DataEngine

    @property
    def AppDriverSize(self):
        r"""driver规格：small,medium,large,xlarge；内存型(引擎类型)：m.small,m.medium,m.large,m.xlarge
        :rtype: str
        """
        return self._AppDriverSize

    @AppDriverSize.setter
    def AppDriverSize(self, AppDriverSize):
        self._AppDriverSize = AppDriverSize

    @property
    def AppExecutorSize(self):
        r"""executor规格：small,medium,large,xlarge；内存型(引擎类型)：m.small,m.medium,m.large,m.xlarge
        :rtype: str
        """
        return self._AppExecutorSize

    @AppExecutorSize.setter
    def AppExecutorSize(self, AppExecutorSize):
        self._AppExecutorSize = AppExecutorSize

    @property
    def AppExecutorNums(self):
        r"""指定executor数量，最小值为1，最大值小于集群规格
        :rtype: int
        """
        return self._AppExecutorNums

    @AppExecutorNums.setter
    def AppExecutorNums(self, AppExecutorNums):
        self._AppExecutorNums = AppExecutorNums

    @property
    def AppExecutorMaxNumbers(self):
        r"""指定executor max数量（动态配置场景下），最小值为1，最大值小于集群规格（当ExecutorMaxNumbers小于ExecutorNums时，改值设定为ExecutorNums）
        :rtype: int
        """
        return self._AppExecutorMaxNumbers

    @AppExecutorMaxNumbers.setter
    def AppExecutorMaxNumbers(self, AppExecutorMaxNumbers):
        self._AppExecutorMaxNumbers = AppExecutorMaxNumbers

    @property
    def IsInherit(self):
        r"""任务资源配置是否继承集群模板，0（默认）不继承，1：继承
        :rtype: int
        """
        return self._IsInherit

    @IsInherit.setter
    def IsInherit(self, IsInherit):
        self._IsInherit = IsInherit


    def _deserialize(self, params):
        self._SparkAppId = params.get("SparkAppId")
        self._DataEngine = params.get("DataEngine")
        self._AppDriverSize = params.get("AppDriverSize")
        self._AppExecutorSize = params.get("AppExecutorSize")
        self._AppExecutorNums = params.get("AppExecutorNums")
        self._AppExecutorMaxNumbers = params.get("AppExecutorMaxNumbers")
        self._IsInherit = params.get("IsInherit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifySparkAppBatchResponse(AbstractModel):
    r"""ModifySparkAppBatch返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifySparkAppRequest(AbstractModel):
    r"""ModifySparkApp请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AppName: spark作业名
        :type AppName: str
        :param _AppType: spark作业类型，1代表spark jar作业，2代表spark streaming作业
        :type AppType: int
        :param _DataEngine: 执行spark作业的数据引擎名称
        :type DataEngine: str
        :param _AppFile: spark作业程序包文件路径
        :type AppFile: str
        :param _RoleArn: 数据访问策略，CAM Role arn
        :type RoleArn: int
        :param _AppDriverSize: 指定的Driver规格，当前支持：small（默认，1cu）、medium（2cu）、large（4cu）、xlarge（8cu）
        :type AppDriverSize: str
        :param _AppExecutorSize: 指定的Executor规格，当前支持：small（默认，1cu）、medium（2cu）、large（4cu）、xlarge（8cu）
        :type AppExecutorSize: str
        :param _AppExecutorNums: spark作业executor个数
        :type AppExecutorNums: int
        :param _SparkAppId: spark作业Id
        :type SparkAppId: str
        :param _Eni: 该字段已下线，请使用字段Datasource
        :type Eni: str
        :param _IsLocal: spark作业程序包是否本地上传，cos：存放与cos，lakefs：本地上传（控制台使用，该方式不支持直接接口调用）
        :type IsLocal: str
        :param _MainClass: spark作业主类
        :type MainClass: str
        :param _AppConf: spark配置，以换行符分隔
        :type AppConf: str
        :param _IsLocalJars: spark 作业依赖jar包是否本地上传，cos：存放与cos，lakefs：本地上传（控制台使用，该方式不支持直接接口调用）
        :type IsLocalJars: str
        :param _AppJars: spark 作业依赖jar包（--jars），以逗号分隔
        :type AppJars: str
        :param _IsLocalFiles: spark作业依赖文件资源是否本地上传，cos：存放与cos，lakefs：本地上传（控制台使用，该方式不支持直接接口调用）
        :type IsLocalFiles: str
        :param _AppFiles: spark作业依赖文件资源（--files）（非jar、zip），以逗号分隔
        :type AppFiles: str
        :param _IsLocalPythonFiles: pyspark：依赖上传方式，cos：存放与cos，lakefs：本地上传（控制台使用，该方式不支持直接接口调用）
        :type IsLocalPythonFiles: str
        :param _AppPythonFiles: pyspark作业依赖python资源（--py-files），支持py/zip/egg等归档格式，多文件以逗号分隔
        :type AppPythonFiles: str
        :param _CmdArgs: spark作业程序入参
        :type CmdArgs: str
        :param _MaxRetries: 最大重试次数，只对spark流任务生效
        :type MaxRetries: int
        :param _DataSource: 数据源名
        :type DataSource: str
        :param _IsLocalArchives: spark作业依赖archives资源是否本地上传，cos：存放与cos，lakefs：本地上传（控制台使用，该方式不支持直接接口调用）
        :type IsLocalArchives: str
        :param _AppArchives: spark作业依赖archives资源（--archives），支持tar.gz/tgz/tar等归档格式，以逗号分隔
        :type AppArchives: str
        :param _SparkImage: Spark Image 版本号
        :type SparkImage: str
        :param _SparkImageVersion: Spark Image 版本名称
        :type SparkImageVersion: str
        :param _AppExecutorMaxNumbers: 指定的Executor数量（最大值），默认为1，当开启动态分配有效，若未开启，则该值等于AppExecutorNums
        :type AppExecutorMaxNumbers: int
        :param _SessionId: 关联dlc查询脚本
        :type SessionId: str
        :param _IsInherit: 任务资源配置是否继承集群配置模板：0（默认）不继承、1：继承
        :type IsInherit: int
        :param _IsSessionStarted: 是否使用session脚本的sql运行任务：false：否，true：是
        :type IsSessionStarted: bool
        :param _DependencyPackages: 标准引擎依赖包
        :type DependencyPackages: list of DependencyPackage
        """
        self._AppName = None
        self._AppType = None
        self._DataEngine = None
        self._AppFile = None
        self._RoleArn = None
        self._AppDriverSize = None
        self._AppExecutorSize = None
        self._AppExecutorNums = None
        self._SparkAppId = None
        self._Eni = None
        self._IsLocal = None
        self._MainClass = None
        self._AppConf = None
        self._IsLocalJars = None
        self._AppJars = None
        self._IsLocalFiles = None
        self._AppFiles = None
        self._IsLocalPythonFiles = None
        self._AppPythonFiles = None
        self._CmdArgs = None
        self._MaxRetries = None
        self._DataSource = None
        self._IsLocalArchives = None
        self._AppArchives = None
        self._SparkImage = None
        self._SparkImageVersion = None
        self._AppExecutorMaxNumbers = None
        self._SessionId = None
        self._IsInherit = None
        self._IsSessionStarted = None
        self._DependencyPackages = None

    @property
    def AppName(self):
        r"""spark作业名
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def AppType(self):
        r"""spark作业类型，1代表spark jar作业，2代表spark streaming作业
        :rtype: int
        """
        return self._AppType

    @AppType.setter
    def AppType(self, AppType):
        self._AppType = AppType

    @property
    def DataEngine(self):
        r"""执行spark作业的数据引擎名称
        :rtype: str
        """
        return self._DataEngine

    @DataEngine.setter
    def DataEngine(self, DataEngine):
        self._DataEngine = DataEngine

    @property
    def AppFile(self):
        r"""spark作业程序包文件路径
        :rtype: str
        """
        return self._AppFile

    @AppFile.setter
    def AppFile(self, AppFile):
        self._AppFile = AppFile

    @property
    def RoleArn(self):
        r"""数据访问策略，CAM Role arn
        :rtype: int
        """
        return self._RoleArn

    @RoleArn.setter
    def RoleArn(self, RoleArn):
        self._RoleArn = RoleArn

    @property
    def AppDriverSize(self):
        r"""指定的Driver规格，当前支持：small（默认，1cu）、medium（2cu）、large（4cu）、xlarge（8cu）
        :rtype: str
        """
        return self._AppDriverSize

    @AppDriverSize.setter
    def AppDriverSize(self, AppDriverSize):
        self._AppDriverSize = AppDriverSize

    @property
    def AppExecutorSize(self):
        r"""指定的Executor规格，当前支持：small（默认，1cu）、medium（2cu）、large（4cu）、xlarge（8cu）
        :rtype: str
        """
        return self._AppExecutorSize

    @AppExecutorSize.setter
    def AppExecutorSize(self, AppExecutorSize):
        self._AppExecutorSize = AppExecutorSize

    @property
    def AppExecutorNums(self):
        r"""spark作业executor个数
        :rtype: int
        """
        return self._AppExecutorNums

    @AppExecutorNums.setter
    def AppExecutorNums(self, AppExecutorNums):
        self._AppExecutorNums = AppExecutorNums

    @property
    def SparkAppId(self):
        r"""spark作业Id
        :rtype: str
        """
        return self._SparkAppId

    @SparkAppId.setter
    def SparkAppId(self, SparkAppId):
        self._SparkAppId = SparkAppId

    @property
    def Eni(self):
        r"""该字段已下线，请使用字段Datasource
        :rtype: str
        """
        return self._Eni

    @Eni.setter
    def Eni(self, Eni):
        self._Eni = Eni

    @property
    def IsLocal(self):
        r"""spark作业程序包是否本地上传，cos：存放与cos，lakefs：本地上传（控制台使用，该方式不支持直接接口调用）
        :rtype: str
        """
        return self._IsLocal

    @IsLocal.setter
    def IsLocal(self, IsLocal):
        self._IsLocal = IsLocal

    @property
    def MainClass(self):
        r"""spark作业主类
        :rtype: str
        """
        return self._MainClass

    @MainClass.setter
    def MainClass(self, MainClass):
        self._MainClass = MainClass

    @property
    def AppConf(self):
        r"""spark配置，以换行符分隔
        :rtype: str
        """
        return self._AppConf

    @AppConf.setter
    def AppConf(self, AppConf):
        self._AppConf = AppConf

    @property
    def IsLocalJars(self):
        r"""spark 作业依赖jar包是否本地上传，cos：存放与cos，lakefs：本地上传（控制台使用，该方式不支持直接接口调用）
        :rtype: str
        """
        return self._IsLocalJars

    @IsLocalJars.setter
    def IsLocalJars(self, IsLocalJars):
        self._IsLocalJars = IsLocalJars

    @property
    def AppJars(self):
        r"""spark 作业依赖jar包（--jars），以逗号分隔
        :rtype: str
        """
        return self._AppJars

    @AppJars.setter
    def AppJars(self, AppJars):
        self._AppJars = AppJars

    @property
    def IsLocalFiles(self):
        r"""spark作业依赖文件资源是否本地上传，cos：存放与cos，lakefs：本地上传（控制台使用，该方式不支持直接接口调用）
        :rtype: str
        """
        return self._IsLocalFiles

    @IsLocalFiles.setter
    def IsLocalFiles(self, IsLocalFiles):
        self._IsLocalFiles = IsLocalFiles

    @property
    def AppFiles(self):
        r"""spark作业依赖文件资源（--files）（非jar、zip），以逗号分隔
        :rtype: str
        """
        return self._AppFiles

    @AppFiles.setter
    def AppFiles(self, AppFiles):
        self._AppFiles = AppFiles

    @property
    def IsLocalPythonFiles(self):
        r"""pyspark：依赖上传方式，cos：存放与cos，lakefs：本地上传（控制台使用，该方式不支持直接接口调用）
        :rtype: str
        """
        return self._IsLocalPythonFiles

    @IsLocalPythonFiles.setter
    def IsLocalPythonFiles(self, IsLocalPythonFiles):
        self._IsLocalPythonFiles = IsLocalPythonFiles

    @property
    def AppPythonFiles(self):
        r"""pyspark作业依赖python资源（--py-files），支持py/zip/egg等归档格式，多文件以逗号分隔
        :rtype: str
        """
        return self._AppPythonFiles

    @AppPythonFiles.setter
    def AppPythonFiles(self, AppPythonFiles):
        self._AppPythonFiles = AppPythonFiles

    @property
    def CmdArgs(self):
        r"""spark作业程序入参
        :rtype: str
        """
        return self._CmdArgs

    @CmdArgs.setter
    def CmdArgs(self, CmdArgs):
        self._CmdArgs = CmdArgs

    @property
    def MaxRetries(self):
        r"""最大重试次数，只对spark流任务生效
        :rtype: int
        """
        return self._MaxRetries

    @MaxRetries.setter
    def MaxRetries(self, MaxRetries):
        self._MaxRetries = MaxRetries

    @property
    def DataSource(self):
        r"""数据源名
        :rtype: str
        """
        return self._DataSource

    @DataSource.setter
    def DataSource(self, DataSource):
        self._DataSource = DataSource

    @property
    def IsLocalArchives(self):
        r"""spark作业依赖archives资源是否本地上传，cos：存放与cos，lakefs：本地上传（控制台使用，该方式不支持直接接口调用）
        :rtype: str
        """
        return self._IsLocalArchives

    @IsLocalArchives.setter
    def IsLocalArchives(self, IsLocalArchives):
        self._IsLocalArchives = IsLocalArchives

    @property
    def AppArchives(self):
        r"""spark作业依赖archives资源（--archives），支持tar.gz/tgz/tar等归档格式，以逗号分隔
        :rtype: str
        """
        return self._AppArchives

    @AppArchives.setter
    def AppArchives(self, AppArchives):
        self._AppArchives = AppArchives

    @property
    def SparkImage(self):
        r"""Spark Image 版本号
        :rtype: str
        """
        return self._SparkImage

    @SparkImage.setter
    def SparkImage(self, SparkImage):
        self._SparkImage = SparkImage

    @property
    def SparkImageVersion(self):
        r"""Spark Image 版本名称
        :rtype: str
        """
        return self._SparkImageVersion

    @SparkImageVersion.setter
    def SparkImageVersion(self, SparkImageVersion):
        self._SparkImageVersion = SparkImageVersion

    @property
    def AppExecutorMaxNumbers(self):
        r"""指定的Executor数量（最大值），默认为1，当开启动态分配有效，若未开启，则该值等于AppExecutorNums
        :rtype: int
        """
        return self._AppExecutorMaxNumbers

    @AppExecutorMaxNumbers.setter
    def AppExecutorMaxNumbers(self, AppExecutorMaxNumbers):
        self._AppExecutorMaxNumbers = AppExecutorMaxNumbers

    @property
    def SessionId(self):
        r"""关联dlc查询脚本
        :rtype: str
        """
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def IsInherit(self):
        r"""任务资源配置是否继承集群配置模板：0（默认）不继承、1：继承
        :rtype: int
        """
        return self._IsInherit

    @IsInherit.setter
    def IsInherit(self, IsInherit):
        self._IsInherit = IsInherit

    @property
    def IsSessionStarted(self):
        r"""是否使用session脚本的sql运行任务：false：否，true：是
        :rtype: bool
        """
        return self._IsSessionStarted

    @IsSessionStarted.setter
    def IsSessionStarted(self, IsSessionStarted):
        self._IsSessionStarted = IsSessionStarted

    @property
    def DependencyPackages(self):
        r"""标准引擎依赖包
        :rtype: list of DependencyPackage
        """
        return self._DependencyPackages

    @DependencyPackages.setter
    def DependencyPackages(self, DependencyPackages):
        self._DependencyPackages = DependencyPackages


    def _deserialize(self, params):
        self._AppName = params.get("AppName")
        self._AppType = params.get("AppType")
        self._DataEngine = params.get("DataEngine")
        self._AppFile = params.get("AppFile")
        self._RoleArn = params.get("RoleArn")
        self._AppDriverSize = params.get("AppDriverSize")
        self._AppExecutorSize = params.get("AppExecutorSize")
        self._AppExecutorNums = params.get("AppExecutorNums")
        self._SparkAppId = params.get("SparkAppId")
        self._Eni = params.get("Eni")
        self._IsLocal = params.get("IsLocal")
        self._MainClass = params.get("MainClass")
        self._AppConf = params.get("AppConf")
        self._IsLocalJars = params.get("IsLocalJars")
        self._AppJars = params.get("AppJars")
        self._IsLocalFiles = params.get("IsLocalFiles")
        self._AppFiles = params.get("AppFiles")
        self._IsLocalPythonFiles = params.get("IsLocalPythonFiles")
        self._AppPythonFiles = params.get("AppPythonFiles")
        self._CmdArgs = params.get("CmdArgs")
        self._MaxRetries = params.get("MaxRetries")
        self._DataSource = params.get("DataSource")
        self._IsLocalArchives = params.get("IsLocalArchives")
        self._AppArchives = params.get("AppArchives")
        self._SparkImage = params.get("SparkImage")
        self._SparkImageVersion = params.get("SparkImageVersion")
        self._AppExecutorMaxNumbers = params.get("AppExecutorMaxNumbers")
        self._SessionId = params.get("SessionId")
        self._IsInherit = params.get("IsInherit")
        self._IsSessionStarted = params.get("IsSessionStarted")
        if params.get("DependencyPackages") is not None:
            self._DependencyPackages = []
            for item in params.get("DependencyPackages"):
                obj = DependencyPackage()
                obj._deserialize(item)
                self._DependencyPackages.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifySparkAppResponse(AbstractModel):
    r"""ModifySparkApp返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyUserRequest(AbstractModel):
    r"""ModifyUser请求参数结构体

    """

    def __init__(self):
        r"""
        :param _UserId: 用户Id，和CAM侧Uin匹配
        :type UserId: str
        :param _UserDescription: 用户描述
        :type UserDescription: str
        :param _AccountType: 用户来源类型TencentAccount（普通腾讯云用户） / EntraAccount（微软用户）
        :type AccountType: str
        """
        self._UserId = None
        self._UserDescription = None
        self._AccountType = None

    @property
    def UserId(self):
        r"""用户Id，和CAM侧Uin匹配
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def UserDescription(self):
        r"""用户描述
        :rtype: str
        """
        return self._UserDescription

    @UserDescription.setter
    def UserDescription(self, UserDescription):
        self._UserDescription = UserDescription

    @property
    def AccountType(self):
        r"""用户来源类型TencentAccount（普通腾讯云用户） / EntraAccount（微软用户）
        :rtype: str
        """
        return self._AccountType

    @AccountType.setter
    def AccountType(self, AccountType):
        self._AccountType = AccountType


    def _deserialize(self, params):
        self._UserId = params.get("UserId")
        self._UserDescription = params.get("UserDescription")
        self._AccountType = params.get("AccountType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyUserResponse(AbstractModel):
    r"""ModifyUser返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyUserTypeRequest(AbstractModel):
    r"""ModifyUserType请求参数结构体

    """

    def __init__(self):
        r"""
        :param _UserId: 用户ID
        :type UserId: str
        :param _UserType: 用户要修改到的类型，ADMIN：管理员，COMMON：一般用户。
        :type UserType: str
        :param _AccountType: 用户来源类型TencentAccount（普通腾讯云用户） / EntraAccount（微软用户）
        :type AccountType: str
        """
        self._UserId = None
        self._UserType = None
        self._AccountType = None

    @property
    def UserId(self):
        r"""用户ID
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def UserType(self):
        r"""用户要修改到的类型，ADMIN：管理员，COMMON：一般用户。
        :rtype: str
        """
        return self._UserType

    @UserType.setter
    def UserType(self, UserType):
        self._UserType = UserType

    @property
    def AccountType(self):
        r"""用户来源类型TencentAccount（普通腾讯云用户） / EntraAccount（微软用户）
        :rtype: str
        """
        return self._AccountType

    @AccountType.setter
    def AccountType(self, AccountType):
        self._AccountType = AccountType


    def _deserialize(self, params):
        self._UserId = params.get("UserId")
        self._UserType = params.get("UserType")
        self._AccountType = params.get("AccountType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyUserTypeResponse(AbstractModel):
    r"""ModifyUserType返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyWorkGroupRequest(AbstractModel):
    r"""ModifyWorkGroup请求参数结构体

    """

    def __init__(self):
        r"""
        :param _WorkGroupId: 工作组Id
        :type WorkGroupId: int
        :param _WorkGroupDescription: 工作组描述，最大字符数限制50
        :type WorkGroupDescription: str
        """
        self._WorkGroupId = None
        self._WorkGroupDescription = None

    @property
    def WorkGroupId(self):
        r"""工作组Id
        :rtype: int
        """
        return self._WorkGroupId

    @WorkGroupId.setter
    def WorkGroupId(self, WorkGroupId):
        self._WorkGroupId = WorkGroupId

    @property
    def WorkGroupDescription(self):
        r"""工作组描述，最大字符数限制50
        :rtype: str
        """
        return self._WorkGroupDescription

    @WorkGroupDescription.setter
    def WorkGroupDescription(self, WorkGroupDescription):
        self._WorkGroupDescription = WorkGroupDescription


    def _deserialize(self, params):
        self._WorkGroupId = params.get("WorkGroupId")
        self._WorkGroupDescription = params.get("WorkGroupDescription")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyWorkGroupResponse(AbstractModel):
    r"""ModifyWorkGroup返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class MountPointAssociates(AbstractModel):
    r"""绑定融合桶信息

    """

    def __init__(self):
        r"""
        :param _BucketId: 桶Id
        :type BucketId: str
        :param _VpcId: vpcId
        :type VpcId: str
        :param _VpcCidrBlock: 子网地址
        :type VpcCidrBlock: str
        :param _AccessGroupId: 权限组Id
        :type AccessGroupId: str
        :param _AccessRuleId: 权限规则Id
        :type AccessRuleId: int
        """
        self._BucketId = None
        self._VpcId = None
        self._VpcCidrBlock = None
        self._AccessGroupId = None
        self._AccessRuleId = None

    @property
    def BucketId(self):
        r"""桶Id
        :rtype: str
        """
        return self._BucketId

    @BucketId.setter
    def BucketId(self, BucketId):
        self._BucketId = BucketId

    @property
    def VpcId(self):
        r"""vpcId
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def VpcCidrBlock(self):
        r"""子网地址
        :rtype: str
        """
        return self._VpcCidrBlock

    @VpcCidrBlock.setter
    def VpcCidrBlock(self, VpcCidrBlock):
        self._VpcCidrBlock = VpcCidrBlock

    @property
    def AccessGroupId(self):
        r"""权限组Id
        :rtype: str
        """
        return self._AccessGroupId

    @AccessGroupId.setter
    def AccessGroupId(self, AccessGroupId):
        self._AccessGroupId = AccessGroupId

    @property
    def AccessRuleId(self):
        r"""权限规则Id
        :rtype: int
        """
        return self._AccessRuleId

    @AccessRuleId.setter
    def AccessRuleId(self, AccessRuleId):
        self._AccessRuleId = AccessRuleId


    def _deserialize(self, params):
        self._BucketId = params.get("BucketId")
        self._VpcId = params.get("VpcId")
        self._VpcCidrBlock = params.get("VpcCidrBlock")
        self._AccessGroupId = params.get("AccessGroupId")
        self._AccessRuleId = params.get("AccessRuleId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MysqlInfo(AbstractModel):
    r"""Mysql类型数据源信息

    """

    def __init__(self):
        r"""
        :param _JdbcUrl: 连接mysql的jdbc url
        :type JdbcUrl: str
        :param _User: 用户名
        :type User: str
        :param _Password: mysql密码
        :type Password: str
        :param _Location: mysql数据源的网络信息
        :type Location: :class:`tencentcloud.dlc.v20210125.models.DatasourceConnectionLocation`
        :param _DbName: 数据库名称
        :type DbName: str
        :param _InstanceId: 数据库实例ID，和数据库侧保持一致
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceId: str
        :param _InstanceName: 数据库实例名称，和数据库侧保持一致
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceName: str
        """
        self._JdbcUrl = None
        self._User = None
        self._Password = None
        self._Location = None
        self._DbName = None
        self._InstanceId = None
        self._InstanceName = None

    @property
    def JdbcUrl(self):
        r"""连接mysql的jdbc url
        :rtype: str
        """
        return self._JdbcUrl

    @JdbcUrl.setter
    def JdbcUrl(self, JdbcUrl):
        self._JdbcUrl = JdbcUrl

    @property
    def User(self):
        r"""用户名
        :rtype: str
        """
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def Password(self):
        r"""mysql密码
        :rtype: str
        """
        return self._Password

    @Password.setter
    def Password(self, Password):
        self._Password = Password

    @property
    def Location(self):
        r"""mysql数据源的网络信息
        :rtype: :class:`tencentcloud.dlc.v20210125.models.DatasourceConnectionLocation`
        """
        return self._Location

    @Location.setter
    def Location(self, Location):
        self._Location = Location

    @property
    def DbName(self):
        r"""数据库名称
        :rtype: str
        """
        return self._DbName

    @DbName.setter
    def DbName(self, DbName):
        self._DbName = DbName

    @property
    def InstanceId(self):
        r"""数据库实例ID，和数据库侧保持一致
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def InstanceName(self):
        r"""数据库实例名称，和数据库侧保持一致
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName


    def _deserialize(self, params):
        self._JdbcUrl = params.get("JdbcUrl")
        self._User = params.get("User")
        self._Password = params.get("Password")
        if params.get("Location") is not None:
            self._Location = DatasourceConnectionLocation()
            self._Location._deserialize(params.get("Location"))
        self._DbName = params.get("DbName")
        self._InstanceId = params.get("InstanceId")
        self._InstanceName = params.get("InstanceName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NetWork(AbstractModel):
    r"""网络配置信息

    """

    def __init__(self):
        r"""
        :param _ClbIp: 服务clbip
        :type ClbIp: str
        :param _ClbPort: 服务clbPort
        :type ClbPort: str
        :param _VpcId: vpc实例id
        :type VpcId: str
        :param _VpcCidrBlock: vpc网段
        :type VpcCidrBlock: str
        :param _SubnetId: 子网实例id
        :type SubnetId: str
        :param _SubnetCidrBlock: 子网网段
        :type SubnetCidrBlock: str
        """
        self._ClbIp = None
        self._ClbPort = None
        self._VpcId = None
        self._VpcCidrBlock = None
        self._SubnetId = None
        self._SubnetCidrBlock = None

    @property
    def ClbIp(self):
        r"""服务clbip
        :rtype: str
        """
        return self._ClbIp

    @ClbIp.setter
    def ClbIp(self, ClbIp):
        self._ClbIp = ClbIp

    @property
    def ClbPort(self):
        r"""服务clbPort
        :rtype: str
        """
        return self._ClbPort

    @ClbPort.setter
    def ClbPort(self, ClbPort):
        self._ClbPort = ClbPort

    @property
    def VpcId(self):
        r"""vpc实例id
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def VpcCidrBlock(self):
        r"""vpc网段
        :rtype: str
        """
        return self._VpcCidrBlock

    @VpcCidrBlock.setter
    def VpcCidrBlock(self, VpcCidrBlock):
        self._VpcCidrBlock = VpcCidrBlock

    @property
    def SubnetId(self):
        r"""子网实例id
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def SubnetCidrBlock(self):
        r"""子网网段
        :rtype: str
        """
        return self._SubnetCidrBlock

    @SubnetCidrBlock.setter
    def SubnetCidrBlock(self, SubnetCidrBlock):
        self._SubnetCidrBlock = SubnetCidrBlock


    def _deserialize(self, params):
        self._ClbIp = params.get("ClbIp")
        self._ClbPort = params.get("ClbPort")
        self._VpcId = params.get("VpcId")
        self._VpcCidrBlock = params.get("VpcCidrBlock")
        self._SubnetId = params.get("SubnetId")
        self._SubnetCidrBlock = params.get("SubnetCidrBlock")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NetworkConnection(AbstractModel):
    r"""网络配置

    """

    def __init__(self):
        r"""
        :param _Id: 网络配置id
        :type Id: int
        :param _AssociateId: 网络配置唯一标志符
        :type AssociateId: str
        :param _HouseId: 计算引擎id
        :type HouseId: str
        :param _DatasourceConnectionId: 数据源id(已废弃)
        :type DatasourceConnectionId: str
        :param _State: 网络配置状态（0-初始化，1-正常）
注意：此字段可能返回 null，表示取不到有效值。
        :type State: int
        :param _CreateTime: 创建时间
        :type CreateTime: int
        :param _UpdateTime: 修改时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: int
        :param _Appid: 创建用户Appid
注意：此字段可能返回 null，表示取不到有效值。
        :type Appid: int
        :param _HouseName: 计算引擎名称
        :type HouseName: str
        :param _DatasourceConnectionName: 网络配置名称
        :type DatasourceConnectionName: str
        :param _NetworkConnectionType: 网络配置类型
注意：此字段可能返回 null，表示取不到有效值。
        :type NetworkConnectionType: int
        :param _Uin: 创建用户uin
注意：此字段可能返回 null，表示取不到有效值。
        :type Uin: str
        :param _SubAccountUin: 创建用户SubAccountUin
注意：此字段可能返回 null，表示取不到有效值。
        :type SubAccountUin: str
        :param _NetworkConnectionDesc: 网络配置描述
注意：此字段可能返回 null，表示取不到有效值。
        :type NetworkConnectionDesc: str
        :param _DatasourceConnectionVpcId: 数据源vpcid
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceConnectionVpcId: str
        :param _DatasourceConnectionSubnetId: 数据源SubnetId
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceConnectionSubnetId: str
        :param _DatasourceConnectionCidrBlock: 数据源SubnetId
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceConnectionCidrBlock: str
        :param _DatasourceConnectionSubnetCidrBlock: 数据源SubnetCidrBlock
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceConnectionSubnetCidrBlock: str
        :param _EGSupport: 支持 eg
        :type EGSupport: int
        """
        self._Id = None
        self._AssociateId = None
        self._HouseId = None
        self._DatasourceConnectionId = None
        self._State = None
        self._CreateTime = None
        self._UpdateTime = None
        self._Appid = None
        self._HouseName = None
        self._DatasourceConnectionName = None
        self._NetworkConnectionType = None
        self._Uin = None
        self._SubAccountUin = None
        self._NetworkConnectionDesc = None
        self._DatasourceConnectionVpcId = None
        self._DatasourceConnectionSubnetId = None
        self._DatasourceConnectionCidrBlock = None
        self._DatasourceConnectionSubnetCidrBlock = None
        self._EGSupport = None

    @property
    def Id(self):
        r"""网络配置id
        :rtype: int
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def AssociateId(self):
        r"""网络配置唯一标志符
        :rtype: str
        """
        return self._AssociateId

    @AssociateId.setter
    def AssociateId(self, AssociateId):
        self._AssociateId = AssociateId

    @property
    def HouseId(self):
        r"""计算引擎id
        :rtype: str
        """
        return self._HouseId

    @HouseId.setter
    def HouseId(self, HouseId):
        self._HouseId = HouseId

    @property
    def DatasourceConnectionId(self):
        r"""数据源id(已废弃)
        :rtype: str
        """
        return self._DatasourceConnectionId

    @DatasourceConnectionId.setter
    def DatasourceConnectionId(self, DatasourceConnectionId):
        self._DatasourceConnectionId = DatasourceConnectionId

    @property
    def State(self):
        r"""网络配置状态（0-初始化，1-正常）
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def CreateTime(self):
        r"""创建时间
        :rtype: int
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""修改时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def Appid(self):
        r"""创建用户Appid
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Appid

    @Appid.setter
    def Appid(self, Appid):
        self._Appid = Appid

    @property
    def HouseName(self):
        r"""计算引擎名称
        :rtype: str
        """
        return self._HouseName

    @HouseName.setter
    def HouseName(self, HouseName):
        self._HouseName = HouseName

    @property
    def DatasourceConnectionName(self):
        r"""网络配置名称
        :rtype: str
        """
        return self._DatasourceConnectionName

    @DatasourceConnectionName.setter
    def DatasourceConnectionName(self, DatasourceConnectionName):
        self._DatasourceConnectionName = DatasourceConnectionName

    @property
    def NetworkConnectionType(self):
        r"""网络配置类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._NetworkConnectionType

    @NetworkConnectionType.setter
    def NetworkConnectionType(self, NetworkConnectionType):
        self._NetworkConnectionType = NetworkConnectionType

    @property
    def Uin(self):
        r"""创建用户uin
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Uin

    @Uin.setter
    def Uin(self, Uin):
        self._Uin = Uin

    @property
    def SubAccountUin(self):
        r"""创建用户SubAccountUin
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SubAccountUin

    @SubAccountUin.setter
    def SubAccountUin(self, SubAccountUin):
        self._SubAccountUin = SubAccountUin

    @property
    def NetworkConnectionDesc(self):
        r"""网络配置描述
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._NetworkConnectionDesc

    @NetworkConnectionDesc.setter
    def NetworkConnectionDesc(self, NetworkConnectionDesc):
        self._NetworkConnectionDesc = NetworkConnectionDesc

    @property
    def DatasourceConnectionVpcId(self):
        r"""数据源vpcid
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatasourceConnectionVpcId

    @DatasourceConnectionVpcId.setter
    def DatasourceConnectionVpcId(self, DatasourceConnectionVpcId):
        self._DatasourceConnectionVpcId = DatasourceConnectionVpcId

    @property
    def DatasourceConnectionSubnetId(self):
        r"""数据源SubnetId
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatasourceConnectionSubnetId

    @DatasourceConnectionSubnetId.setter
    def DatasourceConnectionSubnetId(self, DatasourceConnectionSubnetId):
        self._DatasourceConnectionSubnetId = DatasourceConnectionSubnetId

    @property
    def DatasourceConnectionCidrBlock(self):
        r"""数据源SubnetId
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatasourceConnectionCidrBlock

    @DatasourceConnectionCidrBlock.setter
    def DatasourceConnectionCidrBlock(self, DatasourceConnectionCidrBlock):
        self._DatasourceConnectionCidrBlock = DatasourceConnectionCidrBlock

    @property
    def DatasourceConnectionSubnetCidrBlock(self):
        r"""数据源SubnetCidrBlock
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatasourceConnectionSubnetCidrBlock

    @DatasourceConnectionSubnetCidrBlock.setter
    def DatasourceConnectionSubnetCidrBlock(self, DatasourceConnectionSubnetCidrBlock):
        self._DatasourceConnectionSubnetCidrBlock = DatasourceConnectionSubnetCidrBlock

    @property
    def EGSupport(self):
        r"""支持 eg
        :rtype: int
        """
        return self._EGSupport

    @EGSupport.setter
    def EGSupport(self, EGSupport):
        self._EGSupport = EGSupport


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._AssociateId = params.get("AssociateId")
        self._HouseId = params.get("HouseId")
        self._DatasourceConnectionId = params.get("DatasourceConnectionId")
        self._State = params.get("State")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._Appid = params.get("Appid")
        self._HouseName = params.get("HouseName")
        self._DatasourceConnectionName = params.get("DatasourceConnectionName")
        self._NetworkConnectionType = params.get("NetworkConnectionType")
        self._Uin = params.get("Uin")
        self._SubAccountUin = params.get("SubAccountUin")
        self._NetworkConnectionDesc = params.get("NetworkConnectionDesc")
        self._DatasourceConnectionVpcId = params.get("DatasourceConnectionVpcId")
        self._DatasourceConnectionSubnetId = params.get("DatasourceConnectionSubnetId")
        self._DatasourceConnectionCidrBlock = params.get("DatasourceConnectionCidrBlock")
        self._DatasourceConnectionSubnetCidrBlock = params.get("DatasourceConnectionSubnetCidrBlock")
        self._EGSupport = params.get("EGSupport")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NotebookSessionInfo(AbstractModel):
    r"""Notebook Session详细信息。

    """

    def __init__(self):
        r"""
        :param _Name: Session名称
        :type Name: str
        :param _Kind: 类型，当前支持：spark、pyspark、sparkr、sql
        :type Kind: str
        :param _DataEngineName: DLC Spark作业引擎名称
        :type DataEngineName: str
        :param _Arguments: Session相关配置，当前支持：eni、roleArn以及用户指定的配置
注意：此字段可能返回 null，表示取不到有效值。
        :type Arguments: list of KVPair
        :param _ProgramDependentFiles: 运行程序地址，当前支持：cosn://和lakefs://两种路径
注意：此字段可能返回 null，表示取不到有效值。
        :type ProgramDependentFiles: list of str
        :param _ProgramDependentJars: 依赖的jar程序地址，当前支持：cosn://和lakefs://两种路径
注意：此字段可能返回 null，表示取不到有效值。
        :type ProgramDependentJars: list of str
        :param _ProgramDependentPython: 依赖的python程序地址，当前支持：cosn://和lakefs://两种路径
注意：此字段可能返回 null，表示取不到有效值。
        :type ProgramDependentPython: list of str
        :param _ProgramArchives: 依赖的pyspark虚拟环境地址，当前支持：cosn://和lakefs://两种路径
注意：此字段可能返回 null，表示取不到有效值。
        :type ProgramArchives: list of str
        :param _DriverSize: 指定的Driver规格，当前支持：small（默认，1cu）、medium（2cu）、large（4cu）、xlarge（8cu）
        :type DriverSize: str
        :param _ExecutorSize: 指定的Executor规格，当前支持：small（默认，1cu）、medium（2cu）、large（4cu）、xlarge（8cu）
        :type ExecutorSize: str
        :param _ExecutorNumbers: 指定的Executor数量，默认为1
        :type ExecutorNumbers: int
        :param _ProxyUser: 代理用户，默认为root
        :type ProxyUser: str
        :param _TimeoutInSecond: 指定的Session超时时间，单位秒，默认3600秒
        :type TimeoutInSecond: int
        :param _SparkAppId: Spark任务返回的AppId
        :type SparkAppId: str
        :param _SessionId: Session唯一标识
        :type SessionId: str
        :param _State: Session状态，包含：not_started（未启动）、starting（已启动）、idle（等待输入）、busy(正在运行statement)、shutting_down（停止）、error（异常）、dead（已退出）、killed（被杀死）、success（正常停止）
        :type State: str
        :param _CreateTime: Session创建时间
        :type CreateTime: str
        :param _AppInfo: 其它信息
注意：此字段可能返回 null，表示取不到有效值。
        :type AppInfo: list of KVPair
        :param _SparkUiUrl: Spark ui地址
        :type SparkUiUrl: str
        :param _ExecutorMaxNumbers: 指定的Executor数量（最大值），默认为1，当开启动态分配有效，若未开启，则该值等于ExecutorNumbers
        :type ExecutorMaxNumbers: int
        :param _SessionType: session类型，group：资源组下session independent：独立资源session， 不依赖资源组
        :type SessionType: str
        :param _DataEngineId: 引擎id
        :type DataEngineId: str
        :param _ResourceGroupId: 资源组id
        :type ResourceGroupId: str
        :param _ResourceGroupName: 资源组名称
        :type ResourceGroupName: str
        :param _PodSize: session，pod大小
        :type PodSize: int
        :param _PodNumbers: pod数量
        :type PodNumbers: int
        """
        self._Name = None
        self._Kind = None
        self._DataEngineName = None
        self._Arguments = None
        self._ProgramDependentFiles = None
        self._ProgramDependentJars = None
        self._ProgramDependentPython = None
        self._ProgramArchives = None
        self._DriverSize = None
        self._ExecutorSize = None
        self._ExecutorNumbers = None
        self._ProxyUser = None
        self._TimeoutInSecond = None
        self._SparkAppId = None
        self._SessionId = None
        self._State = None
        self._CreateTime = None
        self._AppInfo = None
        self._SparkUiUrl = None
        self._ExecutorMaxNumbers = None
        self._SessionType = None
        self._DataEngineId = None
        self._ResourceGroupId = None
        self._ResourceGroupName = None
        self._PodSize = None
        self._PodNumbers = None

    @property
    def Name(self):
        r"""Session名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Kind(self):
        r"""类型，当前支持：spark、pyspark、sparkr、sql
        :rtype: str
        """
        return self._Kind

    @Kind.setter
    def Kind(self, Kind):
        self._Kind = Kind

    @property
    def DataEngineName(self):
        r"""DLC Spark作业引擎名称
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName

    @property
    def Arguments(self):
        r"""Session相关配置，当前支持：eni、roleArn以及用户指定的配置
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of KVPair
        """
        return self._Arguments

    @Arguments.setter
    def Arguments(self, Arguments):
        self._Arguments = Arguments

    @property
    def ProgramDependentFiles(self):
        r"""运行程序地址，当前支持：cosn://和lakefs://两种路径
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._ProgramDependentFiles

    @ProgramDependentFiles.setter
    def ProgramDependentFiles(self, ProgramDependentFiles):
        self._ProgramDependentFiles = ProgramDependentFiles

    @property
    def ProgramDependentJars(self):
        r"""依赖的jar程序地址，当前支持：cosn://和lakefs://两种路径
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._ProgramDependentJars

    @ProgramDependentJars.setter
    def ProgramDependentJars(self, ProgramDependentJars):
        self._ProgramDependentJars = ProgramDependentJars

    @property
    def ProgramDependentPython(self):
        r"""依赖的python程序地址，当前支持：cosn://和lakefs://两种路径
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._ProgramDependentPython

    @ProgramDependentPython.setter
    def ProgramDependentPython(self, ProgramDependentPython):
        self._ProgramDependentPython = ProgramDependentPython

    @property
    def ProgramArchives(self):
        r"""依赖的pyspark虚拟环境地址，当前支持：cosn://和lakefs://两种路径
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._ProgramArchives

    @ProgramArchives.setter
    def ProgramArchives(self, ProgramArchives):
        self._ProgramArchives = ProgramArchives

    @property
    def DriverSize(self):
        r"""指定的Driver规格，当前支持：small（默认，1cu）、medium（2cu）、large（4cu）、xlarge（8cu）
        :rtype: str
        """
        return self._DriverSize

    @DriverSize.setter
    def DriverSize(self, DriverSize):
        self._DriverSize = DriverSize

    @property
    def ExecutorSize(self):
        r"""指定的Executor规格，当前支持：small（默认，1cu）、medium（2cu）、large（4cu）、xlarge（8cu）
        :rtype: str
        """
        return self._ExecutorSize

    @ExecutorSize.setter
    def ExecutorSize(self, ExecutorSize):
        self._ExecutorSize = ExecutorSize

    @property
    def ExecutorNumbers(self):
        r"""指定的Executor数量，默认为1
        :rtype: int
        """
        return self._ExecutorNumbers

    @ExecutorNumbers.setter
    def ExecutorNumbers(self, ExecutorNumbers):
        self._ExecutorNumbers = ExecutorNumbers

    @property
    def ProxyUser(self):
        r"""代理用户，默认为root
        :rtype: str
        """
        return self._ProxyUser

    @ProxyUser.setter
    def ProxyUser(self, ProxyUser):
        self._ProxyUser = ProxyUser

    @property
    def TimeoutInSecond(self):
        r"""指定的Session超时时间，单位秒，默认3600秒
        :rtype: int
        """
        return self._TimeoutInSecond

    @TimeoutInSecond.setter
    def TimeoutInSecond(self, TimeoutInSecond):
        self._TimeoutInSecond = TimeoutInSecond

    @property
    def SparkAppId(self):
        r"""Spark任务返回的AppId
        :rtype: str
        """
        return self._SparkAppId

    @SparkAppId.setter
    def SparkAppId(self, SparkAppId):
        self._SparkAppId = SparkAppId

    @property
    def SessionId(self):
        r"""Session唯一标识
        :rtype: str
        """
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def State(self):
        r"""Session状态，包含：not_started（未启动）、starting（已启动）、idle（等待输入）、busy(正在运行statement)、shutting_down（停止）、error（异常）、dead（已退出）、killed（被杀死）、success（正常停止）
        :rtype: str
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def CreateTime(self):
        r"""Session创建时间
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def AppInfo(self):
        r"""其它信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of KVPair
        """
        return self._AppInfo

    @AppInfo.setter
    def AppInfo(self, AppInfo):
        self._AppInfo = AppInfo

    @property
    def SparkUiUrl(self):
        r"""Spark ui地址
        :rtype: str
        """
        return self._SparkUiUrl

    @SparkUiUrl.setter
    def SparkUiUrl(self, SparkUiUrl):
        self._SparkUiUrl = SparkUiUrl

    @property
    def ExecutorMaxNumbers(self):
        r"""指定的Executor数量（最大值），默认为1，当开启动态分配有效，若未开启，则该值等于ExecutorNumbers
        :rtype: int
        """
        return self._ExecutorMaxNumbers

    @ExecutorMaxNumbers.setter
    def ExecutorMaxNumbers(self, ExecutorMaxNumbers):
        self._ExecutorMaxNumbers = ExecutorMaxNumbers

    @property
    def SessionType(self):
        r"""session类型，group：资源组下session independent：独立资源session， 不依赖资源组
        :rtype: str
        """
        return self._SessionType

    @SessionType.setter
    def SessionType(self, SessionType):
        self._SessionType = SessionType

    @property
    def DataEngineId(self):
        r"""引擎id
        :rtype: str
        """
        return self._DataEngineId

    @DataEngineId.setter
    def DataEngineId(self, DataEngineId):
        self._DataEngineId = DataEngineId

    @property
    def ResourceGroupId(self):
        r"""资源组id
        :rtype: str
        """
        return self._ResourceGroupId

    @ResourceGroupId.setter
    def ResourceGroupId(self, ResourceGroupId):
        self._ResourceGroupId = ResourceGroupId

    @property
    def ResourceGroupName(self):
        r"""资源组名称
        :rtype: str
        """
        return self._ResourceGroupName

    @ResourceGroupName.setter
    def ResourceGroupName(self, ResourceGroupName):
        self._ResourceGroupName = ResourceGroupName

    @property
    def PodSize(self):
        r"""session，pod大小
        :rtype: int
        """
        return self._PodSize

    @PodSize.setter
    def PodSize(self, PodSize):
        self._PodSize = PodSize

    @property
    def PodNumbers(self):
        r"""pod数量
        :rtype: int
        """
        return self._PodNumbers

    @PodNumbers.setter
    def PodNumbers(self, PodNumbers):
        self._PodNumbers = PodNumbers


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Kind = params.get("Kind")
        self._DataEngineName = params.get("DataEngineName")
        if params.get("Arguments") is not None:
            self._Arguments = []
            for item in params.get("Arguments"):
                obj = KVPair()
                obj._deserialize(item)
                self._Arguments.append(obj)
        self._ProgramDependentFiles = params.get("ProgramDependentFiles")
        self._ProgramDependentJars = params.get("ProgramDependentJars")
        self._ProgramDependentPython = params.get("ProgramDependentPython")
        self._ProgramArchives = params.get("ProgramArchives")
        self._DriverSize = params.get("DriverSize")
        self._ExecutorSize = params.get("ExecutorSize")
        self._ExecutorNumbers = params.get("ExecutorNumbers")
        self._ProxyUser = params.get("ProxyUser")
        self._TimeoutInSecond = params.get("TimeoutInSecond")
        self._SparkAppId = params.get("SparkAppId")
        self._SessionId = params.get("SessionId")
        self._State = params.get("State")
        self._CreateTime = params.get("CreateTime")
        if params.get("AppInfo") is not None:
            self._AppInfo = []
            for item in params.get("AppInfo"):
                obj = KVPair()
                obj._deserialize(item)
                self._AppInfo.append(obj)
        self._SparkUiUrl = params.get("SparkUiUrl")
        self._ExecutorMaxNumbers = params.get("ExecutorMaxNumbers")
        self._SessionType = params.get("SessionType")
        self._DataEngineId = params.get("DataEngineId")
        self._ResourceGroupId = params.get("ResourceGroupId")
        self._ResourceGroupName = params.get("ResourceGroupName")
        self._PodSize = params.get("PodSize")
        self._PodNumbers = params.get("PodNumbers")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NotebookSessionStatementBatchInformation(AbstractModel):
    r"""按批提交Statement运行SQL任务。

    """

    def __init__(self):
        r"""
        :param _NotebookSessionStatementBatch: 任务详情列表
注意：此字段可能返回 null，表示取不到有效值。
        :type NotebookSessionStatementBatch: list of NotebookSessionStatementInfo
        :param _IsAvailable: 当前批任务是否运行完成
        :type IsAvailable: bool
        :param _SessionId: Session唯一标识
        :type SessionId: str
        :param _BatchId: Batch唯一标识
注意：此字段可能返回 null，表示取不到有效值。
        :type BatchId: str
        """
        self._NotebookSessionStatementBatch = None
        self._IsAvailable = None
        self._SessionId = None
        self._BatchId = None

    @property
    def NotebookSessionStatementBatch(self):
        r"""任务详情列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of NotebookSessionStatementInfo
        """
        return self._NotebookSessionStatementBatch

    @NotebookSessionStatementBatch.setter
    def NotebookSessionStatementBatch(self, NotebookSessionStatementBatch):
        self._NotebookSessionStatementBatch = NotebookSessionStatementBatch

    @property
    def IsAvailable(self):
        r"""当前批任务是否运行完成
        :rtype: bool
        """
        return self._IsAvailable

    @IsAvailable.setter
    def IsAvailable(self, IsAvailable):
        self._IsAvailable = IsAvailable

    @property
    def SessionId(self):
        r"""Session唯一标识
        :rtype: str
        """
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def BatchId(self):
        r"""Batch唯一标识
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._BatchId

    @BatchId.setter
    def BatchId(self, BatchId):
        self._BatchId = BatchId


    def _deserialize(self, params):
        if params.get("NotebookSessionStatementBatch") is not None:
            self._NotebookSessionStatementBatch = []
            for item in params.get("NotebookSessionStatementBatch"):
                obj = NotebookSessionStatementInfo()
                obj._deserialize(item)
                self._NotebookSessionStatementBatch.append(obj)
        self._IsAvailable = params.get("IsAvailable")
        self._SessionId = params.get("SessionId")
        self._BatchId = params.get("BatchId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NotebookSessionStatementInfo(AbstractModel):
    r"""NotebookSessionStatement详情。

    """

    def __init__(self):
        r"""
        :param _Completed: 完成时间戳
        :type Completed: int
        :param _Started: 开始时间戳
        :type Started: int
        :param _Progress: 完成进度，百分制
        :type Progress: float
        :param _StatementId: Session Statement唯一标识
        :type StatementId: str
        :param _State: Session Statement状态，包含：waiting（排队中）、running（运行中）、available（正常）、error（异常）、cancelling（取消中）、cancelled（已取消）
        :type State: str
        :param _OutPut: Statement输出信息
注意：此字段可能返回 null，表示取不到有效值。
        :type OutPut: :class:`tencentcloud.dlc.v20210125.models.StatementOutput`
        :param _BatchId: 批任务id
        :type BatchId: str
        :param _Code: 运行语句
        :type Code: str
        :param _TaskId: 任务ID
        :type TaskId: str
        """
        self._Completed = None
        self._Started = None
        self._Progress = None
        self._StatementId = None
        self._State = None
        self._OutPut = None
        self._BatchId = None
        self._Code = None
        self._TaskId = None

    @property
    def Completed(self):
        r"""完成时间戳
        :rtype: int
        """
        return self._Completed

    @Completed.setter
    def Completed(self, Completed):
        self._Completed = Completed

    @property
    def Started(self):
        r"""开始时间戳
        :rtype: int
        """
        return self._Started

    @Started.setter
    def Started(self, Started):
        self._Started = Started

    @property
    def Progress(self):
        r"""完成进度，百分制
        :rtype: float
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def StatementId(self):
        r"""Session Statement唯一标识
        :rtype: str
        """
        return self._StatementId

    @StatementId.setter
    def StatementId(self, StatementId):
        self._StatementId = StatementId

    @property
    def State(self):
        r"""Session Statement状态，包含：waiting（排队中）、running（运行中）、available（正常）、error（异常）、cancelling（取消中）、cancelled（已取消）
        :rtype: str
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def OutPut(self):
        r"""Statement输出信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.dlc.v20210125.models.StatementOutput`
        """
        return self._OutPut

    @OutPut.setter
    def OutPut(self, OutPut):
        self._OutPut = OutPut

    @property
    def BatchId(self):
        r"""批任务id
        :rtype: str
        """
        return self._BatchId

    @BatchId.setter
    def BatchId(self, BatchId):
        self._BatchId = BatchId

    @property
    def Code(self):
        r"""运行语句
        :rtype: str
        """
        return self._Code

    @Code.setter
    def Code(self, Code):
        self._Code = Code

    @property
    def TaskId(self):
        r"""任务ID
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._Completed = params.get("Completed")
        self._Started = params.get("Started")
        self._Progress = params.get("Progress")
        self._StatementId = params.get("StatementId")
        self._State = params.get("State")
        if params.get("OutPut") is not None:
            self._OutPut = StatementOutput()
            self._OutPut._deserialize(params.get("OutPut"))
        self._BatchId = params.get("BatchId")
        self._Code = params.get("Code")
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NotebookSessions(AbstractModel):
    r"""notebook session列表信息。

    """

    def __init__(self):
        r"""
        :param _Kind: 类型，当前支持：spark、pyspark、sparkr、sql
        :type Kind: str
        :param _SessionId: Session唯一标识
        :type SessionId: str
        :param _ProxyUser: 代理用户，默认为root
        :type ProxyUser: str
        :param _State: Session状态，包含：not_started（未启动）、starting（已启动）、idle（等待输入）、busy(正在运行statement)、shutting_down（停止）、error（异常）、dead（已退出）、killed（被杀死）、success（正常停止）
        :type State: str
        :param _SparkAppId: Spark任务返回的AppId
        :type SparkAppId: str
        :param _Name: Session名称
        :type Name: str
        :param _CreateTime: Session创建时间
        :type CreateTime: str
        :param _DataEngineName: 引擎名称
        :type DataEngineName: str
        :param _LastRunningTime: 最新的运行时间
        :type LastRunningTime: str
        :param _Creator: 创建者
        :type Creator: str
        :param _SparkUiUrl: spark ui地址
        :type SparkUiUrl: str
        :param _SessionType: session类型，group：资源组session independent：独立资源session，不依赖资源组
        :type SessionType: str
        :param _DataEngineId: 引擎id
        :type DataEngineId: str
        :param _ResourceGroupId: 资源组id
        :type ResourceGroupId: str
        :param _ResourceGroupName: 资源组名字
        :type ResourceGroupName: str
        """
        self._Kind = None
        self._SessionId = None
        self._ProxyUser = None
        self._State = None
        self._SparkAppId = None
        self._Name = None
        self._CreateTime = None
        self._DataEngineName = None
        self._LastRunningTime = None
        self._Creator = None
        self._SparkUiUrl = None
        self._SessionType = None
        self._DataEngineId = None
        self._ResourceGroupId = None
        self._ResourceGroupName = None

    @property
    def Kind(self):
        r"""类型，当前支持：spark、pyspark、sparkr、sql
        :rtype: str
        """
        return self._Kind

    @Kind.setter
    def Kind(self, Kind):
        self._Kind = Kind

    @property
    def SessionId(self):
        r"""Session唯一标识
        :rtype: str
        """
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def ProxyUser(self):
        r"""代理用户，默认为root
        :rtype: str
        """
        return self._ProxyUser

    @ProxyUser.setter
    def ProxyUser(self, ProxyUser):
        self._ProxyUser = ProxyUser

    @property
    def State(self):
        r"""Session状态，包含：not_started（未启动）、starting（已启动）、idle（等待输入）、busy(正在运行statement)、shutting_down（停止）、error（异常）、dead（已退出）、killed（被杀死）、success（正常停止）
        :rtype: str
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def SparkAppId(self):
        r"""Spark任务返回的AppId
        :rtype: str
        """
        return self._SparkAppId

    @SparkAppId.setter
    def SparkAppId(self, SparkAppId):
        self._SparkAppId = SparkAppId

    @property
    def Name(self):
        r"""Session名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def CreateTime(self):
        r"""Session创建时间
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def DataEngineName(self):
        r"""引擎名称
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName

    @property
    def LastRunningTime(self):
        r"""最新的运行时间
        :rtype: str
        """
        return self._LastRunningTime

    @LastRunningTime.setter
    def LastRunningTime(self, LastRunningTime):
        self._LastRunningTime = LastRunningTime

    @property
    def Creator(self):
        r"""创建者
        :rtype: str
        """
        return self._Creator

    @Creator.setter
    def Creator(self, Creator):
        self._Creator = Creator

    @property
    def SparkUiUrl(self):
        r"""spark ui地址
        :rtype: str
        """
        return self._SparkUiUrl

    @SparkUiUrl.setter
    def SparkUiUrl(self, SparkUiUrl):
        self._SparkUiUrl = SparkUiUrl

    @property
    def SessionType(self):
        r"""session类型，group：资源组session independent：独立资源session，不依赖资源组
        :rtype: str
        """
        return self._SessionType

    @SessionType.setter
    def SessionType(self, SessionType):
        self._SessionType = SessionType

    @property
    def DataEngineId(self):
        r"""引擎id
        :rtype: str
        """
        return self._DataEngineId

    @DataEngineId.setter
    def DataEngineId(self, DataEngineId):
        self._DataEngineId = DataEngineId

    @property
    def ResourceGroupId(self):
        r"""资源组id
        :rtype: str
        """
        return self._ResourceGroupId

    @ResourceGroupId.setter
    def ResourceGroupId(self, ResourceGroupId):
        self._ResourceGroupId = ResourceGroupId

    @property
    def ResourceGroupName(self):
        r"""资源组名字
        :rtype: str
        """
        return self._ResourceGroupName

    @ResourceGroupName.setter
    def ResourceGroupName(self, ResourceGroupName):
        self._ResourceGroupName = ResourceGroupName


    def _deserialize(self, params):
        self._Kind = params.get("Kind")
        self._SessionId = params.get("SessionId")
        self._ProxyUser = params.get("ProxyUser")
        self._State = params.get("State")
        self._SparkAppId = params.get("SparkAppId")
        self._Name = params.get("Name")
        self._CreateTime = params.get("CreateTime")
        self._DataEngineName = params.get("DataEngineName")
        self._LastRunningTime = params.get("LastRunningTime")
        self._Creator = params.get("Creator")
        self._SparkUiUrl = params.get("SparkUiUrl")
        self._SessionType = params.get("SessionType")
        self._DataEngineId = params.get("DataEngineId")
        self._ResourceGroupId = params.get("ResourceGroupId")
        self._ResourceGroupName = params.get("ResourceGroupName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OpendThirdAccessUserInfo(AbstractModel):
    r"""开通了第三方访问的用户信息

    """

    def __init__(self):
        r"""
        :param _Id: id信息
        :type Id: int
        :param _Uin: 用户主UIN
        :type Uin: str
        :param _AppId: 用户AppId
        :type AppId: str
        :param _CreateTime: 开通时间
        :type CreateTime: str
        """
        self._Id = None
        self._Uin = None
        self._AppId = None
        self._CreateTime = None

    @property
    def Id(self):
        r"""id信息
        :rtype: int
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Uin(self):
        r"""用户主UIN
        :rtype: str
        """
        return self._Uin

    @Uin.setter
    def Uin(self, Uin):
        self._Uin = Uin

    @property
    def AppId(self):
        r"""用户AppId
        :rtype: str
        """
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId

    @property
    def CreateTime(self):
        r"""开通时间
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Uin = params.get("Uin")
        self._AppId = params.get("AppId")
        self._CreateTime = params.get("CreateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OperateEngineResourceGroupFailMessage(AbstractModel):
    r"""操作资源组，返回的操作失败信息

    """

    def __init__(self):
        r"""
        :param _EngineResourceGroupName: 引擎资源组名称
        :type EngineResourceGroupName: str
        :param _FailMessage: 操作失败的提示信息
        :type FailMessage: str
        """
        self._EngineResourceGroupName = None
        self._FailMessage = None

    @property
    def EngineResourceGroupName(self):
        r"""引擎资源组名称
        :rtype: str
        """
        return self._EngineResourceGroupName

    @EngineResourceGroupName.setter
    def EngineResourceGroupName(self, EngineResourceGroupName):
        self._EngineResourceGroupName = EngineResourceGroupName

    @property
    def FailMessage(self):
        r"""操作失败的提示信息
        :rtype: str
        """
        return self._FailMessage

    @FailMessage.setter
    def FailMessage(self, FailMessage):
        self._FailMessage = FailMessage


    def _deserialize(self, params):
        self._EngineResourceGroupName = params.get("EngineResourceGroupName")
        self._FailMessage = params.get("FailMessage")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OptimizerEngineInfo(AbstractModel):
    r"""数据优化引擎信息

    """

    def __init__(self):
        r"""
        :param _HouseName: 引擎资源名称
        :type HouseName: str
        :param _HouseId: 引擎资源ID
        :type HouseId: str
        :param _HouseSize: 该参数仅针对spark作业引擎有效，用于执行数据优化任务的资源大小，不填时将采用该引擎所有资源
注意：此字段可能返回 null，表示取不到有效值。
        :type HouseSize: int
        """
        self._HouseName = None
        self._HouseId = None
        self._HouseSize = None

    @property
    def HouseName(self):
        r"""引擎资源名称
        :rtype: str
        """
        return self._HouseName

    @HouseName.setter
    def HouseName(self, HouseName):
        self._HouseName = HouseName

    @property
    def HouseId(self):
        r"""引擎资源ID
        :rtype: str
        """
        return self._HouseId

    @HouseId.setter
    def HouseId(self, HouseId):
        self._HouseId = HouseId

    @property
    def HouseSize(self):
        r"""该参数仅针对spark作业引擎有效，用于执行数据优化任务的资源大小，不填时将采用该引擎所有资源
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._HouseSize

    @HouseSize.setter
    def HouseSize(self, HouseSize):
        self._HouseSize = HouseSize


    def _deserialize(self, params):
        self._HouseName = params.get("HouseName")
        self._HouseId = params.get("HouseId")
        self._HouseSize = params.get("HouseSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Other(AbstractModel):
    r"""数据格式其它类型。

    """

    def __init__(self):
        r"""
        :param _Format: 枚举类型，默认值为Json，可选值为[Json, Parquet, ORC, AVRD]之一。
        :type Format: str
        """
        self._Format = None

    @property
    def Format(self):
        r"""枚举类型，默认值为Json，可选值为[Json, Parquet, ORC, AVRD]之一。
        :rtype: str
        """
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format


    def _deserialize(self, params):
        self._Format = params.get("Format")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OtherCHDFSBinding(AbstractModel):
    r"""非DLC产品CHDFS绑定

    """

    def __init__(self):
        r"""
        :param _ProductName: 产品名称
        :type ProductName: str
        :param _SuperUser: 用户名称（该字段已废弃）
        :type SuperUser: list of str
        :param _VpcInfo: vpc配置信息
        :type VpcInfo: list of CHDFSProductVpcInfo
        :param _IsBind: 是否与该桶绑定（该字段已废弃）
        :type IsBind: bool
        """
        self._ProductName = None
        self._SuperUser = None
        self._VpcInfo = None
        self._IsBind = None

    @property
    def ProductName(self):
        r"""产品名称
        :rtype: str
        """
        return self._ProductName

    @ProductName.setter
    def ProductName(self, ProductName):
        self._ProductName = ProductName

    @property
    def SuperUser(self):
        r"""用户名称（该字段已废弃）
        :rtype: list of str
        """
        return self._SuperUser

    @SuperUser.setter
    def SuperUser(self, SuperUser):
        self._SuperUser = SuperUser

    @property
    def VpcInfo(self):
        r"""vpc配置信息
        :rtype: list of CHDFSProductVpcInfo
        """
        return self._VpcInfo

    @VpcInfo.setter
    def VpcInfo(self, VpcInfo):
        self._VpcInfo = VpcInfo

    @property
    def IsBind(self):
        r"""是否与该桶绑定（该字段已废弃）
        :rtype: bool
        """
        return self._IsBind

    @IsBind.setter
    def IsBind(self, IsBind):
        self._IsBind = IsBind


    def _deserialize(self, params):
        self._ProductName = params.get("ProductName")
        self._SuperUser = params.get("SuperUser")
        if params.get("VpcInfo") is not None:
            self._VpcInfo = []
            for item in params.get("VpcInfo"):
                obj = CHDFSProductVpcInfo()
                obj._deserialize(item)
                self._VpcInfo.append(obj)
        self._IsBind = params.get("IsBind")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OtherDatasourceConnection(AbstractModel):
    r"""其他数据源

    """

    def __init__(self):
        r"""
        :param _Location: 网络参数
        :type Location: :class:`tencentcloud.dlc.v20210125.models.DatasourceConnectionLocation`
        """
        self._Location = None

    @property
    def Location(self):
        r"""网络参数
        :rtype: :class:`tencentcloud.dlc.v20210125.models.DatasourceConnectionLocation`
        """
        return self._Location

    @Location.setter
    def Location(self, Location):
        self._Location = Location


    def _deserialize(self, params):
        if params.get("Location") is not None:
            self._Location = DatasourceConnectionLocation()
            self._Location._deserialize(params.get("Location"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Param(AbstractModel):
    r"""对指定参数的更新、增加、删除

    """

    def __init__(self):
        r"""
        :param _ConfigItem: 参数key，例如：
        :type ConfigItem: str
        :param _ConfigValue: 参数值
        :type ConfigValue: str
        :param _Operate: 下发操作，支持：ADD、DELETE、MODIFY
        :type Operate: str
        """
        self._ConfigItem = None
        self._ConfigValue = None
        self._Operate = None

    @property
    def ConfigItem(self):
        r"""参数key，例如：
        :rtype: str
        """
        return self._ConfigItem

    @ConfigItem.setter
    def ConfigItem(self, ConfigItem):
        self._ConfigItem = ConfigItem

    @property
    def ConfigValue(self):
        r"""参数值
        :rtype: str
        """
        return self._ConfigValue

    @ConfigValue.setter
    def ConfigValue(self, ConfigValue):
        self._ConfigValue = ConfigValue

    @property
    def Operate(self):
        r"""下发操作，支持：ADD、DELETE、MODIFY
        :rtype: str
        """
        return self._Operate

    @Operate.setter
    def Operate(self, Operate):
        self._Operate = Operate


    def _deserialize(self, params):
        self._ConfigItem = params.get("ConfigItem")
        self._ConfigValue = params.get("ConfigValue")
        self._Operate = params.get("Operate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Partition(AbstractModel):
    r"""数据表分块信息。

    """

    def __init__(self):
        r"""
        :param _Name: 分区列名。
        :type Name: str
        :param _Type: 分区类型。
        :type Type: str
        :param _Comment: 对分区的描述。
        :type Comment: str
        :param _Transform: 隐式分区转换策略
        :type Transform: str
        :param _TransformArgs: 转换策略参数
注意：此字段可能返回 null，表示取不到有效值。
        :type TransformArgs: list of str
        :param _CreateTime: 创建时间
        :type CreateTime: int
        """
        self._Name = None
        self._Type = None
        self._Comment = None
        self._Transform = None
        self._TransformArgs = None
        self._CreateTime = None

    @property
    def Name(self):
        r"""分区列名。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Type(self):
        r"""分区类型。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Comment(self):
        r"""对分区的描述。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def Transform(self):
        r"""隐式分区转换策略
        :rtype: str
        """
        return self._Transform

    @Transform.setter
    def Transform(self, Transform):
        self._Transform = Transform

    @property
    def TransformArgs(self):
        r"""转换策略参数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._TransformArgs

    @TransformArgs.setter
    def TransformArgs(self, TransformArgs):
        self._TransformArgs = TransformArgs

    @property
    def CreateTime(self):
        r"""创建时间
        :rtype: int
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Type = params.get("Type")
        self._Comment = params.get("Comment")
        self._Transform = params.get("Transform")
        self._TransformArgs = params.get("TransformArgs")
        self._CreateTime = params.get("CreateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PauseStandardEngineResourceGroupsRequest(AbstractModel):
    r"""PauseStandardEngineResourceGroups请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EngineResourceGroupNames: 标准引擎资源组名称
        :type EngineResourceGroupNames: list of str
        """
        self._EngineResourceGroupNames = None

    @property
    def EngineResourceGroupNames(self):
        r"""标准引擎资源组名称
        :rtype: list of str
        """
        return self._EngineResourceGroupNames

    @EngineResourceGroupNames.setter
    def EngineResourceGroupNames(self, EngineResourceGroupNames):
        self._EngineResourceGroupNames = EngineResourceGroupNames


    def _deserialize(self, params):
        self._EngineResourceGroupNames = params.get("EngineResourceGroupNames")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PauseStandardEngineResourceGroupsResponse(AbstractModel):
    r"""PauseStandardEngineResourceGroups返回参数结构体

    """

    def __init__(self):
        r"""
        :param _OperateEngineResourceGroupFailMessages: 批量操作资源组时，操作失败的资源组相关信息
注意：此字段可能返回 null，表示取不到有效值。
        :type OperateEngineResourceGroupFailMessages: list of OperateEngineResourceGroupFailMessage
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._OperateEngineResourceGroupFailMessages = None
        self._RequestId = None

    @property
    def OperateEngineResourceGroupFailMessages(self):
        r"""批量操作资源组时，操作失败的资源组相关信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of OperateEngineResourceGroupFailMessage
        """
        return self._OperateEngineResourceGroupFailMessages

    @OperateEngineResourceGroupFailMessages.setter
    def OperateEngineResourceGroupFailMessages(self, OperateEngineResourceGroupFailMessages):
        self._OperateEngineResourceGroupFailMessages = OperateEngineResourceGroupFailMessages

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("OperateEngineResourceGroupFailMessages") is not None:
            self._OperateEngineResourceGroupFailMessages = []
            for item in params.get("OperateEngineResourceGroupFailMessages"):
                obj = OperateEngineResourceGroupFailMessage()
                obj._deserialize(item)
                self._OperateEngineResourceGroupFailMessages.append(obj)
        self._RequestId = params.get("RequestId")


class Policy(AbstractModel):
    r"""权限对象

    """

    def __init__(self):
        r"""
        :param _Database: 需要授权的数据库名，填 * 代表当前Catalog下所有数据库。当授权类型为管理员级别时，只允许填 “*”，当授权类型为数据连接级别时只允许填空，其他类型下可以任意指定数据库。
        :type Database: str
        :param _Catalog: 需要授权的数据源名称，管理员级别下只支持填  * （代表该级别全部资源）；数据源级别和数据库级别鉴权的情况下，只支持填COSDataCatalog或者*；在数据表级别鉴权下可以填写用户自定义数据源。不填情况下默认为DataLakeCatalog。注意：如果是对用户自定义数据源进行鉴权，DLC能够管理的权限是用户接入数据源的时候提供的账户的子集。
        :type Catalog: str
        :param _Table: 需要授权的表名，填 * 代表当前Database下所有表。当授权类型为管理员级别时，只允许填“*”，当授权类型为数据连接级别、数据库级别时只允许填空，其他类型下可以任意指定数据表。
        :type Table: str
        :param _Operation: 授权的权限操作，对于不同级别的鉴权提供不同操作。管理员权限：ALL，不填默认为ALL；数据连接级鉴权：CREATE；数据库级别鉴权：ALL、CREATE、ALTER、DROP；数据表权限：ALL、SELECT、INSERT、ALTER、DELETE、DROP、UPDATE。注意：在数据表权限下，指定的数据源不为COSDataCatalog的时候，只支持SELECT操作。
        :type Operation: str
        :param _PolicyType: 授权类型，现在支持八种授权类型：ADMIN:管理员级别鉴权 DATASOURCE：数据连接级别鉴权 DATABASE：数据库级别鉴权 TABLE：表级别鉴权 VIEW：视图级别鉴权 FUNCTION：函数级别鉴权 COLUMN：列级别鉴权 ENGINE：数据引擎鉴权。不填默认为管理员级别鉴权。
        :type PolicyType: str
        :param _Function: 需要授权的函数名，填 * 代表当前Catalog下所有函数。当授权类型为管理员级别时，只允许填“*”，当授权类型为数据连接级别时只允许填空，其他类型下可以任意指定函数。
注意：此字段可能返回 null，表示取不到有效值。
        :type Function: str
        :param _View: 需要授权的视图，填 * 代表当前Database下所有视图。当授权类型为管理员级别时，只允许填“*”，当授权类型为数据连接级别、数据库级别时只允许填空，其他类型下可以任意指定视图。
注意：此字段可能返回 null，表示取不到有效值。
        :type View: str
        :param _Column: 需要授权的列，填 * 代表当前所有列。当授权类型为管理员级别时，只允许填“*”
注意：此字段可能返回 null，表示取不到有效值。
        :type Column: str
        :param _DataEngine: 需要授权的数据引擎，填 * 代表当前所有引擎。当授权类型为管理员级别时，只允许填“*”
注意：此字段可能返回 null，表示取不到有效值。
        :type DataEngine: str
        :param _ReAuth: 用户是否可以进行二次授权。当为true的时候，被授权的用户可以将本次获取的权限再次授权给其他子用户。默认为false
注意：此字段可能返回 null，表示取不到有效值。
        :type ReAuth: bool
        :param _Source: 权限来源，入参不填。USER：权限来自用户本身；WORKGROUP：权限来自绑定的工作组
注意：此字段可能返回 null，表示取不到有效值。
        :type Source: str
        :param _Mode: 授权模式，入参不填。COMMON：普通模式；SENIOR：高级模式。
注意：此字段可能返回 null，表示取不到有效值。
        :type Mode: str
        :param _Operator: 操作者，入参不填。
注意：此字段可能返回 null，表示取不到有效值。
        :type Operator: str
        :param _CreateTime: 权限创建的时间，入参不填
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: str
        :param _SourceId: 权限所属工作组的ID，只有当该权限的来源为工作组时才会有值。即仅当Source字段的值为WORKGROUP时该字段才有值。
注意：此字段可能返回 null，表示取不到有效值。
        :type SourceId: int
        :param _SourceName: 权限所属工作组的名称，只有当该权限的来源为工作组时才会有值。即仅当Source字段的值为WORKGROUP时该字段才有值。
注意：此字段可能返回 null，表示取不到有效值。
        :type SourceName: str
        :param _Id: 策略ID
注意：此字段可能返回 null，表示取不到有效值。
        :type Id: int
        :param _EngineGeneration: 引擎类型

        :type EngineGeneration: str
        :param _Model: 需要授权的Model名，填 * 代表当前Database下所有表。当授权类型为管理员级别时，只允许填“*”，当授权类型为数据连接级别、数据库级别时只允许填空，其他类型下可以任意指定数据表。
        :type Model: str
        :param _IsAdminPolicy: 权限来源是否为管理员
        :type IsAdminPolicy: bool
        """
        self._Database = None
        self._Catalog = None
        self._Table = None
        self._Operation = None
        self._PolicyType = None
        self._Function = None
        self._View = None
        self._Column = None
        self._DataEngine = None
        self._ReAuth = None
        self._Source = None
        self._Mode = None
        self._Operator = None
        self._CreateTime = None
        self._SourceId = None
        self._SourceName = None
        self._Id = None
        self._EngineGeneration = None
        self._Model = None
        self._IsAdminPolicy = None

    @property
    def Database(self):
        r"""需要授权的数据库名，填 * 代表当前Catalog下所有数据库。当授权类型为管理员级别时，只允许填 “*”，当授权类型为数据连接级别时只允许填空，其他类型下可以任意指定数据库。
        :rtype: str
        """
        return self._Database

    @Database.setter
    def Database(self, Database):
        self._Database = Database

    @property
    def Catalog(self):
        r"""需要授权的数据源名称，管理员级别下只支持填  * （代表该级别全部资源）；数据源级别和数据库级别鉴权的情况下，只支持填COSDataCatalog或者*；在数据表级别鉴权下可以填写用户自定义数据源。不填情况下默认为DataLakeCatalog。注意：如果是对用户自定义数据源进行鉴权，DLC能够管理的权限是用户接入数据源的时候提供的账户的子集。
        :rtype: str
        """
        return self._Catalog

    @Catalog.setter
    def Catalog(self, Catalog):
        self._Catalog = Catalog

    @property
    def Table(self):
        r"""需要授权的表名，填 * 代表当前Database下所有表。当授权类型为管理员级别时，只允许填“*”，当授权类型为数据连接级别、数据库级别时只允许填空，其他类型下可以任意指定数据表。
        :rtype: str
        """
        return self._Table

    @Table.setter
    def Table(self, Table):
        self._Table = Table

    @property
    def Operation(self):
        r"""授权的权限操作，对于不同级别的鉴权提供不同操作。管理员权限：ALL，不填默认为ALL；数据连接级鉴权：CREATE；数据库级别鉴权：ALL、CREATE、ALTER、DROP；数据表权限：ALL、SELECT、INSERT、ALTER、DELETE、DROP、UPDATE。注意：在数据表权限下，指定的数据源不为COSDataCatalog的时候，只支持SELECT操作。
        :rtype: str
        """
        return self._Operation

    @Operation.setter
    def Operation(self, Operation):
        self._Operation = Operation

    @property
    def PolicyType(self):
        r"""授权类型，现在支持八种授权类型：ADMIN:管理员级别鉴权 DATASOURCE：数据连接级别鉴权 DATABASE：数据库级别鉴权 TABLE：表级别鉴权 VIEW：视图级别鉴权 FUNCTION：函数级别鉴权 COLUMN：列级别鉴权 ENGINE：数据引擎鉴权。不填默认为管理员级别鉴权。
        :rtype: str
        """
        return self._PolicyType

    @PolicyType.setter
    def PolicyType(self, PolicyType):
        self._PolicyType = PolicyType

    @property
    def Function(self):
        r"""需要授权的函数名，填 * 代表当前Catalog下所有函数。当授权类型为管理员级别时，只允许填“*”，当授权类型为数据连接级别时只允许填空，其他类型下可以任意指定函数。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Function

    @Function.setter
    def Function(self, Function):
        self._Function = Function

    @property
    def View(self):
        r"""需要授权的视图，填 * 代表当前Database下所有视图。当授权类型为管理员级别时，只允许填“*”，当授权类型为数据连接级别、数据库级别时只允许填空，其他类型下可以任意指定视图。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._View

    @View.setter
    def View(self, View):
        self._View = View

    @property
    def Column(self):
        r"""需要授权的列，填 * 代表当前所有列。当授权类型为管理员级别时，只允许填“*”
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Column

    @Column.setter
    def Column(self, Column):
        self._Column = Column

    @property
    def DataEngine(self):
        r"""需要授权的数据引擎，填 * 代表当前所有引擎。当授权类型为管理员级别时，只允许填“*”
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DataEngine

    @DataEngine.setter
    def DataEngine(self, DataEngine):
        self._DataEngine = DataEngine

    @property
    def ReAuth(self):
        r"""用户是否可以进行二次授权。当为true的时候，被授权的用户可以将本次获取的权限再次授权给其他子用户。默认为false
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._ReAuth

    @ReAuth.setter
    def ReAuth(self, ReAuth):
        self._ReAuth = ReAuth

    @property
    def Source(self):
        r"""权限来源，入参不填。USER：权限来自用户本身；WORKGROUP：权限来自绑定的工作组
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Source

    @Source.setter
    def Source(self, Source):
        self._Source = Source

    @property
    def Mode(self):
        r"""授权模式，入参不填。COMMON：普通模式；SENIOR：高级模式。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def Operator(self):
        r"""操作者，入参不填。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Operator

    @Operator.setter
    def Operator(self, Operator):
        self._Operator = Operator

    @property
    def CreateTime(self):
        r"""权限创建的时间，入参不填
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def SourceId(self):
        r"""权限所属工作组的ID，只有当该权限的来源为工作组时才会有值。即仅当Source字段的值为WORKGROUP时该字段才有值。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._SourceId

    @SourceId.setter
    def SourceId(self, SourceId):
        self._SourceId = SourceId

    @property
    def SourceName(self):
        r"""权限所属工作组的名称，只有当该权限的来源为工作组时才会有值。即仅当Source字段的值为WORKGROUP时该字段才有值。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SourceName

    @SourceName.setter
    def SourceName(self, SourceName):
        self._SourceName = SourceName

    @property
    def Id(self):
        r"""策略ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def EngineGeneration(self):
        r"""引擎类型

        :rtype: str
        """
        return self._EngineGeneration

    @EngineGeneration.setter
    def EngineGeneration(self, EngineGeneration):
        self._EngineGeneration = EngineGeneration

    @property
    def Model(self):
        r"""需要授权的Model名，填 * 代表当前Database下所有表。当授权类型为管理员级别时，只允许填“*”，当授权类型为数据连接级别、数据库级别时只允许填空，其他类型下可以任意指定数据表。
        :rtype: str
        """
        return self._Model

    @Model.setter
    def Model(self, Model):
        self._Model = Model

    @property
    def IsAdminPolicy(self):
        r"""权限来源是否为管理员
        :rtype: bool
        """
        return self._IsAdminPolicy

    @IsAdminPolicy.setter
    def IsAdminPolicy(self, IsAdminPolicy):
        self._IsAdminPolicy = IsAdminPolicy


    def _deserialize(self, params):
        self._Database = params.get("Database")
        self._Catalog = params.get("Catalog")
        self._Table = params.get("Table")
        self._Operation = params.get("Operation")
        self._PolicyType = params.get("PolicyType")
        self._Function = params.get("Function")
        self._View = params.get("View")
        self._Column = params.get("Column")
        self._DataEngine = params.get("DataEngine")
        self._ReAuth = params.get("ReAuth")
        self._Source = params.get("Source")
        self._Mode = params.get("Mode")
        self._Operator = params.get("Operator")
        self._CreateTime = params.get("CreateTime")
        self._SourceId = params.get("SourceId")
        self._SourceName = params.get("SourceName")
        self._Id = params.get("Id")
        self._EngineGeneration = params.get("EngineGeneration")
        self._Model = params.get("Model")
        self._IsAdminPolicy = params.get("IsAdminPolicy")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Policys(AbstractModel):
    r"""策略集合

    """

    def __init__(self):
        r"""
        :param _PolicySet: 策略集合
注意：此字段可能返回 null，表示取不到有效值。
        :type PolicySet: list of Policy
        :param _TotalCount: 策略总数
        :type TotalCount: int
        """
        self._PolicySet = None
        self._TotalCount = None

    @property
    def PolicySet(self):
        r"""策略集合
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of Policy
        """
        return self._PolicySet

    @PolicySet.setter
    def PolicySet(self, PolicySet):
        self._PolicySet = PolicySet

    @property
    def TotalCount(self):
        r"""策略总数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount


    def _deserialize(self, params):
        if params.get("PolicySet") is not None:
            self._PolicySet = []
            for item in params.get("PolicySet"):
                obj = Policy()
                obj._deserialize(item)
                self._PolicySet.append(obj)
        self._TotalCount = params.get("TotalCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PrestoMonitorMetrics(AbstractModel):
    r"""Presto监控指标

    """

    def __init__(self):
        r"""
        :param _LocalCacheHitRate: 	Alluxio本地缓存命中率
注意：此字段可能返回 null，表示取不到有效值。
        :type LocalCacheHitRate: float
        :param _FragmentCacheHitRate: Fragment缓存命中率
注意：此字段可能返回 null，表示取不到有效值。
        :type FragmentCacheHitRate: float
        """
        self._LocalCacheHitRate = None
        self._FragmentCacheHitRate = None

    @property
    def LocalCacheHitRate(self):
        r"""	Alluxio本地缓存命中率
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: float
        """
        return self._LocalCacheHitRate

    @LocalCacheHitRate.setter
    def LocalCacheHitRate(self, LocalCacheHitRate):
        self._LocalCacheHitRate = LocalCacheHitRate

    @property
    def FragmentCacheHitRate(self):
        r"""Fragment缓存命中率
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: float
        """
        return self._FragmentCacheHitRate

    @FragmentCacheHitRate.setter
    def FragmentCacheHitRate(self, FragmentCacheHitRate):
        self._FragmentCacheHitRate = FragmentCacheHitRate


    def _deserialize(self, params):
        self._LocalCacheHitRate = params.get("LocalCacheHitRate")
        self._FragmentCacheHitRate = params.get("FragmentCacheHitRate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Property(AbstractModel):
    r"""数据库和数据表属性信息

    """

    def __init__(self):
        r"""
        :param _Key: 属性key名称。
        :type Key: str
        :param _Value: 属性key对应的value。
        :type Value: str
        """
        self._Key = None
        self._Value = None

    @property
    def Key(self):
        r"""属性key名称。
        :rtype: str
        """
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def Value(self):
        r"""属性key对应的value。
        :rtype: str
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value


    def _deserialize(self, params):
        self._Key = params.get("Key")
        self._Value = params.get("Value")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PythonSparkImage(AbstractModel):
    r"""python-spark镜像信息。

    """

    def __init__(self):
        r"""
        :param _SparkImageId: spark镜像唯一id
        :type SparkImageId: str
        :param _ChildImageVersionId: 集群小版本镜像id
        :type ChildImageVersionId: str
        :param _SparkImageVersion: spark镜像名称
        :type SparkImageVersion: str
        :param _Description: spark镜像描述信息
        :type Description: str
        :param _CreateTime: 创建时间
        :type CreateTime: str
        :param _UpdateTime: 更新时间
        :type UpdateTime: str
        """
        self._SparkImageId = None
        self._ChildImageVersionId = None
        self._SparkImageVersion = None
        self._Description = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def SparkImageId(self):
        r"""spark镜像唯一id
        :rtype: str
        """
        return self._SparkImageId

    @SparkImageId.setter
    def SparkImageId(self, SparkImageId):
        self._SparkImageId = SparkImageId

    @property
    def ChildImageVersionId(self):
        r"""集群小版本镜像id
        :rtype: str
        """
        return self._ChildImageVersionId

    @ChildImageVersionId.setter
    def ChildImageVersionId(self, ChildImageVersionId):
        self._ChildImageVersionId = ChildImageVersionId

    @property
    def SparkImageVersion(self):
        r"""spark镜像名称
        :rtype: str
        """
        return self._SparkImageVersion

    @SparkImageVersion.setter
    def SparkImageVersion(self, SparkImageVersion):
        self._SparkImageVersion = SparkImageVersion

    @property
    def Description(self):
        r"""spark镜像描述信息
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def CreateTime(self):
        r"""创建时间
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""更新时间
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._SparkImageId = params.get("SparkImageId")
        self._ChildImageVersionId = params.get("ChildImageVersionId")
        self._SparkImageVersion = params.get("SparkImageVersion")
        self._Description = params.get("Description")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class QueryInternalTableWarehouseRequest(AbstractModel):
    r"""QueryInternalTableWarehouse请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DatabaseName: 库名
        :type DatabaseName: str
        :param _TableName: 表名
        :type TableName: str
        :param _DatasourceConnectionName: catalog名称
        :type DatasourceConnectionName: str
        """
        self._DatabaseName = None
        self._TableName = None
        self._DatasourceConnectionName = None

    @property
    def DatabaseName(self):
        r"""库名
        :rtype: str
        """
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def TableName(self):
        r"""表名
        :rtype: str
        """
        return self._TableName

    @TableName.setter
    def TableName(self, TableName):
        self._TableName = TableName

    @property
    def DatasourceConnectionName(self):
        r"""catalog名称
        :rtype: str
        """
        return self._DatasourceConnectionName

    @DatasourceConnectionName.setter
    def DatasourceConnectionName(self, DatasourceConnectionName):
        self._DatasourceConnectionName = DatasourceConnectionName


    def _deserialize(self, params):
        self._DatabaseName = params.get("DatabaseName")
        self._TableName = params.get("TableName")
        self._DatasourceConnectionName = params.get("DatasourceConnectionName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class QueryInternalTableWarehouseResponse(AbstractModel):
    r"""QueryInternalTableWarehouse返回参数结构体

    """

    def __init__(self):
        r"""
        :param _WarehousePath: warehouse路径
        :type WarehousePath: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._WarehousePath = None
        self._RequestId = None

    @property
    def WarehousePath(self):
        r"""warehouse路径
        :rtype: str
        """
        return self._WarehousePath

    @WarehousePath.setter
    def WarehousePath(self, WarehousePath):
        self._WarehousePath = WarehousePath

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._WarehousePath = params.get("WarehousePath")
        self._RequestId = params.get("RequestId")


class QueryResultRequest(AbstractModel):
    r"""QueryResult请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务ID
        :type TaskId: str
        :param _NextToken: objectListMarker={marker}&lastReadFile={filename}&lastReadOffsetlastReadFile为上一次读取的文件，lastReadOffset为上一次读取到的位置
        :type NextToken: str
        """
        self._TaskId = None
        self._NextToken = None

    @property
    def TaskId(self):
        r"""任务ID
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def NextToken(self):
        r"""objectListMarker={marker}&lastReadFile={filename}&lastReadOffsetlastReadFile为上一次读取的文件，lastReadOffset为上一次读取到的位置
        :rtype: str
        """
        return self._NextToken

    @NextToken.setter
    def NextToken(self, NextToken):
        self._NextToken = NextToken


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._NextToken = params.get("NextToken")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class QueryResultResponse(AbstractModel):
    r"""QueryResult返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务Id
        :type TaskId: str
        :param _ResultSet: 结果数据
        :type ResultSet: str
        :param _ResultSchema: schema
        :type ResultSchema: list of Column
        :param _NextToken: 分页信息
        :type NextToken: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._ResultSet = None
        self._ResultSchema = None
        self._NextToken = None
        self._RequestId = None

    @property
    def TaskId(self):
        r"""任务Id
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ResultSet(self):
        r"""结果数据
        :rtype: str
        """
        return self._ResultSet

    @ResultSet.setter
    def ResultSet(self, ResultSet):
        self._ResultSet = ResultSet

    @property
    def ResultSchema(self):
        r"""schema
        :rtype: list of Column
        """
        return self._ResultSchema

    @ResultSchema.setter
    def ResultSchema(self, ResultSchema):
        self._ResultSchema = ResultSchema

    @property
    def NextToken(self):
        r"""分页信息
        :rtype: str
        """
        return self._NextToken

    @NextToken.setter
    def NextToken(self, NextToken):
        self._NextToken = NextToken

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ResultSet = params.get("ResultSet")
        if params.get("ResultSchema") is not None:
            self._ResultSchema = []
            for item in params.get("ResultSchema"):
                obj = Column()
                obj._deserialize(item)
                self._ResultSchema.append(obj)
        self._NextToken = params.get("NextToken")
        self._RequestId = params.get("RequestId")


class QueryTaskCostDetailRequest(AbstractModel):
    r"""QueryTaskCostDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件，如下支持的过滤类型，传参Name应为以下其中一个,其中task-id支持最大50个过滤个数，其他过滤参数支持的总数不超过5个。
task-id - String - （任务ID准确过滤）task-id取值形如：e386471f-139a-4e59-877f-50ece8135b99。
task-state - String - （任务状态过滤）取值范围 0(初始化)， 1(运行中)， 2(成功)， -1(失败)。
task-sql-keyword - String - （SQL语句关键字模糊过滤）取值形如：DROP TABLE。
task-operator- string （子uin过滤）
        :type Filters: list of Filter
        :param _StartTime: 起始时间点，格式为yyyy-mm-dd HH:MM:SS。默认为45天前的当前时刻
        :type StartTime: str
        :param _EndTime: 结束时间点，格式为yyyy-mm-dd HH:MM:SS时间跨度在(0,30天]，支持最近45天数据查询。默认为当前时刻
        :type EndTime: str
        :param _DataEngineName: 数据引擎名称，用于筛选
        :type DataEngineName: str
        :param _SearchAfter: 下一页的标识
        :type SearchAfter: str
        :param _PageSize: 每页的大小
        :type PageSize: int
        """
        self._Filters = None
        self._StartTime = None
        self._EndTime = None
        self._DataEngineName = None
        self._SearchAfter = None
        self._PageSize = None

    @property
    def Filters(self):
        r"""过滤条件，如下支持的过滤类型，传参Name应为以下其中一个,其中task-id支持最大50个过滤个数，其他过滤参数支持的总数不超过5个。
task-id - String - （任务ID准确过滤）task-id取值形如：e386471f-139a-4e59-877f-50ece8135b99。
task-state - String - （任务状态过滤）取值范围 0(初始化)， 1(运行中)， 2(成功)， -1(失败)。
task-sql-keyword - String - （SQL语句关键字模糊过滤）取值形如：DROP TABLE。
task-operator- string （子uin过滤）
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def StartTime(self):
        r"""起始时间点，格式为yyyy-mm-dd HH:MM:SS。默认为45天前的当前时刻
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""结束时间点，格式为yyyy-mm-dd HH:MM:SS时间跨度在(0,30天]，支持最近45天数据查询。默认为当前时刻
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def DataEngineName(self):
        r"""数据引擎名称，用于筛选
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName

    @property
    def SearchAfter(self):
        r"""下一页的标识
        :rtype: str
        """
        return self._SearchAfter

    @SearchAfter.setter
    def SearchAfter(self, SearchAfter):
        self._SearchAfter = SearchAfter

    @property
    def PageSize(self):
        r"""每页的大小
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._DataEngineName = params.get("DataEngineName")
        self._SearchAfter = params.get("SearchAfter")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class QueryTaskCostDetailResponse(AbstractModel):
    r"""QueryTaskCostDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SearchAfter: 下一页的标识
        :type SearchAfter: str
        :param _Data: 返回的数据
        :type Data: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SearchAfter = None
        self._Data = None
        self._RequestId = None

    @property
    def SearchAfter(self):
        r"""下一页的标识
        :rtype: str
        """
        return self._SearchAfter

    @SearchAfter.setter
    def SearchAfter(self, SearchAfter):
        self._SearchAfter = SearchAfter

    @property
    def Data(self):
        r"""返回的数据
        :rtype: str
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SearchAfter = params.get("SearchAfter")
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class RegisterThirdPartyAccessUserRequest(AbstractModel):
    r"""RegisterThirdPartyAccessUser请求参数结构体

    """


class RegisterThirdPartyAccessUserResponse(AbstractModel):
    r"""RegisterThirdPartyAccessUser返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class RenewDataEngineRequest(AbstractModel):
    r"""RenewDataEngine请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DataEngineName: CU队列名称
        :type DataEngineName: str
        :param _TimeSpan: 续费时长，单位月，最少续费1一个月
        :type TimeSpan: int
        :param _PayMode: 付费类型，默认为1，预付费
        :type PayMode: int
        :param _TimeUnit: 单位，默认m，仅能填m
        :type TimeUnit: str
        :param _RenewFlag: 自动续费标志，0，初始状态，默认不自动续费，若用户有预付费不停服特权，自动续费。1：自动续费。2：明确不自动续费。不传该参数默认为0
        :type RenewFlag: int
        """
        self._DataEngineName = None
        self._TimeSpan = None
        self._PayMode = None
        self._TimeUnit = None
        self._RenewFlag = None

    @property
    def DataEngineName(self):
        r"""CU队列名称
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName

    @property
    def TimeSpan(self):
        r"""续费时长，单位月，最少续费1一个月
        :rtype: int
        """
        return self._TimeSpan

    @TimeSpan.setter
    def TimeSpan(self, TimeSpan):
        self._TimeSpan = TimeSpan

    @property
    def PayMode(self):
        r"""付费类型，默认为1，预付费
        :rtype: int
        """
        return self._PayMode

    @PayMode.setter
    def PayMode(self, PayMode):
        self._PayMode = PayMode

    @property
    def TimeUnit(self):
        r"""单位，默认m，仅能填m
        :rtype: str
        """
        return self._TimeUnit

    @TimeUnit.setter
    def TimeUnit(self, TimeUnit):
        self._TimeUnit = TimeUnit

    @property
    def RenewFlag(self):
        r"""自动续费标志，0，初始状态，默认不自动续费，若用户有预付费不停服特权，自动续费。1：自动续费。2：明确不自动续费。不传该参数默认为0
        :rtype: int
        """
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag


    def _deserialize(self, params):
        self._DataEngineName = params.get("DataEngineName")
        self._TimeSpan = params.get("TimeSpan")
        self._PayMode = params.get("PayMode")
        self._TimeUnit = params.get("TimeUnit")
        self._RenewFlag = params.get("RenewFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RenewDataEngineResponse(AbstractModel):
    r"""RenewDataEngine返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ReportHeartbeatMetaDataRequest(AbstractModel):
    r"""ReportHeartbeatMetaData请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DatasourceConnectionName: 数据源名称
        :type DatasourceConnectionName: str
        :param _LockId: 锁ID
        :type LockId: int
        :param _TxnId: 事务ID
        :type TxnId: int
        """
        self._DatasourceConnectionName = None
        self._LockId = None
        self._TxnId = None

    @property
    def DatasourceConnectionName(self):
        r"""数据源名称
        :rtype: str
        """
        return self._DatasourceConnectionName

    @DatasourceConnectionName.setter
    def DatasourceConnectionName(self, DatasourceConnectionName):
        self._DatasourceConnectionName = DatasourceConnectionName

    @property
    def LockId(self):
        r"""锁ID
        :rtype: int
        """
        return self._LockId

    @LockId.setter
    def LockId(self, LockId):
        self._LockId = LockId

    @property
    def TxnId(self):
        r"""事务ID
        :rtype: int
        """
        return self._TxnId

    @TxnId.setter
    def TxnId(self, TxnId):
        self._TxnId = TxnId


    def _deserialize(self, params):
        self._DatasourceConnectionName = params.get("DatasourceConnectionName")
        self._LockId = params.get("LockId")
        self._TxnId = params.get("TxnId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ReportHeartbeatMetaDataResponse(AbstractModel):
    r"""ReportHeartbeatMetaData返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ResourceConf(AbstractModel):
    r"""数据治理资源配置项

    """

    def __init__(self):
        r"""
        :param _Parallelism: 当为TCLake优化资源时，优化任务的并行度
        :type Parallelism: int
        """
        self._Parallelism = None

    @property
    def Parallelism(self):
        r"""当为TCLake优化资源时，优化任务的并行度
        :rtype: int
        """
        return self._Parallelism

    @Parallelism.setter
    def Parallelism(self, Parallelism):
        self._Parallelism = Parallelism


    def _deserialize(self, params):
        self._Parallelism = params.get("Parallelism")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ResourceInfo(AbstractModel):
    r"""数据优化资源信息结构

    """

    def __init__(self):
        r"""
        :param _AttributionType: 归属类型
        :type AttributionType: str
        :param _ResourceType: 资源类型
        :type ResourceType: str
        :param _Name: 引擎名称
        :type Name: str
        :param _Instance: 如资源类型为spark-sql 取值为Name, 如为spark-batch 取值为session app_name
        :type Instance: str
        :param _Favor: 亲和性
注意：此字段可能返回 null，表示取不到有效值。
        :type Favor: list of FavorInfo
        :param _Status: 状态
        :type Status: int
        :param _ResourceGroupName: 标准引擎资源组信息
        :type ResourceGroupName: str
        :param _ResourceConf: 资源配置信息
        :type ResourceConf: :class:`tencentcloud.dlc.v20210125.models.ResourceConf`
        """
        self._AttributionType = None
        self._ResourceType = None
        self._Name = None
        self._Instance = None
        self._Favor = None
        self._Status = None
        self._ResourceGroupName = None
        self._ResourceConf = None

    @property
    def AttributionType(self):
        r"""归属类型
        :rtype: str
        """
        return self._AttributionType

    @AttributionType.setter
    def AttributionType(self, AttributionType):
        self._AttributionType = AttributionType

    @property
    def ResourceType(self):
        r"""资源类型
        :rtype: str
        """
        return self._ResourceType

    @ResourceType.setter
    def ResourceType(self, ResourceType):
        self._ResourceType = ResourceType

    @property
    def Name(self):
        r"""引擎名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Instance(self):
        r"""如资源类型为spark-sql 取值为Name, 如为spark-batch 取值为session app_name
        :rtype: str
        """
        return self._Instance

    @Instance.setter
    def Instance(self, Instance):
        self._Instance = Instance

    @property
    def Favor(self):
        r"""亲和性
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of FavorInfo
        """
        return self._Favor

    @Favor.setter
    def Favor(self, Favor):
        self._Favor = Favor

    @property
    def Status(self):
        r"""状态
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ResourceGroupName(self):
        r"""标准引擎资源组信息
        :rtype: str
        """
        return self._ResourceGroupName

    @ResourceGroupName.setter
    def ResourceGroupName(self, ResourceGroupName):
        self._ResourceGroupName = ResourceGroupName

    @property
    def ResourceConf(self):
        r"""资源配置信息
        :rtype: :class:`tencentcloud.dlc.v20210125.models.ResourceConf`
        """
        return self._ResourceConf

    @ResourceConf.setter
    def ResourceConf(self, ResourceConf):
        self._ResourceConf = ResourceConf


    def _deserialize(self, params):
        self._AttributionType = params.get("AttributionType")
        self._ResourceType = params.get("ResourceType")
        self._Name = params.get("Name")
        self._Instance = params.get("Instance")
        if params.get("Favor") is not None:
            self._Favor = []
            for item in params.get("Favor"):
                obj = FavorInfo()
                obj._deserialize(item)
                self._Favor.append(obj)
        self._Status = params.get("Status")
        self._ResourceGroupName = params.get("ResourceGroupName")
        if params.get("ResourceConf") is not None:
            self._ResourceConf = ResourceConf()
            self._ResourceConf._deserialize(params.get("ResourceConf"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RestartDataEngineRequest(AbstractModel):
    r"""RestartDataEngine请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DataEngineId: 引擎ID
        :type DataEngineId: str
        :param _ForcedOperation: 是否强制重启，忽略任务
        :type ForcedOperation: bool
        """
        self._DataEngineId = None
        self._ForcedOperation = None

    @property
    def DataEngineId(self):
        r"""引擎ID
        :rtype: str
        """
        return self._DataEngineId

    @DataEngineId.setter
    def DataEngineId(self, DataEngineId):
        self._DataEngineId = DataEngineId

    @property
    def ForcedOperation(self):
        r"""是否强制重启，忽略任务
        :rtype: bool
        """
        return self._ForcedOperation

    @ForcedOperation.setter
    def ForcedOperation(self, ForcedOperation):
        self._ForcedOperation = ForcedOperation


    def _deserialize(self, params):
        self._DataEngineId = params.get("DataEngineId")
        self._ForcedOperation = params.get("ForcedOperation")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RestartDataEngineResponse(AbstractModel):
    r"""RestartDataEngine返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class RevokeDLCCatalogAccessRequest(AbstractModel):
    r"""RevokeDLCCatalogAccess请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpcId: VpcID
        :type VpcId: str
        """
        self._VpcId = None

    @property
    def VpcId(self):
        r"""VpcID
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RevokeDLCCatalogAccessResponse(AbstractModel):
    r"""RevokeDLCCatalogAccess返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class RollbackDataEngineImageRequest(AbstractModel):
    r"""RollbackDataEngineImage请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DataEngineId: 引擎ID
        :type DataEngineId: str
        :param _FromRecordId: 检查是否能回滚的接口返回的FromRecordId参数
        :type FromRecordId: str
        :param _ToRecordId: 检查是否能回滚的接口返回的ToRecordId参数
        :type ToRecordId: str
        """
        self._DataEngineId = None
        self._FromRecordId = None
        self._ToRecordId = None

    @property
    def DataEngineId(self):
        r"""引擎ID
        :rtype: str
        """
        return self._DataEngineId

    @DataEngineId.setter
    def DataEngineId(self, DataEngineId):
        self._DataEngineId = DataEngineId

    @property
    def FromRecordId(self):
        r"""检查是否能回滚的接口返回的FromRecordId参数
        :rtype: str
        """
        return self._FromRecordId

    @FromRecordId.setter
    def FromRecordId(self, FromRecordId):
        self._FromRecordId = FromRecordId

    @property
    def ToRecordId(self):
        r"""检查是否能回滚的接口返回的ToRecordId参数
        :rtype: str
        """
        return self._ToRecordId

    @ToRecordId.setter
    def ToRecordId(self, ToRecordId):
        self._ToRecordId = ToRecordId


    def _deserialize(self, params):
        self._DataEngineId = params.get("DataEngineId")
        self._FromRecordId = params.get("FromRecordId")
        self._ToRecordId = params.get("ToRecordId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RollbackDataEngineImageResponse(AbstractModel):
    r"""RollbackDataEngineImage返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class SQLTask(AbstractModel):
    r"""SQL查询任务

    """

    def __init__(self):
        r"""
        :param _SQL: base64加密后的SQL语句
        :type SQL: str
        :param _Config: 任务的配置信息
        :type Config: list of KVPair
        """
        self._SQL = None
        self._Config = None

    @property
    def SQL(self):
        r"""base64加密后的SQL语句
        :rtype: str
        """
        return self._SQL

    @SQL.setter
    def SQL(self, SQL):
        self._SQL = SQL

    @property
    def Config(self):
        r"""任务的配置信息
        :rtype: list of KVPair
        """
        return self._Config

    @Config.setter
    def Config(self, Config):
        self._Config = Config


    def _deserialize(self, params):
        self._SQL = params.get("SQL")
        if params.get("Config") is not None:
            self._Config = []
            for item in params.get("Config"):
                obj = KVPair()
                obj._deserialize(item)
                self._Config.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ScheduleElasticityConf(AbstractModel):
    r"""引擎资源弹性伸缩策略

    """

    def __init__(self):
        r"""
        :param _ScheduledElasticityEnabled: 是否开启弹性伸缩：true/false
        :type ScheduledElasticityEnabled: bool
        :param _ScheduleType: 调度类型：ONCE（一次性调度），DAILY（每日调度），WEEKLY（每周调度），MONTHLY（每月调度）
        :type ScheduleType: str
        :param _ScheduleDays: 调度日期：WEEKLY传：1~7； MONTHLY传:1~31；其它类型不传
        :type ScheduleDays: list of int
        :param _TimeZone: 调度时区
        :type TimeZone: str
        :param _ElasticPlans: 弹性伸缩计划
        :type ElasticPlans: list of ElasticPlan
        """
        self._ScheduledElasticityEnabled = None
        self._ScheduleType = None
        self._ScheduleDays = None
        self._TimeZone = None
        self._ElasticPlans = None

    @property
    def ScheduledElasticityEnabled(self):
        r"""是否开启弹性伸缩：true/false
        :rtype: bool
        """
        return self._ScheduledElasticityEnabled

    @ScheduledElasticityEnabled.setter
    def ScheduledElasticityEnabled(self, ScheduledElasticityEnabled):
        self._ScheduledElasticityEnabled = ScheduledElasticityEnabled

    @property
    def ScheduleType(self):
        r"""调度类型：ONCE（一次性调度），DAILY（每日调度），WEEKLY（每周调度），MONTHLY（每月调度）
        :rtype: str
        """
        return self._ScheduleType

    @ScheduleType.setter
    def ScheduleType(self, ScheduleType):
        self._ScheduleType = ScheduleType

    @property
    def ScheduleDays(self):
        r"""调度日期：WEEKLY传：1~7； MONTHLY传:1~31；其它类型不传
        :rtype: list of int
        """
        return self._ScheduleDays

    @ScheduleDays.setter
    def ScheduleDays(self, ScheduleDays):
        self._ScheduleDays = ScheduleDays

    @property
    def TimeZone(self):
        r"""调度时区
        :rtype: str
        """
        return self._TimeZone

    @TimeZone.setter
    def TimeZone(self, TimeZone):
        self._TimeZone = TimeZone

    @property
    def ElasticPlans(self):
        r"""弹性伸缩计划
        :rtype: list of ElasticPlan
        """
        return self._ElasticPlans

    @ElasticPlans.setter
    def ElasticPlans(self, ElasticPlans):
        self._ElasticPlans = ElasticPlans


    def _deserialize(self, params):
        self._ScheduledElasticityEnabled = params.get("ScheduledElasticityEnabled")
        self._ScheduleType = params.get("ScheduleType")
        self._ScheduleDays = params.get("ScheduleDays")
        self._TimeZone = params.get("TimeZone")
        if params.get("ElasticPlans") is not None:
            self._ElasticPlans = []
            for item in params.get("ElasticPlans"):
                obj = ElasticPlan()
                obj._deserialize(item)
                self._ElasticPlans.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Script(AbstractModel):
    r"""script实例。

    """

    def __init__(self):
        r"""
        :param _ScriptId: 脚本Id，长度36字节。
        :type ScriptId: str
        :param _ScriptName: 脚本名称，长度0-25。
        :type ScriptName: str
        :param _ScriptDesc: 脚本描述，长度0-50。
注意：此字段可能返回 null，表示取不到有效值。
        :type ScriptDesc: str
        :param _DatabaseName: 默认关联数据库。
        :type DatabaseName: str
        :param _SQLStatement: SQL描述，长度0-10000。
注意：此字段可能返回 null，表示取不到有效值。
        :type SQLStatement: str
        :param _UpdateTime: 更新时间戳， 单位：ms。
        :type UpdateTime: int
        """
        self._ScriptId = None
        self._ScriptName = None
        self._ScriptDesc = None
        self._DatabaseName = None
        self._SQLStatement = None
        self._UpdateTime = None

    @property
    def ScriptId(self):
        r"""脚本Id，长度36字节。
        :rtype: str
        """
        return self._ScriptId

    @ScriptId.setter
    def ScriptId(self, ScriptId):
        self._ScriptId = ScriptId

    @property
    def ScriptName(self):
        r"""脚本名称，长度0-25。
        :rtype: str
        """
        return self._ScriptName

    @ScriptName.setter
    def ScriptName(self, ScriptName):
        self._ScriptName = ScriptName

    @property
    def ScriptDesc(self):
        r"""脚本描述，长度0-50。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ScriptDesc

    @ScriptDesc.setter
    def ScriptDesc(self, ScriptDesc):
        self._ScriptDesc = ScriptDesc

    @property
    def DatabaseName(self):
        r"""默认关联数据库。
        :rtype: str
        """
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def SQLStatement(self):
        r"""SQL描述，长度0-10000。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SQLStatement

    @SQLStatement.setter
    def SQLStatement(self, SQLStatement):
        self._SQLStatement = SQLStatement

    @property
    def UpdateTime(self):
        r"""更新时间戳， 单位：ms。
        :rtype: int
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._ScriptId = params.get("ScriptId")
        self._ScriptName = params.get("ScriptName")
        self._ScriptDesc = params.get("ScriptDesc")
        self._DatabaseName = params.get("DatabaseName")
        self._SQLStatement = params.get("SQLStatement")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SessionResourceTemplate(AbstractModel):
    r"""Spark批作业集群Session资源配置模板；

    """

    def __init__(self):
        r"""
        :param _DriverSize: driver规格：small,medium,large,xlarge；内存型(引擎类型)：m.small,m.medium,m.large,m.xlarge
        :type DriverSize: str
        :param _ExecutorSize: executor规格：small,medium,large,xlarge；内存型(引擎类型)：m.small,m.medium,m.large,m.xlarge
        :type ExecutorSize: str
        :param _ExecutorNums: 指定executor数量，最小值为1，最大值小于集群规格
        :type ExecutorNums: int
        :param _ExecutorMaxNumbers: 指定executor max数量（动态配置场景下），最小值为1，最大值小于集群规格（当ExecutorMaxNumbers小于ExecutorNums时，改值设定为ExecutorNums）
        :type ExecutorMaxNumbers: int
        :param _RunningTimeParameters: 运行时参数
        :type RunningTimeParameters: list of DataEngineConfigPair
        """
        self._DriverSize = None
        self._ExecutorSize = None
        self._ExecutorNums = None
        self._ExecutorMaxNumbers = None
        self._RunningTimeParameters = None

    @property
    def DriverSize(self):
        r"""driver规格：small,medium,large,xlarge；内存型(引擎类型)：m.small,m.medium,m.large,m.xlarge
        :rtype: str
        """
        return self._DriverSize

    @DriverSize.setter
    def DriverSize(self, DriverSize):
        self._DriverSize = DriverSize

    @property
    def ExecutorSize(self):
        r"""executor规格：small,medium,large,xlarge；内存型(引擎类型)：m.small,m.medium,m.large,m.xlarge
        :rtype: str
        """
        return self._ExecutorSize

    @ExecutorSize.setter
    def ExecutorSize(self, ExecutorSize):
        self._ExecutorSize = ExecutorSize

    @property
    def ExecutorNums(self):
        r"""指定executor数量，最小值为1，最大值小于集群规格
        :rtype: int
        """
        return self._ExecutorNums

    @ExecutorNums.setter
    def ExecutorNums(self, Exec