"""先对 $s_1s_2s_3$ 求和，可以得到 $\rho_{ss_0}$"""

# AUTOGENERATED! DO NOT EDIT! File to edit: ../../2-6.ipynb.

# %% auto 0
__all__ = ['calc_reduced_density_matrix', 'calc_observation']

# %% ../../2-6.ipynb 3
from typing import List
import math
import torch
from ..utils import check_quantum_gate

# %% ../../2-6.ipynb 4
def calc_reduced_density_matrix(state: torch.Tensor, qubit_idx: int | List[int]):
    assert isinstance(qubit_idx, (int, list)), "qubit_idx must be an integer or a list of integers"
    if isinstance(qubit_idx, int):
        qubit_idx = [qubit_idx]

    num_qubits = state.ndim
    for qi in qubit_idx:
        assert 0 <= qi < num_qubits, "qubit_idx must be in [0, num_qubits - 1]"

    qubit_indices = list(range(num_qubits))
    dims_to_reduce = [i for i in qubit_indices if i not in qubit_idx]
    dims_to_keep = qubit_idx
    state = state.permute(*(dims_to_keep + dims_to_reduce))  # (*dims_to_keep, *dims_to_reduce)
    shape_to_keep = math.prod([state.shape[i] for i in dims_to_keep])
    shape_to_reduce = math.prod([state.shape[i] for i in dims_to_reduce])
    state = state.reshape(shape_to_keep, shape_to_reduce)
    reduced_density_matrix = state @ state.conj().T
    return reduced_density_matrix


def calc_observation(
    state: torch.Tensor, operator: torch.Tensor, qubit_idx: int | List[int], _fast_mode: bool = True
):
    if isinstance(qubit_idx, int):
        length = 1
    else:
        length = len(qubit_idx)
    reduced_density_matrix = calc_reduced_density_matrix(state, qubit_idx)
    num_qubits_operator = check_quantum_gate(operator)
    assert num_qubits_operator == length, (
        "The number of qubits of the operator does not match the number of qubits of the state"
    )
    operator_mat = operator.reshape(2**num_qubits_operator, 2**num_qubits_operator)
    if _fast_mode:
        return (reduced_density_matrix * operator_mat.T).sum()
    else:
        return torch.trace(reduced_density_matrix @ operator_mat)
