# AUTOGENERATED! DO NOT EDIT! File to edit: ../../../1-4-mlx.ipynb.

# %% auto 0
__all__ = ['identity_tensor']

# %% ../../../1-4-mlx.ipynb 0
import mlx.core as mx

# %% ../../../1-4-mlx.ipynb 5
def identity_tensor(order: int, dim: int, dtype: mx.Dtype = mx.float32) -> mx.array:
    """
    Create an identity tensor of given order and dimension.
    Args:
        order (int): The order of the tensor.
        dim (int): The dimension of the tensor.
        dtype (mx.Dtype): The data type of the tensor. Default is mx.float32.
    Returns:
        mx.array: The identity tensor of shape (dim, dim, ..., dim) with the specified order.
    """
    dims = [dim] * order
    I = mx.zeros(dims, dtype=dtype)
    for i in range(dim):
        indices = [i] * order
        I[tuple(indices)] = 1.0

    return I
