"""力学指使用数序描述物理系统的演化规律"""

# AUTOGENERATED! DO NOT EDIT! File to edit: ../../2-8.ipynb.

# %% auto 0
__all__ = ['heisenberg']

# %% ../../2-8.ipynb 2
import torch
from .functional import pauli_operator

# %% ../../2-8.ipynb 4
def heisenberg(
    *,
    jx: float | torch.Tensor,
    jy: float | torch.Tensor,
    jz: float | torch.Tensor,
    double_precision: bool = False,
    return_matrix: bool = False,
) -> torch.Tensor:
    """
    Calculate the Hamiltonian of the Heisenberg model.
    Args:
        jx: float | torch.Tensor, the coupling strength of the x-axis.
        jy: float | torch.Tensor, the coupling strength of the y-axis.
        jz: float | torch.Tensor, the coupling strength of the z-axis.
        double_precision: bool, whether to use double precision.
        return_matrix: bool, whether to return the Hamiltonian in matrix form. By default, the Hamiltonian is returned in tensor form.
    Returns:
        torch.Tensor, the Hamiltonian of the Heisenberg model.
    """
    pauli_x = pauli_operator(pauli="X", double_precision=double_precision)
    pauli_y = pauli_operator(pauli="Y", double_precision=double_precision)
    pauli_z = pauli_operator(pauli="Z", double_precision=double_precision)
    hamiltonian = (
        jx * torch.einsum("ab, ij -> aibj", pauli_x, pauli_x)
        + jy * torch.einsum("ab, ij -> aibj", pauli_y, pauli_y).real
        + jz * torch.einsum("ab, ij -> aibj", pauli_z, pauli_z)
    )
    hamiltonian /= 4
    if return_matrix:
        return hamiltonian.reshape(4, 4)
    else:
        return hamiltonian
