# do not import all endpoints into this module because that uses a lot of memory and stack frames
# if you need the ability to import all endpoints from this module, import them with
# from openapi_client.apis.path_to_api import path_to_api

import enum


class PathValues(str, enum.Enum):
    AUTH_KEYLOGIN = "/auth/keylogin"
    AUTH_LOGIN = "/auth/login"
    AUTH_KEYGEN = "/auth/keygen"
    AUTH_WHO_AM_I = "/auth/whoAmI"
    AUTH_SIGNUP = "/auth/signup"
    AUTH_ACTIVATE = "/auth/activate"
    AUTH_RESEND_ACTIVATION_MAIL = "/auth/resendActivationMail"
    AUTH_SEND_RESET_PASSWORD_MAIL = "/auth/sendResetPasswordMail"
    AUTH_RESET_PASSWORD = "/auth/resetPassword"
    AUTH_SET_USER_METADATA = "/auth/setUserMetadata"
    AUTH_REQUEST_TRIAL = "/auth/requestTrial"
    AUTH_START_TRIAL = "/auth/startTrial"
    AUTH_EXTEND_TRIAL = "/auth/extendTrial"
    AUTH_LOGOUT = "/auth/logout"
    DASHBOARDS_GET_KIBANA_DASHBOARDS = "/dashboards/getKibanaDashboards"
    DASHBOARDS_GET_PROJECT_DASHBOARDS = "/dashboards/getProjectDashboards"
    DASHBOARDS_GET_DASHBOARD = "/dashboards/getDashboard"
    DASHBOARDS_ADD_DASHBOARD = "/dashboards/addDashboard"
    DASHBOARDS_DELETE_DASHBOARD = "/dashboards/deleteDashboard"
    DASHBOARDS_UPDATE_DASHBOARD = "/dashboards/updateDashboard"
    DASHBOARDS_GET_KIBANA_DASHLET_FIELDS = "/dashboards/getKibanaDashletFields"
    DASHBOARDS_GET_DASHLET_FIELDS = "/dashboards/getDashletFields"
    DATASETS_GET_DATASETS = "/datasets/getDatasets"
    DATASETS_ADD_DATASET = "/datasets/addDataset"
    DATASETS_TRASH_DATASET = "/datasets/trashDataset"
    DATASETS_SAVE_DATASET_VERSION = "/datasets/saveDatasetVersion"
    DATASETS_MODIFY_DATASET_VERSION_NOTE = "/datasets/modifyDatasetVersionNote"
    DATASETS_PARSE_DATASET = "/datasets/parseDataset"
    DATASETS_GET_DATASET_VERSION = "/datasets/getDatasetVersion"
    DATASETS_GET_LATEST_DATASET_VERSION = "/datasets/getLatestDatasetVersion"
    DATASETS_GET_DATASET_VERSIONS = "/datasets/getDatasetVersions"
    DEMOS_GET_DEMOS = "/demos/getDemos"
    DEMOS_IMPORT_DEMO_PROJECT = "/demos/importDemoProject"
    DEMOS_SEND_USER_MESSAGE = "/demos/sendUserMessage"
    EXPORTEDMODELS_GET_EXPORTED_MODEL_JOBS = "/exportedmodels/getExportedModelJobs"
    EXPORTEDMODELS_GET_STORED_EXPORTED_MODEL_RESOURCE_URL = "/exportedmodels/getStoredExportedModelResourceUrl"
    INSIGHTS_GET_MODEL_INSIGHTS = "/insights/getModelInsights"
    ISSUES_GET_PROJECT_ISSUES = "/issues/getProjectIssues"
    ISSUES_GET_SINGLE_ISSUE = "/issues/getSingleIssue"
    ISSUES_UPDATE_ISSUE = "/issues/updateIssue"
    ISSUES_ADD_ISSUE = "/issues/addIssue"
    ISSUES_DELETE_ISSUE = "/issues/deleteIssue"
    JOBS_GET_JOBS = "/jobs/getJobs"
    JOBS_GET_TRAINING_JOBS = "/jobs/getTrainingJobs"
    JOBS_IS_TRAINING_JOB_RUNNING = "/jobs/isTrainingJobRunning"
    JOBS_GET_ORGANIZATION_JOBS = "/jobs/getOrganizationJobs"
    JOBS_STOP_JOB = "/jobs/stopJob"
    JOBS_TERMINATE_JOB = "/jobs/terminateJob"
    JOBS_WARMUP = "/jobs/warmup"
    JOBS_ADD_EXPORT_MODEL_JOB = "/jobs/addExportModelJob"
    JOBS_TRAIN_FROM_SCRATCH = "/jobs/trainFromScratch"
    JOBS_CONTINUE_TRAIN = "/jobs/continueTrain"
    JOBS_TRAIN_FROM_INITIAL_WEIGHTS = "/jobs/trainFromInitialWeights"
    JOBS_EVALUATE = "/jobs/evaluate"
    JOBS_SAMPLE_ANALYSIS = "/jobs/sampleAnalysis"
    JOBS_POPULATION_EXPLORATION = "/jobs/populationExploration"
    JOBS_SAMPLE_SELECTION = "/jobs/sampleSelection"
    JOBS_GET_MACHINE_TYPES = "/jobs/getMachineTypes"
    JOBS_SET_MACHINE_TYPE = "/jobs/setMachineType"
    METADATA_GET_MAX_ACTIVE_USERS = "/metadata/getMaxActiveUsers"
    METADATA_GET_STATISTICS = "/metadata/getStatistics"
    MODELTESTS_CREATE_MODEL_TEST = "/model-tests/createModelTest"
    MODELTESTS_UPDATE_MODEL_TEST = "/model-tests/updateModelTest"
    MODELTESTS_GET_SINGLE_MODEL_TEST = "/model-tests/getSingleModelTest"
    MODELTESTS_GET_ALL_PROJECT_MODEL_TESTS = "/model-tests/getAllProjectModelTests"
    MODELTESTS_DELETE_MODEL_TEST = "/model-tests/deleteModelTest"
    MODELTESTS_GET_MODEL_TEST_RESULT = "/model-tests/getModelTestResult"
    MODELMETRICS_GET_MODEL_EPOCH_LOSS = "/modelmetrics/getModelEpochLoss"
    MODELMETRICS_GET_XYCHART = "/modelmetrics/getXYChart"
    MODELMETRICS_GET_HEATMAP_CHART = "/modelmetrics/getHeatmapChart"
    MODELMETRICS_GET_TABLE_CHART = "/modelmetrics/getTableChart"
    MODELMETRICS_GET_CONFUSION_METRIC_NAMES = "/modelmetrics/getConfusionMetricNames"
    MODELMETRICS_GET_BALANCED_ACCURACY = "/modelmetrics/getBalancedAccuracy"
    MODELMETRICS_GET_F1SCORE = "/modelmetrics/getF1Score"
    MODELMETRICS_GET_PR_CURVE = "/modelmetrics/getPrCurve"
    MODELMETRICS_GET_ROC = "/modelmetrics/getRoc"
    MODELS_GET_MODELS_BY_HASH = "/models/getModelsByHash"
    MODELS_GET_MODELS_BY_VERSION_ID = "/models/getModelsByVersionId"
    MODELS_GET_RECENT_ORGANIZATION_MODELS = "/models/getRecentOrganizationModels"
    MODELS_DELETE_MODEL = "/models/deleteModel"
    MONITOR_HEALTH_CHECK = "/monitor/healthCheck"
    NOTIFICATIONS_GET_NOTIFICATIONS = "/notifications/getNotifications"
    NOTIFICATIONS_SET_USER_NOTIFICATIONS_AS_READ = "/notifications/setUserNotificationsAsRead"
    ORGANIZATIONS_GET_ORGANIZATIONS = "/organizations/getOrganizations"
    ORGANIZATIONS_UPDATE_ORGANIZATION_PUBLIC_NAME = "/organizations/updateOrganizationPublicName"
    ORGANIZATIONS_CREATE_ORGANIZATION = "/organizations/createOrganization"
    ORGANIZATIONS_DELETE_ORGANIZATION = "/organizations/deleteOrganization"
    ORGANIZATIONS_SET_DEFAULT_ORGANIZATION = "/organizations/setDefaultOrganization"
    PROJECTS_ADD_PROJECT = "/projects/addProject"
    PROJECTS_GET_PROJECTS = "/projects/getProjects"
    PROJECTS_LOAD_MODEL = "/projects/loadModel"
    PROJECTS_DELETE_PROJECT = "/projects/deleteProject"
    PROJECTS_TRASH_PROJECT = "/projects/trashProject"
    PROJECTS_GET_CURRENT_PROJECT_VERSION = "/projects/getCurrentProjectVersion"
    SECRETMANAGER_ADD_SECRET_MANAGER = "/secret-manager/addSecretManager"
    SECRETMANAGER_TRASH_SECRET_MANAGER = "/secret-manager/trashSecretManager"
    SECRETMANAGER_GET_SECRET_MANAGER_LIST = "/secret-manager/getSecretManagerList"
    SECRETMANAGER_UPDATE_SECRET_MANAGER = "/secret-manager/updateSecretManager"
    USERS_GET_ORGANIZATION_SLIM_USER_DATA = "/users/getOrganizationSlimUserData"
    USERS_GET_ALL_SLIM_USER_DATA = "/users/getAllSlimUserData"
    USERS_UPDATE_USER_STATUS = "/users/updateUserStatus"
    USERS_UPDATE_USER_ORGANIZATION = "/users/updateUserOrganization"
    USERS_UPDATE_USER_ROLE = "/users/updateUserRole"
    USERS_UPDATE_USER_NAME = "/users/updateUserName"
    USERS_DELETE_USER_BY_ID = "/users/deleteUserById"
    VERSIONS_IMPORT_MODEL = "/versions/importModel"
    VERSIONS_ADD_VERSION = "/versions/addVersion"
    VERSIONS_LOAD_VERSION = "/versions/loadVersion"
    VERSIONS_DELETE_VERSION = "/versions/deleteVersion"
    VERSIONS_UPDATE_VERSION = "/versions/updateVersion"
    VERSIONS_GET_PROJECT_SLIM_VERSIONS = "/versions/getProjectSlimVersions"
    VERSIONS_GET_UPLOAD_SIGNED_URL = "/versions/getUploadSignedUrl"
    VISUALIZATIONS_GET_VISUALIZATION = "/visualizations/getVisualization"
    VISUALIZATIONS_GET_MODEL_VISUALIZATIONS = "/visualizations/getModelVisualizations"
    VISUALIZATIONS_SAVE_ANALYZER_LAYOUT = "/visualizations/saveAnalyzerLayout"
    VISUALIZATIONS_DELETE_VISUALIZATIONS = "/visualizations/deleteVisualizations"
    VISUALIZATIONS_GET_STORED_RESOURCE_URL = "/visualizations/getStoredResourceUrl"
