# tensorleap-openapi-client
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.0.237
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python &gt;&#x3D;3.7

## Migration from other generators like python and python-legacy

### Changes
1. This generator uses spec case for all (object) property names and parameter names.
    - So if the spec has a property name like camelCase, it will use camelCase rather than camel_case
    - So you will need to update how you input and read properties to use spec case
2. Endpoint parameters are stored in dictionaries to prevent collisions (explanation below)
    - So you will need to update how you pass data in to endpoints
3. Endpoint responses now include the original response, the deserialized response body, and (todo)the deserialized headers
    - So you will need to update your code to use response.body to access deserialized data
4. All validated data is instantiated in an instance that subclasses all validated Schema classes and Decimal/str/list/tuple/frozendict/NoneClass/BoolClass/bytes/io.FileIO
    - This means that you can use isinstance to check if a payload validated against a schema class
    - This means that no data will be of type None/True/False
        - ingested None will subclass NoneClass
        - ingested True will subclass BoolClass
        - ingested False will subclass BoolClass
        - So if you need to check is True/False/None, instead use instance.is_true_oapg()/.is_false_oapg()/.is_none_oapg()
5. All validated class instances are immutable except for ones based on io.File
    - This is because if properties were changed after validation, that validation would no longer apply
    - So no changing values or property values after a class has been instantiated
6. String + Number types with formats
    - String type data is stored as a string and if you need to access types based on its format like date,
    date-time, uuid, number etc then you will need to use accessor functions on the instance
    - type string + format: See .as_date_oapg, .as_datetime_oapg, .as_decimal_oapg, .as_uuid_oapg
    - type number + format: See .as_float_oapg, .as_int_oapg
    - this was done because openapi/json-schema defines constraints. string data may be type string with no format
    keyword in one schema, and include a format constraint in another schema
    - So if you need to access a string format based type, use as_date_oapg/as_datetime_oapg/as_decimal_oapg/as_uuid_oapg
    - So if you need to access a number format based type, use as_int_oapg/as_float_oapg
7. Property access on AnyType(type unset) or object(dict) schemas
    - Only required keys with valid python names are properties like .someProp and have type hints
    - All optional keys may not exist, so properties are not defined for them
    - One can access optional values with dict_instance['optionalProp'] and KeyError will be raised if it does not exist
    - Use get_item_oapg if you need a way to always get a value whether or not the key exists
        - If the key does not exist, schemas.unset is returned from calling dict_instance.get_item_oapg('optionalProp')
        - All required and optional keys have type hints for this method, and @typing.overload is used
        - A type hint is also generated for additionalProperties accessed using this method
    - So you will need to update you code to use some_instance['optionalProp'] to access optional property
    and additionalProperty values
8. The location of the api classes has changed
    - Api classes are located in your_package.apis.tags.some_api
    - This change was made to eliminate redundant code generation
    - Legacy generators generated the same endpoint twice if it had > 1 tag on it
    - This generator defines an endpoint in one class, then inherits that class to generate
      apis by tags and by paths
    - This change reduces code and allows quicker run time if you use the path apis
        - path apis are at your_package.apis.paths.some_path
    - Those apis will only load their needed models, which is less to load than all of the resources needed in a tag api
    - So you will need to update your import paths to the api classes

### Why are Oapg and _oapg used in class and method names?
Classes can have arbitrarily named properties set on them
Endpoints can have arbitrary operationId method names set
For those reasons, I use the prefix Oapg and _oapg to greatly reduce the likelihood of collisions
on protected + public classes/methods.
oapg stands for OpenApi Python Generator.

### Object property spec case
This was done because when payloads are ingested, they can be validated against N number of schemas.
If the input signature used a different property name then that has mutated the payload.
So SchemaA and SchemaB must both see the camelCase spec named variable.
Also it is possible to send in two properties, named camelCase and camel_case in the same payload.
That use case should be support so spec case is used.

### Parameter spec case
Parameters can be included in different locations including:
- query
- path
- header
- cookie

Any of those parameters could use the same parameter names, so if every parameter
was included as an endpoint parameter in a function signature, they would collide.
For that reason, each of those inputs have been separated out into separate typed dictionaries:
- query_params
- path_params
- header_params
- cookie_params

So when updating your code, you will need to pass endpoint parameters in using those
dictionaries.

### Endpoint responses
Endpoint responses have been enriched to now include more information.
Any response reom an endpoint will now include the following properties:
response: urllib3.HTTPResponse
body: typing.Union[Unset, Schema]
headers: typing.Union[Unset, TODO]
Note: response header deserialization has not yet been added


## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import tensorleap_openapi_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import tensorleap_openapi_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import tensorleap_openapi_client
from pprint import pprint
from tensorleap_openapi_client.apis.tags import default_api
from tensorleap_openapi_client.model.activation_params import ActivationParams
from tensorleap_openapi_client.model.add_dashboard_params import AddDashboardParams
from tensorleap_openapi_client.model.add_dashboard_response import AddDashboardResponse
from tensorleap_openapi_client.model.add_dataset_response import AddDatasetResponse
from tensorleap_openapi_client.model.add_export_model_job_params import AddExportModelJobParams
from tensorleap_openapi_client.model.add_issue_params import AddIssueParams
from tensorleap_openapi_client.model.add_project_params import AddProjectParams
from tensorleap_openapi_client.model.add_project_response import AddProjectResponse
from tensorleap_openapi_client.model.add_secret_manager_params import AddSecretManagerParams
from tensorleap_openapi_client.model.add_secret_manager_response import AddSecretManagerResponse
from tensorleap_openapi_client.model.add_version_params import AddVersionParams
from tensorleap_openapi_client.model.add_version_response import AddVersionResponse
from tensorleap_openapi_client.model.all_models_test_results import AllModelsTestResults
from tensorleap_openapi_client.model.confusion_matrix_params import ConfusionMatrixParams
from tensorleap_openapi_client.model.confusion_metric_names_response import ConfusionMetricNamesResponse
from tensorleap_openapi_client.model.continue_train_params import ContinueTrainParams
from tensorleap_openapi_client.model.create_model_test_request import CreateModelTestRequest
from tensorleap_openapi_client.model.create_organization_request import CreateOrganizationRequest
from tensorleap_openapi_client.model.create_organization_response import CreateOrganizationResponse
from tensorleap_openapi_client.model.dataset_parse_request_params import DatasetParseRequestParams
from tensorleap_openapi_client.model.delete_dashboard_params import DeleteDashboardParams
from tensorleap_openapi_client.model.delete_issue_params import DeleteIssueParams
from tensorleap_openapi_client.model.delete_model_params import DeleteModelParams
from tensorleap_openapi_client.model.delete_model_test_request import DeleteModelTestRequest
from tensorleap_openapi_client.model.delete_organization_request import DeleteOrganizationRequest
from tensorleap_openapi_client.model.delete_project_params import DeleteProjectParams
from tensorleap_openapi_client.model.delete_user_by_id_request import DeleteUserByIdRequest
from tensorleap_openapi_client.model.delete_version_params import DeleteVersionParams
from tensorleap_openapi_client.model.delete_visualizations_params import DeleteVisualizationsParams
from tensorleap_openapi_client.model.evaluate_params import EvaluateParams
from tensorleap_openapi_client.model.extend_trial_params import ExtendTrialParams
from tensorleap_openapi_client.model.extend_trial_response import ExtendTrialResponse
from tensorleap_openapi_client.model.external_import_model_storage import ExternalImportModelStorage
from tensorleap_openapi_client.model.external_import_model_storage_response import ExternalImportModelStorageResponse
from tensorleap_openapi_client.model.generic_data_query_params import GenericDataQueryParams
from tensorleap_openapi_client.model.get_all_project_model_tests_request import GetAllProjectModelTestsRequest
from tensorleap_openapi_client.model.get_current_project_version_params import GetCurrentProjectVersionParams
from tensorleap_openapi_client.model.get_current_project_version_response import GetCurrentProjectVersionResponse
from tensorleap_openapi_client.model.get_dashboard_params import GetDashboardParams
from tensorleap_openapi_client.model.get_dashboard_response import GetDashboardResponse
from tensorleap_openapi_client.model.get_dashlet_fields_response import GetDashletFieldsResponse
from tensorleap_openapi_client.model.get_dataset_version_params import GetDatasetVersionParams
from tensorleap_openapi_client.model.get_dataset_version_response import GetDatasetVersionResponse
from tensorleap_openapi_client.model.get_dataset_versions_params import GetDatasetVersionsParams
from tensorleap_openapi_client.model.get_dataset_versions_response import GetDatasetVersionsResponse
from tensorleap_openapi_client.model.get_datasets_response import GetDatasetsResponse
from tensorleap_openapi_client.model.get_demos_response import GetDemosResponse
from tensorleap_openapi_client.model.get_exported_model_jobs_params import GetExportedModelJobsParams
from tensorleap_openapi_client.model.get_exported_model_jobs_response import GetExportedModelJobsResponse
from tensorleap_openapi_client.model.get_jobs_params import GetJobsParams
from tensorleap_openapi_client.model.get_jobs_response import GetJobsResponse
from tensorleap_openapi_client.model.get_kibana_dashboards_response import GetKibanaDashboardsResponse
from tensorleap_openapi_client.model.get_kibana_dashlet_fields_response import GetKibanaDashletFieldsResponse
from tensorleap_openapi_client.model.get_latest_dataset_version_params import GetLatestDatasetVersionParams
from tensorleap_openapi_client.model.get_latest_dataset_version_response import GetLatestDatasetVersionResponse
from tensorleap_openapi_client.model.get_machine_types_response import GetMachineTypesResponse
from tensorleap_openapi_client.model.get_max_active_users_response import GetMaxActiveUsersResponse
from tensorleap_openapi_client.model.get_model_epoch_loss_params import GetModelEpochLossParams
from tensorleap_openapi_client.model.get_model_insights_params import GetModelInsightsParams
from tensorleap_openapi_client.model.get_model_insights_response import GetModelInsightsResponse
from tensorleap_openapi_client.model.get_model_test_results_request import GetModelTestResultsRequest
from tensorleap_openapi_client.model.get_model_visualizations_params import GetModelVisualizationsParams
from tensorleap_openapi_client.model.get_model_visualizations_response import GetModelVisualizationsResponse
from tensorleap_openapi_client.model.get_notifications_response import GetNotificationsResponse
from tensorleap_openapi_client.model.get_organization_jobs_params import GetOrganizationJobsParams
from tensorleap_openapi_client.model.get_organization_users_request import GetOrganizationUsersRequest
from tensorleap_openapi_client.model.get_organization_users_response import GetOrganizationUsersResponse
from tensorleap_openapi_client.model.get_organizations_response import GetOrganizationsResponse
from tensorleap_openapi_client.model.get_project_dashboards_params import GetProjectDashboardsParams
from tensorleap_openapi_client.model.get_project_dashboards_response import GetProjectDashboardsResponse
from tensorleap_openapi_client.model.get_project_issues_params import GetProjectIssuesParams
from tensorleap_openapi_client.model.get_project_issues_response import GetProjectIssuesResponse
from tensorleap_openapi_client.model.get_project_slim_versions_response import GetProjectSlimVersionsResponse
from tensorleap_openapi_client.model.get_project_versions_params import GetProjectVersionsParams
from tensorleap_openapi_client.model.get_projects_response import GetProjectsResponse
from tensorleap_openapi_client.model.get_secret_manager_list_response import GetSecretManagerListResponse
from tensorleap_openapi_client.model.get_single_issue_params import GetSingleIssueParams
from tensorleap_openapi_client.model.get_single_model_test_request import GetSingleModelTestRequest
from tensorleap_openapi_client.model.get_statistics_response import GetStatisticsResponse
from tensorleap_openapi_client.model.get_stored_exported_model_resource_url_params import GetStoredExportedModelResourceUrlParams
from tensorleap_openapi_client.model.get_stored_exported_model_resource_url_response import GetStoredExportedModelResourceUrlResponse
from tensorleap_openapi_client.model.get_stored_resource_url_params import GetStoredResourceUrlParams
from tensorleap_openapi_client.model.get_training_job_params import GetTrainingJobParams
from tensorleap_openapi_client.model.get_upload_signed_url_params import GetUploadSignedUrlParams
from tensorleap_openapi_client.model.get_visualization_params import GetVisualizationParams
from tensorleap_openapi_client.model.health_check_response import HealthCheckResponse
from tensorleap_openapi_client.model.heatmap_charts_params import HeatmapChartsParams
from tensorleap_openapi_client.model.import_demo_project_params import ImportDemoProjectParams
from tensorleap_openapi_client.model.import_demo_project_response import ImportDemoProjectResponse
from tensorleap_openapi_client.model.import_new_model_params import ImportNewModelParams
from tensorleap_openapi_client.model.is_training_job_running_params import IsTrainingJobRunningParams
from tensorleap_openapi_client.model.is_training_job_running_response import IsTrainingJobRunningResponse
from tensorleap_openapi_client.model.issue import Issue
from tensorleap_openapi_client.model.job import Job
from tensorleap_openapi_client.model.key_login_params import KeyLoginParams
from tensorleap_openapi_client.model.load_model_params import LoadModelParams
from tensorleap_openapi_client.model.load_model_response import LoadModelResponse
from tensorleap_openapi_client.model.load_version_params import LoadVersionParams
from tensorleap_openapi_client.model.load_version_response import LoadVersionResponse
from tensorleap_openapi_client.model.login_params import LoginParams
from tensorleap_openapi_client.model.model_hash_request_params import ModelHashRequestParams
from tensorleap_openapi_client.model.model_test import ModelTest
from tensorleap_openapi_client.model.model_version_id_request_params import ModelVersionIdRequestParams
from tensorleap_openapi_client.model.models_response import ModelsResponse
from tensorleap_openapi_client.model.modify_dataset_version_note_params import ModifyDatasetVersionNoteParams
from tensorleap_openapi_client.model.modify_dataset_version_note_response import ModifyDatasetVersionNoteResponse
from tensorleap_openapi_client.model.multi_charts_params import MultiChartsParams
from tensorleap_openapi_client.model.multi_charts_response import MultiChartsResponse
from tensorleap_openapi_client.model.multi_threshold_confusion_matrix_params import MultiThresholdConfusionMatrixParams
from tensorleap_openapi_client.model.new_dataset_params import NewDatasetParams
from tensorleap_openapi_client.model.parse_dataset_response import ParseDatasetResponse
from tensorleap_openapi_client.model.population_exploration_params import PopulationExplorationParams
from tensorleap_openapi_client.model.recent_models_response import RecentModelsResponse
from tensorleap_openapi_client.model.recent_organization_models_request_params import RecentOrganizationModelsRequestParams
from tensorleap_openapi_client.model.request_trial_params import RequestTrialParams
from tensorleap_openapi_client.model.request_trial_response import RequestTrialResponse
from tensorleap_openapi_client.model.resend_activation_mail_params import ResendActivationMailParams
from tensorleap_openapi_client.model.resend_activation_mail_response import ResendActivationMailResponse
from tensorleap_openapi_client.model.reset_password_params import ResetPasswordParams
from tensorleap_openapi_client.model.reset_password_response import ResetPasswordResponse
from tensorleap_openapi_client.model.rotate_api_key_response import RotateApiKeyResponse
from tensorleap_openapi_client.model.sample_analysis_params import SampleAnalysisParams
from tensorleap_openapi_client.model.sample_selection_params import SampleSelectionParams
from tensorleap_openapi_client.model.save_analyzer_layout_params import SaveAnalyzerLayoutParams
from tensorleap_openapi_client.model.save_dataset_setup_response import SaveDatasetSetupResponse
from tensorleap_openapi_client.model.save_dataset_version_params import SaveDatasetVersionParams
from tensorleap_openapi_client.model.send_reset_password_mail_params import SendResetPasswordMailParams
from tensorleap_openapi_client.model.send_reset_password_mail_response import SendResetPasswordMailResponse
from tensorleap_openapi_client.model.send_user_message_params import SendUserMessageParams
from tensorleap_openapi_client.model.send_user_message_response import SendUserMessageResponse
from tensorleap_openapi_client.model.set_default_organization_request import SetDefaultOrganizationRequest
from tensorleap_openapi_client.model.set_organization_machine_type_params import SetOrganizationMachineTypeParams
from tensorleap_openapi_client.model.set_user_metadata_params import SetUserMetadataParams
from tensorleap_openapi_client.model.set_user_metadata_response import SetUserMetadataResponse
from tensorleap_openapi_client.model.signup_params import SignupParams
from tensorleap_openapi_client.model.signup_response import SignupResponse
from tensorleap_openapi_client.model.slim_user_data import SlimUserData
from tensorleap_openapi_client.model.start_trial_params import StartTrialParams
from tensorleap_openapi_client.model.stop_job_params import StopJobParams
from tensorleap_openapi_client.model.stop_job_response import StopJobResponse
from tensorleap_openapi_client.model.terminate_job_params import TerminateJobParams
from tensorleap_openapi_client.model.terminate_job_response import TerminateJobResponse
from tensorleap_openapi_client.model.train_from_initial_weights_params import TrainFromInitialWeightsParams
from tensorleap_openapi_client.model.train_from_scratch_params import TrainFromScratchParams
from tensorleap_openapi_client.model.trash_dataset_params import TrashDatasetParams
from tensorleap_openapi_client.model.trash_project_params import TrashProjectParams
from tensorleap_openapi_client.model.trash_secret_manager_params import TrashSecretManagerParams
from tensorleap_openapi_client.model.trash_secret_manager_response import TrashSecretManagerResponse
from tensorleap_openapi_client.model.update_dashboard_params import UpdateDashboardParams
from tensorleap_openapi_client.model.update_issue_params import UpdateIssueParams
from tensorleap_openapi_client.model.update_model_test_request import UpdateModelTestRequest
from tensorleap_openapi_client.model.update_organization_public_name_request import UpdateOrganizationPublicNameRequest
from tensorleap_openapi_client.model.update_secret_manager_params import UpdateSecretManagerParams
from tensorleap_openapi_client.model.update_secret_manager_response import UpdateSecretManagerResponse
from tensorleap_openapi_client.model.update_user_name_request import UpdateUserNameRequest
from tensorleap_openapi_client.model.update_user_organization_request import UpdateUserOrganizationRequest
from tensorleap_openapi_client.model.update_user_role_request import UpdateUserRoleRequest
from tensorleap_openapi_client.model.update_user_status_request import UpdateUserStatusRequest
from tensorleap_openapi_client.model.update_version_params import UpdateVersionParams
from tensorleap_openapi_client.model.update_version_response import UpdateVersionResponse
from tensorleap_openapi_client.model.user_data import UserData
from tensorleap_openapi_client.model.visualization import Visualization
from tensorleap_openapi_client.model.xy_charts_response import XYChartsResponse
# Defining the host is optional and defaults to /api/v2
# See configuration.py for a list of all supported configuration parameters.
configuration = tensorleap_openapi_client.Configuration(
    host = "/api/v2"
)


# Enter a context with an instance of the API client
with tensorleap_openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = default_api.DefaultApi(api_client)
    activation_params = ActivationParams(
        token="token_example",
    ) # ActivationParams | 

    try:
        api_response = api_instance.activate(activation_params)
        pprint(api_response)
    except tensorleap_openapi_client.ApiException as e:
        print("Exception when calling DefaultApi->activate: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to */api/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**activate**](docs/apis/tags/DefaultApi.md#activate) | **post** /auth/activate | 
*DefaultApi* | [**add_dashboard**](docs/apis/tags/DefaultApi.md#add_dashboard) | **post** /dashboards/addDashboard | 
*DefaultApi* | [**add_dataset**](docs/apis/tags/DefaultApi.md#add_dataset) | **post** /datasets/addDataset | 
*DefaultApi* | [**add_export_model_job**](docs/apis/tags/DefaultApi.md#add_export_model_job) | **post** /jobs/addExportModelJob | 
*DefaultApi* | [**add_issue**](docs/apis/tags/DefaultApi.md#add_issue) | **post** /issues/addIssue | 
*DefaultApi* | [**add_project**](docs/apis/tags/DefaultApi.md#add_project) | **post** /projects/addProject | 
*DefaultApi* | [**add_secret_manager**](docs/apis/tags/DefaultApi.md#add_secret_manager) | **post** /secret-manager/addSecretManager | 
*DefaultApi* | [**add_version**](docs/apis/tags/DefaultApi.md#add_version) | **post** /versions/addVersion | 
*DefaultApi* | [**continue_train**](docs/apis/tags/DefaultApi.md#continue_train) | **post** /jobs/continueTrain | 
*DefaultApi* | [**create_model_test**](docs/apis/tags/DefaultApi.md#create_model_test) | **post** /model-tests/createModelTest | 
*DefaultApi* | [**create_organization**](docs/apis/tags/DefaultApi.md#create_organization) | **post** /organizations/createOrganization | 
*DefaultApi* | [**delete_dashboard**](docs/apis/tags/DefaultApi.md#delete_dashboard) | **post** /dashboards/deleteDashboard | 
*DefaultApi* | [**delete_issue**](docs/apis/tags/DefaultApi.md#delete_issue) | **post** /issues/deleteIssue | 
*DefaultApi* | [**delete_model**](docs/apis/tags/DefaultApi.md#delete_model) | **post** /models/deleteModel | 
*DefaultApi* | [**delete_model_test**](docs/apis/tags/DefaultApi.md#delete_model_test) | **post** /model-tests/deleteModelTest | 
*DefaultApi* | [**delete_organization**](docs/apis/tags/DefaultApi.md#delete_organization) | **post** /organizations/deleteOrganization | 
*DefaultApi* | [**delete_project**](docs/apis/tags/DefaultApi.md#delete_project) | **post** /projects/deleteProject | 
*DefaultApi* | [**delete_user_by_id**](docs/apis/tags/DefaultApi.md#delete_user_by_id) | **post** /users/deleteUserById | 
*DefaultApi* | [**delete_version**](docs/apis/tags/DefaultApi.md#delete_version) | **post** /versions/deleteVersion | 
*DefaultApi* | [**delete_visualizations**](docs/apis/tags/DefaultApi.md#delete_visualizations) | **post** /visualizations/deleteVisualizations | 
*DefaultApi* | [**evaluate**](docs/apis/tags/DefaultApi.md#evaluate) | **post** /jobs/evaluate | 
*DefaultApi* | [**extend_trial**](docs/apis/tags/DefaultApi.md#extend_trial) | **post** /auth/extendTrial | 
*DefaultApi* | [**get_all_project_model_tests**](docs/apis/tags/DefaultApi.md#get_all_project_model_tests) | **post** /model-tests/getAllProjectModelTests | 
*DefaultApi* | [**get_all_slim_user_data**](docs/apis/tags/DefaultApi.md#get_all_slim_user_data) | **post** /users/getAllSlimUserData | 
*DefaultApi* | [**get_balanced_accuracy**](docs/apis/tags/DefaultApi.md#get_balanced_accuracy) | **post** /modelmetrics/getBalancedAccuracy | 
*DefaultApi* | [**get_confusion_metric_names**](docs/apis/tags/DefaultApi.md#get_confusion_metric_names) | **post** /modelmetrics/getConfusionMetricNames | 
*DefaultApi* | [**get_current_project_version**](docs/apis/tags/DefaultApi.md#get_current_project_version) | **post** /projects/getCurrentProjectVersion | 
*DefaultApi* | [**get_dashboard**](docs/apis/tags/DefaultApi.md#get_dashboard) | **post** /dashboards/getDashboard | 
*DefaultApi* | [**get_dashlet_fields**](docs/apis/tags/DefaultApi.md#get_dashlet_fields) | **post** /dashboards/getDashletFields | 
*DefaultApi* | [**get_dataset_version**](docs/apis/tags/DefaultApi.md#get_dataset_version) | **post** /datasets/getDatasetVersion | 
*DefaultApi* | [**get_dataset_versions**](docs/apis/tags/DefaultApi.md#get_dataset_versions) | **post** /datasets/getDatasetVersions | 
*DefaultApi* | [**get_datasets**](docs/apis/tags/DefaultApi.md#get_datasets) | **post** /datasets/getDatasets | 
*DefaultApi* | [**get_demos**](docs/apis/tags/DefaultApi.md#get_demos) | **post** /demos/getDemos | 
*DefaultApi* | [**get_exported_model_jobs**](docs/apis/tags/DefaultApi.md#get_exported_model_jobs) | **post** /exportedmodels/getExportedModelJobs | 
*DefaultApi* | [**get_f1_score**](docs/apis/tags/DefaultApi.md#get_f1_score) | **post** /modelmetrics/getF1Score | 
*DefaultApi* | [**get_heatmap_chart**](docs/apis/tags/DefaultApi.md#get_heatmap_chart) | **post** /modelmetrics/getHeatmapChart | 
*DefaultApi* | [**get_jobs**](docs/apis/tags/DefaultApi.md#get_jobs) | **post** /jobs/getJobs | 
*DefaultApi* | [**get_kibana_dashboards**](docs/apis/tags/DefaultApi.md#get_kibana_dashboards) | **post** /dashboards/getKibanaDashboards | 
*DefaultApi* | [**get_kibana_dashlet_fields**](docs/apis/tags/DefaultApi.md#get_kibana_dashlet_fields) | **post** /dashboards/getKibanaDashletFields | 
*DefaultApi* | [**get_latest_dataset_version**](docs/apis/tags/DefaultApi.md#get_latest_dataset_version) | **post** /datasets/getLatestDatasetVersion | 
*DefaultApi* | [**get_machine_types**](docs/apis/tags/DefaultApi.md#get_machine_types) | **post** /jobs/getMachineTypes | 
*DefaultApi* | [**get_max_active_users**](docs/apis/tags/DefaultApi.md#get_max_active_users) | **post** /metadata/getMaxActiveUsers | 
*DefaultApi* | [**get_model_epoch_loss**](docs/apis/tags/DefaultApi.md#get_model_epoch_loss) | **post** /modelmetrics/getModelEpochLoss | 
*DefaultApi* | [**get_model_insights**](docs/apis/tags/DefaultApi.md#get_model_insights) | **post** /insights/getModelInsights | 
*DefaultApi* | [**get_model_test_result**](docs/apis/tags/DefaultApi.md#get_model_test_result) | **post** /model-tests/getModelTestResult | 
*DefaultApi* | [**get_model_visualizations**](docs/apis/tags/DefaultApi.md#get_model_visualizations) | **post** /visualizations/getModelVisualizations | 
*DefaultApi* | [**get_models_by_hash**](docs/apis/tags/DefaultApi.md#get_models_by_hash) | **post** /models/getModelsByHash | 
*DefaultApi* | [**get_models_by_version_id**](docs/apis/tags/DefaultApi.md#get_models_by_version_id) | **post** /models/getModelsByVersionId | 
*DefaultApi* | [**get_notifications**](docs/apis/tags/DefaultApi.md#get_notifications) | **post** /notifications/getNotifications | 
*DefaultApi* | [**get_organization_jobs**](docs/apis/tags/DefaultApi.md#get_organization_jobs) | **post** /jobs/getOrganizationJobs | 
*DefaultApi* | [**get_organization_slim_user_data**](docs/apis/tags/DefaultApi.md#get_organization_slim_user_data) | **post** /users/getOrganizationSlimUserData | 
*DefaultApi* | [**get_organizations**](docs/apis/tags/DefaultApi.md#get_organizations) | **post** /organizations/getOrganizations | 
*DefaultApi* | [**get_pr_curve**](docs/apis/tags/DefaultApi.md#get_pr_curve) | **post** /modelmetrics/getPrCurve | 
*DefaultApi* | [**get_project_dashboards**](docs/apis/tags/DefaultApi.md#get_project_dashboards) | **post** /dashboards/getProjectDashboards | 
*DefaultApi* | [**get_project_issues**](docs/apis/tags/DefaultApi.md#get_project_issues) | **post** /issues/getProjectIssues | 
*DefaultApi* | [**get_project_slim_versions**](docs/apis/tags/DefaultApi.md#get_project_slim_versions) | **post** /versions/getProjectSlimVersions | 
*DefaultApi* | [**get_projects**](docs/apis/tags/DefaultApi.md#get_projects) | **post** /projects/getProjects | 
*DefaultApi* | [**get_recent_organization_models**](docs/apis/tags/DefaultApi.md#get_recent_organization_models) | **post** /models/getRecentOrganizationModels | 
*DefaultApi* | [**get_roc**](docs/apis/tags/DefaultApi.md#get_roc) | **post** /modelmetrics/getRoc | 
*DefaultApi* | [**get_secret_manager_list**](docs/apis/tags/DefaultApi.md#get_secret_manager_list) | **post** /secret-manager/getSecretManagerList | 
*DefaultApi* | [**get_single_issue**](docs/apis/tags/DefaultApi.md#get_single_issue) | **post** /issues/getSingleIssue | 
*DefaultApi* | [**get_single_model_test**](docs/apis/tags/DefaultApi.md#get_single_model_test) | **post** /model-tests/getSingleModelTest | 
*DefaultApi* | [**get_statistics**](docs/apis/tags/DefaultApi.md#get_statistics) | **post** /metadata/getStatistics | 
*DefaultApi* | [**get_stored_exported_model_resource_url**](docs/apis/tags/DefaultApi.md#get_stored_exported_model_resource_url) | **post** /exportedmodels/getStoredExportedModelResourceUrl | 
*DefaultApi* | [**get_stored_resource_url**](docs/apis/tags/DefaultApi.md#get_stored_resource_url) | **post** /visualizations/getStoredResourceUrl | 
*DefaultApi* | [**get_table_chart**](docs/apis/tags/DefaultApi.md#get_table_chart) | **post** /modelmetrics/getTableChart | 
*DefaultApi* | [**get_training_jobs**](docs/apis/tags/DefaultApi.md#get_training_jobs) | **post** /jobs/getTrainingJobs | 
*DefaultApi* | [**get_upload_signed_url**](docs/apis/tags/DefaultApi.md#get_upload_signed_url) | **post** /versions/getUploadSignedUrl | 
*DefaultApi* | [**get_visualization**](docs/apis/tags/DefaultApi.md#get_visualization) | **post** /visualizations/getVisualization | 
*DefaultApi* | [**get_xy_chart**](docs/apis/tags/DefaultApi.md#get_xy_chart) | **post** /modelmetrics/getXYChart | 
*DefaultApi* | [**health_check**](docs/apis/tags/DefaultApi.md#health_check) | **get** /monitor/healthCheck | 
*DefaultApi* | [**import_demo_project**](docs/apis/tags/DefaultApi.md#import_demo_project) | **post** /demos/importDemoProject | 
*DefaultApi* | [**import_model**](docs/apis/tags/DefaultApi.md#import_model) | **post** /versions/importModel | 
*DefaultApi* | [**is_training_job_running**](docs/apis/tags/DefaultApi.md#is_training_job_running) | **post** /jobs/isTrainingJobRunning | 
*DefaultApi* | [**key_gen**](docs/apis/tags/DefaultApi.md#key_gen) | **post** /auth/keygen | 
*DefaultApi* | [**key_login**](docs/apis/tags/DefaultApi.md#key_login) | **post** /auth/keylogin | 
*DefaultApi* | [**load_model**](docs/apis/tags/DefaultApi.md#load_model) | **post** /projects/loadModel | 
*DefaultApi* | [**load_version**](docs/apis/tags/DefaultApi.md#load_version) | **post** /versions/loadVersion | 
*DefaultApi* | [**login**](docs/apis/tags/DefaultApi.md#login) | **post** /auth/login | 
*DefaultApi* | [**logout**](docs/apis/tags/DefaultApi.md#logout) | **post** /auth/logout | 
*DefaultApi* | [**modify_dataset_version_note**](docs/apis/tags/DefaultApi.md#modify_dataset_version_note) | **post** /datasets/modifyDatasetVersionNote | 
*DefaultApi* | [**parse_dataset**](docs/apis/tags/DefaultApi.md#parse_dataset) | **post** /datasets/parseDataset | 
*DefaultApi* | [**population_exploration**](docs/apis/tags/DefaultApi.md#population_exploration) | **post** /jobs/populationExploration | 
*DefaultApi* | [**request_trial**](docs/apis/tags/DefaultApi.md#request_trial) | **post** /auth/requestTrial | 
*DefaultApi* | [**resend_activation_mail**](docs/apis/tags/DefaultApi.md#resend_activation_mail) | **post** /auth/resendActivationMail | 
*DefaultApi* | [**reset_password**](docs/apis/tags/DefaultApi.md#reset_password) | **post** /auth/resetPassword | 
*DefaultApi* | [**sample_analysis**](docs/apis/tags/DefaultApi.md#sample_analysis) | **post** /jobs/sampleAnalysis | 
*DefaultApi* | [**sample_selection**](docs/apis/tags/DefaultApi.md#sample_selection) | **post** /jobs/sampleSelection | 
*DefaultApi* | [**save_analyzer_layout**](docs/apis/tags/DefaultApi.md#save_analyzer_layout) | **post** /visualizations/saveAnalyzerLayout | 
*DefaultApi* | [**save_dataset_version**](docs/apis/tags/DefaultApi.md#save_dataset_version) | **post** /datasets/saveDatasetVersion | 
*DefaultApi* | [**send_reset_password_mail**](docs/apis/tags/DefaultApi.md#send_reset_password_mail) | **post** /auth/sendResetPasswordMail | 
*DefaultApi* | [**send_user_message**](docs/apis/tags/DefaultApi.md#send_user_message) | **post** /demos/sendUserMessage | 
*DefaultApi* | [**set_default_organization**](docs/apis/tags/DefaultApi.md#set_default_organization) | **post** /organizations/setDefaultOrganization | 
*DefaultApi* | [**set_organization_machine_type**](docs/apis/tags/DefaultApi.md#set_organization_machine_type) | **post** /jobs/setMachineType | 
*DefaultApi* | [**set_user_metadata**](docs/apis/tags/DefaultApi.md#set_user_metadata) | **post** /auth/setUserMetadata | 
*DefaultApi* | [**set_user_notifications_as_read**](docs/apis/tags/DefaultApi.md#set_user_notifications_as_read) | **post** /notifications/setUserNotificationsAsRead | 
*DefaultApi* | [**signup**](docs/apis/tags/DefaultApi.md#signup) | **post** /auth/signup | 
*DefaultApi* | [**start_trial**](docs/apis/tags/DefaultApi.md#start_trial) | **post** /auth/startTrial | 
*DefaultApi* | [**stop_job**](docs/apis/tags/DefaultApi.md#stop_job) | **post** /jobs/stopJob | 
*DefaultApi* | [**terminate_job**](docs/apis/tags/DefaultApi.md#terminate_job) | **post** /jobs/terminateJob | 
*DefaultApi* | [**train_from_initial_weights**](docs/apis/tags/DefaultApi.md#train_from_initial_weights) | **post** /jobs/trainFromInitialWeights | 
*DefaultApi* | [**train_from_scratch**](docs/apis/tags/DefaultApi.md#train_from_scratch) | **post** /jobs/trainFromScratch | 
*DefaultApi* | [**trash_dataset**](docs/apis/tags/DefaultApi.md#trash_dataset) | **post** /datasets/trashDataset | 
*DefaultApi* | [**trash_project**](docs/apis/tags/DefaultApi.md#trash_project) | **post** /projects/trashProject | 
*DefaultApi* | [**trash_secret_manager**](docs/apis/tags/DefaultApi.md#trash_secret_manager) | **post** /secret-manager/trashSecretManager | 
*DefaultApi* | [**update_dashboard**](docs/apis/tags/DefaultApi.md#update_dashboard) | **post** /dashboards/updateDashboard | 
*DefaultApi* | [**update_issue**](docs/apis/tags/DefaultApi.md#update_issue) | **post** /issues/updateIssue | 
*DefaultApi* | [**update_model_test**](docs/apis/tags/DefaultApi.md#update_model_test) | **post** /model-tests/updateModelTest | 
*DefaultApi* | [**update_organization_public_name**](docs/apis/tags/DefaultApi.md#update_organization_public_name) | **post** /organizations/updateOrganizationPublicName | 
*DefaultApi* | [**update_secret_manager**](docs/apis/tags/DefaultApi.md#update_secret_manager) | **post** /secret-manager/updateSecretManager | 
*DefaultApi* | [**update_user_name**](docs/apis/tags/DefaultApi.md#update_user_name) | **post** /users/updateUserName | 
*DefaultApi* | [**update_user_organization**](docs/apis/tags/DefaultApi.md#update_user_organization) | **post** /users/updateUserOrganization | 
*DefaultApi* | [**update_user_role**](docs/apis/tags/DefaultApi.md#update_user_role) | **post** /users/updateUserRole | 
*DefaultApi* | [**update_user_status**](docs/apis/tags/DefaultApi.md#update_user_status) | **post** /users/updateUserStatus | 
*DefaultApi* | [**update_version**](docs/apis/tags/DefaultApi.md#update_version) | **post** /versions/updateVersion | 
*DefaultApi* | [**warmup**](docs/apis/tags/DefaultApi.md#warmup) | **post** /jobs/warmup | 
*DefaultApi* | [**who_am_i**](docs/apis/tags/DefaultApi.md#who_am_i) | **post** /auth/whoAmI | 

## Documentation For Models

 - [ActionAssignmentElement](docs/models/ActionAssignmentElement.md)
 - [ActionCommentElement](docs/models/ActionCommentElement.md)
 - [ActionTagElement](docs/models/ActionTagElement.md)
 - [ActivationParams](docs/models/ActivationParams.md)
 - [AddDashboardParams](docs/models/AddDashboardParams.md)
 - [AddDashboardResponse](docs/models/AddDashboardResponse.md)
 - [AddDatasetResponse](docs/models/AddDatasetResponse.md)
 - [AddExportModelJobParams](docs/models/AddExportModelJobParams.md)
 - [AddIssueParams](docs/models/AddIssueParams.md)
 - [AddProjectParams](docs/models/AddProjectParams.md)
 - [AddProjectResponse](docs/models/AddProjectResponse.md)
 - [AddSecretManagerParams](docs/models/AddSecretManagerParams.md)
 - [AddSecretManagerResponse](docs/models/AddSecretManagerResponse.md)
 - [AddVersionParams](docs/models/AddVersionParams.md)
 - [AddVersionResponse](docs/models/AddVersionResponse.md)
 - [AggregationMethod](docs/models/AggregationMethod.md)
 - [Aggregations](docs/models/Aggregations.md)
 - [AllModelsTestResults](docs/models/AllModelsTestResults.md)
 - [AnalyzeParams](docs/models/AnalyzeParams.md)
 - [AnalyzeTypeEnum](docs/models/AnalyzeTypeEnum.md)
 - [AxisType](docs/models/AxisType.md)
 - [BBoxImageData](docs/models/BBoxImageData.md)
 - [BBoxImageScatterLabel](docs/models/BBoxImageScatterLabel.md)
 - [BBoxImageViz](docs/models/BBoxImageViz.md)
 - [BasicVisualizationInfo](docs/models/BasicVisualizationInfo.md)
 - [BoundingBox](docs/models/BoundingBox.md)
 - [BucketAggregation](docs/models/BucketAggregation.md)
 - [ChartResponse](docs/models/ChartResponse.md)
 - [ClientFilterParams](docs/models/ClientFilterParams.md)
 - [ClusterInsight](docs/models/ClusterInsight.md)
 - [Clusters](docs/models/Clusters.md)
 - [ConfusionMatrixParams](docs/models/ConfusionMatrixParams.md)
 - [ConfusionMetricNamesResponse](docs/models/ConfusionMetricNamesResponse.md)
 - [ContinueTrainParams](docs/models/ContinueTrainParams.md)
 - [CreateModelTestRequest](docs/models/CreateModelTestRequest.md)
 - [CreateOrganizationRequest](docs/models/CreateOrganizationRequest.md)
 - [CreateOrganizationResponse](docs/models/CreateOrganizationResponse.md)
 - [CustomLayerInstance](docs/models/CustomLayerInstance.md)
 - [CustomMessageData](docs/models/CustomMessageData.md)
 - [CustomMessageDataParams](docs/models/CustomMessageDataParams.md)
 - [CustomVisualizationData](docs/models/CustomVisualizationData.md)
 - [CustomVisualizationItem](docs/models/CustomVisualizationItem.md)
 - [CustomVisualizationType](docs/models/CustomVisualizationType.md)
 - [Dashboard](docs/models/Dashboard.md)
 - [DashboardItem](docs/models/DashboardItem.md)
 - [DataDistributionType](docs/models/DataDistributionType.md)
 - [DataStateForEval](docs/models/DataStateForEval.md)
 - [DataStateType](docs/models/DataStateType.md)
 - [DataTypeEnum](docs/models/DataTypeEnum.md)
 - [Dataset](docs/models/Dataset.md)
 - [DatasetAccess](docs/models/DatasetAccess.md)
 - [DatasetInputInstance](docs/models/DatasetInputInstance.md)
 - [DatasetMessageParams](docs/models/DatasetMessageParams.md)
 - [DatasetMetadata](docs/models/DatasetMetadata.md)
 - [DatasetMetadataInstance](docs/models/DatasetMetadataInstance.md)
 - [DatasetMetadataType](docs/models/DatasetMetadataType.md)
 - [DatasetOutputInstance](docs/models/DatasetOutputInstance.md)
 - [DatasetParseRequestParams](docs/models/DatasetParseRequestParams.md)
 - [DatasetPreprocess](docs/models/DatasetPreprocess.md)
 - [DatasetSetup](docs/models/DatasetSetup.md)
 - [DatasetSetupStatus](docs/models/DatasetSetupStatus.md)
 - [DatasetTestResultPayload](docs/models/DatasetTestResultPayload.md)
 - [DatasetVersion](docs/models/DatasetVersion.md)
 - [DeleteDashboardParams](docs/models/DeleteDashboardParams.md)
 - [DeleteIssueParams](docs/models/DeleteIssueParams.md)
 - [DeleteModelParams](docs/models/DeleteModelParams.md)
 - [DeleteModelTestRequest](docs/models/DeleteModelTestRequest.md)
 - [DeleteOrganizationRequest](docs/models/DeleteOrganizationRequest.md)
 - [DeleteProjectParams](docs/models/DeleteProjectParams.md)
 - [DeleteUserByIdRequest](docs/models/DeleteUserByIdRequest.md)
 - [DeleteVersionParams](docs/models/DeleteVersionParams.md)
 - [DeleteVisualizationsParams](docs/models/DeleteVisualizationsParams.md)
 - [Demo](docs/models/Demo.md)
 - [Domain](docs/models/Domain.md)
 - [DomainMax](docs/models/DomainMax.md)
 - [DomainMin](docs/models/DomainMin.md)
 - [ESFilter](docs/models/ESFilter.md)
 - [ESFilterValue](docs/models/ESFilterValue.md)
 - [EarlyStopParams](docs/models/EarlyStopParams.md)
 - [EsBatchAggregationType](docs/models/EsBatchAggregationType.md)
 - [EvaluateParams](docs/models/EvaluateParams.md)
 - [ExportModelParams](docs/models/ExportModelParams.md)
 - [ExportModelTypeEnum](docs/models/ExportModelTypeEnum.md)
 - [ExportedModelJobUi](docs/models/ExportedModelJobUi.md)
 - [ExtendTrialParams](docs/models/ExtendTrialParams.md)
 - [ExtendTrialResponse](docs/models/ExtendTrialResponse.md)
 - [ExternalImportModelStorage](docs/models/ExternalImportModelStorage.md)
 - [ExternalImportModelStorageResponse](docs/models/ExternalImportModelStorageResponse.md)
 - [FeatureImportance](docs/models/FeatureImportance.md)
 - [FeatureImportanceItem](docs/models/FeatureImportanceItem.md)
 - [FilterOperatorType](docs/models/FilterOperatorType.md)
 - [GeneralMessageParams](docs/models/GeneralMessageParams.md)
 - [GenericDataQueryParams](docs/models/GenericDataQueryParams.md)
 - [GenericDataResponse](docs/models/GenericDataResponse.md)
 - [GetAllProjectModelTestsRequest](docs/models/GetAllProjectModelTestsRequest.md)
 - [GetBalancedAccuracyParams](docs/models/GetBalancedAccuracyParams.md)
 - [GetConfusionMetricNamesObject](docs/models/GetConfusionMetricNamesObject.md)
 - [GetCurrentProjectVersionParams](docs/models/GetCurrentProjectVersionParams.md)
 - [GetCurrentProjectVersionResponse](docs/models/GetCurrentProjectVersionResponse.md)
 - [GetDashboardParams](docs/models/GetDashboardParams.md)
 - [GetDashboardResponse](docs/models/GetDashboardResponse.md)
 - [GetDashletFieldsResponse](docs/models/GetDashletFieldsResponse.md)
 - [GetDatasetVersionParams](docs/models/GetDatasetVersionParams.md)
 - [GetDatasetVersionResponse](docs/models/GetDatasetVersionResponse.md)
 - [GetDatasetVersionsParams](docs/models/GetDatasetVersionsParams.md)
 - [GetDatasetVersionsResponse](docs/models/GetDatasetVersionsResponse.md)
 - [GetDatasetsResponse](docs/models/GetDatasetsResponse.md)
 - [GetDemosResponse](docs/models/GetDemosResponse.md)
 - [GetExportedModelJobsParams](docs/models/GetExportedModelJobsParams.md)
 - [GetExportedModelJobsResponse](docs/models/GetExportedModelJobsResponse.md)
 - [GetF1ScoreParams](docs/models/GetF1ScoreParams.md)
 - [GetJobsParams](docs/models/GetJobsParams.md)
 - [GetJobsResponse](docs/models/GetJobsResponse.md)
 - [GetKibanaDashboardsResponse](docs/models/GetKibanaDashboardsResponse.md)
 - [GetKibanaDashletFieldsResponse](docs/models/GetKibanaDashletFieldsResponse.md)
 - [GetLatestDatasetVersionParams](docs/models/GetLatestDatasetVersionParams.md)
 - [GetLatestDatasetVersionResponse](docs/models/GetLatestDatasetVersionResponse.md)
 - [GetMachineTypesResponse](docs/models/GetMachineTypesResponse.md)
 - [GetMaxActiveUsersResponse](docs/models/GetMaxActiveUsersResponse.md)
 - [GetModelEpochLossParams](docs/models/GetModelEpochLossParams.md)
 - [GetModelInsightsParams](docs/models/GetModelInsightsParams.md)
 - [GetModelInsightsResponse](docs/models/GetModelInsightsResponse.md)
 - [GetModelTestResultsRequest](docs/models/GetModelTestResultsRequest.md)
 - [GetModelVisualizationsParams](docs/models/GetModelVisualizationsParams.md)
 - [GetModelVisualizationsResponse](docs/models/GetModelVisualizationsResponse.md)
 - [GetNotificationsResponse](docs/models/GetNotificationsResponse.md)
 - [GetOrganizationJobsParams](docs/models/GetOrganizationJobsParams.md)
 - [GetOrganizationUsersRequest](docs/models/GetOrganizationUsersRequest.md)
 - [GetOrganizationUsersResponse](docs/models/GetOrganizationUsersResponse.md)
 - [GetOrganizationsResponse](docs/models/GetOrganizationsResponse.md)
 - [GetPrCurveParams](docs/models/GetPrCurveParams.md)
 - [GetProjectDashboardsParams](docs/models/GetProjectDashboardsParams.md)
 - [GetProjectDashboardsResponse](docs/models/GetProjectDashboardsResponse.md)
 - [GetProjectIssuesParams](docs/models/GetProjectIssuesParams.md)
 - [GetProjectIssuesResponse](docs/models/GetProjectIssuesResponse.md)
 - [GetProjectSlimVersionsResponse](docs/models/GetProjectSlimVersionsResponse.md)
 - [GetProjectVersionsParams](docs/models/GetProjectVersionsParams.md)
 - [GetProjectsResponse](docs/models/GetProjectsResponse.md)
 - [GetRocParams](docs/models/GetRocParams.md)
 - [GetSecretManagerListResponse](docs/models/GetSecretManagerListResponse.md)
 - [GetSingleIssueParams](docs/models/GetSingleIssueParams.md)
 - [GetSingleModelTestRequest](docs/models/GetSingleModelTestRequest.md)
 - [GetStatisticsResponse](docs/models/GetStatisticsResponse.md)
 - [GetStoredExportedModelResourceUrlParams](docs/models/GetStoredExportedModelResourceUrlParams.md)
 - [GetStoredExportedModelResourceUrlResponse](docs/models/GetStoredExportedModelResourceUrlResponse.md)
 - [GetStoredResourceUrlParams](docs/models/GetStoredResourceUrlParams.md)
 - [GetStoredResourceUrlResponse](docs/models/GetStoredResourceUrlResponse.md)
 - [GetTrainingJobParams](docs/models/GetTrainingJobParams.md)
 - [GetUploadSignedUrlParams](docs/models/GetUploadSignedUrlParams.md)
 - [GetVisualizationParams](docs/models/GetVisualizationParams.md)
 - [GradsAnalysis](docs/models/GradsAnalysis.md)
 - [GradsItem](docs/models/GradsItem.md)
 - [GraphData](docs/models/GraphData.md)
 - [GraphScatterLabel](docs/models/GraphScatterLabel.md)
 - [GraphViz](docs/models/GraphViz.md)
 - [HealthCheckResponse](docs/models/HealthCheckResponse.md)
 - [HealthStatus](docs/models/HealthStatus.md)
 - [Heatmap](docs/models/Heatmap.md)
 - [HeatmapChartsParams](docs/models/HeatmapChartsParams.md)
 - [HeatmapType](docs/models/HeatmapType.md)
 - [HorizontalBarData](docs/models/HorizontalBarData.md)
 - [HorizontalBarScatterLabel](docs/models/HorizontalBarScatterLabel.md)
 - [HorizontalBarViz](docs/models/HorizontalBarViz.md)
 - [HorizontalCharts](docs/models/HorizontalCharts.md)
 - [ImageData](docs/models/ImageData.md)
 - [ImageScatterLabel](docs/models/ImageScatterLabel.md)
 - [ImageViz](docs/models/ImageViz.md)
 - [ImportDemoProjectParams](docs/models/ImportDemoProjectParams.md)
 - [ImportDemoProjectResponse](docs/models/ImportDemoProjectResponse.md)
 - [ImportModelType](docs/models/ImportModelType.md)
 - [ImportNewModelParams](docs/models/ImportNewModelParams.md)
 - [Insight](docs/models/Insight.md)
 - [InsightType](docs/models/InsightType.md)
 - [IsTrainingJobRunningParams](docs/models/IsTrainingJobRunningParams.md)
 - [IsTrainingJobRunningResponse](docs/models/IsTrainingJobRunningResponse.md)
 - [Issue](docs/models/Issue.md)
 - [IssueAction](docs/models/IssueAction.md)
 - [IssueActionType](docs/models/IssueActionType.md)
 - [IssueActivity](docs/models/IssueActivity.md)
 - [IssueStatus](docs/models/IssueStatus.md)
 - [Job](docs/models/Job.md)
 - [JobMessageParams](docs/models/JobMessageParams.md)
 - [JobNotificationBaseContext](docs/models/JobNotificationBaseContext.md)
 - [JobNotificationContext](docs/models/JobNotificationContext.md)
 - [JobNotificationLeepScriptContext](docs/models/JobNotificationLeepScriptContext.md)
 - [JobNotificationModelContext](docs/models/JobNotificationModelContext.md)
 - [JobParams](docs/models/JobParams.md)
 - [JobStatus](docs/models/JobStatus.md)
 - [JobTypeEnum](docs/models/JobTypeEnum.md)
 - [KeyLoginParams](docs/models/KeyLoginParams.md)
 - [Layout](docs/models/Layout.md)
 - [LeapDataType](docs/models/LeapDataType.md)
 - [Line](docs/models/Line.md)
 - [LoadModelParams](docs/models/LoadModelParams.md)
 - [LoadModelResponse](docs/models/LoadModelResponse.md)
 - [LoadVersionParams](docs/models/LoadVersionParams.md)
 - [LoadVersionResponse](docs/models/LoadVersionResponse.md)
 - [LoginParams](docs/models/LoginParams.md)
 - [LossMessageParams](docs/models/LossMessageParams.md)
 - [MachineTypeOption](docs/models/MachineTypeOption.md)
 - [MaskImageData](docs/models/MaskImageData.md)
 - [MaskImageScatterLabel](docs/models/MaskImageScatterLabel.md)
 - [MaskTextData](docs/models/MaskTextData.md)
 - [MessageLevel](docs/models/MessageLevel.md)
 - [Metric](docs/models/Metric.md)
 - [MetricMessageParams](docs/models/MetricMessageParams.md)
 - [Model](docs/models/Model.md)
 - [ModelGraph](docs/models/ModelGraph.md)
 - [ModelHashRequestParams](docs/models/ModelHashRequestParams.md)
 - [ModelPopulatedJob](docs/models/ModelPopulatedJob.md)
 - [ModelSaveData](docs/models/ModelSaveData.md)
 - [ModelSetup](docs/models/ModelSetup.md)
 - [ModelTest](docs/models/ModelTest.md)
 - [ModelTestData](docs/models/ModelTestData.md)
 - [ModelTestResult](docs/models/ModelTestResult.md)
 - [ModelTestResultError](docs/models/ModelTestResultError.md)
 - [ModelTestResultNotFound](docs/models/ModelTestResultNotFound.md)
 - [ModelTestResultSuccess](docs/models/ModelTestResultSuccess.md)
 - [ModelType](docs/models/ModelType.md)
 - [ModelVersionIdRequestParams](docs/models/ModelVersionIdRequestParams.md)
 - [ModelsResponse](docs/models/ModelsResponse.md)
 - [ModifyDatasetVersionNoteParams](docs/models/ModifyDatasetVersionNoteParams.md)
 - [ModifyDatasetVersionNoteResponse](docs/models/ModifyDatasetVersionNoteResponse.md)
 - [Module](docs/models/Module.md)
 - [ModuleMessageData](docs/models/ModuleMessageData.md)
 - [ModuleStatus](docs/models/ModuleStatus.md)
 - [ModuleStatusAllModules](docs/models/ModuleStatusAllModules.md)
 - [MonitoredModuleType](docs/models/MonitoredModuleType.md)
 - [MultiChartsParams](docs/models/MultiChartsParams.md)
 - [MultiChartsResponse](docs/models/MultiChartsResponse.md)
 - [MultiThresholdConfusionMatrixParams](docs/models/MultiThresholdConfusionMatrixParams.md)
 - [NewDatasetParams](docs/models/NewDatasetParams.md)
 - [NodeMessageParams](docs/models/NodeMessageParams.md)
 - [NodeType](docs/models/NodeType.md)
 - [Notification](docs/models/Notification.md)
 - [NumberOrString](docs/models/NumberOrString.md)
 - [OperatorEnum](docs/models/OperatorEnum.md)
 - [OrderType](docs/models/OrderType.md)
 - [OverfittingInsight](docs/models/OverfittingInsight.md)
 - [PanelLayout](docs/models/PanelLayout.md)
 - [ParseDatasetResponse](docs/models/ParseDatasetResponse.md)
 - [PartialRecordTourPageTourStepDefinitionArray](docs/models/PartialRecordTourPageTourStepDefinitionArray.md)
 - [Point](docs/models/Point.md)
 - [PointValueTypes](docs/models/PointValueTypes.md)
 - [PopExploreInfo](docs/models/PopExploreInfo.md)
 - [PopulationExplorationParams](docs/models/PopulationExplorationParams.md)
 - [PredictionTypeInstance](docs/models/PredictionTypeInstance.md)
 - [Project](docs/models/Project.md)
 - [ProjectAccess](docs/models/ProjectAccess.md)
 - [ProjectStatus](docs/models/ProjectStatus.md)
 - [RecentModelsResponse](docs/models/RecentModelsResponse.md)
 - [RecentOrganizationModelsRequestParams](docs/models/RecentOrganizationModelsRequestParams.md)
 - [RequestTrialMetadata](docs/models/RequestTrialMetadata.md)
 - [RequestTrialParams](docs/models/RequestTrialParams.md)
 - [RequestTrialResponse](docs/models/RequestTrialResponse.md)
 - [ResendActivationMailParams](docs/models/ResendActivationMailParams.md)
 - [ResendActivationMailResponse](docs/models/ResendActivationMailResponse.md)
 - [ResetPasswordParams](docs/models/ResetPasswordParams.md)
 - [ResetPasswordResponse](docs/models/ResetPasswordResponse.md)
 - [RotateApiKeyResponse](docs/models/RotateApiKeyResponse.md)
 - [SampleAnalysisParams](docs/models/SampleAnalysisParams.md)
 - [SampleAnalysisViz](docs/models/SampleAnalysisViz.md)
 - [SampleIdentity](docs/models/SampleIdentity.md)
 - [SampleSelectionInfo](docs/models/SampleSelectionInfo.md)
 - [SampleSelectionParams](docs/models/SampleSelectionParams.md)
 - [SampleVisualizationInfo](docs/models/SampleVisualizationInfo.md)
 - [SaveAnalyzerLayoutParams](docs/models/SaveAnalyzerLayoutParams.md)
 - [SaveDatasetSetupResponse](docs/models/SaveDatasetSetupResponse.md)
 - [SaveDatasetVersionParams](docs/models/SaveDatasetVersionParams.md)
 - [ScatterFilter](docs/models/ScatterFilter.md)
 - [ScatterInsightType](docs/models/ScatterInsightType.md)
 - [ScatterLabel](docs/models/ScatterLabel.md)
 - [ScatterViz](docs/models/ScatterViz.md)
 - [ScatterVizDataState](docs/models/ScatterVizDataState.md)
 - [SecretManager](docs/models/SecretManager.md)
 - [SendResetPasswordMailParams](docs/models/SendResetPasswordMailParams.md)
 - [SendResetPasswordMailResponse](docs/models/SendResetPasswordMailResponse.md)
 - [SendUserMessageParams](docs/models/SendUserMessageParams.md)
 - [SendUserMessageResponse](docs/models/SendUserMessageResponse.md)
 - [SetDefaultOrganizationRequest](docs/models/SetDefaultOrganizationRequest.md)
 - [SetOrganizationMachineTypeParams](docs/models/SetOrganizationMachineTypeParams.md)
 - [SetUserMetadataInnerParams](docs/models/SetUserMetadataInnerParams.md)
 - [SetUserMetadataParams](docs/models/SetUserMetadataParams.md)
 - [SetUserMetadataResponse](docs/models/SetUserMetadataResponse.md)
 - [SignupParams](docs/models/SignupParams.md)
 - [SignupResponse](docs/models/SignupResponse.md)
 - [SingleUserModeSettings](docs/models/SingleUserModeSettings.md)
 - [SizedLayout](docs/models/SizedLayout.md)
 - [SlimOrganization](docs/models/SlimOrganization.md)
 - [SlimUserData](docs/models/SlimUserData.md)
 - [SlimUserDataLocal](docs/models/SlimUserDataLocal.md)
 - [SlimVersion](docs/models/SlimVersion.md)
 - [SlimVisualization](docs/models/SlimVisualization.md)
 - [SpaceKibanaDashboard](docs/models/SpaceKibanaDashboard.md)
 - [StartTrialParams](docs/models/StartTrialParams.md)
 - [StopJobParams](docs/models/StopJobParams.md)
 - [StopJobResponse](docs/models/StopJobResponse.md)
 - [TerminateJobParams](docs/models/TerminateJobParams.md)
 - [TerminateJobResponse](docs/models/TerminateJobResponse.md)
 - [TestStatus](docs/models/TestStatus.md)
 - [TextData](docs/models/TextData.md)
 - [TextMaskScatterLabel](docs/models/TextMaskScatterLabel.md)
 - [TextScatterLabel](docs/models/TextScatterLabel.md)
 - [TextViz](docs/models/TextViz.md)
 - [TourStepDefinition](docs/models/TourStepDefinition.md)
 - [TrainFromInitialWeightsParams](docs/models/TrainFromInitialWeightsParams.md)
 - [TrainFromScratchParams](docs/models/TrainFromScratchParams.md)
 - [TrainingParams](docs/models/TrainingParams.md)
 - [TrashDatasetParams](docs/models/TrashDatasetParams.md)
 - [TrashProjectParams](docs/models/TrashProjectParams.md)
 - [TrashSecretManagerParams](docs/models/TrashSecretManagerParams.md)
 - [TrashSecretManagerResponse](docs/models/TrashSecretManagerResponse.md)
 - [UnderRepresentationInsight](docs/models/UnderRepresentationInsight.md)
 - [UpdateDashboardParams](docs/models/UpdateDashboardParams.md)
 - [UpdateIssueParams](docs/models/UpdateIssueParams.md)
 - [UpdateModelTestRequest](docs/models/UpdateModelTestRequest.md)
 - [UpdateOrganizationPublicNameRequest](docs/models/UpdateOrganizationPublicNameRequest.md)
 - [UpdateSecretManagerParams](docs/models/UpdateSecretManagerParams.md)
 - [UpdateSecretManagerResponse](docs/models/UpdateSecretManagerResponse.md)
 - [UpdateUserNameRequest](docs/models/UpdateUserNameRequest.md)
 - [UpdateUserOrganizationRequest](docs/models/UpdateUserOrganizationRequest.md)
 - [UpdateUserRoleRequest](docs/models/UpdateUserRoleRequest.md)
 - [UpdateUserStatusRequest](docs/models/UpdateUserStatusRequest.md)
 - [UpdateVersionParams](docs/models/UpdateVersionParams.md)
 - [UpdateVersionResponse](docs/models/UpdateVersionResponse.md)
 - [UserData](docs/models/UserData.md)
 - [UserDataLocal](docs/models/UserDataLocal.md)
 - [UserDataMetadata](docs/models/UserDataMetadata.md)
 - [UserRole](docs/models/UserRole.md)
 - [Version](docs/models/Version.md)
 - [VerticalCharts](docs/models/VerticalCharts.md)
 - [VisData](docs/models/VisData.md)
 - [Visualization](docs/models/Visualization.md)
 - [VisualizationData](docs/models/VisualizationData.md)
 - [VisualizationItem](docs/models/VisualizationItem.md)
 - [VisualizationResponse](docs/models/VisualizationResponse.md)
 - [VisualizedItem](docs/models/VisualizedItem.md)
 - [VisualizerInstance](docs/models/VisualizerInstance.md)
 - [VisualizerMessageParams](docs/models/VisualizerMessageParams.md)
 - [VizInfoType](docs/models/VizInfoType.md)
 - [VizType](docs/models/VizType.md)
 - [XMetaAxis](docs/models/XMetaAxis.md)
 - [XYChart](docs/models/XYChart.md)
 - [XYChartsMeta](docs/models/XYChartsMeta.md)
 - [XYChartsResponse](docs/models/XYChartsResponse.md)
 - [YMetaAxis](docs/models/YMetaAxis.md)

## Documentation For Authorization

 All endpoints do not require authorization.

## Author



## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in tensorleap_openapi_client.apis and tensorleap_openapi_client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from tensorleap_openapi_client.apis.default_api import DefaultApi`
- `from tensorleap_openapi_client.model.pet import Pet`

Solution 1:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import tensorleap_openapi_client
from tensorleap_openapi_client.apis import *
from tensorleap_openapi_client.models import *
```
