# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.request_options import RequestOptions
from ..core.serialization import convert_and_respect_annotation_metadata
from ..core.unchecked_base_model import construct_type
from ..errors.bad_request_error import BadRequestError
from ..errors.not_found_error import NotFoundError
from ..errors.unauthorized_error import UnauthorizedError
from ..types.activity import Activity
from ..types.activity_fetch_request_end_date import ActivityFetchRequestEndDate
from .types.activity_fetch_request_start_date import ActivityFetchRequestStartDate
from .types.activity_fetch_response import ActivityFetchResponse
from .types.activity_write_response import ActivityWriteResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawActivityClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def fetch(
        self,
        *,
        user_id: str,
        start_date: ActivityFetchRequestStartDate,
        end_date: typing.Optional[ActivityFetchRequestEndDate] = None,
        to_webhook: typing.Optional[bool] = None,
        with_samples: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ActivityFetchResponse]:
        """
        Fetches completed workout sessions, with a defined start and end time and activity type (e.g. running, cycling, etc.)

        Parameters
        ----------
        user_id : str
            Terra user ID (UUID format) to retrieve data for

        start_date : ActivityFetchRequestStartDate
            Start date for data query - either ISO8601 date (YYYY-MM-DD) or unix timestamp in seconds (10-digit)

        end_date : typing.Optional[ActivityFetchRequestEndDate]
            End date for data query - either ISO8601 date (YYYY-MM-DD) or unix timestamp in seconds (10-digit)

        to_webhook : typing.Optional[bool]
            Boolean flag specifying whether to send the data retrieved to the webhook instead of in the response (default: false)

        with_samples : typing.Optional[bool]
            Boolean flag specifying whether to include detailed samples in the returned payload (default: false)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ActivityFetchResponse]
            Returned upon successful data request
        """
        _response = self._client_wrapper.httpx_client.request(
            "activity",
            method="GET",
            params={
                "user_id": user_id,
                "start_date": start_date,
                "end_date": end_date,
                "to_webhook": to_webhook,
                "with_samples": with_samples,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ActivityFetchResponse,
                    construct_type(
                        type_=ActivityFetchResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def write(
        self, *, data: typing.Sequence[Activity], request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ActivityWriteResponse]:
        """
        Used to post activity data to a provider. This endpoint only works for users connected via Wahoo. Returns error for other providers.

        Parameters
        ----------
        data : typing.Sequence[Activity]
            List of user-tracked workouts to post to data provider

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ActivityWriteResponse]
            Returned when activity was successfully created on the provider
        """
        _response = self._client_wrapper.httpx_client.request(
            "activity",
            method="POST",
            json={
                "data": convert_and_respect_annotation_metadata(
                    object_=data, annotation=typing.Sequence[Activity], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ActivityWriteResponse,
                    construct_type(
                        type_=ActivityWriteResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawActivityClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def fetch(
        self,
        *,
        user_id: str,
        start_date: ActivityFetchRequestStartDate,
        end_date: typing.Optional[ActivityFetchRequestEndDate] = None,
        to_webhook: typing.Optional[bool] = None,
        with_samples: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ActivityFetchResponse]:
        """
        Fetches completed workout sessions, with a defined start and end time and activity type (e.g. running, cycling, etc.)

        Parameters
        ----------
        user_id : str
            Terra user ID (UUID format) to retrieve data for

        start_date : ActivityFetchRequestStartDate
            Start date for data query - either ISO8601 date (YYYY-MM-DD) or unix timestamp in seconds (10-digit)

        end_date : typing.Optional[ActivityFetchRequestEndDate]
            End date for data query - either ISO8601 date (YYYY-MM-DD) or unix timestamp in seconds (10-digit)

        to_webhook : typing.Optional[bool]
            Boolean flag specifying whether to send the data retrieved to the webhook instead of in the response (default: false)

        with_samples : typing.Optional[bool]
            Boolean flag specifying whether to include detailed samples in the returned payload (default: false)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ActivityFetchResponse]
            Returned upon successful data request
        """
        _response = await self._client_wrapper.httpx_client.request(
            "activity",
            method="GET",
            params={
                "user_id": user_id,
                "start_date": start_date,
                "end_date": end_date,
                "to_webhook": to_webhook,
                "with_samples": with_samples,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ActivityFetchResponse,
                    construct_type(
                        type_=ActivityFetchResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def write(
        self, *, data: typing.Sequence[Activity], request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ActivityWriteResponse]:
        """
        Used to post activity data to a provider. This endpoint only works for users connected via Wahoo. Returns error for other providers.

        Parameters
        ----------
        data : typing.Sequence[Activity]
            List of user-tracked workouts to post to data provider

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ActivityWriteResponse]
            Returned when activity was successfully created on the provider
        """
        _response = await self._client_wrapper.httpx_client.request(
            "activity",
            method="POST",
            json={
                "data": convert_and_respect_annotation_metadata(
                    object_=data, annotation=typing.Sequence[Activity], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ActivityWriteResponse,
                    construct_type(
                        type_=ActivityWriteResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
