# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import httpx
from .core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .environment import TerraEnvironment

if typing.TYPE_CHECKING:
    from .activity.client import ActivityClient, AsyncActivityClient
    from .athlete.client import AsyncAthleteClient, AthleteClient
    from .authentication.client import AsyncAuthenticationClient, AuthenticationClient
    from .body.client import AsyncBodyClient, BodyClient
    from .daily.client import AsyncDailyClient, DailyClient
    from .integrations.client import AsyncIntegrationsClient, IntegrationsClient
    from .menstruation.client import AsyncMenstruationClient, MenstruationClient
    from .nutrition.client import AsyncNutritionClient, NutritionClient
    from .plannedworkout.client import AsyncPlannedworkoutClient, PlannedworkoutClient
    from .sleep.client import AsyncSleepClient, SleepClient
    from .user.client import AsyncUserClient, UserClient


class Terra:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : TerraEnvironment
        The environment to use for requests from the client. from .environment import TerraEnvironment



        Defaults to TerraEnvironment.DEFAULT



    dev_id : str
    api_key : str
    headers : typing.Optional[typing.Dict[str, str]]
        Additional headers to send with every request.

    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.Client]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from terra import Terra

    client = Terra(
        dev_id="YOUR_DEV_ID",
        api_key="YOUR_API_KEY",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: TerraEnvironment = TerraEnvironment.DEFAULT,
        dev_id: str,
        api_key: str,
        headers: typing.Optional[typing.Dict[str, str]] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.Client] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        self._client_wrapper = SyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            dev_id=dev_id,
            api_key=api_key,
            headers=headers,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.Client(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.Client(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self._authentication: typing.Optional[AuthenticationClient] = None
        self._user: typing.Optional[UserClient] = None
        self._activity: typing.Optional[ActivityClient] = None
        self._athlete: typing.Optional[AthleteClient] = None
        self._body: typing.Optional[BodyClient] = None
        self._daily: typing.Optional[DailyClient] = None
        self._menstruation: typing.Optional[MenstruationClient] = None
        self._nutrition: typing.Optional[NutritionClient] = None
        self._sleep: typing.Optional[SleepClient] = None
        self._plannedworkout: typing.Optional[PlannedworkoutClient] = None
        self._integrations: typing.Optional[IntegrationsClient] = None

    @property
    def authentication(self):
        if self._authentication is None:
            from .authentication.client import AuthenticationClient  # noqa: E402

            self._authentication = AuthenticationClient(client_wrapper=self._client_wrapper)
        return self._authentication

    @property
    def user(self):
        if self._user is None:
            from .user.client import UserClient  # noqa: E402

            self._user = UserClient(client_wrapper=self._client_wrapper)
        return self._user

    @property
    def activity(self):
        if self._activity is None:
            from .activity.client import ActivityClient  # noqa: E402

            self._activity = ActivityClient(client_wrapper=self._client_wrapper)
        return self._activity

    @property
    def athlete(self):
        if self._athlete is None:
            from .athlete.client import AthleteClient  # noqa: E402

            self._athlete = AthleteClient(client_wrapper=self._client_wrapper)
        return self._athlete

    @property
    def body(self):
        if self._body is None:
            from .body.client import BodyClient  # noqa: E402

            self._body = BodyClient(client_wrapper=self._client_wrapper)
        return self._body

    @property
    def daily(self):
        if self._daily is None:
            from .daily.client import DailyClient  # noqa: E402

            self._daily = DailyClient(client_wrapper=self._client_wrapper)
        return self._daily

    @property
    def menstruation(self):
        if self._menstruation is None:
            from .menstruation.client import MenstruationClient  # noqa: E402

            self._menstruation = MenstruationClient(client_wrapper=self._client_wrapper)
        return self._menstruation

    @property
    def nutrition(self):
        if self._nutrition is None:
            from .nutrition.client import NutritionClient  # noqa: E402

            self._nutrition = NutritionClient(client_wrapper=self._client_wrapper)
        return self._nutrition

    @property
    def sleep(self):
        if self._sleep is None:
            from .sleep.client import SleepClient  # noqa: E402

            self._sleep = SleepClient(client_wrapper=self._client_wrapper)
        return self._sleep

    @property
    def plannedworkout(self):
        if self._plannedworkout is None:
            from .plannedworkout.client import PlannedworkoutClient  # noqa: E402

            self._plannedworkout = PlannedworkoutClient(client_wrapper=self._client_wrapper)
        return self._plannedworkout

    @property
    def integrations(self):
        if self._integrations is None:
            from .integrations.client import IntegrationsClient  # noqa: E402

            self._integrations = IntegrationsClient(client_wrapper=self._client_wrapper)
        return self._integrations


class AsyncTerra:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : TerraEnvironment
        The environment to use for requests from the client. from .environment import TerraEnvironment



        Defaults to TerraEnvironment.DEFAULT



    dev_id : str
    api_key : str
    headers : typing.Optional[typing.Dict[str, str]]
        Additional headers to send with every request.

    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.AsyncClient]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from terra import AsyncTerra

    client = AsyncTerra(
        dev_id="YOUR_DEV_ID",
        api_key="YOUR_API_KEY",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: TerraEnvironment = TerraEnvironment.DEFAULT,
        dev_id: str,
        api_key: str,
        headers: typing.Optional[typing.Dict[str, str]] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.AsyncClient] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        self._client_wrapper = AsyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            dev_id=dev_id,
            api_key=api_key,
            headers=headers,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self._authentication: typing.Optional[AsyncAuthenticationClient] = None
        self._user: typing.Optional[AsyncUserClient] = None
        self._activity: typing.Optional[AsyncActivityClient] = None
        self._athlete: typing.Optional[AsyncAthleteClient] = None
        self._body: typing.Optional[AsyncBodyClient] = None
        self._daily: typing.Optional[AsyncDailyClient] = None
        self._menstruation: typing.Optional[AsyncMenstruationClient] = None
        self._nutrition: typing.Optional[AsyncNutritionClient] = None
        self._sleep: typing.Optional[AsyncSleepClient] = None
        self._plannedworkout: typing.Optional[AsyncPlannedworkoutClient] = None
        self._integrations: typing.Optional[AsyncIntegrationsClient] = None

    @property
    def authentication(self):
        if self._authentication is None:
            from .authentication.client import AsyncAuthenticationClient  # noqa: E402

            self._authentication = AsyncAuthenticationClient(client_wrapper=self._client_wrapper)
        return self._authentication

    @property
    def user(self):
        if self._user is None:
            from .user.client import AsyncUserClient  # noqa: E402

            self._user = AsyncUserClient(client_wrapper=self._client_wrapper)
        return self._user

    @property
    def activity(self):
        if self._activity is None:
            from .activity.client import AsyncActivityClient  # noqa: E402

            self._activity = AsyncActivityClient(client_wrapper=self._client_wrapper)
        return self._activity

    @property
    def athlete(self):
        if self._athlete is None:
            from .athlete.client import AsyncAthleteClient  # noqa: E402

            self._athlete = AsyncAthleteClient(client_wrapper=self._client_wrapper)
        return self._athlete

    @property
    def body(self):
        if self._body is None:
            from .body.client import AsyncBodyClient  # noqa: E402

            self._body = AsyncBodyClient(client_wrapper=self._client_wrapper)
        return self._body

    @property
    def daily(self):
        if self._daily is None:
            from .daily.client import AsyncDailyClient  # noqa: E402

            self._daily = AsyncDailyClient(client_wrapper=self._client_wrapper)
        return self._daily

    @property
    def menstruation(self):
        if self._menstruation is None:
            from .menstruation.client import AsyncMenstruationClient  # noqa: E402

            self._menstruation = AsyncMenstruationClient(client_wrapper=self._client_wrapper)
        return self._menstruation

    @property
    def nutrition(self):
        if self._nutrition is None:
            from .nutrition.client import AsyncNutritionClient  # noqa: E402

            self._nutrition = AsyncNutritionClient(client_wrapper=self._client_wrapper)
        return self._nutrition

    @property
    def sleep(self):
        if self._sleep is None:
            from .sleep.client import AsyncSleepClient  # noqa: E402

            self._sleep = AsyncSleepClient(client_wrapper=self._client_wrapper)
        return self._sleep

    @property
    def plannedworkout(self):
        if self._plannedworkout is None:
            from .plannedworkout.client import AsyncPlannedworkoutClient  # noqa: E402

            self._plannedworkout = AsyncPlannedworkoutClient(client_wrapper=self._client_wrapper)
        return self._plannedworkout

    @property
    def integrations(self):
        if self._integrations is None:
            from .integrations.client import AsyncIntegrationsClient  # noqa: E402

            self._integrations = AsyncIntegrationsClient(client_wrapper=self._client_wrapper)
        return self._integrations


def _get_base_url(*, base_url: typing.Optional[str] = None, environment: TerraEnvironment) -> str:
    if base_url is not None:
        return base_url
    elif environment is not None:
        return environment.value
    else:
        raise Exception("Please pass in either base_url or environment to construct the client")
