# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.request_options import RequestOptions
from ..core.serialization import convert_and_respect_annotation_metadata
from ..core.unchecked_base_model import construct_type
from ..errors.bad_request_error import BadRequestError
from ..errors.not_found_error import NotFoundError
from ..errors.unauthorized_error import UnauthorizedError
from ..types.planned_workout import PlannedWorkout
from ..types.planned_workout_fetch_request_end_date import PlannedWorkoutFetchRequestEndDate
from .types.planned_workout_delete_response import PlannedWorkoutDeleteResponse
from .types.planned_workout_fetch_request_start_date import PlannedWorkoutFetchRequestStartDate
from .types.planned_workout_fetch_response import PlannedWorkoutFetchResponse
from .types.planned_workout_write_response import PlannedWorkoutWriteResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawPlannedworkoutClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def fetch(
        self,
        *,
        user_id: str,
        start_date: PlannedWorkoutFetchRequestStartDate,
        end_date: typing.Optional[PlannedWorkoutFetchRequestEndDate] = None,
        to_webhook: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PlannedWorkoutFetchResponse]:
        """
        Used to get workout plans the user has registered on their account. This can be strength workouts (sets, reps, weight lifted) or cardio workouts (warmup, intervals of different intensities, cooldown etc)

        Parameters
        ----------
        user_id : str
            Terra user ID (UUID format) to retrieve data for

        start_date : PlannedWorkoutFetchRequestStartDate
            Start date for data query - either ISO8601 date (YYYY-MM-DD) or unix timestamp in seconds (10-digit)

        end_date : typing.Optional[PlannedWorkoutFetchRequestEndDate]
            End date for data query - either ISO8601 date (YYYY-MM-DD) or unix timestamp in seconds (10-digit)

        to_webhook : typing.Optional[bool]
            Boolean flag specifying whether to send the data retrieved to the webhook instead of in the response (default: false)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PlannedWorkoutFetchResponse]
            Returned upon successful data request
        """
        _response = self._client_wrapper.httpx_client.request(
            "plannedWorkout",
            method="GET",
            params={
                "user_id": user_id,
                "start_date": start_date,
                "end_date": end_date,
                "to_webhook": to_webhook,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PlannedWorkoutFetchResponse,
                    construct_type(
                        type_=PlannedWorkoutFetchResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def write(
        self, *, data: typing.Sequence[PlannedWorkout], request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[PlannedWorkoutWriteResponse]:
        """
        Used to post workout plans users can follow on their wearable. This can be strength workouts (sets, reps, weight lifted) or cardio workouts (warmup, intervals of different intensities, cooldown etc)

        Parameters
        ----------
        data : typing.Sequence[PlannedWorkout]
            PlannedWorkout entry to post to data provider

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PlannedWorkoutWriteResponse]
            Returned when activity was successfully created on the provider
        """
        _response = self._client_wrapper.httpx_client.request(
            "plannedWorkout",
            method="POST",
            json={
                "data": convert_and_respect_annotation_metadata(
                    object_=data, annotation=typing.Sequence[PlannedWorkout], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PlannedWorkoutWriteResponse,
                    construct_type(
                        type_=PlannedWorkoutWriteResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete(
        self,
        *,
        user_id: str,
        data: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PlannedWorkoutDeleteResponse]:
        """
        Used to delete workout plans the user has registered on their account. This can be strength workouts (sets, reps, weight lifted) or cardio workouts (warmup, intervals of different intensities, cooldown etc)

        Parameters
        ----------
        user_id : str
            Terra user ID (UUID format) to retrieve data for

        data : typing.Optional[typing.Sequence[str]]
            List of identifiers for planned workout entries to be deleted

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PlannedWorkoutDeleteResponse]
            Returned when all records were deleted successfully
        """
        _response = self._client_wrapper.httpx_client.request(
            "plannedWorkout",
            method="DELETE",
            params={
                "user_id": user_id,
            },
            json={
                "data": data,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PlannedWorkoutDeleteResponse,
                    construct_type(
                        type_=PlannedWorkoutDeleteResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawPlannedworkoutClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def fetch(
        self,
        *,
        user_id: str,
        start_date: PlannedWorkoutFetchRequestStartDate,
        end_date: typing.Optional[PlannedWorkoutFetchRequestEndDate] = None,
        to_webhook: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PlannedWorkoutFetchResponse]:
        """
        Used to get workout plans the user has registered on their account. This can be strength workouts (sets, reps, weight lifted) or cardio workouts (warmup, intervals of different intensities, cooldown etc)

        Parameters
        ----------
        user_id : str
            Terra user ID (UUID format) to retrieve data for

        start_date : PlannedWorkoutFetchRequestStartDate
            Start date for data query - either ISO8601 date (YYYY-MM-DD) or unix timestamp in seconds (10-digit)

        end_date : typing.Optional[PlannedWorkoutFetchRequestEndDate]
            End date for data query - either ISO8601 date (YYYY-MM-DD) or unix timestamp in seconds (10-digit)

        to_webhook : typing.Optional[bool]
            Boolean flag specifying whether to send the data retrieved to the webhook instead of in the response (default: false)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PlannedWorkoutFetchResponse]
            Returned upon successful data request
        """
        _response = await self._client_wrapper.httpx_client.request(
            "plannedWorkout",
            method="GET",
            params={
                "user_id": user_id,
                "start_date": start_date,
                "end_date": end_date,
                "to_webhook": to_webhook,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PlannedWorkoutFetchResponse,
                    construct_type(
                        type_=PlannedWorkoutFetchResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def write(
        self, *, data: typing.Sequence[PlannedWorkout], request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[PlannedWorkoutWriteResponse]:
        """
        Used to post workout plans users can follow on their wearable. This can be strength workouts (sets, reps, weight lifted) or cardio workouts (warmup, intervals of different intensities, cooldown etc)

        Parameters
        ----------
        data : typing.Sequence[PlannedWorkout]
            PlannedWorkout entry to post to data provider

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PlannedWorkoutWriteResponse]
            Returned when activity was successfully created on the provider
        """
        _response = await self._client_wrapper.httpx_client.request(
            "plannedWorkout",
            method="POST",
            json={
                "data": convert_and_respect_annotation_metadata(
                    object_=data, annotation=typing.Sequence[PlannedWorkout], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PlannedWorkoutWriteResponse,
                    construct_type(
                        type_=PlannedWorkoutWriteResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete(
        self,
        *,
        user_id: str,
        data: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PlannedWorkoutDeleteResponse]:
        """
        Used to delete workout plans the user has registered on their account. This can be strength workouts (sets, reps, weight lifted) or cardio workouts (warmup, intervals of different intensities, cooldown etc)

        Parameters
        ----------
        user_id : str
            Terra user ID (UUID format) to retrieve data for

        data : typing.Optional[typing.Sequence[str]]
            List of identifiers for planned workout entries to be deleted

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PlannedWorkoutDeleteResponse]
            Returned when all records were deleted successfully
        """
        _response = await self._client_wrapper.httpx_client.request(
            "plannedWorkout",
            method="DELETE",
            params={
                "user_id": user_id,
            },
            json={
                "data": data,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PlannedWorkoutDeleteResponse,
                    construct_type(
                        type_=PlannedWorkoutDeleteResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
