# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .breath_sample import BreathSample


class BreathsData(UncheckedBaseModel):
    avg_breaths_per_min: typing.Optional[float] = pydantic.Field(default=None)
    """
    Average breathing rate of the user during the sleep session.
    """

    max_breaths_per_min: typing.Optional[float] = pydantic.Field(default=None)
    """
    Maximum breathing rate of the user during the sleep session.
    """

    min_breaths_per_min: typing.Optional[float] = pydantic.Field(default=None)
    """
    Minimum breathing rate of the user during the sleep session.
    """

    on_demand_reading: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Flag indicating if the reading was performed on demand, or if it was automatically captured by the device.
    """

    samples: typing.Optional[typing.List[BreathSample]] = pydantic.Field(default=None)
    """
    List of breathing rate information sampled throughout the sleep session.
    """

    start_time: typing.Optional[str] = pydantic.Field(default=None)
    """
    The start time of the recording of breathing rate data, in ISO8601 format with microsecond precision. Will always fall on midnight of any given day, and will always be equal to 24h before end_time. TimeZone info will be provided whenever possible. If absent, the time corresponds to the user's local time.
    """

    end_time: typing.Optional[str] = pydantic.Field(default=None)
    """
    The end time of the recording of breathing rate data, in ISO8601 format with microsecond precision. TimeZone info will be provided whenever possible. If absent, the time corresponds to the user's local time.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
