# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .menstrual_phase import MenstrualPhase
from .menstruation_flow_sample import MenstruationFlowSample


class MenstruationData(UncheckedBaseModel):
    period_length_days: typing.Optional[int] = pydantic.Field(default=None)
    """
    Total length of period (i.e. menstrual bleeding).
    """

    current_phase: typing.Optional[MenstrualPhase] = pydantic.Field(default=None)
    """
    Phase in associated cycle, (i.e. menstruation, fertile etc).
    """

    length_of_current_phase_days: typing.Optional[int] = pydantic.Field(default=None)
    """
    Length of current phase.
    """

    days_until_next_phase: typing.Optional[int] = pydantic.Field(default=None)
    """
    Number of days to reach the next phase (predicted).
    """

    period_start_date: typing.Optional[str] = pydantic.Field(default=None)
    """
    Start date of menstrual cycle, in ISO8601 format.
    """

    predicted_cycle_length_days: typing.Optional[int] = pydantic.Field(default=None)
    """
    Prediction of the cycle's total length.
    """

    day_in_cycle: typing.Optional[int] = pydantic.Field(default=None)
    """
    Number of day in cycle this object is associated with.
    """

    last_updated_time: typing.Optional[str] = pydantic.Field(default=None)
    """
    Last time when the user recorded information regarding their cycle, in ISO8601 format, with microseconds precision.
    """

    cycle_length_days: typing.Optional[str] = pydantic.Field(default=None)
    """
    Total cycle length.
    """

    is_predicted_cycle: typing.Optional[str] = pydantic.Field(default=None)
    """
    Flag indicating whether associated object is a prediction or user-logged information.
    """

    menstruation_flow: typing.Optional[typing.List[MenstruationFlowSample]] = pydantic.Field(default=None)
    """
    List of user logs of information related to the strength of user's menstrual flow.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
