# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .power_planned_workout_step_target_target_type import PowerPlannedWorkoutStepTargetTargetType


class PowerPlannedWorkoutStepTarget(UncheckedBaseModel):
    target_type: typing.Optional[PowerPlannedWorkoutStepTargetTargetType] = pydantic.Field(default=None)
    """
    Type of target for the workout - i.e. metric type for which a criterion must be met for the workout to be completed
    """

    power_percentage_low: typing.Optional[float] = pydantic.Field(default=None)
    """
    Maximum percentage of Functional Threshold Power for the workout step - i.e. the user is to stay under this value during the workout step
    """

    power_percentage_high: typing.Optional[float] = pydantic.Field(default=None)
    """
    Minimum percentage of Functional Threshold Power for the workout step - i.e. the user is to stay above this value during the workout
    """

    power_watt_high: typing.Optional[int] = pydantic.Field(default=None)
    """
    Maximum power threshold for the workout step - i.e. the user is to stay under this value during the workout step
    """

    power_watt_low: typing.Optional[int] = pydantic.Field(default=None)
    """
    Minimum power threshold for the workout step - i.e. the user is to stay above this value during the workout
    """

    power_watt: typing.Optional[int] = None
    power_percentage: typing.Optional[float] = pydantic.Field(default=None)
    """
    Ideal percentage of user's Functional Threshold Power to be maintained workout step
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
