# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawAuthenticationClient, RawAuthenticationClient
from .types.authentication_authenticate_user_response import AuthenticationAuthenticateUserResponse
from .types.authentication_deauthenticate_user_response import AuthenticationDeauthenticateUserResponse
from .types.authentication_generate_auth_token_response import AuthenticationGenerateAuthTokenResponse
from .types.authentication_generate_widget_session_response import AuthenticationGenerateWidgetSessionResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class AuthenticationClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAuthenticationClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAuthenticationClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAuthenticationClient
        """
        return self._raw_client

    def authenticateuser(
        self,
        *,
        resource: str,
        language: typing.Optional[str] = OMIT,
        reference_id: typing.Optional[str] = OMIT,
        auth_success_redirect_url: typing.Optional[str] = OMIT,
        auth_failure_redirect_url: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AuthenticationAuthenticateUserResponse:
        """
        Creates a login link that allows end users to connect their fitness tracking account

        Parameters
        ----------
        resource : str
            resource to authenticate user with

        language : typing.Optional[str]

        reference_id : typing.Optional[str]

        auth_success_redirect_url : typing.Optional[str]

        auth_failure_redirect_url : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AuthenticationAuthenticateUserResponse
            Returned when authentication link could be successfully generated

        Examples
        --------
        from terra import Terra

        client = Terra(
            dev_id="YOUR_DEV_ID",
            api_key="YOUR_API_KEY",
        )
        client.authentication.authenticateuser(
            resource="resource",
        )
        """
        _response = self._raw_client.authenticateuser(
            resource=resource,
            language=language,
            reference_id=reference_id,
            auth_success_redirect_url=auth_success_redirect_url,
            auth_failure_redirect_url=auth_failure_redirect_url,
            request_options=request_options,
        )
        return _response.data

    def generatewidgetsession(
        self,
        *,
        providers: typing.Optional[str] = OMIT,
        language: typing.Optional[str] = OMIT,
        reference_id: typing.Optional[str] = OMIT,
        auth_success_redirect_url: typing.Optional[str] = OMIT,
        auth_failure_redirect_url: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AuthenticationGenerateWidgetSessionResponse:
        """
        Generates a link to redirect an end user to for them to select an integration and log in with their fitness data provider

        Parameters
        ----------
        providers : typing.Optional[str]
            Comma separated list of providers to display on the device selection page. This overrides your selected sources on your dashboard

        language : typing.Optional[str]
            Display language of the widget

        reference_id : typing.Optional[str]
            Identifier of the end user on your system, such as a user ID or email associated with them

        auth_success_redirect_url : typing.Optional[str]
            URL the user is redirected to upon successful authentication

        auth_failure_redirect_url : typing.Optional[str]
            URL the user is redirected to upon unsuccessful authentication

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AuthenticationGenerateWidgetSessionResponse
            Returned when authentication link could be successfully generated

        Examples
        --------
        from terra import Terra

        client = Terra(
            dev_id="YOUR_DEV_ID",
            api_key="YOUR_API_KEY",
        )
        client.authentication.generatewidgetsession()
        """
        _response = self._raw_client.generatewidgetsession(
            providers=providers,
            language=language,
            reference_id=reference_id,
            auth_success_redirect_url=auth_success_redirect_url,
            auth_failure_redirect_url=auth_failure_redirect_url,
            request_options=request_options,
        )
        return _response.data

    def deauthenticateuser(
        self, *, user_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AuthenticationDeauthenticateUserResponse:
        """
        Deletes all records of the user on Terra's end, revoking Terra's access to their data

        Parameters
        ----------
        user_id : str
            user_id to deauthenticate for

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AuthenticationDeauthenticateUserResponse
            Returned when authentication link could be successfully generated

        Examples
        --------
        from terra import Terra

        client = Terra(
            dev_id="YOUR_DEV_ID",
            api_key="YOUR_API_KEY",
        )
        client.authentication.deauthenticateuser(
            user_id="user_id",
        )
        """
        _response = self._raw_client.deauthenticateuser(user_id=user_id, request_options=request_options)
        return _response.data

    def generateauthtoken(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AuthenticationGenerateAuthTokenResponse:
        """
        Creates a token to be used with initConnection() functions in the Terra mobile SDKs in order to create a user record for Apple Health or Samsung Health (or equivalent)

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AuthenticationGenerateAuthTokenResponse
            200

        Examples
        --------
        from terra import Terra

        client = Terra(
            dev_id="YOUR_DEV_ID",
            api_key="YOUR_API_KEY",
        )
        client.authentication.generateauthtoken()
        """
        _response = self._raw_client.generateauthtoken(request_options=request_options)
        return _response.data


class AsyncAuthenticationClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAuthenticationClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAuthenticationClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAuthenticationClient
        """
        return self._raw_client

    async def authenticateuser(
        self,
        *,
        resource: str,
        language: typing.Optional[str] = OMIT,
        reference_id: typing.Optional[str] = OMIT,
        auth_success_redirect_url: typing.Optional[str] = OMIT,
        auth_failure_redirect_url: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AuthenticationAuthenticateUserResponse:
        """
        Creates a login link that allows end users to connect their fitness tracking account

        Parameters
        ----------
        resource : str
            resource to authenticate user with

        language : typing.Optional[str]

        reference_id : typing.Optional[str]

        auth_success_redirect_url : typing.Optional[str]

        auth_failure_redirect_url : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AuthenticationAuthenticateUserResponse
            Returned when authentication link could be successfully generated

        Examples
        --------
        import asyncio

        from terra import AsyncTerra

        client = AsyncTerra(
            dev_id="YOUR_DEV_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.authentication.authenticateuser(
                resource="resource",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.authenticateuser(
            resource=resource,
            language=language,
            reference_id=reference_id,
            auth_success_redirect_url=auth_success_redirect_url,
            auth_failure_redirect_url=auth_failure_redirect_url,
            request_options=request_options,
        )
        return _response.data

    async def generatewidgetsession(
        self,
        *,
        providers: typing.Optional[str] = OMIT,
        language: typing.Optional[str] = OMIT,
        reference_id: typing.Optional[str] = OMIT,
        auth_success_redirect_url: typing.Optional[str] = OMIT,
        auth_failure_redirect_url: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AuthenticationGenerateWidgetSessionResponse:
        """
        Generates a link to redirect an end user to for them to select an integration and log in with their fitness data provider

        Parameters
        ----------
        providers : typing.Optional[str]
            Comma separated list of providers to display on the device selection page. This overrides your selected sources on your dashboard

        language : typing.Optional[str]
            Display language of the widget

        reference_id : typing.Optional[str]
            Identifier of the end user on your system, such as a user ID or email associated with them

        auth_success_redirect_url : typing.Optional[str]
            URL the user is redirected to upon successful authentication

        auth_failure_redirect_url : typing.Optional[str]
            URL the user is redirected to upon unsuccessful authentication

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AuthenticationGenerateWidgetSessionResponse
            Returned when authentication link could be successfully generated

        Examples
        --------
        import asyncio

        from terra import AsyncTerra

        client = AsyncTerra(
            dev_id="YOUR_DEV_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.authentication.generatewidgetsession()


        asyncio.run(main())
        """
        _response = await self._raw_client.generatewidgetsession(
            providers=providers,
            language=language,
            reference_id=reference_id,
            auth_success_redirect_url=auth_success_redirect_url,
            auth_failure_redirect_url=auth_failure_redirect_url,
            request_options=request_options,
        )
        return _response.data

    async def deauthenticateuser(
        self, *, user_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AuthenticationDeauthenticateUserResponse:
        """
        Deletes all records of the user on Terra's end, revoking Terra's access to their data

        Parameters
        ----------
        user_id : str
            user_id to deauthenticate for

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AuthenticationDeauthenticateUserResponse
            Returned when authentication link could be successfully generated

        Examples
        --------
        import asyncio

        from terra import AsyncTerra

        client = AsyncTerra(
            dev_id="YOUR_DEV_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.authentication.deauthenticateuser(
                user_id="user_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.deauthenticateuser(user_id=user_id, request_options=request_options)
        return _response.data

    async def generateauthtoken(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AuthenticationGenerateAuthTokenResponse:
        """
        Creates a token to be used with initConnection() functions in the Terra mobile SDKs in order to create a user record for Apple Health or Samsung Health (or equivalent)

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AuthenticationGenerateAuthTokenResponse
            200

        Examples
        --------
        import asyncio

        from terra import AsyncTerra

        client = AsyncTerra(
            dev_id="YOUR_DEV_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.authentication.generateauthtoken()


        asyncio.run(main())
        """
        _response = await self._raw_client.generateauthtoken(request_options=request_options)
        return _response.data
