# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.body import Body
from .raw_client import AsyncRawBodyClient, RawBodyClient
from .types.body_delete_response import BodyDeleteResponse
from .types.body_fetch_request_start_date import BodyFetchRequestStartDate
from .types.body_fetch_response import BodyFetchResponse
from .types.body_write_response import BodyWriteResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class BodyClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawBodyClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawBodyClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawBodyClient
        """
        return self._raw_client

    def fetch(
        self,
        *,
        user_id: str,
        start_date: BodyFetchRequestStartDate,
        end_date: typing.Optional[int] = None,
        to_webhook: typing.Optional[bool] = None,
        with_samples: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> BodyFetchResponse:
        """
        Fetches body metrics such as weight, height, body fat percentage etc. for a given user ID

        Parameters
        ----------
        user_id : str
            user ID to query data for

        start_date : BodyFetchRequestStartDate
            start date of data to query for - either ISO8601 date or unix timestamp

        end_date : typing.Optional[int]
            end date of data to query for - either ISO8601 date or unix timestamp

        to_webhook : typing.Optional[bool]
            boolean flag specifying whether to send the data retrieved to the webhook, or in the response

        with_samples : typing.Optional[bool]
            boolean flag specifying whether to include detailed samples in the returned payload

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BodyFetchResponse
            Returned upon successful data request

        Examples
        --------
        from terra import Terra

        client = Terra(
            dev_id="YOUR_DEV_ID",
            api_key="YOUR_API_KEY",
        )
        client.body.fetch(
            user_id="user_id",
            start_date=1,
        )
        """
        _response = self._raw_client.fetch(
            user_id=user_id,
            start_date=start_date,
            end_date=end_date,
            to_webhook=to_webhook,
            with_samples=with_samples,
            request_options=request_options,
        )
        return _response.data

    def write(
        self, *, data: typing.Sequence[Body], request_options: typing.Optional[RequestOptions] = None
    ) -> BodyWriteResponse:
        """
        Used to post body data to a provider. Available for Google Fit

        Parameters
        ----------
        data : typing.Sequence[Body]
            Body measurement metrics to post to data provider

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BodyWriteResponse
            Returned when activity was successfully created on the provider

        Examples
        --------
        from terra import Body, BodyMetadata, Terra

        client = Terra(
            dev_id="YOUR_DEV_ID",
            api_key="YOUR_API_KEY",
        )
        client.body.write(
            data=[
                Body(
                    metadata=BodyMetadata(
                        end_time="2022-10-28T10:00:00.000000+01:00",
                        start_time="1999-11-23T09:00:00.000000+02:00",
                    ),
                )
            ],
        )
        """
        _response = self._raw_client.write(data=data, request_options=request_options)
        return _response.data

    def delete(
        self,
        *,
        user_id: str,
        log_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> BodyDeleteResponse:
        """
        Used to delete Body metrics the user has registered on their account

        Parameters
        ----------
        user_id : str
            user ID to query data for

        log_ids : typing.Optional[typing.Sequence[str]]
            List of identifiers for body metrics entries to be deleted

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BodyDeleteResponse
            Returned when all records were deleted successfully

        Examples
        --------
        from terra import Terra

        client = Terra(
            dev_id="YOUR_DEV_ID",
            api_key="YOUR_API_KEY",
        )
        client.body.delete(
            user_id="user_id",
        )
        """
        _response = self._raw_client.delete(user_id=user_id, log_ids=log_ids, request_options=request_options)
        return _response.data


class AsyncBodyClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawBodyClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawBodyClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawBodyClient
        """
        return self._raw_client

    async def fetch(
        self,
        *,
        user_id: str,
        start_date: BodyFetchRequestStartDate,
        end_date: typing.Optional[int] = None,
        to_webhook: typing.Optional[bool] = None,
        with_samples: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> BodyFetchResponse:
        """
        Fetches body metrics such as weight, height, body fat percentage etc. for a given user ID

        Parameters
        ----------
        user_id : str
            user ID to query data for

        start_date : BodyFetchRequestStartDate
            start date of data to query for - either ISO8601 date or unix timestamp

        end_date : typing.Optional[int]
            end date of data to query for - either ISO8601 date or unix timestamp

        to_webhook : typing.Optional[bool]
            boolean flag specifying whether to send the data retrieved to the webhook, or in the response

        with_samples : typing.Optional[bool]
            boolean flag specifying whether to include detailed samples in the returned payload

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BodyFetchResponse
            Returned upon successful data request

        Examples
        --------
        import asyncio

        from terra import AsyncTerra

        client = AsyncTerra(
            dev_id="YOUR_DEV_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.body.fetch(
                user_id="user_id",
                start_date=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.fetch(
            user_id=user_id,
            start_date=start_date,
            end_date=end_date,
            to_webhook=to_webhook,
            with_samples=with_samples,
            request_options=request_options,
        )
        return _response.data

    async def write(
        self, *, data: typing.Sequence[Body], request_options: typing.Optional[RequestOptions] = None
    ) -> BodyWriteResponse:
        """
        Used to post body data to a provider. Available for Google Fit

        Parameters
        ----------
        data : typing.Sequence[Body]
            Body measurement metrics to post to data provider

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BodyWriteResponse
            Returned when activity was successfully created on the provider

        Examples
        --------
        import asyncio

        from terra import AsyncTerra, Body, BodyMetadata

        client = AsyncTerra(
            dev_id="YOUR_DEV_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.body.write(
                data=[
                    Body(
                        metadata=BodyMetadata(
                            end_time="2022-10-28T10:00:00.000000+01:00",
                            start_time="1999-11-23T09:00:00.000000+02:00",
                        ),
                    )
                ],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.write(data=data, request_options=request_options)
        return _response.data

    async def delete(
        self,
        *,
        user_id: str,
        log_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> BodyDeleteResponse:
        """
        Used to delete Body metrics the user has registered on their account

        Parameters
        ----------
        user_id : str
            user ID to query data for

        log_ids : typing.Optional[typing.Sequence[str]]
            List of identifiers for body metrics entries to be deleted

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BodyDeleteResponse
            Returned when all records were deleted successfully

        Examples
        --------
        import asyncio

        from terra import AsyncTerra

        client = AsyncTerra(
            dev_id="YOUR_DEV_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.body.delete(
                user_id="user_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(user_id=user_id, log_ids=log_ids, request_options=request_options)
        return _response.data
