# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawDailyClient, RawDailyClient
from .types.daily_fetch_request_start_date import DailyFetchRequestStartDate
from .types.daily_fetch_response import DailyFetchResponse


class DailyClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawDailyClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawDailyClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawDailyClient
        """
        return self._raw_client

    def fetch(
        self,
        *,
        user_id: str,
        start_date: DailyFetchRequestStartDate,
        end_date: typing.Optional[int] = None,
        to_webhook: typing.Optional[bool] = None,
        with_samples: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DailyFetchResponse:
        """
        Fetches daily summaries of activity metrics such as steps, distance, calories burned etc. for a given user ID

        Parameters
        ----------
        user_id : str
            user ID to query data for

        start_date : DailyFetchRequestStartDate
            start date of data to query for - either ISO8601 date or unix timestamp

        end_date : typing.Optional[int]
            end date of data to query for - either ISO8601 date or unix timestamp

        to_webhook : typing.Optional[bool]
            boolean flag specifying whether to send the data retrieved to the webhook, or in the response

        with_samples : typing.Optional[bool]
            boolean flag specifying whether to include detailed samples in the returned payload

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DailyFetchResponse
            Returned upon successful data request

        Examples
        --------
        from terra import Terra

        client = Terra(
            dev_id="YOUR_DEV_ID",
            api_key="YOUR_API_KEY",
        )
        client.daily.fetch(
            user_id="user_id",
            start_date=1,
        )
        """
        _response = self._raw_client.fetch(
            user_id=user_id,
            start_date=start_date,
            end_date=end_date,
            to_webhook=to_webhook,
            with_samples=with_samples,
            request_options=request_options,
        )
        return _response.data


class AsyncDailyClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawDailyClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawDailyClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawDailyClient
        """
        return self._raw_client

    async def fetch(
        self,
        *,
        user_id: str,
        start_date: DailyFetchRequestStartDate,
        end_date: typing.Optional[int] = None,
        to_webhook: typing.Optional[bool] = None,
        with_samples: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DailyFetchResponse:
        """
        Fetches daily summaries of activity metrics such as steps, distance, calories burned etc. for a given user ID

        Parameters
        ----------
        user_id : str
            user ID to query data for

        start_date : DailyFetchRequestStartDate
            start date of data to query for - either ISO8601 date or unix timestamp

        end_date : typing.Optional[int]
            end date of data to query for - either ISO8601 date or unix timestamp

        to_webhook : typing.Optional[bool]
            boolean flag specifying whether to send the data retrieved to the webhook, or in the response

        with_samples : typing.Optional[bool]
            boolean flag specifying whether to include detailed samples in the returned payload

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DailyFetchResponse
            Returned upon successful data request

        Examples
        --------
        import asyncio

        from terra import AsyncTerra

        client = AsyncTerra(
            dev_id="YOUR_DEV_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.daily.fetch(
                user_id="user_id",
                start_date=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.fetch(
            user_id=user_id,
            start_date=start_date,
            end_date=end_date,
            to_webhook=to_webhook,
            with_samples=with_samples,
            request_options=request_options,
        )
        return _response.data
