# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .drink_sample import DrinkSample
from .meal import Meal
from .nutrition_metadata import NutritionMetadata
from .nutrition_summary import NutritionSummary


class Nutrition(UncheckedBaseModel):
    drink_samples: typing.Optional[typing.List[DrinkSample]] = pydantic.Field(default=None)
    """
    Information on drinks the user consumed throughout the day.
    """

    meals: typing.Optional[typing.List[Meal]] = pydantic.Field(default=None)
    """
    Information on individual foods consumed throughout a given day.
    """

    metadata: NutritionMetadata = pydantic.Field()
    """
    Object containing daily summary metadata.
    """

    summary: typing.Optional[NutritionSummary] = pydantic.Field(default=None)
    """
    Summative nutritional information for a given day.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
