# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .planned_workout_step_duration import PlannedWorkoutStepDuration
from .planned_workout_step_target import PlannedWorkoutStepTarget
from .strength_planned_workout_step_exercice_category import StrengthPlannedWorkoutStepExerciceCategory


class StrengthPlannedWorkoutStep(UncheckedBaseModel):
    weight_kg: typing.Optional[float] = pydantic.Field(default=None)
    """
    Weight to be lifted for the exercise
    """

    targets: typing.Optional[typing.List[PlannedWorkoutStepTarget]] = pydantic.Field(default=None)
    """
    List of targets for the workout
    """

    intensity: typing.Optional[int] = pydantic.Field(default=None)
    """
    Planned intensity for the workout step
    """

    order: typing.Optional[int] = pydantic.Field(default=None)
    """
    Position of the workout step in the overall workout
    """

    exercice_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of strength exercise to be performed for the workout step
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Description of workout step
    """

    durations: typing.Optional[typing.List[PlannedWorkoutStepDuration]] = pydantic.Field(default=None)
    """
    List of conditions to be fulfilled for the workout step to be completed - all of the conditions must be completed
    """

    exercice_category: typing.Optional[StrengthPlannedWorkoutStepExerciceCategory] = pydantic.Field(default=None)
    """
    Type of strength exercise to be performed for the workout step
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of workout step
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
