# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .body_battery_sample import BodyBatterySample
from .high import High
from .stress_sample import StressSample


class StressData(UncheckedBaseModel):
    avg_stress_level: typing.Optional[float] = pydantic.Field(default=None)
    """
    Average stress level for the day.
    """

    activity_stress_duration_seconds: typing.Optional[float] = pydantic.Field(default=None)
    """
    Total number of seconds spent in a stressed state while active during the day.
    """

    low_stress_duration_seconds: typing.Optional[float] = pydantic.Field(default=None)
    """
    Total number of seconds spent in a state of low stress during the day.
    """

    max_stress_level: typing.Optional[float] = pydantic.Field(default=None)
    """
    Maximum stress level recorded during the day.
    """

    medium_stress_duration_seconds: typing.Optional[float] = pydantic.Field(default=None)
    """
    Total number of seconds spent in a state of medium stress during the day.
    """

    samples: typing.Optional[typing.List[StressSample]] = pydantic.Field(default=None)
    """
    Array of stress level data points sampled throughout the day.
    """

    rest_stress_duration_seconds: typing.Optional[float] = pydantic.Field(default=None)
    """
    Total number of seconds spent in a stressed state while at rest during the day.
    """

    high_stress_duration_seconds: typing.Optional[float] = pydantic.Field(default=None)
    """
    Total number of seconds spent in a state of high stress during the day.
    """

    stress_duration_seconds: typing.Optional[float] = pydantic.Field(default=None)
    """
    Total number of seconds spent in a stressed state while at rest during the day.
    """

    stress_rating: typing.Optional[High] = pydantic.Field(default=None)
    """
    Stress rating for the day.
    """

    body_battery_samples: typing.Optional[typing.List[BodyBatterySample]] = pydantic.Field(default=None)
    """
    Array of Body Battery data points sampled throughout the day.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
