# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.request_options import RequestOptions
from ..core.unchecked_base_model import construct_type
from ..errors.bad_request_error import BadRequestError
from ..errors.not_found_error import NotFoundError
from ..errors.unauthorized_error import UnauthorizedError
from .types.menstruation_fetch_request_start_date import MenstruationFetchRequestStartDate
from .types.menstruation_fetch_response import MenstruationFetchResponse


class RawMenstruationClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def fetch(
        self,
        *,
        user_id: str,
        start_date: MenstruationFetchRequestStartDate,
        end_date: typing.Optional[int] = None,
        to_webhook: typing.Optional[bool] = None,
        with_samples: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[MenstruationFetchResponse]:
        """
        Fetches menstruation data such as cycle length, period length, ovulation date etc. for a given user ID

        Parameters
        ----------
        user_id : str
            Terra user ID (UUID format) to retrieve data for

        start_date : MenstruationFetchRequestStartDate
            Start date for data query - either ISO8601 date (YYYY-MM-DD) or unix timestamp in seconds (10-digit)

        end_date : typing.Optional[int]
            End date for data query - either ISO8601 date (YYYY-MM-DD) or unix timestamp in seconds (10-digit)

        to_webhook : typing.Optional[bool]
            Boolean flag specifying whether to send the data retrieved to the webhook instead of in the response (default: false)

        with_samples : typing.Optional[bool]
            Boolean flag specifying whether to include detailed samples in the returned payload (default: false)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[MenstruationFetchResponse]
            Returned upon successful data request
        """
        _response = self._client_wrapper.httpx_client.request(
            "menstruation",
            method="GET",
            params={
                "user_id": user_id,
                "start_date": start_date,
                "end_date": end_date,
                "to_webhook": to_webhook,
                "with_samples": with_samples,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    MenstruationFetchResponse,
                    construct_type(
                        type_=MenstruationFetchResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawMenstruationClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def fetch(
        self,
        *,
        user_id: str,
        start_date: MenstruationFetchRequestStartDate,
        end_date: typing.Optional[int] = None,
        to_webhook: typing.Optional[bool] = None,
        with_samples: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[MenstruationFetchResponse]:
        """
        Fetches menstruation data such as cycle length, period length, ovulation date etc. for a given user ID

        Parameters
        ----------
        user_id : str
            Terra user ID (UUID format) to retrieve data for

        start_date : MenstruationFetchRequestStartDate
            Start date for data query - either ISO8601 date (YYYY-MM-DD) or unix timestamp in seconds (10-digit)

        end_date : typing.Optional[int]
            End date for data query - either ISO8601 date (YYYY-MM-DD) or unix timestamp in seconds (10-digit)

        to_webhook : typing.Optional[bool]
            Boolean flag specifying whether to send the data retrieved to the webhook instead of in the response (default: false)

        with_samples : typing.Optional[bool]
            Boolean flag specifying whether to include detailed samples in the returned payload (default: false)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[MenstruationFetchResponse]
            Returned upon successful data request
        """
        _response = await self._client_wrapper.httpx_client.request(
            "menstruation",
            method="GET",
            params={
                "user_id": user_id,
                "start_date": start_date,
                "end_date": end_date,
                "to_webhook": to_webhook,
                "with_samples": with_samples,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    MenstruationFetchResponse,
                    construct_type(
                        type_=MenstruationFetchResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
