# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.nutrition import Nutrition
from .raw_client import AsyncRawNutritionClient, RawNutritionClient
from .types.nutrition_delete_response import NutritionDeleteResponse
from .types.nutrition_fetch_request_start_date import NutritionFetchRequestStartDate
from .types.nutrition_fetch_response import NutritionFetchResponse
from .types.nutrition_write_response import NutritionWriteResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class NutritionClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawNutritionClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawNutritionClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawNutritionClient
        """
        return self._raw_client

    def fetch(
        self,
        *,
        user_id: str,
        start_date: NutritionFetchRequestStartDate,
        end_date: typing.Optional[int] = None,
        to_webhook: typing.Optional[bool] = None,
        with_samples: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> NutritionFetchResponse:
        """
        Fetches nutrition log data such as meal type, calories, macronutrients etc. for a given user ID

        Parameters
        ----------
        user_id : str
            Terra user ID (UUID format) to retrieve data for

        start_date : NutritionFetchRequestStartDate
            Start date for data query - either ISO8601 date (YYYY-MM-DD) or unix timestamp in seconds (10-digit)

        end_date : typing.Optional[int]
            End date for data query - either ISO8601 date (YYYY-MM-DD) or unix timestamp in seconds (10-digit)

        to_webhook : typing.Optional[bool]
            Boolean flag specifying whether to send the data retrieved to the webhook instead of in the response (default: false)

        with_samples : typing.Optional[bool]
            Boolean flag specifying whether to include detailed samples in the returned payload (default: false)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        NutritionFetchResponse
            Returned upon successful data request

        Examples
        --------
        from terra import Terra

        client = Terra(
            dev_id="YOUR_DEV_ID",
            api_key="YOUR_API_KEY",
        )
        client.nutrition.fetch(
            user_id="user_id",
            start_date=1,
        )
        """
        _response = self._raw_client.fetch(
            user_id=user_id,
            start_date=start_date,
            end_date=end_date,
            to_webhook=to_webhook,
            with_samples=with_samples,
            request_options=request_options,
        )
        return _response.data

    def write(
        self, *, data: typing.Sequence[Nutrition], request_options: typing.Optional[RequestOptions] = None
    ) -> NutritionWriteResponse:
        """
        Used to post nutrition logs to a provider. This endpoint only works for users connected via Fitbit. Returns error for other providers.

        Parameters
        ----------
        data : typing.Sequence[Nutrition]
            Nutrition entry to post to data provider

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        NutritionWriteResponse
            Returned when activity was successfully created on the provider

        Examples
        --------
        from terra import Nutrition, NutritionMetadata, Terra

        client = Terra(
            dev_id="YOUR_DEV_ID",
            api_key="YOUR_API_KEY",
        )
        client.nutrition.write(
            data=[
                Nutrition(
                    metadata=NutritionMetadata(
                        end_time="2022-10-28T10:00:00.000000+01:00",
                        start_time="1999-11-23T09:00:00.000000+02:00",
                    ),
                )
            ],
        )
        """
        _response = self._raw_client.write(data=data, request_options=request_options)
        return _response.data

    def delete(
        self,
        *,
        user_id: str,
        data: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> NutritionDeleteResponse:
        """
        Used to delete nutrition logs the user has registered on their account

        Parameters
        ----------
        user_id : str
            Terra user ID (UUID format) to retrieve data for

        data : typing.Optional[typing.Sequence[str]]
            List of identifiers for nutrition entries to be deleted

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        NutritionDeleteResponse
            Returned when all records were deleted successfully

        Examples
        --------
        from terra import Terra

        client = Terra(
            dev_id="YOUR_DEV_ID",
            api_key="YOUR_API_KEY",
        )
        client.nutrition.delete(
            user_id="user_id",
        )
        """
        _response = self._raw_client.delete(user_id=user_id, data=data, request_options=request_options)
        return _response.data


class AsyncNutritionClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawNutritionClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawNutritionClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawNutritionClient
        """
        return self._raw_client

    async def fetch(
        self,
        *,
        user_id: str,
        start_date: NutritionFetchRequestStartDate,
        end_date: typing.Optional[int] = None,
        to_webhook: typing.Optional[bool] = None,
        with_samples: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> NutritionFetchResponse:
        """
        Fetches nutrition log data such as meal type, calories, macronutrients etc. for a given user ID

        Parameters
        ----------
        user_id : str
            Terra user ID (UUID format) to retrieve data for

        start_date : NutritionFetchRequestStartDate
            Start date for data query - either ISO8601 date (YYYY-MM-DD) or unix timestamp in seconds (10-digit)

        end_date : typing.Optional[int]
            End date for data query - either ISO8601 date (YYYY-MM-DD) or unix timestamp in seconds (10-digit)

        to_webhook : typing.Optional[bool]
            Boolean flag specifying whether to send the data retrieved to the webhook instead of in the response (default: false)

        with_samples : typing.Optional[bool]
            Boolean flag specifying whether to include detailed samples in the returned payload (default: false)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        NutritionFetchResponse
            Returned upon successful data request

        Examples
        --------
        import asyncio

        from terra import AsyncTerra

        client = AsyncTerra(
            dev_id="YOUR_DEV_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.nutrition.fetch(
                user_id="user_id",
                start_date=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.fetch(
            user_id=user_id,
            start_date=start_date,
            end_date=end_date,
            to_webhook=to_webhook,
            with_samples=with_samples,
            request_options=request_options,
        )
        return _response.data

    async def write(
        self, *, data: typing.Sequence[Nutrition], request_options: typing.Optional[RequestOptions] = None
    ) -> NutritionWriteResponse:
        """
        Used to post nutrition logs to a provider. This endpoint only works for users connected via Fitbit. Returns error for other providers.

        Parameters
        ----------
        data : typing.Sequence[Nutrition]
            Nutrition entry to post to data provider

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        NutritionWriteResponse
            Returned when activity was successfully created on the provider

        Examples
        --------
        import asyncio

        from terra import AsyncTerra, Nutrition, NutritionMetadata

        client = AsyncTerra(
            dev_id="YOUR_DEV_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.nutrition.write(
                data=[
                    Nutrition(
                        metadata=NutritionMetadata(
                            end_time="2022-10-28T10:00:00.000000+01:00",
                            start_time="1999-11-23T09:00:00.000000+02:00",
                        ),
                    )
                ],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.write(data=data, request_options=request_options)
        return _response.data

    async def delete(
        self,
        *,
        user_id: str,
        data: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> NutritionDeleteResponse:
        """
        Used to delete nutrition logs the user has registered on their account

        Parameters
        ----------
        user_id : str
            Terra user ID (UUID format) to retrieve data for

        data : typing.Optional[typing.Sequence[str]]
            List of identifiers for nutrition entries to be deleted

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        NutritionDeleteResponse
            Returned when all records were deleted successfully

        Examples
        --------
        import asyncio

        from terra import AsyncTerra

        client = AsyncTerra(
            dev_id="YOUR_DEV_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.nutrition.delete(
                user_id="user_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(user_id=user_id, data=data, request_options=request_options)
        return _response.data
