# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .heart_rate_zone_data import HeartRateZoneData


class HeartRateDataSummary(UncheckedBaseModel):
    avg_hr_bpm: typing.Optional[float] = pydantic.Field(default=None)
    """
    Average HeartRate of the user during the workout.
    """

    avg_hrv_rmssd: typing.Optional[float] = pydantic.Field(default=None)
    """
    Average HeartRate Variability of the user during the workout, computed using RMSSD.
    """

    avg_hrv_sdnn: typing.Optional[float] = pydantic.Field(default=None)
    """
    Average HeartRate Variability of the user during the workout, computed using SDNN.
    """

    hr_zone_data: typing.Optional[typing.List[HeartRateZoneData]] = pydantic.Field(default=None)
    """
    Array of time spent in various HR zones throughout the workout.
    """

    max_hr_bpm: typing.Optional[float] = pydantic.Field(default=None)
    """
    Maximum HeartRate of the user during the workout.
    """

    min_hr_bpm: typing.Optional[float] = pydantic.Field(default=None)
    """
    Minimum HeartRate of the user during the workout.
    """

    resting_hr_bpm: typing.Optional[float] = pydantic.Field(default=None)
    """
    Resting HeartRate of the user, as determined by the fitness data provider.
    """

    user_max_hr_bpm: typing.Optional[float] = pydantic.Field(default=None)
    """
    User's maximum HeartRate based on their age, and other factors as determined by the fitness data provider.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
