# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .oxygen_saturation_sample import OxygenSaturationSample


class OxygenSaturationData(UncheckedBaseModel):
    avg_saturation_percentage: typing.Optional[float] = pydantic.Field(default=None)
    """
    Average Oxygen Saturation percentage of the user during the sleep session.
    """

    end_time: typing.Optional[str] = pydantic.Field(default=None)
    """
    The end time of the recording of oxygen saturation, in ISO8601 format with microsecond precision. TimeZone info will be provided whenever possible. If absent, the time corresponds to the user's local time.
    """

    samples: typing.Optional[typing.List[OxygenSaturationSample]] = pydantic.Field(default=None)
    """
    Array of Oxygen Saturation percentage datapoints sampled throughout the sleep session.
    """

    start_time: typing.Optional[str] = pydantic.Field(default=None)
    """
    The start time of the recording of oxygen saturation, in ISO8601 format with microsecond precision. Will always fall on midnight of any given day, and will always be equal to 24h before end_time. TimeZone info will be provided whenever possible. If absent, the time corresponds to the user's local time.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
