# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .planned_workout_step_duration import PlannedWorkoutStepDuration
from .planned_workout_step_target import PlannedWorkoutStepTarget
from .swimming_planned_workout_step_equipment_type import SwimmingPlannedWorkoutStepEquipmentType
from .swimming_planned_workout_step_stroke_type import SwimmingPlannedWorkoutStepStrokeType


class SwimmingPlannedWorkoutStep(UncheckedBaseModel):
    targets: typing.Optional[typing.List[PlannedWorkoutStepTarget]] = pydantic.Field(default=None)
    """
    List of targets for the workout
    """

    intensity: typing.Optional[int] = pydantic.Field(default=None)
    """
    Planned intensity for the workout step
    """

    order: typing.Optional[int] = pydantic.Field(default=None)
    """
    Position of the workout step in the overall workout
    """

    equipment_type: typing.Optional[SwimmingPlannedWorkoutStepEquipmentType] = pydantic.Field(default=None)
    """
    Workout equipment to be used during the workout step
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Description of workout step
    """

    durations: typing.Optional[typing.List[PlannedWorkoutStepDuration]] = pydantic.Field(default=None)
    """
    List of conditions to be fulfilled for the workout step to be completed - all of the conditions must be completed
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of workout step
    """

    stroke_type: typing.Optional[SwimmingPlannedWorkoutStepStrokeType] = pydantic.Field(default=None)
    """
    Stroke type used for the workout step (e.g. breaststroke)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
