# Especificación de gráficos de barras horizontales

En un archivo `.yaml` los gráficos de barras horizontales se especifican con el constructor `!barh`.

## Series y bloques de series

Pueden especificarse, o bien *series*, con la entrada `series` o bien *bloques de series* con la entrada `blocks`, pero no ambas a la vez.

- Cada serie en la entrada `series` representará una barra en el gráfico final.
- Los *bloques de series* utilizan para controlar los colores de las barras. Las series dentro de un mismo bloque tendrán el mismo color en el gráfico final.

```yaml
test_plot1: !barh
  blocks:
    block1:
      label: name_to_be_displayed_1
      series:
        series_name_1: series_name_to_be_displayed_1
        series_name_2: series_name_to_be_displayed_2*
    block2:
      label: name_to_be_displayed_2
      series:
        series_name_3: series_name_to_be_displayed_3
        series_name_4: series_name_to_be_displayed_4

test_plot2: !barh
  series:
    series_name_5: series_name_to_be_displayed_5
    series_name_6: series_name_to_be_displayed_6
```

### Cómo destacar una serie
Si añadimos un `*` al nombre de una serie, esta será marcada como destacada en el gráfico. Concretamente, se le añadirá cierta transparencia.

## Qué muestra un gráfico de barras horizontales

Un gráfico de barras horizontales puede mostrar hasta dos conjuntos de valores asociados de forma simultánea.

- Si $(x_1,...,x_n)$ es un conjunto de valores, un gráfico de barras horizontales presenta estos valores de forma que cada uno de ellos queda asociado a una barra de longitud proporcional a su valor.
  - Este conjunto de valores está representado por una *serie* de *pandas* y suele recibir, internamente, el nombre de `value_series`.
- Opcionalmente, podemos querer acompañar cada valor (o solo algunos) $x_i$ con otro valor auxiliar $y_i$ para añadir contexto.
  - Estos valores auxiliares $y_i$ se monstrarán con el formato que decidamos, entre paréntesis, al lado del nombre asociado al valor $x_i$, en el eje de ordenadas.
  - Este conjunto de valores está respresentado por una *serie* de *pandas* y suele recibir, internamente, el nombre de `axis_series`.

### Formato del eje *x*
Para especificar el número de decimales, la escala y las unidades que queremos que se muestren para los valores presentados en forma de barras (nótese que esta configración afectará al aspecto del eje *x*) podemos usar la entrada `format`.

```yaml
nombre_del_grafico: !barh
    # other stuff
    format:
        decimals: 0
        units: "%"
        scale: 100

```

### Formato de los valores representados en el eje *y*
Para especificar el número de decimales, la escala y las unidades que queremos que se muestren para los valores auxiliares presentados numéricamente en el eje *y*, podemos usar la entrada `axis_format`.

```yaml
nombre_del_grafico: !barh
    # other stuff
    axis_format:
        decimals: 2
        units: €
        scale: 1
```

### Formato de las anotaciones sobre las barras
En ocasiones es dificil ver el valor exacto asociado a cada barra, sobre todo cuando no hay muchas marcas en el eje $x$, la rejilla es demasiado clara, o la barra queda muy lejos del eje.

Para solventar este problema, podemos, opcionalmente, añadir una anotación al lado de cada una de las barras que indique numéricamente, y con el formato que queramos, el valor asociado a cada una de ellas. Para ello, podemos usar la entrada `annot_format`.

```yaml
nombre_del_grafico: !barh
    # other stuff
    annot_format:
        decimals: 2
        units: €
        scale: 1
```

## Ordenar las barras por longitud

Usualmente querremos que las barras del gráfico se muestren ordenadas, para ellos podemos usar la entrada `sorted`, que se tomará como `True` por defecto.

- *TO DO*: Quizá aquí sería interesante añadir una entrada `ascending` que indique cómo ordenar las barras en caso de que la entrada `sorted` esté a `True`, y que será ignorada en caso de que `sorted` esté a `False`.

```yaml
nombre_del_grafico: !barh
    # other stuff
    sorted: True # default

```

## Gráficos de series a partir de *dataframes* con formato *flash*

### Entrada *flash*

```yaml
nombre_del_gráfico: !barh
    # other stuff
    flash:
        date: # if None takes last date
        deviations: True
        offset: ftd # friday to date
        difference: relative # relative/absolute difference
```