
# python wrapper for package github.com/cohere-ai/tokenizer within overall package tokenizer
# This is what you import to use the package.
# File is generated by gopy. Do not edit.
# gopy build -output=tokenizer -vm=python3 /home/kipply/tokenizer

# the following is required to enable dlopen to open the _go.so file
import os,sys,inspect,collections
try:
	import collections.abc as _collections_abc
except ImportError:
	_collections_abc = collections

cwd = os.getcwd()
currentdir = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
os.chdir(currentdir)
from . import _tokenizer
from . import go

os.chdir(cwd)

# to use this code in your end-user python file, import it as follows:
# from tokenizer import tokenizer
# and then refer to everything using tokenizer. prefix
# packages imported by this package listed below:




# ---- Types ---

# Python type for slice [2]string
class Array_2_string(go.GoClass):
	""""""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameter is a python list that we copy from
		"""
		self.index = 0
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_tokenizer.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_tokenizer.IncRef(self.handle)
	def __del__(self):
		_tokenizer.DecRef(self.handle)
	def __str__(self):
		s = 'tokenizer.Array_2_string len: ' + str(len(self)) + ' handle: ' + str(self.handle) + ' ['
		if len(self) < 120:
			s += ', '.join(map(str, self)) + ']'
		return s
	def __repr__(self):
		return 'tokenizer.Array_2_string([' + ', '.join(map(str, self)) + '])'
	def __len__(self):
		return _tokenizer.Array_2_string_len(self.handle)
	def __getitem__(self, key):
		if isinstance(key, slice):
			return [self[ii] for ii in range(*key.indices(len(self)))]
		elif isinstance(key, int):
			if key < 0:
				key += len(self)
			if key < 0 or key >= len(self):
				raise IndexError('slice index out of range')
			return _tokenizer.Array_2_string_elem(self.handle, key)
		else:
			raise TypeError('slice index invalid type')
	def __setitem__(self, idx, value):
		if idx < 0:
			idx += len(self)
		if idx < len(self):
			_tokenizer.Array_2_string_set(self.handle, idx, value)
			return
		raise IndexError('slice index out of range')
	def __iter__(self):
		self.index = 0
		return self
	def __next__(self):
		if self.index < len(self):
			rv = _tokenizer.Array_2_string_elem(self.handle, self.index)
			self.index = self.index + 1
			return rv
		raise StopIteration

# Python type for slice [][2]string
class Slice__2_string(go.GoClass):
	""""""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameter is a python list that we copy from
		"""
		self.index = 0
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_tokenizer.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_tokenizer.IncRef(self.handle)
		else:
			self.handle = _tokenizer.Slice__2_string_CTor()
			_tokenizer.IncRef(self.handle)
			if len(args) > 0:
				if not isinstance(args[0], _collections_abc.Iterable):
					raise TypeError('Slice__2_string.__init__ takes a sequence as argument')
				for elt in args[0]:
					self.append(elt)
	def __del__(self):
		_tokenizer.DecRef(self.handle)
	def __str__(self):
		s = 'tokenizer.Slice__2_string len: ' + str(len(self)) + ' handle: ' + str(self.handle) + ' ['
		if len(self) < 120:
			s += ', '.join(map(str, self)) + ']'
		return s
	def __repr__(self):
		return 'tokenizer.Slice__2_string([' + ', '.join(map(str, self)) + '])'
	def __len__(self):
		return _tokenizer.Slice__2_string_len(self.handle)
	def __getitem__(self, key):
		if isinstance(key, slice):
			if key.step == None or key.step == 1:
				st = key.start
				ed = key.stop
				if st == None:
					st = 0
				if ed == None:
					ed = _tokenizer.Slice__2_string_len(self.handle)
				return Slice__2_string(handle=_tokenizer.Slice__2_string_subslice(self.handle, st, ed))
			return [self[ii] for ii in range(*key.indices(len(self)))]
		elif isinstance(key, int):
			if key < 0:
				key += len(self)
			if key < 0 or key >= len(self):
				raise IndexError('slice index out of range')
			return Array_2_string(handle=_tokenizer.Slice__2_string_elem(self.handle, key))
		else:
			raise TypeError('slice index invalid type')
	def __setitem__(self, idx, value):
		if idx < 0:
			idx += len(self)
		if idx < len(self):
			_tokenizer.Slice__2_string_set(self.handle, idx, value.handle)
			return
		raise IndexError('slice index out of range')
	def __iadd__(self, value):
		if not isinstance(value, _collections_abc.Iterable):
			raise TypeError('Slice__2_string.__iadd__ takes a sequence as argument')
		for elt in value:
			self.append(elt)
		return self
	def __iter__(self):
		self.index = 0
		return self
	def __next__(self):
		if self.index < len(self):
			rv = _tokenizer.Slice__2_string_elem(self.handle, self.index)
			self.index = self.index + 1
			return rv
		raise StopIteration
	def append(self, value):
		_tokenizer.Slice__2_string_append(self.handle, value.handle)
	def copy(self, src):
		""" copy emulates the go copy function, copying elements into this list from source list, up to min of size of each list """
		mx = min(len(self), len(src))
		for i in range(mx):
			self[i] = src[i]

# Python type for map map[[2]string]int64
class Map__2_string_int64(go.GoClass):
	""""""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameter is a python list that we copy from
		"""
		self.index = 0
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_tokenizer.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_tokenizer.IncRef(self.handle)
		else:
			self.handle = _tokenizer.Map__2_string_int64_CTor()
			_tokenizer.IncRef(self.handle)
			if len(args) > 0:
				if not isinstance(args[0], _collections_abc.Mapping):
					raise TypeError('Map__2_string_int64.__init__ takes a mapping as argument')
				for k, v in args[0].items():
					_tokenizer.Map__2_string_int64_set(self.handle, k, v)
	def __del__(self):
		_tokenizer.DecRef(self.handle)
	def __str__(self):
		s = 'tokenizer.Map__2_string_int64 len: ' + str(len(self)) + ' handle: ' + str(self.handle) + ' {'
		if len(self) < 120:
			for k, v in self.items():
				s += str(k) + '=' + str(v) + ', '
		return s + '}'
	def __repr__(self):
		s = 'tokenizer.Map__2_string_int64({'
		for k, v in self.items():
			s += str(k) + '=' + str(v) + ', '
		return s + '})'
	def __len__(self):
		return _tokenizer.Map__2_string_int64_len(self.handle)
	def __getitem__(self, key):
		return _tokenizer.Map__2_string_int64_elem(self.handle, key.handle)
	def __setitem__(self, key, value):
		_tokenizer.Map__2_string_int64_set(self.handle, key.handle, value)
	def __delitem__(self, key):
		return _tokenizer.Map__2_string_int64_delete(self.handle, key.handle)
	def keys(self):
		return Slice__2_string(handle=_tokenizer.Map__2_string_int64_keys(self.handle))
	def values(self):
		vls = []
		kys = self.keys()
		for k in kys:
			vls.append(self[k])
		return vls
	def items(self):
		vls = []
		kys = self.keys()
		for k in kys:
			vls.append((k, self[k]))
		return vls
	def __iter__(self):
		return iter(self.items())
	def __contains__(self, key):
		return _tokenizer.Map__2_string_int64_contains(self.handle, key.handle)

# Python type for map map[int64]string
class Map_int64_string(go.GoClass):
	""""""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameter is a python list that we copy from
		"""
		self.index = 0
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_tokenizer.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_tokenizer.IncRef(self.handle)
		else:
			self.handle = _tokenizer.Map_int64_string_CTor()
			_tokenizer.IncRef(self.handle)
			if len(args) > 0:
				if not isinstance(args[0], _collections_abc.Mapping):
					raise TypeError('Map_int64_string.__init__ takes a mapping as argument')
				for k, v in args[0].items():
					_tokenizer.Map_int64_string_set(self.handle, k, v)
	def __del__(self):
		_tokenizer.DecRef(self.handle)
	def __str__(self):
		s = 'tokenizer.Map_int64_string len: ' + str(len(self)) + ' handle: ' + str(self.handle) + ' {'
		if len(self) < 120:
			for k, v in self.items():
				s += str(k) + '=' + str(v) + ', '
		return s + '}'
	def __repr__(self):
		s = 'tokenizer.Map_int64_string({'
		for k, v in self.items():
			s += str(k) + '=' + str(v) + ', '
		return s + '})'
	def __len__(self):
		return _tokenizer.Map_int64_string_len(self.handle)
	def __getitem__(self, key):
		return _tokenizer.Map_int64_string_elem(self.handle, key)
	def __setitem__(self, key, value):
		_tokenizer.Map_int64_string_set(self.handle, key, value)
	def __delitem__(self, key):
		return _tokenizer.Map_int64_string_delete(self.handle, key)
	def keys(self):
		return go.Slice_int64(handle=_tokenizer.Map_int64_string_keys(self.handle))
	def values(self):
		vls = []
		kys = self.keys()
		for k in kys:
			vls.append(self[k])
		return vls
	def items(self):
		vls = []
		kys = self.keys()
		for k in kys:
			vls.append((k, self[k]))
		return vls
	def __iter__(self):
		return iter(self.items())
	def __contains__(self, key):
		return _tokenizer.Map_int64_string_contains(self.handle, key)

# Python type for map map[string]int64
class Map_string_int64(go.GoClass):
	""""""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameter is a python list that we copy from
		"""
		self.index = 0
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_tokenizer.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_tokenizer.IncRef(self.handle)
		else:
			self.handle = _tokenizer.Map_string_int64_CTor()
			_tokenizer.IncRef(self.handle)
			if len(args) > 0:
				if not isinstance(args[0], _collections_abc.Mapping):
					raise TypeError('Map_string_int64.__init__ takes a mapping as argument')
				for k, v in args[0].items():
					_tokenizer.Map_string_int64_set(self.handle, k, v)
	def __del__(self):
		_tokenizer.DecRef(self.handle)
	def __str__(self):
		s = 'tokenizer.Map_string_int64 len: ' + str(len(self)) + ' handle: ' + str(self.handle) + ' {'
		if len(self) < 120:
			for k, v in self.items():
				s += str(k) + '=' + str(v) + ', '
		return s + '}'
	def __repr__(self):
		s = 'tokenizer.Map_string_int64({'
		for k, v in self.items():
			s += str(k) + '=' + str(v) + ', '
		return s + '})'
	def __len__(self):
		return _tokenizer.Map_string_int64_len(self.handle)
	def __getitem__(self, key):
		return _tokenizer.Map_string_int64_elem(self.handle, key)
	def __setitem__(self, key, value):
		_tokenizer.Map_string_int64_set(self.handle, key, value)
	def __delitem__(self, key):
		return _tokenizer.Map_string_int64_delete(self.handle, key)
	def keys(self):
		return go.Slice_string(handle=_tokenizer.Map_string_int64_keys(self.handle))
	def values(self):
		vls = []
		kys = self.keys()
		for k in kys:
			vls.append(self[k])
		return vls
	def items(self):
		vls = []
		kys = self.keys()
		for k in kys:
			vls.append((k, self[k]))
		return vls
	def __iter__(self):
		return iter(self.items())
	def __contains__(self, key):
		return _tokenizer.Map_string_int64_contains(self.handle, key)

# Python type for map map[string]string
class Map_string_string(go.GoClass):
	""""""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameter is a python list that we copy from
		"""
		self.index = 0
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_tokenizer.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_tokenizer.IncRef(self.handle)
		else:
			self.handle = _tokenizer.Map_string_string_CTor()
			_tokenizer.IncRef(self.handle)
			if len(args) > 0:
				if not isinstance(args[0], _collections_abc.Mapping):
					raise TypeError('Map_string_string.__init__ takes a mapping as argument')
				for k, v in args[0].items():
					_tokenizer.Map_string_string_set(self.handle, k, v)
	def __del__(self):
		_tokenizer.DecRef(self.handle)
	def __str__(self):
		s = 'tokenizer.Map_string_string len: ' + str(len(self)) + ' handle: ' + str(self.handle) + ' {'
		if len(self) < 120:
			for k, v in self.items():
				s += str(k) + '=' + str(v) + ', '
		return s + '}'
	def __repr__(self):
		s = 'tokenizer.Map_string_string({'
		for k, v in self.items():
			s += str(k) + '=' + str(v) + ', '
		return s + '})'
	def __len__(self):
		return _tokenizer.Map_string_string_len(self.handle)
	def __getitem__(self, key):
		return _tokenizer.Map_string_string_elem(self.handle, key)
	def __setitem__(self, key, value):
		_tokenizer.Map_string_string_set(self.handle, key, value)
	def __delitem__(self, key):
		return _tokenizer.Map_string_string_delete(self.handle, key)
	def keys(self):
		return go.Slice_string(handle=_tokenizer.Map_string_string_keys(self.handle))
	def values(self):
		vls = []
		kys = self.keys()
		for k in kys:
			vls.append(self[k])
		return vls
	def items(self):
		vls = []
		kys = self.keys()
		for k in kys:
			vls.append((k, self[k]))
		return vls
	def __iter__(self):
		return iter(self.items())
	def __contains__(self, key):
		return _tokenizer.Map_string_string_contains(self.handle, key)


#---- Enums from Go (collections of consts with same type) ---


#---- Constants from Go: Python can only ask that you please don't change these! ---


# ---- Global Variables: can only use functions to access ---


# ---- Interfaces ---


# ---- Structs ---

# Python type for struct tokenizer.Encoder
class Encoder(go.GoClass):
	""""""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameters can be unnamed in order of field names or named fields
		in which case a new Go object is constructed first
		"""
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_tokenizer.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_tokenizer.IncRef(self.handle)
		else:
			self.handle = _tokenizer.tokenizer_Encoder_CTor()
			_tokenizer.IncRef(self.handle)
			if  0 < len(args):
				self.Encoder = args[0]
			if "Encoder" in kwargs:
				self.Encoder = kwargs["Encoder"]
			if  1 < len(args):
				self.Decoder = args[1]
			if "Decoder" in kwargs:
				self.Decoder = kwargs["Decoder"]
			if  2 < len(args):
				self.BPERanks = args[2]
			if "BPERanks" in kwargs:
				self.BPERanks = kwargs["BPERanks"]
			if  3 < len(args):
				self.Cache = args[3]
			if "Cache" in kwargs:
				self.Cache = kwargs["Cache"]
			if  4 < len(args):
				self.VocabSize = args[4]
			if "VocabSize" in kwargs:
				self.VocabSize = kwargs["VocabSize"]
	def __del__(self):
		_tokenizer.DecRef(self.handle)
	def __str__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'tokenizer.Encoder{'
		first = True
		for v in pr:
			if callable(v[1]):
				continue
			if first:
				first = False
			else:
				sv += ', '
			sv += v[0] + '=' + str(v[1])
		return sv + '}'
	def __repr__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'tokenizer.Encoder ( '
		for v in pr:
			if not callable(v[1]):
				sv += v[0] + '=' + str(v[1]) + ', '
		return sv + ')'
	@property
	def Encoder(self):
		return Map_string_int64(handle=_tokenizer.tokenizer_Encoder_Encoder_Get(self.handle))
	@Encoder.setter
	def Encoder(self, value):
		if isinstance(value, go.GoClass):
			_tokenizer.tokenizer_Encoder_Encoder_Set(self.handle, value.handle)
		else:
			raise TypeError("supplied argument type {t} is not a go.GoClass".format(t=type(value)))
	@property
	def Decoder(self):
		return Map_int64_string(handle=_tokenizer.tokenizer_Encoder_Decoder_Get(self.handle))
	@Decoder.setter
	def Decoder(self, value):
		if isinstance(value, go.GoClass):
			_tokenizer.tokenizer_Encoder_Decoder_Set(self.handle, value.handle)
		else:
			raise TypeError("supplied argument type {t} is not a go.GoClass".format(t=type(value)))
	@property
	def BPERanks(self):
		return Map__2_string_int64(handle=_tokenizer.tokenizer_Encoder_BPERanks_Get(self.handle))
	@BPERanks.setter
	def BPERanks(self, value):
		if isinstance(value, go.GoClass):
			_tokenizer.tokenizer_Encoder_BPERanks_Set(self.handle, value.handle)
		else:
			raise TypeError("supplied argument type {t} is not a go.GoClass".format(t=type(value)))
	@property
	def Cache(self):
		return Map_string_string(handle=_tokenizer.tokenizer_Encoder_Cache_Get(self.handle))
	@Cache.setter
	def Cache(self, value):
		if isinstance(value, go.GoClass):
			_tokenizer.tokenizer_Encoder_Cache_Set(self.handle, value.handle)
		else:
			raise TypeError("supplied argument type {t} is not a go.GoClass".format(t=type(value)))
	@property
	def VocabSize(self):
		return _tokenizer.tokenizer_Encoder_VocabSize_Get(self.handle)
	@VocabSize.setter
	def VocabSize(self, value):
		if isinstance(value, go.GoClass):
			_tokenizer.tokenizer_Encoder_VocabSize_Set(self.handle, value.handle)
		else:
			_tokenizer.tokenizer_Encoder_VocabSize_Set(self.handle, value)
	def Encode(self, text):
		"""Encode(str text) []long"""
		return go.Slice_int64(handle=_tokenizer.tokenizer_Encoder_Encode(self.handle, text))
	def Decode(self, tokens):
		"""Decode([]long tokens) str"""
		return _tokenizer.tokenizer_Encoder_Decode(self.handle, tokens.handle)

# Python type for struct tokenizer.Merge
class Merge(go.GoClass):
	""""""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameters can be unnamed in order of field names or named fields
		in which case a new Go object is constructed first
		"""
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_tokenizer.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_tokenizer.IncRef(self.handle)
		else:
			self.handle = _tokenizer.tokenizer_Merge_CTor()
			_tokenizer.IncRef(self.handle)
			if  0 < len(args):
				self.Merge = args[0]
			if "Merge" in kwargs:
				self.Merge = kwargs["Merge"]
			if  1 < len(args):
				self.Count = args[1]
			if "Count" in kwargs:
				self.Count = kwargs["Count"]
	def __del__(self):
		_tokenizer.DecRef(self.handle)
	def __str__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'tokenizer.Merge{'
		first = True
		for v in pr:
			if callable(v[1]):
				continue
			if first:
				first = False
			else:
				sv += ', '
			sv += v[0] + '=' + str(v[1])
		return sv + '}'
	def __repr__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'tokenizer.Merge ( '
		for v in pr:
			if not callable(v[1]):
				sv += v[0] + '=' + str(v[1]) + ', '
		return sv + ')'
	@property
	def Merge(self):
		return Array_2_string(handle=_tokenizer.tokenizer_Merge_Merge_Get(self.handle))
	@property
	def Count(self):
		return _tokenizer.tokenizer_Merge_Count_Get(self.handle)
	@Count.setter
	def Count(self, value):
		if isinstance(value, go.GoClass):
			_tokenizer.tokenizer_Merge_Count_Set(self.handle, value.handle)
		else:
			_tokenizer.tokenizer_Merge_Count_Set(self.handle, value)

# Python type for struct tokenizer.WordCount
class WordCount(go.GoClass):
	""""""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameters can be unnamed in order of field names or named fields
		in which case a new Go object is constructed first
		"""
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_tokenizer.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_tokenizer.IncRef(self.handle)
		else:
			self.handle = _tokenizer.tokenizer_WordCount_CTor()
			_tokenizer.IncRef(self.handle)
			if  0 < len(args):
				self.Pieces = args[0]
			if "Pieces" in kwargs:
				self.Pieces = kwargs["Pieces"]
			if  1 < len(args):
				self.Count = args[1]
			if "Count" in kwargs:
				self.Count = kwargs["Count"]
	def __del__(self):
		_tokenizer.DecRef(self.handle)
	def __str__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'tokenizer.WordCount{'
		first = True
		for v in pr:
			if callable(v[1]):
				continue
			if first:
				first = False
			else:
				sv += ', '
			sv += v[0] + '=' + str(v[1])
		return sv + '}'
	def __repr__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'tokenizer.WordCount ( '
		for v in pr:
			if not callable(v[1]):
				sv += v[0] + '=' + str(v[1]) + ', '
		return sv + ')'
	@property
	def Pieces(self):
		return go.Slice_string(handle=_tokenizer.tokenizer_WordCount_Pieces_Get(self.handle))
	@Pieces.setter
	def Pieces(self, value):
		if isinstance(value, go.GoClass):
			_tokenizer.tokenizer_WordCount_Pieces_Set(self.handle, value.handle)
		else:
			raise TypeError("supplied argument type {t} is not a go.GoClass".format(t=type(value)))
	@property
	def Count(self):
		return _tokenizer.tokenizer_WordCount_Count_Get(self.handle)
	@Count.setter
	def Count(self, value):
		if isinstance(value, go.GoClass):
			_tokenizer.tokenizer_WordCount_Count_Set(self.handle, value.handle)
		else:
			_tokenizer.tokenizer_WordCount_Count_Set(self.handle, value)


# ---- Slices ---


# ---- Maps ---


# ---- Constructors ---
def New(encoder, bpeMerges):
	"""New(object encoder, [][]str bpeMerges) object, str"""
	return Encoder(handle=_tokenizer.tokenizer_New(encoder.handle, bpeMerges.handle))
def NewFromPrebuilt(name):
	"""NewFromPrebuilt(str name) object, str"""
	return Encoder(handle=_tokenizer.tokenizer_NewFromPrebuilt(name))
def NewFromReaders(encoderReader, vocabReader):
	"""NewFromReaders(object encoderReader, object vocabReader) object, str"""
	return Encoder(handle=_tokenizer.tokenizer_NewFromReaders(encoderReader.handle, vocabReader.handle))


# ---- Functions ---
def CountString(s):
	"""CountString(str s) object"""
	return Map_string_int64(handle=_tokenizer.tokenizer_CountString(s))
def MergeCounts(a, b, goRun=False):
	"""MergeCounts(object a, object b) """
	_tokenizer.tokenizer_MergeCounts(a.handle, b.handle, goRun)
def CountReader(reader):
	"""CountReader(object reader) object, str"""
	return Map_string_int64(handle=_tokenizer.tokenizer_CountReader(reader.handle))


