import json
import urllib

from .models.TestObjectInfo import TestObjectInfo

class TestObjectBase():
    def __init__(self, session, name, category):
        if session is None:
            raise Exception("Session is required")
        if name is None:
            raise Exception("Name is required")
        if category is None:
            raise Exception("Category is required")

        if session.robot is None:
            raise Exception("Robot is undefined for session")

        resources = session.metadata["resources"]
        for resource1 in resources:
            if resource1["name"] == name:
                resource = resource1
                break
            else:
                resource = None
        if resource is None:
            raise Exception("No resource found with name " + name)
        
        testobject = session.robot.getTestObject(resource["id"])
        self.info = TestObjectInfo(testobject)
        if "customProperties" in resource:
            self.customProperties = resource["customProperties"]
        else:
            self.customProperties = {}

        self.session = session
        self.name = name

        self.__isDisposed = False

    def executeCommand(self, commandName, requestObj, errorMessagePrefix):
        return self.session.robot.executeCommand(self.session.testRunId, self.name, commandName, requestObj, errorMessagePrefix)

    def dispose(self):
        self.__isDisposed = True

    def throwIfDisposed(self):
        if self.__isDisposed is True:
            print("Cannot access a disposed object")
            raise Exception("Cannot access a disposed object.")        