# Install
```cmd
pip install textbasic
```

# 개요

이 패키지는 텍스트 데이터에 대한 고품질화 전용 보편적 전처리 기능을 담은 함수들과 유사도 검증 기능을 제공하여 비정형 텍스트 데이터에 대한 빠른 정형화를 통해 효율적인 데이터 제어를 지원합니다.

# Features

## - basic

| 함수명                                                       | 목적                                                       |
| ------------------------------------------------------------ | ---------------------------------------------------------- |
| [word_replace](https://github.com/Kim-YoonHyun/textbasic/blob/master/docs/word_replace.md) | confusion matrix 생성                                      |
| [blank_adjust]((https://github.com/Kim-YoonHyun/textbasic/blob/master/docs/blank_adjust.md)) | 과한(2개 이상) 공백 제거                                   |
| [remove_line](https://github.com/Kim-YoonHyun/textbasic/blob/master/docs/remove_line.md) | 특정 키워드가 포함된 줄 제거                               |
| [remove_re](https://github.com/Kim-YoonHyun/textbasic/blob/master/docs/remove_re.md) | 정규식 기반 텍스트 제거                                    |
| [remove_string](https://github.com/Kim-YoonHyun/textbasic/blob/master/docs/remove_string.md) | 일치여부 기반 텍스트 제거                                  |
| [remove_emoji](https://github.com/Kim-YoonHyun/textbasic/blob/master/docs/remove_.md) | 이모티콘 제거                                              |
| [remove_enter](https://github.com/Kim-YoonHyun/textbasic/blob/master/docs/remove_.md) | 줄바꿈 제거                                                |
| [remove_kor](https://github.com/Kim-YoonHyun/textbasic/blob/master/docs/remove_.md) | 한글 제거                                                  |
| [remove_eng](https://github.com/Kim-YoonHyun/textbasic/blob/master/docs/remove_.md) | 영어 제거                                                  |
| [remove_num](https://github.com/Kim-YoonHyun/textbasic/blob/master/docs/remove_.md) | 숫자 제거                                                  |
| [len_filter](https://github.com/Kim-YoonHyun/textbasic/blob/master/docs/len_filter.md) | 길이 기준 데이터 배제                                      |
| [normal](https://github.com/Kim-YoonHyun/textbasic/blob/master/docs/normal.md) | 오타수정, 공백제거, 특수 정규식 제거, 이모티콘 제거를 적용 |
| [morpheme](https://github.com/Kim-YoonHyun/textbasic/blob/master/docs/morpheme.md) | 형태소 분석                                                |

## - compare

| 함수명                                                       | 목적                              |
| ------------------------------------------------------------ | --------------------------------- |
| [extract_sim](https://github.com/Kim-YoonHyun/textbasic/blob/master/docs/extract_sim.md) | 유사도 검증 및 그룹화             |
| [compare_sim](https://github.com/Kim-YoonHyun/textbasic/blob/master/docs/compare_sim.md) | 두 문장 간의 유사도 퍼센티지 계산 |

# Version

## 2025-11-26 ver 0.2.0

- README.md 
  - 내용 docs화 진행

- basic
  - morpheme 함수의 출력값을 (원본, 형태소 분석 결과) 2개 출력에서 (형태소 분석 결과) 단일 출력으로 변경
  - morpheme 함수 사용시 문장 형태소 구성이 하나 인 경우(예: 안녕하십니까) 정상적 분석이 되지 않는 현상 수정

- compare
  - extract_sim
    - **내부 연산 알고리즘 전체 변경**
    - compare_sim 활용
    - 유사도 그룹 결과의 출력 dataframe 에 기준문장과의 비교 유사도 값을 표시하는 **컬럼 'sim_p' 추가**



## ver 0.1.7
- 유사도 모듈에 두개의 입력 문장에 대한 유사도 퍼센티지 계산 함수인 compare_sim 추가
## ver 0.1.6
- 유사도 검증시 data 를 list 로 넣었을때 비유사도 데이터가 아예 없을 경우 string 컬럼이 없다고 에러가 뜨는 현상 수정
- 완전히 동일한 경우, 문장 유사도 기준값을 100에 가깝게하면 오히려 유사하지 않게 계산되는 현상 수정
- 유사도 결과 저장 컬럼을 group_{p} 로 변경
## ver 0.1.5
- 유사도 검증 extract_sim 함수 수정