import sys
import os
import pandas as pd

sys.path.append('/home/kimyh/library/textbasic')
from textbasic import basic as ba
# from textbasic.compare.similarityanalysis import *


def main():
    from textbasic import compare as com
    print('데이터 불러오기...')
    df = pd.read_csv('./faultcode_whole.csv', encoding='utf-8-sig')
    # df = df[:10]
    data = df.copy()
    explain_list = data['설명'].tolist()
    # print(data)
    # sys.exit()
    # data = df['설명'].tolist()
    # print(data)

    string = '운전석 정면 4단계 전개 컨트롤(하위 결함)'
    sim_p_list = []
    for explain in explain_list:
        sim_p = com.compare_sim(string, explain)
        print(string, explain, sim_p)
        sys.exit()
        sim_p_list.append(sim_p)
    print(sim_p_list[0])
    sys.exit()

def main1():
    from textbasic import basic as ba
    string_list = ['안녕하세요. 제 이름은 홍길동입니다.', '점심으로 한식을 먹고 싣파']
    word_dict = {'하세요':'하십니까', '싣파':'싶다', '한식':'중식'}
    result = ba.word_replace(
        data_list=string_list,
        dictionary=word_dict
    )
    
    for string, res in zip(string_list, result):
        print(f'{string} --> {res}')


def main2():
    from textbasic import basic as ba
    string_list = ['안녕하세요.     제 이름은     홍길동입니다.', '점심으로   한식을 먹고    싶다']
    result = ba.blank_adjust(string_list)
    
    for string, res in zip(string_list, result):
        print(f'{string} --> {res}')


def main3():
    from textbasic import basic as ba
    string_list = [
'''안녕하세요. 제 이름은 홍길동입니다.
점심으로
한식을 먹고 싶다'''
]
    junk_list = ['점심']
    result = ba.remove_line(
        data_list=string_list, 
        junk_list=junk_list
    )
    
    for string, res in zip(string_list, result):
        print(string)
        print('-->')
        print(res)
    

def main4():
    from textbasic import basic as ba
    string_list = ['안녕하세요.^$^!~? 제!%^ 이름은 홍!@%!@%^길동입니다.', '점심###%으로 한식을 먹^&고 싶다']
    re_list = ['[#%^$&~]', ['!?@']]
    result = ba.remove_re(
        data_list=string_list, 
        re_list=re_list
    )
    
    for string, res in zip(string_list, result):
        print(f'{string} --> {res}')


def main5():
    from textbasic import basic as ba
    string_list = ['안녕하세요. 제 이름은 홍길동입니다.', '점심으로 한식을 먹고 싶다']
    remove_list = ['이름', '점심']
    result = ba.remove_string(
        data_list=string_list, 
        remove_list=remove_list
    )
    
    for string, res in zip(string_list, result):
        print(f'{string} --> {res}')

def main6():
    from textbasic import basic as ba
#     string_list = [
#         '안녕하세요🙂. 제 이름은 홍길동 입니다🙆‍♂️.', 
#         '점심으로 한식을 먹고 싶다😋'
#     ]
#     result = ba.remove_emoji(string_list)
#     for string, res in zip(string_list, result):
#         print(f'{string} --> {res}')

#     string_list = [
# '''안녕hello하세요🙂. 
# 제my 이name름은 
# 홍is길honggil동
# dong입니다🙆‍♂️.''', 
# '''점심Iwant으ea로t 
# 한🙋‍♂️식을 
# 먹고korean 싶foo다d😋'''
# ]
#     result = ba.remove_enter(string_list)
#     for string, res in zip(string_list, result):
#         print(f'{string} --> {res}')
    # string_list = [
    #     '안녕hello하세요. 제my 이name름은 홍is길honggil동 dong입니다.', 
    #     '점심Iwant으로 한eat식을 먹고korean 싶foo다d'
    # ]
    # result = ba.remove_kor(string_list)
    # for string, res in zip(string_list, result):
    #     print(f'{string} --> {res}')
    # string_list = [
    #     '안녕hello하세요. 제my 이name름은 홍is길honggil동 dong입니다.', 
    #     '점심Iwant으로 한eat식을 먹고korean 싶foo다d'
    # ]
    # result = ba.remove_eng(string_list)
    # for string, res in zip(string_list, result):
    #     print(f'{string} --> {res}')
    string_list = [
        '전화번호는 000-1234-5678 입니다.' , 
        '지금 시간은 12시 52분 입니다.'
    ]
    result = ba.remove_num(string_list)
    for string, res in zip(string_list, result):
        print(f'{string} --> {res}')

def main7():
    from textbasic import basic as ba
    string_list = [
        '안녕하세요🙂. 제 이름은 홍길동 입니다🙆‍♂️.', 
        '안녕하십니까. 오늘부터 모임에 참여하게 된 신입이라고합니다. 잘부탁드립니다.',
        '점심으로 한식을 먹고 싶다',
        '안녕'
    ]
    result = ba.len_filter(
        data_list=string_list, 
        min_len=5, 
        max_len=20
    )

    for string in string_list:
        print(string)
    print('-->')
    for res in result:
        print(res)


def main8():
    from textbasic import basic as ba
    string_list = ['안녕하세요🙂. 제     이름은 홍길동    입니다🙆‍♂️. 혹시    여기에 아무것도 ㅇ벗나요?']
    result = ba.normal(string_list)
    
    print(string_list[0])
    print('-->')
    print(result[0])


def main9():
    from textbasic import basic as ba
    string_list = [
        '안녕하세요. 제 이름은 홍길동입니다.',
        '오늘 점심은 한식을 먹으러 가자'
    ]
    morph_list = ba.morpheme(string_list)

    for string, morph in zip(string_list, morph_list):
        print(f'{string} --> {morph}')    



def main10():
    from textbasic import compare as com
    string_list = [
        '안녕하세요. 제 이름은 홍길동입니다. 회사에서 과장을 맡고 있습니다. 잘 부탁드립니다.',
        '안녕하세요. 제 이름은 김길동입니다. 회사에서 대리를 맡고 있습니다. 잘 부탁드립니다.',
        '안녕하세요. 제 이름은 박길동입니다. 회사에서 주임연구원 입니다. 잘 부탁드립니다.',
        '오늘 점심은 한식을 먹으러 가자',
        '오늘 점심은 중식을 먹으러 가볼까',
        '커피와 에이드중 어떤것을 마실까',
        '제 취미는 독서와 게임입니다.',
        '제 취미는 독서와 쇼핑입니다.'
    ]
    # rest, sim_df = com.extract_sim(
    #     data=string_list,
    #     p=60
    # )
    # print(rest)
    # print(sim_df)
    # sys.exit()

    string_df = pd.DataFrame({'sentence':string_list})
    rest, sim_df = com.extract_sim(
        data=string_df,
        column='sentence',
        p=60, 
        # preserve=True
    )
    print(rest)
    print(sim_df)
    sys.exit()
    # print(rest)
    # print(sim_df)
    p = com.compare_sim(string_list[3], string_list[4])
    # p = com.compare_sim('안녕하세요', '안녕하십니까')
    # p = com.compare_sim('안녕 안녕 안녕 안녕 안녕 안녕', '안녕')
    print(p)
    

def main11():
    from textbasic import compare as com
    p = com.compare_sim('오늘 점심은 한식을 먹으러 가자', '오늘 점심은 중식을 먹으러 가볼까',)
    print(p)


if __name__ == '__main__':
    main11()