# SPDX-License-Identifier: GPL-3.0-only
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, version 3 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.
#
# Copyright (c) 2024, Firdaus Hakimi <hakimifirdaus944@gmail.com>

import logging
from pathlib import Path
from typing import cast

from telegram import Update
from telegram.ext import Application, CommandHandler, ContextTypes, MessageHandler, filters

import tgbot_python_v2.util.module
from tgbot_python_v2.modules.rm6785 import RM6785_MASTER_USER
from tgbot_python_v2.util.help import Help

log: logging.Logger = logging.getLogger(__name__)
TOKEN: str = Path(".token").read_text()


class ModuleMetadata(tgbot_python_v2.util.module.ModuleMetadata):
    @classmethod
    def setup_module(cls, app: Application):
        app.add_handler(MessageHandler(filters.TEXT, x, block=False), group=10)


async def x(update: Update, context: ContextTypes.DEFAULT_TYPE) -> None:
    if "x.com" not in cast(str, update.message.text):
        return

    new_text: str = update.message.text.replace("/x.com/", "/stupidfaggotlittlecocksuckerx.com/")
    await update.message.reply_text(new_text)
