# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from verizon.api_helper import APIHelper
from verizon.configuration import Server
from verizon.http.api_response import ApiResponse
from verizon.controllers.base_controller import BaseController
from apimatic_core.request_builder import RequestBuilder
from apimatic_core.response_handler import ResponseHandler
from apimatic_core.types.parameter import Parameter
from verizon.http.http_method_enum import HttpMethodEnum
from apimatic_core.authentication.multiple.single_auth import Single
from verizon.models.device_location_subscription import DeviceLocationSubscription
from verizon.exceptions.device_location_result_exception import DeviceLocationResultException


class DevicesLocationSubscriptionsController(BaseController):

    """A Controller to access Endpoints in the verizon API."""
    def __init__(self, config):
        super(DevicesLocationSubscriptionsController, self).__init__(config)

    def get_location_service_subscription_status(self,
                                                 account):
        """Does a GET request to /subscriptions/{account}.

        This subscriptions endpoint retrieves an account's current location
        subscription status.

        Args:
            account (str): Account identifier in "##########-#####".

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Device
                location subscription information.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.DEVICE_LOCATION)
            .path('/subscriptions/{account}')
            .http_method(HttpMethodEnum.GET)
            .template_param(Parameter()
                            .key('account')
                            .value(account)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('oAuth2'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(DeviceLocationSubscription.from_dictionary)
            .is_api_response(True)
            .local_error('400', 'Unexpected error.', DeviceLocationResultException)
        ).execute()

    def get_location_service_usage(self,
                                   body):
        """Does a POST request to /usage.

        This endpoint allows user to search for billable usage for accounts
        based on the provided date range.

        Args:
            body (BillUsageRequest): Request to obtain billable usage for
                accounts.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Billable
                usage report.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.DEVICE_LOCATION)
            .path('/usage')
            .http_method(HttpMethodEnum.POST)
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('*/*'))
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(Single('oAuth2'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .is_api_response(True)
            .local_error('400', 'Unexpected error.', DeviceLocationResultException)
        ).execute()
