# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from verizon.api_helper import APIHelper
from verizon.configuration import Server
from verizon.http.api_response import ApiResponse
from verizon.controllers.base_controller import BaseController
from apimatic_core.request_builder import RequestBuilder
from apimatic_core.response_handler import ResponseHandler
from apimatic_core.types.parameter import Parameter
from verizon.http.http_method_enum import HttpMethodEnum
from apimatic_core.authentication.multiple.single_auth import Single
from verizon.models.response_to_usage_query import ResponseToUsageQuery
from verizon.models.usage_request_response import UsageRequestResponse
from verizon.exceptions.ready_sim_rest_error_response_exception import ReadySimRestErrorResponseException


class PromotionPeriodInformationController(BaseController):

    """A Controller to access Endpoints in the verizon API."""
    def __init__(self, config):
        super(PromotionPeriodInformationController, self).__init__(config)

    def get_promo_device_usage_history(self,
                                       body):
        """Does a POST request to /m2m/v1/devices/usage/actions/promodeviceusage.

        Retrieves the usage history of a device during the promotion period.

        Args:
            body (RequestBodyForUsage): Retrieve Aggregate Usage

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Usage
                History

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.THINGSPACE)
            .path('/m2m/v1/devices/usage/actions/promodeviceusage')
            .http_method(HttpMethodEnum.POST)
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(Single('oAuth2'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(ResponseToUsageQuery.from_dictionary)
            .is_api_response(True)
            .local_error('default', 'All error responses will be in this format', ReadySimRestErrorResponseException)
        ).execute()

    def get_promo_device_aggregate_usage_history(self,
                                                 body):
        """Does a POST request to /m2m/v1/devices/usage/actions/promoaggregateusage.

        Retrieves the aggregate usage for an account using pseudo-MDN during
        the promotional period using a callback.

        Args:
            body (UsageRequestBody): Retrieve Aggregate Usage

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Request
                response

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.THINGSPACE)
            .path('/m2m/v1/devices/usage/actions/promoaggregateusage')
            .http_method(HttpMethodEnum.POST)
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(Single('oAuth2'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(UsageRequestResponse.from_dictionary)
            .is_api_response(True)
            .local_error('default', 'Error response', ReadySimRestErrorResponseException)
        ).execute()
