# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from verizon.api_helper import APIHelper
from verizon.configuration import Server
from verizon.http.api_response import ApiResponse
from verizon.controllers.base_controller import BaseController
from apimatic_core.request_builder import RequestBuilder
from apimatic_core.response_handler import ResponseHandler
from apimatic_core.types.parameter import Parameter
from verizon.http.http_method_enum import HttpMethodEnum
from apimatic_core.authentication.multiple.single_auth import Single
from verizon.models.usage_trigger_response import UsageTriggerResponse
from verizon.models.device_location_success_result import DeviceLocationSuccessResult
from verizon.exceptions.device_location_result_exception import DeviceLocationResultException


class UsageTriggerManagementController(BaseController):

    """A Controller to access Endpoints in the verizon API."""
    def __init__(self, config):
        super(UsageTriggerManagementController, self).__init__(config)

    def create_new_trigger(self,
                           body=None):
        """Does a POST request to /usage/triggers.

        Create a new usage trigger, which will send an alert when the number
        of device location service transactions reaches a specified percentage
        of the monthly subscription amount.

        Args:
            body (UsageTriggerAddRequest, optional): License assignment.

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Usage
                trigger Add result

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SUBSCRIPTION_SERVER)
            .path('/usage/triggers')
            .http_method(HttpMethodEnum.POST)
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(Single('oAuth2'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(UsageTriggerResponse.from_dictionary)
            .is_api_response(True)
            .local_error('400', 'Unexpected error', DeviceLocationResultException)
        ).execute()

    def update_trigger(self,
                       trigger_id,
                       body=None):
        """Does a POST request to /usage/triggers/{triggerId}.

        Update an existing usage trigger

        Args:
            trigger_id (str): Usage trigger ID
            body (UsageTriggerUpdateRequest, optional): New trigger values

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Usage
                trigger Modify result

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SUBSCRIPTION_SERVER)
            .path('/usage/triggers/{triggerId}')
            .http_method(HttpMethodEnum.POST)
            .template_param(Parameter()
                            .key('triggerId')
                            .value(trigger_id)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(Single('oAuth2'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(UsageTriggerResponse.from_dictionary)
            .is_api_response(True)
            .local_error('400', 'Unexpected error', DeviceLocationResultException)
        ).execute()

    def delete_trigger(self,
                       account_name,
                       trigger_id):
        """Does a DELETE request to /usage/accounts/{accountName}/triggers/{triggerId}.

        eletes the specified usage trigger from the given account

        Args:
            account_name (str): Account name
            trigger_id (str): Usage trigger ID

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Delete
                result

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SUBSCRIPTION_SERVER)
            .path('/usage/accounts/{accountName}/triggers/{triggerId}')
            .http_method(HttpMethodEnum.DELETE)
            .template_param(Parameter()
                            .key('accountName')
                            .value(account_name)
                            .should_encode(True))
            .template_param(Parameter()
                            .key('triggerId')
                            .value(trigger_id)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('oAuth2'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(DeviceLocationSuccessResult.from_dictionary)
            .is_api_response(True)
            .local_error('400', 'Unexpected error', DeviceLocationResultException)
        ).execute()
