# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.api_response_code import ApiResponseCode
from verizon.models.device_service_information import DeviceServiceInformation


class BullseyeServiceResult(object):

    """Implementation of the 'BullseyeServiceResult' model.

    Status of Hyper Precise Location on the device.

    Attributes:
        account_number (str): The account the device belongs to.
        device_list (List[DeviceServiceInformation]): List of devices.
        response_type (ApiResponseCode): ResponseCode and/or a message
            indicating success or failure of the request.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "account_number": 'accountNumber',
        "device_list": 'deviceList',
        "response_type": 'responseType'
    }

    _optionals = [
        'account_number',
        'device_list',
        'response_type',
    ]

    def __init__(self,
                 account_number=APIHelper.SKIP,
                 device_list=APIHelper.SKIP,
                 response_type=APIHelper.SKIP):
        """Constructor for the BullseyeServiceResult class"""

        # Initialize members of the class
        if account_number is not APIHelper.SKIP:
            self.account_number = account_number 
        if device_list is not APIHelper.SKIP:
            self.device_list = device_list 
        if response_type is not APIHelper.SKIP:
            self.response_type = response_type 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        account_number = dictionary.get("accountNumber") if dictionary.get("accountNumber") else APIHelper.SKIP
        device_list = None
        if dictionary.get('deviceList') is not None:
            device_list = [DeviceServiceInformation.from_dictionary(x) for x in dictionary.get('deviceList')]
        else:
            device_list = APIHelper.SKIP
        response_type = ApiResponseCode.from_dictionary(dictionary.get('responseType')) if 'responseType' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(account_number,
                   device_list,
                   response_type)
