# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.device_id import DeviceId


class CreateDeviceGroupRequest(object):

    """Implementation of the 'CreateDeviceGroupRequest' model.

    Create request for a new device group and optionally add devices to the
    group.

    Attributes:
        account_name (str): The Verizon billing account that the device group
            will belong to. An account name is usually numeric, and must
            include any leading zeros.
        group_description (str): A description for the device group.
        group_name (str): The name for the new device group. This name must be
            unique within the specified account.
        devices_to_add (List[DeviceId]): Zero or more devices to add to the
            device group. You can use POST /devices/actions/list to get a list
            of all devices in the account.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "account_name": 'accountName',
        "group_description": 'groupDescription',
        "group_name": 'groupName',
        "devices_to_add": 'devicesToAdd'
    }

    _optionals = [
        'devices_to_add',
    ]

    def __init__(self,
                 account_name=None,
                 group_description=None,
                 group_name=None,
                 devices_to_add=APIHelper.SKIP):
        """Constructor for the CreateDeviceGroupRequest class"""

        # Initialize members of the class
        self.account_name = account_name 
        self.group_description = group_description 
        self.group_name = group_name 
        if devices_to_add is not APIHelper.SKIP:
            self.devices_to_add = devices_to_add 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        account_name = dictionary.get("accountName") if dictionary.get("accountName") else None
        group_description = dictionary.get("groupDescription") if dictionary.get("groupDescription") else None
        group_name = dictionary.get("groupName") if dictionary.get("groupName") else None
        devices_to_add = None
        if dictionary.get('devicesToAdd') is not None:
            devices_to_add = [DeviceId.from_dictionary(x) for x in dictionary.get('devicesToAdd')]
        else:
            devices_to_add = APIHelper.SKIP
        # Return an object of this model
        return cls(account_name,
                   group_description,
                   group_name,
                   devices_to_add)
