# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper


class CustomerName(object):

    """Implementation of the 'CustomerName' model.

    The customer name to be used for line usage taxation.

    Attributes:
        title (str): An optional title for the customer, such as “Mr.” or
            “Dr.”
        first_name (str): The customer's first name.
        middle_name (str): The customer's middle name.
        last_name (str): The customer's last name.
        suffix (str): An optional suffix for the customer name, such as “Jr.”
            or “III.”

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "first_name": 'firstName',
        "last_name": 'lastName',
        "title": 'title',
        "middle_name": 'middleName',
        "suffix": 'suffix'
    }

    _optionals = [
        'title',
        'middle_name',
        'suffix',
    ]

    def __init__(self,
                 first_name=None,
                 last_name=None,
                 title=APIHelper.SKIP,
                 middle_name=APIHelper.SKIP,
                 suffix=APIHelper.SKIP):
        """Constructor for the CustomerName class"""

        # Initialize members of the class
        if title is not APIHelper.SKIP:
            self.title = title 
        self.first_name = first_name 
        if middle_name is not APIHelper.SKIP:
            self.middle_name = middle_name 
        self.last_name = last_name 
        if suffix is not APIHelper.SKIP:
            self.suffix = suffix 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        first_name = dictionary.get("firstName") if dictionary.get("firstName") else None
        last_name = dictionary.get("lastName") if dictionary.get("lastName") else None
        title = dictionary.get("title") if dictionary.get("title") else APIHelper.SKIP
        middle_name = dictionary.get("middleName") if dictionary.get("middleName") else APIHelper.SKIP
        suffix = dictionary.get("suffix") if dictionary.get("suffix") else APIHelper.SKIP
        # Return an object of this model
        return cls(first_name,
                   last_name,
                   title,
                   middle_name,
                   suffix)
