# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.deactivate_device_list import DeactivateDeviceList


class DeactivateDeviceProfileRequest(object):

    """Implementation of the 'DeactivateDeviceProfileRequest' model.

    TODO: type model description here.

    Attributes:
        account_name (str): TODO: type description here.
        reason_code (str): TODO: type description here.
        devices (List[DeactivateDeviceList]): TODO: type description here.
        carrier_name (str): TODO: type description here.
        etf_waiver (bool): TODO: type description here.
        check_fallback_profile (bool): TODO: type description here.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "account_name": 'accountName',
        "reason_code": 'reasonCode',
        "devices": 'devices',
        "carrier_name": 'carrierName',
        "etf_waiver": 'etfWaiver',
        "check_fallback_profile": 'checkFallbackProfile'
    }

    _optionals = [
        'devices',
        'carrier_name',
        'etf_waiver',
        'check_fallback_profile',
    ]

    def __init__(self,
                 account_name=None,
                 reason_code=None,
                 devices=APIHelper.SKIP,
                 carrier_name=APIHelper.SKIP,
                 etf_waiver=True,
                 check_fallback_profile=False):
        """Constructor for the DeactivateDeviceProfileRequest class"""

        # Initialize members of the class
        self.account_name = account_name 
        self.reason_code = reason_code 
        if devices is not APIHelper.SKIP:
            self.devices = devices 
        if carrier_name is not APIHelper.SKIP:
            self.carrier_name = carrier_name 
        self.etf_waiver = etf_waiver 
        self.check_fallback_profile = check_fallback_profile 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        account_name = dictionary.get("accountName") if dictionary.get("accountName") else None
        reason_code = dictionary.get("reasonCode") if dictionary.get("reasonCode") else None
        devices = None
        if dictionary.get('devices') is not None:
            devices = [DeactivateDeviceList.from_dictionary(x) for x in dictionary.get('devices')]
        else:
            devices = APIHelper.SKIP
        carrier_name = dictionary.get("carrierName") if dictionary.get("carrierName") else APIHelper.SKIP
        etf_waiver = dictionary.get("etfWaiver") if dictionary.get("etfWaiver") else True
        check_fallback_profile = dictionary.get("checkFallbackProfile") if dictionary.get("checkFallbackProfile") else False
        # Return an object of this model
        return cls(account_name,
                   reason_code,
                   devices,
                   carrier_name,
                   etf_waiver,
                   check_fallback_profile)
