# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.account_device_list import AccountDeviceList


class DeleteDevicesRequest(object):

    """Implementation of the 'DeleteDevicesRequest' model.

    Request to delete a device request.

    Attributes:
        devices_to_delete (List[AccountDeviceList]): A list of up to 100
            devices that you want to delete, specified by device identifier.
            You only need to provide one identifier per device.
        account_name (str): The Verizon billing account that the device group
            belongs to. An account name is usually numeric, and must include
            any leading zeros.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "devices_to_delete": 'devicesToDelete',
        "account_name": 'accountName'
    }

    _optionals = [
        'account_name',
    ]

    def __init__(self,
                 devices_to_delete=None,
                 account_name=APIHelper.SKIP):
        """Constructor for the DeleteDevicesRequest class"""

        # Initialize members of the class
        self.devices_to_delete = devices_to_delete 
        if account_name is not APIHelper.SKIP:
            self.account_name = account_name 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        devices_to_delete = None
        if dictionary.get('devicesToDelete') is not None:
            devices_to_delete = [AccountDeviceList.from_dictionary(x) for x in dictionary.get('devicesToDelete')]
        account_name = dictionary.get("accountName") if dictionary.get("accountName") else APIHelper.SKIP
        # Return an object of this model
        return cls(devices_to_delete,
                   account_name)
