# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.custom_fields import CustomFields


class DeviceGroup(object):

    """Implementation of the 'DeviceGroup' model.

    Returns a list of all device groups in a specified account.

    Attributes:
        description (str): The description of the device group.
        extended_attributes (List[CustomFields]): Any extended attributes for
            the device group, as Key and Value pairs.
        is_default_group (bool): Identifies the default device group.
        name (str): The name of the device group.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "description": 'description',
        "extended_attributes": 'extendedAttributes',
        "is_default_group": 'isDefaultGroup',
        "name": 'name'
    }

    _optionals = [
        'description',
        'extended_attributes',
        'is_default_group',
        'name',
    ]

    def __init__(self,
                 description=APIHelper.SKIP,
                 extended_attributes=APIHelper.SKIP,
                 is_default_group=APIHelper.SKIP,
                 name=APIHelper.SKIP):
        """Constructor for the DeviceGroup class"""

        # Initialize members of the class
        if description is not APIHelper.SKIP:
            self.description = description 
        if extended_attributes is not APIHelper.SKIP:
            self.extended_attributes = extended_attributes 
        if is_default_group is not APIHelper.SKIP:
            self.is_default_group = is_default_group 
        if name is not APIHelper.SKIP:
            self.name = name 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        description = dictionary.get("description") if dictionary.get("description") else APIHelper.SKIP
        extended_attributes = None
        if dictionary.get('extendedAttributes') is not None:
            extended_attributes = [CustomFields.from_dictionary(x) for x in dictionary.get('extendedAttributes')]
        else:
            extended_attributes = APIHelper.SKIP
        is_default_group = dictionary.get("isDefaultGroup") if "isDefaultGroup" in dictionary.keys() else APIHelper.SKIP
        name = dictionary.get("name") if dictionary.get("name") else APIHelper.SKIP
        # Return an object of this model
        return cls(description,
                   extended_attributes,
                   is_default_group,
                   name)
