# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.device_id import DeviceId


class DeviceGroupUpdateRequest(object):

    """Implementation of the 'DeviceGroupUpdateRequest' model.

    Make changes to a device group, including changing the name and
    description, and adding or removing devices.

    Attributes:
        devices_to_add (List[DeviceId]): Zero or more devices to add to the
            device group, specified by device ID. The devices will be removed
            from their current device groups. You can use POST
            /devices/actions/list to get a list of all devices in the
            account.
        devices_to_remove (List[DeviceId]): Zero or more devices to remove
            from the device group, specified by device ID. The devices will be
            added to the default device group.
        new_group_description (str): A new description for the device group.
            Do not include this parameter to leave the group description
            unchanged.
        new_group_name (str): A new name for the device group. Do not include
            this parameter if you want to leave the group name unchanged.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "devices_to_add": 'devicesToAdd',
        "devices_to_remove": 'devicesToRemove',
        "new_group_description": 'newGroupDescription',
        "new_group_name": 'newGroupName'
    }

    _optionals = [
        'devices_to_add',
        'devices_to_remove',
        'new_group_description',
        'new_group_name',
    ]

    def __init__(self,
                 devices_to_add=APIHelper.SKIP,
                 devices_to_remove=APIHelper.SKIP,
                 new_group_description=APIHelper.SKIP,
                 new_group_name=APIHelper.SKIP):
        """Constructor for the DeviceGroupUpdateRequest class"""

        # Initialize members of the class
        if devices_to_add is not APIHelper.SKIP:
            self.devices_to_add = devices_to_add 
        if devices_to_remove is not APIHelper.SKIP:
            self.devices_to_remove = devices_to_remove 
        if new_group_description is not APIHelper.SKIP:
            self.new_group_description = new_group_description 
        if new_group_name is not APIHelper.SKIP:
            self.new_group_name = new_group_name 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        devices_to_add = None
        if dictionary.get('devicesToAdd') is not None:
            devices_to_add = [DeviceId.from_dictionary(x) for x in dictionary.get('devicesToAdd')]
        else:
            devices_to_add = APIHelper.SKIP
        devices_to_remove = None
        if dictionary.get('devicesToRemove') is not None:
            devices_to_remove = [DeviceId.from_dictionary(x) for x in dictionary.get('devicesToRemove')]
        else:
            devices_to_remove = APIHelper.SKIP
        new_group_description = dictionary.get("newGroupDescription") if dictionary.get("newGroupDescription") else APIHelper.SKIP
        new_group_name = dictionary.get("newGroupName") if dictionary.get("newGroupName") else APIHelper.SKIP
        # Return an object of this model
        return cls(devices_to_add,
                   devices_to_remove,
                   new_group_description,
                   new_group_name)
