# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.models.device_id import DeviceId


class DeviceProvisioningHistoryListRequest(object):

    """Implementation of the 'DeviceProvisioningHistoryListRequest' model.

    Request to return the provisioning history of a specified device during a
    specified time period.

    Attributes:
        device_id (DeviceId): An identifier for a single device.
        earliest (str): The earliest date and time for which you want
            provisioning data.
        latest (str): The last date and time for which you want provisioning
            data.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "device_id": 'deviceId',
        "earliest": 'earliest',
        "latest": 'latest'
    }

    def __init__(self,
                 device_id=None,
                 earliest=None,
                 latest=None):
        """Constructor for the DeviceProvisioningHistoryListRequest class"""

        # Initialize members of the class
        self.device_id = device_id 
        self.earliest = earliest 
        self.latest = latest 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        device_id = DeviceId.from_dictionary(dictionary.get('deviceId')) if dictionary.get('deviceId') else None
        earliest = dictionary.get("earliest") if dictionary.get("earliest") else None
        latest = dictionary.get("latest") if dictionary.get("latest") else None
        # Return an object of this model
        return cls(device_id,
                   earliest,
                   latest)
