# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.provisioning_history import ProvisioningHistory


class DeviceProvisioningHistoryListResult(object):

    """Implementation of the 'DeviceProvisioningHistoryListResult' model.

    Response to return the provisioning history of a specified device during a
    specified time period.

    Attributes:
        has_more_data (bool): False for a status 200 response.True for a
            status 202 response, indicating that there is more data to be
            retrieved.
        provisioning_history (List[ProvisioningHistory]): The provisioning
            history of a specified device during a specified time period.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "has_more_data": 'hasMoreData',
        "provisioning_history": 'provisioningHistory'
    }

    _optionals = [
        'has_more_data',
        'provisioning_history',
    ]

    def __init__(self,
                 has_more_data=APIHelper.SKIP,
                 provisioning_history=APIHelper.SKIP):
        """Constructor for the DeviceProvisioningHistoryListResult class"""

        # Initialize members of the class
        if has_more_data is not APIHelper.SKIP:
            self.has_more_data = has_more_data 
        if provisioning_history is not APIHelper.SKIP:
            self.provisioning_history = provisioning_history 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        has_more_data = dictionary.get("hasMoreData") if "hasMoreData" in dictionary.keys() else APIHelper.SKIP
        provisioning_history = None
        if dictionary.get('provisioningHistory') is not None:
            provisioning_history = [ProvisioningHistory.from_dictionary(x) for x in dictionary.get('provisioningHistory')]
        else:
            provisioning_history = APIHelper.SKIP
        # Return an object of this model
        return cls(has_more_data,
                   provisioning_history)
