# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.usage import Usage


class DeviceUsageListResult(object):

    """Implementation of the 'DeviceUsageListResult' model.

    Response to return the daily network data usage of a single device during
    a specified time period.

    Attributes:
        has_more_data (bool): False for a status 200 response.True for a
            status 202 response, indicating that there is more data to be
            retrieved.
        usage_history (List[Usage]): Placeholder.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "has_more_data": 'hasMoreData',
        "usage_history": 'usageHistory'
    }

    _optionals = [
        'has_more_data',
        'usage_history',
    ]

    def __init__(self,
                 has_more_data=APIHelper.SKIP,
                 usage_history=APIHelper.SKIP):
        """Constructor for the DeviceUsageListResult class"""

        # Initialize members of the class
        if has_more_data is not APIHelper.SKIP:
            self.has_more_data = has_more_data 
        if usage_history is not APIHelper.SKIP:
            self.usage_history = usage_history 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        has_more_data = dictionary.get("hasMoreData") if "hasMoreData" in dictionary.keys() else APIHelper.SKIP
        usage_history = None
        if dictionary.get('usageHistory') is not None:
            usage_history = [Usage.from_dictionary(x) for x in dictionary.get('usageHistory')]
        else:
            usage_history = APIHelper.SKIP
        # Return an object of this model
        return cls(has_more_data,
                   usage_history)
