# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.device_id_2 import DeviceId2


class ESIMProvhistoryRequest(object):

    """Implementation of the 'eSIMProvhistoryRequest' model.

    TODO: type model description here.

    Attributes:
        account_name (str): TODO: type description here.
        device_filter (List[DeviceId2]): TODO: type description here.
        earliest (datetime): TODO: type description here.
        latest (datetime): TODO: type description here.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "account_name": 'accountName',
        "device_filter": 'deviceFilter',
        "earliest": 'earliest',
        "latest": 'latest'
    }

    _optionals = [
        'account_name',
        'device_filter',
        'earliest',
        'latest',
    ]

    def __init__(self,
                 account_name=APIHelper.SKIP,
                 device_filter=APIHelper.SKIP,
                 earliest=APIHelper.SKIP,
                 latest=APIHelper.SKIP):
        """Constructor for the ESIMProvhistoryRequest class"""

        # Initialize members of the class
        if account_name is not APIHelper.SKIP:
            self.account_name = account_name 
        if device_filter is not APIHelper.SKIP:
            self.device_filter = device_filter 
        if earliest is not APIHelper.SKIP:
            self.earliest = APIHelper.apply_datetime_converter(earliest, APIHelper.RFC3339DateTime) if earliest else None 
        if latest is not APIHelper.SKIP:
            self.latest = APIHelper.apply_datetime_converter(latest, APIHelper.RFC3339DateTime) if latest else None 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        account_name = dictionary.get("accountName") if dictionary.get("accountName") else APIHelper.SKIP
        device_filter = None
        if dictionary.get('deviceFilter') is not None:
            device_filter = [DeviceId2.from_dictionary(x) for x in dictionary.get('deviceFilter')]
        else:
            device_filter = APIHelper.SKIP
        earliest = APIHelper.RFC3339DateTime.from_value(dictionary.get("earliest")).datetime if dictionary.get("earliest") else APIHelper.SKIP
        latest = APIHelper.RFC3339DateTime.from_value(dictionary.get("latest")).datetime if dictionary.get("latest") else APIHelper.SKIP
        # Return an object of this model
        return cls(account_name,
                   device_filter,
                   earliest,
                   latest)
