# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.v1_device_list_item import V1DeviceListItem


class FirmwareUpgradeChangeResult(object):

    """Implementation of the 'FirmwareUpgradeChangeResult' model.

    Upgrade information.

    Attributes:
        account_name (str): Account identifier in "##########-#####".
        id (str): The unique identifier for this upgrade.
        device_list (List[V1DeviceListItem]): A JSON object for each device
            that was included in the request, showing the device IMEI, the
            status of the addition or removal, and additional information
            about the status.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "account_name": 'accountName',
        "id": 'id',
        "device_list": 'deviceList'
    }

    _optionals = [
        'account_name',
        'id',
        'device_list',
    ]

    def __init__(self,
                 account_name=APIHelper.SKIP,
                 id=APIHelper.SKIP,
                 device_list=APIHelper.SKIP):
        """Constructor for the FirmwareUpgradeChangeResult class"""

        # Initialize members of the class
        if account_name is not APIHelper.SKIP:
            self.account_name = account_name 
        if id is not APIHelper.SKIP:
            self.id = id 
        if device_list is not APIHelper.SKIP:
            self.device_list = device_list 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        account_name = dictionary.get("accountName") if dictionary.get("accountName") else APIHelper.SKIP
        id = dictionary.get("id") if dictionary.get("id") else APIHelper.SKIP
        device_list = None
        if dictionary.get('deviceList') is not None:
            device_list = [V1DeviceListItem.from_dictionary(x) for x in dictionary.get('deviceList')]
        else:
            device_list = APIHelper.SKIP
        # Return an object of this model
        return cls(account_name,
                   id,
                   device_list)
