# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.gio_device_id import GIODeviceId
from verizon.models.kv_pair import KvPair


class GIOSMSSendRequest(object):

    """Implementation of the 'GIOSMSSendRequest' model.

    TODO: type model description here.

    Attributes:
        account_name (str): TODO: type description here.
        custom_fields (List[KvPair]): TODO: type description here.
        data_encoding (str): TODO: type description here.
        group_name (str): TODO: type description here.
        service_plan (str): TODO: type description here.
        time_to_live (str): TODO: type description here.
        device_ids (List[GIODeviceId]): TODO: type description here.
        sms_message (str): TODO: type description here.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "device_ids": 'deviceIds',
        "sms_message": 'smsMessage',
        "account_name": 'accountName',
        "custom_fields": 'customFields',
        "data_encoding": 'dataEncoding',
        "group_name": 'groupName',
        "service_plan": 'servicePlan',
        "time_to_live": 'timeToLive'
    }

    _optionals = [
        'account_name',
        'custom_fields',
        'data_encoding',
        'group_name',
        'service_plan',
        'time_to_live',
    ]

    def __init__(self,
                 device_ids=None,
                 sms_message=None,
                 account_name=APIHelper.SKIP,
                 custom_fields=APIHelper.SKIP,
                 data_encoding=APIHelper.SKIP,
                 group_name=APIHelper.SKIP,
                 service_plan=APIHelper.SKIP,
                 time_to_live=APIHelper.SKIP):
        """Constructor for the GIOSMSSendRequest class"""

        # Initialize members of the class
        if account_name is not APIHelper.SKIP:
            self.account_name = account_name 
        if custom_fields is not APIHelper.SKIP:
            self.custom_fields = custom_fields 
        if data_encoding is not APIHelper.SKIP:
            self.data_encoding = data_encoding 
        if group_name is not APIHelper.SKIP:
            self.group_name = group_name 
        if service_plan is not APIHelper.SKIP:
            self.service_plan = service_plan 
        if time_to_live is not APIHelper.SKIP:
            self.time_to_live = time_to_live 
        self.device_ids = device_ids 
        self.sms_message = sms_message 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        device_ids = None
        if dictionary.get('deviceIds') is not None:
            device_ids = [GIODeviceId.from_dictionary(x) for x in dictionary.get('deviceIds')]
        sms_message = dictionary.get("smsMessage") if dictionary.get("smsMessage") else None
        account_name = dictionary.get("accountName") if dictionary.get("accountName") else APIHelper.SKIP
        custom_fields = None
        if dictionary.get('customFields') is not None:
            custom_fields = [KvPair.from_dictionary(x) for x in dictionary.get('customFields')]
        else:
            custom_fields = APIHelper.SKIP
        data_encoding = dictionary.get("dataEncoding") if dictionary.get("dataEncoding") else APIHelper.SKIP
        group_name = dictionary.get("groupName") if dictionary.get("groupName") else APIHelper.SKIP
        service_plan = dictionary.get("servicePlan") if dictionary.get("servicePlan") else APIHelper.SKIP
        time_to_live = dictionary.get("timeToLive") if dictionary.get("timeToLive") else APIHelper.SKIP
        # Return an object of this model
        return cls(device_ids,
                   sms_message,
                   account_name,
                   custom_fields,
                   data_encoding,
                   group_name,
                   service_plan,
                   time_to_live)
