# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper


class NetworkResourcesType(object):

    """Implementation of the 'NetworkResourcesType' model.

    Network resources of a service profile.

    Attributes:
        min_bandwidth_kbits (int): Minimum required connection bandwidth in
            Kbit/s for the application.
        service_continuity_support (bool): Indicates if service continuity
            support is required or not for the application.
        max_request_rate (int): Maximum request rate that the application can
            handle.
        max_latency_ms (int): Maximum response time or latency that the
            application can handle, in milliseconds. Note: this value must be
            in multiples of 5.
        min_availability (int): Minimum availability required for the server.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "max_latency_ms": 'maxLatencyMs',
        "min_bandwidth_kbits": 'minBandwidthKbits',
        "service_continuity_support": 'serviceContinuitySupport',
        "max_request_rate": 'maxRequestRate',
        "min_availability": 'minAvailability'
    }

    _optionals = [
        'min_bandwidth_kbits',
        'service_continuity_support',
        'max_request_rate',
        'min_availability',
    ]

    def __init__(self,
                 max_latency_ms=None,
                 min_bandwidth_kbits=APIHelper.SKIP,
                 service_continuity_support=APIHelper.SKIP,
                 max_request_rate=APIHelper.SKIP,
                 min_availability=APIHelper.SKIP):
        """Constructor for the NetworkResourcesType class"""

        # Initialize members of the class
        if min_bandwidth_kbits is not APIHelper.SKIP:
            self.min_bandwidth_kbits = min_bandwidth_kbits 
        if service_continuity_support is not APIHelper.SKIP:
            self.service_continuity_support = service_continuity_support 
        if max_request_rate is not APIHelper.SKIP:
            self.max_request_rate = max_request_rate 
        self.max_latency_ms = max_latency_ms 
        if min_availability is not APIHelper.SKIP:
            self.min_availability = min_availability 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        max_latency_ms = dictionary.get("maxLatencyMs") if dictionary.get("maxLatencyMs") else None
        min_bandwidth_kbits = dictionary.get("minBandwidthKbits") if dictionary.get("minBandwidthKbits") else APIHelper.SKIP
        service_continuity_support = dictionary.get("serviceContinuitySupport") if "serviceContinuitySupport" in dictionary.keys() else APIHelper.SKIP
        max_request_rate = dictionary.get("maxRequestRate") if dictionary.get("maxRequestRate") else APIHelper.SKIP
        min_availability = dictionary.get("minAvailability") if dictionary.get("minAvailability") else APIHelper.SKIP
        # Return an object of this model
        return cls(max_latency_ms,
                   min_bandwidth_kbits,
                   service_continuity_support,
                   max_request_rate,
                   min_availability)
